/***************************************************************************
  Copyright (C) 2007 Filip Maric

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------
  This program is inspired by MiniSat solver (C) Een, Sorensson 2003-2006.
  It uses Bliss (C) Tommi Junttila
*****************************************************************************/

#include "BacktrackableStack.h"
#include <sstream>
#include <string>

#include <iostream>

std::string itoa(int i) {
    std::ostringstream s_name;
    s_name << i;
    return s_name.str();
}

std::string toString(int t) {
    return itoa(t);
}

std::string toString(unsigned t) {
    return itoa(t);
}

#include "Literal.h"
std::string toString(Literal l) {
    return Literals::toString(l);
}

std::string toString(std::string t) {
    return t;
}

std::string BacktrackableStack<unsigned short>::toString() const {
    std::string result = "[ ";
    for (unsigned level = 0, j = 0; level < levels.size(); level ++) {
	for (unsigned k = 0; k < levels[level]; k++, j++) {
	    result += ::toString(get(j)) + " ";
	}

	if (level < levels.size() - 1)
	    result += "|\n";
    }
    result += "]";
    return result;
}
