/***************************************************************************
  Copyright (C) 2007 Filip Maric, Predrag Janicic

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------
  This program is inspired by MiniSat solver (C) Een, Sorensson 2003-2006.
  It uses Bliss (C) Tommi Junttila
*****************************************************************************/

#include "Clause.h"

bool Clause::isTrue() const {
    const_iterator i, b = begin(), e = end();
    for (i = b; i != e; i++)
	if (Literals::isTrue(*i))
	    return true;
    return false;
}

bool Clause::isFalse() const {
    const_iterator i, b = begin(), e = end();
    for (i = b; i != e; i++)
	if (!Literals::isFalse(*i))
	    return false;
    return true;
}

bool Clause::isTrue(const std::vector<Literal>& model) {
    const_iterator i, b = begin(), e = end();
    for (i = b; i != e; i++)
	if (std::find(model.begin(), model.end(), *i) != model.end())
	    return true;
    return false;
}


bool Clause::isUnit() const {
    return getUnitLiteral() != 0;
}

const Literal* Clause::getUnitLiteral() const {
    const Literal* unassignedLiteral = 0;
    const_iterator i, b = begin(), e = end();
    for (i = b; i != e; i++) {
//	std::cout << "CHK: " << Literals::toString(*i) << std::endl;
	if (!Literals::isAssigned(*i) && unassignedLiteral == 0) {
	    // First unassigned literal
	    unassignedLiteral = &(*i);
//	    std::cout << "UN: " << Literals::toString(*i) << std::endl;
	} else if (!Literals::isAssigned(*i) && unassignedLiteral != 0) {
//	    std::cout << "UN: " << Literals::toString(*i) << std::endl;
	    // Second unassigned literal
	    return 0;
	}
    }

    return unassignedLiteral;
}

std::string Clause::toString() const {
    std::string result = "";
    const_iterator i, b = begin(), e = end();
    for (i = b; i != e; i++)
	result += Literals::toString(*i) + " ";
    return result;
}


std::string Clause::valuationString() const {
    std::string result;
    const_iterator i, b = begin(), e = end();
    for (i = b; i != e; i++) {
	if (Literals::isTrue(*i))
	    result += "T";
	else if (Literals::isFalse(*i))
	    result += "F";
	else 
	    result += "?";
    }
    return result;
}

Clause* Clause::getOpposite() const {
    std::vector<Literal> literals;
    const_iterator i, b = begin(), e = end();
    for (i = b; i != e; i++)
	literals.push_back(Literals::getOpposite(*i));
    return new Clause(literals);
}

void Clause::canonicalForm() {
    std::sort(_literals.begin(), _literals.end());
}
