#include "Literal.h"
#include "expressions/Expression.h"

void Literals::setTrue(Literal literal, size_t decisionLevel) {
    _expressions[literal].setAssigned(true);
    if (!isTrue(literal)) {
	Variables::setValue(getVariable(literal), isPositive(literal) ? TRUE : FALSE, decisionLevel);
	setFalse(getOpposite(literal), decisionLevel);
    }
}

void Literals::setFalse(Literal literal, size_t decisionLevel) {
    _expressions[literal].setAssigned(true);
    if (!isFalse(literal)) {
	Variables::setValue(getVariable(literal), isPositive(literal) ? FALSE : TRUE, decisionLevel);
	setTrue(getOpposite(literal), decisionLevel);
    }
}

void Literals::setUnassigned(Literal literal) {
	_expressions[literal].setAssigned(false);
	_expressions[getOpposite(literal)].setAssigned(false);
	Variables::setValue(getVariable(literal), UNDEF, 0);
}

void Literals::newVariable() {
    _expressions.push_back(Expression());
    _expressions.push_back(Expression());
}

void Literals::setExpression(Literal l, Expression& e) {
	_expressions[l] = e;
	e.setLiteral(l);
}

Expression Literals::getExpression(Literal l) {
    return _expressions[l];
}

Literal Literals::getLiteral(const Expression& e) {
    return e.getLiteral();
}

void Literals::printExpressions() {
    for (Variable i = 0; i < 2*Variables::size(); i++) {
	coutput << toString(i) << " : " << _expressions[i] << endl;
    }
}

std::vector<Expression> Literals::_expressions;

