/***************************************************************************
  Copyright (C) 2007 Filip Maric, Predrag Janicic

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------
  This program is inspired by MiniSat solver (C) Een, Sorensson 2003-2006.
  It uses Bliss (C) Tommi Junttila
*****************************************************************************/

#ifndef __LITERAL_H__
#define __LITERAL_H__

#include "Variable.h"
#include <vector>
#include <map>

typedef unsigned short Literal;

class Expression;
class Clause;

class Literals {
 public:
    static void setTrue(Literal literal, size_t decisionLevel);
    static void setFalse(Literal literal, size_t decisionLevel);
    static void setUnassigned(Literal literal);

    static bool isTrue(Literal literal) {
	return Variables::getValue(getVariable(literal)) == (isNegative(literal) ? FALSE : TRUE);
    }    

    static bool isFalse(Literal literal) {
	return Variables::getValue(getVariable(literal)) == (isNegative(literal) ? TRUE : FALSE);
    }

    static bool isAssigned(Literal literal) {
	return Variables::getValue(getVariable(literal)) != UNDEF;
    }

    static size_t getDecisionLevel(Literal literal) {
	return Variables::getDecisionLevel(getVariable(literal));
    }

    static Literal getOpposite(Literal literal) {
	if (isPositive(literal))
	    return literal + 1;
	else
	    return literal - 1;
    }

    static bool isPositive(Literal literal) {
	return !(literal & 1);
    }

    static bool isNegative(Literal literal) {
	return literal & 1;
    }

    static Literal getVariable(Literal literal) {
	return literal >> 1;
    }

    static Literal getLiteral(Variable variable, bool positive) {
		return positive ? (variable << 1) : ((variable << 1) + 1);
    }

    static std::string toString(Literal literal) {
	std::string result = isPositive(literal) ? "" : "-";
	result += Variables::toString(getVariable(literal));
	return result;
    }

    static Literal fromInt(int num) {
	return num < 0 ? Literals::getLiteral(-num-1, false) : Literals::getLiteral(num-1, true);
    }

    static void printExpressions();

    static void newVariable();
    static void setExpression(Literal l, Expression& e);
    static Expression getExpression(Literal l);
    static Literal getLiteral(const Expression& e);

    static std::vector<Expression> _expressions;
};
#endif
