#include "ResolutionClause.h"
#include "Solver.h"
#include <algorithm>

std::vector<bool> ResolutionClause::_containsVariableCache;

// inline void
// fill(bool* __first, bool* __last, const bool& __c) {
//    bool __tmp = __c;
//    memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
//}

ResolutionClause::ResolutionClause(Solver* solver) {
    resolutionLiteral = 0;
    clause = 0;
    this->solver = solver;
    numCurrentLevelLiterals = 0;

    if (Variables::size() > _containsVariableCache.size()) {
	_containsVariableCache.resize(Variables::size());
    }

    _containsVariableCache.assign(Variables::size(), false);
    // fill(_containsVariableCache.begin(), _containsVariableCache.end(), false);
}

void ResolutionClause::removeResolutionLiteral() {
    assert(getDecisionLevel(resolutionLiteral) == getCurrentDecisionLevel());
    removeLiteral(resolutionLiteral);
    resolutionLiteral = 0;
}


size_t ResolutionClause::getDecisionLevel(Literal literal) const {
    return Literals::getDecisionLevel(literal);
}

size_t ResolutionClause::getCurrentDecisionLevel() const {
    return solver->getCurrentDecisionLevel();
}
