#ifndef __SOLVER_STATISTICS_H__
#define __SOLVER_STATISTICS_H__
#include <cstdio>

class SolverStatistics {
 private:
    static int numberOfDecisions;
    static int numberOfInitialClauses;
    static int numberOfLearntClauses;
    static int numberOfConflicts;
    static int numberOfRestarts;
    static int numberOfPropagations;
	
 public:
    static void newDecision() {
	numberOfDecisions++;
    }
	
    static void newConflict() {
	numberOfConflicts++;
    }

    static void newRestart() {
	numberOfRestarts++;
    }

    static void newPropagation() {
	numberOfPropagations++;
    }
	
    static void newInitialClause() {
	numberOfInitialClauses++;
    }

    static void newLearntClause() {
	numberOfLearntClauses++;
    }

    static void removeLearntClause() {
	numberOfLearntClauses--;
    }

    static void removeInitialClause() {
	numberOfInitialClauses--;
    }

    static void printHeader() {
	printf("\n------------------------------------------------------------------------------\n");
	printf("| Decisions | Initial+Learnt Clauses | Conflicts | Propagations | Restarts    \n");
	printf("------------------------------------------------------------------------------\n");
		
    }

    static void printFooter() {
	printf("------------------------------------------------------------------------------\n");
    }
	
    static void printStatistics() {
	printf("| %9d |  %8d + %9d  | %9d |  %10d  | %10d |\n", 
	       numberOfDecisions, numberOfInitialClauses, numberOfLearntClauses, 
	       numberOfConflicts, numberOfPropagations, numberOfRestarts);
    }

};


#endif
