/***************************************************************************
  Copyright (C) 2007 Filip Maric, Predrag Janicic

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------
  This program is inspired by MiniSat solver (C) Een, Sorensson 2003-2006.
  It uses Bliss (C) Tommi Junttila
*****************************************************************************/

#include "Variable.h"
#include "Literal.h"

std::vector<ExtendedBoolean> Variables::_values;
std::vector<size_t> Variables::_decisionLevels;
std::vector<double> Variables::_activity;
std::vector<bool>   Variables::_useAsDecisionVariable;

Variable Variables::newVariable(bool useAsDecisionVariable) {
    Variable variable = size();

    _values.push_back(UNDEF);
    _decisionLevels.push_back(0);
    _activity.push_back(0.0);
    _useAsDecisionVariable.push_back(useAsDecisionVariable);
    Literals::newVariable();

    return variable;
}
