/***************************************************************************
  Copyright (C) 2007 Filip Maric, Predrag Janicic

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------
  This program is inspired by MiniSat solver (C) Een, Sorensson 2003-2006.
  It uses Bliss (C) Tommi Junttila
*****************************************************************************/

#ifndef __VARIABLE_H__
#define __VARIABLE_H__

#include "ExtendedBoolean.h"
#include <vector>
#include <sstream>
#include <iostream>

typedef unsigned short Variable;

class Variables {
 public:
    static void setNumberOfVariables(size_t n) {
	for (size_t i = 0; i < n; i++)
	    newVariable();
    }

    static Variable newVariable(bool useAsDecisionVariable = true);

    static ExtendedBoolean getValue(Variable variable) {
	return _values[variable];
    }

    static size_t getDecisionLevel(Variable variable) {
	return _decisionLevels[variable];
    }

    static void setValue(Variable variable, ExtendedBoolean value, size_t decisionLevel) {
	_values[variable] = value;
	_decisionLevels[variable] = decisionLevel;
    }

    static std::string toString(Variable variable) {	
	std::ostringstream stream;
	stream << variable;
	return stream.str();
    }

    static size_t size() {
	return _values.size();
    }

    static double& getActivity(Variable variable) {
	return _activity[variable];
    }

    static bool useAsDecisionVariable(Variable variable) {
	return _useAsDecisionVariable[variable];
    }

 private:
    static std::vector<ExtendedBoolean> _values;
    static std::vector<size_t> _decisionLevels;
    static std::vector<double> _activity;
    static std::vector<bool>   _useAsDecisionVariable;

};
#endif
