#ifndef __DUMMY_THEORY_H__
#define __DUMMY_THEORY_H__

#include "theory/Theory.h"
#include "expressions/Expression.h"
#include <iostream>
#include <vector>
using namespace std;

class DummyTheory : public Theory {
 public:
    DummyTheory() {
	registerTheory(this);
    }

    virtual ~DummyTheory() {}

    virtual void addExpression(Expression e) {
	coutput << "Add expression: " << e << endl;
    }

    virtual void newDecision() {
	coutput << "New decision" << endl;
    }

    virtual void assertExpression(Expression e) {
	coutput << "Assert: " << e << endl;
	_trail.push_back(e);
    }

    virtual void backtrack(int n) {
	coutput << "Backtrack" << endl;
	_trail.erase(_trail.end() - n);
    }

    virtual bool isTrue(Expression e) {
	return false;
    }

    virtual bool isFalse(Expression e) {
	return false;
    }

    virtual Expression cannonize(Expression e) {
	return e;
    }

    virtual Expression negate(Expression e) {
	return Expression::NOT(e);
    }

    virtual void explain(std::vector<Expression>& explanation) {
	std::vector<Expression>::const_iterator it;
	for (it = _trail.begin(); it != _trail.end(); it++)
	    explanation.push_back(opposite(*it));
    }

    virtual bool isUnsat() {
	return _trail.size() == 3;
    }

 private:
    std::vector<Expression> _trail;

};

#endif
