#include "Signature.h"
void Signature::AddSymbol(const std::string& name, SORT sort_1)
{
     _symbols.insert(name);

     std::vector<SORT> sorts;
     sorts.push_back(sort_1);
     SortRegistry::Instance()->Register(name,sorts);
}

void Signature::AddSymbol(const std::string& name, SORT sort_1, SORT  sort_2)
{
     _symbols.insert(name);

     std::vector<SORT> sorts;
     sorts.push_back(sort_1);	  
     sorts.push_back(sort_2);
     SortRegistry::Instance()->Register(name,sorts);
}


void Signature::AddSymbol(const std::string& name, SORT sort_1, SORT sort_2, SORT sort_3)
{
     _symbols.insert(name);

     std::vector<SORT> sorts;
     sorts.push_back(sort_1);	  
     sorts.push_back(sort_2);
     sorts.push_back(sort_3);

     SortRegistry::Instance()->Register(name,sorts);
}

	       
void Signature::AddSymbol(const std::string& name, SORT sort_1, SORT sort_2, SORT sort_3, SORT sort_4)
{
     _symbols.insert(name);

     std::vector<SORT> sorts;
     sorts.push_back(sort_1);	  
     sorts.push_back(sort_2);
     sorts.push_back(sort_3);
     sorts.push_back(sort_4);
     SortRegistry::Instance()->Register(name,sorts);
}

bool Signature::ContainsLeadingSymbol(const Expression& e) const 
{
     if (e.IsEquality() || e.IsDisequality() || e.IsVariable())
	  return true;

     if (_symbols.find(e.GetName()) == _symbols.end())
	  return false;

     const std::vector<SORT>&  v = SortRegistry::Instance()->GetSortVector(e.GetName());
     if (v.size()-1 != e.GetArity())
	  return false;
     /*
       unsigned s, arity = e.GetArity();
       for (s = 0; s < arity; s++)
       if (v[s] != e[s].GetSort())
       return false;
     */
     
     return true;
}

bool Signature::ContainsExpression(const Expression& e) const
{
     Expression::subexpressions_iterator i, iend = e.subexpressions_end();
     for (i = e.subexpressions_begin(); i != iend; ++i)
	  if (!ContainsLeadingSymbol(*i))
	       return false;
     return true;
}


