#ifndef __SIGNATURE_H__
#define __SIGNATURE_H__

#include <set>
#include <string>
#include "expressions/Sorts.h"
#include "expressions/Expression.h"

#define EQ      "="
#define DISEQ   "!="

class Signature
{
private:
     std::set<std::string> _symbols;

public:
     Signature()
     {}

     virtual ~Signature()
     {}

     void AddSymbol(const std::string& name, SORT sort_1);
     void AddSymbol(const std::string& name, SORT sort_1, SORT sort_2);
     void AddSymbol(const std::string& name, SORT sort_1, SORT sort_2, SORT sort_3);
     void AddSymbol(const std::string& name, SORT sort_1, SORT sort_2, SORT sort_3, SORT sort_4);
     void AddSymbol(const std::string& name, const std::vector<SORT>& sorts)     ;
     
     virtual bool ContainsLeadingSymbol(const Expression& e) const;
     virtual bool ContainsExpression(const Expression& e) const;
};

#endif

