#ifndef __THEORY_H__
#define __THEORY_H__

#include<vector>
#include "expressions/Expression.h"

class Theory {
 public:
    virtual ~Theory() {}

    virtual void init() = 0;
    virtual void addExpression(Expression e) = 0;
    virtual void newDecision() = 0;
    virtual void backtrackDecision() = 0;
    virtual void assertExpression(Expression e) = 0;
    virtual void backtrack() = 0;
    virtual void commitBacktrack() = 0;
    virtual void explain(std::vector<Expression>& explanation) = 0;
    virtual bool theoryPropagate(std::vector<Expression>& explanation) = 0;
    virtual void forceCheck(bool strong) = 0;
    virtual bool isUnsat() = 0;

    virtual bool generateModel() = 0;
    virtual bool checkAgainstModel(Expression e) = 0;

    virtual Expression cannonize(Expression e) = 0;
    virtual Expression negate(Expression e) = 0;
    virtual bool isTrue(Expression e) = 0;
    virtual bool isFalse(Expression e) = 0;

    static Theory* getInstance() {
	return _instance;
    }


 protected:
    static void registerTheory(Theory* instance) {
	_instance = instance;
    }

 private:
    static Theory* _instance;
    
};
#endif
