#include "PRAPolyform.h"

Expression PRAPolyform::Cannonize(const Expression& e)
{
//    coutput << "PPC: " << e << endl;
    if (IsCannonizedPRAPolyform(e, false)) {
	return e;
    } else {
	std::vector<Expression> pfv;
	pfv.push_back(Expression::RationalNumeral(RATIONAL(0)));
	AddTerm(e, pfv);

	return Expression::Function("+", pfv);
    }
}

bool PRAPolyform::IsCannonizedPRAPolyform(const Expression& e, bool homogenous) {
    if (!IsPRAPolyform(e, homogenous))
	return false;
     Expression::operands_iterator i, i_end= e.end() - 1;
     for (i = e.begin() + (homogenous ? 0 : 1); i < i_end; i++) {
	 if (VariableCompare((*i)[1].GetName(), (*(i+1))[1].GetName()) < 0) {
	     return false;
	 }
     }
     return true;
}

bool PRAPolyform::IsPRAPolyform(const Expression& e, bool homogenous)
{
    if (!e.IsFunction() || e.GetName()!="+")
	return false;
		
    if (!homogenous && !e[0].IsNumeral())
	return false;

    Expression::operands_iterator i, i_end= e.end();
    for (i = e.begin() + (homogenous ? 0 : 1); i!=i_end; i++)
    {	
	if (!i->IsFunction() || i->GetName() !="*")
	    return false;
	if (!(*i)[0].IsNumeral())
	    return false;
	if (!(*i)[1].IsVariable() && !(*i)[1].IsConstant())
	    return false;
    }
    return true;
}


void PRAPolyform::AddConstant(const RATIONAL& coefficient, std::vector<Expression>& pfv) {
    if (coefficient == 0)
	return;

    pfv[0] = Expression::RationalNumeral(coefficient + pfv[0].GetValueRational());
}


void PRAPolyform::AddVariable(const RATIONAL& coefficient, const Expression& variable, std::vector<Expression>& pfv) {
    if (coefficient == 0)
	return;

    std::vector<Expression>::iterator i, iend = pfv.end();
    for (i = pfv.begin()+1; i!=iend; i++) {
	int cmp = VariableCompare(variable.GetName(), (*i)[1].GetName());
	if (cmp > 0)
	    break;
	if (cmp == 0) {
	    RATIONAL const_val = coefficient + (*i)[0].GetValueRational();
	    if (const_val == 0)
		pfv.erase(i);
	    else
		(*i) = CoefficientMultVariable(const_val, variable);
	    return;
	}
    }

    pfv.insert(i, CoefficientMultVariable(coefficient,variable));
}

bool PRAPolyform::isNumeric(const Expression& e, RATIONAL& value) {
    if (e.IsNumeral()) {
	value = e.GetValueRational();
	return true;
    }
    if (e.IsFunction()) {
	if (e.GetName() == "~") {
	    if (!isNumeric(e[0], value))
		return false;
	    value = -value;
	    return true;
	}
	if (e.GetName() == "/") {
	    RATIONAL l, r;
	    if (!isNumeric(e[0], l))
		return false;
	    if (!isNumeric(e[1], r))
		return false;	
	    value = l/r;
	    return true;
	}
	if (e.GetName() == "*") {
	    RATIONAL l, r;
	    if (!isNumeric(e[0], l))
		return false;
	    if (!isNumeric(e[1], r))
		return false;
	    value = l*r;
	    return true;
	}
	if (e.GetName() == "+") {
	    RATIONAL l, r;
	    if (!isNumeric(e[0], l))
		return false;
	    if (!isNumeric(e[1], r))
		return false;
	    value = l+r;
	    return true;
	}
	if (e.GetName() == "-") {
	    RATIONAL l, r;
	    if (!isNumeric(e[0], l))
		return false;
	    if (!isNumeric(e[1], r))
		return false;
	    value = l-r;
	    return true;
	}
    }
    return false;
}

void PRAPolyform::AddTerm(const Expression& e, std::vector<Expression>& pfv)
{
//    coutput << "Add term: " << e << endl;
    if (e.IsFunction()) {
	if (e.GetName()=="+") {
	    Expression::operands_iterator i, iend = e.end();
	    for (i =  e.begin(); i != iend; i++)
		AddTerm(*i, pfv);
	} else if (e.GetName()=="-") {
	    Expression tmp = Expression::Function("+", e[0], Expression::Function("*", e[1], Expression::Numeral(-1)));
	    AddTerm(tmp, pfv);
	} else if (e.GetName()=="~") {
	    AddTerm(Expression::Function("*", e[0], Expression::Numeral(-1)), pfv);
	} else if (e.GetName() == "/") {
	    if (e[0].IsNumeral() && e[1].IsNumeral()) {
		RATIONAL const_val(e[0].GetValue(), e[1].GetValue());
		const_val.canonicalize();
		AddConstant(const_val, pfv);
	    } else
		throw "Not LRA expression";
	} else if (e.GetName()=="*") {
	    RATIONAL l, r;
	    if (isNumeric(e[0], l) && isNumeric(e[1], r)) {
		AddConstant(l*r, pfv);
	    }
	    else if ((e[0].IsVariable() || e[0].IsConstant()) && isNumeric(e[1], r))
		AddVariable(r, e[0], pfv);
	    else if (isNumeric(e[0], l) && (e[1].IsVariable() || e[1].IsConstant()))
		AddVariable(l,e[1], pfv);
	    else if (isNumeric(e[0], l))
		AddTerm(Times(Cannonize(e[1]), l), pfv);
	    else if (isNumeric(e[1], r))
		AddTerm(Times(Cannonize(e[0]), r), pfv);
	    else
		throw "Not LRA expression";
	}
    } else if (e.IsNumeral())
	AddConstant(e.GetValueRational(), pfv);
    else if (e.IsVariable() || e.IsConstant())
	AddVariable(RATIONAL(1), e, pfv);
    else
	throw "Not LA expression";
}


Expression PRAPolyform::Times(const Expression& pf, const RATIONAL& coefficient)
{
//    coutput << "Times: " << pf << " * " << coefficient << endl;
    assert(IsPRAPolyform(pf));

    if (coefficient == 1)
	return pf;


    std::vector<Expression> pfv;
    pfv.push_back(Expression::RationalNumeral(RATIONAL(0)));

    AddConstant(pf[0].GetValueRational()*coefficient, pfv);
    Expression::operands_iterator i;
    for (i = pf.begin()+1; i!=pf.end(); i++)
	AddVariable((*i)[0].GetValueRational()*coefficient, (*i)[1], pfv);
    return Expression::Function("+", pfv);

}

Expression PRAPolyform::Divide(const Expression& pf, const RATIONAL& coefficient) {
//    coutput << "Div: " << pf << " / " << coefficient << endl;
    return Times(pf, 1/coefficient);
}

Expression PRAPolyform::Plus(const Expression& pf_1, const Expression& pf_2)
{
     assert(IsPRAPolyform(pf_1) && IsPRAPolyform(pf_2));
     return Cannonize(Expression::Function("+", pf_1, pf_2));

}
     
Expression PRAPolyform::Minus(const Expression& pf_1, const Expression& pf_2) {
    assert(IsPRAPolyform(pf_1) && IsPRAPolyform(pf_2));
    return Cannonize(Expression::Function("+", pf_1, Times(pf_2, RATIONAL(-1))));
}


Expression PRAPolyform::Simplify(const Expression& pf)
{
     if (IsGround(pf))
	  return pf;

     std::vector<Expression> pfv;
     
     // 0 + x -> x
     if (pf[0].GetValue() != 0)
	  pfv.push_back(pf[0]);

     // 1 * x -> x
     Expression::operands_iterator i;
     for (i = pf.begin() + 1; i!=pf.end(); i++)
	  pfv.push_back((*i)[0].GetValueRational()==1 ? (*i)[1] : (*i));

     
     return Expression::Function("+", pfv);
}

bool PRAPolyform::IsGround(const Expression& pf)
{
     if (pf.IsNumeral())
	  return true;

     if (!IsPRAPolyform(pf, false))
	 return false;

     assert(IsPRAPolyform(pf));
     return pf.GetArity() == 1;
}
