#ifndef __PRA_SIGNATURE_H__
#define __PRA_SIGNATURE_H__

#include "theory/Signature.h"

#define LEQ     "<="
#define LT      "<"
#define GEQ     ">="
#define GT      ">"

class PRASignature : public Signature
{
public:
     PRASignature()
     {
	  AddSymbol(LT, INT_SORT, INT_SORT, LOGICAL_SORT);
	  AddSymbol(LEQ, INT_SORT, INT_SORT, LOGICAL_SORT);
	  AddSymbol(GT, INT_SORT, INT_SORT, LOGICAL_SORT);
	  AddSymbol(GEQ, INT_SORT, INT_SORT, LOGICAL_SORT);
	  AddSymbol("+", INT_SORT, INT_SORT, INT_SORT);
     }

     virtual bool ContainsLeadingSymbol(const Expression& e) const
     {
	  // All numerals Are regular LA expressions
	  if (e.IsNumeral())
	       return true;

	  //Numeral * expr and expr * Numeral are regular LA expressions
	  if (e.IsFunction() && e.GetName()=="*")
	       return e.GetArity()==2 &&
		    (e[0].IsNumeral() || e[1].IsNumeral());

	  //Allow n-ary +
	  if (e.IsFunction() && e.GetName()=="+")
	       return true;

	  //Standard check
	  return Signature::ContainsLeadingSymbol(e);
     }


     /* Finds opposite LA predicate symbol i.e. 
	the simbol read from right to left */
     static std::string OppositePredicate(const std::string& pred)
     {
	  if (pred == LEQ)
	       return GEQ;
	  if (pred == LT)
	       return GT;
	  if (pred == GEQ)
	       return LEQ;
	  if (pred == GT)
	       return LT;
	  if (pred == EQ)
	       return EQ;
	  if (pred == DISEQ)
	       return DISEQ;

	  return "error";
     }

     /* Negated predicate symbol */
     static std::string NegatedPredicate(const std::string& pred)
     {
	  if (pred == LEQ)
	       return GT;
	  if (pred == LT)
	       return GEQ;
	  if (pred == GEQ)
	       return LT;
	  if (pred == GT)
	       return LEQ;
	  if (pred == EQ)
	       return DISEQ;
	  if (pred == DISEQ)
	       return EQ;

	  return "error";
     }


     static void GetResolvingPredicates(std::string rel, std::vector<std::string>& resolving)
     {
	  if (ResolvingPredicate(rel, EQ) != "error")
	       resolving.push_back(EQ);
	  if (ResolvingPredicate(rel, DISEQ) != "error")
	       resolving.push_back(DISEQ);
	  if (ResolvingPredicate(rel, LT) != "error")
	       resolving.push_back(LT);
	  if (ResolvingPredicate(rel, GT) != "error")
	       resolving.push_back(GT);
	  if (ResolvingPredicate(rel, LEQ) != "error")
	       resolving.push_back(LEQ);
	  if (ResolvingPredicate(rel, GEQ) != "error")
	       resolving.push_back(GEQ);
     }  


     static bool AreResolvingPredicates(std::string rel_1, std::string rel_2)
     {
	  std::vector<std::string> opposites;
	  GetResolvingPredicates(rel_1, opposites);
	  for (unsigned k = 0; k < opposites.size(); k++)
	       if (rel_2 == opposites[k])
		    return true;
	  return false;
     }

     static std::string ResolvingPredicate(std::string p1, std::string p2)
     {

	  static std::string preds[] = {EQ, DISEQ, LT, GT, LEQ, GEQ};
	  static int table[][6] = {{0,  1,  2,  3,  4,  5},
				   {1, -1, -1, -1, -1, -1},
				   {2, -1,  2, -1,  2, -1},
				   {3, -1, -1,  3, -1,  3},
				   {4, -1,  2  -1,  4, -1},
				   {5, -1, -1,  3, -1,  5}};
	  int type_1 = 0, type_2 = 0;
	  for (int i = 0; i<6; i++)
	  {
	       if (preds[i]==p1)
		    type_1 = i;
	       if (preds[i]==p2)
		    type_2 = i;
	  }

	  int type = table[type_1][type_2];
	  return type != -1 ? preds[type] : "error";
     }


     static void test()
     {
	  PRASignature pra_signature;
	  Expression e;
	  if (!Expression::Read("(< (+ ?x 2) (* 3 ?x))", e))
	       return;
	  
	  coutput<<e<<endl;

	  if (pra_signature.ContainsExpression(e))
	       coutput<<"TRUE"<<endl;

     }
};

#endif
