#ifndef __QDELTA__
#define __QDELTA__

#include "expressions/Expression.h"
#include <iostream>

class QDelta {
 public:
    QDelta(RATIONAL a = RATIONAL(0), RATIONAL b = RATIONAL(0)) 
	: _a(a), _b(b) {
    }


    void reset() {
	_a = 0; _b = 0;
    }

    QDelta operator+(const QDelta& qd) const {
	return QDelta(_a + qd._a, _b + qd._b);
    }

    void operator+=(const QDelta& qd) {
	_a += qd._a;
	_b += qd._b;
    }

    void operator-=(const QDelta& qd) {
	_a -= qd._a;
	_b -= qd._b;
    }

    QDelta operator-(const QDelta& qd) const {
	return QDelta(_a - qd._a, _b - qd._b);
    }

    QDelta operator*(const RATIONAL& r) const {
	return QDelta(_a*r, _b*r);
    }

    bool operator<(const QDelta& qd) const {
	return _a < qd._a || (_a == qd._a && _b < qd._b);
    }

    bool operator<=(const QDelta& qd) const {
	return _a < qd._a || (_a == qd._a && _b <= qd._b);
    }

    bool operator>=(const QDelta& qd) const {
	return _a > qd._a || (_a == qd._a && _b >= qd._b);
    }

    bool operator>(const QDelta& qd) const {
	return _a > qd._a || (_a == qd._a && _b > qd._b);
    }

    bool operator==(const QDelta& qd) const {
	return _a == qd._a && _b == qd._b;
    }

    bool operator!=(const QDelta& qd) const {
	return !((*this) == qd);
    }

    bool operator==(const RATIONAL& r) const {
	return _a == r && _b == 0;
    }

    bool operator==(int r) const {
	return _a == r && _b == 0;
    }

    void print(std::ostream& ostr) const {
	ostr << _a;
	if (_b != RATIONAL(0)) {
	    if (_b > RATIONAL(0))
		ostr << std::string("+");
	    ostr << _b << std::string("delta");
	}
    }

    const RATIONAL& getA() const {
	return _a;
    }

    const RATIONAL& getB() const {
	return _b;
    }

    RATIONAL toRational(const RATIONAL& delta) const {
	RATIONAL result;
	result = _a + _b*delta;
	result.canonicalize();
	return result;
    }
 private:
    RATIONAL _a, _b;
};

std::ostream& operator<<(std::ostream& ostr, const QDelta& r);

#endif
