#include "VariableOrdering.h"
#include <iostream>
#include <algorithm>
using std::cout;
using std::endl;

VariableOrdering _variableOrdering;

int VariableOrdering::compare(const std::string& v1, const std::string& v2) const {
//    cout << "Compare: " << v1 << " " << v2 << endl;
    std::map<std::string, int>::const_iterator i1 = _count.find(v1);
    std::map<std::string, int>::const_iterator i2 = _count.find(v2);
    std::map<std::string, int>::const_iterator en = _count.end();

    if (i1 == en && i2 != en)
	return -1;
    if (i1 != en && i2 == en)
	return 1;
    if (i1 == en && i2 == en)
	return -v1.compare(v2);

    int cnt1 = i1->second;
    int cnt2 = i2->second;
    if ( cnt1 < cnt2 )
	return 1;
    else if (cnt1 > cnt2)
	return -1;
    else 
	return -v1.compare(v2);
}

int VariableOrdering::compare(unsigned i1, unsigned i2) const {
    int cnt1 = i1 < _indexedCount.size() ? _indexedCount[i1] : 0;
    int cnt2 = i2 < _indexedCount.size() ? _indexedCount[i2] : 0;

    if (cnt1 < cnt2)
	return 1;
    if (cnt1 > cnt2)
	return -1;
    if (i1 < i2)
	return -1;
    if (i1 > i2)
	return 1;
    else
	return 0;
}

void VariableOrdering::add(const std::string& v, unsigned index) {
//    cout << "ADD: " << v << " " << index << endl;
    std::map<std::string, int>::iterator i = _count.find(v);
    if (i == _count.end()) {
	_count[v] = 1;
	if (index >= _indexedCount.size()) {
	    unsigned old_size = _indexedCount.size();
	    _indexedCount.resize(index+1);
	    for (unsigned k = old_size; k < index; k++) {
		_indexedCount[k] = 0;
	    }
	    _indexedCount[index] = 1;
	}
    } else {
	i->second++;
	_indexedCount[index]++;
    }
}

void VariableOrdering::print() {
    sort();
    std::map<std::string, int>::const_iterator it;
    for (it = _count.begin(); it != _count.end(); it++)
	std::cout << it->first << " : " << it->second << std::endl;
    std::vector<std::string>::const_iterator jt;
    for (jt = _sorted_vars.begin(); jt != _sorted_vars.end(); jt++)
	std::cout << *jt << " ";
    std::cout << std::endl;
    for (unsigned k = 0; k < _indexedCount.size(); k++) {
	cout << k << " : occurs : " << _indexedCount[k] << endl;
    }
}

void VariableOrdering::sort() {
    _sorted_vars.clear();
    std::map<std::string, int>::const_iterator it;
    for (it = _count.begin(); it != _count.end(); it++)
	_sorted_vars.push_back(it->first);

    std::sort(_sorted_vars.begin(), _sorted_vars.end(), *this);
}

