#ifndef __VARIABLE_ORDERING_H__
#define __VARIABLE_ORDERING_H__

#include <map>
#include <string>
#include <vector>

class VariableOrdering {
 public:
    int compare(const std::string& v1, const std::string& v2) const;
    int compare(unsigned i1, unsigned i2) const;
    void add(const std::string& v, unsigned index);
    void print();

    int operator()(const std::string& v1, const std::string& v2) const {
	return compare(v1, v2) > 0;
    }

    typedef std::vector<std::string>::reverse_iterator reverse_iterator;

    reverse_iterator rbegin() {
	return _sorted_vars.rbegin();
    }

    reverse_iterator rend() {
	return _sorted_vars.rend();
    }

    void sort();

    static bool isNumber(const std::string& v);

 private:

    std::map<std::string, int> _count;
    std::vector<unsigned> _indexedCount;
    std::vector<std::string> _sorted_vars;
 
};

extern VariableOrdering _variableOrdering;
#endif
