:- dynamic(symmetric/1).

/* ----------------------------------------------------------------- */

/* sorting elements of the list */
quick_sort([],[]) :- !.
quick_sort([H|T],Sorted) :- pivoting(H,T,L1,L2),
                            quick_sort(L1,Sorted1),quick_sort(L2,Sorted2),
                            append(Sorted1,[H|Sorted2],Sorted).
   
pivoting(_,[],[],[]) :- !.
pivoting(H,[X|T],[X|L],G) :- X@=<H, !, pivoting(H,T,L,G).
pivoting(H,[X|T],L,[X|G]) :- X@>H, pivoting(H,T,L,G).

/* ----------------------------------------------------------------- */

/* depth of a term */
term_depth(T,0) :- var(T), !.
term_depth(T,0) :- number(T), !.
term_depth(T,0) :- atom(T), !.
term_depth(T,N) :- compound(T), functor(T,F,M), F='.', !,
                   calculate_max_term_depth(T,M,N).
term_depth(T,N) :- compound(T), functor(T,F,M), F='foot', !,
                   calculate_max_term_depth(T,M,N). /* foot ne racunamo u slozenost */
term_depth(T,N) :- compound(T), functor(T,F,M), F='outcenter', !,
                   calculate_max_term_depth(T,M,N). /* outcenter ne racunamo u slozenost */
term_depth(T,N) :- compound(T), functor(T,F,M), F='incenter', !,
                   calculate_max_term_depth(T,M,N). /* incenter ne racunamo u slozenost */
term_depth(T,N) :- compound(T), functor(T,_,M), !,
                   calculate_max_term_depth(T,M,N1), N is N1+1.

calculate_max_term_depth(_,0,0) :- !.
calculate_max_term_depth(T,M,N) :- arg(M,T,A), term_depth(A,N1), M1 is M-1, 
                                   calculate_max_term_depth(T,M1,N2), max(N1,N2,N).

max(A,B,A) :- A>=B, !.
max(_,B,B).
 
/* ----------------------------------------------------------------- */

/* formatted name of objects (for the formatted output of construction) */
obj_name(X,W) :- var(X), !, term_to_atom(X,Y), string_concat('V[',Y,Z),
                 string_concat(Z,']',W).
obj_name(obj(point,X),W) :- var(X), !, term_to_atom(X,Y), string_concat('P_{\\',Y,Z),
                            string_concat(Z,'}',W).
obj_name(obj(line,X),W) :- var(X), !, term_to_atom(X,Y), string_concat('L_{\\',Y,Z),
                           string_concat(Z,'}',W).
obj_name(obj(circle,X),W) :- var(X), !, term_to_atom(X,Y), string_concat('C_{\\',Y,Z),
                             string_concat(Z,'}',W).
obj_name(obj(angle,X),W) :- var(X), !, term_to_atom(X,Y), string_concat('angle[',Y,Z),
                            string_concat(Z,']',W).
obj_name(obj(int,X),X) :- !.

obj_name(obj(point,a),'A') :- !.
obj_name(obj(point,b),'B') :- !.
obj_name(obj(point,c),'C') :- !.
obj_name(obj(point,a_k),'A_{k}') :- !.
obj_name(obj(point,b_k),'B_{k}') :- !.
obj_name(obj(point,c_k),'C_{k}') :- !.
obj_name(obj(point,chord1(a)),'A_{c1}') :- !.
obj_name(obj(point,chord2(a)),'A_{c2}') :- !.
obj_name(obj(point,chord3(a)),'A_{c3}') :- !.
obj_name(obj(point,chord4(a)),'A_{c4}') :- !.
obj_name(obj(point,chord1(b)),'B_{c1}') :- !.
obj_name(obj(point,chord2(b)),'B_{c2}') :- !.
obj_name(obj(point,chord3(b)),'B_{c3}') :- !.
obj_name(obj(point,chord4(b)),'B_{c4}') :- !.
obj_name(obj(point,chord1(c)),'C_{c1}') :- !.
obj_name(obj(point,chord2(c)),'C_{c2}') :- !.
obj_name(obj(point,chord3(c)),'C_{c3}') :- !.
obj_name(obj(point,chord4(c)),'C_{c4}') :- !.
obj_name(obj(point,chord_alt1(a)),'A_{ca1}') :- !.
obj_name(obj(point,chord_alt2(a)),'A_{ca2}') :- !.
obj_name(obj(point,chord_alt1(b)),'B_{ca1}') :- !.
obj_name(obj(point,chord_alt2(b)),'B_{ca2}') :- !.
obj_name(obj(point,chord_alt1(c)),'C_{ca1}') :- !.
obj_name(obj(point,chord_alt2(c)),'C_{ca2}') :- !.
obj_name(obj(point,second_ai(a)),'A_{sa}') :- !.
obj_name(obj(point,second_ai(b)),'B_{sa}') :- !.
obj_name(obj(point,second_ai(c)),'C_{sa}') :- !.
obj_name(obj(point,foot_ima(a)),'A_{fi}') :- !.
obj_name(obj(point,foot_ima(b)),'B_{fi}') :- !.
obj_name(obj(point,foot_ima(c)),'C_{fi}') :- !.
obj_name(obj(point,foot_out(a)),'A_{fo}') :- !.
obj_name(obj(point,foot_out(b)),'B_{fo}') :- !.
obj_name(obj(point,foot_out(c)),'C_{fo}') :- !.
obj_name(obj(line,line_a1),'a1') :- !.
obj_name(obj(line,line_a2),'a2') :- !.
obj_name(obj(line,line_b1),'b1') :- !.
obj_name(obj(line,line_b2),'b2') :- !.
obj_name(obj(line,line_c1),'c1') :- !.
obj_name(obj(line,line_c2),'c2') :- !.
obj_name(obj(line,line_x1),'x1') :- !.
obj_name(obj(line,line_x2),'x2') :- !.
obj_name(obj(line,line_x3),'x3') :- !.
obj_name(obj(line,line_y1),'y1') :- !.
obj_name(obj(line,line_y2),'y2') :- !.
obj_name(obj(line,line_y3),'y3') :- !.
obj_name(obj(point,a_w(b)),'A_{wb}') :- !.
obj_name(obj(point,a_w(c)),'A_{wc}') :- !.
obj_name(obj(point,b_w(a)),'B_{wa}') :- !.
obj_name(obj(point,b_w(c)),'B_{wc}') :- !.
obj_name(obj(point,c_w(a)),'C_{wa}') :- !.
obj_name(obj(point,c_w(b)),'C_{wb}') :- !.
obj_name(obj(line,line([a,b])),'c') :- !.
obj_name(obj(line,line([a,c])),'b') :- !.
obj_name(obj(line,line([b,c])),'a') :- !.
obj_name(obj(line,line([X,Y])),Z) :- obj_name(obj(point,X),X1),  
                                     obj_name(obj(point,Y),Y1), 
                                     string_concat(X1,Y1,Z), !.
obj_name(obj(point,midpoint([a,b])),'M_{c}') :- !.
obj_name(obj(point,midpoint([a,c])),'M_{b}') :- !.
obj_name(obj(point,midpoint([b,c])),'M_{a}') :- !.
obj_name(obj(point,midpoint([X,Y])),Z) :- obj_name(obj(point,X),X1),  
                                     obj_name(obj(point,Y),Y1),
                                     string_concat('midpoint([',X1,Z1),
                                     string_concat(Z1,',',Z2),
                                     string_concat(Z2,Y1,Z3),
                                     string_concat(Z3,'])',Z), !.
obj_name(obj(point,circumcenter([a,b],c)),'O') :- !.
obj_name(obj(point,incenter([a,b],c)),'I') :- !.
obj_name(obj(point,centroid([a,b],c)),'G') :- !.
obj_name(obj(point,orthocenter([a,b],c)),'H') :- !.
obj_name(obj(point,npcenter([a,b],c)),'N') :- !.
obj_name(obj(point,foot(a,[b,c])),'H_{a}') :- !.
obj_name(obj(point,foot(b,[a,c])),'H_{b}') :- !.
obj_name(obj(point,foot(c,[a,b])),'H_{c}') :- !.
obj_name(obj(point,point_n(a,[b,c])),'N_{a}') :- !.
obj_name(obj(point,point_n(b,[a,c])),'N_{b}') :- !.
obj_name(obj(point,point_n(c,[a,b])),'N_{c}') :- !.
obj_name(obj(point,point_n_k(a,[b,c])),'N_{a}_{k}') :- !.
obj_name(obj(point,point_n_k(b,[a,c])),'N_{b}_{k}') :- !.
obj_name(obj(point,point_n_k(c,[a,b])),'N_{c}_{k}') :- !.
obj_name(obj(point,point_p(a,[b,c])),'PP_{a}') :- !.
obj_name(obj(point,point_p(b,[a,c])),'PP_{b}') :- !.
obj_name(obj(point,point_p(c,[a,b])),'PP_{c}') :- !.
obj_name(obj(point,point_p1(a,[b,c])),'PP_{a}`') :- !.
obj_name(obj(point,point_p1(b,[a,c])),'PP_{b}`') :- !.
obj_name(obj(point,point_p1(c,[a,b])),'PP_{c}`') :- !.
obj_name(obj(point,angle_bis_foot(a,[b,c])),'T_{a}') :- !.
obj_name(obj(point,angle_bis_foot(b,[a,c])),'T_{b}') :- !.
obj_name(obj(point,angle_bis_foot(c,[a,b])),'T_{c}') :- !.
obj_name(obj(point,euler(a,[b,c])),'E_{a}') :- !.
obj_name(obj(point,euler(b,[a,c])),'E_{b}') :- !.
obj_name(obj(point,euler(c,[a,b])),'E_{c}') :- !.
obj_name(obj(point,angle_bis_out_foot(a,[b,c])),'T`_{a}') :- !.
obj_name(obj(point,angle_bis_out_foot(b,[a,c])),'T`_{b}') :- !.
obj_name(obj(point,angle_bis_out_foot(c,[a,b])),'T`_{c}') :- !.
obj_name(obj(point,foot(incenter([a,b],c),[b,c])),'P_{a}') :- !.
obj_name(obj(point,foot(incenter([a,b],c),[a,c])),'P_{b}') :- !.
obj_name(obj(point,foot(incenter([a,b],c),[a,b])),'P_{c}') :- !.
obj_name(obj(point,foot(outcenter(a,[b,c]),[b,c])),'P`_{a}') :- !.
obj_name(obj(point,foot(outcenter(b,[a,c]),[a,c])),'P`_{b}') :- !.
obj_name(obj(point,foot(outcenter(c,[a,b]),[a,b])),'P`_{c}') :- !.
obj_name(obj(point,foot_out(a)),'P``_{a}') :- !.
obj_name(obj(point,foot_out(b)),'P``_{b}') :- !.
obj_name(obj(point,foot_out(c)),'P``_{c}') :- !.
obj_name(obj(line,side_bis([b,c])),'m_{a}') :- !.
obj_name(obj(line,side_bis([a,c])),'m_{b}') :- !.
obj_name(obj(line,side_bis([a,b])),'m_{c}') :- !.
obj_name(obj(line,side_bis([X,Y])),Z) :- obj_name(obj(point,X),X1),  
                                         obj_name(obj(point,Y),Y1), 
                                         string_concat('m(',X1,Z1),
                                         string_concat(Z1,Y1,Z2),
                                         string_concat(Z2,')',Z), !.
obj_name(obj(line,homothety(P,L,A,B)),Z) :- obj_name(obj(point,P),P1),  
                                            obj_name(obj(line,L),L1), 
                                            string_concat('h_{',P1,Z1),
                                            string_concat(Z1,',',Z2),
                                            string_concat(Z2,A,Z3),
                                            string_concat(Z3,'/',Z4),
                                            string_concat(Z4,B,Z5),
                                            string_concat(Z5,'}(',Z6), 
                                            string_concat(Z6,L1,Z7),
                                            string_concat(Z7,')',Z), !.
obj_name(obj(circle,homothety_circ(P,C,A,B)),Z) :- obj_name(obj(point,P),P1),  
                                                 obj_name(obj(circle,C),C1), 
                                                 string_concat('h_{',P1,Z1),
                                                 string_concat(Z1,',',Z2),
                                                 string_concat(Z2,A,Z3),
                                                 string_concat(Z3,'/',Z4),
                                                 string_concat(Z4,B,Z5),
                                                 string_concat(Z5,'}(',Z6), 
                                                 string_concat(Z6,C1,Z7),
                                                 string_concat(Z7,')',Z), !.
obj_name(obj(line,altitude(a,[b,c])),'h_{a}') :- !.
obj_name(obj(line,altitude(b,[a,c])),'h_{b}') :- !.
obj_name(obj(line,altitude(c,[a,b])),'h_{c}') :- !.
obj_name(obj(line,median(a,[b,c])),'t_{a}') :- !.
obj_name(obj(line,median(b,[a,c])),'t_{b}') :- !.
obj_name(obj(line,median(c,[a,b])),'t_{c}') :- !.
obj_name(obj(line,angle_bis(a,[b,c])),'s_{a}') :- !.
obj_name(obj(line,angle_bis(b,[a,c])),'s_{b}') :- !.
obj_name(obj(line,angle_bis(c,[a,b])),'s_{c}') :- !.
obj_name(obj(circle,circumcircle([a,b],c)),'k(O,C)') :- !.
obj_name(obj(circle,incircle([a,b],c)),'k(I,P_{a})') :- !.
obj_name(obj(circle,npcircle([a,b],c)),'k(N,M_{a})') :- !.
obj_name(obj(circle,circle_center_through(X,Y)),Z) :- obj_name(obj(point,X),X1), 
                                                      obj_name(obj(point,Y),Y1),
                                                      string_concat('k(',X1,P1), 
                                                      string_concat(P1,',',P2), 
                                                      string_concat(P2,Y1,P3),
                                                      string_concat(P3,')',Z), !.
obj_name(obj(circle,diam(X,Y)),Z) :- obj_name(obj(point,X),X1), 
                                     obj_name(obj(point,Y),Y1),
                                     string_concat('k_over(',X1,P1), 
                                     string_concat(P1,',',P2), 
                                     string_concat(P2,Y1,P3),
                                     string_concat(P3,')',Z), !.
obj_name(obj(circle,circumcircle([b,c,foot(b,[a,c])])),'k(M_{a},C)') :- !.
obj_name(obj(circle,circumcircle([b,a,foot(b,[a,c])])),'k(M_{c},B)') :- !.
obj_name(obj(circle,circumcircle([a,c,foot(a,[b,c])])),'k(M_{b},A)') :- !.
obj_name(obj(angle,angle(X,Y)),Z) :- obj_name_modified(obj(line,X),X1), 
                                     obj_name_modified(obj(line,Y),Y1),
                                     string_concat('angle[',X1,P1),
                                     string_concat(P1,'][',P2),
                                     string_concat(P2,Y1,P3),
                                     string_concat(P3,']',Z), !.
obj_name(obj(circle,over_chord([X,Y],Ang)),Z) :- obj_name(obj(point,X),X1), 
                                                 obj_name(obj(point,Y),Y1), 
                                                 obj_name(obj(angle,Ang),Ang1), 
                                                 string_concat('circle[',X1,A1),
                                                 string_concat(A1,',',A2),
                                                 string_concat(A2,Y1,A3), 
                                                 string_concat(A3,',',A4),
                                                 string_concat(A4,Ang1,A5),
                                                 string_concat(A5,']',Z), !.
obj_name(obj(point,foot(X,Y)),Z) :- obj_name(obj(point,X),X1),
                                    obj_name(obj(line,Y),Y1),
                                    string_concat('foot[',X1,A1),
                                    string_concat(A1,',',A2),
                                    string_concat(A2,Y1,A3),
                                    string_concat(A3,']',Z), !.
obj_name(X,X). /* for other objects */

/*PROVERI DA LI TREBA MOZDA KAO ARGUMENT X, PA ONDA PROVERITI EQUAL(x,...)*/

tex_obj_name(Obj,NameTex) :- obj_name(Obj,Name), string_concat('$',Name,Name1), string_concat(Name1,'$',NameTex).

obj_name_modified(Obj,NameMod) :- obj_name(Obj,Name), replace_brackets(Name,NameMod), !.

replace_brackets(Name,NameMod) :- string_to_list(Name,NameList), replace(NameList,NameNew), string_to_list(NameMod,NameNew), !.

replace([],[]) :- !.
replace([40|T],[91|T1]) :- !, replace(T,T1).
replace([41|T],[93|T1]) :- !, replace(T,T1).
replace([95,123|T],[91|T1]) :- !, replace(T,T1).
replace([125|T],[93|T1]) :- !, replace(T,T1).

replace([H|T],[H|T1]) :- replace(T,T1). 

/* ----------------------------------------------------------------- */

/* printing problem setting into a file */
print_problem_setting_to_file(Known,_,N,Stream) :- write(Stream,'Problem '), 
                                                        write(Stream,N),
                                                        write(Stream,':'),
                                                        nl(Stream),
                                                        write(Stream,'Given '), 
                                                        write_tex_indef_objs_to_file(Known,Stream),
                                                        write(Stream, ', construct the triangle ABC.'), 
                                                        nl(Stream), nl(Stream), !.

/* ----------------------------------------------------------------- */
                                                     
print_construction_to_tex_file(L,Known,N,NDGs,DETs,RulesUsed,LemmasUsed,Time,Stream) :-
                                             write(Stream,'\\documentclass{article}'), nl(Stream),
                                             write(Stream,'\\usepackage{argoclp}'), nl(Stream),
                                             write(Stream,'\\usepackage{listings}'), nl(Stream),
                                             write(Stream,'\\usepackage{tikz}'), nl(Stream),
                                             write(Stream,'\\usepackage{gclc}'), nl(Stream),
                                             write(Stream,'\\usepackage{graphicx}'), nl(Stream),

                                             write(Stream,'\\lstset{%'), nl(Stream),
                                             write(Stream,'language=[LaTeX]TeX,'), nl(Stream),
                                             write(Stream,'basicstyle=\\ttfamily,'), nl(Stream),
                                             write(Stream,'breaklines=true,'), nl(Stream),
                                             write(Stream,'columns=fullflexible'), nl(Stream),
                                             write(Stream,'}'), nl(Stream),
                    
                                             write(Stream,'\\makeatletter'), nl(Stream),
                                             write(Stream,'\\@ifclassloaded{combine}'), nl(Stream),
                                             write(Stream,'  {\\let\\@begindocumenthook\\@empty}'), nl(Stream),
                                             write(Stream,'  {}'), nl(Stream),
                                             write(Stream,'\\makeatother'), nl(Stream), nl(Stream),

                                             write(Stream,'\\begin{document}'), nl(Stream),
                                             write(Stream,'\\title{Problem '), write(Stream,N),  write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\author{Generated automatically by ArgoTriCS '),
                                             write(Stream,'\\\\ Developed by Vesna Marinkovi\\\' c, University of Belgrade}'), 
                                             nl(Stream),
                                             write(Stream,'\\maketitle'), nl(Stream), nl(Stream),

                                             write(Stream,'\\section{Problem}'), nl(Stream), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N), write(Stream,': '), 
                                             write(Stream,'Given '), write_tex_indef_objs_to_file(Known,Stream),
                                             write(Stream, ', construct the triangle $ABC$.'), nl(Stream), nl(Stream),
 
                                             write(Stream,'\\section{Solution}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{Construction in natural language form}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\begin{enumerate}'), nl(Stream),
                                             print_tex_steps_to_file(L,1,Stream),
                                             write(Stream,'\\end{enumerate}'), nl(Stream), nl(Stream),
                                             write(Stream, 'Non-degenerate conditions: '), write_tex_prop_list(Stream,NDGs,1), write(Stream,'.'), nl(Stream),
                                             nl(Stream),
                                             write(Stream, 'Determination conditions: '), write_tex_prop_list(Stream,DETs,1), write(Stream,'.'), nl(Stream), 
                                             nl(Stream),
                                             write(Stream, 'Rules used: '), write(Stream,RulesUsed), nl(Stream),
                                             nl(Stream),
                                             write(Stream, 'Lemmas used: '), write(Stream,LemmasUsed), nl(Stream), nl(Stream),
                                             write(Stream, 'Solving time: '), 
                                             format(Stream,'~1f',[Time]), /*write(Stream,Time),*/ write(Stream,' seconds.'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{Construction in GCLC language}'), nl(Stream), nl(Stream),
                                             write(Stream, '\\footnotesize{'), nl(Stream),
                                             write(Stream,'\\begin{lstlisting}'), nl(Stream),
                                             print_construction_to_gclc_file(L,NDGs,DETs,Known,Stream),
                                             write(Stream,'\\end{lstlisting}'), nl(Stream), 
                                             write(Stream,'}'), nl(Stream),
                                             nl(Stream),
                                             write(Stream,'\\subsection{Illustration}'), nl(Stream), nl(Stream),
                                             write(Stream,'Illustration of the constructed figure is given in Figure \\ref{fig:problem'),
                                             write(Stream,N), write(Stream,'}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\begin{figure}'), nl(Stream),
                                             write(Stream,'\\centering'), nl(Stream),
                                             write(Stream,'\\input{proofs/construction_'), write(Stream,N), write(Stream,'.tikz}'), nl(Stream),
                                             write(Stream,'\\caption{Illustration of the problem '), write(Stream,N),
                                             write(Stream,'}\\label{fig:problem'), write(Stream,N), write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\end{figure}'), nl(Stream),
                                             write(Stream,'\\subsection{Construction in OpenGeoProver format}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream, '\\footnotesize{'), nl(Stream),
                                             write(Stream,'\\begin{lstlisting}'), nl(Stream),
                                             print_construction_to_xml_file(L,Known,N,Stream),
                                             write(Stream,'\\end{lstlisting}'), nl(Stream),
                                             write(Stream,'}'), nl(Stream),

                                             write(Stream,'\\section{Correctness proof}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{OGP - Wu method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction_'), write(Stream,N), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),                                           
                                             write(Stream,'\\subsection{GCLC - Area method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction_'), write(Stream,N), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{GCLC - Wu method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction_'), write(Stream,N), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{GCLC - Grobner basis method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction_'), write(Stream,N), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\end{document}'),
                                             
                                             !.


/* ----------------------------------------------------------------- */
                                                     
/* printing construction into a file */
print_construction_to_file(L,NDGs,DETs,RulesUsed,LemmasUsed,Time,Stream) :- write(Stream, 'Construction: '), nl(Stream),
/*write('XXX'),*/
print_steps_to_file(L,1,Stream), nl(Stream),
                                             /*write('AAA'),*/
                                             write(Stream, 'Non-degenerate conditions: '), write_prop_list(Stream,NDGs,1), write(Stream,'.'), nl(Stream),
                                             /*write('BBB'),*/
                                             write(Stream, 'Determination conditions: '), write_prop_list(Stream,DETs,1), write(Stream,'.'), nl(Stream), 
                                             /*write('CCC'),*/
                                             write(Stream, 'Rules used: '), write(Stream,RulesUsed), nl(Stream),
                                             /*write('DDD'),*/
                                             write(Stream, 'Lemmas used: '), write(Stream,LemmasUsed), nl(Stream), nl(Stream),
                                             write(Stream, 'Solving time: '), 
                                             format(Stream,'~1f',[Time]), /*write(Stream,Time),*/ write(Stream,' seconds.'), 
                                             nl(Stream), nl(Stream), !. 

/* ----------------------------------------------------------------- */

write_ndg_list_if_any(_,[]) :- !.
write_ndg_list_if_any(Stream,L) :- write(Stream,'% NDG: '), write_prop_list(Stream,L,1).
           
/* ----------------------------------------------------------------- */

write_tex_ndg_list_if_any(_,[]) :- !.
write_tex_ndg_list_if_any(Stream,L) :- write(Stream,'\\% NDG: '), write_tex_prop_list(Stream,L,1).
           
/* ----------------------------------------------------------------- */

write_det_list_if_any(_,[]) :-!.
write_det_list_if_any(Stream,L) :- write(Stream,'% DET: '), write_prop_list(Stream,L,1).
           
/* ----------------------------------------------------------------- */

write_tex_det_list_if_any(_,[]) :-!.
write_tex_det_list_if_any(Stream,L) :- write(Stream,' \\% DET: '), write_tex_prop_list(Stream,L,1).
           
/* ----------------------------------------------------------------- */
                                          
write_prop_list(_,[],_) :- !.
write_prop_list(Stream,[H|T],N) :- write_semicolon_to_file1(N,Stream), write_prop(Stream,H), N1 is N+1, write_prop_list(Stream,T,N1).

/* ----------------------------------------------------------------- */

write_tex_prop_list(_,[],_) :- !.
write_tex_prop_list(Stream,[H|T],N) :- write_semicolon_to_file1(N,Stream), write_tex_prop(Stream,H), N1 is N+1, write_tex_prop_list(Stream,T,N1).

/* ----------------------------------------------------------------- */

write_prop(Stream,not_true(identical_points(A,B))) :- !, write(Stream,' points '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(point,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_prop(Stream,not_true(identical_lines(A,B))) :- !, write(Stream,' lines '), 
                                                obj_name(obj(line,A),AN),
                                                obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_prop(Stream,not_true(identical_circles(A,B))) :- !, write(Stream,' circles '), 
                                                obj_name(obj(circle,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_prop(Stream,not_parallel(A,B)) :- !, write(Stream,' lines '), 
                                                obj_name(obj(line,A),AN),
                                                obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not parallel').
write_prop(Stream,intersect_line_circle(A,B)) :- !, write(Stream,' line '), 
                                                obj_name(obj(line,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and circle '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_prop(Stream,intersect_circle_circle(A,B)) :- !, write(Stream,' circles '), 
                                                obj_name(obj(circle,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_prop(Stream,not_true(inc(A,B))) :- !, write(Stream,' point '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is not incident to the line '),
                                                write(Stream,BN).
write_prop(Stream,out_of_circle(A,B)) :- !, write(Stream,' point '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is outside the circle '),
                                                write(Stream,BN).
write_prop(Stream,in_circle(A,B)) :- write(Stream,' point '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is inside the circle '),
                                                write(Stream,BN).


/* ----------------------------------------------------------------- */

write_tex_prop(Stream,not_true(identical_points(A,B))) :- !, write(Stream,' points '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(point,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_tex_prop(Stream,not_true(identical_lines(A,B))) :- !, write(Stream,' lines '), 
                                                tex_obj_name(obj(line,A),AN),
                                                tex_obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_tex_prop(Stream,not_true(identical_circles(A,B))) :- !, write(Stream,' circles '), 
                                                tex_obj_name(obj(circle,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_tex_prop(Stream,not_parallel(A,B)) :- !, write(Stream,' lines '), 
                                                tex_obj_name(obj(line,A),AN),
                                                tex_obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not parallel').
write_tex_prop(Stream,intersect_line_circle(A,B)) :- !, write(Stream,' line '), 
                                                tex_obj_name(obj(line,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and circle '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_tex_prop(Stream,intersect_circle_circle(A,B)) :- !, write(Stream,' circles '), 
                                                tex_obj_name(obj(circle,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_tex_prop(Stream,not_true(inc(A,B))) :- !, write(Stream,' point '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is not incident to the line '),
                                                write(Stream,BN).
write_tex_prop(Stream,out_of_circle(A,B)) :- !, write(Stream,' point '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is outside the circle '),
                                                write(Stream,BN).
write_tex_prop(Stream,in_circle(A,B)) :- write(Stream,' point '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is inside the circle '),
                                                write(Stream,BN).


/* ----------------------------------------------------------------- */

/* printing construction steps into a file */
print_steps_to_file([],_,Stream)                       :- write(Stream,'.'), nl(Stream), !.
print_steps_to_file([(_,C,[H],_,_,_,'WOnline1',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline1'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline1) '),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline1'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H],_,_,_,'WOnline2',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline2'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline2)'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline2'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H],_,_,_,'WOnline3',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline3'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline3)'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline3'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H],_,_,_,'WOnline4',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline4'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline4)'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline4'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle1',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('woncircle1'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle)'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle1'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle2',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('woncircle2'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle)'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle2'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([([],_,[H1|T1],_,_,_,Id,_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write(Id),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' (rule '), write(Stream,Id),
                                                         write(Stream, ')'),
                                                         N1 is N+1, 
                                                         /*write('prosao'), write(Id),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([([H|T],_,[H1|T1],_,NDG,DET,Id,_)|O],N,Stream) :- 
                                                            write_semicolon_to_file(N,Stream),
                                                            /*nl, write(Id),*/
                                                            write(Stream,N), write(Stream,'. Using '),
                                                            eliminate_duplicates([H|T],L1),
                                                            write_tex_def_objs_to_file(L1,Stream), 
                                                            write(Stream,', construct '),
                                                            eliminate_duplicates([H1|T1],L2),
                                                            write_tex_indef_objs_to_file(L2,Stream),
                                                            write(Stream, ' (rule '), write(Stream,Id),
                                                            write(Stream,'); '),  
                                                            write_ndg_list_if_any(Stream,NDG),
                                                            write_det_list_if_any(Stream,DET),
                                                            N1 is N+1, 
                                                            /*write('prosao'), write(Id), nl,*/
                                                            print_steps_to_file(O,N1,Stream).

/* ----------------------------------------------------------------- */

/* printing construction steps into a file */
print_tex_steps_to_file([],_,Stream)                       :- write(Stream,'.'), nl(Stream), !.
print_tex_steps_to_file([(_,C,[H],_,_,_,'WOnline1',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline1'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline1) '),
                                                         /*write('prosao wonline1'),*/
                                                         N1 is N+1,
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H],_,_,_,'WOnline2',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline2'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline2)'),
                                                         /*write('prosao wonline2'),*/
                                                         N1 is N+1,
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H],_,_,_,'WOnline3',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline3'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline3)'),
                                                         /*write('prosao wonline3'),*/
                                                         N1 is N+1,
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H],_,_,_,'WOnline4',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline4'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline4)'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline4'),*/
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle1',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('woncircle1'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle)'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle1'),*/
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle2',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('woncircle2'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle)'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle2'),*/
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([([],_,[H1|T1],_,_,_,Id,_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write(Id),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' (rule '), write(Stream,Id),
                                                         write(Stream, ')'),
                                                         N1 is N+1, 
                                                         /*write('prosao'), write(Id),*/
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([([H|T],_,[H1|T1],_,NDG,DET,Id,_)|O],N,Stream) :- 
                                                            write_semicolon_to_file(N,Stream),
                                                            /*nl, write(Id),*/
                                                            write(Stream,'\\item '), write(Stream,'Using '),
                                                            eliminate_duplicates([H|T],L1),
                                                            write_tex_def_objs_to_file(L1,Stream), 
                                                            write(Stream,', construct '),
                                                            eliminate_duplicates([H1|T1],L2),
                                                            write_tex_indef_objs_to_file(L2,Stream),
                                                            write(Stream, ' (rule '), write(Stream,Id),
                                                            write(Stream,'); '),  
                                                            write_tex_ndg_list_if_any(Stream,NDG),
                                                            write_tex_det_list_if_any(Stream,DET),
                                                            N1 is N+1, 
                                                            /*write('prosao'), write(Id), nl,*/
                                                            print_tex_steps_to_file(O,N1,Stream).

/* ----------------------------------------------------------------- */

/* eliminates duplicates in list of objects */
eliminate_duplicates([],[]) :- !.
eliminate_duplicates([H|T],T1) :- element(H,T), !, eliminate_duplicates(T,T1). 
eliminate_duplicates([H|T],[H|T1]) :- eliminate_duplicates(T,T1). 

/* ----------------------------------------------------------------- */

/* each line, except the last one is ended by ';' */
write_semicolon_to_file(1,_)      :- !.
write_semicolon_to_file(_,Stream) :- write(Stream,';'), nl(Stream).

/* ----------------------------------------------------------------- */

/* each line, except the last one is ended by ';' without new line */
write_semicolon_to_file1(1,_)      :- !.
write_semicolon_to_file1(_,Stream) :- write(Stream,';').

/* ------------------------------------------------------------------ */

/* write comma between objects  to stdout */
write_comma(1) :- !.
write_comma(_) :- write(', ').

/* ------------------------------------------------------------------ */

/* write comma between objects  to stdout */
write_comma(1,_) :- !.
write_comma(_,Stream) :- write(Stream,', ').

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_def_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'the '), write(Stream,Type),  write(Stream,' '), 
                                           obj_name(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_tex_def_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'the '), write(Stream,Type),  write(Stream,' '), 
                                           tex_obj_name(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_and_def_objs_to_file([],_)      :- !.
write_and_def_objs_to_file([H],Stream):- write(Stream,' and '), write_def_obj_to_file(H,Stream), !.
write_and_def_objs_to_file([H|T],Stream):- write(Stream,', '), write_def_obj_to_file(H,Stream), 
                                       write_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_tex_and_def_objs_to_file([],_)      :- !.
write_tex_and_def_objs_to_file([H],Stream):- write(Stream,' and '), write_tex_def_obj_to_file(H,Stream), !.
write_tex_and_def_objs_to_file([H|T],Stream):- write(Stream,', '), write_tex_def_obj_to_file(H,Stream), 
                                       write_tex_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_def_objs_to_file([], _) :- !.
write_def_objs_to_file([H|T],Stream):- write_def_obj_to_file(H,Stream), 
                                   write_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_tex_def_objs_to_file([], _) :- !.
write_tex_def_objs_to_file([H|T],Stream):- write_tex_def_obj_to_file(H,Stream), 
                                   write_tex_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_indef_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'a '), write(Stream,Type),  write(Stream,' '), 
                                           obj_name(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_tex_indef_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'a '), write(Stream,Type), write(Stream,' '),
                                           tex_obj_name(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_and_indef_objs_to_file([],_)      :- !.
write_and_indef_objs_to_file([H],Stream) :- write(Stream,' and '), write_indef_obj_to_file(H,Stream), !.
write_and_indef_objs_to_file([H|T],Stream):- write(Stream,', '), write_indef_obj_to_file(H,Stream), 
                                       write_and_indef_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_tex_and_indef_objs_to_file([],_)      :- !.
write_tex_and_indef_objs_to_file([H],Stream) :- write(Stream,' and '), write_tex_indef_obj_to_file(H,Stream), !.
write_tex_and_indef_objs_to_file([H|T],Stream):- write(Stream,', '), write_tex_indef_obj_to_file(H,Stream), 
                                       write_tex_and_indef_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_indef_objs_to_file([], _) :- !.
write_indef_objs_to_file([H|T],Stream):- write_indef_obj_to_file(H,Stream), 
                                   write_and_indef_objs_to_file(T,Stream).


/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_tex_indef_objs_to_file([], _) :- !.
write_tex_indef_objs_to_file([H|T],Stream):- write_tex_indef_obj_to_file(H,Stream), 
                                   write_tex_and_indef_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of object names separated by commas to a standard output */
write_list([],_) :- !.
write_list([H|T],N) :- write_comma(N), obj_name(H,H1), write(H1), N1 is N+1, write_list(T,N1).

/* ----------------------------------------------------------------- */

/* write a list of object names separated by commas to a standard output */
write_tex_list([],_) :- !.
write_tex_list([H|T],N) :- write_comma(N), tex_obj_name(H,H1), write(H1), N1 is N+1, write_tex_list(T,N1).


/* ----------------------------------------------------------------- */

/* write a list of object names separated by commas to a stream */
write_list([],_,_) :- !.
write_list([H|T],N,Stream) :- write_comma(N,Stream), obj_name(H,H1), write(Stream,H1), N1 is N+1, write_list(T,N1,Stream).

/* ----------------------------------------------------------------- */

/* write a list of object names separated by commas to a stream */
write_tex_list([],_,_) :- !.
write_tex_list([H|T],N,Stream) :- write_comma(N,Stream), tex_obj_name(H,H1), write(Stream,H1), N1 is N+1, write_tex_list(T,N1,Stream).

/* ----------------------------------------------------------------- */

/* removes an element from the list */
remove_one(_,[],[])         :- !.
remove_one(H,[H|T],T)       :- !.
remove_one(H,[H1|T],[H1|R]) :- remove_one(H,T,R).

/* ----------------------------------------------------------------- */

/* removes all elements of the first list from the second */
myremove([],L,L)    :- !.
myremove([H|T],L,R) :- remove_one(H,L,R1), myremove(T,R1,R).

/* ----------------------------------------------------------------- */

/* appending a list to another */
myappend([],X,X)         :- !.
myappend([H|T],X,[H|T1]) :- myappend(T,X,T1).

/* ----------------------------------------------------------------- */

/* making union of two lists, two variants */
myunion([],L,L)         :- !.
myunion([H|T],L,[H|L1]) :- not_element(H,L), myunion(T,L,L1).
myunion([H|T],L,L1)     :- element(H,L), myunion(T,L,L1).

myunion1(L,[],L)     :- !.
myunion1(L,[H|T],L2) :- not_element(H,L), add2end(H,L,L1), myunion1(L1,T,L2).
myunion1(L,[H|T],L1) :- element(H,L), myunion1(L,T,L1).

/* ----------------------------------------------------------------- */

/* adding element to the end of the list */
add2end(X,[H|T],[H|NewT]) :- add2end(X,T,NewT).
add2end(X,[],[X]).
                  
/* ----------------------------------------------------------------- */

/* checking if the object is an element of the list */
element(O,[H|_]) :- equal(H,O).
element(O,[_|T]) :- element(O,T).

/* ----------------------------------------------------------------- */

/* checking if the object is not an element of the list */
not_element(H,L) :- element(H,L), !, fail.
not_element(_,_).

/* ----------------------------------------------------------------- */

/* checking if the object is not a number */
not_number(H) :- number(H), !, fail.
not_number(_).

/* ----------------------------------------------------------------- */

/* determining which elements of the first list occur in the second list;
   both lists do not contain variables */
in_list([],_,[]).
in_list([H|T],L1,[H|T1]) :- element(H,L1), !, in_list(T,L1,T1).
in_list([_|T],L1,L2)     :- in_list(T,L1,L2).

/* ----------------------------------------------------------------- */

/* determining which elements of the first list occur in the second list */
in_list1([],_,[]).
in_list1([H|T],L1,[H|T1]) :- element(H,L1), in_list1(T,L1,T1).
in_list1([_|T],L1,L2)     :- in_list1(T,L1,L2).


/* ----------------------------------------------------------------- */

/* determining which elements of the first list do not occur in the second list */
not_in_list([],_,[]).
not_in_list([H|T],L1,[H|R]) :- not_element(H,L1), !, not_in_list(T,L1,R).
not_in_list([_|T],L1,R)     :- not_in_list(T,L1,R).
 
/* ----------------------------------------------------------------- */

/* instantiation of the second list with the elements of the first list */
instantiate(_,[])     :-!.
instantiate(L1,[H|T]) :- element(H,L1), instantiate(L1,T).

/* ----------------------------------------------------------------- */

/* checking if the second list is a sublist of the first list */
mysublist(_,[])     :- !.
mysublist(L1,[H|T]) :- element_and_decompose(L1,H,A,B), myappend(A,B,L2), mysublist(L2,T).
/* unified element is deleted from the first list, 
   in order not to be able to instantiate different elements with the same one */

/* ----------------------------------------------------------------- */

/* checking if the second list is not a sublist of the first list */
not_mysublist(L,L1) :- mysublist(L,L1), !, fail.
not_mysublist(_,_).

/* ----------------------------------------------------------------- */

/* checking if the second list is a sublist of the first list */
mysublist_def_lemma(_,[],_)        :- !.
mysublist_def_lemma(L1,[H|T],Perm) :- element_and_decompose_def_lemma(L1,H,A,B,Perm), myappend(A,B,L2), 
                                      /*write('poziv mysublist za '), write(L2), nl, write(T), nl, write(Perm), nl, */
                                      mysublist_def_lemma(L2,T,Perm).
/* unified element is deleted from the first list, 
   in order not to be able to instantiate different elements with the same one */

mysublist_def_lemma_inv(_,[],_)        :- !.
mysublist_def_lemma_inv(L1,[H|T],Perm) :- element_and_decompose_def_lemma_inv(L1,H,A,B,Perm), myappend(A,B,L2), mysublist_def_lemma_inv(L2,T,Perm).

/* ----------------------------------------------------------------- */

/* checking if the element E occurs in the list [H|T],
   if it occurs - list is decomposed into two lists: 
   one with elements before and one with elements after it */
element_and_decompose([],_,[],[])       :- !, fail.
element_and_decompose([H|T],E,[],T)     :- equal(H,E).
element_and_decompose([H|T],E,[H|T1],L) :- element_and_decompose(T,E,T1,L).

/* ----------------------------------------------------------------- */

/* checking if the element E occurs in the list [H|T],
   if it occurs - list is decomposed into two lists: 
   one with elements before and one with elements after it */
element_and_decompose_def_lemma([],_,[],[],_)          :- !, fail.
element_and_decompose_def_lemma([H|T],E,[],T,Perm)     :- equal_def_lemma(H,E,Perm) /*write('proslo equal '), write(H), nl, write(E), write(Perm), nl */.
element_and_decompose_def_lemma([H|T],E,[H|T1],L,Perm) :- element_and_decompose_def_lemma(T,E,T1,L,Perm).

element_and_decompose_def_lemma_inv([],_,[],[],_)          :- !, fail.
element_and_decompose_def_lemma_inv([H|T],E,[],T,Perm)     :- equal_def_lemma(E,H,Perm).
element_and_decompose_def_lemma_inv([H|T],E,[H|T1],L,Perm) :- element_and_decompose_def_lemma_inv(T,E,T1,L,Perm).

/* ----------------------------------------------------------------- */

/* testing if a term is not compound */
non_compound(X) :- compound(X), !, fail.
non_compound(_).

/* ----------------------------------------------------------------- */

/* checking if two terms are equal in the way I like
   examples: equal(A,a), equal(f(A),f(a)), 
             equal(f([a,b,c]),f([c,a,b])), equal(f([a,b,[c,d]]),f([[d,c],b,a])) */

equal(A,B)           :- non_compound(A), A = B, !.
equal(A,B)           :- non_compound(B), A = B, !.
equal([H|T],[H1|T1]) :- !, mysublist([H|T],[H1|T1]), mysublist([H1|T1],[H|T]). 
equal(A,B)           :- compound(A), compound(B), functor(A,FA,NOA), functor(B,FB,NOB), 
                        FA = FB, NOA = NOB, all_n_equal(A,B,NOA).

/* ----------------------------------------------------------------- */

/* checking if all arguments of compound term are equal */

all_n_equal(_,_,N) :- N = 0, !.
all_n_equal(A,B,N) :- arg(N,A,ArgA), arg(N,B,ArgB), 
                      equal(ArgA,ArgB), 
                      N1 is N-1, all_n_equal(A,B,N1).

/* ----------------------------------------------------------------- */

/* checking if two terms are equal with regard to definitions and lemmas
   examples: equal(centroid([a,c],b),centroid([a,b],c)) */
equal_def_lemma(A,B,_)              :- non_compound(A), 
                                       A = B, !.
equal_def_lemma(A,B,_)              :- non_compound(B), 
                                       A = B, !.
equal_def_lemma([H|T],[H1|T1],Perm) :- !, mysublist_def_lemma([H|T],[H1|T1],Perm), 
                                       mysublist_def_lemma_inv([H1|T1],[H|T],Perm).
equal_def_lemma(A,B,Perm)           :- equal_points(A,B,Perm). 
                                       /* ZA SAD SU U POSTAVCI ZADATAKA SAMO TACKE, PA JE OVO OK */

/* ----------------------------------------------------------------- */

/* checking if all arguments of compound term are equal */
all_n_equal_def_lemma(_,_,N,_)    :- N = 0, !.
all_n_equal_def_lemma(A,B,N,Perm) :- arg(N,A,ArgA), arg(N,B,ArgB), 
                                     equal_def_lemma(ArgA,ArgB,Perm), 
                                     N1 is N-1, all_n_equal_def_lemma(A,B,N1,Perm).

/* ----------------------------------------------------------------- */

/* checking if two terms are different */
notequal(A,B) :- equal(A,B), !, fail.
notequal(_,_).

/* ----------------------------------------------------------------- */

/* checking if two terms are different */
notequal_def(A,B,Perm) :- equal_def(A,B,Perm), !, fail.
notequal_def(_,_,_).

/* ----------------------------------------------------------------- */

/* collecting all lines equal to the given one */
all_equal_lines(L,All,All1) :- equal_lines(L,L1), not_element(obj(line,L1),All), !,
                               /* write('DODAJEMO PRAVU '), write(L1), nl, */
                               all_equal_lines(L,[obj(line,L1)|All],All1).
all_equal_lines(_,All,All). 

/* ----------------------------------------------------------------- */

/* collecting all circles equal to the given one */
all_equal_circles(L,All,All1) :- equal_circles(L,L1), not_element(obj(circle,L1),All), !,
                                 /* write('DODAJEMO KRUG '), write(L1), nl, */
                                 all_equal_circles(L,[obj(circle,L1)|All],All1).
all_equal_circles(_,All,All). 

/* --------------------------------------------------------y--------- */

/* collecting all lines and circles through the given point */
lines_and_circles_through_point(X,Objs,Objs1) :- def_or_lemma(inc(X,P),_), not_element(obj(line,P),Objs), !,
                                                 /* write('POZIVAMO ALL EQUAL LINES ZA PRAVU '), write(P), nl, */
                                                 all_equal_lines(P,[],Lines), myunion(Lines,Objs,All),
                                                 /* write('PRAVI SE UNIJA: '), write(All), nl, */
                                                 lines_and_circles_through_point(X,All,Objs1).
lines_and_circles_through_point(X,Objs,Objs1) :- def_or_lemma(inc_k(X,C),_), not_element(obj(circle,C),Objs), !,
                                                 /* write('POZIVAMO ALL EQUAL CIRCLES ZA KRUG '), write(C), nl, */
                                                 all_equal_circles(C,[],Circles), myunion(Circles,Objs,All),
                                                 /* write('PRAVI SE UNIJA: '), write(All), nl, */
                                                 lines_and_circles_through_point(X,All,Objs1).
lines_and_circles_through_point(_,Objs,Objs) :- !.

/* ----------------------------------------------------------------- */

/* checking if a problem is locus-dependent */
locus_dependent_problem(N,RulesUsed,LemmasUsed) :- problem_setting(N,Name,Known,Unknown),
                              ld_triple(N,Name,Known,Unknown,RulesUsed,LemmasUsed).
                              
ld_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se ld_triple za: '), write(X), nl, 
                                /*X=obj(point,XN),
                                lines_and_circles_through_point(XN,[],All),*/
                                construct2([Y,Z],X,Name,N,Unknown,RulesUsed,LemmasUsed), 
                                !.

ld_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se ld_triple za: '), write(Y), nl,
                                /*Y=obj(point,YN),
                                lines_and_circles_through_point(YN,[],All),*/
                                construct2([X,Z],Y,Name,N,Unknown,RulesUsed,LemmasUsed), 
                                !.

ld_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se ld_triple za: '), write(Z), nl,
                                /*Z=obj(point,ZN), 
                                lines_and_circles_through_point(ZN,[],All),*/
                                construct2([X,Y],Z,Name,N,Unknown,RulesUsed,LemmasUsed), 
                                !.

/* ----------------------------------------------------------------- */

/* checking if a problem is redundant */
redundant_problem(N,RulesUsed,LemmasUsed) :- problem_setting(N,Name,Known,Unknown), 
                        redundant_triple(N,Name,Known,Unknown,RulesUsed,LemmasUsed).

/* checking if a triple is redundant -- if one of the elements is constructible from the others */
redundant_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se redundant_triple za: '), write(X), nl,
                                       construct1([Y,Z],[X],Name,N,Unknown,RulesUsed,LemmasUsed), !.
redundant_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se redundant_triple za: '), write(Y), nl,
                                       construct1([X,Z],[Y],Name,N,Unknown,RulesUsed,LemmasUsed), !.
redundant_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se redundant_triple za: '), write(Z), nl,
                                       construct1([X,Y],[Z],Name,N,Unknown,RulesUsed,LemmasUsed), !.

/* ----------------------------------------------------------------- */

/* checking if problem is not symmetric */
not_symmetric(N) :- symmetric(N), !, fail.
not_symmetric(_).

/* ----------------------------------------------------------------- */

/* checking if a problem is symmetric to some previous */
/* we compare a problem only to the problems from the corpora it belongs to  */
symmetric_problem(N,Stream) :- N>2000, !, /*write('pokusavamo za: '), flush, */ symmetric_problems(N,2001,Stream). 
symmetric_problem(N,Stream) :- N>1000, N<2000, !, /*write('pokusavamo za: '), flush,*/ symmetric_problems(N,1001,Stream). 
symmetric_problem(N,Stream) :- N<1000, !, /*write('pokusavamo za: '), flush,*/ symmetric_problems(N,1,Stream). 

/* ----------------------------------------------------------------- */

symmetric_problems(N,M,_)      :- N==M, !.
symmetric_problems(N,M,Stream) :- not_symmetric(M), /* there is no point in finding symmetric problems to already symmetric ones */
                                  problem_setting(N,_,NKnown,_), 
                                  problem_setting(M,_,MKnown,_),
                                  without_type(NKnown,NObj),
                                  without_type(MKnown,MObj),
                                  permutation(Perm), 
                                  substitute(NObj,Perm,NNew),
                                  equal_ld(NNew,MObj,Perm,Stream), 
                                  !, 
                                  assert(symmetric(N)),
                                  write('to the problem '), write(M),
                                  write(Stream,'('), write(Stream,M), write(Stream,')$) '),
                                  write(' for the permutation '), write(Perm), nl.
symmetric_problems(N,M,Stream) :- /*write(M), write(' '), flush,*/
                                  M1 is M+1, symmetric_problems(N,M1,Stream).

/* ----------------------------------------------------------------- */

/* equality regarding definitions only, or both definitions and lemmas */
equal_ld(L1,L2,_,Stream)    :- equal(L1,L2), 
                               write('Symmetric with regard to definitions only '), 
                               tab(Stream,3),
                               write(Stream,'($S_d'), !.
equal_ld(L1,L2,Perm,Stream) :- equal_def_lemma(L1,L2,Perm), 
                               write('Symmetric with regard to definitions and lemmas '), 
                               tab(Stream,3),
                               write(Stream,'($S_{dl}'), !.

/* ----------------------------------------------------------------- */

/* two points are equal if they belong to two same lines */
equal_points(A,B,Perm) :- def_or_lemma_perm(inc(A,L1),Perm),
                          def_or_lemma(inc(B,L2),_), 
                          equal(L1,L2),   
                          def_or_lemma_perm(inc(A,L3),Perm), 
                          notequal(L1,L3),
                          /*notequal(L2,L3),*/ 
                          not_equal_lines(L1,L3),
                          /*not_equal_lines(L2,L3),*/
                          def_or_lemma(inc(B,L4),_),
                          equal(L3,L4),
                          notequal(L1,L4),
                          not_equal_lines(L1,L4),
                          notequal(L2,L4),
                          not_equal_lines(L2,L4),
                          !.

/* ----------------------------------------------------------------- */

/* definition or a lemma with applied permutation */
def_or_lemma_perm(PropPerm,Perm) :- def_or_lemma(Prop,_), substitute(Prop,Perm,PropPerm).

/* ----------------------------------------------------------------- */

/* list of objects given without their types */
without_type([],[]) :- !.
without_type([obj(_,X)|T],[X|T1]) :- without_type(T,T1).

/* ----------------------------------------------------------------- */

/* all possible permutations of a triple [a b c] */
permutation([a,c,b]).
permutation([b,a,c]).
permutation([b,c,a]).
permutation([c,a,b]).
permutation([c,b,a]).

inverse_permutation([a,c,b],[a,c,b]) :- !.
inverse_permutation([b,a,c],[b,a,c]) :- !.
inverse_permutation([b,c,a],[c,a,b]) :- !.
inverse_permutation([c,a,b],[b,c,a]) :- !.
inverse_permutation([c,b,a],[c,b,a]) :- !.

/* ----------------------------------------------------------------- */

/* substitution in a given term using a permutation of [a,b,c] (given as a second argument of a predicate) */
substitute([],_,[])         :- !.
substitute(a,[A,_,_],A)     :- !.
substitute(b,[_,B,_],B)     :- !.
substitute(c,[_,_,C],C)     :- !.
substitute([H|T],L,[H1|T1]) :- !, substitute(H,L,H1), substitute(T,L,T1). 
substitute(X,L,Y)           :- compound(X), !, functor(X,FX,NOX), functor(Y,FX,NOX), substitute_n(X,L,Y,NOX).

/* ----------------------------------------------------------------- */

substitute_n(_,_,_,N) :- N = 0, !.
substitute_n(A,L,B,N) :- arg(N,A,ArgA),  
                         substitute(ArgA,L,ArgB), 
                         arg(N,B,ArgB),
                         N1 is N-1, substitute_n(A,L,B,N1).

/* ----------------------------------------------------------------- */

print_list_to_stdout([])    :- !.
print_list_to_stdout([H|T]) :- write(H), nl, print_list_to_stdout(T).
