/* points which are necessarily distinct; proved using OGP */
/* OVO SE JOS UVEK NIGDE NE KORISTI*/
not_identical_p([a,b]).
not_identical_p([a,c]).
not_identical_p([b,c]).

not_identical_p([a,midpoint([b,c])]).
not_identical_p([b,midpoint([a,c])]).
not_identical_p([c,midpoint([a,b])]).

not_identical_p([a,midpoint([a,b])]).
not_identical_p([a,midpoint([a,c])]).
not_identical_p([b,midpoint([b,c])]).
not_identical_p([b,midpoint([a,b])]).
not_identical_p([c,midpoint([b,c])]).
not_identical_p([c,midpoint([a,c])]).

not_identical_p([midpoint([a,b]),midpoint([b,c])]).
not_identical_p([midpoint([a,b]),midpoint([a,c])]).
not_identical_p([midpoint([a,c]),midpoint([b,c])]).

not_identical_p([a,centroid([a,b],c)]).
not_identical_p([b,centroid([a,b],c)]).
not_identical_p([c,centroid([a,b],c)]).

not_identical_p([midpoint([a,b]),centroid([a,b],c)]).
not_identical_p([midpoint([a,c]),centroid([a,b],c)]).
not_identical_p([midpoint([b,c]),centroid([a,b],c)]).

not_identical_p([a,circumcenter([a,b],c)]).
not_identical_p([b,circumcenter([a,b],c)]).
not_identical_p([c,circumcenter([a,b],c)]).

not_identical_p([a,foot(a,[b,c])]).
not_identical_p([b,foot(b,[a,c])]).
not_identical_p([c,foot(c,[a,b])]).

not_identical_p([midpoint([a,c]),foot(a,[b,c])]).
not_identical_p([midpoint([a,b]),foot(a,[b,c])]).
not_identical_p([midpoint([b,c]),foot(b,[a,c])]).
not_identical_p([midpoint([a,b]),foot(b,[a,c])]).
not_identical_p([midpoint([a,c]),foot(c,[a,b])]).
not_identical_p([midpoint([b,c]),foot(c,[a,b])]).

not_identical_p([centroid([a,b],c),foot(a,[b,c])]).
not_identical_p([centroid([a,b],c),foot(b,[a,c])]).
not_identical_p([centroid([a,b],c),foot(c,[a,b])]).

not_identical_p([midpoint([a,c]),orthocenter([a,b],c)]).
not_identical_p([midpoint([b,c]),orthocenter([a,b],c)]).
not_identical_p([midpoint([a,b]),orthocenter([a,b],c)]).

not_identical_p([a,angle_bis_foot(a,[b,c])]).
not_identical_p([b,angle_bis_foot(a,[b,c])]).
not_identical_p([c,angle_bis_foot(a,[b,c])]).
not_identical_p([a,angle_bis_foot(b,[a,c])]).
not_identical_p([b,angle_bis_foot(b,[a,c])]).
not_identical_p([c,angle_bis_foot(b,[a,c])]).
not_identical_p([a,angle_bis_foot(c,[a,b])]).
not_identical_p([b,angle_bis_foot(c,[a,b])]).
not_identical_p([c,angle_bis_foot(c,[a,b])]).

not_identical_p([midpoint([a,c]),angle_bis_foot(a,[b,c])]).
not_identical_p([midpoint([a,b]),angle_bis_foot(a,[b,c])]).
not_identical_p([midpoint([b,c]),angle_bis_foot(b,[a,c])]).
not_identical_p([midpoint([a,b]),angle_bis_foot(b,[a,c])]).
not_identical_p([midpoint([a,c]),angle_bis_foot(c,[a,b])]).
not_identical_p([midpoint([b,c]),angle_bis_foot(c,[a,b])]).

not_identical_p([centroid([a,b],c),angle_bis_foot(a,[b,c])]).
not_identical_p([centroid([a,b],c),angle_bis_foot(b,[a,c])]).
not_identical_p([centroid([a,b],c),angle_bis_foot(c,[a,b])]).

not_identical_p([foot(b,[a,c]),angle_bis_foot(a,[b,c])]).
not_identical_p([foot(c,[a,b]),angle_bis_foot(a,[b,c])]).
not_identical_p([foot(a,[b,c]),angle_bis_foot(b,[a,c])]).
not_identical_p([foot(c,[a,b]),angle_bis_foot(b,[a,c])]).
not_identical_p([foot(b,[a,c]),angle_bis_foot(c,[a,b])]).
not_identical_p([foot(a,[b,c]),angle_bis_foot(c,[a,b])]).

not_identical_p([angle_bis_foot(a,[b,c]),orthocenter([a,b],c)]).
not_identical_p([angle_bis_foot(b,[a,c]),orthocenter([a,b],c)]).
not_identical_p([angle_bis_foot(c,[a,b]),orthocenter([a,b],c)]).

not_identical_p([angle_bis_foot(a,[b,c]),angle_bis_foot(b,[a,c])]).
not_identical_p([angle_bis_foot(b,[a,c]),angle_bis_foot(c,[a,b])]).
not_identical_p([angle_bis_foot(a,[b,c]),angle_bis_foot(c,[a,b])]).

not_identical_p([a,incenter([a,b],c)]).
not_identical_p([b,incenter([a,b],c)]).
not_identical_p([c,incenter([a,b],c)]).

not_identical_p([midpoint([b,c]),incenter([a,b],c)]).
not_identical_p([midpoint([a,c]),incenter([a,b],c)]).
not_identical_p([midpoint([a,b]),incenter([a,b],c)]).

not_identical_p([foot(a,[b,c]),incenter([a,b],c)]).
not_identical_p([foot(b,[a,c]),incenter([a,b],c)]).
not_identical_p([foot(c,[a,b]),incenter([a,b],c)]).

not_identical_p([angle_bis_foot(a,[b,c]),incenter([a,b],c)]).
not_identical_p([angle_bis_foot(b,[a,c]),incenter([a,b],c)]).
not_identical_p([angle_bis_foot(c,[a,b]),incenter([a,b],c)]).

/*---------------------------------------------------------------*/

/* generation of theorem file needed for ArgoCLP */
print_argoclp_theorem_file(Trace_simp,Known,Name,Stream) :-
         all_objects_used(Known,Trace_simp,Objects,[],PropsPremises),
         write('Objects:'), write(Objects), nl,
         write('PropsPremises:'), write(PropsPremises), nl,
         enumerate(Objects,EnumList,1),
         write('EnumList:'), write(EnumList), nl,
         add_premises_to_theorem_file(Known,Name,PropsPremises,EnumList,Stream),
         add_steps_to_theorem_file(Trace_simp,PropsPremises,Known,EnumList,Stream).

/*---------------------------------------------------------------*/

/* calculating the set of values and constructed objects; 
   also deciding which properties should go into the set
   of premises of the theorem file */
all_objects_used(Objects,[],Objects,PropsPremises,PropsPremises) :- !.
all_objects_used(Objects,[(_,Values,ObjsConstr,Props,NDG,_,_,_)|T],Objects1,PropsPrem,PropsPrem1) :-
                        myunion(Objects,Values,ObjectsA),
                        myunion(ObjectsA,ObjsConstr,ObjectsNew),
                        myunion(Props,NDG,AllProps),
                        without_type(ObjsConstr,ObjsConstr1), 
                        divide_props(AllProps,ListPrem,_,ObjsConstr1),
                        write('ObjsConstr1: '), write(ObjsConstr1), nl,
                        write('AllProps: '), write(AllProps), nl,
                        write('ListPrem: '), write(ListPrem), nl, nl, nl,
                        myunion(PropsPrem,ListPrem,PropsPremNew),
                        all_objects_used(ObjectsNew,T,Objects1,PropsPremNew,PropsPrem1), !.

/*---------------------------------------------------------------*/
           
/* printing premises of the theorem into the file */
add_premises_to_theorem_file(Known,Name,PropsPremises,EnumList,Stream) :- 
                                              myunion(Known,PropsPremises,Props),
                                              translate_to_argoclp(Props,EnumList,Premises),
                                              nl(Stream), 
                                              write(Stream,'premises'), nl(Stream),
                                              write(Stream,'# theorem'), write(Stream,Name), 
                                              nl(Stream), nl(Stream),
                                              write_list_to_stream(Stream,Premises),
                                              nl(Stream),
                                              write(Stream,'conclusions'), nl(Stream), nl(Stream), !.
                                                     
/*---------------------------------------------------------------*/
 
/* printing the conclusion of the theorem into the file */
add_steps_to_theorem_file([],_,_,_,_) :- !.
add_steps_to_theorem_file([H|T],PropsPremises,Known,EnumList,Stream) :- add_step_to_theorem_file(H,PropsPremises,Known,EnumList,Stream),
                                  add_steps_to_theorem_file(T,PropsPremises,Known,EnumList,Stream).

/*---------------------------------------------------------------*/

/* printing one step of the construction into the conclusion of the theorem */
add_step_to_theorem_file((_,Values,ObjsConstr,Props,NDG,_,_,_),PropsPremises,_,EnumList,Stream) :- 
                       myunion(Values,ObjsConstr,AllObjs1),
                       myunion(Props,NDG,Props1),
                       not_in_list(Props1,PropsPremises,Props2),
                       myunion(AllObjs1,Props2,AllProps),
                       translate_to_argoclp(AllProps,EnumList,Conclusions),
                       write_list_to_stream(Stream,Conclusions),
                       !.
                       
/*---------------------------------------------------------------*/

/* FJE ZA TESTIRANJE */
print_axioms(RulesUsed,Name) :- generate_all_argoclp_axioms([]),
                                nl, nl,
                                write('GOTOVO GENERISANJE AKSIOMA!'),
                                nl, nl,
                                output_argoclp_axioms_file_name(Name,File3), nl, 
                                open(File3,write,Stream3),
                                print_argoclp_axioms_file(RulesUsed,Stream3),
                                close(Stream3).

print_theorem_premises(Known,Name) :- output_argoclp_theorem_file_name(Name,File),  
                                      open(File,write,Stream),
                                      all_objects_used(Known,[([obj(point,a),obj(point,orthocenter([a,b],c))],[],
                                                        [obj(line,altitude(a,[b,c]))],
                                                        [not_equal_point(a,orthocenter([a,b],c)),
                                                        inc(a,altitude(a,[b,c])),inc(orthocenter([a,b],c),altitude(a,[b,c]))],
                                                        [not_true(identical_points(a,orthocenter([a,b],c)))],[],[],[]),
                                                        ([obj(point,a),obj(line,altitude(a,[b,c]))],[],
                                                        [obj(line,line([b,c]))], [perp(line([b,c]),altitude(a,[b,c])),inc(a,line([b,c]))],
                                                        [],[],[],[]),
                                                        ([obj(point,b),obj(point,orthocenter([a,b],c))],[],
                                                        [obj(line,altitude(b,[a,c]))], [inc(b,altitude(b,[a,c])),inc(orthocenter([a,b],c),altitude(b,[a,c]))],
                                                        [not_equal_point(b,orthocenter([a,b],c)),not_true(identical_points(b,orthocenter([a,b],c)))],[],[],[])],
                                                        Objects,[],PropsPrem),
                                                        write('Objects: '), write(Objects), nl,
                                                        write('PropsPrem: '), write(PropsPrem), nl,
                                                        enumerate(Objects,EnumList,1),
                                                        write('Enumlist: '), write(EnumList), nl,
                                      add_premises_to_theorem_file(Known,Name,PropsPrem,EnumList,Stream),
                                      add_steps_to_theorem_file([([obj(point,a),obj(point,orthocenter([a,b],c))],[],
                                                                  [obj(line,altitude(a,[b,c]))],
                                                                  [inc(a,altitude(a,[b,c])),inc(orthocenter([a,b],c),altitude(a,[b,c]))],
                                                                  [not_true(identical_points(a,orthocenter([a,b],c)))],[],[],[]),
                                                                  ([obj(point,a),obj(line,altitude(a,[b,c]))],[],
                                                                  [obj(line,line([b,c]))],[perp(line([b,c]),altitude(a,[b,c]))],
                                                                  [],[],[],[]),
                                                                  ([obj(point,b),obj(point,orthocenter([a,b],c))],[],
                                                                  [obj(line,altitude(b,[a,c]))], [inc(b,altitude(b,[a,c])),inc(orthocenter([a,b],c),altitude(b,[a,c]))],
                                                                  [not_equal_point(b,orthocenter([a,b],c)),not_true(identical_points(b,orthocenter([a,b],c)))],[],[],[])],
                                                                  PropsPrem,Known,EnumList,Stream),
                                      close(Stream).

/*---------------------------------------------------------------*/

/* generation of axioms file needed for ArgoCLP */
print_argoclp_axioms_file(RulesUsed,Stream) :- add_axioms_to_file(Stream,RulesUsed).

/*---------------------------------------------------------------*/

/* adding axioms to the axiom file */                                    
add_axioms_to_file(_,[]) :- !.
add_axioms_to_file(Stream,[H|T]) :- write('PRAVILO:'), write(H), nl, add_axiom_to_file(Stream,H), 
                                  add_axioms_to_file(Stream,T).

/*---------------------------------------------------------------*/

/* adding one axiom to the axiom file */
add_axiom_to_file(Stream,RuleId) :- argoclp_ax(RuleId,Premises,Conclusion),
                                  write('nasao '), write(RuleId), nl,
                                  add_argoclp_ax(Stream,RuleId,Premises,Conclusion).

/*---------------------------------------------------------------*/

/* printng one axiom to the the axiom file*/
add_argoclp_ax(Stream,RuleId,Premises,Conclusion) :- nl(Stream), 
                                                     write(Stream,'premises'), nl(Stream),
                                                     write(Stream,'#'), write(Stream,RuleId), 
                                                     nl(Stream), nl(Stream),
                                                     write_list_to_stream(Stream,Premises),
                                                     nl(Stream),
                                                     write(Stream,'conclusions'), nl(Stream),
                                                     nl(Stream),
                                                     write_list_to_stream(Stream,Conclusion),
                                                     nl(Stream), nl(Stream).

/*---------------------------------------------------------------*/
                                          
/* writing list of argoclp steps to the file */           
write_list_to_stream(_,[]) :- !.
write_list_to_stream(Stream,[H|T]) :- write(Stream,H), nl(Stream), 
                                      write_list_to_stream(Stream,T).

/*---------------------------------------------------------------*/

/* function for translating all construction rules into axioms in ArgoCLP */
/* this should be done only once */
generate_all_argoclp_axioms(_)       :- a, !.
generate_all_argoclp_axioms(RuleIds) :- generate_argoclp_axiom(RuleId,Premises,Conclusion),
                                        not_element(RuleId,RuleIds), !,
                                        assert(argoclp_ax(RuleId,Premises,Conclusion)),
                                        /*provera*/
                                        write(argoclp_ax(RuleId,Premises,Conclusion)), nl,
                                        generate_all_argoclp_axioms([RuleId|RuleIds]),
                                        assert(a).
generate_all_argoclp_axioms(_) :- !.

/*---------------------------------------------------------------*/

/* ovde treba dodati da se generisu aksiome i za wonline i woncircle i free.. ne znam kako */
generate_argoclp_axiom(RuleId,Premises,Conclusion) :- basic_cons(Obj_known,Numbers,Obj_constr,Props,NDGs,_,RuleId),
                                                      /*write('Props '), write(Props), nl,*/
                                                      translate_names(Obj_known,Obj_known1),
                                                      write('Obj_known: '), write(Obj_known), nl, 
                                                      write('Obj_known1: '), write(Obj_known1), nl,
                                                      translate_names(Numbers,Numbers1),
                                                      write('Numbers: '), write(Numbers), nl,
                                                      write('Numbers1: '), write(Numbers1), nl,
                                                      translate_names(Obj_constr,Obj_constr1),
                                                      
                                                      write('Obj_constr1: '), write(Obj_constr1), nl,
                                                      myunion(Obj_known1,Numbers1,Obj_known2),
                                                      /*write('Obj_known2: '), write(Obj_known2), nl,*/
                                                      myunion(Obj_known2,Obj_constr1,Objs1),
                                                      /*write('Objs1: '), write(Objs1), nl,*/
                                                      enumerate(Objs1,EnumList,1),
                                                      /*write('EnumList: '), write(EnumList), nl,*/
                                                      write('Props '), write(Props), nl,
                                                      translate_names(Props,Props1), nl,
                                                      write('Props1 '), write(Props1), nl, 
                                                      write('NDGs '), write(NDGs), nl, 
                                                      translate_names(NDGs,NDGs1), nl, 
                                                      write('NDGs1 '), write(NDGs1), nl, 
                                                      without_type(Obj_constr1,Obj_constr2), nl,
                                                      /*write('Obj_constr1 '), write(Obj_constr1), nl, 
                                                      write('Obj_constr2 '), write(Obj_constr2), nl, */
                                                      divide_props(Props1,ListPrem,ListConcl,Obj_constr2),
                                                      /*write('Objs in premises '), write(ListPrem), nl,
                                                      write('Objs in conclusions '), write(ListConcl), nl,*/
                                                      myunion(Obj_known2,ListPrem,P),
                                                      myunion(P,NDGs1,P1),
                                                      nl, write('P1: '), write(P1), nl,
                                                      /*write('P1 '), write(P1), nl,*/
                                                      myunion(Obj_constr1,ListConcl,C),
                                                      nl, write('C: '), write(C), nl,
                                                      /*write('C '), write(C), nl,*/
                                                      translate_to_argoclp(P1,EnumList,Premises),
                                                      write('prosao za premises: '), write(Premises), nl,
                                                      translate_to_argoclp(C,EnumList,Conclusion),
                                                      write('prosao za conclusion: '), write(Conclusion), nl.

/*---------------------------------------------------------------*/

/* dividing properties into once that go to the set of premises
   and the others that go to the set of conclusions */
divide_props([],[],[],_) :- !.
divide_props([H|T],ListPrem,[H|T1],Obj_constr) :- functor(H,_,Arity), 
                                                  element_of_list(H,Arity,Obj_constr,1), !,
                                                  divide_props(T,ListPrem,T1,Obj_constr).
divide_props([H|T],[H|T1],ListConcl,Obj_constr) :- divide_props(T,T1,ListConcl,Obj_constr).
  
element_of_list(_,Arity,_,N)              :- N>Arity, !, fail.
/*element_of_list(H,_,ListOfObjs,N)         :- arg(N,H,HN), compound(HN), !,  
                                             functor(HN,_,Arity1), element_of_list(HN,Arity1,ListOfObjs,1).*/
element_of_list(H,_,ListOfObjs,N)         :- arg(N,H,HN),  
                                             element(HN,ListOfObjs).
element_of_list(H,Arity,ListOfObjs,N)     :- N1 is N+1, element_of_list(H,Arity,ListOfObjs,N1).

/*---------------------------------------------------------------*/

/* translation of variable names into the corresponding names */
translate_names([],[]) :- !.
translate_names([obj(Type,P)|T],[obj(Type,H1)|T1]) :- !, write('AAAAA:'), write(Type), write(P), write(H1), obj_name(obj(_,P),H1), translate_names(T,T1).
translate_names([not_true(H)|T],[H1|T1]) :- !, functor(H,Name,Arity), argument_names(H,Arity,1,[],List),
                                            atom_concat('~',Name,Name1), nl, nl, 
                                            H1=..[Name1|List], 
                                            translate_names(T,T1).
translate_names([H|T],[H1|T1]) :- functor(H,Name,Arity),  
                                  write('Pozivamo argument names za: '), write(H), nl, 
                                  argument_names(H,Arity,1,[],List), nl, nl,
                                  write('POZIVAMOOOOOOO ZA: '), write(Name), nl, nl,
                                  string_concat('not_',Name1,Name), !,
                                  write('Staro ime: '), write(Name),
                                  atom_concat('~',Name1,Name2),
                                  write('Novo ime: '), write(Name2), nl,
                                  H1=..[Name2|List],                            
                                  translate_names(T,T1).
translate_names([H|T],[H1|T1]) :- functor(H,Name,Arity), 
                                  write('Pozivamo argument names za: '), write(H), nl, 
                                  argument_names(H,Arity,1,[],List),
                                  H1=..[Name|List],                            
                                  translate_names(T,T1).

argument_names(_,Arity,N,List,List) :- N>Arity, !.
/*argument_names(H,Arity,N,List,List1) :- arg(N,H,HN), obj_name(obj(_,HN),Name), N1 is N+1, myappend(List,[Name],List2), argument_names(H,Arity,N1,List2,List1).
*/
argument_names(H,Arity,N,List,List1) :- arg(N,H,HN), nl, write('1:'), write(HN), compound(HN), !, translate_names([HN],[Name]), write('prosao 1 '), write(Name), N1 is N+1, myappend(List,[Name],List2), argument_names(H,Arity,N1,List2,List1).
argument_names(H,Arity,N,List,List1) :- arg(N,H,HN), nl, write('2:'), write(HN), translate_names([obj(_,HN)],[obj(_,Name)]), write('prosao 2 '), write(Name), N1 is N+1, myappend(List,[Name],List2), argument_names(H,Arity,N1,List2,List1).

/*---------------------------------------------------------------*/

/* enumeration of the given list of objects according to their order in the list */
enumerate([],[],_) :- !.
enumerate([H|T],[(H,N)|T1],N) :- N1 is N+1, enumerate(T,T1,N1). 

/*---------------------------------------------------------------*/

/* translation of the declaration of the list of objects in prolog into a list 
   of declarations of the objects in ArgoCLP */
translate_to_argoclp([],_,[]) :- !.
translate_to_argoclp([H|T],EnumList,[Prem|Prems]) :- nl, nl, nl, write('PREVODIMO H:'), write(H), nl, 
                                                     translate_one_to_argoclp(H,EnumList,Prem), 
                                                     translate_to_argoclp(T,EnumList,Prems).

/*---------------------------------------------------------------*/

/* translation of the declaration of the object in prolog into a declaration of the object in ArgoCLP */
translate_one_to_argoclp(obj(Type,Name),EnumList,O) :- !, num(obj(Type,Name),EnumList,Num), 
                                                       string_concat(Type,'(',P1),
                                                       string_concat(P1,Num,P2),
                                                       string_concat(P2,')',O),
                                                       write('O:'), write(O).

translate_one_to_argoclp(not_true(H),EnumList,O) :- !, functor(H,Name,Arity),
                                          arg_nums_list(H,Arity,1,EnumList,[],Args),
                                          write('Args:'), write(Args), nl,
                                          list_to_string(Args,String),
                                          string_concat('~',Name,P0),
                                          string_concat(P0,'(',P1),
                                          string_concat(P1,String,P2),
                                          string_concat(P2,')',O).

translate_one_to_argoclp(H,EnumList,O) :- functor(H,Name,Arity),
                                          string_concat('not_',Name1,Name), !,
                                          arg_nums_list(H,Arity,1,EnumList,[],Args),
                                          write('Args:'), write(Args), nl,
                                          list_to_string(Args,String),
                                          string_concat('~',Name1,P0),
                                          string_concat(P0,'(',P1),
                                          string_concat(P1,String,P2),
                                          string_concat(P2,')',O).


translate_one_to_argoclp(H,EnumList,O) :- functor(H,Name,Arity),
                                          arg_nums_list(H,Arity,1,EnumList,[],Args),
                                          write('Args:'), write(Args), nl,
                                          list_to_string(Args,String),
                                          string_concat(Name,'(',P1),
                                          string_concat(P1,String,P2),
                                          string_concat(P2,')',O).

arg_nums_list(_,Arity,N,_,Args,Args)  :- N>Arity, !.

/* NE VALJA ZBOG NPR INC(FOOT(A,[B,C]),P)... */
/* SAD NECE RADITI UMETNUTI PREDIKAT, ALI TO IONAKO MORA DA SE NEKAKO PREZAPISE */
/*arg_nums_list(H,Arity,N,EnumList,Args,Args1) :- arg(N,H,HN), write('HN1:'), write(HN), compound(HN), !, write('jeste slozen'), nl,
                                                translate_one_to_argoclp(HN,EnumList,Num1),
                                                N1 is N+1, myunion(Args,[Num1],ArgsNew), arg_nums_list(H,Arity,N1,EnumList,ArgsNew,Args1).*/

arg_nums_list(H,Arity,N,EnumList,Args,Args1) :- write(H), arg(N,H,HN), write('  HN2:'), write(HN), 
                                                write('EnumList:'), write(EnumList), 
                                                num(obj(_,HN),EnumList,Num1), write('uspeo num: '), write(Num1), 
                                                N1 is N+1, myunion(Args,[Num1],ArgsNew), arg_nums_list(H,Arity,N1,EnumList,ArgsNew,Args1).


list_to_string([],'') :- !.
list_to_string([H],H) :- !.
list_to_string([H|T],A) :- string_concat(H,',',P1), list_to_string(T,P2), string_concat(P1,P2,A). 
 
/*---------------------------------------------------------------*/

/* returns the ordinal of the given object in the given list of pairs */
num(Name,[(Name,Num)|_],Num) :- !.
num(Name,[_|T],Num) :- num(Name,T,Num).
