/* ----------------------------------------------------------------- */

/* adding underline sign before object name, except for the triangle verices */
underline_name('A','A')    :- !.
underline_name('B','B')    :- !.
underline_name('C','C')    :- !.
underline_name(Name,Name1) :- atom_concat('\\_',Name,Name1).

/* ----------------------------------------------------------------- */

/* generation of all gclc definitions, based upon prolog definitions 
  this is performed exactly once, at the begining of the proving process */
generate_all_gclc_definitions(_)    :- q, !.
generate_all_gclc_definitions(Defs) :- /*write('pokusavamo za P: '),*/
                                       generate_gclc_definitions(P,Def),
                                       not_element(P,Defs), !,
                                       /*write('prosla definicija'),*/
                                       assert(gclc_def(P,Def)),
                                       /* provera */
                                       write(gclc_def(P,Def)), nl,
                                       generate_all_gclc_definitions([P|Defs]),
                                       assert(q).
generate_all_gclc_definitions(_) :- !.

/* ----------------------------------------------------------------- */

/* generation of one gclc definition; it differs for each type of definition */
generate_gclc_definitions(P,Def) :- def(P,[inc(A,P),inc(B,P)],_),
                                    obj_name(obj(line,P),PN), underline_name(PN,PU),
                                    obj_name(obj(point,A),AN), underline_name(AN,AU), 
                                    obj_name(obj(point,B),BN), underline_name(BN,BU),
                                    atom_concat('line ',PU,R1),
                                    atom_concat(R1,' ',R2),
                                    atom_concat(R2,AU,R3),
                                    atom_concat(R3,' ',R4),
                                    atom_concat(R4,BU,Def).
generate_gclc_definitions(A,Def) :- def(A,[inc(A,P),inc(A,Q)],_),
                                    obj_name(obj(line,P),PN), underline_name(PN,PU),
                                    obj_name(obj(point,A),AN), underline_name(AN,AU), 
                                    obj_name(obj(line,Q),QN), underline_name(QN,QU),
                                    atom_concat('intersec ',AU,R1),
                                    atom_concat(R1,' ',R2),
                                    atom_concat(R2,PU,R3),
                                    atom_concat(R3,' ',R4),
                                    atom_concat(R4,QU,Def).
generate_gclc_definitions(C,Def) :- def(C,[center(O,C),inc_k(A,C)],_), 
                                    obj_name(obj(point,O),ON), underline_name(ON,OU),
                                    obj_name(obj(point,A),AN), underline_name(AN,AU), 
                                    obj_name(obj(circle,C),CN), underline_name(CN,CU),
                                    atom_concat('circle ',CU,R1),
                                    atom_concat(R1,' ',R2),
                                    atom_concat(R2,OU,R3),
                                    atom_concat(R3,' ',R4),
                                    atom_concat(R4,AU,Def).
generate_gclc_definitions(Y,Def) :- def(Y,[sratio(X,Y,X,Z,K,L)],_),
                                    obj_name(obj(point,X),XN), underline_name(XN,XU),
                                    obj_name(obj(point,Y),YN), underline_name(YN,YU), 
                                    obj_name(obj(point,Z),ZN), underline_name(ZN,ZU),
                                    C is K/L, 
                                    atom_concat('towards ',YU,R1),
                                    atom_concat(R1,' ',R2),
                                    atom_concat(R2,XU,R3),
                                    atom_concat(R3,' ',R4),
                                    atom_concat(R4,ZU,R5),
                                    atom_concat(R5,' ',R6),
                                    atom_concat(R6,C,Def).
generate_gclc_definitions(P,Def) :- def(P,L,_), 
                                    equal(L,[inc(X,P),perp(P,Q)]),
                                    obj_name(obj(point,X),XN), underline_name(XN,XU),
                                    obj_name(obj(line,P),PN), underline_name(PN,PU), 
                                    obj_name(obj(line,Q),QN), underline_name(QN,QU),
                                    atom_concat('perp ',PU,R1),
                                    atom_concat(R1,' ',R2),
                                    atom_concat(R2,XU,R3),
                                    atom_concat(R3,' ',R4),
                                    atom_concat(R4,QU,Def).
generate_gclc_definitions(P,Def) :- def(P,L,_), 
                                    equal(L,[eq_angle_compound(angle(L1,L2),
                                                               angle(L2,L3),1,0,0,0)]),
                                    def_or_lemma(inc(A,L1),_), def_or_lemma(inc(C,L1),_), A\=C, 
                                    def_or_lemma(inc(B,L3),_), def_or_lemma(inc(C,L3),_), B\=C, 
                                    obj_name(obj(point,A),AN), underline_name(AN,AU),
                                    obj_name(obj(point,B),BN), underline_name(BN,BU), 
                                    obj_name(obj(point,C),CN), underline_name(CN,CU),
                                    obj_name(obj(line,L2),L2N), underline_name(L2N,L2U), 
                                    atom_concat('bis ',L2U,R1),
                                    atom_concat(R1,' ',R2),
                                    atom_concat(R2,AU,R3),
                                    atom_concat(R3,' ',R4),
                                    atom_concat(R4,CU,R5),
                                    atom_concat(R5,' ',R6),
                                    atom_concat(R6,BU,Def).

/* ----------------------------------------------------------------- */ 

/* coordinates of all significant points */
coordinates(a,80,95) :- !.
coordinates(b,20,40) :- !.
coordinates(c,110,40) :- !.
coordinates(midpoint([a,b]),50,67.5) :- !.
coordinates(midpoint([a,c]),95,67.5) :- !.
coordinates(midpoint([b,c]),65,40) :- !.
coordinates(foot(a,[b,c]),80,40) :- !.
coordinates(foot(b,[a,c]),89.36,77.83) :- !.
coordinates(foot(c,[a,b]),68.91,84.83) :- !.
coordinates(angle_bis_foot(a,[b,c]),70.86,40) :- !.
coordinates(angle_bis_foot(b,[a,c]),94.25,68.88) :- !.
coordinates(angle_bis_foot(c,[a,b]),55.38,72.43) :- !.
coordinates(circumcenter([a,b],c),65,51.14) :- !.
coordinates(orthocenter([a,b],c),80,72.73) :- !.
coordinates(incenter([a,b],c),74.37,61.15) :- !.
coordinates(centroid([a,b],c),70,58.33) :- !.
coordinates(euler(a,[b,c]),80,83.86) :- !.
coordinates(euler(b,[a,c]),50,56.36) :- !.
coordinates(euler(c,[a,b]),95,56.36) :- !.
coordinates(npcenter([a,b],c),72.5,61.93) :- !.

/* ----------------------------------------------------------------- */

/* write a list of formatted names of the objects to a stream */
write_formatted(_,[])                :- !.
write_formatted(Stream,[H|T]) :- /*write('1.write_formatted, H:'), write(H),
                                 write(' Name:'),*/
                                 obj_name(H,Name), 
                                 /*write(Name), nl,*/
                                 write(Stream,Name), write(Stream,' '), 
                                 write_formatted(Stream,T).

/* ----------------------------------------------------------------- */

/* printing a construction in gclc form */
print_construction_to_gclc_file(Trace_simp,NDGs,DETs,Known,Stream) :- print_construction_header_to_file(Known,Stream),
                                                                      /*write('prosao header'), flush, */ print_body_to_file(Trace_simp,Stream),
                                                                      /*write('prosao body'), flush, */ print_construction_footer_to_file(Stream,NDGs,DETs),
                                                                      /*write('prosao footer'), flush,*/
                                                                      print_verification(Known,Stream), !.  
print_construction_to_gclc_file(_,_,_,_,_). 


/* ----------------------------------------------------------------- */

/* printing a proof that the problem setting is redundant in gclc form */
print_construction_to_gclc_file_red(Trace_simp,NDGs,DETs,Known,Unknown,Stream) :- print_construction_header_to_file(Known,Stream),
                                                                        print_redundancy_description(Unknown,Stream), 
                                                                        print_body_to_file(Trace_simp,Stream), 
                                                                        print_construction_footer_to_file(Stream,NDGs,DETs), 
                                                                        myunion(Known,Unknown,Known1),
                                                                        print_verification(Known1,Stream), !.
print_construction_to_gclc_file_red(_,_,_,_,_,_).

/* ----------------------------------------------------------------- */

/* printing a proof that the problem setting is redundant in gclc form */
print_construction_to_gclc_file_ld(Trace_simp,NDGs,DETs,Known,Unknown,El,Stream) :- /*write('2.usao u pc'), nl,*/
                                                                          print_construction_header_to_file(Known,Stream),
                                                                          /*write('2.prosao print header'), nl,*/
                                                                          print_ld_description(Unknown,El,Stream), 
                                                                          /*write('2.prosao ld description'), nl,*/
                                                                          print_body_to_file(Trace_simp,Stream), 
                                                                          /*write('2.prosao print body'), nl,*/
                                                                          print_construction_footer_to_file(Stream,NDGs,DETs), 
                                                                          /*write('2.prosao print footer'), nl,*/
                                                                          myunion(Known,[Unknown],Known1),
                                                                          print_verification(Known1,Stream),
                                                                          /*write('2.prosao print verification'), nl,*/
                                                                          !.
print_construction_to_gclc_file_ld(_,_,_,_,_,_,_). 


/* ----------------------------------------------------------------- */

/* printing a construction header */
print_construction_header_to_file(Known,Stream) :- write(Stream,'dim 120 120'), 
                                                   nl(Stream),
                                                   nl(Stream),
                                                   write_objs_to_gclc_file(Known,Stream),
                                                   nl(Stream),
                                                   write(Stream,'color 220 0 0'), 
                                                   nl(Stream),
                                                   write(Stream,'fontsize 9'),
                                                   nl(Stream),
                                                   mark_objs(Known,Stream), 
                                                   nl(Stream),
                                                   write(Stream,'color 0 0 0'), 
                                                   nl(Stream),
                                                   write(Stream,'fontsize 8'),
                                                   nl(Stream),
                                                   !.
                                                   
/* ----------------------------------------------------------------- */

/* printing (as a comment) an explanation of redundancy */
print_ld_description(obj(Type,A),[obj(Type1,L)],Stream) :- 
                                                        obj_name(obj(Type,A),Name), obj_name(obj(Type1,L),Name1),
                                                        nl(Stream), nl(Stream), write(Stream, '% '),
                                                        write(Stream, Type), write(Stream,' '), write(Stream,Name),
                                                        write(Stream,' is given by the problem setting, but it has to belong to the '),  
                                                        write(Stream,Type1), write(Stream,' '), write(Stream,Name1),
                                                        write(Stream,' which is constructible from the others objects given '), !.

/* ----------------------------------------------------------------- */

/* printing (as a comment) an explanation of redundancy */
print_redundancy_description([obj(Type,Obj)],Stream) :- nl(Stream), nl(Stream), write(Stream, '% '),
                                                        write(Stream,Type), obj_name(obj(Type,Obj),Name),
                                                        write(Stream,' '), write(Stream,Name), 
                                                        write(Stream,' is given by the problem setting, '),
                                                        write(Stream,'but it has to be constructible this way, '),
                                                        write(Stream,'otherwise the problem has no solution'), !.


/* ----------------------------------------------------------------- */

/* print verification in gclc form */
print_verification(Known,Stream) :- nl(Stream), nl(Stream),
                                    write(Stream,'% definitions'), nl(Stream),
                                    without_types(Known,Known1), 
                                    /* we need to pay attention to the order in which definitions are printed */
                                    /*nl, nl, write('POZIV FJE ORDER: prosao without types '),*/
                                    order(Known1,Known2),
                                    /*write('prosao order '), 
                                    write('Known1:'), write(Known1), nl,
                                    write('Known2:'), write(Known2), nl,*/
                                    collect_all(Known2,Objs),
                                    /*write('prosao collect all '),
                                    write(Objs), nl,*/
                                    print_definitions(Objs,Stream),
                                    /*write('prosao print def'),*/
                                    print_theorems(Known,Stream), 
                                    /*write('prosao print theorems'),*/
                                    !.

/* ----------------------------------------------------------------- */

/* transforming a list of objects into a list of object names (without types) */
without_types([],[]) :- !.
without_types([obj(_,H)|T],[H|T1]) :- without_types(T,T1). 

/* ----------------------------------------------------------------- */

/* for the list of given objects collect all objects that should be defined */
collect_all([],[])     :- !.
collect_all([H|T],All) :- collect_objs_to_be_defined([H],[H],AllH),
                          collect_all(T,AllT), 
                          myunion1(AllH,AllT,All). 

/* ----------------------------------------------------------------- */

collect_objs_to_be_defined([],AllObjs,AllObjs)    :- !.
collect_objs_to_be_defined([H|T],AllObjs,ObjsDef) :- def(H,Props,_), /*write('def za H:'), write(H), nl,*/ 
                                                     all_objs_in_props(Props,[],Objs), 
                                                     /*write('Objs: '), write(Objs), nl,*/
                                                     eliminate_same(Objs,H,Objs1),
                                                     /*write('Objs1: '), write(Objs1), nl,*/
                                                     not_mysublist(AllObjs,Objs), !,
                                                     /*write('pravimo uniju: '), write(Objs), write(' i '), write([H|T]), nl,*/
                                                     myunion1(Objs1,[H|T],List1), 
                                                     /*write('List1: '), write(List1), nl,
                                                     write('pravimo uniju: '), write(Objs), write(' i '), write(AllObjs), nl,
                                                     */
                                                     myunion1(Objs1,AllObjs,AllObjs1),
                                                     /*write('AllObjs1: '), write(AllObjs1), nl, 
                                                     write('nastavljamo za List1: '), write(List1), nl, nl, 
                                                     */
                                                     collect_objs_to_be_defined(List1,AllObjs1,ObjsDef).
collect_objs_to_be_defined([_|T],AllObjs,ObjsDef) :- collect_objs_to_be_defined(T,AllObjs,ObjsDef).

/* ----------------------------------------------------------------- */

/* definition of the object X must precede the definition of the object Y */
must_precede(X,Y) :- must_precede_one(X,Y), !.
must_precede(X,Y) :- must_precede_one(X,Z), must_precede(Z,Y). 

/* ----------------------------------------------------------------- */

must_precede_one(Y,X) :- def(X,List,_), 
                         all_objs_in_props(List,[],Objs), 
                         element(Y,Objs), Y\=X, !.

/* ----------------------------------------------------------------- */

/* for each list of objects its ordering, according to the partial order above, is given */
order([A,B],[B,A]) :- must_precede(B,A), !.
order([A,B],[A,B]) :- !.

order([A,B,C],[B,A,C]) :- must_precede(B,A), must_precede(B,C), must_precede(A,C), !.
order([A,B,C],[B,C,A]) :- must_precede(B,A), must_precede(B,C), !.
order([A,B,C],[C,A,B]) :- must_precede(C,A), must_precede(C,B), must_precede(A,B), !.
order([A,B,C],[C,B,A]) :- must_precede(C,A), must_precede(C,B), !.
order([A,B,C],[A,C,B]) :- must_precede(A,B), must_precede(A,C), must_precede(C,B), !.
order([A,B,C],[C,A,B]) :- must_precede(C,A), must_precede(A,B), !.
order([A,B,C],[C,B,A]) :- must_precede(C,B), must_precede(B,A), !.
order([A,B,C],[B,A,C]) :- must_precede(B,A), must_precede(A,C), !.
order([A,B,C],[B,C,A]) :- must_precede(B,C), must_precede(C,A), !.
order([A,B,C],[A,C,B]) :- must_precede(A,C), must_precede(C,B), !.
order([A,B,C],[C,B,A]) :- must_precede(C,A), !.
order([A,B,C],[A,C,B]) :- must_precede(C,B), !.
order([A,B,C],[B,A,C]) :- must_precede(B,A), !.
order([A,B,C],[A,B,C]) :- !.

/* ----------------------------------------------------------------- */

/* collecting all objects appearing in the list of properties */
all_objs_in_props([],List,List) :- !.
all_objs_in_props([H|T],List,List1) :- all_objs_in_prop(H,Args),
                                       myunion(List,Args,ListNew),
                                       all_objs_in_props(T,ListNew,List1).

all_objs_in_prop(H,Args) :- functor(H,_,Arity),
                            get_all_args(H,Arity,[],Args).

eliminate_same([],_,[]) :- !.
eliminate_same([H|T],H,T1) :- !, eliminate_same(T,H,T1).
eliminate_same([H|T],H1,[H|T1]) :- eliminate_same(T,H1,T1). 

/* ----------------------------------------------------------------- */

/* collecting all objects appearing in the given property */
get_all_args(_,0,Args,Args) :- !.
get_all_args(H,N,Args,Args1) :- arg(N,H,V), functor(V,Name,_),
                                Name='[]', !, myunion(Args,H,Args1).
/* ZA SAD OVAKO URADJENO, AKO JE ANGLE TO SE PRESKACE */
get_all_args(H,N,Args,Args1) :- N1 is N-1, arg(N,H,V), functor(V,Name,NV),
                                Name='angle', 
                                !,
                                get_all_args(V,NV,[],Objs),
                                myunion(Args,Objs,U), 
                                get_all_args(H,N1,U,Args1).
get_all_args(H,N,Args,Args1) :- N1 is N-1, arg(N,H,V), functor(V,Name,_),
                                Name\='.', 
                                not_element(V,Args), not_number(V), 
                                not_element(V,['a','b','c']), !, 
                                get_all_args(H,N1,[V|Args],Args1).
get_all_args(H,N,Args,Args1) :- N1 is N-1, arg(N,H,V), functor(V,Name,_),
                                Name\='.', 
                                !, 
                                get_all_args(H,N1,Args,Args1).
get_all_args(H,N,Args,Args1) :- N1 is N-1, arg(N,H,V), functor(V,Name,NV),
                                Name='.', 
                                V\=[], !,
                                get_all_args(V,NV,[],Objs),
                                myunion(Args,Objs,U), 
                                get_all_args(H,N1,U,Args1).

/* ----------------------------------------------------------------- */

/* printing definitions as gclc instructions for the set of given objects */
print_definitions([],_)         :- !.
print_definitions([H|T],Stream) :- print_definition(H,Stream), print_definitions(T,Stream).

/* ----------------------------------------------------------------- */

/* print a definition */
print_definition(O,Stream) :- not_element(O,['a','b','c']), !, 
                              /*write('ispis za definiciju za:'), write(O),*/
                              gclc_def(O,O1), 
                              /*write('prosao'), nl,*/
                              write(Stream,O1), nl(Stream), !.
print_definition(_,_)      :- !.

/* ----------------------------------------------------------------- */

/* printing theorems of the form prove{identical X _X} for all objects except vertices of the triangle */       
print_theorems([],_)         :- !.
print_theorems([H|T],Stream) :- print_theorem(H,Stream), print_theorems(T,Stream).
 
/* ----------------------------------------------------------------- */

/* printing one theorem */
print_theorem(obj(T,O),Stream) :- not_element(O,['a','b','c']), !, write(Stream,'prove {identical '),
                                  obj_name(obj(T,O),Name), underline_name(Name,Name1), 
                                  write(Stream,Name), write(Stream,' '), write(Stream,Name1),
                                  write(Stream,'}'), nl(Stream), !.
print_theorem(_,_)             :- !.

/* ----------------------------------------------------------------- */

/* printing a construction footer in gclc form */
print_construction_footer_to_file(Stream,NDGs,DETs) :- nl(Stream),
                                             nl(Stream),
                                             write(Stream,'drawsegment A B'), 
                                             nl(Stream),
                                             write(Stream,'drawsegment A C'), 
                                             nl(Stream),
                                             write(Stream,'drawsegment B C'), 
                                             nl(Stream), nl(Stream), 
                                             write(Stream, '% Non-degenerate conditions: '), 
                                             write_prop_list(Stream, NDGs, 1), nl(Stream),
                                             write(Stream, '% Determination conditions: '), 
                                             write_prop_list(Stream, DETs, 1), nl(Stream),
                                             !.

/* ----------------------------------------------------------------- */

/* printing a body of construction in gclc form */
print_body_to_file(Trace_simp,Stream) :- print_steps_to_gclc(Trace_simp,Stream), !.

/* ----------------------------------------------------------------- */

/* printing a list of high-level construction steps in gclc form */
print_steps_to_gclc([],_)         :- !.
print_steps_to_gclc([H|T],Stream) :- nl(Stream), 
                                     print_step_to_gclc(H,Stream),
                                     print_steps_to_gclc(T,Stream).

/* ----------------------------------------------------------------- */

/* printing a high-level construction step in gclc form */
print_step_to_gclc((L,Values,Obj,_,NDG,DET,Name,_),Stream) :- 
                                                      /*write('print step'), write((L,Values,Obj,NDG, DET,Name)),*/
                                                      write_ndg_list_if_any(Stream,NDG), 
                                                      write_det_list_if_any(Stream,DET), 
                                                      nl(Stream),
                                                      translate(L,Values,Obj,Name,Steps), 
                                                      /*nl, write('prosao translate'), nl,*/
                                                      write_steps(Steps,Stream), !.

/* ----------------------------------------------------------------- */

/* printing a list of gclc instructions in gclc form */
write_steps([],_)         :- !.
write_steps([H|T],Stream) :- write_step(H,Stream), nl(Stream), 
                             write_steps(T,Stream).

/* ----------------------------------------------------------------- */

/* printing a gclc instruction in gclc form */
write_step(('expression',ListKnown,ListValues,ListConstr,Text),Stream) :- !,  
                                                         write(Stream,'% '), write(Stream,Text), nl(Stream),
                                                         write(Stream,'expression'), write(Stream,' '),  
                                                         write_formatted(Stream,ListConstr),
                                                         write(Stream,' { '), write_formatted(Stream,ListKnown), 
                                                         write_el(Stream,ListValues),
                                                         write(Stream,' } '), 
                                                         nl(Stream), nl(Stream).
write_step((Name,ListKnown,ListValues,ListConstr,Text),Stream) :- 
                                                         write(Stream,'% '), write(Stream,Text), nl(Stream),
                                                         write(Stream,Name), write(Stream,' '),  
                                                         write_formatted(Stream,ListConstr),
                                                         /*write('1.write_step:'), write(ListKnown), nl,*/
                                                         write_formatted(Stream,ListKnown),
                                                         /*write('2.write_step:'), write(ListKnown), nl,*/
                                                         write_el(Stream,ListValues),
                                                         write_coordinates_for_free(Stream,Name,ListConstr),
                                                         mark_objs(ListConstr,Stream),
                                                         nl(Stream), 
                                                         additional_steps((Name,ListKnown,ListValues,ListConstr),List),
                                                         write_additionals(Stream,List).

/* ----------------------------------------------------------------- */

/* for free points their coordinates are printed */
write_coordinates_for_free(Stream,'point',[obj(point,Obj)]) :- !, coordinates(Obj,X,Y), write(Stream,X), 
                                                               write(Stream,' '), write(Stream,Y), nl(Stream).
write_coordinates_for_free(_,_,_) :- !.

/* ----------------------------------------------------------------- */

/* add additional steps to construction if necessary, otherwise do nothing */
write_additionals(_,[]) :- !.
write_additionals(Stream,List) :- write(Stream,'color 200 200 200'),
                                  nl(Stream),
                                  write_additional(Stream,List), 
                                  write(Stream,'color 0 0 0'),
                                  nl(Stream).

/* ----------------------------------------------------------------- */

/* printing list of additional steps */
write_additional(_,[]).
write_additional(Stream,[(Name,List)|T]) :- write(Stream,Name), write(Stream,' '),
                                            write_formatted(Stream,List), 
                                            nl(Stream),
                                            write_additional(Stream,T).

/* ----------------------------------------------------------------- */

/* write a list of objects to a stream */
write_el(_,[]) :- !.
write_el(Stream,[H|T]) :- write(Stream,H), write_el(Stream,T).

/* ----------------------------------------------------------------- */

/* write a list of object declarations in gclc form */
write_objs_to_gclc_file([],_)         :- !.
write_objs_to_gclc_file([H|T],Stream) :- write_obj_to_gclc_file(H,Stream),
                                         write_objs_to_gclc_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write an object declaration in gclc form */
write_obj_to_gclc_file(obj(Type,Obj),Stream) :- write(Stream,Type),  write(Stream,' '), 
                                                obj_name(obj(Type,Obj),Name), write(Stream,Name), write(Stream,' '), 
                                                coordinates(Obj,X,Y), write(Stream,X), write(Stream,' '),
                                                write(Stream,Y), nl(Stream).

/* ----------------------------------------------------------------- */

/* mark list of points */
mark_objs([],_)         :- !.
mark_objs([H|T],Stream) :- nl(Stream), mark_obj(H,Stream),
                           mark_objs(T,Stream).

/* ----------------------------------------------------------------- */

/* mark a point */
mark_obj(X,_) :- var(X), !.
/* dodate fiksne pozicije za temena, proveri da li radi kako treba */
mark_obj(obj(point,X),Stream)  :- nonvar(X), X=a, obj_name(obj(point,a),Name), write(Stream,'cmark_rt'),  
                                  write(Stream,' '),  
                                  write(Stream,Name), !.
mark_obj(obj(point,X),Stream)  :- nonvar(X), X=b, obj_name(obj(point,b),Name), write(Stream,'cmark_b'),  
                                  write(Stream,' '),  
                                  write(Stream,Name), !.
mark_obj(obj(point,X),Stream)  :- nonvar(X), X=c, obj_name(obj(point,c),Name), write(Stream,'cmark_b'),  
                                  write(Stream,' '),  
                                  write(Stream,Name), !.
mark_obj(obj(point,A),Stream)  :- obj_name(obj(point,A),Name), write(Stream,'cmark'),  
                                  random_direction(X), write(Stream,X), write(Stream,' '),  
                                  write(Stream,Name), !.
mark_obj(obj(line,P),Stream)   :- nl(Stream), write(Stream,'color 200 200 200'), nl(Stream),
                                  obj_name(obj(line,P),Name), 
                                  write(Stream,'drawline '), write(Stream,Name), nl(Stream), 
                                  write(Stream,'color 0 0 0'), nl(Stream), !.
mark_obj(obj(circle,C),Stream) :- nl(Stream), write(Stream,'color 200 200 200'), nl(Stream),
                                  obj_name(obj(circle,C),Name), 
                                  write(Stream,'drawcircle '), write(Stream,Name), nl(Stream), 
                                  write(Stream,'color 0 0 0'), nl(Stream), !.
mark_obj(obj(_,_),_).

/* ----------------------------------------------------------------- */

/* translating high-level construction rules used in program to gclc instructions */
translate([X,X,Y],[obj(_,K),obj(_,L)],[Z],'W01',[('towards',[X,Y],[V],[Z],Text)]) :- 
                 !, V is K/L, 
                 nl_text('towards',[X,Y,Z,V],Text).

translate([X,Y,Z],[obj(_,K),obj(_,L)],[W],'W01',[('translate',[Y,X,Z],[],[I],Text1),
                                  ('towards',[X,I],[V],[W],Text2)]) :- 
                 !, I=obj(point,_),
                 V is K/L,
                 nl_text('translate',[Y,X,Z,I],Text1), 
                 nl_text('towards',[X,I,W,V],Text2).

translate([X,Y],[],[P],'W02',[('line',[X,Y],[],[P],Text)]) :- 
                 !, nl_text('line',[X,Y,P],Text).

translate([P,Q],[],[A],'W03',[('intersec',[P,Q],[],[A],Text)]) :- 
                  !, nl_text('intersec',[P,Q,A],Text).

translate([C,P],[],[A,B],'W04',[('intersec2',[C,P],[],[A,B],Text)]) :- 
                 !, nl_text('intersec2',[C,P,A,B],Text).

translate([_,P,O,A],[],[B],'W05',[('foot',[O,P],[],[O1],Text1),
                                  ('sim',[O1,A],[],[B],Text2)]) :-  
                  !, O1=obj(point,_), 
                  nl_text('foot',[O,P,O1],Text1), 
                  nl_text('sim',[O1,A,B],Text2).

translate([_,_,O,A],[],[B],'W05a',[('sim',[O,A],[],[B],Text2)]) :-  
                  !, nl_text('sim',[O,A,B],Text2).

translate([A,O],[],[C],'W06',[('circle',[O,A],[],[C],Text)]) :- 
                  !, nl_text('circle',[O,A,C],Text).

translate([C,C1],[],[A,B],'W07',[('intersec2',[C,C1],[],[A,B],Text)]) :- 
                   !, nl_text('intersec2',[C,C1,A,B],Text).

translate([_,_,A,O1,O2],[],[B],'W08',[('line',[O1,O2],[],[P],Text1),
                                       ('sim',[P,A],[],[B],Text2)]) :-  
                   !, P=obj(line,_),
                   nl_text('line',[O1,O2,P],Text1), 
                   nl_text('sim',[P,A,B],Text2).
                   
translate([A,B],[],[C],'W09',[('midpoint',[A,B],[],[O],Text1),
                              ('circle',[O,A],[],[C],Text2)]) :- 
                   !, O=obj(point,_),
                   nl_text('midpoint',[A,B,O],Text1), 
                   nl_text('circle',[O,A,C],Text2).

translate([A,P],[],[Q],'W10a',[('perp',[A,P],[],[Q],Text)]) :- 
                  !, nl_text('perp',[A,P,Q],Text).

translate([A,P],[],[Q],'W10b',[('perp',[A,P],[],[Q],Text)]) :- 
                  !, nl_text('perp',[A,P,Q],Text).

translate([A,P],[],[C],'W11',[('foot',[A,P],[],[A1],Text1),
                             ('circle',[A,A1],[],[C],Text2)]) :- 
                   !, A1=obj(point,_),
                   nl_text('foot',[A,P,A1],Text1),
                   nl_text('circle',[A,A1,C],Text2).

translate([C,A,O],[],[P,Q],'W12',[('midpoint',[A,O],[],[O1],Text1),
                                  ('circle',[O1,A],[],[C1],Text2),
                                  ('intersec2',[C1,C],[],[D,E],Text3),
                                  ('line',[A,D],[],[P],Text4),
                                  ('line',[A,E],[],[Q],Text5)]) :- 
                   !, O1=obj(point,_),
                   C1=obj(circle,_),
                   D=obj(point,_),
                   E=obj(point,_),
                   P=obj(line,_),
                   nl_text('midpoint',[A,O,O1],Text1),
                   nl_text('circle',[O1,A,C1],Text2),
                   nl_text('intersec2',[C1,C,D,E],Text3),
                   nl_text('line',[A,D,P],Text4),
                   nl_text('line',[A,E,Q],Text5).

translate([_,A,O,Q],[],[P],'W13',[('foot',[O,Q],[],[B],Text1),
                                  ('line',[O,A],[],[L],Text2),
                                  ('sim',[L,B],[],[C],Text3),
                                  ('line',[A,C],[],[P],Text4)]):-
                   !, B=obj(point,_),
                   L=obj(line,_),
                   C=obj(point,_),
                   nl_text('foot',[O,Q,B],Text1),
                   nl_text('line',[O,A,L],Text2),
                   nl_text('sim',[L,B,C],Text3),
                   nl_text('line',[A,C,P],Text4).

translate([A,B],[],[P],'W14',[('med',[A,B],[],[P],Text1)]):-          
                   !, nl_text('med',[A,B,P],Text1).

translate([A,P,X],[obj(_,K),obj(_,L)],[Q],'W15',[('towards',[A,X],[V],[Z],Text1),
                                  ('parallel',[Z,P],[],[Q],Text2)]) :- 
                   !, V is K/L,
                   Z=obj(point,_),
                   nl_text('towards',[A,X,Z,V],Text1),
                   nl_text('parallel',[Z,P,Q],Text2).

translate([A,P],[],[Q],'W16',[('parallel',[A,P],[],[Q],Text)]) :- 
                   !, nl_text('parallel',[A,P,Q],Text).

translate([X,Y,_,T1,T2,T3,_,_],[obj(_,A),obj(_,B),obj(_,C),obj(_,D)],[S],'W17',
                                               [('angle_o',[T1,T2,T3],[],[Ang],Text4),
                                                ('expression',[],[V],[Value],Text3),
                                                ('rotate',[X,Value,Y],[],[Z],Text1),
                                                ('line',[X,Z],[],[S],Text2)]) :- 
                   !, Z=obj(point,_),
                   Value=obj(angle,_),
                   obj_name(Ang,AngN), 
                   string_concat(A,'/pow(2,',R1),
                   string_concat(R1,B,R2),
                   string_concat(R2,')*',R3),
                   string_concat(R3,AngN,R4),
                   string_concat(R4,'+',R5),
                   string_concat(R5,C,R6),
                   string_concat(R6,'/pow(2,',R7),
                   string_concat(R7,D,R8),
                   string_concat(R8,')*180',V),
                   nl_text('expression',[V,Value],Text3),
                   write('A'),
                   nl_text('rotate',[X,Y,V,Z],Text1), 
                   write('B'),
                   nl_text('line',[X,Z,S],Text2),
                   write('C'),
                   nl_text('angle_o',[T1,T2,T3,Ang],Text4).

translate([_,_,_,X,Y,T1,T2,T3],[obj(_,A),obj(_,B),obj(_,C),obj(_,D)],[R],'W18',
                                           [('angle_o',[T1,T2,T3],[],[Ang],Text4),
                                            ('expression',[],[V],[Value],Text3),
                                            ('rotate',[X,Value,Y],[],[Z],Text1),
                                            ('line',[X,Z],[],[R],Text2)]) :-
                   !, Z=obj(point,_),
                   Value=obj(angle,_),
                   obj_name(Ang,AngN), 
                   string_concat('-',A,R1),
                   string_concat(R1,'/(pow(2,',R2),
                   string_concat(R2,B,R3),
                   string_concat(R3,'))*',R4),
                   string_concat(R4,AngN,R5),
                   string_concat(R5,'-',R6),
                   string_concat(R6,C,R7),
                   string_concat(R7,'/(pow(2,',R8),
                   string_concat(R8,D,R9),
                   string_concat(R9,'))*180',V),
                   nl_text('expression',[V,Value],Text3),
                   nl_text('rotate',[X,Y,V,Z],Text1),
                   nl_text('line',[X,Z,R],Text2),
                   nl_text('angle_o',[T1,T2,T3,Ang],Text4).

translate([A,B,C,P],[],[D],'W19',[('rotate',[C,Value,B],[],[B1],Text10),
                                    ('line',[C,B1],[],[Q],Text11),
                                    ('midpoint',[B,B1],[],[L],Text12),
                                    ('line',[A,L],[],[AL],Text1),
                                    ('line',[B,L],[],[BL],Text2),
                                    ('intersec',[Q,AL],[],[M],Text3),
                                    ('intersec',[Q,BL],[],[N],Text4),
                                    ('line',[A,N],[],[AN],Text5),
                                    ('line',[B,M],[],[BM],Text6),
                                    ('intersec',[AN,BM],[],[K],Text7),
                                    ('line',[L,K],[],[LK],Text8),
                                    ('intersec',[LK,P],[],[D],Text9)]) :-
                   !, Value is 90,
                   B1=obj(point,_),
                   Q=obj(line,_),
                   L=obj(point,_),
                   AL=obj(line,_),
                   BL=obj(line,_),
                   M=obj(point,_),
                   N=obj(point,_),
                   AN=obj(line,_),
                   BM=obj(line,_),
                   K=obj(point,_),
                   LK=obj(line,_),
                   nl_text('rotate',[C,B,Value,B1],Text10),
                   nl_text('line',[C,B1,Q],Text11),
                   nl_text('midpoint',[B,B1,L],Text12),
                   nl_text('line',[A,L,AL],Text1),
                   nl_text('line',[B,L,BL],Text2),
                   nl_text('intersec',[Q,AL,M],Text3),
                   nl_text('intersec',[Q,BL,N],Text4),
                   nl_text('line',[A,N,AN],Text5),
                   nl_text('line',[B,M,BM],Text6),
                   nl_text('intersec',[AN,BM,K],Text7),
                   nl_text('line',[L,K,LK],Text8),
                   nl_text('intersec',[LK,P,D],Text9).

/* ILI ROTIRATI OKO B PITANJE JE SAD :)*/
translate([A,B,P1,P2,P3],[obj(_,K1),obj(_,K2),obj(_,K3),obj(_,K4)],[C],'W20',
                                 [('angle_o',[P1,P2,P3],[],[Ang],Text7),
                                  ('expression',[],[V1],[Value],Text8), 
                                  ('line',[A,B],[],[P],Text1),
                                  ('med',[A,B],[],[Q],Text2),
                                  ('rotate',[A,Value,B],[],[D],Text3),
                                  ('line',[A,D],[],[R],Text4),
                                  ('intersec',[Q,R],[],[O],Text5),
                                  ('circle',[O,A],[],[C],Text6)]) :- 
                    
                   !, Ang=obj(angle,_),
                   obj_name(Ang,AngN), 
                   Value=obj(angle,_),
                   string_concat(K1,'/pow(2,',R1),
                   string_concat(R1,K2,R2),
                   string_concat(R2,')*',R3),
                   string_concat(R3,AngN,R4),
                   string_concat(R4,'+',R5),
                   string_concat(R5,K3,R6),
                   string_concat(R6,'/pow(2,',R7),
                   string_concat(R7,K4,R8),
                   string_concat(R8,')*180',V),
                   string_concat('90-',V,V1),
                   /*write('A'),*/
                   P=obj(line,_), 
                   Q=obj(line,_),  
                   D=obj(point,_),
                   R=obj(line,_), 
                   O=obj(point,_),
                   /*write('B'),*/
                   nl_text('line',[A,B,P],Text1),
                   /*write('C'),*/
                   nl_text('med',[A,B,Q],Text2), 
                   /*write('D'),*/
                   nl_text('rotate',[A,B,Value,D],Text3),
                   /*write('E'),*/
                   nl_text('line',[A,D,R],Text4), 
                   /*write('F'),*/
                   nl_text('intersec',[Q,R,O],Text5),  
                   /*write('G'),*/
                   nl_text('circle',[O,A,C],Text6),
                   /*write('H'),*/
                   nl_text('angle_o',[P1,P2,P3,Ang],Text7),
                   /*write('I'),*/
                   nl_text('expression',[V1,Value],Text8).


translate([A,P],[],[B],'W21',[('foot',[A,P],[],[B],Text)]) :- 
                   !, nl_text('foot',[A,P,B],Text).

translate([A,_,O,B],[],[C2],'W22',[('distance',[O,B],[],[Value],Text1),
                                    ('distance',[O,A],[],[Value1],Text2),
                                    ('expression',[],[V1],[Value2],Text3),
                                    ('towards',[O,A],[Value2N],[obj(point,X1)],Text4),
                                    ('circle',[A,X],[],[C2],Text5)]) :- 
                   !, X=obj(point,X1), nl, write('A'),
                   obj_name(Value,ValueN),
                   obj_name(Value1,Value1N),
                   obj_name(Value2,Value2N),
                   string_concat(ValueN,'/',R1), nl, write('B'),
                   string_concat(R1,Value1N,V1), nl, write('C'),
                   nl_text('distance',[O,B,Value],Text1), nl, write('D'),
                   nl_text('distance',[O,A,Value1],Text2), nl, write('E'),
                   nl_text('expression',[V1,Value2],Text3), nl, write('F'), write('Value2:'), write(Value2), nl,
                   nl_text('towards',[O,A,obj(point,X1),V1],Text4), nl, write('G'),
                   nl_text('circle',[A,obj(point,X1),C2],Text5), nl, write('H').

translate([A,_,O,X],[obj(_,K),obj(_,L)],[C1],'W23',[('towards',[A,X],[V],[X1],Text1),
                                     ('towards',[A,O],[V],[O1],Text2),
                                     ('circle',[O1,X1],[],[C1],Text3)]) :-
                   !, V is K/L,
                   X1=obj(point,_),
                   O1=obj(point,_),
                   nl_text('towards',[A,O,O1,V],Text2),
                   nl_text('towards',[A,X,X1,V],Text1),
                   nl_text('circle',[O1,X1,C1],Text3).

translate([],[],[A],'free',[('point',[],[],[A],Text)]) :- 
                   !, nl_text('point',[A],Text).

translate([_,P,Q],_,[A],'WOnline1',[('online',[P,Q],[],[A],Text)]) :- 
                   !, nl_text('online',[P,Q,A],Text).

translate([_,P,X],_,[A],'WOnline2',[('random',[],[],[R],Text1),
                                   ('expression',[],[R2],[R1],Text2),
                                   ('turtle',[X,P,V,R1],[],[A],Text3)]) :- 
                   !, V is 90,
                   obj_name(R,RN),
                   string_concat(RN,'*20',R2), 
                   nl_text('random',[R],Text1), 
                   nl_text('expression',[R2,R1],Text2), 
                   nl_text('turtle',[X,P,V,R1,A],Text3).

translate([_,A,B,P,K,L],_,[O],'WOnline3',[('towards',[P,A],[V],[X],Text1),
                                         ('towards',[P,B],[V],[Y],Text2),
                                         ('online',[X,Y],[],[O],Text3)]) :- 
                   !, V is K/L,
                   X=obj(point,_),
                   Y=obj(point,_),
                   nl_text('towards',[P,A,X,V],Text1),
                   nl_text('towards',[P,B,Y,V],Text2),
                   nl_text('online',[X,Y,O],Text3).

translate([_,A,B,P,K,L],_,[O],'WOnline4',[('towards',[P,A],[W],[X],Text1),
                                         ('random',[],[],[R],Text2),
                                         ('expression',[],[R2],[R1],Text3),
                                         ('turtle',[B,X,V,R1],[],[O],Text4)]) :- 
                   !, W is K/L,
                   V is 90,
                   X=obj(point,_),
                   obj_name(R,RN),
                   string_concat(RN,'*20',R2), 
                   nl_text('towards',[P,A,X,W],Text1),
                   nl_text('random',[R],Text2), 
                   nl_text('expression',[R2,R1],Text3), 
                   nl_text('turtle',[B,X,V,R1,O],Text4).
                   

translate([P,Q],_,[A],'WOncircle1',[('oncircle',[P,Q],[],[A],Text)]) :- 
                   !, nl_text('oncircle',[P,Q,A],Text).

translate([X,Y],_,[A],'WOncircle2',[('midpoint',[X,Y],[],[M],Text1),
                                     ('oncircle',[M,X],[],[A],Text2)]) :- 
                   !, M=obj(point,_),
                   nl_text('midpoint',[X,Y,M],Text1),
                   nl_text('oncircle',[M,X,A],Text2).


/* ----------------------------------------------------------------- */

/* for each construction a list of additional drawings is listed */
additional_steps(('rotate',[X,Value,Y],_,[_]), [('drawarc_p',[X,Y,Value])]) :- !.
additional_steps(('online',[X,Y],_,[_]), [('drawline',[X,Y])]) :- !.
additional_steps(('oncircle',[P,Q],_,[_]), [('drawcircle',[P,Q])]) :- !.
additional_steps(('towards',[X,_],[V],[Z]), [('drawsegment',[X,Z])]) :- number(V), V > 1, !.
additional_steps(('towards',[X,Y],[V],[_]), [('drawsegment',[X,Y])]) :- number(V), V > 0, V < 1, !.
additional_steps(('towards',[_,Y],[V],[Z]), [('drawsegment',[Y,Z])]) :- number(V), V < 0, !.
additional_steps(('translate',[_,_,Z],_,[I]), [('drawsegment',[Z,I])]) :- !.
additional_steps(('med',[A,B],_,[_]), [('drawsegment',[A,B])]) :- !.
additional_steps(('foot',[O,_],_,[O1]), [('drawline',[O,O1])]) :- !.
additional_steps(_,[]).

/* ----------------------------------------------------------------- */

/* for each construction a description in natural language is given */
nl_text('expression',[V,Value],Text) :- !, obj_name(Value,ValueN),
                                        atom_concat('Calculating value ',ValueN,R1),
                                        atom_concat(R1,' using formula ',R2),
                                        atom_concat(R2,V,Text).

nl_text('distance',[O,A,V],Text) :- !, obj_name(V,VN),
                                    obj_name(O,ON),
                                    obj_name(A,AN),
                                    atom_concat('Calculating distance ',VN,R1),
                                    atom_concat(R1,' from point ',R2),
                                    atom_concat(R2,ON,R3),
                                    atom_concat(R3,' to point ',R4),
                                    atom_concat(R4,AN,Text).

nl_text('random',[R],Text) :- !, obj_name(R,RN),
                              atom_concat('Generating random value ',RN,Text).

nl_text('turtle',[X,P,V,R,A],Text) :- !, obj_name(X,XN), 
                                    obj_name(P,PN),
                                    obj_name(R,RN),
                                    obj_name(A,AN),
                                    atom_concat('Constructing a point ',AN,R1),
                                    atom_concat(R1,' which is a point for which holds ',R2),
                                    atom_concat(R2,PN,R3),
                                    atom_concat(R3,AN,R4),
                                    atom_concat(R4,' = ',R5),
                                    atom_concat(R5,RN,R6),
                                    atom_concat(R6,' and angle ',R7),
                                    atom_concat(R7,XN,R8),
                                    atom_concat(R8,PN,R9),
                                    atom_concat(R9,AN,R10),
                                    atom_concat(R10,' = ',R11),
                                    atom_concat(R11,V,Text).

nl_text('rotate',[X,Y,V,Z],Text) :- !, obj_name(X,XN), 
                                    obj_name(Y,YN),
                                    obj_name(Z,ZN),
                                    obj_name(V,VN),
                                    atom_concat('Constructing a point ',ZN,R1),
                                    atom_concat(R1,' which is an image of the point ',R2),
                                    atom_concat(R2,YN,R3),
                                    atom_concat(R3,' in a rotation around the point ',R4),
                                    atom_concat(R4,XN,R5),
                                    atom_concat(R5,' for the angle ',R6),
                                    atom_concat(R6,VN,Text).

nl_text('midpoint',[A,B,M],Text) :- !, obj_name(A,AN), 
                                    obj_name(B,BN),
                                    obj_name(M,MN),
                                    atom_concat('Constructing midpoint ',MN,R1),
                                    atom_concat(R1,' of the segment ',R2),
                                    atom_concat(R2,AN,R3),
                                    atom_concat(R3,BN,Text).

nl_text('med',[A,B,P],Text) :- !, obj_name(A,AN), 
                               obj_name(B,BN),
                               obj_name(P,PN),
                               atom_concat('Constructing bisector ',PN,R1),
                               atom_concat(R1,' of the segment ',R2),
                               atom_concat(R2,AN,R3),
                               atom_concat(R3,BN,Text).

nl_text('oncircle',[P,Q,A],Text) :- !, obj_name(A,AN), 
                                  obj_name(P,PN),
                                  obj_name(Q,QN),
                                  atom_concat('Choosing randomly a point ',AN,R1),
                                  atom_concat(R1,' on the circle with center ',R2),
                                  atom_concat(R2,PN,R3),
                                  atom_concat(R3,' through point ',R4),
                                  atom_concat(R4,QN,Text).

nl_text('online',[X,Y,A],Text) :- !, obj_name(A,AN), 
                                  obj_name(X,XN),
                                  obj_name(Y,YN),
                                  atom_concat('Choosing randomly a point ',AN,R1),
                                  atom_concat(R1,' on the line ',R2),
                                  atom_concat(R2,XN,R3),
                                  atom_concat(R3,YN,Text).

nl_text('parallel',[A,P,Q],Text) :- !,obj_name(A,AN), 
                                    obj_name(P,PN),
                                    obj_name(Q,QN),
                                    atom_concat('Constructing a line ',QN,R1),
                                    atom_concat(R1,' which contains the point ',R2),
                                    atom_concat(R2,AN,R3),
                                    atom_concat(R3,' and is parallel to the line ',R4),
                                    atom_concat(R4,PN,Text).

nl_text('angle_o',[A,B,C,Ang],Text) :- !, obj_name(A,AN), 
                                       obj_name(B,BN),
                                       obj_name(C,CN),
                                       obj_name(Ang,AngN),
                                       write('AngN'), write(AngN),
                                       atom_concat('Constructing an angle ',AngN,R1),
                                       atom_concat(R1,' which is equal to the angle ',R2),
                                       atom_concat(R2,AN,R3),
                                       atom_concat(R3,BN,R4),
                                       atom_concat(R4,CN,Text).

nl_text('foot',[O,P,Q],Text) :- !, obj_name(O,ON), 
                                obj_name(P,PN),
				obj_name(Q,QN),
				atom_concat('Constructing a point ',QN,R1),
                                atom_concat(R1,' which is a foot of the point ',R2),
                                atom_concat(R2,ON,R3),
                                atom_concat(R3,' on the line ',R4),
                                atom_concat(R4,PN,Text).

nl_text('sim',[O,A,B],Text) :- !, obj_name(O,ON), 
                               obj_name(B,BN),
			       obj_name(A,AN),
			       atom_concat('Constructing a point ',BN,R1),
                               atom_concat(R1,' which is an image of the point ',R2),
                               atom_concat(R2, AN,R3),
                               atom_concat(R3,' in the symmetry to point/line ',R4),
                               atom_concat(R4,ON,Text).

nl_text('intersec',[P,Q,A],Text) :- !, obj_name(P,PN), 
                                    obj_name(Q,QN),
                                    obj_name(A,AN),
                                    atom_concat('Constructing a point ',AN,R1),
                                    atom_concat(R1,' which belongs to line ',R2),
                                    atom_concat(R2, PN,R3),
                                    atom_concat(R3,' and line ',R4),
                                    atom_concat(R4,QN,Text).

nl_text('towards',[X,Y,Z,V],Text) :- !, obj_name(X,XN), 
                                     obj_name(Y,YN),
                                     obj_name(Z,ZN),
                                     atom_concat('Constructing a point ',ZN,R1),
                                     atom_concat(R1,' such that ',R2),
                                     atom_concat(R2, XN,R3),
                                     atom_concat(R3,ZN,R4),
                                     atom_concat(R4,'/',R5),
                                     atom_concat(R5,XN,R6),
                                     atom_concat(R6,YN,R7),
                                     atom_concat(R7,'=',R8),
                                     atom_concat(R8,V,Text).

nl_text('translate',[X,Y,Z,W],Text) :- !, obj_name(X,XN), 
                                       obj_name(Y,YN),
                                       obj_name(Z,ZN),
                                       obj_name(W,WN),
                                       atom_concat('Constructing a point ',WN,R1), 
                                       atom_concat(R1,' which is an image of the point ',R2), 
                                       atom_concat(R2,ZN,R3),
                                       atom_concat(R3,' in a translation for the vector ',R4),
                                       atom_concat(R4,XN,R5),
                                       atom_concat(R5,YN,Text).

nl_text('line',[X,Y,P],Text) :- !, obj_name(X,XN), 
                                obj_name(Y,YN),
                                obj_name(P,PN),
                                atom_concat('Constructing a line ',PN,R1), 
                                atom_concat(R1,' which passes through point ',R2), 
                                atom_concat(R2,XN,R3),
                                atom_concat(R3,' and point ',R4),
                                atom_concat(R4,YN,Text).

nl_text('circle',[O,A,C],Text) :- !, obj_name(O,ON), 
                                  obj_name(A,AN),
                                  obj_name(C,CN),
                                  atom_concat('Constructing a circle ',CN,R1), 
                                  atom_concat(R1,' whose center is at point ',R2), 
                                  atom_concat(R2,ON,R3),
                                  atom_concat(R3,' and which passes through point ',R4),
                                  atom_concat(R4,AN,Text).

nl_text('intersec2',[C,P,A,B],Text) :- !, obj_name(C,CN), 
                                       obj_name(A,AN),
                                       obj_name(B,BN),
                                       obj_name(P,PN),
                                       atom_concat('Constructing points ',AN,R1), 
                                       atom_concat(R1,' and ',R2),
                                       atom_concat(R2,BN,R3), 
                                       atom_concat(R3,' which are in intersection of ',R4), 
                                       atom_concat(R4,CN,R5),
                                       atom_concat(R5,' and ',R6),
                                       atom_concat(R6,PN,Text).

nl_text('perp',[A,P,Q],Text) :- !, obj_name(P,PN), 
                                obj_name(A,AN),
                                obj_name(Q,QN), 
                                atom_concat('Constructing a line ',QN,R1),   
                                atom_concat(R1,' which is perpendicular to line ',R2),   
                                atom_concat(R2,PN,R3),  
                                atom_concat(R3,' and which passes through point ',R4), 
                                atom_concat(R4,AN,Text).

nl_text('point',[A],Text) :- !, obj_name(A,AN),
                             atom_concat('Constructing a free point ',AN,Text).

/* ----------------------------------------------------------------- */

/* calculating direction according to the randomly chosen number */
/* random_direction(Y) :- random(X), direction(X,Y). */
random_direction('_r').

/* ----------------------------------------------------------------- */

/* calculating direction according to the given number */
direction(Z,'_r') :- Z < 0.25, !.  
direction(Z,'_l') :- Z >= 0.25, Z < 0.5, !.
direction(Z,'_t') :- Z >= 0.5, Z < 0.75, !.
direction(Z,'_b') :- Z >= 0.75.
