﻿     
:- dynamic(a/0).
:- dynamic(p/0).
:- dynamic(i/0).
:- dynamic(q/0).
:- dynamic(r/1).
:- dynamic(c/1).
:- dynamic(p/1).
:- dynamic(x/0).
:- dynamic(miniversion/0).
:- dynamic(gclc_def/2).
:- dynamic(problem_setting/4).

/* ----------------------------------------------------------------- */

/* consulting all files for mini version */
myimport_mini :- i, !.
myimport_mini :- consult('AuxiliaryPredicates.pro'),
                 consult('DefsAndLemmas.pro'),
                 consult('ConstructionRules.pro'),
                 consult('Preprocessing.pro'),
                 consult('Drawing.pro'),
                 consult('Search.pro'),
                 consult('Verification.pro'),
                 consult('Discussion.pro')
,consult('problemi_wernick.txt')
,consult('problemi_connelly.txt')
                 ,assert(i).

/* ----------------------------------------------------------------- */

/* initialization consists of importing other files and lemma generation,
   it is executed only once, before solving the first problem */
init :- p, !.
/* if we want to repeat preprocessing phase */
/*init :- miniversion, 
          statistics(cputime,TB),
          myimport_mini, 
          add_defs_and_lemmas, 
          generate_all_gclc_definitions([]), nl, nl,
          generate_all_xml_definitions([]), nl, nl,
          generate_all_argoclp_axioms([]), nl, nl,
          statistics(cputime,T1),
          Time is T1-TB,
          write('Time za preprocess: '), 
          format('~1f',[Time]), write(' seconds.'), nl, nl,
          assert(p), !.
*/
/* if we want to test with definitions and lemmas from the file */
init :- miniversion, 
        statistics(cputime,TB),
        myimport_mini, 
        consult('definicije.txt'), 
        consult('leme.txt'), 
        generate_all_gclc_definitions([]), nl, nl,
        generate_all_xml_definitions([]), nl, nl,
        generate_all_argoclp_axioms([]), nl, nl,
        statistics(cputime,T1),
        Time is T1-TB,
        write('Time za preprocess: '), 
        format('~1f',[Time]), write(' seconds.'), nl, nl,                                     
        assert(p), !.


/* ----------------------------------------------------------------- */

/* name of the output files are constructed according to the name of the problem */
output_txt_file_name(N,File) :- atom_concat('constructions/construction_',N,A), atom_concat(A,'.txt',File).
output_gclc_file_name(N,File) :- atom_concat('constructions/construction_',N,A), atom_concat(A,'.gcl',File).
output_xml_file_name(N,File) :- atom_concat('constructions/construction_',N,A), atom_concat(A,'.xml',File).
output_tex_file_name(N,File) :- atom_concat('constructions/construction_',N,A), atom_concat(A,'.tex',File).
output_argoclp_axioms_file_name(N,File) :- atom_concat('constructions/axioms_',N,A), atom_concat(A,'.txt',File).
output_argoclp_theorem_file_name(N,File) :- atom_concat('constructions/theorem_',N,A), atom_concat(A,'.txt',File).

/* ----------------------------------------------------------------- */

/* solving N-th problem in our numeration and calculating time */
solve_time(N,Stream,RulesUsed,LemmasUsed) :- assert(miniversion), 
                                             /* asserting executes miniversion, 
                                                commenting this line executes full version */ 
                                             init, 
                                             statistics(cputime,T1),
                                             problem_setting(N,_,Known,_),
                                             write('Problem:'), write(N), write(': '), 
                                             write_tex_list(Known,1), nl, flush, 
                                             write(Stream, N), write(Stream, '. & '), 
                                             write_tex_list(Known,1,Stream),
                                             write(Stream, ' & '),
                                             solve(N,Stream,RulesUsed,LemmasUsed),
                                             tab(Stream,3),
                                             symmetric_problem(N,Stream), /* determining if the problem is symmetric to some of previous problems */
                                             write(Stream, '&   &  '),
                                             write_nl_third(Stream,N),
                                             statistics(cputime,T2),
                                             Time1 is T2-T1,
                                             write('Time: '), 
                                             format('~1f',[Time1]), write(' seconds.'), nl, nl, !.
            
/* ----------------------------------------------------------------- */

write_nl_third(Stream,N) :- N rem 3 =:= 0, write(Stream, ' \\\\ \\hline'), nl(Stream), !.
write_nl_third(_,_).


/* ----------------------------------------------------------------- */

/* solving N-th problem in our numeration */

/* determining if the problem is redundant */
solve(N,Stream,RulesUsed,LemmasUsed) :-
            redundant_problem(N,RulesUsed,LemmasUsed), 
            tab(Stream,3), write(Stream,'R'), tab(Stream,3), 
            write('Problem is redundant'), nl, !. 

/* determining if the problem is locus-dependent */
solve(N,Stream,RulesUsed,LemmasUsed) :- 
            locus_dependent_problem(N,RulesUsed,LemmasUsed), 
            tab(Stream,3), write(Stream,'L'), tab(Stream,3), 
            write('Problem is locus dependent'), nl, !.

/* if the problem is neither redundant nor symmetric to some of the previous problems, we try to solve it */
solve(N,Stream,RulesUsed,LemmasUsed) :- 
            problem_setting(N,Name,Known,Sought), 
            construct(Known,Sought,Name,N,Stream,RulesUsed,LemmasUsed), !.

/* ----------------------------------------------------------------- */

/* solving all the problems from the corpus, while total time is calculated; 
   the argument of the procedure is the total number of problems */
solve_all_time(To,From,FileName,FileStatDef,FileStatLemma,FileStatConstr,Num,RulesUsed,RulesUsed1,LemmasUsed,LemmasUsed1) :- 
                     statistics(cputime, T1), 
                     solve_all(To,From,FileName,FileStatDef,FileStatLemma,FileStatConstr,RulesUsed,RulesUsed1,LemmasUsed,LemmasUsed1,Num), 
                     statistics(cputime, T2), Time is T2-T1, 
                     nl, write('Total time: '), format('~1f',[Time]), write(' seconds.'), nl,
                     open(FileName,append,Stream),
                     quick_sort(RulesUsed1,RulesOrdered),
                     write('Rules Used In Total: '), write(RulesOrdered), nl,
                     write(Stream, 'Rules Used In Total: '), write(Stream,RulesOrdered), nl(Stream),
                     quick_sort(LemmasUsed1,LemmasOrdered),
                     write('Lemmas Used In Total: '), write(LemmasOrdered), 
                     write(Stream,'Lemmas Used In Total: '), write(Stream,LemmasOrdered), 
                     close(Stream), !.

/* ----------------------------------------------------------------- */

/* solving all the problems from the corpus */
solve_all(N,M,_,_,_,_,RulesUsed,RulesUsed,LemmasUsed,LemmasUsed,_) :- M > N, !.
solve_all(N,M,FileName,FileStatDef,FileStatLemma,FileStatConstr,Rules,Rules1,Lemmas,Lemmas1,Num) :- open(FileName,append,Stream),
                  open(FileStatDef,append,Stream1),
                  open(FileStatConstr,append,Stream2),
                  open(FileStatLemma,append,Stream3),
                  solve_time(M,Stream,R,L), !,
                  close(Stream),
                  M1 is M+1, 
                  myunion(R,Rules,RulesNew),
                  quick_sort(RulesNew,RulesOrdered),
                  myunion(L,Lemmas,LemmasNew),
                  quick_sort(LemmasNew,LemmasOrdered),
                  nl, write('Construction used so far: '), write(RulesOrdered), 
                  length(RulesOrdered,L1),
                  write(Stream2,Num), write(Stream2,' '), 
                  write(Stream2,L1), nl(Stream2),
                  nl, write('Definitions and lemmas used so far: '), write(LemmasOrdered), nl,
                  length_defs(LemmasOrdered,0,L2),
                  length_lemmas(LemmasOrdered,0,L3),
                  write(Stream1,Num), write(Stream1,' '), 
                  write(Stream1,L2), nl(Stream1),
                  write(Stream3,Num), write(Stream3,' '), 
                  write(Stream3,L3), nl(Stream3),
                  close(Stream1),
                  close(Stream2),
                  close(Stream3),
                  Num1 is Num+1,
                  solve_all(N,M1,FileName,FileStatDef,FileStatLemma,FileStatConstr,RulesNew,Rules1,LemmasNew,Lemmas1,Num1). 

/* ----------------------------------------------------------------- */

length_lemmas([],N,N) :- !.
length_lemmas([H|T],N,M) :- string_concat('L',_,H), !, N1 is N+1, length_lemmas(T,N1,M).
length_lemmas([H|T],N,M) :- string_concat('GL',_,H), !, N1 is N+1, length_lemmas(T,N1,M).
length_lemmas([_|T],N,M) :- length_lemmas(T,N,M).

/* ----------------------------------------------------------------- */

length_defs([],N,N) :- !.
length_defs([H|T],N,M) :- string_concat('D',_,H), !, N1 is N+1, length_defs(T,N1,M).
length_defs([H|T],N,M) :- string_concat('GD',_,H), !, N1 is N+1, length_defs(T,N1,M).
length_defs([_|T],N,M) :- length_defs(T,N,M).


/* ----------------------------------------------------------------- */

/* the user enters the number of the problem to be solved */
solve :- !, write('Enter the number of the problem ended by a dot: '), 
         read(N),
         open('lista.txt', write, Stream),
         solve_time(N,Stream,_,_),
         close(Stream).

/* ----------------------------------------------------------------- */

/* solving all problems from Wernick's corpus */
solve_wernick :- assert(miniversion), init, 
                 generate_wernick(N), 
                 solve_all_time(N,1,'WERNICK_LIST_v2.txt',
                                'statistika_wernick_def.txt', 'statistika_wernick_lemma.txt','statistika_wernick_constructions.txt',1,
                                [],_,[],_), !.

/* ----------------------------------------------------------------- */

/* solving all problems from Pascal's corpus */
solve_pascal :- assert(miniversion), init, generate_pascal(N), 
                 solve_all_time(N,2001,'PASCAL_list.txt',
                                'statistika_pascal_def.txt','statistika_pascal_lemma.txt','statistika_pascal_constructions.txt',1,
                                [],_,[],_), !.

/* ----------------------------------------------------------------- */

/* solving all problems from Connelly's corpus */
solve_connelly :- assert(miniversion), init, generate_connelly1(N), 
                 solve_all_time(N,1001,'CONNELLY_LIST_v2.txt',
                 'statistika_connelly_def.txt','statistika_connelly_lemma.txt','statistika_connelly_constructions.txt',1,
                 [],_,[],_), !.

/* ----------------------------------------------------------------- */

/* solving all problems from Wernick's and Connnelly's corpus */
solve_wernick_and_connelly :- assert(miniversion), init,
                 /*generate_wernick(N),*/ 
                 solve_all_time(560,1,'WERNICK_LIST.txt',
                                'statistika_wc_def.txt', 'statistika_wc_lemma.txt','statistika_wc_constructions.txt',1,
                                [],RulesUsed,[],LemmasUsed), 
                 /*generate_connelly1(N),*/
                 solve_all_time(1580,1001,'CONNELLY_LIST.txt',
                 'statistika_wc_def.txt','statistika_wc_lemma.txt','statistika_wc_constructions.txt',561,
                 RulesUsed,_,LemmasUsed,_), !.



/* ----------------------------------------------------------------- */

/* solving N-th problem */
solve_one(N) :- assert(miniversion), 
                init, 
                open('test.txt', write, Stream),
                solve_time(N,Stream,RulesUsed,LemmasUsed),
                quick_sort(RulesUsed,RulesOrdered),
                quick_sort(LemmasUsed,LemmasOrdered),
                write('Rules Used:'), write(RulesOrdered), nl,
                write('Lemmas Used:'), write(LemmasOrdered), nl, 
                close(Stream).

/* solving all problems from the list */
solve_list(L) :- solve_list_aux(L,[],RulesUsed,[],LemmasUsed),
                 quick_sort(RulesUsed,RulesOrdered),
                 quick_sort(LemmasUsed,LemmasOrdered),
                 write('Rules Used:'), write(RulesOrdered), nl,
                 write('Lemmas Used:'), write(LemmasOrdered), nl, !.

solve_list_aux([],RulesUsed,RulesUsed,LemmasUsed,LemmasUsed).
solve_list_aux([N|T],RulesUsed,RulesUsed1,LemmasUsed,LemmasUsed1) :- 
                             assert(miniversion), init, 
                             open('lista1.txt', append, Stream),
                             solve_time(N, Stream,R,L),
                             close(Stream), 
                             myunion(R,RulesUsed,RulesUsedNew),
                             myunion(L,LemmasUsed,LemmasUsedNew),
                             solve_list_aux(T,RulesUsedNew,RulesUsed1,LemmasUsedNew,LemmasUsed1).

/* ----------------------------------------------------------------- */

/* generation of all problems from Wernick's corpus */
generate_wernick(N) :- r(N), !.
generate_wernick(N) :- myimport_mini,
                       write('Wernick`s corpus:'), nl,
                       open('problemi_wernick.txt',write,Stream),                                                       
                       generate_all_triples([obj(point,a),obj(point,b),obj(point,c),
                                             obj(point,circumcenter([a,b],c)),
                                             obj(point,midpoint([b,c])),
                                             obj(point,midpoint([a,c])),
                                             obj(point,midpoint([a,b])),
                                             obj(point,centroid([a,b],c)),
                                             obj(point,foot(a,[b,c])),
                                             obj(point,foot(b,[a,c])),
                                             obj(point,foot(c,[a,b])),
                                             obj(point,orthocenter([a,b],c)),
                                             obj(point,angle_bis_foot(a,[b,c])),
                                             obj(point,angle_bis_foot(b,[a,c])),
                                             obj(point,angle_bis_foot(c,[a,b])),
                                             obj(point,incenter([a,b],c))
                                             ],0,N,[],_,Stream),
                       close(Stream),
                       assert(r(N)), nl, nl, !.

/* ----------------------------------------------------------------- */

/* generation of all problems from Pascal's corpus */
generate_pascal(N) :- p(N), !.
generate_pascal(N) :- myimport_mini,
                      write('Pascal`s corpus:'), nl,
                      open('problemi_pascal.txt',write,Stream),                                                        
                      generate_all_triples([obj(length,length(segment([b,c]))),
                                            obj(length,length(segment([a,c]))),
                                            obj(length,length(segment([a,b]))),
                                            obj(length,length(segment([a,midpoint([b,c])]))),
                                            obj(length,length(segment([b,midpoint([a,c])]))),
                                            obj(length,length(segment([c,midpoint([a,b])]))),
                                            obj(length,length(segment([a,foot(a,[b,c])]))),
                                            obj(length,length(segment([b,foot(b,[a,c])]))),
                                            obj(length,length(segment([c,foot(c,[a,b])])))
                                            ],2000,N,[],_,Stream),
                       close(Stream),
                       assert(p(N)), nl, nl, !.

/* ----------------------------------------------------------------- */

/* generation of all problems from Connelly's corpus */
generate_connelly(N) :- c(N), !.
generate_connelly(N) :- myimport_mini,
                        write('Connelly`s corpus:'), nl,
                        open('problemi_connelly.txt',write,Stream),                                                       
                        generate_all_comb_triples(
                                             [obj(point,euler(a,[b,c])),
                                             obj(point,euler(b,[a,c])),
                                             obj(point,euler(c,[a,b])),
                                             obj(point,npcenter([a,b],c))
                                             ],
                                             [obj(point,a),obj(point,b),obj(point,c),
                                             obj(point,centroid([a,b],c)),
                                             obj(point,orthocenter([a,b],c)),
                                             obj(point,foot(a,[b,c])),
                                             obj(point,foot(b,[a,c])),
                                             obj(point,foot(c,[a,b])),
                                             obj(point,incenter([a,b],c)),
                                             obj(point,midpoint([b,c])),
                                             obj(point,midpoint([a,c])),
                                             obj(point,midpoint([a,b])),
                                             obj(point,npcenter([a,b],c)),
                                             obj(point,circumcenter([a,b],c)),
                                             obj(point,angle_bis_foot(a,[b,c])),
                                             obj(point,angle_bis_foot(b,[a,c])),
                                             obj(point,angle_bis_foot(c,[a,b]))
                                             ],1000,N,[],_,Stream),
                       close(Stream),
                       assert(c(N)), nl, nl, !.

generate_connelly1(N) :- c(N), !.
generate_connelly1(N) :- myimport_mini,
                         write('Connelly`s corpus:'), nl,
                         open('problemi_connelly.txt',write,Stream),                                                       
                         generate_all_comb_triples1([obj(point,euler(a,[b,c])),
                                             obj(point,euler(b,[a,c])),
                                             obj(point,euler(c,[a,b])),
                                             obj(point,npcenter([a,b],c))
                                             ],
                                             [obj(point,a),obj(point,b),obj(point,c),
                                             obj(point,euler(a,[b,c])),
                                             obj(point,euler(b,[a,c])),
                                             obj(point,euler(c,[a,b])),
                                             obj(point,centroid([a,b],c)),
                                             obj(point,orthocenter([a,b],c)),
                                             obj(point,foot(a,[b,c])),
                                             obj(point,foot(b,[a,c])),
                                             obj(point,foot(c,[a,b])),
                                             obj(point,incenter([a,b],c)),
                                             obj(point,midpoint([b,c])),
                                             obj(point,midpoint([a,c])),
                                             obj(point,midpoint([a,b])),
                                             obj(point,npcenter([a,b],c)),
                                             obj(point,circumcenter([a,b],c)),
                                             obj(point,angle_bis_foot(a,[b,c])),
                                             obj(point,angle_bis_foot(b,[a,c])),
                                             obj(point,angle_bis_foot(c,[a,b]))
                                             ],1000,N,[],_,Stream),
                         close(Stream),
                         assert(c(N)), nl, nl, !.

/* ----------------------------------------------------------------- */

/* generating all distinct triples out of given list of objects */
generate_all_triples(ObjectList,N,N2,Triples,AllTriples,Stream) :- element(A,ObjectList), element(B,ObjectList), A\=B,
                                                       element(C,ObjectList), A\=C, B\=C,
                                                       X=[A,B,C],
                                                       not_element(X,Triples), !, N1 is N+1,
                                                       Y=[obj(point,a),obj(point,b),obj(point,c)],
                                                       assert(problem_setting(N1,N1,X,Y)),
                                                       write(Stream,problem_setting(N1,N1,X,Y)), 
                                                       write(Stream,'.'),
                                                       nl(Stream), 
                                                       write(problem_setting(N1,N1,X,Y)), nl, 
                                                       generate_all_triples(ObjectList,N1,N2,[[A,B,C]|Triples],AllTriples,Stream). 
generate_all_triples(_,N,N,Triples,Triples,_) :- !.

/* ----------------------------------------------------------------- */

/* generating all distinct triples where first element is from the first list, and other two from the second list of objects */
generate_all_comb_triples(ObjectList1,ObjectList2,N,N2,Triples,AllTriples,Stream) :- element(A,ObjectList1), element(B,ObjectList2),
                                                       element(C,ObjectList2), B\=C,
                                                       X=[A,B,C],
                                                       not_element(X,Triples), !, N1 is N+1,
                                                       Y=[obj(point,a),obj(point,b),obj(point,c)],
                                                       assert(problem_setting(N1,N1,X,Y)),
                                                       write(Stream,problem_setting(N1,N1,X,Y)), 
                                                       write(Stream,'.'),
                                                       nl(Stream), 
                                                       write(problem_setting(N1,N1,X,Y)), nl, 
                                                       generate_all_comb_triples(ObjectList1,ObjectList2,N1,N2,[[A,B,C]|Triples],AllTriples,Stream). 
generate_all_comb_triples(_,_,N,N,Triples,Triples,_) :- !.

/* ----------------------------------------------------------------- */

/* generating all distinct triples where first element is from the first list, and other two from the second list of objects */
generate_all_comb_triples1(ObjectList1,ObjectList2,N,N2,Triples,AllTriples,Stream) :- element(A,ObjectList2), element(B,ObjectList2), A\=B,
                                                       element(C,ObjectList2), A\=C, B\=C,
                                                       X=[A,B,C], in_list(ObjectList1,X,X1), X1\=[],
                                                       not_element(X,Triples), !, N1 is N+1,
                                                       Y=[obj(point,a),obj(point,b),obj(point,c)],
                                                       assert(problem_setting(N1,N1,X,Y)),
                                                       write(Stream,problem_setting(N1,N1,X,Y)), 
                                                       write(Stream,'.'),
                                                       nl(Stream), 
                                                       write(problem_setting(N1,N1,X,Y)), nl, 
                                                       generate_all_comb_triples1(ObjectList1,ObjectList2,N1,N2,[[A,B,C]|Triples],AllTriples,Stream). 
generate_all_comb_triples1(_,_,N,N,Triples,Triples,_) :- !.

/* ----------------------------------------------------------------- */

/* find what is an ordinal of the problem in the corpus for the problem we want to solve */
find_problem_number(List,Number) :- problem_setting(Number,_,List,_),
                                    write(Number), nl.
