/* the unknown objects are being constructed given known objects;
simplified trace is printed to the file; it succeeds always */
construct(Known,Unknown,Name,_,StreamList,RulesUsed,LemmasUsed) :- statistics(cputime,T1), 
                              update_known(Known,Unknown,[],Trace,[],_,[],_,'W00',[]),
                              statistics(cputime,T2), 
                              nonvar(Trace), !, /* the following is performed only if the construction is found */
                              Time is T2 - T1, 
                              simplify_construction(Trace,Unknown,[],Trace_simp,[],RulesUsed,[],LemmasUsed,[],NDGs,[],DETs),
                              quick_sort(RulesUsed,RulesOrdered),
                              quick_sort(LemmasUsed,LemmasOrdered),
                              output_txt_file_name(Name,File),
                              output_gclc_file_name(Name,File1),
                              output_xml_file_name(Name,File2),
                              output_tex_file_name(Name,File5),
                              output_argoclp_axioms_file_name(Name,File3),
                              output_argoclp_theorem_file_name(Name,File4),
                              open(File,write,Stream), 
                              open(File1,write,Stream1), 
                              open(File2,write,Stream2),
                              open(File3,write,Stream3),
                              open(File4,write,Stream4),
                              open(File5,write,Stream5),
                              print_problem_setting_to_file(Known,Unknown,Name,Stream),
                              print_construction_to_file(Trace_simp,NDGs,DETs,RulesOrdered,LemmasOrdered,Time,Stream),
                              print_construction_to_gclc_file(Trace_simp,NDGs,DETs,Known,Stream1), 
                              print_construction_to_xml_file(Trace_simp,Known,Name,Stream2),
                              print_construction_to_tex_file(Trace_simp,Known,Name,NDGs,DETs,RulesOrdered,LemmasOrdered,Time,Stream5),
                              /* u Trace_simp imam uz svaki korak koje je pravilo korisceno i sta treba od lema */
                             /*print_argoclp_axioms_file(RulesUsed,Stream3),
                              write('prosao print argoclp axioms'), nl,
                              print_argoclp_theorem_file(Trace_simp,Known,Name,Stream4),
                              write('prosao print argoclp theorem'), nl,
                              */close(Stream),
                              close(Stream1), 
                              close(Stream2),
                              close(Stream3),
                              close(Stream4),
                              close(Stream5),
                              tab(StreamList,3), write(StreamList,'S').
construct(_,_,_,_,StreamList,_,_) :- tab(StreamList,3), write(StreamList,'U').

/* ----------------------------------------------------------------- */

/* the unknown objects are being constructed given known objects;
simplified trace is printed to the file; it succeeds if the objects sought can be constructed */
construct1(Known,Unknown,Name,_,AllUnknown,RulesUsed,LemmasUsed) :- statistics(cputime,T1), 
                                          update_known1(Known,Unknown,AllUnknown,[],Trace,[],_,[],_,'W00',_), !,
                                          statistics(cputime,T2), 
                                          Time is T2 - T1,
                                          myunion(Unknown,AllUnknown,Unknown1),
                                          simplify_construction(Trace,Unknown1,[],Trace_simp,[],RulesUsed,[],LemmasUsed,[],NDGs,[],DETs),
                                          quick_sort(RulesUsed,RulesOrdered),
                                          quick_sort(LemmasUsed,LemmasOrdered),
                                          output_txt_file_name(Name,File),
                                          output_gclc_file_name(Name,File1),
                                          output_xml_file_name(Name,File2),
                                          output_tex_file_name(Name,File5),
                                          output_argoclp_axioms_file_name(Name,File3),
                                          output_argoclp_theorem_file_name(Name,File4),
                                          open(File,write,Stream), 
                                          open(File1,write,Stream1), 
                                          open(File2,write,Stream2),
                                          open(File3,write,Stream3),
                                          open(File4,write,Stream4),
                                          open(File5,write,Stream5),
                                          print_problem_setting_to_file(Known,Unknown,Name,Stream),
                                          print_construction_to_file(Trace_simp,NDGs,DETs,RulesOrdered,LemmasOrdered,Time,Stream),
                                          print_construction_to_gclc_file_red(Trace_simp,NDGs,DETs,Known,Unknown,Stream1),
                                          print_construction_to_xml_file(Trace_simp,Known,Name,Stream2),
                                          print_construction_to_tex_file(Trace_simp,Known,Name,NDGs,DETs,RulesOrdered,LemmasOrdered,Time,Stream5),
                                          /*print_argoclp_axioms_file(RulesUsed,Stream3),
                                          write('prosao print argoclp axioms'), nl,
                                          print_argoclp_theorem_file(Trace_simp,Known,RulesUsed,Stream4),
                                          write('prosao print argoclp theorem'), nl,
                                          */close(Stream),
                                          close(Stream1),
                                          close(Stream2),
                                          close(Stream3),
                                          close(Stream4),
                                          close(Stream5).

/* ----------------------------------------------------------------- */

/* the unknown objects are being constructed given known objects;
simplified trace is printed to the file; it succeeds if the objects sought can be constructed */
construct2(Known,Unknown,Name,_,AllUnknown,RulesUsed,LemmasUsed) :- statistics(cputime,T1), 
                                          update_known2(Known,Unknown,AllUnknown,[],Trace,[],_,[],_,_,El,'W00'), !, 
                                          statistics(cputime,T2), 
                                          Time is T2 - T1,
                                          myunion(El,AllUnknown,Unknown1),
                                          simplify_construction(Trace,Unknown1,[],Trace_simp,[],RulesUsed,[],LemmasUsed,[],NDGs,[],DETs),
                                          quick_sort(RulesUsed,RulesOrdered),
                                          quick_sort(LemmasUsed,LemmasOrdered),
                                          output_txt_file_name(Name,File),
                                          output_gclc_file_name(Name,File1),
                                          output_xml_file_name(Name,File2),
                                          output_tex_file_name(Name,File5),
                                          output_argoclp_axioms_file_name(Name,File3),
                                          output_argoclp_theorem_file_name(Name,File4),
                                          open(File,write,Stream), 
                                          open(File1,write,Stream1), 
                                          open(File2,write,Stream2), 
                                          open(File3,write,Stream3),
                                          open(File4,write,Stream4),
                                          open(File5,write,Stream5),
                                          print_problem_setting_to_file(Known,El,Name,Stream),
                                          print_construction_to_file(Trace_simp,NDGs,DETs,RulesOrdered,LemmasOrdered,Time,Stream),
                                          print_construction_to_gclc_file_ld(Trace_simp,NDGs,DETs,Known,Unknown,El,Stream1),
                                          print_construction_to_xml_file(Trace_simp,Known,Name,Stream2),
                                          print_construction_to_tex_file(Trace_simp,Known,Name,NDGs,DETs,RulesOrdered,LemmasOrdered,Time,Stream5),
                                          /*print_argoclp_axioms_file(RulesUsed,Stream3),
                                          write('prosao print argoclp axioms'), nl,
                                          print_argoclp_theorem_file(Trace_simp,Known,RulesUsed,Stream4),
                                          write('prosao print argoclp theorem'), nl,
                                          */close(Stream),
                                          close(Stream1),
                                          close(Stream2),
                                          close(Stream3),
                                          close(Stream4),
                                          close(Stream5).


/* ----------------------------------------------------------------- */

/* application of construction rules to the objects constructed so far; determining if the construction can be found */
update_known(Known,Unknown,Input,Input,NDGs,NDGs,DETs,DETs,_,_)       :- mysublist(Known,Unknown), 
                                                                 write('Construction found'), nl, !.
update_known(Known_old,Unknown,Input,Output,NDGs,NDGs1,DETs,DETs1,IdPrev,Obj_constructedPrev) :- 
             basic_cons(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId),
             IdPrev@>RuleId,
             in_list1(Obj_constructedPrev,Obj_known,List), 
             /* ili ici samo sa functorom, mozda nam ovo radi posao koji nam treba? */
             List\=[],
             instantiate(Known_old,Obj_known), /* all objects from the premises of the rule are constructed */ 
             all_defs_or_lemmas(Props,[],LemmasUsed),  /* all properties are in definitions or lemmas */
             relevant_not_constructed_some(Obj_constructed,Props,Known_old),  /* at least one object that is being constructed is relevant */ 
             not_in_list(Obj_constructed,Known_old,Obj_new),
             Obj_new = Obj_constructed,  /* all objects that are being constructed are unknown */
             /* nema ! jer zbog Pascalovog korpusa treba dozvoliti backtracking */
             write('Construction: Konstruise se: '), write(Obj_new), write(' za pravilo:'), write(RuleId), nl, 
             myappend(Known_old,Obj_constructed,Known_new),
             myappend(NDGs,NDG,NDGs_new),
             myappend(DETs,DET,DETs_new),
             update_known(Known_new,Unknown,[(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId,LemmasUsed)|Input],Output,NDGs_new,NDGs1,DETs_new,DETs1,
                          RuleId,Obj_constructed), !.  
update_known(Known_old,Unknown,Input,Output,NDGs,NDGs1,DETs,DETs1,IdPrev,_) :- 
             basic_cons(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId),
             IdPrev @=< RuleId,
             instantiate(Known_old,Obj_known), /* all objects from the premises of the rule are constructed */ 
             all_defs_or_lemmas(Props,[],LemmasUsed),  /* all properties are in definitions or lemmas */
             relevant_not_constructed_some(Obj_constructed,Props,Known_old),  /* at least one object that is being constructed is relevant */ 
             not_in_list(Obj_constructed,Known_old,Obj_new),
             Obj_new = Obj_constructed,  /* all objects that are being constructed are unknown */
             /* nema ! jer zbog Pascalovog korpusa treba dozvoliti backtracking */
             write('Construction: Konstruise se: '), write(Obj_new), write(' za pravilo:'), write(RuleId), nl, 
             myappend(Known_old,Obj_constructed,Known_new),
             myappend(NDGs,NDG,NDGs_new),
             myappend(DETs,DET,DETs_new),
             update_known(Known_new,Unknown,[(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId,LemmasUsed)|Input],Output,NDGs_new,NDGs1,DETs_new,DETs1,
                          RuleId,Obj_constructed), !.  
update_known(_,_,_,_,_,_,_,_,_,_)                                  :- !, write('Construction can not be found'), nl, !.

/* ----------------------------------------------------------------- */

/* application of construction rules to the objects constructed so far; determining if the problem is redundant */
update_known1(Known,_,AllUnknown,Input,Input,NDGs,NDGs,DETs,DETs,_,_)   :- mysublist(Known,AllUnknown),
                                                                         !.
update_known1(Known,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,_,_) :- mysublist(Known,Unknown), 
                                                                         element(A,AllUnknown), 
                                                                         not_element(A,Known),
                                                                         /* pravi se unija da se ne bi vise konstruisale slobodne tacke */
                                                                         !,
                                                                         /* DA LI OVDE STAVITI CUT? */
                                                                         write('Redundant: Konstruise se tacka: '), write(A), write(' za pravilo free.'), nl, 
                                                                         myunion(Unknown,AllUnknown,Unknown1),
                                                                         update_known1([A|Known],Unknown1,AllUnknown,
                                                                            [([],[],[A],[],[],[],'free',[])|Input],Output,NDGs,NDGs1,DETs,DETs1,'W00',_),
                                                                         !.
update_known1(Known_old,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,IdPrev,Obj_constructedPrev) :- 
             basic_cons(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId),
             IdPrev@>RuleId,
             in_list1(Obj_constructedPrev,Obj_known,List), /* ili ici samo sa functorom, mozda nam ovo radi posao koji nam treba? */
             List\=[],
             instantiate(Known_old,Obj_known), /* all objects from the premises of the rule are constructed */ 
             all_defs_or_lemmas(Props,[],LemmasUsed),  /* all properties are in definitions or lemmas */
             relevant_not_constructed_some(Obj_constructed,Props,Known_old), /* at least one object that is being constructed is relevant */ 
             not_in_list(Obj_constructed,Known_old,Obj_new), 
             /* Obj_new \= [], */
             Obj_new = Obj_constructed, /* all objects that are being constructed are unknown */
             !, /* no backtracking */
             write('Redundant: Konstruise se: '), write(Obj_new), write(' za pravilo:'), write(RuleId), nl, 
             myappend(Known_old,Obj_constructed,Known_new),
             myappend(NDGs,NDG,NDGs_new),
             myappend(DETs,DET,DETs_new),
             update_known1(Known_new,Unknown,AllUnknown,[(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId,LemmasUsed)|Input],Output,NDGs_new,NDGs1,DETs_new,DETs1,
                                                          RuleId,Obj_constructed), !.  
update_known1(Known_old,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,IdPrev,_) :- 
             basic_cons(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId),
             IdPrev@=<RuleId,
             instantiate(Known_old,Obj_known), /* all objects from the premises of the rule are constructed */ 
             all_defs_or_lemmas(Props,[],LemmasUsed),  /* all properties are in definitions or lemmas */
             relevant_not_constructed_some(Obj_constructed,Props,Known_old), /* at least one object that is being constructed is relevant */ 
             not_in_list(Obj_constructed,Known_old,Obj_new), 
             /* Obj_new \= [], */
             Obj_new = Obj_constructed, /* all objects that are being constructed are unknown */
             !, /* no backtracking */
             write('Redundant: Konstruise se: '), write(Obj_new), write(' za pravilo:'), write(RuleId), nl, 
             myappend(Known_old,Obj_constructed,Known_new),
             myappend(NDGs,NDG,NDGs_new),
             myappend(DETs,DET,DETs_new),
             update_known1(Known_new,Unknown,AllUnknown,[(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId,LemmasUsed)|Input],Output,NDGs_new,NDGs1,DETs_new,DETs1,
                                                          RuleId,Obj_constructed), !.  
update_known1(_,_,_,_,_,_,_,_,_,_,_)                                  :- !, fail.

/* ----------------------------------------------------------------- */

/* checking if some object from the given list contains the point, 
  if it is the case the object is returned through the last parameter */
some_contains_point(_,[],_)           :- !, fail.
some_contains_point(Unknown,[H|_],El) :- contains_point(Unknown,H,El), !.
some_contains_point(Unknown,[_|T],El) :- some_contains_point(Unknown,T,El).
 
/* ----------------------------------------------------------------- */

/* checking if the line/circle contains the point */
contains_point(obj(point,Unknown),obj(line,Obj),[obj(line,Obj)])     :- !, def_or_lemma(inc(Unknown,Line),_), equal_lines(Line,Obj).
contains_point(obj(point,Unknown),obj(circle,Obj),[obj(circle,Obj)]) :- !, def_or_lemma(inc_k(Unknown,Circle),_), equal_circles(Circle,Obj).

/* ----------------------------------------------------------------- */

/* if there are two known points on the line, they are returned */
find_two_characteristic_points_for_line(Known,Line,[obj(line,Line),obj(point,A),obj(point,B)],'WOnline1') :- 
                               element(obj(point,A),Known),
                               def_or_lemma(inc(A,L1),_),
                               equal_lines(L1,Line),
                               element(obj(point,B),Known), B\=A,
                               def_or_lemma(inc(B,L2),_),
                               equal_lines(L2,Line), !.

/* otherwise a point on the line with a point on the perpendicular line are returned */
find_two_characteristic_points_for_line(Known,Line,[obj(line,Line),obj(point,A),obj(point,X)],'WOnline2') :- 
                               element(obj(point,A),Known),
                               def_or_lemma(inc(A,L1),_),
                               equal_lines(L1,Line),
                               element(obj(line,L2),Known),
                               def_or_lemma(perp(Line,L2),_),
                               element(obj(point,X),Known), X\=A,
                               def_or_lemma(inc(X,L2),_), !.

find_two_characteristic_points_for_line(Known,Line,[obj(line,Line),obj(point,A),obj(point,X)],'WOnline2') :- 
                               element(obj(point,A),Known),
                               def_or_lemma(inc(A,L1),_),
                               equal_lines(L1,Line),
                               element(obj(line,L2),Known),
                               def_or_lemma(perp(L2,Line),_),
                               element(obj(point,X),Known), X\=A,
                               def_or_lemma(inc(X,L2),_), !.

/* otherwise two points on the homothetic line are returned */
find_two_characteristic_points_for_line(Known,homothety(P,Line,K,L),
                    [obj(line,homothety(P,Line,K,L)),obj(point,A),obj(point,B),obj(point,P),K,L],'WOnline3') :- 
                               find_two_characteristic_points_for_line(Known,Line,[obj(line,Line),obj(point,A),obj(point,B)],'WOnline1'),
                               !.

/* otherwise a point on the homothetic line with a point on the perpendicular line are returned */
find_two_characteristic_points_for_line(Known,homothety(P,Line,K,L),
                    [obj(line,homothety(P,Line,K,L)),obj(point,A),obj(point,B),obj(point,P),K,L],'WOnline4') :- 
                              find_two_characteristic_points_for_line(Known,Line,[obj(line,Line),obj(point,A),obj(point,B)],'WOnline2'),
                              !.

/* ----------------------------------------------------------------- */

/* if there is a center and a point on the circle, they are returned */
find_two_characteristic_points_for_circle(Known,Circle,[obj(point,A),obj(point,B)],'WOncircle1') :-
                               element(obj(point,A),Known),
                               def_or_lemma(center(A,C1),_),
                               equal_circles(C1,Circle),
                               element(obj(point,B),Known), B\=A,
                               def_or_lemma(inc_k(B,C2),_),
                               equal_circles(C2,Circle), !.

/* otherwise two points containing diameter are returned */
find_two_characteristic_points_for_circle(_,diam(X,Y),[obj(point,X),obj(point,Y)],'WOncircle2') :- !.


/* ----------------------------------------------------------------- */

/* application of construction rules to the objects constructed so far; determining if the problem is locus-dependent */
update_known2(Known,_,AllUnknown,Output,Output,NDGs,NDGs,DETs,DETs,_,_,_)   :- mysublist(Known,AllUnknown), !.

update_known2(Known,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,ObjConstructed,[obj(line,L)],_) :- /*write('USAO U 1 '),*/
             not_element(Unknown,Known),
             some_contains_point(Unknown,ObjConstructed,[obj(line,L)]),
             find_two_characteristic_points_for_line(Known,L,Objs,Name),
             !, 
             /*DA LI OVDE STAVITI CUT? */
             write('Locus-dependent: Konstruise se: '), write(Unknown), 
             write(' kao online1 '), write(L), nl, 
             update_known2([Unknown|Known],Unknown,AllUnknown,
             [(Objs,[obj(line,L)],[Unknown],[],[],[],Name,[])|Input],Output,NDGs,NDGs1,DETs,DETs1,_,_,'W00'),
             !.

update_known2(Known,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,ObjConstructed,[obj(circle,C)],_) :- /*write('USAO u 2'),*/
             not_element(Unknown,Known),
             some_contains_point(Unknown,ObjConstructed,[obj(circle,C)]),
             find_two_characteristic_points_for_circle(Known,C,Objs,Name),
             !, 
             /*DA LI OVDE STAVITI CUT? */
             write('Locus-dependent: Konstruise se: '), write(Unknown), 
             write(' kao oncircle1 '), write(C), nl, 
             update_known2([Unknown|Known],Unknown,AllUnknown,
             [(Objs,[obj(circle,C)],[Unknown],[],[],[],Name,[])|Input],Output,NDGs,NDGs1,DETs,DETs1,_,_,'W00'), 
             !.
             
update_known2(Known_old,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,Obj_constructedPrev,X,IdPrev) :-
             basic_cons(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId),
             IdPrev@>RuleId,
             in_list1(Obj_constructedPrev,Obj_known,List), 
             List\=[],
             instantiate(Known_old,Obj_known), /* all objects from the premises of the rule are constructed */ 
             all_defs_or_lemmas(Props,[],LemmasUsed),  /* all properties are in definitions or lemmas */
             relevant_not_constructed_some(Obj_constructed,Props,Known_old), /* at least one object that is being constructed is relevant */ 
             not_in_list(Obj_constructed,Known_old,Obj_new), 
             Obj_new = Obj_constructed,  /* all objects that are being constructed are unknown */
             !, /* no backtracking */
             write('Locus-dependent: Konstruise se: '), write(Obj_new), write(' za pravilo:'), write(RuleId), nl, 
             myappend(Known_old,Obj_constructed,Known_new),
             myappend(NDGs,NDG,NDGs_new),
             myappend(DETs,DET,DETs_new),
             update_known2(Known_new,Unknown,AllUnknown,
                           [(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId,LemmasUsed)|Input],Output,NDGs_new,NDGs1,DETs_new,DETs1,Obj_constructed,X,RuleId), !.  

update_known2(Known_old,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,_,X,IdPrev) :- /*write('USAO u 4'),*/
             basic_cons(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId),
             IdPrev@=<RuleId,
             instantiate(Known_old,Obj_known), /* all objects from the premises of the rule are constructed */ 
             all_defs_or_lemmas(Props,[],LemmasUsed),  /* all properties are in definitions or lemmas */
             relevant_not_constructed_some(Obj_constructed,Props,Known_old), /* at least one object that is being constructed is relevant */ 
             not_in_list(Obj_constructed,Known_old,Obj_new), 
             Obj_new = Obj_constructed, /* all objects that are being constructed are unknown */
             !, /* no backtracking */
             write('Locus-dependent: Konstruise se: '), write(Obj_new), write(' za pravilo:'), write(RuleId), nl, 
             myappend(Known_old,Obj_constructed,Known_new),
             myappend(NDGs,NDG,NDGs_new),
             myappend(DETs,DET,DETs_new),
             update_known2(Known_new,Unknown,AllUnknown,
                           [(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId,LemmasUsed)|Input],Output,NDGs_new,NDGs1,DETs_new,DETs1,Obj_constructed,X,RuleId), !.  
                                                                   
update_known2(Known,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,_,_,_) :- /* write('USAO u 5'),*/
             element(Unknown,Known), /* problem jeste ld*/
             element(A,AllUnknown), 
             not_element(A,Known),
             A=obj(point,A1),
             element(P,Known),
             P=obj(line,P1),
             def_or_lemma(inc(A1,Q),_),
             equal_lines(P1,Q),
             find_two_characteristic_points_for_line(Known,P1,Objs,Name),
             !, 
             /*DA LI OVDE STAVITI CUT? */
             write('Locus-dependent: Konstruise se: '), write(A), 
             write(' kao online2 '), write(Q), nl, 
             update_known2([A|Known],Unknown,AllUnknown,
             [(Objs,[obj(line,P1)],[A],[],[],[],Name,[])|Input],Output,NDGs,NDGs1,DETs,DETs1,_,_,'W00'),
             !.

update_known2(Known,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,_,_,_) :- /* write('USAO u 6'),*/
             element(Unknown,Known), /* problem jeste ld*/
             element(A,AllUnknown), 
             not_element(A,Known),
             A=obj(point,A1),
             element(C,Known),
             C=obj(circle,C0),
             def_or_lemma(inc_k(A1,C1),_),
             equal_circles(C0,C1),
             find_two_characteristic_points_for_circle(Known,C0,Objs,Name),
             !, 
             /*DA LI OVDE STAVITI CUT? */
             write('Locus-dependent: Konstruise se: '), write(A), 
             write(' kao oncircle2 '), write(C), nl, 
             update_known2([A|Known],Unknown,AllUnknown,
             [(Objs,[obj(circle,C0)],[A],[],[],[],Name,[])|Input],Output,NDGs,NDGs1,DETs,DETs1,_,_,'W00'),
             !.

update_known2(Known,Unknown,AllUnknown,Input,Output,NDGs,NDGs1,DETs,DETs1,_,_,_) :- /* write('USAO u 7'),*/
             element(Unknown,Known), /* problem jeste ld*/
             element(A,AllUnknown), 
             not_element(A,Known), 
             /*menjano*/
             !,
             /*DA LI OVDE STAVITI CUT? */
             write('Locus-dependent: Konstruise se slobodna tacka: '), write(A), nl,
             update_known2([A|Known],Unknown,AllUnknown,
             [([],[],[A],[],[],[],'free',[])|Input],Output,NDGs,NDGs1,DETs,DETs1,_,_,'W00'),
             !.

update_known2(_,_,_,_,_,_,_,_,_,_,_,_)                                  :- !, fail.

/* ----------------------------------------------------------------- */

/* checking if some object from the list is relevant */
relevant_some([],_)         :- !, fail.
relevant_some([H|_], Props) :- relevant(H,Props).
relevant_some([_|T], Props) :- relevant_some(T,Props).

/* ----------------------------------------------------------------- */

/* checking if all objects from the list are relevant */
relevant_all([],_)         :- !.
relevant_all([H|T], Props) :- relevant(H,Props), relevant_all(T,Props).

/* ----------------------------------------------------------------- */

/* checking if an object is relevant */
relevant(obj(point,Obj),Props)  :- !, relevant_point(Obj,Props).
relevant(obj(line,Obj),Props)   :- !, relevant_line(Obj,Props).
relevant(obj(circle,Obj),Props) :- !, relevant_circle(Obj,Props).
relevant(obj(angle,Obj),Props)  :- !, relevant_angle(Obj,Props).

/* ----------------------------------------------------------------- */

/* object is relevant for the construction if it appears as an argument in some definition or lemma,
   apart from the one used for its construction (given by Props) */
relevant_point(Obj,Props) :- A = inc(Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = inc_k(Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = sratio(Obj,_,_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = sratio(_,Obj,_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = sratio(_,_,Obj,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = sratio(_,_,_,Obj,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = center(Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = harm(_,_,_,Obj), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = harm(_,_,Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = harm(_,Obj,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = harm(Obj,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = eq_dist(Obj,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_point(Obj,Props) :- A = eq_dist(_,_,Obj,_), def_or_lemma(A,_), not_element(A,Props).

/* ----------------------------------------------------------------- */

relevant_line(Obj,Props) :- A = inc(_,Obj), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = perp(_,Obj), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = perp(Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = perp_line_to_circ(Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = parallel(_,Obj), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = parallel(Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = eq_angle_compound(angle(Obj,_),_,_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = eq_angle_compound(angle(_,Obj),_,_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = eq_angle_compound(_,angle(Obj,_),_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = eq_angle_compound(_,angle(_,Obj),_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = eq_dist(_,Obj,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_line(Obj,Props) :- A = eq_dist(_,_,_,Obj), def_or_lemma(A,_), not_element(A,Props).

/* ----------------------------------------------------------------- */

relevant_circle(Obj,Props) :- A = inc_k(_,Obj), def_or_lemma(A,_), not_element(A,Props).
relevant_circle(Obj,Props) :- A = center(_,Obj), def_or_lemma(A,_), not_element(A,Props).
relevant_circle(Obj,Props) :- A = perp_line_to_circ(_,Obj), def_or_lemma(A,_), not_element(A,Props).
relevant_circle(Obj,Props) :- A = perp_circ_int(Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_circle(Obj,Props) :- A = perp_circ_int(_,Obj), def_or_lemma(A,_), not_element(A,Props).

/* ----------------------------------------------------------------- */

relevant_angle(Obj,Props) :- A = inc_k(_,over_chord([_,_],Obj)), def_or_lemma(A,_), 
                             not_element(A,Props).
relevant_angle(Obj,Props) :- A = eq_angle_compound(Obj,_,_,_,_,_), def_or_lemma(A,_), 
                             not_element(A,Props).
relevant_angle(Obj,Props) :- A = eq_angle_compound(_,Obj,_,_,_,_), def_or_lemma(A,_), 
                             not_element(A,Props).
/* ----------------------------------------------------------------- */

/* checking if all objects from the list are relevant */
relevant_not_constructed_some([],_,_)         :- !, fail.
relevant_not_constructed_some([H|_], Props,L) :- relevant_not_constructed(H,Props,L). 
relevant_not_constructed_some([_|T], Props,L) :- relevant_not_constructed_some(T,Props,L).

/* ----------------------------------------------------------------- */

/* checking if all objects from the list are relevant */
relevant_not_constructed_all([],_,_)         :- !.
relevant_not_constructed_all([H|T], Props,L) :- relevant_not_constructed(H,Props,L), relevant_not_constructed_all(T,Props,L).

/* ----------------------------------------------------------------- */

/* checking if an object is relevant */
relevant_not_constructed(obj(point,Obj),Props,L)  :- !, relevant_not_constructed_point(Obj,Props,L).
relevant_not_constructed(obj(line,Obj),Props,L)   :- !, relevant_not_constructed_line(Obj,Props,L).
relevant_not_constructed(obj(circle,Obj),Props,L) :- !, relevant_not_constructed_circle(Obj,Props,L).
relevant_not_constructed(obj(angle,Obj),Props,L)  :- !, relevant_not_constructed_angle(Obj,Props,L).

/* ----------------------------------------------------------------- */

/* object is relevant for the construction if it appears as an argument in some definition or lemma,
   apart from the one used for its construction (given by Props) and is relevant for the object not yet constructed */
relevant_not_constructed_point(Obj,Props,L) :- A = inc(Obj,X), def_or_lemma(A,_), not_element(A,Props), not_element(obj(line,X),L).
relevant_not_constructed_point(Obj,Props,L) :- A = inc_k(Obj,X), def_or_lemma(A,_), not_element(A,Props), not_element(obj(circle,X),L).
relevant_not_constructed_point(Obj,Props,L) :- A = center(Obj,X), def_or_lemma(A,_), not_element(A,Props),not_element(obj(circle,X),L).

/* treba i ovde prosiriti ali me sad mrzi*/
relevant_not_constructed_point(Obj,Props,_) :- A = sratio(Obj,_,_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_point(Obj,Props,_) :- A = sratio(_,Obj,_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_point(Obj,Props,_) :- A = sratio(_,_,Obj,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_point(Obj,Props,_) :- A = sratio(_,_,_,Obj,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_point(Obj,Props,_) :- A = harm(_,_,_,Obj), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_point(Obj,Props,_) :- A = harm(_,_,Obj,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_point(Obj,Props,_) :- A = harm(_,Obj,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_point(Obj,Props,_) :- A = harm(Obj,_,_,_), def_or_lemma(A,_), not_element(A,Props).

/* ----------------------------------------------------------------- */

relevant_not_constructed_line(Obj,Props,L) :- A = inc(X,Obj), def_or_lemma(A,_), not_element(A,Props), not_element(obj(point,X),L).
relevant_not_constructed_line(Obj,Props,L) :- A = perp(X,Obj), def_or_lemma(A,_), not_element(A,Props), not_element(obj(line,X),L).
relevant_not_constructed_line(Obj,Props,L) :- A = perp(Obj,X), def_or_lemma(A,_), not_element(A,Props), not_element(obj(line,X),L).
relevant_not_constructed_line(Obj,Props,L) :- A = perp_line_to_circ(Obj,X), def_or_lemma(A,_), not_element(A,Props), not_element(obj(circle,X),L).
relevant_not_constructed_line(Obj,Props,L) :- A = parallel(X,Obj), def_or_lemma(A,_), not_element(A,Props), not_element(obj(line,X),L).
relevant_not_constructed_line(Obj,Props,L) :- A = parallel(Obj,X), def_or_lemma(A,_), not_element(A,Props), not_element(obj(line,X),L).

/* treba i ovde prosiriti ali me sad mrzi*/
relevant_not_constructed_line(Obj,Props,_) :- A = eq_angle_compound(angle(Obj,_),_,_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_line(Obj,Props,_) :- A = eq_angle_compound(angle(_,Obj),_,_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_line(Obj,Props,_) :- A = eq_angle_compound(_,angle(Obj,_),_,_,_,_), def_or_lemma(A,_), not_element(A,Props).
relevant_not_constructed_line(Obj,Props,_) :- A = eq_angle_compound(_,angle(_,Obj),_,_,_,_), def_or_lemma(A,_), not_element(A,Props).

/* ----------------------------------------------------------------- */

relevant_not_constructed_circle(Obj,Props,L) :- A = inc_k(X,Obj), def_or_lemma(A,_), not_element(A,Props), not_element(obj(point,X),L).
relevant_not_constructed_circle(Obj,Props,L) :- A = center(X,Obj), def_or_lemma(A,_), not_element(A,Props), not_element(obj(point,X),L).
relevant_not_constructed_circle(Obj,Props,L) :- A = perp_line_to_circ(X,Obj), def_or_lemma(A,_), not_element(A,Props), not_element(obj(line,X),L).
relevant_not_constructed_circle(Obj,Props,L) :- A = perp_circ_int(Obj,X), def_or_lemma(A,_), not_element(A,Props), not_element(obj(circle,X),L).
relevant_not_constructed_circle(Obj,Props,L) :- A = perp_circ_int(X,Obj), def_or_lemma(A,_), not_element(A,Props), not_element(obj(circle,X),L).

/* ----------------------------------------------------------------- */

relevant_not_constructed_angle(Obj,Props,L) :- A = inc_k(X,over_chord([_,_],Obj)), def_or_lemma(A,_), 
                             not_element(A,Props), not_element(obj(point,X),L).
relevant_not_constructed_angle(Obj,Props,L) :- A = eq_angle_compound(Obj,X,_,_,_,_), def_or_lemma(A,_), 
                             not_element(A,Props), not_element(obj(angle,X),L).
relevant_not_constructed_angle(Obj,Props,L) :- A = eq_angle_compound(X,Obj,_,_,_,_), def_or_lemma(A,_), 
                             not_element(A,Props), not_element(obj(angle,X),L).

/* ----------------------------------------------------------------- */

/*kako ovo radi???? istestirati!!! */
/* simplification of the trace ('cleaning' procedure) */
simplify_construction([],_,Output,Output,RulesUsed,RulesUsed,LemmasUsed,LemmasUsed,NDGs,NDGs,DETs,DETs) :- !.
simplify_construction([(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId,LemmaList)|T],Unknown,Input,Output,Rules,Rules1,Lemmas,Lemmas1,NDGs,NDGs1,DETs,DETs1) :- 
                 in_list(Obj_constructed,Unknown,Obj_relevant),
                 Obj_relevant \= [], !,
                 myremove(Obj_relevant,Unknown,Unknown1),
                 myappend(Unknown1,Obj_known,Unknown_new),
                 myappend(NDGs,NDG,NDGs_new),
                 myappend(DETs,DET,DETs_new),
                 myunion([RuleId],Rules,RulesNew),
                 myunion(LemmaList,Lemmas,LemmasNew),
                 simplify_construction(T,Unknown_new,[(Obj_known,Values,Obj_constructed,Props,NDG,DET,RuleId,LemmaList)|Input],
                                       Output,RulesNew,Rules1,LemmasNew,Lemmas1,NDGs_new,NDGs1,DETs_new,DETs1).
simplify_construction([(_,_,_,_,_,_,_,_)|T],Unknown,Input,Output,Rules,Rules1,Lemmas,Lemmas1,NDGs,NDGs1,DETs,DETs1) :- 
                 simplify_construction(T,Unknown,Input,Output,Rules,Rules1,Lemmas,Lemmas1,NDGs,NDGs1,DETs,DETs1).
