
/* name of the object inside $$ signs */
xml_obj_name(H,XmlName) :- obj_name(H,Name), atom_concat('$',Name,R1),
                           atom_concat(R1,'$',XmlName), !.

xml_underline_obj_name(H,XmlName) :- obj_name(H,Name), underline_name(Name,UName), atom_concat('$',UName,R1),
                           atom_concat(R1,'$',XmlName), !.

/* ----------------------------------------------------------------- */

/* printing construction to xml file */
print_construction_to_xml_file(Trace_simp,Known,Name,Stream) :- 
                                      /*write('1.usao u pc xml'), nl, nl, nl,*/
                                      print_header_to_xml_file(Known,Name,Trace_simp,Stream),
                                      /*write('1.prosao print header xml'), nl, nl, nl,*/
                                      print_verification_to_xml_file(Known,Stream),
                                      /*write('1.prosao print verification xml'), nl, nl, nl,*/
                                      print_footer_to_xml_file(Stream), !.
print_construction_to_xml_file(_,_,_,_).

/* ----------------------------------------------------------------- */

/* predicate for testing generation of xml files */
/*print_to_xml(Trace_simp,Known,Name) :- 
                                   generate_all_xml_definitions([]),
                                   output_xml_file_name(Name,File2),
                                   open(File2,write,Stream),
                                   print_header_to_xml_file(Known,Name,Trace_simp,Stream),
                                   print_verification_to_xml_file(Known,Stream),
                                   print_footer_to_xml_file(Stream),
                                   close(Stream), !.*/

/* ----------------------------------------------------------------- */

/* printing header of xml file */
print_header_to_xml_file(Known,Name,Trace_simp,Stream) :- 
                                   write(Stream,'<?xml version="1.0" encoding="UTF-8"?>'), nl(Stream),
                                   write(Stream,'<!DOCTYPE geothm SYSTEM "geothm.dtd">'), nl(Stream),
                                   write(Stream,'<geothm name="Construction no. '), 
                                   write(Stream, Name), write(Stream, '">'), nl(Stream),
                                   tab(Stream,5), write(Stream,'<constructions>'), nl(Stream),
                                   print_known_objs_to_xml_file(Known,Stream),
                                   print_body_to_xml_file(Trace_simp,Stream),
                                   print_all_definitions_to_xml_file(Known,Stream),
                                   tab(Stream,5), write(Stream,'</constructions>'), nl(Stream), !.
                                                       
/* ----------------------------------------------------------------- */

/* printing objects that are given in the construction to xml file */
print_known_objs_to_xml_file([],_) :- /*write('prosao print known objects'), nl,*/ !.
print_known_objs_to_xml_file([H|T],Stream) :- xml_obj_name(H,Name), 
                                              tab(Stream,10), write(Stream,'<pfree label="'), 
                                              write(Stream,Name), write(Stream,'" />'), nl(Stream),
                                              print_known_objs_to_xml_file(T,Stream).

/* ----------------------------------------------------------------- */

/* printing a body of construction to xml file */
print_body_to_xml_file(Trace_simp,Stream) :- /*write('Trace simp:'), write(Trace_simp), nl, */
                                             print_steps_to_xml_file(Trace_simp,Stream), 
                                             /*write('prosao print body'), nl, nl,*/ !.

/* ----------------------------------------------------------------- */

/* printing a list of high-level construction steps to xml file */
print_steps_to_xml_file([],_)         :- !.
print_steps_to_xml_file([H|T],Stream) :- print_step_to_xml_file(H,Stream), 
                                         /*write('prosao print step za: '), write(H), nl,*/
                                         print_steps_to_xml_file(T,Stream).

/* ----------------------------------------------------------------- */

/* printing a high-level construction step to xml file */
print_step_to_xml_file((L,Values,Obj,_,_,_,Name,_),Stream) :- write('PREVODIMO KORAK: '), write(L), nl,
                                                              write(Values), nl, write(Obj), nl, write(Name), nl,
                                                              translate_to_xml(L,Values,Obj,Name,Steps),
                                                              write_steps_to_xml_file(Steps,Stream).

/* ----------------------------------------------------------------- */

/* printing a list of gclc instructions to xml file */
write_steps_to_xml_file([],_)         :- !.
write_steps_to_xml_file([H|T],Stream) :- tab(Stream,10), write_step_to_xml_file(H,Stream), /*write('prosao '), write(H), nl, */
                                         nl(Stream),
                                         write_steps_to_xml_file(T,Stream).

/* ----------------------------------------------------------------- */

/* printing a gclc instruction to xml file */
write_step_to_xml_file(('psegdiv',[A,B],[Val],[Constr]),Stream) :- !,
                                                         write(Stream,'<psegdiv label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" point1="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" point2="'),
                                                         xml_obj_name(B,Name2), write(Stream,Name2),
                                                         write(Stream,'" coeff="'),
                                                         Val1 is Val/(1-Val),
                                                         write(Stream,Val1),
                                                         write(Stream,'" />').
write_step_to_xml_file(('ptranslated',[X,Y,Z],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<ptranslated label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" point1="'),
                                                         xml_obj_name(X,Name1), write(Stream,Name1),
                                                         write(Stream,'" point2="'),
                                                         xml_obj_name(Y,Name2), write(Stream,Name2),
                                                         write(Stream,'" origpt="'),
                                                         xml_obj_name(Z,Name3), write(Stream,Name3),
                                                         write(Stream,'" />').
write_step_to_xml_file(('ltwopts',[A,B],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<ltwopts label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" point1="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" point2="'),
                                                         xml_obj_name(B,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('pintersect',[A,B],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<pintersect label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" set1="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" set2="'),
                                                         xml_obj_name(B,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('ccenterpt',[O,A],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<ccenterpt label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" center="'),
                                                         xml_obj_name(O,Name1), write(Stream,Name1),
                                                         write(Stream,'" point="'),
                                                         xml_obj_name(A,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('pfoot',[O,P],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<pfoot label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" origpt="'),
                                                         xml_obj_name(O,Name1), write(Stream,Name1),
                                                         write(Stream,'" baseline="'),
                                                         xml_obj_name(P,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('lperp',[O,P],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<lperp label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" point="'),
                                                         xml_obj_name(O,Name1), write(Stream,Name1),
                                                         write(Stream,'" baseline="'),
                                                         xml_obj_name(P,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('pmid',[A,B],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<pmid label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" point1="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" point2="'),
                                                         xml_obj_name(B,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('ltangent',[A,C],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<ltangent label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" basept="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" pointset="'),
                                                         xml_obj_name(C,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('lperpbis',[A,B],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<lperpbis label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" point1="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" point2="'),
                                                         xml_obj_name(B,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('langbis',[A,B,C],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<langbis label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" firstraypt="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" vertex="'),
                                                         xml_obj_name(B,Name2), write(Stream,Name2),
                                                         write(Stream,'" secondraypt="'),
                                                         xml_obj_name(C,Name3), write(Stream,Name3),
                                                         write(Stream,'" />').
write_step_to_xml_file(('langray',[A,B,D,E,F],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<langray label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" firstraypt="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" vertex="'),
                                                         xml_obj_name(B,Name2), write(Stream,Name2),
                                                         write(Stream,'" congangfrp="'),
                                                         xml_obj_name(D,Name3), write(Stream,Name3),
                                                         write(Stream,'" congangv="'),
                                                         xml_obj_name(E,Name4), write(Stream,Name4),
                                                         write(Stream,'" congangsrp="'),
                                                         xml_obj_name(F,Name5), write(Stream,Name5),
                                                         write(Stream,'" />').
write_step_to_xml_file(('lparallel',[O,P],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<lparallel label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" point="'),
                                                         xml_obj_name(O,Name1), write(Stream,Name1),
                                                         write(Stream,'" baseline="'),
                                                         xml_obj_name(P,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('pharmonicconj',[A,B,C],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<pharmonicconj label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" point1="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" point2="'),
                                                         xml_obj_name(B,Name2), write(Stream,Name2),
                                                         write(Stream,'" point3="'),
                                                         xml_obj_name(C,Name3), write(Stream,Name3),
                                                         write(Stream,'" />').
write_step_to_xml_file(('protated',[X,Value,Y],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<protated label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" origpt="'),
                                                         xml_obj_name(X,Name1), write(Stream,Name1),
                                                         write(Stream,'" center="'),
                                                         xml_obj_name(Y,Name2), write(Stream,Name2),
                                                         write(Stream,'" angmeasure="'),
                                                         write(Stream,Value),
                                                         write(Stream,'" />').
write_step_to_xml_file(('pfree',[],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<pfree label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" />').
write_step_to_xml_file(('prandline',[L],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<prandline label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" line="'),
                                                         xml_obj_name(L,Name1), write(Stream,Name1),
                                                         write(Stream,'" />').

write_step_to_xml_file(('prandcircle',[C],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<prandcircle label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" circle="'),
                                                         xml_obj_name(C,Name1), write(Stream,Name1),
                                                         write(Stream,'" />').

write_step_to_xml_file(('pcentralsymm',[O,A],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<pcentralsymm label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" origpt="'),
                                                         xml_obj_name(A,Name1), write(Stream,Name1),
                                                         write(Stream,'" center="'),
                                                         xml_obj_name(O,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file(('preflexive',[B,L],[],[Constr]),Stream) :- !,
                                                         write(Stream,'<preflexive label ="'), 
                                                         xml_obj_name(Constr,Name), write(Stream,Name),
                                                         write(Stream,'" origpt="'),
                                                         xml_obj_name(B,Name1), write(Stream,Name1),
                                                         write(Stream,'" baseline="'),
                                                         xml_obj_name(L,Name2), write(Stream,Name2),
                                                         write(Stream,'" />').
write_step_to_xml_file((_,_,_,_,_),Stream) :- write(Stream,'nije uspelo').

/* ----------------------------------------------------------------- */

/* printing verification statements to xml file */
print_verification_to_xml_file(Known,Stream) :- tab(Stream,5),
                                                write(Stream,'<statement>'), nl(Stream),
                                                print_theorems_to_xml_file(Known,Stream),
                                                tab(Stream,5),
                                                write(Stream,'</statement>'), nl(Stream), !.

/* ----------------------------------------------------------------- */

/* printing theorems that points are identical for all objects except vertices of the triangle */
print_theorems_to_xml_file([],_)         :- !.
print_theorems_to_xml_file([H|T],Stream) :- print_theorem_to_xml_file(H,Stream), 
                                            /*write('prosao def '), write(H), nl,*/
                                            print_theorems_to_xml_file(T,Stream).

/* ----------------------------------------------------------------- */

/* printing one theorem to xml file */
print_theorem_to_xml_file(obj(point,O),Stream) :- not_element(O,['a','b','c']), !, 
                                                  tab(Stream,10),                                  
                                                  write(Stream,'<identicpts point1="'),
                                                  xml_obj_name(obj(point,O),Name),
                                                  xml_underline_obj_name(obj(point,O),Name1),
                                                  write(Stream,Name), write(Stream,'" point2="'), write(Stream,Name1),
                                                  write(Stream,'" />'), nl(Stream).
print_theorem_to_xml_file(_,_)                 :- !.

/* ----------------------------------------------------------------- */

/* printing footer of construction to xml file */
print_footer_to_xml_file(Stream) :- write(Stream,'</geothm>'), nl(Stream), !.

/* ----------------------------------------------------------------- */

/* print all definitions to xml file */
print_all_definitions_to_xml_file(Known,Stream) :- 
                                    without_types(Known,Known1),
                                    /* we need to pay attention to the order in which definitions are printed */
                                    /*write('AAAAprosao without types '), nl,*/
                                    order(Known1,Known2),
                                    /*write('AAAAprosao order '), nl, */
                                    collect_all(Known2,Objs),
                                    /*write('AAAAprosao collect all '), nl,*/
                                    print_definitions_to_xml_file(Objs,Stream),
                                    /*write('AAAAprosao print def'), nl,*/
                                    !.

/* ----------------------------------------------------------------- */

/* printing definition of all collected objects to xml file */
print_definitions_to_xml_file([],_)         :- !.
print_definitions_to_xml_file([H|T],Stream) :- print_definition_to_xml_file(H,Stream), 
                                               /*write('BBBBprosao print definition za :'), write(H), nl,*/
                                               print_definitions_to_xml_file(T,Stream).

/* ----------------------------------------------------------------- */

/* print a definition to xml file */
print_definition_to_xml_file(O,Stream) :- not_element(O,['a','b','c']), !,
                                          /*write('XXXXXXXispis za definiciju za:'), write(O),*/
                                          xml_def(O,O1),
                                          /*write('prosao O1:'), write(O1), nl, nl, nl,*/
                                          tab(Stream,10),
                                          write(Stream,O1), nl(Stream).
print_definition_to_xml_file(_,_)      :- !.

/* ----------------------------------------------------------------- */

/* generation of all xml definitions, based upon prolog definitions
  this is performed exactly once, at the begining of the proving process */
generate_all_xml_definitions(_)    :- x, !.
generate_all_xml_definitions(Defs) :- /*write('pokusavamo za P: '),*/
                                       generate_xml_definitions(P,Def),
                                       not_element(P,Defs), !,
                                       /*write('prosla definicija'),*/
                                       assert(xml_def(P,Def)),
                                       /* provera */
                                       write(xml_def(P,Def)), nl,
                                       generate_all_xml_definitions([P|Defs]),
                                       assert(x).
generate_all_xml_definitions(_) :- !.

/* ----------------------------------------------------------------- */

/* generation of one xml definition; it differs for each type of definition */                                                             
generate_xml_definitions(Y,Def) :- def(Y,[sratio(X,Y,X,Z,K,L)],_),
                                   xml_underline_obj_name(obj(point,X),XU),
                                   xml_underline_obj_name(obj(point,Y),YU),
                                   xml_underline_obj_name(obj(point,Z),ZU),
                                   C is K/(L-K),
                                   atom_concat('<psegdiv label="',YU,R1),
                                   atom_concat(R1,'" point1="',R2),
                                   atom_concat(R2,XU,R3),
                                   atom_concat(R3,'" point2="',R4),
                                   atom_concat(R4,ZU,R5),
                                   atom_concat(R5,'" coeff="',R6),
                                   atom_concat(R6,C,R7),
                                   atom_concat(R7,'" />',Def).
generate_xml_definitions(P,Def) :- def(P,L,_), 
                                   equal(L,[eq_angle_compound(angle(L1,L2),
                                                              angle(L2,L3),1,0,0,0)]),
                                   def_or_lemma(inc(A,L1),_), def_or_lemma(inc(C,L1),_), notequal(A,C),
                                   def_or_lemma(inc(C,L3),_), def_or_lemma(inc(B,L3),_), notequal(B,C),
                                   xml_underline_obj_name(obj(point,A),AU),
                                   xml_underline_obj_name(obj(point,B),BU),
                                   xml_underline_obj_name(obj(point,C),CU),
                                   xml_underline_obj_name(obj(line,L2),L2U),
                                   atom_concat('<langbis label="',L2U,R1),
                                   atom_concat(R1,'" firstraypt="',R2),
                                   atom_concat(R2,AU,R3),
                                   atom_concat(R3,'" vertex="',R4),
                                   atom_concat(R4,CU,R5),
                                   atom_concat(R5,'" secondraypt="',R6),
                                   atom_concat(R6,BU,R7),
                                   atom_concat(R7,'" />',Def).
generate_xml_definitions(C,Def) :- def(C,[center(O,C),inc_k(A,C)],_),
                                   xml_underline_obj_name(obj(point,O),OU),
                                   xml_underline_obj_name(obj(point,A),AU),
                                   xml_underline_obj_name(obj(circle,C),CU),
                                   atom_concat('<ccenterpt label="',CU,R1),
                                   atom_concat(R1,'" center="',R2),
                                   atom_concat(R2,OU,R3),
                                   atom_concat(R3,'" point="',R4),
                                   atom_concat(R4,AU,R5),
                                   atom_concat(R5,'" />',Def).
generate_xml_definitions(P,Def) :- def(P,[inc(A,P),inc(B,P)],_),
                                   xml_underline_obj_name(obj(line,P),PU),
                                   xml_underline_obj_name(obj(point,A),AU),
                                   xml_underline_obj_name(obj(point,B),BU),
                                   atom_concat('<ltwopts label="',PU,R1),
                                   atom_concat(R1,'" point1="',R2),
                                   atom_concat(R2,AU,R3),
                                   atom_concat(R3,'" point2="',R4),
                                   atom_concat(R4,BU,R5),
                                   atom_concat(R5,'" />',Def).
generate_xml_definitions(A,Def) :- def(A,[inc(A,P),inc(A,Q)],_), 
                                   xml_underline_obj_name(obj(line,P),PU),
                                   xml_underline_obj_name(obj(point,A),AU),
                                   xml_underline_obj_name(obj(line,Q),QU),
                                   atom_concat('<pintersect label="',AU,R1),
                                   atom_concat(R1,'" set1="',R2),
                                   atom_concat(R2,PU,R3),
                                   atom_concat(R3,'" set2="',R4),
                                   atom_concat(R4,QU,R5),
                                   atom_concat(R5,'" />',Def).
generate_xml_definitions(P,Def) :- def(P,L,_),
                                   equal(L,[inc(X,P),perp(P,Q)]),
                                   xml_underline_obj_name(obj(point,X),XU),
                                   xml_underline_obj_name(obj(line,P),PU),
                                   xml_underline_obj_name(obj(line,Q),QU),
                                   atom_concat('<lperp label="',PU,R1),
                                   atom_concat(R1,'" point="',R2),
                                   atom_concat(R2,XU,R3),
                                   atom_concat(R3,'" baseline="',R4),
                                   atom_concat(R4,QU,R5),
                                   atom_concat(R5,'" />',Def).

/* ----------------------------------------------------------------- */

/* translating high-level construction rules used in program to OGP's xml format */
translate_to_xml([X,X,Y],[obj(_,K),obj(_,L)],[Z],'W01',[('psegdiv',[X,Y],[V],[Z])]) :-
                 !, V is K/L.

translate_to_xml([X,Y,Z],[obj(_,K),obj(_,L)],[W],'W01',[('ptranslated',[Y,X,Z],[],[I]),
                                          ('psegdiv',[X,I],[V],[W])]) :-
                 !, I=obj(point,_),
                 V is K/L.

translate_to_xml([X,Y],[],[P],'W02',[('ltwopts',[X,Y],[],[P])]) :- !.

translate_to_xml([P,Q],[],[A],'W03',[('pintersect',[P,Q],[],[A])]) :- !.

translate_to_xml([C,P],[],[A,B],'W04',[('pintersect',[C,P],[],[A]),
                                       ('pintersect',[C,P],[],[B])]) :- !.

translate_to_xml([_,P,O,A],[],[B],'W05',[('pfoot',[O,P],[],[O1]),
                                         ('pcentralsymm',[O1,A],[],[B])]) :-
                  !, O1=obj(point,_).

translate_to_xml([_,_,O,A],[],[B],'W05a',[('pcentralsymm',[O,A],[],[B])]) :- !.

translate_to_xml([A,O],[],[C],'W06',[('ccenterpt',[O,A],[],[C])]) :- !.

translate_to_xml([C,C1],[],[A,B],'W07',[('pintersect',[C,C1],[],[A]),
                                        ('pintersect',[C,C1],[],[B])]) :- !.

translate_to_xml([_,_,A,O1,O2],[],[B],'W08',[('ltwopts',[O1,O2],[],[P]),
                                             ('pfoot',[A,P],[],[O]),
                                             ('pcentralsymm',[O,A],[],[B])]) :-
                   !, P=obj(line,_), O=obj(point,_).

translate_to_xml([A,B],[],[C],'W09',[('pmid',[A,B],[],[O]),
                                     ('ccenterpt',[O,A],[],[C])]) :-
                   !, O=obj(point,_).

translate_to_xml([A,P],[],[Q],'W10a',[('lperp',[A,P],[],[Q])]) :- !.

translate_to_xml([A,P],[],[Q],'W10b',[('lperp',[A,P],[],[Q])]) :- !.

translate_to_xml([A,P],[],[C],'W11',[('pfoot',[A,P],[],[A1]),
                                     ('ccenterpt',[A,A1],[],[C])]) :-
                   !, A1=obj(point,_).

translate_to_xml([C,A,_],[],[P,Q],'W12',[('ltangent',[A,C],[],[P]),
                                         ('ltangent',[A,C],[],[Q])]) :- !.

translate_to_xml([_,A,O,Q],[],[P],'W13',[('pfoot',[O,Q],[],[B]),
                                         ('ltwopts',[O,A],[],[L]),
                                         ('preflexive',[B,L],[],[C]),
                                         ('ltwopts',[A,C],[],[P])]):-
                   !, B=obj(point,_),
                   L=obj(line,_),
                   C=obj(point,_).

translate_to_xml([A,B],[],[P],'W14',[('lperpbis',[A,B],[],[P])]) :- !.

translate_to_xml([A,P,X],[obj(_,K),obj(_,L)],[Q],'W15',[('psegdiv',[A,X],[V],[Z]),
                                          ('lparallel',[Z,P],[],[Q])]) :-
                   !, V is K/L,
                   Z=obj(point,_).

translate_to_xml([A,P],[],[Q],'W16',[('lparallel',[A,P],[],[Q])]).

/* treba da konstruisemo ugao K1*(1/2)^K2*alpha+K3*(1/2)^K4*pi */
translate_to_xml([A,B,_,P1,P2,P3,_,_],[obj(_,K1),obj(_,K2),obj(_,K3),obj(_,K4)],[S],'W17',Steps) :-
                   K3<0, !,
                   write('W20b'), nl,
                   V2 is -180,
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   X5=obj(point,_),
                   X6=obj(point,_),
                   X7=obj(point,_),
                   Beg = [('langray',[B,A,P1,P2,P3],[],[S2]), /* konstruisemo ugao velicine P1P2P3 pocev od zraka AB */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   write('w20 - AAAA'), nl,
                   divide_by_two([B,A,X2],K2,X3,[],Text1),
                   write('w20 - BBBB'), nl,
                   multiply([B,A,X3],X3,K1,X4,[],Text2),
                   write('w20 - cccc'), nl,
                   Mid = [('protated',[X4,V2,A],[],[X5])], /* konstruisemo ugao od PI - to je ugao X4AX5 */
                   K31 is -K3,
                   divide_by_two([X4,A,X5],K4,X6,[],Text3),
                   multiply([X4,A,X6],X6,K31,X7,[],Text4),
                   write('w20 - dddd'), nl,
                   En = [('ltwopts',[A,X7],[],[S])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,Mid,Pom3),
                   myappend(Pom3,Text3,Pom4),
                   myappend(Pom4,Text4,Pom5),
                   myappend(Pom5,En,Steps)
                   ,write('w20 - eeee'),
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl.


translate_to_xml([A,B,_,P1,P2,P3,_,_],[obj(_,K1),obj(_,K2),obj(_,K3),obj(_,K4)],[S],'W17',Steps) :-
                   K3 > 0, !,
                   write('W20'), nl,
                   V2 is 180,
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   X5=obj(point,_),
                   X6=obj(point,_),
                   X7=obj(point,_),
                   Beg = [('langray',[B,A,P1,P2,P3],[],[S2]), /* konstruisemo ugao velicine P1P2P3 pocev od zraka AB */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   write('w20 - AAAA'), nl,
                   divide_by_two([B,A,X2],K2,X3,[],Text1),
                   write('w20 - BBBB'), nl,
                   multiply([B,A,X3],X3,K1,X4,[],Text2),
                   write('w20 - cccc'), nl,
                   Mid = [('protated',[X4,V2,A],[],[X5])], /* konstruisemo ugao od PI - to je ugao X4AX5 */
                   divide_by_two([X4,A,X5],K4,X6,[],Text3),
                   multiply([X4,A,X6],X6,K3,X7,[],Text4),
                   write('w20 - dddd'), nl,
                   En = [('ltwopts',[A,X7],[],[S])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,Mid,Pom3),
                   myappend(Pom3,Text3,Pom4),
                   myappend(Pom4,Text4,Pom5),
                   myappend(Pom5,En,Steps)
                   ,write('w20 - eeee'),
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl.

translate_to_xml([A,B,_,P1,P2,P3,_,_],[obj(_,K1),obj(_,K2),obj(_,K3),_],[S],'W17',Steps) :-
                   K3=0, !,
                   write('W201'), nl,
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   Beg = [('langray',[B,A,P1,P2,P3],[],[S2]), /* konstruisemo ugao velicine P1P2P3 pocev od zraka AB - PROVERI */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   write('w201 - AAAA'), nl,
                   divide_by_two([B,A,X2],K2,X3,[],Text1),
                   write('w201 - BBBB'), nl,
                   multiply([B,A,X3],X3,K1,X4,[],Text2),
                   write('w201 - CCCC'), nl,
                   En = [('ltwopts',[A,X4],[],[S])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,En,Steps)
                   ,
                   write('w201 - DDDD'), nl,
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl.

/* treba da konstruisemo ugao -K1*(1/2)^K2*alpha-K3*(1/2)^K4*pi */
translate_to_xml([_,_,_,A,B,P1,P2,P3],[obj(_,K1),obj(_,K2),obj(_,K3),obj(_,K4)],[S],'W18',Steps) :-
                   K3< 0, !,
                   /*write('W21'), nl,*/
                   V2 is 180,
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   X5=obj(point,_),
                   X6=obj(point,_),
                   X7=obj(point,_),
                   Beg = [('langray',[B,A,P3,P2,P1],[],[S2]), /* konstruisemo ugao velicine P3P2P1 pocev od zraka AB */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   /*write('w21 - AAAA'), nl,*/
                   divide_by_two([B,A,X2],K2,X3,[],Text1),
                   /*write('w21 - BBBB'), nl,*/
                   multiply([B,A,X3],X3,K1,X4,[],Text2),
                   /*write('w21 - cccc'), nl,*/
                   Mid = [('protated',[X4,V2,A],[],[X5])], /* konstruisemo ugao od PI - to je ugao X4AX5 */
                   divide_by_two([X4,A,X5],K4,X6,[],Text3),
                   K31 is -K3,
                   multiply([X4,A,X6],X6,K31,X7,[],Text4),
                   /*write('w21 - dddd'), nl,*/
                   En = [('ltwopts',[A,X7],[],[S])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,Mid,Pom3),
                   myappend(Pom3,Text3,Pom4),
                   myappend(Pom4,Text4,Pom5),
                   myappend(Pom5,En,Steps)
                   /*, write('w21 - eeee'), nl,
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl */.

/* treba da konstruisemo ugao -K1*(1/2)^K2*alpha-K3*(1/2)^K4*pi */
translate_to_xml([_,_,_,A,B,P1,P2,P3],[obj(_,K1),obj(_,K2),obj(_,K3),obj(_,K4)],[S],'W18',Steps) :-
                   K3> 0, !,
                   /*write('W21'), nl,*/
                   V2 is -180,
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   X5=obj(point,_),
                   X6=obj(point,_),
                   X7=obj(point,_),
                   Beg = [('langray',[B,A,P3,P2,P1],[],[S2]), /* konstruisemo ugao velicine P3P2P1 pocev od zraka AB */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   /*write('w21 - AAAA'), nl,*/
                   divide_by_two([B,A,X2],K2,X3,[],Text1),
                   /*write('w21 - BBBB'), nl,*/
                   multiply([B,A,X3],X3,K1,X4,[],Text2),
                   /*write('w21 - cccc'), nl,*/
                   Mid = [('protated',[X4,V2,A],[],[X5])], /* konstruisemo ugao od PI - to je ugao X4AX5 */
                   divide_by_two([X4,A,X5],K4,X6,[],Text3),
                   multiply([X4,A,X6],X6,K3,X7,[],Text4),
                   /*write('w21 - dddd'), nl,*/
                   En = [('ltwopts',[A,X7],[],[S])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,Mid,Pom3),
                   myappend(Pom3,Text3,Pom4),
                   myappend(Pom4,Text4,Pom5),
                   myappend(Pom5,En,Steps)
                   /*,
                   write('w21 - eeee'), nl,
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl */.

translate_to_xml([_,_,_,A,B,P1,P2,P3],[obj(_,K1),obj(_,K2),obj(_,K3),_],[S],'W18',Steps) :-
                   K3=0, !,
                   /*write('w211'), nl,*/
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   Beg = [('langray',[B,A,P3,P2,P1],[],[S2]), /* konstruisemo ugao velicine P3P2P1 pocev od zraka AB - PROVERI */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   /*write('w211 - AAAA'), nl,*/
                   divide_by_two([B,A,X2],K2,X3,[],Text1),
                   /*write('w211 - BBBB'), nl,*/
                   multiply([B,A,X3],X3,K1,X4,[],Text2),
                   /*write('w211 - CCCC'), nl,*/
                   En = [('ltwopts',[A,X4],[],[S])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,En,Steps)
                   /*,
                   write('w211 - DDDD'), nl,
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl */.


translate_to_xml([A,B,C,_],[],[D],'W19',[('pharmonicconj',[A,B,C],[],[D])]) :- !.

/* treba da konstruisemo ugao 90-K1*(1/2)^K2*alpha+K3*(1/2)^K4*pi */
translate_to_xml([A,B,P1,P2,P3],[obj(_,K1),obj(_,K2),obj(_,K3),obj(_,K4)],[C],'W20',Steps) :-
                   K3< 0, !,
                   /*write('w25a'), nl,*/
                   V1 is 90,
                   V2 is -180,
                   X1=obj(point,_),
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   X5=obj(point,_),
                   X6=obj(point,_),
                   X7=obj(point,_),
                   L2=obj(line,_),
                   Q=obj(line,_),
                   O=obj(point,_),
                   /*write('w25a - AAAA'), nl,*/
                   Beg = [('protated',[B,V1,A],[],[X1]), /* pravimo ugao od 90 stepeni */
                          ('langray',[X1,A,P3,P2,P1],[],[S2]), /* konstruisemo ugao velicine P3P2P1 pocev od zraka AX1 - PROVERI */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   divide_by_two([X1,A,X2],K2,X3,[],Text1),
                   /*write('w25a - BBBB'), nl,*/
                   multiply([X1,A,X3],X3,K1,X4,[],Text2),
                   /*write('w25a - BBBB'), nl,*/
                   Mid = [('protated',[X4,V2,A],[],[X5])], /* konstruisemo ugao od PI - to je ugao X4AX5 */
                   divide_by_two([X4,A,X5],K4,X6,[],Text3),
                   K31 is -K3,
                   multiply([X4,A,X6],X6,K31,X7,[],Text4),
                   /*write('w25a - CCCC'), nl,*/
                   En = [('ltwopts',[A,X7],[],[L2]),
                         ('lperpbis',[A,B],[],[Q]),
                         ('pintersect',[Q,L2],[],[O]),
                         ('ccenterpt',[O,A],[],[C])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,Mid,Pom3),
                   myappend(Pom3,Text3,Pom4),
                   myappend(Pom4,Text4,Pom5),
                   myappend(Pom5,En,Steps)
                   /*,
                   write('w25a - DDDD'), nl,
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl*/ .

translate_to_xml([A,B,P1,P2,P3],[obj(_,K1),obj(_,K2),obj(_,K3),obj(_,K4)],[C],'W20',Steps) :-

                   K3> 0, !,
                   /*write('w25a'), nl,*/
                   V1 is 90,
                   V2 is 180,
                   X1=obj(point,_),
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   X5=obj(point,_),
                   X6=obj(point,_),
                   X7=obj(point,_),
                   L2=obj(line,_),
                   Q=obj(line,_),
                   O=obj(point,_),
                   /*write('w25a - AAAA'), nl,*/
                   Beg = [('protated',[B,V1,A],[],[X1]), /* pravimo ugao od 90 stepeni */
                          ('langray',[X1,A,P3,P2,P1],[],[S2]), /* konstruisemo ugao velicine P3P2P1 pocev od zraka AX1 - PROVERI */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   divide_by_two([X1,A,X2],K2,X3,[],Text1),
                   /*write('w25a - BBBB'), nl,*/
                   multiply([X1,A,X3],X3,K1,X4,[],Text2),
                   /*write('w25a - BBBB'), nl,*/
                   Mid = [('protated',[X4,V2,A],[],[X5])], /* konstruisemo ugao od PI - to je ugao X4AX5 */
                   divide_by_two([X4,A,X5],K4,X6,[],Text3),
                   multiply([X4,A,X6],X6,K3,X7,[],Text4),
                   /*write('w25a - CCCC'), nl,*/
                   En = [('ltwopts',[A,X7],[],[L2]),
                         ('lperpbis',[A,B],[],[Q]),
                         ('pintersect',[Q,L2],[],[O]),
                         ('ccenterpt',[O,A],[],[C])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,Mid,Pom3),
                   myappend(Pom3,Text3,Pom4),
                   myappend(Pom4,Text4,Pom5),
                   myappend(Pom5,En,Steps)
                   /*,write('w25a - DDDD'), nl,
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl*/ .



/* treba da konstruisemo ugao 90-K1*(1/2)^K2*alpha */
translate_to_xml([A,B,P1,P2,P3],[obj(_,K1),obj(_,K2),obj(_,K3),_],[C],'W20',Steps) :-

                   K3=0, !,
                   /*write('w25a1'), nl,*/
                   V1 is 90,
                   X1=obj(point,_),
                   S2=obj(line,_),
                   X2=obj(point,_),
                   X3=obj(point,_),
                   X4=obj(point,_),
                   L2=obj(line,_),
                   Q=obj(line,_),
                   O=obj(point,_),
                   Beg = [('protated',[B,V1,A],[],[X1]), /* pravimo ugao od 90 stepeni */
                          ('langray',[X1,A,P3,P2,P1],[],[S2]), /* konstruisemo ugao velicine P3P2P1 pocev od zraka AX1 - PROVERI */
                          ('prandline',[S2],[],[X2])], /* OVO NIJE DOBRO, TREBA MI PROIZVOLJNA TACKA SA ZRAKA S2, A NE PRAVE */
                   /*write('w25a1 - AAAA'), nl,*/
                   divide_by_two([X1,A,X2],K2,X3,[],Text1),
                   /*write('w25a1 - BBBB'), nl,*/
                   multiply([X1,A,X3],X3,K1,X4,[],Text2),
                   /*write('w25a1 - CCCC'), nl,*/
                   En = [('ltwopts',[A,X4],[],[L2]),
                         ('lperpbis',[A,B],[],[Q]),
                         ('pintersect',[Q,L2],[],[O]),
                         ('ccenterpt',[O,A],[],[C])],
                   myappend(Beg,Text1,Pom1),
                   myappend(Pom1,Text2,Pom2),
                   myappend(Pom2,En,Steps)
                   /*,write('w25a1 - DDDD'), nl,
                   nl, write('Koraci:'), nl,
                   print_list_to_stdout(Steps), nl */.

translate_to_xml([A,P],[],[B],'W21',[('pfoot',[A,P],[],[B])]) :- !.

/* za tacku X1 treba izabrati blizu, kako? */
translate_to_xml([A,B,O,_],[],[C],'W22',[('ltwopts',[A,O],[],[L]),
                                             ('pintersect',[B,L],[],[X1]),
                                             ('ccenterpt',[A,X1],[],[C])]) :-
                   !,
                   L=obj(line,_),
                   X1=obj(point,_).

translate_to_xml([A,_,O,X],[obj(_,K),obj(_,L)],[C1],'W23',[('psegdiv',[A,X],[V],[X1]),
                                             ('psegdiv',[A,O],[V],[O1]),
                                             ('ccenterpt',[O1,X1],[],[C1])]) :-
                   !, V is K/L,
                   X1=obj(point,_),
                   O1=obj(point,_).




translate_to_xml([],[],[A],'free',[('pfree',[],[],[A])]) :- !.

translate_to_xml([L,_,_],_,[A],'WOnline1',[('prandline',[L],[],[A])]) :- !.

translate_to_xml([L,_,_],_,[A],'WOnline2',[('prandline',[L],[],[A])]) :- !.

translate_to_xml([_,A,B,P,K,L],_,[C],'WOnline3',[('psegdiv',[P,A],[V],[A1]),
                                                  ('psegdiv',[P,B],[V],[B1]),
                                                  ('ltwopts',[A1,B1],[],[Line]),
                                                  ('prandline',[Line],[],[C])]) :-
                   !, V is K/(K-L),
                   A1=obj(point,_),
                   B1=obj(point,_),
                   Line=obj(line,_).

translate_to_xml([Line,A,_,P,K,L],_,[C],'WOnline4',[('psegdiv',[P,A],[V],[A1]),
                                                     ('lparallel',[A1,Line],[],[Line1]),
                                                     ('prandline',[Line1],[],[C])]) :-
                   !, V is K/(K-L),
                   A1=obj(point,_),
                   Line1=obj(line,_).

translate_to_xml([O,P],_,[A],'WOncircle1',[('ccenterpt',[O,P],[],[C]),
                                            ('prandcircle',[C],[],[A])]) :-
                   !, C=obj(circle,_).

translate_to_xml([X,Y],_,[A],'WOncircle2',[('pmid',[X,Y],[],[M]),
                                            ('ccenterpt',[X,Y],[],[C]),
                                            ('prandcircle',[C],[],[A])]) :-
                   !, M=obj(point,_),
                   C=obj(circle,_).


/* VIDI STA SE DESAVA KAD JE NEKA VREDNOST MANJA OD USLOVA IZLASKA IZ PETLJE */
divide_by_two([_,_,P3],K,A,Text,Text)     :- K=0, !, A=P3.
divide_by_two([P1,P2,P3],K,A,Text,Text1) :- TextNew = [('langbis',[P1,P2,P3],[],[obj(line,L)]),
                                                       ('prandline',[obj(line,L)],[],[obj(point,Name)])],
                                            myappend(Text,TextNew,TextNew1),
                                            K1 is K-1, 
                                            divide_by_two([P1,P2,obj(point,Name)],K1,A,TextNew1,Text1). 

multiply([_,_,_],P31,K,A2,Text,Text)   :- K=1, !, A2=P31.
multiply([P1,P2,P3],_,K,A2,Text,Text1) :- TextNew = [('langray',[P3,P2,P1,P2,P3],[],[obj(line,L)]),
                                                     ('prandline',[obj(line,L)],[],[obj(point,A)])],
                                          /*write('pocetna vrednost za K: '), write(K), nl,*/
                                          myappend(Text,TextNew,TextNew1),
                                          K1 is K-1, 
                                          multiply([P1,P2,P3],obj(point,A),K1,A2,TextNew1,Text1). 


