theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th11:
assumes "\<not>col PO1 PO2 PO3"
shows " (PO1 ~= PO2 & PO1 ~= PO3 & PO2 ~= PO3)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 2*)
(*2*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 3*)
(*3*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 4*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 5*)
(*5*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 6*)
(*6*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1"
using ax_I4a [of "PO1" "PO1" "PO1"]
by auto

(* po redu: 7*)
(*7*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 8*)
(*8*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 9*)
(*9*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 10*)
(*10*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO4::point
where "inc_po_pl PO4 PL1" and "inc_po_pl PO4 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 11*)
(*11*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 12*)
(*12*)  (*BRANCH NAME*)
} note note1 = this
(* po redu: 13*)
(*13*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 14*)
(*14*)  (*REGULAR*)
moreover

obtain  PO4::point and  PO5::point and  PO6::point and  PO7::point
where "\<not>comp PO4 PO5 PO6 PO7"
using ax_I8 by auto

(* po redu: 15*)
(*15*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 16*)
(*16*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 17*)
(*17*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 18*)
(*18*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 19*)
(*19*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 20*)
(*20*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 21*)
(*21*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 22*)
(*22*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 23*)
(*23*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4` and `PO1 = PO5` and `PO1 = PO6` and `PO1 = PO7`
have "\<not>comp PO1 PO1 PO1 PO1"
by auto

(* po redu: 24*)
(*24*)  (*REGULAR*)
moreover
from `comp PO1 PO1 PO1 PO1` and `\<not>comp PO1 PO1 PO1 PO1`
have False
by auto

(* po redu: 25*)
(*25*)  (*BRANCH NAME*)
} note note2 = this
(* po redu: 26*)
(*26*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 27*)
(*27*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 28*)
(*28*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 29*)
(*29*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 30*)
(*30*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4` and `PO1 = PO5` and `PO1 = PO6`
have "\<not>comp PO1 PO1 PO1 PO7"
by auto

(* po redu: 31*)
(*31*)  (*REGULAR*)
moreover
from `comp PO1 PO1 PO1 PO7` and `\<not>comp PO1 PO1 PO1 PO7`
have False
by auto

(* po redu: 32*)
(*32*)  (*BRANCH NAME*)
} note note3 = this
(* po redu: 33*)
(*33*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 34*)
(*34*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO7 LI1"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 35*)
(*35*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 36*)
(*36*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 37*)
(*37*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 38*)
(*38*)  (*BRANCH NAME*)
} note note4 = this
(* po redu: 39*)
(*39*)  
(*BRANCH END*)
from note3 and note4 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 40*)
(*40*)  (*BRANCH NAME*)
} note note5 = this
(* po redu: 41*)
(*41*)  
(*BRANCH END*)
from note2 and note5 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 42*)
(*42*)  (*BRANCH NAME*)
} note note6 = this
(* po redu: 43*)
(*43*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 44*)
(*44*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 45*)
(*45*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 46*)
(*46*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 47*)
(*47*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 48*)
(*48*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 49*)
(*49*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 50*)
(*50*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO6 LI1"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 51*)
(*51*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 52*)
(*52*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 53*)
(*53*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 54*)
(*54*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 55*)
(*55*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 56*)
(*56*)  (*BRANCH NAME*)
} note note7 = this
(* po redu: 57*)
(*57*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 58*)
(*58*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 59*)
(*59*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 60*)
(*60*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO1 PO1 PO6 PO6` and `PO1 = PO2` and `PO1 = PO3` and `PO1 = PO4` and `PO1 = PO5` and `PO6 = PO7`
have False
by auto

(* po redu: 61*)
(*61*)  (*BRANCH NAME*)
} note note8 = this
(* po redu: 62*)
(*62*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 63*)
(*63*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 64*)
(*64*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 65*)
(*65*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 66*)
(*66*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 67*)
(*67*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4` and `PO1 = PO5`
have "\<not>comp PO1 PO1 PO6 PO7"
by auto

(* po redu: 68*)
(*68*)  (*REGULAR*)
moreover
from `comp PO1 PO1 PO6 PO7` and `\<not>comp PO1 PO1 PO6 PO7`
have False
by auto

(* po redu: 69*)
(*69*)  (*BRANCH NAME*)
} note note9 = this
(* po redu: 70*)
(*70*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 71*)
(*71*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 72*)
(*72*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 73*)
(*73*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 74*)
(*74*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI3::line
where "inc_po_l PO6 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 75*)
(*75*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 76*)
(*76*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 77*)
(*77*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 78*)
(*78*)  (*BRANCH NAME*)
} note note10 = this
(* po redu: 79*)
(*79*)  
(*BRANCH END*)
from note9 and note10 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 80*)
(*80*)  (*BRANCH NAME*)
} note note11 = this
(* po redu: 81*)
(*81*)  
(*BRANCH END*)
from note8 and note11 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 82*)
(*82*)  (*BRANCH NAME*)
} note note12 = this
(* po redu: 83*)
(*83*)  
(*BRANCH END*)
from note7 and note12 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 84*)
(*84*)  (*BRANCH NAME*)
} note note13 = this
(* po redu: 85*)
(*85*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 86*)
(*86*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 87*)
(*87*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 88*)
(*88*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO6 LI1"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 89*)
(*89*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 90*)
(*90*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 91*)
(*91*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 92*)
(*92*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 93*)
(*93*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 94*)
(*94*)  (*BRANCH NAME*)
} note note14 = this
(* po redu: 95*)
(*95*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 96*)
(*96*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 97*)
(*97*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 98*)
(*98*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 99*)
(*99*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 100*)
(*100*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 101*)
(*101*)  (*BRANCH NAME*)
} note note15 = this
(* po redu: 102*)
(*102*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 103*)
(*103*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 104*)
(*104*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 105*)
(*105*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 106*)
(*106*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 107*)
(*107*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 108*)
(*108*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 109*)
(*109*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 110*)
(*110*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI3::line
where "inc_po_l PO6 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 111*)
(*111*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 112*)
(*112*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 113*)
(*113*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 114*)
(*114*)  (*BRANCH NAME*)
} note note16 = this
(* po redu: 115*)
(*115*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 116*)
(*116*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 117*)
(*117*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 118*)
(*118*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 119*)
(*119*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI3::line
where "inc_po_l PO6 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 120*)
(*120*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 121*)
(*121*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 122*)
(*122*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 123*)
(*123*)  (*BRANCH NAME*)
} note note17 = this
(* po redu: 124*)
(*124*)  
(*BRANCH END*)
from note16 and note17 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 125*)
(*125*)  (*BRANCH NAME*)
} note note18 = this
(* po redu: 126*)
(*126*)  
(*BRANCH END*)
from note15 and note18 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 127*)
(*127*)  (*BRANCH NAME*)
} note note19 = this
(* po redu: 128*)
(*128*)  
(*BRANCH END*)
from note14 and note19 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 129*)
(*129*)  (*BRANCH NAME*)
} note note20 = this
(* po redu: 130*)
(*130*)  
(*BRANCH END*)
from note13 and note20 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 131*)
(*131*)  (*BRANCH NAME*)
} note note21 = this
(* po redu: 132*)
(*132*)  
(*BRANCH END*)
from note6 and note21 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 133*)
(*133*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 134*)
(*134*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 135*)
(*135*)  (*REGULAR*)
moreover

have  "inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1"
using ax_g5 [of "PO5" "PL1"]
by auto

(* po redu: 136*)
(*136*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO5 PL1"
(* po redu: 137*)
(*137*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 138*)
(*138*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 139*)
(*139*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 140*)
(*140*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 141*)
(*141*)  (*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO5 LI1"
using ax_I1 [of "PO1" "PO5"]
by auto

(* po redu: 142*)
(*142*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 143*)
(*143*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 144*)
(*144*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 145*)
(*145*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 146*)
(*146*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 147*)
(*147*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 148*)
(*148*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 149*)
(*149*)  (*BRANCH NAME*)
} note note23 = this
(* po redu: 150*)
(*150*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 151*)
(*151*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 152*)
(*152*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 153*)
(*153*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 154*)
(*154*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 155*)
(*155*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 156*)
(*156*)  (*BRANCH NAME*)
} note note24 = this
(* po redu: 157*)
(*157*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 158*)
(*158*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 159*)
(*159*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 160*)
(*160*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 161*)
(*161*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 162*)
(*162*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 163*)
(*163*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 164*)
(*164*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 165*)
(*165*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 166*)
(*166*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 167*)
(*167*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 168*)
(*168*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 169*)
(*169*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 170*)
(*170*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 171*)
(*171*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 172*)
(*172*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 173*)
(*173*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 174*)
(*174*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 175*)
(*175*)  (*BRANCH NAME*)
} note note25 = this
(* po redu: 176*)
(*176*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 177*)
(*177*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 178*)
(*178*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 179*)
(*179*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 180*)
(*180*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 181*)
(*181*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 182*)
(*182*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 183*)
(*183*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 184*)
(*184*)  (*BRANCH NAME*)
} note note26 = this
(* po redu: 185*)
(*185*)  
(*BRANCH END*)
from note25 and note26 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 186*)
(*186*)  (*BRANCH NAME*)
} note note27 = this
(* po redu: 187*)
(*187*)  
(*BRANCH END*)
from note24 and note27 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 188*)
(*188*)  (*BRANCH NAME*)
} note note28 = this
(* po redu: 189*)
(*189*)  
(*BRANCH END*)
from note23 and note28 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 190*)
(*190*)  (*BRANCH NAME*)
} note note29 = this
(* po redu: 191*)
(*191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 192*)
(*192*)  (*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

(* po redu: 193*)
(*193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
(* po redu: 194*)
(*194*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 195*)
(*195*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 196*)
(*196*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 197*)
(*197*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 198*)
(*198*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 199*)
(*199*)  (*BRANCH NAME*)
} note note30 = this
(* po redu: 200*)
(*200*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 201*)
(*201*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 202*)
(*202*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 203*)
(*203*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO1 PO5 PO5 PO5` and `PO1 = PO2` and `PO1 = PO3` and `PO1 = PO4` and `PO5 = PO6` and `PO5 = PO7`
have False
by auto

(* po redu: 204*)
(*204*)  (*BRANCH NAME*)
} note note31 = this
(* po redu: 205*)
(*205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 206*)
(*206*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 207*)
(*207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 208*)
(*208*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 209*)
(*209*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 210*)
(*210*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 211*)
(*211*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 212*)
(*212*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4` and `PO5 = PO6`
have "\<not>comp PO1 PO5 PO5 PO7"
by auto

(* po redu: 213*)
(*213*)  (*REGULAR*)
moreover
from `comp PO1 PO5 PO5 PO7` and `\<not>comp PO1 PO5 PO5 PO7`
have False
by auto

(* po redu: 214*)
(*214*)  (*BRANCH NAME*)
} note note32 = this
(* po redu: 215*)
(*215*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 216*)
(*216*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 217*)
(*217*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 218*)
(*218*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 219*)
(*219*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 220*)
(*220*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 221*)
(*221*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 222*)
(*222*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 223*)
(*223*)  (*BRANCH NAME*)
} note note33 = this
(* po redu: 224*)
(*224*)  
(*BRANCH END*)
from note32 and note33 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 225*)
(*225*)  (*BRANCH NAME*)
} note note34 = this
(* po redu: 226*)
(*226*)  
(*BRANCH END*)
from note31 and note34 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 227*)
(*227*)  (*BRANCH NAME*)
} note note35 = this
(* po redu: 228*)
(*228*)  
(*BRANCH END*)
from note30 and note35 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 229*)
(*229*)  (*BRANCH NAME*)
} note note36 = this
(* po redu: 230*)
(*230*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
(* po redu: 231*)
(*231*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 232*)
(*232*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 233*)
(*233*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 234*)
(*234*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO6"]
by auto

(* po redu: 235*)
(*235*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 236*)
(*236*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO6"]
by auto

(* po redu: 237*)
(*237*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO6"]
by auto

(* po redu: 238*)
(*238*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 239*)
(*239*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO5 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO6"]
by auto

(* po redu: 240*)
(*240*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO6" "PO6"]
by auto

(* po redu: 241*)
(*241*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO6 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 242*)
(*242*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 243*)
(*243*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 244*)
(*244*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 245*)
(*245*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 246*)
(*246*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 247*)
(*247*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 248*)
(*248*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 249*)
(*249*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 250*)
(*250*)  (*BRANCH NAME*)
} note note37 = this
(* po redu: 251*)
(*251*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 252*)
(*252*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 253*)
(*253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 254*)
(*254*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 255*)
(*255*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 256*)
(*256*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 257*)
(*257*)  (*BRANCH NAME*)
} note note38 = this
(* po redu: 258*)
(*258*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 259*)
(*259*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 260*)
(*260*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 261*)
(*261*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO1 PO5 PO6 PO6` and `PO1 = PO2` and `PO1 = PO3` and `PO1 = PO4` and `PO6 = PO7`
have False
by auto

(* po redu: 262*)
(*262*)  (*BRANCH NAME*)
} note note39 = this
(* po redu: 263*)
(*263*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 264*)
(*264*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 265*)
(*265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 266*)
(*266*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 267*)
(*267*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 268*)
(*268*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 269*)
(*269*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 270*)
(*270*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 271*)
(*271*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO7"]
by auto

(* po redu: 272*)
(*272*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4`
have "\<not>comp PO1 PO5 PO6 PO7"
by auto

(* po redu: 273*)
(*273*)  (*REGULAR*)
moreover
from `comp PO1 PO5 PO6 PO7` and `\<not>comp PO1 PO5 PO6 PO7`
have False
by auto

(* po redu: 274*)
(*274*)  (*BRANCH NAME*)
} note note40 = this
(* po redu: 275*)
(*275*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 276*)
(*276*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 277*)
(*277*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 278*)
(*278*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 279*)
(*279*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 280*)
(*280*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 281*)
(*281*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 282*)
(*282*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 283*)
(*283*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 284*)
(*284*)  (*BRANCH NAME*)
} note note41 = this
(* po redu: 285*)
(*285*)  
(*BRANCH END*)
from note40 and note41 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 286*)
(*286*)  (*BRANCH NAME*)
} note note42 = this
(* po redu: 287*)
(*287*)  
(*BRANCH END*)
from note39 and note42 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 288*)
(*288*)  (*BRANCH NAME*)
} note note43 = this
(* po redu: 289*)
(*289*)  
(*BRANCH END*)
from note38 and note43 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 290*)
(*290*)  (*BRANCH NAME*)
} note note44 = this
(* po redu: 291*)
(*291*)  
(*BRANCH END*)
from note37 and note44 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 292*)
(*292*)  (*BRANCH NAME*)
} note note45 = this
(* po redu: 293*)
(*293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 294*)
(*294*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 295*)
(*295*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 296*)
(*296*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 297*)
(*297*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 298*)
(*298*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 299*)
(*299*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 300*)
(*300*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 301*)
(*301*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 302*)
(*302*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 303*)
(*303*)  (*BRANCH NAME*)
} note note46 = this
(* po redu: 304*)
(*304*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 305*)
(*305*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 306*)
(*306*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 307*)
(*307*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 308*)
(*308*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 309*)
(*309*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 310*)
(*310*)  (*BRANCH NAME*)
} note note47 = this
(* po redu: 311*)
(*311*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 312*)
(*312*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 313*)
(*313*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 314*)
(*314*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 315*)
(*315*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 316*)
(*316*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 317*)
(*317*)  (*BRANCH NAME*)
} note note48 = this
(* po redu: 318*)
(*318*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 319*)
(*319*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 320*)
(*320*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 321*)
(*321*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 322*)
(*322*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 323*)
(*323*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 324*)
(*324*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 325*)
(*325*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 326*)
(*326*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 327*)
(*327*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 328*)
(*328*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 329*)
(*329*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 330*)
(*330*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 331*)
(*331*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 332*)
(*332*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 333*)
(*333*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 334*)
(*334*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 335*)
(*335*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 336*)
(*336*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 337*)
(*337*)  (*BRANCH NAME*)
} note note49 = this
(* po redu: 338*)
(*338*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 339*)
(*339*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 340*)
(*340*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 341*)
(*341*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 342*)
(*342*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 343*)
(*343*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 344*)
(*344*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 345*)
(*345*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 346*)
(*346*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 347*)
(*347*)  (*BRANCH NAME*)
} note note50 = this
(* po redu: 348*)
(*348*)  
(*BRANCH END*)
from note49 and note50 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 349*)
(*349*)  (*BRANCH NAME*)
} note note51 = this
(* po redu: 350*)
(*350*)  
(*BRANCH END*)
from note48 and note51 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 351*)
(*351*)  (*BRANCH NAME*)
} note note52 = this
(* po redu: 352*)
(*352*)  
(*BRANCH END*)
from note47 and note52 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 353*)
(*353*)  (*BRANCH NAME*)
} note note53 = this
(* po redu: 354*)
(*354*)  
(*BRANCH END*)
from note46 and note53 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 355*)
(*355*)  (*BRANCH NAME*)
} note note54 = this
(* po redu: 356*)
(*356*)  
(*BRANCH END*)
from note45 and note54 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 357*)
(*357*)  (*BRANCH NAME*)
} note note55 = this
(* po redu: 358*)
(*358*)  
(*BRANCH END*)
from note36 and note55 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
(* po redu: 359*)
(*359*)  (*BRANCH NAME*)
} note note56 = this
(* po redu: 360*)
(*360*)  
(*BRANCH END*)
from note29 and note56 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 361*)
(*361*)  (*BRANCH NAME*)
} note note57 = this
(* po redu: 362*)
(*362*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO5 PL1"
(* po redu: 363*)
(*363*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 364*)
(*364*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO5 PL1`
have  "\<not>comp PO1 PO1 PO1 PO5"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO5"]
by auto

(* po redu: 365*)
(*365*)  (*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO5 LI1"
using ax_I1 [of "PO1" "PO5"]
by auto

(* po redu: 366*)
(*366*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 367*)
(*367*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 368*)
(*368*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 369*)
(*369*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 370*)
(*370*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 371*)
(*371*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 372*)
(*372*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 373*)
(*373*)  (*BRANCH NAME*)
} note note58 = this
(* po redu: 374*)
(*374*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 375*)
(*375*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 376*)
(*376*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 377*)
(*377*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 378*)
(*378*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 379*)
(*379*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 380*)
(*380*)  (*BRANCH NAME*)
} note note59 = this
(* po redu: 381*)
(*381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 382*)
(*382*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 383*)
(*383*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 384*)
(*384*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 385*)
(*385*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 386*)
(*386*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 387*)
(*387*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 388*)
(*388*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 389*)
(*389*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 390*)
(*390*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 391*)
(*391*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 392*)
(*392*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 393*)
(*393*)  (*BRANCH NAME*)
} note note60 = this
(* po redu: 394*)
(*394*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 395*)
(*395*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 396*)
(*396*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 397*)
(*397*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 398*)
(*398*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 399*)
(*399*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 400*)
(*400*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 401*)
(*401*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 402*)
(*402*)  (*BRANCH NAME*)
} note note61 = this
(* po redu: 403*)
(*403*)  
(*BRANCH END*)
from note60 and note61 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 404*)
(*404*)  (*BRANCH NAME*)
} note note62 = this
(* po redu: 405*)
(*405*)  
(*BRANCH END*)
from note59 and note62 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 406*)
(*406*)  (*BRANCH NAME*)
} note note63 = this
(* po redu: 407*)
(*407*)  
(*BRANCH END*)
from note58 and note63 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 408*)
(*408*)  (*BRANCH NAME*)
} note note64 = this
(* po redu: 409*)
(*409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 410*)
(*410*)  (*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

(* po redu: 411*)
(*411*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
(* po redu: 412*)
(*412*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 413*)
(*413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 414*)
(*414*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 415*)
(*415*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 416*)
(*416*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 417*)
(*417*)  (*BRANCH NAME*)
} note note65 = this
(* po redu: 418*)
(*418*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 419*)
(*419*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 420*)
(*420*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 421*)
(*421*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 422*)
(*422*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 423*)
(*423*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 424*)
(*424*)  (*BRANCH NAME*)
} note note66 = this
(* po redu: 425*)
(*425*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 426*)
(*426*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 427*)
(*427*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 428*)
(*428*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 429*)
(*429*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 430*)
(*430*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 431*)
(*431*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 432*)
(*432*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 433*)
(*433*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 434*)
(*434*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 435*)
(*435*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 436*)
(*436*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 437*)
(*437*)  (*BRANCH NAME*)
} note note67 = this
(* po redu: 438*)
(*438*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 439*)
(*439*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 440*)
(*440*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 441*)
(*441*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 442*)
(*442*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 443*)
(*443*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 444*)
(*444*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 445*)
(*445*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 446*)
(*446*)  (*BRANCH NAME*)
} note note68 = this
(* po redu: 447*)
(*447*)  
(*BRANCH END*)
from note67 and note68 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 448*)
(*448*)  (*BRANCH NAME*)
} note note69 = this
(* po redu: 449*)
(*449*)  
(*BRANCH END*)
from note66 and note69 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 450*)
(*450*)  (*BRANCH NAME*)
} note note70 = this
(* po redu: 451*)
(*451*)  
(*BRANCH END*)
from note65 and note70 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 452*)
(*452*)  (*BRANCH NAME*)
} note note71 = this
(* po redu: 453*)
(*453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
(* po redu: 454*)
(*454*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 455*)
(*455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 456*)
(*456*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 457*)
(*457*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 458*)
(*458*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 459*)
(*459*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 460*)
(*460*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 461*)
(*461*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 462*)
(*462*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 463*)
(*463*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 464*)
(*464*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 465*)
(*465*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 466*)
(*466*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 467*)
(*467*)  (*BRANCH NAME*)
} note note72 = this
(* po redu: 468*)
(*468*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 469*)
(*469*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 470*)
(*470*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 471*)
(*471*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 472*)
(*472*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 473*)
(*473*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 474*)
(*474*)  (*BRANCH NAME*)
} note note73 = this
(* po redu: 475*)
(*475*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 476*)
(*476*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 477*)
(*477*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 478*)
(*478*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 479*)
(*479*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 480*)
(*480*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 481*)
(*481*)  (*BRANCH NAME*)
} note note74 = this
(* po redu: 482*)
(*482*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 483*)
(*483*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 484*)
(*484*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 485*)
(*485*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 486*)
(*486*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 487*)
(*487*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 488*)
(*488*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 489*)
(*489*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 490*)
(*490*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 491*)
(*491*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 492*)
(*492*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 493*)
(*493*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 494*)
(*494*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 495*)
(*495*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 496*)
(*496*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 497*)
(*497*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 498*)
(*498*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 499*)
(*499*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 500*)
(*500*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 501*)
(*501*)  (*BRANCH NAME*)
} note note75 = this
(* po redu: 502*)
(*502*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 503*)
(*503*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 504*)
(*504*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 505*)
(*505*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 506*)
(*506*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 507*)
(*507*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 508*)
(*508*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 509*)
(*509*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 510*)
(*510*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 511*)
(*511*)  (*BRANCH NAME*)
} note note76 = this
(* po redu: 512*)
(*512*)  
(*BRANCH END*)
from note75 and note76 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 513*)
(*513*)  (*BRANCH NAME*)
} note note77 = this
(* po redu: 514*)
(*514*)  
(*BRANCH END*)
from note74 and note77 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 515*)
(*515*)  (*BRANCH NAME*)
} note note78 = this
(* po redu: 516*)
(*516*)  
(*BRANCH END*)
from note73 and note78 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 517*)
(*517*)  (*BRANCH NAME*)
} note note79 = this
(* po redu: 518*)
(*518*)  
(*BRANCH END*)
from note72 and note79 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 519*)
(*519*)  (*BRANCH NAME*)
} note note80 = this
(* po redu: 520*)
(*520*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 521*)
(*521*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 522*)
(*522*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 523*)
(*523*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 524*)
(*524*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 525*)
(*525*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 526*)
(*526*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 527*)
(*527*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 528*)
(*528*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 529*)
(*529*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 530*)
(*530*)  (*BRANCH NAME*)
} note note81 = this
(* po redu: 531*)
(*531*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 532*)
(*532*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 533*)
(*533*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 534*)
(*534*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 535*)
(*535*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 536*)
(*536*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 537*)
(*537*)  (*BRANCH NAME*)
} note note82 = this
(* po redu: 538*)
(*538*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 539*)
(*539*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 540*)
(*540*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 541*)
(*541*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 542*)
(*542*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 543*)
(*543*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 544*)
(*544*)  (*BRANCH NAME*)
} note note83 = this
(* po redu: 545*)
(*545*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 546*)
(*546*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 547*)
(*547*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 548*)
(*548*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 549*)
(*549*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 550*)
(*550*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 551*)
(*551*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 552*)
(*552*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 553*)
(*553*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 554*)
(*554*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 555*)
(*555*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 556*)
(*556*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 557*)
(*557*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 558*)
(*558*)  (*BRANCH NAME*)
} note note84 = this
(* po redu: 559*)
(*559*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 560*)
(*560*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 561*)
(*561*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 562*)
(*562*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 563*)
(*563*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 564*)
(*564*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 565*)
(*565*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 566*)
(*566*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 567*)
(*567*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 568*)
(*568*)  (*BRANCH NAME*)
} note note85 = this
(* po redu: 569*)
(*569*)  
(*BRANCH END*)
from note84 and note85 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 570*)
(*570*)  (*BRANCH NAME*)
} note note86 = this
(* po redu: 571*)
(*571*)  
(*BRANCH END*)
from note83 and note86 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 572*)
(*572*)  (*BRANCH NAME*)
} note note87 = this
(* po redu: 573*)
(*573*)  
(*BRANCH END*)
from note82 and note87 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 574*)
(*574*)  (*BRANCH NAME*)
} note note88 = this
(* po redu: 575*)
(*575*)  
(*BRANCH END*)
from note81 and note88 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 576*)
(*576*)  (*BRANCH NAME*)
} note note89 = this
(* po redu: 577*)
(*577*)  
(*BRANCH END*)
from note80 and note89 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 578*)
(*578*)  (*BRANCH NAME*)
} note note90 = this
(* po redu: 579*)
(*579*)  
(*BRANCH END*)
from note71 and note90 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
(* po redu: 580*)
(*580*)  (*BRANCH NAME*)
} note note91 = this
(* po redu: 581*)
(*581*)  
(*BRANCH END*)
from note64 and note91 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 582*)
(*582*)  (*BRANCH NAME*)
} note note92 = this
(* po redu: 583*)
(*583*)  
(*BRANCH END*)
from note57 and note92 and `inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1`
have False
by auto
(* po redu: 584*)
(*584*)  (*BRANCH NAME*)
} note note93 = this
(* po redu: 585*)
(*585*)  
(*BRANCH END*)
from note22 and note93 and `PO1 = PO5 \<or> PO1 ~= PO5`
have False
by auto
(* po redu: 586*)
(*586*)  (*BRANCH NAME*)
} note note94 = this
(* po redu: 587*)
(*587*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 588*)
(*588*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 589*)
(*589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 590*)
(*590*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 591*)
(*591*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 592*)
(*592*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 593*)
(*593*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 594*)
(*594*)  (*REGULAR*)
moreover
from `PO1 ~= PO4`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO4 LI1"
using ax_I1 [of "PO1" "PO4"]
by auto

(* po redu: 595*)
(*595*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 596*)
(*596*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 597*)
(*597*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 598*)
(*598*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 599*)
(*599*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 600*)
(*600*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 601*)
(*601*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 602*)
(*602*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 603*)
(*603*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 604*)
(*604*)  (*BRANCH NAME*)
} note note95 = this
(* po redu: 605*)
(*605*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 606*)
(*606*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 607*)
(*607*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 608*)
(*608*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 609*)
(*609*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 610*)
(*610*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 611*)
(*611*)  (*BRANCH NAME*)
} note note96 = this
(* po redu: 612*)
(*612*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 613*)
(*613*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 614*)
(*614*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 615*)
(*615*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 616*)
(*616*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 617*)
(*617*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 618*)
(*618*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 619*)
(*619*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 620*)
(*620*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 621*)
(*621*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 622*)
(*622*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 623*)
(*623*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 624*)
(*624*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 625*)
(*625*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 626*)
(*626*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 627*)
(*627*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 628*)
(*628*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 629*)
(*629*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 630*)
(*630*)  (*BRANCH NAME*)
} note note97 = this
(* po redu: 631*)
(*631*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 632*)
(*632*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 633*)
(*633*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 634*)
(*634*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 635*)
(*635*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 636*)
(*636*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 637*)
(*637*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 638*)
(*638*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 639*)
(*639*)  (*BRANCH NAME*)
} note note98 = this
(* po redu: 640*)
(*640*)  
(*BRANCH END*)
from note97 and note98 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 641*)
(*641*)  (*BRANCH NAME*)
} note note99 = this
(* po redu: 642*)
(*642*)  
(*BRANCH END*)
from note96 and note99 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 643*)
(*643*)  (*BRANCH NAME*)
} note note100 = this
(* po redu: 644*)
(*644*)  
(*BRANCH END*)
from note95 and note100 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 645*)
(*645*)  (*BRANCH NAME*)
} note note101 = this
(* po redu: 646*)
(*646*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 647*)
(*647*)  (*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

(* po redu: 648*)
(*648*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
(* po redu: 649*)
(*649*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 650*)
(*650*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 651*)
(*651*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 652*)
(*652*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 653*)
(*653*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 654*)
(*654*)  (*BRANCH NAME*)
} note note102 = this
(* po redu: 655*)
(*655*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 656*)
(*656*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 657*)
(*657*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 658*)
(*658*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 659*)
(*659*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 660*)
(*660*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 661*)
(*661*)  (*BRANCH NAME*)
} note note103 = this
(* po redu: 662*)
(*662*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 663*)
(*663*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 664*)
(*664*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 665*)
(*665*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 666*)
(*666*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 667*)
(*667*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 668*)
(*668*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 669*)
(*669*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 670*)
(*670*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 671*)
(*671*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 672*)
(*672*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 673*)
(*673*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 674*)
(*674*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 675*)
(*675*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 676*)
(*676*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 677*)
(*677*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 678*)
(*678*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 679*)
(*679*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 680*)
(*680*)  (*BRANCH NAME*)
} note note104 = this
(* po redu: 681*)
(*681*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 682*)
(*682*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 683*)
(*683*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 684*)
(*684*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 685*)
(*685*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 686*)
(*686*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 687*)
(*687*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 688*)
(*688*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 689*)
(*689*)  (*BRANCH NAME*)
} note note105 = this
(* po redu: 690*)
(*690*)  
(*BRANCH END*)
from note104 and note105 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 691*)
(*691*)  (*BRANCH NAME*)
} note note106 = this
(* po redu: 692*)
(*692*)  
(*BRANCH END*)
from note103 and note106 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 693*)
(*693*)  (*BRANCH NAME*)
} note note107 = this
(* po redu: 694*)
(*694*)  
(*BRANCH END*)
from note102 and note107 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 695*)
(*695*)  (*BRANCH NAME*)
} note note108 = this
(* po redu: 696*)
(*696*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
(* po redu: 697*)
(*697*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 698*)
(*698*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 699*)
(*699*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 700*)
(*700*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO6"]
by auto

(* po redu: 701*)
(*701*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 702*)
(*702*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO6"]
by auto

(* po redu: 703*)
(*703*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO6"]
by auto

(* po redu: 704*)
(*704*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 705*)
(*705*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO4 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO6"]
by auto

(* po redu: 706*)
(*706*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO6"]
by auto

(* po redu: 707*)
(*707*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO6 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 708*)
(*708*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 709*)
(*709*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 710*)
(*710*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 711*)
(*711*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 712*)
(*712*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 713*)
(*713*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 714*)
(*714*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 715*)
(*715*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 716*)
(*716*)  (*BRANCH NAME*)
} note note109 = this
(* po redu: 717*)
(*717*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 718*)
(*718*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 719*)
(*719*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 720*)
(*720*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 721*)
(*721*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 722*)
(*722*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 723*)
(*723*)  (*BRANCH NAME*)
} note note110 = this
(* po redu: 724*)
(*724*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 725*)
(*725*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 726*)
(*726*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 727*)
(*727*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 728*)
(*728*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 729*)
(*729*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 730*)
(*730*)  (*BRANCH NAME*)
} note note111 = this
(* po redu: 731*)
(*731*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 732*)
(*732*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 733*)
(*733*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 734*)
(*734*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 735*)
(*735*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 736*)
(*736*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 737*)
(*737*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 738*)
(*738*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 739*)
(*739*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO7"]
by auto

(* po redu: 740*)
(*740*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 741*)
(*741*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 742*)
(*742*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 743*)
(*743*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 744*)
(*744*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 745*)
(*745*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO7"]
by auto

(* po redu: 746*)
(*746*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 747*)
(*747*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO6 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 748*)
(*748*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO6 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 749*)
(*749*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 750*)
(*750*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 751*)
(*751*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 752*)
(*752*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 753*)
(*753*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 754*)
(*754*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 755*)
(*755*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 756*)
(*756*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 757*)
(*757*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 758*)
(*758*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 759*)
(*759*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 760*)
(*760*)  (*BRANCH NAME*)
} note note112 = this
(* po redu: 761*)
(*761*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 762*)
(*762*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 763*)
(*763*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 764*)
(*764*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 765*)
(*765*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 766*)
(*766*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 767*)
(*767*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 768*)
(*768*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 769*)
(*769*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 770*)
(*770*)  (*BRANCH NAME*)
} note note113 = this
(* po redu: 771*)
(*771*)  
(*BRANCH END*)
from note112 and note113 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 772*)
(*772*)  (*BRANCH NAME*)
} note note114 = this
(* po redu: 773*)
(*773*)  
(*BRANCH END*)
from note111 and note114 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 774*)
(*774*)  (*BRANCH NAME*)
} note note115 = this
(* po redu: 775*)
(*775*)  
(*BRANCH END*)
from note110 and note115 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 776*)
(*776*)  (*BRANCH NAME*)
} note note116 = this
(* po redu: 777*)
(*777*)  
(*BRANCH END*)
from note109 and note116 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 778*)
(*778*)  (*BRANCH NAME*)
} note note117 = this
(* po redu: 779*)
(*779*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 780*)
(*780*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 781*)
(*781*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 782*)
(*782*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 783*)
(*783*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 784*)
(*784*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 785*)
(*785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 786*)
(*786*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 787*)
(*787*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 788*)
(*788*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 789*)
(*789*)  (*BRANCH NAME*)
} note note118 = this
(* po redu: 790*)
(*790*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 791*)
(*791*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 792*)
(*792*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 793*)
(*793*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 794*)
(*794*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 795*)
(*795*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 796*)
(*796*)  (*BRANCH NAME*)
} note note119 = this
(* po redu: 797*)
(*797*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 798*)
(*798*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 799*)
(*799*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 800*)
(*800*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 801*)
(*801*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 802*)
(*802*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 803*)
(*803*)  (*BRANCH NAME*)
} note note120 = this
(* po redu: 804*)
(*804*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 805*)
(*805*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 806*)
(*806*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 807*)
(*807*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 808*)
(*808*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 809*)
(*809*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 810*)
(*810*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 811*)
(*811*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 812*)
(*812*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 813*)
(*813*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 814*)
(*814*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 815*)
(*815*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 816*)
(*816*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 817*)
(*817*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 818*)
(*818*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 819*)
(*819*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 820*)
(*820*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 821*)
(*821*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 822*)
(*822*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 823*)
(*823*)  (*BRANCH NAME*)
} note note121 = this
(* po redu: 824*)
(*824*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 825*)
(*825*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 826*)
(*826*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 827*)
(*827*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 828*)
(*828*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 829*)
(*829*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 830*)
(*830*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 831*)
(*831*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 832*)
(*832*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 833*)
(*833*)  (*BRANCH NAME*)
} note note122 = this
(* po redu: 834*)
(*834*)  
(*BRANCH END*)
from note121 and note122 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 835*)
(*835*)  (*BRANCH NAME*)
} note note123 = this
(* po redu: 836*)
(*836*)  
(*BRANCH END*)
from note120 and note123 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 837*)
(*837*)  (*BRANCH NAME*)
} note note124 = this
(* po redu: 838*)
(*838*)  
(*BRANCH END*)
from note119 and note124 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 839*)
(*839*)  (*BRANCH NAME*)
} note note125 = this
(* po redu: 840*)
(*840*)  
(*BRANCH END*)
from note118 and note125 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 841*)
(*841*)  (*BRANCH NAME*)
} note note126 = this
(* po redu: 842*)
(*842*)  
(*BRANCH END*)
from note117 and note126 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 843*)
(*843*)  (*BRANCH NAME*)
} note note127 = this
(* po redu: 844*)
(*844*)  
(*BRANCH END*)
from note108 and note127 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
(* po redu: 845*)
(*845*)  (*BRANCH NAME*)
} note note128 = this
(* po redu: 846*)
(*846*)  
(*BRANCH END*)
from note101 and note128 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 847*)
(*847*)  (*BRANCH NAME*)
} note note129 = this
(* po redu: 848*)
(*848*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 849*)
(*849*)  (*REGULAR*)
moreover

have  "PO4 = PO5 \<or> PO4 ~= PO5"
using ax_g1 [of "PO4" "PO5"]
by auto

(* po redu: 850*)
(*850*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO5"
(* po redu: 851*)
(*851*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 852*)
(*852*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 853*)
(*853*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 854*)
(*854*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 855*)
(*855*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 856*)
(*856*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 857*)
(*857*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 858*)
(*858*)  (*BRANCH NAME*)
} note note130 = this
(* po redu: 859*)
(*859*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 860*)
(*860*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 861*)
(*861*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 862*)
(*862*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 863*)
(*863*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 864*)
(*864*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 865*)
(*865*)  (*BRANCH NAME*)
} note note131 = this
(* po redu: 866*)
(*866*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 867*)
(*867*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 868*)
(*868*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 869*)
(*869*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 870*)
(*870*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 871*)
(*871*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 872*)
(*872*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 873*)
(*873*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 874*)
(*874*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 875*)
(*875*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 876*)
(*876*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 877*)
(*877*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 878*)
(*878*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 879*)
(*879*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 880*)
(*880*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 881*)
(*881*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 882*)
(*882*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 883*)
(*883*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 884*)
(*884*)  (*BRANCH NAME*)
} note note132 = this
(* po redu: 885*)
(*885*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 886*)
(*886*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 887*)
(*887*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 888*)
(*888*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 889*)
(*889*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 890*)
(*890*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 891*)
(*891*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 892*)
(*892*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 893*)
(*893*)  (*BRANCH NAME*)
} note note133 = this
(* po redu: 894*)
(*894*)  
(*BRANCH END*)
from note132 and note133 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 895*)
(*895*)  (*BRANCH NAME*)
} note note134 = this
(* po redu: 896*)
(*896*)  
(*BRANCH END*)
from note131 and note134 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 897*)
(*897*)  (*BRANCH NAME*)
} note note135 = this
(* po redu: 898*)
(*898*)  
(*BRANCH END*)
from note130 and note135 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 899*)
(*899*)  (*BRANCH NAME*)
} note note136 = this
(* po redu: 900*)
(*900*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 901*)
(*901*)  (*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

(* po redu: 902*)
(*902*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
(* po redu: 903*)
(*903*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 904*)
(*904*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 905*)
(*905*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 906*)
(*906*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 907*)
(*907*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 908*)
(*908*)  (*BRANCH NAME*)
} note note137 = this
(* po redu: 909*)
(*909*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 910*)
(*910*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 911*)
(*911*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 912*)
(*912*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO4 PO4 PO4 PO4` and `PO4 = PO5` and `PO4 = PO6` and `PO4 = PO7`
have False
by auto

(* po redu: 913*)
(*913*)  (*BRANCH NAME*)
} note note138 = this
(* po redu: 914*)
(*914*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 915*)
(*915*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 916*)
(*916*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 917*)
(*917*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 918*)
(*918*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 919*)
(*919*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 920*)
(*920*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 921*)
(*921*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 922*)
(*922*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 923*)
(*923*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 924*)
(*924*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO4 = PO5` and `PO4 = PO6`
have "\<not>comp PO4 PO4 PO4 PO7"
by auto

(* po redu: 925*)
(*925*)  (*REGULAR*)
moreover
from `comp PO4 PO4 PO4 PO7` and `\<not>comp PO4 PO4 PO4 PO7`
have False
by auto

(* po redu: 926*)
(*926*)  (*BRANCH NAME*)
} note note139 = this
(* po redu: 927*)
(*927*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 928*)
(*928*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 929*)
(*929*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 930*)
(*930*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 931*)
(*931*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 932*)
(*932*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 933*)
(*933*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 934*)
(*934*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 935*)
(*935*)  (*BRANCH NAME*)
} note note140 = this
(* po redu: 936*)
(*936*)  
(*BRANCH END*)
from note139 and note140 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 937*)
(*937*)  (*BRANCH NAME*)
} note note141 = this
(* po redu: 938*)
(*938*)  
(*BRANCH END*)
from note138 and note141 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 939*)
(*939*)  (*BRANCH NAME*)
} note note142 = this
(* po redu: 940*)
(*940*)  
(*BRANCH END*)
from note137 and note142 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 941*)
(*941*)  (*BRANCH NAME*)
} note note143 = this
(* po redu: 942*)
(*942*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
(* po redu: 943*)
(*943*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 944*)
(*944*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 945*)
(*945*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 946*)
(*946*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO6"]
by auto

(* po redu: 947*)
(*947*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 948*)
(*948*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO6"]
by auto

(* po redu: 949*)
(*949*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO6"]
by auto

(* po redu: 950*)
(*950*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 951*)
(*951*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO4 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO6"]
by auto

(* po redu: 952*)
(*952*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO6"]
by auto

(* po redu: 953*)
(*953*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO6 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 954*)
(*954*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 955*)
(*955*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 956*)
(*956*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 957*)
(*957*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 958*)
(*958*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 959*)
(*959*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 960*)
(*960*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 961*)
(*961*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 962*)
(*962*)  (*BRANCH NAME*)
} note note144 = this
(* po redu: 963*)
(*963*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 964*)
(*964*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 965*)
(*965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 966*)
(*966*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 967*)
(*967*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 968*)
(*968*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 969*)
(*969*)  (*BRANCH NAME*)
} note note145 = this
(* po redu: 970*)
(*970*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 971*)
(*971*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 972*)
(*972*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 973*)
(*973*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO4 PO4 PO6 PO6` and `PO4 = PO5` and `PO6 = PO7`
have False
by auto

(* po redu: 974*)
(*974*)  (*BRANCH NAME*)
} note note146 = this
(* po redu: 975*)
(*975*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 976*)
(*976*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 977*)
(*977*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 978*)
(*978*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 979*)
(*979*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 980*)
(*980*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 981*)
(*981*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 982*)
(*982*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 983*)
(*983*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO7"]
by auto

(* po redu: 984*)
(*984*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 985*)
(*985*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 986*)
(*986*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 987*)
(*987*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 988*)
(*988*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 989*)
(*989*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO7"]
by auto

(* po redu: 990*)
(*990*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO4 = PO5`
have "\<not>comp PO4 PO4 PO6 PO7"
by auto

(* po redu: 991*)
(*991*)  (*REGULAR*)
moreover
from `comp PO4 PO4 PO6 PO7` and `\<not>comp PO4 PO4 PO6 PO7`
have False
by auto

(* po redu: 992*)
(*992*)  (*BRANCH NAME*)
} note note147 = this
(* po redu: 993*)
(*993*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 994*)
(*994*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 995*)
(*995*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 996*)
(*996*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 997*)
(*997*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 998*)
(*998*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 999*)
(*999*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1000*)
(*1000*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1001*)
(*1001*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1002*)
(*1002*)  (*BRANCH NAME*)
} note note148 = this
(* po redu: 1003*)
(*1003*)  
(*BRANCH END*)
from note147 and note148 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1004*)
(*1004*)  (*BRANCH NAME*)
} note note149 = this
(* po redu: 1005*)
(*1005*)  
(*BRANCH END*)
from note146 and note149 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 1006*)
(*1006*)  (*BRANCH NAME*)
} note note150 = this
(* po redu: 1007*)
(*1007*)  
(*BRANCH END*)
from note145 and note150 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1008*)
(*1008*)  (*BRANCH NAME*)
} note note151 = this
(* po redu: 1009*)
(*1009*)  
(*BRANCH END*)
from note144 and note151 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1010*)
(*1010*)  (*BRANCH NAME*)
} note note152 = this
(* po redu: 1011*)
(*1011*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 1012*)
(*1012*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1013*)
(*1013*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 1014*)
(*1014*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 1015*)
(*1015*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 1016*)
(*1016*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1017*)
(*1017*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1018*)
(*1018*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1019*)
(*1019*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1020*)
(*1020*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1021*)
(*1021*)  (*BRANCH NAME*)
} note note153 = this
(* po redu: 1022*)
(*1022*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1023*)
(*1023*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1024*)
(*1024*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1025*)
(*1025*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1026*)
(*1026*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1027*)
(*1027*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1028*)
(*1028*)  (*BRANCH NAME*)
} note note154 = this
(* po redu: 1029*)
(*1029*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1030*)
(*1030*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 1031*)
(*1031*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 1032*)
(*1032*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1033*)
(*1033*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1034*)
(*1034*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1035*)
(*1035*)  (*BRANCH NAME*)
} note note155 = this
(* po redu: 1036*)
(*1036*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 1037*)
(*1037*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1038*)
(*1038*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1039*)
(*1039*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1040*)
(*1040*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1041*)
(*1041*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1042*)
(*1042*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1043*)
(*1043*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1044*)
(*1044*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1045*)
(*1045*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1046*)
(*1046*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1047*)
(*1047*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1048*)
(*1048*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1049*)
(*1049*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1050*)
(*1050*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1051*)
(*1051*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1052*)
(*1052*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1053*)
(*1053*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1054*)
(*1054*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1055*)
(*1055*)  (*BRANCH NAME*)
} note note156 = this
(* po redu: 1056*)
(*1056*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1057*)
(*1057*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1058*)
(*1058*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1059*)
(*1059*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1060*)
(*1060*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1061*)
(*1061*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1062*)
(*1062*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1063*)
(*1063*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1064*)
(*1064*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1065*)
(*1065*)  (*BRANCH NAME*)
} note note157 = this
(* po redu: 1066*)
(*1066*)  
(*BRANCH END*)
from note156 and note157 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1067*)
(*1067*)  (*BRANCH NAME*)
} note note158 = this
(* po redu: 1068*)
(*1068*)  
(*BRANCH END*)
from note155 and note158 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 1069*)
(*1069*)  (*BRANCH NAME*)
} note note159 = this
(* po redu: 1070*)
(*1070*)  
(*BRANCH END*)
from note154 and note159 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1071*)
(*1071*)  (*BRANCH NAME*)
} note note160 = this
(* po redu: 1072*)
(*1072*)  
(*BRANCH END*)
from note153 and note160 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1073*)
(*1073*)  (*BRANCH NAME*)
} note note161 = this
(* po redu: 1074*)
(*1074*)  
(*BRANCH END*)
from note152 and note161 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 1075*)
(*1075*)  (*BRANCH NAME*)
} note note162 = this
(* po redu: 1076*)
(*1076*)  
(*BRANCH END*)
from note143 and note162 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
(* po redu: 1077*)
(*1077*)  (*BRANCH NAME*)
} note note163 = this
(* po redu: 1078*)
(*1078*)  
(*BRANCH END*)
from note136 and note163 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 1079*)
(*1079*)  (*BRANCH NAME*)
} note note164 = this
(* po redu: 1080*)
(*1080*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO5"
(* po redu: 1081*)
(*1081*)  (*REGULAR*)
moreover

have  "inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1"
using ax_g5 [of "PO5" "PL1"]
by auto

(* po redu: 1082*)
(*1082*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO5 PL1"
(* po redu: 1083*)
(*1083*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 1084*)
(*1084*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO4 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO5"]
by auto

(* po redu: 1085*)
(*1085*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 1086*)
(*1086*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO4 PO4 PO5"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO5"]
by auto

(* po redu: 1087*)
(*1087*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO4 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO5"]
by auto

(* po redu: 1088*)
(*1088*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 1089*)
(*1089*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO4 PO4 PO4 PO5"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO5"]
by auto

(* po redu: 1090*)
(*1090*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO4 PO4 PO5 PO5"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO5"]
by auto

(* po redu: 1091*)
(*1091*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO4 PO5 PO5 PO5"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 1092*)
(*1092*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 1093*)
(*1093*)  (*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

(* po redu: 1094*)
(*1094*)  (*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

(* po redu: 1095*)
(*1095*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 1096*)
(*1096*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 1097*)
(*1097*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1098*)
(*1098*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1099*)
(*1099*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1100*)
(*1100*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1101*)
(*1101*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1102*)
(*1102*)  (*BRANCH NAME*)
} note note165 = this
(* po redu: 1103*)
(*1103*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1104*)
(*1104*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1105*)
(*1105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1106*)
(*1106*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1107*)
(*1107*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1108*)
(*1108*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1109*)
(*1109*)  (*BRANCH NAME*)
} note note166 = this
(* po redu: 1110*)
(*1110*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1111*)
(*1111*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1112*)
(*1112*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1113*)
(*1113*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1114*)
(*1114*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1115*)
(*1115*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1116*)
(*1116*)  (*BRANCH NAME*)
} note note167 = this
(* po redu: 1117*)
(*1117*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1118*)
(*1118*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1119*)
(*1119*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1120*)
(*1120*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1121*)
(*1121*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1122*)
(*1122*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 1123*)
(*1123*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1124*)
(*1124*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1125*)
(*1125*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1126*)
(*1126*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1127*)
(*1127*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1128*)
(*1128*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1129*)
(*1129*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1130*)
(*1130*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1131*)
(*1131*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1132*)
(*1132*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1133*)
(*1133*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1134*)
(*1134*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1135*)
(*1135*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1136*)
(*1136*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1137*)
(*1137*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1138*)
(*1138*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1139*)
(*1139*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1140*)
(*1140*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1141*)
(*1141*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1142*)
(*1142*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1143*)
(*1143*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1144*)
(*1144*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1145*)
(*1145*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1146*)
(*1146*)  (*BRANCH NAME*)
} note note168 = this
(* po redu: 1147*)
(*1147*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1148*)
(*1148*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1149*)
(*1149*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1150*)
(*1150*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1151*)
(*1151*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1152*)
(*1152*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1153*)
(*1153*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1154*)
(*1154*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1155*)
(*1155*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1156*)
(*1156*)  (*BRANCH NAME*)
} note note169 = this
(* po redu: 1157*)
(*1157*)  
(*BRANCH END*)
from note168 and note169 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1158*)
(*1158*)  (*BRANCH NAME*)
} note note170 = this
(* po redu: 1159*)
(*1159*)  
(*BRANCH END*)
from note167 and note170 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1160*)
(*1160*)  (*BRANCH NAME*)
} note note171 = this
(* po redu: 1161*)
(*1161*)  
(*BRANCH END*)
from note166 and note171 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1162*)
(*1162*)  (*BRANCH NAME*)
} note note172 = this
(* po redu: 1163*)
(*1163*)  
(*BRANCH END*)
from note165 and note172 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1164*)
(*1164*)  (*BRANCH NAME*)
} note note173 = this
(* po redu: 1165*)
(*1165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 1166*)
(*1166*)  (*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

(* po redu: 1167*)
(*1167*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
(* po redu: 1168*)
(*1168*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1169*)
(*1169*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1170*)
(*1170*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1171*)
(*1171*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1172*)
(*1172*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1173*)
(*1173*)  (*BRANCH NAME*)
} note note174 = this
(* po redu: 1174*)
(*1174*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1175*)
(*1175*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1176*)
(*1176*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1177*)
(*1177*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1178*)
(*1178*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1179*)
(*1179*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1180*)
(*1180*)  (*BRANCH NAME*)
} note note175 = this
(* po redu: 1181*)
(*1181*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1182*)
(*1182*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1183*)
(*1183*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1184*)
(*1184*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1185*)
(*1185*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1186*)
(*1186*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1187*)
(*1187*)  (*BRANCH NAME*)
} note note176 = this
(* po redu: 1188*)
(*1188*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1189*)
(*1189*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1190*)
(*1190*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1191*)
(*1191*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1192*)
(*1192*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1193*)
(*1193*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 1194*)
(*1194*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1195*)
(*1195*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1196*)
(*1196*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1197*)
(*1197*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1198*)
(*1198*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1199*)
(*1199*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1200*)
(*1200*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1201*)
(*1201*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1202*)
(*1202*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1203*)
(*1203*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1204*)
(*1204*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1205*)
(*1205*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1206*)
(*1206*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1207*)
(*1207*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1208*)
(*1208*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1209*)
(*1209*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1210*)
(*1210*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1211*)
(*1211*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1212*)
(*1212*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1213*)
(*1213*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1214*)
(*1214*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1215*)
(*1215*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1216*)
(*1216*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1217*)
(*1217*)  (*BRANCH NAME*)
} note note177 = this
(* po redu: 1218*)
(*1218*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1219*)
(*1219*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1220*)
(*1220*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1221*)
(*1221*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1222*)
(*1222*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1223*)
(*1223*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1224*)
(*1224*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1225*)
(*1225*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1226*)
(*1226*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1227*)
(*1227*)  (*BRANCH NAME*)
} note note178 = this
(* po redu: 1228*)
(*1228*)  
(*BRANCH END*)
from note177 and note178 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1229*)
(*1229*)  (*BRANCH NAME*)
} note note179 = this
(* po redu: 1230*)
(*1230*)  
(*BRANCH END*)
from note176 and note179 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1231*)
(*1231*)  (*BRANCH NAME*)
} note note180 = this
(* po redu: 1232*)
(*1232*)  
(*BRANCH END*)
from note175 and note180 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1233*)
(*1233*)  (*BRANCH NAME*)
} note note181 = this
(* po redu: 1234*)
(*1234*)  
(*BRANCH END*)
from note174 and note181 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1235*)
(*1235*)  (*BRANCH NAME*)
} note note182 = this
(* po redu: 1236*)
(*1236*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
(* po redu: 1237*)
(*1237*)  (*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

(* po redu: 1238*)
(*1238*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
(* po redu: 1239*)
(*1239*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1240*)
(*1240*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1241*)
(*1241*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1242*)
(*1242*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1243*)
(*1243*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1244*)
(*1244*)  (*BRANCH NAME*)
} note note183 = this
(* po redu: 1245*)
(*1245*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1246*)
(*1246*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1247*)
(*1247*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1248*)
(*1248*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1249*)
(*1249*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1250*)
(*1250*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1251*)
(*1251*)  (*BRANCH NAME*)
} note note184 = this
(* po redu: 1252*)
(*1252*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1253*)
(*1253*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1254*)
(*1254*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1255*)
(*1255*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO4 PO5 PO5 PO5` and `PO5 = PO6` and `PO5 = PO7`
have False
by auto

(* po redu: 1256*)
(*1256*)  (*BRANCH NAME*)
} note note185 = this
(* po redu: 1257*)
(*1257*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1258*)
(*1258*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1259*)
(*1259*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1260*)
(*1260*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1261*)
(*1261*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1262*)
(*1262*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 1263*)
(*1263*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1264*)
(*1264*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1265*)
(*1265*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1266*)
(*1266*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1267*)
(*1267*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1268*)
(*1268*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1269*)
(*1269*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1270*)
(*1270*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1271*)
(*1271*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1272*)
(*1272*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1273*)
(*1273*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1274*)
(*1274*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO5 = PO6`
have "\<not>comp PO4 PO5 PO5 PO7"
by auto

(* po redu: 1275*)
(*1275*)  (*REGULAR*)
moreover
from `comp PO4 PO5 PO5 PO7` and `\<not>comp PO4 PO5 PO5 PO7`
have False
by auto

(* po redu: 1276*)
(*1276*)  (*BRANCH NAME*)
} note note186 = this
(* po redu: 1277*)
(*1277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1278*)
(*1278*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1279*)
(*1279*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1280*)
(*1280*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1281*)
(*1281*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1282*)
(*1282*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1283*)
(*1283*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1284*)
(*1284*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1285*)
(*1285*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1286*)
(*1286*)  (*BRANCH NAME*)
} note note187 = this
(* po redu: 1287*)
(*1287*)  
(*BRANCH END*)
from note186 and note187 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1288*)
(*1288*)  (*BRANCH NAME*)
} note note188 = this
(* po redu: 1289*)
(*1289*)  
(*BRANCH END*)
from note185 and note188 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1290*)
(*1290*)  (*BRANCH NAME*)
} note note189 = this
(* po redu: 1291*)
(*1291*)  
(*BRANCH END*)
from note184 and note189 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1292*)
(*1292*)  (*BRANCH NAME*)
} note note190 = this
(* po redu: 1293*)
(*1293*)  
(*BRANCH END*)
from note183 and note190 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1294*)
(*1294*)  (*BRANCH NAME*)
} note note191 = this
(* po redu: 1295*)
(*1295*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
(* po redu: 1296*)
(*1296*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 1297*)
(*1297*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 1298*)
(*1298*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 1299*)
(*1299*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO6"]
by auto

(* po redu: 1300*)
(*1300*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO6"]
by auto

(* po redu: 1301*)
(*1301*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 1302*)
(*1302*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO6"]
by auto

(* po redu: 1303*)
(*1303*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO6"]
by auto

(* po redu: 1304*)
(*1304*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO6"]
by auto

(* po redu: 1305*)
(*1305*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO6"]
by auto

(* po redu: 1306*)
(*1306*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO6"]
by auto

(* po redu: 1307*)
(*1307*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1308*)
(*1308*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO4 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO6"]
by auto

(* po redu: 1309*)
(*1309*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO5 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO6"]
by auto

(* po redu: 1310*)
(*1310*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO6"]
by auto

(* po redu: 1311*)
(*1311*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO5 PO5 PO6"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO6"]
by auto

(* po redu: 1312*)
(*1312*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO5 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO5" "PO6" "PO6"]
by auto

(* po redu: 1313*)
(*1313*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO6 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1314*)
(*1314*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO5 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO6"]
by auto

(* po redu: 1315*)
(*1315*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO6" "PO6"]
by auto

(* po redu: 1316*)
(*1316*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO6 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1317*)
(*1317*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1318*)
(*1318*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 1319*)
(*1319*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 1320*)
(*1320*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 1321*)
(*1321*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1322*)
(*1322*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1323*)
(*1323*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1324*)
(*1324*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1325*)
(*1325*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1326*)
(*1326*)  (*BRANCH NAME*)
} note note192 = this
(* po redu: 1327*)
(*1327*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1328*)
(*1328*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1329*)
(*1329*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1330*)
(*1330*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1331*)
(*1331*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1332*)
(*1332*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1333*)
(*1333*)  (*BRANCH NAME*)
} note note193 = this
(* po redu: 1334*)
(*1334*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1335*)
(*1335*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1336*)
(*1336*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1337*)
(*1337*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1338*)
(*1338*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1339*)
(*1339*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1340*)
(*1340*)  (*BRANCH NAME*)
} note note194 = this
(* po redu: 1341*)
(*1341*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1342*)
(*1342*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 1343*)
(*1343*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 1344*)
(*1344*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO4 PO5 PO6 PO6` and `PO6 = PO7`
have False
by auto

(* po redu: 1345*)
(*1345*)  (*BRANCH NAME*)
} note note195 = this
(* po redu: 1346*)
(*1346*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 1347*)
(*1347*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1348*)
(*1348*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1349*)
(*1349*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1350*)
(*1350*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1351*)
(*1351*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 1352*)
(*1352*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 1353*)
(*1353*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1354*)
(*1354*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1355*)
(*1355*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1356*)
(*1356*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO7"]
by auto

(* po redu: 1357*)
(*1357*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1358*)
(*1358*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1359*)
(*1359*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO7"]
by auto

(* po redu: 1360*)
(*1360*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1361*)
(*1361*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 1362*)
(*1362*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 1363*)
(*1363*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1364*)
(*1364*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1365*)
(*1365*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1366*)
(*1366*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO7"]
by auto

(* po redu: 1367*)
(*1367*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1368*)
(*1368*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1369*)
(*1369*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO6" "PO7"]
by auto

(* po redu: 1370*)
(*1370*)  (*REGULAR*)
moreover
from `comp PO4 PO5 PO6 PO7` and `\<not>comp PO4 PO5 PO6 PO7`
have False
by auto

(* po redu: 1371*)
(*1371*)  (*BRANCH NAME*)
} note note196 = this
(* po redu: 1372*)
(*1372*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1373*)
(*1373*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1374*)
(*1374*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1375*)
(*1375*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1376*)
(*1376*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1377*)
(*1377*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1378*)
(*1378*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1379*)
(*1379*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1380*)
(*1380*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1381*)
(*1381*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1382*)
(*1382*)  (*BRANCH NAME*)
} note note197 = this
(* po redu: 1383*)
(*1383*)  
(*BRANCH END*)
from note196 and note197 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1384*)
(*1384*)  (*BRANCH NAME*)
} note note198 = this
(* po redu: 1385*)
(*1385*)  
(*BRANCH END*)
from note195 and note198 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 1386*)
(*1386*)  (*BRANCH NAME*)
} note note199 = this
(* po redu: 1387*)
(*1387*)  
(*BRANCH END*)
from note194 and note199 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1388*)
(*1388*)  (*BRANCH NAME*)
} note note200 = this
(* po redu: 1389*)
(*1389*)  
(*BRANCH END*)
from note193 and note200 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1390*)
(*1390*)  (*BRANCH NAME*)
} note note201 = this
(* po redu: 1391*)
(*1391*)  
(*BRANCH END*)
from note192 and note201 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1392*)
(*1392*)  (*BRANCH NAME*)
} note note202 = this
(* po redu: 1393*)
(*1393*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 1394*)
(*1394*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1395*)
(*1395*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 1396*)
(*1396*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 1397*)
(*1397*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 1398*)
(*1398*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 1399*)
(*1399*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1400*)
(*1400*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1401*)
(*1401*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1402*)
(*1402*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1403*)
(*1403*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1404*)
(*1404*)  (*BRANCH NAME*)
} note note203 = this
(* po redu: 1405*)
(*1405*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1406*)
(*1406*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1407*)
(*1407*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1408*)
(*1408*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1409*)
(*1409*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1410*)
(*1410*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1411*)
(*1411*)  (*BRANCH NAME*)
} note note204 = this
(* po redu: 1412*)
(*1412*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1413*)
(*1413*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1414*)
(*1414*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1415*)
(*1415*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1416*)
(*1416*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1417*)
(*1417*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1418*)
(*1418*)  (*BRANCH NAME*)
} note note205 = this
(* po redu: 1419*)
(*1419*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1420*)
(*1420*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 1421*)
(*1421*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 1422*)
(*1422*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1423*)
(*1423*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1424*)
(*1424*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1425*)
(*1425*)  (*BRANCH NAME*)
} note note206 = this
(* po redu: 1426*)
(*1426*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 1427*)
(*1427*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1428*)
(*1428*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1429*)
(*1429*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1430*)
(*1430*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1431*)
(*1431*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 1432*)
(*1432*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1433*)
(*1433*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1434*)
(*1434*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1435*)
(*1435*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1436*)
(*1436*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1437*)
(*1437*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1438*)
(*1438*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1439*)
(*1439*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1440*)
(*1440*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

(* po redu: 1441*)
(*1441*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1442*)
(*1442*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1443*)
(*1443*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1444*)
(*1444*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1445*)
(*1445*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 1446*)
(*1446*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 1447*)
(*1447*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1448*)
(*1448*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1449*)
(*1449*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1450*)
(*1450*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1451*)
(*1451*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1452*)
(*1452*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1453*)
(*1453*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1454*)
(*1454*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1455*)
(*1455*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1456*)
(*1456*)  (*BRANCH NAME*)
} note note207 = this
(* po redu: 1457*)
(*1457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1458*)
(*1458*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1459*)
(*1459*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1460*)
(*1460*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1461*)
(*1461*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1462*)
(*1462*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1463*)
(*1463*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1464*)
(*1464*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1465*)
(*1465*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1466*)
(*1466*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1467*)
(*1467*)  (*BRANCH NAME*)
} note note208 = this
(* po redu: 1468*)
(*1468*)  
(*BRANCH END*)
from note207 and note208 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1469*)
(*1469*)  (*BRANCH NAME*)
} note note209 = this
(* po redu: 1470*)
(*1470*)  
(*BRANCH END*)
from note206 and note209 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 1471*)
(*1471*)  (*BRANCH NAME*)
} note note210 = this
(* po redu: 1472*)
(*1472*)  
(*BRANCH END*)
from note205 and note210 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1473*)
(*1473*)  (*BRANCH NAME*)
} note note211 = this
(* po redu: 1474*)
(*1474*)  
(*BRANCH END*)
from note204 and note211 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1475*)
(*1475*)  (*BRANCH NAME*)
} note note212 = this
(* po redu: 1476*)
(*1476*)  
(*BRANCH END*)
from note203 and note212 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1477*)
(*1477*)  (*BRANCH NAME*)
} note note213 = this
(* po redu: 1478*)
(*1478*)  
(*BRANCH END*)
from note202 and note213 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 1479*)
(*1479*)  (*BRANCH NAME*)
} note note214 = this
(* po redu: 1480*)
(*1480*)  
(*BRANCH END*)
from note191 and note214 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
(* po redu: 1481*)
(*1481*)  (*BRANCH NAME*)
} note note215 = this
(* po redu: 1482*)
(*1482*)  
(*BRANCH END*)
from note182 and note215 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
(* po redu: 1483*)
(*1483*)  (*BRANCH NAME*)
} note note216 = this
(* po redu: 1484*)
(*1484*)  
(*BRANCH END*)
from note173 and note216 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 1485*)
(*1485*)  (*BRANCH NAME*)
} note note217 = this
(* po redu: 1486*)
(*1486*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO5 PL1"
(* po redu: 1487*)
(*1487*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1488*)
(*1488*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO5 PL1`
have  "\<not>comp PO1 PO1 PO1 PO5"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO5"]
by auto

(* po redu: 1489*)
(*1489*)  (*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

(* po redu: 1490*)
(*1490*)  (*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

(* po redu: 1491*)
(*1491*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 1492*)
(*1492*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 1493*)
(*1493*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1494*)
(*1494*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1495*)
(*1495*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1496*)
(*1496*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1497*)
(*1497*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1498*)
(*1498*)  (*BRANCH NAME*)
} note note218 = this
(* po redu: 1499*)
(*1499*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1500*)
(*1500*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1501*)
(*1501*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1502*)
(*1502*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1503*)
(*1503*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1504*)
(*1504*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1505*)
(*1505*)  (*BRANCH NAME*)
} note note219 = this
(* po redu: 1506*)
(*1506*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1507*)
(*1507*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1508*)
(*1508*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1509*)
(*1509*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1510*)
(*1510*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1511*)
(*1511*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1512*)
(*1512*)  (*BRANCH NAME*)
} note note220 = this
(* po redu: 1513*)
(*1513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1514*)
(*1514*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1515*)
(*1515*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1516*)
(*1516*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1517*)
(*1517*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1518*)
(*1518*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1519*)
(*1519*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1520*)
(*1520*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1521*)
(*1521*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1522*)
(*1522*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1523*)
(*1523*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1524*)
(*1524*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1525*)
(*1525*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1526*)
(*1526*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1527*)
(*1527*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1528*)
(*1528*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1529*)
(*1529*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1530*)
(*1530*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1531*)
(*1531*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1532*)
(*1532*)  (*BRANCH NAME*)
} note note221 = this
(* po redu: 1533*)
(*1533*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1534*)
(*1534*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1535*)
(*1535*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1536*)
(*1536*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1537*)
(*1537*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1538*)
(*1538*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1539*)
(*1539*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1540*)
(*1540*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1541*)
(*1541*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1542*)
(*1542*)  (*BRANCH NAME*)
} note note222 = this
(* po redu: 1543*)
(*1543*)  
(*BRANCH END*)
from note221 and note222 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1544*)
(*1544*)  (*BRANCH NAME*)
} note note223 = this
(* po redu: 1545*)
(*1545*)  
(*BRANCH END*)
from note220 and note223 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1546*)
(*1546*)  (*BRANCH NAME*)
} note note224 = this
(* po redu: 1547*)
(*1547*)  
(*BRANCH END*)
from note219 and note224 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1548*)
(*1548*)  (*BRANCH NAME*)
} note note225 = this
(* po redu: 1549*)
(*1549*)  
(*BRANCH END*)
from note218 and note225 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1550*)
(*1550*)  (*BRANCH NAME*)
} note note226 = this
(* po redu: 1551*)
(*1551*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 1552*)
(*1552*)  (*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

(* po redu: 1553*)
(*1553*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
(* po redu: 1554*)
(*1554*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1555*)
(*1555*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1556*)
(*1556*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1557*)
(*1557*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1558*)
(*1558*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1559*)
(*1559*)  (*BRANCH NAME*)
} note note227 = this
(* po redu: 1560*)
(*1560*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1561*)
(*1561*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1562*)
(*1562*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1563*)
(*1563*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1564*)
(*1564*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1565*)
(*1565*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1566*)
(*1566*)  (*BRANCH NAME*)
} note note228 = this
(* po redu: 1567*)
(*1567*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1568*)
(*1568*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1569*)
(*1569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1570*)
(*1570*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1571*)
(*1571*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1572*)
(*1572*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1573*)
(*1573*)  (*BRANCH NAME*)
} note note229 = this
(* po redu: 1574*)
(*1574*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1575*)
(*1575*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1576*)
(*1576*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1577*)
(*1577*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1578*)
(*1578*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1579*)
(*1579*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1580*)
(*1580*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1581*)
(*1581*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1582*)
(*1582*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1583*)
(*1583*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1584*)
(*1584*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1585*)
(*1585*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1586*)
(*1586*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1587*)
(*1587*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1588*)
(*1588*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1589*)
(*1589*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1590*)
(*1590*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1591*)
(*1591*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1592*)
(*1592*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1593*)
(*1593*)  (*BRANCH NAME*)
} note note230 = this
(* po redu: 1594*)
(*1594*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1595*)
(*1595*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1596*)
(*1596*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1597*)
(*1597*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1598*)
(*1598*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1599*)
(*1599*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1600*)
(*1600*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1601*)
(*1601*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1602*)
(*1602*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1603*)
(*1603*)  (*BRANCH NAME*)
} note note231 = this
(* po redu: 1604*)
(*1604*)  
(*BRANCH END*)
from note230 and note231 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1605*)
(*1605*)  (*BRANCH NAME*)
} note note232 = this
(* po redu: 1606*)
(*1606*)  
(*BRANCH END*)
from note229 and note232 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1607*)
(*1607*)  (*BRANCH NAME*)
} note note233 = this
(* po redu: 1608*)
(*1608*)  
(*BRANCH END*)
from note228 and note233 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1609*)
(*1609*)  (*BRANCH NAME*)
} note note234 = this
(* po redu: 1610*)
(*1610*)  
(*BRANCH END*)
from note227 and note234 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1611*)
(*1611*)  (*BRANCH NAME*)
} note note235 = this
(* po redu: 1612*)
(*1612*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
(* po redu: 1613*)
(*1613*)  (*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

(* po redu: 1614*)
(*1614*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
(* po redu: 1615*)
(*1615*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1616*)
(*1616*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1617*)
(*1617*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1618*)
(*1618*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1619*)
(*1619*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1620*)
(*1620*)  (*BRANCH NAME*)
} note note236 = this
(* po redu: 1621*)
(*1621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1622*)
(*1622*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1623*)
(*1623*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1624*)
(*1624*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1625*)
(*1625*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1626*)
(*1626*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1627*)
(*1627*)  (*BRANCH NAME*)
} note note237 = this
(* po redu: 1628*)
(*1628*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1629*)
(*1629*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1630*)
(*1630*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1631*)
(*1631*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1632*)
(*1632*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1633*)
(*1633*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1634*)
(*1634*)  (*BRANCH NAME*)
} note note238 = this
(* po redu: 1635*)
(*1635*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1636*)
(*1636*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1637*)
(*1637*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1638*)
(*1638*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1639*)
(*1639*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1640*)
(*1640*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1641*)
(*1641*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1642*)
(*1642*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1643*)
(*1643*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1644*)
(*1644*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1645*)
(*1645*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1646*)
(*1646*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1647*)
(*1647*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1648*)
(*1648*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1649*)
(*1649*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1650*)
(*1650*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1651*)
(*1651*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1652*)
(*1652*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1653*)
(*1653*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1654*)
(*1654*)  (*BRANCH NAME*)
} note note239 = this
(* po redu: 1655*)
(*1655*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1656*)
(*1656*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1657*)
(*1657*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1658*)
(*1658*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1659*)
(*1659*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1660*)
(*1660*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1661*)
(*1661*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1662*)
(*1662*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1663*)
(*1663*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1664*)
(*1664*)  (*BRANCH NAME*)
} note note240 = this
(* po redu: 1665*)
(*1665*)  
(*BRANCH END*)
from note239 and note240 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1666*)
(*1666*)  (*BRANCH NAME*)
} note note241 = this
(* po redu: 1667*)
(*1667*)  
(*BRANCH END*)
from note238 and note241 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1668*)
(*1668*)  (*BRANCH NAME*)
} note note242 = this
(* po redu: 1669*)
(*1669*)  
(*BRANCH END*)
from note237 and note242 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1670*)
(*1670*)  (*BRANCH NAME*)
} note note243 = this
(* po redu: 1671*)
(*1671*)  
(*BRANCH END*)
from note236 and note243 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1672*)
(*1672*)  (*BRANCH NAME*)
} note note244 = this
(* po redu: 1673*)
(*1673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
(* po redu: 1674*)
(*1674*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 1675*)
(*1675*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 1676*)
(*1676*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 1677*)
(*1677*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO6"]
by auto

(* po redu: 1678*)
(*1678*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 1679*)
(*1679*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO6"]
by auto

(* po redu: 1680*)
(*1680*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO6"]
by auto

(* po redu: 1681*)
(*1681*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1682*)
(*1682*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO4 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO6"]
by auto

(* po redu: 1683*)
(*1683*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO6"]
by auto

(* po redu: 1684*)
(*1684*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO6 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1685*)
(*1685*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1686*)
(*1686*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 1687*)
(*1687*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 1688*)
(*1688*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 1689*)
(*1689*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1690*)
(*1690*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1691*)
(*1691*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1692*)
(*1692*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1693*)
(*1693*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1694*)
(*1694*)  (*BRANCH NAME*)
} note note245 = this
(* po redu: 1695*)
(*1695*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1696*)
(*1696*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1697*)
(*1697*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1698*)
(*1698*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1699*)
(*1699*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1700*)
(*1700*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1701*)
(*1701*)  (*BRANCH NAME*)
} note note246 = this
(* po redu: 1702*)
(*1702*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1703*)
(*1703*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1704*)
(*1704*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1705*)
(*1705*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1706*)
(*1706*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1707*)
(*1707*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1708*)
(*1708*)  (*BRANCH NAME*)
} note note247 = this
(* po redu: 1709*)
(*1709*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1710*)
(*1710*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 1711*)
(*1711*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 1712*)
(*1712*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1713*)
(*1713*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1714*)
(*1714*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1715*)
(*1715*)  (*BRANCH NAME*)
} note note248 = this
(* po redu: 1716*)
(*1716*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 1717*)
(*1717*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1718*)
(*1718*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1719*)
(*1719*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1720*)
(*1720*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1721*)
(*1721*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 1722*)
(*1722*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1723*)
(*1723*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1724*)
(*1724*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO7"]
by auto

(* po redu: 1725*)
(*1725*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1726*)
(*1726*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 1727*)
(*1727*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 1728*)
(*1728*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1729*)
(*1729*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1730*)
(*1730*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO7"]
by auto

(* po redu: 1731*)
(*1731*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1732*)
(*1732*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO6 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 1733*)
(*1733*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO6 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 1734*)
(*1734*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1735*)
(*1735*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 1736*)
(*1736*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 1737*)
(*1737*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1738*)
(*1738*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1739*)
(*1739*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1740*)
(*1740*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1741*)
(*1741*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1742*)
(*1742*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1743*)
(*1743*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1744*)
(*1744*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1745*)
(*1745*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1746*)
(*1746*)  (*BRANCH NAME*)
} note note249 = this
(* po redu: 1747*)
(*1747*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1748*)
(*1748*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1749*)
(*1749*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1750*)
(*1750*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1751*)
(*1751*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1752*)
(*1752*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1753*)
(*1753*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1754*)
(*1754*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1755*)
(*1755*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1756*)
(*1756*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1757*)
(*1757*)  (*BRANCH NAME*)
} note note250 = this
(* po redu: 1758*)
(*1758*)  
(*BRANCH END*)
from note249 and note250 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1759*)
(*1759*)  (*BRANCH NAME*)
} note note251 = this
(* po redu: 1760*)
(*1760*)  
(*BRANCH END*)
from note248 and note251 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 1761*)
(*1761*)  (*BRANCH NAME*)
} note note252 = this
(* po redu: 1762*)
(*1762*)  
(*BRANCH END*)
from note247 and note252 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1763*)
(*1763*)  (*BRANCH NAME*)
} note note253 = this
(* po redu: 1764*)
(*1764*)  
(*BRANCH END*)
from note246 and note253 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1765*)
(*1765*)  (*BRANCH NAME*)
} note note254 = this
(* po redu: 1766*)
(*1766*)  
(*BRANCH END*)
from note245 and note254 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1767*)
(*1767*)  (*BRANCH NAME*)
} note note255 = this
(* po redu: 1768*)
(*1768*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 1769*)
(*1769*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1770*)
(*1770*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 1771*)
(*1771*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 1772*)
(*1772*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 1773*)
(*1773*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 1774*)
(*1774*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1775*)
(*1775*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1776*)
(*1776*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1777*)
(*1777*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1778*)
(*1778*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1779*)
(*1779*)  (*BRANCH NAME*)
} note note256 = this
(* po redu: 1780*)
(*1780*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1781*)
(*1781*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1782*)
(*1782*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1783*)
(*1783*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1784*)
(*1784*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1785*)
(*1785*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1786*)
(*1786*)  (*BRANCH NAME*)
} note note257 = this
(* po redu: 1787*)
(*1787*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1788*)
(*1788*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 1789*)
(*1789*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 1790*)
(*1790*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1791*)
(*1791*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1792*)
(*1792*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1793*)
(*1793*)  (*BRANCH NAME*)
} note note258 = this
(* po redu: 1794*)
(*1794*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 1795*)
(*1795*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 1796*)
(*1796*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 1797*)
(*1797*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1798*)
(*1798*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1799*)
(*1799*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1800*)
(*1800*)  (*BRANCH NAME*)
} note note259 = this
(* po redu: 1801*)
(*1801*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 1802*)
(*1802*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1803*)
(*1803*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1804*)
(*1804*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1805*)
(*1805*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

(* po redu: 1806*)
(*1806*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1807*)
(*1807*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1808*)
(*1808*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1809*)
(*1809*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1810*)
(*1810*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

(* po redu: 1811*)
(*1811*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

(* po redu: 1812*)
(*1812*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1813*)
(*1813*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1814*)
(*1814*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1815*)
(*1815*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1816*)
(*1816*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1817*)
(*1817*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1818*)
(*1818*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1819*)
(*1819*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1820*)
(*1820*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1821*)
(*1821*)  (*BRANCH NAME*)
} note note260 = this
(* po redu: 1822*)
(*1822*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1823*)
(*1823*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1824*)
(*1824*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1825*)
(*1825*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1826*)
(*1826*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1827*)
(*1827*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 1828*)
(*1828*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1829*)
(*1829*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1830*)
(*1830*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1831*)
(*1831*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1832*)
(*1832*)  (*BRANCH NAME*)
} note note261 = this
(* po redu: 1833*)
(*1833*)  
(*BRANCH END*)
from note260 and note261 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1834*)
(*1834*)  (*BRANCH NAME*)
} note note262 = this
(* po redu: 1835*)
(*1835*)  
(*BRANCH END*)
from note259 and note262 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 1836*)
(*1836*)  (*BRANCH NAME*)
} note note263 = this
(* po redu: 1837*)
(*1837*)  
(*BRANCH END*)
from note258 and note263 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 1838*)
(*1838*)  (*BRANCH NAME*)
} note note264 = this
(* po redu: 1839*)
(*1839*)  
(*BRANCH END*)
from note257 and note264 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1840*)
(*1840*)  (*BRANCH NAME*)
} note note265 = this
(* po redu: 1841*)
(*1841*)  
(*BRANCH END*)
from note256 and note265 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1842*)
(*1842*)  (*BRANCH NAME*)
} note note266 = this
(* po redu: 1843*)
(*1843*)  
(*BRANCH END*)
from note255 and note266 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 1844*)
(*1844*)  (*BRANCH NAME*)
} note note267 = this
(* po redu: 1845*)
(*1845*)  
(*BRANCH END*)
from note244 and note267 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
(* po redu: 1846*)
(*1846*)  (*BRANCH NAME*)
} note note268 = this
(* po redu: 1847*)
(*1847*)  
(*BRANCH END*)
from note235 and note268 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
(* po redu: 1848*)
(*1848*)  (*BRANCH NAME*)
} note note269 = this
(* po redu: 1849*)
(*1849*)  
(*BRANCH END*)
from note226 and note269 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 1850*)
(*1850*)  (*BRANCH NAME*)
} note note270 = this
(* po redu: 1851*)
(*1851*)  
(*BRANCH END*)
from note217 and note270 and `inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1`
have False
by auto
(* po redu: 1852*)
(*1852*)  (*BRANCH NAME*)
} note note271 = this
(* po redu: 1853*)
(*1853*)  
(*BRANCH END*)
from note164 and note271 and `PO4 = PO5 \<or> PO4 ~= PO5`
have False
by auto
(* po redu: 1854*)
(*1854*)  (*BRANCH NAME*)
} note note272 = this
(* po redu: 1855*)
(*1855*)  
(*BRANCH END*)
from note129 and note272 and `PO1 = PO5 \<or> PO1 ~= PO5`
have False
by auto
(* po redu: 1856*)
(*1856*)  (*BRANCH NAME*)
} note note273 = this
(* po redu: 1857*)
(*1857*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 1858*)
(*1858*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1859*)
(*1859*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO1 PO4"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO4"]
by auto

(* po redu: 1860*)
(*1860*)  (*REGULAR*)
moreover
from `PO1 ~= PO4`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO4 LI1"
using ax_I1 [of "PO1" "PO4"]
by auto

(* po redu: 1861*)
(*1861*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 1862*)
(*1862*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 1863*)
(*1863*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 1864*)
(*1864*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 1865*)
(*1865*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1866*)
(*1866*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1867*)
(*1867*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1868*)
(*1868*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1869*)
(*1869*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1870*)
(*1870*)  (*BRANCH NAME*)
} note note274 = this
(* po redu: 1871*)
(*1871*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1872*)
(*1872*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1873*)
(*1873*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1874*)
(*1874*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1875*)
(*1875*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1876*)
(*1876*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1877*)
(*1877*)  (*BRANCH NAME*)
} note note275 = this
(* po redu: 1878*)
(*1878*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1879*)
(*1879*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1880*)
(*1880*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1881*)
(*1881*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1882*)
(*1882*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1883*)
(*1883*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1884*)
(*1884*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1885*)
(*1885*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1886*)
(*1886*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1887*)
(*1887*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1888*)
(*1888*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1889*)
(*1889*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1890*)
(*1890*)  (*BRANCH NAME*)
} note note276 = this
(* po redu: 1891*)
(*1891*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1892*)
(*1892*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1893*)
(*1893*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1894*)
(*1894*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1895*)
(*1895*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1896*)
(*1896*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1897*)
(*1897*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1898*)
(*1898*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1899*)
(*1899*)  (*BRANCH NAME*)
} note note277 = this
(* po redu: 1900*)
(*1900*)  
(*BRANCH END*)
from note276 and note277 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1901*)
(*1901*)  (*BRANCH NAME*)
} note note278 = this
(* po redu: 1902*)
(*1902*)  
(*BRANCH END*)
from note275 and note278 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1903*)
(*1903*)  (*BRANCH NAME*)
} note note279 = this
(* po redu: 1904*)
(*1904*)  
(*BRANCH END*)
from note274 and note279 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1905*)
(*1905*)  (*BRANCH NAME*)
} note note280 = this
(* po redu: 1906*)
(*1906*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 1907*)
(*1907*)  (*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

(* po redu: 1908*)
(*1908*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
(* po redu: 1909*)
(*1909*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1910*)
(*1910*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1911*)
(*1911*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1912*)
(*1912*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1913*)
(*1913*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1914*)
(*1914*)  (*BRANCH NAME*)
} note note281 = this
(* po redu: 1915*)
(*1915*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1916*)
(*1916*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1917*)
(*1917*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1918*)
(*1918*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1919*)
(*1919*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1920*)
(*1920*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1921*)
(*1921*)  (*BRANCH NAME*)
} note note282 = this
(* po redu: 1922*)
(*1922*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1923*)
(*1923*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1924*)
(*1924*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1925*)
(*1925*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1926*)
(*1926*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1927*)
(*1927*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1928*)
(*1928*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1929*)
(*1929*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1930*)
(*1930*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1931*)
(*1931*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1932*)
(*1932*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1933*)
(*1933*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1934*)
(*1934*)  (*BRANCH NAME*)
} note note283 = this
(* po redu: 1935*)
(*1935*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 1936*)
(*1936*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1937*)
(*1937*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 1938*)
(*1938*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1939*)
(*1939*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1940*)
(*1940*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1941*)
(*1941*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1942*)
(*1942*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1943*)
(*1943*)  (*BRANCH NAME*)
} note note284 = this
(* po redu: 1944*)
(*1944*)  
(*BRANCH END*)
from note283 and note284 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 1945*)
(*1945*)  (*BRANCH NAME*)
} note note285 = this
(* po redu: 1946*)
(*1946*)  
(*BRANCH END*)
from note282 and note285 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 1947*)
(*1947*)  (*BRANCH NAME*)
} note note286 = this
(* po redu: 1948*)
(*1948*)  
(*BRANCH END*)
from note281 and note286 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 1949*)
(*1949*)  (*BRANCH NAME*)
} note note287 = this
(* po redu: 1950*)
(*1950*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
(* po redu: 1951*)
(*1951*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 1952*)
(*1952*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 1953*)
(*1953*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 1954*)
(*1954*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 1955*)
(*1955*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1956*)
(*1956*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 1957*)
(*1957*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 1958*)
(*1958*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 1959*)
(*1959*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 1960*)
(*1960*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 1961*)
(*1961*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1962*)
(*1962*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1963*)
(*1963*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1964*)
(*1964*)  (*BRANCH NAME*)
} note note288 = this
(* po redu: 1965*)
(*1965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 1966*)
(*1966*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 1967*)
(*1967*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 1968*)
(*1968*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1969*)
(*1969*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1970*)
(*1970*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1971*)
(*1971*)  (*BRANCH NAME*)
} note note289 = this
(* po redu: 1972*)
(*1972*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 1973*)
(*1973*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 1974*)
(*1974*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 1975*)
(*1975*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1976*)
(*1976*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1977*)
(*1977*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1978*)
(*1978*)  (*BRANCH NAME*)
} note note290 = this
(* po redu: 1979*)
(*1979*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 1980*)
(*1980*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 1981*)
(*1981*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 1982*)
(*1982*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 1983*)
(*1983*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 1984*)
(*1984*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 1985*)
(*1985*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 1986*)
(*1986*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 1987*)
(*1987*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1988*)
(*1988*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 1989*)
(*1989*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 1990*)
(*1990*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1991*)
(*1991*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 1992*)
(*1992*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 1993*)
(*1993*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 1994*)
(*1994*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 1995*)
(*1995*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1996*)
(*1996*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1997*)
(*1997*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1998*)
(*1998*)  (*BRANCH NAME*)
} note note291 = this
(* po redu: 1999*)
(*1999*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2000*)
(*2000*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2001*)
(*2001*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2002*)
(*2002*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2003*)
(*2003*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2004*)
(*2004*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2005*)
(*2005*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2006*)
(*2006*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2007*)
(*2007*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2008*)
(*2008*)  (*BRANCH NAME*)
} note note292 = this
(* po redu: 2009*)
(*2009*)  
(*BRANCH END*)
from note291 and note292 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2010*)
(*2010*)  (*BRANCH NAME*)
} note note293 = this
(* po redu: 2011*)
(*2011*)  
(*BRANCH END*)
from note290 and note293 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 2012*)
(*2012*)  (*BRANCH NAME*)
} note note294 = this
(* po redu: 2013*)
(*2013*)  
(*BRANCH END*)
from note289 and note294 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2014*)
(*2014*)  (*BRANCH NAME*)
} note note295 = this
(* po redu: 2015*)
(*2015*)  
(*BRANCH END*)
from note288 and note295 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2016*)
(*2016*)  (*BRANCH NAME*)
} note note296 = this
(* po redu: 2017*)
(*2017*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 2018*)
(*2018*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2019*)
(*2019*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 2020*)
(*2020*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 2021*)
(*2021*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 2022*)
(*2022*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2023*)
(*2023*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2024*)
(*2024*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2025*)
(*2025*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2026*)
(*2026*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2027*)
(*2027*)  (*BRANCH NAME*)
} note note297 = this
(* po redu: 2028*)
(*2028*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2029*)
(*2029*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2030*)
(*2030*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2031*)
(*2031*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2032*)
(*2032*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2033*)
(*2033*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2034*)
(*2034*)  (*BRANCH NAME*)
} note note298 = this
(* po redu: 2035*)
(*2035*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2036*)
(*2036*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 2037*)
(*2037*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 2038*)
(*2038*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2039*)
(*2039*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2040*)
(*2040*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2041*)
(*2041*)  (*BRANCH NAME*)
} note note299 = this
(* po redu: 2042*)
(*2042*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 2043*)
(*2043*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2044*)
(*2044*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2045*)
(*2045*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2046*)
(*2046*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2047*)
(*2047*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2048*)
(*2048*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2049*)
(*2049*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2050*)
(*2050*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2051*)
(*2051*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2052*)
(*2052*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2053*)
(*2053*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2054*)
(*2054*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2055*)
(*2055*)  (*BRANCH NAME*)
} note note300 = this
(* po redu: 2056*)
(*2056*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2057*)
(*2057*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2058*)
(*2058*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2059*)
(*2059*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2060*)
(*2060*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2061*)
(*2061*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2062*)
(*2062*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2063*)
(*2063*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2064*)
(*2064*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2065*)
(*2065*)  (*BRANCH NAME*)
} note note301 = this
(* po redu: 2066*)
(*2066*)  
(*BRANCH END*)
from note300 and note301 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2067*)
(*2067*)  (*BRANCH NAME*)
} note note302 = this
(* po redu: 2068*)
(*2068*)  
(*BRANCH END*)
from note299 and note302 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 2069*)
(*2069*)  (*BRANCH NAME*)
} note note303 = this
(* po redu: 2070*)
(*2070*)  
(*BRANCH END*)
from note298 and note303 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2071*)
(*2071*)  (*BRANCH NAME*)
} note note304 = this
(* po redu: 2072*)
(*2072*)  
(*BRANCH END*)
from note297 and note304 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2073*)
(*2073*)  (*BRANCH NAME*)
} note note305 = this
(* po redu: 2074*)
(*2074*)  
(*BRANCH END*)
from note296 and note305 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 2075*)
(*2075*)  (*BRANCH NAME*)
} note note306 = this
(* po redu: 2076*)
(*2076*)  
(*BRANCH END*)
from note287 and note306 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
(* po redu: 2077*)
(*2077*)  (*BRANCH NAME*)
} note note307 = this
(* po redu: 2078*)
(*2078*)  
(*BRANCH END*)
from note280 and note307 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 2079*)
(*2079*)  (*BRANCH NAME*)
} note note308 = this
(* po redu: 2080*)
(*2080*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 2081*)
(*2081*)  (*REGULAR*)
moreover

have  "PO4 = PO5 \<or> PO4 ~= PO5"
using ax_g1 [of "PO4" "PO5"]
by auto

(* po redu: 2082*)
(*2082*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO5"
(* po redu: 2083*)
(*2083*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 2084*)
(*2084*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 2085*)
(*2085*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2086*)
(*2086*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2087*)
(*2087*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2088*)
(*2088*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2089*)
(*2089*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2090*)
(*2090*)  (*BRANCH NAME*)
} note note309 = this
(* po redu: 2091*)
(*2091*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2092*)
(*2092*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2093*)
(*2093*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2094*)
(*2094*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2095*)
(*2095*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2096*)
(*2096*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2097*)
(*2097*)  (*BRANCH NAME*)
} note note310 = this
(* po redu: 2098*)
(*2098*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2099*)
(*2099*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2100*)
(*2100*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2101*)
(*2101*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2102*)
(*2102*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2103*)
(*2103*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2104*)
(*2104*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2105*)
(*2105*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2106*)
(*2106*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2107*)
(*2107*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2108*)
(*2108*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2109*)
(*2109*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2110*)
(*2110*)  (*BRANCH NAME*)
} note note311 = this
(* po redu: 2111*)
(*2111*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2112*)
(*2112*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2113*)
(*2113*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2114*)
(*2114*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2115*)
(*2115*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2116*)
(*2116*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2117*)
(*2117*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2118*)
(*2118*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2119*)
(*2119*)  (*BRANCH NAME*)
} note note312 = this
(* po redu: 2120*)
(*2120*)  
(*BRANCH END*)
from note311 and note312 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2121*)
(*2121*)  (*BRANCH NAME*)
} note note313 = this
(* po redu: 2122*)
(*2122*)  
(*BRANCH END*)
from note310 and note313 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2123*)
(*2123*)  (*BRANCH NAME*)
} note note314 = this
(* po redu: 2124*)
(*2124*)  
(*BRANCH END*)
from note309 and note314 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2125*)
(*2125*)  (*BRANCH NAME*)
} note note315 = this
(* po redu: 2126*)
(*2126*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 2127*)
(*2127*)  (*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

(* po redu: 2128*)
(*2128*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
(* po redu: 2129*)
(*2129*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2130*)
(*2130*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2131*)
(*2131*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2132*)
(*2132*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2133*)
(*2133*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2134*)
(*2134*)  (*BRANCH NAME*)
} note note316 = this
(* po redu: 2135*)
(*2135*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2136*)
(*2136*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2137*)
(*2137*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2138*)
(*2138*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2139*)
(*2139*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2140*)
(*2140*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2141*)
(*2141*)  (*BRANCH NAME*)
} note note317 = this
(* po redu: 2142*)
(*2142*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2143*)
(*2143*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2144*)
(*2144*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2145*)
(*2145*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2146*)
(*2146*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2147*)
(*2147*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2148*)
(*2148*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2149*)
(*2149*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2150*)
(*2150*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2151*)
(*2151*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2152*)
(*2152*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2153*)
(*2153*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2154*)
(*2154*)  (*BRANCH NAME*)
} note note318 = this
(* po redu: 2155*)
(*2155*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2156*)
(*2156*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2157*)
(*2157*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2158*)
(*2158*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2159*)
(*2159*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2160*)
(*2160*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2161*)
(*2161*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2162*)
(*2162*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2163*)
(*2163*)  (*BRANCH NAME*)
} note note319 = this
(* po redu: 2164*)
(*2164*)  
(*BRANCH END*)
from note318 and note319 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2165*)
(*2165*)  (*BRANCH NAME*)
} note note320 = this
(* po redu: 2166*)
(*2166*)  
(*BRANCH END*)
from note317 and note320 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2167*)
(*2167*)  (*BRANCH NAME*)
} note note321 = this
(* po redu: 2168*)
(*2168*)  
(*BRANCH END*)
from note316 and note321 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2169*)
(*2169*)  (*BRANCH NAME*)
} note note322 = this
(* po redu: 2170*)
(*2170*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
(* po redu: 2171*)
(*2171*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 2172*)
(*2172*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 2173*)
(*2173*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 2174*)
(*2174*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 2175*)
(*2175*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 2176*)
(*2176*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 2177*)
(*2177*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 2178*)
(*2178*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 2179*)
(*2179*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2180*)
(*2180*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2181*)
(*2181*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2182*)
(*2182*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2183*)
(*2183*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2184*)
(*2184*)  (*BRANCH NAME*)
} note note323 = this
(* po redu: 2185*)
(*2185*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2186*)
(*2186*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2187*)
(*2187*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2188*)
(*2188*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2189*)
(*2189*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2190*)
(*2190*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2191*)
(*2191*)  (*BRANCH NAME*)
} note note324 = this
(* po redu: 2192*)
(*2192*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2193*)
(*2193*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 2194*)
(*2194*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 2195*)
(*2195*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2196*)
(*2196*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2197*)
(*2197*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2198*)
(*2198*)  (*BRANCH NAME*)
} note note325 = this
(* po redu: 2199*)
(*2199*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 2200*)
(*2200*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2201*)
(*2201*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2202*)
(*2202*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2203*)
(*2203*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 2204*)
(*2204*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2205*)
(*2205*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 2206*)
(*2206*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 2207*)
(*2207*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2208*)
(*2208*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 2209*)
(*2209*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 2210*)
(*2210*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2211*)
(*2211*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2212*)
(*2212*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2213*)
(*2213*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2214*)
(*2214*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2215*)
(*2215*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2216*)
(*2216*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2217*)
(*2217*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2218*)
(*2218*)  (*BRANCH NAME*)
} note note326 = this
(* po redu: 2219*)
(*2219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2220*)
(*2220*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2221*)
(*2221*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2222*)
(*2222*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2223*)
(*2223*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2224*)
(*2224*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2225*)
(*2225*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2226*)
(*2226*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2227*)
(*2227*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2228*)
(*2228*)  (*BRANCH NAME*)
} note note327 = this
(* po redu: 2229*)
(*2229*)  
(*BRANCH END*)
from note326 and note327 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2230*)
(*2230*)  (*BRANCH NAME*)
} note note328 = this
(* po redu: 2231*)
(*2231*)  
(*BRANCH END*)
from note325 and note328 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 2232*)
(*2232*)  (*BRANCH NAME*)
} note note329 = this
(* po redu: 2233*)
(*2233*)  
(*BRANCH END*)
from note324 and note329 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2234*)
(*2234*)  (*BRANCH NAME*)
} note note330 = this
(* po redu: 2235*)
(*2235*)  
(*BRANCH END*)
from note323 and note330 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2236*)
(*2236*)  (*BRANCH NAME*)
} note note331 = this
(* po redu: 2237*)
(*2237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 2238*)
(*2238*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2239*)
(*2239*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 2240*)
(*2240*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 2241*)
(*2241*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 2242*)
(*2242*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2243*)
(*2243*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2244*)
(*2244*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2245*)
(*2245*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2246*)
(*2246*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2247*)
(*2247*)  (*BRANCH NAME*)
} note note332 = this
(* po redu: 2248*)
(*2248*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2249*)
(*2249*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2250*)
(*2250*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2251*)
(*2251*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2252*)
(*2252*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2253*)
(*2253*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2254*)
(*2254*)  (*BRANCH NAME*)
} note note333 = this
(* po redu: 2255*)
(*2255*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2256*)
(*2256*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 2257*)
(*2257*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 2258*)
(*2258*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2259*)
(*2259*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2260*)
(*2260*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2261*)
(*2261*)  (*BRANCH NAME*)
} note note334 = this
(* po redu: 2262*)
(*2262*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 2263*)
(*2263*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2264*)
(*2264*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2265*)
(*2265*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2266*)
(*2266*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2267*)
(*2267*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2268*)
(*2268*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2269*)
(*2269*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2270*)
(*2270*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2271*)
(*2271*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2272*)
(*2272*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2273*)
(*2273*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2274*)
(*2274*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2275*)
(*2275*)  (*BRANCH NAME*)
} note note335 = this
(* po redu: 2276*)
(*2276*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2277*)
(*2277*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2278*)
(*2278*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2279*)
(*2279*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2280*)
(*2280*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2281*)
(*2281*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2282*)
(*2282*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2283*)
(*2283*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2284*)
(*2284*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2285*)
(*2285*)  (*BRANCH NAME*)
} note note336 = this
(* po redu: 2286*)
(*2286*)  
(*BRANCH END*)
from note335 and note336 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2287*)
(*2287*)  (*BRANCH NAME*)
} note note337 = this
(* po redu: 2288*)
(*2288*)  
(*BRANCH END*)
from note334 and note337 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 2289*)
(*2289*)  (*BRANCH NAME*)
} note note338 = this
(* po redu: 2290*)
(*2290*)  
(*BRANCH END*)
from note333 and note338 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2291*)
(*2291*)  (*BRANCH NAME*)
} note note339 = this
(* po redu: 2292*)
(*2292*)  
(*BRANCH END*)
from note332 and note339 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2293*)
(*2293*)  (*BRANCH NAME*)
} note note340 = this
(* po redu: 2294*)
(*2294*)  
(*BRANCH END*)
from note331 and note340 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 2295*)
(*2295*)  (*BRANCH NAME*)
} note note341 = this
(* po redu: 2296*)
(*2296*)  
(*BRANCH END*)
from note322 and note341 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
(* po redu: 2297*)
(*2297*)  (*BRANCH NAME*)
} note note342 = this
(* po redu: 2298*)
(*2298*)  
(*BRANCH END*)
from note315 and note342 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 2299*)
(*2299*)  (*BRANCH NAME*)
} note note343 = this
(* po redu: 2300*)
(*2300*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO5"
(* po redu: 2301*)
(*2301*)  (*REGULAR*)
moreover

have  "inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1"
using ax_g5 [of "PO5" "PL1"]
by auto

(* po redu: 2302*)
(*2302*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO5 PL1"
(* po redu: 2303*)
(*2303*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 2304*)
(*2304*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 2305*)
(*2305*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 2306*)
(*2306*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 2307*)
(*2307*)  (*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

(* po redu: 2308*)
(*2308*)  (*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

(* po redu: 2309*)
(*2309*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 2310*)
(*2310*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 2311*)
(*2311*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2312*)
(*2312*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2313*)
(*2313*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2314*)
(*2314*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2315*)
(*2315*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2316*)
(*2316*)  (*BRANCH NAME*)
} note note344 = this
(* po redu: 2317*)
(*2317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2318*)
(*2318*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2319*)
(*2319*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2320*)
(*2320*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2321*)
(*2321*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2322*)
(*2322*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2323*)
(*2323*)  (*BRANCH NAME*)
} note note345 = this
(* po redu: 2324*)
(*2324*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2325*)
(*2325*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2326*)
(*2326*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2327*)
(*2327*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2328*)
(*2328*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2329*)
(*2329*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2330*)
(*2330*)  (*BRANCH NAME*)
} note note346 = this
(* po redu: 2331*)
(*2331*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2332*)
(*2332*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2333*)
(*2333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2334*)
(*2334*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2335*)
(*2335*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 2336*)
(*2336*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2337*)
(*2337*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2338*)
(*2338*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2339*)
(*2339*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2340*)
(*2340*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2341*)
(*2341*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2342*)
(*2342*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2343*)
(*2343*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2344*)
(*2344*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2345*)
(*2345*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2346*)
(*2346*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2347*)
(*2347*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2348*)
(*2348*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2349*)
(*2349*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2350*)
(*2350*)  (*BRANCH NAME*)
} note note347 = this
(* po redu: 2351*)
(*2351*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2352*)
(*2352*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2353*)
(*2353*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2354*)
(*2354*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2355*)
(*2355*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2356*)
(*2356*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2357*)
(*2357*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2358*)
(*2358*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2359*)
(*2359*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2360*)
(*2360*)  (*BRANCH NAME*)
} note note348 = this
(* po redu: 2361*)
(*2361*)  
(*BRANCH END*)
from note347 and note348 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2362*)
(*2362*)  (*BRANCH NAME*)
} note note349 = this
(* po redu: 2363*)
(*2363*)  
(*BRANCH END*)
from note346 and note349 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2364*)
(*2364*)  (*BRANCH NAME*)
} note note350 = this
(* po redu: 2365*)
(*2365*)  
(*BRANCH END*)
from note345 and note350 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2366*)
(*2366*)  (*BRANCH NAME*)
} note note351 = this
(* po redu: 2367*)
(*2367*)  
(*BRANCH END*)
from note344 and note351 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2368*)
(*2368*)  (*BRANCH NAME*)
} note note352 = this
(* po redu: 2369*)
(*2369*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 2370*)
(*2370*)  (*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

(* po redu: 2371*)
(*2371*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
(* po redu: 2372*)
(*2372*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2373*)
(*2373*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2374*)
(*2374*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2375*)
(*2375*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2376*)
(*2376*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2377*)
(*2377*)  (*BRANCH NAME*)
} note note353 = this
(* po redu: 2378*)
(*2378*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2379*)
(*2379*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2380*)
(*2380*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2381*)
(*2381*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2382*)
(*2382*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2383*)
(*2383*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2384*)
(*2384*)  (*BRANCH NAME*)
} note note354 = this
(* po redu: 2385*)
(*2385*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2386*)
(*2386*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2387*)
(*2387*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2388*)
(*2388*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2389*)
(*2389*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2390*)
(*2390*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2391*)
(*2391*)  (*BRANCH NAME*)
} note note355 = this
(* po redu: 2392*)
(*2392*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2393*)
(*2393*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2394*)
(*2394*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2395*)
(*2395*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2396*)
(*2396*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 2397*)
(*2397*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2398*)
(*2398*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2399*)
(*2399*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2400*)
(*2400*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2401*)
(*2401*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2402*)
(*2402*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2403*)
(*2403*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2404*)
(*2404*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2405*)
(*2405*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2406*)
(*2406*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2407*)
(*2407*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2408*)
(*2408*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2409*)
(*2409*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2410*)
(*2410*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2411*)
(*2411*)  (*BRANCH NAME*)
} note note356 = this
(* po redu: 2412*)
(*2412*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2413*)
(*2413*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2414*)
(*2414*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2415*)
(*2415*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2416*)
(*2416*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2417*)
(*2417*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2418*)
(*2418*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2419*)
(*2419*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2420*)
(*2420*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2421*)
(*2421*)  (*BRANCH NAME*)
} note note357 = this
(* po redu: 2422*)
(*2422*)  
(*BRANCH END*)
from note356 and note357 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2423*)
(*2423*)  (*BRANCH NAME*)
} note note358 = this
(* po redu: 2424*)
(*2424*)  
(*BRANCH END*)
from note355 and note358 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2425*)
(*2425*)  (*BRANCH NAME*)
} note note359 = this
(* po redu: 2426*)
(*2426*)  
(*BRANCH END*)
from note354 and note359 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2427*)
(*2427*)  (*BRANCH NAME*)
} note note360 = this
(* po redu: 2428*)
(*2428*)  
(*BRANCH END*)
from note353 and note360 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2429*)
(*2429*)  (*BRANCH NAME*)
} note note361 = this
(* po redu: 2430*)
(*2430*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
(* po redu: 2431*)
(*2431*)  (*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

(* po redu: 2432*)
(*2432*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
(* po redu: 2433*)
(*2433*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2434*)
(*2434*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2435*)
(*2435*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2436*)
(*2436*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2437*)
(*2437*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2438*)
(*2438*)  (*BRANCH NAME*)
} note note362 = this
(* po redu: 2439*)
(*2439*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2440*)
(*2440*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2441*)
(*2441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2442*)
(*2442*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2443*)
(*2443*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2444*)
(*2444*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2445*)
(*2445*)  (*BRANCH NAME*)
} note note363 = this
(* po redu: 2446*)
(*2446*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2447*)
(*2447*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2448*)
(*2448*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2449*)
(*2449*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2450*)
(*2450*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2451*)
(*2451*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2452*)
(*2452*)  (*BRANCH NAME*)
} note note364 = this
(* po redu: 2453*)
(*2453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2454*)
(*2454*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2455*)
(*2455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2456*)
(*2456*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2457*)
(*2457*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 2458*)
(*2458*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2459*)
(*2459*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2460*)
(*2460*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2461*)
(*2461*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2462*)
(*2462*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2463*)
(*2463*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2464*)
(*2464*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2465*)
(*2465*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2466*)
(*2466*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2467*)
(*2467*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2468*)
(*2468*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2469*)
(*2469*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2470*)
(*2470*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2471*)
(*2471*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2472*)
(*2472*)  (*BRANCH NAME*)
} note note365 = this
(* po redu: 2473*)
(*2473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2474*)
(*2474*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2475*)
(*2475*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2476*)
(*2476*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2477*)
(*2477*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2478*)
(*2478*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2479*)
(*2479*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2480*)
(*2480*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2481*)
(*2481*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2482*)
(*2482*)  (*BRANCH NAME*)
} note note366 = this
(* po redu: 2483*)
(*2483*)  
(*BRANCH END*)
from note365 and note366 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2484*)
(*2484*)  (*BRANCH NAME*)
} note note367 = this
(* po redu: 2485*)
(*2485*)  
(*BRANCH END*)
from note364 and note367 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2486*)
(*2486*)  (*BRANCH NAME*)
} note note368 = this
(* po redu: 2487*)
(*2487*)  
(*BRANCH END*)
from note363 and note368 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2488*)
(*2488*)  (*BRANCH NAME*)
} note note369 = this
(* po redu: 2489*)
(*2489*)  
(*BRANCH END*)
from note362 and note369 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2490*)
(*2490*)  (*BRANCH NAME*)
} note note370 = this
(* po redu: 2491*)
(*2491*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
(* po redu: 2492*)
(*2492*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 2493*)
(*2493*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 2494*)
(*2494*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 2495*)
(*2495*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO6"]
by auto

(* po redu: 2496*)
(*2496*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 2497*)
(*2497*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO6"]
by auto

(* po redu: 2498*)
(*2498*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO6"]
by auto

(* po redu: 2499*)
(*2499*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 2500*)
(*2500*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO5 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO6"]
by auto

(* po redu: 2501*)
(*2501*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO6" "PO6"]
by auto

(* po redu: 2502*)
(*2502*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO6 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 2503*)
(*2503*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 2504*)
(*2504*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 2505*)
(*2505*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 2506*)
(*2506*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 2507*)
(*2507*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2508*)
(*2508*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2509*)
(*2509*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2510*)
(*2510*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2511*)
(*2511*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2512*)
(*2512*)  (*BRANCH NAME*)
} note note371 = this
(* po redu: 2513*)
(*2513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2514*)
(*2514*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2515*)
(*2515*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2516*)
(*2516*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2517*)
(*2517*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2518*)
(*2518*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2519*)
(*2519*)  (*BRANCH NAME*)
} note note372 = this
(* po redu: 2520*)
(*2520*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2521*)
(*2521*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2522*)
(*2522*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2523*)
(*2523*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2524*)
(*2524*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2525*)
(*2525*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2526*)
(*2526*)  (*BRANCH NAME*)
} note note373 = this
(* po redu: 2527*)
(*2527*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2528*)
(*2528*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 2529*)
(*2529*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 2530*)
(*2530*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2531*)
(*2531*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2532*)
(*2532*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2533*)
(*2533*)  (*BRANCH NAME*)
} note note374 = this
(* po redu: 2534*)
(*2534*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 2535*)
(*2535*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2536*)
(*2536*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2537*)
(*2537*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2538*)
(*2538*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 2539*)
(*2539*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 2540*)
(*2540*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2541*)
(*2541*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2542*)
(*2542*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO7"]
by auto

(* po redu: 2543*)
(*2543*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2544*)
(*2544*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 2545*)
(*2545*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 2546*)
(*2546*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2547*)
(*2547*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2548*)
(*2548*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO6 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO6" "PO7"]
by auto

(* po redu: 2549*)
(*2549*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2550*)
(*2550*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO6 PO6 PO7"
using ax_D3 [of "PO5" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 2551*)
(*2551*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO6 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 2552*)
(*2552*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2553*)
(*2553*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 2554*)
(*2554*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 2555*)
(*2555*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2556*)
(*2556*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2557*)
(*2557*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2558*)
(*2558*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2559*)
(*2559*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2560*)
(*2560*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2561*)
(*2561*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2562*)
(*2562*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2563*)
(*2563*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2564*)
(*2564*)  (*BRANCH NAME*)
} note note375 = this
(* po redu: 2565*)
(*2565*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2566*)
(*2566*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2567*)
(*2567*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2568*)
(*2568*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2569*)
(*2569*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2570*)
(*2570*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2571*)
(*2571*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2572*)
(*2572*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2573*)
(*2573*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2574*)
(*2574*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2575*)
(*2575*)  (*BRANCH NAME*)
} note note376 = this
(* po redu: 2576*)
(*2576*)  
(*BRANCH END*)
from note375 and note376 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2577*)
(*2577*)  (*BRANCH NAME*)
} note note377 = this
(* po redu: 2578*)
(*2578*)  
(*BRANCH END*)
from note374 and note377 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 2579*)
(*2579*)  (*BRANCH NAME*)
} note note378 = this
(* po redu: 2580*)
(*2580*)  
(*BRANCH END*)
from note373 and note378 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2581*)
(*2581*)  (*BRANCH NAME*)
} note note379 = this
(* po redu: 2582*)
(*2582*)  
(*BRANCH END*)
from note372 and note379 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2583*)
(*2583*)  (*BRANCH NAME*)
} note note380 = this
(* po redu: 2584*)
(*2584*)  
(*BRANCH END*)
from note371 and note380 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2585*)
(*2585*)  (*BRANCH NAME*)
} note note381 = this
(* po redu: 2586*)
(*2586*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 2587*)
(*2587*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2588*)
(*2588*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 2589*)
(*2589*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 2590*)
(*2590*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 2591*)
(*2591*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 2592*)
(*2592*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2593*)
(*2593*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2594*)
(*2594*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2595*)
(*2595*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2596*)
(*2596*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2597*)
(*2597*)  (*BRANCH NAME*)
} note note382 = this
(* po redu: 2598*)
(*2598*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2599*)
(*2599*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2600*)
(*2600*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2601*)
(*2601*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2602*)
(*2602*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2603*)
(*2603*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2604*)
(*2604*)  (*BRANCH NAME*)
} note note383 = this
(* po redu: 2605*)
(*2605*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2606*)
(*2606*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2607*)
(*2607*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2608*)
(*2608*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2609*)
(*2609*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2610*)
(*2610*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2611*)
(*2611*)  (*BRANCH NAME*)
} note note384 = this
(* po redu: 2612*)
(*2612*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2613*)
(*2613*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 2614*)
(*2614*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 2615*)
(*2615*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2616*)
(*2616*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2617*)
(*2617*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2618*)
(*2618*)  (*BRANCH NAME*)
} note note385 = this
(* po redu: 2619*)
(*2619*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 2620*)
(*2620*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2621*)
(*2621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2622*)
(*2622*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2623*)
(*2623*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

(* po redu: 2624*)
(*2624*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2625*)
(*2625*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2626*)
(*2626*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2627*)
(*2627*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2628*)
(*2628*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

(* po redu: 2629*)
(*2629*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

(* po redu: 2630*)
(*2630*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2631*)
(*2631*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2632*)
(*2632*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2633*)
(*2633*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2634*)
(*2634*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2635*)
(*2635*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2636*)
(*2636*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2637*)
(*2637*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2638*)
(*2638*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2639*)
(*2639*)  (*BRANCH NAME*)
} note note386 = this
(* po redu: 2640*)
(*2640*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2641*)
(*2641*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2642*)
(*2642*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2643*)
(*2643*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2644*)
(*2644*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2645*)
(*2645*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2646*)
(*2646*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2647*)
(*2647*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2648*)
(*2648*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2649*)
(*2649*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2650*)
(*2650*)  (*BRANCH NAME*)
} note note387 = this
(* po redu: 2651*)
(*2651*)  
(*BRANCH END*)
from note386 and note387 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2652*)
(*2652*)  (*BRANCH NAME*)
} note note388 = this
(* po redu: 2653*)
(*2653*)  
(*BRANCH END*)
from note385 and note388 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 2654*)
(*2654*)  (*BRANCH NAME*)
} note note389 = this
(* po redu: 2655*)
(*2655*)  
(*BRANCH END*)
from note384 and note389 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2656*)
(*2656*)  (*BRANCH NAME*)
} note note390 = this
(* po redu: 2657*)
(*2657*)  
(*BRANCH END*)
from note383 and note390 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2658*)
(*2658*)  (*BRANCH NAME*)
} note note391 = this
(* po redu: 2659*)
(*2659*)  
(*BRANCH END*)
from note382 and note391 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2660*)
(*2660*)  (*BRANCH NAME*)
} note note392 = this
(* po redu: 2661*)
(*2661*)  
(*BRANCH END*)
from note381 and note392 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 2662*)
(*2662*)  (*BRANCH NAME*)
} note note393 = this
(* po redu: 2663*)
(*2663*)  
(*BRANCH END*)
from note370 and note393 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
(* po redu: 2664*)
(*2664*)  (*BRANCH NAME*)
} note note394 = this
(* po redu: 2665*)
(*2665*)  
(*BRANCH END*)
from note361 and note394 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
(* po redu: 2666*)
(*2666*)  (*BRANCH NAME*)
} note note395 = this
(* po redu: 2667*)
(*2667*)  
(*BRANCH END*)
from note352 and note395 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 2668*)
(*2668*)  (*BRANCH NAME*)
} note note396 = this
(* po redu: 2669*)
(*2669*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO5 PL1"
(* po redu: 2670*)
(*2670*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2671*)
(*2671*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO5 PL1`
have  "\<not>comp PO1 PO1 PO1 PO5"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO5"]
by auto

(* po redu: 2672*)
(*2672*)  (*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

(* po redu: 2673*)
(*2673*)  (*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

(* po redu: 2674*)
(*2674*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 2675*)
(*2675*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 2676*)
(*2676*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2677*)
(*2677*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2678*)
(*2678*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2679*)
(*2679*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2680*)
(*2680*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2681*)
(*2681*)  (*BRANCH NAME*)
} note note397 = this
(* po redu: 2682*)
(*2682*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2683*)
(*2683*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2684*)
(*2684*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2685*)
(*2685*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2686*)
(*2686*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2687*)
(*2687*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2688*)
(*2688*)  (*BRANCH NAME*)
} note note398 = this
(* po redu: 2689*)
(*2689*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2690*)
(*2690*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2691*)
(*2691*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2692*)
(*2692*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2693*)
(*2693*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2694*)
(*2694*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2695*)
(*2695*)  (*BRANCH NAME*)
} note note399 = this
(* po redu: 2696*)
(*2696*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2697*)
(*2697*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2698*)
(*2698*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2699*)
(*2699*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2700*)
(*2700*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2701*)
(*2701*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2702*)
(*2702*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2703*)
(*2703*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2704*)
(*2704*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2705*)
(*2705*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2706*)
(*2706*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2707*)
(*2707*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2708*)
(*2708*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2709*)
(*2709*)  (*BRANCH NAME*)
} note note400 = this
(* po redu: 2710*)
(*2710*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2711*)
(*2711*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2712*)
(*2712*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2713*)
(*2713*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2714*)
(*2714*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2715*)
(*2715*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2716*)
(*2716*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2717*)
(*2717*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2718*)
(*2718*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2719*)
(*2719*)  (*BRANCH NAME*)
} note note401 = this
(* po redu: 2720*)
(*2720*)  
(*BRANCH END*)
from note400 and note401 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2721*)
(*2721*)  (*BRANCH NAME*)
} note note402 = this
(* po redu: 2722*)
(*2722*)  
(*BRANCH END*)
from note399 and note402 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2723*)
(*2723*)  (*BRANCH NAME*)
} note note403 = this
(* po redu: 2724*)
(*2724*)  
(*BRANCH END*)
from note398 and note403 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2725*)
(*2725*)  (*BRANCH NAME*)
} note note404 = this
(* po redu: 2726*)
(*2726*)  
(*BRANCH END*)
from note397 and note404 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2727*)
(*2727*)  (*BRANCH NAME*)
} note note405 = this
(* po redu: 2728*)
(*2728*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 2729*)
(*2729*)  (*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

(* po redu: 2730*)
(*2730*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
(* po redu: 2731*)
(*2731*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2732*)
(*2732*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2733*)
(*2733*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2734*)
(*2734*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2735*)
(*2735*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2736*)
(*2736*)  (*BRANCH NAME*)
} note note406 = this
(* po redu: 2737*)
(*2737*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2738*)
(*2738*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2739*)
(*2739*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2740*)
(*2740*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2741*)
(*2741*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2742*)
(*2742*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2743*)
(*2743*)  (*BRANCH NAME*)
} note note407 = this
(* po redu: 2744*)
(*2744*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2745*)
(*2745*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2746*)
(*2746*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2747*)
(*2747*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2748*)
(*2748*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2749*)
(*2749*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2750*)
(*2750*)  (*BRANCH NAME*)
} note note408 = this
(* po redu: 2751*)
(*2751*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2752*)
(*2752*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2753*)
(*2753*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2754*)
(*2754*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2755*)
(*2755*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2756*)
(*2756*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2757*)
(*2757*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2758*)
(*2758*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2759*)
(*2759*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2760*)
(*2760*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2761*)
(*2761*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2762*)
(*2762*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2763*)
(*2763*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2764*)
(*2764*)  (*BRANCH NAME*)
} note note409 = this
(* po redu: 2765*)
(*2765*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2766*)
(*2766*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2767*)
(*2767*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2768*)
(*2768*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2769*)
(*2769*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2770*)
(*2770*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2771*)
(*2771*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2772*)
(*2772*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2773*)
(*2773*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2774*)
(*2774*)  (*BRANCH NAME*)
} note note410 = this
(* po redu: 2775*)
(*2775*)  
(*BRANCH END*)
from note409 and note410 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2776*)
(*2776*)  (*BRANCH NAME*)
} note note411 = this
(* po redu: 2777*)
(*2777*)  
(*BRANCH END*)
from note408 and note411 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2778*)
(*2778*)  (*BRANCH NAME*)
} note note412 = this
(* po redu: 2779*)
(*2779*)  
(*BRANCH END*)
from note407 and note412 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2780*)
(*2780*)  (*BRANCH NAME*)
} note note413 = this
(* po redu: 2781*)
(*2781*)  
(*BRANCH END*)
from note406 and note413 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2782*)
(*2782*)  (*BRANCH NAME*)
} note note414 = this
(* po redu: 2783*)
(*2783*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
(* po redu: 2784*)
(*2784*)  (*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

(* po redu: 2785*)
(*2785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
(* po redu: 2786*)
(*2786*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2787*)
(*2787*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2788*)
(*2788*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2789*)
(*2789*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2790*)
(*2790*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2791*)
(*2791*)  (*BRANCH NAME*)
} note note415 = this
(* po redu: 2792*)
(*2792*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2793*)
(*2793*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2794*)
(*2794*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2795*)
(*2795*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2796*)
(*2796*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2797*)
(*2797*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2798*)
(*2798*)  (*BRANCH NAME*)
} note note416 = this
(* po redu: 2799*)
(*2799*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2800*)
(*2800*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2801*)
(*2801*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2802*)
(*2802*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2803*)
(*2803*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2804*)
(*2804*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2805*)
(*2805*)  (*BRANCH NAME*)
} note note417 = this
(* po redu: 2806*)
(*2806*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2807*)
(*2807*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2808*)
(*2808*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2809*)
(*2809*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2810*)
(*2810*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2811*)
(*2811*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2812*)
(*2812*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2813*)
(*2813*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2814*)
(*2814*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2815*)
(*2815*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2816*)
(*2816*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2817*)
(*2817*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2818*)
(*2818*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2819*)
(*2819*)  (*BRANCH NAME*)
} note note418 = this
(* po redu: 2820*)
(*2820*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2821*)
(*2821*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2822*)
(*2822*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2823*)
(*2823*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2824*)
(*2824*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2825*)
(*2825*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2826*)
(*2826*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2827*)
(*2827*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2828*)
(*2828*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2829*)
(*2829*)  (*BRANCH NAME*)
} note note419 = this
(* po redu: 2830*)
(*2830*)  
(*BRANCH END*)
from note418 and note419 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2831*)
(*2831*)  (*BRANCH NAME*)
} note note420 = this
(* po redu: 2832*)
(*2832*)  
(*BRANCH END*)
from note417 and note420 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2833*)
(*2833*)  (*BRANCH NAME*)
} note note421 = this
(* po redu: 2834*)
(*2834*)  
(*BRANCH END*)
from note416 and note421 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2835*)
(*2835*)  (*BRANCH NAME*)
} note note422 = this
(* po redu: 2836*)
(*2836*)  
(*BRANCH END*)
from note415 and note422 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2837*)
(*2837*)  (*BRANCH NAME*)
} note note423 = this
(* po redu: 2838*)
(*2838*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
(* po redu: 2839*)
(*2839*)  (*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

(* po redu: 2840*)
(*2840*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
(* po redu: 2841*)
(*2841*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

(* po redu: 2842*)
(*2842*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

(* po redu: 2843*)
(*2843*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 2844*)
(*2844*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

(* po redu: 2845*)
(*2845*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 2846*)
(*2846*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 2847*)
(*2847*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 2848*)
(*2848*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2849*)
(*2849*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2850*)
(*2850*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2851*)
(*2851*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2852*)
(*2852*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2853*)
(*2853*)  (*BRANCH NAME*)
} note note424 = this
(* po redu: 2854*)
(*2854*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2855*)
(*2855*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2856*)
(*2856*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2857*)
(*2857*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2858*)
(*2858*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2859*)
(*2859*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2860*)
(*2860*)  (*BRANCH NAME*)
} note note425 = this
(* po redu: 2861*)
(*2861*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2862*)
(*2862*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2863*)
(*2863*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2864*)
(*2864*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2865*)
(*2865*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2866*)
(*2866*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2867*)
(*2867*)  (*BRANCH NAME*)
} note note426 = this
(* po redu: 2868*)
(*2868*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2869*)
(*2869*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 2870*)
(*2870*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 2871*)
(*2871*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2872*)
(*2872*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2873*)
(*2873*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2874*)
(*2874*)  (*BRANCH NAME*)
} note note427 = this
(* po redu: 2875*)
(*2875*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 2876*)
(*2876*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2877*)
(*2877*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2878*)
(*2878*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2879*)
(*2879*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

(* po redu: 2880*)
(*2880*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2881*)
(*2881*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 2882*)
(*2882*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 2883*)
(*2883*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2884*)
(*2884*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

(* po redu: 2885*)
(*2885*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

(* po redu: 2886*)
(*2886*)  (*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2887*)
(*2887*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2888*)
(*2888*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2889*)
(*2889*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2890*)
(*2890*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2891*)
(*2891*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2892*)
(*2892*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2893*)
(*2893*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2894*)
(*2894*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2895*)
(*2895*)  (*BRANCH NAME*)
} note note428 = this
(* po redu: 2896*)
(*2896*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2897*)
(*2897*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2898*)
(*2898*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2899*)
(*2899*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2900*)
(*2900*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2901*)
(*2901*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2902*)
(*2902*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2903*)
(*2903*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2904*)
(*2904*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2905*)
(*2905*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2906*)
(*2906*)  (*BRANCH NAME*)
} note note429 = this
(* po redu: 2907*)
(*2907*)  
(*BRANCH END*)
from note428 and note429 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2908*)
(*2908*)  (*BRANCH NAME*)
} note note430 = this
(* po redu: 2909*)
(*2909*)  
(*BRANCH END*)
from note427 and note430 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 2910*)
(*2910*)  (*BRANCH NAME*)
} note note431 = this
(* po redu: 2911*)
(*2911*)  
(*BRANCH END*)
from note426 and note431 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2912*)
(*2912*)  (*BRANCH NAME*)
} note note432 = this
(* po redu: 2913*)
(*2913*)  
(*BRANCH END*)
from note425 and note432 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2914*)
(*2914*)  (*BRANCH NAME*)
} note note433 = this
(* po redu: 2915*)
(*2915*)  
(*BRANCH END*)
from note424 and note433 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2916*)
(*2916*)  (*BRANCH NAME*)
} note note434 = this
(* po redu: 2917*)
(*2917*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
(* po redu: 2918*)
(*2918*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2919*)
(*2919*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

(* po redu: 2920*)
(*2920*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 2921*)
(*2921*)  (*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

(* po redu: 2922*)
(*2922*)  (*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

(* po redu: 2923*)
(*2923*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 2924*)
(*2924*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 2925*)
(*2925*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2926*)
(*2926*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2927*)
(*2927*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2928*)
(*2928*)  (*BRANCH NAME*)
} note note435 = this
(* po redu: 2929*)
(*2929*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 2930*)
(*2930*)  (*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

(* po redu: 2931*)
(*2931*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
(* po redu: 2932*)
(*2932*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2933*)
(*2933*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2934*)
(*2934*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2935*)
(*2935*)  (*BRANCH NAME*)
} note note436 = this
(* po redu: 2936*)
(*2936*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
(* po redu: 2937*)
(*2937*)  (*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

(* po redu: 2938*)
(*2938*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
(* po redu: 2939*)
(*2939*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2940*)
(*2940*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2941*)
(*2941*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2942*)
(*2942*)  (*BRANCH NAME*)
} note note437 = this
(* po redu: 2943*)
(*2943*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
(* po redu: 2944*)
(*2944*)  (*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

(* po redu: 2945*)
(*2945*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
(* po redu: 2946*)
(*2946*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2947*)
(*2947*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2948*)
(*2948*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2949*)
(*2949*)  (*BRANCH NAME*)
} note note438 = this
(* po redu: 2950*)
(*2950*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
(* po redu: 2951*)
(*2951*)  (*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

(* po redu: 2952*)
(*2952*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
(* po redu: 2953*)
(*2953*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

(* po redu: 2954*)
(*2954*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

(* po redu: 2955*)
(*2955*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2956*)
(*2956*)  (*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

(* po redu: 2957*)
(*2957*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2958*)
(*2958*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2959*)
(*2959*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2960*)
(*2960*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2961*)
(*2961*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2962*)
(*2962*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2963*)
(*2963*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2964*)
(*2964*)  (*BRANCH NAME*)
} note note439 = this
(* po redu: 2965*)
(*2965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
(* po redu: 2966*)
(*2966*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2967*)
(*2967*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

(* po redu: 2968*)
(*2968*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 2969*)
(*2969*)  (*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

(* po redu: 2970*)
(*2970*)  (*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

(* po redu: 2971*)
(*2971*)  (*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

(* po redu: 2972*)
(*2972*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2973*)
(*2973*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2974*)
(*2974*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2975*)
(*2975*)  (*BRANCH NAME*)
} note note440 = this
(* po redu: 2976*)
(*2976*)  
(*BRANCH END*)
from note439 and note440 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
(* po redu: 2977*)
(*2977*)  (*BRANCH NAME*)
} note note441 = this
(* po redu: 2978*)
(*2978*)  
(*BRANCH END*)
from note438 and note441 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
(* po redu: 2979*)
(*2979*)  (*BRANCH NAME*)
} note note442 = this
(* po redu: 2980*)
(*2980*)  
(*BRANCH END*)
from note437 and note442 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
(* po redu: 2981*)
(*2981*)  (*BRANCH NAME*)
} note note443 = this
(* po redu: 2982*)
(*2982*)  
(*BRANCH END*)
from note436 and note443 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
(* po redu: 2983*)
(*2983*)  (*BRANCH NAME*)
} note note444 = this
(* po redu: 2984*)
(*2984*)  
(*BRANCH END*)
from note435 and note444 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 2985*)
(*2985*)  (*BRANCH NAME*)
} note note445 = this
(* po redu: 2986*)
(*2986*)  
(*BRANCH END*)
from note434 and note445 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
(* po redu: 2987*)
(*2987*)  (*BRANCH NAME*)
} note note446 = this
(* po redu: 2988*)
(*2988*)  
(*BRANCH END*)
from note423 and note446 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
(* po redu: 2989*)
(*2989*)  (*BRANCH NAME*)
} note note447 = this
(* po redu: 2990*)
(*2990*)  
(*BRANCH END*)
from note414 and note447 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
(* po redu: 2991*)
(*2991*)  (*BRANCH NAME*)
} note note448 = this
(* po redu: 2992*)
(*2992*)  
(*BRANCH END*)
from note405 and note448 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 2993*)
(*2993*)  (*BRANCH NAME*)
} note note449 = this
(* po redu: 2994*)
(*2994*)  
(*BRANCH END*)
from note396 and note449 and `inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1`
have False
by auto
(* po redu: 2995*)
(*2995*)  (*BRANCH NAME*)
} note note450 = this
(* po redu: 2996*)
(*2996*)  
(*BRANCH END*)
from note343 and note450 and `PO4 = PO5 \<or> PO4 ~= PO5`
have False
by auto
(* po redu: 2997*)
(*2997*)  (*BRANCH NAME*)
} note note451 = this
(* po redu: 2998*)
(*2998*)  
(*BRANCH END*)
from note308 and note451 and `PO1 = PO5 \<or> PO1 ~= PO5`
have False
by auto
(* po redu: 2999*)
(*2999*)  (*BRANCH NAME*)
} note note452 = this
(* po redu: 3000*)
(*3000*)  
(*BRANCH END*)
from note273 and note452 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have False
by auto
(* po redu: 3001*)
(*3001*)  (*BRANCH NAME*)
} note note453 = this
(* po redu: 3002*)
(*3002*)  
(*BRANCH END*)
from note94 and note453 and `PO1 = PO4 \<or> PO1 ~= PO4`
have False
by auto
(* po redu: 3003*)
(*3003*)  (*BRANCH NAME*)
} note note454 = this
(* po redu: 3004*)
(*3004*)  
(*BRANCH END*)
from note1 and note454 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have False
by auto
(* po redu: 3005*)
(*3005*)  (*BRANCH NAME*)
} note note455 = this
(* po redu: 3006*)
(*3006*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 3007*)
(*3007*)  (*REGULAR*)
moreover
from `PO1 ~= PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO3 LI1"
using ax_I1 [of "PO1" "PO3"]
by auto

(* po redu: 3008*)
(*3008*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(* po redu: 3009*)
(*3009*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1"
using ax_I4a [of "PO1" "PO1" "PO3"]
by auto

(* po redu: 3010*)
(*3010*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 3011*)
(*3011*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(* po redu: 3012*)
(*3012*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(* po redu: 3013*)
(*3013*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO3` and `\<not>col PO1 PO1 PO3`
have False
by auto

(* po redu: 3014*)
(*3014*)  (*BRANCH NAME*)
} note note456 = this
(* po redu: 3015*)
(*3015*)  
(*BRANCH END*)
from note455 and note456 and `PO1 = PO3 \<or> PO1 ~= PO3`
have False
by auto
(* po redu: 3016*)
(*3016*)  (*BRANCH NAME*)
} note note457 = this
(* po redu: 3017*)
(*3017*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 3018*)
(*3018*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 3019*)
(*3019*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 3020*)
(*3020*)  (*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(* po redu: 3021*)
(*3021*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(* po redu: 3022*)
(*3022*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO1`
have  "\<not>col PO1 PO1 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO1"]
by auto

(* po redu: 3023*)
(*3023*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1"
using ax_I4a [of "PO1" "PO1" "PO2"]
by auto

(* po redu: 3024*)
(*3024*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 3025*)
(*3025*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(* po redu: 3026*)
(*3026*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(* po redu: 3027*)
(*3027*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO1`
have  "\<not>col PO1 PO1 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO1"]
by auto

(* po redu: 3028*)
(*3028*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO2` and `\<not>col PO1 PO1 PO2`
have False
by auto

(* po redu: 3029*)
(*3029*)  (*BRANCH NAME*)
} note note458 = this
(* po redu: 3030*)
(*3030*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 3031*)
(*3031*)  (*REGULAR*)
moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(* po redu: 3032*)
(*3032*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO3"
(* po redu: 3033*)
(*3033*)  (*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(* po redu: 3034*)
(*3034*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(* po redu: 3035*)
(*3035*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1"
using ax_I4a [of "PO1" "PO2" "PO2"]
by auto

(* po redu: 3036*)
(*3036*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 3037*)
(*3037*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(* po redu: 3038*)
(*3038*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(* po redu: 3039*)
(*3039*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(* po redu: 3040*)
(*3040*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO2` and `\<not>col PO1 PO2 PO2`
have False
by auto

(* po redu: 3041*)
(*3041*)  (*BRANCH NAME*)
} note note459 = this
(* po redu: 3042*)
(*3042*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO3"
(* po redu: 3043*)
(*3043*)  
(*BRANCH END THESIS*)
moreover 
from `PO1 ~= PO2` and `PO1 ~= PO3` and `PO2 ~= PO3`
have ?thesis
by auto
(* po redu: 3044*)
(*3044*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note460 = this
(* po redu: 3045*)
(*3045*)  
(*BRANCH END*)
from note459 and note460 and `PO2 = PO3 \<or> PO2 ~= PO3`
have ?thesis
by auto
(* po redu: 3046*)
(*3046*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note461 = this
(* po redu: 3047*)
(*3047*)  
(*BRANCH END*)
from note458 and note461 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 3048*)
(*3048*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note462 = this
(* po redu: 3049*)
(*3049*)  
(*BRANCH END*)
from note457 and note462 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
