theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th18:
assumes "PL1 ~= PL2"
and "inc_l_pl LI1 PL1"
and "inc_l_pl LI1 PL2"
and "inc_po_pl PO1 PL1"
and "inc_po_pl PO1 PL2"
shows " (inc_po_l PO1 LI1)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 2*)
(*2*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3*)
(*3*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(* po redu: 4*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
(* po redu: 5*)
(*5*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 6*)
(*6*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 7*)
(*7*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 8*)
(*8*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 9*)
(*9*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 10*)
(*10*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 11*)
(*11*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 12*)
(*12*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 13*)
(*13*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 14*)
(*14*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 15*)
(*15*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1 = this
(* po redu: 16*)
(*16*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 17*)
(*17*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 18*)
(*18*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 19*)
(*19*)  (*BRANCH NAME*)
} note note2 = this
(* po redu: 20*)
(*20*)  
(*BRANCH END*)
from note1 and note2 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 21*)
(*21*)  (*BRANCH NAME*)
} note note3 = this
(* po redu: 22*)
(*22*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 23*)
(*23*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 24*)
(*24*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 25*)
(*25*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note4 = this
(* po redu: 26*)
(*26*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 27*)
(*27*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 28*)
(*28*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 29*)
(*29*)  (*BRANCH NAME*)
} note note5 = this
(* po redu: 30*)
(*30*)  
(*BRANCH END*)
from note4 and note5 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 31*)
(*31*)  (*BRANCH NAME*)
} note note6 = this
(* po redu: 32*)
(*32*)  
(*BRANCH END*)
from note3 and note6 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 33*)
(*33*)  (*BRANCH NAME*)
} note note7 = this
(* po redu: 34*)
(*34*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 35*)
(*35*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 36*)
(*36*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 37*)
(*37*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 38*)
(*38*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 39*)
(*39*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note8 = this
(* po redu: 40*)
(*40*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 41*)
(*41*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 42*)
(*42*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 43*)
(*43*)  (*BRANCH NAME*)
} note note9 = this
(* po redu: 44*)
(*44*)  
(*BRANCH END*)
from note8 and note9 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 45*)
(*45*)  (*BRANCH NAME*)
} note note10 = this
(* po redu: 46*)
(*46*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 47*)
(*47*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 48*)
(*48*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 49*)
(*49*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note11 = this
(* po redu: 50*)
(*50*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 51*)
(*51*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 52*)
(*52*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 53*)
(*53*)  (*BRANCH NAME*)
} note note12 = this
(* po redu: 54*)
(*54*)  
(*BRANCH END*)
from note11 and note12 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 55*)
(*55*)  (*BRANCH NAME*)
} note note13 = this
(* po redu: 56*)
(*56*)  
(*BRANCH END*)
from note10 and note13 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 57*)
(*57*)  (*BRANCH NAME*)
} note note14 = this
(* po redu: 58*)
(*58*)  
(*BRANCH END*)
from note7 and note14 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 59*)
(*59*)  (*BRANCH NAME*)
} note note15 = this
(* po redu: 60*)
(*60*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 61*)
(*61*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 62*)
(*62*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 63*)
(*63*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 64*)
(*64*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 65*)
(*65*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 66*)
(*66*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 67*)
(*67*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note16 = this
(* po redu: 68*)
(*68*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 69*)
(*69*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 70*)
(*70*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 71*)
(*71*)  (*BRANCH NAME*)
} note note17 = this
(* po redu: 72*)
(*72*)  
(*BRANCH END*)
from note16 and note17 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 73*)
(*73*)  (*BRANCH NAME*)
} note note18 = this
(* po redu: 74*)
(*74*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 75*)
(*75*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 76*)
(*76*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 77*)
(*77*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note19 = this
(* po redu: 78*)
(*78*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 79*)
(*79*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 80*)
(*80*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 81*)
(*81*)  (*BRANCH NAME*)
} note note20 = this
(* po redu: 82*)
(*82*)  
(*BRANCH END*)
from note19 and note20 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 83*)
(*83*)  (*BRANCH NAME*)
} note note21 = this
(* po redu: 84*)
(*84*)  
(*BRANCH END*)
from note18 and note21 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 85*)
(*85*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 86*)
(*86*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 87*)
(*87*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 88*)
(*88*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 89*)
(*89*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 90*)
(*90*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 91*)
(*91*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note23 = this
(* po redu: 92*)
(*92*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 93*)
(*93*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 94*)
(*94*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 95*)
(*95*)  (*BRANCH NAME*)
} note note24 = this
(* po redu: 96*)
(*96*)  
(*BRANCH END*)
from note23 and note24 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 97*)
(*97*)  (*BRANCH NAME*)
} note note25 = this
(* po redu: 98*)
(*98*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 99*)
(*99*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 100*)
(*100*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 101*)
(*101*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note26 = this
(* po redu: 102*)
(*102*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 103*)
(*103*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 104*)
(*104*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 105*)
(*105*)  (*BRANCH NAME*)
} note note27 = this
(* po redu: 106*)
(*106*)  
(*BRANCH END*)
from note26 and note27 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 107*)
(*107*)  (*BRANCH NAME*)
} note note28 = this
(* po redu: 108*)
(*108*)  
(*BRANCH END*)
from note25 and note28 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 109*)
(*109*)  (*BRANCH NAME*)
} note note29 = this
(* po redu: 110*)
(*110*)  
(*BRANCH END*)
from note22 and note29 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 111*)
(*111*)  (*BRANCH NAME*)
} note note30 = this
(* po redu: 112*)
(*112*)  
(*BRANCH END*)
from note15 and note30 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 113*)
(*113*)  (*BRANCH NAME*)
} note note31 = this
(* po redu: 114*)
(*114*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 115*)
(*115*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 116*)
(*116*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 117*)
(*117*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 118*)
(*118*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 119*)
(*119*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 120*)
(*120*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 121*)
(*121*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 122*)
(*122*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 123*)
(*123*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note32 = this
(* po redu: 124*)
(*124*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 125*)
(*125*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 126*)
(*126*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 127*)
(*127*)  (*BRANCH NAME*)
} note note33 = this
(* po redu: 128*)
(*128*)  
(*BRANCH END*)
from note32 and note33 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 129*)
(*129*)  (*BRANCH NAME*)
} note note34 = this
(* po redu: 130*)
(*130*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 131*)
(*131*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 132*)
(*132*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 133*)
(*133*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note35 = this
(* po redu: 134*)
(*134*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 135*)
(*135*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 136*)
(*136*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 137*)
(*137*)  (*BRANCH NAME*)
} note note36 = this
(* po redu: 138*)
(*138*)  
(*BRANCH END*)
from note35 and note36 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 139*)
(*139*)  (*BRANCH NAME*)
} note note37 = this
(* po redu: 140*)
(*140*)  
(*BRANCH END*)
from note34 and note37 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 141*)
(*141*)  (*BRANCH NAME*)
} note note38 = this
(* po redu: 142*)
(*142*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 143*)
(*143*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 144*)
(*144*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 145*)
(*145*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 146*)
(*146*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 147*)
(*147*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note39 = this
(* po redu: 148*)
(*148*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 149*)
(*149*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 150*)
(*150*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 151*)
(*151*)  (*BRANCH NAME*)
} note note40 = this
(* po redu: 152*)
(*152*)  
(*BRANCH END*)
from note39 and note40 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 153*)
(*153*)  (*BRANCH NAME*)
} note note41 = this
(* po redu: 154*)
(*154*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 155*)
(*155*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 156*)
(*156*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 157*)
(*157*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note42 = this
(* po redu: 158*)
(*158*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 159*)
(*159*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 160*)
(*160*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 161*)
(*161*)  (*BRANCH NAME*)
} note note43 = this
(* po redu: 162*)
(*162*)  
(*BRANCH END*)
from note42 and note43 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 163*)
(*163*)  (*BRANCH NAME*)
} note note44 = this
(* po redu: 164*)
(*164*)  
(*BRANCH END*)
from note41 and note44 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 165*)
(*165*)  (*BRANCH NAME*)
} note note45 = this
(* po redu: 166*)
(*166*)  
(*BRANCH END*)
from note38 and note45 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 167*)
(*167*)  (*BRANCH NAME*)
} note note46 = this
(* po redu: 168*)
(*168*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 169*)
(*169*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 170*)
(*170*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 171*)
(*171*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 172*)
(*172*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 173*)
(*173*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 174*)
(*174*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 175*)
(*175*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note47 = this
(* po redu: 176*)
(*176*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 177*)
(*177*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 178*)
(*178*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 179*)
(*179*)  (*BRANCH NAME*)
} note note48 = this
(* po redu: 180*)
(*180*)  
(*BRANCH END*)
from note47 and note48 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 181*)
(*181*)  (*BRANCH NAME*)
} note note49 = this
(* po redu: 182*)
(*182*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 183*)
(*183*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 184*)
(*184*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 185*)
(*185*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note50 = this
(* po redu: 186*)
(*186*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 187*)
(*187*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 188*)
(*188*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 189*)
(*189*)  (*BRANCH NAME*)
} note note51 = this
(* po redu: 190*)
(*190*)  
(*BRANCH END*)
from note50 and note51 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 191*)
(*191*)  (*BRANCH NAME*)
} note note52 = this
(* po redu: 192*)
(*192*)  
(*BRANCH END*)
from note49 and note52 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 193*)
(*193*)  (*BRANCH NAME*)
} note note53 = this
(* po redu: 194*)
(*194*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 195*)
(*195*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 196*)
(*196*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 197*)
(*197*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 198*)
(*198*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 199*)
(*199*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note54 = this
(* po redu: 200*)
(*200*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 201*)
(*201*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 202*)
(*202*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 203*)
(*203*)  (*BRANCH NAME*)
} note note55 = this
(* po redu: 204*)
(*204*)  
(*BRANCH END*)
from note54 and note55 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 205*)
(*205*)  (*BRANCH NAME*)
} note note56 = this
(* po redu: 206*)
(*206*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 207*)
(*207*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 208*)
(*208*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 209*)
(*209*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note57 = this
(* po redu: 210*)
(*210*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 211*)
(*211*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 212*)
(*212*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 213*)
(*213*)  (*BRANCH NAME*)
} note note58 = this
(* po redu: 214*)
(*214*)  
(*BRANCH END*)
from note57 and note58 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 215*)
(*215*)  (*BRANCH NAME*)
} note note59 = this
(* po redu: 216*)
(*216*)  
(*BRANCH END*)
from note56 and note59 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 217*)
(*217*)  (*BRANCH NAME*)
} note note60 = this
(* po redu: 218*)
(*218*)  
(*BRANCH END*)
from note53 and note60 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 219*)
(*219*)  (*BRANCH NAME*)
} note note61 = this
(* po redu: 220*)
(*220*)  
(*BRANCH END*)
from note46 and note61 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 221*)
(*221*)  (*BRANCH NAME*)
} note note62 = this
(* po redu: 222*)
(*222*)  
(*BRANCH END*)
from note31 and note62 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 223*)
(*223*)  (*BRANCH NAME*)
} note note63 = this
(* po redu: 224*)
(*224*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
(* po redu: 225*)
(*225*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 226*)
(*226*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 227*)
(*227*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 228*)
(*228*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 229*)
(*229*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 230*)
(*230*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 231*)
(*231*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 232*)
(*232*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 233*)
(*233*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 234*)
(*234*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 235*)
(*235*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note64 = this
(* po redu: 236*)
(*236*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 237*)
(*237*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 238*)
(*238*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 239*)
(*239*)  (*BRANCH NAME*)
} note note65 = this
(* po redu: 240*)
(*240*)  
(*BRANCH END*)
from note64 and note65 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 241*)
(*241*)  (*BRANCH NAME*)
} note note66 = this
(* po redu: 242*)
(*242*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 243*)
(*243*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 244*)
(*244*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 245*)
(*245*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note67 = this
(* po redu: 246*)
(*246*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 247*)
(*247*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 248*)
(*248*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 249*)
(*249*)  (*BRANCH NAME*)
} note note68 = this
(* po redu: 250*)
(*250*)  
(*BRANCH END*)
from note67 and note68 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 251*)
(*251*)  (*BRANCH NAME*)
} note note69 = this
(* po redu: 252*)
(*252*)  
(*BRANCH END*)
from note66 and note69 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 253*)
(*253*)  (*BRANCH NAME*)
} note note70 = this
(* po redu: 254*)
(*254*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 255*)
(*255*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 256*)
(*256*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 257*)
(*257*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 258*)
(*258*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 259*)
(*259*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note71 = this
(* po redu: 260*)
(*260*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 261*)
(*261*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 262*)
(*262*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 263*)
(*263*)  (*BRANCH NAME*)
} note note72 = this
(* po redu: 264*)
(*264*)  
(*BRANCH END*)
from note71 and note72 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 265*)
(*265*)  (*BRANCH NAME*)
} note note73 = this
(* po redu: 266*)
(*266*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 267*)
(*267*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 268*)
(*268*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 269*)
(*269*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note74 = this
(* po redu: 270*)
(*270*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 271*)
(*271*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 272*)
(*272*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 273*)
(*273*)  (*BRANCH NAME*)
} note note75 = this
(* po redu: 274*)
(*274*)  
(*BRANCH END*)
from note74 and note75 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 275*)
(*275*)  (*BRANCH NAME*)
} note note76 = this
(* po redu: 276*)
(*276*)  
(*BRANCH END*)
from note73 and note76 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 277*)
(*277*)  (*BRANCH NAME*)
} note note77 = this
(* po redu: 278*)
(*278*)  
(*BRANCH END*)
from note70 and note77 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 279*)
(*279*)  (*BRANCH NAME*)
} note note78 = this
(* po redu: 280*)
(*280*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 281*)
(*281*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 282*)
(*282*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 283*)
(*283*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 284*)
(*284*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 285*)
(*285*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 286*)
(*286*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 287*)
(*287*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note79 = this
(* po redu: 288*)
(*288*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 289*)
(*289*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 290*)
(*290*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 291*)
(*291*)  (*BRANCH NAME*)
} note note80 = this
(* po redu: 292*)
(*292*)  
(*BRANCH END*)
from note79 and note80 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 293*)
(*293*)  (*BRANCH NAME*)
} note note81 = this
(* po redu: 294*)
(*294*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 295*)
(*295*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 296*)
(*296*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 297*)
(*297*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note82 = this
(* po redu: 298*)
(*298*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 299*)
(*299*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 300*)
(*300*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 301*)
(*301*)  (*BRANCH NAME*)
} note note83 = this
(* po redu: 302*)
(*302*)  
(*BRANCH END*)
from note82 and note83 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 303*)
(*303*)  (*BRANCH NAME*)
} note note84 = this
(* po redu: 304*)
(*304*)  
(*BRANCH END*)
from note81 and note84 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 305*)
(*305*)  (*BRANCH NAME*)
} note note85 = this
(* po redu: 306*)
(*306*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 307*)
(*307*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 308*)
(*308*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 309*)
(*309*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 310*)
(*310*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 311*)
(*311*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note86 = this
(* po redu: 312*)
(*312*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 313*)
(*313*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 314*)
(*314*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 315*)
(*315*)  (*BRANCH NAME*)
} note note87 = this
(* po redu: 316*)
(*316*)  
(*BRANCH END*)
from note86 and note87 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 317*)
(*317*)  (*BRANCH NAME*)
} note note88 = this
(* po redu: 318*)
(*318*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 319*)
(*319*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 320*)
(*320*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 321*)
(*321*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note89 = this
(* po redu: 322*)
(*322*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 323*)
(*323*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 324*)
(*324*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 325*)
(*325*)  (*BRANCH NAME*)
} note note90 = this
(* po redu: 326*)
(*326*)  
(*BRANCH END*)
from note89 and note90 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 327*)
(*327*)  (*BRANCH NAME*)
} note note91 = this
(* po redu: 328*)
(*328*)  
(*BRANCH END*)
from note88 and note91 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 329*)
(*329*)  (*BRANCH NAME*)
} note note92 = this
(* po redu: 330*)
(*330*)  
(*BRANCH END*)
from note85 and note92 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 331*)
(*331*)  (*BRANCH NAME*)
} note note93 = this
(* po redu: 332*)
(*332*)  
(*BRANCH END*)
from note78 and note93 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 333*)
(*333*)  (*BRANCH NAME*)
} note note94 = this
(* po redu: 334*)
(*334*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 335*)
(*335*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 336*)
(*336*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 337*)
(*337*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 338*)
(*338*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 339*)
(*339*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 340*)
(*340*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 341*)
(*341*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 342*)
(*342*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 343*)
(*343*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note95 = this
(* po redu: 344*)
(*344*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 345*)
(*345*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 346*)
(*346*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 347*)
(*347*)  (*BRANCH NAME*)
} note note96 = this
(* po redu: 348*)
(*348*)  
(*BRANCH END*)
from note95 and note96 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 349*)
(*349*)  (*BRANCH NAME*)
} note note97 = this
(* po redu: 350*)
(*350*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 351*)
(*351*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 352*)
(*352*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 353*)
(*353*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note98 = this
(* po redu: 354*)
(*354*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 355*)
(*355*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 356*)
(*356*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 357*)
(*357*)  (*BRANCH NAME*)
} note note99 = this
(* po redu: 358*)
(*358*)  
(*BRANCH END*)
from note98 and note99 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 359*)
(*359*)  (*BRANCH NAME*)
} note note100 = this
(* po redu: 360*)
(*360*)  
(*BRANCH END*)
from note97 and note100 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 361*)
(*361*)  (*BRANCH NAME*)
} note note101 = this
(* po redu: 362*)
(*362*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 363*)
(*363*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 364*)
(*364*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 365*)
(*365*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 366*)
(*366*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 367*)
(*367*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note102 = this
(* po redu: 368*)
(*368*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 369*)
(*369*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 370*)
(*370*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 371*)
(*371*)  (*BRANCH NAME*)
} note note103 = this
(* po redu: 372*)
(*372*)  
(*BRANCH END*)
from note102 and note103 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 373*)
(*373*)  (*BRANCH NAME*)
} note note104 = this
(* po redu: 374*)
(*374*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 375*)
(*375*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 376*)
(*376*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 377*)
(*377*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note105 = this
(* po redu: 378*)
(*378*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 379*)
(*379*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 380*)
(*380*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 381*)
(*381*)  (*BRANCH NAME*)
} note note106 = this
(* po redu: 382*)
(*382*)  
(*BRANCH END*)
from note105 and note106 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 383*)
(*383*)  (*BRANCH NAME*)
} note note107 = this
(* po redu: 384*)
(*384*)  
(*BRANCH END*)
from note104 and note107 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 385*)
(*385*)  (*BRANCH NAME*)
} note note108 = this
(* po redu: 386*)
(*386*)  
(*BRANCH END*)
from note101 and note108 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 387*)
(*387*)  (*BRANCH NAME*)
} note note109 = this
(* po redu: 388*)
(*388*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 389*)
(*389*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 390*)
(*390*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 391*)
(*391*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 392*)
(*392*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 393*)
(*393*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 394*)
(*394*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 395*)
(*395*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note110 = this
(* po redu: 396*)
(*396*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 397*)
(*397*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 398*)
(*398*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 399*)
(*399*)  (*BRANCH NAME*)
} note note111 = this
(* po redu: 400*)
(*400*)  
(*BRANCH END*)
from note110 and note111 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 401*)
(*401*)  (*BRANCH NAME*)
} note note112 = this
(* po redu: 402*)
(*402*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 403*)
(*403*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 404*)
(*404*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 405*)
(*405*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note113 = this
(* po redu: 406*)
(*406*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 407*)
(*407*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 408*)
(*408*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 409*)
(*409*)  (*BRANCH NAME*)
} note note114 = this
(* po redu: 410*)
(*410*)  
(*BRANCH END*)
from note113 and note114 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 411*)
(*411*)  (*BRANCH NAME*)
} note note115 = this
(* po redu: 412*)
(*412*)  
(*BRANCH END*)
from note112 and note115 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 413*)
(*413*)  (*BRANCH NAME*)
} note note116 = this
(* po redu: 414*)
(*414*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 415*)
(*415*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 416*)
(*416*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 417*)
(*417*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 418*)
(*418*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 419*)
(*419*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note117 = this
(* po redu: 420*)
(*420*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 421*)
(*421*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

(* po redu: 422*)
(*422*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

(* po redu: 423*)
(*423*)  (*BRANCH NAME*)
} note note118 = this
(* po redu: 424*)
(*424*)  
(*BRANCH END*)
from note117 and note118 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 425*)
(*425*)  (*BRANCH NAME*)
} note note119 = this
(* po redu: 426*)
(*426*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 427*)
(*427*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 428*)
(*428*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 429*)
(*429*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note120 = this
(* po redu: 430*)
(*430*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 431*)
(*431*)  (*REGULAR*)
moreover

obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 432*)
(*432*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
obtain  PO4::point
where "PO1 ~= PO4" and "inc_po_pl PO4 PL1" and "inc_po_pl PO4 PL2"
using ax_I7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 433*)
(*433*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(* po redu: 434*)
(*434*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL1"
using ax_D11 [of "LI1" "PL1" "PO2"]
by auto

(* po redu: 435*)
(*435*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 436*)
(*436*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 437*)
(*437*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 438*)
(*438*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 439*)
(*439*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL2"
using ax_D11 [of "LI1" "PL2" "PO2"]
by auto

(* po redu: 440*)
(*440*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 441*)
(*441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 442*)
(*442*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `PO1 = PO2`
have False
by auto

(* po redu: 443*)
(*443*)  (*BRANCH NAME*)
} note note121 = this
(* po redu: 444*)
(*444*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 445*)
(*445*)  (*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO2 LI2"
using ax_I1 [of "PO1" "PO2"]
by auto

(* po redu: 446*)
(*446*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(* po redu: 447*)
(*447*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

(* po redu: 448*)
(*448*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

(* po redu: 449*)
(*449*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO1 LI1`
have  "\<not>col PO2 PO3 PO1"
using ax_D1a [of "PO2" "PO3" "LI1" "PO1"]
by auto

(* po redu: 450*)
(*450*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 451*)
(*451*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 452*)
(*452*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(* po redu: 453*)
(*453*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 454*)
(*454*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 455*)
(*455*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 456*)
(*456*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 457*)
(*457*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 458*)
(*458*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 459*)
(*459*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 460*)
(*460*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 461*)
(*461*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL2"
using ax_D11 [of "LI1" "PL2" "PO3"]
by auto

(* po redu: 462*)
(*462*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO1`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_231 [of "PO2" "PO3" "PO1"]
by auto

(* po redu: 463*)
(*463*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO3 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO3" "PL1" "PL2"]
by auto

(* po redu: 464*)
(*464*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 465*)
(*465*)  (*BRANCH NAME*)
} note note122 = this
(* po redu: 466*)
(*466*)  
(*BRANCH END*)
from note121 and note122 and `PO1 = PO2 \<or> PO1 ~= PO2`
have False
by auto
(* po redu: 467*)
(*467*)  (*BRANCH NAME*)
} note note123 = this
(* po redu: 468*)
(*468*)  
(*BRANCH END*)
from note120 and note123 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 469*)
(*469*)  (*BRANCH NAME*)
} note note124 = this
(* po redu: 470*)
(*470*)  
(*BRANCH END*)
from note119 and note124 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 471*)
(*471*)  (*BRANCH NAME*)
} note note125 = this
(* po redu: 472*)
(*472*)  
(*BRANCH END*)
from note116 and note125 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 473*)
(*473*)  (*BRANCH NAME*)
} note note126 = this
(* po redu: 474*)
(*474*)  
(*BRANCH END*)
from note109 and note126 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 475*)
(*475*)  (*BRANCH NAME*)
} note note127 = this
(* po redu: 476*)
(*476*)  
(*BRANCH END*)
from note94 and note127 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 477*)
(*477*)  (*BRANCH NAME*)
} note note128 = this
(* po redu: 478*)
(*478*)  
(*BRANCH END*)
from note63 and note128 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
