theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th19:
assumes "\<not>inc_l_pl LI1 PL1"
shows " ( \<exists>  (PO1::point). inc_po_l PO1 LI1 & inc_po_pl PO1 PL1) \<or>  (\<not>int_l_pl LI1 PL1)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(* po redu: 2*)
(*2*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
(* po redu: 3*)
(*3*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 4*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 5*)
(*5*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 6*)
(*6*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 7*)
(*7*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 8*)
(*8*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 9*)
(*9*)  (*BRANCH NAME*)
} note note1 = this
(* po redu: 10*)
(*10*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 11*)
(*11*)  
(*BRANCH END THESIS*)
moreover 
from `\<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 12*)
(*12*)  
(*BRANCH END*)
from `\<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 13*)
(*13*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note2 = this
(* po redu: 14*)
(*14*)  
(*BRANCH END*)
from note1 and note2 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 15*)
(*15*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note3 = this
(* po redu: 16*)
(*16*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 17*)
(*17*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 18*)
(*18*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 19*)
(*19*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 20*)
(*20*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 21*)
(*21*)  (*BRANCH NAME*)
} note note4 = this
(* po redu: 22*)
(*22*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 23*)
(*23*)  
(*BRANCH END THESIS*)
moreover 
from `\<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 24*)
(*24*)  
(*BRANCH END*)
from `\<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 25*)
(*25*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note5 = this
(* po redu: 26*)
(*26*)  
(*BRANCH END*)
from note4 and note5 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 27*)
(*27*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note6 = this
(* po redu: 28*)
(*28*)  
(*BRANCH END*)
from note3 and note6 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 29*)
(*29*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note7 = this
(* po redu: 30*)
(*30*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
(* po redu: 31*)
(*31*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 32*)
(*32*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 33*)
(*33*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 34*)
(*34*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 35*)
(*35*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO1::point
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 36*)
(*36*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 37*)
(*37*)  (*BRANCH NAME*)
} note note8 = this
(* po redu: 38*)
(*38*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 39*)
(*39*)  
(*BRANCH END THESIS*)
moreover 
from `\<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 40*)
(*40*)  
(*BRANCH END*)
from `\<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 41*)
(*41*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note9 = this
(* po redu: 42*)
(*42*)  
(*BRANCH END*)
from note8 and note9 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 43*)
(*43*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note10 = this
(* po redu: 44*)
(*44*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 45*)
(*45*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 46*)
(*46*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 47*)
(*47*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_pl PO1 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 48*)
(*48*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_pl PO1 PL1`
have ?thesis
by auto
(* po redu: 49*)
(*49*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_pl PO1 PL1)`
have ?thesis
by auto
(* po redu: 50*)
(*50*)  (*BRANCH NAME*)
} note note11 = this
(* po redu: 51*)
(*51*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 52*)
(*52*)  
(*BRANCH END THESIS*)
moreover 
from `\<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 53*)
(*53*)  
(*BRANCH END*)
from `\<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 54*)
(*54*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note12 = this
(* po redu: 55*)
(*55*)  
(*BRANCH END*)
from note11 and note12 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 56*)
(*56*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note13 = this
(* po redu: 57*)
(*57*)  
(*BRANCH END*)
from note10 and note13 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 58*)
(*58*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note14 = this
(* po redu: 59*)
(*59*)  
(*BRANCH END*)
from note7 and note14 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
