theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th22:
assumes "\<not>inc_po_l PO1 LI1"
and "inc_l_pl LI1 PL1"
and "inc_po_pl PO1 PL1"
and "inc_l_pl LI1 PL2"
and "inc_po_pl PO1 PL2"
shows " (PL1 = PL2)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 2*)
(*2*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(* po redu: 3*)
(*3*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
(* po redu: 4*)
(*4*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 5*)
(*5*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 6*)
(*6*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 7*)
(*7*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 8*)
(*8*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 9*)
(*9*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 10*)
(*10*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 11*)
(*11*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 12*)
(*12*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 13*)
(*13*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 14*)
(*14*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 15*)
(*15*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 16*)
(*16*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1 = this
(* po redu: 17*)
(*17*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 18*)
(*18*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 19*)
(*19*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 20*)
(*20*)  (*BRANCH NAME*)
} note note2 = this
(* po redu: 21*)
(*21*)  
(*BRANCH END*)
from note1 and note2 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 22*)
(*22*)  (*BRANCH NAME*)
} note note3 = this
(* po redu: 23*)
(*23*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 24*)
(*24*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 25*)
(*25*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 26*)
(*26*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 27*)
(*27*)  (*BRANCH NAME*)
} note note4 = this
(* po redu: 28*)
(*28*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 29*)
(*29*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 30*)
(*30*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 31*)
(*31*)  (*BRANCH NAME*)
} note note5 = this
(* po redu: 32*)
(*32*)  
(*BRANCH END*)
from note4 and note5 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 33*)
(*33*)  (*BRANCH NAME*)
} note note6 = this
(* po redu: 34*)
(*34*)  
(*BRANCH END*)
from note3 and note6 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 35*)
(*35*)  (*BRANCH NAME*)
} note note7 = this
(* po redu: 36*)
(*36*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 37*)
(*37*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 38*)
(*38*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 39*)
(*39*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 40*)
(*40*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 41*)
(*41*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 42*)
(*42*)  (*BRANCH NAME*)
} note note8 = this
(* po redu: 43*)
(*43*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 44*)
(*44*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 45*)
(*45*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 46*)
(*46*)  (*BRANCH NAME*)
} note note9 = this
(* po redu: 47*)
(*47*)  
(*BRANCH END*)
from note8 and note9 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 48*)
(*48*)  (*BRANCH NAME*)
} note note10 = this
(* po redu: 49*)
(*49*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 50*)
(*50*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 51*)
(*51*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 52*)
(*52*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note11 = this
(* po redu: 53*)
(*53*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 54*)
(*54*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 55*)
(*55*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 56*)
(*56*)  (*BRANCH NAME*)
} note note12 = this
(* po redu: 57*)
(*57*)  
(*BRANCH END*)
from note11 and note12 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 58*)
(*58*)  (*BRANCH NAME*)
} note note13 = this
(* po redu: 59*)
(*59*)  
(*BRANCH END*)
from note10 and note13 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 60*)
(*60*)  (*BRANCH NAME*)
} note note14 = this
(* po redu: 61*)
(*61*)  
(*BRANCH END*)
from note7 and note14 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 62*)
(*62*)  (*BRANCH NAME*)
} note note15 = this
(* po redu: 63*)
(*63*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 64*)
(*64*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 65*)
(*65*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 66*)
(*66*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 67*)
(*67*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 68*)
(*68*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 69*)
(*69*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 70*)
(*70*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 71*)
(*71*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 72*)
(*72*)  (*BRANCH NAME*)
} note note16 = this
(* po redu: 73*)
(*73*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 74*)
(*74*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 75*)
(*75*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 76*)
(*76*)  (*BRANCH NAME*)
} note note17 = this
(* po redu: 77*)
(*77*)  
(*BRANCH END*)
from note16 and note17 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 78*)
(*78*)  (*BRANCH NAME*)
} note note18 = this
(* po redu: 79*)
(*79*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 80*)
(*80*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 81*)
(*81*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 82*)
(*82*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 83*)
(*83*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 84*)
(*84*)  (*BRANCH NAME*)
} note note19 = this
(* po redu: 85*)
(*85*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 86*)
(*86*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 87*)
(*87*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 88*)
(*88*)  (*BRANCH NAME*)
} note note20 = this
(* po redu: 89*)
(*89*)  
(*BRANCH END*)
from note19 and note20 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 90*)
(*90*)  (*BRANCH NAME*)
} note note21 = this
(* po redu: 91*)
(*91*)  
(*BRANCH END*)
from note18 and note21 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 92*)
(*92*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 93*)
(*93*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 94*)
(*94*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 95*)
(*95*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 96*)
(*96*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 97*)
(*97*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 98*)
(*98*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 99*)
(*99*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 100*)
(*100*)  (*BRANCH NAME*)
} note note23 = this
(* po redu: 101*)
(*101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 102*)
(*102*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 103*)
(*103*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 104*)
(*104*)  (*BRANCH NAME*)
} note note24 = this
(* po redu: 105*)
(*105*)  
(*BRANCH END*)
from note23 and note24 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 106*)
(*106*)  (*BRANCH NAME*)
} note note25 = this
(* po redu: 107*)
(*107*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 108*)
(*108*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 109*)
(*109*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 110*)
(*110*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 111*)
(*111*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 112*)
(*112*)  (*BRANCH NAME*)
} note note26 = this
(* po redu: 113*)
(*113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 114*)
(*114*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 115*)
(*115*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 116*)
(*116*)  (*BRANCH NAME*)
} note note27 = this
(* po redu: 117*)
(*117*)  
(*BRANCH END*)
from note26 and note27 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 118*)
(*118*)  (*BRANCH NAME*)
} note note28 = this
(* po redu: 119*)
(*119*)  
(*BRANCH END*)
from note25 and note28 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 120*)
(*120*)  (*BRANCH NAME*)
} note note29 = this
(* po redu: 121*)
(*121*)  
(*BRANCH END*)
from note22 and note29 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 122*)
(*122*)  (*BRANCH NAME*)
} note note30 = this
(* po redu: 123*)
(*123*)  
(*BRANCH END*)
from note15 and note30 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 124*)
(*124*)  (*BRANCH NAME*)
} note note31 = this
(* po redu: 125*)
(*125*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 126*)
(*126*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 127*)
(*127*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 128*)
(*128*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 129*)
(*129*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 130*)
(*130*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 131*)
(*131*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 132*)
(*132*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 133*)
(*133*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 134*)
(*134*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 135*)
(*135*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 136*)
(*136*)  (*BRANCH NAME*)
} note note32 = this
(* po redu: 137*)
(*137*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 138*)
(*138*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 139*)
(*139*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 140*)
(*140*)  (*BRANCH NAME*)
} note note33 = this
(* po redu: 141*)
(*141*)  
(*BRANCH END*)
from note32 and note33 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 142*)
(*142*)  (*BRANCH NAME*)
} note note34 = this
(* po redu: 143*)
(*143*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 144*)
(*144*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 145*)
(*145*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 146*)
(*146*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 147*)
(*147*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 148*)
(*148*)  (*BRANCH NAME*)
} note note35 = this
(* po redu: 149*)
(*149*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 150*)
(*150*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 151*)
(*151*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 152*)
(*152*)  (*BRANCH NAME*)
} note note36 = this
(* po redu: 153*)
(*153*)  
(*BRANCH END*)
from note35 and note36 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 154*)
(*154*)  (*BRANCH NAME*)
} note note37 = this
(* po redu: 155*)
(*155*)  
(*BRANCH END*)
from note34 and note37 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 156*)
(*156*)  (*BRANCH NAME*)
} note note38 = this
(* po redu: 157*)
(*157*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 158*)
(*158*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 159*)
(*159*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 160*)
(*160*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 161*)
(*161*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 162*)
(*162*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 163*)
(*163*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 164*)
(*164*)  (*BRANCH NAME*)
} note note39 = this
(* po redu: 165*)
(*165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 166*)
(*166*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 167*)
(*167*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 168*)
(*168*)  (*BRANCH NAME*)
} note note40 = this
(* po redu: 169*)
(*169*)  
(*BRANCH END*)
from note39 and note40 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 170*)
(*170*)  (*BRANCH NAME*)
} note note41 = this
(* po redu: 171*)
(*171*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 172*)
(*172*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 173*)
(*173*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 174*)
(*174*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 175*)
(*175*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 176*)
(*176*)  (*BRANCH NAME*)
} note note42 = this
(* po redu: 177*)
(*177*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 178*)
(*178*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 179*)
(*179*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 180*)
(*180*)  (*BRANCH NAME*)
} note note43 = this
(* po redu: 181*)
(*181*)  
(*BRANCH END*)
from note42 and note43 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 182*)
(*182*)  (*BRANCH NAME*)
} note note44 = this
(* po redu: 183*)
(*183*)  
(*BRANCH END*)
from note41 and note44 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 184*)
(*184*)  (*BRANCH NAME*)
} note note45 = this
(* po redu: 185*)
(*185*)  
(*BRANCH END*)
from note38 and note45 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 186*)
(*186*)  (*BRANCH NAME*)
} note note46 = this
(* po redu: 187*)
(*187*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 188*)
(*188*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 189*)
(*189*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 190*)
(*190*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 191*)
(*191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 192*)
(*192*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 193*)
(*193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 194*)
(*194*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 195*)
(*195*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 196*)
(*196*)  (*BRANCH NAME*)
} note note47 = this
(* po redu: 197*)
(*197*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 198*)
(*198*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 199*)
(*199*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 200*)
(*200*)  (*BRANCH NAME*)
} note note48 = this
(* po redu: 201*)
(*201*)  
(*BRANCH END*)
from note47 and note48 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 202*)
(*202*)  (*BRANCH NAME*)
} note note49 = this
(* po redu: 203*)
(*203*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 204*)
(*204*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 205*)
(*205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 206*)
(*206*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 207*)
(*207*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 208*)
(*208*)  (*BRANCH NAME*)
} note note50 = this
(* po redu: 209*)
(*209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 210*)
(*210*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 211*)
(*211*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 212*)
(*212*)  (*BRANCH NAME*)
} note note51 = this
(* po redu: 213*)
(*213*)  
(*BRANCH END*)
from note50 and note51 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 214*)
(*214*)  (*BRANCH NAME*)
} note note52 = this
(* po redu: 215*)
(*215*)  
(*BRANCH END*)
from note49 and note52 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 216*)
(*216*)  (*BRANCH NAME*)
} note note53 = this
(* po redu: 217*)
(*217*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 218*)
(*218*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 219*)
(*219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 220*)
(*220*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 221*)
(*221*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 222*)
(*222*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 223*)
(*223*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 224*)
(*224*)  (*BRANCH NAME*)
} note note54 = this
(* po redu: 225*)
(*225*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 226*)
(*226*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 227*)
(*227*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 228*)
(*228*)  (*BRANCH NAME*)
} note note55 = this
(* po redu: 229*)
(*229*)  
(*BRANCH END*)
from note54 and note55 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 230*)
(*230*)  (*BRANCH NAME*)
} note note56 = this
(* po redu: 231*)
(*231*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 232*)
(*232*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 233*)
(*233*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 234*)
(*234*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 235*)
(*235*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 236*)
(*236*)  (*BRANCH NAME*)
} note note57 = this
(* po redu: 237*)
(*237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 238*)
(*238*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 239*)
(*239*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 240*)
(*240*)  (*BRANCH NAME*)
} note note58 = this
(* po redu: 241*)
(*241*)  
(*BRANCH END*)
from note57 and note58 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 242*)
(*242*)  (*BRANCH NAME*)
} note note59 = this
(* po redu: 243*)
(*243*)  
(*BRANCH END*)
from note56 and note59 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 244*)
(*244*)  (*BRANCH NAME*)
} note note60 = this
(* po redu: 245*)
(*245*)  
(*BRANCH END*)
from note53 and note60 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 246*)
(*246*)  (*BRANCH NAME*)
} note note61 = this
(* po redu: 247*)
(*247*)  
(*BRANCH END*)
from note46 and note61 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 248*)
(*248*)  (*BRANCH NAME*)
} note note62 = this
(* po redu: 249*)
(*249*)  
(*BRANCH END*)
from note31 and note62 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 250*)
(*250*)  (*BRANCH NAME*)
} note note63 = this
(* po redu: 251*)
(*251*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 252*)
(*252*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 253*)
(*253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 254*)
(*254*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 255*)
(*255*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 256*)
(*256*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 257*)
(*257*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 258*)
(*258*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 259*)
(*259*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 260*)
(*260*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 261*)
(*261*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 262*)
(*262*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 263*)
(*263*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 264*)
(*264*)  (*BRANCH NAME*)
} note note64 = this
(* po redu: 265*)
(*265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 266*)
(*266*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 267*)
(*267*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 268*)
(*268*)  (*BRANCH NAME*)
} note note65 = this
(* po redu: 269*)
(*269*)  
(*BRANCH END*)
from note64 and note65 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 270*)
(*270*)  (*BRANCH NAME*)
} note note66 = this
(* po redu: 271*)
(*271*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 272*)
(*272*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 273*)
(*273*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 274*)
(*274*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 275*)
(*275*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 276*)
(*276*)  (*BRANCH NAME*)
} note note67 = this
(* po redu: 277*)
(*277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 278*)
(*278*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 279*)
(*279*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 280*)
(*280*)  (*BRANCH NAME*)
} note note68 = this
(* po redu: 281*)
(*281*)  
(*BRANCH END*)
from note67 and note68 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 282*)
(*282*)  (*BRANCH NAME*)
} note note69 = this
(* po redu: 283*)
(*283*)  
(*BRANCH END*)
from note66 and note69 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 284*)
(*284*)  (*BRANCH NAME*)
} note note70 = this
(* po redu: 285*)
(*285*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 286*)
(*286*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 287*)
(*287*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 288*)
(*288*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 289*)
(*289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 290*)
(*290*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 291*)
(*291*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 292*)
(*292*)  (*BRANCH NAME*)
} note note71 = this
(* po redu: 293*)
(*293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 294*)
(*294*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 295*)
(*295*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 296*)
(*296*)  (*BRANCH NAME*)
} note note72 = this
(* po redu: 297*)
(*297*)  
(*BRANCH END*)
from note71 and note72 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 298*)
(*298*)  (*BRANCH NAME*)
} note note73 = this
(* po redu: 299*)
(*299*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 300*)
(*300*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 301*)
(*301*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 302*)
(*302*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 303*)
(*303*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 304*)
(*304*)  (*BRANCH NAME*)
} note note74 = this
(* po redu: 305*)
(*305*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 306*)
(*306*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 307*)
(*307*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 308*)
(*308*)  (*BRANCH NAME*)
} note note75 = this
(* po redu: 309*)
(*309*)  
(*BRANCH END*)
from note74 and note75 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 310*)
(*310*)  (*BRANCH NAME*)
} note note76 = this
(* po redu: 311*)
(*311*)  
(*BRANCH END*)
from note73 and note76 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 312*)
(*312*)  (*BRANCH NAME*)
} note note77 = this
(* po redu: 313*)
(*313*)  
(*BRANCH END*)
from note70 and note77 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 314*)
(*314*)  (*BRANCH NAME*)
} note note78 = this
(* po redu: 315*)
(*315*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 316*)
(*316*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 317*)
(*317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 318*)
(*318*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 319*)
(*319*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 320*)
(*320*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 321*)
(*321*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 322*)
(*322*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 323*)
(*323*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 324*)
(*324*)  (*BRANCH NAME*)
} note note79 = this
(* po redu: 325*)
(*325*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 326*)
(*326*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 327*)
(*327*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 328*)
(*328*)  (*BRANCH NAME*)
} note note80 = this
(* po redu: 329*)
(*329*)  
(*BRANCH END*)
from note79 and note80 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 330*)
(*330*)  (*BRANCH NAME*)
} note note81 = this
(* po redu: 331*)
(*331*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 332*)
(*332*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 333*)
(*333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 334*)
(*334*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 335*)
(*335*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 336*)
(*336*)  (*BRANCH NAME*)
} note note82 = this
(* po redu: 337*)
(*337*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 338*)
(*338*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 339*)
(*339*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 340*)
(*340*)  (*BRANCH NAME*)
} note note83 = this
(* po redu: 341*)
(*341*)  
(*BRANCH END*)
from note82 and note83 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 342*)
(*342*)  (*BRANCH NAME*)
} note note84 = this
(* po redu: 343*)
(*343*)  
(*BRANCH END*)
from note81 and note84 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 344*)
(*344*)  (*BRANCH NAME*)
} note note85 = this
(* po redu: 345*)
(*345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 346*)
(*346*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 347*)
(*347*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 348*)
(*348*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 349*)
(*349*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 350*)
(*350*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 351*)
(*351*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 352*)
(*352*)  (*BRANCH NAME*)
} note note86 = this
(* po redu: 353*)
(*353*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 354*)
(*354*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 355*)
(*355*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 356*)
(*356*)  (*BRANCH NAME*)
} note note87 = this
(* po redu: 357*)
(*357*)  
(*BRANCH END*)
from note86 and note87 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 358*)
(*358*)  (*BRANCH NAME*)
} note note88 = this
(* po redu: 359*)
(*359*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 360*)
(*360*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 361*)
(*361*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 362*)
(*362*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 363*)
(*363*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 364*)
(*364*)  (*BRANCH NAME*)
} note note89 = this
(* po redu: 365*)
(*365*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 366*)
(*366*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 367*)
(*367*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 368*)
(*368*)  (*BRANCH NAME*)
} note note90 = this
(* po redu: 369*)
(*369*)  
(*BRANCH END*)
from note89 and note90 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 370*)
(*370*)  (*BRANCH NAME*)
} note note91 = this
(* po redu: 371*)
(*371*)  
(*BRANCH END*)
from note88 and note91 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 372*)
(*372*)  (*BRANCH NAME*)
} note note92 = this
(* po redu: 373*)
(*373*)  
(*BRANCH END*)
from note85 and note92 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 374*)
(*374*)  (*BRANCH NAME*)
} note note93 = this
(* po redu: 375*)
(*375*)  
(*BRANCH END*)
from note78 and note93 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 376*)
(*376*)  (*BRANCH NAME*)
} note note94 = this
(* po redu: 377*)
(*377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 378*)
(*378*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 379*)
(*379*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 380*)
(*380*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 381*)
(*381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 382*)
(*382*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 383*)
(*383*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 384*)
(*384*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 385*)
(*385*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 386*)
(*386*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 387*)
(*387*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 388*)
(*388*)  (*BRANCH NAME*)
} note note95 = this
(* po redu: 389*)
(*389*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 390*)
(*390*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 391*)
(*391*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 392*)
(*392*)  (*BRANCH NAME*)
} note note96 = this
(* po redu: 393*)
(*393*)  
(*BRANCH END*)
from note95 and note96 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 394*)
(*394*)  (*BRANCH NAME*)
} note note97 = this
(* po redu: 395*)
(*395*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 396*)
(*396*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 397*)
(*397*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 398*)
(*398*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 399*)
(*399*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 400*)
(*400*)  (*BRANCH NAME*)
} note note98 = this
(* po redu: 401*)
(*401*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 402*)
(*402*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 403*)
(*403*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 404*)
(*404*)  (*BRANCH NAME*)
} note note99 = this
(* po redu: 405*)
(*405*)  
(*BRANCH END*)
from note98 and note99 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 406*)
(*406*)  (*BRANCH NAME*)
} note note100 = this
(* po redu: 407*)
(*407*)  
(*BRANCH END*)
from note97 and note100 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 408*)
(*408*)  (*BRANCH NAME*)
} note note101 = this
(* po redu: 409*)
(*409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 410*)
(*410*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 411*)
(*411*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 412*)
(*412*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 413*)
(*413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 414*)
(*414*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 415*)
(*415*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 416*)
(*416*)  (*BRANCH NAME*)
} note note102 = this
(* po redu: 417*)
(*417*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 418*)
(*418*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 419*)
(*419*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 420*)
(*420*)  (*BRANCH NAME*)
} note note103 = this
(* po redu: 421*)
(*421*)  
(*BRANCH END*)
from note102 and note103 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 422*)
(*422*)  (*BRANCH NAME*)
} note note104 = this
(* po redu: 423*)
(*423*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 424*)
(*424*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 425*)
(*425*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 426*)
(*426*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 427*)
(*427*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 428*)
(*428*)  (*BRANCH NAME*)
} note note105 = this
(* po redu: 429*)
(*429*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 430*)
(*430*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 431*)
(*431*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 432*)
(*432*)  (*BRANCH NAME*)
} note note106 = this
(* po redu: 433*)
(*433*)  
(*BRANCH END*)
from note105 and note106 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 434*)
(*434*)  (*BRANCH NAME*)
} note note107 = this
(* po redu: 435*)
(*435*)  
(*BRANCH END*)
from note104 and note107 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 436*)
(*436*)  (*BRANCH NAME*)
} note note108 = this
(* po redu: 437*)
(*437*)  
(*BRANCH END*)
from note101 and note108 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 438*)
(*438*)  (*BRANCH NAME*)
} note note109 = this
(* po redu: 439*)
(*439*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 440*)
(*440*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 441*)
(*441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 442*)
(*442*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 443*)
(*443*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 444*)
(*444*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 445*)
(*445*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 446*)
(*446*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note110 = this
(* po redu: 447*)
(*447*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 448*)
(*448*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 449*)
(*449*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 450*)
(*450*)  (*BRANCH NAME*)
} note note111 = this
(* po redu: 451*)
(*451*)  
(*BRANCH END*)
from note110 and note111 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 452*)
(*452*)  (*BRANCH NAME*)
} note note112 = this
(* po redu: 453*)
(*453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 454*)
(*454*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 455*)
(*455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 456*)
(*456*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 457*)
(*457*)  (*BRANCH NAME*)
} note note113 = this
(* po redu: 458*)
(*458*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 459*)
(*459*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 460*)
(*460*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 461*)
(*461*)  (*BRANCH NAME*)
} note note114 = this
(* po redu: 462*)
(*462*)  
(*BRANCH END*)
from note113 and note114 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 463*)
(*463*)  (*BRANCH NAME*)
} note note115 = this
(* po redu: 464*)
(*464*)  
(*BRANCH END*)
from note112 and note115 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 465*)
(*465*)  (*BRANCH NAME*)
} note note116 = this
(* po redu: 466*)
(*466*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 467*)
(*467*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 468*)
(*468*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 469*)
(*469*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 470*)
(*470*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 471*)
(*471*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 472*)
(*472*)  (*BRANCH NAME*)
} note note117 = this
(* po redu: 473*)
(*473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 474*)
(*474*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 475*)
(*475*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 476*)
(*476*)  (*BRANCH NAME*)
} note note118 = this
(* po redu: 477*)
(*477*)  
(*BRANCH END*)
from note117 and note118 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 478*)
(*478*)  (*BRANCH NAME*)
} note note119 = this
(* po redu: 479*)
(*479*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 480*)
(*480*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 481*)
(*481*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 482*)
(*482*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note120 = this
(* po redu: 483*)
(*483*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 484*)
(*484*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 485*)
(*485*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 486*)
(*486*)  (*BRANCH NAME*)
} note note121 = this
(* po redu: 487*)
(*487*)  
(*BRANCH END*)
from note120 and note121 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 488*)
(*488*)  (*BRANCH NAME*)
} note note122 = this
(* po redu: 489*)
(*489*)  
(*BRANCH END*)
from note119 and note122 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 490*)
(*490*)  (*BRANCH NAME*)
} note note123 = this
(* po redu: 491*)
(*491*)  
(*BRANCH END*)
from note116 and note123 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 492*)
(*492*)  (*BRANCH NAME*)
} note note124 = this
(* po redu: 493*)
(*493*)  
(*BRANCH END*)
from note109 and note124 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 494*)
(*494*)  (*BRANCH NAME*)
} note note125 = this
(* po redu: 495*)
(*495*)  
(*BRANCH END*)
from note94 and note125 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 496*)
(*496*)  (*BRANCH NAME*)
} note note126 = this
(* po redu: 497*)
(*497*)  
(*BRANCH END*)
from note63 and note126 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 498*)
(*498*)  (*BRANCH NAME*)
} note note127 = this
(* po redu: 499*)
(*499*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
(* po redu: 500*)
(*500*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 501*)
(*501*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 502*)
(*502*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 503*)
(*503*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 504*)
(*504*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 505*)
(*505*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 506*)
(*506*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 507*)
(*507*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 508*)
(*508*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 509*)
(*509*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 510*)
(*510*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 511*)
(*511*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 512*)
(*512*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note128 = this
(* po redu: 513*)
(*513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 514*)
(*514*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 515*)
(*515*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 516*)
(*516*)  (*BRANCH NAME*)
} note note129 = this
(* po redu: 517*)
(*517*)  
(*BRANCH END*)
from note128 and note129 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 518*)
(*518*)  (*BRANCH NAME*)
} note note130 = this
(* po redu: 519*)
(*519*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 520*)
(*520*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 521*)
(*521*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 522*)
(*522*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 523*)
(*523*)  (*BRANCH NAME*)
} note note131 = this
(* po redu: 524*)
(*524*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 525*)
(*525*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 526*)
(*526*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 527*)
(*527*)  (*BRANCH NAME*)
} note note132 = this
(* po redu: 528*)
(*528*)  
(*BRANCH END*)
from note131 and note132 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 529*)
(*529*)  (*BRANCH NAME*)
} note note133 = this
(* po redu: 530*)
(*530*)  
(*BRANCH END*)
from note130 and note133 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 531*)
(*531*)  (*BRANCH NAME*)
} note note134 = this
(* po redu: 532*)
(*532*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 533*)
(*533*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 534*)
(*534*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 535*)
(*535*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 536*)
(*536*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 537*)
(*537*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 538*)
(*538*)  (*BRANCH NAME*)
} note note135 = this
(* po redu: 539*)
(*539*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 540*)
(*540*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 541*)
(*541*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 542*)
(*542*)  (*BRANCH NAME*)
} note note136 = this
(* po redu: 543*)
(*543*)  
(*BRANCH END*)
from note135 and note136 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 544*)
(*544*)  (*BRANCH NAME*)
} note note137 = this
(* po redu: 545*)
(*545*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 546*)
(*546*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 547*)
(*547*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 548*)
(*548*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note138 = this
(* po redu: 549*)
(*549*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 550*)
(*550*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 551*)
(*551*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 552*)
(*552*)  (*BRANCH NAME*)
} note note139 = this
(* po redu: 553*)
(*553*)  
(*BRANCH END*)
from note138 and note139 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 554*)
(*554*)  (*BRANCH NAME*)
} note note140 = this
(* po redu: 555*)
(*555*)  
(*BRANCH END*)
from note137 and note140 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 556*)
(*556*)  (*BRANCH NAME*)
} note note141 = this
(* po redu: 557*)
(*557*)  
(*BRANCH END*)
from note134 and note141 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 558*)
(*558*)  (*BRANCH NAME*)
} note note142 = this
(* po redu: 559*)
(*559*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 560*)
(*560*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 561*)
(*561*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 562*)
(*562*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 563*)
(*563*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 564*)
(*564*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 565*)
(*565*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 566*)
(*566*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 567*)
(*567*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 568*)
(*568*)  (*BRANCH NAME*)
} note note143 = this
(* po redu: 569*)
(*569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 570*)
(*570*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 571*)
(*571*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 572*)
(*572*)  (*BRANCH NAME*)
} note note144 = this
(* po redu: 573*)
(*573*)  
(*BRANCH END*)
from note143 and note144 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 574*)
(*574*)  (*BRANCH NAME*)
} note note145 = this
(* po redu: 575*)
(*575*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 576*)
(*576*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 577*)
(*577*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 578*)
(*578*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 579*)
(*579*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 580*)
(*580*)  (*BRANCH NAME*)
} note note146 = this
(* po redu: 581*)
(*581*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 582*)
(*582*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 583*)
(*583*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 584*)
(*584*)  (*BRANCH NAME*)
} note note147 = this
(* po redu: 585*)
(*585*)  
(*BRANCH END*)
from note146 and note147 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 586*)
(*586*)  (*BRANCH NAME*)
} note note148 = this
(* po redu: 587*)
(*587*)  
(*BRANCH END*)
from note145 and note148 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 588*)
(*588*)  (*BRANCH NAME*)
} note note149 = this
(* po redu: 589*)
(*589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 590*)
(*590*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 591*)
(*591*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 592*)
(*592*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 593*)
(*593*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 594*)
(*594*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 595*)
(*595*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 596*)
(*596*)  (*BRANCH NAME*)
} note note150 = this
(* po redu: 597*)
(*597*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 598*)
(*598*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 599*)
(*599*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 600*)
(*600*)  (*BRANCH NAME*)
} note note151 = this
(* po redu: 601*)
(*601*)  
(*BRANCH END*)
from note150 and note151 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 602*)
(*602*)  (*BRANCH NAME*)
} note note152 = this
(* po redu: 603*)
(*603*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 604*)
(*604*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 605*)
(*605*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 606*)
(*606*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 607*)
(*607*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 608*)
(*608*)  (*BRANCH NAME*)
} note note153 = this
(* po redu: 609*)
(*609*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 610*)
(*610*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 611*)
(*611*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 612*)
(*612*)  (*BRANCH NAME*)
} note note154 = this
(* po redu: 613*)
(*613*)  
(*BRANCH END*)
from note153 and note154 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 614*)
(*614*)  (*BRANCH NAME*)
} note note155 = this
(* po redu: 615*)
(*615*)  
(*BRANCH END*)
from note152 and note155 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 616*)
(*616*)  (*BRANCH NAME*)
} note note156 = this
(* po redu: 617*)
(*617*)  
(*BRANCH END*)
from note149 and note156 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 618*)
(*618*)  (*BRANCH NAME*)
} note note157 = this
(* po redu: 619*)
(*619*)  
(*BRANCH END*)
from note142 and note157 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 620*)
(*620*)  (*BRANCH NAME*)
} note note158 = this
(* po redu: 621*)
(*621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 622*)
(*622*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 623*)
(*623*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 624*)
(*624*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 625*)
(*625*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 626*)
(*626*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 627*)
(*627*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 628*)
(*628*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 629*)
(*629*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 630*)
(*630*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 631*)
(*631*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 632*)
(*632*)  (*BRANCH NAME*)
} note note159 = this
(* po redu: 633*)
(*633*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 634*)
(*634*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 635*)
(*635*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 636*)
(*636*)  (*BRANCH NAME*)
} note note160 = this
(* po redu: 637*)
(*637*)  
(*BRANCH END*)
from note159 and note160 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 638*)
(*638*)  (*BRANCH NAME*)
} note note161 = this
(* po redu: 639*)
(*639*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 640*)
(*640*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 641*)
(*641*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 642*)
(*642*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 643*)
(*643*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 644*)
(*644*)  (*BRANCH NAME*)
} note note162 = this
(* po redu: 645*)
(*645*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 646*)
(*646*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 647*)
(*647*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 648*)
(*648*)  (*BRANCH NAME*)
} note note163 = this
(* po redu: 649*)
(*649*)  
(*BRANCH END*)
from note162 and note163 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 650*)
(*650*)  (*BRANCH NAME*)
} note note164 = this
(* po redu: 651*)
(*651*)  
(*BRANCH END*)
from note161 and note164 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 652*)
(*652*)  (*BRANCH NAME*)
} note note165 = this
(* po redu: 653*)
(*653*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 654*)
(*654*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 655*)
(*655*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 656*)
(*656*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 657*)
(*657*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 658*)
(*658*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 659*)
(*659*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 660*)
(*660*)  (*BRANCH NAME*)
} note note166 = this
(* po redu: 661*)
(*661*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 662*)
(*662*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 663*)
(*663*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 664*)
(*664*)  (*BRANCH NAME*)
} note note167 = this
(* po redu: 665*)
(*665*)  
(*BRANCH END*)
from note166 and note167 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 666*)
(*666*)  (*BRANCH NAME*)
} note note168 = this
(* po redu: 667*)
(*667*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 668*)
(*668*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 669*)
(*669*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 670*)
(*670*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 671*)
(*671*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 672*)
(*672*)  (*BRANCH NAME*)
} note note169 = this
(* po redu: 673*)
(*673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 674*)
(*674*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 675*)
(*675*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 676*)
(*676*)  (*BRANCH NAME*)
} note note170 = this
(* po redu: 677*)
(*677*)  
(*BRANCH END*)
from note169 and note170 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 678*)
(*678*)  (*BRANCH NAME*)
} note note171 = this
(* po redu: 679*)
(*679*)  
(*BRANCH END*)
from note168 and note171 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 680*)
(*680*)  (*BRANCH NAME*)
} note note172 = this
(* po redu: 681*)
(*681*)  
(*BRANCH END*)
from note165 and note172 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 682*)
(*682*)  (*BRANCH NAME*)
} note note173 = this
(* po redu: 683*)
(*683*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 684*)
(*684*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 685*)
(*685*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 686*)
(*686*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 687*)
(*687*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 688*)
(*688*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 689*)
(*689*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 690*)
(*690*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 691*)
(*691*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 692*)
(*692*)  (*BRANCH NAME*)
} note note174 = this
(* po redu: 693*)
(*693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 694*)
(*694*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 695*)
(*695*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 696*)
(*696*)  (*BRANCH NAME*)
} note note175 = this
(* po redu: 697*)
(*697*)  
(*BRANCH END*)
from note174 and note175 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 698*)
(*698*)  (*BRANCH NAME*)
} note note176 = this
(* po redu: 699*)
(*699*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 700*)
(*700*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 701*)
(*701*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 702*)
(*702*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 703*)
(*703*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 704*)
(*704*)  (*BRANCH NAME*)
} note note177 = this
(* po redu: 705*)
(*705*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 706*)
(*706*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 707*)
(*707*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 708*)
(*708*)  (*BRANCH NAME*)
} note note178 = this
(* po redu: 709*)
(*709*)  
(*BRANCH END*)
from note177 and note178 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 710*)
(*710*)  (*BRANCH NAME*)
} note note179 = this
(* po redu: 711*)
(*711*)  
(*BRANCH END*)
from note176 and note179 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 712*)
(*712*)  (*BRANCH NAME*)
} note note180 = this
(* po redu: 713*)
(*713*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 714*)
(*714*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 715*)
(*715*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 716*)
(*716*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 717*)
(*717*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 718*)
(*718*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 719*)
(*719*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 720*)
(*720*)  (*BRANCH NAME*)
} note note181 = this
(* po redu: 721*)
(*721*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 722*)
(*722*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 723*)
(*723*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 724*)
(*724*)  (*BRANCH NAME*)
} note note182 = this
(* po redu: 725*)
(*725*)  
(*BRANCH END*)
from note181 and note182 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 726*)
(*726*)  (*BRANCH NAME*)
} note note183 = this
(* po redu: 727*)
(*727*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 728*)
(*728*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 729*)
(*729*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 730*)
(*730*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 731*)
(*731*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 732*)
(*732*)  (*BRANCH NAME*)
} note note184 = this
(* po redu: 733*)
(*733*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 734*)
(*734*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 735*)
(*735*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 736*)
(*736*)  (*BRANCH NAME*)
} note note185 = this
(* po redu: 737*)
(*737*)  
(*BRANCH END*)
from note184 and note185 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 738*)
(*738*)  (*BRANCH NAME*)
} note note186 = this
(* po redu: 739*)
(*739*)  
(*BRANCH END*)
from note183 and note186 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 740*)
(*740*)  (*BRANCH NAME*)
} note note187 = this
(* po redu: 741*)
(*741*)  
(*BRANCH END*)
from note180 and note187 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 742*)
(*742*)  (*BRANCH NAME*)
} note note188 = this
(* po redu: 743*)
(*743*)  
(*BRANCH END*)
from note173 and note188 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 744*)
(*744*)  (*BRANCH NAME*)
} note note189 = this
(* po redu: 745*)
(*745*)  
(*BRANCH END*)
from note158 and note189 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 746*)
(*746*)  (*BRANCH NAME*)
} note note190 = this
(* po redu: 747*)
(*747*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 748*)
(*748*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 749*)
(*749*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 750*)
(*750*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 751*)
(*751*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 752*)
(*752*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 753*)
(*753*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 754*)
(*754*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 755*)
(*755*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 756*)
(*756*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 757*)
(*757*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 758*)
(*758*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 759*)
(*759*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 760*)
(*760*)  (*BRANCH NAME*)
} note note191 = this
(* po redu: 761*)
(*761*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 762*)
(*762*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 763*)
(*763*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 764*)
(*764*)  (*BRANCH NAME*)
} note note192 = this
(* po redu: 765*)
(*765*)  
(*BRANCH END*)
from note191 and note192 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 766*)
(*766*)  (*BRANCH NAME*)
} note note193 = this
(* po redu: 767*)
(*767*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 768*)
(*768*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 769*)
(*769*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 770*)
(*770*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 771*)
(*771*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 772*)
(*772*)  (*BRANCH NAME*)
} note note194 = this
(* po redu: 773*)
(*773*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 774*)
(*774*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 775*)
(*775*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 776*)
(*776*)  (*BRANCH NAME*)
} note note195 = this
(* po redu: 777*)
(*777*)  
(*BRANCH END*)
from note194 and note195 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 778*)
(*778*)  (*BRANCH NAME*)
} note note196 = this
(* po redu: 779*)
(*779*)  
(*BRANCH END*)
from note193 and note196 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 780*)
(*780*)  (*BRANCH NAME*)
} note note197 = this
(* po redu: 781*)
(*781*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 782*)
(*782*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 783*)
(*783*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 784*)
(*784*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 785*)
(*785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 786*)
(*786*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 787*)
(*787*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 788*)
(*788*)  (*BRANCH NAME*)
} note note198 = this
(* po redu: 789*)
(*789*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 790*)
(*790*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 791*)
(*791*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 792*)
(*792*)  (*BRANCH NAME*)
} note note199 = this
(* po redu: 793*)
(*793*)  
(*BRANCH END*)
from note198 and note199 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 794*)
(*794*)  (*BRANCH NAME*)
} note note200 = this
(* po redu: 795*)
(*795*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 796*)
(*796*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 797*)
(*797*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 798*)
(*798*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 799*)
(*799*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 800*)
(*800*)  (*BRANCH NAME*)
} note note201 = this
(* po redu: 801*)
(*801*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 802*)
(*802*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 803*)
(*803*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 804*)
(*804*)  (*BRANCH NAME*)
} note note202 = this
(* po redu: 805*)
(*805*)  
(*BRANCH END*)
from note201 and note202 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 806*)
(*806*)  (*BRANCH NAME*)
} note note203 = this
(* po redu: 807*)
(*807*)  
(*BRANCH END*)
from note200 and note203 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 808*)
(*808*)  (*BRANCH NAME*)
} note note204 = this
(* po redu: 809*)
(*809*)  
(*BRANCH END*)
from note197 and note204 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 810*)
(*810*)  (*BRANCH NAME*)
} note note205 = this
(* po redu: 811*)
(*811*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 812*)
(*812*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 813*)
(*813*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 814*)
(*814*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 815*)
(*815*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 816*)
(*816*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 817*)
(*817*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 818*)
(*818*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 819*)
(*819*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 820*)
(*820*)  (*BRANCH NAME*)
} note note206 = this
(* po redu: 821*)
(*821*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 822*)
(*822*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 823*)
(*823*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 824*)
(*824*)  (*BRANCH NAME*)
} note note207 = this
(* po redu: 825*)
(*825*)  
(*BRANCH END*)
from note206 and note207 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 826*)
(*826*)  (*BRANCH NAME*)
} note note208 = this
(* po redu: 827*)
(*827*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 828*)
(*828*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 829*)
(*829*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 830*)
(*830*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 831*)
(*831*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 832*)
(*832*)  (*BRANCH NAME*)
} note note209 = this
(* po redu: 833*)
(*833*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 834*)
(*834*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 835*)
(*835*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 836*)
(*836*)  (*BRANCH NAME*)
} note note210 = this
(* po redu: 837*)
(*837*)  
(*BRANCH END*)
from note209 and note210 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 838*)
(*838*)  (*BRANCH NAME*)
} note note211 = this
(* po redu: 839*)
(*839*)  
(*BRANCH END*)
from note208 and note211 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 840*)
(*840*)  (*BRANCH NAME*)
} note note212 = this
(* po redu: 841*)
(*841*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 842*)
(*842*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 843*)
(*843*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 844*)
(*844*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 845*)
(*845*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 846*)
(*846*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 847*)
(*847*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 848*)
(*848*)  (*BRANCH NAME*)
} note note213 = this
(* po redu: 849*)
(*849*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 850*)
(*850*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

(* po redu: 851*)
(*851*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

(* po redu: 852*)
(*852*)  (*BRANCH NAME*)
} note note214 = this
(* po redu: 853*)
(*853*)  
(*BRANCH END*)
from note213 and note214 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 854*)
(*854*)  (*BRANCH NAME*)
} note note215 = this
(* po redu: 855*)
(*855*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 856*)
(*856*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 857*)
(*857*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 858*)
(*858*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 859*)
(*859*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 860*)
(*860*)  (*BRANCH NAME*)
} note note216 = this
(* po redu: 861*)
(*861*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 862*)
(*862*)  (*REGULAR*)
moreover

obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 863*)
(*863*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
obtain  PO4::point
where "PO1 ~= PO4" and "inc_po_pl PO4 PL1" and "inc_po_pl PO4 PL2"
using ax_I7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 864*)
(*864*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(* po redu: 865*)
(*865*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL1"
using ax_D11 [of "LI1" "PL1" "PO2"]
by auto

(* po redu: 866*)
(*866*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 867*)
(*867*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 868*)
(*868*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 869*)
(*869*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 870*)
(*870*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL2"
using ax_D11 [of "LI1" "PL2" "PO2"]
by auto

(* po redu: 871*)
(*871*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 872*)
(*872*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 873*)
(*873*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `PO1 = PO2`
have False
by auto

(* po redu: 874*)
(*874*)  (*BRANCH NAME*)
} note note217 = this
(* po redu: 875*)
(*875*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 876*)
(*876*)  (*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO2 LI2"
using ax_I1 [of "PO1" "PO2"]
by auto

(* po redu: 877*)
(*877*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(* po redu: 878*)
(*878*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

(* po redu: 879*)
(*879*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

(* po redu: 880*)
(*880*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO1 LI1`
have  "\<not>col PO2 PO3 PO1"
using ax_D1a [of "PO2" "PO3" "LI1" "PO1"]
by auto

(* po redu: 881*)
(*881*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 882*)
(*882*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 883*)
(*883*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(* po redu: 884*)
(*884*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 885*)
(*885*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 886*)
(*886*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 887*)
(*887*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 888*)
(*888*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 889*)
(*889*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 890*)
(*890*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 891*)
(*891*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 892*)
(*892*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL2"
using ax_D11 [of "LI1" "PL2" "PO3"]
by auto

(* po redu: 893*)
(*893*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO1`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_231 [of "PO2" "PO3" "PO1"]
by auto

(* po redu: 894*)
(*894*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO3 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO3" "PL1" "PL2"]
by auto

(* po redu: 895*)
(*895*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 896*)
(*896*)  (*BRANCH NAME*)
} note note218 = this
(* po redu: 897*)
(*897*)  
(*BRANCH END*)
from note217 and note218 and `PO1 = PO2 \<or> PO1 ~= PO2`
have False
by auto
(* po redu: 898*)
(*898*)  (*BRANCH NAME*)
} note note219 = this
(* po redu: 899*)
(*899*)  
(*BRANCH END*)
from note216 and note219 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 900*)
(*900*)  (*BRANCH NAME*)
} note note220 = this
(* po redu: 901*)
(*901*)  
(*BRANCH END*)
from note215 and note220 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 902*)
(*902*)  (*BRANCH NAME*)
} note note221 = this
(* po redu: 903*)
(*903*)  
(*BRANCH END*)
from note212 and note221 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 904*)
(*904*)  (*BRANCH NAME*)
} note note222 = this
(* po redu: 905*)
(*905*)  
(*BRANCH END*)
from note205 and note222 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 906*)
(*906*)  (*BRANCH NAME*)
} note note223 = this
(* po redu: 907*)
(*907*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 908*)
(*908*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 909*)
(*909*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 910*)
(*910*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 911*)
(*911*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 912*)
(*912*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 913*)
(*913*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 914*)
(*914*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 915*)
(*915*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 916*)
(*916*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 917*)
(*917*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 918*)
(*918*)  (*BRANCH NAME*)
} note note224 = this
(* po redu: 919*)
(*919*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 920*)
(*920*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 921*)
(*921*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 922*)
(*922*)  (*BRANCH NAME*)
} note note225 = this
(* po redu: 923*)
(*923*)  
(*BRANCH END*)
from note224 and note225 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 924*)
(*924*)  (*BRANCH NAME*)
} note note226 = this
(* po redu: 925*)
(*925*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 926*)
(*926*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 927*)
(*927*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 928*)
(*928*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 929*)
(*929*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 930*)
(*930*)  (*BRANCH NAME*)
} note note227 = this
(* po redu: 931*)
(*931*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 932*)
(*932*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 933*)
(*933*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 934*)
(*934*)  (*BRANCH NAME*)
} note note228 = this
(* po redu: 935*)
(*935*)  
(*BRANCH END*)
from note227 and note228 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 936*)
(*936*)  (*BRANCH NAME*)
} note note229 = this
(* po redu: 937*)
(*937*)  
(*BRANCH END*)
from note226 and note229 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 938*)
(*938*)  (*BRANCH NAME*)
} note note230 = this
(* po redu: 939*)
(*939*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 940*)
(*940*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 941*)
(*941*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 942*)
(*942*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 943*)
(*943*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 944*)
(*944*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 945*)
(*945*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 946*)
(*946*)  (*BRANCH NAME*)
} note note231 = this
(* po redu: 947*)
(*947*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 948*)
(*948*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 949*)
(*949*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 950*)
(*950*)  (*BRANCH NAME*)
} note note232 = this
(* po redu: 951*)
(*951*)  
(*BRANCH END*)
from note231 and note232 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 952*)
(*952*)  (*BRANCH NAME*)
} note note233 = this
(* po redu: 953*)
(*953*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 954*)
(*954*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 955*)
(*955*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 956*)
(*956*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 957*)
(*957*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 958*)
(*958*)  (*BRANCH NAME*)
} note note234 = this
(* po redu: 959*)
(*959*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 960*)
(*960*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 961*)
(*961*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 962*)
(*962*)  (*BRANCH NAME*)
} note note235 = this
(* po redu: 963*)
(*963*)  
(*BRANCH END*)
from note234 and note235 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 964*)
(*964*)  (*BRANCH NAME*)
} note note236 = this
(* po redu: 965*)
(*965*)  
(*BRANCH END*)
from note233 and note236 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 966*)
(*966*)  (*BRANCH NAME*)
} note note237 = this
(* po redu: 967*)
(*967*)  
(*BRANCH END*)
from note230 and note237 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 968*)
(*968*)  (*BRANCH NAME*)
} note note238 = this
(* po redu: 969*)
(*969*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 970*)
(*970*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 971*)
(*971*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 972*)
(*972*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 973*)
(*973*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 974*)
(*974*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 975*)
(*975*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 976*)
(*976*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note239 = this
(* po redu: 977*)
(*977*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 978*)
(*978*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 979*)
(*979*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 980*)
(*980*)  (*BRANCH NAME*)
} note note240 = this
(* po redu: 981*)
(*981*)  
(*BRANCH END*)
from note239 and note240 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 982*)
(*982*)  (*BRANCH NAME*)
} note note241 = this
(* po redu: 983*)
(*983*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 984*)
(*984*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 985*)
(*985*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 986*)
(*986*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 987*)
(*987*)  (*BRANCH NAME*)
} note note242 = this
(* po redu: 988*)
(*988*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 989*)
(*989*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 990*)
(*990*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 991*)
(*991*)  (*BRANCH NAME*)
} note note243 = this
(* po redu: 992*)
(*992*)  
(*BRANCH END*)
from note242 and note243 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 993*)
(*993*)  (*BRANCH NAME*)
} note note244 = this
(* po redu: 994*)
(*994*)  
(*BRANCH END*)
from note241 and note244 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 995*)
(*995*)  (*BRANCH NAME*)
} note note245 = this
(* po redu: 996*)
(*996*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 997*)
(*997*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 998*)
(*998*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 999*)
(*999*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1000*)
(*1000*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1001*)
(*1001*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1002*)
(*1002*)  (*BRANCH NAME*)
} note note246 = this
(* po redu: 1003*)
(*1003*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1004*)
(*1004*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1005*)
(*1005*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1006*)
(*1006*)  (*BRANCH NAME*)
} note note247 = this
(* po redu: 1007*)
(*1007*)  
(*BRANCH END*)
from note246 and note247 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1008*)
(*1008*)  (*BRANCH NAME*)
} note note248 = this
(* po redu: 1009*)
(*1009*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1010*)
(*1010*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1011*)
(*1011*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1012*)
(*1012*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note249 = this
(* po redu: 1013*)
(*1013*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1014*)
(*1014*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1015*)
(*1015*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1016*)
(*1016*)  (*BRANCH NAME*)
} note note250 = this
(* po redu: 1017*)
(*1017*)  
(*BRANCH END*)
from note249 and note250 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 1018*)
(*1018*)  (*BRANCH NAME*)
} note note251 = this
(* po redu: 1019*)
(*1019*)  
(*BRANCH END*)
from note248 and note251 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 1020*)
(*1020*)  (*BRANCH NAME*)
} note note252 = this
(* po redu: 1021*)
(*1021*)  
(*BRANCH END*)
from note245 and note252 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 1022*)
(*1022*)  (*BRANCH NAME*)
} note note253 = this
(* po redu: 1023*)
(*1023*)  
(*BRANCH END*)
from note238 and note253 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 1024*)
(*1024*)  (*BRANCH NAME*)
} note note254 = this
(* po redu: 1025*)
(*1025*)  
(*BRANCH END*)
from note223 and note254 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 1026*)
(*1026*)  (*BRANCH NAME*)
} note note255 = this
(* po redu: 1027*)
(*1027*)  
(*BRANCH END*)
from note190 and note255 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 1028*)
(*1028*)  (*BRANCH NAME*)
} note note256 = this
(* po redu: 1029*)
(*1029*)  
(*BRANCH END*)
from note127 and note256 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
