theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th23:
assumes "LI1 ~= LI2"
and "inc_po_l PO1 LI1"
and "inc_po_l PO1 LI2"
shows " ( \<exists>  (PL1::plane). inc_l_pl LI1 PL1 & inc_l_pl LI2 PL1)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2*)
(*2*)  (*REGULAR*)
moreover
from `LI1 ~= LI2` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have  "int_l_l LI1 LI2"
using ax_D5 [of "LI1" "LI2" "PO1"]
by auto

(* po redu: 3*)
(*3*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(* po redu: 4*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
(* po redu: 5*)
(*5*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(* po redu: 6*)
(*6*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
(* po redu: 7*)
(*7*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 8*)
(*8*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 9*)
(*9*)  (*BRANCH NAME*)
} note note1 = this
(* po redu: 10*)
(*10*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
(* po redu: 11*)
(*11*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 12*)
(*12*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 13*)
(*13*)  (*BRANCH NAME*)
} note note2 = this
(* po redu: 14*)
(*14*)  
(*BRANCH END*)
from note1 and note2 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have False
by auto
(* po redu: 15*)
(*15*)  (*BRANCH NAME*)
} note note3 = this
(* po redu: 16*)
(*16*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
(* po redu: 17*)
(*17*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(* po redu: 18*)
(*18*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
(* po redu: 19*)
(*19*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 20*)
(*20*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 21*)
(*21*)  (*BRANCH NAME*)
} note note4 = this
(* po redu: 22*)
(*22*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
(* po redu: 23*)
(*23*)  (*REGULAR*)
moreover

obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 24*)
(*24*)  (*REGULAR*)
moreover

obtain  PO4::point and  PO5::point
where "inc_po_l PO4 LI2" and "PO4 ~= PO5" and "inc_po_l PO5 LI2"
using ax_I3a [of "LI2"]
by auto

(* po redu: 25*)
(*25*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(* po redu: 26*)
(*26*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(* po redu: 27*)
(*27*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(* po redu: 28*)
(*28*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 29*)
(*29*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 30*)
(*30*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(* po redu: 31*)
(*31*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(* po redu: 32*)
(*32*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

(* po redu: 33*)
(*33*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2"
using ax_g4 [of "PO3" "LI2"]
by auto

(* po redu: 34*)
(*34*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI2"
(* po redu: 35*)
(*35*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 36*)
(*36*)  (*REGULAR*)
moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2`
have  "LI1 = LI2"
using ax_I2 [of "PO1" "PO3" "LI1" "LI2"]
by auto

(* po redu: 37*)
(*37*)  (*REGULAR*)
moreover
from `LI1 = LI2` and `LI1 ~= LI2`
have False
by auto

(* po redu: 38*)
(*38*)  (*BRANCH NAME*)
} note note5 = this
(* po redu: 39*)
(*39*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI2"
(* po redu: 40*)
(*40*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

(* po redu: 41*)
(*41*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

(* po redu: 42*)
(*42*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

(* po redu: 43*)
(*43*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 44*)
(*44*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 45*)
(*45*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 46*)
(*46*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 47*)
(*47*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 48*)
(*48*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 49*)
(*49*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 50*)
(*50*)  (*REGULAR*)
moreover

have  "PO3 = PO5 \<or> PO3 ~= PO5"
using ax_g1 [of "PO3" "PO5"]
by auto

(* po redu: 51*)
(*51*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO5"
(* po redu: 52*)
(*52*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO5`
have False
by auto

(* po redu: 53*)
(*53*)  (*BRANCH NAME*)
} note note6 = this
(* po redu: 54*)
(*54*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO5"
(* po redu: 55*)
(*55*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 56*)
(*56*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 57*)
(*57*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI1" "PO3" "PO5"]
by auto

(* po redu: 58*)
(*58*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 59*)
(*59*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

(* po redu: 60*)
(*60*)  (*BRANCH NAME*)
} note note7 = this
(* po redu: 61*)
(*61*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 62*)
(*62*)  (*REGULAR*)
moreover
from `PO3 ~= PO5`
obtain  LI3::line
where "inc_po_l PO3 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO3" "PO5"]
by auto

(* po redu: 63*)
(*63*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 64*)
(*64*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO5 PL1"
using ax_I4a [of "PO1" "PO3" "PO5"]
by auto

(* po redu: 65*)
(*65*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI3" "PO3" "PO5"]
by auto

(* po redu: 66*)
(*66*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO5 PO5"
using ax_D1 [of "PO3" "LI3" "PO5" "PO5"]
by auto

(* po redu: 67*)
(*67*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 68*)
(*68*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 69*)
(*69*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 70*)
(*70*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 71*)
(*71*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 72*)
(*72*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 73*)
(*73*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 74*)
(*74*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 75*)
(*75*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 76*)
(*76*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 77*)
(*77*)  (*BRANCH NAME*)
} note note8 = this
(* po redu: 78*)
(*78*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 79*)
(*79*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 80*)
(*80*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 81*)
(*81*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 82*)
(*82*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 83*)
(*83*)  (*BRANCH NAME*)
} note note9 = this
(* po redu: 84*)
(*84*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 85*)
(*85*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 86*)
(*86*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 87*)
(*87*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI3" "PO3" "PO5"]
by auto

(* po redu: 88*)
(*88*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 89*)
(*89*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

(* po redu: 90*)
(*90*)  (*BRANCH NAME*)
} note note10 = this
(* po redu: 91*)
(*91*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 92*)
(*92*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 93*)
(*93*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 94*)
(*94*)  (*BRANCH NAME*)
} note note11 = this
(* po redu: 95*)
(*95*)  
(*BRANCH END*)
from note10 and note11 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 96*)
(*96*)  (*BRANCH NAME*)
} note note12 = this
(* po redu: 97*)
(*97*)  
(*BRANCH END*)
from note9 and note12 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 98*)
(*98*)  (*BRANCH NAME*)
} note note13 = this
(* po redu: 99*)
(*99*)  
(*BRANCH END*)
from note8 and note13 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 100*)
(*100*)  (*BRANCH NAME*)
} note note14 = this
(* po redu: 101*)
(*101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 102*)
(*102*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 103*)
(*103*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 104*)
(*104*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 105*)
(*105*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 106*)
(*106*)  (*BRANCH NAME*)
} note note15 = this
(* po redu: 107*)
(*107*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 108*)
(*108*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 109*)
(*109*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 110*)
(*110*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 111*)
(*111*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 112*)
(*112*)  (*BRANCH NAME*)
} note note16 = this
(* po redu: 113*)
(*113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 114*)
(*114*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 115*)
(*115*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 116*)
(*116*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI3" "PO3" "PO5"]
by auto

(* po redu: 117*)
(*117*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 118*)
(*118*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

(* po redu: 119*)
(*119*)  (*BRANCH NAME*)
} note note17 = this
(* po redu: 120*)
(*120*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 121*)
(*121*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 122*)
(*122*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 123*)
(*123*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 124*)
(*124*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 125*)
(*125*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO5"]
by auto

(* po redu: 126*)
(*126*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 127*)
(*127*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 128*)
(*128*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 129*)
(*129*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 130*)
(*130*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 131*)
(*131*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 132*)
(*132*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO3 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 133*)
(*133*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 134*)
(*134*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO5 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 135*)
(*135*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 136*)
(*136*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 137*)
(*137*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO3` and `inc_po_l PO3 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO3" "PL1"]
by auto

(* po redu: 138*)
(*138*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 139*)
(*139*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO5` and `inc_po_l PO5 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO5" "PL1"]
by auto

(* po redu: 140*)
(*140*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 141*)
(*141*)  (*BRANCH NAME*)
} note note18 = this
(* po redu: 142*)
(*142*)  
(*BRANCH END*)
from note17 and note18 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 143*)
(*143*)  (*BRANCH NAME*)
} note note19 = this
(* po redu: 144*)
(*144*)  
(*BRANCH END*)
from note16 and note19 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 145*)
(*145*)  (*BRANCH NAME*)
} note note20 = this
(* po redu: 146*)
(*146*)  
(*BRANCH END*)
from note15 and note20 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 147*)
(*147*)  (*BRANCH NAME*)
} note note21 = this
(* po redu: 148*)
(*148*)  
(*BRANCH END*)
from note14 and note21 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 149*)
(*149*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 150*)
(*150*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 151*)
(*151*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 152*)
(*152*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 153*)
(*153*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 154*)
(*154*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 155*)
(*155*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 156*)
(*156*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 157*)
(*157*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 158*)
(*158*)  (*BRANCH NAME*)
} note note23 = this
(* po redu: 159*)
(*159*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 160*)
(*160*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 161*)
(*161*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 162*)
(*162*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 163*)
(*163*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 164*)
(*164*)  (*BRANCH NAME*)
} note note24 = this
(* po redu: 165*)
(*165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 166*)
(*166*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 167*)
(*167*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 168*)
(*168*)  (*BRANCH NAME*)
} note note25 = this
(* po redu: 169*)
(*169*)  
(*BRANCH END*)
from note24 and note25 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 170*)
(*170*)  (*BRANCH NAME*)
} note note26 = this
(* po redu: 171*)
(*171*)  
(*BRANCH END*)
from note23 and note26 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 172*)
(*172*)  (*BRANCH NAME*)
} note note27 = this
(* po redu: 173*)
(*173*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 174*)
(*174*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 175*)
(*175*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 176*)
(*176*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 177*)
(*177*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 178*)
(*178*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 179*)
(*179*)  (*BRANCH NAME*)
} note note28 = this
(* po redu: 180*)
(*180*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 181*)
(*181*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 182*)
(*182*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 183*)
(*183*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 184*)
(*184*)  (*BRANCH NAME*)
} note note29 = this
(* po redu: 185*)
(*185*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 186*)
(*186*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 187*)
(*187*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 188*)
(*188*)  (*BRANCH NAME*)
} note note30 = this
(* po redu: 189*)
(*189*)  
(*BRANCH END*)
from note29 and note30 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 190*)
(*190*)  (*BRANCH NAME*)
} note note31 = this
(* po redu: 191*)
(*191*)  
(*BRANCH END*)
from note28 and note31 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 192*)
(*192*)  (*BRANCH NAME*)
} note note32 = this
(* po redu: 193*)
(*193*)  
(*BRANCH END*)
from note27 and note32 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 194*)
(*194*)  (*BRANCH NAME*)
} note note33 = this
(* po redu: 195*)
(*195*)  
(*BRANCH END*)
from note22 and note33 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 196*)
(*196*)  (*BRANCH NAME*)
} note note34 = this
(* po redu: 197*)
(*197*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 198*)
(*198*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 199*)
(*199*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 200*)
(*200*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 201*)
(*201*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 202*)
(*202*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 203*)
(*203*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 204*)
(*204*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 205*)
(*205*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 206*)
(*206*)  (*BRANCH NAME*)
} note note35 = this
(* po redu: 207*)
(*207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 208*)
(*208*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 209*)
(*209*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 210*)
(*210*)  (*BRANCH NAME*)
} note note36 = this
(* po redu: 211*)
(*211*)  
(*BRANCH END*)
from note35 and note36 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 212*)
(*212*)  (*BRANCH NAME*)
} note note37 = this
(* po redu: 213*)
(*213*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 214*)
(*214*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 215*)
(*215*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 216*)
(*216*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 217*)
(*217*)  (*BRANCH NAME*)
} note note38 = this
(* po redu: 218*)
(*218*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 219*)
(*219*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 220*)
(*220*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 221*)
(*221*)  (*BRANCH NAME*)
} note note39 = this
(* po redu: 222*)
(*222*)  
(*BRANCH END*)
from note38 and note39 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 223*)
(*223*)  (*BRANCH NAME*)
} note note40 = this
(* po redu: 224*)
(*224*)  
(*BRANCH END*)
from note37 and note40 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 225*)
(*225*)  (*BRANCH NAME*)
} note note41 = this
(* po redu: 226*)
(*226*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 227*)
(*227*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 228*)
(*228*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 229*)
(*229*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 230*)
(*230*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 231*)
(*231*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 232*)
(*232*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 233*)
(*233*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 234*)
(*234*)  (*BRANCH NAME*)
} note note42 = this
(* po redu: 235*)
(*235*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 236*)
(*236*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 237*)
(*237*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 238*)
(*238*)  (*BRANCH NAME*)
} note note43 = this
(* po redu: 239*)
(*239*)  
(*BRANCH END*)
from note42 and note43 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 240*)
(*240*)  (*BRANCH NAME*)
} note note44 = this
(* po redu: 241*)
(*241*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 242*)
(*242*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 243*)
(*243*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 244*)
(*244*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 245*)
(*245*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 246*)
(*246*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 247*)
(*247*)  (*BRANCH NAME*)
} note note45 = this
(* po redu: 248*)
(*248*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 249*)
(*249*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 250*)
(*250*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 251*)
(*251*)  (*BRANCH NAME*)
} note note46 = this
(* po redu: 252*)
(*252*)  
(*BRANCH END*)
from note45 and note46 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 253*)
(*253*)  (*BRANCH NAME*)
} note note47 = this
(* po redu: 254*)
(*254*)  
(*BRANCH END*)
from note44 and note47 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 255*)
(*255*)  (*BRANCH NAME*)
} note note48 = this
(* po redu: 256*)
(*256*)  
(*BRANCH END*)
from note41 and note48 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 257*)
(*257*)  (*BRANCH NAME*)
} note note49 = this
(* po redu: 258*)
(*258*)  
(*BRANCH END*)
from note34 and note49 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 259*)
(*259*)  (*BRANCH NAME*)
} note note50 = this
(* po redu: 260*)
(*260*)  
(*BRANCH END*)
from note7 and note50 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 261*)
(*261*)  (*BRANCH NAME*)
} note note51 = this
(* po redu: 262*)
(*262*)  
(*BRANCH END*)
from note6 and note51 and `PO3 = PO5 \<or> PO3 ~= PO5`
have ?thesis
by auto
(* po redu: 263*)
(*263*)  (*BRANCH NAME*)
} note note52 = this
(* po redu: 264*)
(*264*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 265*)
(*265*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO4 PO3"
using ax_D1a [of "PO1" "PO4" "LI2" "PO3"]
by auto

(* po redu: 266*)
(*266*)  (*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(* po redu: 267*)
(*267*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
(* po redu: 268*)
(*268*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO4`
have False
by auto

(* po redu: 269*)
(*269*)  (*BRANCH NAME*)
} note note53 = this
(* po redu: 270*)
(*270*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
(* po redu: 271*)
(*271*)  (*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(* po redu: 272*)
(*272*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
(* po redu: 273*)
(*273*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI1" "PO3" "PO4"]
by auto

(* po redu: 274*)
(*274*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 275*)
(*275*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 276*)
(*276*)  (*BRANCH NAME*)
} note note54 = this
(* po redu: 277*)
(*277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(* po redu: 278*)
(*278*)  (*REGULAR*)
moreover
from `PO3 ~= PO4`
obtain  LI3::line
where "inc_po_l PO3 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO3" "PO4"]
by auto

(* po redu: 279*)
(*279*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 280*)
(*280*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO1" "PO3" "PO4"]
by auto

(* po redu: 281*)
(*281*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 282*)
(*282*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO4 PO5"
using ax_D1 [of "PO1" "LI2" "PO4" "PO5"]
by auto

(* po redu: 283*)
(*283*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 284*)
(*284*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO4 PO5"
using ax_D1 [of "PO4" "LI2" "PO4" "PO5"]
by auto

(* po redu: 285*)
(*285*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO5 PO5"
using ax_D1 [of "PO4" "LI2" "PO5" "PO5"]
by auto

(* po redu: 286*)
(*286*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 287*)
(*287*)  (*REGULAR*)
moreover
from `PO4 ~= PO5` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO4 PO5 PO3"
using ax_D1a [of "PO4" "PO5" "LI2" "PO3"]
by auto

(* po redu: 288*)
(*288*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 289*)
(*289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 290*)
(*290*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO3 PO3 PO4"
using ax_D1 [of "PO3" "LI3" "PO3" "PO4"]
by auto

(* po redu: 291*)
(*291*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO3 PO4 PO4"
using ax_D1 [of "PO3" "LI3" "PO4" "PO4"]
by auto

(* po redu: 292*)
(*292*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 293*)
(*293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 294*)
(*294*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 295*)
(*295*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 296*)
(*296*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 297*)
(*297*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 298*)
(*298*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 299*)
(*299*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 300*)
(*300*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 301*)
(*301*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 302*)
(*302*)  (*BRANCH NAME*)
} note note55 = this
(* po redu: 303*)
(*303*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 304*)
(*304*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 305*)
(*305*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 306*)
(*306*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 307*)
(*307*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 308*)
(*308*)  (*BRANCH NAME*)
} note note56 = this
(* po redu: 309*)
(*309*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 310*)
(*310*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 311*)
(*311*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 312*)
(*312*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI3" "PO3" "PO4"]
by auto

(* po redu: 313*)
(*313*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 314*)
(*314*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 315*)
(*315*)  (*BRANCH NAME*)
} note note57 = this
(* po redu: 316*)
(*316*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 317*)
(*317*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 318*)
(*318*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 319*)
(*319*)  (*BRANCH NAME*)
} note note58 = this
(* po redu: 320*)
(*320*)  
(*BRANCH END*)
from note57 and note58 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 321*)
(*321*)  (*BRANCH NAME*)
} note note59 = this
(* po redu: 322*)
(*322*)  
(*BRANCH END*)
from note56 and note59 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 323*)
(*323*)  (*BRANCH NAME*)
} note note60 = this
(* po redu: 324*)
(*324*)  
(*BRANCH END*)
from note55 and note60 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 325*)
(*325*)  (*BRANCH NAME*)
} note note61 = this
(* po redu: 326*)
(*326*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 327*)
(*327*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 328*)
(*328*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 329*)
(*329*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 330*)
(*330*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 331*)
(*331*)  (*BRANCH NAME*)
} note note62 = this
(* po redu: 332*)
(*332*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 333*)
(*333*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 334*)
(*334*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 335*)
(*335*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 336*)
(*336*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 337*)
(*337*)  (*BRANCH NAME*)
} note note63 = this
(* po redu: 338*)
(*338*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 339*)
(*339*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 340*)
(*340*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 341*)
(*341*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI3" "PO3" "PO4"]
by auto

(* po redu: 342*)
(*342*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 343*)
(*343*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 344*)
(*344*)  (*BRANCH NAME*)
} note note64 = this
(* po redu: 345*)
(*345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 346*)
(*346*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 347*)
(*347*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 348*)
(*348*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 349*)
(*349*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 350*)
(*350*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

(* po redu: 351*)
(*351*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 352*)
(*352*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 353*)
(*353*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 354*)
(*354*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 355*)
(*355*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 356*)
(*356*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 357*)
(*357*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 358*)
(*358*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 359*)
(*359*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 360*)
(*360*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 361*)
(*361*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 362*)
(*362*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO3` and `inc_po_l PO3 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO3" "PL1"]
by auto

(* po redu: 363*)
(*363*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO5`
have "PO4 ~= PO1"
by auto

(* po redu: 364*)
(*364*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 365*)
(*365*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 366*)
(*366*)  (*BRANCH NAME*)
} note note65 = this
(* po redu: 367*)
(*367*)  
(*BRANCH END*)
from note64 and note65 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 368*)
(*368*)  (*BRANCH NAME*)
} note note66 = this
(* po redu: 369*)
(*369*)  
(*BRANCH END*)
from note63 and note66 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 370*)
(*370*)  (*BRANCH NAME*)
} note note67 = this
(* po redu: 371*)
(*371*)  
(*BRANCH END*)
from note62 and note67 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 372*)
(*372*)  (*BRANCH NAME*)
} note note68 = this
(* po redu: 373*)
(*373*)  
(*BRANCH END*)
from note61 and note68 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 374*)
(*374*)  (*BRANCH NAME*)
} note note69 = this
(* po redu: 375*)
(*375*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 376*)
(*376*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 377*)
(*377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 378*)
(*378*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 379*)
(*379*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 380*)
(*380*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 381*)
(*381*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 382*)
(*382*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 383*)
(*383*)  (*BRANCH NAME*)
} note note70 = this
(* po redu: 384*)
(*384*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 385*)
(*385*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 386*)
(*386*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 387*)
(*387*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 388*)
(*388*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 389*)
(*389*)  (*BRANCH NAME*)
} note note71 = this
(* po redu: 390*)
(*390*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 391*)
(*391*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 392*)
(*392*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 393*)
(*393*)  (*BRANCH NAME*)
} note note72 = this
(* po redu: 394*)
(*394*)  
(*BRANCH END*)
from note71 and note72 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 395*)
(*395*)  (*BRANCH NAME*)
} note note73 = this
(* po redu: 396*)
(*396*)  
(*BRANCH END*)
from note70 and note73 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 397*)
(*397*)  (*BRANCH NAME*)
} note note74 = this
(* po redu: 398*)
(*398*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 399*)
(*399*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 400*)
(*400*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 401*)
(*401*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 402*)
(*402*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 403*)
(*403*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 404*)
(*404*)  (*BRANCH NAME*)
} note note75 = this
(* po redu: 405*)
(*405*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 406*)
(*406*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 407*)
(*407*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 408*)
(*408*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 409*)
(*409*)  (*BRANCH NAME*)
} note note76 = this
(* po redu: 410*)
(*410*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 411*)
(*411*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 412*)
(*412*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 413*)
(*413*)  (*BRANCH NAME*)
} note note77 = this
(* po redu: 414*)
(*414*)  
(*BRANCH END*)
from note76 and note77 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 415*)
(*415*)  (*BRANCH NAME*)
} note note78 = this
(* po redu: 416*)
(*416*)  
(*BRANCH END*)
from note75 and note78 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 417*)
(*417*)  (*BRANCH NAME*)
} note note79 = this
(* po redu: 418*)
(*418*)  
(*BRANCH END*)
from note74 and note79 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 419*)
(*419*)  (*BRANCH NAME*)
} note note80 = this
(* po redu: 420*)
(*420*)  
(*BRANCH END*)
from note69 and note80 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 421*)
(*421*)  (*BRANCH NAME*)
} note note81 = this
(* po redu: 422*)
(*422*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 423*)
(*423*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 424*)
(*424*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 425*)
(*425*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 426*)
(*426*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 427*)
(*427*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 428*)
(*428*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 429*)
(*429*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 430*)
(*430*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 431*)
(*431*)  (*BRANCH NAME*)
} note note82 = this
(* po redu: 432*)
(*432*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 433*)
(*433*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 434*)
(*434*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 435*)
(*435*)  (*BRANCH NAME*)
} note note83 = this
(* po redu: 436*)
(*436*)  
(*BRANCH END*)
from note82 and note83 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 437*)
(*437*)  (*BRANCH NAME*)
} note note84 = this
(* po redu: 438*)
(*438*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 439*)
(*439*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 440*)
(*440*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 441*)
(*441*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 442*)
(*442*)  (*BRANCH NAME*)
} note note85 = this
(* po redu: 443*)
(*443*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 444*)
(*444*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 445*)
(*445*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 446*)
(*446*)  (*BRANCH NAME*)
} note note86 = this
(* po redu: 447*)
(*447*)  
(*BRANCH END*)
from note85 and note86 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 448*)
(*448*)  (*BRANCH NAME*)
} note note87 = this
(* po redu: 449*)
(*449*)  
(*BRANCH END*)
from note84 and note87 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 450*)
(*450*)  (*BRANCH NAME*)
} note note88 = this
(* po redu: 451*)
(*451*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 452*)
(*452*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 453*)
(*453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 454*)
(*454*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 455*)
(*455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 456*)
(*456*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 457*)
(*457*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 458*)
(*458*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 459*)
(*459*)  (*BRANCH NAME*)
} note note89 = this
(* po redu: 460*)
(*460*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 461*)
(*461*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 462*)
(*462*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 463*)
(*463*)  (*BRANCH NAME*)
} note note90 = this
(* po redu: 464*)
(*464*)  
(*BRANCH END*)
from note89 and note90 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 465*)
(*465*)  (*BRANCH NAME*)
} note note91 = this
(* po redu: 466*)
(*466*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 467*)
(*467*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 468*)
(*468*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 469*)
(*469*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 470*)
(*470*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 471*)
(*471*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 472*)
(*472*)  (*BRANCH NAME*)
} note note92 = this
(* po redu: 473*)
(*473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 474*)
(*474*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 475*)
(*475*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 476*)
(*476*)  (*BRANCH NAME*)
} note note93 = this
(* po redu: 477*)
(*477*)  
(*BRANCH END*)
from note92 and note93 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 478*)
(*478*)  (*BRANCH NAME*)
} note note94 = this
(* po redu: 479*)
(*479*)  
(*BRANCH END*)
from note91 and note94 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 480*)
(*480*)  (*BRANCH NAME*)
} note note95 = this
(* po redu: 481*)
(*481*)  
(*BRANCH END*)
from note88 and note95 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 482*)
(*482*)  (*BRANCH NAME*)
} note note96 = this
(* po redu: 483*)
(*483*)  
(*BRANCH END*)
from note81 and note96 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 484*)
(*484*)  (*BRANCH NAME*)
} note note97 = this
(* po redu: 485*)
(*485*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 486*)
(*486*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 487*)
(*487*)  (*REGULAR*)
moreover

have  "PO3 = PO5 \<or> PO3 ~= PO5"
using ax_g1 [of "PO3" "PO5"]
by auto

(* po redu: 488*)
(*488*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO5"
(* po redu: 489*)
(*489*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO5`
have False
by auto

(* po redu: 490*)
(*490*)  (*BRANCH NAME*)
} note note98 = this
(* po redu: 491*)
(*491*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO5"
(* po redu: 492*)
(*492*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 493*)
(*493*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 494*)
(*494*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI1" "PO3" "PO5"]
by auto

(* po redu: 495*)
(*495*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 496*)
(*496*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

(* po redu: 497*)
(*497*)  (*BRANCH NAME*)
} note note99 = this
(* po redu: 498*)
(*498*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 499*)
(*499*)  (*REGULAR*)
moreover
from `PO3 ~= PO5`
obtain  LI4::line
where "inc_po_l PO3 LI4" and "inc_po_l PO5 LI4"
using ax_I1 [of "PO3" "PO5"]
by auto

(* po redu: 500*)
(*500*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 501*)
(*501*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5`
obtain  PL2::plane
where "inc_po_pl PO1 PL2" and "inc_po_pl PO3 PL2" and "inc_po_pl PO5 PL2"
using ax_I4a [of "PO1" "PO3" "PO5"]
by auto

(* po redu: 502*)
(*502*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

(* po redu: 503*)
(*503*)  (*REGULAR*)
moreover
from `\<not>col PO3 PO4 PO5`
obtain  PL3::plane
where "inc_po_pl PO3 PL3" and "inc_po_pl PO4 PL3" and "inc_po_pl PO5 PL3"
using ax_I4a [of "PO3" "PO4" "PO5"]
by auto

(* po redu: 504*)
(*504*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO3 PO3 PO4"
using ax_D1 [of "PO3" "LI3" "PO3" "PO4"]
by auto

(* po redu: 505*)
(*505*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO3 PO4 PO4"
using ax_D1 [of "PO3" "LI3" "PO4" "PO4"]
by auto

(* po redu: 506*)
(*506*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 507*)
(*507*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 508*)
(*508*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 509*)
(*509*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 510*)
(*510*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 511*)
(*511*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 512*)
(*512*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 513*)
(*513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 514*)
(*514*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 515*)
(*515*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 516*)
(*516*)  (*BRANCH NAME*)
} note note100 = this
(* po redu: 517*)
(*517*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 518*)
(*518*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 519*)
(*519*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 520*)
(*520*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 521*)
(*521*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 522*)
(*522*)  (*BRANCH NAME*)
} note note101 = this
(* po redu: 523*)
(*523*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 524*)
(*524*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 525*)
(*525*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 526*)
(*526*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI3" "PO3" "PO4"]
by auto

(* po redu: 527*)
(*527*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 528*)
(*528*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 529*)
(*529*)  (*BRANCH NAME*)
} note note102 = this
(* po redu: 530*)
(*530*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 531*)
(*531*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

(* po redu: 532*)
(*532*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
(* po redu: 533*)
(*533*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI3" "PO3" "PO5"]
by auto

(* po redu: 534*)
(*534*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO4 PO5"
using ax_D1 [of "PO3" "LI3" "PO4" "PO5"]
by auto

(* po redu: 535*)
(*535*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

(* po redu: 536*)
(*536*)  (*REGULAR*)
moreover
from `col PO3 PO4 PO5` and `\<not>col PO3 PO4 PO5`
have False
by auto

(* po redu: 537*)
(*537*)  (*BRANCH NAME*)
} note note103 = this
(* po redu: 538*)
(*538*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
(* po redu: 539*)
(*539*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 540*)
(*540*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 541*)
(*541*)  (*BRANCH NAME*)
} note note104 = this
(* po redu: 542*)
(*542*)  
(*BRANCH END*)
from note103 and note104 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have False
by auto
(* po redu: 543*)
(*543*)  (*BRANCH NAME*)
} note note105 = this
(* po redu: 544*)
(*544*)  
(*BRANCH END*)
from note102 and note105 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 545*)
(*545*)  (*BRANCH NAME*)
} note note106 = this
(* po redu: 546*)
(*546*)  
(*BRANCH END*)
from note101 and note106 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 547*)
(*547*)  (*BRANCH NAME*)
} note note107 = this
(* po redu: 548*)
(*548*)  
(*BRANCH END*)
from note100 and note107 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 549*)
(*549*)  (*BRANCH NAME*)
} note note108 = this
(* po redu: 550*)
(*550*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 551*)
(*551*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 552*)
(*552*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 553*)
(*553*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 554*)
(*554*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 555*)
(*555*)  (*BRANCH NAME*)
} note note109 = this
(* po redu: 556*)
(*556*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 557*)
(*557*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 558*)
(*558*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 559*)
(*559*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 560*)
(*560*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 561*)
(*561*)  (*BRANCH NAME*)
} note note110 = this
(* po redu: 562*)
(*562*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 563*)
(*563*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 564*)
(*564*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 565*)
(*565*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI3" "PO3" "PO4"]
by auto

(* po redu: 566*)
(*566*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 567*)
(*567*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 568*)
(*568*)  (*BRANCH NAME*)
} note note111 = this
(* po redu: 569*)
(*569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 570*)
(*570*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

(* po redu: 571*)
(*571*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
(* po redu: 572*)
(*572*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI3" "PO3" "PO5"]
by auto

(* po redu: 573*)
(*573*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO4 PO5"
using ax_D1 [of "PO3" "LI3" "PO4" "PO5"]
by auto

(* po redu: 574*)
(*574*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

(* po redu: 575*)
(*575*)  (*REGULAR*)
moreover
from `col PO3 PO4 PO5` and `\<not>col PO3 PO4 PO5`
have False
by auto

(* po redu: 576*)
(*576*)  (*BRANCH NAME*)
} note note112 = this
(* po redu: 577*)
(*577*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
(* po redu: 578*)
(*578*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 579*)
(*579*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 580*)
(*580*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 581*)
(*581*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 582*)
(*582*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

(* po redu: 583*)
(*583*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 584*)
(*584*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 585*)
(*585*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 586*)
(*586*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 587*)
(*587*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 588*)
(*588*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 589*)
(*589*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 590*)
(*590*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 591*)
(*591*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 592*)
(*592*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 593*)
(*593*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 594*)
(*594*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO3` and `inc_po_l PO3 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO3" "PL1"]
by auto

(* po redu: 595*)
(*595*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 596*)
(*596*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 597*)
(*597*)  (*BRANCH NAME*)
} note note113 = this
(* po redu: 598*)
(*598*)  
(*BRANCH END*)
from note112 and note113 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have ?thesis
by auto
(* po redu: 599*)
(*599*)  (*BRANCH NAME*)
} note note114 = this
(* po redu: 600*)
(*600*)  
(*BRANCH END*)
from note111 and note114 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 601*)
(*601*)  (*BRANCH NAME*)
} note note115 = this
(* po redu: 602*)
(*602*)  
(*BRANCH END*)
from note110 and note115 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 603*)
(*603*)  (*BRANCH NAME*)
} note note116 = this
(* po redu: 604*)
(*604*)  
(*BRANCH END*)
from note109 and note116 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 605*)
(*605*)  (*BRANCH NAME*)
} note note117 = this
(* po redu: 606*)
(*606*)  
(*BRANCH END*)
from note108 and note117 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 607*)
(*607*)  (*BRANCH NAME*)
} note note118 = this
(* po redu: 608*)
(*608*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 609*)
(*609*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 610*)
(*610*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 611*)
(*611*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 612*)
(*612*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 613*)
(*613*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 614*)
(*614*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 615*)
(*615*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 616*)
(*616*)  (*BRANCH NAME*)
} note note119 = this
(* po redu: 617*)
(*617*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 618*)
(*618*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 619*)
(*619*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 620*)
(*620*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 621*)
(*621*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 622*)
(*622*)  (*BRANCH NAME*)
} note note120 = this
(* po redu: 623*)
(*623*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 624*)
(*624*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 625*)
(*625*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 626*)
(*626*)  (*BRANCH NAME*)
} note note121 = this
(* po redu: 627*)
(*627*)  
(*BRANCH END*)
from note120 and note121 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 628*)
(*628*)  (*BRANCH NAME*)
} note note122 = this
(* po redu: 629*)
(*629*)  
(*BRANCH END*)
from note119 and note122 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 630*)
(*630*)  (*BRANCH NAME*)
} note note123 = this
(* po redu: 631*)
(*631*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 632*)
(*632*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 633*)
(*633*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 634*)
(*634*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 635*)
(*635*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 636*)
(*636*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 637*)
(*637*)  (*BRANCH NAME*)
} note note124 = this
(* po redu: 638*)
(*638*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 639*)
(*639*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 640*)
(*640*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 641*)
(*641*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 642*)
(*642*)  (*BRANCH NAME*)
} note note125 = this
(* po redu: 643*)
(*643*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 644*)
(*644*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 645*)
(*645*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 646*)
(*646*)  (*BRANCH NAME*)
} note note126 = this
(* po redu: 647*)
(*647*)  
(*BRANCH END*)
from note125 and note126 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 648*)
(*648*)  (*BRANCH NAME*)
} note note127 = this
(* po redu: 649*)
(*649*)  
(*BRANCH END*)
from note124 and note127 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 650*)
(*650*)  (*BRANCH NAME*)
} note note128 = this
(* po redu: 651*)
(*651*)  
(*BRANCH END*)
from note123 and note128 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 652*)
(*652*)  (*BRANCH NAME*)
} note note129 = this
(* po redu: 653*)
(*653*)  
(*BRANCH END*)
from note118 and note129 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 654*)
(*654*)  (*BRANCH NAME*)
} note note130 = this
(* po redu: 655*)
(*655*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 656*)
(*656*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 657*)
(*657*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 658*)
(*658*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 659*)
(*659*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 660*)
(*660*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 661*)
(*661*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 662*)
(*662*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 663*)
(*663*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 664*)
(*664*)  (*BRANCH NAME*)
} note note131 = this
(* po redu: 665*)
(*665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 666*)
(*666*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 667*)
(*667*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 668*)
(*668*)  (*BRANCH NAME*)
} note note132 = this
(* po redu: 669*)
(*669*)  
(*BRANCH END*)
from note131 and note132 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 670*)
(*670*)  (*BRANCH NAME*)
} note note133 = this
(* po redu: 671*)
(*671*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 672*)
(*672*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 673*)
(*673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 674*)
(*674*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 675*)
(*675*)  (*BRANCH NAME*)
} note note134 = this
(* po redu: 676*)
(*676*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 677*)
(*677*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 678*)
(*678*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 679*)
(*679*)  (*BRANCH NAME*)
} note note135 = this
(* po redu: 680*)
(*680*)  
(*BRANCH END*)
from note134 and note135 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 681*)
(*681*)  (*BRANCH NAME*)
} note note136 = this
(* po redu: 682*)
(*682*)  
(*BRANCH END*)
from note133 and note136 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 683*)
(*683*)  (*BRANCH NAME*)
} note note137 = this
(* po redu: 684*)
(*684*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 685*)
(*685*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 686*)
(*686*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 687*)
(*687*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 688*)
(*688*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 689*)
(*689*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 690*)
(*690*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 691*)
(*691*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 692*)
(*692*)  (*BRANCH NAME*)
} note note138 = this
(* po redu: 693*)
(*693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 694*)
(*694*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 695*)
(*695*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 696*)
(*696*)  (*BRANCH NAME*)
} note note139 = this
(* po redu: 697*)
(*697*)  
(*BRANCH END*)
from note138 and note139 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 698*)
(*698*)  (*BRANCH NAME*)
} note note140 = this
(* po redu: 699*)
(*699*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 700*)
(*700*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 701*)
(*701*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 702*)
(*702*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 703*)
(*703*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 704*)
(*704*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 705*)
(*705*)  (*BRANCH NAME*)
} note note141 = this
(* po redu: 706*)
(*706*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 707*)
(*707*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 708*)
(*708*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 709*)
(*709*)  (*BRANCH NAME*)
} note note142 = this
(* po redu: 710*)
(*710*)  
(*BRANCH END*)
from note141 and note142 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 711*)
(*711*)  (*BRANCH NAME*)
} note note143 = this
(* po redu: 712*)
(*712*)  
(*BRANCH END*)
from note140 and note143 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 713*)
(*713*)  (*BRANCH NAME*)
} note note144 = this
(* po redu: 714*)
(*714*)  
(*BRANCH END*)
from note137 and note144 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 715*)
(*715*)  (*BRANCH NAME*)
} note note145 = this
(* po redu: 716*)
(*716*)  
(*BRANCH END*)
from note130 and note145 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 717*)
(*717*)  (*BRANCH NAME*)
} note note146 = this
(* po redu: 718*)
(*718*)  
(*BRANCH END*)
from note99 and note146 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 719*)
(*719*)  (*BRANCH NAME*)
} note note147 = this
(* po redu: 720*)
(*720*)  
(*BRANCH END*)
from note98 and note147 and `PO3 = PO5 \<or> PO3 ~= PO5`
have ?thesis
by auto
(* po redu: 721*)
(*721*)  (*BRANCH NAME*)
} note note148 = this
(* po redu: 722*)
(*722*)  
(*BRANCH END*)
from note97 and note148 and `PO1 = PO5 \<or> PO1 ~= PO5`
have ?thesis
by auto
(* po redu: 723*)
(*723*)  (*BRANCH NAME*)
} note note149 = this
(* po redu: 724*)
(*724*)  
(*BRANCH END*)
from note54 and note149 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(* po redu: 725*)
(*725*)  (*BRANCH NAME*)
} note note150 = this
(* po redu: 726*)
(*726*)  
(*BRANCH END*)
from note53 and note150 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
(* po redu: 727*)
(*727*)  (*BRANCH NAME*)
} note note151 = this
(* po redu: 728*)
(*728*)  
(*BRANCH END*)
from note52 and note151 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 729*)
(*729*)  (*BRANCH NAME*)
} note note152 = this
(* po redu: 730*)
(*730*)  
(*BRANCH END*)
from note5 and note152 and `inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2`
have ?thesis
by auto
(* po redu: 731*)
(*731*)  (*BRANCH NAME*)
} note note153 = this
(* po redu: 732*)
(*732*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 733*)
(*733*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2"
using ax_g4 [of "PO2" "LI2"]
by auto

(* po redu: 734*)
(*734*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI2"
(* po redu: 735*)
(*735*)  (*REGULAR*)
moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO2 LI2`
have  "LI1 = LI2"
using ax_I2 [of "PO1" "PO2" "LI1" "LI2"]
by auto

(* po redu: 736*)
(*736*)  (*REGULAR*)
moreover
from `LI1 = LI2` and `LI1 ~= LI2`
have False
by auto

(* po redu: 737*)
(*737*)  (*BRANCH NAME*)
} note note154 = this
(* po redu: 738*)
(*738*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI2"
(* po redu: 739*)
(*739*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(* po redu: 740*)
(*740*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(* po redu: 741*)
(*741*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(* po redu: 742*)
(*742*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(* po redu: 743*)
(*743*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

(* po redu: 744*)
(*744*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

(* po redu: 745*)
(*745*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 746*)
(*746*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 747*)
(*747*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

(* po redu: 748*)
(*748*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

(* po redu: 749*)
(*749*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

(* po redu: 750*)
(*750*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 751*)
(*751*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 752*)
(*752*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 753*)
(*753*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 754*)
(*754*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 755*)
(*755*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 756*)
(*756*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 757*)
(*757*)  (*REGULAR*)
moreover

have  "PO2 = PO5 \<or> PO2 ~= PO5"
using ax_g1 [of "PO2" "PO5"]
by auto

(* po redu: 758*)
(*758*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO5"
(* po redu: 759*)
(*759*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO5`
have False
by auto

(* po redu: 760*)
(*760*)  (*BRANCH NAME*)
} note note155 = this
(* po redu: 761*)
(*761*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO5"
(* po redu: 762*)
(*762*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 763*)
(*763*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 764*)
(*764*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI1" "PO2" "PO5"]
by auto

(* po redu: 765*)
(*765*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 766*)
(*766*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 767*)
(*767*)  (*BRANCH NAME*)
} note note156 = this
(* po redu: 768*)
(*768*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 769*)
(*769*)  (*REGULAR*)
moreover
from `PO2 ~= PO5`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO2" "PO5"]
by auto

(* po redu: 770*)
(*770*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 771*)
(*771*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO5 PL1"
using ax_I4a [of "PO1" "PO2" "PO5"]
by auto

(* po redu: 772*)
(*772*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

(* po redu: 773*)
(*773*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO5 PO5"
using ax_D1 [of "PO2" "LI3" "PO5" "PO5"]
by auto

(* po redu: 774*)
(*774*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 775*)
(*775*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 776*)
(*776*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 777*)
(*777*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 778*)
(*778*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 779*)
(*779*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 780*)
(*780*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 781*)
(*781*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 782*)
(*782*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 783*)
(*783*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 784*)
(*784*)  (*BRANCH NAME*)
} note note157 = this
(* po redu: 785*)
(*785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 786*)
(*786*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 787*)
(*787*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 788*)
(*788*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 789*)
(*789*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 790*)
(*790*)  (*BRANCH NAME*)
} note note158 = this
(* po redu: 791*)
(*791*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 792*)
(*792*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 793*)
(*793*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 794*)
(*794*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI3" "PO2" "PO5"]
by auto

(* po redu: 795*)
(*795*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 796*)
(*796*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 797*)
(*797*)  (*BRANCH NAME*)
} note note159 = this
(* po redu: 798*)
(*798*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 799*)
(*799*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 800*)
(*800*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 801*)
(*801*)  (*BRANCH NAME*)
} note note160 = this
(* po redu: 802*)
(*802*)  
(*BRANCH END*)
from note159 and note160 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 803*)
(*803*)  (*BRANCH NAME*)
} note note161 = this
(* po redu: 804*)
(*804*)  
(*BRANCH END*)
from note158 and note161 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 805*)
(*805*)  (*BRANCH NAME*)
} note note162 = this
(* po redu: 806*)
(*806*)  
(*BRANCH END*)
from note157 and note162 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 807*)
(*807*)  (*BRANCH NAME*)
} note note163 = this
(* po redu: 808*)
(*808*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 809*)
(*809*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 810*)
(*810*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 811*)
(*811*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 812*)
(*812*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 813*)
(*813*)  (*BRANCH NAME*)
} note note164 = this
(* po redu: 814*)
(*814*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 815*)
(*815*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 816*)
(*816*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 817*)
(*817*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 818*)
(*818*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 819*)
(*819*)  (*BRANCH NAME*)
} note note165 = this
(* po redu: 820*)
(*820*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 821*)
(*821*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 822*)
(*822*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 823*)
(*823*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI3" "PO2" "PO5"]
by auto

(* po redu: 824*)
(*824*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 825*)
(*825*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 826*)
(*826*)  (*BRANCH NAME*)
} note note166 = this
(* po redu: 827*)
(*827*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 828*)
(*828*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 829*)
(*829*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 830*)
(*830*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 831*)
(*831*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 832*)
(*832*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO5"]
by auto

(* po redu: 833*)
(*833*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 834*)
(*834*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 835*)
(*835*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO5"]
by auto

(* po redu: 836*)
(*836*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO5" "PO5"]
by auto

(* po redu: 837*)
(*837*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 838*)
(*838*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 839*)
(*839*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO2 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO5"]
by auto

(* po redu: 840*)
(*840*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO5" "PO5"]
by auto

(* po redu: 841*)
(*841*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO5 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 842*)
(*842*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 843*)
(*843*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO3`
have "PO2 ~= PO1"
by auto

(* po redu: 844*)
(*844*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 845*)
(*845*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 846*)
(*846*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO5` and `inc_po_l PO5 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO5" "PL1"]
by auto

(* po redu: 847*)
(*847*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 848*)
(*848*)  (*BRANCH NAME*)
} note note167 = this
(* po redu: 849*)
(*849*)  
(*BRANCH END*)
from note166 and note167 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 850*)
(*850*)  (*BRANCH NAME*)
} note note168 = this
(* po redu: 851*)
(*851*)  
(*BRANCH END*)
from note165 and note168 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 852*)
(*852*)  (*BRANCH NAME*)
} note note169 = this
(* po redu: 853*)
(*853*)  
(*BRANCH END*)
from note164 and note169 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 854*)
(*854*)  (*BRANCH NAME*)
} note note170 = this
(* po redu: 855*)
(*855*)  
(*BRANCH END*)
from note163 and note170 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 856*)
(*856*)  (*BRANCH NAME*)
} note note171 = this
(* po redu: 857*)
(*857*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 858*)
(*858*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 859*)
(*859*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 860*)
(*860*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 861*)
(*861*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 862*)
(*862*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 863*)
(*863*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 864*)
(*864*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 865*)
(*865*)  (*BRANCH NAME*)
} note note172 = this
(* po redu: 866*)
(*866*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 867*)
(*867*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 868*)
(*868*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 869*)
(*869*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 870*)
(*870*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 871*)
(*871*)  (*BRANCH NAME*)
} note note173 = this
(* po redu: 872*)
(*872*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 873*)
(*873*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 874*)
(*874*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 875*)
(*875*)  (*BRANCH NAME*)
} note note174 = this
(* po redu: 876*)
(*876*)  
(*BRANCH END*)
from note173 and note174 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 877*)
(*877*)  (*BRANCH NAME*)
} note note175 = this
(* po redu: 878*)
(*878*)  
(*BRANCH END*)
from note172 and note175 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 879*)
(*879*)  (*BRANCH NAME*)
} note note176 = this
(* po redu: 880*)
(*880*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 881*)
(*881*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 882*)
(*882*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 883*)
(*883*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 884*)
(*884*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 885*)
(*885*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 886*)
(*886*)  (*BRANCH NAME*)
} note note177 = this
(* po redu: 887*)
(*887*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 888*)
(*888*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 889*)
(*889*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 890*)
(*890*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 891*)
(*891*)  (*BRANCH NAME*)
} note note178 = this
(* po redu: 892*)
(*892*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 893*)
(*893*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 894*)
(*894*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 895*)
(*895*)  (*BRANCH NAME*)
} note note179 = this
(* po redu: 896*)
(*896*)  
(*BRANCH END*)
from note178 and note179 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 897*)
(*897*)  (*BRANCH NAME*)
} note note180 = this
(* po redu: 898*)
(*898*)  
(*BRANCH END*)
from note177 and note180 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 899*)
(*899*)  (*BRANCH NAME*)
} note note181 = this
(* po redu: 900*)
(*900*)  
(*BRANCH END*)
from note176 and note181 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 901*)
(*901*)  (*BRANCH NAME*)
} note note182 = this
(* po redu: 902*)
(*902*)  
(*BRANCH END*)
from note171 and note182 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 903*)
(*903*)  (*BRANCH NAME*)
} note note183 = this
(* po redu: 904*)
(*904*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 905*)
(*905*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 906*)
(*906*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 907*)
(*907*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 908*)
(*908*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 909*)
(*909*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 910*)
(*910*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 911*)
(*911*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 912*)
(*912*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 913*)
(*913*)  (*BRANCH NAME*)
} note note184 = this
(* po redu: 914*)
(*914*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 915*)
(*915*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 916*)
(*916*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 917*)
(*917*)  (*BRANCH NAME*)
} note note185 = this
(* po redu: 918*)
(*918*)  
(*BRANCH END*)
from note184 and note185 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 919*)
(*919*)  (*BRANCH NAME*)
} note note186 = this
(* po redu: 920*)
(*920*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 921*)
(*921*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 922*)
(*922*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 923*)
(*923*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 924*)
(*924*)  (*BRANCH NAME*)
} note note187 = this
(* po redu: 925*)
(*925*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 926*)
(*926*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 927*)
(*927*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 928*)
(*928*)  (*BRANCH NAME*)
} note note188 = this
(* po redu: 929*)
(*929*)  
(*BRANCH END*)
from note187 and note188 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 930*)
(*930*)  (*BRANCH NAME*)
} note note189 = this
(* po redu: 931*)
(*931*)  
(*BRANCH END*)
from note186 and note189 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 932*)
(*932*)  (*BRANCH NAME*)
} note note190 = this
(* po redu: 933*)
(*933*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 934*)
(*934*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 935*)
(*935*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 936*)
(*936*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 937*)
(*937*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 938*)
(*938*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 939*)
(*939*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 940*)
(*940*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 941*)
(*941*)  (*BRANCH NAME*)
} note note191 = this
(* po redu: 942*)
(*942*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 943*)
(*943*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 944*)
(*944*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 945*)
(*945*)  (*BRANCH NAME*)
} note note192 = this
(* po redu: 946*)
(*946*)  
(*BRANCH END*)
from note191 and note192 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 947*)
(*947*)  (*BRANCH NAME*)
} note note193 = this
(* po redu: 948*)
(*948*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 949*)
(*949*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 950*)
(*950*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 951*)
(*951*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 952*)
(*952*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 953*)
(*953*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 954*)
(*954*)  (*BRANCH NAME*)
} note note194 = this
(* po redu: 955*)
(*955*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 956*)
(*956*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 957*)
(*957*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 958*)
(*958*)  (*BRANCH NAME*)
} note note195 = this
(* po redu: 959*)
(*959*)  
(*BRANCH END*)
from note194 and note195 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 960*)
(*960*)  (*BRANCH NAME*)
} note note196 = this
(* po redu: 961*)
(*961*)  
(*BRANCH END*)
from note193 and note196 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 962*)
(*962*)  (*BRANCH NAME*)
} note note197 = this
(* po redu: 963*)
(*963*)  
(*BRANCH END*)
from note190 and note197 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 964*)
(*964*)  (*BRANCH NAME*)
} note note198 = this
(* po redu: 965*)
(*965*)  
(*BRANCH END*)
from note183 and note198 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 966*)
(*966*)  (*BRANCH NAME*)
} note note199 = this
(* po redu: 967*)
(*967*)  
(*BRANCH END*)
from note156 and note199 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 968*)
(*968*)  (*BRANCH NAME*)
} note note200 = this
(* po redu: 969*)
(*969*)  
(*BRANCH END*)
from note155 and note200 and `PO2 = PO5 \<or> PO2 ~= PO5`
have ?thesis
by auto
(* po redu: 970*)
(*970*)  (*BRANCH NAME*)
} note note201 = this
(* po redu: 971*)
(*971*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 972*)
(*972*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO4 PO2"
using ax_D1a [of "PO1" "PO4" "LI2" "PO2"]
by auto

(* po redu: 973*)
(*973*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 974*)
(*974*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 975*)
(*975*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO4`
have False
by auto

(* po redu: 976*)
(*976*)  (*BRANCH NAME*)
} note note202 = this
(* po redu: 977*)
(*977*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 978*)
(*978*)  (*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(* po redu: 979*)
(*979*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
(* po redu: 980*)
(*980*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

(* po redu: 981*)
(*981*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 982*)
(*982*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 983*)
(*983*)  (*BRANCH NAME*)
} note note203 = this
(* po redu: 984*)
(*984*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(* po redu: 985*)
(*985*)  (*REGULAR*)
moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(* po redu: 986*)
(*986*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 987*)
(*987*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO1" "PO2" "PO4"]
by auto

(* po redu: 988*)
(*988*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 989*)
(*989*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO4 PO5"
using ax_D1 [of "PO1" "LI2" "PO4" "PO5"]
by auto

(* po redu: 990*)
(*990*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 991*)
(*991*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO4 PO5"
using ax_D1 [of "PO4" "LI2" "PO4" "PO5"]
by auto

(* po redu: 992*)
(*992*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO5 PO5"
using ax_D1 [of "PO4" "LI2" "PO5" "PO5"]
by auto

(* po redu: 993*)
(*993*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 994*)
(*994*)  (*REGULAR*)
moreover
from `PO4 ~= PO5` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO4 PO5 PO2"
using ax_D1a [of "PO4" "PO5" "LI2" "PO2"]
by auto

(* po redu: 995*)
(*995*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 996*)
(*996*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 997*)
(*997*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI3" "PO2" "PO4"]
by auto

(* po redu: 998*)
(*998*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO4 PO4"
using ax_D1 [of "PO2" "LI3" "PO4" "PO4"]
by auto

(* po redu: 999*)
(*999*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 1000*)
(*1000*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 1001*)
(*1001*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 1002*)
(*1002*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 1003*)
(*1003*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1004*)
(*1004*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1005*)
(*1005*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1006*)
(*1006*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1007*)
(*1007*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1008*)
(*1008*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1009*)
(*1009*)  (*BRANCH NAME*)
} note note204 = this
(* po redu: 1010*)
(*1010*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1011*)
(*1011*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1012*)
(*1012*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1013*)
(*1013*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1014*)
(*1014*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1015*)
(*1015*)  (*BRANCH NAME*)
} note note205 = this
(* po redu: 1016*)
(*1016*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1017*)
(*1017*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 1018*)
(*1018*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 1019*)
(*1019*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

(* po redu: 1020*)
(*1020*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 1021*)
(*1021*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 1022*)
(*1022*)  (*BRANCH NAME*)
} note note206 = this
(* po redu: 1023*)
(*1023*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 1024*)
(*1024*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 1025*)
(*1025*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 1026*)
(*1026*)  (*BRANCH NAME*)
} note note207 = this
(* po redu: 1027*)
(*1027*)  
(*BRANCH END*)
from note206 and note207 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 1028*)
(*1028*)  (*BRANCH NAME*)
} note note208 = this
(* po redu: 1029*)
(*1029*)  
(*BRANCH END*)
from note205 and note208 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1030*)
(*1030*)  (*BRANCH NAME*)
} note note209 = this
(* po redu: 1031*)
(*1031*)  
(*BRANCH END*)
from note204 and note209 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1032*)
(*1032*)  (*BRANCH NAME*)
} note note210 = this
(* po redu: 1033*)
(*1033*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1034*)
(*1034*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1035*)
(*1035*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1036*)
(*1036*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1037*)
(*1037*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1038*)
(*1038*)  (*BRANCH NAME*)
} note note211 = this
(* po redu: 1039*)
(*1039*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1040*)
(*1040*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1041*)
(*1041*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1042*)
(*1042*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1043*)
(*1043*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1044*)
(*1044*)  (*BRANCH NAME*)
} note note212 = this
(* po redu: 1045*)
(*1045*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1046*)
(*1046*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 1047*)
(*1047*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 1048*)
(*1048*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

(* po redu: 1049*)
(*1049*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 1050*)
(*1050*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 1051*)
(*1051*)  (*BRANCH NAME*)
} note note213 = this
(* po redu: 1052*)
(*1052*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 1053*)
(*1053*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 1054*)
(*1054*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 1055*)
(*1055*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 1056*)
(*1056*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 1057*)
(*1057*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(* po redu: 1058*)
(*1058*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 1059*)
(*1059*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 1060*)
(*1060*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 1061*)
(*1061*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 1062*)
(*1062*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 1063*)
(*1063*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 1064*)
(*1064*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 1065*)
(*1065*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 1066*)
(*1066*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 1067*)
(*1067*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 1068*)
(*1068*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO3`
have "PO2 ~= PO1"
by auto

(* po redu: 1069*)
(*1069*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 1070*)
(*1070*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO5`
have "PO4 ~= PO1"
by auto

(* po redu: 1071*)
(*1071*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 1072*)
(*1072*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 1073*)
(*1073*)  (*BRANCH NAME*)
} note note214 = this
(* po redu: 1074*)
(*1074*)  
(*BRANCH END*)
from note213 and note214 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 1075*)
(*1075*)  (*BRANCH NAME*)
} note note215 = this
(* po redu: 1076*)
(*1076*)  
(*BRANCH END*)
from note212 and note215 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 1077*)
(*1077*)  (*BRANCH NAME*)
} note note216 = this
(* po redu: 1078*)
(*1078*)  
(*BRANCH END*)
from note211 and note216 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 1079*)
(*1079*)  (*BRANCH NAME*)
} note note217 = this
(* po redu: 1080*)
(*1080*)  
(*BRANCH END*)
from note210 and note217 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 1081*)
(*1081*)  (*BRANCH NAME*)
} note note218 = this
(* po redu: 1082*)
(*1082*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 1083*)
(*1083*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1084*)
(*1084*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1085*)
(*1085*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1086*)
(*1086*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1087*)
(*1087*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1088*)
(*1088*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1089*)
(*1089*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1090*)
(*1090*)  (*BRANCH NAME*)
} note note219 = this
(* po redu: 1091*)
(*1091*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1092*)
(*1092*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1093*)
(*1093*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1094*)
(*1094*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1095*)
(*1095*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1096*)
(*1096*)  (*BRANCH NAME*)
} note note220 = this
(* po redu: 1097*)
(*1097*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1098*)
(*1098*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 1099*)
(*1099*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 1100*)
(*1100*)  (*BRANCH NAME*)
} note note221 = this
(* po redu: 1101*)
(*1101*)  
(*BRANCH END*)
from note220 and note221 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1102*)
(*1102*)  (*BRANCH NAME*)
} note note222 = this
(* po redu: 1103*)
(*1103*)  
(*BRANCH END*)
from note219 and note222 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1104*)
(*1104*)  (*BRANCH NAME*)
} note note223 = this
(* po redu: 1105*)
(*1105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1106*)
(*1106*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1107*)
(*1107*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1108*)
(*1108*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1109*)
(*1109*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1110*)
(*1110*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1111*)
(*1111*)  (*BRANCH NAME*)
} note note224 = this
(* po redu: 1112*)
(*1112*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1113*)
(*1113*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1114*)
(*1114*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1115*)
(*1115*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 1116*)
(*1116*)  (*BRANCH NAME*)
} note note225 = this
(* po redu: 1117*)
(*1117*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1118*)
(*1118*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 1119*)
(*1119*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 1120*)
(*1120*)  (*BRANCH NAME*)
} note note226 = this
(* po redu: 1121*)
(*1121*)  
(*BRANCH END*)
from note225 and note226 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1122*)
(*1122*)  (*BRANCH NAME*)
} note note227 = this
(* po redu: 1123*)
(*1123*)  
(*BRANCH END*)
from note224 and note227 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1124*)
(*1124*)  (*BRANCH NAME*)
} note note228 = this
(* po redu: 1125*)
(*1125*)  
(*BRANCH END*)
from note223 and note228 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 1126*)
(*1126*)  (*BRANCH NAME*)
} note note229 = this
(* po redu: 1127*)
(*1127*)  
(*BRANCH END*)
from note218 and note229 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 1128*)
(*1128*)  (*BRANCH NAME*)
} note note230 = this
(* po redu: 1129*)
(*1129*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 1130*)
(*1130*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 1131*)
(*1131*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 1132*)
(*1132*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1133*)
(*1133*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1134*)
(*1134*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1135*)
(*1135*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1136*)
(*1136*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1137*)
(*1137*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1138*)
(*1138*)  (*BRANCH NAME*)
} note note231 = this
(* po redu: 1139*)
(*1139*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1140*)
(*1140*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1141*)
(*1141*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1142*)
(*1142*)  (*BRANCH NAME*)
} note note232 = this
(* po redu: 1143*)
(*1143*)  
(*BRANCH END*)
from note231 and note232 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1144*)
(*1144*)  (*BRANCH NAME*)
} note note233 = this
(* po redu: 1145*)
(*1145*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1146*)
(*1146*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1147*)
(*1147*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1148*)
(*1148*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 1149*)
(*1149*)  (*BRANCH NAME*)
} note note234 = this
(* po redu: 1150*)
(*1150*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1151*)
(*1151*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1152*)
(*1152*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1153*)
(*1153*)  (*BRANCH NAME*)
} note note235 = this
(* po redu: 1154*)
(*1154*)  
(*BRANCH END*)
from note234 and note235 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1155*)
(*1155*)  (*BRANCH NAME*)
} note note236 = this
(* po redu: 1156*)
(*1156*)  
(*BRANCH END*)
from note233 and note236 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 1157*)
(*1157*)  (*BRANCH NAME*)
} note note237 = this
(* po redu: 1158*)
(*1158*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 1159*)
(*1159*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1160*)
(*1160*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1161*)
(*1161*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1162*)
(*1162*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1163*)
(*1163*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1164*)
(*1164*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1165*)
(*1165*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1166*)
(*1166*)  (*BRANCH NAME*)
} note note238 = this
(* po redu: 1167*)
(*1167*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1168*)
(*1168*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1169*)
(*1169*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1170*)
(*1170*)  (*BRANCH NAME*)
} note note239 = this
(* po redu: 1171*)
(*1171*)  
(*BRANCH END*)
from note238 and note239 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1172*)
(*1172*)  (*BRANCH NAME*)
} note note240 = this
(* po redu: 1173*)
(*1173*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1174*)
(*1174*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1175*)
(*1175*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1176*)
(*1176*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1177*)
(*1177*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1178*)
(*1178*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1179*)
(*1179*)  (*BRANCH NAME*)
} note note241 = this
(* po redu: 1180*)
(*1180*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1181*)
(*1181*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1182*)
(*1182*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1183*)
(*1183*)  (*BRANCH NAME*)
} note note242 = this
(* po redu: 1184*)
(*1184*)  
(*BRANCH END*)
from note241 and note242 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1185*)
(*1185*)  (*BRANCH NAME*)
} note note243 = this
(* po redu: 1186*)
(*1186*)  
(*BRANCH END*)
from note240 and note243 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 1187*)
(*1187*)  (*BRANCH NAME*)
} note note244 = this
(* po redu: 1188*)
(*1188*)  
(*BRANCH END*)
from note237 and note244 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 1189*)
(*1189*)  (*BRANCH NAME*)
} note note245 = this
(* po redu: 1190*)
(*1190*)  
(*BRANCH END*)
from note230 and note245 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 1191*)
(*1191*)  (*BRANCH NAME*)
} note note246 = this
(* po redu: 1192*)
(*1192*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 1193*)
(*1193*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 1194*)
(*1194*)  (*REGULAR*)
moreover

have  "PO2 = PO5 \<or> PO2 ~= PO5"
using ax_g1 [of "PO2" "PO5"]
by auto

(* po redu: 1195*)
(*1195*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO5"
(* po redu: 1196*)
(*1196*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO5`
have False
by auto

(* po redu: 1197*)
(*1197*)  (*BRANCH NAME*)
} note note247 = this
(* po redu: 1198*)
(*1198*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO5"
(* po redu: 1199*)
(*1199*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 1200*)
(*1200*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 1201*)
(*1201*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI1" "PO2" "PO5"]
by auto

(* po redu: 1202*)
(*1202*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 1203*)
(*1203*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 1204*)
(*1204*)  (*BRANCH NAME*)
} note note248 = this
(* po redu: 1205*)
(*1205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 1206*)
(*1206*)  (*REGULAR*)
moreover
from `PO2 ~= PO5`
obtain  LI4::line
where "inc_po_l PO2 LI4" and "inc_po_l PO5 LI4"
using ax_I1 [of "PO2" "PO5"]
by auto

(* po redu: 1207*)
(*1207*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 1208*)
(*1208*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5`
obtain  PL2::plane
where "inc_po_pl PO1 PL2" and "inc_po_pl PO2 PL2" and "inc_po_pl PO5 PL2"
using ax_I4a [of "PO1" "PO2" "PO5"]
by auto

(* po redu: 1209*)
(*1209*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

(* po redu: 1210*)
(*1210*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO4 PO5`
obtain  PL3::plane
where "inc_po_pl PO2 PL3" and "inc_po_pl PO4 PL3" and "inc_po_pl PO5 PL3"
using ax_I4a [of "PO2" "PO4" "PO5"]
by auto

(* po redu: 1211*)
(*1211*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI3" "PO2" "PO4"]
by auto

(* po redu: 1212*)
(*1212*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO4 PO4"
using ax_D1 [of "PO2" "LI3" "PO4" "PO4"]
by auto

(* po redu: 1213*)
(*1213*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 1214*)
(*1214*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 1215*)
(*1215*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 1216*)
(*1216*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 1217*)
(*1217*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1218*)
(*1218*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1219*)
(*1219*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1220*)
(*1220*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1221*)
(*1221*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1222*)
(*1222*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1223*)
(*1223*)  (*BRANCH NAME*)
} note note249 = this
(* po redu: 1224*)
(*1224*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1225*)
(*1225*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1226*)
(*1226*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1227*)
(*1227*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1228*)
(*1228*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1229*)
(*1229*)  (*BRANCH NAME*)
} note note250 = this
(* po redu: 1230*)
(*1230*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1231*)
(*1231*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 1232*)
(*1232*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 1233*)
(*1233*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

(* po redu: 1234*)
(*1234*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 1235*)
(*1235*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 1236*)
(*1236*)  (*BRANCH NAME*)
} note note251 = this
(* po redu: 1237*)
(*1237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 1238*)
(*1238*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

(* po redu: 1239*)
(*1239*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
(* po redu: 1240*)
(*1240*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

(* po redu: 1241*)
(*1241*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO4 PO5"
using ax_D1 [of "PO2" "LI3" "PO4" "PO5"]
by auto

(* po redu: 1242*)
(*1242*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

(* po redu: 1243*)
(*1243*)  (*REGULAR*)
moreover
from `col PO2 PO4 PO5` and `\<not>col PO2 PO4 PO5`
have False
by auto

(* po redu: 1244*)
(*1244*)  (*BRANCH NAME*)
} note note252 = this
(* po redu: 1245*)
(*1245*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
(* po redu: 1246*)
(*1246*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 1247*)
(*1247*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 1248*)
(*1248*)  (*BRANCH NAME*)
} note note253 = this
(* po redu: 1249*)
(*1249*)  
(*BRANCH END*)
from note252 and note253 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have False
by auto
(* po redu: 1250*)
(*1250*)  (*BRANCH NAME*)
} note note254 = this
(* po redu: 1251*)
(*1251*)  
(*BRANCH END*)
from note251 and note254 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 1252*)
(*1252*)  (*BRANCH NAME*)
} note note255 = this
(* po redu: 1253*)
(*1253*)  
(*BRANCH END*)
from note250 and note255 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1254*)
(*1254*)  (*BRANCH NAME*)
} note note256 = this
(* po redu: 1255*)
(*1255*)  
(*BRANCH END*)
from note249 and note256 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1256*)
(*1256*)  (*BRANCH NAME*)
} note note257 = this
(* po redu: 1257*)
(*1257*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1258*)
(*1258*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1259*)
(*1259*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1260*)
(*1260*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1261*)
(*1261*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1262*)
(*1262*)  (*BRANCH NAME*)
} note note258 = this
(* po redu: 1263*)
(*1263*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1264*)
(*1264*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1265*)
(*1265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1266*)
(*1266*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1267*)
(*1267*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1268*)
(*1268*)  (*BRANCH NAME*)
} note note259 = this
(* po redu: 1269*)
(*1269*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1270*)
(*1270*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 1271*)
(*1271*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 1272*)
(*1272*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

(* po redu: 1273*)
(*1273*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 1274*)
(*1274*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 1275*)
(*1275*)  (*BRANCH NAME*)
} note note260 = this
(* po redu: 1276*)
(*1276*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 1277*)
(*1277*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

(* po redu: 1278*)
(*1278*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
(* po redu: 1279*)
(*1279*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

(* po redu: 1280*)
(*1280*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO4 PO5"
using ax_D1 [of "PO2" "LI3" "PO4" "PO5"]
by auto

(* po redu: 1281*)
(*1281*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

(* po redu: 1282*)
(*1282*)  (*REGULAR*)
moreover
from `col PO2 PO4 PO5` and `\<not>col PO2 PO4 PO5`
have False
by auto

(* po redu: 1283*)
(*1283*)  (*BRANCH NAME*)
} note note261 = this
(* po redu: 1284*)
(*1284*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
(* po redu: 1285*)
(*1285*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 1286*)
(*1286*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 1287*)
(*1287*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 1288*)
(*1288*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 1289*)
(*1289*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(* po redu: 1290*)
(*1290*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 1291*)
(*1291*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 1292*)
(*1292*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 1293*)
(*1293*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 1294*)
(*1294*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 1295*)
(*1295*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 1296*)
(*1296*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 1297*)
(*1297*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 1298*)
(*1298*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 1299*)
(*1299*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 1300*)
(*1300*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO3`
have "PO2 ~= PO1"
by auto

(* po redu: 1301*)
(*1301*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 1302*)
(*1302*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 1303*)
(*1303*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 1304*)
(*1304*)  (*BRANCH NAME*)
} note note262 = this
(* po redu: 1305*)
(*1305*)  
(*BRANCH END*)
from note261 and note262 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have ?thesis
by auto
(* po redu: 1306*)
(*1306*)  (*BRANCH NAME*)
} note note263 = this
(* po redu: 1307*)
(*1307*)  
(*BRANCH END*)
from note260 and note263 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 1308*)
(*1308*)  (*BRANCH NAME*)
} note note264 = this
(* po redu: 1309*)
(*1309*)  
(*BRANCH END*)
from note259 and note264 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 1310*)
(*1310*)  (*BRANCH NAME*)
} note note265 = this
(* po redu: 1311*)
(*1311*)  
(*BRANCH END*)
from note258 and note265 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 1312*)
(*1312*)  (*BRANCH NAME*)
} note note266 = this
(* po redu: 1313*)
(*1313*)  
(*BRANCH END*)
from note257 and note266 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 1314*)
(*1314*)  (*BRANCH NAME*)
} note note267 = this
(* po redu: 1315*)
(*1315*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 1316*)
(*1316*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1317*)
(*1317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1318*)
(*1318*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1319*)
(*1319*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1320*)
(*1320*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1321*)
(*1321*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1322*)
(*1322*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1323*)
(*1323*)  (*BRANCH NAME*)
} note note268 = this
(* po redu: 1324*)
(*1324*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1325*)
(*1325*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1326*)
(*1326*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1327*)
(*1327*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1328*)
(*1328*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1329*)
(*1329*)  (*BRANCH NAME*)
} note note269 = this
(* po redu: 1330*)
(*1330*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1331*)
(*1331*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 1332*)
(*1332*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 1333*)
(*1333*)  (*BRANCH NAME*)
} note note270 = this
(* po redu: 1334*)
(*1334*)  
(*BRANCH END*)
from note269 and note270 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1335*)
(*1335*)  (*BRANCH NAME*)
} note note271 = this
(* po redu: 1336*)
(*1336*)  
(*BRANCH END*)
from note268 and note271 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1337*)
(*1337*)  (*BRANCH NAME*)
} note note272 = this
(* po redu: 1338*)
(*1338*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1339*)
(*1339*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1340*)
(*1340*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1341*)
(*1341*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1342*)
(*1342*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1343*)
(*1343*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1344*)
(*1344*)  (*BRANCH NAME*)
} note note273 = this
(* po redu: 1345*)
(*1345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1346*)
(*1346*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1347*)
(*1347*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1348*)
(*1348*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 1349*)
(*1349*)  (*BRANCH NAME*)
} note note274 = this
(* po redu: 1350*)
(*1350*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1351*)
(*1351*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 1352*)
(*1352*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 1353*)
(*1353*)  (*BRANCH NAME*)
} note note275 = this
(* po redu: 1354*)
(*1354*)  
(*BRANCH END*)
from note274 and note275 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1355*)
(*1355*)  (*BRANCH NAME*)
} note note276 = this
(* po redu: 1356*)
(*1356*)  
(*BRANCH END*)
from note273 and note276 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1357*)
(*1357*)  (*BRANCH NAME*)
} note note277 = this
(* po redu: 1358*)
(*1358*)  
(*BRANCH END*)
from note272 and note277 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 1359*)
(*1359*)  (*BRANCH NAME*)
} note note278 = this
(* po redu: 1360*)
(*1360*)  
(*BRANCH END*)
from note267 and note278 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 1361*)
(*1361*)  (*BRANCH NAME*)
} note note279 = this
(* po redu: 1362*)
(*1362*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 1363*)
(*1363*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 1364*)
(*1364*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 1365*)
(*1365*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1366*)
(*1366*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1367*)
(*1367*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1368*)
(*1368*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1369*)
(*1369*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1370*)
(*1370*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1371*)
(*1371*)  (*BRANCH NAME*)
} note note280 = this
(* po redu: 1372*)
(*1372*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1373*)
(*1373*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1374*)
(*1374*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1375*)
(*1375*)  (*BRANCH NAME*)
} note note281 = this
(* po redu: 1376*)
(*1376*)  
(*BRANCH END*)
from note280 and note281 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1377*)
(*1377*)  (*BRANCH NAME*)
} note note282 = this
(* po redu: 1378*)
(*1378*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1379*)
(*1379*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1380*)
(*1380*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1381*)
(*1381*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 1382*)
(*1382*)  (*BRANCH NAME*)
} note note283 = this
(* po redu: 1383*)
(*1383*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1384*)
(*1384*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1385*)
(*1385*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1386*)
(*1386*)  (*BRANCH NAME*)
} note note284 = this
(* po redu: 1387*)
(*1387*)  
(*BRANCH END*)
from note283 and note284 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1388*)
(*1388*)  (*BRANCH NAME*)
} note note285 = this
(* po redu: 1389*)
(*1389*)  
(*BRANCH END*)
from note282 and note285 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 1390*)
(*1390*)  (*BRANCH NAME*)
} note note286 = this
(* po redu: 1391*)
(*1391*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 1392*)
(*1392*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1393*)
(*1393*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1394*)
(*1394*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1395*)
(*1395*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1396*)
(*1396*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1397*)
(*1397*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1398*)
(*1398*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1399*)
(*1399*)  (*BRANCH NAME*)
} note note287 = this
(* po redu: 1400*)
(*1400*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1401*)
(*1401*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1402*)
(*1402*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1403*)
(*1403*)  (*BRANCH NAME*)
} note note288 = this
(* po redu: 1404*)
(*1404*)  
(*BRANCH END*)
from note287 and note288 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1405*)
(*1405*)  (*BRANCH NAME*)
} note note289 = this
(* po redu: 1406*)
(*1406*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1407*)
(*1407*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1408*)
(*1408*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1409*)
(*1409*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1410*)
(*1410*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1411*)
(*1411*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1412*)
(*1412*)  (*BRANCH NAME*)
} note note290 = this
(* po redu: 1413*)
(*1413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1414*)
(*1414*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1415*)
(*1415*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1416*)
(*1416*)  (*BRANCH NAME*)
} note note291 = this
(* po redu: 1417*)
(*1417*)  
(*BRANCH END*)
from note290 and note291 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1418*)
(*1418*)  (*BRANCH NAME*)
} note note292 = this
(* po redu: 1419*)
(*1419*)  
(*BRANCH END*)
from note289 and note292 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 1420*)
(*1420*)  (*BRANCH NAME*)
} note note293 = this
(* po redu: 1421*)
(*1421*)  
(*BRANCH END*)
from note286 and note293 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 1422*)
(*1422*)  (*BRANCH NAME*)
} note note294 = this
(* po redu: 1423*)
(*1423*)  
(*BRANCH END*)
from note279 and note294 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 1424*)
(*1424*)  (*BRANCH NAME*)
} note note295 = this
(* po redu: 1425*)
(*1425*)  
(*BRANCH END*)
from note248 and note295 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 1426*)
(*1426*)  (*BRANCH NAME*)
} note note296 = this
(* po redu: 1427*)
(*1427*)  
(*BRANCH END*)
from note247 and note296 and `PO2 = PO5 \<or> PO2 ~= PO5`
have ?thesis
by auto
(* po redu: 1428*)
(*1428*)  (*BRANCH NAME*)
} note note297 = this
(* po redu: 1429*)
(*1429*)  
(*BRANCH END*)
from note246 and note297 and `PO1 = PO5 \<or> PO1 ~= PO5`
have ?thesis
by auto
(* po redu: 1430*)
(*1430*)  (*BRANCH NAME*)
} note note298 = this
(* po redu: 1431*)
(*1431*)  
(*BRANCH END*)
from note203 and note298 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(* po redu: 1432*)
(*1432*)  (*BRANCH NAME*)
} note note299 = this
(* po redu: 1433*)
(*1433*)  
(*BRANCH END*)
from note202 and note299 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 1434*)
(*1434*)  (*BRANCH NAME*)
} note note300 = this
(* po redu: 1435*)
(*1435*)  
(*BRANCH END*)
from note201 and note300 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 1436*)
(*1436*)  (*BRANCH NAME*)
} note note301 = this
(* po redu: 1437*)
(*1437*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 1438*)
(*1438*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2"
using ax_g4 [of "PO3" "LI2"]
by auto

(* po redu: 1439*)
(*1439*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI2"
(* po redu: 1440*)
(*1440*)  (*REGULAR*)
moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO3 PO2"
using ax_D1a [of "PO1" "PO3" "LI2" "PO2"]
by auto

(* po redu: 1441*)
(*1441*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_132 [of "PO1" "PO3" "PO2"]
by auto

(* po redu: 1442*)
(*1442*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3`
have  "\<not>col PO1 PO3 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO3"]
by auto

(* po redu: 1443*)
(*1443*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO3`
have  "col PO1 PO3 PO2"
using ax_col_132 [of "PO1" "PO2" "PO3"]
by auto

(* po redu: 1444*)
(*1444*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2` and `col PO1 PO3 PO2`
have False
by auto

(* po redu: 1445*)
(*1445*)  (*BRANCH NAME*)
} note note302 = this
(* po redu: 1446*)
(*1446*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI2"
(* po redu: 1447*)
(*1447*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

(* po redu: 1448*)
(*1448*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

(* po redu: 1449*)
(*1449*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

(* po redu: 1450*)
(*1450*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 1451*)
(*1451*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 1452*)
(*1452*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 1453*)
(*1453*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 1454*)
(*1454*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 1455*)
(*1455*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 1456*)
(*1456*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 1457*)
(*1457*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 1458*)
(*1458*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 1459*)
(*1459*)  (*REGULAR*)
moreover

have  "PO2 = PO5 \<or> PO2 ~= PO5"
using ax_g1 [of "PO2" "PO5"]
by auto

(* po redu: 1460*)
(*1460*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO5"
(* po redu: 1461*)
(*1461*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO5`
have False
by auto

(* po redu: 1462*)
(*1462*)  (*BRANCH NAME*)
} note note303 = this
(* po redu: 1463*)
(*1463*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO5"
(* po redu: 1464*)
(*1464*)  (*REGULAR*)
moreover

have  "PO3 = PO5 \<or> PO3 ~= PO5"
using ax_g1 [of "PO3" "PO5"]
by auto

(* po redu: 1465*)
(*1465*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO5"
(* po redu: 1466*)
(*1466*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO5`
have False
by auto

(* po redu: 1467*)
(*1467*)  (*BRANCH NAME*)
} note note304 = this
(* po redu: 1468*)
(*1468*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO5"
(* po redu: 1469*)
(*1469*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 1470*)
(*1470*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 1471*)
(*1471*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI1" "PO2" "PO5"]
by auto

(* po redu: 1472*)
(*1472*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 1473*)
(*1473*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 1474*)
(*1474*)  (*BRANCH NAME*)
} note note305 = this
(* po redu: 1475*)
(*1475*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 1476*)
(*1476*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO5 LI1`
have  "\<not>col PO2 PO3 PO5"
using ax_D1a [of "PO2" "PO3" "LI1" "PO5"]
by auto

(* po redu: 1477*)
(*1477*)  (*REGULAR*)
moreover
from `PO2 ~= PO5`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO2" "PO5"]
by auto

(* po redu: 1478*)
(*1478*)  (*REGULAR*)
moreover
from `PO3 ~= PO5`
obtain  LI4::line
where "inc_po_l PO3 LI4" and "inc_po_l PO5 LI4"
using ax_I1 [of "PO3" "PO5"]
by auto

(* po redu: 1479*)
(*1479*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 1480*)
(*1480*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO5 PL1"
using ax_I4a [of "PO1" "PO2" "PO5"]
by auto

(* po redu: 1481*)
(*1481*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 1482*)
(*1482*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5`
obtain  PL2::plane
where "inc_po_pl PO1 PL2" and "inc_po_pl PO3 PL2" and "inc_po_pl PO5 PL2"
using ax_I4a [of "PO1" "PO3" "PO5"]
by auto

(* po redu: 1483*)
(*1483*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO5`
obtain  PL3::plane
where "inc_po_pl PO2 PL3" and "inc_po_pl PO3 PL3" and "inc_po_pl PO5 PL3"
using ax_I4a [of "PO2" "PO3" "PO5"]
by auto

(* po redu: 1484*)
(*1484*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

(* po redu: 1485*)
(*1485*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO5 PO5"
using ax_D1 [of "PO2" "LI3" "PO5" "PO5"]
by auto

(* po redu: 1486*)
(*1486*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 1487*)
(*1487*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 1488*)
(*1488*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 1489*)
(*1489*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 1490*)
(*1490*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1491*)
(*1491*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1492*)
(*1492*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1493*)
(*1493*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1494*)
(*1494*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1495*)
(*1495*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1496*)
(*1496*)  (*BRANCH NAME*)
} note note306 = this
(* po redu: 1497*)
(*1497*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1498*)
(*1498*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1499*)
(*1499*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1500*)
(*1500*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1501*)
(*1501*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1502*)
(*1502*)  (*BRANCH NAME*)
} note note307 = this
(* po redu: 1503*)
(*1503*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1504*)
(*1504*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 1505*)
(*1505*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 1506*)
(*1506*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI3" "PO2" "PO5"]
by auto

(* po redu: 1507*)
(*1507*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 1508*)
(*1508*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 1509*)
(*1509*)  (*BRANCH NAME*)
} note note308 = this
(* po redu: 1510*)
(*1510*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 1511*)
(*1511*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 1512*)
(*1512*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 1513*)
(*1513*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO3 PO5"
using ax_D1 [of "PO2" "LI3" "PO3" "PO5"]
by auto

(* po redu: 1514*)
(*1514*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO5` and `\<not>col PO2 PO3 PO5`
have False
by auto

(* po redu: 1515*)
(*1515*)  (*BRANCH NAME*)
} note note309 = this
(* po redu: 1516*)
(*1516*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 1517*)
(*1517*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 1518*)
(*1518*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 1519*)
(*1519*)  (*BRANCH NAME*)
} note note310 = this
(* po redu: 1520*)
(*1520*)  
(*BRANCH END*)
from note309 and note310 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have False
by auto
(* po redu: 1521*)
(*1521*)  (*BRANCH NAME*)
} note note311 = this
(* po redu: 1522*)
(*1522*)  
(*BRANCH END*)
from note308 and note311 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 1523*)
(*1523*)  (*BRANCH NAME*)
} note note312 = this
(* po redu: 1524*)
(*1524*)  
(*BRANCH END*)
from note307 and note312 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1525*)
(*1525*)  (*BRANCH NAME*)
} note note313 = this
(* po redu: 1526*)
(*1526*)  
(*BRANCH END*)
from note306 and note313 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1527*)
(*1527*)  (*BRANCH NAME*)
} note note314 = this
(* po redu: 1528*)
(*1528*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 1529*)
(*1529*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1530*)
(*1530*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1531*)
(*1531*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1532*)
(*1532*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1533*)
(*1533*)  (*BRANCH NAME*)
} note note315 = this
(* po redu: 1534*)
(*1534*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1535*)
(*1535*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1536*)
(*1536*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1537*)
(*1537*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1538*)
(*1538*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1539*)
(*1539*)  (*BRANCH NAME*)
} note note316 = this
(* po redu: 1540*)
(*1540*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1541*)
(*1541*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 1542*)
(*1542*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 1543*)
(*1543*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI3" "PO2" "PO5"]
by auto

(* po redu: 1544*)
(*1544*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 1545*)
(*1545*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 1546*)
(*1546*)  (*BRANCH NAME*)
} note note317 = this
(* po redu: 1547*)
(*1547*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 1548*)
(*1548*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 1549*)
(*1549*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 1550*)
(*1550*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO3 PO5"
using ax_D1 [of "PO2" "LI3" "PO3" "PO5"]
by auto

(* po redu: 1551*)
(*1551*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO5` and `\<not>col PO2 PO3 PO5`
have False
by auto

(* po redu: 1552*)
(*1552*)  (*BRANCH NAME*)
} note note318 = this
(* po redu: 1553*)
(*1553*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 1554*)
(*1554*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI4" "PO3" "PO5"]
by auto

(* po redu: 1555*)
(*1555*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO5 PO5"
using ax_D1 [of "PO3" "LI4" "PO5" "PO5"]
by auto

(* po redu: 1556*)
(*1556*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4"
using ax_D6a [of "LI1" "LI4"]
by auto

(* po redu: 1557*)
(*1557*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI4"
(* po redu: 1558*)
(*1558*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 1559*)
(*1559*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 1560*)
(*1560*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 1561*)
(*1561*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 1562*)
(*1562*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 1563*)
(*1563*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 1564*)
(*1564*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1565*)
(*1565*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1566*)
(*1566*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1567*)
(*1567*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1568*)
(*1568*)  (*BRANCH NAME*)
} note note319 = this
(* po redu: 1569*)
(*1569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1570*)
(*1570*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1571*)
(*1571*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1572*)
(*1572*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1573*)
(*1573*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1574*)
(*1574*)  (*BRANCH NAME*)
} note note320 = this
(* po redu: 1575*)
(*1575*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1576*)
(*1576*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 1577*)
(*1577*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 1578*)
(*1578*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 1579*)
(*1579*)  (*BRANCH NAME*)
} note note321 = this
(* po redu: 1580*)
(*1580*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 1581*)
(*1581*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

(* po redu: 1582*)
(*1582*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
(* po redu: 1583*)
(*1583*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI4" "PO3" "PO5"]
by auto

(* po redu: 1584*)
(*1584*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 1585*)
(*1585*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

(* po redu: 1586*)
(*1586*)  (*BRANCH NAME*)
} note note322 = this
(* po redu: 1587*)
(*1587*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
(* po redu: 1588*)
(*1588*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

(* po redu: 1589*)
(*1589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
(* po redu: 1590*)
(*1590*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO2 PO3 PO5"
using ax_D1 [of "PO2" "LI4" "PO3" "PO5"]
by auto

(* po redu: 1591*)
(*1591*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO5` and `\<not>col PO2 PO3 PO5`
have False
by auto

(* po redu: 1592*)
(*1592*)  (*BRANCH NAME*)
} note note323 = this
(* po redu: 1593*)
(*1593*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
(* po redu: 1594*)
(*1594*)  (*REGULAR*)
moreover
from `int_l_l LI4 LI4`
obtain  PO6::point
where "inc_po_l PO6 LI4" and "inc_po_l PO6 LI4" and "LI4 ~= LI4"
using ax_D6 [of "LI4" "LI4"]
by auto

(* po redu: 1595*)
(*1595*)  (*REGULAR*)
moreover
from `LI4 ~= LI4`
have False
by auto

(* po redu: 1596*)
(*1596*)  (*BRANCH NAME*)
} note note324 = this
(* po redu: 1597*)
(*1597*)  
(*BRANCH END*)
from note323 and note324 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have False
by auto
(* po redu: 1598*)
(*1598*)  (*BRANCH NAME*)
} note note325 = this
(* po redu: 1599*)
(*1599*)  
(*BRANCH END*)
from note322 and note325 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have False
by auto
(* po redu: 1600*)
(*1600*)  (*BRANCH NAME*)
} note note326 = this
(* po redu: 1601*)
(*1601*)  
(*BRANCH END*)
from note321 and note326 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 1602*)
(*1602*)  (*BRANCH NAME*)
} note note327 = this
(* po redu: 1603*)
(*1603*)  
(*BRANCH END*)
from note320 and note327 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1604*)
(*1604*)  (*BRANCH NAME*)
} note note328 = this
(* po redu: 1605*)
(*1605*)  
(*BRANCH END*)
from note319 and note328 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1606*)
(*1606*)  (*BRANCH NAME*)
} note note329 = this
(* po redu: 1607*)
(*1607*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 1608*)
(*1608*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1609*)
(*1609*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1610*)
(*1610*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1611*)
(*1611*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1612*)
(*1612*)  (*BRANCH NAME*)
} note note330 = this
(* po redu: 1613*)
(*1613*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1614*)
(*1614*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1615*)
(*1615*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1616*)
(*1616*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1617*)
(*1617*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1618*)
(*1618*)  (*BRANCH NAME*)
} note note331 = this
(* po redu: 1619*)
(*1619*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1620*)
(*1620*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 1621*)
(*1621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 1622*)
(*1622*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 1623*)
(*1623*)  (*BRANCH NAME*)
} note note332 = this
(* po redu: 1624*)
(*1624*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 1625*)
(*1625*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

(* po redu: 1626*)
(*1626*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
(* po redu: 1627*)
(*1627*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI4" "PO3" "PO5"]
by auto

(* po redu: 1628*)
(*1628*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 1629*)
(*1629*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

(* po redu: 1630*)
(*1630*)  (*BRANCH NAME*)
} note note333 = this
(* po redu: 1631*)
(*1631*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
(* po redu: 1632*)
(*1632*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

(* po redu: 1633*)
(*1633*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
(* po redu: 1634*)
(*1634*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO2 PO3 PO5"
using ax_D1 [of "PO2" "LI4" "PO3" "PO5"]
by auto

(* po redu: 1635*)
(*1635*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO5` and `\<not>col PO2 PO3 PO5`
have False
by auto

(* po redu: 1636*)
(*1636*)  (*BRANCH NAME*)
} note note334 = this
(* po redu: 1637*)
(*1637*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
(* po redu: 1638*)
(*1638*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 1639*)
(*1639*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 1640*)
(*1640*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 1641*)
(*1641*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 1642*)
(*1642*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO5"]
by auto

(* po redu: 1643*)
(*1643*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 1644*)
(*1644*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 1645*)
(*1645*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO5"]
by auto

(* po redu: 1646*)
(*1646*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO5" "PO5"]
by auto

(* po redu: 1647*)
(*1647*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 1648*)
(*1648*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 1649*)
(*1649*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO2 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO5"]
by auto

(* po redu: 1650*)
(*1650*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO5" "PO5"]
by auto

(* po redu: 1651*)
(*1651*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO5 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 1652*)
(*1652*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 1653*)
(*1653*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 1654*)
(*1654*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 1655*)
(*1655*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 1656*)
(*1656*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(* po redu: 1657*)
(*1657*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 1658*)
(*1658*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO5"]
by auto

(* po redu: 1659*)
(*1659*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 1660*)
(*1660*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 1661*)
(*1661*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO5"]
by auto

(* po redu: 1662*)
(*1662*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 1663*)
(*1663*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 1664*)
(*1664*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 1665*)
(*1665*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 1666*)
(*1666*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 1667*)
(*1667*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO3 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO5"]
by auto

(* po redu: 1668*)
(*1668*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 1669*)
(*1669*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO3 PO3 PO5"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 1670*)
(*1670*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO3 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 1671*)
(*1671*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 1672*)
(*1672*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO3 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 1673*)
(*1673*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 1674*)
(*1674*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO5 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 1675*)
(*1675*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 1676*)
(*1676*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO5` and `inc_po_l PO5 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO5" "PL1"]
by auto

(* po redu: 1677*)
(*1677*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 1678*)
(*1678*)  (*BRANCH NAME*)
} note note335 = this
(* po redu: 1679*)
(*1679*)  
(*BRANCH END*)
from note334 and note335 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have ?thesis
by auto
(* po redu: 1680*)
(*1680*)  (*BRANCH NAME*)
} note note336 = this
(* po redu: 1681*)
(*1681*)  
(*BRANCH END*)
from note333 and note336 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have ?thesis
by auto
(* po redu: 1682*)
(*1682*)  (*BRANCH NAME*)
} note note337 = this
(* po redu: 1683*)
(*1683*)  
(*BRANCH END*)
from note332 and note337 and `LI3 = LI4 \<or> LI3 ~= LI4`
have ?thesis
by auto
(* po redu: 1684*)
(*1684*)  (*BRANCH NAME*)
} note note338 = this
(* po redu: 1685*)
(*1685*)  
(*BRANCH END*)
from note331 and note338 and `LI2 = LI4 \<or> LI2 ~= LI4`
have ?thesis
by auto
(* po redu: 1686*)
(*1686*)  (*BRANCH NAME*)
} note note339 = this
(* po redu: 1687*)
(*1687*)  
(*BRANCH END*)
from note330 and note339 and `LI1 = LI4 \<or> LI1 ~= LI4`
have ?thesis
by auto
(* po redu: 1688*)
(*1688*)  (*BRANCH NAME*)
} note note340 = this
(* po redu: 1689*)
(*1689*)  
(*BRANCH END*)
from note329 and note340 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have ?thesis
by auto
(* po redu: 1690*)
(*1690*)  (*BRANCH NAME*)
} note note341 = this
(* po redu: 1691*)
(*1691*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 1692*)
(*1692*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 1693*)
(*1693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 1694*)
(*1694*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1695*)
(*1695*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1696*)
(*1696*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1697*)
(*1697*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1698*)
(*1698*)  (*BRANCH NAME*)
} note note342 = this
(* po redu: 1699*)
(*1699*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1700*)
(*1700*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1701*)
(*1701*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1702*)
(*1702*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1703*)
(*1703*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1704*)
(*1704*)  (*BRANCH NAME*)
} note note343 = this
(* po redu: 1705*)
(*1705*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1706*)
(*1706*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 1707*)
(*1707*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 1708*)
(*1708*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 1709*)
(*1709*)  (*BRANCH NAME*)
} note note344 = this
(* po redu: 1710*)
(*1710*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 1711*)
(*1711*)  (*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO5"]
by auto

(* po redu: 1712*)
(*1712*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

(* po redu: 1713*)
(*1713*)  (*BRANCH NAME*)
} note note345 = this
(* po redu: 1714*)
(*1714*)  
(*BRANCH END*)
from note344 and note345 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 1715*)
(*1715*)  (*BRANCH NAME*)
} note note346 = this
(* po redu: 1716*)
(*1716*)  
(*BRANCH END*)
from note343 and note346 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1717*)
(*1717*)  (*BRANCH NAME*)
} note note347 = this
(* po redu: 1718*)
(*1718*)  
(*BRANCH END*)
from note342 and note347 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1719*)
(*1719*)  (*BRANCH NAME*)
} note note348 = this
(* po redu: 1720*)
(*1720*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 1721*)
(*1721*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1722*)
(*1722*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1723*)
(*1723*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1724*)
(*1724*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1725*)
(*1725*)  (*BRANCH NAME*)
} note note349 = this
(* po redu: 1726*)
(*1726*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1727*)
(*1727*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1728*)
(*1728*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1729*)
(*1729*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1730*)
(*1730*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1731*)
(*1731*)  (*BRANCH NAME*)
} note note350 = this
(* po redu: 1732*)
(*1732*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1733*)
(*1733*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 1734*)
(*1734*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 1735*)
(*1735*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 1736*)
(*1736*)  (*BRANCH NAME*)
} note note351 = this
(* po redu: 1737*)
(*1737*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 1738*)
(*1738*)  (*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO5"]
by auto

(* po redu: 1739*)
(*1739*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

(* po redu: 1740*)
(*1740*)  (*BRANCH NAME*)
} note note352 = this
(* po redu: 1741*)
(*1741*)  
(*BRANCH END*)
from note351 and note352 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 1742*)
(*1742*)  (*BRANCH NAME*)
} note note353 = this
(* po redu: 1743*)
(*1743*)  
(*BRANCH END*)
from note350 and note353 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1744*)
(*1744*)  (*BRANCH NAME*)
} note note354 = this
(* po redu: 1745*)
(*1745*)  
(*BRANCH END*)
from note349 and note354 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1746*)
(*1746*)  (*BRANCH NAME*)
} note note355 = this
(* po redu: 1747*)
(*1747*)  
(*BRANCH END*)
from note348 and note355 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 1748*)
(*1748*)  (*BRANCH NAME*)
} note note356 = this
(* po redu: 1749*)
(*1749*)  
(*BRANCH END*)
from note341 and note356 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have ?thesis
by auto
(* po redu: 1750*)
(*1750*)  (*BRANCH NAME*)
} note note357 = this
(* po redu: 1751*)
(*1751*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 1752*)
(*1752*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 1753*)
(*1753*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 1754*)
(*1754*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 1755*)
(*1755*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 1756*)
(*1756*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1757*)
(*1757*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1758*)
(*1758*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1759*)
(*1759*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1760*)
(*1760*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1761*)
(*1761*)  (*BRANCH NAME*)
} note note358 = this
(* po redu: 1762*)
(*1762*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1763*)
(*1763*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1764*)
(*1764*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1765*)
(*1765*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1766*)
(*1766*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1767*)
(*1767*)  (*BRANCH NAME*)
} note note359 = this
(* po redu: 1768*)
(*1768*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1769*)
(*1769*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO5"]
by auto

(* po redu: 1770*)
(*1770*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 1771*)
(*1771*)  (*BRANCH NAME*)
} note note360 = this
(* po redu: 1772*)
(*1772*)  
(*BRANCH END*)
from note359 and note360 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1773*)
(*1773*)  (*BRANCH NAME*)
} note note361 = this
(* po redu: 1774*)
(*1774*)  
(*BRANCH END*)
from note358 and note361 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1775*)
(*1775*)  (*BRANCH NAME*)
} note note362 = this
(* po redu: 1776*)
(*1776*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 1777*)
(*1777*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1778*)
(*1778*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1779*)
(*1779*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1780*)
(*1780*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1781*)
(*1781*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1782*)
(*1782*)  (*BRANCH NAME*)
} note note363 = this
(* po redu: 1783*)
(*1783*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1784*)
(*1784*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1785*)
(*1785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1786*)
(*1786*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 1787*)
(*1787*)  (*BRANCH NAME*)
} note note364 = this
(* po redu: 1788*)
(*1788*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1789*)
(*1789*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO5"]
by auto

(* po redu: 1790*)
(*1790*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 1791*)
(*1791*)  (*BRANCH NAME*)
} note note365 = this
(* po redu: 1792*)
(*1792*)  
(*BRANCH END*)
from note364 and note365 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1793*)
(*1793*)  (*BRANCH NAME*)
} note note366 = this
(* po redu: 1794*)
(*1794*)  
(*BRANCH END*)
from note363 and note366 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1795*)
(*1795*)  (*BRANCH NAME*)
} note note367 = this
(* po redu: 1796*)
(*1796*)  
(*BRANCH END*)
from note362 and note367 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 1797*)
(*1797*)  (*BRANCH NAME*)
} note note368 = this
(* po redu: 1798*)
(*1798*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 1799*)
(*1799*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 1800*)
(*1800*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 1801*)
(*1801*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1802*)
(*1802*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1803*)
(*1803*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1804*)
(*1804*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1805*)
(*1805*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1806*)
(*1806*)  (*BRANCH NAME*)
} note note369 = this
(* po redu: 1807*)
(*1807*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1808*)
(*1808*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1809*)
(*1809*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1810*)
(*1810*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1811*)
(*1811*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1812*)
(*1812*)  (*BRANCH NAME*)
} note note370 = this
(* po redu: 1813*)
(*1813*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1814*)
(*1814*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO5"]
by auto

(* po redu: 1815*)
(*1815*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 1816*)
(*1816*)  (*BRANCH NAME*)
} note note371 = this
(* po redu: 1817*)
(*1817*)  
(*BRANCH END*)
from note370 and note371 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1818*)
(*1818*)  (*BRANCH NAME*)
} note note372 = this
(* po redu: 1819*)
(*1819*)  
(*BRANCH END*)
from note369 and note372 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1820*)
(*1820*)  (*BRANCH NAME*)
} note note373 = this
(* po redu: 1821*)
(*1821*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 1822*)
(*1822*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1823*)
(*1823*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1824*)
(*1824*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1825*)
(*1825*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1826*)
(*1826*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1827*)
(*1827*)  (*BRANCH NAME*)
} note note374 = this
(* po redu: 1828*)
(*1828*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1829*)
(*1829*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1830*)
(*1830*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1831*)
(*1831*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 1832*)
(*1832*)  (*BRANCH NAME*)
} note note375 = this
(* po redu: 1833*)
(*1833*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1834*)
(*1834*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO5"]
by auto

(* po redu: 1835*)
(*1835*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 1836*)
(*1836*)  (*BRANCH NAME*)
} note note376 = this
(* po redu: 1837*)
(*1837*)  
(*BRANCH END*)
from note375 and note376 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1838*)
(*1838*)  (*BRANCH NAME*)
} note note377 = this
(* po redu: 1839*)
(*1839*)  
(*BRANCH END*)
from note374 and note377 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1840*)
(*1840*)  (*BRANCH NAME*)
} note note378 = this
(* po redu: 1841*)
(*1841*)  
(*BRANCH END*)
from note373 and note378 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 1842*)
(*1842*)  (*BRANCH NAME*)
} note note379 = this
(* po redu: 1843*)
(*1843*)  
(*BRANCH END*)
from note368 and note379 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 1844*)
(*1844*)  (*BRANCH NAME*)
} note note380 = this
(* po redu: 1845*)
(*1845*)  
(*BRANCH END*)
from note357 and note380 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have ?thesis
by auto
(* po redu: 1846*)
(*1846*)  (*BRANCH NAME*)
} note note381 = this
(* po redu: 1847*)
(*1847*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI4"
(* po redu: 1848*)
(*1848*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 1849*)
(*1849*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 1850*)
(*1850*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 1851*)
(*1851*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 1852*)
(*1852*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 1853*)
(*1853*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 1854*)
(*1854*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1855*)
(*1855*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1856*)
(*1856*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1857*)
(*1857*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1858*)
(*1858*)  (*BRANCH NAME*)
} note note382 = this
(* po redu: 1859*)
(*1859*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1860*)
(*1860*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1861*)
(*1861*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1862*)
(*1862*)  (*BRANCH NAME*)
} note note383 = this
(* po redu: 1863*)
(*1863*)  
(*BRANCH END*)
from note382 and note383 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1864*)
(*1864*)  (*BRANCH NAME*)
} note note384 = this
(* po redu: 1865*)
(*1865*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 1866*)
(*1866*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1867*)
(*1867*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1868*)
(*1868*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 1869*)
(*1869*)  (*BRANCH NAME*)
} note note385 = this
(* po redu: 1870*)
(*1870*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1871*)
(*1871*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1872*)
(*1872*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1873*)
(*1873*)  (*BRANCH NAME*)
} note note386 = this
(* po redu: 1874*)
(*1874*)  
(*BRANCH END*)
from note385 and note386 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1875*)
(*1875*)  (*BRANCH NAME*)
} note note387 = this
(* po redu: 1876*)
(*1876*)  
(*BRANCH END*)
from note384 and note387 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 1877*)
(*1877*)  (*BRANCH NAME*)
} note note388 = this
(* po redu: 1878*)
(*1878*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 1879*)
(*1879*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 1880*)
(*1880*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 1881*)
(*1881*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1882*)
(*1882*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1883*)
(*1883*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 1884*)
(*1884*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 1885*)
(*1885*)  (*BRANCH NAME*)
} note note389 = this
(* po redu: 1886*)
(*1886*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1887*)
(*1887*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1888*)
(*1888*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1889*)
(*1889*)  (*BRANCH NAME*)
} note note390 = this
(* po redu: 1890*)
(*1890*)  
(*BRANCH END*)
from note389 and note390 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1891*)
(*1891*)  (*BRANCH NAME*)
} note note391 = this
(* po redu: 1892*)
(*1892*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 1893*)
(*1893*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1894*)
(*1894*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1895*)
(*1895*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 1896*)
(*1896*)  (*BRANCH NAME*)
} note note392 = this
(* po redu: 1897*)
(*1897*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1898*)
(*1898*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1899*)
(*1899*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1900*)
(*1900*)  (*BRANCH NAME*)
} note note393 = this
(* po redu: 1901*)
(*1901*)  
(*BRANCH END*)
from note392 and note393 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1902*)
(*1902*)  (*BRANCH NAME*)
} note note394 = this
(* po redu: 1903*)
(*1903*)  
(*BRANCH END*)
from note391 and note394 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 1904*)
(*1904*)  (*BRANCH NAME*)
} note note395 = this
(* po redu: 1905*)
(*1905*)  
(*BRANCH END*)
from note388 and note395 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 1906*)
(*1906*)  (*BRANCH NAME*)
} note note396 = this
(* po redu: 1907*)
(*1907*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 1908*)
(*1908*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 1909*)
(*1909*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 1910*)
(*1910*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 1911*)
(*1911*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 1912*)
(*1912*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1913*)
(*1913*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1914*)
(*1914*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1915*)
(*1915*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1916*)
(*1916*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1917*)
(*1917*)  (*BRANCH NAME*)
} note note397 = this
(* po redu: 1918*)
(*1918*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1919*)
(*1919*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1920*)
(*1920*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1921*)
(*1921*)  (*BRANCH NAME*)
} note note398 = this
(* po redu: 1922*)
(*1922*)  
(*BRANCH END*)
from note397 and note398 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1923*)
(*1923*)  (*BRANCH NAME*)
} note note399 = this
(* po redu: 1924*)
(*1924*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 1925*)
(*1925*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1926*)
(*1926*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1927*)
(*1927*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1928*)
(*1928*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1929*)
(*1929*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1930*)
(*1930*)  (*BRANCH NAME*)
} note note400 = this
(* po redu: 1931*)
(*1931*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1932*)
(*1932*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1933*)
(*1933*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1934*)
(*1934*)  (*BRANCH NAME*)
} note note401 = this
(* po redu: 1935*)
(*1935*)  
(*BRANCH END*)
from note400 and note401 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1936*)
(*1936*)  (*BRANCH NAME*)
} note note402 = this
(* po redu: 1937*)
(*1937*)  
(*BRANCH END*)
from note399 and note402 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 1938*)
(*1938*)  (*BRANCH NAME*)
} note note403 = this
(* po redu: 1939*)
(*1939*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 1940*)
(*1940*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 1941*)
(*1941*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 1942*)
(*1942*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1943*)
(*1943*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1944*)
(*1944*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1945*)
(*1945*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1946*)
(*1946*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1947*)
(*1947*)  (*BRANCH NAME*)
} note note404 = this
(* po redu: 1948*)
(*1948*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1949*)
(*1949*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1950*)
(*1950*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1951*)
(*1951*)  (*BRANCH NAME*)
} note note405 = this
(* po redu: 1952*)
(*1952*)  
(*BRANCH END*)
from note404 and note405 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1953*)
(*1953*)  (*BRANCH NAME*)
} note note406 = this
(* po redu: 1954*)
(*1954*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 1955*)
(*1955*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1956*)
(*1956*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1957*)
(*1957*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1958*)
(*1958*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1959*)
(*1959*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1960*)
(*1960*)  (*BRANCH NAME*)
} note note407 = this
(* po redu: 1961*)
(*1961*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1962*)
(*1962*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1963*)
(*1963*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1964*)
(*1964*)  (*BRANCH NAME*)
} note note408 = this
(* po redu: 1965*)
(*1965*)  
(*BRANCH END*)
from note407 and note408 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1966*)
(*1966*)  (*BRANCH NAME*)
} note note409 = this
(* po redu: 1967*)
(*1967*)  
(*BRANCH END*)
from note406 and note409 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 1968*)
(*1968*)  (*BRANCH NAME*)
} note note410 = this
(* po redu: 1969*)
(*1969*)  
(*BRANCH END*)
from note403 and note410 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 1970*)
(*1970*)  (*BRANCH NAME*)
} note note411 = this
(* po redu: 1971*)
(*1971*)  
(*BRANCH END*)
from note396 and note411 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have False
by auto
(* po redu: 1972*)
(*1972*)  (*BRANCH NAME*)
} note note412 = this
(* po redu: 1973*)
(*1973*)  
(*BRANCH END*)
from note381 and note412 and `int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4`
have ?thesis
by auto
(* po redu: 1974*)
(*1974*)  (*BRANCH NAME*)
} note note413 = this
(* po redu: 1975*)
(*1975*)  
(*BRANCH END*)
from note318 and note413 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have ?thesis
by auto
(* po redu: 1976*)
(*1976*)  (*BRANCH NAME*)
} note note414 = this
(* po redu: 1977*)
(*1977*)  
(*BRANCH END*)
from note317 and note414 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 1978*)
(*1978*)  (*BRANCH NAME*)
} note note415 = this
(* po redu: 1979*)
(*1979*)  
(*BRANCH END*)
from note316 and note415 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 1980*)
(*1980*)  (*BRANCH NAME*)
} note note416 = this
(* po redu: 1981*)
(*1981*)  
(*BRANCH END*)
from note315 and note416 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 1982*)
(*1982*)  (*BRANCH NAME*)
} note note417 = this
(* po redu: 1983*)
(*1983*)  
(*BRANCH END*)
from note314 and note417 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 1984*)
(*1984*)  (*BRANCH NAME*)
} note note418 = this
(* po redu: 1985*)
(*1985*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 1986*)
(*1986*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 1987*)
(*1987*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 1988*)
(*1988*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1989*)
(*1989*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1990*)
(*1990*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 1991*)
(*1991*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 1992*)
(*1992*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 1993*)
(*1993*)  (*BRANCH NAME*)
} note note419 = this
(* po redu: 1994*)
(*1994*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1995*)
(*1995*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1996*)
(*1996*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1997*)
(*1997*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 1998*)
(*1998*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 1999*)
(*1999*)  (*BRANCH NAME*)
} note note420 = this
(* po redu: 2000*)
(*2000*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2001*)
(*2001*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 2002*)
(*2002*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 2003*)
(*2003*)  (*BRANCH NAME*)
} note note421 = this
(* po redu: 2004*)
(*2004*)  
(*BRANCH END*)
from note420 and note421 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 2005*)
(*2005*)  (*BRANCH NAME*)
} note note422 = this
(* po redu: 2006*)
(*2006*)  
(*BRANCH END*)
from note419 and note422 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2007*)
(*2007*)  (*BRANCH NAME*)
} note note423 = this
(* po redu: 2008*)
(*2008*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 2009*)
(*2009*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2010*)
(*2010*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2011*)
(*2011*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2012*)
(*2012*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2013*)
(*2013*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2014*)
(*2014*)  (*BRANCH NAME*)
} note note424 = this
(* po redu: 2015*)
(*2015*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2016*)
(*2016*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2017*)
(*2017*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2018*)
(*2018*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 2019*)
(*2019*)  (*BRANCH NAME*)
} note note425 = this
(* po redu: 2020*)
(*2020*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2021*)
(*2021*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 2022*)
(*2022*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 2023*)
(*2023*)  (*BRANCH NAME*)
} note note426 = this
(* po redu: 2024*)
(*2024*)  
(*BRANCH END*)
from note425 and note426 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 2025*)
(*2025*)  (*BRANCH NAME*)
} note note427 = this
(* po redu: 2026*)
(*2026*)  
(*BRANCH END*)
from note424 and note427 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2027*)
(*2027*)  (*BRANCH NAME*)
} note note428 = this
(* po redu: 2028*)
(*2028*)  
(*BRANCH END*)
from note423 and note428 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 2029*)
(*2029*)  (*BRANCH NAME*)
} note note429 = this
(* po redu: 2030*)
(*2030*)  
(*BRANCH END*)
from note418 and note429 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 2031*)
(*2031*)  (*BRANCH NAME*)
} note note430 = this
(* po redu: 2032*)
(*2032*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 2033*)
(*2033*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 2034*)
(*2034*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 2035*)
(*2035*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 2036*)
(*2036*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 2037*)
(*2037*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2038*)
(*2038*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2039*)
(*2039*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2040*)
(*2040*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2041*)
(*2041*)  (*BRANCH NAME*)
} note note431 = this
(* po redu: 2042*)
(*2042*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2043*)
(*2043*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2044*)
(*2044*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2045*)
(*2045*)  (*BRANCH NAME*)
} note note432 = this
(* po redu: 2046*)
(*2046*)  
(*BRANCH END*)
from note431 and note432 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2047*)
(*2047*)  (*BRANCH NAME*)
} note note433 = this
(* po redu: 2048*)
(*2048*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 2049*)
(*2049*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2050*)
(*2050*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2051*)
(*2051*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 2052*)
(*2052*)  (*BRANCH NAME*)
} note note434 = this
(* po redu: 2053*)
(*2053*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2054*)
(*2054*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2055*)
(*2055*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2056*)
(*2056*)  (*BRANCH NAME*)
} note note435 = this
(* po redu: 2057*)
(*2057*)  
(*BRANCH END*)
from note434 and note435 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2058*)
(*2058*)  (*BRANCH NAME*)
} note note436 = this
(* po redu: 2059*)
(*2059*)  
(*BRANCH END*)
from note433 and note436 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 2060*)
(*2060*)  (*BRANCH NAME*)
} note note437 = this
(* po redu: 2061*)
(*2061*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 2062*)
(*2062*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 2063*)
(*2063*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 2064*)
(*2064*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2065*)
(*2065*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2066*)
(*2066*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2067*)
(*2067*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2068*)
(*2068*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2069*)
(*2069*)  (*BRANCH NAME*)
} note note438 = this
(* po redu: 2070*)
(*2070*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2071*)
(*2071*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2072*)
(*2072*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2073*)
(*2073*)  (*BRANCH NAME*)
} note note439 = this
(* po redu: 2074*)
(*2074*)  
(*BRANCH END*)
from note438 and note439 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2075*)
(*2075*)  (*BRANCH NAME*)
} note note440 = this
(* po redu: 2076*)
(*2076*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 2077*)
(*2077*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2078*)
(*2078*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2079*)
(*2079*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2080*)
(*2080*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2081*)
(*2081*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2082*)
(*2082*)  (*BRANCH NAME*)
} note note441 = this
(* po redu: 2083*)
(*2083*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2084*)
(*2084*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2085*)
(*2085*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2086*)
(*2086*)  (*BRANCH NAME*)
} note note442 = this
(* po redu: 2087*)
(*2087*)  
(*BRANCH END*)
from note441 and note442 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2088*)
(*2088*)  (*BRANCH NAME*)
} note note443 = this
(* po redu: 2089*)
(*2089*)  
(*BRANCH END*)
from note440 and note443 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 2090*)
(*2090*)  (*BRANCH NAME*)
} note note444 = this
(* po redu: 2091*)
(*2091*)  
(*BRANCH END*)
from note437 and note444 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 2092*)
(*2092*)  (*BRANCH NAME*)
} note note445 = this
(* po redu: 2093*)
(*2093*)  
(*BRANCH END*)
from note430 and note445 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 2094*)
(*2094*)  (*BRANCH NAME*)
} note note446 = this
(* po redu: 2095*)
(*2095*)  
(*BRANCH END*)
from note305 and note446 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 2096*)
(*2096*)  (*BRANCH NAME*)
} note note447 = this
(* po redu: 2097*)
(*2097*)  
(*BRANCH END*)
from note304 and note447 and `PO3 = PO5 \<or> PO3 ~= PO5`
have ?thesis
by auto
(* po redu: 2098*)
(*2098*)  (*BRANCH NAME*)
} note note448 = this
(* po redu: 2099*)
(*2099*)  
(*BRANCH END*)
from note303 and note448 and `PO2 = PO5 \<or> PO2 ~= PO5`
have ?thesis
by auto
(* po redu: 2100*)
(*2100*)  (*BRANCH NAME*)
} note note449 = this
(* po redu: 2101*)
(*2101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 2102*)
(*2102*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO4 PO2"
using ax_D1a [of "PO1" "PO4" "LI2" "PO2"]
by auto

(* po redu: 2103*)
(*2103*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO4 PO3"
using ax_D1a [of "PO1" "PO4" "LI2" "PO3"]
by auto

(* po redu: 2104*)
(*2104*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 2105*)
(*2105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 2106*)
(*2106*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO4`
have False
by auto

(* po redu: 2107*)
(*2107*)  (*BRANCH NAME*)
} note note450 = this
(* po redu: 2108*)
(*2108*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 2109*)
(*2109*)  (*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(* po redu: 2110*)
(*2110*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
(* po redu: 2111*)
(*2111*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO4`
have False
by auto

(* po redu: 2112*)
(*2112*)  (*BRANCH NAME*)
} note note451 = this
(* po redu: 2113*)
(*2113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
(* po redu: 2114*)
(*2114*)  (*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(* po redu: 2115*)
(*2115*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
(* po redu: 2116*)
(*2116*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

(* po redu: 2117*)
(*2117*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 2118*)
(*2118*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 2119*)
(*2119*)  (*BRANCH NAME*)
} note note452 = this
(* po redu: 2120*)
(*2120*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(* po redu: 2121*)
(*2121*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO4 LI1`
have  "\<not>col PO2 PO3 PO4"
using ax_D1a [of "PO2" "PO3" "LI1" "PO4"]
by auto

(* po redu: 2122*)
(*2122*)  (*REGULAR*)
moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(* po redu: 2123*)
(*2123*)  (*REGULAR*)
moreover
from `PO3 ~= PO4`
obtain  LI4::line
where "inc_po_l PO3 LI4" and "inc_po_l PO4 LI4"
using ax_I1 [of "PO3" "PO4"]
by auto

(* po redu: 2124*)
(*2124*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 2125*)
(*2125*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO1" "PO2" "PO4"]
by auto

(* po redu: 2126*)
(*2126*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 2127*)
(*2127*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO4`
obtain  PL2::plane
where "inc_po_pl PO1 PL2" and "inc_po_pl PO3 PL2" and "inc_po_pl PO4 PL2"
using ax_I4a [of "PO1" "PO3" "PO4"]
by auto

(* po redu: 2128*)
(*2128*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO4`
obtain  PL3::plane
where "inc_po_pl PO2 PL3" and "inc_po_pl PO3 PL3" and "inc_po_pl PO4 PL3"
using ax_I4a [of "PO2" "PO3" "PO4"]
by auto

(* po redu: 2129*)
(*2129*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 2130*)
(*2130*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO4 PO5"
using ax_D1 [of "PO1" "LI2" "PO4" "PO5"]
by auto

(* po redu: 2131*)
(*2131*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 2132*)
(*2132*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO4 PO5"
using ax_D1 [of "PO4" "LI2" "PO4" "PO5"]
by auto

(* po redu: 2133*)
(*2133*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO5 PO5"
using ax_D1 [of "PO4" "LI2" "PO5" "PO5"]
by auto

(* po redu: 2134*)
(*2134*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 2135*)
(*2135*)  (*REGULAR*)
moreover
from `PO4 ~= PO5` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO4 PO5 PO2"
using ax_D1a [of "PO4" "PO5" "LI2" "PO2"]
by auto

(* po redu: 2136*)
(*2136*)  (*REGULAR*)
moreover
from `PO4 ~= PO5` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO4 PO5 PO3"
using ax_D1a [of "PO4" "PO5" "LI2" "PO3"]
by auto

(* po redu: 2137*)
(*2137*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 2138*)
(*2138*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 2139*)
(*2139*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI3" "PO2" "PO4"]
by auto

(* po redu: 2140*)
(*2140*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO4 PO4"
using ax_D1 [of "PO2" "LI3" "PO4" "PO4"]
by auto

(* po redu: 2141*)
(*2141*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 2142*)
(*2142*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 2143*)
(*2143*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 2144*)
(*2144*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 2145*)
(*2145*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 2146*)
(*2146*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 2147*)
(*2147*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2148*)
(*2148*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2149*)
(*2149*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2150*)
(*2150*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2151*)
(*2151*)  (*BRANCH NAME*)
} note note453 = this
(* po redu: 2152*)
(*2152*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2153*)
(*2153*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2154*)
(*2154*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2155*)
(*2155*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2156*)
(*2156*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2157*)
(*2157*)  (*BRANCH NAME*)
} note note454 = this
(* po redu: 2158*)
(*2158*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2159*)
(*2159*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 2160*)
(*2160*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 2161*)
(*2161*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

(* po redu: 2162*)
(*2162*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 2163*)
(*2163*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 2164*)
(*2164*)  (*BRANCH NAME*)
} note note455 = this
(* po redu: 2165*)
(*2165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 2166*)
(*2166*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 2167*)
(*2167*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 2168*)
(*2168*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI3" "PO3" "PO4"]
by auto

(* po redu: 2169*)
(*2169*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2170*)
(*2170*)  (*BRANCH NAME*)
} note note456 = this
(* po redu: 2171*)
(*2171*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 2172*)
(*2172*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 2173*)
(*2173*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 2174*)
(*2174*)  (*BRANCH NAME*)
} note note457 = this
(* po redu: 2175*)
(*2175*)  
(*BRANCH END*)
from note456 and note457 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have False
by auto
(* po redu: 2176*)
(*2176*)  (*BRANCH NAME*)
} note note458 = this
(* po redu: 2177*)
(*2177*)  
(*BRANCH END*)
from note455 and note458 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 2178*)
(*2178*)  (*BRANCH NAME*)
} note note459 = this
(* po redu: 2179*)
(*2179*)  
(*BRANCH END*)
from note454 and note459 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 2180*)
(*2180*)  (*BRANCH NAME*)
} note note460 = this
(* po redu: 2181*)
(*2181*)  
(*BRANCH END*)
from note453 and note460 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2182*)
(*2182*)  (*BRANCH NAME*)
} note note461 = this
(* po redu: 2183*)
(*2183*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 2184*)
(*2184*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2185*)
(*2185*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2186*)
(*2186*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2187*)
(*2187*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2188*)
(*2188*)  (*BRANCH NAME*)
} note note462 = this
(* po redu: 2189*)
(*2189*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2190*)
(*2190*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2191*)
(*2191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2192*)
(*2192*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2193*)
(*2193*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2194*)
(*2194*)  (*BRANCH NAME*)
} note note463 = this
(* po redu: 2195*)
(*2195*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2196*)
(*2196*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 2197*)
(*2197*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 2198*)
(*2198*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

(* po redu: 2199*)
(*2199*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 2200*)
(*2200*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 2201*)
(*2201*)  (*BRANCH NAME*)
} note note464 = this
(* po redu: 2202*)
(*2202*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 2203*)
(*2203*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 2204*)
(*2204*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 2205*)
(*2205*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI3" "PO3" "PO4"]
by auto

(* po redu: 2206*)
(*2206*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2207*)
(*2207*)  (*BRANCH NAME*)
} note note465 = this
(* po redu: 2208*)
(*2208*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 2209*)
(*2209*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO3 PO3 PO4"
using ax_D1 [of "PO3" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2210*)
(*2210*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4` and `inc_po_l PO4 LI4`
have  "col PO3 PO4 PO4"
using ax_D1 [of "PO3" "LI4" "PO4" "PO4"]
by auto

(* po redu: 2211*)
(*2211*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4"
using ax_D6a [of "LI1" "LI4"]
by auto

(* po redu: 2212*)
(*2212*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI4"
(* po redu: 2213*)
(*2213*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 2214*)
(*2214*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 2215*)
(*2215*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 2216*)
(*2216*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 2217*)
(*2217*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2218*)
(*2218*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2219*)
(*2219*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2220*)
(*2220*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2221*)
(*2221*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2222*)
(*2222*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2223*)
(*2223*)  (*BRANCH NAME*)
} note note466 = this
(* po redu: 2224*)
(*2224*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2225*)
(*2225*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2226*)
(*2226*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2227*)
(*2227*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2228*)
(*2228*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2229*)
(*2229*)  (*BRANCH NAME*)
} note note467 = this
(* po redu: 2230*)
(*2230*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2231*)
(*2231*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 2232*)
(*2232*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 2233*)
(*2233*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 2234*)
(*2234*)  (*BRANCH NAME*)
} note note468 = this
(* po redu: 2235*)
(*2235*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 2236*)
(*2236*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

(* po redu: 2237*)
(*2237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
(* po redu: 2238*)
(*2238*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2239*)
(*2239*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 2240*)
(*2240*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 2241*)
(*2241*)  (*BRANCH NAME*)
} note note469 = this
(* po redu: 2242*)
(*2242*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
(* po redu: 2243*)
(*2243*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

(* po redu: 2244*)
(*2244*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
(* po redu: 2245*)
(*2245*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2246*)
(*2246*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2247*)
(*2247*)  (*BRANCH NAME*)
} note note470 = this
(* po redu: 2248*)
(*2248*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
(* po redu: 2249*)
(*2249*)  (*REGULAR*)
moreover
from `int_l_l LI4 LI4`
obtain  PO6::point
where "inc_po_l PO6 LI4" and "inc_po_l PO6 LI4" and "LI4 ~= LI4"
using ax_D6 [of "LI4" "LI4"]
by auto

(* po redu: 2250*)
(*2250*)  (*REGULAR*)
moreover
from `LI4 ~= LI4`
have False
by auto

(* po redu: 2251*)
(*2251*)  (*BRANCH NAME*)
} note note471 = this
(* po redu: 2252*)
(*2252*)  
(*BRANCH END*)
from note470 and note471 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have False
by auto
(* po redu: 2253*)
(*2253*)  (*BRANCH NAME*)
} note note472 = this
(* po redu: 2254*)
(*2254*)  
(*BRANCH END*)
from note469 and note472 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have False
by auto
(* po redu: 2255*)
(*2255*)  (*BRANCH NAME*)
} note note473 = this
(* po redu: 2256*)
(*2256*)  
(*BRANCH END*)
from note468 and note473 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 2257*)
(*2257*)  (*BRANCH NAME*)
} note note474 = this
(* po redu: 2258*)
(*2258*)  
(*BRANCH END*)
from note467 and note474 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2259*)
(*2259*)  (*BRANCH NAME*)
} note note475 = this
(* po redu: 2260*)
(*2260*)  
(*BRANCH END*)
from note466 and note475 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2261*)
(*2261*)  (*BRANCH NAME*)
} note note476 = this
(* po redu: 2262*)
(*2262*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2263*)
(*2263*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2264*)
(*2264*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2265*)
(*2265*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2266*)
(*2266*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2267*)
(*2267*)  (*BRANCH NAME*)
} note note477 = this
(* po redu: 2268*)
(*2268*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2269*)
(*2269*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2270*)
(*2270*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2271*)
(*2271*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2272*)
(*2272*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2273*)
(*2273*)  (*BRANCH NAME*)
} note note478 = this
(* po redu: 2274*)
(*2274*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2275*)
(*2275*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 2276*)
(*2276*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 2277*)
(*2277*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 2278*)
(*2278*)  (*BRANCH NAME*)
} note note479 = this
(* po redu: 2279*)
(*2279*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 2280*)
(*2280*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

(* po redu: 2281*)
(*2281*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
(* po redu: 2282*)
(*2282*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2283*)
(*2283*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 2284*)
(*2284*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 2285*)
(*2285*)  (*BRANCH NAME*)
} note note480 = this
(* po redu: 2286*)
(*2286*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
(* po redu: 2287*)
(*2287*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

(* po redu: 2288*)
(*2288*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
(* po redu: 2289*)
(*2289*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2290*)
(*2290*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2291*)
(*2291*)  (*BRANCH NAME*)
} note note481 = this
(* po redu: 2292*)
(*2292*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
(* po redu: 2293*)
(*2293*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 2294*)
(*2294*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 2295*)
(*2295*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 2296*)
(*2296*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 2297*)
(*2297*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(* po redu: 2298*)
(*2298*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 2299*)
(*2299*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 2300*)
(*2300*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 2301*)
(*2301*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 2302*)
(*2302*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 2303*)
(*2303*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 2304*)
(*2304*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 2305*)
(*2305*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 2306*)
(*2306*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 2307*)
(*2307*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 2308*)
(*2308*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 2309*)
(*2309*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 2310*)
(*2310*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 2311*)
(*2311*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(* po redu: 2312*)
(*2312*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 2313*)
(*2313*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

(* po redu: 2314*)
(*2314*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 2315*)
(*2315*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 2316*)
(*2316*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO4"]
by auto

(* po redu: 2317*)
(*2317*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 2318*)
(*2318*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 2319*)
(*2319*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 2320*)
(*2320*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 2321*)
(*2321*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 2322*)
(*2322*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO4"]
by auto

(* po redu: 2323*)
(*2323*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 2324*)
(*2324*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 2325*)
(*2325*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 2326*)
(*2326*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 2327*)
(*2327*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 2328*)
(*2328*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 2329*)
(*2329*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 2330*)
(*2330*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO5`
have "PO4 ~= PO1"
by auto

(* po redu: 2331*)
(*2331*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 2332*)
(*2332*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 2333*)
(*2333*)  (*BRANCH NAME*)
} note note482 = this
(* po redu: 2334*)
(*2334*)  
(*BRANCH END*)
from note481 and note482 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have ?thesis
by auto
(* po redu: 2335*)
(*2335*)  (*BRANCH NAME*)
} note note483 = this
(* po redu: 2336*)
(*2336*)  
(*BRANCH END*)
from note480 and note483 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have ?thesis
by auto
(* po redu: 2337*)
(*2337*)  (*BRANCH NAME*)
} note note484 = this
(* po redu: 2338*)
(*2338*)  
(*BRANCH END*)
from note479 and note484 and `LI3 = LI4 \<or> LI3 ~= LI4`
have ?thesis
by auto
(* po redu: 2339*)
(*2339*)  (*BRANCH NAME*)
} note note485 = this
(* po redu: 2340*)
(*2340*)  
(*BRANCH END*)
from note478 and note485 and `LI2 = LI4 \<or> LI2 ~= LI4`
have ?thesis
by auto
(* po redu: 2341*)
(*2341*)  (*BRANCH NAME*)
} note note486 = this
(* po redu: 2342*)
(*2342*)  
(*BRANCH END*)
from note477 and note486 and `LI1 = LI4 \<or> LI1 ~= LI4`
have ?thesis
by auto
(* po redu: 2343*)
(*2343*)  (*BRANCH NAME*)
} note note487 = this
(* po redu: 2344*)
(*2344*)  
(*BRANCH END*)
from note476 and note487 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have ?thesis
by auto
(* po redu: 2345*)
(*2345*)  (*BRANCH NAME*)
} note note488 = this
(* po redu: 2346*)
(*2346*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 2347*)
(*2347*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2348*)
(*2348*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2349*)
(*2349*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2350*)
(*2350*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2351*)
(*2351*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2352*)
(*2352*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2353*)
(*2353*)  (*BRANCH NAME*)
} note note489 = this
(* po redu: 2354*)
(*2354*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2355*)
(*2355*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2356*)
(*2356*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2357*)
(*2357*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2358*)
(*2358*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2359*)
(*2359*)  (*BRANCH NAME*)
} note note490 = this
(* po redu: 2360*)
(*2360*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2361*)
(*2361*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 2362*)
(*2362*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 2363*)
(*2363*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 2364*)
(*2364*)  (*BRANCH NAME*)
} note note491 = this
(* po redu: 2365*)
(*2365*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 2366*)
(*2366*)  (*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO4"]
by auto

(* po redu: 2367*)
(*2367*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

(* po redu: 2368*)
(*2368*)  (*BRANCH NAME*)
} note note492 = this
(* po redu: 2369*)
(*2369*)  
(*BRANCH END*)
from note491 and note492 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 2370*)
(*2370*)  (*BRANCH NAME*)
} note note493 = this
(* po redu: 2371*)
(*2371*)  
(*BRANCH END*)
from note490 and note493 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2372*)
(*2372*)  (*BRANCH NAME*)
} note note494 = this
(* po redu: 2373*)
(*2373*)  
(*BRANCH END*)
from note489 and note494 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2374*)
(*2374*)  (*BRANCH NAME*)
} note note495 = this
(* po redu: 2375*)
(*2375*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2376*)
(*2376*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2377*)
(*2377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2378*)
(*2378*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2379*)
(*2379*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2380*)
(*2380*)  (*BRANCH NAME*)
} note note496 = this
(* po redu: 2381*)
(*2381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2382*)
(*2382*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2383*)
(*2383*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2384*)
(*2384*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2385*)
(*2385*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2386*)
(*2386*)  (*BRANCH NAME*)
} note note497 = this
(* po redu: 2387*)
(*2387*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2388*)
(*2388*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 2389*)
(*2389*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 2390*)
(*2390*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 2391*)
(*2391*)  (*BRANCH NAME*)
} note note498 = this
(* po redu: 2392*)
(*2392*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 2393*)
(*2393*)  (*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO4"]
by auto

(* po redu: 2394*)
(*2394*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

(* po redu: 2395*)
(*2395*)  (*BRANCH NAME*)
} note note499 = this
(* po redu: 2396*)
(*2396*)  
(*BRANCH END*)
from note498 and note499 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 2397*)
(*2397*)  (*BRANCH NAME*)
} note note500 = this
(* po redu: 2398*)
(*2398*)  
(*BRANCH END*)
from note497 and note500 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2399*)
(*2399*)  (*BRANCH NAME*)
} note note501 = this
(* po redu: 2400*)
(*2400*)  
(*BRANCH END*)
from note496 and note501 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2401*)
(*2401*)  (*BRANCH NAME*)
} note note502 = this
(* po redu: 2402*)
(*2402*)  
(*BRANCH END*)
from note495 and note502 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 2403*)
(*2403*)  (*BRANCH NAME*)
} note note503 = this
(* po redu: 2404*)
(*2404*)  
(*BRANCH END*)
from note488 and note503 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have ?thesis
by auto
(* po redu: 2405*)
(*2405*)  (*BRANCH NAME*)
} note note504 = this
(* po redu: 2406*)
(*2406*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 2407*)
(*2407*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 2408*)
(*2408*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 2409*)
(*2409*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2410*)
(*2410*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2411*)
(*2411*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2412*)
(*2412*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2413*)
(*2413*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2414*)
(*2414*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2415*)
(*2415*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2416*)
(*2416*)  (*BRANCH NAME*)
} note note505 = this
(* po redu: 2417*)
(*2417*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2418*)
(*2418*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2419*)
(*2419*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2420*)
(*2420*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2421*)
(*2421*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2422*)
(*2422*)  (*BRANCH NAME*)
} note note506 = this
(* po redu: 2423*)
(*2423*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2424*)
(*2424*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 2425*)
(*2425*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 2426*)
(*2426*)  (*BRANCH NAME*)
} note note507 = this
(* po redu: 2427*)
(*2427*)  
(*BRANCH END*)
from note506 and note507 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2428*)
(*2428*)  (*BRANCH NAME*)
} note note508 = this
(* po redu: 2429*)
(*2429*)  
(*BRANCH END*)
from note505 and note508 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2430*)
(*2430*)  (*BRANCH NAME*)
} note note509 = this
(* po redu: 2431*)
(*2431*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2432*)
(*2432*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2433*)
(*2433*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2434*)
(*2434*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2435*)
(*2435*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2436*)
(*2436*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2437*)
(*2437*)  (*BRANCH NAME*)
} note note510 = this
(* po redu: 2438*)
(*2438*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2439*)
(*2439*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2440*)
(*2440*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2441*)
(*2441*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 2442*)
(*2442*)  (*BRANCH NAME*)
} note note511 = this
(* po redu: 2443*)
(*2443*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2444*)
(*2444*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 2445*)
(*2445*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 2446*)
(*2446*)  (*BRANCH NAME*)
} note note512 = this
(* po redu: 2447*)
(*2447*)  
(*BRANCH END*)
from note511 and note512 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2448*)
(*2448*)  (*BRANCH NAME*)
} note note513 = this
(* po redu: 2449*)
(*2449*)  
(*BRANCH END*)
from note510 and note513 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2450*)
(*2450*)  (*BRANCH NAME*)
} note note514 = this
(* po redu: 2451*)
(*2451*)  
(*BRANCH END*)
from note509 and note514 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 2452*)
(*2452*)  (*BRANCH NAME*)
} note note515 = this
(* po redu: 2453*)
(*2453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 2454*)
(*2454*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2455*)
(*2455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2456*)
(*2456*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2457*)
(*2457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2458*)
(*2458*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2459*)
(*2459*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2460*)
(*2460*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2461*)
(*2461*)  (*BRANCH NAME*)
} note note516 = this
(* po redu: 2462*)
(*2462*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2463*)
(*2463*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2464*)
(*2464*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2465*)
(*2465*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2466*)
(*2466*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2467*)
(*2467*)  (*BRANCH NAME*)
} note note517 = this
(* po redu: 2468*)
(*2468*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2469*)
(*2469*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 2470*)
(*2470*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 2471*)
(*2471*)  (*BRANCH NAME*)
} note note518 = this
(* po redu: 2472*)
(*2472*)  
(*BRANCH END*)
from note517 and note518 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2473*)
(*2473*)  (*BRANCH NAME*)
} note note519 = this
(* po redu: 2474*)
(*2474*)  
(*BRANCH END*)
from note516 and note519 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2475*)
(*2475*)  (*BRANCH NAME*)
} note note520 = this
(* po redu: 2476*)
(*2476*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2477*)
(*2477*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2478*)
(*2478*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2479*)
(*2479*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2480*)
(*2480*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2481*)
(*2481*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2482*)
(*2482*)  (*BRANCH NAME*)
} note note521 = this
(* po redu: 2483*)
(*2483*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2484*)
(*2484*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2485*)
(*2485*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2486*)
(*2486*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 2487*)
(*2487*)  (*BRANCH NAME*)
} note note522 = this
(* po redu: 2488*)
(*2488*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2489*)
(*2489*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 2490*)
(*2490*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 2491*)
(*2491*)  (*BRANCH NAME*)
} note note523 = this
(* po redu: 2492*)
(*2492*)  
(*BRANCH END*)
from note522 and note523 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2493*)
(*2493*)  (*BRANCH NAME*)
} note note524 = this
(* po redu: 2494*)
(*2494*)  
(*BRANCH END*)
from note521 and note524 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2495*)
(*2495*)  (*BRANCH NAME*)
} note note525 = this
(* po redu: 2496*)
(*2496*)  
(*BRANCH END*)
from note520 and note525 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 2497*)
(*2497*)  (*BRANCH NAME*)
} note note526 = this
(* po redu: 2498*)
(*2498*)  
(*BRANCH END*)
from note515 and note526 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 2499*)
(*2499*)  (*BRANCH NAME*)
} note note527 = this
(* po redu: 2500*)
(*2500*)  
(*BRANCH END*)
from note504 and note527 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have ?thesis
by auto
(* po redu: 2501*)
(*2501*)  (*BRANCH NAME*)
} note note528 = this
(* po redu: 2502*)
(*2502*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI4"
(* po redu: 2503*)
(*2503*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 2504*)
(*2504*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 2505*)
(*2505*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 2506*)
(*2506*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 2507*)
(*2507*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2508*)
(*2508*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2509*)
(*2509*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2510*)
(*2510*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2511*)
(*2511*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2512*)
(*2512*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2513*)
(*2513*)  (*BRANCH NAME*)
} note note529 = this
(* po redu: 2514*)
(*2514*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2515*)
(*2515*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2516*)
(*2516*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2517*)
(*2517*)  (*BRANCH NAME*)
} note note530 = this
(* po redu: 2518*)
(*2518*)  
(*BRANCH END*)
from note529 and note530 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2519*)
(*2519*)  (*BRANCH NAME*)
} note note531 = this
(* po redu: 2520*)
(*2520*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2521*)
(*2521*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2522*)
(*2522*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2523*)
(*2523*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 2524*)
(*2524*)  (*BRANCH NAME*)
} note note532 = this
(* po redu: 2525*)
(*2525*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2526*)
(*2526*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2527*)
(*2527*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2528*)
(*2528*)  (*BRANCH NAME*)
} note note533 = this
(* po redu: 2529*)
(*2529*)  
(*BRANCH END*)
from note532 and note533 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2530*)
(*2530*)  (*BRANCH NAME*)
} note note534 = this
(* po redu: 2531*)
(*2531*)  
(*BRANCH END*)
from note531 and note534 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 2532*)
(*2532*)  (*BRANCH NAME*)
} note note535 = this
(* po redu: 2533*)
(*2533*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 2534*)
(*2534*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2535*)
(*2535*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2536*)
(*2536*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2537*)
(*2537*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2538*)
(*2538*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2539*)
(*2539*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2540*)
(*2540*)  (*BRANCH NAME*)
} note note536 = this
(* po redu: 2541*)
(*2541*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2542*)
(*2542*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2543*)
(*2543*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2544*)
(*2544*)  (*BRANCH NAME*)
} note note537 = this
(* po redu: 2545*)
(*2545*)  
(*BRANCH END*)
from note536 and note537 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2546*)
(*2546*)  (*BRANCH NAME*)
} note note538 = this
(* po redu: 2547*)
(*2547*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2548*)
(*2548*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2549*)
(*2549*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2550*)
(*2550*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 2551*)
(*2551*)  (*BRANCH NAME*)
} note note539 = this
(* po redu: 2552*)
(*2552*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2553*)
(*2553*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2554*)
(*2554*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2555*)
(*2555*)  (*BRANCH NAME*)
} note note540 = this
(* po redu: 2556*)
(*2556*)  
(*BRANCH END*)
from note539 and note540 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2557*)
(*2557*)  (*BRANCH NAME*)
} note note541 = this
(* po redu: 2558*)
(*2558*)  
(*BRANCH END*)
from note538 and note541 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 2559*)
(*2559*)  (*BRANCH NAME*)
} note note542 = this
(* po redu: 2560*)
(*2560*)  
(*BRANCH END*)
from note535 and note542 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 2561*)
(*2561*)  (*BRANCH NAME*)
} note note543 = this
(* po redu: 2562*)
(*2562*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 2563*)
(*2563*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 2564*)
(*2564*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 2565*)
(*2565*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2566*)
(*2566*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2567*)
(*2567*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2568*)
(*2568*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2569*)
(*2569*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2570*)
(*2570*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2571*)
(*2571*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2572*)
(*2572*)  (*BRANCH NAME*)
} note note544 = this
(* po redu: 2573*)
(*2573*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2574*)
(*2574*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2575*)
(*2575*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2576*)
(*2576*)  (*BRANCH NAME*)
} note note545 = this
(* po redu: 2577*)
(*2577*)  
(*BRANCH END*)
from note544 and note545 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2578*)
(*2578*)  (*BRANCH NAME*)
} note note546 = this
(* po redu: 2579*)
(*2579*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2580*)
(*2580*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2581*)
(*2581*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2582*)
(*2582*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2583*)
(*2583*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2584*)
(*2584*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2585*)
(*2585*)  (*BRANCH NAME*)
} note note547 = this
(* po redu: 2586*)
(*2586*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2587*)
(*2587*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2588*)
(*2588*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2589*)
(*2589*)  (*BRANCH NAME*)
} note note548 = this
(* po redu: 2590*)
(*2590*)  
(*BRANCH END*)
from note547 and note548 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2591*)
(*2591*)  (*BRANCH NAME*)
} note note549 = this
(* po redu: 2592*)
(*2592*)  
(*BRANCH END*)
from note546 and note549 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 2593*)
(*2593*)  (*BRANCH NAME*)
} note note550 = this
(* po redu: 2594*)
(*2594*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 2595*)
(*2595*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2596*)
(*2596*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2597*)
(*2597*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2598*)
(*2598*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2599*)
(*2599*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2600*)
(*2600*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2601*)
(*2601*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2602*)
(*2602*)  (*BRANCH NAME*)
} note note551 = this
(* po redu: 2603*)
(*2603*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2604*)
(*2604*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2605*)
(*2605*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2606*)
(*2606*)  (*BRANCH NAME*)
} note note552 = this
(* po redu: 2607*)
(*2607*)  
(*BRANCH END*)
from note551 and note552 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2608*)
(*2608*)  (*BRANCH NAME*)
} note note553 = this
(* po redu: 2609*)
(*2609*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2610*)
(*2610*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2611*)
(*2611*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2612*)
(*2612*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2613*)
(*2613*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2614*)
(*2614*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2615*)
(*2615*)  (*BRANCH NAME*)
} note note554 = this
(* po redu: 2616*)
(*2616*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2617*)
(*2617*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2618*)
(*2618*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2619*)
(*2619*)  (*BRANCH NAME*)
} note note555 = this
(* po redu: 2620*)
(*2620*)  
(*BRANCH END*)
from note554 and note555 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2621*)
(*2621*)  (*BRANCH NAME*)
} note note556 = this
(* po redu: 2622*)
(*2622*)  
(*BRANCH END*)
from note553 and note556 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 2623*)
(*2623*)  (*BRANCH NAME*)
} note note557 = this
(* po redu: 2624*)
(*2624*)  
(*BRANCH END*)
from note550 and note557 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 2625*)
(*2625*)  (*BRANCH NAME*)
} note note558 = this
(* po redu: 2626*)
(*2626*)  
(*BRANCH END*)
from note543 and note558 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have False
by auto
(* po redu: 2627*)
(*2627*)  (*BRANCH NAME*)
} note note559 = this
(* po redu: 2628*)
(*2628*)  
(*BRANCH END*)
from note528 and note559 and `int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4`
have ?thesis
by auto
(* po redu: 2629*)
(*2629*)  (*BRANCH NAME*)
} note note560 = this
(* po redu: 2630*)
(*2630*)  
(*BRANCH END*)
from note465 and note560 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have ?thesis
by auto
(* po redu: 2631*)
(*2631*)  (*BRANCH NAME*)
} note note561 = this
(* po redu: 2632*)
(*2632*)  
(*BRANCH END*)
from note464 and note561 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 2633*)
(*2633*)  (*BRANCH NAME*)
} note note562 = this
(* po redu: 2634*)
(*2634*)  
(*BRANCH END*)
from note463 and note562 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 2635*)
(*2635*)  (*BRANCH NAME*)
} note note563 = this
(* po redu: 2636*)
(*2636*)  
(*BRANCH END*)
from note462 and note563 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 2637*)
(*2637*)  (*BRANCH NAME*)
} note note564 = this
(* po redu: 2638*)
(*2638*)  
(*BRANCH END*)
from note461 and note564 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 2639*)
(*2639*)  (*BRANCH NAME*)
} note note565 = this
(* po redu: 2640*)
(*2640*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 2641*)
(*2641*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 2642*)
(*2642*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 2643*)
(*2643*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2644*)
(*2644*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2645*)
(*2645*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2646*)
(*2646*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2647*)
(*2647*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2648*)
(*2648*)  (*BRANCH NAME*)
} note note566 = this
(* po redu: 2649*)
(*2649*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2650*)
(*2650*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2651*)
(*2651*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2652*)
(*2652*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2653*)
(*2653*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2654*)
(*2654*)  (*BRANCH NAME*)
} note note567 = this
(* po redu: 2655*)
(*2655*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2656*)
(*2656*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 2657*)
(*2657*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 2658*)
(*2658*)  (*BRANCH NAME*)
} note note568 = this
(* po redu: 2659*)
(*2659*)  
(*BRANCH END*)
from note567 and note568 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 2660*)
(*2660*)  (*BRANCH NAME*)
} note note569 = this
(* po redu: 2661*)
(*2661*)  
(*BRANCH END*)
from note566 and note569 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2662*)
(*2662*)  (*BRANCH NAME*)
} note note570 = this
(* po redu: 2663*)
(*2663*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 2664*)
(*2664*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2665*)
(*2665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2666*)
(*2666*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2667*)
(*2667*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2668*)
(*2668*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2669*)
(*2669*)  (*BRANCH NAME*)
} note note571 = this
(* po redu: 2670*)
(*2670*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2671*)
(*2671*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2672*)
(*2672*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2673*)
(*2673*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 2674*)
(*2674*)  (*BRANCH NAME*)
} note note572 = this
(* po redu: 2675*)
(*2675*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2676*)
(*2676*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 2677*)
(*2677*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 2678*)
(*2678*)  (*BRANCH NAME*)
} note note573 = this
(* po redu: 2679*)
(*2679*)  
(*BRANCH END*)
from note572 and note573 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 2680*)
(*2680*)  (*BRANCH NAME*)
} note note574 = this
(* po redu: 2681*)
(*2681*)  
(*BRANCH END*)
from note571 and note574 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2682*)
(*2682*)  (*BRANCH NAME*)
} note note575 = this
(* po redu: 2683*)
(*2683*)  
(*BRANCH END*)
from note570 and note575 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 2684*)
(*2684*)  (*BRANCH NAME*)
} note note576 = this
(* po redu: 2685*)
(*2685*)  
(*BRANCH END*)
from note565 and note576 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 2686*)
(*2686*)  (*BRANCH NAME*)
} note note577 = this
(* po redu: 2687*)
(*2687*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 2688*)
(*2688*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 2689*)
(*2689*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 2690*)
(*2690*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 2691*)
(*2691*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 2692*)
(*2692*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2693*)
(*2693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2694*)
(*2694*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2695*)
(*2695*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2696*)
(*2696*)  (*BRANCH NAME*)
} note note578 = this
(* po redu: 2697*)
(*2697*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2698*)
(*2698*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2699*)
(*2699*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2700*)
(*2700*)  (*BRANCH NAME*)
} note note579 = this
(* po redu: 2701*)
(*2701*)  
(*BRANCH END*)
from note578 and note579 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2702*)
(*2702*)  (*BRANCH NAME*)
} note note580 = this
(* po redu: 2703*)
(*2703*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 2704*)
(*2704*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2705*)
(*2705*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2706*)
(*2706*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 2707*)
(*2707*)  (*BRANCH NAME*)
} note note581 = this
(* po redu: 2708*)
(*2708*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2709*)
(*2709*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2710*)
(*2710*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2711*)
(*2711*)  (*BRANCH NAME*)
} note note582 = this
(* po redu: 2712*)
(*2712*)  
(*BRANCH END*)
from note581 and note582 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2713*)
(*2713*)  (*BRANCH NAME*)
} note note583 = this
(* po redu: 2714*)
(*2714*)  
(*BRANCH END*)
from note580 and note583 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 2715*)
(*2715*)  (*BRANCH NAME*)
} note note584 = this
(* po redu: 2716*)
(*2716*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 2717*)
(*2717*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 2718*)
(*2718*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 2719*)
(*2719*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2720*)
(*2720*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2721*)
(*2721*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2722*)
(*2722*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2723*)
(*2723*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2724*)
(*2724*)  (*BRANCH NAME*)
} note note585 = this
(* po redu: 2725*)
(*2725*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2726*)
(*2726*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2727*)
(*2727*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2728*)
(*2728*)  (*BRANCH NAME*)
} note note586 = this
(* po redu: 2729*)
(*2729*)  
(*BRANCH END*)
from note585 and note586 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2730*)
(*2730*)  (*BRANCH NAME*)
} note note587 = this
(* po redu: 2731*)
(*2731*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 2732*)
(*2732*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2733*)
(*2733*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2734*)
(*2734*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 2735*)
(*2735*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 2736*)
(*2736*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 2737*)
(*2737*)  (*BRANCH NAME*)
} note note588 = this
(* po redu: 2738*)
(*2738*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2739*)
(*2739*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2740*)
(*2740*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2741*)
(*2741*)  (*BRANCH NAME*)
} note note589 = this
(* po redu: 2742*)
(*2742*)  
(*BRANCH END*)
from note588 and note589 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2743*)
(*2743*)  (*BRANCH NAME*)
} note note590 = this
(* po redu: 2744*)
(*2744*)  
(*BRANCH END*)
from note587 and note590 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 2745*)
(*2745*)  (*BRANCH NAME*)
} note note591 = this
(* po redu: 2746*)
(*2746*)  
(*BRANCH END*)
from note584 and note591 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 2747*)
(*2747*)  (*BRANCH NAME*)
} note note592 = this
(* po redu: 2748*)
(*2748*)  
(*BRANCH END*)
from note577 and note592 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 2749*)
(*2749*)  (*BRANCH NAME*)
} note note593 = this
(* po redu: 2750*)
(*2750*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 2751*)
(*2751*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 2752*)
(*2752*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 2753*)
(*2753*)  (*REGULAR*)
moreover

have  "PO2 = PO5 \<or> PO2 ~= PO5"
using ax_g1 [of "PO2" "PO5"]
by auto

(* po redu: 2754*)
(*2754*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO5"
(* po redu: 2755*)
(*2755*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO5`
have False
by auto

(* po redu: 2756*)
(*2756*)  (*BRANCH NAME*)
} note note594 = this
(* po redu: 2757*)
(*2757*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO5"
(* po redu: 2758*)
(*2758*)  (*REGULAR*)
moreover

have  "PO3 = PO5 \<or> PO3 ~= PO5"
using ax_g1 [of "PO3" "PO5"]
by auto

(* po redu: 2759*)
(*2759*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO5"
(* po redu: 2760*)
(*2760*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO5`
have False
by auto

(* po redu: 2761*)
(*2761*)  (*BRANCH NAME*)
} note note595 = this
(* po redu: 2762*)
(*2762*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO5"
(* po redu: 2763*)
(*2763*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 2764*)
(*2764*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 2765*)
(*2765*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI1" "PO2" "PO5"]
by auto

(* po redu: 2766*)
(*2766*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 2767*)
(*2767*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 2768*)
(*2768*)  (*BRANCH NAME*)
} note note596 = this
(* po redu: 2769*)
(*2769*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 2770*)
(*2770*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO5 LI1`
have  "\<not>col PO2 PO3 PO5"
using ax_D1a [of "PO2" "PO3" "LI1" "PO5"]
by auto

(* po redu: 2771*)
(*2771*)  (*REGULAR*)
moreover
from `PO2 ~= PO5`
obtain  LI5::line
where "inc_po_l PO2 LI5" and "inc_po_l PO5 LI5"
using ax_I1 [of "PO2" "PO5"]
by auto

(* po redu: 2772*)
(*2772*)  (*REGULAR*)
moreover
from `PO3 ~= PO5`
obtain  LI6::line
where "inc_po_l PO3 LI6" and "inc_po_l PO5 LI6"
using ax_I1 [of "PO3" "PO5"]
by auto

(* po redu: 2773*)
(*2773*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 2774*)
(*2774*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5`
obtain  PL4::plane
where "inc_po_pl PO1 PL4" and "inc_po_pl PO2 PL4" and "inc_po_pl PO5 PL4"
using ax_I4a [of "PO1" "PO2" "PO5"]
by auto

(* po redu: 2775*)
(*2775*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 2776*)
(*2776*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5`
obtain  PL5::plane
where "inc_po_pl PO1 PL5" and "inc_po_pl PO3 PL5" and "inc_po_pl PO5 PL5"
using ax_I4a [of "PO1" "PO3" "PO5"]
by auto

(* po redu: 2777*)
(*2777*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO5`
obtain  PL6::plane
where "inc_po_pl PO2 PL6" and "inc_po_pl PO3 PL6" and "inc_po_pl PO5 PL6"
using ax_I4a [of "PO2" "PO3" "PO5"]
by auto

(* po redu: 2778*)
(*2778*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

(* po redu: 2779*)
(*2779*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO4 PO5`
obtain  PL7::plane
where "inc_po_pl PO2 PL7" and "inc_po_pl PO4 PL7" and "inc_po_pl PO5 PL7"
using ax_I4a [of "PO2" "PO4" "PO5"]
by auto

(* po redu: 2780*)
(*2780*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

(* po redu: 2781*)
(*2781*)  (*REGULAR*)
moreover
from `\<not>col PO3 PO4 PO5`
obtain  PL8::plane
where "inc_po_pl PO3 PL8" and "inc_po_pl PO4 PL8" and "inc_po_pl PO5 PL8"
using ax_I4a [of "PO3" "PO4" "PO5"]
by auto

(* po redu: 2782*)
(*2782*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI3" "PO2" "PO4"]
by auto

(* po redu: 2783*)
(*2783*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO4 PO4"
using ax_D1 [of "PO2" "LI3" "PO4" "PO4"]
by auto

(* po redu: 2784*)
(*2784*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 2785*)
(*2785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 2786*)
(*2786*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 2787*)
(*2787*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 2788*)
(*2788*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 2789*)
(*2789*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 2790*)
(*2790*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2791*)
(*2791*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2792*)
(*2792*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2793*)
(*2793*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2794*)
(*2794*)  (*BRANCH NAME*)
} note note597 = this
(* po redu: 2795*)
(*2795*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2796*)
(*2796*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2797*)
(*2797*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2798*)
(*2798*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2799*)
(*2799*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2800*)
(*2800*)  (*BRANCH NAME*)
} note note598 = this
(* po redu: 2801*)
(*2801*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2802*)
(*2802*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 2803*)
(*2803*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 2804*)
(*2804*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

(* po redu: 2805*)
(*2805*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 2806*)
(*2806*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 2807*)
(*2807*)  (*BRANCH NAME*)
} note note599 = this
(* po redu: 2808*)
(*2808*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 2809*)
(*2809*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 2810*)
(*2810*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 2811*)
(*2811*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI3" "PO3" "PO4"]
by auto

(* po redu: 2812*)
(*2812*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2813*)
(*2813*)  (*BRANCH NAME*)
} note note600 = this
(* po redu: 2814*)
(*2814*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 2815*)
(*2815*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

(* po redu: 2816*)
(*2816*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
(* po redu: 2817*)
(*2817*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

(* po redu: 2818*)
(*2818*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO4 PO5"
using ax_D1 [of "PO2" "LI3" "PO4" "PO5"]
by auto

(* po redu: 2819*)
(*2819*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

(* po redu: 2820*)
(*2820*)  (*REGULAR*)
moreover
from `col PO2 PO4 PO5` and `\<not>col PO2 PO4 PO5`
have False
by auto

(* po redu: 2821*)
(*2821*)  (*BRANCH NAME*)
} note note601 = this
(* po redu: 2822*)
(*2822*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
(* po redu: 2823*)
(*2823*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

(* po redu: 2824*)
(*2824*)  (*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

(* po redu: 2825*)
(*2825*)  (*BRANCH NAME*)
} note note602 = this
(* po redu: 2826*)
(*2826*)  
(*BRANCH END*)
from note601 and note602 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have False
by auto
(* po redu: 2827*)
(*2827*)  (*BRANCH NAME*)
} note note603 = this
(* po redu: 2828*)
(*2828*)  
(*BRANCH END*)
from note600 and note603 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have False
by auto
(* po redu: 2829*)
(*2829*)  (*BRANCH NAME*)
} note note604 = this
(* po redu: 2830*)
(*2830*)  
(*BRANCH END*)
from note599 and note604 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
(* po redu: 2831*)
(*2831*)  (*BRANCH NAME*)
} note note605 = this
(* po redu: 2832*)
(*2832*)  
(*BRANCH END*)
from note598 and note605 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 2833*)
(*2833*)  (*BRANCH NAME*)
} note note606 = this
(* po redu: 2834*)
(*2834*)  
(*BRANCH END*)
from note597 and note606 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2835*)
(*2835*)  (*BRANCH NAME*)
} note note607 = this
(* po redu: 2836*)
(*2836*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 2837*)
(*2837*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2838*)
(*2838*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2839*)
(*2839*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2840*)
(*2840*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2841*)
(*2841*)  (*BRANCH NAME*)
} note note608 = this
(* po redu: 2842*)
(*2842*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2843*)
(*2843*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2844*)
(*2844*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2845*)
(*2845*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2846*)
(*2846*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2847*)
(*2847*)  (*BRANCH NAME*)
} note note609 = this
(* po redu: 2848*)
(*2848*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2849*)
(*2849*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(* po redu: 2850*)
(*2850*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
(* po redu: 2851*)
(*2851*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

(* po redu: 2852*)
(*2852*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 2853*)
(*2853*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 2854*)
(*2854*)  (*BRANCH NAME*)
} note note610 = this
(* po redu: 2855*)
(*2855*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(* po redu: 2856*)
(*2856*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 2857*)
(*2857*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 2858*)
(*2858*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI3" "PO3" "PO4"]
by auto

(* po redu: 2859*)
(*2859*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2860*)
(*2860*)  (*BRANCH NAME*)
} note note611 = this
(* po redu: 2861*)
(*2861*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 2862*)
(*2862*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

(* po redu: 2863*)
(*2863*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
(* po redu: 2864*)
(*2864*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

(* po redu: 2865*)
(*2865*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO4 PO5"
using ax_D1 [of "PO2" "LI3" "PO4" "PO5"]
by auto

(* po redu: 2866*)
(*2866*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

(* po redu: 2867*)
(*2867*)  (*REGULAR*)
moreover
from `col PO2 PO4 PO5` and `\<not>col PO2 PO4 PO5`
have False
by auto

(* po redu: 2868*)
(*2868*)  (*BRANCH NAME*)
} note note612 = this
(* po redu: 2869*)
(*2869*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
(* po redu: 2870*)
(*2870*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO3 PO3 PO4"
using ax_D1 [of "PO3" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2871*)
(*2871*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4` and `inc_po_l PO4 LI4`
have  "col PO3 PO4 PO4"
using ax_D1 [of "PO3" "LI4" "PO4" "PO4"]
by auto

(* po redu: 2872*)
(*2872*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4"
using ax_D6a [of "LI1" "LI4"]
by auto

(* po redu: 2873*)
(*2873*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI4"
(* po redu: 2874*)
(*2874*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 2875*)
(*2875*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 2876*)
(*2876*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 2877*)
(*2877*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 2878*)
(*2878*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 2879*)
(*2879*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 2880*)
(*2880*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2881*)
(*2881*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2882*)
(*2882*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2883*)
(*2883*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2884*)
(*2884*)  (*BRANCH NAME*)
} note note613 = this
(* po redu: 2885*)
(*2885*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2886*)
(*2886*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2887*)
(*2887*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2888*)
(*2888*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2889*)
(*2889*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2890*)
(*2890*)  (*BRANCH NAME*)
} note note614 = this
(* po redu: 2891*)
(*2891*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2892*)
(*2892*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 2893*)
(*2893*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 2894*)
(*2894*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 2895*)
(*2895*)  (*BRANCH NAME*)
} note note615 = this
(* po redu: 2896*)
(*2896*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 2897*)
(*2897*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

(* po redu: 2898*)
(*2898*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
(* po redu: 2899*)
(*2899*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2900*)
(*2900*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 2901*)
(*2901*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 2902*)
(*2902*)  (*BRANCH NAME*)
} note note616 = this
(* po redu: 2903*)
(*2903*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
(* po redu: 2904*)
(*2904*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

(* po redu: 2905*)
(*2905*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
(* po redu: 2906*)
(*2906*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2907*)
(*2907*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2908*)
(*2908*)  (*BRANCH NAME*)
} note note617 = this
(* po redu: 2909*)
(*2909*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
(* po redu: 2910*)
(*2910*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI4 \<or> \<not>inc_po_l PO5 LI4"
using ax_g4 [of "PO5" "LI4"]
by auto

(* po redu: 2911*)
(*2911*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI4"
(* po redu: 2912*)
(*2912*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI4" "PO3" "PO5"]
by auto

(* po redu: 2913*)
(*2913*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO4 PO5"
using ax_D1 [of "PO3" "LI4" "PO4" "PO5"]
by auto

(* po redu: 2914*)
(*2914*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

(* po redu: 2915*)
(*2915*)  (*REGULAR*)
moreover
from `col PO3 PO4 PO5` and `\<not>col PO3 PO4 PO5`
have False
by auto

(* po redu: 2916*)
(*2916*)  (*BRANCH NAME*)
} note note618 = this
(* po redu: 2917*)
(*2917*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI4"
(* po redu: 2918*)
(*2918*)  (*REGULAR*)
moreover
from `int_l_l LI4 LI4`
obtain  PO6::point
where "inc_po_l PO6 LI4" and "inc_po_l PO6 LI4" and "LI4 ~= LI4"
using ax_D6 [of "LI4" "LI4"]
by auto

(* po redu: 2919*)
(*2919*)  (*REGULAR*)
moreover
from `LI4 ~= LI4`
have False
by auto

(* po redu: 2920*)
(*2920*)  (*BRANCH NAME*)
} note note619 = this
(* po redu: 2921*)
(*2921*)  
(*BRANCH END*)
from note618 and note619 and `inc_po_l PO5 LI4 \<or> \<not>inc_po_l PO5 LI4`
have False
by auto
(* po redu: 2922*)
(*2922*)  (*BRANCH NAME*)
} note note620 = this
(* po redu: 2923*)
(*2923*)  
(*BRANCH END*)
from note617 and note620 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have False
by auto
(* po redu: 2924*)
(*2924*)  (*BRANCH NAME*)
} note note621 = this
(* po redu: 2925*)
(*2925*)  
(*BRANCH END*)
from note616 and note621 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have False
by auto
(* po redu: 2926*)
(*2926*)  (*BRANCH NAME*)
} note note622 = this
(* po redu: 2927*)
(*2927*)  
(*BRANCH END*)
from note615 and note622 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 2928*)
(*2928*)  (*BRANCH NAME*)
} note note623 = this
(* po redu: 2929*)
(*2929*)  
(*BRANCH END*)
from note614 and note623 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2930*)
(*2930*)  (*BRANCH NAME*)
} note note624 = this
(* po redu: 2931*)
(*2931*)  
(*BRANCH END*)
from note613 and note624 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2932*)
(*2932*)  (*BRANCH NAME*)
} note note625 = this
(* po redu: 2933*)
(*2933*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 2934*)
(*2934*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2935*)
(*2935*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2936*)
(*2936*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 2937*)
(*2937*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 2938*)
(*2938*)  (*BRANCH NAME*)
} note note626 = this
(* po redu: 2939*)
(*2939*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2940*)
(*2940*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2941*)
(*2941*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2942*)
(*2942*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 2943*)
(*2943*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 2944*)
(*2944*)  (*BRANCH NAME*)
} note note627 = this
(* po redu: 2945*)
(*2945*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2946*)
(*2946*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 2947*)
(*2947*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 2948*)
(*2948*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 2949*)
(*2949*)  (*BRANCH NAME*)
} note note628 = this
(* po redu: 2950*)
(*2950*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 2951*)
(*2951*)  (*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

(* po redu: 2952*)
(*2952*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
(* po redu: 2953*)
(*2953*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2954*)
(*2954*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 2955*)
(*2955*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 2956*)
(*2956*)  (*BRANCH NAME*)
} note note629 = this
(* po redu: 2957*)
(*2957*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
(* po redu: 2958*)
(*2958*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

(* po redu: 2959*)
(*2959*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
(* po redu: 2960*)
(*2960*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI4" "PO3" "PO4"]
by auto

(* po redu: 2961*)
(*2961*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2962*)
(*2962*)  (*BRANCH NAME*)
} note note630 = this
(* po redu: 2963*)
(*2963*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
(* po redu: 2964*)
(*2964*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI4 \<or> \<not>inc_po_l PO5 LI4"
using ax_g4 [of "PO5" "LI4"]
by auto

(* po redu: 2965*)
(*2965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI4"
(* po redu: 2966*)
(*2966*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI4" "PO3" "PO5"]
by auto

(* po redu: 2967*)
(*2967*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO4 PO5"
using ax_D1 [of "PO3" "LI4" "PO4" "PO5"]
by auto

(* po redu: 2968*)
(*2968*)  (*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

(* po redu: 2969*)
(*2969*)  (*REGULAR*)
moreover
from `col PO3 PO4 PO5` and `\<not>col PO3 PO4 PO5`
have False
by auto

(* po redu: 2970*)
(*2970*)  (*BRANCH NAME*)
} note note631 = this
(* po redu: 2971*)
(*2971*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI4"
(* po redu: 2972*)
(*2972*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 2973*)
(*2973*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 2974*)
(*2974*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 2975*)
(*2975*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 2976*)
(*2976*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(* po redu: 2977*)
(*2977*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 2978*)
(*2978*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 2979*)
(*2979*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 2980*)
(*2980*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 2981*)
(*2981*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 2982*)
(*2982*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 2983*)
(*2983*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 2984*)
(*2984*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 2985*)
(*2985*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 2986*)
(*2986*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 2987*)
(*2987*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 2988*)
(*2988*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 2989*)
(*2989*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 2990*)
(*2990*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(* po redu: 2991*)
(*2991*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 2992*)
(*2992*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

(* po redu: 2993*)
(*2993*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 2994*)
(*2994*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 2995*)
(*2995*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO4"]
by auto

(* po redu: 2996*)
(*2996*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 2997*)
(*2997*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 2998*)
(*2998*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 2999*)
(*2999*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 3000*)
(*3000*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 3001*)
(*3001*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO4"]
by auto

(* po redu: 3002*)
(*3002*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 3003*)
(*3003*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 3004*)
(*3004*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 3005*)
(*3005*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 3006*)
(*3006*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 3007*)
(*3007*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 3008*)
(*3008*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 3009*)
(*3009*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 3010*)
(*3010*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 3011*)
(*3011*)  (*BRANCH NAME*)
} note note632 = this
(* po redu: 3012*)
(*3012*)  
(*BRANCH END*)
from note631 and note632 and `inc_po_l PO5 LI4 \<or> \<not>inc_po_l PO5 LI4`
have ?thesis
by auto
(* po redu: 3013*)
(*3013*)  (*BRANCH NAME*)
} note note633 = this
(* po redu: 3014*)
(*3014*)  
(*BRANCH END*)
from note630 and note633 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have ?thesis
by auto
(* po redu: 3015*)
(*3015*)  (*BRANCH NAME*)
} note note634 = this
(* po redu: 3016*)
(*3016*)  
(*BRANCH END*)
from note629 and note634 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have ?thesis
by auto
(* po redu: 3017*)
(*3017*)  (*BRANCH NAME*)
} note note635 = this
(* po redu: 3018*)
(*3018*)  
(*BRANCH END*)
from note628 and note635 and `LI3 = LI4 \<or> LI3 ~= LI4`
have ?thesis
by auto
(* po redu: 3019*)
(*3019*)  (*BRANCH NAME*)
} note note636 = this
(* po redu: 3020*)
(*3020*)  
(*BRANCH END*)
from note627 and note636 and `LI2 = LI4 \<or> LI2 ~= LI4`
have ?thesis
by auto
(* po redu: 3021*)
(*3021*)  (*BRANCH NAME*)
} note note637 = this
(* po redu: 3022*)
(*3022*)  
(*BRANCH END*)
from note626 and note637 and `LI1 = LI4 \<or> LI1 ~= LI4`
have ?thesis
by auto
(* po redu: 3023*)
(*3023*)  (*BRANCH NAME*)
} note note638 = this
(* po redu: 3024*)
(*3024*)  
(*BRANCH END*)
from note625 and note638 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have ?thesis
by auto
(* po redu: 3025*)
(*3025*)  (*BRANCH NAME*)
} note note639 = this
(* po redu: 3026*)
(*3026*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 3027*)
(*3027*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 3028*)
(*3028*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 3029*)
(*3029*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3030*)
(*3030*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3031*)
(*3031*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 3032*)
(*3032*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 3033*)
(*3033*)  (*BRANCH NAME*)
} note note640 = this
(* po redu: 3034*)
(*3034*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3035*)
(*3035*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 3036*)
(*3036*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 3037*)
(*3037*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 3038*)
(*3038*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 3039*)
(*3039*)  (*BRANCH NAME*)
} note note641 = this
(* po redu: 3040*)
(*3040*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 3041*)
(*3041*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 3042*)
(*3042*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 3043*)
(*3043*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 3044*)
(*3044*)  (*BRANCH NAME*)
} note note642 = this
(* po redu: 3045*)
(*3045*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 3046*)
(*3046*)  (*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO4"]
by auto

(* po redu: 3047*)
(*3047*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

(* po redu: 3048*)
(*3048*)  (*BRANCH NAME*)
} note note643 = this
(* po redu: 3049*)
(*3049*)  
(*BRANCH END*)
from note642 and note643 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 3050*)
(*3050*)  (*BRANCH NAME*)
} note note644 = this
(* po redu: 3051*)
(*3051*)  
(*BRANCH END*)
from note641 and note644 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 3052*)
(*3052*)  (*BRANCH NAME*)
} note note645 = this
(* po redu: 3053*)
(*3053*)  
(*BRANCH END*)
from note640 and note645 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3054*)
(*3054*)  (*BRANCH NAME*)
} note note646 = this
(* po redu: 3055*)
(*3055*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 3056*)
(*3056*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3057*)
(*3057*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3058*)
(*3058*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 3059*)
(*3059*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 3060*)
(*3060*)  (*BRANCH NAME*)
} note note647 = this
(* po redu: 3061*)
(*3061*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3062*)
(*3062*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 3063*)
(*3063*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 3064*)
(*3064*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 3065*)
(*3065*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 3066*)
(*3066*)  (*BRANCH NAME*)
} note note648 = this
(* po redu: 3067*)
(*3067*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 3068*)
(*3068*)  (*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

(* po redu: 3069*)
(*3069*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
(* po redu: 3070*)
(*3070*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

(* po redu: 3071*)
(*3071*)  (*BRANCH NAME*)
} note note649 = this
(* po redu: 3072*)
(*3072*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
(* po redu: 3073*)
(*3073*)  (*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO4"]
by auto

(* po redu: 3074*)
(*3074*)  (*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

(* po redu: 3075*)
(*3075*)  (*BRANCH NAME*)
} note note650 = this
(* po redu: 3076*)
(*3076*)  
(*BRANCH END*)
from note649 and note650 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
(* po redu: 3077*)
(*3077*)  (*BRANCH NAME*)
} note note651 = this
(* po redu: 3078*)
(*3078*)  
(*BRANCH END*)
from note648 and note651 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 3079*)
(*3079*)  (*BRANCH NAME*)
} note note652 = this
(* po redu: 3080*)
(*3080*)  
(*BRANCH END*)
from note647 and note652 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3081*)
(*3081*)  (*BRANCH NAME*)
} note note653 = this
(* po redu: 3082*)
(*3082*)  
(*BRANCH END*)
from note646 and note653 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 3083*)
(*3083*)  (*BRANCH NAME*)
} note note654 = this
(* po redu: 3084*)
(*3084*)  
(*BRANCH END*)
from note639 and note654 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have ?thesis
by auto
(* po redu: 3085*)
(*3085*)  (*BRANCH NAME*)
} note note655 = this
(* po redu: 3086*)
(*3086*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 3087*)
(*3087*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 3088*)
(*3088*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 3089*)
(*3089*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 3090*)
(*3090*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 3091*)
(*3091*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3092*)
(*3092*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3093*)
(*3093*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3094*)
(*3094*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3095*)
(*3095*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3096*)
(*3096*)  (*BRANCH NAME*)
} note note656 = this
(* po redu: 3097*)
(*3097*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3098*)
(*3098*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 3099*)
(*3099*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 3100*)
(*3100*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 3101*)
(*3101*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 3102*)
(*3102*)  (*BRANCH NAME*)
} note note657 = this
(* po redu: 3103*)
(*3103*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 3104*)
(*3104*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 3105*)
(*3105*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 3106*)
(*3106*)  (*BRANCH NAME*)
} note note658 = this
(* po redu: 3107*)
(*3107*)  
(*BRANCH END*)
from note657 and note658 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 3108*)
(*3108*)  (*BRANCH NAME*)
} note note659 = this
(* po redu: 3109*)
(*3109*)  
(*BRANCH END*)
from note656 and note659 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3110*)
(*3110*)  (*BRANCH NAME*)
} note note660 = this
(* po redu: 3111*)
(*3111*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 3112*)
(*3112*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3113*)
(*3113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3114*)
(*3114*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3115*)
(*3115*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3116*)
(*3116*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3117*)
(*3117*)  (*BRANCH NAME*)
} note note661 = this
(* po redu: 3118*)
(*3118*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3119*)
(*3119*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 3120*)
(*3120*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 3121*)
(*3121*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 3122*)
(*3122*)  (*BRANCH NAME*)
} note note662 = this
(* po redu: 3123*)
(*3123*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 3124*)
(*3124*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 3125*)
(*3125*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 3126*)
(*3126*)  (*BRANCH NAME*)
} note note663 = this
(* po redu: 3127*)
(*3127*)  
(*BRANCH END*)
from note662 and note663 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 3128*)
(*3128*)  (*BRANCH NAME*)
} note note664 = this
(* po redu: 3129*)
(*3129*)  
(*BRANCH END*)
from note661 and note664 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3130*)
(*3130*)  (*BRANCH NAME*)
} note note665 = this
(* po redu: 3131*)
(*3131*)  
(*BRANCH END*)
from note660 and note665 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 3132*)
(*3132*)  (*BRANCH NAME*)
} note note666 = this
(* po redu: 3133*)
(*3133*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 3134*)
(*3134*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 3135*)
(*3135*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 3136*)
(*3136*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3137*)
(*3137*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3138*)
(*3138*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3139*)
(*3139*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3140*)
(*3140*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3141*)
(*3141*)  (*BRANCH NAME*)
} note note667 = this
(* po redu: 3142*)
(*3142*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3143*)
(*3143*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 3144*)
(*3144*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 3145*)
(*3145*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

(* po redu: 3146*)
(*3146*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 3147*)
(*3147*)  (*BRANCH NAME*)
} note note668 = this
(* po redu: 3148*)
(*3148*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 3149*)
(*3149*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 3150*)
(*3150*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 3151*)
(*3151*)  (*BRANCH NAME*)
} note note669 = this
(* po redu: 3152*)
(*3152*)  
(*BRANCH END*)
from note668 and note669 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 3153*)
(*3153*)  (*BRANCH NAME*)
} note note670 = this
(* po redu: 3154*)
(*3154*)  
(*BRANCH END*)
from note667 and note670 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3155*)
(*3155*)  (*BRANCH NAME*)
} note note671 = this
(* po redu: 3156*)
(*3156*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 3157*)
(*3157*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3158*)
(*3158*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3159*)
(*3159*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3160*)
(*3160*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3161*)
(*3161*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3162*)
(*3162*)  (*BRANCH NAME*)
} note note672 = this
(* po redu: 3163*)
(*3163*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3164*)
(*3164*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 3165*)
(*3165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 3166*)
(*3166*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 3167*)
(*3167*)  (*BRANCH NAME*)
} note note673 = this
(* po redu: 3168*)
(*3168*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 3169*)
(*3169*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 3170*)
(*3170*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 3171*)
(*3171*)  (*BRANCH NAME*)
} note note674 = this
(* po redu: 3172*)
(*3172*)  
(*BRANCH END*)
from note673 and note674 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 3173*)
(*3173*)  (*BRANCH NAME*)
} note note675 = this
(* po redu: 3174*)
(*3174*)  
(*BRANCH END*)
from note672 and note675 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3175*)
(*3175*)  (*BRANCH NAME*)
} note note676 = this
(* po redu: 3176*)
(*3176*)  
(*BRANCH END*)
from note671 and note676 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 3177*)
(*3177*)  (*BRANCH NAME*)
} note note677 = this
(* po redu: 3178*)
(*3178*)  
(*BRANCH END*)
from note666 and note677 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 3179*)
(*3179*)  (*BRANCH NAME*)
} note note678 = this
(* po redu: 3180*)
(*3180*)  
(*BRANCH END*)
from note655 and note678 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have ?thesis
by auto
(* po redu: 3181*)
(*3181*)  (*BRANCH NAME*)
} note note679 = this
(* po redu: 3182*)
(*3182*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI4"
(* po redu: 3183*)
(*3183*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 3184*)
(*3184*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 3185*)
(*3185*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 3186*)
(*3186*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 3187*)
(*3187*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 3188*)
(*3188*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 3189*)
(*3189*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3190*)
(*3190*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3191*)
(*3191*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 3192*)
(*3192*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 3193*)
(*3193*)  (*BRANCH NAME*)
} note note680 = this
(* po redu: 3194*)
(*3194*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3195*)
(*3195*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3196*)
(*3196*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3197*)
(*3197*)  (*BRANCH NAME*)
} note note681 = this
(* po redu: 3198*)
(*3198*)  
(*BRANCH END*)
from note680 and note681 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3199*)
(*3199*)  (*BRANCH NAME*)
} note note682 = this
(* po redu: 3200*)
(*3200*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 3201*)
(*3201*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3202*)
(*3202*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3203*)
(*3203*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 3204*)
(*3204*)  (*BRANCH NAME*)
} note note683 = this
(* po redu: 3205*)
(*3205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3206*)
(*3206*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3207*)
(*3207*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3208*)
(*3208*)  (*BRANCH NAME*)
} note note684 = this
(* po redu: 3209*)
(*3209*)  
(*BRANCH END*)
from note683 and note684 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3210*)
(*3210*)  (*BRANCH NAME*)
} note note685 = this
(* po redu: 3211*)
(*3211*)  
(*BRANCH END*)
from note682 and note685 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 3212*)
(*3212*)  (*BRANCH NAME*)
} note note686 = this
(* po redu: 3213*)
(*3213*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 3214*)
(*3214*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 3215*)
(*3215*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 3216*)
(*3216*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3217*)
(*3217*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3218*)
(*3218*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

(* po redu: 3219*)
(*3219*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 3220*)
(*3220*)  (*BRANCH NAME*)
} note note687 = this
(* po redu: 3221*)
(*3221*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3222*)
(*3222*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3223*)
(*3223*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3224*)
(*3224*)  (*BRANCH NAME*)
} note note688 = this
(* po redu: 3225*)
(*3225*)  
(*BRANCH END*)
from note687 and note688 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3226*)
(*3226*)  (*BRANCH NAME*)
} note note689 = this
(* po redu: 3227*)
(*3227*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 3228*)
(*3228*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3229*)
(*3229*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3230*)
(*3230*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 3231*)
(*3231*)  (*BRANCH NAME*)
} note note690 = this
(* po redu: 3232*)
(*3232*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3233*)
(*3233*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3234*)
(*3234*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3235*)
(*3235*)  (*BRANCH NAME*)
} note note691 = this
(* po redu: 3236*)
(*3236*)  
(*BRANCH END*)
from note690 and note691 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3237*)
(*3237*)  (*BRANCH NAME*)
} note note692 = this
(* po redu: 3238*)
(*3238*)  
(*BRANCH END*)
from note689 and note692 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 3239*)
(*3239*)  (*BRANCH NAME*)
} note note693 = this
(* po redu: 3240*)
(*3240*)  
(*BRANCH END*)
from note686 and note693 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 3241*)
(*3241*)  (*BRANCH NAME*)
} note note694 = this
(* po redu: 3242*)
(*3242*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 3243*)
(*3243*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

(* po redu: 3244*)
(*3244*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
(* po redu: 3245*)
(*3245*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 3246*)
(*3246*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 3247*)
(*3247*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3248*)
(*3248*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3249*)
(*3249*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3250*)
(*3250*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3251*)
(*3251*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3252*)
(*3252*)  (*BRANCH NAME*)
} note note695 = this
(* po redu: 3253*)
(*3253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3254*)
(*3254*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3255*)
(*3255*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3256*)
(*3256*)  (*BRANCH NAME*)
} note note696 = this
(* po redu: 3257*)
(*3257*)  
(*BRANCH END*)
from note695 and note696 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3258*)
(*3258*)  (*BRANCH NAME*)
} note note697 = this
(* po redu: 3259*)
(*3259*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 3260*)
(*3260*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3261*)
(*3261*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3262*)
(*3262*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3263*)
(*3263*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3264*)
(*3264*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3265*)
(*3265*)  (*BRANCH NAME*)
} note note698 = this
(* po redu: 3266*)
(*3266*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3267*)
(*3267*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3268*)
(*3268*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3269*)
(*3269*)  (*BRANCH NAME*)
} note note699 = this
(* po redu: 3270*)
(*3270*)  
(*BRANCH END*)
from note698 and note699 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3271*)
(*3271*)  (*BRANCH NAME*)
} note note700 = this
(* po redu: 3272*)
(*3272*)  
(*BRANCH END*)
from note697 and note700 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 3273*)
(*3273*)  (*BRANCH NAME*)
} note note701 = this
(* po redu: 3274*)
(*3274*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
(* po redu: 3275*)
(*3275*)  (*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

(* po redu: 3276*)
(*3276*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
(* po redu: 3277*)
(*3277*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3278*)
(*3278*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3279*)
(*3279*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3280*)
(*3280*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3281*)
(*3281*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3282*)
(*3282*)  (*BRANCH NAME*)
} note note702 = this
(* po redu: 3283*)
(*3283*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3284*)
(*3284*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3285*)
(*3285*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3286*)
(*3286*)  (*BRANCH NAME*)
} note note703 = this
(* po redu: 3287*)
(*3287*)  
(*BRANCH END*)
from note702 and note703 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3288*)
(*3288*)  (*BRANCH NAME*)
} note note704 = this
(* po redu: 3289*)
(*3289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
(* po redu: 3290*)
(*3290*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3291*)
(*3291*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3292*)
(*3292*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3293*)
(*3293*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3294*)
(*3294*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3295*)
(*3295*)  (*BRANCH NAME*)
} note note705 = this
(* po redu: 3296*)
(*3296*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3297*)
(*3297*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3298*)
(*3298*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3299*)
(*3299*)  (*BRANCH NAME*)
} note note706 = this
(* po redu: 3300*)
(*3300*)  
(*BRANCH END*)
from note705 and note706 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3301*)
(*3301*)  (*BRANCH NAME*)
} note note707 = this
(* po redu: 3302*)
(*3302*)  
(*BRANCH END*)
from note704 and note707 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
(* po redu: 3303*)
(*3303*)  (*BRANCH NAME*)
} note note708 = this
(* po redu: 3304*)
(*3304*)  
(*BRANCH END*)
from note701 and note708 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
(* po redu: 3305*)
(*3305*)  (*BRANCH NAME*)
} note note709 = this
(* po redu: 3306*)
(*3306*)  
(*BRANCH END*)
from note694 and note709 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have False
by auto
(* po redu: 3307*)
(*3307*)  (*BRANCH NAME*)
} note note710 = this
(* po redu: 3308*)
(*3308*)  
(*BRANCH END*)
from note679 and note710 and `int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4`
have ?thesis
by auto
(* po redu: 3309*)
(*3309*)  (*BRANCH NAME*)
} note note711 = this
(* po redu: 3310*)
(*3310*)  
(*BRANCH END*)
from note612 and note711 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have ?thesis
by auto
(* po redu: 3311*)
(*3311*)  (*BRANCH NAME*)
} note note712 = this
(* po redu: 3312*)
(*3312*)  
(*BRANCH END*)
from note611 and note712 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have ?thesis
by auto
(* po redu: 3313*)
(*3313*)  (*BRANCH NAME*)
} note note713 = this
(* po redu: 3314*)
(*3314*)  
(*BRANCH END*)
from note610 and note713 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(* po redu: 3315*)
(*3315*)  (*BRANCH NAME*)
} note note714 = this
(* po redu: 3316*)
(*3316*)  
(*BRANCH END*)
from note609 and note714 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
(* po redu: 3317*)
(*3317*)  (*BRANCH NAME*)
} note note715 = this
(* po redu: 3318*)
(*3318*)  
(*BRANCH END*)
from note608 and note715 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
(* po redu: 3319*)
(*3319*)  (*BRANCH NAME*)
} note note716 = this
(* po redu: 3320*)
(*3320*)  
(*BRANCH END*)
from note607 and note716 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(* po redu: 3321*)
(*3321*)  (*BRANCH NAME*)
} note note717 = this
(* po redu: 3322*)
(*3322*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 3323*)
(*3323*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 3324*)
(*3324*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 3325*)
(*3325*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 3326*)
(*3326*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 3327*)
(*3327*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3328*)
(*3328*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3329*)
(*3329*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3330*)
(*3330*)  (*BRANCH NAME*)
} note note718 = this
(* po redu: 3331*)
(*3331*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 3332*)
(*3332*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 3333*)
(*3333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 3334*)
(*3334*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

(* po redu: 3335*)
(*3335*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

(* po redu: 3336*)
(*3336*)  (*BRANCH NAME*)
} note note719 = this
(* po redu: 3337*)
(*3337*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 3338*)
(*3338*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 3339*)
(*3339*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 3340*)
(*3340*)  (*BRANCH NAME*)
} note note720 = this
(* po redu: 3341*)
(*3341*)  
(*BRANCH END*)
from note719 and note720 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 3342*)
(*3342*)  (*BRANCH NAME*)
} note note721 = this
(* po redu: 3343*)
(*3343*)  
(*BRANCH END*)
from note718 and note721 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 3344*)
(*3344*)  (*BRANCH NAME*)
} note note722 = this
(* po redu: 3345*)
(*3345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 3346*)
(*3346*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 3347*)
(*3347*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 3348*)
(*3348*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3349*)
(*3349*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3350*)
(*3350*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3351*)
(*3351*)  (*BRANCH NAME*)
} note note723 = this
(* po redu: 3352*)
(*3352*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 3353*)
(*3353*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 3354*)
(*3354*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 3355*)
(*3355*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 3356*)
(*3356*)  (*BRANCH NAME*)
} note note724 = this
(* po redu: 3357*)
(*3357*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 3358*)
(*3358*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 3359*)
(*3359*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 3360*)
(*3360*)  (*BRANCH NAME*)
} note note725 = this
(* po redu: 3361*)
(*3361*)  
(*BRANCH END*)
from note724 and note725 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 3362*)
(*3362*)  (*BRANCH NAME*)
} note note726 = this
(* po redu: 3363*)
(*3363*)  
(*BRANCH END*)
from note723 and note726 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 3364*)
(*3364*)  (*BRANCH NAME*)
} note note727 = this
(* po redu: 3365*)
(*3365*)  
(*BRANCH END*)
from note722 and note727 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 3366*)
(*3366*)  (*BRANCH NAME*)
} note note728 = this
(* po redu: 3367*)
(*3367*)  
(*BRANCH END*)
from note717 and note728 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 3368*)
(*3368*)  (*BRANCH NAME*)
} note note729 = this
(* po redu: 3369*)
(*3369*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 3370*)
(*3370*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 3371*)
(*3371*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 3372*)
(*3372*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 3373*)
(*3373*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 3374*)
(*3374*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 3375*)
(*3375*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 3376*)
(*3376*)  (*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

(* po redu: 3377*)
(*3377*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

(* po redu: 3378*)
(*3378*)  (*BRANCH NAME*)
} note note730 = this
(* po redu: 3379*)
(*3379*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 3380*)
(*3380*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 3381*)
(*3381*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 3382*)
(*3382*)  (*BRANCH NAME*)
} note note731 = this
(* po redu: 3383*)
(*3383*)  
(*BRANCH END*)
from note730 and note731 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 3384*)
(*3384*)  (*BRANCH NAME*)
} note note732 = this
(* po redu: 3385*)
(*3385*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 3386*)
(*3386*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 3387*)
(*3387*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 3388*)
(*3388*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 3389*)
(*3389*)  (*BRANCH NAME*)
} note note733 = this
(* po redu: 3390*)
(*3390*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 3391*)
(*3391*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 3392*)
(*3392*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 3393*)
(*3393*)  (*BRANCH NAME*)
} note note734 = this
(* po redu: 3394*)
(*3394*)  
(*BRANCH END*)
from note733 and note734 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 3395*)
(*3395*)  (*BRANCH NAME*)
} note note735 = this
(* po redu: 3396*)
(*3396*)  
(*BRANCH END*)
from note732 and note735 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 3397*)
(*3397*)  (*BRANCH NAME*)
} note note736 = this
(* po redu: 3398*)
(*3398*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 3399*)
(*3399*)  (*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(* po redu: 3400*)
(*3400*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
(* po redu: 3401*)
(*3401*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 3402*)
(*3402*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 3403*)
(*3403*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3404*)
(*3404*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3405*)
(*3405*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3406*)
(*3406*)  (*BRANCH NAME*)
} note note737 = this
(* po redu: 3407*)
(*3407*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 3408*)
(*3408*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 3409*)
(*3409*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 3410*)
(*3410*)  (*BRANCH NAME*)
} note note738 = this
(* po redu: 3411*)
(*3411*)  
(*BRANCH END*)
from note737 and note738 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 3412*)
(*3412*)  (*BRANCH NAME*)
} note note739 = this
(* po redu: 3413*)
(*3413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
(* po redu: 3414*)
(*3414*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 3415*)
(*3415*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 3416*)
(*3416*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

(* po redu: 3417*)
(*3417*)  (*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

(* po redu: 3418*)
(*3418*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(* po redu: 3419*)
(*3419*)  (*BRANCH NAME*)
} note note740 = this
(* po redu: 3420*)
(*3420*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 3421*)
(*3421*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 3422*)
(*3422*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 3423*)
(*3423*)  (*BRANCH NAME*)
} note note741 = this
(* po redu: 3424*)
(*3424*)  
(*BRANCH END*)
from note740 and note741 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 3425*)
(*3425*)  (*BRANCH NAME*)
} note note742 = this
(* po redu: 3426*)
(*3426*)  
(*BRANCH END*)
from note739 and note742 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
(* po redu: 3427*)
(*3427*)  (*BRANCH NAME*)
} note note743 = this
(* po redu: 3428*)
(*3428*)  
(*BRANCH END*)
from note736 and note743 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
(* po redu: 3429*)
(*3429*)  (*BRANCH NAME*)
} note note744 = this
(* po redu: 3430*)
(*3430*)  
(*BRANCH END*)
from note729 and note744 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 3431*)
(*3431*)  (*BRANCH NAME*)
} note note745 = this
(* po redu: 3432*)
(*3432*)  
(*BRANCH END*)
from note596 and note745 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 3433*)
(*3433*)  (*BRANCH NAME*)
} note note746 = this
(* po redu: 3434*)
(*3434*)  
(*BRANCH END*)
from note595 and note746 and `PO3 = PO5 \<or> PO3 ~= PO5`
have ?thesis
by auto
(* po redu: 3435*)
(*3435*)  (*BRANCH NAME*)
} note note747 = this
(* po redu: 3436*)
(*3436*)  
(*BRANCH END*)
from note594 and note747 and `PO2 = PO5 \<or> PO2 ~= PO5`
have ?thesis
by auto
(* po redu: 3437*)
(*3437*)  (*BRANCH NAME*)
} note note748 = this
(* po redu: 3438*)
(*3438*)  
(*BRANCH END*)
from note593 and note748 and `PO1 = PO5 \<or> PO1 ~= PO5`
have ?thesis
by auto
(* po redu: 3439*)
(*3439*)  (*BRANCH NAME*)
} note note749 = this
(* po redu: 3440*)
(*3440*)  
(*BRANCH END*)
from note452 and note749 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(* po redu: 3441*)
(*3441*)  (*BRANCH NAME*)
} note note750 = this
(* po redu: 3442*)
(*3442*)  
(*BRANCH END*)
from note451 and note750 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
(* po redu: 3443*)
(*3443*)  (*BRANCH NAME*)
} note note751 = this
(* po redu: 3444*)
(*3444*)  
(*BRANCH END*)
from note450 and note751 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 3445*)
(*3445*)  (*BRANCH NAME*)
} note note752 = this
(* po redu: 3446*)
(*3446*)  
(*BRANCH END*)
from note449 and note752 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 3447*)
(*3447*)  (*BRANCH NAME*)
} note note753 = this
(* po redu: 3448*)
(*3448*)  
(*BRANCH END*)
from note302 and note753 and `inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2`
have ?thesis
by auto
(* po redu: 3449*)
(*3449*)  (*BRANCH NAME*)
} note note754 = this
(* po redu: 3450*)
(*3450*)  
(*BRANCH END*)
from note301 and note754 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 3451*)
(*3451*)  (*BRANCH NAME*)
} note note755 = this
(* po redu: 3452*)
(*3452*)  
(*BRANCH END*)
from note154 and note755 and `inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2`
have ?thesis
by auto
(* po redu: 3453*)
(*3453*)  (*BRANCH NAME*)
} note note756 = this
(* po redu: 3454*)
(*3454*)  
(*BRANCH END*)
from note153 and note756 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
(* po redu: 3455*)
(*3455*)  (*BRANCH NAME*)
} note note757 = this
(* po redu: 3456*)
(*3456*)  
(*BRANCH END*)
from note4 and note757 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have ?thesis
by auto
(* po redu: 3457*)
(*3457*)  (*BRANCH NAME*)
} note note758 = this
(* po redu: 3458*)
(*3458*)  
(*BRANCH END*)
from note3 and note758 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
