theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th24:
assumes "LI1 ~= LI2"
and "inc_po_l PO1 LI1"
and "inc_po_l PO1 LI2"
and "inc_l_pl LI1 PL1"
and "inc_l_pl LI2 PL1"
and "inc_l_pl LI1 PL2"
and "inc_l_pl LI2 PL2"
shows " (PL1 = PL2)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2*)
(*2*)  (*REGULAR*)
moreover
from `LI1 ~= LI2` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have  "int_l_l LI1 LI2"
using ax_D5 [of "LI1" "LI2" "PO1"]
by auto

(* po redu: 3*)
(*3*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO1 LI1`
have  "inc_po_pl PO1 PL1"
using ax_D11 [of "LI1" "PL1" "PO1"]
by auto

(* po redu: 4*)
(*4*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 5*)
(*5*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO1 LI1`
have  "inc_po_pl PO1 PL2"
using ax_D11 [of "LI1" "PL2" "PO1"]
by auto

(* po redu: 6*)
(*6*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(* po redu: 7*)
(*7*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
(* po redu: 8*)
(*8*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(* po redu: 9*)
(*9*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
(* po redu: 10*)
(*10*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 11*)
(*11*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 12*)
(*12*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 13*)
(*13*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 14*)
(*14*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 15*)
(*15*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 16*)
(*16*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 17*)
(*17*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 18*)
(*18*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 19*)
(*19*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 20*)
(*20*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 21*)
(*21*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 22*)
(*22*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 23*)
(*23*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 24*)
(*24*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 25*)
(*25*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 26*)
(*26*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1 = this
(* po redu: 27*)
(*27*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 28*)
(*28*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 29*)
(*29*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 30*)
(*30*)  (*BRANCH NAME*)
} note note2 = this
(* po redu: 31*)
(*31*)  
(*BRANCH END*)
from note1 and note2 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 32*)
(*32*)  (*BRANCH NAME*)
} note note3 = this
(* po redu: 33*)
(*33*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 34*)
(*34*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 35*)
(*35*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 36*)
(*36*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 37*)
(*37*)  (*BRANCH NAME*)
} note note4 = this
(* po redu: 38*)
(*38*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 39*)
(*39*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 40*)
(*40*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 41*)
(*41*)  (*BRANCH NAME*)
} note note5 = this
(* po redu: 42*)
(*42*)  
(*BRANCH END*)
from note4 and note5 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 43*)
(*43*)  (*BRANCH NAME*)
} note note6 = this
(* po redu: 44*)
(*44*)  
(*BRANCH END*)
from note3 and note6 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 45*)
(*45*)  (*BRANCH NAME*)
} note note7 = this
(* po redu: 46*)
(*46*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 47*)
(*47*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 48*)
(*48*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 49*)
(*49*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 50*)
(*50*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 51*)
(*51*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 52*)
(*52*)  (*BRANCH NAME*)
} note note8 = this
(* po redu: 53*)
(*53*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 54*)
(*54*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 55*)
(*55*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 56*)
(*56*)  (*BRANCH NAME*)
} note note9 = this
(* po redu: 57*)
(*57*)  
(*BRANCH END*)
from note8 and note9 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 58*)
(*58*)  (*BRANCH NAME*)
} note note10 = this
(* po redu: 59*)
(*59*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 60*)
(*60*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 61*)
(*61*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 62*)
(*62*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note11 = this
(* po redu: 63*)
(*63*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 64*)
(*64*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 65*)
(*65*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 66*)
(*66*)  (*BRANCH NAME*)
} note note12 = this
(* po redu: 67*)
(*67*)  
(*BRANCH END*)
from note11 and note12 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 68*)
(*68*)  (*BRANCH NAME*)
} note note13 = this
(* po redu: 69*)
(*69*)  
(*BRANCH END*)
from note10 and note13 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 70*)
(*70*)  (*BRANCH NAME*)
} note note14 = this
(* po redu: 71*)
(*71*)  
(*BRANCH END*)
from note7 and note14 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 72*)
(*72*)  (*BRANCH NAME*)
} note note15 = this
(* po redu: 73*)
(*73*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 74*)
(*74*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 75*)
(*75*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 76*)
(*76*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 77*)
(*77*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 78*)
(*78*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 79*)
(*79*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 80*)
(*80*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 81*)
(*81*)  (*BRANCH NAME*)
} note note16 = this
(* po redu: 82*)
(*82*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 83*)
(*83*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 84*)
(*84*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 85*)
(*85*)  (*BRANCH NAME*)
} note note17 = this
(* po redu: 86*)
(*86*)  
(*BRANCH END*)
from note16 and note17 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 87*)
(*87*)  (*BRANCH NAME*)
} note note18 = this
(* po redu: 88*)
(*88*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 89*)
(*89*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 90*)
(*90*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 91*)
(*91*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 92*)
(*92*)  (*BRANCH NAME*)
} note note19 = this
(* po redu: 93*)
(*93*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 94*)
(*94*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 95*)
(*95*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 96*)
(*96*)  (*BRANCH NAME*)
} note note20 = this
(* po redu: 97*)
(*97*)  
(*BRANCH END*)
from note19 and note20 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 98*)
(*98*)  (*BRANCH NAME*)
} note note21 = this
(* po redu: 99*)
(*99*)  
(*BRANCH END*)
from note18 and note21 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 100*)
(*100*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 101*)
(*101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 102*)
(*102*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 103*)
(*103*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 104*)
(*104*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 105*)
(*105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 106*)
(*106*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 107*)
(*107*)  (*BRANCH NAME*)
} note note23 = this
(* po redu: 108*)
(*108*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 109*)
(*109*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 110*)
(*110*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 111*)
(*111*)  (*BRANCH NAME*)
} note note24 = this
(* po redu: 112*)
(*112*)  
(*BRANCH END*)
from note23 and note24 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 113*)
(*113*)  (*BRANCH NAME*)
} note note25 = this
(* po redu: 114*)
(*114*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 115*)
(*115*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 116*)
(*116*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 117*)
(*117*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 118*)
(*118*)  (*BRANCH NAME*)
} note note26 = this
(* po redu: 119*)
(*119*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 120*)
(*120*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 121*)
(*121*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 122*)
(*122*)  (*BRANCH NAME*)
} note note27 = this
(* po redu: 123*)
(*123*)  
(*BRANCH END*)
from note26 and note27 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 124*)
(*124*)  (*BRANCH NAME*)
} note note28 = this
(* po redu: 125*)
(*125*)  
(*BRANCH END*)
from note25 and note28 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 126*)
(*126*)  (*BRANCH NAME*)
} note note29 = this
(* po redu: 127*)
(*127*)  
(*BRANCH END*)
from note22 and note29 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 128*)
(*128*)  (*BRANCH NAME*)
} note note30 = this
(* po redu: 129*)
(*129*)  
(*BRANCH END*)
from note15 and note30 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 130*)
(*130*)  (*BRANCH NAME*)
} note note31 = this
(* po redu: 131*)
(*131*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 132*)
(*132*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 133*)
(*133*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 134*)
(*134*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 135*)
(*135*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 136*)
(*136*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 137*)
(*137*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 138*)
(*138*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 139*)
(*139*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 140*)
(*140*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 141*)
(*141*)  (*BRANCH NAME*)
} note note32 = this
(* po redu: 142*)
(*142*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 143*)
(*143*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 144*)
(*144*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 145*)
(*145*)  (*BRANCH NAME*)
} note note33 = this
(* po redu: 146*)
(*146*)  
(*BRANCH END*)
from note32 and note33 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 147*)
(*147*)  (*BRANCH NAME*)
} note note34 = this
(* po redu: 148*)
(*148*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 149*)
(*149*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 150*)
(*150*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 151*)
(*151*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 152*)
(*152*)  (*BRANCH NAME*)
} note note35 = this
(* po redu: 153*)
(*153*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 154*)
(*154*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 155*)
(*155*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 156*)
(*156*)  (*BRANCH NAME*)
} note note36 = this
(* po redu: 157*)
(*157*)  
(*BRANCH END*)
from note35 and note36 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 158*)
(*158*)  (*BRANCH NAME*)
} note note37 = this
(* po redu: 159*)
(*159*)  
(*BRANCH END*)
from note34 and note37 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 160*)
(*160*)  (*BRANCH NAME*)
} note note38 = this
(* po redu: 161*)
(*161*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 162*)
(*162*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 163*)
(*163*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 164*)
(*164*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 165*)
(*165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 166*)
(*166*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 167*)
(*167*)  (*BRANCH NAME*)
} note note39 = this
(* po redu: 168*)
(*168*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 169*)
(*169*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 170*)
(*170*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 171*)
(*171*)  (*BRANCH NAME*)
} note note40 = this
(* po redu: 172*)
(*172*)  
(*BRANCH END*)
from note39 and note40 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 173*)
(*173*)  (*BRANCH NAME*)
} note note41 = this
(* po redu: 174*)
(*174*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 175*)
(*175*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 176*)
(*176*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 177*)
(*177*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 178*)
(*178*)  (*BRANCH NAME*)
} note note42 = this
(* po redu: 179*)
(*179*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 180*)
(*180*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 181*)
(*181*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 182*)
(*182*)  (*BRANCH NAME*)
} note note43 = this
(* po redu: 183*)
(*183*)  
(*BRANCH END*)
from note42 and note43 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 184*)
(*184*)  (*BRANCH NAME*)
} note note44 = this
(* po redu: 185*)
(*185*)  
(*BRANCH END*)
from note41 and note44 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 186*)
(*186*)  (*BRANCH NAME*)
} note note45 = this
(* po redu: 187*)
(*187*)  
(*BRANCH END*)
from note38 and note45 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 188*)
(*188*)  (*BRANCH NAME*)
} note note46 = this
(* po redu: 189*)
(*189*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 190*)
(*190*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 191*)
(*191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 192*)
(*192*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 193*)
(*193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 194*)
(*194*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 195*)
(*195*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 196*)
(*196*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note47 = this
(* po redu: 197*)
(*197*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 198*)
(*198*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 199*)
(*199*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 200*)
(*200*)  (*BRANCH NAME*)
} note note48 = this
(* po redu: 201*)
(*201*)  
(*BRANCH END*)
from note47 and note48 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 202*)
(*202*)  (*BRANCH NAME*)
} note note49 = this
(* po redu: 203*)
(*203*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 204*)
(*204*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 205*)
(*205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 206*)
(*206*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 207*)
(*207*)  (*BRANCH NAME*)
} note note50 = this
(* po redu: 208*)
(*208*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 209*)
(*209*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 210*)
(*210*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 211*)
(*211*)  (*BRANCH NAME*)
} note note51 = this
(* po redu: 212*)
(*212*)  
(*BRANCH END*)
from note50 and note51 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 213*)
(*213*)  (*BRANCH NAME*)
} note note52 = this
(* po redu: 214*)
(*214*)  
(*BRANCH END*)
from note49 and note52 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 215*)
(*215*)  (*BRANCH NAME*)
} note note53 = this
(* po redu: 216*)
(*216*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 217*)
(*217*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 218*)
(*218*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 219*)
(*219*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 220*)
(*220*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 221*)
(*221*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 222*)
(*222*)  (*BRANCH NAME*)
} note note54 = this
(* po redu: 223*)
(*223*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 224*)
(*224*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 225*)
(*225*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 226*)
(*226*)  (*BRANCH NAME*)
} note note55 = this
(* po redu: 227*)
(*227*)  
(*BRANCH END*)
from note54 and note55 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 228*)
(*228*)  (*BRANCH NAME*)
} note note56 = this
(* po redu: 229*)
(*229*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 230*)
(*230*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 231*)
(*231*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 232*)
(*232*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note57 = this
(* po redu: 233*)
(*233*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 234*)
(*234*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 235*)
(*235*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 236*)
(*236*)  (*BRANCH NAME*)
} note note58 = this
(* po redu: 237*)
(*237*)  
(*BRANCH END*)
from note57 and note58 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 238*)
(*238*)  (*BRANCH NAME*)
} note note59 = this
(* po redu: 239*)
(*239*)  
(*BRANCH END*)
from note56 and note59 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 240*)
(*240*)  (*BRANCH NAME*)
} note note60 = this
(* po redu: 241*)
(*241*)  
(*BRANCH END*)
from note53 and note60 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 242*)
(*242*)  (*BRANCH NAME*)
} note note61 = this
(* po redu: 243*)
(*243*)  
(*BRANCH END*)
from note46 and note61 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 244*)
(*244*)  (*BRANCH NAME*)
} note note62 = this
(* po redu: 245*)
(*245*)  
(*BRANCH END*)
from note31 and note62 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 246*)
(*246*)  (*BRANCH NAME*)
} note note63 = this
(* po redu: 247*)
(*247*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 248*)
(*248*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 249*)
(*249*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 250*)
(*250*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 251*)
(*251*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 252*)
(*252*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 253*)
(*253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 254*)
(*254*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 255*)
(*255*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 256*)
(*256*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 257*)
(*257*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 258*)
(*258*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 259*)
(*259*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 260*)
(*260*)  (*BRANCH NAME*)
} note note64 = this
(* po redu: 261*)
(*261*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 262*)
(*262*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 263*)
(*263*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 264*)
(*264*)  (*BRANCH NAME*)
} note note65 = this
(* po redu: 265*)
(*265*)  
(*BRANCH END*)
from note64 and note65 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 266*)
(*266*)  (*BRANCH NAME*)
} note note66 = this
(* po redu: 267*)
(*267*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 268*)
(*268*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 269*)
(*269*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 270*)
(*270*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 271*)
(*271*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 272*)
(*272*)  (*BRANCH NAME*)
} note note67 = this
(* po redu: 273*)
(*273*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 274*)
(*274*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 275*)
(*275*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 276*)
(*276*)  (*BRANCH NAME*)
} note note68 = this
(* po redu: 277*)
(*277*)  
(*BRANCH END*)
from note67 and note68 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 278*)
(*278*)  (*BRANCH NAME*)
} note note69 = this
(* po redu: 279*)
(*279*)  
(*BRANCH END*)
from note66 and note69 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 280*)
(*280*)  (*BRANCH NAME*)
} note note70 = this
(* po redu: 281*)
(*281*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 282*)
(*282*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 283*)
(*283*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 284*)
(*284*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 285*)
(*285*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 286*)
(*286*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 287*)
(*287*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 288*)
(*288*)  (*BRANCH NAME*)
} note note71 = this
(* po redu: 289*)
(*289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 290*)
(*290*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 291*)
(*291*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 292*)
(*292*)  (*BRANCH NAME*)
} note note72 = this
(* po redu: 293*)
(*293*)  
(*BRANCH END*)
from note71 and note72 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 294*)
(*294*)  (*BRANCH NAME*)
} note note73 = this
(* po redu: 295*)
(*295*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 296*)
(*296*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 297*)
(*297*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 298*)
(*298*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 299*)
(*299*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 300*)
(*300*)  (*BRANCH NAME*)
} note note74 = this
(* po redu: 301*)
(*301*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 302*)
(*302*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 303*)
(*303*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 304*)
(*304*)  (*BRANCH NAME*)
} note note75 = this
(* po redu: 305*)
(*305*)  
(*BRANCH END*)
from note74 and note75 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 306*)
(*306*)  (*BRANCH NAME*)
} note note76 = this
(* po redu: 307*)
(*307*)  
(*BRANCH END*)
from note73 and note76 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 308*)
(*308*)  (*BRANCH NAME*)
} note note77 = this
(* po redu: 309*)
(*309*)  
(*BRANCH END*)
from note70 and note77 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 310*)
(*310*)  (*BRANCH NAME*)
} note note78 = this
(* po redu: 311*)
(*311*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 312*)
(*312*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 313*)
(*313*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 314*)
(*314*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 315*)
(*315*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 316*)
(*316*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 317*)
(*317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 318*)
(*318*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 319*)
(*319*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 320*)
(*320*)  (*BRANCH NAME*)
} note note79 = this
(* po redu: 321*)
(*321*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 322*)
(*322*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 323*)
(*323*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 324*)
(*324*)  (*BRANCH NAME*)
} note note80 = this
(* po redu: 325*)
(*325*)  
(*BRANCH END*)
from note79 and note80 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 326*)
(*326*)  (*BRANCH NAME*)
} note note81 = this
(* po redu: 327*)
(*327*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 328*)
(*328*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 329*)
(*329*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 330*)
(*330*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 331*)
(*331*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 332*)
(*332*)  (*BRANCH NAME*)
} note note82 = this
(* po redu: 333*)
(*333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 334*)
(*334*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 335*)
(*335*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 336*)
(*336*)  (*BRANCH NAME*)
} note note83 = this
(* po redu: 337*)
(*337*)  
(*BRANCH END*)
from note82 and note83 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 338*)
(*338*)  (*BRANCH NAME*)
} note note84 = this
(* po redu: 339*)
(*339*)  
(*BRANCH END*)
from note81 and note84 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 340*)
(*340*)  (*BRANCH NAME*)
} note note85 = this
(* po redu: 341*)
(*341*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 342*)
(*342*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 343*)
(*343*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 344*)
(*344*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 345*)
(*345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 346*)
(*346*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 347*)
(*347*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 348*)
(*348*)  (*BRANCH NAME*)
} note note86 = this
(* po redu: 349*)
(*349*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 350*)
(*350*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 351*)
(*351*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 352*)
(*352*)  (*BRANCH NAME*)
} note note87 = this
(* po redu: 353*)
(*353*)  
(*BRANCH END*)
from note86 and note87 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 354*)
(*354*)  (*BRANCH NAME*)
} note note88 = this
(* po redu: 355*)
(*355*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 356*)
(*356*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 357*)
(*357*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 358*)
(*358*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 359*)
(*359*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 360*)
(*360*)  (*BRANCH NAME*)
} note note89 = this
(* po redu: 361*)
(*361*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 362*)
(*362*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 363*)
(*363*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 364*)
(*364*)  (*BRANCH NAME*)
} note note90 = this
(* po redu: 365*)
(*365*)  
(*BRANCH END*)
from note89 and note90 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 366*)
(*366*)  (*BRANCH NAME*)
} note note91 = this
(* po redu: 367*)
(*367*)  
(*BRANCH END*)
from note88 and note91 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 368*)
(*368*)  (*BRANCH NAME*)
} note note92 = this
(* po redu: 369*)
(*369*)  
(*BRANCH END*)
from note85 and note92 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 370*)
(*370*)  (*BRANCH NAME*)
} note note93 = this
(* po redu: 371*)
(*371*)  
(*BRANCH END*)
from note78 and note93 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 372*)
(*372*)  (*BRANCH NAME*)
} note note94 = this
(* po redu: 373*)
(*373*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 374*)
(*374*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 375*)
(*375*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 376*)
(*376*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 377*)
(*377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 378*)
(*378*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 379*)
(*379*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 380*)
(*380*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 381*)
(*381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 382*)
(*382*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 383*)
(*383*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 384*)
(*384*)  (*BRANCH NAME*)
} note note95 = this
(* po redu: 385*)
(*385*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 386*)
(*386*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 387*)
(*387*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 388*)
(*388*)  (*BRANCH NAME*)
} note note96 = this
(* po redu: 389*)
(*389*)  
(*BRANCH END*)
from note95 and note96 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 390*)
(*390*)  (*BRANCH NAME*)
} note note97 = this
(* po redu: 391*)
(*391*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 392*)
(*392*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 393*)
(*393*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 394*)
(*394*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 395*)
(*395*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 396*)
(*396*)  (*BRANCH NAME*)
} note note98 = this
(* po redu: 397*)
(*397*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 398*)
(*398*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 399*)
(*399*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 400*)
(*400*)  (*BRANCH NAME*)
} note note99 = this
(* po redu: 401*)
(*401*)  
(*BRANCH END*)
from note98 and note99 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 402*)
(*402*)  (*BRANCH NAME*)
} note note100 = this
(* po redu: 403*)
(*403*)  
(*BRANCH END*)
from note97 and note100 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 404*)
(*404*)  (*BRANCH NAME*)
} note note101 = this
(* po redu: 405*)
(*405*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 406*)
(*406*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 407*)
(*407*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 408*)
(*408*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 409*)
(*409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 410*)
(*410*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 411*)
(*411*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 412*)
(*412*)  (*BRANCH NAME*)
} note note102 = this
(* po redu: 413*)
(*413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 414*)
(*414*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 415*)
(*415*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 416*)
(*416*)  (*BRANCH NAME*)
} note note103 = this
(* po redu: 417*)
(*417*)  
(*BRANCH END*)
from note102 and note103 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 418*)
(*418*)  (*BRANCH NAME*)
} note note104 = this
(* po redu: 419*)
(*419*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 420*)
(*420*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 421*)
(*421*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 422*)
(*422*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 423*)
(*423*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 424*)
(*424*)  (*BRANCH NAME*)
} note note105 = this
(* po redu: 425*)
(*425*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 426*)
(*426*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 427*)
(*427*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 428*)
(*428*)  (*BRANCH NAME*)
} note note106 = this
(* po redu: 429*)
(*429*)  
(*BRANCH END*)
from note105 and note106 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 430*)
(*430*)  (*BRANCH NAME*)
} note note107 = this
(* po redu: 431*)
(*431*)  
(*BRANCH END*)
from note104 and note107 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 432*)
(*432*)  (*BRANCH NAME*)
} note note108 = this
(* po redu: 433*)
(*433*)  
(*BRANCH END*)
from note101 and note108 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 434*)
(*434*)  (*BRANCH NAME*)
} note note109 = this
(* po redu: 435*)
(*435*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 436*)
(*436*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 437*)
(*437*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 438*)
(*438*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 439*)
(*439*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 440*)
(*440*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 441*)
(*441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 442*)
(*442*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 443*)
(*443*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 444*)
(*444*)  (*BRANCH NAME*)
} note note110 = this
(* po redu: 445*)
(*445*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 446*)
(*446*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 447*)
(*447*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 448*)
(*448*)  (*BRANCH NAME*)
} note note111 = this
(* po redu: 449*)
(*449*)  
(*BRANCH END*)
from note110 and note111 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 450*)
(*450*)  (*BRANCH NAME*)
} note note112 = this
(* po redu: 451*)
(*451*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 452*)
(*452*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 453*)
(*453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 454*)
(*454*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 455*)
(*455*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 456*)
(*456*)  (*BRANCH NAME*)
} note note113 = this
(* po redu: 457*)
(*457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 458*)
(*458*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 459*)
(*459*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 460*)
(*460*)  (*BRANCH NAME*)
} note note114 = this
(* po redu: 461*)
(*461*)  
(*BRANCH END*)
from note113 and note114 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 462*)
(*462*)  (*BRANCH NAME*)
} note note115 = this
(* po redu: 463*)
(*463*)  
(*BRANCH END*)
from note112 and note115 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 464*)
(*464*)  (*BRANCH NAME*)
} note note116 = this
(* po redu: 465*)
(*465*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 466*)
(*466*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 467*)
(*467*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 468*)
(*468*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 469*)
(*469*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 470*)
(*470*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 471*)
(*471*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 472*)
(*472*)  (*BRANCH NAME*)
} note note117 = this
(* po redu: 473*)
(*473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 474*)
(*474*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 475*)
(*475*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 476*)
(*476*)  (*BRANCH NAME*)
} note note118 = this
(* po redu: 477*)
(*477*)  
(*BRANCH END*)
from note117 and note118 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 478*)
(*478*)  (*BRANCH NAME*)
} note note119 = this
(* po redu: 479*)
(*479*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 480*)
(*480*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 481*)
(*481*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 482*)
(*482*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 483*)
(*483*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 484*)
(*484*)  (*BRANCH NAME*)
} note note120 = this
(* po redu: 485*)
(*485*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 486*)
(*486*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 487*)
(*487*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 488*)
(*488*)  (*BRANCH NAME*)
} note note121 = this
(* po redu: 489*)
(*489*)  
(*BRANCH END*)
from note120 and note121 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 490*)
(*490*)  (*BRANCH NAME*)
} note note122 = this
(* po redu: 491*)
(*491*)  
(*BRANCH END*)
from note119 and note122 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 492*)
(*492*)  (*BRANCH NAME*)
} note note123 = this
(* po redu: 493*)
(*493*)  
(*BRANCH END*)
from note116 and note123 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 494*)
(*494*)  (*BRANCH NAME*)
} note note124 = this
(* po redu: 495*)
(*495*)  
(*BRANCH END*)
from note109 and note124 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 496*)
(*496*)  (*BRANCH NAME*)
} note note125 = this
(* po redu: 497*)
(*497*)  
(*BRANCH END*)
from note94 and note125 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 498*)
(*498*)  (*BRANCH NAME*)
} note note126 = this
(* po redu: 499*)
(*499*)  
(*BRANCH END*)
from note63 and note126 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 500*)
(*500*)  (*BRANCH NAME*)
} note note127 = this
(* po redu: 501*)
(*501*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 502*)
(*502*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 503*)
(*503*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 504*)
(*504*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 505*)
(*505*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 506*)
(*506*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 507*)
(*507*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 508*)
(*508*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 509*)
(*509*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 510*)
(*510*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 511*)
(*511*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 512*)
(*512*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 513*)
(*513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 514*)
(*514*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 515*)
(*515*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 516*)
(*516*)  (*BRANCH NAME*)
} note note128 = this
(* po redu: 517*)
(*517*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 518*)
(*518*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 519*)
(*519*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 520*)
(*520*)  (*BRANCH NAME*)
} note note129 = this
(* po redu: 521*)
(*521*)  
(*BRANCH END*)
from note128 and note129 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 522*)
(*522*)  (*BRANCH NAME*)
} note note130 = this
(* po redu: 523*)
(*523*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 524*)
(*524*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 525*)
(*525*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 526*)
(*526*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 527*)
(*527*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 528*)
(*528*)  (*BRANCH NAME*)
} note note131 = this
(* po redu: 529*)
(*529*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 530*)
(*530*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 531*)
(*531*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 532*)
(*532*)  (*BRANCH NAME*)
} note note132 = this
(* po redu: 533*)
(*533*)  
(*BRANCH END*)
from note131 and note132 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 534*)
(*534*)  (*BRANCH NAME*)
} note note133 = this
(* po redu: 535*)
(*535*)  
(*BRANCH END*)
from note130 and note133 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 536*)
(*536*)  (*BRANCH NAME*)
} note note134 = this
(* po redu: 537*)
(*537*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 538*)
(*538*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 539*)
(*539*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 540*)
(*540*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 541*)
(*541*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 542*)
(*542*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 543*)
(*543*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 544*)
(*544*)  (*BRANCH NAME*)
} note note135 = this
(* po redu: 545*)
(*545*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 546*)
(*546*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 547*)
(*547*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 548*)
(*548*)  (*BRANCH NAME*)
} note note136 = this
(* po redu: 549*)
(*549*)  
(*BRANCH END*)
from note135 and note136 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 550*)
(*550*)  (*BRANCH NAME*)
} note note137 = this
(* po redu: 551*)
(*551*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 552*)
(*552*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 553*)
(*553*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 554*)
(*554*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 555*)
(*555*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 556*)
(*556*)  (*BRANCH NAME*)
} note note138 = this
(* po redu: 557*)
(*557*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 558*)
(*558*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 559*)
(*559*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 560*)
(*560*)  (*BRANCH NAME*)
} note note139 = this
(* po redu: 561*)
(*561*)  
(*BRANCH END*)
from note138 and note139 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 562*)
(*562*)  (*BRANCH NAME*)
} note note140 = this
(* po redu: 563*)
(*563*)  
(*BRANCH END*)
from note137 and note140 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 564*)
(*564*)  (*BRANCH NAME*)
} note note141 = this
(* po redu: 565*)
(*565*)  
(*BRANCH END*)
from note134 and note141 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 566*)
(*566*)  (*BRANCH NAME*)
} note note142 = this
(* po redu: 567*)
(*567*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 568*)
(*568*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 569*)
(*569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 570*)
(*570*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 571*)
(*571*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 572*)
(*572*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 573*)
(*573*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 574*)
(*574*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 575*)
(*575*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 576*)
(*576*)  (*BRANCH NAME*)
} note note143 = this
(* po redu: 577*)
(*577*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 578*)
(*578*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 579*)
(*579*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 580*)
(*580*)  (*BRANCH NAME*)
} note note144 = this
(* po redu: 581*)
(*581*)  
(*BRANCH END*)
from note143 and note144 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 582*)
(*582*)  (*BRANCH NAME*)
} note note145 = this
(* po redu: 583*)
(*583*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 584*)
(*584*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 585*)
(*585*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 586*)
(*586*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 587*)
(*587*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 588*)
(*588*)  (*BRANCH NAME*)
} note note146 = this
(* po redu: 589*)
(*589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 590*)
(*590*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 591*)
(*591*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 592*)
(*592*)  (*BRANCH NAME*)
} note note147 = this
(* po redu: 593*)
(*593*)  
(*BRANCH END*)
from note146 and note147 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 594*)
(*594*)  (*BRANCH NAME*)
} note note148 = this
(* po redu: 595*)
(*595*)  
(*BRANCH END*)
from note145 and note148 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 596*)
(*596*)  (*BRANCH NAME*)
} note note149 = this
(* po redu: 597*)
(*597*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 598*)
(*598*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 599*)
(*599*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 600*)
(*600*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 601*)
(*601*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 602*)
(*602*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 603*)
(*603*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 604*)
(*604*)  (*BRANCH NAME*)
} note note150 = this
(* po redu: 605*)
(*605*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 606*)
(*606*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 607*)
(*607*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 608*)
(*608*)  (*BRANCH NAME*)
} note note151 = this
(* po redu: 609*)
(*609*)  
(*BRANCH END*)
from note150 and note151 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 610*)
(*610*)  (*BRANCH NAME*)
} note note152 = this
(* po redu: 611*)
(*611*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 612*)
(*612*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 613*)
(*613*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 614*)
(*614*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 615*)
(*615*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 616*)
(*616*)  (*BRANCH NAME*)
} note note153 = this
(* po redu: 617*)
(*617*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 618*)
(*618*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 619*)
(*619*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 620*)
(*620*)  (*BRANCH NAME*)
} note note154 = this
(* po redu: 621*)
(*621*)  
(*BRANCH END*)
from note153 and note154 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 622*)
(*622*)  (*BRANCH NAME*)
} note note155 = this
(* po redu: 623*)
(*623*)  
(*BRANCH END*)
from note152 and note155 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 624*)
(*624*)  (*BRANCH NAME*)
} note note156 = this
(* po redu: 625*)
(*625*)  
(*BRANCH END*)
from note149 and note156 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 626*)
(*626*)  (*BRANCH NAME*)
} note note157 = this
(* po redu: 627*)
(*627*)  
(*BRANCH END*)
from note142 and note157 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 628*)
(*628*)  (*BRANCH NAME*)
} note note158 = this
(* po redu: 629*)
(*629*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 630*)
(*630*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 631*)
(*631*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 632*)
(*632*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 633*)
(*633*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 634*)
(*634*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 635*)
(*635*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 636*)
(*636*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 637*)
(*637*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 638*)
(*638*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 639*)
(*639*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 640*)
(*640*)  (*BRANCH NAME*)
} note note159 = this
(* po redu: 641*)
(*641*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 642*)
(*642*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 643*)
(*643*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 644*)
(*644*)  (*BRANCH NAME*)
} note note160 = this
(* po redu: 645*)
(*645*)  
(*BRANCH END*)
from note159 and note160 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 646*)
(*646*)  (*BRANCH NAME*)
} note note161 = this
(* po redu: 647*)
(*647*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 648*)
(*648*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 649*)
(*649*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 650*)
(*650*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 651*)
(*651*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 652*)
(*652*)  (*BRANCH NAME*)
} note note162 = this
(* po redu: 653*)
(*653*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 654*)
(*654*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 655*)
(*655*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 656*)
(*656*)  (*BRANCH NAME*)
} note note163 = this
(* po redu: 657*)
(*657*)  
(*BRANCH END*)
from note162 and note163 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 658*)
(*658*)  (*BRANCH NAME*)
} note note164 = this
(* po redu: 659*)
(*659*)  
(*BRANCH END*)
from note161 and note164 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 660*)
(*660*)  (*BRANCH NAME*)
} note note165 = this
(* po redu: 661*)
(*661*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 662*)
(*662*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 663*)
(*663*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 664*)
(*664*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 665*)
(*665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 666*)
(*666*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 667*)
(*667*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 668*)
(*668*)  (*BRANCH NAME*)
} note note166 = this
(* po redu: 669*)
(*669*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 670*)
(*670*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 671*)
(*671*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 672*)
(*672*)  (*BRANCH NAME*)
} note note167 = this
(* po redu: 673*)
(*673*)  
(*BRANCH END*)
from note166 and note167 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 674*)
(*674*)  (*BRANCH NAME*)
} note note168 = this
(* po redu: 675*)
(*675*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 676*)
(*676*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 677*)
(*677*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 678*)
(*678*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 679*)
(*679*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 680*)
(*680*)  (*BRANCH NAME*)
} note note169 = this
(* po redu: 681*)
(*681*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 682*)
(*682*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 683*)
(*683*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 684*)
(*684*)  (*BRANCH NAME*)
} note note170 = this
(* po redu: 685*)
(*685*)  
(*BRANCH END*)
from note169 and note170 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 686*)
(*686*)  (*BRANCH NAME*)
} note note171 = this
(* po redu: 687*)
(*687*)  
(*BRANCH END*)
from note168 and note171 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 688*)
(*688*)  (*BRANCH NAME*)
} note note172 = this
(* po redu: 689*)
(*689*)  
(*BRANCH END*)
from note165 and note172 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 690*)
(*690*)  (*BRANCH NAME*)
} note note173 = this
(* po redu: 691*)
(*691*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 692*)
(*692*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 693*)
(*693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 694*)
(*694*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 695*)
(*695*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 696*)
(*696*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 697*)
(*697*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 698*)
(*698*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 699*)
(*699*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 700*)
(*700*)  (*BRANCH NAME*)
} note note174 = this
(* po redu: 701*)
(*701*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 702*)
(*702*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 703*)
(*703*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 704*)
(*704*)  (*BRANCH NAME*)
} note note175 = this
(* po redu: 705*)
(*705*)  
(*BRANCH END*)
from note174 and note175 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 706*)
(*706*)  (*BRANCH NAME*)
} note note176 = this
(* po redu: 707*)
(*707*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 708*)
(*708*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 709*)
(*709*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 710*)
(*710*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 711*)
(*711*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 712*)
(*712*)  (*BRANCH NAME*)
} note note177 = this
(* po redu: 713*)
(*713*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 714*)
(*714*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 715*)
(*715*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 716*)
(*716*)  (*BRANCH NAME*)
} note note178 = this
(* po redu: 717*)
(*717*)  
(*BRANCH END*)
from note177 and note178 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 718*)
(*718*)  (*BRANCH NAME*)
} note note179 = this
(* po redu: 719*)
(*719*)  
(*BRANCH END*)
from note176 and note179 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 720*)
(*720*)  (*BRANCH NAME*)
} note note180 = this
(* po redu: 721*)
(*721*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 722*)
(*722*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 723*)
(*723*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 724*)
(*724*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 725*)
(*725*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 726*)
(*726*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 727*)
(*727*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 728*)
(*728*)  (*BRANCH NAME*)
} note note181 = this
(* po redu: 729*)
(*729*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 730*)
(*730*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 731*)
(*731*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 732*)
(*732*)  (*BRANCH NAME*)
} note note182 = this
(* po redu: 733*)
(*733*)  
(*BRANCH END*)
from note181 and note182 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 734*)
(*734*)  (*BRANCH NAME*)
} note note183 = this
(* po redu: 735*)
(*735*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 736*)
(*736*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 737*)
(*737*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 738*)
(*738*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 739*)
(*739*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 740*)
(*740*)  (*BRANCH NAME*)
} note note184 = this
(* po redu: 741*)
(*741*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 742*)
(*742*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 743*)
(*743*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 744*)
(*744*)  (*BRANCH NAME*)
} note note185 = this
(* po redu: 745*)
(*745*)  
(*BRANCH END*)
from note184 and note185 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 746*)
(*746*)  (*BRANCH NAME*)
} note note186 = this
(* po redu: 747*)
(*747*)  
(*BRANCH END*)
from note183 and note186 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 748*)
(*748*)  (*BRANCH NAME*)
} note note187 = this
(* po redu: 749*)
(*749*)  
(*BRANCH END*)
from note180 and note187 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 750*)
(*750*)  (*BRANCH NAME*)
} note note188 = this
(* po redu: 751*)
(*751*)  
(*BRANCH END*)
from note173 and note188 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 752*)
(*752*)  (*BRANCH NAME*)
} note note189 = this
(* po redu: 753*)
(*753*)  
(*BRANCH END*)
from note158 and note189 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 754*)
(*754*)  (*BRANCH NAME*)
} note note190 = this
(* po redu: 755*)
(*755*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 756*)
(*756*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 757*)
(*757*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 758*)
(*758*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 759*)
(*759*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 760*)
(*760*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 761*)
(*761*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 762*)
(*762*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 763*)
(*763*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 764*)
(*764*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 765*)
(*765*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 766*)
(*766*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 767*)
(*767*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 768*)
(*768*)  (*BRANCH NAME*)
} note note191 = this
(* po redu: 769*)
(*769*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 770*)
(*770*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 771*)
(*771*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 772*)
(*772*)  (*BRANCH NAME*)
} note note192 = this
(* po redu: 773*)
(*773*)  
(*BRANCH END*)
from note191 and note192 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 774*)
(*774*)  (*BRANCH NAME*)
} note note193 = this
(* po redu: 775*)
(*775*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 776*)
(*776*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 777*)
(*777*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 778*)
(*778*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 779*)
(*779*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 780*)
(*780*)  (*BRANCH NAME*)
} note note194 = this
(* po redu: 781*)
(*781*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 782*)
(*782*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 783*)
(*783*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 784*)
(*784*)  (*BRANCH NAME*)
} note note195 = this
(* po redu: 785*)
(*785*)  
(*BRANCH END*)
from note194 and note195 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 786*)
(*786*)  (*BRANCH NAME*)
} note note196 = this
(* po redu: 787*)
(*787*)  
(*BRANCH END*)
from note193 and note196 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 788*)
(*788*)  (*BRANCH NAME*)
} note note197 = this
(* po redu: 789*)
(*789*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 790*)
(*790*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 791*)
(*791*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 792*)
(*792*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 793*)
(*793*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 794*)
(*794*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 795*)
(*795*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 796*)
(*796*)  (*BRANCH NAME*)
} note note198 = this
(* po redu: 797*)
(*797*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 798*)
(*798*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 799*)
(*799*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 800*)
(*800*)  (*BRANCH NAME*)
} note note199 = this
(* po redu: 801*)
(*801*)  
(*BRANCH END*)
from note198 and note199 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 802*)
(*802*)  (*BRANCH NAME*)
} note note200 = this
(* po redu: 803*)
(*803*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 804*)
(*804*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 805*)
(*805*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 806*)
(*806*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 807*)
(*807*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 808*)
(*808*)  (*BRANCH NAME*)
} note note201 = this
(* po redu: 809*)
(*809*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 810*)
(*810*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 811*)
(*811*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 812*)
(*812*)  (*BRANCH NAME*)
} note note202 = this
(* po redu: 813*)
(*813*)  
(*BRANCH END*)
from note201 and note202 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 814*)
(*814*)  (*BRANCH NAME*)
} note note203 = this
(* po redu: 815*)
(*815*)  
(*BRANCH END*)
from note200 and note203 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 816*)
(*816*)  (*BRANCH NAME*)
} note note204 = this
(* po redu: 817*)
(*817*)  
(*BRANCH END*)
from note197 and note204 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 818*)
(*818*)  (*BRANCH NAME*)
} note note205 = this
(* po redu: 819*)
(*819*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 820*)
(*820*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 821*)
(*821*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 822*)
(*822*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 823*)
(*823*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 824*)
(*824*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 825*)
(*825*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 826*)
(*826*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 827*)
(*827*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 828*)
(*828*)  (*BRANCH NAME*)
} note note206 = this
(* po redu: 829*)
(*829*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 830*)
(*830*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 831*)
(*831*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 832*)
(*832*)  (*BRANCH NAME*)
} note note207 = this
(* po redu: 833*)
(*833*)  
(*BRANCH END*)
from note206 and note207 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 834*)
(*834*)  (*BRANCH NAME*)
} note note208 = this
(* po redu: 835*)
(*835*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 836*)
(*836*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 837*)
(*837*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 838*)
(*838*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 839*)
(*839*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 840*)
(*840*)  (*BRANCH NAME*)
} note note209 = this
(* po redu: 841*)
(*841*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 842*)
(*842*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 843*)
(*843*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 844*)
(*844*)  (*BRANCH NAME*)
} note note210 = this
(* po redu: 845*)
(*845*)  
(*BRANCH END*)
from note209 and note210 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 846*)
(*846*)  (*BRANCH NAME*)
} note note211 = this
(* po redu: 847*)
(*847*)  
(*BRANCH END*)
from note208 and note211 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 848*)
(*848*)  (*BRANCH NAME*)
} note note212 = this
(* po redu: 849*)
(*849*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 850*)
(*850*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 851*)
(*851*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 852*)
(*852*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 853*)
(*853*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 854*)
(*854*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 855*)
(*855*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 856*)
(*856*)  (*BRANCH NAME*)
} note note213 = this
(* po redu: 857*)
(*857*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 858*)
(*858*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 859*)
(*859*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 860*)
(*860*)  (*BRANCH NAME*)
} note note214 = this
(* po redu: 861*)
(*861*)  
(*BRANCH END*)
from note213 and note214 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 862*)
(*862*)  (*BRANCH NAME*)
} note note215 = this
(* po redu: 863*)
(*863*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 864*)
(*864*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 865*)
(*865*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 866*)
(*866*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 867*)
(*867*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 868*)
(*868*)  (*BRANCH NAME*)
} note note216 = this
(* po redu: 869*)
(*869*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 870*)
(*870*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 871*)
(*871*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 872*)
(*872*)  (*BRANCH NAME*)
} note note217 = this
(* po redu: 873*)
(*873*)  
(*BRANCH END*)
from note216 and note217 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 874*)
(*874*)  (*BRANCH NAME*)
} note note218 = this
(* po redu: 875*)
(*875*)  
(*BRANCH END*)
from note215 and note218 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 876*)
(*876*)  (*BRANCH NAME*)
} note note219 = this
(* po redu: 877*)
(*877*)  
(*BRANCH END*)
from note212 and note219 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 878*)
(*878*)  (*BRANCH NAME*)
} note note220 = this
(* po redu: 879*)
(*879*)  
(*BRANCH END*)
from note205 and note220 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 880*)
(*880*)  (*BRANCH NAME*)
} note note221 = this
(* po redu: 881*)
(*881*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 882*)
(*882*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 883*)
(*883*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 884*)
(*884*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 885*)
(*885*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 886*)
(*886*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 887*)
(*887*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 888*)
(*888*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 889*)
(*889*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 890*)
(*890*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 891*)
(*891*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 892*)
(*892*)  (*BRANCH NAME*)
} note note222 = this
(* po redu: 893*)
(*893*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 894*)
(*894*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 895*)
(*895*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 896*)
(*896*)  (*BRANCH NAME*)
} note note223 = this
(* po redu: 897*)
(*897*)  
(*BRANCH END*)
from note222 and note223 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 898*)
(*898*)  (*BRANCH NAME*)
} note note224 = this
(* po redu: 899*)
(*899*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 900*)
(*900*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 901*)
(*901*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 902*)
(*902*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 903*)
(*903*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 904*)
(*904*)  (*BRANCH NAME*)
} note note225 = this
(* po redu: 905*)
(*905*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 906*)
(*906*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 907*)
(*907*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 908*)
(*908*)  (*BRANCH NAME*)
} note note226 = this
(* po redu: 909*)
(*909*)  
(*BRANCH END*)
from note225 and note226 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 910*)
(*910*)  (*BRANCH NAME*)
} note note227 = this
(* po redu: 911*)
(*911*)  
(*BRANCH END*)
from note224 and note227 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 912*)
(*912*)  (*BRANCH NAME*)
} note note228 = this
(* po redu: 913*)
(*913*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 914*)
(*914*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 915*)
(*915*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 916*)
(*916*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 917*)
(*917*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 918*)
(*918*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 919*)
(*919*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 920*)
(*920*)  (*BRANCH NAME*)
} note note229 = this
(* po redu: 921*)
(*921*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 922*)
(*922*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 923*)
(*923*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 924*)
(*924*)  (*BRANCH NAME*)
} note note230 = this
(* po redu: 925*)
(*925*)  
(*BRANCH END*)
from note229 and note230 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 926*)
(*926*)  (*BRANCH NAME*)
} note note231 = this
(* po redu: 927*)
(*927*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 928*)
(*928*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 929*)
(*929*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 930*)
(*930*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 931*)
(*931*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 932*)
(*932*)  (*BRANCH NAME*)
} note note232 = this
(* po redu: 933*)
(*933*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 934*)
(*934*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 935*)
(*935*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 936*)
(*936*)  (*BRANCH NAME*)
} note note233 = this
(* po redu: 937*)
(*937*)  
(*BRANCH END*)
from note232 and note233 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 938*)
(*938*)  (*BRANCH NAME*)
} note note234 = this
(* po redu: 939*)
(*939*)  
(*BRANCH END*)
from note231 and note234 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 940*)
(*940*)  (*BRANCH NAME*)
} note note235 = this
(* po redu: 941*)
(*941*)  
(*BRANCH END*)
from note228 and note235 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 942*)
(*942*)  (*BRANCH NAME*)
} note note236 = this
(* po redu: 943*)
(*943*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 944*)
(*944*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 945*)
(*945*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 946*)
(*946*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 947*)
(*947*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 948*)
(*948*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 949*)
(*949*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 950*)
(*950*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 951*)
(*951*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 952*)
(*952*)  (*BRANCH NAME*)
} note note237 = this
(* po redu: 953*)
(*953*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 954*)
(*954*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 955*)
(*955*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 956*)
(*956*)  (*BRANCH NAME*)
} note note238 = this
(* po redu: 957*)
(*957*)  
(*BRANCH END*)
from note237 and note238 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 958*)
(*958*)  (*BRANCH NAME*)
} note note239 = this
(* po redu: 959*)
(*959*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 960*)
(*960*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 961*)
(*961*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 962*)
(*962*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 963*)
(*963*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 964*)
(*964*)  (*BRANCH NAME*)
} note note240 = this
(* po redu: 965*)
(*965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 966*)
(*966*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 967*)
(*967*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 968*)
(*968*)  (*BRANCH NAME*)
} note note241 = this
(* po redu: 969*)
(*969*)  
(*BRANCH END*)
from note240 and note241 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 970*)
(*970*)  (*BRANCH NAME*)
} note note242 = this
(* po redu: 971*)
(*971*)  
(*BRANCH END*)
from note239 and note242 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 972*)
(*972*)  (*BRANCH NAME*)
} note note243 = this
(* po redu: 973*)
(*973*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 974*)
(*974*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 975*)
(*975*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 976*)
(*976*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 977*)
(*977*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 978*)
(*978*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 979*)
(*979*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 980*)
(*980*)  (*BRANCH NAME*)
} note note244 = this
(* po redu: 981*)
(*981*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 982*)
(*982*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 983*)
(*983*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 984*)
(*984*)  (*BRANCH NAME*)
} note note245 = this
(* po redu: 985*)
(*985*)  
(*BRANCH END*)
from note244 and note245 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 986*)
(*986*)  (*BRANCH NAME*)
} note note246 = this
(* po redu: 987*)
(*987*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 988*)
(*988*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 989*)
(*989*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 990*)
(*990*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 991*)
(*991*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 992*)
(*992*)  (*BRANCH NAME*)
} note note247 = this
(* po redu: 993*)
(*993*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 994*)
(*994*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 995*)
(*995*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 996*)
(*996*)  (*BRANCH NAME*)
} note note248 = this
(* po redu: 997*)
(*997*)  
(*BRANCH END*)
from note247 and note248 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 998*)
(*998*)  (*BRANCH NAME*)
} note note249 = this
(* po redu: 999*)
(*999*)  
(*BRANCH END*)
from note246 and note249 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1000*)
(*1000*)  (*BRANCH NAME*)
} note note250 = this
(* po redu: 1001*)
(*1001*)  
(*BRANCH END*)
from note243 and note250 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1002*)
(*1002*)  (*BRANCH NAME*)
} note note251 = this
(* po redu: 1003*)
(*1003*)  
(*BRANCH END*)
from note236 and note251 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 1004*)
(*1004*)  (*BRANCH NAME*)
} note note252 = this
(* po redu: 1005*)
(*1005*)  
(*BRANCH END*)
from note221 and note252 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 1006*)
(*1006*)  (*BRANCH NAME*)
} note note253 = this
(* po redu: 1007*)
(*1007*)  
(*BRANCH END*)
from note190 and note253 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 1008*)
(*1008*)  (*BRANCH NAME*)
} note note254 = this
(* po redu: 1009*)
(*1009*)  
(*BRANCH END*)
from note127 and note254 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 1010*)
(*1010*)  (*BRANCH NAME*)
} note note255 = this
(* po redu: 1011*)
(*1011*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 1012*)
(*1012*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 1013*)
(*1013*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 1014*)
(*1014*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 1015*)
(*1015*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 1016*)
(*1016*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 1017*)
(*1017*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 1018*)
(*1018*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 1019*)
(*1019*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 1020*)
(*1020*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1021*)
(*1021*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1022*)
(*1022*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1023*)
(*1023*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1024*)
(*1024*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1025*)
(*1025*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1026*)
(*1026*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1027*)
(*1027*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1028*)
(*1028*)  (*BRANCH NAME*)
} note note256 = this
(* po redu: 1029*)
(*1029*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1030*)
(*1030*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1031*)
(*1031*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1032*)
(*1032*)  (*BRANCH NAME*)
} note note257 = this
(* po redu: 1033*)
(*1033*)  
(*BRANCH END*)
from note256 and note257 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1034*)
(*1034*)  (*BRANCH NAME*)
} note note258 = this
(* po redu: 1035*)
(*1035*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1036*)
(*1036*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1037*)
(*1037*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1038*)
(*1038*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1039*)
(*1039*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1040*)
(*1040*)  (*BRANCH NAME*)
} note note259 = this
(* po redu: 1041*)
(*1041*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1042*)
(*1042*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1043*)
(*1043*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1044*)
(*1044*)  (*BRANCH NAME*)
} note note260 = this
(* po redu: 1045*)
(*1045*)  
(*BRANCH END*)
from note259 and note260 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1046*)
(*1046*)  (*BRANCH NAME*)
} note note261 = this
(* po redu: 1047*)
(*1047*)  
(*BRANCH END*)
from note258 and note261 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1048*)
(*1048*)  (*BRANCH NAME*)
} note note262 = this
(* po redu: 1049*)
(*1049*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1050*)
(*1050*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1051*)
(*1051*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1052*)
(*1052*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1053*)
(*1053*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1054*)
(*1054*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1055*)
(*1055*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1056*)
(*1056*)  (*BRANCH NAME*)
} note note263 = this
(* po redu: 1057*)
(*1057*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1058*)
(*1058*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1059*)
(*1059*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1060*)
(*1060*)  (*BRANCH NAME*)
} note note264 = this
(* po redu: 1061*)
(*1061*)  
(*BRANCH END*)
from note263 and note264 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1062*)
(*1062*)  (*BRANCH NAME*)
} note note265 = this
(* po redu: 1063*)
(*1063*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1064*)
(*1064*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1065*)
(*1065*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1066*)
(*1066*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1067*)
(*1067*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1068*)
(*1068*)  (*BRANCH NAME*)
} note note266 = this
(* po redu: 1069*)
(*1069*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1070*)
(*1070*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1071*)
(*1071*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1072*)
(*1072*)  (*BRANCH NAME*)
} note note267 = this
(* po redu: 1073*)
(*1073*)  
(*BRANCH END*)
from note266 and note267 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1074*)
(*1074*)  (*BRANCH NAME*)
} note note268 = this
(* po redu: 1075*)
(*1075*)  
(*BRANCH END*)
from note265 and note268 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1076*)
(*1076*)  (*BRANCH NAME*)
} note note269 = this
(* po redu: 1077*)
(*1077*)  
(*BRANCH END*)
from note262 and note269 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1078*)
(*1078*)  (*BRANCH NAME*)
} note note270 = this
(* po redu: 1079*)
(*1079*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1080*)
(*1080*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1081*)
(*1081*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1082*)
(*1082*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1083*)
(*1083*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1084*)
(*1084*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1085*)
(*1085*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1086*)
(*1086*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1087*)
(*1087*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1088*)
(*1088*)  (*BRANCH NAME*)
} note note271 = this
(* po redu: 1089*)
(*1089*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1090*)
(*1090*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1091*)
(*1091*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1092*)
(*1092*)  (*BRANCH NAME*)
} note note272 = this
(* po redu: 1093*)
(*1093*)  
(*BRANCH END*)
from note271 and note272 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1094*)
(*1094*)  (*BRANCH NAME*)
} note note273 = this
(* po redu: 1095*)
(*1095*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1096*)
(*1096*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1097*)
(*1097*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1098*)
(*1098*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1099*)
(*1099*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1100*)
(*1100*)  (*BRANCH NAME*)
} note note274 = this
(* po redu: 1101*)
(*1101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1102*)
(*1102*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1103*)
(*1103*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1104*)
(*1104*)  (*BRANCH NAME*)
} note note275 = this
(* po redu: 1105*)
(*1105*)  
(*BRANCH END*)
from note274 and note275 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1106*)
(*1106*)  (*BRANCH NAME*)
} note note276 = this
(* po redu: 1107*)
(*1107*)  
(*BRANCH END*)
from note273 and note276 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1108*)
(*1108*)  (*BRANCH NAME*)
} note note277 = this
(* po redu: 1109*)
(*1109*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1110*)
(*1110*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1111*)
(*1111*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1112*)
(*1112*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1113*)
(*1113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1114*)
(*1114*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1115*)
(*1115*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1116*)
(*1116*)  (*BRANCH NAME*)
} note note278 = this
(* po redu: 1117*)
(*1117*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1118*)
(*1118*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1119*)
(*1119*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1120*)
(*1120*)  (*BRANCH NAME*)
} note note279 = this
(* po redu: 1121*)
(*1121*)  
(*BRANCH END*)
from note278 and note279 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1122*)
(*1122*)  (*BRANCH NAME*)
} note note280 = this
(* po redu: 1123*)
(*1123*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1124*)
(*1124*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1125*)
(*1125*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1126*)
(*1126*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1127*)
(*1127*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1128*)
(*1128*)  (*BRANCH NAME*)
} note note281 = this
(* po redu: 1129*)
(*1129*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1130*)
(*1130*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1131*)
(*1131*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1132*)
(*1132*)  (*BRANCH NAME*)
} note note282 = this
(* po redu: 1133*)
(*1133*)  
(*BRANCH END*)
from note281 and note282 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1134*)
(*1134*)  (*BRANCH NAME*)
} note note283 = this
(* po redu: 1135*)
(*1135*)  
(*BRANCH END*)
from note280 and note283 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1136*)
(*1136*)  (*BRANCH NAME*)
} note note284 = this
(* po redu: 1137*)
(*1137*)  
(*BRANCH END*)
from note277 and note284 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1138*)
(*1138*)  (*BRANCH NAME*)
} note note285 = this
(* po redu: 1139*)
(*1139*)  
(*BRANCH END*)
from note270 and note285 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 1140*)
(*1140*)  (*BRANCH NAME*)
} note note286 = this
(* po redu: 1141*)
(*1141*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 1142*)
(*1142*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 1143*)
(*1143*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 1144*)
(*1144*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1145*)
(*1145*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1146*)
(*1146*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1147*)
(*1147*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1148*)
(*1148*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1149*)
(*1149*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1150*)
(*1150*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1151*)
(*1151*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1152*)
(*1152*)  (*BRANCH NAME*)
} note note287 = this
(* po redu: 1153*)
(*1153*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1154*)
(*1154*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1155*)
(*1155*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1156*)
(*1156*)  (*BRANCH NAME*)
} note note288 = this
(* po redu: 1157*)
(*1157*)  
(*BRANCH END*)
from note287 and note288 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1158*)
(*1158*)  (*BRANCH NAME*)
} note note289 = this
(* po redu: 1159*)
(*1159*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1160*)
(*1160*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1161*)
(*1161*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1162*)
(*1162*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1163*)
(*1163*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1164*)
(*1164*)  (*BRANCH NAME*)
} note note290 = this
(* po redu: 1165*)
(*1165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1166*)
(*1166*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1167*)
(*1167*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1168*)
(*1168*)  (*BRANCH NAME*)
} note note291 = this
(* po redu: 1169*)
(*1169*)  
(*BRANCH END*)
from note290 and note291 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1170*)
(*1170*)  (*BRANCH NAME*)
} note note292 = this
(* po redu: 1171*)
(*1171*)  
(*BRANCH END*)
from note289 and note292 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1172*)
(*1172*)  (*BRANCH NAME*)
} note note293 = this
(* po redu: 1173*)
(*1173*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1174*)
(*1174*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1175*)
(*1175*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1176*)
(*1176*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1177*)
(*1177*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1178*)
(*1178*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1179*)
(*1179*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1180*)
(*1180*)  (*BRANCH NAME*)
} note note294 = this
(* po redu: 1181*)
(*1181*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1182*)
(*1182*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1183*)
(*1183*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1184*)
(*1184*)  (*BRANCH NAME*)
} note note295 = this
(* po redu: 1185*)
(*1185*)  
(*BRANCH END*)
from note294 and note295 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1186*)
(*1186*)  (*BRANCH NAME*)
} note note296 = this
(* po redu: 1187*)
(*1187*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1188*)
(*1188*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1189*)
(*1189*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1190*)
(*1190*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1191*)
(*1191*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1192*)
(*1192*)  (*BRANCH NAME*)
} note note297 = this
(* po redu: 1193*)
(*1193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1194*)
(*1194*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1195*)
(*1195*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1196*)
(*1196*)  (*BRANCH NAME*)
} note note298 = this
(* po redu: 1197*)
(*1197*)  
(*BRANCH END*)
from note297 and note298 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1198*)
(*1198*)  (*BRANCH NAME*)
} note note299 = this
(* po redu: 1199*)
(*1199*)  
(*BRANCH END*)
from note296 and note299 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1200*)
(*1200*)  (*BRANCH NAME*)
} note note300 = this
(* po redu: 1201*)
(*1201*)  
(*BRANCH END*)
from note293 and note300 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1202*)
(*1202*)  (*BRANCH NAME*)
} note note301 = this
(* po redu: 1203*)
(*1203*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1204*)
(*1204*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1205*)
(*1205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1206*)
(*1206*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1207*)
(*1207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1208*)
(*1208*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1209*)
(*1209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1210*)
(*1210*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1211*)
(*1211*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1212*)
(*1212*)  (*BRANCH NAME*)
} note note302 = this
(* po redu: 1213*)
(*1213*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1214*)
(*1214*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1215*)
(*1215*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1216*)
(*1216*)  (*BRANCH NAME*)
} note note303 = this
(* po redu: 1217*)
(*1217*)  
(*BRANCH END*)
from note302 and note303 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1218*)
(*1218*)  (*BRANCH NAME*)
} note note304 = this
(* po redu: 1219*)
(*1219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1220*)
(*1220*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1221*)
(*1221*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1222*)
(*1222*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1223*)
(*1223*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1224*)
(*1224*)  (*BRANCH NAME*)
} note note305 = this
(* po redu: 1225*)
(*1225*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1226*)
(*1226*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1227*)
(*1227*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1228*)
(*1228*)  (*BRANCH NAME*)
} note note306 = this
(* po redu: 1229*)
(*1229*)  
(*BRANCH END*)
from note305 and note306 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1230*)
(*1230*)  (*BRANCH NAME*)
} note note307 = this
(* po redu: 1231*)
(*1231*)  
(*BRANCH END*)
from note304 and note307 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1232*)
(*1232*)  (*BRANCH NAME*)
} note note308 = this
(* po redu: 1233*)
(*1233*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1234*)
(*1234*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1235*)
(*1235*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1236*)
(*1236*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1237*)
(*1237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1238*)
(*1238*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1239*)
(*1239*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1240*)
(*1240*)  (*BRANCH NAME*)
} note note309 = this
(* po redu: 1241*)
(*1241*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1242*)
(*1242*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1243*)
(*1243*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1244*)
(*1244*)  (*BRANCH NAME*)
} note note310 = this
(* po redu: 1245*)
(*1245*)  
(*BRANCH END*)
from note309 and note310 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1246*)
(*1246*)  (*BRANCH NAME*)
} note note311 = this
(* po redu: 1247*)
(*1247*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1248*)
(*1248*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1249*)
(*1249*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1250*)
(*1250*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1251*)
(*1251*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1252*)
(*1252*)  (*BRANCH NAME*)
} note note312 = this
(* po redu: 1253*)
(*1253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1254*)
(*1254*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1255*)
(*1255*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1256*)
(*1256*)  (*BRANCH NAME*)
} note note313 = this
(* po redu: 1257*)
(*1257*)  
(*BRANCH END*)
from note312 and note313 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1258*)
(*1258*)  (*BRANCH NAME*)
} note note314 = this
(* po redu: 1259*)
(*1259*)  
(*BRANCH END*)
from note311 and note314 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1260*)
(*1260*)  (*BRANCH NAME*)
} note note315 = this
(* po redu: 1261*)
(*1261*)  
(*BRANCH END*)
from note308 and note315 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1262*)
(*1262*)  (*BRANCH NAME*)
} note note316 = this
(* po redu: 1263*)
(*1263*)  
(*BRANCH END*)
from note301 and note316 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 1264*)
(*1264*)  (*BRANCH NAME*)
} note note317 = this
(* po redu: 1265*)
(*1265*)  
(*BRANCH END*)
from note286 and note317 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 1266*)
(*1266*)  (*BRANCH NAME*)
} note note318 = this
(* po redu: 1267*)
(*1267*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 1268*)
(*1268*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 1269*)
(*1269*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 1270*)
(*1270*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 1271*)
(*1271*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 1272*)
(*1272*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1273*)
(*1273*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1274*)
(*1274*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1275*)
(*1275*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1276*)
(*1276*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1277*)
(*1277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1278*)
(*1278*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1279*)
(*1279*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1280*)
(*1280*)  (*BRANCH NAME*)
} note note319 = this
(* po redu: 1281*)
(*1281*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1282*)
(*1282*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1283*)
(*1283*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1284*)
(*1284*)  (*BRANCH NAME*)
} note note320 = this
(* po redu: 1285*)
(*1285*)  
(*BRANCH END*)
from note319 and note320 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1286*)
(*1286*)  (*BRANCH NAME*)
} note note321 = this
(* po redu: 1287*)
(*1287*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1288*)
(*1288*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1289*)
(*1289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1290*)
(*1290*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1291*)
(*1291*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1292*)
(*1292*)  (*BRANCH NAME*)
} note note322 = this
(* po redu: 1293*)
(*1293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1294*)
(*1294*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1295*)
(*1295*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1296*)
(*1296*)  (*BRANCH NAME*)
} note note323 = this
(* po redu: 1297*)
(*1297*)  
(*BRANCH END*)
from note322 and note323 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1298*)
(*1298*)  (*BRANCH NAME*)
} note note324 = this
(* po redu: 1299*)
(*1299*)  
(*BRANCH END*)
from note321 and note324 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1300*)
(*1300*)  (*BRANCH NAME*)
} note note325 = this
(* po redu: 1301*)
(*1301*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1302*)
(*1302*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1303*)
(*1303*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1304*)
(*1304*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1305*)
(*1305*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1306*)
(*1306*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1307*)
(*1307*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1308*)
(*1308*)  (*BRANCH NAME*)
} note note326 = this
(* po redu: 1309*)
(*1309*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1310*)
(*1310*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1311*)
(*1311*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1312*)
(*1312*)  (*BRANCH NAME*)
} note note327 = this
(* po redu: 1313*)
(*1313*)  
(*BRANCH END*)
from note326 and note327 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1314*)
(*1314*)  (*BRANCH NAME*)
} note note328 = this
(* po redu: 1315*)
(*1315*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1316*)
(*1316*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1317*)
(*1317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1318*)
(*1318*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1319*)
(*1319*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1320*)
(*1320*)  (*BRANCH NAME*)
} note note329 = this
(* po redu: 1321*)
(*1321*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1322*)
(*1322*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1323*)
(*1323*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1324*)
(*1324*)  (*BRANCH NAME*)
} note note330 = this
(* po redu: 1325*)
(*1325*)  
(*BRANCH END*)
from note329 and note330 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1326*)
(*1326*)  (*BRANCH NAME*)
} note note331 = this
(* po redu: 1327*)
(*1327*)  
(*BRANCH END*)
from note328 and note331 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1328*)
(*1328*)  (*BRANCH NAME*)
} note note332 = this
(* po redu: 1329*)
(*1329*)  
(*BRANCH END*)
from note325 and note332 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1330*)
(*1330*)  (*BRANCH NAME*)
} note note333 = this
(* po redu: 1331*)
(*1331*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1332*)
(*1332*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1333*)
(*1333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1334*)
(*1334*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1335*)
(*1335*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1336*)
(*1336*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1337*)
(*1337*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1338*)
(*1338*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1339*)
(*1339*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1340*)
(*1340*)  (*BRANCH NAME*)
} note note334 = this
(* po redu: 1341*)
(*1341*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1342*)
(*1342*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1343*)
(*1343*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1344*)
(*1344*)  (*BRANCH NAME*)
} note note335 = this
(* po redu: 1345*)
(*1345*)  
(*BRANCH END*)
from note334 and note335 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1346*)
(*1346*)  (*BRANCH NAME*)
} note note336 = this
(* po redu: 1347*)
(*1347*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1348*)
(*1348*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1349*)
(*1349*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1350*)
(*1350*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1351*)
(*1351*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1352*)
(*1352*)  (*BRANCH NAME*)
} note note337 = this
(* po redu: 1353*)
(*1353*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1354*)
(*1354*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1355*)
(*1355*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1356*)
(*1356*)  (*BRANCH NAME*)
} note note338 = this
(* po redu: 1357*)
(*1357*)  
(*BRANCH END*)
from note337 and note338 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1358*)
(*1358*)  (*BRANCH NAME*)
} note note339 = this
(* po redu: 1359*)
(*1359*)  
(*BRANCH END*)
from note336 and note339 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1360*)
(*1360*)  (*BRANCH NAME*)
} note note340 = this
(* po redu: 1361*)
(*1361*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1362*)
(*1362*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1363*)
(*1363*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1364*)
(*1364*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1365*)
(*1365*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1366*)
(*1366*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1367*)
(*1367*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1368*)
(*1368*)  (*BRANCH NAME*)
} note note341 = this
(* po redu: 1369*)
(*1369*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1370*)
(*1370*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1371*)
(*1371*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1372*)
(*1372*)  (*BRANCH NAME*)
} note note342 = this
(* po redu: 1373*)
(*1373*)  
(*BRANCH END*)
from note341 and note342 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1374*)
(*1374*)  (*BRANCH NAME*)
} note note343 = this
(* po redu: 1375*)
(*1375*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1376*)
(*1376*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1377*)
(*1377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1378*)
(*1378*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1379*)
(*1379*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1380*)
(*1380*)  (*BRANCH NAME*)
} note note344 = this
(* po redu: 1381*)
(*1381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1382*)
(*1382*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1383*)
(*1383*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1384*)
(*1384*)  (*BRANCH NAME*)
} note note345 = this
(* po redu: 1385*)
(*1385*)  
(*BRANCH END*)
from note344 and note345 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1386*)
(*1386*)  (*BRANCH NAME*)
} note note346 = this
(* po redu: 1387*)
(*1387*)  
(*BRANCH END*)
from note343 and note346 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1388*)
(*1388*)  (*BRANCH NAME*)
} note note347 = this
(* po redu: 1389*)
(*1389*)  
(*BRANCH END*)
from note340 and note347 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1390*)
(*1390*)  (*BRANCH NAME*)
} note note348 = this
(* po redu: 1391*)
(*1391*)  
(*BRANCH END*)
from note333 and note348 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 1392*)
(*1392*)  (*BRANCH NAME*)
} note note349 = this
(* po redu: 1393*)
(*1393*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 1394*)
(*1394*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 1395*)
(*1395*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 1396*)
(*1396*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1397*)
(*1397*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1398*)
(*1398*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1399*)
(*1399*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1400*)
(*1400*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1401*)
(*1401*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1402*)
(*1402*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1403*)
(*1403*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1404*)
(*1404*)  (*BRANCH NAME*)
} note note350 = this
(* po redu: 1405*)
(*1405*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1406*)
(*1406*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1407*)
(*1407*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1408*)
(*1408*)  (*BRANCH NAME*)
} note note351 = this
(* po redu: 1409*)
(*1409*)  
(*BRANCH END*)
from note350 and note351 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1410*)
(*1410*)  (*BRANCH NAME*)
} note note352 = this
(* po redu: 1411*)
(*1411*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1412*)
(*1412*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1413*)
(*1413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1414*)
(*1414*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1415*)
(*1415*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1416*)
(*1416*)  (*BRANCH NAME*)
} note note353 = this
(* po redu: 1417*)
(*1417*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1418*)
(*1418*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1419*)
(*1419*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1420*)
(*1420*)  (*BRANCH NAME*)
} note note354 = this
(* po redu: 1421*)
(*1421*)  
(*BRANCH END*)
from note353 and note354 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1422*)
(*1422*)  (*BRANCH NAME*)
} note note355 = this
(* po redu: 1423*)
(*1423*)  
(*BRANCH END*)
from note352 and note355 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1424*)
(*1424*)  (*BRANCH NAME*)
} note note356 = this
(* po redu: 1425*)
(*1425*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1426*)
(*1426*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1427*)
(*1427*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1428*)
(*1428*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1429*)
(*1429*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1430*)
(*1430*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1431*)
(*1431*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1432*)
(*1432*)  (*BRANCH NAME*)
} note note357 = this
(* po redu: 1433*)
(*1433*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1434*)
(*1434*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1435*)
(*1435*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1436*)
(*1436*)  (*BRANCH NAME*)
} note note358 = this
(* po redu: 1437*)
(*1437*)  
(*BRANCH END*)
from note357 and note358 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1438*)
(*1438*)  (*BRANCH NAME*)
} note note359 = this
(* po redu: 1439*)
(*1439*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1440*)
(*1440*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1441*)
(*1441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1442*)
(*1442*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1443*)
(*1443*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1444*)
(*1444*)  (*BRANCH NAME*)
} note note360 = this
(* po redu: 1445*)
(*1445*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1446*)
(*1446*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1447*)
(*1447*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1448*)
(*1448*)  (*BRANCH NAME*)
} note note361 = this
(* po redu: 1449*)
(*1449*)  
(*BRANCH END*)
from note360 and note361 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1450*)
(*1450*)  (*BRANCH NAME*)
} note note362 = this
(* po redu: 1451*)
(*1451*)  
(*BRANCH END*)
from note359 and note362 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1452*)
(*1452*)  (*BRANCH NAME*)
} note note363 = this
(* po redu: 1453*)
(*1453*)  
(*BRANCH END*)
from note356 and note363 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1454*)
(*1454*)  (*BRANCH NAME*)
} note note364 = this
(* po redu: 1455*)
(*1455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1456*)
(*1456*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1457*)
(*1457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1458*)
(*1458*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1459*)
(*1459*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1460*)
(*1460*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1461*)
(*1461*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1462*)
(*1462*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1463*)
(*1463*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1464*)
(*1464*)  (*BRANCH NAME*)
} note note365 = this
(* po redu: 1465*)
(*1465*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1466*)
(*1466*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1467*)
(*1467*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1468*)
(*1468*)  (*BRANCH NAME*)
} note note366 = this
(* po redu: 1469*)
(*1469*)  
(*BRANCH END*)
from note365 and note366 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1470*)
(*1470*)  (*BRANCH NAME*)
} note note367 = this
(* po redu: 1471*)
(*1471*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1472*)
(*1472*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1473*)
(*1473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1474*)
(*1474*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1475*)
(*1475*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1476*)
(*1476*)  (*BRANCH NAME*)
} note note368 = this
(* po redu: 1477*)
(*1477*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1478*)
(*1478*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1479*)
(*1479*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1480*)
(*1480*)  (*BRANCH NAME*)
} note note369 = this
(* po redu: 1481*)
(*1481*)  
(*BRANCH END*)
from note368 and note369 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1482*)
(*1482*)  (*BRANCH NAME*)
} note note370 = this
(* po redu: 1483*)
(*1483*)  
(*BRANCH END*)
from note367 and note370 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1484*)
(*1484*)  (*BRANCH NAME*)
} note note371 = this
(* po redu: 1485*)
(*1485*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1486*)
(*1486*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1487*)
(*1487*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1488*)
(*1488*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1489*)
(*1489*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1490*)
(*1490*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1491*)
(*1491*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1492*)
(*1492*)  (*BRANCH NAME*)
} note note372 = this
(* po redu: 1493*)
(*1493*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1494*)
(*1494*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1495*)
(*1495*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1496*)
(*1496*)  (*BRANCH NAME*)
} note note373 = this
(* po redu: 1497*)
(*1497*)  
(*BRANCH END*)
from note372 and note373 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1498*)
(*1498*)  (*BRANCH NAME*)
} note note374 = this
(* po redu: 1499*)
(*1499*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1500*)
(*1500*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1501*)
(*1501*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1502*)
(*1502*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1503*)
(*1503*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1504*)
(*1504*)  (*BRANCH NAME*)
} note note375 = this
(* po redu: 1505*)
(*1505*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1506*)
(*1506*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 1507*)
(*1507*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 1508*)
(*1508*)  (*BRANCH NAME*)
} note note376 = this
(* po redu: 1509*)
(*1509*)  
(*BRANCH END*)
from note375 and note376 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1510*)
(*1510*)  (*BRANCH NAME*)
} note note377 = this
(* po redu: 1511*)
(*1511*)  
(*BRANCH END*)
from note374 and note377 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1512*)
(*1512*)  (*BRANCH NAME*)
} note note378 = this
(* po redu: 1513*)
(*1513*)  
(*BRANCH END*)
from note371 and note378 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1514*)
(*1514*)  (*BRANCH NAME*)
} note note379 = this
(* po redu: 1515*)
(*1515*)  
(*BRANCH END*)
from note364 and note379 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 1516*)
(*1516*)  (*BRANCH NAME*)
} note note380 = this
(* po redu: 1517*)
(*1517*)  
(*BRANCH END*)
from note349 and note380 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 1518*)
(*1518*)  (*BRANCH NAME*)
} note note381 = this
(* po redu: 1519*)
(*1519*)  
(*BRANCH END*)
from note318 and note381 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 1520*)
(*1520*)  (*BRANCH NAME*)
} note note382 = this
(* po redu: 1521*)
(*1521*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 1522*)
(*1522*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 1523*)
(*1523*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 1524*)
(*1524*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 1525*)
(*1525*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 1526*)
(*1526*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 1527*)
(*1527*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 1528*)
(*1528*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1529*)
(*1529*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1530*)
(*1530*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1531*)
(*1531*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1532*)
(*1532*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1533*)
(*1533*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1534*)
(*1534*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1535*)
(*1535*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1536*)
(*1536*)  (*BRANCH NAME*)
} note note383 = this
(* po redu: 1537*)
(*1537*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1538*)
(*1538*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1539*)
(*1539*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1540*)
(*1540*)  (*BRANCH NAME*)
} note note384 = this
(* po redu: 1541*)
(*1541*)  
(*BRANCH END*)
from note383 and note384 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1542*)
(*1542*)  (*BRANCH NAME*)
} note note385 = this
(* po redu: 1543*)
(*1543*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1544*)
(*1544*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1545*)
(*1545*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1546*)
(*1546*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1547*)
(*1547*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1548*)
(*1548*)  (*BRANCH NAME*)
} note note386 = this
(* po redu: 1549*)
(*1549*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1550*)
(*1550*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1551*)
(*1551*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1552*)
(*1552*)  (*BRANCH NAME*)
} note note387 = this
(* po redu: 1553*)
(*1553*)  
(*BRANCH END*)
from note386 and note387 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1554*)
(*1554*)  (*BRANCH NAME*)
} note note388 = this
(* po redu: 1555*)
(*1555*)  
(*BRANCH END*)
from note385 and note388 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1556*)
(*1556*)  (*BRANCH NAME*)
} note note389 = this
(* po redu: 1557*)
(*1557*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1558*)
(*1558*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1559*)
(*1559*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1560*)
(*1560*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1561*)
(*1561*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1562*)
(*1562*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1563*)
(*1563*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1564*)
(*1564*)  (*BRANCH NAME*)
} note note390 = this
(* po redu: 1565*)
(*1565*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1566*)
(*1566*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1567*)
(*1567*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1568*)
(*1568*)  (*BRANCH NAME*)
} note note391 = this
(* po redu: 1569*)
(*1569*)  
(*BRANCH END*)
from note390 and note391 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1570*)
(*1570*)  (*BRANCH NAME*)
} note note392 = this
(* po redu: 1571*)
(*1571*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1572*)
(*1572*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1573*)
(*1573*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1574*)
(*1574*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1575*)
(*1575*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1576*)
(*1576*)  (*BRANCH NAME*)
} note note393 = this
(* po redu: 1577*)
(*1577*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1578*)
(*1578*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1579*)
(*1579*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1580*)
(*1580*)  (*BRANCH NAME*)
} note note394 = this
(* po redu: 1581*)
(*1581*)  
(*BRANCH END*)
from note393 and note394 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1582*)
(*1582*)  (*BRANCH NAME*)
} note note395 = this
(* po redu: 1583*)
(*1583*)  
(*BRANCH END*)
from note392 and note395 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1584*)
(*1584*)  (*BRANCH NAME*)
} note note396 = this
(* po redu: 1585*)
(*1585*)  
(*BRANCH END*)
from note389 and note396 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1586*)
(*1586*)  (*BRANCH NAME*)
} note note397 = this
(* po redu: 1587*)
(*1587*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1588*)
(*1588*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1589*)
(*1589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1590*)
(*1590*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1591*)
(*1591*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1592*)
(*1592*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1593*)
(*1593*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1594*)
(*1594*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1595*)
(*1595*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1596*)
(*1596*)  (*BRANCH NAME*)
} note note398 = this
(* po redu: 1597*)
(*1597*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1598*)
(*1598*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1599*)
(*1599*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1600*)
(*1600*)  (*BRANCH NAME*)
} note note399 = this
(* po redu: 1601*)
(*1601*)  
(*BRANCH END*)
from note398 and note399 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1602*)
(*1602*)  (*BRANCH NAME*)
} note note400 = this
(* po redu: 1603*)
(*1603*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1604*)
(*1604*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1605*)
(*1605*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1606*)
(*1606*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1607*)
(*1607*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1608*)
(*1608*)  (*BRANCH NAME*)
} note note401 = this
(* po redu: 1609*)
(*1609*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1610*)
(*1610*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1611*)
(*1611*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1612*)
(*1612*)  (*BRANCH NAME*)
} note note402 = this
(* po redu: 1613*)
(*1613*)  
(*BRANCH END*)
from note401 and note402 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1614*)
(*1614*)  (*BRANCH NAME*)
} note note403 = this
(* po redu: 1615*)
(*1615*)  
(*BRANCH END*)
from note400 and note403 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1616*)
(*1616*)  (*BRANCH NAME*)
} note note404 = this
(* po redu: 1617*)
(*1617*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1618*)
(*1618*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1619*)
(*1619*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1620*)
(*1620*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1621*)
(*1621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1622*)
(*1622*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1623*)
(*1623*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1624*)
(*1624*)  (*BRANCH NAME*)
} note note405 = this
(* po redu: 1625*)
(*1625*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1626*)
(*1626*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1627*)
(*1627*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1628*)
(*1628*)  (*BRANCH NAME*)
} note note406 = this
(* po redu: 1629*)
(*1629*)  
(*BRANCH END*)
from note405 and note406 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1630*)
(*1630*)  (*BRANCH NAME*)
} note note407 = this
(* po redu: 1631*)
(*1631*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1632*)
(*1632*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1633*)
(*1633*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1634*)
(*1634*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1635*)
(*1635*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1636*)
(*1636*)  (*BRANCH NAME*)
} note note408 = this
(* po redu: 1637*)
(*1637*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1638*)
(*1638*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1639*)
(*1639*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1640*)
(*1640*)  (*BRANCH NAME*)
} note note409 = this
(* po redu: 1641*)
(*1641*)  
(*BRANCH END*)
from note408 and note409 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1642*)
(*1642*)  (*BRANCH NAME*)
} note note410 = this
(* po redu: 1643*)
(*1643*)  
(*BRANCH END*)
from note407 and note410 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1644*)
(*1644*)  (*BRANCH NAME*)
} note note411 = this
(* po redu: 1645*)
(*1645*)  
(*BRANCH END*)
from note404 and note411 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1646*)
(*1646*)  (*BRANCH NAME*)
} note note412 = this
(* po redu: 1647*)
(*1647*)  
(*BRANCH END*)
from note397 and note412 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 1648*)
(*1648*)  (*BRANCH NAME*)
} note note413 = this
(* po redu: 1649*)
(*1649*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 1650*)
(*1650*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 1651*)
(*1651*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 1652*)
(*1652*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1653*)
(*1653*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1654*)
(*1654*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1655*)
(*1655*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1656*)
(*1656*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1657*)
(*1657*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1658*)
(*1658*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1659*)
(*1659*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1660*)
(*1660*)  (*BRANCH NAME*)
} note note414 = this
(* po redu: 1661*)
(*1661*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1662*)
(*1662*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1663*)
(*1663*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1664*)
(*1664*)  (*BRANCH NAME*)
} note note415 = this
(* po redu: 1665*)
(*1665*)  
(*BRANCH END*)
from note414 and note415 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1666*)
(*1666*)  (*BRANCH NAME*)
} note note416 = this
(* po redu: 1667*)
(*1667*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1668*)
(*1668*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1669*)
(*1669*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1670*)
(*1670*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1671*)
(*1671*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1672*)
(*1672*)  (*BRANCH NAME*)
} note note417 = this
(* po redu: 1673*)
(*1673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1674*)
(*1674*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1675*)
(*1675*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1676*)
(*1676*)  (*BRANCH NAME*)
} note note418 = this
(* po redu: 1677*)
(*1677*)  
(*BRANCH END*)
from note417 and note418 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1678*)
(*1678*)  (*BRANCH NAME*)
} note note419 = this
(* po redu: 1679*)
(*1679*)  
(*BRANCH END*)
from note416 and note419 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1680*)
(*1680*)  (*BRANCH NAME*)
} note note420 = this
(* po redu: 1681*)
(*1681*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1682*)
(*1682*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1683*)
(*1683*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1684*)
(*1684*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1685*)
(*1685*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1686*)
(*1686*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1687*)
(*1687*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1688*)
(*1688*)  (*BRANCH NAME*)
} note note421 = this
(* po redu: 1689*)
(*1689*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1690*)
(*1690*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1691*)
(*1691*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1692*)
(*1692*)  (*BRANCH NAME*)
} note note422 = this
(* po redu: 1693*)
(*1693*)  
(*BRANCH END*)
from note421 and note422 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1694*)
(*1694*)  (*BRANCH NAME*)
} note note423 = this
(* po redu: 1695*)
(*1695*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1696*)
(*1696*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1697*)
(*1697*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1698*)
(*1698*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1699*)
(*1699*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1700*)
(*1700*)  (*BRANCH NAME*)
} note note424 = this
(* po redu: 1701*)
(*1701*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1702*)
(*1702*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1703*)
(*1703*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1704*)
(*1704*)  (*BRANCH NAME*)
} note note425 = this
(* po redu: 1705*)
(*1705*)  
(*BRANCH END*)
from note424 and note425 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1706*)
(*1706*)  (*BRANCH NAME*)
} note note426 = this
(* po redu: 1707*)
(*1707*)  
(*BRANCH END*)
from note423 and note426 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1708*)
(*1708*)  (*BRANCH NAME*)
} note note427 = this
(* po redu: 1709*)
(*1709*)  
(*BRANCH END*)
from note420 and note427 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1710*)
(*1710*)  (*BRANCH NAME*)
} note note428 = this
(* po redu: 1711*)
(*1711*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1712*)
(*1712*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1713*)
(*1713*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1714*)
(*1714*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1715*)
(*1715*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1716*)
(*1716*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1717*)
(*1717*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1718*)
(*1718*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1719*)
(*1719*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1720*)
(*1720*)  (*BRANCH NAME*)
} note note429 = this
(* po redu: 1721*)
(*1721*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1722*)
(*1722*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1723*)
(*1723*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1724*)
(*1724*)  (*BRANCH NAME*)
} note note430 = this
(* po redu: 1725*)
(*1725*)  
(*BRANCH END*)
from note429 and note430 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1726*)
(*1726*)  (*BRANCH NAME*)
} note note431 = this
(* po redu: 1727*)
(*1727*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1728*)
(*1728*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1729*)
(*1729*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1730*)
(*1730*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1731*)
(*1731*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1732*)
(*1732*)  (*BRANCH NAME*)
} note note432 = this
(* po redu: 1733*)
(*1733*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1734*)
(*1734*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1735*)
(*1735*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1736*)
(*1736*)  (*BRANCH NAME*)
} note note433 = this
(* po redu: 1737*)
(*1737*)  
(*BRANCH END*)
from note432 and note433 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1738*)
(*1738*)  (*BRANCH NAME*)
} note note434 = this
(* po redu: 1739*)
(*1739*)  
(*BRANCH END*)
from note431 and note434 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1740*)
(*1740*)  (*BRANCH NAME*)
} note note435 = this
(* po redu: 1741*)
(*1741*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1742*)
(*1742*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1743*)
(*1743*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1744*)
(*1744*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1745*)
(*1745*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1746*)
(*1746*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1747*)
(*1747*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1748*)
(*1748*)  (*BRANCH NAME*)
} note note436 = this
(* po redu: 1749*)
(*1749*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1750*)
(*1750*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1751*)
(*1751*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1752*)
(*1752*)  (*BRANCH NAME*)
} note note437 = this
(* po redu: 1753*)
(*1753*)  
(*BRANCH END*)
from note436 and note437 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1754*)
(*1754*)  (*BRANCH NAME*)
} note note438 = this
(* po redu: 1755*)
(*1755*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1756*)
(*1756*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1757*)
(*1757*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1758*)
(*1758*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 1759*)
(*1759*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 1760*)
(*1760*)  (*BRANCH NAME*)
} note note439 = this
(* po redu: 1761*)
(*1761*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1762*)
(*1762*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1763*)
(*1763*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1764*)
(*1764*)  (*BRANCH NAME*)
} note note440 = this
(* po redu: 1765*)
(*1765*)  
(*BRANCH END*)
from note439 and note440 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1766*)
(*1766*)  (*BRANCH NAME*)
} note note441 = this
(* po redu: 1767*)
(*1767*)  
(*BRANCH END*)
from note438 and note441 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1768*)
(*1768*)  (*BRANCH NAME*)
} note note442 = this
(* po redu: 1769*)
(*1769*)  
(*BRANCH END*)
from note435 and note442 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1770*)
(*1770*)  (*BRANCH NAME*)
} note note443 = this
(* po redu: 1771*)
(*1771*)  
(*BRANCH END*)
from note428 and note443 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 1772*)
(*1772*)  (*BRANCH NAME*)
} note note444 = this
(* po redu: 1773*)
(*1773*)  
(*BRANCH END*)
from note413 and note444 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 1774*)
(*1774*)  (*BRANCH NAME*)
} note note445 = this
(* po redu: 1775*)
(*1775*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 1776*)
(*1776*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 1777*)
(*1777*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 1778*)
(*1778*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 1779*)
(*1779*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 1780*)
(*1780*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1781*)
(*1781*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1782*)
(*1782*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1783*)
(*1783*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1784*)
(*1784*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1785*)
(*1785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1786*)
(*1786*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note446 = this
(* po redu: 1787*)
(*1787*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1788*)
(*1788*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1789*)
(*1789*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1790*)
(*1790*)  (*BRANCH NAME*)
} note note447 = this
(* po redu: 1791*)
(*1791*)  
(*BRANCH END*)
from note446 and note447 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 1792*)
(*1792*)  (*BRANCH NAME*)
} note note448 = this
(* po redu: 1793*)
(*1793*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1794*)
(*1794*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1795*)
(*1795*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1796*)
(*1796*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1797*)
(*1797*)  (*BRANCH NAME*)
} note note449 = this
(* po redu: 1798*)
(*1798*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1799*)
(*1799*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1800*)
(*1800*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1801*)
(*1801*)  (*BRANCH NAME*)
} note note450 = this
(* po redu: 1802*)
(*1802*)  
(*BRANCH END*)
from note449 and note450 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1803*)
(*1803*)  (*BRANCH NAME*)
} note note451 = this
(* po redu: 1804*)
(*1804*)  
(*BRANCH END*)
from note448 and note451 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 1805*)
(*1805*)  (*BRANCH NAME*)
} note note452 = this
(* po redu: 1806*)
(*1806*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1807*)
(*1807*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1808*)
(*1808*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1809*)
(*1809*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1810*)
(*1810*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1811*)
(*1811*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1812*)
(*1812*)  (*BRANCH NAME*)
} note note453 = this
(* po redu: 1813*)
(*1813*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1814*)
(*1814*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1815*)
(*1815*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1816*)
(*1816*)  (*BRANCH NAME*)
} note note454 = this
(* po redu: 1817*)
(*1817*)  
(*BRANCH END*)
from note453 and note454 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1818*)
(*1818*)  (*BRANCH NAME*)
} note note455 = this
(* po redu: 1819*)
(*1819*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1820*)
(*1820*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1821*)
(*1821*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1822*)
(*1822*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note456 = this
(* po redu: 1823*)
(*1823*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1824*)
(*1824*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1825*)
(*1825*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1826*)
(*1826*)  (*BRANCH NAME*)
} note note457 = this
(* po redu: 1827*)
(*1827*)  
(*BRANCH END*)
from note456 and note457 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 1828*)
(*1828*)  (*BRANCH NAME*)
} note note458 = this
(* po redu: 1829*)
(*1829*)  
(*BRANCH END*)
from note455 and note458 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 1830*)
(*1830*)  (*BRANCH NAME*)
} note note459 = this
(* po redu: 1831*)
(*1831*)  
(*BRANCH END*)
from note452 and note459 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 1832*)
(*1832*)  (*BRANCH NAME*)
} note note460 = this
(* po redu: 1833*)
(*1833*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1834*)
(*1834*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1835*)
(*1835*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1836*)
(*1836*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1837*)
(*1837*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1838*)
(*1838*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1839*)
(*1839*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1840*)
(*1840*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1841*)
(*1841*)  (*BRANCH NAME*)
} note note461 = this
(* po redu: 1842*)
(*1842*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1843*)
(*1843*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1844*)
(*1844*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1845*)
(*1845*)  (*BRANCH NAME*)
} note note462 = this
(* po redu: 1846*)
(*1846*)  
(*BRANCH END*)
from note461 and note462 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1847*)
(*1847*)  (*BRANCH NAME*)
} note note463 = this
(* po redu: 1848*)
(*1848*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1849*)
(*1849*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1850*)
(*1850*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1851*)
(*1851*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1852*)
(*1852*)  (*BRANCH NAME*)
} note note464 = this
(* po redu: 1853*)
(*1853*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1854*)
(*1854*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1855*)
(*1855*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1856*)
(*1856*)  (*BRANCH NAME*)
} note note465 = this
(* po redu: 1857*)
(*1857*)  
(*BRANCH END*)
from note464 and note465 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1858*)
(*1858*)  (*BRANCH NAME*)
} note note466 = this
(* po redu: 1859*)
(*1859*)  
(*BRANCH END*)
from note463 and note466 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1860*)
(*1860*)  (*BRANCH NAME*)
} note note467 = this
(* po redu: 1861*)
(*1861*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1862*)
(*1862*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1863*)
(*1863*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1864*)
(*1864*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1865*)
(*1865*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1866*)
(*1866*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1867*)
(*1867*)  (*BRANCH NAME*)
} note note468 = this
(* po redu: 1868*)
(*1868*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1869*)
(*1869*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1870*)
(*1870*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1871*)
(*1871*)  (*BRANCH NAME*)
} note note469 = this
(* po redu: 1872*)
(*1872*)  
(*BRANCH END*)
from note468 and note469 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1873*)
(*1873*)  (*BRANCH NAME*)
} note note470 = this
(* po redu: 1874*)
(*1874*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1875*)
(*1875*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1876*)
(*1876*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1877*)
(*1877*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1878*)
(*1878*)  (*BRANCH NAME*)
} note note471 = this
(* po redu: 1879*)
(*1879*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1880*)
(*1880*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1881*)
(*1881*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1882*)
(*1882*)  (*BRANCH NAME*)
} note note472 = this
(* po redu: 1883*)
(*1883*)  
(*BRANCH END*)
from note471 and note472 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1884*)
(*1884*)  (*BRANCH NAME*)
} note note473 = this
(* po redu: 1885*)
(*1885*)  
(*BRANCH END*)
from note470 and note473 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1886*)
(*1886*)  (*BRANCH NAME*)
} note note474 = this
(* po redu: 1887*)
(*1887*)  
(*BRANCH END*)
from note467 and note474 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1888*)
(*1888*)  (*BRANCH NAME*)
} note note475 = this
(* po redu: 1889*)
(*1889*)  
(*BRANCH END*)
from note460 and note475 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 1890*)
(*1890*)  (*BRANCH NAME*)
} note note476 = this
(* po redu: 1891*)
(*1891*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 1892*)
(*1892*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 1893*)
(*1893*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 1894*)
(*1894*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1895*)
(*1895*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1896*)
(*1896*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1897*)
(*1897*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1898*)
(*1898*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1899*)
(*1899*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1900*)
(*1900*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1901*)
(*1901*)  (*BRANCH NAME*)
} note note477 = this
(* po redu: 1902*)
(*1902*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1903*)
(*1903*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1904*)
(*1904*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1905*)
(*1905*)  (*BRANCH NAME*)
} note note478 = this
(* po redu: 1906*)
(*1906*)  
(*BRANCH END*)
from note477 and note478 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1907*)
(*1907*)  (*BRANCH NAME*)
} note note479 = this
(* po redu: 1908*)
(*1908*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1909*)
(*1909*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1910*)
(*1910*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1911*)
(*1911*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1912*)
(*1912*)  (*BRANCH NAME*)
} note note480 = this
(* po redu: 1913*)
(*1913*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1914*)
(*1914*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1915*)
(*1915*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1916*)
(*1916*)  (*BRANCH NAME*)
} note note481 = this
(* po redu: 1917*)
(*1917*)  
(*BRANCH END*)
from note480 and note481 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1918*)
(*1918*)  (*BRANCH NAME*)
} note note482 = this
(* po redu: 1919*)
(*1919*)  
(*BRANCH END*)
from note479 and note482 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1920*)
(*1920*)  (*BRANCH NAME*)
} note note483 = this
(* po redu: 1921*)
(*1921*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1922*)
(*1922*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1923*)
(*1923*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1924*)
(*1924*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1925*)
(*1925*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1926*)
(*1926*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1927*)
(*1927*)  (*BRANCH NAME*)
} note note484 = this
(* po redu: 1928*)
(*1928*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1929*)
(*1929*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1930*)
(*1930*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1931*)
(*1931*)  (*BRANCH NAME*)
} note note485 = this
(* po redu: 1932*)
(*1932*)  
(*BRANCH END*)
from note484 and note485 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1933*)
(*1933*)  (*BRANCH NAME*)
} note note486 = this
(* po redu: 1934*)
(*1934*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1935*)
(*1935*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1936*)
(*1936*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1937*)
(*1937*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1938*)
(*1938*)  (*BRANCH NAME*)
} note note487 = this
(* po redu: 1939*)
(*1939*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1940*)
(*1940*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1941*)
(*1941*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1942*)
(*1942*)  (*BRANCH NAME*)
} note note488 = this
(* po redu: 1943*)
(*1943*)  
(*BRANCH END*)
from note487 and note488 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1944*)
(*1944*)  (*BRANCH NAME*)
} note note489 = this
(* po redu: 1945*)
(*1945*)  
(*BRANCH END*)
from note486 and note489 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 1946*)
(*1946*)  (*BRANCH NAME*)
} note note490 = this
(* po redu: 1947*)
(*1947*)  
(*BRANCH END*)
from note483 and note490 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 1948*)
(*1948*)  (*BRANCH NAME*)
} note note491 = this
(* po redu: 1949*)
(*1949*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 1950*)
(*1950*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 1951*)
(*1951*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 1952*)
(*1952*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1953*)
(*1953*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1954*)
(*1954*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1955*)
(*1955*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1956*)
(*1956*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note492 = this
(* po redu: 1957*)
(*1957*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1958*)
(*1958*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1959*)
(*1959*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1960*)
(*1960*)  (*BRANCH NAME*)
} note note493 = this
(* po redu: 1961*)
(*1961*)  
(*BRANCH END*)
from note492 and note493 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 1962*)
(*1962*)  (*BRANCH NAME*)
} note note494 = this
(* po redu: 1963*)
(*1963*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1964*)
(*1964*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1965*)
(*1965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1966*)
(*1966*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1967*)
(*1967*)  (*BRANCH NAME*)
} note note495 = this
(* po redu: 1968*)
(*1968*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1969*)
(*1969*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1970*)
(*1970*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1971*)
(*1971*)  (*BRANCH NAME*)
} note note496 = this
(* po redu: 1972*)
(*1972*)  
(*BRANCH END*)
from note495 and note496 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1973*)
(*1973*)  (*BRANCH NAME*)
} note note497 = this
(* po redu: 1974*)
(*1974*)  
(*BRANCH END*)
from note494 and note497 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 1975*)
(*1975*)  (*BRANCH NAME*)
} note note498 = this
(* po redu: 1976*)
(*1976*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 1977*)
(*1977*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 1978*)
(*1978*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 1979*)
(*1979*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1980*)
(*1980*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1981*)
(*1981*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 1982*)
(*1982*)  (*BRANCH NAME*)
} note note499 = this
(* po redu: 1983*)
(*1983*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1984*)
(*1984*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1985*)
(*1985*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1986*)
(*1986*)  (*BRANCH NAME*)
} note note500 = this
(* po redu: 1987*)
(*1987*)  
(*BRANCH END*)
from note499 and note500 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 1988*)
(*1988*)  (*BRANCH NAME*)
} note note501 = this
(* po redu: 1989*)
(*1989*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 1990*)
(*1990*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1991*)
(*1991*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1992*)
(*1992*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note502 = this
(* po redu: 1993*)
(*1993*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1994*)
(*1994*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1995*)
(*1995*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1996*)
(*1996*)  (*BRANCH NAME*)
} note note503 = this
(* po redu: 1997*)
(*1997*)  
(*BRANCH END*)
from note502 and note503 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 1998*)
(*1998*)  (*BRANCH NAME*)
} note note504 = this
(* po redu: 1999*)
(*1999*)  
(*BRANCH END*)
from note501 and note504 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 2000*)
(*2000*)  (*BRANCH NAME*)
} note note505 = this
(* po redu: 2001*)
(*2001*)  
(*BRANCH END*)
from note498 and note505 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 2002*)
(*2002*)  (*BRANCH NAME*)
} note note506 = this
(* po redu: 2003*)
(*2003*)  
(*BRANCH END*)
from note491 and note506 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 2004*)
(*2004*)  (*BRANCH NAME*)
} note note507 = this
(* po redu: 2005*)
(*2005*)  
(*BRANCH END*)
from note476 and note507 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 2006*)
(*2006*)  (*BRANCH NAME*)
} note note508 = this
(* po redu: 2007*)
(*2007*)  
(*BRANCH END*)
from note445 and note508 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 2008*)
(*2008*)  (*BRANCH NAME*)
} note note509 = this
(* po redu: 2009*)
(*2009*)  
(*BRANCH END*)
from note382 and note509 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 2010*)
(*2010*)  (*BRANCH NAME*)
} note note510 = this
(* po redu: 2011*)
(*2011*)  
(*BRANCH END*)
from note255 and note510 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 2012*)
(*2012*)  (*BRANCH NAME*)
} note note511 = this
(* po redu: 2013*)
(*2013*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
(* po redu: 2014*)
(*2014*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 2015*)
(*2015*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 2016*)
(*2016*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 2017*)
(*2017*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 2018*)
(*2018*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 2019*)
(*2019*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 2020*)
(*2020*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 2021*)
(*2021*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 2022*)
(*2022*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 2023*)
(*2023*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 2024*)
(*2024*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2025*)
(*2025*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2026*)
(*2026*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2027*)
(*2027*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2028*)
(*2028*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2029*)
(*2029*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2030*)
(*2030*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note512 = this
(* po redu: 2031*)
(*2031*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2032*)
(*2032*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2033*)
(*2033*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2034*)
(*2034*)  (*BRANCH NAME*)
} note note513 = this
(* po redu: 2035*)
(*2035*)  
(*BRANCH END*)
from note512 and note513 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 2036*)
(*2036*)  (*BRANCH NAME*)
} note note514 = this
(* po redu: 2037*)
(*2037*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2038*)
(*2038*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2039*)
(*2039*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2040*)
(*2040*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2041*)
(*2041*)  (*BRANCH NAME*)
} note note515 = this
(* po redu: 2042*)
(*2042*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2043*)
(*2043*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2044*)
(*2044*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2045*)
(*2045*)  (*BRANCH NAME*)
} note note516 = this
(* po redu: 2046*)
(*2046*)  
(*BRANCH END*)
from note515 and note516 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2047*)
(*2047*)  (*BRANCH NAME*)
} note note517 = this
(* po redu: 2048*)
(*2048*)  
(*BRANCH END*)
from note514 and note517 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 2049*)
(*2049*)  (*BRANCH NAME*)
} note note518 = this
(* po redu: 2050*)
(*2050*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2051*)
(*2051*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2052*)
(*2052*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2053*)
(*2053*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2054*)
(*2054*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2055*)
(*2055*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2056*)
(*2056*)  (*BRANCH NAME*)
} note note519 = this
(* po redu: 2057*)
(*2057*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2058*)
(*2058*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2059*)
(*2059*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2060*)
(*2060*)  (*BRANCH NAME*)
} note note520 = this
(* po redu: 2061*)
(*2061*)  
(*BRANCH END*)
from note519 and note520 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2062*)
(*2062*)  (*BRANCH NAME*)
} note note521 = this
(* po redu: 2063*)
(*2063*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2064*)
(*2064*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2065*)
(*2065*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2066*)
(*2066*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note522 = this
(* po redu: 2067*)
(*2067*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2068*)
(*2068*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2069*)
(*2069*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2070*)
(*2070*)  (*BRANCH NAME*)
} note note523 = this
(* po redu: 2071*)
(*2071*)  
(*BRANCH END*)
from note522 and note523 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 2072*)
(*2072*)  (*BRANCH NAME*)
} note note524 = this
(* po redu: 2073*)
(*2073*)  
(*BRANCH END*)
from note521 and note524 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 2074*)
(*2074*)  (*BRANCH NAME*)
} note note525 = this
(* po redu: 2075*)
(*2075*)  
(*BRANCH END*)
from note518 and note525 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 2076*)
(*2076*)  (*BRANCH NAME*)
} note note526 = this
(* po redu: 2077*)
(*2077*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 2078*)
(*2078*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2079*)
(*2079*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2080*)
(*2080*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2081*)
(*2081*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2082*)
(*2082*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2083*)
(*2083*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2084*)
(*2084*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2085*)
(*2085*)  (*BRANCH NAME*)
} note note527 = this
(* po redu: 2086*)
(*2086*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2087*)
(*2087*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2088*)
(*2088*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2089*)
(*2089*)  (*BRANCH NAME*)
} note note528 = this
(* po redu: 2090*)
(*2090*)  
(*BRANCH END*)
from note527 and note528 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2091*)
(*2091*)  (*BRANCH NAME*)
} note note529 = this
(* po redu: 2092*)
(*2092*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2093*)
(*2093*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2094*)
(*2094*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2095*)
(*2095*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2096*)
(*2096*)  (*BRANCH NAME*)
} note note530 = this
(* po redu: 2097*)
(*2097*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2098*)
(*2098*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2099*)
(*2099*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2100*)
(*2100*)  (*BRANCH NAME*)
} note note531 = this
(* po redu: 2101*)
(*2101*)  
(*BRANCH END*)
from note530 and note531 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2102*)
(*2102*)  (*BRANCH NAME*)
} note note532 = this
(* po redu: 2103*)
(*2103*)  
(*BRANCH END*)
from note529 and note532 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2104*)
(*2104*)  (*BRANCH NAME*)
} note note533 = this
(* po redu: 2105*)
(*2105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2106*)
(*2106*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2107*)
(*2107*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2108*)
(*2108*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2109*)
(*2109*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2110*)
(*2110*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2111*)
(*2111*)  (*BRANCH NAME*)
} note note534 = this
(* po redu: 2112*)
(*2112*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2113*)
(*2113*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2114*)
(*2114*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2115*)
(*2115*)  (*BRANCH NAME*)
} note note535 = this
(* po redu: 2116*)
(*2116*)  
(*BRANCH END*)
from note534 and note535 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2117*)
(*2117*)  (*BRANCH NAME*)
} note note536 = this
(* po redu: 2118*)
(*2118*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2119*)
(*2119*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2120*)
(*2120*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2121*)
(*2121*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2122*)
(*2122*)  (*BRANCH NAME*)
} note note537 = this
(* po redu: 2123*)
(*2123*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2124*)
(*2124*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2125*)
(*2125*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2126*)
(*2126*)  (*BRANCH NAME*)
} note note538 = this
(* po redu: 2127*)
(*2127*)  
(*BRANCH END*)
from note537 and note538 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2128*)
(*2128*)  (*BRANCH NAME*)
} note note539 = this
(* po redu: 2129*)
(*2129*)  
(*BRANCH END*)
from note536 and note539 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2130*)
(*2130*)  (*BRANCH NAME*)
} note note540 = this
(* po redu: 2131*)
(*2131*)  
(*BRANCH END*)
from note533 and note540 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2132*)
(*2132*)  (*BRANCH NAME*)
} note note541 = this
(* po redu: 2133*)
(*2133*)  
(*BRANCH END*)
from note526 and note541 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 2134*)
(*2134*)  (*BRANCH NAME*)
} note note542 = this
(* po redu: 2135*)
(*2135*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 2136*)
(*2136*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 2137*)
(*2137*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 2138*)
(*2138*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2139*)
(*2139*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2140*)
(*2140*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2141*)
(*2141*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2142*)
(*2142*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2143*)
(*2143*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2144*)
(*2144*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2145*)
(*2145*)  (*BRANCH NAME*)
} note note543 = this
(* po redu: 2146*)
(*2146*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2147*)
(*2147*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2148*)
(*2148*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2149*)
(*2149*)  (*BRANCH NAME*)
} note note544 = this
(* po redu: 2150*)
(*2150*)  
(*BRANCH END*)
from note543 and note544 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2151*)
(*2151*)  (*BRANCH NAME*)
} note note545 = this
(* po redu: 2152*)
(*2152*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2153*)
(*2153*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2154*)
(*2154*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2155*)
(*2155*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2156*)
(*2156*)  (*BRANCH NAME*)
} note note546 = this
(* po redu: 2157*)
(*2157*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2158*)
(*2158*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2159*)
(*2159*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2160*)
(*2160*)  (*BRANCH NAME*)
} note note547 = this
(* po redu: 2161*)
(*2161*)  
(*BRANCH END*)
from note546 and note547 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2162*)
(*2162*)  (*BRANCH NAME*)
} note note548 = this
(* po redu: 2163*)
(*2163*)  
(*BRANCH END*)
from note545 and note548 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2164*)
(*2164*)  (*BRANCH NAME*)
} note note549 = this
(* po redu: 2165*)
(*2165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2166*)
(*2166*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2167*)
(*2167*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2168*)
(*2168*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2169*)
(*2169*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2170*)
(*2170*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2171*)
(*2171*)  (*BRANCH NAME*)
} note note550 = this
(* po redu: 2172*)
(*2172*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2173*)
(*2173*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2174*)
(*2174*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2175*)
(*2175*)  (*BRANCH NAME*)
} note note551 = this
(* po redu: 2176*)
(*2176*)  
(*BRANCH END*)
from note550 and note551 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2177*)
(*2177*)  (*BRANCH NAME*)
} note note552 = this
(* po redu: 2178*)
(*2178*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2179*)
(*2179*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2180*)
(*2180*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2181*)
(*2181*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2182*)
(*2182*)  (*BRANCH NAME*)
} note note553 = this
(* po redu: 2183*)
(*2183*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2184*)
(*2184*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2185*)
(*2185*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2186*)
(*2186*)  (*BRANCH NAME*)
} note note554 = this
(* po redu: 2187*)
(*2187*)  
(*BRANCH END*)
from note553 and note554 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2188*)
(*2188*)  (*BRANCH NAME*)
} note note555 = this
(* po redu: 2189*)
(*2189*)  
(*BRANCH END*)
from note552 and note555 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2190*)
(*2190*)  (*BRANCH NAME*)
} note note556 = this
(* po redu: 2191*)
(*2191*)  
(*BRANCH END*)
from note549 and note556 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2192*)
(*2192*)  (*BRANCH NAME*)
} note note557 = this
(* po redu: 2193*)
(*2193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 2194*)
(*2194*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2195*)
(*2195*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2196*)
(*2196*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2197*)
(*2197*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2198*)
(*2198*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2199*)
(*2199*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2200*)
(*2200*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note558 = this
(* po redu: 2201*)
(*2201*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2202*)
(*2202*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2203*)
(*2203*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2204*)
(*2204*)  (*BRANCH NAME*)
} note note559 = this
(* po redu: 2205*)
(*2205*)  
(*BRANCH END*)
from note558 and note559 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 2206*)
(*2206*)  (*BRANCH NAME*)
} note note560 = this
(* po redu: 2207*)
(*2207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2208*)
(*2208*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2209*)
(*2209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2210*)
(*2210*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2211*)
(*2211*)  (*BRANCH NAME*)
} note note561 = this
(* po redu: 2212*)
(*2212*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2213*)
(*2213*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2214*)
(*2214*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2215*)
(*2215*)  (*BRANCH NAME*)
} note note562 = this
(* po redu: 2216*)
(*2216*)  
(*BRANCH END*)
from note561 and note562 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2217*)
(*2217*)  (*BRANCH NAME*)
} note note563 = this
(* po redu: 2218*)
(*2218*)  
(*BRANCH END*)
from note560 and note563 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 2219*)
(*2219*)  (*BRANCH NAME*)
} note note564 = this
(* po redu: 2220*)
(*2220*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2221*)
(*2221*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2222*)
(*2222*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2223*)
(*2223*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2224*)
(*2224*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2225*)
(*2225*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 2226*)
(*2226*)  (*BRANCH NAME*)
} note note565 = this
(* po redu: 2227*)
(*2227*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2228*)
(*2228*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2229*)
(*2229*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2230*)
(*2230*)  (*BRANCH NAME*)
} note note566 = this
(* po redu: 2231*)
(*2231*)  
(*BRANCH END*)
from note565 and note566 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2232*)
(*2232*)  (*BRANCH NAME*)
} note note567 = this
(* po redu: 2233*)
(*2233*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2234*)
(*2234*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2235*)
(*2235*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2236*)
(*2236*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note568 = this
(* po redu: 2237*)
(*2237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2238*)
(*2238*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2239*)
(*2239*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2240*)
(*2240*)  (*BRANCH NAME*)
} note note569 = this
(* po redu: 2241*)
(*2241*)  
(*BRANCH END*)
from note568 and note569 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 2242*)
(*2242*)  (*BRANCH NAME*)
} note note570 = this
(* po redu: 2243*)
(*2243*)  
(*BRANCH END*)
from note567 and note570 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 2244*)
(*2244*)  (*BRANCH NAME*)
} note note571 = this
(* po redu: 2245*)
(*2245*)  
(*BRANCH END*)
from note564 and note571 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 2246*)
(*2246*)  (*BRANCH NAME*)
} note note572 = this
(* po redu: 2247*)
(*2247*)  
(*BRANCH END*)
from note557 and note572 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 2248*)
(*2248*)  (*BRANCH NAME*)
} note note573 = this
(* po redu: 2249*)
(*2249*)  
(*BRANCH END*)
from note542 and note573 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 2250*)
(*2250*)  (*BRANCH NAME*)
} note note574 = this
(* po redu: 2251*)
(*2251*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 2252*)
(*2252*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 2253*)
(*2253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 2254*)
(*2254*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 2255*)
(*2255*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 2256*)
(*2256*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2257*)
(*2257*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2258*)
(*2258*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2259*)
(*2259*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2260*)
(*2260*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2261*)
(*2261*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2262*)
(*2262*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2263*)
(*2263*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2264*)
(*2264*)  (*BRANCH NAME*)
} note note575 = this
(* po redu: 2265*)
(*2265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2266*)
(*2266*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2267*)
(*2267*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2268*)
(*2268*)  (*BRANCH NAME*)
} note note576 = this
(* po redu: 2269*)
(*2269*)  
(*BRANCH END*)
from note575 and note576 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2270*)
(*2270*)  (*BRANCH NAME*)
} note note577 = this
(* po redu: 2271*)
(*2271*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2272*)
(*2272*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2273*)
(*2273*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2274*)
(*2274*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2275*)
(*2275*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2276*)
(*2276*)  (*BRANCH NAME*)
} note note578 = this
(* po redu: 2277*)
(*2277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2278*)
(*2278*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2279*)
(*2279*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2280*)
(*2280*)  (*BRANCH NAME*)
} note note579 = this
(* po redu: 2281*)
(*2281*)  
(*BRANCH END*)
from note578 and note579 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2282*)
(*2282*)  (*BRANCH NAME*)
} note note580 = this
(* po redu: 2283*)
(*2283*)  
(*BRANCH END*)
from note577 and note580 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2284*)
(*2284*)  (*BRANCH NAME*)
} note note581 = this
(* po redu: 2285*)
(*2285*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2286*)
(*2286*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2287*)
(*2287*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2288*)
(*2288*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2289*)
(*2289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2290*)
(*2290*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2291*)
(*2291*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2292*)
(*2292*)  (*BRANCH NAME*)
} note note582 = this
(* po redu: 2293*)
(*2293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2294*)
(*2294*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2295*)
(*2295*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2296*)
(*2296*)  (*BRANCH NAME*)
} note note583 = this
(* po redu: 2297*)
(*2297*)  
(*BRANCH END*)
from note582 and note583 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2298*)
(*2298*)  (*BRANCH NAME*)
} note note584 = this
(* po redu: 2299*)
(*2299*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2300*)
(*2300*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2301*)
(*2301*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2302*)
(*2302*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2303*)
(*2303*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2304*)
(*2304*)  (*BRANCH NAME*)
} note note585 = this
(* po redu: 2305*)
(*2305*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2306*)
(*2306*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2307*)
(*2307*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2308*)
(*2308*)  (*BRANCH NAME*)
} note note586 = this
(* po redu: 2309*)
(*2309*)  
(*BRANCH END*)
from note585 and note586 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2310*)
(*2310*)  (*BRANCH NAME*)
} note note587 = this
(* po redu: 2311*)
(*2311*)  
(*BRANCH END*)
from note584 and note587 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2312*)
(*2312*)  (*BRANCH NAME*)
} note note588 = this
(* po redu: 2313*)
(*2313*)  
(*BRANCH END*)
from note581 and note588 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2314*)
(*2314*)  (*BRANCH NAME*)
} note note589 = this
(* po redu: 2315*)
(*2315*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 2316*)
(*2316*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2317*)
(*2317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2318*)
(*2318*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2319*)
(*2319*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2320*)
(*2320*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2321*)
(*2321*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2322*)
(*2322*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2323*)
(*2323*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2324*)
(*2324*)  (*BRANCH NAME*)
} note note590 = this
(* po redu: 2325*)
(*2325*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2326*)
(*2326*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2327*)
(*2327*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2328*)
(*2328*)  (*BRANCH NAME*)
} note note591 = this
(* po redu: 2329*)
(*2329*)  
(*BRANCH END*)
from note590 and note591 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2330*)
(*2330*)  (*BRANCH NAME*)
} note note592 = this
(* po redu: 2331*)
(*2331*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2332*)
(*2332*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2333*)
(*2333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2334*)
(*2334*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2335*)
(*2335*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2336*)
(*2336*)  (*BRANCH NAME*)
} note note593 = this
(* po redu: 2337*)
(*2337*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2338*)
(*2338*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2339*)
(*2339*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2340*)
(*2340*)  (*BRANCH NAME*)
} note note594 = this
(* po redu: 2341*)
(*2341*)  
(*BRANCH END*)
from note593 and note594 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2342*)
(*2342*)  (*BRANCH NAME*)
} note note595 = this
(* po redu: 2343*)
(*2343*)  
(*BRANCH END*)
from note592 and note595 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2344*)
(*2344*)  (*BRANCH NAME*)
} note note596 = this
(* po redu: 2345*)
(*2345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2346*)
(*2346*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2347*)
(*2347*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2348*)
(*2348*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2349*)
(*2349*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2350*)
(*2350*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2351*)
(*2351*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2352*)
(*2352*)  (*BRANCH NAME*)
} note note597 = this
(* po redu: 2353*)
(*2353*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2354*)
(*2354*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2355*)
(*2355*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2356*)
(*2356*)  (*BRANCH NAME*)
} note note598 = this
(* po redu: 2357*)
(*2357*)  
(*BRANCH END*)
from note597 and note598 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2358*)
(*2358*)  (*BRANCH NAME*)
} note note599 = this
(* po redu: 2359*)
(*2359*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2360*)
(*2360*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2361*)
(*2361*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2362*)
(*2362*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2363*)
(*2363*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2364*)
(*2364*)  (*BRANCH NAME*)
} note note600 = this
(* po redu: 2365*)
(*2365*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2366*)
(*2366*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2367*)
(*2367*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2368*)
(*2368*)  (*BRANCH NAME*)
} note note601 = this
(* po redu: 2369*)
(*2369*)  
(*BRANCH END*)
from note600 and note601 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2370*)
(*2370*)  (*BRANCH NAME*)
} note note602 = this
(* po redu: 2371*)
(*2371*)  
(*BRANCH END*)
from note599 and note602 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2372*)
(*2372*)  (*BRANCH NAME*)
} note note603 = this
(* po redu: 2373*)
(*2373*)  
(*BRANCH END*)
from note596 and note603 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2374*)
(*2374*)  (*BRANCH NAME*)
} note note604 = this
(* po redu: 2375*)
(*2375*)  
(*BRANCH END*)
from note589 and note604 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 2376*)
(*2376*)  (*BRANCH NAME*)
} note note605 = this
(* po redu: 2377*)
(*2377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 2378*)
(*2378*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 2379*)
(*2379*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 2380*)
(*2380*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2381*)
(*2381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2382*)
(*2382*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2383*)
(*2383*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2384*)
(*2384*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2385*)
(*2385*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2386*)
(*2386*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2387*)
(*2387*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2388*)
(*2388*)  (*BRANCH NAME*)
} note note606 = this
(* po redu: 2389*)
(*2389*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2390*)
(*2390*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2391*)
(*2391*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2392*)
(*2392*)  (*BRANCH NAME*)
} note note607 = this
(* po redu: 2393*)
(*2393*)  
(*BRANCH END*)
from note606 and note607 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2394*)
(*2394*)  (*BRANCH NAME*)
} note note608 = this
(* po redu: 2395*)
(*2395*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2396*)
(*2396*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2397*)
(*2397*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2398*)
(*2398*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2399*)
(*2399*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2400*)
(*2400*)  (*BRANCH NAME*)
} note note609 = this
(* po redu: 2401*)
(*2401*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2402*)
(*2402*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2403*)
(*2403*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2404*)
(*2404*)  (*BRANCH NAME*)
} note note610 = this
(* po redu: 2405*)
(*2405*)  
(*BRANCH END*)
from note609 and note610 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2406*)
(*2406*)  (*BRANCH NAME*)
} note note611 = this
(* po redu: 2407*)
(*2407*)  
(*BRANCH END*)
from note608 and note611 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2408*)
(*2408*)  (*BRANCH NAME*)
} note note612 = this
(* po redu: 2409*)
(*2409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2410*)
(*2410*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2411*)
(*2411*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2412*)
(*2412*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2413*)
(*2413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2414*)
(*2414*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2415*)
(*2415*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2416*)
(*2416*)  (*BRANCH NAME*)
} note note613 = this
(* po redu: 2417*)
(*2417*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2418*)
(*2418*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2419*)
(*2419*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2420*)
(*2420*)  (*BRANCH NAME*)
} note note614 = this
(* po redu: 2421*)
(*2421*)  
(*BRANCH END*)
from note613 and note614 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2422*)
(*2422*)  (*BRANCH NAME*)
} note note615 = this
(* po redu: 2423*)
(*2423*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2424*)
(*2424*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2425*)
(*2425*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2426*)
(*2426*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2427*)
(*2427*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2428*)
(*2428*)  (*BRANCH NAME*)
} note note616 = this
(* po redu: 2429*)
(*2429*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2430*)
(*2430*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2431*)
(*2431*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2432*)
(*2432*)  (*BRANCH NAME*)
} note note617 = this
(* po redu: 2433*)
(*2433*)  
(*BRANCH END*)
from note616 and note617 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2434*)
(*2434*)  (*BRANCH NAME*)
} note note618 = this
(* po redu: 2435*)
(*2435*)  
(*BRANCH END*)
from note615 and note618 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2436*)
(*2436*)  (*BRANCH NAME*)
} note note619 = this
(* po redu: 2437*)
(*2437*)  
(*BRANCH END*)
from note612 and note619 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2438*)
(*2438*)  (*BRANCH NAME*)
} note note620 = this
(* po redu: 2439*)
(*2439*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 2440*)
(*2440*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2441*)
(*2441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2442*)
(*2442*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2443*)
(*2443*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2444*)
(*2444*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2445*)
(*2445*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2446*)
(*2446*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2447*)
(*2447*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2448*)
(*2448*)  (*BRANCH NAME*)
} note note621 = this
(* po redu: 2449*)
(*2449*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2450*)
(*2450*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2451*)
(*2451*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2452*)
(*2452*)  (*BRANCH NAME*)
} note note622 = this
(* po redu: 2453*)
(*2453*)  
(*BRANCH END*)
from note621 and note622 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2454*)
(*2454*)  (*BRANCH NAME*)
} note note623 = this
(* po redu: 2455*)
(*2455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2456*)
(*2456*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2457*)
(*2457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2458*)
(*2458*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2459*)
(*2459*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2460*)
(*2460*)  (*BRANCH NAME*)
} note note624 = this
(* po redu: 2461*)
(*2461*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2462*)
(*2462*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2463*)
(*2463*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2464*)
(*2464*)  (*BRANCH NAME*)
} note note625 = this
(* po redu: 2465*)
(*2465*)  
(*BRANCH END*)
from note624 and note625 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2466*)
(*2466*)  (*BRANCH NAME*)
} note note626 = this
(* po redu: 2467*)
(*2467*)  
(*BRANCH END*)
from note623 and note626 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2468*)
(*2468*)  (*BRANCH NAME*)
} note note627 = this
(* po redu: 2469*)
(*2469*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2470*)
(*2470*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2471*)
(*2471*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2472*)
(*2472*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2473*)
(*2473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2474*)
(*2474*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2475*)
(*2475*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2476*)
(*2476*)  (*BRANCH NAME*)
} note note628 = this
(* po redu: 2477*)
(*2477*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2478*)
(*2478*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2479*)
(*2479*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2480*)
(*2480*)  (*BRANCH NAME*)
} note note629 = this
(* po redu: 2481*)
(*2481*)  
(*BRANCH END*)
from note628 and note629 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2482*)
(*2482*)  (*BRANCH NAME*)
} note note630 = this
(* po redu: 2483*)
(*2483*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2484*)
(*2484*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2485*)
(*2485*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2486*)
(*2486*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2487*)
(*2487*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2488*)
(*2488*)  (*BRANCH NAME*)
} note note631 = this
(* po redu: 2489*)
(*2489*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2490*)
(*2490*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 2491*)
(*2491*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 2492*)
(*2492*)  (*BRANCH NAME*)
} note note632 = this
(* po redu: 2493*)
(*2493*)  
(*BRANCH END*)
from note631 and note632 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2494*)
(*2494*)  (*BRANCH NAME*)
} note note633 = this
(* po redu: 2495*)
(*2495*)  
(*BRANCH END*)
from note630 and note633 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2496*)
(*2496*)  (*BRANCH NAME*)
} note note634 = this
(* po redu: 2497*)
(*2497*)  
(*BRANCH END*)
from note627 and note634 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2498*)
(*2498*)  (*BRANCH NAME*)
} note note635 = this
(* po redu: 2499*)
(*2499*)  
(*BRANCH END*)
from note620 and note635 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 2500*)
(*2500*)  (*BRANCH NAME*)
} note note636 = this
(* po redu: 2501*)
(*2501*)  
(*BRANCH END*)
from note605 and note636 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 2502*)
(*2502*)  (*BRANCH NAME*)
} note note637 = this
(* po redu: 2503*)
(*2503*)  
(*BRANCH END*)
from note574 and note637 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 2504*)
(*2504*)  (*BRANCH NAME*)
} note note638 = this
(* po redu: 2505*)
(*2505*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 2506*)
(*2506*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 2507*)
(*2507*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 2508*)
(*2508*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 2509*)
(*2509*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 2510*)
(*2510*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 2511*)
(*2511*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 2512*)
(*2512*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2513*)
(*2513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2514*)
(*2514*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2515*)
(*2515*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2516*)
(*2516*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2517*)
(*2517*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2518*)
(*2518*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2519*)
(*2519*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2520*)
(*2520*)  (*BRANCH NAME*)
} note note639 = this
(* po redu: 2521*)
(*2521*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2522*)
(*2522*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2523*)
(*2523*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2524*)
(*2524*)  (*BRANCH NAME*)
} note note640 = this
(* po redu: 2525*)
(*2525*)  
(*BRANCH END*)
from note639 and note640 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2526*)
(*2526*)  (*BRANCH NAME*)
} note note641 = this
(* po redu: 2527*)
(*2527*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2528*)
(*2528*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2529*)
(*2529*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2530*)
(*2530*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2531*)
(*2531*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2532*)
(*2532*)  (*BRANCH NAME*)
} note note642 = this
(* po redu: 2533*)
(*2533*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2534*)
(*2534*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2535*)
(*2535*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2536*)
(*2536*)  (*BRANCH NAME*)
} note note643 = this
(* po redu: 2537*)
(*2537*)  
(*BRANCH END*)
from note642 and note643 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2538*)
(*2538*)  (*BRANCH NAME*)
} note note644 = this
(* po redu: 2539*)
(*2539*)  
(*BRANCH END*)
from note641 and note644 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2540*)
(*2540*)  (*BRANCH NAME*)
} note note645 = this
(* po redu: 2541*)
(*2541*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2542*)
(*2542*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2543*)
(*2543*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2544*)
(*2544*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2545*)
(*2545*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2546*)
(*2546*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2547*)
(*2547*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2548*)
(*2548*)  (*BRANCH NAME*)
} note note646 = this
(* po redu: 2549*)
(*2549*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2550*)
(*2550*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2551*)
(*2551*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2552*)
(*2552*)  (*BRANCH NAME*)
} note note647 = this
(* po redu: 2553*)
(*2553*)  
(*BRANCH END*)
from note646 and note647 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2554*)
(*2554*)  (*BRANCH NAME*)
} note note648 = this
(* po redu: 2555*)
(*2555*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2556*)
(*2556*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2557*)
(*2557*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2558*)
(*2558*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2559*)
(*2559*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2560*)
(*2560*)  (*BRANCH NAME*)
} note note649 = this
(* po redu: 2561*)
(*2561*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2562*)
(*2562*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2563*)
(*2563*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2564*)
(*2564*)  (*BRANCH NAME*)
} note note650 = this
(* po redu: 2565*)
(*2565*)  
(*BRANCH END*)
from note649 and note650 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2566*)
(*2566*)  (*BRANCH NAME*)
} note note651 = this
(* po redu: 2567*)
(*2567*)  
(*BRANCH END*)
from note648 and note651 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2568*)
(*2568*)  (*BRANCH NAME*)
} note note652 = this
(* po redu: 2569*)
(*2569*)  
(*BRANCH END*)
from note645 and note652 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2570*)
(*2570*)  (*BRANCH NAME*)
} note note653 = this
(* po redu: 2571*)
(*2571*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 2572*)
(*2572*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2573*)
(*2573*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2574*)
(*2574*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2575*)
(*2575*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2576*)
(*2576*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2577*)
(*2577*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2578*)
(*2578*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2579*)
(*2579*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2580*)
(*2580*)  (*BRANCH NAME*)
} note note654 = this
(* po redu: 2581*)
(*2581*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2582*)
(*2582*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2583*)
(*2583*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2584*)
(*2584*)  (*BRANCH NAME*)
} note note655 = this
(* po redu: 2585*)
(*2585*)  
(*BRANCH END*)
from note654 and note655 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2586*)
(*2586*)  (*BRANCH NAME*)
} note note656 = this
(* po redu: 2587*)
(*2587*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2588*)
(*2588*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2589*)
(*2589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2590*)
(*2590*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2591*)
(*2591*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2592*)
(*2592*)  (*BRANCH NAME*)
} note note657 = this
(* po redu: 2593*)
(*2593*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2594*)
(*2594*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2595*)
(*2595*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2596*)
(*2596*)  (*BRANCH NAME*)
} note note658 = this
(* po redu: 2597*)
(*2597*)  
(*BRANCH END*)
from note657 and note658 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2598*)
(*2598*)  (*BRANCH NAME*)
} note note659 = this
(* po redu: 2599*)
(*2599*)  
(*BRANCH END*)
from note656 and note659 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2600*)
(*2600*)  (*BRANCH NAME*)
} note note660 = this
(* po redu: 2601*)
(*2601*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2602*)
(*2602*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2603*)
(*2603*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2604*)
(*2604*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2605*)
(*2605*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2606*)
(*2606*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2607*)
(*2607*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2608*)
(*2608*)  (*BRANCH NAME*)
} note note661 = this
(* po redu: 2609*)
(*2609*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2610*)
(*2610*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2611*)
(*2611*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2612*)
(*2612*)  (*BRANCH NAME*)
} note note662 = this
(* po redu: 2613*)
(*2613*)  
(*BRANCH END*)
from note661 and note662 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2614*)
(*2614*)  (*BRANCH NAME*)
} note note663 = this
(* po redu: 2615*)
(*2615*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2616*)
(*2616*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2617*)
(*2617*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2618*)
(*2618*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2619*)
(*2619*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2620*)
(*2620*)  (*BRANCH NAME*)
} note note664 = this
(* po redu: 2621*)
(*2621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2622*)
(*2622*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2623*)
(*2623*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2624*)
(*2624*)  (*BRANCH NAME*)
} note note665 = this
(* po redu: 2625*)
(*2625*)  
(*BRANCH END*)
from note664 and note665 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2626*)
(*2626*)  (*BRANCH NAME*)
} note note666 = this
(* po redu: 2627*)
(*2627*)  
(*BRANCH END*)
from note663 and note666 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2628*)
(*2628*)  (*BRANCH NAME*)
} note note667 = this
(* po redu: 2629*)
(*2629*)  
(*BRANCH END*)
from note660 and note667 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2630*)
(*2630*)  (*BRANCH NAME*)
} note note668 = this
(* po redu: 2631*)
(*2631*)  
(*BRANCH END*)
from note653 and note668 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 2632*)
(*2632*)  (*BRANCH NAME*)
} note note669 = this
(* po redu: 2633*)
(*2633*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 2634*)
(*2634*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 2635*)
(*2635*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 2636*)
(*2636*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2637*)
(*2637*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2638*)
(*2638*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2639*)
(*2639*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2640*)
(*2640*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2641*)
(*2641*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2642*)
(*2642*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2643*)
(*2643*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2644*)
(*2644*)  (*BRANCH NAME*)
} note note670 = this
(* po redu: 2645*)
(*2645*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2646*)
(*2646*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2647*)
(*2647*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2648*)
(*2648*)  (*BRANCH NAME*)
} note note671 = this
(* po redu: 2649*)
(*2649*)  
(*BRANCH END*)
from note670 and note671 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2650*)
(*2650*)  (*BRANCH NAME*)
} note note672 = this
(* po redu: 2651*)
(*2651*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2652*)
(*2652*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2653*)
(*2653*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2654*)
(*2654*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2655*)
(*2655*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2656*)
(*2656*)  (*BRANCH NAME*)
} note note673 = this
(* po redu: 2657*)
(*2657*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2658*)
(*2658*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2659*)
(*2659*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2660*)
(*2660*)  (*BRANCH NAME*)
} note note674 = this
(* po redu: 2661*)
(*2661*)  
(*BRANCH END*)
from note673 and note674 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2662*)
(*2662*)  (*BRANCH NAME*)
} note note675 = this
(* po redu: 2663*)
(*2663*)  
(*BRANCH END*)
from note672 and note675 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2664*)
(*2664*)  (*BRANCH NAME*)
} note note676 = this
(* po redu: 2665*)
(*2665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2666*)
(*2666*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2667*)
(*2667*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2668*)
(*2668*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2669*)
(*2669*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2670*)
(*2670*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2671*)
(*2671*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2672*)
(*2672*)  (*BRANCH NAME*)
} note note677 = this
(* po redu: 2673*)
(*2673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2674*)
(*2674*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2675*)
(*2675*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2676*)
(*2676*)  (*BRANCH NAME*)
} note note678 = this
(* po redu: 2677*)
(*2677*)  
(*BRANCH END*)
from note677 and note678 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2678*)
(*2678*)  (*BRANCH NAME*)
} note note679 = this
(* po redu: 2679*)
(*2679*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2680*)
(*2680*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2681*)
(*2681*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2682*)
(*2682*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2683*)
(*2683*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2684*)
(*2684*)  (*BRANCH NAME*)
} note note680 = this
(* po redu: 2685*)
(*2685*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2686*)
(*2686*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2687*)
(*2687*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2688*)
(*2688*)  (*BRANCH NAME*)
} note note681 = this
(* po redu: 2689*)
(*2689*)  
(*BRANCH END*)
from note680 and note681 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2690*)
(*2690*)  (*BRANCH NAME*)
} note note682 = this
(* po redu: 2691*)
(*2691*)  
(*BRANCH END*)
from note679 and note682 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2692*)
(*2692*)  (*BRANCH NAME*)
} note note683 = this
(* po redu: 2693*)
(*2693*)  
(*BRANCH END*)
from note676 and note683 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2694*)
(*2694*)  (*BRANCH NAME*)
} note note684 = this
(* po redu: 2695*)
(*2695*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 2696*)
(*2696*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2697*)
(*2697*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2698*)
(*2698*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2699*)
(*2699*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2700*)
(*2700*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2701*)
(*2701*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2702*)
(*2702*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2703*)
(*2703*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2704*)
(*2704*)  (*BRANCH NAME*)
} note note685 = this
(* po redu: 2705*)
(*2705*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2706*)
(*2706*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2707*)
(*2707*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2708*)
(*2708*)  (*BRANCH NAME*)
} note note686 = this
(* po redu: 2709*)
(*2709*)  
(*BRANCH END*)
from note685 and note686 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2710*)
(*2710*)  (*BRANCH NAME*)
} note note687 = this
(* po redu: 2711*)
(*2711*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2712*)
(*2712*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2713*)
(*2713*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2714*)
(*2714*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2715*)
(*2715*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2716*)
(*2716*)  (*BRANCH NAME*)
} note note688 = this
(* po redu: 2717*)
(*2717*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2718*)
(*2718*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2719*)
(*2719*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2720*)
(*2720*)  (*BRANCH NAME*)
} note note689 = this
(* po redu: 2721*)
(*2721*)  
(*BRANCH END*)
from note688 and note689 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2722*)
(*2722*)  (*BRANCH NAME*)
} note note690 = this
(* po redu: 2723*)
(*2723*)  
(*BRANCH END*)
from note687 and note690 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2724*)
(*2724*)  (*BRANCH NAME*)
} note note691 = this
(* po redu: 2725*)
(*2725*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2726*)
(*2726*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2727*)
(*2727*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2728*)
(*2728*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2729*)
(*2729*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2730*)
(*2730*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2731*)
(*2731*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2732*)
(*2732*)  (*BRANCH NAME*)
} note note692 = this
(* po redu: 2733*)
(*2733*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2734*)
(*2734*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2735*)
(*2735*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2736*)
(*2736*)  (*BRANCH NAME*)
} note note693 = this
(* po redu: 2737*)
(*2737*)  
(*BRANCH END*)
from note692 and note693 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2738*)
(*2738*)  (*BRANCH NAME*)
} note note694 = this
(* po redu: 2739*)
(*2739*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2740*)
(*2740*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2741*)
(*2741*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2742*)
(*2742*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2743*)
(*2743*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2744*)
(*2744*)  (*BRANCH NAME*)
} note note695 = this
(* po redu: 2745*)
(*2745*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2746*)
(*2746*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2747*)
(*2747*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2748*)
(*2748*)  (*BRANCH NAME*)
} note note696 = this
(* po redu: 2749*)
(*2749*)  
(*BRANCH END*)
from note695 and note696 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2750*)
(*2750*)  (*BRANCH NAME*)
} note note697 = this
(* po redu: 2751*)
(*2751*)  
(*BRANCH END*)
from note694 and note697 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2752*)
(*2752*)  (*BRANCH NAME*)
} note note698 = this
(* po redu: 2753*)
(*2753*)  
(*BRANCH END*)
from note691 and note698 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2754*)
(*2754*)  (*BRANCH NAME*)
} note note699 = this
(* po redu: 2755*)
(*2755*)  
(*BRANCH END*)
from note684 and note699 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 2756*)
(*2756*)  (*BRANCH NAME*)
} note note700 = this
(* po redu: 2757*)
(*2757*)  
(*BRANCH END*)
from note669 and note700 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 2758*)
(*2758*)  (*BRANCH NAME*)
} note note701 = this
(* po redu: 2759*)
(*2759*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 2760*)
(*2760*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 2761*)
(*2761*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 2762*)
(*2762*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 2763*)
(*2763*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 2764*)
(*2764*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2765*)
(*2765*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2766*)
(*2766*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2767*)
(*2767*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2768*)
(*2768*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2769*)
(*2769*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2770*)
(*2770*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2771*)
(*2771*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2772*)
(*2772*)  (*BRANCH NAME*)
} note note702 = this
(* po redu: 2773*)
(*2773*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2774*)
(*2774*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2775*)
(*2775*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2776*)
(*2776*)  (*BRANCH NAME*)
} note note703 = this
(* po redu: 2777*)
(*2777*)  
(*BRANCH END*)
from note702 and note703 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2778*)
(*2778*)  (*BRANCH NAME*)
} note note704 = this
(* po redu: 2779*)
(*2779*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2780*)
(*2780*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2781*)
(*2781*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2782*)
(*2782*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2783*)
(*2783*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2784*)
(*2784*)  (*BRANCH NAME*)
} note note705 = this
(* po redu: 2785*)
(*2785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2786*)
(*2786*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2787*)
(*2787*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2788*)
(*2788*)  (*BRANCH NAME*)
} note note706 = this
(* po redu: 2789*)
(*2789*)  
(*BRANCH END*)
from note705 and note706 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2790*)
(*2790*)  (*BRANCH NAME*)
} note note707 = this
(* po redu: 2791*)
(*2791*)  
(*BRANCH END*)
from note704 and note707 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2792*)
(*2792*)  (*BRANCH NAME*)
} note note708 = this
(* po redu: 2793*)
(*2793*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2794*)
(*2794*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2795*)
(*2795*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2796*)
(*2796*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2797*)
(*2797*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2798*)
(*2798*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2799*)
(*2799*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2800*)
(*2800*)  (*BRANCH NAME*)
} note note709 = this
(* po redu: 2801*)
(*2801*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2802*)
(*2802*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2803*)
(*2803*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2804*)
(*2804*)  (*BRANCH NAME*)
} note note710 = this
(* po redu: 2805*)
(*2805*)  
(*BRANCH END*)
from note709 and note710 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2806*)
(*2806*)  (*BRANCH NAME*)
} note note711 = this
(* po redu: 2807*)
(*2807*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2808*)
(*2808*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2809*)
(*2809*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2810*)
(*2810*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2811*)
(*2811*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2812*)
(*2812*)  (*BRANCH NAME*)
} note note712 = this
(* po redu: 2813*)
(*2813*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2814*)
(*2814*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2815*)
(*2815*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2816*)
(*2816*)  (*BRANCH NAME*)
} note note713 = this
(* po redu: 2817*)
(*2817*)  
(*BRANCH END*)
from note712 and note713 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2818*)
(*2818*)  (*BRANCH NAME*)
} note note714 = this
(* po redu: 2819*)
(*2819*)  
(*BRANCH END*)
from note711 and note714 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2820*)
(*2820*)  (*BRANCH NAME*)
} note note715 = this
(* po redu: 2821*)
(*2821*)  
(*BRANCH END*)
from note708 and note715 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2822*)
(*2822*)  (*BRANCH NAME*)
} note note716 = this
(* po redu: 2823*)
(*2823*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 2824*)
(*2824*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2825*)
(*2825*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2826*)
(*2826*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2827*)
(*2827*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2828*)
(*2828*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2829*)
(*2829*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2830*)
(*2830*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2831*)
(*2831*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2832*)
(*2832*)  (*BRANCH NAME*)
} note note717 = this
(* po redu: 2833*)
(*2833*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2834*)
(*2834*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2835*)
(*2835*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2836*)
(*2836*)  (*BRANCH NAME*)
} note note718 = this
(* po redu: 2837*)
(*2837*)  
(*BRANCH END*)
from note717 and note718 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2838*)
(*2838*)  (*BRANCH NAME*)
} note note719 = this
(* po redu: 2839*)
(*2839*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2840*)
(*2840*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2841*)
(*2841*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2842*)
(*2842*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2843*)
(*2843*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2844*)
(*2844*)  (*BRANCH NAME*)
} note note720 = this
(* po redu: 2845*)
(*2845*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2846*)
(*2846*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2847*)
(*2847*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2848*)
(*2848*)  (*BRANCH NAME*)
} note note721 = this
(* po redu: 2849*)
(*2849*)  
(*BRANCH END*)
from note720 and note721 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2850*)
(*2850*)  (*BRANCH NAME*)
} note note722 = this
(* po redu: 2851*)
(*2851*)  
(*BRANCH END*)
from note719 and note722 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2852*)
(*2852*)  (*BRANCH NAME*)
} note note723 = this
(* po redu: 2853*)
(*2853*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2854*)
(*2854*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2855*)
(*2855*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2856*)
(*2856*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2857*)
(*2857*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2858*)
(*2858*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2859*)
(*2859*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2860*)
(*2860*)  (*BRANCH NAME*)
} note note724 = this
(* po redu: 2861*)
(*2861*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2862*)
(*2862*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2863*)
(*2863*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2864*)
(*2864*)  (*BRANCH NAME*)
} note note725 = this
(* po redu: 2865*)
(*2865*)  
(*BRANCH END*)
from note724 and note725 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2866*)
(*2866*)  (*BRANCH NAME*)
} note note726 = this
(* po redu: 2867*)
(*2867*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2868*)
(*2868*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2869*)
(*2869*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2870*)
(*2870*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2871*)
(*2871*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2872*)
(*2872*)  (*BRANCH NAME*)
} note note727 = this
(* po redu: 2873*)
(*2873*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2874*)
(*2874*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2875*)
(*2875*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2876*)
(*2876*)  (*BRANCH NAME*)
} note note728 = this
(* po redu: 2877*)
(*2877*)  
(*BRANCH END*)
from note727 and note728 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2878*)
(*2878*)  (*BRANCH NAME*)
} note note729 = this
(* po redu: 2879*)
(*2879*)  
(*BRANCH END*)
from note726 and note729 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2880*)
(*2880*)  (*BRANCH NAME*)
} note note730 = this
(* po redu: 2881*)
(*2881*)  
(*BRANCH END*)
from note723 and note730 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2882*)
(*2882*)  (*BRANCH NAME*)
} note note731 = this
(* po redu: 2883*)
(*2883*)  
(*BRANCH END*)
from note716 and note731 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 2884*)
(*2884*)  (*BRANCH NAME*)
} note note732 = this
(* po redu: 2885*)
(*2885*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 2886*)
(*2886*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 2887*)
(*2887*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 2888*)
(*2888*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2889*)
(*2889*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2890*)
(*2890*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2891*)
(*2891*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2892*)
(*2892*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2893*)
(*2893*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2894*)
(*2894*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2895*)
(*2895*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2896*)
(*2896*)  (*BRANCH NAME*)
} note note733 = this
(* po redu: 2897*)
(*2897*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2898*)
(*2898*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2899*)
(*2899*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2900*)
(*2900*)  (*BRANCH NAME*)
} note note734 = this
(* po redu: 2901*)
(*2901*)  
(*BRANCH END*)
from note733 and note734 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2902*)
(*2902*)  (*BRANCH NAME*)
} note note735 = this
(* po redu: 2903*)
(*2903*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2904*)
(*2904*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2905*)
(*2905*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2906*)
(*2906*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2907*)
(*2907*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2908*)
(*2908*)  (*BRANCH NAME*)
} note note736 = this
(* po redu: 2909*)
(*2909*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2910*)
(*2910*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2911*)
(*2911*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2912*)
(*2912*)  (*BRANCH NAME*)
} note note737 = this
(* po redu: 2913*)
(*2913*)  
(*BRANCH END*)
from note736 and note737 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2914*)
(*2914*)  (*BRANCH NAME*)
} note note738 = this
(* po redu: 2915*)
(*2915*)  
(*BRANCH END*)
from note735 and note738 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2916*)
(*2916*)  (*BRANCH NAME*)
} note note739 = this
(* po redu: 2917*)
(*2917*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2918*)
(*2918*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2919*)
(*2919*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2920*)
(*2920*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2921*)
(*2921*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2922*)
(*2922*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2923*)
(*2923*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2924*)
(*2924*)  (*BRANCH NAME*)
} note note740 = this
(* po redu: 2925*)
(*2925*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2926*)
(*2926*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2927*)
(*2927*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2928*)
(*2928*)  (*BRANCH NAME*)
} note note741 = this
(* po redu: 2929*)
(*2929*)  
(*BRANCH END*)
from note740 and note741 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2930*)
(*2930*)  (*BRANCH NAME*)
} note note742 = this
(* po redu: 2931*)
(*2931*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2932*)
(*2932*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2933*)
(*2933*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2934*)
(*2934*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2935*)
(*2935*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2936*)
(*2936*)  (*BRANCH NAME*)
} note note743 = this
(* po redu: 2937*)
(*2937*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2938*)
(*2938*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2939*)
(*2939*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2940*)
(*2940*)  (*BRANCH NAME*)
} note note744 = this
(* po redu: 2941*)
(*2941*)  
(*BRANCH END*)
from note743 and note744 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2942*)
(*2942*)  (*BRANCH NAME*)
} note note745 = this
(* po redu: 2943*)
(*2943*)  
(*BRANCH END*)
from note742 and note745 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2944*)
(*2944*)  (*BRANCH NAME*)
} note note746 = this
(* po redu: 2945*)
(*2945*)  
(*BRANCH END*)
from note739 and note746 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 2946*)
(*2946*)  (*BRANCH NAME*)
} note note747 = this
(* po redu: 2947*)
(*2947*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 2948*)
(*2948*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 2949*)
(*2949*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 2950*)
(*2950*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2951*)
(*2951*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2952*)
(*2952*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2953*)
(*2953*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2954*)
(*2954*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2955*)
(*2955*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2956*)
(*2956*)  (*BRANCH NAME*)
} note note748 = this
(* po redu: 2957*)
(*2957*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2958*)
(*2958*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2959*)
(*2959*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2960*)
(*2960*)  (*BRANCH NAME*)
} note note749 = this
(* po redu: 2961*)
(*2961*)  
(*BRANCH END*)
from note748 and note749 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2962*)
(*2962*)  (*BRANCH NAME*)
} note note750 = this
(* po redu: 2963*)
(*2963*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2964*)
(*2964*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2965*)
(*2965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2966*)
(*2966*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2967*)
(*2967*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2968*)
(*2968*)  (*BRANCH NAME*)
} note note751 = this
(* po redu: 2969*)
(*2969*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2970*)
(*2970*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2971*)
(*2971*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2972*)
(*2972*)  (*BRANCH NAME*)
} note note752 = this
(* po redu: 2973*)
(*2973*)  
(*BRANCH END*)
from note751 and note752 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2974*)
(*2974*)  (*BRANCH NAME*)
} note note753 = this
(* po redu: 2975*)
(*2975*)  
(*BRANCH END*)
from note750 and note753 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 2976*)
(*2976*)  (*BRANCH NAME*)
} note note754 = this
(* po redu: 2977*)
(*2977*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 2978*)
(*2978*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 2979*)
(*2979*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 2980*)
(*2980*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2981*)
(*2981*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2982*)
(*2982*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2983*)
(*2983*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2984*)
(*2984*)  (*BRANCH NAME*)
} note note755 = this
(* po redu: 2985*)
(*2985*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2986*)
(*2986*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2987*)
(*2987*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 2988*)
(*2988*)  (*BRANCH NAME*)
} note note756 = this
(* po redu: 2989*)
(*2989*)  
(*BRANCH END*)
from note755 and note756 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 2990*)
(*2990*)  (*BRANCH NAME*)
} note note757 = this
(* po redu: 2991*)
(*2991*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 2992*)
(*2992*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 2993*)
(*2993*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 2994*)
(*2994*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 2995*)
(*2995*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 2996*)
(*2996*)  (*BRANCH NAME*)
} note note758 = this
(* po redu: 2997*)
(*2997*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 2998*)
(*2998*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 2999*)
(*2999*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3000*)
(*3000*)  (*BRANCH NAME*)
} note note759 = this
(* po redu: 3001*)
(*3001*)  
(*BRANCH END*)
from note758 and note759 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3002*)
(*3002*)  (*BRANCH NAME*)
} note note760 = this
(* po redu: 3003*)
(*3003*)  
(*BRANCH END*)
from note757 and note760 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3004*)
(*3004*)  (*BRANCH NAME*)
} note note761 = this
(* po redu: 3005*)
(*3005*)  
(*BRANCH END*)
from note754 and note761 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3006*)
(*3006*)  (*BRANCH NAME*)
} note note762 = this
(* po redu: 3007*)
(*3007*)  
(*BRANCH END*)
from note747 and note762 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 3008*)
(*3008*)  (*BRANCH NAME*)
} note note763 = this
(* po redu: 3009*)
(*3009*)  
(*BRANCH END*)
from note732 and note763 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 3010*)
(*3010*)  (*BRANCH NAME*)
} note note764 = this
(* po redu: 3011*)
(*3011*)  
(*BRANCH END*)
from note701 and note764 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 3012*)
(*3012*)  (*BRANCH NAME*)
} note note765 = this
(* po redu: 3013*)
(*3013*)  
(*BRANCH END*)
from note638 and note765 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 3014*)
(*3014*)  (*BRANCH NAME*)
} note note766 = this
(* po redu: 3015*)
(*3015*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 3016*)
(*3016*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 3017*)
(*3017*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 3018*)
(*3018*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 3019*)
(*3019*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 3020*)
(*3020*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 3021*)
(*3021*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 3022*)
(*3022*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 3023*)
(*3023*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 3024*)
(*3024*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3025*)
(*3025*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3026*)
(*3026*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3027*)
(*3027*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3028*)
(*3028*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3029*)
(*3029*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3030*)
(*3030*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3031*)
(*3031*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3032*)
(*3032*)  (*BRANCH NAME*)
} note note767 = this
(* po redu: 3033*)
(*3033*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3034*)
(*3034*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3035*)
(*3035*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3036*)
(*3036*)  (*BRANCH NAME*)
} note note768 = this
(* po redu: 3037*)
(*3037*)  
(*BRANCH END*)
from note767 and note768 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3038*)
(*3038*)  (*BRANCH NAME*)
} note note769 = this
(* po redu: 3039*)
(*3039*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3040*)
(*3040*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3041*)
(*3041*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3042*)
(*3042*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3043*)
(*3043*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3044*)
(*3044*)  (*BRANCH NAME*)
} note note770 = this
(* po redu: 3045*)
(*3045*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3046*)
(*3046*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3047*)
(*3047*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3048*)
(*3048*)  (*BRANCH NAME*)
} note note771 = this
(* po redu: 3049*)
(*3049*)  
(*BRANCH END*)
from note770 and note771 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3050*)
(*3050*)  (*BRANCH NAME*)
} note note772 = this
(* po redu: 3051*)
(*3051*)  
(*BRANCH END*)
from note769 and note772 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3052*)
(*3052*)  (*BRANCH NAME*)
} note note773 = this
(* po redu: 3053*)
(*3053*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3054*)
(*3054*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3055*)
(*3055*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3056*)
(*3056*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3057*)
(*3057*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3058*)
(*3058*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3059*)
(*3059*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3060*)
(*3060*)  (*BRANCH NAME*)
} note note774 = this
(* po redu: 3061*)
(*3061*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3062*)
(*3062*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3063*)
(*3063*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3064*)
(*3064*)  (*BRANCH NAME*)
} note note775 = this
(* po redu: 3065*)
(*3065*)  
(*BRANCH END*)
from note774 and note775 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3066*)
(*3066*)  (*BRANCH NAME*)
} note note776 = this
(* po redu: 3067*)
(*3067*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3068*)
(*3068*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3069*)
(*3069*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3070*)
(*3070*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3071*)
(*3071*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3072*)
(*3072*)  (*BRANCH NAME*)
} note note777 = this
(* po redu: 3073*)
(*3073*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3074*)
(*3074*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3075*)
(*3075*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3076*)
(*3076*)  (*BRANCH NAME*)
} note note778 = this
(* po redu: 3077*)
(*3077*)  
(*BRANCH END*)
from note777 and note778 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3078*)
(*3078*)  (*BRANCH NAME*)
} note note779 = this
(* po redu: 3079*)
(*3079*)  
(*BRANCH END*)
from note776 and note779 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3080*)
(*3080*)  (*BRANCH NAME*)
} note note780 = this
(* po redu: 3081*)
(*3081*)  
(*BRANCH END*)
from note773 and note780 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3082*)
(*3082*)  (*BRANCH NAME*)
} note note781 = this
(* po redu: 3083*)
(*3083*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 3084*)
(*3084*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3085*)
(*3085*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3086*)
(*3086*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3087*)
(*3087*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3088*)
(*3088*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3089*)
(*3089*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3090*)
(*3090*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3091*)
(*3091*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3092*)
(*3092*)  (*BRANCH NAME*)
} note note782 = this
(* po redu: 3093*)
(*3093*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3094*)
(*3094*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3095*)
(*3095*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3096*)
(*3096*)  (*BRANCH NAME*)
} note note783 = this
(* po redu: 3097*)
(*3097*)  
(*BRANCH END*)
from note782 and note783 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3098*)
(*3098*)  (*BRANCH NAME*)
} note note784 = this
(* po redu: 3099*)
(*3099*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3100*)
(*3100*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3101*)
(*3101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3102*)
(*3102*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3103*)
(*3103*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3104*)
(*3104*)  (*BRANCH NAME*)
} note note785 = this
(* po redu: 3105*)
(*3105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3106*)
(*3106*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3107*)
(*3107*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3108*)
(*3108*)  (*BRANCH NAME*)
} note note786 = this
(* po redu: 3109*)
(*3109*)  
(*BRANCH END*)
from note785 and note786 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3110*)
(*3110*)  (*BRANCH NAME*)
} note note787 = this
(* po redu: 3111*)
(*3111*)  
(*BRANCH END*)
from note784 and note787 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3112*)
(*3112*)  (*BRANCH NAME*)
} note note788 = this
(* po redu: 3113*)
(*3113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3114*)
(*3114*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3115*)
(*3115*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3116*)
(*3116*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3117*)
(*3117*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3118*)
(*3118*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3119*)
(*3119*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3120*)
(*3120*)  (*BRANCH NAME*)
} note note789 = this
(* po redu: 3121*)
(*3121*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3122*)
(*3122*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3123*)
(*3123*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3124*)
(*3124*)  (*BRANCH NAME*)
} note note790 = this
(* po redu: 3125*)
(*3125*)  
(*BRANCH END*)
from note789 and note790 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3126*)
(*3126*)  (*BRANCH NAME*)
} note note791 = this
(* po redu: 3127*)
(*3127*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3128*)
(*3128*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3129*)
(*3129*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3130*)
(*3130*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3131*)
(*3131*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3132*)
(*3132*)  (*BRANCH NAME*)
} note note792 = this
(* po redu: 3133*)
(*3133*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3134*)
(*3134*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3135*)
(*3135*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3136*)
(*3136*)  (*BRANCH NAME*)
} note note793 = this
(* po redu: 3137*)
(*3137*)  
(*BRANCH END*)
from note792 and note793 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3138*)
(*3138*)  (*BRANCH NAME*)
} note note794 = this
(* po redu: 3139*)
(*3139*)  
(*BRANCH END*)
from note791 and note794 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3140*)
(*3140*)  (*BRANCH NAME*)
} note note795 = this
(* po redu: 3141*)
(*3141*)  
(*BRANCH END*)
from note788 and note795 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3142*)
(*3142*)  (*BRANCH NAME*)
} note note796 = this
(* po redu: 3143*)
(*3143*)  
(*BRANCH END*)
from note781 and note796 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 3144*)
(*3144*)  (*BRANCH NAME*)
} note note797 = this
(* po redu: 3145*)
(*3145*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 3146*)
(*3146*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 3147*)
(*3147*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 3148*)
(*3148*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3149*)
(*3149*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3150*)
(*3150*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3151*)
(*3151*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3152*)
(*3152*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3153*)
(*3153*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3154*)
(*3154*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3155*)
(*3155*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3156*)
(*3156*)  (*BRANCH NAME*)
} note note798 = this
(* po redu: 3157*)
(*3157*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3158*)
(*3158*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3159*)
(*3159*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3160*)
(*3160*)  (*BRANCH NAME*)
} note note799 = this
(* po redu: 3161*)
(*3161*)  
(*BRANCH END*)
from note798 and note799 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3162*)
(*3162*)  (*BRANCH NAME*)
} note note800 = this
(* po redu: 3163*)
(*3163*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3164*)
(*3164*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3165*)
(*3165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3166*)
(*3166*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3167*)
(*3167*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3168*)
(*3168*)  (*BRANCH NAME*)
} note note801 = this
(* po redu: 3169*)
(*3169*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3170*)
(*3170*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3171*)
(*3171*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3172*)
(*3172*)  (*BRANCH NAME*)
} note note802 = this
(* po redu: 3173*)
(*3173*)  
(*BRANCH END*)
from note801 and note802 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3174*)
(*3174*)  (*BRANCH NAME*)
} note note803 = this
(* po redu: 3175*)
(*3175*)  
(*BRANCH END*)
from note800 and note803 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3176*)
(*3176*)  (*BRANCH NAME*)
} note note804 = this
(* po redu: 3177*)
(*3177*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3178*)
(*3178*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3179*)
(*3179*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3180*)
(*3180*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3181*)
(*3181*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3182*)
(*3182*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3183*)
(*3183*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3184*)
(*3184*)  (*BRANCH NAME*)
} note note805 = this
(* po redu: 3185*)
(*3185*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3186*)
(*3186*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3187*)
(*3187*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3188*)
(*3188*)  (*BRANCH NAME*)
} note note806 = this
(* po redu: 3189*)
(*3189*)  
(*BRANCH END*)
from note805 and note806 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3190*)
(*3190*)  (*BRANCH NAME*)
} note note807 = this
(* po redu: 3191*)
(*3191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3192*)
(*3192*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3193*)
(*3193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3194*)
(*3194*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3195*)
(*3195*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3196*)
(*3196*)  (*BRANCH NAME*)
} note note808 = this
(* po redu: 3197*)
(*3197*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3198*)
(*3198*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3199*)
(*3199*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3200*)
(*3200*)  (*BRANCH NAME*)
} note note809 = this
(* po redu: 3201*)
(*3201*)  
(*BRANCH END*)
from note808 and note809 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3202*)
(*3202*)  (*BRANCH NAME*)
} note note810 = this
(* po redu: 3203*)
(*3203*)  
(*BRANCH END*)
from note807 and note810 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3204*)
(*3204*)  (*BRANCH NAME*)
} note note811 = this
(* po redu: 3205*)
(*3205*)  
(*BRANCH END*)
from note804 and note811 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3206*)
(*3206*)  (*BRANCH NAME*)
} note note812 = this
(* po redu: 3207*)
(*3207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 3208*)
(*3208*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3209*)
(*3209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3210*)
(*3210*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3211*)
(*3211*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3212*)
(*3212*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3213*)
(*3213*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3214*)
(*3214*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3215*)
(*3215*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3216*)
(*3216*)  (*BRANCH NAME*)
} note note813 = this
(* po redu: 3217*)
(*3217*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3218*)
(*3218*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3219*)
(*3219*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3220*)
(*3220*)  (*BRANCH NAME*)
} note note814 = this
(* po redu: 3221*)
(*3221*)  
(*BRANCH END*)
from note813 and note814 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3222*)
(*3222*)  (*BRANCH NAME*)
} note note815 = this
(* po redu: 3223*)
(*3223*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3224*)
(*3224*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3225*)
(*3225*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3226*)
(*3226*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3227*)
(*3227*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3228*)
(*3228*)  (*BRANCH NAME*)
} note note816 = this
(* po redu: 3229*)
(*3229*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3230*)
(*3230*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3231*)
(*3231*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3232*)
(*3232*)  (*BRANCH NAME*)
} note note817 = this
(* po redu: 3233*)
(*3233*)  
(*BRANCH END*)
from note816 and note817 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3234*)
(*3234*)  (*BRANCH NAME*)
} note note818 = this
(* po redu: 3235*)
(*3235*)  
(*BRANCH END*)
from note815 and note818 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3236*)
(*3236*)  (*BRANCH NAME*)
} note note819 = this
(* po redu: 3237*)
(*3237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3238*)
(*3238*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3239*)
(*3239*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3240*)
(*3240*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3241*)
(*3241*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3242*)
(*3242*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3243*)
(*3243*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3244*)
(*3244*)  (*BRANCH NAME*)
} note note820 = this
(* po redu: 3245*)
(*3245*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3246*)
(*3246*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3247*)
(*3247*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3248*)
(*3248*)  (*BRANCH NAME*)
} note note821 = this
(* po redu: 3249*)
(*3249*)  
(*BRANCH END*)
from note820 and note821 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3250*)
(*3250*)  (*BRANCH NAME*)
} note note822 = this
(* po redu: 3251*)
(*3251*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3252*)
(*3252*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3253*)
(*3253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3254*)
(*3254*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3255*)
(*3255*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3256*)
(*3256*)  (*BRANCH NAME*)
} note note823 = this
(* po redu: 3257*)
(*3257*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3258*)
(*3258*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3259*)
(*3259*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3260*)
(*3260*)  (*BRANCH NAME*)
} note note824 = this
(* po redu: 3261*)
(*3261*)  
(*BRANCH END*)
from note823 and note824 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3262*)
(*3262*)  (*BRANCH NAME*)
} note note825 = this
(* po redu: 3263*)
(*3263*)  
(*BRANCH END*)
from note822 and note825 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3264*)
(*3264*)  (*BRANCH NAME*)
} note note826 = this
(* po redu: 3265*)
(*3265*)  
(*BRANCH END*)
from note819 and note826 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3266*)
(*3266*)  (*BRANCH NAME*)
} note note827 = this
(* po redu: 3267*)
(*3267*)  
(*BRANCH END*)
from note812 and note827 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 3268*)
(*3268*)  (*BRANCH NAME*)
} note note828 = this
(* po redu: 3269*)
(*3269*)  
(*BRANCH END*)
from note797 and note828 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 3270*)
(*3270*)  (*BRANCH NAME*)
} note note829 = this
(* po redu: 3271*)
(*3271*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 3272*)
(*3272*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 3273*)
(*3273*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 3274*)
(*3274*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 3275*)
(*3275*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 3276*)
(*3276*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3277*)
(*3277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3278*)
(*3278*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3279*)
(*3279*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3280*)
(*3280*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3281*)
(*3281*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3282*)
(*3282*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3283*)
(*3283*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3284*)
(*3284*)  (*BRANCH NAME*)
} note note830 = this
(* po redu: 3285*)
(*3285*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3286*)
(*3286*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3287*)
(*3287*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3288*)
(*3288*)  (*BRANCH NAME*)
} note note831 = this
(* po redu: 3289*)
(*3289*)  
(*BRANCH END*)
from note830 and note831 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3290*)
(*3290*)  (*BRANCH NAME*)
} note note832 = this
(* po redu: 3291*)
(*3291*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3292*)
(*3292*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3293*)
(*3293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3294*)
(*3294*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3295*)
(*3295*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3296*)
(*3296*)  (*BRANCH NAME*)
} note note833 = this
(* po redu: 3297*)
(*3297*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3298*)
(*3298*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3299*)
(*3299*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3300*)
(*3300*)  (*BRANCH NAME*)
} note note834 = this
(* po redu: 3301*)
(*3301*)  
(*BRANCH END*)
from note833 and note834 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3302*)
(*3302*)  (*BRANCH NAME*)
} note note835 = this
(* po redu: 3303*)
(*3303*)  
(*BRANCH END*)
from note832 and note835 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3304*)
(*3304*)  (*BRANCH NAME*)
} note note836 = this
(* po redu: 3305*)
(*3305*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3306*)
(*3306*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3307*)
(*3307*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3308*)
(*3308*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3309*)
(*3309*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3310*)
(*3310*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3311*)
(*3311*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3312*)
(*3312*)  (*BRANCH NAME*)
} note note837 = this
(* po redu: 3313*)
(*3313*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3314*)
(*3314*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3315*)
(*3315*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3316*)
(*3316*)  (*BRANCH NAME*)
} note note838 = this
(* po redu: 3317*)
(*3317*)  
(*BRANCH END*)
from note837 and note838 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3318*)
(*3318*)  (*BRANCH NAME*)
} note note839 = this
(* po redu: 3319*)
(*3319*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3320*)
(*3320*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3321*)
(*3321*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3322*)
(*3322*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3323*)
(*3323*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3324*)
(*3324*)  (*BRANCH NAME*)
} note note840 = this
(* po redu: 3325*)
(*3325*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3326*)
(*3326*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3327*)
(*3327*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3328*)
(*3328*)  (*BRANCH NAME*)
} note note841 = this
(* po redu: 3329*)
(*3329*)  
(*BRANCH END*)
from note840 and note841 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3330*)
(*3330*)  (*BRANCH NAME*)
} note note842 = this
(* po redu: 3331*)
(*3331*)  
(*BRANCH END*)
from note839 and note842 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3332*)
(*3332*)  (*BRANCH NAME*)
} note note843 = this
(* po redu: 3333*)
(*3333*)  
(*BRANCH END*)
from note836 and note843 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3334*)
(*3334*)  (*BRANCH NAME*)
} note note844 = this
(* po redu: 3335*)
(*3335*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 3336*)
(*3336*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3337*)
(*3337*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3338*)
(*3338*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3339*)
(*3339*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3340*)
(*3340*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3341*)
(*3341*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3342*)
(*3342*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3343*)
(*3343*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3344*)
(*3344*)  (*BRANCH NAME*)
} note note845 = this
(* po redu: 3345*)
(*3345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3346*)
(*3346*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3347*)
(*3347*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3348*)
(*3348*)  (*BRANCH NAME*)
} note note846 = this
(* po redu: 3349*)
(*3349*)  
(*BRANCH END*)
from note845 and note846 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3350*)
(*3350*)  (*BRANCH NAME*)
} note note847 = this
(* po redu: 3351*)
(*3351*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3352*)
(*3352*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3353*)
(*3353*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3354*)
(*3354*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3355*)
(*3355*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3356*)
(*3356*)  (*BRANCH NAME*)
} note note848 = this
(* po redu: 3357*)
(*3357*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3358*)
(*3358*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3359*)
(*3359*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3360*)
(*3360*)  (*BRANCH NAME*)
} note note849 = this
(* po redu: 3361*)
(*3361*)  
(*BRANCH END*)
from note848 and note849 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3362*)
(*3362*)  (*BRANCH NAME*)
} note note850 = this
(* po redu: 3363*)
(*3363*)  
(*BRANCH END*)
from note847 and note850 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3364*)
(*3364*)  (*BRANCH NAME*)
} note note851 = this
(* po redu: 3365*)
(*3365*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3366*)
(*3366*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3367*)
(*3367*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3368*)
(*3368*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3369*)
(*3369*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3370*)
(*3370*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3371*)
(*3371*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3372*)
(*3372*)  (*BRANCH NAME*)
} note note852 = this
(* po redu: 3373*)
(*3373*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3374*)
(*3374*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3375*)
(*3375*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3376*)
(*3376*)  (*BRANCH NAME*)
} note note853 = this
(* po redu: 3377*)
(*3377*)  
(*BRANCH END*)
from note852 and note853 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3378*)
(*3378*)  (*BRANCH NAME*)
} note note854 = this
(* po redu: 3379*)
(*3379*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3380*)
(*3380*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3381*)
(*3381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3382*)
(*3382*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3383*)
(*3383*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3384*)
(*3384*)  (*BRANCH NAME*)
} note note855 = this
(* po redu: 3385*)
(*3385*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3386*)
(*3386*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3387*)
(*3387*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3388*)
(*3388*)  (*BRANCH NAME*)
} note note856 = this
(* po redu: 3389*)
(*3389*)  
(*BRANCH END*)
from note855 and note856 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3390*)
(*3390*)  (*BRANCH NAME*)
} note note857 = this
(* po redu: 3391*)
(*3391*)  
(*BRANCH END*)
from note854 and note857 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3392*)
(*3392*)  (*BRANCH NAME*)
} note note858 = this
(* po redu: 3393*)
(*3393*)  
(*BRANCH END*)
from note851 and note858 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3394*)
(*3394*)  (*BRANCH NAME*)
} note note859 = this
(* po redu: 3395*)
(*3395*)  
(*BRANCH END*)
from note844 and note859 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 3396*)
(*3396*)  (*BRANCH NAME*)
} note note860 = this
(* po redu: 3397*)
(*3397*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 3398*)
(*3398*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 3399*)
(*3399*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 3400*)
(*3400*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3401*)
(*3401*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3402*)
(*3402*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3403*)
(*3403*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3404*)
(*3404*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3405*)
(*3405*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3406*)
(*3406*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3407*)
(*3407*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3408*)
(*3408*)  (*BRANCH NAME*)
} note note861 = this
(* po redu: 3409*)
(*3409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3410*)
(*3410*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3411*)
(*3411*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3412*)
(*3412*)  (*BRANCH NAME*)
} note note862 = this
(* po redu: 3413*)
(*3413*)  
(*BRANCH END*)
from note861 and note862 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3414*)
(*3414*)  (*BRANCH NAME*)
} note note863 = this
(* po redu: 3415*)
(*3415*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3416*)
(*3416*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3417*)
(*3417*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3418*)
(*3418*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3419*)
(*3419*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3420*)
(*3420*)  (*BRANCH NAME*)
} note note864 = this
(* po redu: 3421*)
(*3421*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3422*)
(*3422*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3423*)
(*3423*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3424*)
(*3424*)  (*BRANCH NAME*)
} note note865 = this
(* po redu: 3425*)
(*3425*)  
(*BRANCH END*)
from note864 and note865 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3426*)
(*3426*)  (*BRANCH NAME*)
} note note866 = this
(* po redu: 3427*)
(*3427*)  
(*BRANCH END*)
from note863 and note866 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3428*)
(*3428*)  (*BRANCH NAME*)
} note note867 = this
(* po redu: 3429*)
(*3429*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3430*)
(*3430*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3431*)
(*3431*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3432*)
(*3432*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3433*)
(*3433*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3434*)
(*3434*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3435*)
(*3435*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3436*)
(*3436*)  (*BRANCH NAME*)
} note note868 = this
(* po redu: 3437*)
(*3437*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3438*)
(*3438*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3439*)
(*3439*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3440*)
(*3440*)  (*BRANCH NAME*)
} note note869 = this
(* po redu: 3441*)
(*3441*)  
(*BRANCH END*)
from note868 and note869 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3442*)
(*3442*)  (*BRANCH NAME*)
} note note870 = this
(* po redu: 3443*)
(*3443*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3444*)
(*3444*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3445*)
(*3445*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3446*)
(*3446*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3447*)
(*3447*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3448*)
(*3448*)  (*BRANCH NAME*)
} note note871 = this
(* po redu: 3449*)
(*3449*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3450*)
(*3450*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3451*)
(*3451*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3452*)
(*3452*)  (*BRANCH NAME*)
} note note872 = this
(* po redu: 3453*)
(*3453*)  
(*BRANCH END*)
from note871 and note872 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3454*)
(*3454*)  (*BRANCH NAME*)
} note note873 = this
(* po redu: 3455*)
(*3455*)  
(*BRANCH END*)
from note870 and note873 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3456*)
(*3456*)  (*BRANCH NAME*)
} note note874 = this
(* po redu: 3457*)
(*3457*)  
(*BRANCH END*)
from note867 and note874 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3458*)
(*3458*)  (*BRANCH NAME*)
} note note875 = this
(* po redu: 3459*)
(*3459*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 3460*)
(*3460*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3461*)
(*3461*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3462*)
(*3462*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3463*)
(*3463*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3464*)
(*3464*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3465*)
(*3465*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3466*)
(*3466*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3467*)
(*3467*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3468*)
(*3468*)  (*BRANCH NAME*)
} note note876 = this
(* po redu: 3469*)
(*3469*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3470*)
(*3470*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3471*)
(*3471*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3472*)
(*3472*)  (*BRANCH NAME*)
} note note877 = this
(* po redu: 3473*)
(*3473*)  
(*BRANCH END*)
from note876 and note877 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3474*)
(*3474*)  (*BRANCH NAME*)
} note note878 = this
(* po redu: 3475*)
(*3475*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3476*)
(*3476*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3477*)
(*3477*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3478*)
(*3478*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3479*)
(*3479*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3480*)
(*3480*)  (*BRANCH NAME*)
} note note879 = this
(* po redu: 3481*)
(*3481*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3482*)
(*3482*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3483*)
(*3483*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3484*)
(*3484*)  (*BRANCH NAME*)
} note note880 = this
(* po redu: 3485*)
(*3485*)  
(*BRANCH END*)
from note879 and note880 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3486*)
(*3486*)  (*BRANCH NAME*)
} note note881 = this
(* po redu: 3487*)
(*3487*)  
(*BRANCH END*)
from note878 and note881 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3488*)
(*3488*)  (*BRANCH NAME*)
} note note882 = this
(* po redu: 3489*)
(*3489*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3490*)
(*3490*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3491*)
(*3491*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3492*)
(*3492*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3493*)
(*3493*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3494*)
(*3494*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3495*)
(*3495*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3496*)
(*3496*)  (*BRANCH NAME*)
} note note883 = this
(* po redu: 3497*)
(*3497*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3498*)
(*3498*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3499*)
(*3499*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3500*)
(*3500*)  (*BRANCH NAME*)
} note note884 = this
(* po redu: 3501*)
(*3501*)  
(*BRANCH END*)
from note883 and note884 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3502*)
(*3502*)  (*BRANCH NAME*)
} note note885 = this
(* po redu: 3503*)
(*3503*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3504*)
(*3504*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3505*)
(*3505*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3506*)
(*3506*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3507*)
(*3507*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3508*)
(*3508*)  (*BRANCH NAME*)
} note note886 = this
(* po redu: 3509*)
(*3509*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3510*)
(*3510*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 3511*)
(*3511*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 3512*)
(*3512*)  (*BRANCH NAME*)
} note note887 = this
(* po redu: 3513*)
(*3513*)  
(*BRANCH END*)
from note886 and note887 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3514*)
(*3514*)  (*BRANCH NAME*)
} note note888 = this
(* po redu: 3515*)
(*3515*)  
(*BRANCH END*)
from note885 and note888 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3516*)
(*3516*)  (*BRANCH NAME*)
} note note889 = this
(* po redu: 3517*)
(*3517*)  
(*BRANCH END*)
from note882 and note889 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3518*)
(*3518*)  (*BRANCH NAME*)
} note note890 = this
(* po redu: 3519*)
(*3519*)  
(*BRANCH END*)
from note875 and note890 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 3520*)
(*3520*)  (*BRANCH NAME*)
} note note891 = this
(* po redu: 3521*)
(*3521*)  
(*BRANCH END*)
from note860 and note891 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 3522*)
(*3522*)  (*BRANCH NAME*)
} note note892 = this
(* po redu: 3523*)
(*3523*)  
(*BRANCH END*)
from note829 and note892 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 3524*)
(*3524*)  (*BRANCH NAME*)
} note note893 = this
(* po redu: 3525*)
(*3525*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 3526*)
(*3526*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 3527*)
(*3527*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 3528*)
(*3528*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 3529*)
(*3529*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 3530*)
(*3530*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 3531*)
(*3531*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 3532*)
(*3532*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3533*)
(*3533*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3534*)
(*3534*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3535*)
(*3535*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3536*)
(*3536*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3537*)
(*3537*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3538*)
(*3538*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3539*)
(*3539*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3540*)
(*3540*)  (*BRANCH NAME*)
} note note894 = this
(* po redu: 3541*)
(*3541*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3542*)
(*3542*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3543*)
(*3543*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3544*)
(*3544*)  (*BRANCH NAME*)
} note note895 = this
(* po redu: 3545*)
(*3545*)  
(*BRANCH END*)
from note894 and note895 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3546*)
(*3546*)  (*BRANCH NAME*)
} note note896 = this
(* po redu: 3547*)
(*3547*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3548*)
(*3548*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3549*)
(*3549*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3550*)
(*3550*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3551*)
(*3551*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3552*)
(*3552*)  (*BRANCH NAME*)
} note note897 = this
(* po redu: 3553*)
(*3553*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3554*)
(*3554*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3555*)
(*3555*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3556*)
(*3556*)  (*BRANCH NAME*)
} note note898 = this
(* po redu: 3557*)
(*3557*)  
(*BRANCH END*)
from note897 and note898 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3558*)
(*3558*)  (*BRANCH NAME*)
} note note899 = this
(* po redu: 3559*)
(*3559*)  
(*BRANCH END*)
from note896 and note899 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3560*)
(*3560*)  (*BRANCH NAME*)
} note note900 = this
(* po redu: 3561*)
(*3561*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3562*)
(*3562*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3563*)
(*3563*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3564*)
(*3564*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3565*)
(*3565*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3566*)
(*3566*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3567*)
(*3567*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3568*)
(*3568*)  (*BRANCH NAME*)
} note note901 = this
(* po redu: 3569*)
(*3569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3570*)
(*3570*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3571*)
(*3571*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3572*)
(*3572*)  (*BRANCH NAME*)
} note note902 = this
(* po redu: 3573*)
(*3573*)  
(*BRANCH END*)
from note901 and note902 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3574*)
(*3574*)  (*BRANCH NAME*)
} note note903 = this
(* po redu: 3575*)
(*3575*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3576*)
(*3576*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3577*)
(*3577*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3578*)
(*3578*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3579*)
(*3579*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3580*)
(*3580*)  (*BRANCH NAME*)
} note note904 = this
(* po redu: 3581*)
(*3581*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3582*)
(*3582*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3583*)
(*3583*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3584*)
(*3584*)  (*BRANCH NAME*)
} note note905 = this
(* po redu: 3585*)
(*3585*)  
(*BRANCH END*)
from note904 and note905 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3586*)
(*3586*)  (*BRANCH NAME*)
} note note906 = this
(* po redu: 3587*)
(*3587*)  
(*BRANCH END*)
from note903 and note906 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3588*)
(*3588*)  (*BRANCH NAME*)
} note note907 = this
(* po redu: 3589*)
(*3589*)  
(*BRANCH END*)
from note900 and note907 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3590*)
(*3590*)  (*BRANCH NAME*)
} note note908 = this
(* po redu: 3591*)
(*3591*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 3592*)
(*3592*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3593*)
(*3593*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3594*)
(*3594*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3595*)
(*3595*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3596*)
(*3596*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3597*)
(*3597*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3598*)
(*3598*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3599*)
(*3599*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3600*)
(*3600*)  (*BRANCH NAME*)
} note note909 = this
(* po redu: 3601*)
(*3601*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3602*)
(*3602*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3603*)
(*3603*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3604*)
(*3604*)  (*BRANCH NAME*)
} note note910 = this
(* po redu: 3605*)
(*3605*)  
(*BRANCH END*)
from note909 and note910 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3606*)
(*3606*)  (*BRANCH NAME*)
} note note911 = this
(* po redu: 3607*)
(*3607*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3608*)
(*3608*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3609*)
(*3609*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3610*)
(*3610*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3611*)
(*3611*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3612*)
(*3612*)  (*BRANCH NAME*)
} note note912 = this
(* po redu: 3613*)
(*3613*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3614*)
(*3614*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3615*)
(*3615*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3616*)
(*3616*)  (*BRANCH NAME*)
} note note913 = this
(* po redu: 3617*)
(*3617*)  
(*BRANCH END*)
from note912 and note913 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3618*)
(*3618*)  (*BRANCH NAME*)
} note note914 = this
(* po redu: 3619*)
(*3619*)  
(*BRANCH END*)
from note911 and note914 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3620*)
(*3620*)  (*BRANCH NAME*)
} note note915 = this
(* po redu: 3621*)
(*3621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3622*)
(*3622*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3623*)
(*3623*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3624*)
(*3624*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3625*)
(*3625*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3626*)
(*3626*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3627*)
(*3627*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3628*)
(*3628*)  (*BRANCH NAME*)
} note note916 = this
(* po redu: 3629*)
(*3629*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3630*)
(*3630*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3631*)
(*3631*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3632*)
(*3632*)  (*BRANCH NAME*)
} note note917 = this
(* po redu: 3633*)
(*3633*)  
(*BRANCH END*)
from note916 and note917 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3634*)
(*3634*)  (*BRANCH NAME*)
} note note918 = this
(* po redu: 3635*)
(*3635*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3636*)
(*3636*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3637*)
(*3637*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3638*)
(*3638*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3639*)
(*3639*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3640*)
(*3640*)  (*BRANCH NAME*)
} note note919 = this
(* po redu: 3641*)
(*3641*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3642*)
(*3642*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3643*)
(*3643*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3644*)
(*3644*)  (*BRANCH NAME*)
} note note920 = this
(* po redu: 3645*)
(*3645*)  
(*BRANCH END*)
from note919 and note920 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3646*)
(*3646*)  (*BRANCH NAME*)
} note note921 = this
(* po redu: 3647*)
(*3647*)  
(*BRANCH END*)
from note918 and note921 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3648*)
(*3648*)  (*BRANCH NAME*)
} note note922 = this
(* po redu: 3649*)
(*3649*)  
(*BRANCH END*)
from note915 and note922 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3650*)
(*3650*)  (*BRANCH NAME*)
} note note923 = this
(* po redu: 3651*)
(*3651*)  
(*BRANCH END*)
from note908 and note923 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 3652*)
(*3652*)  (*BRANCH NAME*)
} note note924 = this
(* po redu: 3653*)
(*3653*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 3654*)
(*3654*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 3655*)
(*3655*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 3656*)
(*3656*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3657*)
(*3657*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3658*)
(*3658*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3659*)
(*3659*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3660*)
(*3660*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3661*)
(*3661*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3662*)
(*3662*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3663*)
(*3663*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3664*)
(*3664*)  (*BRANCH NAME*)
} note note925 = this
(* po redu: 3665*)
(*3665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3666*)
(*3666*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3667*)
(*3667*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3668*)
(*3668*)  (*BRANCH NAME*)
} note note926 = this
(* po redu: 3669*)
(*3669*)  
(*BRANCH END*)
from note925 and note926 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3670*)
(*3670*)  (*BRANCH NAME*)
} note note927 = this
(* po redu: 3671*)
(*3671*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3672*)
(*3672*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3673*)
(*3673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3674*)
(*3674*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3675*)
(*3675*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3676*)
(*3676*)  (*BRANCH NAME*)
} note note928 = this
(* po redu: 3677*)
(*3677*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3678*)
(*3678*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3679*)
(*3679*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3680*)
(*3680*)  (*BRANCH NAME*)
} note note929 = this
(* po redu: 3681*)
(*3681*)  
(*BRANCH END*)
from note928 and note929 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3682*)
(*3682*)  (*BRANCH NAME*)
} note note930 = this
(* po redu: 3683*)
(*3683*)  
(*BRANCH END*)
from note927 and note930 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3684*)
(*3684*)  (*BRANCH NAME*)
} note note931 = this
(* po redu: 3685*)
(*3685*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3686*)
(*3686*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3687*)
(*3687*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3688*)
(*3688*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3689*)
(*3689*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3690*)
(*3690*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3691*)
(*3691*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3692*)
(*3692*)  (*BRANCH NAME*)
} note note932 = this
(* po redu: 3693*)
(*3693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3694*)
(*3694*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3695*)
(*3695*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3696*)
(*3696*)  (*BRANCH NAME*)
} note note933 = this
(* po redu: 3697*)
(*3697*)  
(*BRANCH END*)
from note932 and note933 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3698*)
(*3698*)  (*BRANCH NAME*)
} note note934 = this
(* po redu: 3699*)
(*3699*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3700*)
(*3700*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3701*)
(*3701*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3702*)
(*3702*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3703*)
(*3703*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3704*)
(*3704*)  (*BRANCH NAME*)
} note note935 = this
(* po redu: 3705*)
(*3705*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3706*)
(*3706*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3707*)
(*3707*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3708*)
(*3708*)  (*BRANCH NAME*)
} note note936 = this
(* po redu: 3709*)
(*3709*)  
(*BRANCH END*)
from note935 and note936 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3710*)
(*3710*)  (*BRANCH NAME*)
} note note937 = this
(* po redu: 3711*)
(*3711*)  
(*BRANCH END*)
from note934 and note937 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3712*)
(*3712*)  (*BRANCH NAME*)
} note note938 = this
(* po redu: 3713*)
(*3713*)  
(*BRANCH END*)
from note931 and note938 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3714*)
(*3714*)  (*BRANCH NAME*)
} note note939 = this
(* po redu: 3715*)
(*3715*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 3716*)
(*3716*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3717*)
(*3717*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3718*)
(*3718*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3719*)
(*3719*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3720*)
(*3720*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3721*)
(*3721*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3722*)
(*3722*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3723*)
(*3723*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3724*)
(*3724*)  (*BRANCH NAME*)
} note note940 = this
(* po redu: 3725*)
(*3725*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3726*)
(*3726*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3727*)
(*3727*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3728*)
(*3728*)  (*BRANCH NAME*)
} note note941 = this
(* po redu: 3729*)
(*3729*)  
(*BRANCH END*)
from note940 and note941 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3730*)
(*3730*)  (*BRANCH NAME*)
} note note942 = this
(* po redu: 3731*)
(*3731*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3732*)
(*3732*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3733*)
(*3733*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3734*)
(*3734*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3735*)
(*3735*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3736*)
(*3736*)  (*BRANCH NAME*)
} note note943 = this
(* po redu: 3737*)
(*3737*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3738*)
(*3738*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3739*)
(*3739*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3740*)
(*3740*)  (*BRANCH NAME*)
} note note944 = this
(* po redu: 3741*)
(*3741*)  
(*BRANCH END*)
from note943 and note944 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3742*)
(*3742*)  (*BRANCH NAME*)
} note note945 = this
(* po redu: 3743*)
(*3743*)  
(*BRANCH END*)
from note942 and note945 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3744*)
(*3744*)  (*BRANCH NAME*)
} note note946 = this
(* po redu: 3745*)
(*3745*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3746*)
(*3746*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3747*)
(*3747*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3748*)
(*3748*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3749*)
(*3749*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3750*)
(*3750*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3751*)
(*3751*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3752*)
(*3752*)  (*BRANCH NAME*)
} note note947 = this
(* po redu: 3753*)
(*3753*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3754*)
(*3754*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3755*)
(*3755*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3756*)
(*3756*)  (*BRANCH NAME*)
} note note948 = this
(* po redu: 3757*)
(*3757*)  
(*BRANCH END*)
from note947 and note948 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3758*)
(*3758*)  (*BRANCH NAME*)
} note note949 = this
(* po redu: 3759*)
(*3759*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3760*)
(*3760*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3761*)
(*3761*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3762*)
(*3762*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 3763*)
(*3763*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 3764*)
(*3764*)  (*BRANCH NAME*)
} note note950 = this
(* po redu: 3765*)
(*3765*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3766*)
(*3766*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3767*)
(*3767*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3768*)
(*3768*)  (*BRANCH NAME*)
} note note951 = this
(* po redu: 3769*)
(*3769*)  
(*BRANCH END*)
from note950 and note951 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3770*)
(*3770*)  (*BRANCH NAME*)
} note note952 = this
(* po redu: 3771*)
(*3771*)  
(*BRANCH END*)
from note949 and note952 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3772*)
(*3772*)  (*BRANCH NAME*)
} note note953 = this
(* po redu: 3773*)
(*3773*)  
(*BRANCH END*)
from note946 and note953 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3774*)
(*3774*)  (*BRANCH NAME*)
} note note954 = this
(* po redu: 3775*)
(*3775*)  
(*BRANCH END*)
from note939 and note954 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 3776*)
(*3776*)  (*BRANCH NAME*)
} note note955 = this
(* po redu: 3777*)
(*3777*)  
(*BRANCH END*)
from note924 and note955 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 3778*)
(*3778*)  (*BRANCH NAME*)
} note note956 = this
(* po redu: 3779*)
(*3779*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 3780*)
(*3780*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 3781*)
(*3781*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 3782*)
(*3782*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 3783*)
(*3783*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 3784*)
(*3784*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3785*)
(*3785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3786*)
(*3786*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3787*)
(*3787*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3788*)
(*3788*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3789*)
(*3789*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3790*)
(*3790*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note957 = this
(* po redu: 3791*)
(*3791*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3792*)
(*3792*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3793*)
(*3793*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3794*)
(*3794*)  (*BRANCH NAME*)
} note note958 = this
(* po redu: 3795*)
(*3795*)  
(*BRANCH END*)
from note957 and note958 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 3796*)
(*3796*)  (*BRANCH NAME*)
} note note959 = this
(* po redu: 3797*)
(*3797*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3798*)
(*3798*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3799*)
(*3799*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3800*)
(*3800*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3801*)
(*3801*)  (*BRANCH NAME*)
} note note960 = this
(* po redu: 3802*)
(*3802*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3803*)
(*3803*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3804*)
(*3804*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3805*)
(*3805*)  (*BRANCH NAME*)
} note note961 = this
(* po redu: 3806*)
(*3806*)  
(*BRANCH END*)
from note960 and note961 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3807*)
(*3807*)  (*BRANCH NAME*)
} note note962 = this
(* po redu: 3808*)
(*3808*)  
(*BRANCH END*)
from note959 and note962 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 3809*)
(*3809*)  (*BRANCH NAME*)
} note note963 = this
(* po redu: 3810*)
(*3810*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3811*)
(*3811*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3812*)
(*3812*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3813*)
(*3813*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3814*)
(*3814*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3815*)
(*3815*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3816*)
(*3816*)  (*BRANCH NAME*)
} note note964 = this
(* po redu: 3817*)
(*3817*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3818*)
(*3818*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3819*)
(*3819*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3820*)
(*3820*)  (*BRANCH NAME*)
} note note965 = this
(* po redu: 3821*)
(*3821*)  
(*BRANCH END*)
from note964 and note965 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3822*)
(*3822*)  (*BRANCH NAME*)
} note note966 = this
(* po redu: 3823*)
(*3823*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3824*)
(*3824*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3825*)
(*3825*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3826*)
(*3826*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note967 = this
(* po redu: 3827*)
(*3827*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3828*)
(*3828*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3829*)
(*3829*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3830*)
(*3830*)  (*BRANCH NAME*)
} note note968 = this
(* po redu: 3831*)
(*3831*)  
(*BRANCH END*)
from note967 and note968 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 3832*)
(*3832*)  (*BRANCH NAME*)
} note note969 = this
(* po redu: 3833*)
(*3833*)  
(*BRANCH END*)
from note966 and note969 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 3834*)
(*3834*)  (*BRANCH NAME*)
} note note970 = this
(* po redu: 3835*)
(*3835*)  
(*BRANCH END*)
from note963 and note970 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 3836*)
(*3836*)  (*BRANCH NAME*)
} note note971 = this
(* po redu: 3837*)
(*3837*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 3838*)
(*3838*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3839*)
(*3839*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3840*)
(*3840*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3841*)
(*3841*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3842*)
(*3842*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3843*)
(*3843*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3844*)
(*3844*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3845*)
(*3845*)  (*BRANCH NAME*)
} note note972 = this
(* po redu: 3846*)
(*3846*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3847*)
(*3847*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3848*)
(*3848*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3849*)
(*3849*)  (*BRANCH NAME*)
} note note973 = this
(* po redu: 3850*)
(*3850*)  
(*BRANCH END*)
from note972 and note973 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3851*)
(*3851*)  (*BRANCH NAME*)
} note note974 = this
(* po redu: 3852*)
(*3852*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3853*)
(*3853*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3854*)
(*3854*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3855*)
(*3855*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3856*)
(*3856*)  (*BRANCH NAME*)
} note note975 = this
(* po redu: 3857*)
(*3857*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3858*)
(*3858*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3859*)
(*3859*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3860*)
(*3860*)  (*BRANCH NAME*)
} note note976 = this
(* po redu: 3861*)
(*3861*)  
(*BRANCH END*)
from note975 and note976 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3862*)
(*3862*)  (*BRANCH NAME*)
} note note977 = this
(* po redu: 3863*)
(*3863*)  
(*BRANCH END*)
from note974 and note977 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3864*)
(*3864*)  (*BRANCH NAME*)
} note note978 = this
(* po redu: 3865*)
(*3865*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3866*)
(*3866*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3867*)
(*3867*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3868*)
(*3868*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3869*)
(*3869*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3870*)
(*3870*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3871*)
(*3871*)  (*BRANCH NAME*)
} note note979 = this
(* po redu: 3872*)
(*3872*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3873*)
(*3873*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3874*)
(*3874*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3875*)
(*3875*)  (*BRANCH NAME*)
} note note980 = this
(* po redu: 3876*)
(*3876*)  
(*BRANCH END*)
from note979 and note980 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3877*)
(*3877*)  (*BRANCH NAME*)
} note note981 = this
(* po redu: 3878*)
(*3878*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3879*)
(*3879*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3880*)
(*3880*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3881*)
(*3881*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3882*)
(*3882*)  (*BRANCH NAME*)
} note note982 = this
(* po redu: 3883*)
(*3883*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3884*)
(*3884*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3885*)
(*3885*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3886*)
(*3886*)  (*BRANCH NAME*)
} note note983 = this
(* po redu: 3887*)
(*3887*)  
(*BRANCH END*)
from note982 and note983 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3888*)
(*3888*)  (*BRANCH NAME*)
} note note984 = this
(* po redu: 3889*)
(*3889*)  
(*BRANCH END*)
from note981 and note984 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3890*)
(*3890*)  (*BRANCH NAME*)
} note note985 = this
(* po redu: 3891*)
(*3891*)  
(*BRANCH END*)
from note978 and note985 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3892*)
(*3892*)  (*BRANCH NAME*)
} note note986 = this
(* po redu: 3893*)
(*3893*)  
(*BRANCH END*)
from note971 and note986 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 3894*)
(*3894*)  (*BRANCH NAME*)
} note note987 = this
(* po redu: 3895*)
(*3895*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 3896*)
(*3896*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 3897*)
(*3897*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 3898*)
(*3898*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3899*)
(*3899*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3900*)
(*3900*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3901*)
(*3901*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3902*)
(*3902*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3903*)
(*3903*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3904*)
(*3904*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3905*)
(*3905*)  (*BRANCH NAME*)
} note note988 = this
(* po redu: 3906*)
(*3906*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3907*)
(*3907*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3908*)
(*3908*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3909*)
(*3909*)  (*BRANCH NAME*)
} note note989 = this
(* po redu: 3910*)
(*3910*)  
(*BRANCH END*)
from note988 and note989 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3911*)
(*3911*)  (*BRANCH NAME*)
} note note990 = this
(* po redu: 3912*)
(*3912*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3913*)
(*3913*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3914*)
(*3914*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3915*)
(*3915*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3916*)
(*3916*)  (*BRANCH NAME*)
} note note991 = this
(* po redu: 3917*)
(*3917*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3918*)
(*3918*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3919*)
(*3919*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3920*)
(*3920*)  (*BRANCH NAME*)
} note note992 = this
(* po redu: 3921*)
(*3921*)  
(*BRANCH END*)
from note991 and note992 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3922*)
(*3922*)  (*BRANCH NAME*)
} note note993 = this
(* po redu: 3923*)
(*3923*)  
(*BRANCH END*)
from note990 and note993 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3924*)
(*3924*)  (*BRANCH NAME*)
} note note994 = this
(* po redu: 3925*)
(*3925*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3926*)
(*3926*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3927*)
(*3927*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3928*)
(*3928*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3929*)
(*3929*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3930*)
(*3930*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3931*)
(*3931*)  (*BRANCH NAME*)
} note note995 = this
(* po redu: 3932*)
(*3932*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3933*)
(*3933*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3934*)
(*3934*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3935*)
(*3935*)  (*BRANCH NAME*)
} note note996 = this
(* po redu: 3936*)
(*3936*)  
(*BRANCH END*)
from note995 and note996 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3937*)
(*3937*)  (*BRANCH NAME*)
} note note997 = this
(* po redu: 3938*)
(*3938*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3939*)
(*3939*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3940*)
(*3940*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3941*)
(*3941*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3942*)
(*3942*)  (*BRANCH NAME*)
} note note998 = this
(* po redu: 3943*)
(*3943*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3944*)
(*3944*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3945*)
(*3945*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3946*)
(*3946*)  (*BRANCH NAME*)
} note note999 = this
(* po redu: 3947*)
(*3947*)  
(*BRANCH END*)
from note998 and note999 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3948*)
(*3948*)  (*BRANCH NAME*)
} note note1000 = this
(* po redu: 3949*)
(*3949*)  
(*BRANCH END*)
from note997 and note1000 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 3950*)
(*3950*)  (*BRANCH NAME*)
} note note1001 = this
(* po redu: 3951*)
(*3951*)  
(*BRANCH END*)
from note994 and note1001 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 3952*)
(*3952*)  (*BRANCH NAME*)
} note note1002 = this
(* po redu: 3953*)
(*3953*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 3954*)
(*3954*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 3955*)
(*3955*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 3956*)
(*3956*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3957*)
(*3957*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3958*)
(*3958*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3959*)
(*3959*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3960*)
(*3960*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1003 = this
(* po redu: 3961*)
(*3961*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3962*)
(*3962*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3963*)
(*3963*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3964*)
(*3964*)  (*BRANCH NAME*)
} note note1004 = this
(* po redu: 3965*)
(*3965*)  
(*BRANCH END*)
from note1003 and note1004 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 3966*)
(*3966*)  (*BRANCH NAME*)
} note note1005 = this
(* po redu: 3967*)
(*3967*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3968*)
(*3968*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3969*)
(*3969*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3970*)
(*3970*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3971*)
(*3971*)  (*BRANCH NAME*)
} note note1006 = this
(* po redu: 3972*)
(*3972*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3973*)
(*3973*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3974*)
(*3974*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3975*)
(*3975*)  (*BRANCH NAME*)
} note note1007 = this
(* po redu: 3976*)
(*3976*)  
(*BRANCH END*)
from note1006 and note1007 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3977*)
(*3977*)  (*BRANCH NAME*)
} note note1008 = this
(* po redu: 3978*)
(*3978*)  
(*BRANCH END*)
from note1005 and note1008 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 3979*)
(*3979*)  (*BRANCH NAME*)
} note note1009 = this
(* po redu: 3980*)
(*3980*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 3981*)
(*3981*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 3982*)
(*3982*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 3983*)
(*3983*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3984*)
(*3984*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3985*)
(*3985*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 3986*)
(*3986*)  (*BRANCH NAME*)
} note note1010 = this
(* po redu: 3987*)
(*3987*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3988*)
(*3988*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3989*)
(*3989*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 3990*)
(*3990*)  (*BRANCH NAME*)
} note note1011 = this
(* po redu: 3991*)
(*3991*)  
(*BRANCH END*)
from note1010 and note1011 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 3992*)
(*3992*)  (*BRANCH NAME*)
} note note1012 = this
(* po redu: 3993*)
(*3993*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 3994*)
(*3994*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 3995*)
(*3995*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 3996*)
(*3996*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1013 = this
(* po redu: 3997*)
(*3997*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 3998*)
(*3998*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 3999*)
(*3999*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4000*)
(*4000*)  (*BRANCH NAME*)
} note note1014 = this
(* po redu: 4001*)
(*4001*)  
(*BRANCH END*)
from note1013 and note1014 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 4002*)
(*4002*)  (*BRANCH NAME*)
} note note1015 = this
(* po redu: 4003*)
(*4003*)  
(*BRANCH END*)
from note1012 and note1015 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 4004*)
(*4004*)  (*BRANCH NAME*)
} note note1016 = this
(* po redu: 4005*)
(*4005*)  
(*BRANCH END*)
from note1009 and note1016 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 4006*)
(*4006*)  (*BRANCH NAME*)
} note note1017 = this
(* po redu: 4007*)
(*4007*)  
(*BRANCH END*)
from note1002 and note1017 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 4008*)
(*4008*)  (*BRANCH NAME*)
} note note1018 = this
(* po redu: 4009*)
(*4009*)  
(*BRANCH END*)
from note987 and note1018 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 4010*)
(*4010*)  (*BRANCH NAME*)
} note note1019 = this
(* po redu: 4011*)
(*4011*)  
(*BRANCH END*)
from note956 and note1019 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 4012*)
(*4012*)  (*BRANCH NAME*)
} note note1020 = this
(* po redu: 4013*)
(*4013*)  
(*BRANCH END*)
from note893 and note1020 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 4014*)
(*4014*)  (*BRANCH NAME*)
} note note1021 = this
(* po redu: 4015*)
(*4015*)  
(*BRANCH END*)
from note766 and note1021 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 4016*)
(*4016*)  (*BRANCH NAME*)
} note note1022 = this
(* po redu: 4017*)
(*4017*)  
(*BRANCH END*)
from note511 and note1022 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have ?thesis
by auto
(* po redu: 4018*)
(*4018*)  (*BRANCH NAME*)
} note note1023 = this
(* po redu: 4019*)
(*4019*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
(* po redu: 4020*)
(*4020*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(* po redu: 4021*)
(*4021*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
(* po redu: 4022*)
(*4022*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 4023*)
(*4023*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 4024*)
(*4024*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 4025*)
(*4025*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 4026*)
(*4026*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 4027*)
(*4027*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 4028*)
(*4028*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 4029*)
(*4029*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 4030*)
(*4030*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 4031*)
(*4031*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 4032*)
(*4032*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4033*)
(*4033*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4034*)
(*4034*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4035*)
(*4035*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4036*)
(*4036*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4037*)
(*4037*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4038*)
(*4038*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1024 = this
(* po redu: 4039*)
(*4039*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4040*)
(*4040*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4041*)
(*4041*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4042*)
(*4042*)  (*BRANCH NAME*)
} note note1025 = this
(* po redu: 4043*)
(*4043*)  
(*BRANCH END*)
from note1024 and note1025 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 4044*)
(*4044*)  (*BRANCH NAME*)
} note note1026 = this
(* po redu: 4045*)
(*4045*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4046*)
(*4046*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4047*)
(*4047*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4048*)
(*4048*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4049*)
(*4049*)  (*BRANCH NAME*)
} note note1027 = this
(* po redu: 4050*)
(*4050*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4051*)
(*4051*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4052*)
(*4052*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4053*)
(*4053*)  (*BRANCH NAME*)
} note note1028 = this
(* po redu: 4054*)
(*4054*)  
(*BRANCH END*)
from note1027 and note1028 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4055*)
(*4055*)  (*BRANCH NAME*)
} note note1029 = this
(* po redu: 4056*)
(*4056*)  
(*BRANCH END*)
from note1026 and note1029 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 4057*)
(*4057*)  (*BRANCH NAME*)
} note note1030 = this
(* po redu: 4058*)
(*4058*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4059*)
(*4059*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4060*)
(*4060*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4061*)
(*4061*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4062*)
(*4062*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4063*)
(*4063*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4064*)
(*4064*)  (*BRANCH NAME*)
} note note1031 = this
(* po redu: 4065*)
(*4065*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4066*)
(*4066*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4067*)
(*4067*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4068*)
(*4068*)  (*BRANCH NAME*)
} note note1032 = this
(* po redu: 4069*)
(*4069*)  
(*BRANCH END*)
from note1031 and note1032 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4070*)
(*4070*)  (*BRANCH NAME*)
} note note1033 = this
(* po redu: 4071*)
(*4071*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4072*)
(*4072*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4073*)
(*4073*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4074*)
(*4074*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1034 = this
(* po redu: 4075*)
(*4075*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4076*)
(*4076*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4077*)
(*4077*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4078*)
(*4078*)  (*BRANCH NAME*)
} note note1035 = this
(* po redu: 4079*)
(*4079*)  
(*BRANCH END*)
from note1034 and note1035 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 4080*)
(*4080*)  (*BRANCH NAME*)
} note note1036 = this
(* po redu: 4081*)
(*4081*)  
(*BRANCH END*)
from note1033 and note1036 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 4082*)
(*4082*)  (*BRANCH NAME*)
} note note1037 = this
(* po redu: 4083*)
(*4083*)  
(*BRANCH END*)
from note1030 and note1037 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 4084*)
(*4084*)  (*BRANCH NAME*)
} note note1038 = this
(* po redu: 4085*)
(*4085*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 4086*)
(*4086*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4087*)
(*4087*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4088*)
(*4088*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4089*)
(*4089*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4090*)
(*4090*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4091*)
(*4091*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4092*)
(*4092*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4093*)
(*4093*)  (*BRANCH NAME*)
} note note1039 = this
(* po redu: 4094*)
(*4094*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4095*)
(*4095*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4096*)
(*4096*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4097*)
(*4097*)  (*BRANCH NAME*)
} note note1040 = this
(* po redu: 4098*)
(*4098*)  
(*BRANCH END*)
from note1039 and note1040 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4099*)
(*4099*)  (*BRANCH NAME*)
} note note1041 = this
(* po redu: 4100*)
(*4100*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4101*)
(*4101*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4102*)
(*4102*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4103*)
(*4103*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4104*)
(*4104*)  (*BRANCH NAME*)
} note note1042 = this
(* po redu: 4105*)
(*4105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4106*)
(*4106*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4107*)
(*4107*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4108*)
(*4108*)  (*BRANCH NAME*)
} note note1043 = this
(* po redu: 4109*)
(*4109*)  
(*BRANCH END*)
from note1042 and note1043 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4110*)
(*4110*)  (*BRANCH NAME*)
} note note1044 = this
(* po redu: 4111*)
(*4111*)  
(*BRANCH END*)
from note1041 and note1044 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4112*)
(*4112*)  (*BRANCH NAME*)
} note note1045 = this
(* po redu: 4113*)
(*4113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4114*)
(*4114*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4115*)
(*4115*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4116*)
(*4116*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4117*)
(*4117*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4118*)
(*4118*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4119*)
(*4119*)  (*BRANCH NAME*)
} note note1046 = this
(* po redu: 4120*)
(*4120*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4121*)
(*4121*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4122*)
(*4122*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4123*)
(*4123*)  (*BRANCH NAME*)
} note note1047 = this
(* po redu: 4124*)
(*4124*)  
(*BRANCH END*)
from note1046 and note1047 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4125*)
(*4125*)  (*BRANCH NAME*)
} note note1048 = this
(* po redu: 4126*)
(*4126*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4127*)
(*4127*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4128*)
(*4128*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4129*)
(*4129*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4130*)
(*4130*)  (*BRANCH NAME*)
} note note1049 = this
(* po redu: 4131*)
(*4131*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4132*)
(*4132*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4133*)
(*4133*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4134*)
(*4134*)  (*BRANCH NAME*)
} note note1050 = this
(* po redu: 4135*)
(*4135*)  
(*BRANCH END*)
from note1049 and note1050 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4136*)
(*4136*)  (*BRANCH NAME*)
} note note1051 = this
(* po redu: 4137*)
(*4137*)  
(*BRANCH END*)
from note1048 and note1051 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4138*)
(*4138*)  (*BRANCH NAME*)
} note note1052 = this
(* po redu: 4139*)
(*4139*)  
(*BRANCH END*)
from note1045 and note1052 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4140*)
(*4140*)  (*BRANCH NAME*)
} note note1053 = this
(* po redu: 4141*)
(*4141*)  
(*BRANCH END*)
from note1038 and note1053 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 4142*)
(*4142*)  (*BRANCH NAME*)
} note note1054 = this
(* po redu: 4143*)
(*4143*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 4144*)
(*4144*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 4145*)
(*4145*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 4146*)
(*4146*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4147*)
(*4147*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4148*)
(*4148*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4149*)
(*4149*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4150*)
(*4150*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4151*)
(*4151*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4152*)
(*4152*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4153*)
(*4153*)  (*BRANCH NAME*)
} note note1055 = this
(* po redu: 4154*)
(*4154*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4155*)
(*4155*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4156*)
(*4156*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4157*)
(*4157*)  (*BRANCH NAME*)
} note note1056 = this
(* po redu: 4158*)
(*4158*)  
(*BRANCH END*)
from note1055 and note1056 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4159*)
(*4159*)  (*BRANCH NAME*)
} note note1057 = this
(* po redu: 4160*)
(*4160*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4161*)
(*4161*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4162*)
(*4162*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4163*)
(*4163*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4164*)
(*4164*)  (*BRANCH NAME*)
} note note1058 = this
(* po redu: 4165*)
(*4165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4166*)
(*4166*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4167*)
(*4167*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4168*)
(*4168*)  (*BRANCH NAME*)
} note note1059 = this
(* po redu: 4169*)
(*4169*)  
(*BRANCH END*)
from note1058 and note1059 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4170*)
(*4170*)  (*BRANCH NAME*)
} note note1060 = this
(* po redu: 4171*)
(*4171*)  
(*BRANCH END*)
from note1057 and note1060 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4172*)
(*4172*)  (*BRANCH NAME*)
} note note1061 = this
(* po redu: 4173*)
(*4173*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4174*)
(*4174*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4175*)
(*4175*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4176*)
(*4176*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4177*)
(*4177*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4178*)
(*4178*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4179*)
(*4179*)  (*BRANCH NAME*)
} note note1062 = this
(* po redu: 4180*)
(*4180*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4181*)
(*4181*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4182*)
(*4182*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4183*)
(*4183*)  (*BRANCH NAME*)
} note note1063 = this
(* po redu: 4184*)
(*4184*)  
(*BRANCH END*)
from note1062 and note1063 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4185*)
(*4185*)  (*BRANCH NAME*)
} note note1064 = this
(* po redu: 4186*)
(*4186*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4187*)
(*4187*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4188*)
(*4188*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4189*)
(*4189*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4190*)
(*4190*)  (*BRANCH NAME*)
} note note1065 = this
(* po redu: 4191*)
(*4191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4192*)
(*4192*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4193*)
(*4193*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4194*)
(*4194*)  (*BRANCH NAME*)
} note note1066 = this
(* po redu: 4195*)
(*4195*)  
(*BRANCH END*)
from note1065 and note1066 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4196*)
(*4196*)  (*BRANCH NAME*)
} note note1067 = this
(* po redu: 4197*)
(*4197*)  
(*BRANCH END*)
from note1064 and note1067 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4198*)
(*4198*)  (*BRANCH NAME*)
} note note1068 = this
(* po redu: 4199*)
(*4199*)  
(*BRANCH END*)
from note1061 and note1068 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4200*)
(*4200*)  (*BRANCH NAME*)
} note note1069 = this
(* po redu: 4201*)
(*4201*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 4202*)
(*4202*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4203*)
(*4203*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4204*)
(*4204*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4205*)
(*4205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4206*)
(*4206*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4207*)
(*4207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4208*)
(*4208*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1070 = this
(* po redu: 4209*)
(*4209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4210*)
(*4210*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4211*)
(*4211*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4212*)
(*4212*)  (*BRANCH NAME*)
} note note1071 = this
(* po redu: 4213*)
(*4213*)  
(*BRANCH END*)
from note1070 and note1071 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 4214*)
(*4214*)  (*BRANCH NAME*)
} note note1072 = this
(* po redu: 4215*)
(*4215*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4216*)
(*4216*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4217*)
(*4217*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4218*)
(*4218*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4219*)
(*4219*)  (*BRANCH NAME*)
} note note1073 = this
(* po redu: 4220*)
(*4220*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4221*)
(*4221*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4222*)
(*4222*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4223*)
(*4223*)  (*BRANCH NAME*)
} note note1074 = this
(* po redu: 4224*)
(*4224*)  
(*BRANCH END*)
from note1073 and note1074 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4225*)
(*4225*)  (*BRANCH NAME*)
} note note1075 = this
(* po redu: 4226*)
(*4226*)  
(*BRANCH END*)
from note1072 and note1075 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 4227*)
(*4227*)  (*BRANCH NAME*)
} note note1076 = this
(* po redu: 4228*)
(*4228*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4229*)
(*4229*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4230*)
(*4230*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4231*)
(*4231*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4232*)
(*4232*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4233*)
(*4233*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 4234*)
(*4234*)  (*BRANCH NAME*)
} note note1077 = this
(* po redu: 4235*)
(*4235*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4236*)
(*4236*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4237*)
(*4237*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4238*)
(*4238*)  (*BRANCH NAME*)
} note note1078 = this
(* po redu: 4239*)
(*4239*)  
(*BRANCH END*)
from note1077 and note1078 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4240*)
(*4240*)  (*BRANCH NAME*)
} note note1079 = this
(* po redu: 4241*)
(*4241*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4242*)
(*4242*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4243*)
(*4243*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4244*)
(*4244*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1080 = this
(* po redu: 4245*)
(*4245*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4246*)
(*4246*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4247*)
(*4247*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4248*)
(*4248*)  (*BRANCH NAME*)
} note note1081 = this
(* po redu: 4249*)
(*4249*)  
(*BRANCH END*)
from note1080 and note1081 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 4250*)
(*4250*)  (*BRANCH NAME*)
} note note1082 = this
(* po redu: 4251*)
(*4251*)  
(*BRANCH END*)
from note1079 and note1082 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 4252*)
(*4252*)  (*BRANCH NAME*)
} note note1083 = this
(* po redu: 4253*)
(*4253*)  
(*BRANCH END*)
from note1076 and note1083 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 4254*)
(*4254*)  (*BRANCH NAME*)
} note note1084 = this
(* po redu: 4255*)
(*4255*)  
(*BRANCH END*)
from note1069 and note1084 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 4256*)
(*4256*)  (*BRANCH NAME*)
} note note1085 = this
(* po redu: 4257*)
(*4257*)  
(*BRANCH END*)
from note1054 and note1085 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 4258*)
(*4258*)  (*BRANCH NAME*)
} note note1086 = this
(* po redu: 4259*)
(*4259*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 4260*)
(*4260*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 4261*)
(*4261*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 4262*)
(*4262*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 4263*)
(*4263*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 4264*)
(*4264*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4265*)
(*4265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4266*)
(*4266*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4267*)
(*4267*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4268*)
(*4268*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4269*)
(*4269*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4270*)
(*4270*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4271*)
(*4271*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4272*)
(*4272*)  (*BRANCH NAME*)
} note note1087 = this
(* po redu: 4273*)
(*4273*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4274*)
(*4274*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4275*)
(*4275*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4276*)
(*4276*)  (*BRANCH NAME*)
} note note1088 = this
(* po redu: 4277*)
(*4277*)  
(*BRANCH END*)
from note1087 and note1088 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4278*)
(*4278*)  (*BRANCH NAME*)
} note note1089 = this
(* po redu: 4279*)
(*4279*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4280*)
(*4280*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4281*)
(*4281*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4282*)
(*4282*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4283*)
(*4283*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4284*)
(*4284*)  (*BRANCH NAME*)
} note note1090 = this
(* po redu: 4285*)
(*4285*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4286*)
(*4286*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4287*)
(*4287*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4288*)
(*4288*)  (*BRANCH NAME*)
} note note1091 = this
(* po redu: 4289*)
(*4289*)  
(*BRANCH END*)
from note1090 and note1091 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4290*)
(*4290*)  (*BRANCH NAME*)
} note note1092 = this
(* po redu: 4291*)
(*4291*)  
(*BRANCH END*)
from note1089 and note1092 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4292*)
(*4292*)  (*BRANCH NAME*)
} note note1093 = this
(* po redu: 4293*)
(*4293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4294*)
(*4294*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4295*)
(*4295*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4296*)
(*4296*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4297*)
(*4297*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4298*)
(*4298*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4299*)
(*4299*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4300*)
(*4300*)  (*BRANCH NAME*)
} note note1094 = this
(* po redu: 4301*)
(*4301*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4302*)
(*4302*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4303*)
(*4303*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4304*)
(*4304*)  (*BRANCH NAME*)
} note note1095 = this
(* po redu: 4305*)
(*4305*)  
(*BRANCH END*)
from note1094 and note1095 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4306*)
(*4306*)  (*BRANCH NAME*)
} note note1096 = this
(* po redu: 4307*)
(*4307*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4308*)
(*4308*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4309*)
(*4309*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4310*)
(*4310*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4311*)
(*4311*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4312*)
(*4312*)  (*BRANCH NAME*)
} note note1097 = this
(* po redu: 4313*)
(*4313*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4314*)
(*4314*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4315*)
(*4315*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4316*)
(*4316*)  (*BRANCH NAME*)
} note note1098 = this
(* po redu: 4317*)
(*4317*)  
(*BRANCH END*)
from note1097 and note1098 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4318*)
(*4318*)  (*BRANCH NAME*)
} note note1099 = this
(* po redu: 4319*)
(*4319*)  
(*BRANCH END*)
from note1096 and note1099 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4320*)
(*4320*)  (*BRANCH NAME*)
} note note1100 = this
(* po redu: 4321*)
(*4321*)  
(*BRANCH END*)
from note1093 and note1100 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4322*)
(*4322*)  (*BRANCH NAME*)
} note note1101 = this
(* po redu: 4323*)
(*4323*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 4324*)
(*4324*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4325*)
(*4325*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4326*)
(*4326*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4327*)
(*4327*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4328*)
(*4328*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4329*)
(*4329*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4330*)
(*4330*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4331*)
(*4331*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4332*)
(*4332*)  (*BRANCH NAME*)
} note note1102 = this
(* po redu: 4333*)
(*4333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4334*)
(*4334*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4335*)
(*4335*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4336*)
(*4336*)  (*BRANCH NAME*)
} note note1103 = this
(* po redu: 4337*)
(*4337*)  
(*BRANCH END*)
from note1102 and note1103 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4338*)
(*4338*)  (*BRANCH NAME*)
} note note1104 = this
(* po redu: 4339*)
(*4339*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4340*)
(*4340*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4341*)
(*4341*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4342*)
(*4342*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4343*)
(*4343*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4344*)
(*4344*)  (*BRANCH NAME*)
} note note1105 = this
(* po redu: 4345*)
(*4345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4346*)
(*4346*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4347*)
(*4347*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4348*)
(*4348*)  (*BRANCH NAME*)
} note note1106 = this
(* po redu: 4349*)
(*4349*)  
(*BRANCH END*)
from note1105 and note1106 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4350*)
(*4350*)  (*BRANCH NAME*)
} note note1107 = this
(* po redu: 4351*)
(*4351*)  
(*BRANCH END*)
from note1104 and note1107 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4352*)
(*4352*)  (*BRANCH NAME*)
} note note1108 = this
(* po redu: 4353*)
(*4353*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4354*)
(*4354*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4355*)
(*4355*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4356*)
(*4356*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4357*)
(*4357*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4358*)
(*4358*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4359*)
(*4359*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4360*)
(*4360*)  (*BRANCH NAME*)
} note note1109 = this
(* po redu: 4361*)
(*4361*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4362*)
(*4362*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4363*)
(*4363*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4364*)
(*4364*)  (*BRANCH NAME*)
} note note1110 = this
(* po redu: 4365*)
(*4365*)  
(*BRANCH END*)
from note1109 and note1110 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4366*)
(*4366*)  (*BRANCH NAME*)
} note note1111 = this
(* po redu: 4367*)
(*4367*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4368*)
(*4368*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4369*)
(*4369*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4370*)
(*4370*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4371*)
(*4371*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4372*)
(*4372*)  (*BRANCH NAME*)
} note note1112 = this
(* po redu: 4373*)
(*4373*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4374*)
(*4374*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4375*)
(*4375*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4376*)
(*4376*)  (*BRANCH NAME*)
} note note1113 = this
(* po redu: 4377*)
(*4377*)  
(*BRANCH END*)
from note1112 and note1113 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4378*)
(*4378*)  (*BRANCH NAME*)
} note note1114 = this
(* po redu: 4379*)
(*4379*)  
(*BRANCH END*)
from note1111 and note1114 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4380*)
(*4380*)  (*BRANCH NAME*)
} note note1115 = this
(* po redu: 4381*)
(*4381*)  
(*BRANCH END*)
from note1108 and note1115 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4382*)
(*4382*)  (*BRANCH NAME*)
} note note1116 = this
(* po redu: 4383*)
(*4383*)  
(*BRANCH END*)
from note1101 and note1116 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 4384*)
(*4384*)  (*BRANCH NAME*)
} note note1117 = this
(* po redu: 4385*)
(*4385*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 4386*)
(*4386*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 4387*)
(*4387*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 4388*)
(*4388*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4389*)
(*4389*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4390*)
(*4390*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4391*)
(*4391*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4392*)
(*4392*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4393*)
(*4393*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4394*)
(*4394*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4395*)
(*4395*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4396*)
(*4396*)  (*BRANCH NAME*)
} note note1118 = this
(* po redu: 4397*)
(*4397*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4398*)
(*4398*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4399*)
(*4399*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4400*)
(*4400*)  (*BRANCH NAME*)
} note note1119 = this
(* po redu: 4401*)
(*4401*)  
(*BRANCH END*)
from note1118 and note1119 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4402*)
(*4402*)  (*BRANCH NAME*)
} note note1120 = this
(* po redu: 4403*)
(*4403*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4404*)
(*4404*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4405*)
(*4405*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4406*)
(*4406*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4407*)
(*4407*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4408*)
(*4408*)  (*BRANCH NAME*)
} note note1121 = this
(* po redu: 4409*)
(*4409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4410*)
(*4410*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4411*)
(*4411*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4412*)
(*4412*)  (*BRANCH NAME*)
} note note1122 = this
(* po redu: 4413*)
(*4413*)  
(*BRANCH END*)
from note1121 and note1122 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4414*)
(*4414*)  (*BRANCH NAME*)
} note note1123 = this
(* po redu: 4415*)
(*4415*)  
(*BRANCH END*)
from note1120 and note1123 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4416*)
(*4416*)  (*BRANCH NAME*)
} note note1124 = this
(* po redu: 4417*)
(*4417*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4418*)
(*4418*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4419*)
(*4419*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4420*)
(*4420*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4421*)
(*4421*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4422*)
(*4422*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4423*)
(*4423*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4424*)
(*4424*)  (*BRANCH NAME*)
} note note1125 = this
(* po redu: 4425*)
(*4425*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4426*)
(*4426*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4427*)
(*4427*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4428*)
(*4428*)  (*BRANCH NAME*)
} note note1126 = this
(* po redu: 4429*)
(*4429*)  
(*BRANCH END*)
from note1125 and note1126 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4430*)
(*4430*)  (*BRANCH NAME*)
} note note1127 = this
(* po redu: 4431*)
(*4431*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4432*)
(*4432*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4433*)
(*4433*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4434*)
(*4434*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4435*)
(*4435*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4436*)
(*4436*)  (*BRANCH NAME*)
} note note1128 = this
(* po redu: 4437*)
(*4437*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4438*)
(*4438*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4439*)
(*4439*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4440*)
(*4440*)  (*BRANCH NAME*)
} note note1129 = this
(* po redu: 4441*)
(*4441*)  
(*BRANCH END*)
from note1128 and note1129 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4442*)
(*4442*)  (*BRANCH NAME*)
} note note1130 = this
(* po redu: 4443*)
(*4443*)  
(*BRANCH END*)
from note1127 and note1130 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4444*)
(*4444*)  (*BRANCH NAME*)
} note note1131 = this
(* po redu: 4445*)
(*4445*)  
(*BRANCH END*)
from note1124 and note1131 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4446*)
(*4446*)  (*BRANCH NAME*)
} note note1132 = this
(* po redu: 4447*)
(*4447*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 4448*)
(*4448*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4449*)
(*4449*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4450*)
(*4450*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4451*)
(*4451*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4452*)
(*4452*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4453*)
(*4453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4454*)
(*4454*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4455*)
(*4455*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4456*)
(*4456*)  (*BRANCH NAME*)
} note note1133 = this
(* po redu: 4457*)
(*4457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4458*)
(*4458*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4459*)
(*4459*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4460*)
(*4460*)  (*BRANCH NAME*)
} note note1134 = this
(* po redu: 4461*)
(*4461*)  
(*BRANCH END*)
from note1133 and note1134 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4462*)
(*4462*)  (*BRANCH NAME*)
} note note1135 = this
(* po redu: 4463*)
(*4463*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4464*)
(*4464*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4465*)
(*4465*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4466*)
(*4466*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4467*)
(*4467*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4468*)
(*4468*)  (*BRANCH NAME*)
} note note1136 = this
(* po redu: 4469*)
(*4469*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4470*)
(*4470*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4471*)
(*4471*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4472*)
(*4472*)  (*BRANCH NAME*)
} note note1137 = this
(* po redu: 4473*)
(*4473*)  
(*BRANCH END*)
from note1136 and note1137 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4474*)
(*4474*)  (*BRANCH NAME*)
} note note1138 = this
(* po redu: 4475*)
(*4475*)  
(*BRANCH END*)
from note1135 and note1138 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4476*)
(*4476*)  (*BRANCH NAME*)
} note note1139 = this
(* po redu: 4477*)
(*4477*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4478*)
(*4478*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4479*)
(*4479*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4480*)
(*4480*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4481*)
(*4481*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4482*)
(*4482*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4483*)
(*4483*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4484*)
(*4484*)  (*BRANCH NAME*)
} note note1140 = this
(* po redu: 4485*)
(*4485*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4486*)
(*4486*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4487*)
(*4487*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4488*)
(*4488*)  (*BRANCH NAME*)
} note note1141 = this
(* po redu: 4489*)
(*4489*)  
(*BRANCH END*)
from note1140 and note1141 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4490*)
(*4490*)  (*BRANCH NAME*)
} note note1142 = this
(* po redu: 4491*)
(*4491*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4492*)
(*4492*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4493*)
(*4493*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4494*)
(*4494*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4495*)
(*4495*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4496*)
(*4496*)  (*BRANCH NAME*)
} note note1143 = this
(* po redu: 4497*)
(*4497*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4498*)
(*4498*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 4499*)
(*4499*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 4500*)
(*4500*)  (*BRANCH NAME*)
} note note1144 = this
(* po redu: 4501*)
(*4501*)  
(*BRANCH END*)
from note1143 and note1144 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4502*)
(*4502*)  (*BRANCH NAME*)
} note note1145 = this
(* po redu: 4503*)
(*4503*)  
(*BRANCH END*)
from note1142 and note1145 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4504*)
(*4504*)  (*BRANCH NAME*)
} note note1146 = this
(* po redu: 4505*)
(*4505*)  
(*BRANCH END*)
from note1139 and note1146 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4506*)
(*4506*)  (*BRANCH NAME*)
} note note1147 = this
(* po redu: 4507*)
(*4507*)  
(*BRANCH END*)
from note1132 and note1147 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 4508*)
(*4508*)  (*BRANCH NAME*)
} note note1148 = this
(* po redu: 4509*)
(*4509*)  
(*BRANCH END*)
from note1117 and note1148 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 4510*)
(*4510*)  (*BRANCH NAME*)
} note note1149 = this
(* po redu: 4511*)
(*4511*)  
(*BRANCH END*)
from note1086 and note1149 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 4512*)
(*4512*)  (*BRANCH NAME*)
} note note1150 = this
(* po redu: 4513*)
(*4513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 4514*)
(*4514*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 4515*)
(*4515*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 4516*)
(*4516*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 4517*)
(*4517*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 4518*)
(*4518*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 4519*)
(*4519*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 4520*)
(*4520*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4521*)
(*4521*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4522*)
(*4522*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4523*)
(*4523*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4524*)
(*4524*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4525*)
(*4525*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4526*)
(*4526*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4527*)
(*4527*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4528*)
(*4528*)  (*BRANCH NAME*)
} note note1151 = this
(* po redu: 4529*)
(*4529*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4530*)
(*4530*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4531*)
(*4531*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4532*)
(*4532*)  (*BRANCH NAME*)
} note note1152 = this
(* po redu: 4533*)
(*4533*)  
(*BRANCH END*)
from note1151 and note1152 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4534*)
(*4534*)  (*BRANCH NAME*)
} note note1153 = this
(* po redu: 4535*)
(*4535*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4536*)
(*4536*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4537*)
(*4537*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4538*)
(*4538*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4539*)
(*4539*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4540*)
(*4540*)  (*BRANCH NAME*)
} note note1154 = this
(* po redu: 4541*)
(*4541*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4542*)
(*4542*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4543*)
(*4543*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4544*)
(*4544*)  (*BRANCH NAME*)
} note note1155 = this
(* po redu: 4545*)
(*4545*)  
(*BRANCH END*)
from note1154 and note1155 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4546*)
(*4546*)  (*BRANCH NAME*)
} note note1156 = this
(* po redu: 4547*)
(*4547*)  
(*BRANCH END*)
from note1153 and note1156 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4548*)
(*4548*)  (*BRANCH NAME*)
} note note1157 = this
(* po redu: 4549*)
(*4549*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4550*)
(*4550*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4551*)
(*4551*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4552*)
(*4552*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4553*)
(*4553*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4554*)
(*4554*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4555*)
(*4555*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4556*)
(*4556*)  (*BRANCH NAME*)
} note note1158 = this
(* po redu: 4557*)
(*4557*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4558*)
(*4558*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4559*)
(*4559*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4560*)
(*4560*)  (*BRANCH NAME*)
} note note1159 = this
(* po redu: 4561*)
(*4561*)  
(*BRANCH END*)
from note1158 and note1159 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4562*)
(*4562*)  (*BRANCH NAME*)
} note note1160 = this
(* po redu: 4563*)
(*4563*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4564*)
(*4564*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4565*)
(*4565*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4566*)
(*4566*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4567*)
(*4567*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4568*)
(*4568*)  (*BRANCH NAME*)
} note note1161 = this
(* po redu: 4569*)
(*4569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4570*)
(*4570*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4571*)
(*4571*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4572*)
(*4572*)  (*BRANCH NAME*)
} note note1162 = this
(* po redu: 4573*)
(*4573*)  
(*BRANCH END*)
from note1161 and note1162 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4574*)
(*4574*)  (*BRANCH NAME*)
} note note1163 = this
(* po redu: 4575*)
(*4575*)  
(*BRANCH END*)
from note1160 and note1163 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4576*)
(*4576*)  (*BRANCH NAME*)
} note note1164 = this
(* po redu: 4577*)
(*4577*)  
(*BRANCH END*)
from note1157 and note1164 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4578*)
(*4578*)  (*BRANCH NAME*)
} note note1165 = this
(* po redu: 4579*)
(*4579*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 4580*)
(*4580*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4581*)
(*4581*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4582*)
(*4582*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4583*)
(*4583*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4584*)
(*4584*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4585*)
(*4585*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4586*)
(*4586*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4587*)
(*4587*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4588*)
(*4588*)  (*BRANCH NAME*)
} note note1166 = this
(* po redu: 4589*)
(*4589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4590*)
(*4590*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4591*)
(*4591*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4592*)
(*4592*)  (*BRANCH NAME*)
} note note1167 = this
(* po redu: 4593*)
(*4593*)  
(*BRANCH END*)
from note1166 and note1167 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4594*)
(*4594*)  (*BRANCH NAME*)
} note note1168 = this
(* po redu: 4595*)
(*4595*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4596*)
(*4596*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4597*)
(*4597*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4598*)
(*4598*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4599*)
(*4599*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4600*)
(*4600*)  (*BRANCH NAME*)
} note note1169 = this
(* po redu: 4601*)
(*4601*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4602*)
(*4602*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4603*)
(*4603*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4604*)
(*4604*)  (*BRANCH NAME*)
} note note1170 = this
(* po redu: 4605*)
(*4605*)  
(*BRANCH END*)
from note1169 and note1170 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4606*)
(*4606*)  (*BRANCH NAME*)
} note note1171 = this
(* po redu: 4607*)
(*4607*)  
(*BRANCH END*)
from note1168 and note1171 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4608*)
(*4608*)  (*BRANCH NAME*)
} note note1172 = this
(* po redu: 4609*)
(*4609*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4610*)
(*4610*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4611*)
(*4611*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4612*)
(*4612*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4613*)
(*4613*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4614*)
(*4614*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4615*)
(*4615*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4616*)
(*4616*)  (*BRANCH NAME*)
} note note1173 = this
(* po redu: 4617*)
(*4617*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4618*)
(*4618*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4619*)
(*4619*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4620*)
(*4620*)  (*BRANCH NAME*)
} note note1174 = this
(* po redu: 4621*)
(*4621*)  
(*BRANCH END*)
from note1173 and note1174 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4622*)
(*4622*)  (*BRANCH NAME*)
} note note1175 = this
(* po redu: 4623*)
(*4623*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4624*)
(*4624*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4625*)
(*4625*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4626*)
(*4626*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4627*)
(*4627*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4628*)
(*4628*)  (*BRANCH NAME*)
} note note1176 = this
(* po redu: 4629*)
(*4629*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4630*)
(*4630*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4631*)
(*4631*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4632*)
(*4632*)  (*BRANCH NAME*)
} note note1177 = this
(* po redu: 4633*)
(*4633*)  
(*BRANCH END*)
from note1176 and note1177 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4634*)
(*4634*)  (*BRANCH NAME*)
} note note1178 = this
(* po redu: 4635*)
(*4635*)  
(*BRANCH END*)
from note1175 and note1178 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4636*)
(*4636*)  (*BRANCH NAME*)
} note note1179 = this
(* po redu: 4637*)
(*4637*)  
(*BRANCH END*)
from note1172 and note1179 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4638*)
(*4638*)  (*BRANCH NAME*)
} note note1180 = this
(* po redu: 4639*)
(*4639*)  
(*BRANCH END*)
from note1165 and note1180 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 4640*)
(*4640*)  (*BRANCH NAME*)
} note note1181 = this
(* po redu: 4641*)
(*4641*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 4642*)
(*4642*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 4643*)
(*4643*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 4644*)
(*4644*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4645*)
(*4645*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4646*)
(*4646*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4647*)
(*4647*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4648*)
(*4648*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4649*)
(*4649*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4650*)
(*4650*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4651*)
(*4651*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4652*)
(*4652*)  (*BRANCH NAME*)
} note note1182 = this
(* po redu: 4653*)
(*4653*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4654*)
(*4654*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4655*)
(*4655*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4656*)
(*4656*)  (*BRANCH NAME*)
} note note1183 = this
(* po redu: 4657*)
(*4657*)  
(*BRANCH END*)
from note1182 and note1183 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4658*)
(*4658*)  (*BRANCH NAME*)
} note note1184 = this
(* po redu: 4659*)
(*4659*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4660*)
(*4660*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4661*)
(*4661*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4662*)
(*4662*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4663*)
(*4663*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4664*)
(*4664*)  (*BRANCH NAME*)
} note note1185 = this
(* po redu: 4665*)
(*4665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4666*)
(*4666*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4667*)
(*4667*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4668*)
(*4668*)  (*BRANCH NAME*)
} note note1186 = this
(* po redu: 4669*)
(*4669*)  
(*BRANCH END*)
from note1185 and note1186 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4670*)
(*4670*)  (*BRANCH NAME*)
} note note1187 = this
(* po redu: 4671*)
(*4671*)  
(*BRANCH END*)
from note1184 and note1187 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4672*)
(*4672*)  (*BRANCH NAME*)
} note note1188 = this
(* po redu: 4673*)
(*4673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4674*)
(*4674*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4675*)
(*4675*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4676*)
(*4676*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4677*)
(*4677*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4678*)
(*4678*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4679*)
(*4679*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4680*)
(*4680*)  (*BRANCH NAME*)
} note note1189 = this
(* po redu: 4681*)
(*4681*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4682*)
(*4682*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4683*)
(*4683*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4684*)
(*4684*)  (*BRANCH NAME*)
} note note1190 = this
(* po redu: 4685*)
(*4685*)  
(*BRANCH END*)
from note1189 and note1190 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4686*)
(*4686*)  (*BRANCH NAME*)
} note note1191 = this
(* po redu: 4687*)
(*4687*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4688*)
(*4688*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4689*)
(*4689*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4690*)
(*4690*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4691*)
(*4691*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4692*)
(*4692*)  (*BRANCH NAME*)
} note note1192 = this
(* po redu: 4693*)
(*4693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4694*)
(*4694*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4695*)
(*4695*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4696*)
(*4696*)  (*BRANCH NAME*)
} note note1193 = this
(* po redu: 4697*)
(*4697*)  
(*BRANCH END*)
from note1192 and note1193 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4698*)
(*4698*)  (*BRANCH NAME*)
} note note1194 = this
(* po redu: 4699*)
(*4699*)  
(*BRANCH END*)
from note1191 and note1194 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4700*)
(*4700*)  (*BRANCH NAME*)
} note note1195 = this
(* po redu: 4701*)
(*4701*)  
(*BRANCH END*)
from note1188 and note1195 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4702*)
(*4702*)  (*BRANCH NAME*)
} note note1196 = this
(* po redu: 4703*)
(*4703*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 4704*)
(*4704*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4705*)
(*4705*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4706*)
(*4706*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4707*)
(*4707*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4708*)
(*4708*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4709*)
(*4709*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4710*)
(*4710*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4711*)
(*4711*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4712*)
(*4712*)  (*BRANCH NAME*)
} note note1197 = this
(* po redu: 4713*)
(*4713*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4714*)
(*4714*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4715*)
(*4715*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4716*)
(*4716*)  (*BRANCH NAME*)
} note note1198 = this
(* po redu: 4717*)
(*4717*)  
(*BRANCH END*)
from note1197 and note1198 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4718*)
(*4718*)  (*BRANCH NAME*)
} note note1199 = this
(* po redu: 4719*)
(*4719*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4720*)
(*4720*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4721*)
(*4721*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4722*)
(*4722*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4723*)
(*4723*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4724*)
(*4724*)  (*BRANCH NAME*)
} note note1200 = this
(* po redu: 4725*)
(*4725*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4726*)
(*4726*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4727*)
(*4727*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4728*)
(*4728*)  (*BRANCH NAME*)
} note note1201 = this
(* po redu: 4729*)
(*4729*)  
(*BRANCH END*)
from note1200 and note1201 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4730*)
(*4730*)  (*BRANCH NAME*)
} note note1202 = this
(* po redu: 4731*)
(*4731*)  
(*BRANCH END*)
from note1199 and note1202 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4732*)
(*4732*)  (*BRANCH NAME*)
} note note1203 = this
(* po redu: 4733*)
(*4733*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4734*)
(*4734*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4735*)
(*4735*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4736*)
(*4736*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4737*)
(*4737*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4738*)
(*4738*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4739*)
(*4739*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4740*)
(*4740*)  (*BRANCH NAME*)
} note note1204 = this
(* po redu: 4741*)
(*4741*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4742*)
(*4742*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4743*)
(*4743*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4744*)
(*4744*)  (*BRANCH NAME*)
} note note1205 = this
(* po redu: 4745*)
(*4745*)  
(*BRANCH END*)
from note1204 and note1205 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4746*)
(*4746*)  (*BRANCH NAME*)
} note note1206 = this
(* po redu: 4747*)
(*4747*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4748*)
(*4748*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4749*)
(*4749*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4750*)
(*4750*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4751*)
(*4751*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4752*)
(*4752*)  (*BRANCH NAME*)
} note note1207 = this
(* po redu: 4753*)
(*4753*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4754*)
(*4754*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4755*)
(*4755*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4756*)
(*4756*)  (*BRANCH NAME*)
} note note1208 = this
(* po redu: 4757*)
(*4757*)  
(*BRANCH END*)
from note1207 and note1208 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4758*)
(*4758*)  (*BRANCH NAME*)
} note note1209 = this
(* po redu: 4759*)
(*4759*)  
(*BRANCH END*)
from note1206 and note1209 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4760*)
(*4760*)  (*BRANCH NAME*)
} note note1210 = this
(* po redu: 4761*)
(*4761*)  
(*BRANCH END*)
from note1203 and note1210 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4762*)
(*4762*)  (*BRANCH NAME*)
} note note1211 = this
(* po redu: 4763*)
(*4763*)  
(*BRANCH END*)
from note1196 and note1211 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 4764*)
(*4764*)  (*BRANCH NAME*)
} note note1212 = this
(* po redu: 4765*)
(*4765*)  
(*BRANCH END*)
from note1181 and note1212 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 4766*)
(*4766*)  (*BRANCH NAME*)
} note note1213 = this
(* po redu: 4767*)
(*4767*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 4768*)
(*4768*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 4769*)
(*4769*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 4770*)
(*4770*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 4771*)
(*4771*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 4772*)
(*4772*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4773*)
(*4773*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4774*)
(*4774*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4775*)
(*4775*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4776*)
(*4776*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4777*)
(*4777*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4778*)
(*4778*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4779*)
(*4779*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4780*)
(*4780*)  (*BRANCH NAME*)
} note note1214 = this
(* po redu: 4781*)
(*4781*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4782*)
(*4782*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4783*)
(*4783*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4784*)
(*4784*)  (*BRANCH NAME*)
} note note1215 = this
(* po redu: 4785*)
(*4785*)  
(*BRANCH END*)
from note1214 and note1215 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4786*)
(*4786*)  (*BRANCH NAME*)
} note note1216 = this
(* po redu: 4787*)
(*4787*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4788*)
(*4788*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4789*)
(*4789*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4790*)
(*4790*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4791*)
(*4791*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4792*)
(*4792*)  (*BRANCH NAME*)
} note note1217 = this
(* po redu: 4793*)
(*4793*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4794*)
(*4794*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4795*)
(*4795*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4796*)
(*4796*)  (*BRANCH NAME*)
} note note1218 = this
(* po redu: 4797*)
(*4797*)  
(*BRANCH END*)
from note1217 and note1218 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4798*)
(*4798*)  (*BRANCH NAME*)
} note note1219 = this
(* po redu: 4799*)
(*4799*)  
(*BRANCH END*)
from note1216 and note1219 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4800*)
(*4800*)  (*BRANCH NAME*)
} note note1220 = this
(* po redu: 4801*)
(*4801*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4802*)
(*4802*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4803*)
(*4803*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4804*)
(*4804*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4805*)
(*4805*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4806*)
(*4806*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4807*)
(*4807*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4808*)
(*4808*)  (*BRANCH NAME*)
} note note1221 = this
(* po redu: 4809*)
(*4809*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4810*)
(*4810*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4811*)
(*4811*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4812*)
(*4812*)  (*BRANCH NAME*)
} note note1222 = this
(* po redu: 4813*)
(*4813*)  
(*BRANCH END*)
from note1221 and note1222 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4814*)
(*4814*)  (*BRANCH NAME*)
} note note1223 = this
(* po redu: 4815*)
(*4815*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4816*)
(*4816*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4817*)
(*4817*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4818*)
(*4818*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4819*)
(*4819*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4820*)
(*4820*)  (*BRANCH NAME*)
} note note1224 = this
(* po redu: 4821*)
(*4821*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4822*)
(*4822*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4823*)
(*4823*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4824*)
(*4824*)  (*BRANCH NAME*)
} note note1225 = this
(* po redu: 4825*)
(*4825*)  
(*BRANCH END*)
from note1224 and note1225 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4826*)
(*4826*)  (*BRANCH NAME*)
} note note1226 = this
(* po redu: 4827*)
(*4827*)  
(*BRANCH END*)
from note1223 and note1226 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4828*)
(*4828*)  (*BRANCH NAME*)
} note note1227 = this
(* po redu: 4829*)
(*4829*)  
(*BRANCH END*)
from note1220 and note1227 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4830*)
(*4830*)  (*BRANCH NAME*)
} note note1228 = this
(* po redu: 4831*)
(*4831*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 4832*)
(*4832*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4833*)
(*4833*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4834*)
(*4834*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4835*)
(*4835*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4836*)
(*4836*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4837*)
(*4837*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4838*)
(*4838*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4839*)
(*4839*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4840*)
(*4840*)  (*BRANCH NAME*)
} note note1229 = this
(* po redu: 4841*)
(*4841*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4842*)
(*4842*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4843*)
(*4843*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4844*)
(*4844*)  (*BRANCH NAME*)
} note note1230 = this
(* po redu: 4845*)
(*4845*)  
(*BRANCH END*)
from note1229 and note1230 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4846*)
(*4846*)  (*BRANCH NAME*)
} note note1231 = this
(* po redu: 4847*)
(*4847*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4848*)
(*4848*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4849*)
(*4849*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4850*)
(*4850*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4851*)
(*4851*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4852*)
(*4852*)  (*BRANCH NAME*)
} note note1232 = this
(* po redu: 4853*)
(*4853*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4854*)
(*4854*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4855*)
(*4855*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4856*)
(*4856*)  (*BRANCH NAME*)
} note note1233 = this
(* po redu: 4857*)
(*4857*)  
(*BRANCH END*)
from note1232 and note1233 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4858*)
(*4858*)  (*BRANCH NAME*)
} note note1234 = this
(* po redu: 4859*)
(*4859*)  
(*BRANCH END*)
from note1231 and note1234 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4860*)
(*4860*)  (*BRANCH NAME*)
} note note1235 = this
(* po redu: 4861*)
(*4861*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4862*)
(*4862*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4863*)
(*4863*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4864*)
(*4864*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4865*)
(*4865*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4866*)
(*4866*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4867*)
(*4867*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4868*)
(*4868*)  (*BRANCH NAME*)
} note note1236 = this
(* po redu: 4869*)
(*4869*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4870*)
(*4870*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4871*)
(*4871*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4872*)
(*4872*)  (*BRANCH NAME*)
} note note1237 = this
(* po redu: 4873*)
(*4873*)  
(*BRANCH END*)
from note1236 and note1237 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4874*)
(*4874*)  (*BRANCH NAME*)
} note note1238 = this
(* po redu: 4875*)
(*4875*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4876*)
(*4876*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4877*)
(*4877*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4878*)
(*4878*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4879*)
(*4879*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4880*)
(*4880*)  (*BRANCH NAME*)
} note note1239 = this
(* po redu: 4881*)
(*4881*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4882*)
(*4882*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4883*)
(*4883*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4884*)
(*4884*)  (*BRANCH NAME*)
} note note1240 = this
(* po redu: 4885*)
(*4885*)  
(*BRANCH END*)
from note1239 and note1240 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4886*)
(*4886*)  (*BRANCH NAME*)
} note note1241 = this
(* po redu: 4887*)
(*4887*)  
(*BRANCH END*)
from note1238 and note1241 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4888*)
(*4888*)  (*BRANCH NAME*)
} note note1242 = this
(* po redu: 4889*)
(*4889*)  
(*BRANCH END*)
from note1235 and note1242 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4890*)
(*4890*)  (*BRANCH NAME*)
} note note1243 = this
(* po redu: 4891*)
(*4891*)  
(*BRANCH END*)
from note1228 and note1243 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 4892*)
(*4892*)  (*BRANCH NAME*)
} note note1244 = this
(* po redu: 4893*)
(*4893*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 4894*)
(*4894*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 4895*)
(*4895*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 4896*)
(*4896*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4897*)
(*4897*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4898*)
(*4898*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4899*)
(*4899*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4900*)
(*4900*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4901*)
(*4901*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4902*)
(*4902*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4903*)
(*4903*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4904*)
(*4904*)  (*BRANCH NAME*)
} note note1245 = this
(* po redu: 4905*)
(*4905*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4906*)
(*4906*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4907*)
(*4907*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4908*)
(*4908*)  (*BRANCH NAME*)
} note note1246 = this
(* po redu: 4909*)
(*4909*)  
(*BRANCH END*)
from note1245 and note1246 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4910*)
(*4910*)  (*BRANCH NAME*)
} note note1247 = this
(* po redu: 4911*)
(*4911*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4912*)
(*4912*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4913*)
(*4913*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4914*)
(*4914*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4915*)
(*4915*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4916*)
(*4916*)  (*BRANCH NAME*)
} note note1248 = this
(* po redu: 4917*)
(*4917*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4918*)
(*4918*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4919*)
(*4919*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4920*)
(*4920*)  (*BRANCH NAME*)
} note note1249 = this
(* po redu: 4921*)
(*4921*)  
(*BRANCH END*)
from note1248 and note1249 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4922*)
(*4922*)  (*BRANCH NAME*)
} note note1250 = this
(* po redu: 4923*)
(*4923*)  
(*BRANCH END*)
from note1247 and note1250 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4924*)
(*4924*)  (*BRANCH NAME*)
} note note1251 = this
(* po redu: 4925*)
(*4925*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4926*)
(*4926*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4927*)
(*4927*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4928*)
(*4928*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4929*)
(*4929*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4930*)
(*4930*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4931*)
(*4931*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4932*)
(*4932*)  (*BRANCH NAME*)
} note note1252 = this
(* po redu: 4933*)
(*4933*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4934*)
(*4934*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4935*)
(*4935*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4936*)
(*4936*)  (*BRANCH NAME*)
} note note1253 = this
(* po redu: 4937*)
(*4937*)  
(*BRANCH END*)
from note1252 and note1253 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4938*)
(*4938*)  (*BRANCH NAME*)
} note note1254 = this
(* po redu: 4939*)
(*4939*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4940*)
(*4940*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4941*)
(*4941*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4942*)
(*4942*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4943*)
(*4943*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4944*)
(*4944*)  (*BRANCH NAME*)
} note note1255 = this
(* po redu: 4945*)
(*4945*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4946*)
(*4946*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4947*)
(*4947*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4948*)
(*4948*)  (*BRANCH NAME*)
} note note1256 = this
(* po redu: 4949*)
(*4949*)  
(*BRANCH END*)
from note1255 and note1256 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4950*)
(*4950*)  (*BRANCH NAME*)
} note note1257 = this
(* po redu: 4951*)
(*4951*)  
(*BRANCH END*)
from note1254 and note1257 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4952*)
(*4952*)  (*BRANCH NAME*)
} note note1258 = this
(* po redu: 4953*)
(*4953*)  
(*BRANCH END*)
from note1251 and note1258 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 4954*)
(*4954*)  (*BRANCH NAME*)
} note note1259 = this
(* po redu: 4955*)
(*4955*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 4956*)
(*4956*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 4957*)
(*4957*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 4958*)
(*4958*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4959*)
(*4959*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4960*)
(*4960*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4961*)
(*4961*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4962*)
(*4962*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4963*)
(*4963*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4964*)
(*4964*)  (*BRANCH NAME*)
} note note1260 = this
(* po redu: 4965*)
(*4965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4966*)
(*4966*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4967*)
(*4967*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4968*)
(*4968*)  (*BRANCH NAME*)
} note note1261 = this
(* po redu: 4969*)
(*4969*)  
(*BRANCH END*)
from note1260 and note1261 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4970*)
(*4970*)  (*BRANCH NAME*)
} note note1262 = this
(* po redu: 4971*)
(*4971*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 4972*)
(*4972*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4973*)
(*4973*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4974*)
(*4974*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4975*)
(*4975*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4976*)
(*4976*)  (*BRANCH NAME*)
} note note1263 = this
(* po redu: 4977*)
(*4977*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4978*)
(*4978*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4979*)
(*4979*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4980*)
(*4980*)  (*BRANCH NAME*)
} note note1264 = this
(* po redu: 4981*)
(*4981*)  
(*BRANCH END*)
from note1263 and note1264 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4982*)
(*4982*)  (*BRANCH NAME*)
} note note1265 = this
(* po redu: 4983*)
(*4983*)  
(*BRANCH END*)
from note1262 and note1265 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 4984*)
(*4984*)  (*BRANCH NAME*)
} note note1266 = this
(* po redu: 4985*)
(*4985*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 4986*)
(*4986*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 4987*)
(*4987*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 4988*)
(*4988*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 4989*)
(*4989*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 4990*)
(*4990*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 4991*)
(*4991*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 4992*)
(*4992*)  (*BRANCH NAME*)
} note note1267 = this
(* po redu: 4993*)
(*4993*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 4994*)
(*4994*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 4995*)
(*4995*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 4996*)
(*4996*)  (*BRANCH NAME*)
} note note1268 = this
(* po redu: 4997*)
(*4997*)  
(*BRANCH END*)
from note1267 and note1268 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 4998*)
(*4998*)  (*BRANCH NAME*)
} note note1269 = this
(* po redu: 4999*)
(*4999*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5000*)
(*5000*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5001*)
(*5001*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5002*)
(*5002*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 5003*)
(*5003*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5004*)
(*5004*)  (*BRANCH NAME*)
} note note1270 = this
(* po redu: 5005*)
(*5005*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5006*)
(*5006*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5007*)
(*5007*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5008*)
(*5008*)  (*BRANCH NAME*)
} note note1271 = this
(* po redu: 5009*)
(*5009*)  
(*BRANCH END*)
from note1270 and note1271 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5010*)
(*5010*)  (*BRANCH NAME*)
} note note1272 = this
(* po redu: 5011*)
(*5011*)  
(*BRANCH END*)
from note1269 and note1272 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5012*)
(*5012*)  (*BRANCH NAME*)
} note note1273 = this
(* po redu: 5013*)
(*5013*)  
(*BRANCH END*)
from note1266 and note1273 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5014*)
(*5014*)  (*BRANCH NAME*)
} note note1274 = this
(* po redu: 5015*)
(*5015*)  
(*BRANCH END*)
from note1259 and note1274 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 5016*)
(*5016*)  (*BRANCH NAME*)
} note note1275 = this
(* po redu: 5017*)
(*5017*)  
(*BRANCH END*)
from note1244 and note1275 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 5018*)
(*5018*)  (*BRANCH NAME*)
} note note1276 = this
(* po redu: 5019*)
(*5019*)  
(*BRANCH END*)
from note1213 and note1276 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 5020*)
(*5020*)  (*BRANCH NAME*)
} note note1277 = this
(* po redu: 5021*)
(*5021*)  
(*BRANCH END*)
from note1150 and note1277 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 5022*)
(*5022*)  (*BRANCH NAME*)
} note note1278 = this
(* po redu: 5023*)
(*5023*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 5024*)
(*5024*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 5025*)
(*5025*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 5026*)
(*5026*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 5027*)
(*5027*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 5028*)
(*5028*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 5029*)
(*5029*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 5030*)
(*5030*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 5031*)
(*5031*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 5032*)
(*5032*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5033*)
(*5033*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5034*)
(*5034*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5035*)
(*5035*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5036*)
(*5036*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5037*)
(*5037*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5038*)
(*5038*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5039*)
(*5039*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5040*)
(*5040*)  (*BRANCH NAME*)
} note note1279 = this
(* po redu: 5041*)
(*5041*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5042*)
(*5042*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5043*)
(*5043*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5044*)
(*5044*)  (*BRANCH NAME*)
} note note1280 = this
(* po redu: 5045*)
(*5045*)  
(*BRANCH END*)
from note1279 and note1280 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5046*)
(*5046*)  (*BRANCH NAME*)
} note note1281 = this
(* po redu: 5047*)
(*5047*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5048*)
(*5048*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5049*)
(*5049*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5050*)
(*5050*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5051*)
(*5051*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5052*)
(*5052*)  (*BRANCH NAME*)
} note note1282 = this
(* po redu: 5053*)
(*5053*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5054*)
(*5054*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5055*)
(*5055*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5056*)
(*5056*)  (*BRANCH NAME*)
} note note1283 = this
(* po redu: 5057*)
(*5057*)  
(*BRANCH END*)
from note1282 and note1283 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5058*)
(*5058*)  (*BRANCH NAME*)
} note note1284 = this
(* po redu: 5059*)
(*5059*)  
(*BRANCH END*)
from note1281 and note1284 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5060*)
(*5060*)  (*BRANCH NAME*)
} note note1285 = this
(* po redu: 5061*)
(*5061*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5062*)
(*5062*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5063*)
(*5063*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5064*)
(*5064*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5065*)
(*5065*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5066*)
(*5066*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5067*)
(*5067*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5068*)
(*5068*)  (*BRANCH NAME*)
} note note1286 = this
(* po redu: 5069*)
(*5069*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5070*)
(*5070*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5071*)
(*5071*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5072*)
(*5072*)  (*BRANCH NAME*)
} note note1287 = this
(* po redu: 5073*)
(*5073*)  
(*BRANCH END*)
from note1286 and note1287 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5074*)
(*5074*)  (*BRANCH NAME*)
} note note1288 = this
(* po redu: 5075*)
(*5075*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5076*)
(*5076*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5077*)
(*5077*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5078*)
(*5078*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5079*)
(*5079*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5080*)
(*5080*)  (*BRANCH NAME*)
} note note1289 = this
(* po redu: 5081*)
(*5081*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5082*)
(*5082*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5083*)
(*5083*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5084*)
(*5084*)  (*BRANCH NAME*)
} note note1290 = this
(* po redu: 5085*)
(*5085*)  
(*BRANCH END*)
from note1289 and note1290 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5086*)
(*5086*)  (*BRANCH NAME*)
} note note1291 = this
(* po redu: 5087*)
(*5087*)  
(*BRANCH END*)
from note1288 and note1291 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5088*)
(*5088*)  (*BRANCH NAME*)
} note note1292 = this
(* po redu: 5089*)
(*5089*)  
(*BRANCH END*)
from note1285 and note1292 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5090*)
(*5090*)  (*BRANCH NAME*)
} note note1293 = this
(* po redu: 5091*)
(*5091*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 5092*)
(*5092*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5093*)
(*5093*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5094*)
(*5094*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5095*)
(*5095*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5096*)
(*5096*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5097*)
(*5097*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5098*)
(*5098*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5099*)
(*5099*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5100*)
(*5100*)  (*BRANCH NAME*)
} note note1294 = this
(* po redu: 5101*)
(*5101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5102*)
(*5102*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5103*)
(*5103*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5104*)
(*5104*)  (*BRANCH NAME*)
} note note1295 = this
(* po redu: 5105*)
(*5105*)  
(*BRANCH END*)
from note1294 and note1295 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5106*)
(*5106*)  (*BRANCH NAME*)
} note note1296 = this
(* po redu: 5107*)
(*5107*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5108*)
(*5108*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5109*)
(*5109*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5110*)
(*5110*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5111*)
(*5111*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5112*)
(*5112*)  (*BRANCH NAME*)
} note note1297 = this
(* po redu: 5113*)
(*5113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5114*)
(*5114*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5115*)
(*5115*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5116*)
(*5116*)  (*BRANCH NAME*)
} note note1298 = this
(* po redu: 5117*)
(*5117*)  
(*BRANCH END*)
from note1297 and note1298 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5118*)
(*5118*)  (*BRANCH NAME*)
} note note1299 = this
(* po redu: 5119*)
(*5119*)  
(*BRANCH END*)
from note1296 and note1299 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5120*)
(*5120*)  (*BRANCH NAME*)
} note note1300 = this
(* po redu: 5121*)
(*5121*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5122*)
(*5122*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5123*)
(*5123*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5124*)
(*5124*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5125*)
(*5125*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5126*)
(*5126*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5127*)
(*5127*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5128*)
(*5128*)  (*BRANCH NAME*)
} note note1301 = this
(* po redu: 5129*)
(*5129*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5130*)
(*5130*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5131*)
(*5131*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5132*)
(*5132*)  (*BRANCH NAME*)
} note note1302 = this
(* po redu: 5133*)
(*5133*)  
(*BRANCH END*)
from note1301 and note1302 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5134*)
(*5134*)  (*BRANCH NAME*)
} note note1303 = this
(* po redu: 5135*)
(*5135*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5136*)
(*5136*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5137*)
(*5137*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5138*)
(*5138*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5139*)
(*5139*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5140*)
(*5140*)  (*BRANCH NAME*)
} note note1304 = this
(* po redu: 5141*)
(*5141*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5142*)
(*5142*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5143*)
(*5143*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5144*)
(*5144*)  (*BRANCH NAME*)
} note note1305 = this
(* po redu: 5145*)
(*5145*)  
(*BRANCH END*)
from note1304 and note1305 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5146*)
(*5146*)  (*BRANCH NAME*)
} note note1306 = this
(* po redu: 5147*)
(*5147*)  
(*BRANCH END*)
from note1303 and note1306 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5148*)
(*5148*)  (*BRANCH NAME*)
} note note1307 = this
(* po redu: 5149*)
(*5149*)  
(*BRANCH END*)
from note1300 and note1307 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5150*)
(*5150*)  (*BRANCH NAME*)
} note note1308 = this
(* po redu: 5151*)
(*5151*)  
(*BRANCH END*)
from note1293 and note1308 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 5152*)
(*5152*)  (*BRANCH NAME*)
} note note1309 = this
(* po redu: 5153*)
(*5153*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 5154*)
(*5154*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 5155*)
(*5155*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 5156*)
(*5156*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5157*)
(*5157*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5158*)
(*5158*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5159*)
(*5159*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5160*)
(*5160*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5161*)
(*5161*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5162*)
(*5162*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5163*)
(*5163*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5164*)
(*5164*)  (*BRANCH NAME*)
} note note1310 = this
(* po redu: 5165*)
(*5165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5166*)
(*5166*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5167*)
(*5167*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5168*)
(*5168*)  (*BRANCH NAME*)
} note note1311 = this
(* po redu: 5169*)
(*5169*)  
(*BRANCH END*)
from note1310 and note1311 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5170*)
(*5170*)  (*BRANCH NAME*)
} note note1312 = this
(* po redu: 5171*)
(*5171*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5172*)
(*5172*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5173*)
(*5173*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5174*)
(*5174*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5175*)
(*5175*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5176*)
(*5176*)  (*BRANCH NAME*)
} note note1313 = this
(* po redu: 5177*)
(*5177*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5178*)
(*5178*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5179*)
(*5179*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5180*)
(*5180*)  (*BRANCH NAME*)
} note note1314 = this
(* po redu: 5181*)
(*5181*)  
(*BRANCH END*)
from note1313 and note1314 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5182*)
(*5182*)  (*BRANCH NAME*)
} note note1315 = this
(* po redu: 5183*)
(*5183*)  
(*BRANCH END*)
from note1312 and note1315 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5184*)
(*5184*)  (*BRANCH NAME*)
} note note1316 = this
(* po redu: 5185*)
(*5185*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5186*)
(*5186*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5187*)
(*5187*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5188*)
(*5188*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5189*)
(*5189*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5190*)
(*5190*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5191*)
(*5191*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5192*)
(*5192*)  (*BRANCH NAME*)
} note note1317 = this
(* po redu: 5193*)
(*5193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5194*)
(*5194*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5195*)
(*5195*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5196*)
(*5196*)  (*BRANCH NAME*)
} note note1318 = this
(* po redu: 5197*)
(*5197*)  
(*BRANCH END*)
from note1317 and note1318 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5198*)
(*5198*)  (*BRANCH NAME*)
} note note1319 = this
(* po redu: 5199*)
(*5199*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5200*)
(*5200*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5201*)
(*5201*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5202*)
(*5202*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5203*)
(*5203*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5204*)
(*5204*)  (*BRANCH NAME*)
} note note1320 = this
(* po redu: 5205*)
(*5205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5206*)
(*5206*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5207*)
(*5207*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5208*)
(*5208*)  (*BRANCH NAME*)
} note note1321 = this
(* po redu: 5209*)
(*5209*)  
(*BRANCH END*)
from note1320 and note1321 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5210*)
(*5210*)  (*BRANCH NAME*)
} note note1322 = this
(* po redu: 5211*)
(*5211*)  
(*BRANCH END*)
from note1319 and note1322 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5212*)
(*5212*)  (*BRANCH NAME*)
} note note1323 = this
(* po redu: 5213*)
(*5213*)  
(*BRANCH END*)
from note1316 and note1323 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5214*)
(*5214*)  (*BRANCH NAME*)
} note note1324 = this
(* po redu: 5215*)
(*5215*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 5216*)
(*5216*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5217*)
(*5217*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5218*)
(*5218*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5219*)
(*5219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5220*)
(*5220*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5221*)
(*5221*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5222*)
(*5222*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5223*)
(*5223*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5224*)
(*5224*)  (*BRANCH NAME*)
} note note1325 = this
(* po redu: 5225*)
(*5225*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5226*)
(*5226*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5227*)
(*5227*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5228*)
(*5228*)  (*BRANCH NAME*)
} note note1326 = this
(* po redu: 5229*)
(*5229*)  
(*BRANCH END*)
from note1325 and note1326 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5230*)
(*5230*)  (*BRANCH NAME*)
} note note1327 = this
(* po redu: 5231*)
(*5231*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5232*)
(*5232*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5233*)
(*5233*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5234*)
(*5234*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5235*)
(*5235*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5236*)
(*5236*)  (*BRANCH NAME*)
} note note1328 = this
(* po redu: 5237*)
(*5237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5238*)
(*5238*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5239*)
(*5239*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5240*)
(*5240*)  (*BRANCH NAME*)
} note note1329 = this
(* po redu: 5241*)
(*5241*)  
(*BRANCH END*)
from note1328 and note1329 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5242*)
(*5242*)  (*BRANCH NAME*)
} note note1330 = this
(* po redu: 5243*)
(*5243*)  
(*BRANCH END*)
from note1327 and note1330 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5244*)
(*5244*)  (*BRANCH NAME*)
} note note1331 = this
(* po redu: 5245*)
(*5245*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5246*)
(*5246*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5247*)
(*5247*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5248*)
(*5248*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5249*)
(*5249*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5250*)
(*5250*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5251*)
(*5251*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5252*)
(*5252*)  (*BRANCH NAME*)
} note note1332 = this
(* po redu: 5253*)
(*5253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5254*)
(*5254*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5255*)
(*5255*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5256*)
(*5256*)  (*BRANCH NAME*)
} note note1333 = this
(* po redu: 5257*)
(*5257*)  
(*BRANCH END*)
from note1332 and note1333 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5258*)
(*5258*)  (*BRANCH NAME*)
} note note1334 = this
(* po redu: 5259*)
(*5259*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5260*)
(*5260*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5261*)
(*5261*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5262*)
(*5262*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5263*)
(*5263*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5264*)
(*5264*)  (*BRANCH NAME*)
} note note1335 = this
(* po redu: 5265*)
(*5265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5266*)
(*5266*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5267*)
(*5267*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5268*)
(*5268*)  (*BRANCH NAME*)
} note note1336 = this
(* po redu: 5269*)
(*5269*)  
(*BRANCH END*)
from note1335 and note1336 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5270*)
(*5270*)  (*BRANCH NAME*)
} note note1337 = this
(* po redu: 5271*)
(*5271*)  
(*BRANCH END*)
from note1334 and note1337 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5272*)
(*5272*)  (*BRANCH NAME*)
} note note1338 = this
(* po redu: 5273*)
(*5273*)  
(*BRANCH END*)
from note1331 and note1338 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5274*)
(*5274*)  (*BRANCH NAME*)
} note note1339 = this
(* po redu: 5275*)
(*5275*)  
(*BRANCH END*)
from note1324 and note1339 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 5276*)
(*5276*)  (*BRANCH NAME*)
} note note1340 = this
(* po redu: 5277*)
(*5277*)  
(*BRANCH END*)
from note1309 and note1340 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 5278*)
(*5278*)  (*BRANCH NAME*)
} note note1341 = this
(* po redu: 5279*)
(*5279*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 5280*)
(*5280*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 5281*)
(*5281*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 5282*)
(*5282*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 5283*)
(*5283*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 5284*)
(*5284*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5285*)
(*5285*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5286*)
(*5286*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5287*)
(*5287*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5288*)
(*5288*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5289*)
(*5289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5290*)
(*5290*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5291*)
(*5291*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5292*)
(*5292*)  (*BRANCH NAME*)
} note note1342 = this
(* po redu: 5293*)
(*5293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5294*)
(*5294*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5295*)
(*5295*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5296*)
(*5296*)  (*BRANCH NAME*)
} note note1343 = this
(* po redu: 5297*)
(*5297*)  
(*BRANCH END*)
from note1342 and note1343 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5298*)
(*5298*)  (*BRANCH NAME*)
} note note1344 = this
(* po redu: 5299*)
(*5299*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5300*)
(*5300*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5301*)
(*5301*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5302*)
(*5302*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5303*)
(*5303*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5304*)
(*5304*)  (*BRANCH NAME*)
} note note1345 = this
(* po redu: 5305*)
(*5305*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5306*)
(*5306*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5307*)
(*5307*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5308*)
(*5308*)  (*BRANCH NAME*)
} note note1346 = this
(* po redu: 5309*)
(*5309*)  
(*BRANCH END*)
from note1345 and note1346 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5310*)
(*5310*)  (*BRANCH NAME*)
} note note1347 = this
(* po redu: 5311*)
(*5311*)  
(*BRANCH END*)
from note1344 and note1347 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5312*)
(*5312*)  (*BRANCH NAME*)
} note note1348 = this
(* po redu: 5313*)
(*5313*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5314*)
(*5314*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5315*)
(*5315*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5316*)
(*5316*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5317*)
(*5317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5318*)
(*5318*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5319*)
(*5319*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5320*)
(*5320*)  (*BRANCH NAME*)
} note note1349 = this
(* po redu: 5321*)
(*5321*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5322*)
(*5322*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5323*)
(*5323*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5324*)
(*5324*)  (*BRANCH NAME*)
} note note1350 = this
(* po redu: 5325*)
(*5325*)  
(*BRANCH END*)
from note1349 and note1350 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5326*)
(*5326*)  (*BRANCH NAME*)
} note note1351 = this
(* po redu: 5327*)
(*5327*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5328*)
(*5328*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5329*)
(*5329*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5330*)
(*5330*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5331*)
(*5331*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5332*)
(*5332*)  (*BRANCH NAME*)
} note note1352 = this
(* po redu: 5333*)
(*5333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5334*)
(*5334*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5335*)
(*5335*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5336*)
(*5336*)  (*BRANCH NAME*)
} note note1353 = this
(* po redu: 5337*)
(*5337*)  
(*BRANCH END*)
from note1352 and note1353 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5338*)
(*5338*)  (*BRANCH NAME*)
} note note1354 = this
(* po redu: 5339*)
(*5339*)  
(*BRANCH END*)
from note1351 and note1354 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5340*)
(*5340*)  (*BRANCH NAME*)
} note note1355 = this
(* po redu: 5341*)
(*5341*)  
(*BRANCH END*)
from note1348 and note1355 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5342*)
(*5342*)  (*BRANCH NAME*)
} note note1356 = this
(* po redu: 5343*)
(*5343*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 5344*)
(*5344*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5345*)
(*5345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5346*)
(*5346*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5347*)
(*5347*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5348*)
(*5348*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5349*)
(*5349*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5350*)
(*5350*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5351*)
(*5351*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5352*)
(*5352*)  (*BRANCH NAME*)
} note note1357 = this
(* po redu: 5353*)
(*5353*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5354*)
(*5354*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5355*)
(*5355*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5356*)
(*5356*)  (*BRANCH NAME*)
} note note1358 = this
(* po redu: 5357*)
(*5357*)  
(*BRANCH END*)
from note1357 and note1358 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5358*)
(*5358*)  (*BRANCH NAME*)
} note note1359 = this
(* po redu: 5359*)
(*5359*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5360*)
(*5360*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5361*)
(*5361*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5362*)
(*5362*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5363*)
(*5363*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5364*)
(*5364*)  (*BRANCH NAME*)
} note note1360 = this
(* po redu: 5365*)
(*5365*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5366*)
(*5366*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5367*)
(*5367*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5368*)
(*5368*)  (*BRANCH NAME*)
} note note1361 = this
(* po redu: 5369*)
(*5369*)  
(*BRANCH END*)
from note1360 and note1361 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5370*)
(*5370*)  (*BRANCH NAME*)
} note note1362 = this
(* po redu: 5371*)
(*5371*)  
(*BRANCH END*)
from note1359 and note1362 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5372*)
(*5372*)  (*BRANCH NAME*)
} note note1363 = this
(* po redu: 5373*)
(*5373*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5374*)
(*5374*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5375*)
(*5375*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5376*)
(*5376*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5377*)
(*5377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5378*)
(*5378*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5379*)
(*5379*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5380*)
(*5380*)  (*BRANCH NAME*)
} note note1364 = this
(* po redu: 5381*)
(*5381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5382*)
(*5382*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5383*)
(*5383*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5384*)
(*5384*)  (*BRANCH NAME*)
} note note1365 = this
(* po redu: 5385*)
(*5385*)  
(*BRANCH END*)
from note1364 and note1365 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5386*)
(*5386*)  (*BRANCH NAME*)
} note note1366 = this
(* po redu: 5387*)
(*5387*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5388*)
(*5388*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5389*)
(*5389*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5390*)
(*5390*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5391*)
(*5391*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5392*)
(*5392*)  (*BRANCH NAME*)
} note note1367 = this
(* po redu: 5393*)
(*5393*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5394*)
(*5394*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5395*)
(*5395*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5396*)
(*5396*)  (*BRANCH NAME*)
} note note1368 = this
(* po redu: 5397*)
(*5397*)  
(*BRANCH END*)
from note1367 and note1368 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5398*)
(*5398*)  (*BRANCH NAME*)
} note note1369 = this
(* po redu: 5399*)
(*5399*)  
(*BRANCH END*)
from note1366 and note1369 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5400*)
(*5400*)  (*BRANCH NAME*)
} note note1370 = this
(* po redu: 5401*)
(*5401*)  
(*BRANCH END*)
from note1363 and note1370 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5402*)
(*5402*)  (*BRANCH NAME*)
} note note1371 = this
(* po redu: 5403*)
(*5403*)  
(*BRANCH END*)
from note1356 and note1371 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 5404*)
(*5404*)  (*BRANCH NAME*)
} note note1372 = this
(* po redu: 5405*)
(*5405*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 5406*)
(*5406*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 5407*)
(*5407*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 5408*)
(*5408*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5409*)
(*5409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5410*)
(*5410*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5411*)
(*5411*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5412*)
(*5412*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5413*)
(*5413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5414*)
(*5414*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5415*)
(*5415*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5416*)
(*5416*)  (*BRANCH NAME*)
} note note1373 = this
(* po redu: 5417*)
(*5417*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5418*)
(*5418*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5419*)
(*5419*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5420*)
(*5420*)  (*BRANCH NAME*)
} note note1374 = this
(* po redu: 5421*)
(*5421*)  
(*BRANCH END*)
from note1373 and note1374 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5422*)
(*5422*)  (*BRANCH NAME*)
} note note1375 = this
(* po redu: 5423*)
(*5423*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5424*)
(*5424*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5425*)
(*5425*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5426*)
(*5426*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5427*)
(*5427*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5428*)
(*5428*)  (*BRANCH NAME*)
} note note1376 = this
(* po redu: 5429*)
(*5429*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5430*)
(*5430*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5431*)
(*5431*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5432*)
(*5432*)  (*BRANCH NAME*)
} note note1377 = this
(* po redu: 5433*)
(*5433*)  
(*BRANCH END*)
from note1376 and note1377 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5434*)
(*5434*)  (*BRANCH NAME*)
} note note1378 = this
(* po redu: 5435*)
(*5435*)  
(*BRANCH END*)
from note1375 and note1378 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5436*)
(*5436*)  (*BRANCH NAME*)
} note note1379 = this
(* po redu: 5437*)
(*5437*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5438*)
(*5438*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5439*)
(*5439*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5440*)
(*5440*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5441*)
(*5441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5442*)
(*5442*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5443*)
(*5443*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5444*)
(*5444*)  (*BRANCH NAME*)
} note note1380 = this
(* po redu: 5445*)
(*5445*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5446*)
(*5446*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5447*)
(*5447*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5448*)
(*5448*)  (*BRANCH NAME*)
} note note1381 = this
(* po redu: 5449*)
(*5449*)  
(*BRANCH END*)
from note1380 and note1381 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5450*)
(*5450*)  (*BRANCH NAME*)
} note note1382 = this
(* po redu: 5451*)
(*5451*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5452*)
(*5452*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5453*)
(*5453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5454*)
(*5454*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5455*)
(*5455*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5456*)
(*5456*)  (*BRANCH NAME*)
} note note1383 = this
(* po redu: 5457*)
(*5457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5458*)
(*5458*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5459*)
(*5459*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5460*)
(*5460*)  (*BRANCH NAME*)
} note note1384 = this
(* po redu: 5461*)
(*5461*)  
(*BRANCH END*)
from note1383 and note1384 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5462*)
(*5462*)  (*BRANCH NAME*)
} note note1385 = this
(* po redu: 5463*)
(*5463*)  
(*BRANCH END*)
from note1382 and note1385 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5464*)
(*5464*)  (*BRANCH NAME*)
} note note1386 = this
(* po redu: 5465*)
(*5465*)  
(*BRANCH END*)
from note1379 and note1386 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5466*)
(*5466*)  (*BRANCH NAME*)
} note note1387 = this
(* po redu: 5467*)
(*5467*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 5468*)
(*5468*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5469*)
(*5469*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5470*)
(*5470*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5471*)
(*5471*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5472*)
(*5472*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5473*)
(*5473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5474*)
(*5474*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5475*)
(*5475*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5476*)
(*5476*)  (*BRANCH NAME*)
} note note1388 = this
(* po redu: 5477*)
(*5477*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5478*)
(*5478*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5479*)
(*5479*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5480*)
(*5480*)  (*BRANCH NAME*)
} note note1389 = this
(* po redu: 5481*)
(*5481*)  
(*BRANCH END*)
from note1388 and note1389 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5482*)
(*5482*)  (*BRANCH NAME*)
} note note1390 = this
(* po redu: 5483*)
(*5483*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5484*)
(*5484*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5485*)
(*5485*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5486*)
(*5486*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5487*)
(*5487*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5488*)
(*5488*)  (*BRANCH NAME*)
} note note1391 = this
(* po redu: 5489*)
(*5489*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5490*)
(*5490*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5491*)
(*5491*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5492*)
(*5492*)  (*BRANCH NAME*)
} note note1392 = this
(* po redu: 5493*)
(*5493*)  
(*BRANCH END*)
from note1391 and note1392 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5494*)
(*5494*)  (*BRANCH NAME*)
} note note1393 = this
(* po redu: 5495*)
(*5495*)  
(*BRANCH END*)
from note1390 and note1393 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5496*)
(*5496*)  (*BRANCH NAME*)
} note note1394 = this
(* po redu: 5497*)
(*5497*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5498*)
(*5498*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5499*)
(*5499*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5500*)
(*5500*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5501*)
(*5501*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5502*)
(*5502*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5503*)
(*5503*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5504*)
(*5504*)  (*BRANCH NAME*)
} note note1395 = this
(* po redu: 5505*)
(*5505*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5506*)
(*5506*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5507*)
(*5507*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5508*)
(*5508*)  (*BRANCH NAME*)
} note note1396 = this
(* po redu: 5509*)
(*5509*)  
(*BRANCH END*)
from note1395 and note1396 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5510*)
(*5510*)  (*BRANCH NAME*)
} note note1397 = this
(* po redu: 5511*)
(*5511*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5512*)
(*5512*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5513*)
(*5513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5514*)
(*5514*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5515*)
(*5515*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5516*)
(*5516*)  (*BRANCH NAME*)
} note note1398 = this
(* po redu: 5517*)
(*5517*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5518*)
(*5518*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 5519*)
(*5519*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 5520*)
(*5520*)  (*BRANCH NAME*)
} note note1399 = this
(* po redu: 5521*)
(*5521*)  
(*BRANCH END*)
from note1398 and note1399 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5522*)
(*5522*)  (*BRANCH NAME*)
} note note1400 = this
(* po redu: 5523*)
(*5523*)  
(*BRANCH END*)
from note1397 and note1400 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5524*)
(*5524*)  (*BRANCH NAME*)
} note note1401 = this
(* po redu: 5525*)
(*5525*)  
(*BRANCH END*)
from note1394 and note1401 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5526*)
(*5526*)  (*BRANCH NAME*)
} note note1402 = this
(* po redu: 5527*)
(*5527*)  
(*BRANCH END*)
from note1387 and note1402 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 5528*)
(*5528*)  (*BRANCH NAME*)
} note note1403 = this
(* po redu: 5529*)
(*5529*)  
(*BRANCH END*)
from note1372 and note1403 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 5530*)
(*5530*)  (*BRANCH NAME*)
} note note1404 = this
(* po redu: 5531*)
(*5531*)  
(*BRANCH END*)
from note1341 and note1404 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 5532*)
(*5532*)  (*BRANCH NAME*)
} note note1405 = this
(* po redu: 5533*)
(*5533*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 5534*)
(*5534*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 5535*)
(*5535*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 5536*)
(*5536*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 5537*)
(*5537*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 5538*)
(*5538*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 5539*)
(*5539*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 5540*)
(*5540*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5541*)
(*5541*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5542*)
(*5542*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5543*)
(*5543*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5544*)
(*5544*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5545*)
(*5545*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5546*)
(*5546*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5547*)
(*5547*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5548*)
(*5548*)  (*BRANCH NAME*)
} note note1406 = this
(* po redu: 5549*)
(*5549*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5550*)
(*5550*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5551*)
(*5551*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5552*)
(*5552*)  (*BRANCH NAME*)
} note note1407 = this
(* po redu: 5553*)
(*5553*)  
(*BRANCH END*)
from note1406 and note1407 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5554*)
(*5554*)  (*BRANCH NAME*)
} note note1408 = this
(* po redu: 5555*)
(*5555*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5556*)
(*5556*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5557*)
(*5557*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5558*)
(*5558*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5559*)
(*5559*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5560*)
(*5560*)  (*BRANCH NAME*)
} note note1409 = this
(* po redu: 5561*)
(*5561*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5562*)
(*5562*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5563*)
(*5563*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5564*)
(*5564*)  (*BRANCH NAME*)
} note note1410 = this
(* po redu: 5565*)
(*5565*)  
(*BRANCH END*)
from note1409 and note1410 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5566*)
(*5566*)  (*BRANCH NAME*)
} note note1411 = this
(* po redu: 5567*)
(*5567*)  
(*BRANCH END*)
from note1408 and note1411 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5568*)
(*5568*)  (*BRANCH NAME*)
} note note1412 = this
(* po redu: 5569*)
(*5569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5570*)
(*5570*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5571*)
(*5571*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5572*)
(*5572*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5573*)
(*5573*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5574*)
(*5574*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5575*)
(*5575*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5576*)
(*5576*)  (*BRANCH NAME*)
} note note1413 = this
(* po redu: 5577*)
(*5577*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5578*)
(*5578*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5579*)
(*5579*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5580*)
(*5580*)  (*BRANCH NAME*)
} note note1414 = this
(* po redu: 5581*)
(*5581*)  
(*BRANCH END*)
from note1413 and note1414 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5582*)
(*5582*)  (*BRANCH NAME*)
} note note1415 = this
(* po redu: 5583*)
(*5583*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5584*)
(*5584*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5585*)
(*5585*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5586*)
(*5586*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5587*)
(*5587*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5588*)
(*5588*)  (*BRANCH NAME*)
} note note1416 = this
(* po redu: 5589*)
(*5589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5590*)
(*5590*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5591*)
(*5591*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5592*)
(*5592*)  (*BRANCH NAME*)
} note note1417 = this
(* po redu: 5593*)
(*5593*)  
(*BRANCH END*)
from note1416 and note1417 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5594*)
(*5594*)  (*BRANCH NAME*)
} note note1418 = this
(* po redu: 5595*)
(*5595*)  
(*BRANCH END*)
from note1415 and note1418 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5596*)
(*5596*)  (*BRANCH NAME*)
} note note1419 = this
(* po redu: 5597*)
(*5597*)  
(*BRANCH END*)
from note1412 and note1419 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5598*)
(*5598*)  (*BRANCH NAME*)
} note note1420 = this
(* po redu: 5599*)
(*5599*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 5600*)
(*5600*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5601*)
(*5601*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5602*)
(*5602*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5603*)
(*5603*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5604*)
(*5604*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5605*)
(*5605*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5606*)
(*5606*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5607*)
(*5607*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5608*)
(*5608*)  (*BRANCH NAME*)
} note note1421 = this
(* po redu: 5609*)
(*5609*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5610*)
(*5610*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5611*)
(*5611*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5612*)
(*5612*)  (*BRANCH NAME*)
} note note1422 = this
(* po redu: 5613*)
(*5613*)  
(*BRANCH END*)
from note1421 and note1422 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5614*)
(*5614*)  (*BRANCH NAME*)
} note note1423 = this
(* po redu: 5615*)
(*5615*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5616*)
(*5616*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5617*)
(*5617*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5618*)
(*5618*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5619*)
(*5619*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5620*)
(*5620*)  (*BRANCH NAME*)
} note note1424 = this
(* po redu: 5621*)
(*5621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5622*)
(*5622*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5623*)
(*5623*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5624*)
(*5624*)  (*BRANCH NAME*)
} note note1425 = this
(* po redu: 5625*)
(*5625*)  
(*BRANCH END*)
from note1424 and note1425 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5626*)
(*5626*)  (*BRANCH NAME*)
} note note1426 = this
(* po redu: 5627*)
(*5627*)  
(*BRANCH END*)
from note1423 and note1426 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5628*)
(*5628*)  (*BRANCH NAME*)
} note note1427 = this
(* po redu: 5629*)
(*5629*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5630*)
(*5630*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5631*)
(*5631*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5632*)
(*5632*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5633*)
(*5633*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5634*)
(*5634*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5635*)
(*5635*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5636*)
(*5636*)  (*BRANCH NAME*)
} note note1428 = this
(* po redu: 5637*)
(*5637*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5638*)
(*5638*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5639*)
(*5639*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5640*)
(*5640*)  (*BRANCH NAME*)
} note note1429 = this
(* po redu: 5641*)
(*5641*)  
(*BRANCH END*)
from note1428 and note1429 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5642*)
(*5642*)  (*BRANCH NAME*)
} note note1430 = this
(* po redu: 5643*)
(*5643*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5644*)
(*5644*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5645*)
(*5645*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5646*)
(*5646*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5647*)
(*5647*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5648*)
(*5648*)  (*BRANCH NAME*)
} note note1431 = this
(* po redu: 5649*)
(*5649*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5650*)
(*5650*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5651*)
(*5651*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5652*)
(*5652*)  (*BRANCH NAME*)
} note note1432 = this
(* po redu: 5653*)
(*5653*)  
(*BRANCH END*)
from note1431 and note1432 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5654*)
(*5654*)  (*BRANCH NAME*)
} note note1433 = this
(* po redu: 5655*)
(*5655*)  
(*BRANCH END*)
from note1430 and note1433 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5656*)
(*5656*)  (*BRANCH NAME*)
} note note1434 = this
(* po redu: 5657*)
(*5657*)  
(*BRANCH END*)
from note1427 and note1434 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5658*)
(*5658*)  (*BRANCH NAME*)
} note note1435 = this
(* po redu: 5659*)
(*5659*)  
(*BRANCH END*)
from note1420 and note1435 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 5660*)
(*5660*)  (*BRANCH NAME*)
} note note1436 = this
(* po redu: 5661*)
(*5661*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 5662*)
(*5662*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 5663*)
(*5663*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 5664*)
(*5664*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5665*)
(*5665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5666*)
(*5666*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5667*)
(*5667*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5668*)
(*5668*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5669*)
(*5669*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5670*)
(*5670*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5671*)
(*5671*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5672*)
(*5672*)  (*BRANCH NAME*)
} note note1437 = this
(* po redu: 5673*)
(*5673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5674*)
(*5674*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5675*)
(*5675*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5676*)
(*5676*)  (*BRANCH NAME*)
} note note1438 = this
(* po redu: 5677*)
(*5677*)  
(*BRANCH END*)
from note1437 and note1438 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5678*)
(*5678*)  (*BRANCH NAME*)
} note note1439 = this
(* po redu: 5679*)
(*5679*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5680*)
(*5680*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5681*)
(*5681*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5682*)
(*5682*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5683*)
(*5683*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5684*)
(*5684*)  (*BRANCH NAME*)
} note note1440 = this
(* po redu: 5685*)
(*5685*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5686*)
(*5686*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5687*)
(*5687*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5688*)
(*5688*)  (*BRANCH NAME*)
} note note1441 = this
(* po redu: 5689*)
(*5689*)  
(*BRANCH END*)
from note1440 and note1441 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5690*)
(*5690*)  (*BRANCH NAME*)
} note note1442 = this
(* po redu: 5691*)
(*5691*)  
(*BRANCH END*)
from note1439 and note1442 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5692*)
(*5692*)  (*BRANCH NAME*)
} note note1443 = this
(* po redu: 5693*)
(*5693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5694*)
(*5694*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5695*)
(*5695*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5696*)
(*5696*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5697*)
(*5697*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5698*)
(*5698*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5699*)
(*5699*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5700*)
(*5700*)  (*BRANCH NAME*)
} note note1444 = this
(* po redu: 5701*)
(*5701*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5702*)
(*5702*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5703*)
(*5703*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5704*)
(*5704*)  (*BRANCH NAME*)
} note note1445 = this
(* po redu: 5705*)
(*5705*)  
(*BRANCH END*)
from note1444 and note1445 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5706*)
(*5706*)  (*BRANCH NAME*)
} note note1446 = this
(* po redu: 5707*)
(*5707*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5708*)
(*5708*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5709*)
(*5709*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5710*)
(*5710*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5711*)
(*5711*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5712*)
(*5712*)  (*BRANCH NAME*)
} note note1447 = this
(* po redu: 5713*)
(*5713*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5714*)
(*5714*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5715*)
(*5715*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5716*)
(*5716*)  (*BRANCH NAME*)
} note note1448 = this
(* po redu: 5717*)
(*5717*)  
(*BRANCH END*)
from note1447 and note1448 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5718*)
(*5718*)  (*BRANCH NAME*)
} note note1449 = this
(* po redu: 5719*)
(*5719*)  
(*BRANCH END*)
from note1446 and note1449 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5720*)
(*5720*)  (*BRANCH NAME*)
} note note1450 = this
(* po redu: 5721*)
(*5721*)  
(*BRANCH END*)
from note1443 and note1450 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5722*)
(*5722*)  (*BRANCH NAME*)
} note note1451 = this
(* po redu: 5723*)
(*5723*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 5724*)
(*5724*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5725*)
(*5725*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5726*)
(*5726*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5727*)
(*5727*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5728*)
(*5728*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5729*)
(*5729*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5730*)
(*5730*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5731*)
(*5731*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5732*)
(*5732*)  (*BRANCH NAME*)
} note note1452 = this
(* po redu: 5733*)
(*5733*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5734*)
(*5734*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5735*)
(*5735*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5736*)
(*5736*)  (*BRANCH NAME*)
} note note1453 = this
(* po redu: 5737*)
(*5737*)  
(*BRANCH END*)
from note1452 and note1453 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5738*)
(*5738*)  (*BRANCH NAME*)
} note note1454 = this
(* po redu: 5739*)
(*5739*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5740*)
(*5740*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5741*)
(*5741*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5742*)
(*5742*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5743*)
(*5743*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5744*)
(*5744*)  (*BRANCH NAME*)
} note note1455 = this
(* po redu: 5745*)
(*5745*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5746*)
(*5746*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5747*)
(*5747*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5748*)
(*5748*)  (*BRANCH NAME*)
} note note1456 = this
(* po redu: 5749*)
(*5749*)  
(*BRANCH END*)
from note1455 and note1456 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5750*)
(*5750*)  (*BRANCH NAME*)
} note note1457 = this
(* po redu: 5751*)
(*5751*)  
(*BRANCH END*)
from note1454 and note1457 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5752*)
(*5752*)  (*BRANCH NAME*)
} note note1458 = this
(* po redu: 5753*)
(*5753*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5754*)
(*5754*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5755*)
(*5755*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5756*)
(*5756*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5757*)
(*5757*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5758*)
(*5758*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5759*)
(*5759*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5760*)
(*5760*)  (*BRANCH NAME*)
} note note1459 = this
(* po redu: 5761*)
(*5761*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5762*)
(*5762*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5763*)
(*5763*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5764*)
(*5764*)  (*BRANCH NAME*)
} note note1460 = this
(* po redu: 5765*)
(*5765*)  
(*BRANCH END*)
from note1459 and note1460 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5766*)
(*5766*)  (*BRANCH NAME*)
} note note1461 = this
(* po redu: 5767*)
(*5767*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5768*)
(*5768*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5769*)
(*5769*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5770*)
(*5770*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 5771*)
(*5771*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 5772*)
(*5772*)  (*BRANCH NAME*)
} note note1462 = this
(* po redu: 5773*)
(*5773*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5774*)
(*5774*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5775*)
(*5775*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5776*)
(*5776*)  (*BRANCH NAME*)
} note note1463 = this
(* po redu: 5777*)
(*5777*)  
(*BRANCH END*)
from note1462 and note1463 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5778*)
(*5778*)  (*BRANCH NAME*)
} note note1464 = this
(* po redu: 5779*)
(*5779*)  
(*BRANCH END*)
from note1461 and note1464 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5780*)
(*5780*)  (*BRANCH NAME*)
} note note1465 = this
(* po redu: 5781*)
(*5781*)  
(*BRANCH END*)
from note1458 and note1465 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5782*)
(*5782*)  (*BRANCH NAME*)
} note note1466 = this
(* po redu: 5783*)
(*5783*)  
(*BRANCH END*)
from note1451 and note1466 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 5784*)
(*5784*)  (*BRANCH NAME*)
} note note1467 = this
(* po redu: 5785*)
(*5785*)  
(*BRANCH END*)
from note1436 and note1467 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 5786*)
(*5786*)  (*BRANCH NAME*)
} note note1468 = this
(* po redu: 5787*)
(*5787*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 5788*)
(*5788*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 5789*)
(*5789*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 5790*)
(*5790*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 5791*)
(*5791*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 5792*)
(*5792*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5793*)
(*5793*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5794*)
(*5794*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5795*)
(*5795*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5796*)
(*5796*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5797*)
(*5797*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5798*)
(*5798*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1469 = this
(* po redu: 5799*)
(*5799*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5800*)
(*5800*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5801*)
(*5801*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5802*)
(*5802*)  (*BRANCH NAME*)
} note note1470 = this
(* po redu: 5803*)
(*5803*)  
(*BRANCH END*)
from note1469 and note1470 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 5804*)
(*5804*)  (*BRANCH NAME*)
} note note1471 = this
(* po redu: 5805*)
(*5805*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5806*)
(*5806*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5807*)
(*5807*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5808*)
(*5808*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5809*)
(*5809*)  (*BRANCH NAME*)
} note note1472 = this
(* po redu: 5810*)
(*5810*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5811*)
(*5811*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5812*)
(*5812*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5813*)
(*5813*)  (*BRANCH NAME*)
} note note1473 = this
(* po redu: 5814*)
(*5814*)  
(*BRANCH END*)
from note1472 and note1473 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5815*)
(*5815*)  (*BRANCH NAME*)
} note note1474 = this
(* po redu: 5816*)
(*5816*)  
(*BRANCH END*)
from note1471 and note1474 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 5817*)
(*5817*)  (*BRANCH NAME*)
} note note1475 = this
(* po redu: 5818*)
(*5818*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5819*)
(*5819*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5820*)
(*5820*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5821*)
(*5821*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5822*)
(*5822*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5823*)
(*5823*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5824*)
(*5824*)  (*BRANCH NAME*)
} note note1476 = this
(* po redu: 5825*)
(*5825*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5826*)
(*5826*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5827*)
(*5827*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5828*)
(*5828*)  (*BRANCH NAME*)
} note note1477 = this
(* po redu: 5829*)
(*5829*)  
(*BRANCH END*)
from note1476 and note1477 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5830*)
(*5830*)  (*BRANCH NAME*)
} note note1478 = this
(* po redu: 5831*)
(*5831*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5832*)
(*5832*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5833*)
(*5833*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5834*)
(*5834*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1479 = this
(* po redu: 5835*)
(*5835*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5836*)
(*5836*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5837*)
(*5837*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5838*)
(*5838*)  (*BRANCH NAME*)
} note note1480 = this
(* po redu: 5839*)
(*5839*)  
(*BRANCH END*)
from note1479 and note1480 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 5840*)
(*5840*)  (*BRANCH NAME*)
} note note1481 = this
(* po redu: 5841*)
(*5841*)  
(*BRANCH END*)
from note1478 and note1481 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 5842*)
(*5842*)  (*BRANCH NAME*)
} note note1482 = this
(* po redu: 5843*)
(*5843*)  
(*BRANCH END*)
from note1475 and note1482 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 5844*)
(*5844*)  (*BRANCH NAME*)
} note note1483 = this
(* po redu: 5845*)
(*5845*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 5846*)
(*5846*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5847*)
(*5847*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5848*)
(*5848*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5849*)
(*5849*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5850*)
(*5850*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5851*)
(*5851*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5852*)
(*5852*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5853*)
(*5853*)  (*BRANCH NAME*)
} note note1484 = this
(* po redu: 5854*)
(*5854*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5855*)
(*5855*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5856*)
(*5856*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5857*)
(*5857*)  (*BRANCH NAME*)
} note note1485 = this
(* po redu: 5858*)
(*5858*)  
(*BRANCH END*)
from note1484 and note1485 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5859*)
(*5859*)  (*BRANCH NAME*)
} note note1486 = this
(* po redu: 5860*)
(*5860*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5861*)
(*5861*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5862*)
(*5862*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5863*)
(*5863*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5864*)
(*5864*)  (*BRANCH NAME*)
} note note1487 = this
(* po redu: 5865*)
(*5865*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5866*)
(*5866*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5867*)
(*5867*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5868*)
(*5868*)  (*BRANCH NAME*)
} note note1488 = this
(* po redu: 5869*)
(*5869*)  
(*BRANCH END*)
from note1487 and note1488 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5870*)
(*5870*)  (*BRANCH NAME*)
} note note1489 = this
(* po redu: 5871*)
(*5871*)  
(*BRANCH END*)
from note1486 and note1489 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5872*)
(*5872*)  (*BRANCH NAME*)
} note note1490 = this
(* po redu: 5873*)
(*5873*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5874*)
(*5874*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5875*)
(*5875*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5876*)
(*5876*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5877*)
(*5877*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5878*)
(*5878*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5879*)
(*5879*)  (*BRANCH NAME*)
} note note1491 = this
(* po redu: 5880*)
(*5880*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5881*)
(*5881*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5882*)
(*5882*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5883*)
(*5883*)  (*BRANCH NAME*)
} note note1492 = this
(* po redu: 5884*)
(*5884*)  
(*BRANCH END*)
from note1491 and note1492 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5885*)
(*5885*)  (*BRANCH NAME*)
} note note1493 = this
(* po redu: 5886*)
(*5886*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5887*)
(*5887*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5888*)
(*5888*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5889*)
(*5889*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5890*)
(*5890*)  (*BRANCH NAME*)
} note note1494 = this
(* po redu: 5891*)
(*5891*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5892*)
(*5892*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5893*)
(*5893*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5894*)
(*5894*)  (*BRANCH NAME*)
} note note1495 = this
(* po redu: 5895*)
(*5895*)  
(*BRANCH END*)
from note1494 and note1495 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5896*)
(*5896*)  (*BRANCH NAME*)
} note note1496 = this
(* po redu: 5897*)
(*5897*)  
(*BRANCH END*)
from note1493 and note1496 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5898*)
(*5898*)  (*BRANCH NAME*)
} note note1497 = this
(* po redu: 5899*)
(*5899*)  
(*BRANCH END*)
from note1490 and note1497 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5900*)
(*5900*)  (*BRANCH NAME*)
} note note1498 = this
(* po redu: 5901*)
(*5901*)  
(*BRANCH END*)
from note1483 and note1498 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 5902*)
(*5902*)  (*BRANCH NAME*)
} note note1499 = this
(* po redu: 5903*)
(*5903*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 5904*)
(*5904*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 5905*)
(*5905*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 5906*)
(*5906*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5907*)
(*5907*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5908*)
(*5908*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5909*)
(*5909*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5910*)
(*5910*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5911*)
(*5911*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5912*)
(*5912*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5913*)
(*5913*)  (*BRANCH NAME*)
} note note1500 = this
(* po redu: 5914*)
(*5914*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5915*)
(*5915*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5916*)
(*5916*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5917*)
(*5917*)  (*BRANCH NAME*)
} note note1501 = this
(* po redu: 5918*)
(*5918*)  
(*BRANCH END*)
from note1500 and note1501 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5919*)
(*5919*)  (*BRANCH NAME*)
} note note1502 = this
(* po redu: 5920*)
(*5920*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5921*)
(*5921*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5922*)
(*5922*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5923*)
(*5923*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5924*)
(*5924*)  (*BRANCH NAME*)
} note note1503 = this
(* po redu: 5925*)
(*5925*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5926*)
(*5926*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5927*)
(*5927*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5928*)
(*5928*)  (*BRANCH NAME*)
} note note1504 = this
(* po redu: 5929*)
(*5929*)  
(*BRANCH END*)
from note1503 and note1504 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5930*)
(*5930*)  (*BRANCH NAME*)
} note note1505 = this
(* po redu: 5931*)
(*5931*)  
(*BRANCH END*)
from note1502 and note1505 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5932*)
(*5932*)  (*BRANCH NAME*)
} note note1506 = this
(* po redu: 5933*)
(*5933*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5934*)
(*5934*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5935*)
(*5935*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5936*)
(*5936*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5937*)
(*5937*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5938*)
(*5938*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5939*)
(*5939*)  (*BRANCH NAME*)
} note note1507 = this
(* po redu: 5940*)
(*5940*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5941*)
(*5941*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5942*)
(*5942*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5943*)
(*5943*)  (*BRANCH NAME*)
} note note1508 = this
(* po redu: 5944*)
(*5944*)  
(*BRANCH END*)
from note1507 and note1508 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5945*)
(*5945*)  (*BRANCH NAME*)
} note note1509 = this
(* po redu: 5946*)
(*5946*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5947*)
(*5947*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5948*)
(*5948*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5949*)
(*5949*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5950*)
(*5950*)  (*BRANCH NAME*)
} note note1510 = this
(* po redu: 5951*)
(*5951*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5952*)
(*5952*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5953*)
(*5953*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5954*)
(*5954*)  (*BRANCH NAME*)
} note note1511 = this
(* po redu: 5955*)
(*5955*)  
(*BRANCH END*)
from note1510 and note1511 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5956*)
(*5956*)  (*BRANCH NAME*)
} note note1512 = this
(* po redu: 5957*)
(*5957*)  
(*BRANCH END*)
from note1509 and note1512 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 5958*)
(*5958*)  (*BRANCH NAME*)
} note note1513 = this
(* po redu: 5959*)
(*5959*)  
(*BRANCH END*)
from note1506 and note1513 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 5960*)
(*5960*)  (*BRANCH NAME*)
} note note1514 = this
(* po redu: 5961*)
(*5961*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 5962*)
(*5962*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 5963*)
(*5963*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 5964*)
(*5964*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5965*)
(*5965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5966*)
(*5966*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5967*)
(*5967*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5968*)
(*5968*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1515 = this
(* po redu: 5969*)
(*5969*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5970*)
(*5970*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5971*)
(*5971*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5972*)
(*5972*)  (*BRANCH NAME*)
} note note1516 = this
(* po redu: 5973*)
(*5973*)  
(*BRANCH END*)
from note1515 and note1516 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 5974*)
(*5974*)  (*BRANCH NAME*)
} note note1517 = this
(* po redu: 5975*)
(*5975*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 5976*)
(*5976*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5977*)
(*5977*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5978*)
(*5978*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5979*)
(*5979*)  (*BRANCH NAME*)
} note note1518 = this
(* po redu: 5980*)
(*5980*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5981*)
(*5981*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5982*)
(*5982*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5983*)
(*5983*)  (*BRANCH NAME*)
} note note1519 = this
(* po redu: 5984*)
(*5984*)  
(*BRANCH END*)
from note1518 and note1519 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 5985*)
(*5985*)  (*BRANCH NAME*)
} note note1520 = this
(* po redu: 5986*)
(*5986*)  
(*BRANCH END*)
from note1517 and note1520 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 5987*)
(*5987*)  (*BRANCH NAME*)
} note note1521 = this
(* po redu: 5988*)
(*5988*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 5989*)
(*5989*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 5990*)
(*5990*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 5991*)
(*5991*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 5992*)
(*5992*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 5993*)
(*5993*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 5994*)
(*5994*)  (*BRANCH NAME*)
} note note1522 = this
(* po redu: 5995*)
(*5995*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 5996*)
(*5996*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 5997*)
(*5997*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 5998*)
(*5998*)  (*BRANCH NAME*)
} note note1523 = this
(* po redu: 5999*)
(*5999*)  
(*BRANCH END*)
from note1522 and note1523 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6000*)
(*6000*)  (*BRANCH NAME*)
} note note1524 = this
(* po redu: 6001*)
(*6001*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6002*)
(*6002*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6003*)
(*6003*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6004*)
(*6004*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1525 = this
(* po redu: 6005*)
(*6005*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6006*)
(*6006*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6007*)
(*6007*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6008*)
(*6008*)  (*BRANCH NAME*)
} note note1526 = this
(* po redu: 6009*)
(*6009*)  
(*BRANCH END*)
from note1525 and note1526 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 6010*)
(*6010*)  (*BRANCH NAME*)
} note note1527 = this
(* po redu: 6011*)
(*6011*)  
(*BRANCH END*)
from note1524 and note1527 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 6012*)
(*6012*)  (*BRANCH NAME*)
} note note1528 = this
(* po redu: 6013*)
(*6013*)  
(*BRANCH END*)
from note1521 and note1528 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 6014*)
(*6014*)  (*BRANCH NAME*)
} note note1529 = this
(* po redu: 6015*)
(*6015*)  
(*BRANCH END*)
from note1514 and note1529 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 6016*)
(*6016*)  (*BRANCH NAME*)
} note note1530 = this
(* po redu: 6017*)
(*6017*)  
(*BRANCH END*)
from note1499 and note1530 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 6018*)
(*6018*)  (*BRANCH NAME*)
} note note1531 = this
(* po redu: 6019*)
(*6019*)  
(*BRANCH END*)
from note1468 and note1531 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 6020*)
(*6020*)  (*BRANCH NAME*)
} note note1532 = this
(* po redu: 6021*)
(*6021*)  
(*BRANCH END*)
from note1405 and note1532 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 6022*)
(*6022*)  (*BRANCH NAME*)
} note note1533 = this
(* po redu: 6023*)
(*6023*)  
(*BRANCH END*)
from note1278 and note1533 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 6024*)
(*6024*)  (*BRANCH NAME*)
} note note1534 = this
(* po redu: 6025*)
(*6025*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
(* po redu: 6026*)
(*6026*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 6027*)
(*6027*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 6028*)
(*6028*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 6029*)
(*6029*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 6030*)
(*6030*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 6031*)
(*6031*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 6032*)
(*6032*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 6033*)
(*6033*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 6034*)
(*6034*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 6035*)
(*6035*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 6036*)
(*6036*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6037*)
(*6037*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6038*)
(*6038*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6039*)
(*6039*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6040*)
(*6040*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6041*)
(*6041*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6042*)
(*6042*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1535 = this
(* po redu: 6043*)
(*6043*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6044*)
(*6044*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6045*)
(*6045*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6046*)
(*6046*)  (*BRANCH NAME*)
} note note1536 = this
(* po redu: 6047*)
(*6047*)  
(*BRANCH END*)
from note1535 and note1536 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 6048*)
(*6048*)  (*BRANCH NAME*)
} note note1537 = this
(* po redu: 6049*)
(*6049*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6050*)
(*6050*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6051*)
(*6051*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6052*)
(*6052*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6053*)
(*6053*)  (*BRANCH NAME*)
} note note1538 = this
(* po redu: 6054*)
(*6054*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6055*)
(*6055*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6056*)
(*6056*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6057*)
(*6057*)  (*BRANCH NAME*)
} note note1539 = this
(* po redu: 6058*)
(*6058*)  
(*BRANCH END*)
from note1538 and note1539 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6059*)
(*6059*)  (*BRANCH NAME*)
} note note1540 = this
(* po redu: 6060*)
(*6060*)  
(*BRANCH END*)
from note1537 and note1540 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 6061*)
(*6061*)  (*BRANCH NAME*)
} note note1541 = this
(* po redu: 6062*)
(*6062*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6063*)
(*6063*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6064*)
(*6064*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6065*)
(*6065*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6066*)
(*6066*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6067*)
(*6067*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6068*)
(*6068*)  (*BRANCH NAME*)
} note note1542 = this
(* po redu: 6069*)
(*6069*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6070*)
(*6070*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6071*)
(*6071*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6072*)
(*6072*)  (*BRANCH NAME*)
} note note1543 = this
(* po redu: 6073*)
(*6073*)  
(*BRANCH END*)
from note1542 and note1543 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6074*)
(*6074*)  (*BRANCH NAME*)
} note note1544 = this
(* po redu: 6075*)
(*6075*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6076*)
(*6076*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6077*)
(*6077*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6078*)
(*6078*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1545 = this
(* po redu: 6079*)
(*6079*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6080*)
(*6080*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6081*)
(*6081*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6082*)
(*6082*)  (*BRANCH NAME*)
} note note1546 = this
(* po redu: 6083*)
(*6083*)  
(*BRANCH END*)
from note1545 and note1546 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 6084*)
(*6084*)  (*BRANCH NAME*)
} note note1547 = this
(* po redu: 6085*)
(*6085*)  
(*BRANCH END*)
from note1544 and note1547 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 6086*)
(*6086*)  (*BRANCH NAME*)
} note note1548 = this
(* po redu: 6087*)
(*6087*)  
(*BRANCH END*)
from note1541 and note1548 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 6088*)
(*6088*)  (*BRANCH NAME*)
} note note1549 = this
(* po redu: 6089*)
(*6089*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 6090*)
(*6090*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6091*)
(*6091*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6092*)
(*6092*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6093*)
(*6093*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6094*)
(*6094*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6095*)
(*6095*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6096*)
(*6096*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6097*)
(*6097*)  (*BRANCH NAME*)
} note note1550 = this
(* po redu: 6098*)
(*6098*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6099*)
(*6099*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6100*)
(*6100*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6101*)
(*6101*)  (*BRANCH NAME*)
} note note1551 = this
(* po redu: 6102*)
(*6102*)  
(*BRANCH END*)
from note1550 and note1551 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6103*)
(*6103*)  (*BRANCH NAME*)
} note note1552 = this
(* po redu: 6104*)
(*6104*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6105*)
(*6105*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6106*)
(*6106*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6107*)
(*6107*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6108*)
(*6108*)  (*BRANCH NAME*)
} note note1553 = this
(* po redu: 6109*)
(*6109*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6110*)
(*6110*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6111*)
(*6111*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6112*)
(*6112*)  (*BRANCH NAME*)
} note note1554 = this
(* po redu: 6113*)
(*6113*)  
(*BRANCH END*)
from note1553 and note1554 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6114*)
(*6114*)  (*BRANCH NAME*)
} note note1555 = this
(* po redu: 6115*)
(*6115*)  
(*BRANCH END*)
from note1552 and note1555 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6116*)
(*6116*)  (*BRANCH NAME*)
} note note1556 = this
(* po redu: 6117*)
(*6117*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6118*)
(*6118*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6119*)
(*6119*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6120*)
(*6120*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6121*)
(*6121*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6122*)
(*6122*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6123*)
(*6123*)  (*BRANCH NAME*)
} note note1557 = this
(* po redu: 6124*)
(*6124*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6125*)
(*6125*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6126*)
(*6126*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6127*)
(*6127*)  (*BRANCH NAME*)
} note note1558 = this
(* po redu: 6128*)
(*6128*)  
(*BRANCH END*)
from note1557 and note1558 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6129*)
(*6129*)  (*BRANCH NAME*)
} note note1559 = this
(* po redu: 6130*)
(*6130*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6131*)
(*6131*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6132*)
(*6132*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6133*)
(*6133*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6134*)
(*6134*)  (*BRANCH NAME*)
} note note1560 = this
(* po redu: 6135*)
(*6135*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6136*)
(*6136*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6137*)
(*6137*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6138*)
(*6138*)  (*BRANCH NAME*)
} note note1561 = this
(* po redu: 6139*)
(*6139*)  
(*BRANCH END*)
from note1560 and note1561 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6140*)
(*6140*)  (*BRANCH NAME*)
} note note1562 = this
(* po redu: 6141*)
(*6141*)  
(*BRANCH END*)
from note1559 and note1562 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6142*)
(*6142*)  (*BRANCH NAME*)
} note note1563 = this
(* po redu: 6143*)
(*6143*)  
(*BRANCH END*)
from note1556 and note1563 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6144*)
(*6144*)  (*BRANCH NAME*)
} note note1564 = this
(* po redu: 6145*)
(*6145*)  
(*BRANCH END*)
from note1549 and note1564 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 6146*)
(*6146*)  (*BRANCH NAME*)
} note note1565 = this
(* po redu: 6147*)
(*6147*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 6148*)
(*6148*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 6149*)
(*6149*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 6150*)
(*6150*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6151*)
(*6151*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6152*)
(*6152*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6153*)
(*6153*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6154*)
(*6154*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6155*)
(*6155*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6156*)
(*6156*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6157*)
(*6157*)  (*BRANCH NAME*)
} note note1566 = this
(* po redu: 6158*)
(*6158*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6159*)
(*6159*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6160*)
(*6160*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6161*)
(*6161*)  (*BRANCH NAME*)
} note note1567 = this
(* po redu: 6162*)
(*6162*)  
(*BRANCH END*)
from note1566 and note1567 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6163*)
(*6163*)  (*BRANCH NAME*)
} note note1568 = this
(* po redu: 6164*)
(*6164*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6165*)
(*6165*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6166*)
(*6166*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6167*)
(*6167*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6168*)
(*6168*)  (*BRANCH NAME*)
} note note1569 = this
(* po redu: 6169*)
(*6169*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6170*)
(*6170*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6171*)
(*6171*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6172*)
(*6172*)  (*BRANCH NAME*)
} note note1570 = this
(* po redu: 6173*)
(*6173*)  
(*BRANCH END*)
from note1569 and note1570 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6174*)
(*6174*)  (*BRANCH NAME*)
} note note1571 = this
(* po redu: 6175*)
(*6175*)  
(*BRANCH END*)
from note1568 and note1571 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6176*)
(*6176*)  (*BRANCH NAME*)
} note note1572 = this
(* po redu: 6177*)
(*6177*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6178*)
(*6178*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6179*)
(*6179*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6180*)
(*6180*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6181*)
(*6181*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6182*)
(*6182*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6183*)
(*6183*)  (*BRANCH NAME*)
} note note1573 = this
(* po redu: 6184*)
(*6184*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6185*)
(*6185*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6186*)
(*6186*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6187*)
(*6187*)  (*BRANCH NAME*)
} note note1574 = this
(* po redu: 6188*)
(*6188*)  
(*BRANCH END*)
from note1573 and note1574 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6189*)
(*6189*)  (*BRANCH NAME*)
} note note1575 = this
(* po redu: 6190*)
(*6190*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6191*)
(*6191*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6192*)
(*6192*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6193*)
(*6193*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6194*)
(*6194*)  (*BRANCH NAME*)
} note note1576 = this
(* po redu: 6195*)
(*6195*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6196*)
(*6196*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6197*)
(*6197*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6198*)
(*6198*)  (*BRANCH NAME*)
} note note1577 = this
(* po redu: 6199*)
(*6199*)  
(*BRANCH END*)
from note1576 and note1577 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6200*)
(*6200*)  (*BRANCH NAME*)
} note note1578 = this
(* po redu: 6201*)
(*6201*)  
(*BRANCH END*)
from note1575 and note1578 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6202*)
(*6202*)  (*BRANCH NAME*)
} note note1579 = this
(* po redu: 6203*)
(*6203*)  
(*BRANCH END*)
from note1572 and note1579 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6204*)
(*6204*)  (*BRANCH NAME*)
} note note1580 = this
(* po redu: 6205*)
(*6205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 6206*)
(*6206*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6207*)
(*6207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6208*)
(*6208*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6209*)
(*6209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6210*)
(*6210*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6211*)
(*6211*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6212*)
(*6212*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1581 = this
(* po redu: 6213*)
(*6213*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6214*)
(*6214*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6215*)
(*6215*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6216*)
(*6216*)  (*BRANCH NAME*)
} note note1582 = this
(* po redu: 6217*)
(*6217*)  
(*BRANCH END*)
from note1581 and note1582 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 6218*)
(*6218*)  (*BRANCH NAME*)
} note note1583 = this
(* po redu: 6219*)
(*6219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6220*)
(*6220*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6221*)
(*6221*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6222*)
(*6222*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6223*)
(*6223*)  (*BRANCH NAME*)
} note note1584 = this
(* po redu: 6224*)
(*6224*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6225*)
(*6225*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6226*)
(*6226*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6227*)
(*6227*)  (*BRANCH NAME*)
} note note1585 = this
(* po redu: 6228*)
(*6228*)  
(*BRANCH END*)
from note1584 and note1585 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6229*)
(*6229*)  (*BRANCH NAME*)
} note note1586 = this
(* po redu: 6230*)
(*6230*)  
(*BRANCH END*)
from note1583 and note1586 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 6231*)
(*6231*)  (*BRANCH NAME*)
} note note1587 = this
(* po redu: 6232*)
(*6232*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6233*)
(*6233*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6234*)
(*6234*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6235*)
(*6235*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6236*)
(*6236*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6237*)
(*6237*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 6238*)
(*6238*)  (*BRANCH NAME*)
} note note1588 = this
(* po redu: 6239*)
(*6239*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6240*)
(*6240*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6241*)
(*6241*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6242*)
(*6242*)  (*BRANCH NAME*)
} note note1589 = this
(* po redu: 6243*)
(*6243*)  
(*BRANCH END*)
from note1588 and note1589 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6244*)
(*6244*)  (*BRANCH NAME*)
} note note1590 = this
(* po redu: 6245*)
(*6245*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6246*)
(*6246*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6247*)
(*6247*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6248*)
(*6248*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1591 = this
(* po redu: 6249*)
(*6249*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6250*)
(*6250*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6251*)
(*6251*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6252*)
(*6252*)  (*BRANCH NAME*)
} note note1592 = this
(* po redu: 6253*)
(*6253*)  
(*BRANCH END*)
from note1591 and note1592 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 6254*)
(*6254*)  (*BRANCH NAME*)
} note note1593 = this
(* po redu: 6255*)
(*6255*)  
(*BRANCH END*)
from note1590 and note1593 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 6256*)
(*6256*)  (*BRANCH NAME*)
} note note1594 = this
(* po redu: 6257*)
(*6257*)  
(*BRANCH END*)
from note1587 and note1594 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 6258*)
(*6258*)  (*BRANCH NAME*)
} note note1595 = this
(* po redu: 6259*)
(*6259*)  
(*BRANCH END*)
from note1580 and note1595 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 6260*)
(*6260*)  (*BRANCH NAME*)
} note note1596 = this
(* po redu: 6261*)
(*6261*)  
(*BRANCH END*)
from note1565 and note1596 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 6262*)
(*6262*)  (*BRANCH NAME*)
} note note1597 = this
(* po redu: 6263*)
(*6263*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 6264*)
(*6264*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 6265*)
(*6265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 6266*)
(*6266*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 6267*)
(*6267*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 6268*)
(*6268*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6269*)
(*6269*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6270*)
(*6270*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6271*)
(*6271*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6272*)
(*6272*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6273*)
(*6273*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6274*)
(*6274*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6275*)
(*6275*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6276*)
(*6276*)  (*BRANCH NAME*)
} note note1598 = this
(* po redu: 6277*)
(*6277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6278*)
(*6278*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6279*)
(*6279*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6280*)
(*6280*)  (*BRANCH NAME*)
} note note1599 = this
(* po redu: 6281*)
(*6281*)  
(*BRANCH END*)
from note1598 and note1599 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6282*)
(*6282*)  (*BRANCH NAME*)
} note note1600 = this
(* po redu: 6283*)
(*6283*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6284*)
(*6284*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6285*)
(*6285*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6286*)
(*6286*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6287*)
(*6287*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6288*)
(*6288*)  (*BRANCH NAME*)
} note note1601 = this
(* po redu: 6289*)
(*6289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6290*)
(*6290*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6291*)
(*6291*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6292*)
(*6292*)  (*BRANCH NAME*)
} note note1602 = this
(* po redu: 6293*)
(*6293*)  
(*BRANCH END*)
from note1601 and note1602 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6294*)
(*6294*)  (*BRANCH NAME*)
} note note1603 = this
(* po redu: 6295*)
(*6295*)  
(*BRANCH END*)
from note1600 and note1603 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6296*)
(*6296*)  (*BRANCH NAME*)
} note note1604 = this
(* po redu: 6297*)
(*6297*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6298*)
(*6298*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6299*)
(*6299*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6300*)
(*6300*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6301*)
(*6301*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6302*)
(*6302*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6303*)
(*6303*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6304*)
(*6304*)  (*BRANCH NAME*)
} note note1605 = this
(* po redu: 6305*)
(*6305*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6306*)
(*6306*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6307*)
(*6307*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6308*)
(*6308*)  (*BRANCH NAME*)
} note note1606 = this
(* po redu: 6309*)
(*6309*)  
(*BRANCH END*)
from note1605 and note1606 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6310*)
(*6310*)  (*BRANCH NAME*)
} note note1607 = this
(* po redu: 6311*)
(*6311*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6312*)
(*6312*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6313*)
(*6313*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6314*)
(*6314*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6315*)
(*6315*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6316*)
(*6316*)  (*BRANCH NAME*)
} note note1608 = this
(* po redu: 6317*)
(*6317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6318*)
(*6318*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6319*)
(*6319*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6320*)
(*6320*)  (*BRANCH NAME*)
} note note1609 = this
(* po redu: 6321*)
(*6321*)  
(*BRANCH END*)
from note1608 and note1609 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6322*)
(*6322*)  (*BRANCH NAME*)
} note note1610 = this
(* po redu: 6323*)
(*6323*)  
(*BRANCH END*)
from note1607 and note1610 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6324*)
(*6324*)  (*BRANCH NAME*)
} note note1611 = this
(* po redu: 6325*)
(*6325*)  
(*BRANCH END*)
from note1604 and note1611 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6326*)
(*6326*)  (*BRANCH NAME*)
} note note1612 = this
(* po redu: 6327*)
(*6327*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 6328*)
(*6328*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6329*)
(*6329*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6330*)
(*6330*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6331*)
(*6331*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6332*)
(*6332*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6333*)
(*6333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6334*)
(*6334*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6335*)
(*6335*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6336*)
(*6336*)  (*BRANCH NAME*)
} note note1613 = this
(* po redu: 6337*)
(*6337*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6338*)
(*6338*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6339*)
(*6339*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6340*)
(*6340*)  (*BRANCH NAME*)
} note note1614 = this
(* po redu: 6341*)
(*6341*)  
(*BRANCH END*)
from note1613 and note1614 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6342*)
(*6342*)  (*BRANCH NAME*)
} note note1615 = this
(* po redu: 6343*)
(*6343*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6344*)
(*6344*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6345*)
(*6345*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6346*)
(*6346*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6347*)
(*6347*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6348*)
(*6348*)  (*BRANCH NAME*)
} note note1616 = this
(* po redu: 6349*)
(*6349*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6350*)
(*6350*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6351*)
(*6351*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6352*)
(*6352*)  (*BRANCH NAME*)
} note note1617 = this
(* po redu: 6353*)
(*6353*)  
(*BRANCH END*)
from note1616 and note1617 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6354*)
(*6354*)  (*BRANCH NAME*)
} note note1618 = this
(* po redu: 6355*)
(*6355*)  
(*BRANCH END*)
from note1615 and note1618 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6356*)
(*6356*)  (*BRANCH NAME*)
} note note1619 = this
(* po redu: 6357*)
(*6357*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6358*)
(*6358*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6359*)
(*6359*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6360*)
(*6360*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6361*)
(*6361*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6362*)
(*6362*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6363*)
(*6363*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6364*)
(*6364*)  (*BRANCH NAME*)
} note note1620 = this
(* po redu: 6365*)
(*6365*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6366*)
(*6366*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6367*)
(*6367*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6368*)
(*6368*)  (*BRANCH NAME*)
} note note1621 = this
(* po redu: 6369*)
(*6369*)  
(*BRANCH END*)
from note1620 and note1621 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6370*)
(*6370*)  (*BRANCH NAME*)
} note note1622 = this
(* po redu: 6371*)
(*6371*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6372*)
(*6372*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6373*)
(*6373*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6374*)
(*6374*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6375*)
(*6375*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6376*)
(*6376*)  (*BRANCH NAME*)
} note note1623 = this
(* po redu: 6377*)
(*6377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6378*)
(*6378*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6379*)
(*6379*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6380*)
(*6380*)  (*BRANCH NAME*)
} note note1624 = this
(* po redu: 6381*)
(*6381*)  
(*BRANCH END*)
from note1623 and note1624 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6382*)
(*6382*)  (*BRANCH NAME*)
} note note1625 = this
(* po redu: 6383*)
(*6383*)  
(*BRANCH END*)
from note1622 and note1625 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6384*)
(*6384*)  (*BRANCH NAME*)
} note note1626 = this
(* po redu: 6385*)
(*6385*)  
(*BRANCH END*)
from note1619 and note1626 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6386*)
(*6386*)  (*BRANCH NAME*)
} note note1627 = this
(* po redu: 6387*)
(*6387*)  
(*BRANCH END*)
from note1612 and note1627 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 6388*)
(*6388*)  (*BRANCH NAME*)
} note note1628 = this
(* po redu: 6389*)
(*6389*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 6390*)
(*6390*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 6391*)
(*6391*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 6392*)
(*6392*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6393*)
(*6393*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6394*)
(*6394*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6395*)
(*6395*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6396*)
(*6396*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6397*)
(*6397*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6398*)
(*6398*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6399*)
(*6399*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6400*)
(*6400*)  (*BRANCH NAME*)
} note note1629 = this
(* po redu: 6401*)
(*6401*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6402*)
(*6402*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6403*)
(*6403*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6404*)
(*6404*)  (*BRANCH NAME*)
} note note1630 = this
(* po redu: 6405*)
(*6405*)  
(*BRANCH END*)
from note1629 and note1630 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6406*)
(*6406*)  (*BRANCH NAME*)
} note note1631 = this
(* po redu: 6407*)
(*6407*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6408*)
(*6408*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6409*)
(*6409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6410*)
(*6410*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6411*)
(*6411*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6412*)
(*6412*)  (*BRANCH NAME*)
} note note1632 = this
(* po redu: 6413*)
(*6413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6414*)
(*6414*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6415*)
(*6415*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6416*)
(*6416*)  (*BRANCH NAME*)
} note note1633 = this
(* po redu: 6417*)
(*6417*)  
(*BRANCH END*)
from note1632 and note1633 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6418*)
(*6418*)  (*BRANCH NAME*)
} note note1634 = this
(* po redu: 6419*)
(*6419*)  
(*BRANCH END*)
from note1631 and note1634 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6420*)
(*6420*)  (*BRANCH NAME*)
} note note1635 = this
(* po redu: 6421*)
(*6421*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6422*)
(*6422*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6423*)
(*6423*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6424*)
(*6424*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6425*)
(*6425*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6426*)
(*6426*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6427*)
(*6427*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6428*)
(*6428*)  (*BRANCH NAME*)
} note note1636 = this
(* po redu: 6429*)
(*6429*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6430*)
(*6430*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6431*)
(*6431*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6432*)
(*6432*)  (*BRANCH NAME*)
} note note1637 = this
(* po redu: 6433*)
(*6433*)  
(*BRANCH END*)
from note1636 and note1637 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6434*)
(*6434*)  (*BRANCH NAME*)
} note note1638 = this
(* po redu: 6435*)
(*6435*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6436*)
(*6436*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6437*)
(*6437*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6438*)
(*6438*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6439*)
(*6439*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6440*)
(*6440*)  (*BRANCH NAME*)
} note note1639 = this
(* po redu: 6441*)
(*6441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6442*)
(*6442*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6443*)
(*6443*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6444*)
(*6444*)  (*BRANCH NAME*)
} note note1640 = this
(* po redu: 6445*)
(*6445*)  
(*BRANCH END*)
from note1639 and note1640 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6446*)
(*6446*)  (*BRANCH NAME*)
} note note1641 = this
(* po redu: 6447*)
(*6447*)  
(*BRANCH END*)
from note1638 and note1641 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6448*)
(*6448*)  (*BRANCH NAME*)
} note note1642 = this
(* po redu: 6449*)
(*6449*)  
(*BRANCH END*)
from note1635 and note1642 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6450*)
(*6450*)  (*BRANCH NAME*)
} note note1643 = this
(* po redu: 6451*)
(*6451*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 6452*)
(*6452*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6453*)
(*6453*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6454*)
(*6454*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6455*)
(*6455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6456*)
(*6456*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6457*)
(*6457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6458*)
(*6458*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6459*)
(*6459*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6460*)
(*6460*)  (*BRANCH NAME*)
} note note1644 = this
(* po redu: 6461*)
(*6461*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6462*)
(*6462*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6463*)
(*6463*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6464*)
(*6464*)  (*BRANCH NAME*)
} note note1645 = this
(* po redu: 6465*)
(*6465*)  
(*BRANCH END*)
from note1644 and note1645 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6466*)
(*6466*)  (*BRANCH NAME*)
} note note1646 = this
(* po redu: 6467*)
(*6467*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6468*)
(*6468*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6469*)
(*6469*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6470*)
(*6470*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6471*)
(*6471*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6472*)
(*6472*)  (*BRANCH NAME*)
} note note1647 = this
(* po redu: 6473*)
(*6473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6474*)
(*6474*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6475*)
(*6475*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6476*)
(*6476*)  (*BRANCH NAME*)
} note note1648 = this
(* po redu: 6477*)
(*6477*)  
(*BRANCH END*)
from note1647 and note1648 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6478*)
(*6478*)  (*BRANCH NAME*)
} note note1649 = this
(* po redu: 6479*)
(*6479*)  
(*BRANCH END*)
from note1646 and note1649 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6480*)
(*6480*)  (*BRANCH NAME*)
} note note1650 = this
(* po redu: 6481*)
(*6481*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6482*)
(*6482*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6483*)
(*6483*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6484*)
(*6484*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6485*)
(*6485*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6486*)
(*6486*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6487*)
(*6487*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6488*)
(*6488*)  (*BRANCH NAME*)
} note note1651 = this
(* po redu: 6489*)
(*6489*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6490*)
(*6490*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6491*)
(*6491*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6492*)
(*6492*)  (*BRANCH NAME*)
} note note1652 = this
(* po redu: 6493*)
(*6493*)  
(*BRANCH END*)
from note1651 and note1652 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6494*)
(*6494*)  (*BRANCH NAME*)
} note note1653 = this
(* po redu: 6495*)
(*6495*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6496*)
(*6496*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6497*)
(*6497*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6498*)
(*6498*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6499*)
(*6499*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6500*)
(*6500*)  (*BRANCH NAME*)
} note note1654 = this
(* po redu: 6501*)
(*6501*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6502*)
(*6502*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6503*)
(*6503*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6504*)
(*6504*)  (*BRANCH NAME*)
} note note1655 = this
(* po redu: 6505*)
(*6505*)  
(*BRANCH END*)
from note1654 and note1655 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6506*)
(*6506*)  (*BRANCH NAME*)
} note note1656 = this
(* po redu: 6507*)
(*6507*)  
(*BRANCH END*)
from note1653 and note1656 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6508*)
(*6508*)  (*BRANCH NAME*)
} note note1657 = this
(* po redu: 6509*)
(*6509*)  
(*BRANCH END*)
from note1650 and note1657 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6510*)
(*6510*)  (*BRANCH NAME*)
} note note1658 = this
(* po redu: 6511*)
(*6511*)  
(*BRANCH END*)
from note1643 and note1658 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 6512*)
(*6512*)  (*BRANCH NAME*)
} note note1659 = this
(* po redu: 6513*)
(*6513*)  
(*BRANCH END*)
from note1628 and note1659 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 6514*)
(*6514*)  (*BRANCH NAME*)
} note note1660 = this
(* po redu: 6515*)
(*6515*)  
(*BRANCH END*)
from note1597 and note1660 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 6516*)
(*6516*)  (*BRANCH NAME*)
} note note1661 = this
(* po redu: 6517*)
(*6517*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 6518*)
(*6518*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 6519*)
(*6519*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 6520*)
(*6520*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 6521*)
(*6521*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 6522*)
(*6522*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 6523*)
(*6523*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 6524*)
(*6524*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6525*)
(*6525*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6526*)
(*6526*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6527*)
(*6527*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6528*)
(*6528*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6529*)
(*6529*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6530*)
(*6530*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6531*)
(*6531*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6532*)
(*6532*)  (*BRANCH NAME*)
} note note1662 = this
(* po redu: 6533*)
(*6533*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6534*)
(*6534*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6535*)
(*6535*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6536*)
(*6536*)  (*BRANCH NAME*)
} note note1663 = this
(* po redu: 6537*)
(*6537*)  
(*BRANCH END*)
from note1662 and note1663 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6538*)
(*6538*)  (*BRANCH NAME*)
} note note1664 = this
(* po redu: 6539*)
(*6539*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6540*)
(*6540*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6541*)
(*6541*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6542*)
(*6542*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6543*)
(*6543*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6544*)
(*6544*)  (*BRANCH NAME*)
} note note1665 = this
(* po redu: 6545*)
(*6545*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6546*)
(*6546*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6547*)
(*6547*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6548*)
(*6548*)  (*BRANCH NAME*)
} note note1666 = this
(* po redu: 6549*)
(*6549*)  
(*BRANCH END*)
from note1665 and note1666 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6550*)
(*6550*)  (*BRANCH NAME*)
} note note1667 = this
(* po redu: 6551*)
(*6551*)  
(*BRANCH END*)
from note1664 and note1667 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6552*)
(*6552*)  (*BRANCH NAME*)
} note note1668 = this
(* po redu: 6553*)
(*6553*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6554*)
(*6554*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6555*)
(*6555*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6556*)
(*6556*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6557*)
(*6557*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6558*)
(*6558*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6559*)
(*6559*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6560*)
(*6560*)  (*BRANCH NAME*)
} note note1669 = this
(* po redu: 6561*)
(*6561*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6562*)
(*6562*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6563*)
(*6563*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6564*)
(*6564*)  (*BRANCH NAME*)
} note note1670 = this
(* po redu: 6565*)
(*6565*)  
(*BRANCH END*)
from note1669 and note1670 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6566*)
(*6566*)  (*BRANCH NAME*)
} note note1671 = this
(* po redu: 6567*)
(*6567*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6568*)
(*6568*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6569*)
(*6569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6570*)
(*6570*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6571*)
(*6571*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6572*)
(*6572*)  (*BRANCH NAME*)
} note note1672 = this
(* po redu: 6573*)
(*6573*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6574*)
(*6574*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6575*)
(*6575*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6576*)
(*6576*)  (*BRANCH NAME*)
} note note1673 = this
(* po redu: 6577*)
(*6577*)  
(*BRANCH END*)
from note1672 and note1673 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6578*)
(*6578*)  (*BRANCH NAME*)
} note note1674 = this
(* po redu: 6579*)
(*6579*)  
(*BRANCH END*)
from note1671 and note1674 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6580*)
(*6580*)  (*BRANCH NAME*)
} note note1675 = this
(* po redu: 6581*)
(*6581*)  
(*BRANCH END*)
from note1668 and note1675 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6582*)
(*6582*)  (*BRANCH NAME*)
} note note1676 = this
(* po redu: 6583*)
(*6583*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 6584*)
(*6584*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6585*)
(*6585*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6586*)
(*6586*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6587*)
(*6587*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6588*)
(*6588*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6589*)
(*6589*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6590*)
(*6590*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6591*)
(*6591*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6592*)
(*6592*)  (*BRANCH NAME*)
} note note1677 = this
(* po redu: 6593*)
(*6593*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6594*)
(*6594*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6595*)
(*6595*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6596*)
(*6596*)  (*BRANCH NAME*)
} note note1678 = this
(* po redu: 6597*)
(*6597*)  
(*BRANCH END*)
from note1677 and note1678 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6598*)
(*6598*)  (*BRANCH NAME*)
} note note1679 = this
(* po redu: 6599*)
(*6599*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6600*)
(*6600*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6601*)
(*6601*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6602*)
(*6602*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6603*)
(*6603*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6604*)
(*6604*)  (*BRANCH NAME*)
} note note1680 = this
(* po redu: 6605*)
(*6605*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6606*)
(*6606*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6607*)
(*6607*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6608*)
(*6608*)  (*BRANCH NAME*)
} note note1681 = this
(* po redu: 6609*)
(*6609*)  
(*BRANCH END*)
from note1680 and note1681 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6610*)
(*6610*)  (*BRANCH NAME*)
} note note1682 = this
(* po redu: 6611*)
(*6611*)  
(*BRANCH END*)
from note1679 and note1682 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6612*)
(*6612*)  (*BRANCH NAME*)
} note note1683 = this
(* po redu: 6613*)
(*6613*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6614*)
(*6614*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6615*)
(*6615*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6616*)
(*6616*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6617*)
(*6617*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6618*)
(*6618*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6619*)
(*6619*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6620*)
(*6620*)  (*BRANCH NAME*)
} note note1684 = this
(* po redu: 6621*)
(*6621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6622*)
(*6622*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6623*)
(*6623*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6624*)
(*6624*)  (*BRANCH NAME*)
} note note1685 = this
(* po redu: 6625*)
(*6625*)  
(*BRANCH END*)
from note1684 and note1685 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6626*)
(*6626*)  (*BRANCH NAME*)
} note note1686 = this
(* po redu: 6627*)
(*6627*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6628*)
(*6628*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6629*)
(*6629*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6630*)
(*6630*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6631*)
(*6631*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6632*)
(*6632*)  (*BRANCH NAME*)
} note note1687 = this
(* po redu: 6633*)
(*6633*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6634*)
(*6634*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6635*)
(*6635*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6636*)
(*6636*)  (*BRANCH NAME*)
} note note1688 = this
(* po redu: 6637*)
(*6637*)  
(*BRANCH END*)
from note1687 and note1688 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6638*)
(*6638*)  (*BRANCH NAME*)
} note note1689 = this
(* po redu: 6639*)
(*6639*)  
(*BRANCH END*)
from note1686 and note1689 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6640*)
(*6640*)  (*BRANCH NAME*)
} note note1690 = this
(* po redu: 6641*)
(*6641*)  
(*BRANCH END*)
from note1683 and note1690 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6642*)
(*6642*)  (*BRANCH NAME*)
} note note1691 = this
(* po redu: 6643*)
(*6643*)  
(*BRANCH END*)
from note1676 and note1691 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 6644*)
(*6644*)  (*BRANCH NAME*)
} note note1692 = this
(* po redu: 6645*)
(*6645*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 6646*)
(*6646*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 6647*)
(*6647*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 6648*)
(*6648*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6649*)
(*6649*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6650*)
(*6650*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6651*)
(*6651*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6652*)
(*6652*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6653*)
(*6653*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6654*)
(*6654*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6655*)
(*6655*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6656*)
(*6656*)  (*BRANCH NAME*)
} note note1693 = this
(* po redu: 6657*)
(*6657*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6658*)
(*6658*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6659*)
(*6659*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6660*)
(*6660*)  (*BRANCH NAME*)
} note note1694 = this
(* po redu: 6661*)
(*6661*)  
(*BRANCH END*)
from note1693 and note1694 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6662*)
(*6662*)  (*BRANCH NAME*)
} note note1695 = this
(* po redu: 6663*)
(*6663*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6664*)
(*6664*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6665*)
(*6665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6666*)
(*6666*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6667*)
(*6667*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6668*)
(*6668*)  (*BRANCH NAME*)
} note note1696 = this
(* po redu: 6669*)
(*6669*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6670*)
(*6670*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6671*)
(*6671*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6672*)
(*6672*)  (*BRANCH NAME*)
} note note1697 = this
(* po redu: 6673*)
(*6673*)  
(*BRANCH END*)
from note1696 and note1697 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6674*)
(*6674*)  (*BRANCH NAME*)
} note note1698 = this
(* po redu: 6675*)
(*6675*)  
(*BRANCH END*)
from note1695 and note1698 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6676*)
(*6676*)  (*BRANCH NAME*)
} note note1699 = this
(* po redu: 6677*)
(*6677*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6678*)
(*6678*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6679*)
(*6679*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6680*)
(*6680*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6681*)
(*6681*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6682*)
(*6682*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6683*)
(*6683*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6684*)
(*6684*)  (*BRANCH NAME*)
} note note1700 = this
(* po redu: 6685*)
(*6685*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6686*)
(*6686*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6687*)
(*6687*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6688*)
(*6688*)  (*BRANCH NAME*)
} note note1701 = this
(* po redu: 6689*)
(*6689*)  
(*BRANCH END*)
from note1700 and note1701 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6690*)
(*6690*)  (*BRANCH NAME*)
} note note1702 = this
(* po redu: 6691*)
(*6691*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6692*)
(*6692*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6693*)
(*6693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6694*)
(*6694*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6695*)
(*6695*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6696*)
(*6696*)  (*BRANCH NAME*)
} note note1703 = this
(* po redu: 6697*)
(*6697*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6698*)
(*6698*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6699*)
(*6699*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6700*)
(*6700*)  (*BRANCH NAME*)
} note note1704 = this
(* po redu: 6701*)
(*6701*)  
(*BRANCH END*)
from note1703 and note1704 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6702*)
(*6702*)  (*BRANCH NAME*)
} note note1705 = this
(* po redu: 6703*)
(*6703*)  
(*BRANCH END*)
from note1702 and note1705 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6704*)
(*6704*)  (*BRANCH NAME*)
} note note1706 = this
(* po redu: 6705*)
(*6705*)  
(*BRANCH END*)
from note1699 and note1706 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6706*)
(*6706*)  (*BRANCH NAME*)
} note note1707 = this
(* po redu: 6707*)
(*6707*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 6708*)
(*6708*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6709*)
(*6709*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6710*)
(*6710*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6711*)
(*6711*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6712*)
(*6712*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6713*)
(*6713*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6714*)
(*6714*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6715*)
(*6715*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6716*)
(*6716*)  (*BRANCH NAME*)
} note note1708 = this
(* po redu: 6717*)
(*6717*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6718*)
(*6718*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6719*)
(*6719*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6720*)
(*6720*)  (*BRANCH NAME*)
} note note1709 = this
(* po redu: 6721*)
(*6721*)  
(*BRANCH END*)
from note1708 and note1709 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6722*)
(*6722*)  (*BRANCH NAME*)
} note note1710 = this
(* po redu: 6723*)
(*6723*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6724*)
(*6724*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6725*)
(*6725*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6726*)
(*6726*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6727*)
(*6727*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6728*)
(*6728*)  (*BRANCH NAME*)
} note note1711 = this
(* po redu: 6729*)
(*6729*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6730*)
(*6730*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6731*)
(*6731*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6732*)
(*6732*)  (*BRANCH NAME*)
} note note1712 = this
(* po redu: 6733*)
(*6733*)  
(*BRANCH END*)
from note1711 and note1712 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6734*)
(*6734*)  (*BRANCH NAME*)
} note note1713 = this
(* po redu: 6735*)
(*6735*)  
(*BRANCH END*)
from note1710 and note1713 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6736*)
(*6736*)  (*BRANCH NAME*)
} note note1714 = this
(* po redu: 6737*)
(*6737*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6738*)
(*6738*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6739*)
(*6739*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6740*)
(*6740*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6741*)
(*6741*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6742*)
(*6742*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6743*)
(*6743*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6744*)
(*6744*)  (*BRANCH NAME*)
} note note1715 = this
(* po redu: 6745*)
(*6745*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6746*)
(*6746*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6747*)
(*6747*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6748*)
(*6748*)  (*BRANCH NAME*)
} note note1716 = this
(* po redu: 6749*)
(*6749*)  
(*BRANCH END*)
from note1715 and note1716 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6750*)
(*6750*)  (*BRANCH NAME*)
} note note1717 = this
(* po redu: 6751*)
(*6751*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6752*)
(*6752*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6753*)
(*6753*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6754*)
(*6754*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6755*)
(*6755*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6756*)
(*6756*)  (*BRANCH NAME*)
} note note1718 = this
(* po redu: 6757*)
(*6757*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6758*)
(*6758*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6759*)
(*6759*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6760*)
(*6760*)  (*BRANCH NAME*)
} note note1719 = this
(* po redu: 6761*)
(*6761*)  
(*BRANCH END*)
from note1718 and note1719 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6762*)
(*6762*)  (*BRANCH NAME*)
} note note1720 = this
(* po redu: 6763*)
(*6763*)  
(*BRANCH END*)
from note1717 and note1720 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6764*)
(*6764*)  (*BRANCH NAME*)
} note note1721 = this
(* po redu: 6765*)
(*6765*)  
(*BRANCH END*)
from note1714 and note1721 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6766*)
(*6766*)  (*BRANCH NAME*)
} note note1722 = this
(* po redu: 6767*)
(*6767*)  
(*BRANCH END*)
from note1707 and note1722 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 6768*)
(*6768*)  (*BRANCH NAME*)
} note note1723 = this
(* po redu: 6769*)
(*6769*)  
(*BRANCH END*)
from note1692 and note1723 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 6770*)
(*6770*)  (*BRANCH NAME*)
} note note1724 = this
(* po redu: 6771*)
(*6771*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 6772*)
(*6772*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 6773*)
(*6773*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 6774*)
(*6774*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 6775*)
(*6775*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 6776*)
(*6776*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6777*)
(*6777*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6778*)
(*6778*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6779*)
(*6779*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6780*)
(*6780*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6781*)
(*6781*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6782*)
(*6782*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6783*)
(*6783*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6784*)
(*6784*)  (*BRANCH NAME*)
} note note1725 = this
(* po redu: 6785*)
(*6785*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6786*)
(*6786*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6787*)
(*6787*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6788*)
(*6788*)  (*BRANCH NAME*)
} note note1726 = this
(* po redu: 6789*)
(*6789*)  
(*BRANCH END*)
from note1725 and note1726 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6790*)
(*6790*)  (*BRANCH NAME*)
} note note1727 = this
(* po redu: 6791*)
(*6791*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6792*)
(*6792*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6793*)
(*6793*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6794*)
(*6794*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6795*)
(*6795*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6796*)
(*6796*)  (*BRANCH NAME*)
} note note1728 = this
(* po redu: 6797*)
(*6797*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6798*)
(*6798*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6799*)
(*6799*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6800*)
(*6800*)  (*BRANCH NAME*)
} note note1729 = this
(* po redu: 6801*)
(*6801*)  
(*BRANCH END*)
from note1728 and note1729 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6802*)
(*6802*)  (*BRANCH NAME*)
} note note1730 = this
(* po redu: 6803*)
(*6803*)  
(*BRANCH END*)
from note1727 and note1730 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6804*)
(*6804*)  (*BRANCH NAME*)
} note note1731 = this
(* po redu: 6805*)
(*6805*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6806*)
(*6806*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6807*)
(*6807*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6808*)
(*6808*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6809*)
(*6809*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6810*)
(*6810*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6811*)
(*6811*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6812*)
(*6812*)  (*BRANCH NAME*)
} note note1732 = this
(* po redu: 6813*)
(*6813*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6814*)
(*6814*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6815*)
(*6815*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6816*)
(*6816*)  (*BRANCH NAME*)
} note note1733 = this
(* po redu: 6817*)
(*6817*)  
(*BRANCH END*)
from note1732 and note1733 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6818*)
(*6818*)  (*BRANCH NAME*)
} note note1734 = this
(* po redu: 6819*)
(*6819*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6820*)
(*6820*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6821*)
(*6821*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6822*)
(*6822*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6823*)
(*6823*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6824*)
(*6824*)  (*BRANCH NAME*)
} note note1735 = this
(* po redu: 6825*)
(*6825*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6826*)
(*6826*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6827*)
(*6827*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6828*)
(*6828*)  (*BRANCH NAME*)
} note note1736 = this
(* po redu: 6829*)
(*6829*)  
(*BRANCH END*)
from note1735 and note1736 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6830*)
(*6830*)  (*BRANCH NAME*)
} note note1737 = this
(* po redu: 6831*)
(*6831*)  
(*BRANCH END*)
from note1734 and note1737 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6832*)
(*6832*)  (*BRANCH NAME*)
} note note1738 = this
(* po redu: 6833*)
(*6833*)  
(*BRANCH END*)
from note1731 and note1738 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6834*)
(*6834*)  (*BRANCH NAME*)
} note note1739 = this
(* po redu: 6835*)
(*6835*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 6836*)
(*6836*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6837*)
(*6837*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6838*)
(*6838*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6839*)
(*6839*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6840*)
(*6840*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6841*)
(*6841*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6842*)
(*6842*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6843*)
(*6843*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6844*)
(*6844*)  (*BRANCH NAME*)
} note note1740 = this
(* po redu: 6845*)
(*6845*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6846*)
(*6846*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6847*)
(*6847*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6848*)
(*6848*)  (*BRANCH NAME*)
} note note1741 = this
(* po redu: 6849*)
(*6849*)  
(*BRANCH END*)
from note1740 and note1741 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6850*)
(*6850*)  (*BRANCH NAME*)
} note note1742 = this
(* po redu: 6851*)
(*6851*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6852*)
(*6852*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6853*)
(*6853*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6854*)
(*6854*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6855*)
(*6855*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6856*)
(*6856*)  (*BRANCH NAME*)
} note note1743 = this
(* po redu: 6857*)
(*6857*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6858*)
(*6858*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6859*)
(*6859*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6860*)
(*6860*)  (*BRANCH NAME*)
} note note1744 = this
(* po redu: 6861*)
(*6861*)  
(*BRANCH END*)
from note1743 and note1744 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6862*)
(*6862*)  (*BRANCH NAME*)
} note note1745 = this
(* po redu: 6863*)
(*6863*)  
(*BRANCH END*)
from note1742 and note1745 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6864*)
(*6864*)  (*BRANCH NAME*)
} note note1746 = this
(* po redu: 6865*)
(*6865*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6866*)
(*6866*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6867*)
(*6867*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6868*)
(*6868*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6869*)
(*6869*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6870*)
(*6870*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6871*)
(*6871*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6872*)
(*6872*)  (*BRANCH NAME*)
} note note1747 = this
(* po redu: 6873*)
(*6873*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6874*)
(*6874*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6875*)
(*6875*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6876*)
(*6876*)  (*BRANCH NAME*)
} note note1748 = this
(* po redu: 6877*)
(*6877*)  
(*BRANCH END*)
from note1747 and note1748 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6878*)
(*6878*)  (*BRANCH NAME*)
} note note1749 = this
(* po redu: 6879*)
(*6879*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6880*)
(*6880*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6881*)
(*6881*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6882*)
(*6882*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6883*)
(*6883*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6884*)
(*6884*)  (*BRANCH NAME*)
} note note1750 = this
(* po redu: 6885*)
(*6885*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6886*)
(*6886*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6887*)
(*6887*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6888*)
(*6888*)  (*BRANCH NAME*)
} note note1751 = this
(* po redu: 6889*)
(*6889*)  
(*BRANCH END*)
from note1750 and note1751 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6890*)
(*6890*)  (*BRANCH NAME*)
} note note1752 = this
(* po redu: 6891*)
(*6891*)  
(*BRANCH END*)
from note1749 and note1752 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6892*)
(*6892*)  (*BRANCH NAME*)
} note note1753 = this
(* po redu: 6893*)
(*6893*)  
(*BRANCH END*)
from note1746 and note1753 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6894*)
(*6894*)  (*BRANCH NAME*)
} note note1754 = this
(* po redu: 6895*)
(*6895*)  
(*BRANCH END*)
from note1739 and note1754 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 6896*)
(*6896*)  (*BRANCH NAME*)
} note note1755 = this
(* po redu: 6897*)
(*6897*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 6898*)
(*6898*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 6899*)
(*6899*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 6900*)
(*6900*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6901*)
(*6901*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6902*)
(*6902*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6903*)
(*6903*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6904*)
(*6904*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6905*)
(*6905*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6906*)
(*6906*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6907*)
(*6907*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6908*)
(*6908*)  (*BRANCH NAME*)
} note note1756 = this
(* po redu: 6909*)
(*6909*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6910*)
(*6910*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6911*)
(*6911*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6912*)
(*6912*)  (*BRANCH NAME*)
} note note1757 = this
(* po redu: 6913*)
(*6913*)  
(*BRANCH END*)
from note1756 and note1757 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6914*)
(*6914*)  (*BRANCH NAME*)
} note note1758 = this
(* po redu: 6915*)
(*6915*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6916*)
(*6916*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6917*)
(*6917*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6918*)
(*6918*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6919*)
(*6919*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6920*)
(*6920*)  (*BRANCH NAME*)
} note note1759 = this
(* po redu: 6921*)
(*6921*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6922*)
(*6922*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6923*)
(*6923*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6924*)
(*6924*)  (*BRANCH NAME*)
} note note1760 = this
(* po redu: 6925*)
(*6925*)  
(*BRANCH END*)
from note1759 and note1760 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6926*)
(*6926*)  (*BRANCH NAME*)
} note note1761 = this
(* po redu: 6927*)
(*6927*)  
(*BRANCH END*)
from note1758 and note1761 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6928*)
(*6928*)  (*BRANCH NAME*)
} note note1762 = this
(* po redu: 6929*)
(*6929*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6930*)
(*6930*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6931*)
(*6931*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6932*)
(*6932*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6933*)
(*6933*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6934*)
(*6934*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6935*)
(*6935*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6936*)
(*6936*)  (*BRANCH NAME*)
} note note1763 = this
(* po redu: 6937*)
(*6937*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6938*)
(*6938*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6939*)
(*6939*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6940*)
(*6940*)  (*BRANCH NAME*)
} note note1764 = this
(* po redu: 6941*)
(*6941*)  
(*BRANCH END*)
from note1763 and note1764 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6942*)
(*6942*)  (*BRANCH NAME*)
} note note1765 = this
(* po redu: 6943*)
(*6943*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6944*)
(*6944*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6945*)
(*6945*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6946*)
(*6946*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6947*)
(*6947*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6948*)
(*6948*)  (*BRANCH NAME*)
} note note1766 = this
(* po redu: 6949*)
(*6949*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6950*)
(*6950*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6951*)
(*6951*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6952*)
(*6952*)  (*BRANCH NAME*)
} note note1767 = this
(* po redu: 6953*)
(*6953*)  
(*BRANCH END*)
from note1766 and note1767 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6954*)
(*6954*)  (*BRANCH NAME*)
} note note1768 = this
(* po redu: 6955*)
(*6955*)  
(*BRANCH END*)
from note1765 and note1768 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6956*)
(*6956*)  (*BRANCH NAME*)
} note note1769 = this
(* po redu: 6957*)
(*6957*)  
(*BRANCH END*)
from note1762 and note1769 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 6958*)
(*6958*)  (*BRANCH NAME*)
} note note1770 = this
(* po redu: 6959*)
(*6959*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 6960*)
(*6960*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6961*)
(*6961*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6962*)
(*6962*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6963*)
(*6963*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6964*)
(*6964*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6965*)
(*6965*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6966*)
(*6966*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6967*)
(*6967*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6968*)
(*6968*)  (*BRANCH NAME*)
} note note1771 = this
(* po redu: 6969*)
(*6969*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6970*)
(*6970*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6971*)
(*6971*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6972*)
(*6972*)  (*BRANCH NAME*)
} note note1772 = this
(* po redu: 6973*)
(*6973*)  
(*BRANCH END*)
from note1771 and note1772 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6974*)
(*6974*)  (*BRANCH NAME*)
} note note1773 = this
(* po redu: 6975*)
(*6975*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 6976*)
(*6976*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6977*)
(*6977*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6978*)
(*6978*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6979*)
(*6979*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6980*)
(*6980*)  (*BRANCH NAME*)
} note note1774 = this
(* po redu: 6981*)
(*6981*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6982*)
(*6982*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6983*)
(*6983*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 6984*)
(*6984*)  (*BRANCH NAME*)
} note note1775 = this
(* po redu: 6985*)
(*6985*)  
(*BRANCH END*)
from note1774 and note1775 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 6986*)
(*6986*)  (*BRANCH NAME*)
} note note1776 = this
(* po redu: 6987*)
(*6987*)  
(*BRANCH END*)
from note1773 and note1776 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 6988*)
(*6988*)  (*BRANCH NAME*)
} note note1777 = this
(* po redu: 6989*)
(*6989*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6990*)
(*6990*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 6991*)
(*6991*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 6992*)
(*6992*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 6993*)
(*6993*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 6994*)
(*6994*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 6995*)
(*6995*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 6996*)
(*6996*)  (*BRANCH NAME*)
} note note1778 = this
(* po redu: 6997*)
(*6997*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 6998*)
(*6998*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 6999*)
(*6999*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7000*)
(*7000*)  (*BRANCH NAME*)
} note note1779 = this
(* po redu: 7001*)
(*7001*)  
(*BRANCH END*)
from note1778 and note1779 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7002*)
(*7002*)  (*BRANCH NAME*)
} note note1780 = this
(* po redu: 7003*)
(*7003*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7004*)
(*7004*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7005*)
(*7005*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7006*)
(*7006*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

(* po redu: 7007*)
(*7007*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7008*)
(*7008*)  (*BRANCH NAME*)
} note note1781 = this
(* po redu: 7009*)
(*7009*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7010*)
(*7010*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7011*)
(*7011*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7012*)
(*7012*)  (*BRANCH NAME*)
} note note1782 = this
(* po redu: 7013*)
(*7013*)  
(*BRANCH END*)
from note1781 and note1782 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7014*)
(*7014*)  (*BRANCH NAME*)
} note note1783 = this
(* po redu: 7015*)
(*7015*)  
(*BRANCH END*)
from note1780 and note1783 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7016*)
(*7016*)  (*BRANCH NAME*)
} note note1784 = this
(* po redu: 7017*)
(*7017*)  
(*BRANCH END*)
from note1777 and note1784 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7018*)
(*7018*)  (*BRANCH NAME*)
} note note1785 = this
(* po redu: 7019*)
(*7019*)  
(*BRANCH END*)
from note1770 and note1785 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 7020*)
(*7020*)  (*BRANCH NAME*)
} note note1786 = this
(* po redu: 7021*)
(*7021*)  
(*BRANCH END*)
from note1755 and note1786 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 7022*)
(*7022*)  (*BRANCH NAME*)
} note note1787 = this
(* po redu: 7023*)
(*7023*)  
(*BRANCH END*)
from note1724 and note1787 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 7024*)
(*7024*)  (*BRANCH NAME*)
} note note1788 = this
(* po redu: 7025*)
(*7025*)  
(*BRANCH END*)
from note1661 and note1788 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 7026*)
(*7026*)  (*BRANCH NAME*)
} note note1789 = this
(* po redu: 7027*)
(*7027*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 7028*)
(*7028*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 7029*)
(*7029*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 7030*)
(*7030*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 7031*)
(*7031*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 7032*)
(*7032*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 7033*)
(*7033*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 7034*)
(*7034*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 7035*)
(*7035*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 7036*)
(*7036*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7037*)
(*7037*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7038*)
(*7038*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7039*)
(*7039*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7040*)
(*7040*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7041*)
(*7041*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7042*)
(*7042*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7043*)
(*7043*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7044*)
(*7044*)  (*BRANCH NAME*)
} note note1790 = this
(* po redu: 7045*)
(*7045*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7046*)
(*7046*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7047*)
(*7047*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7048*)
(*7048*)  (*BRANCH NAME*)
} note note1791 = this
(* po redu: 7049*)
(*7049*)  
(*BRANCH END*)
from note1790 and note1791 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7050*)
(*7050*)  (*BRANCH NAME*)
} note note1792 = this
(* po redu: 7051*)
(*7051*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7052*)
(*7052*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7053*)
(*7053*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7054*)
(*7054*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7055*)
(*7055*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7056*)
(*7056*)  (*BRANCH NAME*)
} note note1793 = this
(* po redu: 7057*)
(*7057*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7058*)
(*7058*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7059*)
(*7059*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7060*)
(*7060*)  (*BRANCH NAME*)
} note note1794 = this
(* po redu: 7061*)
(*7061*)  
(*BRANCH END*)
from note1793 and note1794 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7062*)
(*7062*)  (*BRANCH NAME*)
} note note1795 = this
(* po redu: 7063*)
(*7063*)  
(*BRANCH END*)
from note1792 and note1795 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7064*)
(*7064*)  (*BRANCH NAME*)
} note note1796 = this
(* po redu: 7065*)
(*7065*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7066*)
(*7066*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7067*)
(*7067*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7068*)
(*7068*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7069*)
(*7069*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7070*)
(*7070*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7071*)
(*7071*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7072*)
(*7072*)  (*BRANCH NAME*)
} note note1797 = this
(* po redu: 7073*)
(*7073*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7074*)
(*7074*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7075*)
(*7075*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7076*)
(*7076*)  (*BRANCH NAME*)
} note note1798 = this
(* po redu: 7077*)
(*7077*)  
(*BRANCH END*)
from note1797 and note1798 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7078*)
(*7078*)  (*BRANCH NAME*)
} note note1799 = this
(* po redu: 7079*)
(*7079*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7080*)
(*7080*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7081*)
(*7081*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7082*)
(*7082*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7083*)
(*7083*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7084*)
(*7084*)  (*BRANCH NAME*)
} note note1800 = this
(* po redu: 7085*)
(*7085*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7086*)
(*7086*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7087*)
(*7087*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7088*)
(*7088*)  (*BRANCH NAME*)
} note note1801 = this
(* po redu: 7089*)
(*7089*)  
(*BRANCH END*)
from note1800 and note1801 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7090*)
(*7090*)  (*BRANCH NAME*)
} note note1802 = this
(* po redu: 7091*)
(*7091*)  
(*BRANCH END*)
from note1799 and note1802 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7092*)
(*7092*)  (*BRANCH NAME*)
} note note1803 = this
(* po redu: 7093*)
(*7093*)  
(*BRANCH END*)
from note1796 and note1803 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7094*)
(*7094*)  (*BRANCH NAME*)
} note note1804 = this
(* po redu: 7095*)
(*7095*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 7096*)
(*7096*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7097*)
(*7097*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7098*)
(*7098*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7099*)
(*7099*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7100*)
(*7100*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7101*)
(*7101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7102*)
(*7102*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7103*)
(*7103*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7104*)
(*7104*)  (*BRANCH NAME*)
} note note1805 = this
(* po redu: 7105*)
(*7105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7106*)
(*7106*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7107*)
(*7107*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7108*)
(*7108*)  (*BRANCH NAME*)
} note note1806 = this
(* po redu: 7109*)
(*7109*)  
(*BRANCH END*)
from note1805 and note1806 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7110*)
(*7110*)  (*BRANCH NAME*)
} note note1807 = this
(* po redu: 7111*)
(*7111*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7112*)
(*7112*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7113*)
(*7113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7114*)
(*7114*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7115*)
(*7115*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7116*)
(*7116*)  (*BRANCH NAME*)
} note note1808 = this
(* po redu: 7117*)
(*7117*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7118*)
(*7118*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7119*)
(*7119*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7120*)
(*7120*)  (*BRANCH NAME*)
} note note1809 = this
(* po redu: 7121*)
(*7121*)  
(*BRANCH END*)
from note1808 and note1809 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7122*)
(*7122*)  (*BRANCH NAME*)
} note note1810 = this
(* po redu: 7123*)
(*7123*)  
(*BRANCH END*)
from note1807 and note1810 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7124*)
(*7124*)  (*BRANCH NAME*)
} note note1811 = this
(* po redu: 7125*)
(*7125*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7126*)
(*7126*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7127*)
(*7127*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7128*)
(*7128*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7129*)
(*7129*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7130*)
(*7130*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7131*)
(*7131*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7132*)
(*7132*)  (*BRANCH NAME*)
} note note1812 = this
(* po redu: 7133*)
(*7133*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7134*)
(*7134*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7135*)
(*7135*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7136*)
(*7136*)  (*BRANCH NAME*)
} note note1813 = this
(* po redu: 7137*)
(*7137*)  
(*BRANCH END*)
from note1812 and note1813 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7138*)
(*7138*)  (*BRANCH NAME*)
} note note1814 = this
(* po redu: 7139*)
(*7139*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7140*)
(*7140*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7141*)
(*7141*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7142*)
(*7142*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7143*)
(*7143*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7144*)
(*7144*)  (*BRANCH NAME*)
} note note1815 = this
(* po redu: 7145*)
(*7145*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7146*)
(*7146*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7147*)
(*7147*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7148*)
(*7148*)  (*BRANCH NAME*)
} note note1816 = this
(* po redu: 7149*)
(*7149*)  
(*BRANCH END*)
from note1815 and note1816 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7150*)
(*7150*)  (*BRANCH NAME*)
} note note1817 = this
(* po redu: 7151*)
(*7151*)  
(*BRANCH END*)
from note1814 and note1817 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7152*)
(*7152*)  (*BRANCH NAME*)
} note note1818 = this
(* po redu: 7153*)
(*7153*)  
(*BRANCH END*)
from note1811 and note1818 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7154*)
(*7154*)  (*BRANCH NAME*)
} note note1819 = this
(* po redu: 7155*)
(*7155*)  
(*BRANCH END*)
from note1804 and note1819 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 7156*)
(*7156*)  (*BRANCH NAME*)
} note note1820 = this
(* po redu: 7157*)
(*7157*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 7158*)
(*7158*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 7159*)
(*7159*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 7160*)
(*7160*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7161*)
(*7161*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7162*)
(*7162*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7163*)
(*7163*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7164*)
(*7164*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7165*)
(*7165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7166*)
(*7166*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7167*)
(*7167*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7168*)
(*7168*)  (*BRANCH NAME*)
} note note1821 = this
(* po redu: 7169*)
(*7169*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7170*)
(*7170*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7171*)
(*7171*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7172*)
(*7172*)  (*BRANCH NAME*)
} note note1822 = this
(* po redu: 7173*)
(*7173*)  
(*BRANCH END*)
from note1821 and note1822 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7174*)
(*7174*)  (*BRANCH NAME*)
} note note1823 = this
(* po redu: 7175*)
(*7175*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7176*)
(*7176*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7177*)
(*7177*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7178*)
(*7178*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7179*)
(*7179*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7180*)
(*7180*)  (*BRANCH NAME*)
} note note1824 = this
(* po redu: 7181*)
(*7181*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7182*)
(*7182*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7183*)
(*7183*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7184*)
(*7184*)  (*BRANCH NAME*)
} note note1825 = this
(* po redu: 7185*)
(*7185*)  
(*BRANCH END*)
from note1824 and note1825 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7186*)
(*7186*)  (*BRANCH NAME*)
} note note1826 = this
(* po redu: 7187*)
(*7187*)  
(*BRANCH END*)
from note1823 and note1826 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7188*)
(*7188*)  (*BRANCH NAME*)
} note note1827 = this
(* po redu: 7189*)
(*7189*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7190*)
(*7190*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7191*)
(*7191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7192*)
(*7192*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7193*)
(*7193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7194*)
(*7194*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7195*)
(*7195*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7196*)
(*7196*)  (*BRANCH NAME*)
} note note1828 = this
(* po redu: 7197*)
(*7197*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7198*)
(*7198*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7199*)
(*7199*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7200*)
(*7200*)  (*BRANCH NAME*)
} note note1829 = this
(* po redu: 7201*)
(*7201*)  
(*BRANCH END*)
from note1828 and note1829 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7202*)
(*7202*)  (*BRANCH NAME*)
} note note1830 = this
(* po redu: 7203*)
(*7203*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7204*)
(*7204*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7205*)
(*7205*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7206*)
(*7206*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7207*)
(*7207*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7208*)
(*7208*)  (*BRANCH NAME*)
} note note1831 = this
(* po redu: 7209*)
(*7209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7210*)
(*7210*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7211*)
(*7211*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7212*)
(*7212*)  (*BRANCH NAME*)
} note note1832 = this
(* po redu: 7213*)
(*7213*)  
(*BRANCH END*)
from note1831 and note1832 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7214*)
(*7214*)  (*BRANCH NAME*)
} note note1833 = this
(* po redu: 7215*)
(*7215*)  
(*BRANCH END*)
from note1830 and note1833 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7216*)
(*7216*)  (*BRANCH NAME*)
} note note1834 = this
(* po redu: 7217*)
(*7217*)  
(*BRANCH END*)
from note1827 and note1834 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7218*)
(*7218*)  (*BRANCH NAME*)
} note note1835 = this
(* po redu: 7219*)
(*7219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 7220*)
(*7220*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7221*)
(*7221*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7222*)
(*7222*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7223*)
(*7223*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7224*)
(*7224*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7225*)
(*7225*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7226*)
(*7226*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7227*)
(*7227*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7228*)
(*7228*)  (*BRANCH NAME*)
} note note1836 = this
(* po redu: 7229*)
(*7229*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7230*)
(*7230*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7231*)
(*7231*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7232*)
(*7232*)  (*BRANCH NAME*)
} note note1837 = this
(* po redu: 7233*)
(*7233*)  
(*BRANCH END*)
from note1836 and note1837 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7234*)
(*7234*)  (*BRANCH NAME*)
} note note1838 = this
(* po redu: 7235*)
(*7235*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7236*)
(*7236*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7237*)
(*7237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7238*)
(*7238*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7239*)
(*7239*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7240*)
(*7240*)  (*BRANCH NAME*)
} note note1839 = this
(* po redu: 7241*)
(*7241*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7242*)
(*7242*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7243*)
(*7243*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7244*)
(*7244*)  (*BRANCH NAME*)
} note note1840 = this
(* po redu: 7245*)
(*7245*)  
(*BRANCH END*)
from note1839 and note1840 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7246*)
(*7246*)  (*BRANCH NAME*)
} note note1841 = this
(* po redu: 7247*)
(*7247*)  
(*BRANCH END*)
from note1838 and note1841 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7248*)
(*7248*)  (*BRANCH NAME*)
} note note1842 = this
(* po redu: 7249*)
(*7249*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7250*)
(*7250*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7251*)
(*7251*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7252*)
(*7252*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7253*)
(*7253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7254*)
(*7254*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7255*)
(*7255*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7256*)
(*7256*)  (*BRANCH NAME*)
} note note1843 = this
(* po redu: 7257*)
(*7257*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7258*)
(*7258*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7259*)
(*7259*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7260*)
(*7260*)  (*BRANCH NAME*)
} note note1844 = this
(* po redu: 7261*)
(*7261*)  
(*BRANCH END*)
from note1843 and note1844 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7262*)
(*7262*)  (*BRANCH NAME*)
} note note1845 = this
(* po redu: 7263*)
(*7263*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7264*)
(*7264*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7265*)
(*7265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7266*)
(*7266*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7267*)
(*7267*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7268*)
(*7268*)  (*BRANCH NAME*)
} note note1846 = this
(* po redu: 7269*)
(*7269*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7270*)
(*7270*)  (*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

(* po redu: 7271*)
(*7271*)  (*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

(* po redu: 7272*)
(*7272*)  (*BRANCH NAME*)
} note note1847 = this
(* po redu: 7273*)
(*7273*)  
(*BRANCH END*)
from note1846 and note1847 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7274*)
(*7274*)  (*BRANCH NAME*)
} note note1848 = this
(* po redu: 7275*)
(*7275*)  
(*BRANCH END*)
from note1845 and note1848 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7276*)
(*7276*)  (*BRANCH NAME*)
} note note1849 = this
(* po redu: 7277*)
(*7277*)  
(*BRANCH END*)
from note1842 and note1849 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7278*)
(*7278*)  (*BRANCH NAME*)
} note note1850 = this
(* po redu: 7279*)
(*7279*)  
(*BRANCH END*)
from note1835 and note1850 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 7280*)
(*7280*)  (*BRANCH NAME*)
} note note1851 = this
(* po redu: 7281*)
(*7281*)  
(*BRANCH END*)
from note1820 and note1851 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 7282*)
(*7282*)  (*BRANCH NAME*)
} note note1852 = this
(* po redu: 7283*)
(*7283*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 7284*)
(*7284*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 7285*)
(*7285*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 7286*)
(*7286*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 7287*)
(*7287*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 7288*)
(*7288*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7289*)
(*7289*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7290*)
(*7290*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7291*)
(*7291*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7292*)
(*7292*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7293*)
(*7293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7294*)
(*7294*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7295*)
(*7295*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7296*)
(*7296*)  (*BRANCH NAME*)
} note note1853 = this
(* po redu: 7297*)
(*7297*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7298*)
(*7298*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 7299*)
(*7299*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 7300*)
(*7300*)  (*BRANCH NAME*)
} note note1854 = this
(* po redu: 7301*)
(*7301*)  
(*BRANCH END*)
from note1853 and note1854 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7302*)
(*7302*)  (*BRANCH NAME*)
} note note1855 = this
(* po redu: 7303*)
(*7303*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7304*)
(*7304*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7305*)
(*7305*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7306*)
(*7306*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7307*)
(*7307*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7308*)
(*7308*)  (*BRANCH NAME*)
} note note1856 = this
(* po redu: 7309*)
(*7309*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7310*)
(*7310*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 7311*)
(*7311*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 7312*)
(*7312*)  (*BRANCH NAME*)
} note note1857 = this
(* po redu: 7313*)
(*7313*)  
(*BRANCH END*)
from note1856 and note1857 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7314*)
(*7314*)  (*BRANCH NAME*)
} note note1858 = this
(* po redu: 7315*)
(*7315*)  
(*BRANCH END*)
from note1855 and note1858 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7316*)
(*7316*)  (*BRANCH NAME*)
} note note1859 = this
(* po redu: 7317*)
(*7317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7318*)
(*7318*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7319*)
(*7319*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7320*)
(*7320*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7321*)
(*7321*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7322*)
(*7322*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7323*)
(*7323*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7324*)
(*7324*)  (*BRANCH NAME*)
} note note1860 = this
(* po redu: 7325*)
(*7325*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7326*)
(*7326*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 7327*)
(*7327*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 7328*)
(*7328*)  (*BRANCH NAME*)
} note note1861 = this
(* po redu: 7329*)
(*7329*)  
(*BRANCH END*)
from note1860 and note1861 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7330*)
(*7330*)  (*BRANCH NAME*)
} note note1862 = this
(* po redu: 7331*)
(*7331*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7332*)
(*7332*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7333*)
(*7333*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7334*)
(*7334*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7335*)
(*7335*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7336*)
(*7336*)  (*BRANCH NAME*)
} note note1863 = this
(* po redu: 7337*)
(*7337*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7338*)
(*7338*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 7339*)
(*7339*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 7340*)
(*7340*)  (*BRANCH NAME*)
} note note1864 = this
(* po redu: 7341*)
(*7341*)  
(*BRANCH END*)
from note1863 and note1864 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7342*)
(*7342*)  (*BRANCH NAME*)
} note note1865 = this
(* po redu: 7343*)
(*7343*)  
(*BRANCH END*)
from note1862 and note1865 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7344*)
(*7344*)  (*BRANCH NAME*)
} note note1866 = this
(* po redu: 7345*)
(*7345*)  
(*BRANCH END*)
from note1859 and note1866 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7346*)
(*7346*)  (*BRANCH NAME*)
} note note1867 = this
(* po redu: 7347*)
(*7347*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 7348*)
(*7348*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7349*)
(*7349*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7350*)
(*7350*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7351*)
(*7351*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7352*)
(*7352*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7353*)
(*7353*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7354*)
(*7354*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7355*)
(*7355*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7356*)
(*7356*)  (*BRANCH NAME*)
} note note1868 = this
(* po redu: 7357*)
(*7357*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7358*)
(*7358*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 7359*)
(*7359*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 7360*)
(*7360*)  (*BRANCH NAME*)
} note note1869 = this
(* po redu: 7361*)
(*7361*)  
(*BRANCH END*)
from note1868 and note1869 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7362*)
(*7362*)  (*BRANCH NAME*)
} note note1870 = this
(* po redu: 7363*)
(*7363*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7364*)
(*7364*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7365*)
(*7365*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7366*)
(*7366*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7367*)
(*7367*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7368*)
(*7368*)  (*BRANCH NAME*)
} note note1871 = this
(* po redu: 7369*)
(*7369*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7370*)
(*7370*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 7371*)
(*7371*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 7372*)
(*7372*)  (*BRANCH NAME*)
} note note1872 = this
(* po redu: 7373*)
(*7373*)  
(*BRANCH END*)
from note1871 and note1872 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7374*)
(*7374*)  (*BRANCH NAME*)
} note note1873 = this
(* po redu: 7375*)
(*7375*)  
(*BRANCH END*)
from note1870 and note1873 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7376*)
(*7376*)  (*BRANCH NAME*)
} note note1874 = this
(* po redu: 7377*)
(*7377*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7378*)
(*7378*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7379*)
(*7379*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7380*)
(*7380*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7381*)
(*7381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7382*)
(*7382*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7383*)
(*7383*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7384*)
(*7384*)  (*BRANCH NAME*)
} note note1875 = this
(* po redu: 7385*)
(*7385*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7386*)
(*7386*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 7387*)
(*7387*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 7388*)
(*7388*)  (*BRANCH NAME*)
} note note1876 = this
(* po redu: 7389*)
(*7389*)  
(*BRANCH END*)
from note1875 and note1876 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7390*)
(*7390*)  (*BRANCH NAME*)
} note note1877 = this
(* po redu: 7391*)
(*7391*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7392*)
(*7392*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7393*)
(*7393*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7394*)
(*7394*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7395*)
(*7395*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7396*)
(*7396*)  (*BRANCH NAME*)
} note note1878 = this
(* po redu: 7397*)
(*7397*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7398*)
(*7398*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

(* po redu: 7399*)
(*7399*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

(* po redu: 7400*)
(*7400*)  (*BRANCH NAME*)
} note note1879 = this
(* po redu: 7401*)
(*7401*)  
(*BRANCH END*)
from note1878 and note1879 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7402*)
(*7402*)  (*BRANCH NAME*)
} note note1880 = this
(* po redu: 7403*)
(*7403*)  
(*BRANCH END*)
from note1877 and note1880 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7404*)
(*7404*)  (*BRANCH NAME*)
} note note1881 = this
(* po redu: 7405*)
(*7405*)  
(*BRANCH END*)
from note1874 and note1881 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7406*)
(*7406*)  (*BRANCH NAME*)
} note note1882 = this
(* po redu: 7407*)
(*7407*)  
(*BRANCH END*)
from note1867 and note1882 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 7408*)
(*7408*)  (*BRANCH NAME*)
} note note1883 = this
(* po redu: 7409*)
(*7409*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 7410*)
(*7410*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 7411*)
(*7411*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 7412*)
(*7412*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7413*)
(*7413*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7414*)
(*7414*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7415*)
(*7415*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7416*)
(*7416*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7417*)
(*7417*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7418*)
(*7418*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7419*)
(*7419*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7420*)
(*7420*)  (*BRANCH NAME*)
} note note1884 = this
(* po redu: 7421*)
(*7421*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7422*)
(*7422*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

(* po redu: 7423*)
(*7423*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

(* po redu: 7424*)
(*7424*)  (*BRANCH NAME*)
} note note1885 = this
(* po redu: 7425*)
(*7425*)  
(*BRANCH END*)
from note1884 and note1885 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7426*)
(*7426*)  (*BRANCH NAME*)
} note note1886 = this
(* po redu: 7427*)
(*7427*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7428*)
(*7428*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7429*)
(*7429*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7430*)
(*7430*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7431*)
(*7431*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7432*)
(*7432*)  (*BRANCH NAME*)
} note note1887 = this
(* po redu: 7433*)
(*7433*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7434*)
(*7434*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

(* po redu: 7435*)
(*7435*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

(* po redu: 7436*)
(*7436*)  (*BRANCH NAME*)
} note note1888 = this
(* po redu: 7437*)
(*7437*)  
(*BRANCH END*)
from note1887 and note1888 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7438*)
(*7438*)  (*BRANCH NAME*)
} note note1889 = this
(* po redu: 7439*)
(*7439*)  
(*BRANCH END*)
from note1886 and note1889 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7440*)
(*7440*)  (*BRANCH NAME*)
} note note1890 = this
(* po redu: 7441*)
(*7441*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7442*)
(*7442*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7443*)
(*7443*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7444*)
(*7444*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7445*)
(*7445*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7446*)
(*7446*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7447*)
(*7447*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7448*)
(*7448*)  (*BRANCH NAME*)
} note note1891 = this
(* po redu: 7449*)
(*7449*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7450*)
(*7450*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

(* po redu: 7451*)
(*7451*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

(* po redu: 7452*)
(*7452*)  (*BRANCH NAME*)
} note note1892 = this
(* po redu: 7453*)
(*7453*)  
(*BRANCH END*)
from note1891 and note1892 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7454*)
(*7454*)  (*BRANCH NAME*)
} note note1893 = this
(* po redu: 7455*)
(*7455*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7456*)
(*7456*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7457*)
(*7457*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7458*)
(*7458*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7459*)
(*7459*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7460*)
(*7460*)  (*BRANCH NAME*)
} note note1894 = this
(* po redu: 7461*)
(*7461*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7462*)
(*7462*)  (*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

(* po redu: 7463*)
(*7463*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

(* po redu: 7464*)
(*7464*)  (*BRANCH NAME*)
} note note1895 = this
(* po redu: 7465*)
(*7465*)  
(*BRANCH END*)
from note1894 and note1895 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7466*)
(*7466*)  (*BRANCH NAME*)
} note note1896 = this
(* po redu: 7467*)
(*7467*)  
(*BRANCH END*)
from note1893 and note1896 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7468*)
(*7468*)  (*BRANCH NAME*)
} note note1897 = this
(* po redu: 7469*)
(*7469*)  
(*BRANCH END*)
from note1890 and note1897 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7470*)
(*7470*)  (*BRANCH NAME*)
} note note1898 = this
(* po redu: 7471*)
(*7471*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 7472*)
(*7472*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7473*)
(*7473*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7474*)
(*7474*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7475*)
(*7475*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7476*)
(*7476*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7477*)
(*7477*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7478*)
(*7478*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7479*)
(*7479*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7480*)
(*7480*)  (*BRANCH NAME*)
} note note1899 = this
(* po redu: 7481*)
(*7481*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7482*)
(*7482*)  (*REGULAR*)
moreover
from `int_l_pl LI2 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI2 PL1"
using ax_D10 [of "LI2" "PL1"]
by auto

(* po redu: 7483*)
(*7483*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI2 PL1` and `inc_l_pl LI2 PL1`
have False
by auto

(* po redu: 7484*)
(*7484*)  (*BRANCH NAME*)
} note note1900 = this
(* po redu: 7485*)
(*7485*)  
(*BRANCH END*)
from note1899 and note1900 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7486*)
(*7486*)  (*BRANCH NAME*)
} note note1901 = this
(* po redu: 7487*)
(*7487*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7488*)
(*7488*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7489*)
(*7489*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7490*)
(*7490*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7491*)
(*7491*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7492*)
(*7492*)  (*BRANCH NAME*)
} note note1902 = this
(* po redu: 7493*)
(*7493*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7494*)
(*7494*)  (*REGULAR*)
moreover
from `int_l_pl LI2 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI2 PL1"
using ax_D10 [of "LI2" "PL1"]
by auto

(* po redu: 7495*)
(*7495*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI2 PL1` and `inc_l_pl LI2 PL1`
have False
by auto

(* po redu: 7496*)
(*7496*)  (*BRANCH NAME*)
} note note1903 = this
(* po redu: 7497*)
(*7497*)  
(*BRANCH END*)
from note1902 and note1903 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7498*)
(*7498*)  (*BRANCH NAME*)
} note note1904 = this
(* po redu: 7499*)
(*7499*)  
(*BRANCH END*)
from note1901 and note1904 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7500*)
(*7500*)  (*BRANCH NAME*)
} note note1905 = this
(* po redu: 7501*)
(*7501*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7502*)
(*7502*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7503*)
(*7503*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7504*)
(*7504*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7505*)
(*7505*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7506*)
(*7506*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7507*)
(*7507*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7508*)
(*7508*)  (*BRANCH NAME*)
} note note1906 = this
(* po redu: 7509*)
(*7509*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7510*)
(*7510*)  (*REGULAR*)
moreover
from `int_l_pl LI2 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI2 PL2"
using ax_D10 [of "LI2" "PL2"]
by auto

(* po redu: 7511*)
(*7511*)  (*REGULAR*)
moreover
from `\<not>inc_l_pl LI2 PL2` and `inc_l_pl LI2 PL2`
have False
by auto

(* po redu: 7512*)
(*7512*)  (*BRANCH NAME*)
} note note1907 = this
(* po redu: 7513*)
(*7513*)  
(*BRANCH END*)
from note1906 and note1907 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7514*)
(*7514*)  (*BRANCH NAME*)
} note note1908 = this
(* po redu: 7515*)
(*7515*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7516*)
(*7516*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7517*)
(*7517*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7518*)
(*7518*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7519*)
(*7519*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7520*)
(*7520*)  (*BRANCH NAME*)
} note note1909 = this
(* po redu: 7521*)
(*7521*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7522*)
(*7522*)  (*REGULAR*)
moreover

obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 7523*)
(*7523*)  (*REGULAR*)
moreover

obtain  PO4::point and  PO5::point
where "inc_po_l PO4 LI2" and "PO4 ~= PO5" and "inc_po_l PO5 LI2"
using ax_I3a [of "LI2"]
by auto

(* po redu: 7524*)
(*7524*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
obtain  PO6::point
where "PO1 ~= PO6" and "inc_po_pl PO6 PL1" and "inc_po_pl PO6 PL2"
using ax_I7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7525*)
(*7525*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(* po redu: 7526*)
(*7526*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(* po redu: 7527*)
(*7527*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(* po redu: 7528*)
(*7528*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL1"
using ax_D11 [of "LI1" "PL1" "PO2"]
by auto

(* po redu: 7529*)
(*7529*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 7530*)
(*7530*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 7531*)
(*7531*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 7532*)
(*7532*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 7533*)
(*7533*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL2"
using ax_D11 [of "LI1" "PL2" "PO2"]
by auto

(* po redu: 7534*)
(*7534*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 7535*)
(*7535*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 7536*)
(*7536*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(* po redu: 7537*)
(*7537*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(* po redu: 7538*)
(*7538*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

(* po redu: 7539*)
(*7539*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 7540*)
(*7540*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 7541*)
(*7541*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 7542*)
(*7542*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 7543*)
(*7543*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 7544*)
(*7544*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL2"
using ax_D11 [of "LI1" "PL2" "PO3"]
by auto

(* po redu: 7545*)
(*7545*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2"
using ax_g4 [of "PO3" "LI2"]
by auto

(* po redu: 7546*)
(*7546*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI2"
(* po redu: 7547*)
(*7547*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 7548*)
(*7548*)  (*REGULAR*)
moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2`
have  "LI1 = LI2"
using ax_I2 [of "PO1" "PO3" "LI1" "LI2"]
by auto

(* po redu: 7549*)
(*7549*)  (*REGULAR*)
moreover
from `LI1 = LI2` and `LI1 ~= LI2`
have False
by auto

(* po redu: 7550*)
(*7550*)  (*BRANCH NAME*)
} note note1910 = this
(* po redu: 7551*)
(*7551*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI2"
(* po redu: 7552*)
(*7552*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

(* po redu: 7553*)
(*7553*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

(* po redu: 7554*)
(*7554*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

(* po redu: 7555*)
(*7555*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL1"
using ax_D11 [of "LI2" "PL1" "PO4"]
by auto

(* po redu: 7556*)
(*7556*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 7557*)
(*7557*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

(* po redu: 7558*)
(*7558*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 7559*)
(*7559*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 7560*)
(*7560*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 7561*)
(*7561*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7562*)
(*7562*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 7563*)
(*7563*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 7564*)
(*7564*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7565*)
(*7565*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7566*)
(*7566*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL2"
using ax_D11 [of "LI2" "PL2" "PO4"]
by auto

(* po redu: 7567*)
(*7567*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 7568*)
(*7568*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 7569*)
(*7569*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 7570*)
(*7570*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 7571*)
(*7571*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 7572*)
(*7572*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 7573*)
(*7573*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 7574*)
(*7574*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL1"
using ax_D11 [of "LI2" "PL1" "PO5"]
by auto

(* po redu: 7575*)
(*7575*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 7576*)
(*7576*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO5"]
by auto

(* po redu: 7577*)
(*7577*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 7578*)
(*7578*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 7579*)
(*7579*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 7580*)
(*7580*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7581*)
(*7581*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO3 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 7582*)
(*7582*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 7583*)
(*7583*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO5 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7584*)
(*7584*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7585*)
(*7585*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL2"
using ax_D11 [of "LI2" "PL2" "PO5"]
by auto

(* po redu: 7586*)
(*7586*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 7587*)
(*7587*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO3 PL2` and `inc_po_pl PO5 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO3" "PO5" "PL1" "PL2"]
by auto

(* po redu: 7588*)
(*7588*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7589*)
(*7589*)  (*BRANCH NAME*)
} note note1911 = this
(* po redu: 7590*)
(*7590*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 7591*)
(*7591*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO4 PO3"
using ax_D1a [of "PO1" "PO4" "LI2" "PO3"]
by auto

(* po redu: 7592*)
(*7592*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 7593*)
(*7593*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO4` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO3 PL2` and `inc_po_pl PO4 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO3" "PO4" "PL1" "PL2"]
by auto

(* po redu: 7594*)
(*7594*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7595*)
(*7595*)  (*BRANCH NAME*)
} note note1912 = this
(* po redu: 7596*)
(*7596*)  
(*BRANCH END*)
from note1911 and note1912 and `PO1 = PO4 \<or> PO1 ~= PO4`
have False
by auto
(* po redu: 7597*)
(*7597*)  (*BRANCH NAME*)
} note note1913 = this
(* po redu: 7598*)
(*7598*)  
(*BRANCH END*)
from note1910 and note1913 and `inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2`
have False
by auto
(* po redu: 7599*)
(*7599*)  (*BRANCH NAME*)
} note note1914 = this
(* po redu: 7600*)
(*7600*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 7601*)
(*7601*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2"
using ax_g4 [of "PO2" "LI2"]
by auto

(* po redu: 7602*)
(*7602*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI2"
(* po redu: 7603*)
(*7603*)  (*REGULAR*)
moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO2 LI2`
have  "LI1 = LI2"
using ax_I2 [of "PO1" "PO2" "LI1" "LI2"]
by auto

(* po redu: 7604*)
(*7604*)  (*REGULAR*)
moreover
from `LI1 = LI2` and `LI1 ~= LI2`
have False
by auto

(* po redu: 7605*)
(*7605*)  (*BRANCH NAME*)
} note note1915 = this
(* po redu: 7606*)
(*7606*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI2"
(* po redu: 7607*)
(*7607*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(* po redu: 7608*)
(*7608*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(* po redu: 7609*)
(*7609*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(* po redu: 7610*)
(*7610*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(* po redu: 7611*)
(*7611*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

(* po redu: 7612*)
(*7612*)  (*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

(* po redu: 7613*)
(*7613*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 7614*)
(*7614*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 7615*)
(*7615*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(* po redu: 7616*)
(*7616*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 7617*)
(*7617*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 7618*)
(*7618*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 7619*)
(*7619*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 7620*)
(*7620*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 7621*)
(*7621*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 7622*)
(*7622*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 7623*)
(*7623*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 7624*)
(*7624*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL2"
using ax_D11 [of "LI1" "PL2" "PO3"]
by auto

(* po redu: 7625*)
(*7625*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 7626*)
(*7626*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 7627*)
(*7627*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

(* po redu: 7628*)
(*7628*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

(* po redu: 7629*)
(*7629*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

(* po redu: 7630*)
(*7630*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL1"
using ax_D11 [of "LI2" "PL1" "PO4"]
by auto

(* po redu: 7631*)
(*7631*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 7632*)
(*7632*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(* po redu: 7633*)
(*7633*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 7634*)
(*7634*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 7635*)
(*7635*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 7636*)
(*7636*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7637*)
(*7637*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 7638*)
(*7638*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 7639*)
(*7639*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7640*)
(*7640*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7641*)
(*7641*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL2"
using ax_D11 [of "LI2" "PL2" "PO4"]
by auto

(* po redu: 7642*)
(*7642*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 7643*)
(*7643*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 7644*)
(*7644*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 7645*)
(*7645*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 7646*)
(*7646*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 7647*)
(*7647*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 7648*)
(*7648*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 7649*)
(*7649*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL1"
using ax_D11 [of "LI2" "PL1" "PO5"]
by auto

(* po redu: 7650*)
(*7650*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 7651*)
(*7651*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO5"]
by auto

(* po redu: 7652*)
(*7652*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 7653*)
(*7653*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO5"]
by auto

(* po redu: 7654*)
(*7654*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO5" "PO5"]
by auto

(* po redu: 7655*)
(*7655*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7656*)
(*7656*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO2 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO5"]
by auto

(* po redu: 7657*)
(*7657*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO5" "PO5"]
by auto

(* po redu: 7658*)
(*7658*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO5 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7659*)
(*7659*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7660*)
(*7660*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL2"
using ax_D11 [of "LI2" "PL2" "PO5"]
by auto

(* po redu: 7661*)
(*7661*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 7662*)
(*7662*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO5 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO5" "PL1" "PL2"]
by auto

(* po redu: 7663*)
(*7663*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7664*)
(*7664*)  (*BRANCH NAME*)
} note note1916 = this
(* po redu: 7665*)
(*7665*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 7666*)
(*7666*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO4 PO2"
using ax_D1a [of "PO1" "PO4" "LI2" "PO2"]
by auto

(* po redu: 7667*)
(*7667*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 7668*)
(*7668*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO4` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO4 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO4" "PL1" "PL2"]
by auto

(* po redu: 7669*)
(*7669*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7670*)
(*7670*)  (*BRANCH NAME*)
} note note1917 = this
(* po redu: 7671*)
(*7671*)  
(*BRANCH END*)
from note1916 and note1917 and `PO1 = PO4 \<or> PO1 ~= PO4`
have False
by auto
(* po redu: 7672*)
(*7672*)  (*BRANCH NAME*)
} note note1918 = this
(* po redu: 7673*)
(*7673*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 7674*)
(*7674*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2"
using ax_g4 [of "PO3" "LI2"]
by auto

(* po redu: 7675*)
(*7675*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI2"
(* po redu: 7676*)
(*7676*)  (*REGULAR*)
moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO3 PO2"
using ax_D1a [of "PO1" "PO3" "LI2" "PO2"]
by auto

(* po redu: 7677*)
(*7677*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_132 [of "PO1" "PO3" "PO2"]
by auto

(* po redu: 7678*)
(*7678*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3`
have  "\<not>col PO1 PO3 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO3"]
by auto

(* po redu: 7679*)
(*7679*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO3`
have  "col PO1 PO3 PO2"
using ax_col_132 [of "PO1" "PO2" "PO3"]
by auto

(* po redu: 7680*)
(*7680*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2` and `col PO1 PO3 PO2`
have False
by auto

(* po redu: 7681*)
(*7681*)  (*BRANCH NAME*)
} note note1919 = this
(* po redu: 7682*)
(*7682*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI2"
(* po redu: 7683*)
(*7683*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

(* po redu: 7684*)
(*7684*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

(* po redu: 7685*)
(*7685*)  (*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

(* po redu: 7686*)
(*7686*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL1"
using ax_D11 [of "LI2" "PL1" "PO4"]
by auto

(* po redu: 7687*)
(*7687*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(* po redu: 7688*)
(*7688*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(* po redu: 7689*)
(*7689*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

(* po redu: 7690*)
(*7690*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(* po redu: 7691*)
(*7691*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 7692*)
(*7692*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO4"]
by auto

(* po redu: 7693*)
(*7693*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 7694*)
(*7694*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 7695*)
(*7695*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 7696*)
(*7696*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7697*)
(*7697*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

(* po redu: 7698*)
(*7698*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO4"]
by auto

(* po redu: 7699*)
(*7699*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

(* po redu: 7700*)
(*7700*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 7701*)
(*7701*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 7702*)
(*7702*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7703*)
(*7703*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

(* po redu: 7704*)
(*7704*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

(* po redu: 7705*)
(*7705*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7706*)
(*7706*)  (*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

(* po redu: 7707*)
(*7707*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL2"
using ax_D11 [of "LI2" "PL2" "PO4"]
by auto

(* po redu: 7708*)
(*7708*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 7709*)
(*7709*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 7710*)
(*7710*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

(* po redu: 7711*)
(*7711*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

(* po redu: 7712*)
(*7712*)  (*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

(* po redu: 7713*)
(*7713*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 7714*)
(*7714*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 7715*)
(*7715*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 7716*)
(*7716*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 7717*)
(*7717*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL1"
using ax_D11 [of "LI2" "PL1" "PO5"]
by auto

(* po redu: 7718*)
(*7718*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

(* po redu: 7719*)
(*7719*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO5"]
by auto

(* po redu: 7720*)
(*7720*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO5"]
by auto

(* po redu: 7721*)
(*7721*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

(* po redu: 7722*)
(*7722*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO5"]
by auto

(* po redu: 7723*)
(*7723*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO5"]
by auto

(* po redu: 7724*)
(*7724*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO5" "PO5"]
by auto

(* po redu: 7725*)
(*7725*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 7726*)
(*7726*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 7727*)
(*7727*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7728*)
(*7728*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO2 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO5"]
by auto

(* po redu: 7729*)
(*7729*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO3 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO5"]
by auto

(* po redu: 7730*)
(*7730*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO5" "PO5"]
by auto

(* po redu: 7731*)
(*7731*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO3 PO3 PO5"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 7732*)
(*7732*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO3 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 7733*)
(*7733*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO5 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7734*)
(*7734*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO3 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO5"]
by auto

(* po redu: 7735*)
(*7735*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO5" "PO5"]
by auto

(* po redu: 7736*)
(*7736*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO5 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7737*)
(*7737*)  (*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

(* po redu: 7738*)
(*7738*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL2"
using ax_D11 [of "LI2" "PL2" "PO5"]
by auto

(* po redu: 7739*)
(*7739*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 7740*)
(*7740*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO5 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO5" "PL1" "PL2"]
by auto

(* po redu: 7741*)
(*7741*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7742*)
(*7742*)  (*BRANCH NAME*)
} note note1920 = this
(* po redu: 7743*)
(*7743*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 7744*)
(*7744*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO4 PO2"
using ax_D1a [of "PO1" "PO4" "LI2" "PO2"]
by auto

(* po redu: 7745*)
(*7745*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO4 PO3"
using ax_D1a [of "PO1" "PO4" "LI2" "PO3"]
by auto

(* po redu: 7746*)
(*7746*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 7747*)
(*7747*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO4` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO4 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO4" "PL1" "PL2"]
by auto

(* po redu: 7748*)
(*7748*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7749*)
(*7749*)  (*BRANCH NAME*)
} note note1921 = this
(* po redu: 7750*)
(*7750*)  
(*BRANCH END*)
from note1920 and note1921 and `PO1 = PO4 \<or> PO1 ~= PO4`
have False
by auto
(* po redu: 7751*)
(*7751*)  (*BRANCH NAME*)
} note note1922 = this
(* po redu: 7752*)
(*7752*)  
(*BRANCH END*)
from note1919 and note1922 and `inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2`
have False
by auto
(* po redu: 7753*)
(*7753*)  (*BRANCH NAME*)
} note note1923 = this
(* po redu: 7754*)
(*7754*)  
(*BRANCH END*)
from note1918 and note1923 and `PO1 = PO3 \<or> PO1 ~= PO3`
have False
by auto
(* po redu: 7755*)
(*7755*)  (*BRANCH NAME*)
} note note1924 = this
(* po redu: 7756*)
(*7756*)  
(*BRANCH END*)
from note1915 and note1924 and `inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2`
have False
by auto
(* po redu: 7757*)
(*7757*)  (*BRANCH NAME*)
} note note1925 = this
(* po redu: 7758*)
(*7758*)  
(*BRANCH END*)
from note1914 and note1925 and `PO1 = PO2 \<or> PO1 ~= PO2`
have False
by auto
(* po redu: 7759*)
(*7759*)  (*BRANCH NAME*)
} note note1926 = this
(* po redu: 7760*)
(*7760*)  
(*BRANCH END*)
from note1909 and note1926 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7761*)
(*7761*)  (*BRANCH NAME*)
} note note1927 = this
(* po redu: 7762*)
(*7762*)  
(*BRANCH END*)
from note1908 and note1927 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7763*)
(*7763*)  (*BRANCH NAME*)
} note note1928 = this
(* po redu: 7764*)
(*7764*)  
(*BRANCH END*)
from note1905 and note1928 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7765*)
(*7765*)  (*BRANCH NAME*)
} note note1929 = this
(* po redu: 7766*)
(*7766*)  
(*BRANCH END*)
from note1898 and note1929 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 7767*)
(*7767*)  (*BRANCH NAME*)
} note note1930 = this
(* po redu: 7768*)
(*7768*)  
(*BRANCH END*)
from note1883 and note1930 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 7769*)
(*7769*)  (*BRANCH NAME*)
} note note1931 = this
(* po redu: 7770*)
(*7770*)  
(*BRANCH END*)
from note1852 and note1931 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
(* po redu: 7771*)
(*7771*)  (*BRANCH NAME*)
} note note1932 = this
(* po redu: 7772*)
(*7772*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 7773*)
(*7773*)  (*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

(* po redu: 7774*)
(*7774*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
(* po redu: 7775*)
(*7775*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 7776*)
(*7776*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 7777*)
(*7777*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 7778*)
(*7778*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 7779*)
(*7779*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7780*)
(*7780*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7781*)
(*7781*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7782*)
(*7782*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7783*)
(*7783*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7784*)
(*7784*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7785*)
(*7785*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7786*)
(*7786*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7787*)
(*7787*)  (*BRANCH NAME*)
} note note1933 = this
(* po redu: 7788*)
(*7788*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7789*)
(*7789*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7790*)
(*7790*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7791*)
(*7791*)  (*BRANCH NAME*)
} note note1934 = this
(* po redu: 7792*)
(*7792*)  
(*BRANCH END*)
from note1933 and note1934 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7793*)
(*7793*)  (*BRANCH NAME*)
} note note1935 = this
(* po redu: 7794*)
(*7794*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7795*)
(*7795*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7796*)
(*7796*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7797*)
(*7797*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7798*)
(*7798*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7799*)
(*7799*)  (*BRANCH NAME*)
} note note1936 = this
(* po redu: 7800*)
(*7800*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7801*)
(*7801*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7802*)
(*7802*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7803*)
(*7803*)  (*BRANCH NAME*)
} note note1937 = this
(* po redu: 7804*)
(*7804*)  
(*BRANCH END*)
from note1936 and note1937 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7805*)
(*7805*)  (*BRANCH NAME*)
} note note1938 = this
(* po redu: 7806*)
(*7806*)  
(*BRANCH END*)
from note1935 and note1938 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7807*)
(*7807*)  (*BRANCH NAME*)
} note note1939 = this
(* po redu: 7808*)
(*7808*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7809*)
(*7809*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7810*)
(*7810*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7811*)
(*7811*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7812*)
(*7812*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7813*)
(*7813*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7814*)
(*7814*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7815*)
(*7815*)  (*BRANCH NAME*)
} note note1940 = this
(* po redu: 7816*)
(*7816*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7817*)
(*7817*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7818*)
(*7818*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7819*)
(*7819*)  (*BRANCH NAME*)
} note note1941 = this
(* po redu: 7820*)
(*7820*)  
(*BRANCH END*)
from note1940 and note1941 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7821*)
(*7821*)  (*BRANCH NAME*)
} note note1942 = this
(* po redu: 7822*)
(*7822*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7823*)
(*7823*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7824*)
(*7824*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7825*)
(*7825*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7826*)
(*7826*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7827*)
(*7827*)  (*BRANCH NAME*)
} note note1943 = this
(* po redu: 7828*)
(*7828*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7829*)
(*7829*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7830*)
(*7830*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7831*)
(*7831*)  (*BRANCH NAME*)
} note note1944 = this
(* po redu: 7832*)
(*7832*)  
(*BRANCH END*)
from note1943 and note1944 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7833*)
(*7833*)  (*BRANCH NAME*)
} note note1945 = this
(* po redu: 7834*)
(*7834*)  
(*BRANCH END*)
from note1942 and note1945 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7835*)
(*7835*)  (*BRANCH NAME*)
} note note1946 = this
(* po redu: 7836*)
(*7836*)  
(*BRANCH END*)
from note1939 and note1946 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7837*)
(*7837*)  (*BRANCH NAME*)
} note note1947 = this
(* po redu: 7838*)
(*7838*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 7839*)
(*7839*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7840*)
(*7840*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7841*)
(*7841*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7842*)
(*7842*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7843*)
(*7843*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7844*)
(*7844*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7845*)
(*7845*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7846*)
(*7846*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7847*)
(*7847*)  (*BRANCH NAME*)
} note note1948 = this
(* po redu: 7848*)
(*7848*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7849*)
(*7849*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7850*)
(*7850*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7851*)
(*7851*)  (*BRANCH NAME*)
} note note1949 = this
(* po redu: 7852*)
(*7852*)  
(*BRANCH END*)
from note1948 and note1949 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7853*)
(*7853*)  (*BRANCH NAME*)
} note note1950 = this
(* po redu: 7854*)
(*7854*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7855*)
(*7855*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7856*)
(*7856*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7857*)
(*7857*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7858*)
(*7858*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7859*)
(*7859*)  (*BRANCH NAME*)
} note note1951 = this
(* po redu: 7860*)
(*7860*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7861*)
(*7861*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7862*)
(*7862*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7863*)
(*7863*)  (*BRANCH NAME*)
} note note1952 = this
(* po redu: 7864*)
(*7864*)  
(*BRANCH END*)
from note1951 and note1952 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7865*)
(*7865*)  (*BRANCH NAME*)
} note note1953 = this
(* po redu: 7866*)
(*7866*)  
(*BRANCH END*)
from note1950 and note1953 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7867*)
(*7867*)  (*BRANCH NAME*)
} note note1954 = this
(* po redu: 7868*)
(*7868*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7869*)
(*7869*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7870*)
(*7870*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7871*)
(*7871*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7872*)
(*7872*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7873*)
(*7873*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7874*)
(*7874*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7875*)
(*7875*)  (*BRANCH NAME*)
} note note1955 = this
(* po redu: 7876*)
(*7876*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7877*)
(*7877*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7878*)
(*7878*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7879*)
(*7879*)  (*BRANCH NAME*)
} note note1956 = this
(* po redu: 7880*)
(*7880*)  
(*BRANCH END*)
from note1955 and note1956 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7881*)
(*7881*)  (*BRANCH NAME*)
} note note1957 = this
(* po redu: 7882*)
(*7882*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7883*)
(*7883*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7884*)
(*7884*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7885*)
(*7885*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7886*)
(*7886*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7887*)
(*7887*)  (*BRANCH NAME*)
} note note1958 = this
(* po redu: 7888*)
(*7888*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7889*)
(*7889*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7890*)
(*7890*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7891*)
(*7891*)  (*BRANCH NAME*)
} note note1959 = this
(* po redu: 7892*)
(*7892*)  
(*BRANCH END*)
from note1958 and note1959 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7893*)
(*7893*)  (*BRANCH NAME*)
} note note1960 = this
(* po redu: 7894*)
(*7894*)  
(*BRANCH END*)
from note1957 and note1960 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7895*)
(*7895*)  (*BRANCH NAME*)
} note note1961 = this
(* po redu: 7896*)
(*7896*)  
(*BRANCH END*)
from note1954 and note1961 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7897*)
(*7897*)  (*BRANCH NAME*)
} note note1962 = this
(* po redu: 7898*)
(*7898*)  
(*BRANCH END*)
from note1947 and note1962 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 7899*)
(*7899*)  (*BRANCH NAME*)
} note note1963 = this
(* po redu: 7900*)
(*7900*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 7901*)
(*7901*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 7902*)
(*7902*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 7903*)
(*7903*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7904*)
(*7904*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7905*)
(*7905*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7906*)
(*7906*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7907*)
(*7907*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7908*)
(*7908*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7909*)
(*7909*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7910*)
(*7910*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7911*)
(*7911*)  (*BRANCH NAME*)
} note note1964 = this
(* po redu: 7912*)
(*7912*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7913*)
(*7913*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7914*)
(*7914*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7915*)
(*7915*)  (*BRANCH NAME*)
} note note1965 = this
(* po redu: 7916*)
(*7916*)  
(*BRANCH END*)
from note1964 and note1965 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7917*)
(*7917*)  (*BRANCH NAME*)
} note note1966 = this
(* po redu: 7918*)
(*7918*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7919*)
(*7919*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7920*)
(*7920*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7921*)
(*7921*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7922*)
(*7922*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7923*)
(*7923*)  (*BRANCH NAME*)
} note note1967 = this
(* po redu: 7924*)
(*7924*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7925*)
(*7925*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7926*)
(*7926*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7927*)
(*7927*)  (*BRANCH NAME*)
} note note1968 = this
(* po redu: 7928*)
(*7928*)  
(*BRANCH END*)
from note1967 and note1968 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7929*)
(*7929*)  (*BRANCH NAME*)
} note note1969 = this
(* po redu: 7930*)
(*7930*)  
(*BRANCH END*)
from note1966 and note1969 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7931*)
(*7931*)  (*BRANCH NAME*)
} note note1970 = this
(* po redu: 7932*)
(*7932*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7933*)
(*7933*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7934*)
(*7934*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7935*)
(*7935*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7936*)
(*7936*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7937*)
(*7937*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7938*)
(*7938*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7939*)
(*7939*)  (*BRANCH NAME*)
} note note1971 = this
(* po redu: 7940*)
(*7940*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7941*)
(*7941*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7942*)
(*7942*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7943*)
(*7943*)  (*BRANCH NAME*)
} note note1972 = this
(* po redu: 7944*)
(*7944*)  
(*BRANCH END*)
from note1971 and note1972 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7945*)
(*7945*)  (*BRANCH NAME*)
} note note1973 = this
(* po redu: 7946*)
(*7946*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7947*)
(*7947*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7948*)
(*7948*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7949*)
(*7949*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7950*)
(*7950*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7951*)
(*7951*)  (*BRANCH NAME*)
} note note1974 = this
(* po redu: 7952*)
(*7952*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7953*)
(*7953*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7954*)
(*7954*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7955*)
(*7955*)  (*BRANCH NAME*)
} note note1975 = this
(* po redu: 7956*)
(*7956*)  
(*BRANCH END*)
from note1974 and note1975 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7957*)
(*7957*)  (*BRANCH NAME*)
} note note1976 = this
(* po redu: 7958*)
(*7958*)  
(*BRANCH END*)
from note1973 and note1976 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7959*)
(*7959*)  (*BRANCH NAME*)
} note note1977 = this
(* po redu: 7960*)
(*7960*)  
(*BRANCH END*)
from note1970 and note1977 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 7961*)
(*7961*)  (*BRANCH NAME*)
} note note1978 = this
(* po redu: 7962*)
(*7962*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 7963*)
(*7963*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 7964*)
(*7964*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 7965*)
(*7965*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7966*)
(*7966*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7967*)
(*7967*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7968*)
(*7968*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7969*)
(*7969*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7970*)
(*7970*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7971*)
(*7971*)  (*BRANCH NAME*)
} note note1979 = this
(* po redu: 7972*)
(*7972*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7973*)
(*7973*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7974*)
(*7974*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7975*)
(*7975*)  (*BRANCH NAME*)
} note note1980 = this
(* po redu: 7976*)
(*7976*)  
(*BRANCH END*)
from note1979 and note1980 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7977*)
(*7977*)  (*BRANCH NAME*)
} note note1981 = this
(* po redu: 7978*)
(*7978*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 7979*)
(*7979*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7980*)
(*7980*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7981*)
(*7981*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7982*)
(*7982*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7983*)
(*7983*)  (*BRANCH NAME*)
} note note1982 = this
(* po redu: 7984*)
(*7984*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7985*)
(*7985*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 7986*)
(*7986*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 7987*)
(*7987*)  (*BRANCH NAME*)
} note note1983 = this
(* po redu: 7988*)
(*7988*)  
(*BRANCH END*)
from note1982 and note1983 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7989*)
(*7989*)  (*BRANCH NAME*)
} note note1984 = this
(* po redu: 7990*)
(*7990*)  
(*BRANCH END*)
from note1981 and note1984 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 7991*)
(*7991*)  (*BRANCH NAME*)
} note note1985 = this
(* po redu: 7992*)
(*7992*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 7993*)
(*7993*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 7994*)
(*7994*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 7995*)
(*7995*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7996*)
(*7996*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7997*)
(*7997*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7998*)
(*7998*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7999*)
(*7999*)  (*BRANCH NAME*)
} note note1986 = this
(* po redu: 8000*)
(*8000*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8001*)
(*8001*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8002*)
(*8002*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8003*)
(*8003*)  (*BRANCH NAME*)
} note note1987 = this
(* po redu: 8004*)
(*8004*)  
(*BRANCH END*)
from note1986 and note1987 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8005*)
(*8005*)  (*BRANCH NAME*)
} note note1988 = this
(* po redu: 8006*)
(*8006*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8007*)
(*8007*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8008*)
(*8008*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8009*)
(*8009*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 8010*)
(*8010*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 8011*)
(*8011*)  (*BRANCH NAME*)
} note note1989 = this
(* po redu: 8012*)
(*8012*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8013*)
(*8013*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8014*)
(*8014*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8015*)
(*8015*)  (*BRANCH NAME*)
} note note1990 = this
(* po redu: 8016*)
(*8016*)  
(*BRANCH END*)
from note1989 and note1990 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8017*)
(*8017*)  (*BRANCH NAME*)
} note note1991 = this
(* po redu: 8018*)
(*8018*)  
(*BRANCH END*)
from note1988 and note1991 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 8019*)
(*8019*)  (*BRANCH NAME*)
} note note1992 = this
(* po redu: 8020*)
(*8020*)  
(*BRANCH END*)
from note1985 and note1992 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 8021*)
(*8021*)  (*BRANCH NAME*)
} note note1993 = this
(* po redu: 8022*)
(*8022*)  
(*BRANCH END*)
from note1978 and note1993 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
(* po redu: 8023*)
(*8023*)  (*BRANCH NAME*)
} note note1994 = this
(* po redu: 8024*)
(*8024*)  
(*BRANCH END*)
from note1963 and note1994 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 8025*)
(*8025*)  (*BRANCH NAME*)
} note note1995 = this
(* po redu: 8026*)
(*8026*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
(* po redu: 8027*)
(*8027*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 8028*)
(*8028*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 8029*)
(*8029*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 8030*)
(*8030*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 8031*)
(*8031*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 8032*)
(*8032*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 8033*)
(*8033*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 8034*)
(*8034*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 8035*)
(*8035*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8036*)
(*8036*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8037*)
(*8037*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1996 = this
(* po redu: 8038*)
(*8038*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8039*)
(*8039*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8040*)
(*8040*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8041*)
(*8041*)  (*BRANCH NAME*)
} note note1997 = this
(* po redu: 8042*)
(*8042*)  
(*BRANCH END*)
from note1996 and note1997 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 8043*)
(*8043*)  (*BRANCH NAME*)
} note note1998 = this
(* po redu: 8044*)
(*8044*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8045*)
(*8045*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8046*)
(*8046*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8047*)
(*8047*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8048*)
(*8048*)  (*BRANCH NAME*)
} note note1999 = this
(* po redu: 8049*)
(*8049*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8050*)
(*8050*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8051*)
(*8051*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8052*)
(*8052*)  (*BRANCH NAME*)
} note note2000 = this
(* po redu: 8053*)
(*8053*)  
(*BRANCH END*)
from note1999 and note2000 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8054*)
(*8054*)  (*BRANCH NAME*)
} note note2001 = this
(* po redu: 8055*)
(*8055*)  
(*BRANCH END*)
from note1998 and note2001 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 8056*)
(*8056*)  (*BRANCH NAME*)
} note note2002 = this
(* po redu: 8057*)
(*8057*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 8058*)
(*8058*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 8059*)
(*8059*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 8060*)
(*8060*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8061*)
(*8061*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8062*)
(*8062*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8063*)
(*8063*)  (*BRANCH NAME*)
} note note2003 = this
(* po redu: 8064*)
(*8064*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8065*)
(*8065*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8066*)
(*8066*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8067*)
(*8067*)  (*BRANCH NAME*)
} note note2004 = this
(* po redu: 8068*)
(*8068*)  
(*BRANCH END*)
from note2003 and note2004 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8069*)
(*8069*)  (*BRANCH NAME*)
} note note2005 = this
(* po redu: 8070*)
(*8070*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8071*)
(*8071*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8072*)
(*8072*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8073*)
(*8073*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note2006 = this
(* po redu: 8074*)
(*8074*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8075*)
(*8075*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8076*)
(*8076*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8077*)
(*8077*)  (*BRANCH NAME*)
} note note2007 = this
(* po redu: 8078*)
(*8078*)  
(*BRANCH END*)
from note2006 and note2007 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 8079*)
(*8079*)  (*BRANCH NAME*)
} note note2008 = this
(* po redu: 8080*)
(*8080*)  
(*BRANCH END*)
from note2005 and note2008 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 8081*)
(*8081*)  (*BRANCH NAME*)
} note note2009 = this
(* po redu: 8082*)
(*8082*)  
(*BRANCH END*)
from note2002 and note2009 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 8083*)
(*8083*)  (*BRANCH NAME*)
} note note2010 = this
(* po redu: 8084*)
(*8084*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 8085*)
(*8085*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 8086*)
(*8086*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 8087*)
(*8087*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 8088*)
(*8088*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 8089*)
(*8089*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8090*)
(*8090*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8091*)
(*8091*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8092*)
(*8092*)  (*BRANCH NAME*)
} note note2011 = this
(* po redu: 8093*)
(*8093*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8094*)
(*8094*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8095*)
(*8095*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8096*)
(*8096*)  (*BRANCH NAME*)
} note note2012 = this
(* po redu: 8097*)
(*8097*)  
(*BRANCH END*)
from note2011 and note2012 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8098*)
(*8098*)  (*BRANCH NAME*)
} note note2013 = this
(* po redu: 8099*)
(*8099*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8100*)
(*8100*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8101*)
(*8101*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8102*)
(*8102*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8103*)
(*8103*)  (*BRANCH NAME*)
} note note2014 = this
(* po redu: 8104*)
(*8104*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8105*)
(*8105*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8106*)
(*8106*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8107*)
(*8107*)  (*BRANCH NAME*)
} note note2015 = this
(* po redu: 8108*)
(*8108*)  
(*BRANCH END*)
from note2014 and note2015 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8109*)
(*8109*)  (*BRANCH NAME*)
} note note2016 = this
(* po redu: 8110*)
(*8110*)  
(*BRANCH END*)
from note2013 and note2016 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 8111*)
(*8111*)  (*BRANCH NAME*)
} note note2017 = this
(* po redu: 8112*)
(*8112*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 8113*)
(*8113*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 8114*)
(*8114*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 8115*)
(*8115*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8116*)
(*8116*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8117*)
(*8117*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8118*)
(*8118*)  (*BRANCH NAME*)
} note note2018 = this
(* po redu: 8119*)
(*8119*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8120*)
(*8120*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8121*)
(*8121*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8122*)
(*8122*)  (*BRANCH NAME*)
} note note2019 = this
(* po redu: 8123*)
(*8123*)  
(*BRANCH END*)
from note2018 and note2019 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8124*)
(*8124*)  (*BRANCH NAME*)
} note note2020 = this
(* po redu: 8125*)
(*8125*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8126*)
(*8126*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8127*)
(*8127*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8128*)
(*8128*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8129*)
(*8129*)  (*BRANCH NAME*)
} note note2021 = this
(* po redu: 8130*)
(*8130*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8131*)
(*8131*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8132*)
(*8132*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8133*)
(*8133*)  (*BRANCH NAME*)
} note note2022 = this
(* po redu: 8134*)
(*8134*)  
(*BRANCH END*)
from note2021 and note2022 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8135*)
(*8135*)  (*BRANCH NAME*)
} note note2023 = this
(* po redu: 8136*)
(*8136*)  
(*BRANCH END*)
from note2020 and note2023 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 8137*)
(*8137*)  (*BRANCH NAME*)
} note note2024 = this
(* po redu: 8138*)
(*8138*)  
(*BRANCH END*)
from note2017 and note2024 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 8139*)
(*8139*)  (*BRANCH NAME*)
} note note2025 = this
(* po redu: 8140*)
(*8140*)  
(*BRANCH END*)
from note2010 and note2025 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 8141*)
(*8141*)  (*BRANCH NAME*)
} note note2026 = this
(* po redu: 8142*)
(*8142*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 8143*)
(*8143*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

(* po redu: 8144*)
(*8144*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
(* po redu: 8145*)
(*8145*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 8146*)
(*8146*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 8147*)
(*8147*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 8148*)
(*8148*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 8149*)
(*8149*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8150*)
(*8150*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8151*)
(*8151*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8152*)
(*8152*)  (*BRANCH NAME*)
} note note2027 = this
(* po redu: 8153*)
(*8153*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8154*)
(*8154*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8155*)
(*8155*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8156*)
(*8156*)  (*BRANCH NAME*)
} note note2028 = this
(* po redu: 8157*)
(*8157*)  
(*BRANCH END*)
from note2027 and note2028 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8158*)
(*8158*)  (*BRANCH NAME*)
} note note2029 = this
(* po redu: 8159*)
(*8159*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8160*)
(*8160*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8161*)
(*8161*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8162*)
(*8162*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8163*)
(*8163*)  (*BRANCH NAME*)
} note note2030 = this
(* po redu: 8164*)
(*8164*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8165*)
(*8165*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8166*)
(*8166*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8167*)
(*8167*)  (*BRANCH NAME*)
} note note2031 = this
(* po redu: 8168*)
(*8168*)  
(*BRANCH END*)
from note2030 and note2031 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8169*)
(*8169*)  (*BRANCH NAME*)
} note note2032 = this
(* po redu: 8170*)
(*8170*)  
(*BRANCH END*)
from note2029 and note2032 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 8171*)
(*8171*)  (*BRANCH NAME*)
} note note2033 = this
(* po redu: 8172*)
(*8172*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 8173*)
(*8173*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 8174*)
(*8174*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 8175*)
(*8175*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8176*)
(*8176*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8177*)
(*8177*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8178*)
(*8178*)  (*BRANCH NAME*)
} note note2034 = this
(* po redu: 8179*)
(*8179*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8180*)
(*8180*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8181*)
(*8181*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8182*)
(*8182*)  (*BRANCH NAME*)
} note note2035 = this
(* po redu: 8183*)
(*8183*)  
(*BRANCH END*)
from note2034 and note2035 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8184*)
(*8184*)  (*BRANCH NAME*)
} note note2036 = this
(* po redu: 8185*)
(*8185*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8186*)
(*8186*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8187*)
(*8187*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8188*)
(*8188*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8189*)
(*8189*)  (*BRANCH NAME*)
} note note2037 = this
(* po redu: 8190*)
(*8190*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8191*)
(*8191*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8192*)
(*8192*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8193*)
(*8193*)  (*BRANCH NAME*)
} note note2038 = this
(* po redu: 8194*)
(*8194*)  
(*BRANCH END*)
from note2037 and note2038 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8195*)
(*8195*)  (*BRANCH NAME*)
} note note2039 = this
(* po redu: 8196*)
(*8196*)  
(*BRANCH END*)
from note2036 and note2039 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
(* po redu: 8197*)
(*8197*)  (*BRANCH NAME*)
} note note2040 = this
(* po redu: 8198*)
(*8198*)  
(*BRANCH END*)
from note2033 and note2040 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
(* po redu: 8199*)
(*8199*)  (*BRANCH NAME*)
} note note2041 = this
(* po redu: 8200*)
(*8200*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
(* po redu: 8201*)
(*8201*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 8202*)
(*8202*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 8203*)
(*8203*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 8204*)
(*8204*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 8205*)
(*8205*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8206*)
(*8206*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8207*)
(*8207*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note2042 = this
(* po redu: 8208*)
(*8208*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8209*)
(*8209*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8210*)
(*8210*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8211*)
(*8211*)  (*BRANCH NAME*)
} note note2043 = this
(* po redu: 8212*)
(*8212*)  
(*BRANCH END*)
from note2042 and note2043 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 8213*)
(*8213*)  (*BRANCH NAME*)
} note note2044 = this
(* po redu: 8214*)
(*8214*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8215*)
(*8215*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8216*)
(*8216*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8217*)
(*8217*)  (*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8218*)
(*8218*)  (*BRANCH NAME*)
} note note2045 = this
(* po redu: 8219*)
(*8219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8220*)
(*8220*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8221*)
(*8221*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8222*)
(*8222*)  (*BRANCH NAME*)
} note note2046 = this
(* po redu: 8223*)
(*8223*)  
(*BRANCH END*)
from note2045 and note2046 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8224*)
(*8224*)  (*BRANCH NAME*)
} note note2047 = this
(* po redu: 8225*)
(*8225*)  
(*BRANCH END*)
from note2044 and note2047 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 8226*)
(*8226*)  (*BRANCH NAME*)
} note note2048 = this
(* po redu: 8227*)
(*8227*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 8228*)
(*8228*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

(* po redu: 8229*)
(*8229*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
(* po redu: 8230*)
(*8230*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8231*)
(*8231*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8232*)
(*8232*)  (*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

(* po redu: 8233*)
(*8233*)  (*BRANCH NAME*)
} note note2049 = this
(* po redu: 8234*)
(*8234*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8235*)
(*8235*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8236*)
(*8236*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8237*)
(*8237*)  (*BRANCH NAME*)
} note note2050 = this
(* po redu: 8238*)
(*8238*)  
(*BRANCH END*)
from note2049 and note2050 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 8239*)
(*8239*)  (*BRANCH NAME*)
} note note2051 = this
(* po redu: 8240*)
(*8240*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
(* po redu: 8241*)
(*8241*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 8242*)
(*8242*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 8243*)
(*8243*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note2052 = this
(* po redu: 8244*)
(*8244*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 8245*)
(*8245*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 8246*)
(*8246*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 8247*)
(*8247*)  (*BRANCH NAME*)
} note note2053 = this
(* po redu: 8248*)
(*8248*)  
(*BRANCH END*)
from note2052 and note2053 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 8249*)
(*8249*)  (*BRANCH NAME*)
} note note2054 = this
(* po redu: 8250*)
(*8250*)  
(*BRANCH END*)
from note2051 and note2054 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
(* po redu: 8251*)
(*8251*)  (*BRANCH NAME*)
} note note2055 = this
(* po redu: 8252*)
(*8252*)  
(*BRANCH END*)
from note2048 and note2055 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 8253*)
(*8253*)  (*BRANCH NAME*)
} note note2056 = this
(* po redu: 8254*)
(*8254*)  
(*BRANCH END*)
from note2041 and note2056 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
(* po redu: 8255*)
(*8255*)  (*BRANCH NAME*)
} note note2057 = this
(* po redu: 8256*)
(*8256*)  
(*BRANCH END*)
from note2026 and note2057 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 8257*)
(*8257*)  (*BRANCH NAME*)
} note note2058 = this
(* po redu: 8258*)
(*8258*)  
(*BRANCH END*)
from note1995 and note2058 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
(* po redu: 8259*)
(*8259*)  (*BRANCH NAME*)
} note note2059 = this
(* po redu: 8260*)
(*8260*)  
(*BRANCH END*)
from note1932 and note2059 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 8261*)
(*8261*)  (*BRANCH NAME*)
} note note2060 = this
(* po redu: 8262*)
(*8262*)  
(*BRANCH END*)
from note1789 and note2060 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 8263*)
(*8263*)  (*BRANCH NAME*)
} note note2061 = this
(* po redu: 8264*)
(*8264*)  
(*BRANCH END*)
from note1534 and note2061 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have ?thesis
by auto
(* po redu: 8265*)
(*8265*)  (*BRANCH NAME*)
} note note2062 = this
(* po redu: 8266*)
(*8266*)  
(*BRANCH END*)
from note1023 and note2062 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
