theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma  th9:
assumes "comp PO1 PO2 PO3 PO4"
and "\<not>col PO1 PO2 PO3"
and "inc_po_pl PO1 PL1"
and "inc_po_pl PO2 PL1"
and "inc_po_pl PO3 PL1"
shows " (inc_po_pl PO4 PL1)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 2*)
(*2*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(* po redu: 3*)
(*3*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(* po redu: 4*)
(*4*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(* po redu: 5*)
(*5*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(* po redu: 6*)
(*6*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(* po redu: 7*)
(*7*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 8*)
(*8*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 9*)
(*9*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 10*)
(*10*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 11*)
(*11*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(* po redu: 12*)
(*12*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(* po redu: 13*)
(*13*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(* po redu: 14*)
(*14*)  (*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 15*)
(*15*)  (*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

(* po redu: 16*)
(*16*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 17*)
(*17*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 18*)
(*18*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 19*)
(*19*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 20*)
(*20*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 21*)
(*21*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 22*)
(*22*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 23*)
(*23*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 24*)
(*24*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 25*)
(*25*)  (*BRANCH NAME*)
} note note1 = this
(* po redu: 26*)
(*26*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 27*)
(*27*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 28*)
(*28*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 29*)
(*29*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note2 = this
(* po redu: 30*)
(*30*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 31*)
(*31*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 32*)
(*32*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO1 PO4"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO4"]
by auto

(* po redu: 33*)
(*33*)  (*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2` and `PO1 = PO3`
have "comp PO1 PO1 PO1 PO4"
by auto

(* po redu: 34*)
(*34*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO1 PO4` and `comp PO1 PO1 PO1 PO4`
have False
by auto

(* po redu: 35*)
(*35*)  (*BRANCH NAME*)
} note note3 = this
(* po redu: 36*)
(*36*)  
(*BRANCH END*)
from note2 and note3 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 37*)
(*37*)  (*BRANCH NAME*)
} note note4 = this
(* po redu: 38*)
(*38*)  
(*BRANCH END*)
from note1 and note4 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 39*)
(*39*)  (*BRANCH NAME*)
} note note5 = this
(* po redu: 40*)
(*40*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 41*)
(*41*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 42*)
(*42*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 43*)
(*43*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 44*)
(*44*)  (*BRANCH NAME*)
} note note6 = this
(* po redu: 45*)
(*45*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 46*)
(*46*)  (*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(* po redu: 47*)
(*47*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
(* po redu: 48*)
(*48*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO3 PL1` and `PO3 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 49*)
(*49*)  (*BRANCH NAME*)
} note note7 = this
(* po redu: 50*)
(*50*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
(* po redu: 51*)
(*51*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 52*)
(*52*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 53*)
(*53*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note8 = this
(* po redu: 54*)
(*54*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 55*)
(*55*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(* po redu: 56*)
(*56*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO3 PO4"
using ax_D3a [of "PO1" "PO1" "PO3" "PL1" "PO4"]
by auto

(* po redu: 57*)
(*57*)  (*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2`
have "comp PO1 PO1 PO3 PO4"
by auto

(* po redu: 58*)
(*58*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO3 PO4` and `comp PO1 PO1 PO3 PO4`
have False
by auto

(* po redu: 59*)
(*59*)  (*BRANCH NAME*)
} note note9 = this
(* po redu: 60*)
(*60*)  
(*BRANCH END*)
from note8 and note9 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 61*)
(*61*)  (*BRANCH NAME*)
} note note10 = this
(* po redu: 62*)
(*62*)  
(*BRANCH END*)
from note7 and note10 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
(* po redu: 63*)
(*63*)  (*BRANCH NAME*)
} note note11 = this
(* po redu: 64*)
(*64*)  
(*BRANCH END*)
from note6 and note11 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 65*)
(*65*)  (*BRANCH NAME*)
} note note12 = this
(* po redu: 66*)
(*66*)  
(*BRANCH END*)
from note5 and note12 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 67*)
(*67*)  (*BRANCH NAME*)
} note note13 = this
(* po redu: 68*)
(*68*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 69*)
(*69*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 70*)
(*70*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 71*)
(*71*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 72*)
(*72*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 73*)
(*73*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 74*)
(*74*)  (*BRANCH NAME*)
} note note14 = this
(* po redu: 75*)
(*75*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 76*)
(*76*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 77*)
(*77*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 78*)
(*78*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 79*)
(*79*)  (*BRANCH NAME*)
} note note15 = this
(* po redu: 80*)
(*80*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 81*)
(*81*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 82*)
(*82*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 83*)
(*83*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note16 = this
(* po redu: 84*)
(*84*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 85*)
(*85*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(* po redu: 86*)
(*86*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO1`
have  "\<not>col PO1 PO1 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO1"]
by auto

(* po redu: 87*)
(*87*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO2 PO4"
using ax_D3a [of "PO1" "PO1" "PO2" "PL1" "PO4"]
by auto

(* po redu: 88*)
(*88*)  (*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3`
have "comp PO1 PO2 PO1 PO4"
by auto

(* po redu: 89*)
(*89*)  (*REGULAR*)
moreover
from `comp PO1 PO2 PO1 PO4`
have  "comp PO1 PO1 PO2 PO4"
using ax_comp_1324 [of "PO1" "PO2" "PO1" "PO4"]
by auto

(* po redu: 90*)
(*90*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO2 PO4` and `comp PO1 PO1 PO2 PO4`
have False
by auto

(* po redu: 91*)
(*91*)  (*BRANCH NAME*)
} note note17 = this
(* po redu: 92*)
(*92*)  
(*BRANCH END*)
from note16 and note17 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 93*)
(*93*)  (*BRANCH NAME*)
} note note18 = this
(* po redu: 94*)
(*94*)  
(*BRANCH END*)
from note15 and note18 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 95*)
(*95*)  (*BRANCH NAME*)
} note note19 = this
(* po redu: 96*)
(*96*)  
(*BRANCH END*)
from note14 and note19 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 97*)
(*97*)  (*BRANCH NAME*)
} note note20 = this
(* po redu: 98*)
(*98*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 99*)
(*99*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 100*)
(*100*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 101*)
(*101*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 102*)
(*102*)  (*BRANCH NAME*)
} note note21 = this
(* po redu: 103*)
(*103*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 104*)
(*104*)  (*REGULAR*)
moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(* po redu: 105*)
(*105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO3"
(* po redu: 106*)
(*106*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 107*)
(*107*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 108*)
(*108*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 109*)
(*109*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 110*)
(*110*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 111*)
(*111*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 112*)
(*112*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 113*)
(*113*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note23 = this
(* po redu: 114*)
(*114*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 115*)
(*115*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(* po redu: 116*)
(*116*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO2 PO2 PO4"
using ax_D3a [of "PO1" "PO2" "PO2" "PL1" "PO4"]
by auto

(* po redu: 117*)
(*117*)  (*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3`
have "comp PO1 PO2 PO2 PO4"
by auto

(* po redu: 118*)
(*118*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO2 PO2 PO4` and `comp PO1 PO2 PO2 PO4`
have False
by auto

(* po redu: 119*)
(*119*)  (*BRANCH NAME*)
} note note24 = this
(* po redu: 120*)
(*120*)  
(*BRANCH END*)
from note23 and note24 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 121*)
(*121*)  (*BRANCH NAME*)
} note note25 = this
(* po redu: 122*)
(*122*)  
(*BRANCH END*)
from note22 and note25 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 123*)
(*123*)  (*BRANCH NAME*)
} note note26 = this
(* po redu: 124*)
(*124*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO3"
(* po redu: 125*)
(*125*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 126*)
(*126*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 127*)
(*127*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 128*)
(*128*)  (*BRANCH NAME*)
} note note27 = this
(* po redu: 129*)
(*129*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 130*)
(*130*)  (*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(* po redu: 131*)
(*131*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
(* po redu: 132*)
(*132*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO3 PL1` and `PO3 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 133*)
(*133*)  (*BRANCH NAME*)
} note note28 = this
(* po redu: 134*)
(*134*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
(* po redu: 135*)
(*135*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 136*)
(*136*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 137*)
(*137*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note29 = this
(* po redu: 138*)
(*138*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 139*)
(*139*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO2 PO3 PO4"
using ax_D3a [of "PO1" "PO2" "PO3" "PL1" "PO4"]
by auto

(* po redu: 140*)
(*140*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO2 PO3 PO4` and `comp PO1 PO2 PO3 PO4`
have False
by auto

(* po redu: 141*)
(*141*)  (*BRANCH NAME*)
} note note30 = this
(* po redu: 142*)
(*142*)  
(*BRANCH END*)
from note29 and note30 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 143*)
(*143*)  (*BRANCH NAME*)
} note note31 = this
(* po redu: 144*)
(*144*)  
(*BRANCH END*)
from note28 and note31 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
(* po redu: 145*)
(*145*)  (*BRANCH NAME*)
} note note32 = this
(* po redu: 146*)
(*146*)  
(*BRANCH END*)
from note27 and note32 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 147*)
(*147*)  (*BRANCH NAME*)
} note note33 = this
(* po redu: 148*)
(*148*)  
(*BRANCH END*)
from note26 and note33 and `PO2 = PO3 \<or> PO2 ~= PO3`
have ?thesis
by auto
(* po redu: 149*)
(*149*)  (*BRANCH NAME*)
} note note34 = this
(* po redu: 150*)
(*150*)  
(*BRANCH END*)
from note21 and note34 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 151*)
(*151*)  (*BRANCH NAME*)
} note note35 = this
(* po redu: 152*)
(*152*)  
(*BRANCH END*)
from note20 and note35 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 153*)
(*153*)  (*BRANCH NAME*)
} note note36 = this
(* po redu: 154*)
(*154*)  
(*BRANCH END*)
from note13 and note36 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
(* po redu: 155*)
(*155*)  (*BRANCH NAME*)
} note note37 = this
(* po redu: 156*)
(*156*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 157*)
(*157*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 158*)
(*158*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 159*)
(*159*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 160*)
(*160*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 161*)
(*161*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 162*)
(*162*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 163*)
(*163*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 164*)
(*164*)  (*BRANCH NAME*)
} note note38 = this
(* po redu: 165*)
(*165*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 166*)
(*166*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 167*)
(*167*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 168*)
(*168*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note39 = this
(* po redu: 169*)
(*169*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 170*)
(*170*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 171*)
(*171*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO1 PO4"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO4"]
by auto

(* po redu: 172*)
(*172*)  (*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2` and `PO1 = PO3`
have "comp PO1 PO1 PO1 PO4"
by auto

(* po redu: 173*)
(*173*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO1 PO4` and `comp PO1 PO1 PO1 PO4`
have False
by auto

(* po redu: 174*)
(*174*)  (*BRANCH NAME*)
} note note40 = this
(* po redu: 175*)
(*175*)  
(*BRANCH END*)
from note39 and note40 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 176*)
(*176*)  (*BRANCH NAME*)
} note note41 = this
(* po redu: 177*)
(*177*)  
(*BRANCH END*)
from note38 and note41 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 178*)
(*178*)  (*BRANCH NAME*)
} note note42 = this
(* po redu: 179*)
(*179*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 180*)
(*180*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 181*)
(*181*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 182*)
(*182*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 183*)
(*183*)  (*BRANCH NAME*)
} note note43 = this
(* po redu: 184*)
(*184*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 185*)
(*185*)  (*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(* po redu: 186*)
(*186*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
(* po redu: 187*)
(*187*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO3 PL1` and `PO3 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 188*)
(*188*)  (*BRANCH NAME*)
} note note44 = this
(* po redu: 189*)
(*189*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
(* po redu: 190*)
(*190*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 191*)
(*191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 192*)
(*192*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note45 = this
(* po redu: 193*)
(*193*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 194*)
(*194*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(* po redu: 195*)
(*195*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO3 PO4"
using ax_D3a [of "PO1" "PO1" "PO3" "PL1" "PO4"]
by auto

(* po redu: 196*)
(*196*)  (*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2`
have "comp PO1 PO1 PO3 PO4"
by auto

(* po redu: 197*)
(*197*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO3 PO4` and `comp PO1 PO1 PO3 PO4`
have False
by auto

(* po redu: 198*)
(*198*)  (*BRANCH NAME*)
} note note46 = this
(* po redu: 199*)
(*199*)  
(*BRANCH END*)
from note45 and note46 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 200*)
(*200*)  (*BRANCH NAME*)
} note note47 = this
(* po redu: 201*)
(*201*)  
(*BRANCH END*)
from note44 and note47 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
(* po redu: 202*)
(*202*)  (*BRANCH NAME*)
} note note48 = this
(* po redu: 203*)
(*203*)  
(*BRANCH END*)
from note43 and note48 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 204*)
(*204*)  (*BRANCH NAME*)
} note note49 = this
(* po redu: 205*)
(*205*)  
(*BRANCH END*)
from note42 and note49 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 206*)
(*206*)  (*BRANCH NAME*)
} note note50 = this
(* po redu: 207*)
(*207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 208*)
(*208*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 209*)
(*209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 210*)
(*210*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 211*)
(*211*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 212*)
(*212*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 213*)
(*213*)  (*BRANCH NAME*)
} note note51 = this
(* po redu: 214*)
(*214*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 215*)
(*215*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 216*)
(*216*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 217*)
(*217*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 218*)
(*218*)  (*BRANCH NAME*)
} note note52 = this
(* po redu: 219*)
(*219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 220*)
(*220*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 221*)
(*221*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 222*)
(*222*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note53 = this
(* po redu: 223*)
(*223*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 224*)
(*224*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(* po redu: 225*)
(*225*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO1`
have  "\<not>col PO1 PO1 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO1"]
by auto

(* po redu: 226*)
(*226*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO2 PO4"
using ax_D3a [of "PO1" "PO1" "PO2" "PL1" "PO4"]
by auto

(* po redu: 227*)
(*227*)  (*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3`
have "comp PO1 PO2 PO1 PO4"
by auto

(* po redu: 228*)
(*228*)  (*REGULAR*)
moreover
from `comp PO1 PO2 PO1 PO4`
have  "comp PO1 PO1 PO2 PO4"
using ax_comp_1324 [of "PO1" "PO2" "PO1" "PO4"]
by auto

(* po redu: 229*)
(*229*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO2 PO4` and `comp PO1 PO1 PO2 PO4`
have False
by auto

(* po redu: 230*)
(*230*)  (*BRANCH NAME*)
} note note54 = this
(* po redu: 231*)
(*231*)  
(*BRANCH END*)
from note53 and note54 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 232*)
(*232*)  (*BRANCH NAME*)
} note note55 = this
(* po redu: 233*)
(*233*)  
(*BRANCH END*)
from note52 and note55 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 234*)
(*234*)  (*BRANCH NAME*)
} note note56 = this
(* po redu: 235*)
(*235*)  
(*BRANCH END*)
from note51 and note56 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 236*)
(*236*)  (*BRANCH NAME*)
} note note57 = this
(* po redu: 237*)
(*237*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 238*)
(*238*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 239*)
(*239*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 240*)
(*240*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 241*)
(*241*)  (*BRANCH NAME*)
} note note58 = this
(* po redu: 242*)
(*242*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 243*)
(*243*)  (*REGULAR*)
moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(* po redu: 244*)
(*244*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO3"
(* po redu: 245*)
(*245*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 246*)
(*246*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 247*)
(*247*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 248*)
(*248*)  (*BRANCH NAME*)
} note note59 = this
(* po redu: 249*)
(*249*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 250*)
(*250*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 251*)
(*251*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 252*)
(*252*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note60 = this
(* po redu: 253*)
(*253*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 254*)
(*254*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(* po redu: 255*)
(*255*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO2 PO2 PO4"
using ax_D3a [of "PO1" "PO2" "PO2" "PL1" "PO4"]
by auto

(* po redu: 256*)
(*256*)  (*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3`
have "comp PO1 PO2 PO2 PO4"
by auto

(* po redu: 257*)
(*257*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO2 PO2 PO4` and `comp PO1 PO2 PO2 PO4`
have False
by auto

(* po redu: 258*)
(*258*)  (*BRANCH NAME*)
} note note61 = this
(* po redu: 259*)
(*259*)  
(*BRANCH END*)
from note60 and note61 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 260*)
(*260*)  (*BRANCH NAME*)
} note note62 = this
(* po redu: 261*)
(*261*)  
(*BRANCH END*)
from note59 and note62 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 262*)
(*262*)  (*BRANCH NAME*)
} note note63 = this
(* po redu: 263*)
(*263*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO3"
(* po redu: 264*)
(*264*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 265*)
(*265*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 266*)
(*266*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 267*)
(*267*)  (*BRANCH NAME*)
} note note64 = this
(* po redu: 268*)
(*268*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 269*)
(*269*)  (*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(* po redu: 270*)
(*270*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
(* po redu: 271*)
(*271*)  (*EQCONTRADICTION*)
moreover
from `inc_po_pl PO3 PL1` and `PO3 = PO4`
have "inc_po_pl PO4 PL1"
by auto

(* po redu: 272*)
(*272*)  (*BRANCH NAME*)
} note note65 = this
(* po redu: 273*)
(*273*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
(* po redu: 274*)
(*274*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 275*)
(*275*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 276*)
(*276*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note66 = this
(* po redu: 277*)
(*277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 278*)
(*278*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO2 PO3 PO4"
using ax_D3a [of "PO1" "PO2" "PO3" "PL1" "PO4"]
by auto

(* po redu: 279*)
(*279*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO2 PO3 PO4` and `comp PO1 PO2 PO3 PO4`
have False
by auto

(* po redu: 280*)
(*280*)  (*BRANCH NAME*)
} note note67 = this
(* po redu: 281*)
(*281*)  
(*BRANCH END*)
from note66 and note67 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 282*)
(*282*)  (*BRANCH NAME*)
} note note68 = this
(* po redu: 283*)
(*283*)  
(*BRANCH END*)
from note65 and note68 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
(* po redu: 284*)
(*284*)  (*BRANCH NAME*)
} note note69 = this
(* po redu: 285*)
(*285*)  
(*BRANCH END*)
from note64 and note69 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 286*)
(*286*)  (*BRANCH NAME*)
} note note70 = this
(* po redu: 287*)
(*287*)  
(*BRANCH END*)
from note63 and note70 and `PO2 = PO3 \<or> PO2 ~= PO3`
have ?thesis
by auto
(* po redu: 288*)
(*288*)  (*BRANCH NAME*)
} note note71 = this
(* po redu: 289*)
(*289*)  
(*BRANCH END*)
from note58 and note71 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 290*)
(*290*)  (*BRANCH NAME*)
} note note72 = this
(* po redu: 291*)
(*291*)  
(*BRANCH END*)
from note57 and note72 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 292*)
(*292*)  (*BRANCH NAME*)
} note note73 = this
(* po redu: 293*)
(*293*)  
(*BRANCH END*)
from note50 and note73 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
(* po redu: 294*)
(*294*)  (*BRANCH NAME*)
} note note74 = this
(* po redu: 295*)
(*295*)  
(*BRANCH END*)
from note37 and note74 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
