theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th13:
shows " (col PO1 PO1 PO1)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)

obtain  PO2::point and  PO3::point
where "\<not>col PO1 PO2 PO3"
using ax_ml_I3b_1 [of "PO1"]
by auto

(* po redu: 2*)
(*2*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 3*)
(*3*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 4*)
(*4*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 5*)
(*5*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 6*)
(*6*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 7*)
(*7*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1"
using ax_I4a [of "PO1" "PO1" "PO1"]
by auto

(* po redu: 8*)
(*8*)  (*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(* po redu: 9*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 10*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 11*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO4::point
where "inc_po_pl PO4 PL1" and "inc_po_pl PO4 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 12*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 13*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1 = this
*)
(* po redu: 14*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 15*)
(*9*)  (*REGULAR*)
moreover

obtain  PO4::point and  PO5::point and  PO6::point and  PO7::point
where "\<not>comp PO4 PO5 PO6 PO7"
using ax_I8 by auto

(* po redu: 16*)
(*10*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 17*)
(*11*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 18*)
(*12*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 19*)
(*13*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 20*)
(*14*)  (*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

(* po redu: 21*)
(*15*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
(* po redu: 22*)
(*16*)  (*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

(* po redu: 23*)
(*17*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
(* po redu: 24*)
(*18*)  (*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4` and `PO1 = PO5` and `PO1 = PO6` and `PO1 = PO7`
have "\<not>comp PO1 PO1 PO1 PO1"
by auto

(* po redu: 25*)
(*19*)  (*REGULAR*)
moreover
from `comp PO1 PO1 PO1 PO1` and `\<not>comp PO1 PO1 PO1 PO1`
have False
by auto

(* po redu: 26*)
(*20*)  (*BRANCH NAME*)
} note note2 = this
(* po redu: 27*)
(*21*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
(* po redu: 28*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 29*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4` and `PO1 = PO5` and `PO1 = PO6`
have "\<not>comp PO1 PO1 PO1 PO7"
by auto

*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO1 PO1 PO1 PO7` and `\<not>comp PO1 PO1 PO1 PO7`
have False
by auto

*)
(* po redu: 33*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note3 = this
*)
(* po redu: 34*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 35*)
(*22*)  (*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO7 LI1"
using ax_I1 [of "PO1" "PO7"]
by auto

(* po redu: 36*)
(*23*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 37*)
(*24*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 38*)
(*25*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 39*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note4 = this
*)
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note3 and note4 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 41*)
(*26*)  (*BRANCH NAME*)
} note note5 = this
(* po redu: 42*)
(*27*)  
(*BRANCH END*)
from note2 and note5 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
(* po redu: 43*)
(*28*)  (*BRANCH NAME*)
} note note6 = this
(* po redu: 44*)
(*29*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 48*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 49*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 50*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 51*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO6 LI1"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 52*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 53*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 54*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 55*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 56*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 57*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note7 = this
*)
(* po redu: 58*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 59*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 60*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 61*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO1 PO1 PO6 PO6` and `PO1 = PO2` and `PO1 = PO3` and `PO1 = PO4` and `PO1 = PO5` and `PO6 = PO7`
have False
by auto

*)
(* po redu: 62*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note8 = this
*)
(* po redu: 63*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 64*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 65*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 66*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 67*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 68*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4` and `PO1 = PO5`
have "\<not>comp PO1 PO1 PO6 PO7"
by auto

*)
(* po redu: 69*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO1 PO1 PO6 PO7` and `\<not>comp PO1 PO1 PO6 PO7`
have False
by auto

*)
(* po redu: 70*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note9 = this
*)
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 73*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 74*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 75*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI3::line
where "inc_po_l PO6 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 76*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 77*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 78*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note10 = this
*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note9 and note10 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note11 = this
*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note8 and note11 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note12 = this
*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note7 and note12 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note13 = this
*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 87*)
(*30*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 88*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 89*)
(*31*)  (*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO6 LI1"
using ax_I1 [of "PO1" "PO6"]
by auto

(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 92*)
(*32*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 93*)
(*33*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 94*)
(*34*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 95*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note14 = this
*)
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 97*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 98*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 99*)
(*35*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 100*)
(*36*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 101*)
(*37*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 102*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note15 = this
*)
(* po redu: 103*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 104*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 106*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 107*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 108*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 109*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 110*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 111*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI3::line
where "inc_po_l PO6 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 112*)
(*38*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 113*)
(*39*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 114*)
(*40*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 115*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note16 = this
*)
(* po redu: 116*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 117*)
(*41*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 118*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 119*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 120*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI3::line
where "inc_po_l PO6 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 121*)
(*42*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 122*)
(*43*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 123*)
(*44*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note17 = this
*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note17 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note18 = this
*)
(* po redu: 127*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note15 and note18 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 128*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note19 = this
*)
(* po redu: 129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note14 and note19 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 130*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note20 = this
*)
(* po redu: 131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note13 and note20 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 132*)
(*45*)  (*BRANCH NAME*)
} note note21 = this
(* po redu: 133*)
(*46*)  
(*BRANCH END*)
from note6 and note21 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
(* po redu: 134*)
(*47*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 135*)
(*48*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1"
using ax_g5 [of "PO5" "PL1"]
by auto

*)
(* po redu: 137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO5 PL1"
*)
(* po redu: 138*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 139*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 140*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 141*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 142*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO5 LI1"
using ax_I1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 143*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 144*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 145*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 146*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 147*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 148*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 149*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 150*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note23 = this
*)
(* po redu: 151*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 152*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 153*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 154*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 155*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 156*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 157*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note24 = this
*)
(* po redu: 158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 160*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 161*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 162*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 163*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 164*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 165*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 168*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 169*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 170*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 171*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 172*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 173*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 174*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 175*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 176*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note25 = this
*)
(* po redu: 177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 178*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 179*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 180*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 181*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 182*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 183*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 184*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 185*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note26 = this
*)
(* po redu: 186*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note25 and note26 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 187*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note27 = this
*)
(* po redu: 188*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note24 and note27 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 189*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note28 = this
*)
(* po redu: 190*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note23 and note28 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 191*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note29 = this
*)
(* po redu: 192*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 193*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 194*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
*)
(* po redu: 195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 196*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 197*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 198*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note30 = this
*)
(* po redu: 201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 202*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 204*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO1 PO5 PO5 PO5` and `PO1 = PO2` and `PO1 = PO3` and `PO1 = PO4` and `PO5 = PO6` and `PO5 = PO7`
have False
by auto

*)
(* po redu: 205*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note31 = this
*)
(* po redu: 206*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 207*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 208*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 209*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 212*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 213*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4` and `PO5 = PO6`
have "\<not>comp PO1 PO5 PO5 PO7"
by auto

*)
(* po redu: 214*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO1 PO5 PO5 PO7` and `\<not>comp PO1 PO5 PO5 PO7`
have False
by auto

*)
(* po redu: 215*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note32 = this
*)
(* po redu: 216*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 217*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 218*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 219*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 220*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 221*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 222*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 223*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 224*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note33 = this
*)
(* po redu: 225*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note32 and note33 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 226*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note34 = this
*)
(* po redu: 227*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note31 and note34 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 228*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note35 = this
*)
(* po redu: 229*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note30 and note35 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 230*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note36 = this
*)
(* po redu: 231*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
*)
(* po redu: 232*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 234*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 235*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO6"]
by auto

*)
(* po redu: 236*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 237*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO6"]
by auto

*)
(* po redu: 238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO6"]
by auto

*)
(* po redu: 239*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 240*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO5 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO6"]
by auto

*)
(* po redu: 241*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO6" "PO6"]
by auto

*)
(* po redu: 242*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO6 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 244*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 245*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 246*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 247*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 248*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 249*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 250*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 251*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note37 = this
*)
(* po redu: 252*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 253*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 254*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 255*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 256*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 257*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 258*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note38 = this
*)
(* po redu: 259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 260*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 262*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO1 PO5 PO6 PO6` and `PO1 = PO2` and `PO1 = PO3` and `PO1 = PO4` and `PO6 = PO7`
have False
by auto

*)
(* po redu: 263*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note39 = this
*)
(* po redu: 264*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 265*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 266*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 268*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 269*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 270*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 271*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO7"]
by auto

*)
(* po redu: 273*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO1 = PO4`
have "\<not>comp PO1 PO5 PO6 PO7"
by auto

*)
(* po redu: 274*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO1 PO5 PO6 PO7` and `\<not>comp PO1 PO5 PO6 PO7`
have False
by auto

*)
(* po redu: 275*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note40 = this
*)
(* po redu: 276*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 277*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 278*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 279*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 281*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 283*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 285*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note41 = this
*)
(* po redu: 286*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note40 and note41 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 287*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note42 = this
*)
(* po redu: 288*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note39 and note42 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 289*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note43 = this
*)
(* po redu: 290*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note38 and note43 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 291*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note44 = this
*)
(* po redu: 292*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note37 and note44 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 293*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note45 = this
*)
(* po redu: 294*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 295*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 296*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 297*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 298*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 300*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 301*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 302*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note46 = this
*)
(* po redu: 305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 307*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 308*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 309*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 310*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 311*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note47 = this
*)
(* po redu: 312*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 313*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 314*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 315*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 316*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 317*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 318*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note48 = this
*)
(* po redu: 319*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 320*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 322*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 324*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 325*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 327*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 328*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 329*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 330*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 331*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 332*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 333*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 334*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 336*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 337*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 338*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note49 = this
*)
(* po redu: 339*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 340*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 341*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 342*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 343*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 344*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 345*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 346*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 347*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 348*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note50 = this
*)
(* po redu: 349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note49 and note50 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 350*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note51 = this
*)
(* po redu: 351*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note48 and note51 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 352*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note52 = this
*)
(* po redu: 353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note47 and note52 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 354*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note53 = this
*)
(* po redu: 355*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note46 and note53 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 356*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note54 = this
*)
(* po redu: 357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note45 and note54 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 358*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note55 = this
*)
(* po redu: 359*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note36 and note55 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
*)
(* po redu: 360*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note56 = this
*)
(* po redu: 361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note29 and note56 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 362*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note57 = this
*)
(* po redu: 363*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO5 PL1"
*)
(* po redu: 364*)
(*49*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 365*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO5 PL1`
have  "\<not>comp PO1 PO1 PO1 PO5"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO5"]
by auto

*)
(* po redu: 366*)
(*50*)  (*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO5 LI1"
using ax_I1 [of "PO1" "PO5"]
by auto

(* po redu: 367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 368*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 369*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 370*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 371*)
(*51*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 372*)
(*52*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 373*)
(*53*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 374*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note58 = this
*)
(* po redu: 375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 376*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 378*)
(*54*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 379*)
(*55*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 380*)
(*56*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 381*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note59 = this
*)
(* po redu: 382*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 383*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 384*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 385*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 386*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 387*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 388*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 389*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 390*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 391*)
(*57*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 392*)
(*58*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 393*)
(*59*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 394*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note60 = this
*)
(* po redu: 395*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 396*)
(*60*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 397*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 400*)
(*61*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 401*)
(*62*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 402*)
(*63*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 403*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note61 = this
*)
(* po redu: 404*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note60 and note61 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 405*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note62 = this
*)
(* po redu: 406*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note59 and note62 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 407*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note63 = this
*)
(* po redu: 408*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note58 and note63 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 409*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note64 = this
*)
(* po redu: 410*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 411*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 412*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
*)
(* po redu: 413*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 414*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 415*)
(*64*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 416*)
(*65*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 417*)
(*66*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 418*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note65 = this
*)
(* po redu: 419*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 420*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 422*)
(*67*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 423*)
(*68*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 424*)
(*69*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 425*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note66 = this
*)
(* po redu: 426*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 427*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 428*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 429*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 430*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 432*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 433*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 434*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 435*)
(*70*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 436*)
(*71*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 437*)
(*72*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 438*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note67 = this
*)
(* po redu: 439*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 440*)
(*73*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 441*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 442*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 443*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 444*)
(*74*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 445*)
(*75*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 446*)
(*76*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 447*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note68 = this
*)
(* po redu: 448*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note67 and note68 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 449*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note69 = this
*)
(* po redu: 450*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note66 and note69 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 451*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note70 = this
*)
(* po redu: 452*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note65 and note70 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 453*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note71 = this
*)
(* po redu: 454*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
*)
(* po redu: 455*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 456*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 457*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 458*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 460*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 461*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 462*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 464*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 465*)
(*77*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 466*)
(*78*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 467*)
(*79*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 468*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note72 = this
*)
(* po redu: 469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 470*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 471*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 472*)
(*80*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 473*)
(*81*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 474*)
(*82*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 475*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note73 = this
*)
(* po redu: 476*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 477*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 478*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 479*)
(*83*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 480*)
(*84*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 481*)
(*85*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 482*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note74 = this
*)
(* po redu: 483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 484*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 486*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 487*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 488*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 489*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 490*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 491*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 492*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 493*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 494*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 496*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 497*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 498*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 499*)
(*86*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 500*)
(*87*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 501*)
(*88*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 502*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note75 = this
*)
(* po redu: 503*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 504*)
(*89*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 505*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 506*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 507*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 508*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 509*)
(*90*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 510*)
(*91*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 511*)
(*92*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 512*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note76 = this
*)
(* po redu: 513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note75 and note76 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 514*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note77 = this
*)
(* po redu: 515*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note74 and note77 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 516*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note78 = this
*)
(* po redu: 517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note73 and note78 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 518*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note79 = this
*)
(* po redu: 519*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note72 and note79 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 520*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note80 = this
*)
(* po redu: 521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 522*)
(*93*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 523*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 524*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 525*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI3::line
where "inc_po_l PO5 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 526*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 527*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 528*)
(*94*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 529*)
(*95*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 530*)
(*96*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 531*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note81 = this
*)
(* po redu: 532*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 533*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 534*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 535*)
(*97*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 536*)
(*98*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 537*)
(*99*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 538*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note82 = this
*)
(* po redu: 539*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 542*)
(*100*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 543*)
(*101*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 544*)
(*102*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 545*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note83 = this
*)
(* po redu: 546*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 547*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 548*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 549*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 550*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 551*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 552*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 553*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 554*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 555*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 556*)
(*103*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 557*)
(*104*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 558*)
(*105*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 559*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note84 = this
*)
(* po redu: 560*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 561*)
(*106*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 563*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 564*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI5::line
where "inc_po_l PO5 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 565*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 566*)
(*107*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 567*)
(*108*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 568*)
(*109*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 569*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note85 = this
*)
(* po redu: 570*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note84 and note85 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 571*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note86 = this
*)
(* po redu: 572*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note83 and note86 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 573*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note87 = this
*)
(* po redu: 574*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note82 and note87 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 575*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note88 = this
*)
(* po redu: 576*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note81 and note88 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 577*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note89 = this
*)
(* po redu: 578*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note80 and note89 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 579*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note90 = this
*)
(* po redu: 580*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note71 and note90 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
*)
(* po redu: 581*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note91 = this
*)
(* po redu: 582*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note64 and note91 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 583*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note92 = this
*)
(* po redu: 584*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note57 and note92 and `inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1`
have False
by auto
*)
(* po redu: 585*)
(*110*)  (*BRANCH NAME*)
} note note93 = this
(* po redu: 586*)
(*111*)  
(*BRANCH END*)
from note22 and note93 and `PO1 = PO5 \<or> PO1 ~= PO5`
have False
by auto
(* po redu: 587*)
(*112*)  (*BRANCH NAME*)
} note note94 = this
(* po redu: 588*)
(*113*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 589*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 590*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 592*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 593*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 594*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 595*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO4`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO4 LI1"
using ax_I1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 596*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
*)
(* po redu: 598*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 599*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 600*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 602*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 603*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 604*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 605*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note95 = this
*)
(* po redu: 606*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 608*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 609*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 610*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note96 = this
*)
(* po redu: 613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 616*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 617*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 618*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 619*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 620*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 621*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 622*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 623*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 624*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 625*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 626*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 627*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 628*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 629*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 630*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 631*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note97 = this
*)
(* po redu: 632*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 633*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 636*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 637*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 638*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 639*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 640*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note98 = this
*)
(* po redu: 641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note97 and note98 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 642*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note99 = this
*)
(* po redu: 643*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note96 and note99 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 644*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note100 = this
*)
(* po redu: 645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note95 and note100 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 646*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note101 = this
*)
(* po redu: 647*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 648*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
*)
(* po redu: 650*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 651*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 652*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 653*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 655*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note102 = this
*)
(* po redu: 656*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 657*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 658*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 659*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 660*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 661*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 662*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note103 = this
*)
(* po redu: 663*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 664*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 666*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 667*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 668*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 669*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 670*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 671*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 672*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 673*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 675*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 676*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 677*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 678*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 679*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 680*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 681*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note104 = this
*)
(* po redu: 682*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 683*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 684*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 685*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 686*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 687*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 688*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 689*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 690*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note105 = this
*)
(* po redu: 691*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note104 and note105 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 692*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note106 = this
*)
(* po redu: 693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note103 and note106 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 694*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note107 = this
*)
(* po redu: 695*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note102 and note107 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 696*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note108 = this
*)
(* po redu: 697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
*)
(* po redu: 698*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 699*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 700*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 701*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO6"]
by auto

*)
(* po redu: 702*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO6"]
by auto

*)
(* po redu: 704*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO6"]
by auto

*)
(* po redu: 705*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO4 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO6"]
by auto

*)
(* po redu: 707*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO6"]
by auto

*)
(* po redu: 708*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO6 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 709*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 710*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 711*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 712*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 714*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 715*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 716*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 717*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note109 = this
*)
(* po redu: 718*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 719*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 720*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 721*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 722*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 723*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 724*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note110 = this
*)
(* po redu: 725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 726*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 727*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 728*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 729*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 730*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 731*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note111 = this
*)
(* po redu: 732*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 733*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 734*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 736*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 737*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 738*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 740*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO7"]
by auto

*)
(* po redu: 741*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 742*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 743*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 744*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 745*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 746*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO7"]
by auto

*)
(* po redu: 747*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 748*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO6 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 749*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO6 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 750*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 751*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 752*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 753*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 754*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 755*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 756*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 757*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 758*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 759*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 760*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 761*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note112 = this
*)
(* po redu: 762*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 763*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 764*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 765*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 766*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 767*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 768*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 769*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 770*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 771*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note113 = this
*)
(* po redu: 772*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note112 and note113 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 773*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note114 = this
*)
(* po redu: 774*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note111 and note114 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 775*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note115 = this
*)
(* po redu: 776*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note110 and note115 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 777*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note116 = this
*)
(* po redu: 778*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note109 and note116 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 779*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note117 = this
*)
(* po redu: 780*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 781*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 782*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 783*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 784*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 785*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 786*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 787*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 788*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 789*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 790*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note118 = this
*)
(* po redu: 791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 792*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 794*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 795*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 796*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 797*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note119 = this
*)
(* po redu: 798*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 800*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 801*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 802*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 803*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 804*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note120 = this
*)
(* po redu: 805*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 806*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 807*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 808*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 809*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 810*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 812*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 813*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 814*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 816*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 817*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 818*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 819*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 820*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 821*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 822*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 823*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 824*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note121 = this
*)
(* po redu: 825*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 826*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 827*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 828*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 829*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 830*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 831*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 832*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 833*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 834*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note122 = this
*)
(* po redu: 835*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note121 and note122 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 836*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note123 = this
*)
(* po redu: 837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note120 and note123 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 838*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note124 = this
*)
(* po redu: 839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note119 and note124 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 840*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note125 = this
*)
(* po redu: 841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note118 and note125 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 842*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note126 = this
*)
(* po redu: 843*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note117 and note126 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 844*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note127 = this
*)
(* po redu: 845*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note108 and note127 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
*)
(* po redu: 846*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note128 = this
*)
(* po redu: 847*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note101 and note128 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 848*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note129 = this
*)
(* po redu: 849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
*)
(* po redu: 850*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO5 \<or> PO4 ~= PO5"
using ax_g1 [of "PO4" "PO5"]
by auto

*)
(* po redu: 851*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO5"
*)
(* po redu: 852*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 854*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 855*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 856*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 857*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 858*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 859*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note130 = this
*)
(* po redu: 860*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 861*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 862*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 863*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 864*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 865*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 866*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note131 = this
*)
(* po redu: 867*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 868*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 870*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 871*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 872*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 873*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 874*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 875*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 876*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 877*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 878*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 879*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 880*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 881*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 882*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 883*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 884*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 885*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note132 = this
*)
(* po redu: 886*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 887*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 888*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 889*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 890*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 891*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 892*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 893*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 894*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note133 = this
*)
(* po redu: 895*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note132 and note133 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 896*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note134 = this
*)
(* po redu: 897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note131 and note134 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 898*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note135 = this
*)
(* po redu: 899*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note130 and note135 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 900*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note136 = this
*)
(* po redu: 901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 902*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
*)
(* po redu: 904*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 906*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 907*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 908*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 909*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note137 = this
*)
(* po redu: 910*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 911*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 912*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 913*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO4 PO4 PO4 PO4` and `PO4 = PO5` and `PO4 = PO6` and `PO4 = PO7`
have False
by auto

*)
(* po redu: 914*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note138 = this
*)
(* po redu: 915*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 916*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 917*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 918*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 919*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 920*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 921*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 922*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 923*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 924*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 925*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO4 = PO5` and `PO4 = PO6`
have "\<not>comp PO4 PO4 PO4 PO7"
by auto

*)
(* po redu: 926*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO4 PO4 PO4 PO7` and `\<not>comp PO4 PO4 PO4 PO7`
have False
by auto

*)
(* po redu: 927*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note139 = this
*)
(* po redu: 928*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 929*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 930*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 931*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 932*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 933*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 934*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 935*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 936*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note140 = this
*)
(* po redu: 937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note139 and note140 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 938*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note141 = this
*)
(* po redu: 939*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note138 and note141 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 940*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note142 = this
*)
(* po redu: 941*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note137 and note142 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 942*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note143 = this
*)
(* po redu: 943*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
*)
(* po redu: 944*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 945*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 946*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 947*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO6"]
by auto

*)
(* po redu: 948*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 949*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO6"]
by auto

*)
(* po redu: 950*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO6"]
by auto

*)
(* po redu: 951*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 952*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO4 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO6"]
by auto

*)
(* po redu: 953*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO6"]
by auto

*)
(* po redu: 954*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO6 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 955*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 956*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 957*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 960*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 961*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 962*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 963*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note144 = this
*)
(* po redu: 964*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 965*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 966*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 967*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 968*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 969*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 970*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note145 = this
*)
(* po redu: 971*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 972*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 973*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 974*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO4 PO4 PO6 PO6` and `PO4 = PO5` and `PO6 = PO7`
have False
by auto

*)
(* po redu: 975*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note146 = this
*)
(* po redu: 976*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 977*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 978*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 979*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 980*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 981*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 982*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 983*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 984*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO7"]
by auto

*)
(* po redu: 985*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 986*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 987*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 988*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 989*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 990*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO7"]
by auto

*)
(* po redu: 991*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO4 = PO5`
have "\<not>comp PO4 PO4 PO6 PO7"
by auto

*)
(* po redu: 992*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO4 PO4 PO6 PO7` and `\<not>comp PO4 PO4 PO6 PO7`
have False
by auto

*)
(* po redu: 993*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note147 = this
*)
(* po redu: 994*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 995*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 996*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 997*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 998*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 999*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1000*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1001*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1002*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1003*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note148 = this
*)
(* po redu: 1004*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note147 and note148 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1005*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note149 = this
*)
(* po redu: 1006*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note146 and note149 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 1007*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note150 = this
*)
(* po redu: 1008*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note145 and note150 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1009*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note151 = this
*)
(* po redu: 1010*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note144 and note151 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1011*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note152 = this
*)
(* po redu: 1012*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 1013*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1014*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 1015*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1016*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1017*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1018*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1019*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1020*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1021*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1022*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note153 = this
*)
(* po redu: 1023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1024*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1025*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1026*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1027*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1028*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1029*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note154 = this
*)
(* po redu: 1030*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1031*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1032*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 1033*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1034*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1035*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1036*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note155 = this
*)
(* po redu: 1037*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 1038*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1039*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1040*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1041*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1042*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1043*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1044*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1045*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1046*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1047*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1048*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1049*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1050*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1051*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1052*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1053*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1054*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1055*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1056*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note156 = this
*)
(* po redu: 1057*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1058*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1060*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1061*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1062*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1063*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1064*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1065*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1066*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note157 = this
*)
(* po redu: 1067*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note156 and note157 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1068*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note158 = this
*)
(* po redu: 1069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note155 and note158 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 1070*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note159 = this
*)
(* po redu: 1071*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note154 and note159 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1072*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note160 = this
*)
(* po redu: 1073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note153 and note160 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1074*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note161 = this
*)
(* po redu: 1075*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note152 and note161 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 1076*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note162 = this
*)
(* po redu: 1077*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note143 and note162 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
*)
(* po redu: 1078*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note163 = this
*)
(* po redu: 1079*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note136 and note163 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 1080*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note164 = this
*)
(* po redu: 1081*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO5"
*)
(* po redu: 1082*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1"
using ax_g5 [of "PO5" "PL1"]
by auto

*)
(* po redu: 1083*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO5 PL1"
*)
(* po redu: 1084*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 1085*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO4 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO5"]
by auto

*)
(* po redu: 1086*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 1087*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO4 PO4 PO5"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO5"]
by auto

*)
(* po redu: 1088*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO4 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO5"]
by auto

*)
(* po redu: 1089*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 1090*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO4 PO4 PO4 PO5"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO5"]
by auto

*)
(* po redu: 1091*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO4 PO4 PO5 PO5"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO5"]
by auto

*)
(* po redu: 1092*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO4 PO5 PO5 PO5"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 1093*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 1094*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 1095*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

*)
(* po redu: 1096*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1097*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 1098*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1099*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1100*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1101*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1102*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1103*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note165 = this
*)
(* po redu: 1104*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1105*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1106*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1107*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1108*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1109*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1110*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note166 = this
*)
(* po redu: 1111*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1112*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1114*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1115*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1116*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1117*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note167 = this
*)
(* po redu: 1118*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1119*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1120*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1121*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1122*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1123*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 1124*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1125*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1126*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1127*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1128*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1129*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1132*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1133*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1134*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1135*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1137*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1138*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1139*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1140*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1141*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1142*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1143*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1144*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1145*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1146*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1147*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note168 = this
*)
(* po redu: 1148*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1149*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1151*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1152*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1153*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1154*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1155*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1156*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1157*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note169 = this
*)
(* po redu: 1158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note168 and note169 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1159*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note170 = this
*)
(* po redu: 1160*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note167 and note170 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1161*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note171 = this
*)
(* po redu: 1162*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note166 and note171 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1163*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note172 = this
*)
(* po redu: 1164*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note165 and note172 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1165*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note173 = this
*)
(* po redu: 1166*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 1167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1168*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
*)
(* po redu: 1169*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1170*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1171*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1172*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1173*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1174*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note174 = this
*)
(* po redu: 1175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1176*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1179*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1180*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1181*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note175 = this
*)
(* po redu: 1182*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1183*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1184*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1185*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1186*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1187*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1188*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note176 = this
*)
(* po redu: 1189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1190*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1192*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1193*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1194*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 1195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1196*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1197*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1198*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1200*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1201*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1202*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1203*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1204*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1205*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1206*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1207*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1209*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1212*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1213*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1214*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1215*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1216*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1217*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1218*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note177 = this
*)
(* po redu: 1219*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1220*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1221*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1222*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1223*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1224*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1225*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1226*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1228*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note178 = this
*)
(* po redu: 1229*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note177 and note178 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1230*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note179 = this
*)
(* po redu: 1231*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note176 and note179 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1232*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note180 = this
*)
(* po redu: 1233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note175 and note180 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1234*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note181 = this
*)
(* po redu: 1235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note174 and note181 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1236*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note182 = this
*)
(* po redu: 1237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
*)
(* po redu: 1238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 1239*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
*)
(* po redu: 1240*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1242*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1243*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1244*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1245*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note183 = this
*)
(* po redu: 1246*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1247*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1248*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1249*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1250*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1251*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1252*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note184 = this
*)
(* po redu: 1253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1254*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1255*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1256*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO4 PO5 PO5 PO5` and `PO5 = PO6` and `PO5 = PO7`
have False
by auto

*)
(* po redu: 1257*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note185 = this
*)
(* po redu: 1258*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1259*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1260*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1261*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1262*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1263*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 1264*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1265*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1266*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1268*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1269*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1270*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1271*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1273*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1274*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1275*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `PO5 = PO6`
have "\<not>comp PO4 PO5 PO5 PO7"
by auto

*)
(* po redu: 1276*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO4 PO5 PO5 PO7` and `\<not>comp PO4 PO5 PO5 PO7`
have False
by auto

*)
(* po redu: 1277*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note186 = this
*)
(* po redu: 1278*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1279*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1281*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1283*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1285*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1287*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note187 = this
*)
(* po redu: 1288*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note186 and note187 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1289*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note188 = this
*)
(* po redu: 1290*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note185 and note188 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1291*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note189 = this
*)
(* po redu: 1292*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note184 and note189 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1293*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note190 = this
*)
(* po redu: 1294*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note183 and note190 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1295*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note191 = this
*)
(* po redu: 1296*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
*)
(* po redu: 1297*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 1298*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 1299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 1300*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO6"]
by auto

*)
(* po redu: 1301*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO6"]
by auto

*)
(* po redu: 1302*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 1303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO6"]
by auto

*)
(* po redu: 1304*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO6"]
by auto

*)
(* po redu: 1305*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO6"]
by auto

*)
(* po redu: 1306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO6"]
by auto

*)
(* po redu: 1307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO6"]
by auto

*)
(* po redu: 1308*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1309*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO4 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO6"]
by auto

*)
(* po redu: 1310*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO5 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO6"]
by auto

*)
(* po redu: 1311*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO6"]
by auto

*)
(* po redu: 1312*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO5 PO5 PO6"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO6"]
by auto

*)
(* po redu: 1313*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO5 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO5" "PO6" "PO6"]
by auto

*)
(* po redu: 1314*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO6 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1315*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO5 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO6"]
by auto

*)
(* po redu: 1316*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO6" "PO6"]
by auto

*)
(* po redu: 1317*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO6 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1318*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1319*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1320*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1321*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 1322*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1323*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1324*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1325*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1327*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note192 = this
*)
(* po redu: 1328*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1329*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1330*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1331*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1332*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1333*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1334*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note193 = this
*)
(* po redu: 1335*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1336*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1338*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1339*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1340*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1341*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note194 = this
*)
(* po redu: 1342*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1343*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1344*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 1345*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>comp PO4 PO5 PO6 PO7` and `comp PO4 PO5 PO6 PO6` and `PO6 = PO7`
have False
by auto

*)
(* po redu: 1346*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note195 = this
*)
(* po redu: 1347*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 1348*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1350*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1352*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 1353*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 1354*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1356*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1357*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO7"]
by auto

*)
(* po redu: 1358*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1359*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1360*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO7"]
by auto

*)
(* po redu: 1361*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1362*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 1363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 1364*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1365*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1366*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO7"]
by auto

*)
(* po redu: 1368*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1369*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1370*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO6" "PO7"]
by auto

*)
(* po redu: 1371*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO4 PO5 PO6 PO7` and `\<not>comp PO4 PO5 PO6 PO7`
have False
by auto

*)
(* po redu: 1372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note196 = this
*)
(* po redu: 1373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1374*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1375*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1376*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1377*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1378*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1379*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1381*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1382*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1383*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note197 = this
*)
(* po redu: 1384*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note196 and note197 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1385*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note198 = this
*)
(* po redu: 1386*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note195 and note198 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 1387*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note199 = this
*)
(* po redu: 1388*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note194 and note199 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1389*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note200 = this
*)
(* po redu: 1390*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note193 and note200 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1391*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note201 = this
*)
(* po redu: 1392*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note192 and note201 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1393*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note202 = this
*)
(* po redu: 1394*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 1395*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1396*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 1397*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 1400*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1402*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1403*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1404*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1405*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note203 = this
*)
(* po redu: 1406*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1407*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1408*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1409*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1410*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1411*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note204 = this
*)
(* po redu: 1413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1414*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1415*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1416*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1417*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1419*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note205 = this
*)
(* po redu: 1420*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1421*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1422*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 1423*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1424*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1425*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1426*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note206 = this
*)
(* po redu: 1427*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 1428*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1430*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1432*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 1433*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1434*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1435*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1436*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1437*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1438*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1439*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1440*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1441*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO5" "PO7"]
by auto

*)
(* po redu: 1442*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1443*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO5 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1444*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO5 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1445*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1446*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 1447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 1448*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1449*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1450*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1451*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1452*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1453*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1454*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1455*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1456*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1457*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note207 = this
*)
(* po redu: 1458*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1459*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1460*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1461*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1462*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1464*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1465*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1466*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1467*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1468*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note208 = this
*)
(* po redu: 1469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note207 and note208 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1470*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note209 = this
*)
(* po redu: 1471*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note206 and note209 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 1472*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note210 = this
*)
(* po redu: 1473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note205 and note210 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1474*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note211 = this
*)
(* po redu: 1475*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note204 and note211 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note212 = this
*)
(* po redu: 1477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note203 and note212 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1478*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note213 = this
*)
(* po redu: 1479*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note202 and note213 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 1480*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note214 = this
*)
(* po redu: 1481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note191 and note214 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
*)
(* po redu: 1482*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note215 = this
*)
(* po redu: 1483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note182 and note215 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
*)
(* po redu: 1484*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note216 = this
*)
(* po redu: 1485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note173 and note216 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 1486*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note217 = this
*)
(* po redu: 1487*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO5 PL1"
*)
(* po redu: 1488*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1489*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO5 PL1`
have  "\<not>comp PO1 PO1 PO1 PO5"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO5"]
by auto

*)
(* po redu: 1490*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 1491*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

*)
(* po redu: 1492*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 1494*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1495*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1496*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1497*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1498*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1499*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note218 = this
*)
(* po redu: 1500*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1501*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1502*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1503*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1504*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1505*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1506*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note219 = this
*)
(* po redu: 1507*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1508*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1510*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1511*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1512*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1513*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note220 = this
*)
(* po redu: 1514*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1515*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1516*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1517*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1518*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1519*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1520*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1521*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1522*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1523*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1524*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1525*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1526*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1527*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1528*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1529*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1530*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1531*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1532*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1533*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note221 = this
*)
(* po redu: 1534*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1535*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1536*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1537*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1538*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1539*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1541*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1542*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1543*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note222 = this
*)
(* po redu: 1544*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note221 and note222 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1545*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note223 = this
*)
(* po redu: 1546*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note220 and note223 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1547*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note224 = this
*)
(* po redu: 1548*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note219 and note224 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1549*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note225 = this
*)
(* po redu: 1550*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note218 and note225 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1551*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note226 = this
*)
(* po redu: 1552*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 1553*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1554*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
*)
(* po redu: 1555*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1556*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1557*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1558*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1559*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1560*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note227 = this
*)
(* po redu: 1561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1563*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1564*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1565*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1566*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1567*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note228 = this
*)
(* po redu: 1568*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1569*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1570*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1571*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1572*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1573*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1574*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note229 = this
*)
(* po redu: 1575*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1576*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1578*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1580*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1581*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1582*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1583*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1585*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1586*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1587*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1588*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1589*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1592*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1593*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1594*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note230 = this
*)
(* po redu: 1595*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1596*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1597*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1598*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1599*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1600*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1601*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1602*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1603*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1604*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note231 = this
*)
(* po redu: 1605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note230 and note231 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1606*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note232 = this
*)
(* po redu: 1607*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note229 and note232 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note233 = this
*)
(* po redu: 1609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note228 and note233 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1610*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note234 = this
*)
(* po redu: 1611*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note227 and note234 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note235 = this
*)
(* po redu: 1613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
*)
(* po redu: 1614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 1615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
*)
(* po redu: 1616*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1618*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1619*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1620*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1621*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note236 = this
*)
(* po redu: 1622*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1623*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1624*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1625*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1626*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1627*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1628*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note237 = this
*)
(* po redu: 1629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1630*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1631*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1632*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1633*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1635*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note238 = this
*)
(* po redu: 1636*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1637*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1638*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1639*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1640*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1641*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1642*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1643*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1644*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1645*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1647*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1648*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1649*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1650*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1651*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1652*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1653*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1655*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note239 = this
*)
(* po redu: 1656*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1657*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1658*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1659*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1660*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1661*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1662*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1663*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1664*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1665*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note240 = this
*)
(* po redu: 1666*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note239 and note240 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1667*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note241 = this
*)
(* po redu: 1668*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note238 and note241 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1669*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note242 = this
*)
(* po redu: 1670*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note237 and note242 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1671*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note243 = this
*)
(* po redu: 1672*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note236 and note243 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1673*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note244 = this
*)
(* po redu: 1674*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
*)
(* po redu: 1675*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 1676*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 1677*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 1678*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO6"]
by auto

*)
(* po redu: 1679*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 1680*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO4 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO6"]
by auto

*)
(* po redu: 1681*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO4 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO6"]
by auto

*)
(* po redu: 1682*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1683*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO4 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO6"]
by auto

*)
(* po redu: 1684*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO4 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO6"]
by auto

*)
(* po redu: 1685*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO4 PO6 PO6 PO6"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1686*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1687*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1688*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1689*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 1690*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1691*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1692*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1693*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1695*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note245 = this
*)
(* po redu: 1696*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1697*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1698*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1699*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1700*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1701*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1702*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note246 = this
*)
(* po redu: 1703*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1704*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1707*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1708*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1709*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note247 = this
*)
(* po redu: 1710*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1711*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1712*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 1713*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1714*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1715*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1716*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note248 = this
*)
(* po redu: 1717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 1718*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1719*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1720*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1721*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1722*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 1723*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1724*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1725*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO6" "PO7"]
by auto

*)
(* po redu: 1726*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1727*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 1728*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 1729*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1730*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1731*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO6" "PO7"]
by auto

*)
(* po redu: 1732*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1733*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO6 PO6 PO7"
using ax_D3 [of "PO4" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 1734*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO6 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 1735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1736*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 1737*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 1738*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1740*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1741*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1742*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1743*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1744*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1745*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1746*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1747*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note249 = this
*)
(* po redu: 1748*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1749*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1750*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1751*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1752*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1753*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1754*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1755*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1756*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1757*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1758*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note250 = this
*)
(* po redu: 1759*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note249 and note250 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1760*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note251 = this
*)
(* po redu: 1761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note248 and note251 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 1762*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note252 = this
*)
(* po redu: 1763*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note247 and note252 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1764*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note253 = this
*)
(* po redu: 1765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note246 and note253 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1766*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note254 = this
*)
(* po redu: 1767*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note245 and note254 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1768*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note255 = this
*)
(* po redu: 1769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 1770*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1771*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 1772*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1773*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1774*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 1775*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1776*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1777*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1778*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1779*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1780*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note256 = this
*)
(* po redu: 1781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1782*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1783*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1784*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1785*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1786*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1787*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note257 = this
*)
(* po redu: 1788*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1789*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1790*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 1791*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1792*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1793*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1794*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note258 = this
*)
(* po redu: 1795*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 1796*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 1798*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1799*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1800*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1801*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note259 = this
*)
(* po redu: 1802*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 1803*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1804*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1805*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1806*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO7"]
by auto

*)
(* po redu: 1807*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1808*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO4 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1809*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO4 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1810*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO4 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO7"]
by auto

*)
(* po redu: 1812*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO4 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO4" "PO7" "PO7"]
by auto

*)
(* po redu: 1813*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO4 PO7 PO7 PO7"
using ax_D3 [of "PO4" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1814*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1816*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1817*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1818*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1819*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1820*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1821*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1822*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note260 = this
*)
(* po redu: 1823*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1824*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1825*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1826*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1827*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1828*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 1829*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1830*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 1831*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 1832*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 1833*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note261 = this
*)
(* po redu: 1834*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note260 and note261 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1835*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note262 = this
*)
(* po redu: 1836*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note259 and note262 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 1837*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note263 = this
*)
(* po redu: 1838*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note258 and note263 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 1839*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note264 = this
*)
(* po redu: 1840*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note257 and note264 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1841*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note265 = this
*)
(* po redu: 1842*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note256 and note265 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1843*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note266 = this
*)
(* po redu: 1844*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note255 and note266 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 1845*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note267 = this
*)
(* po redu: 1846*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note244 and note267 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
*)
(* po redu: 1847*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note268 = this
*)
(* po redu: 1848*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note235 and note268 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
*)
(* po redu: 1849*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note269 = this
*)
(* po redu: 1850*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note226 and note269 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 1851*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note270 = this
*)
(* po redu: 1852*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note217 and note270 and `inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1`
have False
by auto
*)
(* po redu: 1853*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note271 = this
*)
(* po redu: 1854*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note164 and note271 and `PO4 = PO5 \<or> PO4 ~= PO5`
have False
by auto
*)
(* po redu: 1855*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note272 = this
*)
(* po redu: 1856*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note129 and note272 and `PO1 = PO5 \<or> PO1 ~= PO5`
have False
by auto
*)
(* po redu: 1857*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note273 = this
*)
(* po redu: 1858*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 1859*)
(*114*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1860*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO1 PO4"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO4"]
by auto

*)
(* po redu: 1861*)
(*115*)  (*REGULAR*)
moreover
from `PO1 ~= PO4`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO4 LI1"
using ax_I1 [of "PO1" "PO4"]
by auto

(* po redu: 1862*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 1863*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
*)
(* po redu: 1864*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 1866*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1867*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1868*)
(*116*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1869*)
(*117*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1870*)
(*118*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1871*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note274 = this
*)
(* po redu: 1872*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1873*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1874*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1875*)
(*119*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1876*)
(*120*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1877*)
(*121*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1878*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note275 = this
*)
(* po redu: 1879*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1880*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1881*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1882*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1883*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1884*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1885*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1886*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1887*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1888*)
(*122*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1889*)
(*123*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1890*)
(*124*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1891*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note276 = this
*)
(* po redu: 1892*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1893*)
(*125*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1894*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1895*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1896*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1897*)
(*126*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1898*)
(*127*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1899*)
(*128*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1900*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note277 = this
*)
(* po redu: 1901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note276 and note277 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1902*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note278 = this
*)
(* po redu: 1903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note275 and note278 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1904*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note279 = this
*)
(* po redu: 1905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note274 and note279 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1906*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note280 = this
*)
(* po redu: 1907*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 1908*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
*)
(* po redu: 1910*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1911*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1912*)
(*129*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1913*)
(*130*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1914*)
(*131*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1915*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note281 = this
*)
(* po redu: 1916*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1917*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1918*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1919*)
(*132*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1920*)
(*133*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1921*)
(*134*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1922*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note282 = this
*)
(* po redu: 1923*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1924*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1926*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1927*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1928*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1929*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1930*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1931*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1932*)
(*135*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1933*)
(*136*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1934*)
(*137*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1935*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note283 = this
*)
(* po redu: 1936*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 1937*)
(*138*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1938*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 1939*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1940*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1941*)
(*139*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1942*)
(*140*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1943*)
(*141*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1944*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note284 = this
*)
(* po redu: 1945*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note283 and note284 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 1946*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note285 = this
*)
(* po redu: 1947*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note282 and note285 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 1948*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note286 = this
*)
(* po redu: 1949*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note281 and note286 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 1950*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note287 = this
*)
(* po redu: 1951*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
*)
(* po redu: 1952*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 1953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 1954*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 1955*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 1956*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1957*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 1958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 1959*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 1960*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 1962*)
(*142*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1963*)
(*143*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1964*)
(*144*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1965*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note288 = this
*)
(* po redu: 1966*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 1967*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1968*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 1969*)
(*145*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1970*)
(*146*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1971*)
(*147*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1972*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note289 = this
*)
(* po redu: 1973*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 1974*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1975*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 1976*)
(*148*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1977*)
(*149*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1978*)
(*150*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1979*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note290 = this
*)
(* po redu: 1980*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 1981*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 1982*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 1983*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 1984*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 1985*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 1986*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 1987*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 1988*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1989*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 1990*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 1991*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1992*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 1993*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 1994*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 1995*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 1996*)
(*151*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 1997*)
(*152*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 1998*)
(*153*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 1999*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note291 = this
*)
(* po redu: 2000*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2001*)
(*154*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2002*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2003*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2004*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2005*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2006*)
(*155*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2007*)
(*156*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2008*)
(*157*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2009*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note292 = this
*)
(* po redu: 2010*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note291 and note292 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2011*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note293 = this
*)
(* po redu: 2012*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note290 and note293 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 2013*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note294 = this
*)
(* po redu: 2014*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note289 and note294 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2015*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note295 = this
*)
(* po redu: 2016*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note288 and note295 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2017*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note296 = this
*)
(* po redu: 2018*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 2019*)
(*158*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2020*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 2021*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2022*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2023*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2024*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2025*)
(*159*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2026*)
(*160*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2027*)
(*161*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2028*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note297 = this
*)
(* po redu: 2029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2030*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2031*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2032*)
(*162*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2033*)
(*163*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2034*)
(*164*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2035*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note298 = this
*)
(* po redu: 2036*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2037*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2038*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 2039*)
(*165*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2040*)
(*166*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2041*)
(*167*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2042*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note299 = this
*)
(* po redu: 2043*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 2044*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2045*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2046*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2047*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2048*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2049*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2050*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2051*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2052*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2053*)
(*168*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2054*)
(*169*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2055*)
(*170*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2056*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note300 = this
*)
(* po redu: 2057*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2058*)
(*171*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2060*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2061*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2062*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2063*)
(*172*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2064*)
(*173*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2065*)
(*174*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2066*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note301 = this
*)
(* po redu: 2067*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note300 and note301 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2068*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note302 = this
*)
(* po redu: 2069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note299 and note302 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 2070*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note303 = this
*)
(* po redu: 2071*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note298 and note303 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2072*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note304 = this
*)
(* po redu: 2073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note297 and note304 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2074*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note305 = this
*)
(* po redu: 2075*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note296 and note305 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 2076*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note306 = this
*)
(* po redu: 2077*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note287 and note306 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
*)
(* po redu: 2078*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note307 = this
*)
(* po redu: 2079*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note280 and note307 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 2080*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note308 = this
*)
(* po redu: 2081*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
*)
(* po redu: 2082*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO5 \<or> PO4 ~= PO5"
using ax_g1 [of "PO4" "PO5"]
by auto

*)
(* po redu: 2083*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO5"
*)
(* po redu: 2084*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2085*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 2086*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2087*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2088*)
(*175*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2089*)
(*176*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2090*)
(*177*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2091*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note309 = this
*)
(* po redu: 2092*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2093*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2094*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2095*)
(*178*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2096*)
(*179*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2097*)
(*180*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2098*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note310 = this
*)
(* po redu: 2099*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2100*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2102*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2104*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2105*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2106*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2107*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2108*)
(*181*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2109*)
(*182*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2110*)
(*183*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2111*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note311 = this
*)
(* po redu: 2112*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2113*)
(*184*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2114*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2115*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2116*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2117*)
(*185*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2118*)
(*186*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2119*)
(*187*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2120*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note312 = this
*)
(* po redu: 2121*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note311 and note312 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2122*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note313 = this
*)
(* po redu: 2123*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note310 and note313 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2124*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note314 = this
*)
(* po redu: 2125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note309 and note314 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2126*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note315 = this
*)
(* po redu: 2127*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 2128*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
*)
(* po redu: 2130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2132*)
(*188*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2133*)
(*189*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2134*)
(*190*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2135*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note316 = this
*)
(* po redu: 2136*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2137*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2138*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2139*)
(*191*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2140*)
(*192*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2141*)
(*193*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2142*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note317 = this
*)
(* po redu: 2143*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2144*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2146*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2147*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2148*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2149*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2151*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2152*)
(*194*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2153*)
(*195*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2154*)
(*196*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2155*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note318 = this
*)
(* po redu: 2156*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2157*)
(*197*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2158*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO7 LI2"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO7 LI3"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2161*)
(*198*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2162*)
(*199*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2163*)
(*200*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note319 = this
*)
(* po redu: 2165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note318 and note319 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2166*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note320 = this
*)
(* po redu: 2167*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note317 and note320 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note321 = this
*)
(* po redu: 2169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note316 and note321 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2170*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note322 = this
*)
(* po redu: 2171*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
*)
(* po redu: 2172*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 2173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 2174*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 2175*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 2176*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 2177*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 2178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2179*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2180*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2182*)
(*201*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2183*)
(*202*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2184*)
(*203*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2185*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note323 = this
*)
(* po redu: 2186*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2187*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2188*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2189*)
(*204*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2190*)
(*205*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2191*)
(*206*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2192*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note324 = this
*)
(* po redu: 2193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2194*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2195*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 2196*)
(*207*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2197*)
(*208*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2198*)
(*209*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2199*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note325 = this
*)
(* po redu: 2200*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 2201*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2202*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2203*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2204*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 2205*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2206*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 2207*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 2208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2209*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 2210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 2211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2212*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2213*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2214*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2215*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2216*)
(*210*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2217*)
(*211*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2218*)
(*212*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2219*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note326 = this
*)
(* po redu: 2220*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2221*)
(*213*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2222*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2223*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2224*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2225*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2226*)
(*214*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2227*)
(*215*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2228*)
(*216*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2229*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note327 = this
*)
(* po redu: 2230*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note326 and note327 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2231*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note328 = this
*)
(* po redu: 2232*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note325 and note328 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 2233*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note329 = this
*)
(* po redu: 2234*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note324 and note329 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2235*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note330 = this
*)
(* po redu: 2236*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note323 and note330 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2237*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note331 = this
*)
(* po redu: 2238*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 2239*)
(*217*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2240*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 2241*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO6 LI2"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2242*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO6 LI3"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2244*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2245*)
(*218*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2246*)
(*219*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2247*)
(*220*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note332 = this
*)
(* po redu: 2249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2250*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2252*)
(*221*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2253*)
(*222*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2254*)
(*223*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2255*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note333 = this
*)
(* po redu: 2256*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2257*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2258*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 2259*)
(*224*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2260*)
(*225*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2261*)
(*226*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2262*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note334 = this
*)
(* po redu: 2263*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 2264*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2266*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2268*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2269*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2270*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2271*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2273*)
(*227*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2274*)
(*228*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2275*)
(*229*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2276*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note335 = this
*)
(* po redu: 2277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2278*)
(*230*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2279*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2281*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI6::line
where "inc_po_l PO6 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2283*)
(*231*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2284*)
(*232*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2285*)
(*233*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2286*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note336 = this
*)
(* po redu: 2287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note335 and note336 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2288*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note337 = this
*)
(* po redu: 2289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note334 and note337 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 2290*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note338 = this
*)
(* po redu: 2291*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note333 and note338 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note339 = this
*)
(* po redu: 2293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note332 and note339 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2294*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note340 = this
*)
(* po redu: 2295*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note331 and note340 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 2296*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note341 = this
*)
(* po redu: 2297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note322 and note341 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
*)
(* po redu: 2298*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note342 = this
*)
(* po redu: 2299*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note315 and note342 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 2300*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note343 = this
*)
(* po redu: 2301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO5"
*)
(* po redu: 2302*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1"
using ax_g5 [of "PO5" "PL1"]
by auto

*)
(* po redu: 2303*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO5 PL1"
*)
(* po redu: 2304*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 2305*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 2306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 2307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 2308*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 2309*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

*)
(* po redu: 2310*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 2312*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2314*)
(*234*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2315*)
(*235*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2316*)
(*236*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2317*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note344 = this
*)
(* po redu: 2318*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2319*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2320*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2321*)
(*237*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2322*)
(*238*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2323*)
(*239*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note345 = this
*)
(* po redu: 2325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2327*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2328*)
(*240*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2329*)
(*241*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2330*)
(*242*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2331*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note346 = this
*)
(* po redu: 2332*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2333*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2334*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2336*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 2337*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2338*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2340*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2341*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2342*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2343*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2344*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2345*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2347*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2348*)
(*243*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2349*)
(*244*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2350*)
(*245*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2351*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note347 = this
*)
(* po redu: 2352*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2353*)
(*246*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2354*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2356*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2357*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2358*)
(*247*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2359*)
(*248*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2360*)
(*249*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2361*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note348 = this
*)
(* po redu: 2362*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note347 and note348 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2363*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note349 = this
*)
(* po redu: 2364*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note346 and note349 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2365*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note350 = this
*)
(* po redu: 2366*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note345 and note350 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2367*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note351 = this
*)
(* po redu: 2368*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note344 and note351 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2369*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note352 = this
*)
(* po redu: 2370*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 2371*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2372*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
*)
(* po redu: 2373*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2374*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2375*)
(*250*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2376*)
(*251*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2377*)
(*252*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2378*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note353 = this
*)
(* po redu: 2379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2382*)
(*253*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2383*)
(*254*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2384*)
(*255*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2385*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note354 = this
*)
(* po redu: 2386*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2387*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2388*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2389*)
(*256*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2390*)
(*257*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2391*)
(*258*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2392*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note355 = this
*)
(* po redu: 2393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2394*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2395*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2396*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2397*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 2398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2400*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2401*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2402*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2403*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2404*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2405*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2406*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2407*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2408*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2409*)
(*259*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2410*)
(*260*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2411*)
(*261*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note356 = this
*)
(* po redu: 2413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2414*)
(*262*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2416*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2417*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2419*)
(*263*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2420*)
(*264*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2421*)
(*265*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2422*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note357 = this
*)
(* po redu: 2423*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note356 and note357 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2424*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note358 = this
*)
(* po redu: 2425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note355 and note358 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2426*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note359 = this
*)
(* po redu: 2427*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note354 and note359 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note360 = this
*)
(* po redu: 2429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note353 and note360 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2430*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note361 = this
*)
(* po redu: 2431*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
*)
(* po redu: 2432*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 2433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
*)
(* po redu: 2434*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2435*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2436*)
(*266*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2437*)
(*267*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2438*)
(*268*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2439*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note362 = this
*)
(* po redu: 2440*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2441*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2442*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2443*)
(*269*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2444*)
(*270*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2445*)
(*271*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2446*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note363 = this
*)
(* po redu: 2447*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2448*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2450*)
(*272*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2451*)
(*273*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2452*)
(*274*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2453*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note364 = this
*)
(* po redu: 2454*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2455*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2456*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2457*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2458*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 2459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2460*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2461*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2462*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2464*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2465*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2466*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2467*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2468*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2469*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2470*)
(*275*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2471*)
(*276*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2472*)
(*277*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2473*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note365 = this
*)
(* po redu: 2474*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2475*)
(*278*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2476*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2477*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2478*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2479*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2480*)
(*279*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2481*)
(*280*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2482*)
(*281*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2483*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note366 = this
*)
(* po redu: 2484*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note365 and note366 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2485*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note367 = this
*)
(* po redu: 2486*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note364 and note367 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2487*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note368 = this
*)
(* po redu: 2488*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note363 and note368 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2489*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note369 = this
*)
(* po redu: 2490*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note362 and note369 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2491*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note370 = this
*)
(* po redu: 2492*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
*)
(* po redu: 2493*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 2494*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 2495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 2496*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO6"]
by auto

*)
(* po redu: 2497*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 2498*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO5 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO6"]
by auto

*)
(* po redu: 2499*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO5 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO6"]
by auto

*)
(* po redu: 2500*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 2501*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO5 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO6"]
by auto

*)
(* po redu: 2502*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO5 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO5" "PO6" "PO6"]
by auto

*)
(* po redu: 2503*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO5 PO6 PO6 PO6"
using ax_D3 [of "PO5" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 2504*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 2505*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2506*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2507*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 2508*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2510*)
(*282*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2511*)
(*283*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2512*)
(*284*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2513*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note371 = this
*)
(* po redu: 2514*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2515*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2516*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2517*)
(*285*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2518*)
(*286*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2519*)
(*287*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2520*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note372 = this
*)
(* po redu: 2521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2522*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2523*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2524*)
(*288*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2525*)
(*289*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2526*)
(*290*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2527*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note373 = this
*)
(* po redu: 2528*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2529*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2530*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 2531*)
(*291*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2532*)
(*292*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2533*)
(*293*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2534*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note374 = this
*)
(* po redu: 2535*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 2536*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2538*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2539*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 2540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 2541*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2542*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2543*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO6" "PO7"]
by auto

*)
(* po redu: 2544*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2545*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 2546*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 2547*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2548*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2549*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO6 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO6" "PO7"]
by auto

*)
(* po redu: 2550*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2551*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO6 PO6 PO7"
using ax_D3 [of "PO5" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 2552*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO6 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 2553*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2554*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 2555*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 2556*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2557*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2558*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2559*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2560*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2561*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2562*)
(*294*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2563*)
(*295*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2564*)
(*296*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2565*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note375 = this
*)
(* po redu: 2566*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2567*)
(*297*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2568*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2569*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2571*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2572*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2573*)
(*298*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2574*)
(*299*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2575*)
(*300*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2576*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note376 = this
*)
(* po redu: 2577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note375 and note376 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2578*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note377 = this
*)
(* po redu: 2579*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note374 and note377 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 2580*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note378 = this
*)
(* po redu: 2581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note373 and note378 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2582*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note379 = this
*)
(* po redu: 2583*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note372 and note379 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2584*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note380 = this
*)
(* po redu: 2585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note371 and note380 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2586*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note381 = this
*)
(* po redu: 2587*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 2588*)
(*301*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2589*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 2590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2592*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 2593*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2594*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2595*)
(*302*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2596*)
(*303*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2597*)
(*304*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2598*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note382 = this
*)
(* po redu: 2599*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2600*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2602*)
(*305*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2603*)
(*306*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2604*)
(*307*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2605*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note383 = this
*)
(* po redu: 2606*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2608*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2609*)
(*308*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2610*)
(*309*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2611*)
(*310*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note384 = this
*)
(* po redu: 2613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 2616*)
(*311*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2617*)
(*312*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2618*)
(*313*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2619*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note385 = this
*)
(* po redu: 2620*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 2621*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2622*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2623*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2624*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO7"]
by auto

*)
(* po redu: 2625*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2626*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO5 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2627*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO5 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2628*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2629*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO5 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO7"]
by auto

*)
(* po redu: 2630*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO5 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO5" "PO7" "PO7"]
by auto

*)
(* po redu: 2631*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO5 PO7 PO7 PO7"
using ax_D3 [of "PO5" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2632*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2633*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2636*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2637*)
(*314*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2638*)
(*315*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2639*)
(*316*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2640*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note386 = this
*)
(* po redu: 2641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2642*)
(*317*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2643*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2644*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2645*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2647*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2648*)
(*318*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2649*)
(*319*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2650*)
(*320*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2651*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note387 = this
*)
(* po redu: 2652*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note386 and note387 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2653*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note388 = this
*)
(* po redu: 2654*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note385 and note388 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 2655*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note389 = this
*)
(* po redu: 2656*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note384 and note389 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2657*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note390 = this
*)
(* po redu: 2658*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note383 and note390 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2659*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note391 = this
*)
(* po redu: 2660*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note382 and note391 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2661*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note392 = this
*)
(* po redu: 2662*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note381 and note392 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 2663*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note393 = this
*)
(* po redu: 2664*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note370 and note393 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
*)
(* po redu: 2665*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note394 = this
*)
(* po redu: 2666*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note361 and note394 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
*)
(* po redu: 2667*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note395 = this
*)
(* po redu: 2668*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note352 and note395 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 2669*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note396 = this
*)
(* po redu: 2670*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO5 PL1"
*)
(* po redu: 2671*)
(*321*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2672*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO5 PL1`
have  "\<not>comp PO1 PO1 PO1 PO5"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO5"]
by auto

*)
(* po redu: 2673*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 2674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

*)
(* po redu: 2675*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO6 \<or> PO1 ~= PO6"
using ax_g1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2676*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO6"
*)
(* po redu: 2677*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2678*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2679*)
(*322*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2680*)
(*323*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2681*)
(*324*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2682*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note397 = this
*)
(* po redu: 2683*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2684*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2686*)
(*325*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2687*)
(*326*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2688*)
(*327*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2689*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note398 = this
*)
(* po redu: 2690*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2691*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2692*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2693*)
(*328*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2694*)
(*329*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2695*)
(*330*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2696*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note399 = this
*)
(* po redu: 2697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2698*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2699*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2700*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2701*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2702*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2704*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2705*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2707*)
(*331*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2708*)
(*332*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2709*)
(*333*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2710*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note400 = this
*)
(* po redu: 2711*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2712*)
(*334*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2713*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2714*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2715*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2716*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2717*)
(*335*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2718*)
(*336*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2719*)
(*337*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2720*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note401 = this
*)
(* po redu: 2721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note400 and note401 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2722*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note402 = this
*)
(* po redu: 2723*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note399 and note402 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2724*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note403 = this
*)
(* po redu: 2725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note398 and note403 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2726*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note404 = this
*)
(* po redu: 2727*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note397 and note404 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2728*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note405 = this
*)
(* po redu: 2729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO6"
*)
(* po redu: 2730*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO6 \<or> PO4 ~= PO6"
using ax_g1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2731*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO6"
*)
(* po redu: 2732*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2734*)
(*338*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2735*)
(*339*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2736*)
(*340*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2737*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note406 = this
*)
(* po redu: 2738*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2740*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2741*)
(*341*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2742*)
(*342*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2743*)
(*343*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note407 = this
*)
(* po redu: 2745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2746*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2747*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2748*)
(*344*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2749*)
(*345*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2750*)
(*346*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2751*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note408 = this
*)
(* po redu: 2752*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2753*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2754*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2755*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2756*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2757*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2758*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2759*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2760*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2761*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2762*)
(*347*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2763*)
(*348*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2764*)
(*349*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2765*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note409 = this
*)
(* po redu: 2766*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2767*)
(*350*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2768*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2769*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2770*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2771*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2772*)
(*351*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2773*)
(*352*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2774*)
(*353*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2775*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note410 = this
*)
(* po redu: 2776*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note409 and note410 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2777*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note411 = this
*)
(* po redu: 2778*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note408 and note411 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2779*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note412 = this
*)
(* po redu: 2780*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note407 and note412 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2781*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note413 = this
*)
(* po redu: 2782*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note406 and note413 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2783*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note414 = this
*)
(* po redu: 2784*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO6"
*)
(* po redu: 2785*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO6 \<or> PO5 ~= PO6"
using ax_g1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 2786*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO6"
*)
(* po redu: 2787*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2788*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2789*)
(*354*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2790*)
(*355*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2791*)
(*356*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2792*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note415 = this
*)
(* po redu: 2793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2794*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2795*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2796*)
(*357*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2797*)
(*358*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2798*)
(*359*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2799*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note416 = this
*)
(* po redu: 2800*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2801*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2802*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2803*)
(*360*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2804*)
(*361*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2805*)
(*362*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2806*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note417 = this
*)
(* po redu: 2807*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2808*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2809*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2810*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2812*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2813*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2814*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2816*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2817*)
(*363*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2818*)
(*364*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2819*)
(*365*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2820*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note418 = this
*)
(* po redu: 2821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2822*)
(*366*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2823*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2824*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO7 LI4"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2825*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO7 LI5"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2826*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO7 LI6"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2827*)
(*367*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2828*)
(*368*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2829*)
(*369*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2830*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note419 = this
*)
(* po redu: 2831*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note418 and note419 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2832*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note420 = this
*)
(* po redu: 2833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note417 and note420 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2834*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note421 = this
*)
(* po redu: 2835*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note416 and note421 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2836*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note422 = this
*)
(* po redu: 2837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note415 and note422 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2838*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note423 = this
*)
(* po redu: 2839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO6"
*)
(* po redu: 2840*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1"
using ax_g5 [of "PO6" "PL1"]
by auto

*)
(* po redu: 2841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO6 PL1"
*)
(* po redu: 2842*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO1 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO6"]
by auto

*)
(* po redu: 2843*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO1 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO6"]
by auto

*)
(* po redu: 2844*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO1 PO6 PO6 PO6"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 2845*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1`
have  "comp PO6 PO6 PO6 PO6"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO6"]
by auto

*)
(* po redu: 2846*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2847*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2848*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 2849*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2850*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2851*)
(*370*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2852*)
(*371*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2853*)
(*372*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2854*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note424 = this
*)
(* po redu: 2855*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2856*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2857*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2858*)
(*373*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2859*)
(*374*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2860*)
(*375*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2861*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note425 = this
*)
(* po redu: 2862*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2863*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2864*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2865*)
(*376*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2866*)
(*377*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2867*)
(*378*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2868*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note426 = this
*)
(* po redu: 2869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2870*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2871*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 2872*)
(*379*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2873*)
(*380*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2874*)
(*381*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2875*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note427 = this
*)
(* po redu: 2876*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 2877*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2878*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2879*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2880*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO6" "PO7"]
by auto

*)
(* po redu: 2881*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2882*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO6 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 2883*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO6 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 2884*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2885*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO6 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO6" "PO7"]
by auto

*)
(* po redu: 2886*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO6 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO6" "PO7" "PO7"]
by auto

*)
(* po redu: 2887*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO6 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO6 PO7 PO7 PO7"
using ax_D3 [of "PO6" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2888*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2889*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2890*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2891*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2892*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2893*)
(*382*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2894*)
(*383*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2895*)
(*384*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2896*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note428 = this
*)
(* po redu: 2897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2898*)
(*385*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2899*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2900*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2901*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2902*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2903*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2904*)
(*386*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2905*)
(*387*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2906*)
(*388*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2907*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note429 = this
*)
(* po redu: 2908*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note428 and note429 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2909*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note430 = this
*)
(* po redu: 2910*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note427 and note430 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 2911*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note431 = this
*)
(* po redu: 2912*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note426 and note431 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2913*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note432 = this
*)
(* po redu: 2914*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note425 and note432 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2915*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note433 = this
*)
(* po redu: 2916*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note424 and note433 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2917*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note434 = this
*)
(* po redu: 2918*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO6 PL1"
*)
(* po redu: 2919*)
(*389*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2920*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO6 PL1`
have  "\<not>comp PO1 PO1 PO1 PO6"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO6"]
by auto

*)
(* po redu: 2921*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO6`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO6 LI4"
using ax_I1 [of "PO1" "PO6"]
by auto

*)
(* po redu: 2922*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO6`
obtain  LI5::line
where "inc_po_l PO4 LI5" and "inc_po_l PO6 LI5"
using ax_I1 [of "PO4" "PO6"]
by auto

*)
(* po redu: 2923*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO6`
obtain  LI6::line
where "inc_po_l PO5 LI6" and "inc_po_l PO6 LI6"
using ax_I1 [of "PO5" "PO6"]
by auto

*)
(* po redu: 2924*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO7 \<or> PO1 ~= PO7"
using ax_g1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO7"
*)
(* po redu: 2926*)
(*390*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2927*)
(*391*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2928*)
(*392*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2929*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note435 = this
*)
(* po redu: 2930*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO7"
*)
(* po redu: 2931*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO7 \<or> PO4 ~= PO7"
using ax_g1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2932*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO7"
*)
(* po redu: 2933*)
(*393*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2934*)
(*394*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2935*)
(*395*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2936*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note436 = this
*)
(* po redu: 2937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO7"
*)
(* po redu: 2938*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO5 = PO7 \<or> PO5 ~= PO7"
using ax_g1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2939*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 = PO7"
*)
(* po redu: 2940*)
(*396*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2941*)
(*397*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2942*)
(*398*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2943*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note437 = this
*)
(* po redu: 2944*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO5 ~= PO7"
*)
(* po redu: 2945*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO6 = PO7 \<or> PO6 ~= PO7"
using ax_g1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2946*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 = PO7"
*)
(* po redu: 2947*)
(*399*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2948*)
(*400*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2949*)
(*401*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2950*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note438 = this
*)
(* po redu: 2951*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO6 ~= PO7"
*)
(* po redu: 2952*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1"
using ax_g5 [of "PO7" "PL1"]
by auto

*)
(* po redu: 2953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO7 PL1"
*)
(* po redu: 2954*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO1 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO7"]
by auto

*)
(* po redu: 2955*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO1 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO1" "PO7" "PO7"]
by auto

*)
(* po redu: 2956*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO1 PO7 PO7 PO7"
using ax_D3 [of "PO1" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2957*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1` and `inc_po_pl PO7 PL1`
have  "comp PO7 PO7 PO7 PO7"
using ax_D3 [of "PO7" "PL1" "PO7" "PO7" "PO7"]
by auto

*)
(* po redu: 2958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2959*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2960*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2961*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2962*)
(*402*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2963*)
(*403*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2964*)
(*404*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2965*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note439 = this
*)
(* po redu: 2966*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO7 PL1"
*)
(* po redu: 2967*)
(*405*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2968*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO7 PL1`
have  "\<not>comp PO1 PO1 PO1 PO7"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO7"]
by auto

*)
(* po redu: 2969*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO7`
obtain  LI7::line
where "inc_po_l PO1 LI7" and "inc_po_l PO7 LI7"
using ax_I1 [of "PO1" "PO7"]
by auto

*)
(* po redu: 2970*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO7`
obtain  LI8::line
where "inc_po_l PO4 LI8" and "inc_po_l PO7 LI8"
using ax_I1 [of "PO4" "PO7"]
by auto

*)
(* po redu: 2971*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO5 ~= PO7`
obtain  LI9::line
where "inc_po_l PO5 LI9" and "inc_po_l PO7 LI9"
using ax_I1 [of "PO5" "PO7"]
by auto

*)
(* po redu: 2972*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO6 ~= PO7`
obtain  LI10::line
where "inc_po_l PO6 LI10" and "inc_po_l PO7 LI10"
using ax_I1 [of "PO6" "PO7"]
by auto

*)
(* po redu: 2973*)
(*406*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 2974*)
(*407*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 2975*)
(*408*)  (*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

(* po redu: 2976*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note440 = this
*)
(* po redu: 2977*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note439 and note440 and `inc_po_pl PO7 PL1 \<or> \<not>inc_po_pl PO7 PL1`
have False
by auto
*)
(* po redu: 2978*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note441 = this
*)
(* po redu: 2979*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note438 and note441 and `PO6 = PO7 \<or> PO6 ~= PO7`
have False
by auto
*)
(* po redu: 2980*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note442 = this
*)
(* po redu: 2981*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note437 and note442 and `PO5 = PO7 \<or> PO5 ~= PO7`
have False
by auto
*)
(* po redu: 2982*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note443 = this
*)
(* po redu: 2983*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note436 and note443 and `PO4 = PO7 \<or> PO4 ~= PO7`
have False
by auto
*)
(* po redu: 2984*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note444 = this
*)
(* po redu: 2985*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note435 and note444 and `PO1 = PO7 \<or> PO1 ~= PO7`
have False
by auto
*)
(* po redu: 2986*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note445 = this
*)
(* po redu: 2987*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note434 and note445 and `inc_po_pl PO6 PL1 \<or> \<not>inc_po_pl PO6 PL1`
have False
by auto
*)
(* po redu: 2988*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note446 = this
*)
(* po redu: 2989*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note423 and note446 and `PO5 = PO6 \<or> PO5 ~= PO6`
have False
by auto
*)
(* po redu: 2990*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note447 = this
*)
(* po redu: 2991*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note414 and note447 and `PO4 = PO6 \<or> PO4 ~= PO6`
have False
by auto
*)
(* po redu: 2992*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note448 = this
*)
(* po redu: 2993*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note405 and note448 and `PO1 = PO6 \<or> PO1 ~= PO6`
have False
by auto
*)
(* po redu: 2994*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note449 = this
*)
(* po redu: 2995*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note396 and note449 and `inc_po_pl PO5 PL1 \<or> \<not>inc_po_pl PO5 PL1`
have False
by auto
*)
(* po redu: 2996*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note450 = this
*)
(* po redu: 2997*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note343 and note450 and `PO4 = PO5 \<or> PO4 ~= PO5`
have False
by auto
*)
(* po redu: 2998*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note451 = this
*)
(* po redu: 2999*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note308 and note451 and `PO1 = PO5 \<or> PO1 ~= PO5`
have False
by auto
*)
(* po redu: 3000*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note452 = this
*)
(* po redu: 3001*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note273 and note452 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have False
by auto
*)
(* po redu: 3002*)
(*409*)  (*BRANCH NAME*)
} note note453 = this
(* po redu: 3003*)
(*410*)  
(*BRANCH END*)
from note94 and note453 and `PO1 = PO4 \<or> PO1 ~= PO4`
have False
by auto
(* po redu: 3004*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note454 = this
*)
(* po redu: 3005*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1 and note454 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have False
by auto
*)
(* po redu: 3006*)
(*411*)  (*BRANCH NAME*)
} note note455 = this
(* po redu: 3007*)
(*412*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 3008*)
(*413*)  (*REGULAR*)
moreover
from `PO1 ~= PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO3 LI1"
using ax_I1 [of "PO1" "PO3"]
by auto

(* po redu: 3009*)
(*414*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(* po redu: 3010*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1"
using ax_I4a [of "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 3011*)
(*415*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 3012*)
(*416*)  (*BRANCH NAME*)
} note note456 = this
(* po redu: 3013*)
(*417*)  
(*BRANCH END*)
from note455 and note456 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 3014*)
(*418*)  (*BRANCH NAME*)
} note note457 = this
(* po redu: 3015*)
(*419*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 3016*)
(*420*)  (*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(* po redu: 3017*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 3018*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
*)
(* po redu: 3019*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

*)
(* po redu: 3020*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO1`
have  "\<not>col PO1 PO1 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO1"]
by auto

*)
(* po redu: 3021*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1"
using ax_I4a [of "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 3022*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 3023*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note458 = this
*)
(* po redu: 3024*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
*)
(* po redu: 3025*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

*)
(* po redu: 3026*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO3"
*)
(* po redu: 3027*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

*)
(* po redu: 3028*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1"
using ax_I4a [of "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 3029*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 3030*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note459 = this
*)
(* po redu: 3031*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO3"
*)
(* po redu: 3032*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 3033*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

*)
(* po redu: 3034*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1"
using ax_I4a [of "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 3035*)
(*421*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 3036*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note460 = this
*)
(* po redu: 3037*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note459 and note460 and `PO2 = PO3 \<or> PO2 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 3038*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note461 = this
*)
(* po redu: 3039*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note458 and note461 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 3040*)
(*422*)  (*BRANCH NAME*)
} note note462 = this
(* po redu: 3041*)
(*423*)  
(*BRANCH END*)
from note457 and note462 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
