theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th14:
shows " ( \<exists>  (PO1::point). \<not>inc_po_l PO1 LI1)"
proof -

(* po redu: 1*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

*)
(* po redu: 2*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
*)
(* po redu: 3*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 4*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 5*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1 = this
*)
(* po redu: 6*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
*)
(* po redu: 7*)
(*1*)  (*REGULAR*)

obtain  PO1::point and  PO2::point
where "inc_po_l PO1 LI1" and "PO1 ~= PO2" and "inc_po_l PO2 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 8*)
(*2*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 9*)
(*3*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(* po redu: 10*)
(*4*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(* po redu: 11*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 12*)
(*5*)  (*REGULAR*)
moreover

obtain  PO3::point and  PO4::point
where "\<not>col PO1 PO3 PO4"
using ax_ml_I3b_1 [of "PO1"]
by auto

(* po redu: 13*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 14*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
*)
(* po redu: 15*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 16*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 17*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO1 = PO3` and `PO1 = PO4`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 18*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO1` and `\<not>col PO1 PO1 PO1`
have False
by auto

*)
(* po redu: 19*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note2 = this
*)
(* po redu: 20*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 21*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 22*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 23*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO1 = PO3` and `PO2 = PO4`
have "\<not>col PO1 PO1 PO2"
by auto

*)
(* po redu: 24*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO2` and `\<not>col PO1 PO1 PO2`
have False
by auto

*)
(* po redu: 25*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note3 = this
*)
(* po redu: 26*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 27*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

*)
(* po redu: 28*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
*)
(* po redu: 29*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI1" "PO1" "PO4"]
by auto

*)
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO4"
by auto

*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO4` and `\<not>col PO1 PO1 PO4`
have False
by auto

*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note4 = this
*)
(* po redu: 33*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
*)
(* po redu: 34*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note5 = this
*)
(* po redu: 35*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note4 and note5 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
*)
(* po redu: 36*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note6 = this
*)
(* po redu: 37*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note3 and note6 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 38*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note7 = this
*)
(* po redu: 39*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note2 and note7 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note8 = this
*)
(* po redu: 41*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
*)
(* po redu: 42*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

*)
(* po redu: 43*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO3"
*)
(* po redu: 44*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO2 = PO3` and `PO1 = PO4`
have "\<not>col PO1 PO2 PO1"
by auto

*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO1`
have  "\<not>col PO1 PO1 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO1"]
by auto

*)
(* po redu: 48*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO2` and `\<not>col PO1 PO1 PO2`
have False
by auto

*)
(* po redu: 49*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note9 = this
*)
(* po redu: 50*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 51*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 52*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 53*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO2 = PO3` and `PO2 = PO4`
have "\<not>col PO1 PO2 PO2"
by auto

*)
(* po redu: 54*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO2` and `\<not>col PO1 PO2 PO2`
have False
by auto

*)
(* po redu: 55*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note10 = this
*)
(* po redu: 56*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 57*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

*)
(* po redu: 58*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
*)
(* po redu: 59*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI1" "PO1" "PO4"]
by auto

*)
(* po redu: 60*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

*)
(* po redu: 61*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO4"
by auto

*)
(* po redu: 62*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 63*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note11 = this
*)
(* po redu: 64*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
*)
(* po redu: 65*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note12 = this
*)
(* po redu: 66*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note11 and note12 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
*)
(* po redu: 67*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note13 = this
*)
(* po redu: 68*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note10 and note13 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 69*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note14 = this
*)
(* po redu: 70*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note9 and note14 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note15 = this
*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO3"
*)
(* po redu: 73*)
(*6*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(* po redu: 74*)
(*7*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI1"
(* po redu: 75*)
(*8*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(* po redu: 76*)
(*9*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(* po redu: 77*)
(*10*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(* po redu: 78*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

*)
(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO1 = PO4`
have "\<not>col PO1 PO3 PO1"
by auto

*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO1`
have  "\<not>col PO1 PO1 PO3"
using ax_ncol_132 [of "PO1" "PO3" "PO1"]
by auto

*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO3` and `col PO1 PO1 PO3`
have False
by auto

*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note16 = this
*)
(* po redu: 87*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 88*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 89*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO2 = PO4`
have "\<not>col PO1 PO3 PO2"
by auto

*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_132 [of "PO1" "PO3" "PO2"]
by auto

*)
(* po redu: 92*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `col PO1 PO2 PO3`
have False
by auto

*)
(* po redu: 93*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note17 = this
*)
(* po redu: 94*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 95*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

*)
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
*)
(* po redu: 97*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO3 PO4` and `PO3 = PO4`
have "\<not>col PO1 PO3 PO3"
by auto

*)
(* po redu: 98*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO3` and `col PO1 PO3 PO3`
have False
by auto

*)
(* po redu: 99*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note18 = this
*)
(* po redu: 100*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
*)
(* po redu: 101*)
(*11*)  (*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(* po redu: 102*)
(*12*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
(* po redu: 103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI1" "PO1" "PO4"]
by auto

*)
(* po redu: 104*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

*)
(* po redu: 105*)
(*13*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI1" "PO3" "PO4"]
by auto

(* po redu: 106*)
(*14*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 107*)
(*15*)  (*BRANCH NAME*)
} note note19 = this
(* po redu: 108*)
(*16*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(* po redu: 109*)
(*17*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note20 = this
(* po redu: 110*)
(*18*)  
(*BRANCH END*)
from note19 and note20 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(* po redu: 111*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note21 = this
*)
(* po redu: 112*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note18 and note21 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 113*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note22 = this
*)
(* po redu: 114*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note17 and note22 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 115*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note23 = this
*)
(* po redu: 116*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note23 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 117*)
(*19*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note24 = this
(* po redu: 118*)
(*20*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(* po redu: 119*)
(*21*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note25 = this
(* po redu: 120*)
(*22*)  
(*BRANCH END*)
from note24 and note25 and `inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(* po redu: 121*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note26 = this
*)
(* po redu: 122*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note15 and note26 and `PO2 = PO3 \<or> PO2 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 123*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note27 = this
*)
(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note8 and note27 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note28 = this
*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1 and note28 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
*)
from this
show ?thesis
by auto
qed
