theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th15:
assumes "inc_l_pl LI1 PL1"
and "inc_l_pl LI2 PL1"
shows " ( \<exists>  (PO1::point). inc_po_l PO1 LI1 & inc_po_l PO1 LI2) \<or>  (\<not>int_l_l LI1 LI2)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(* po redu: 2*)
(*2*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
(* po redu: 3*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"
using ax_D6a [of "LI1" "LI2"]
by auto

*)
(* po redu: 4*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI2"
*)
(* po redu: 5*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

*)
(* po redu: 6*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
*)
(* po redu: 7*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 8*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 9*)
(*3*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 10*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 11*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 12*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 13*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 14*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 15*)
(*5*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 16*)
(*6*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 17*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1 = this
*)
(* po redu: 18*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 19*)
(*7*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 20*)
(*8*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 21*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note2 = this
*)
(* po redu: 22*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1 and note2 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 23*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note3 = this
*)
(* po redu: 24*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 25*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 26*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 27*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI2 PL1` and `LI1 = LI2`
have False
by auto

*)
(* po redu: 28*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note4 = this
*)
(* po redu: 29*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note5 = this
*)
(* po redu: 33*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note4 and note5 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 34*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note6 = this
*)
(* po redu: 35*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note3 and note6 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 36*)
(*9*)  (*BRANCH NAME*)
} note note7 = this
(* po redu: 37*)
(*10*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 38*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 39*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 41*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 42*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI2 PL1` and `LI1 = LI2`
have False
by auto

*)
(* po redu: 43*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note8 = this
*)
(* po redu: 44*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note9 = this
*)
(* po redu: 48*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note8 and note9 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 49*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note10 = this
*)
(* po redu: 50*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 51*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 52*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 53*)
(*11*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 54*)
(*12*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 55*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note11 = this
*)
(* po redu: 56*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 57*)
(*13*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 58*)
(*14*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 59*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note12 = this
*)
(* po redu: 60*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note11 and note12 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 61*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note13 = this
*)
(* po redu: 62*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note10 and note13 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 63*)
(*15*)  (*BRANCH NAME*)
} note note14 = this
(* po redu: 64*)
(*16*)  
(*BRANCH END*)
from note7 and note14 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 65*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note15 = this
*)
(* po redu: 66*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 67*)
(*17*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 68*)
(*18*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 69*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 70*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 73*)
(*19*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 74*)
(*20*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 75*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note16 = this
*)
(* po redu: 76*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 77*)
(*21*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 78*)
(*22*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note17 = this
*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note17 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note18 = this
*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI2 PL1` and `LI1 = LI2`
have False
by auto

*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note19 = this
*)
(* po redu: 87*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 88*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 89*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note20 = this
*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note19 and note20 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 92*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note21 = this
*)
(* po redu: 93*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note18 and note21 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 94*)
(*23*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 95*)
(*24*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 97*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 98*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 99*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 100*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI2 PL1` and `LI1 = LI2`
have False
by auto

*)
(* po redu: 101*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note23 = this
*)
(* po redu: 102*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 104*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 105*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note24 = this
*)
(* po redu: 106*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note23 and note24 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 107*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note25 = this
*)
(* po redu: 108*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 109*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 110*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 111*)
(*25*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 112*)
(*26*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 113*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note26 = this
*)
(* po redu: 114*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 115*)
(*27*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 116*)
(*28*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 117*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note27 = this
*)
(* po redu: 118*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note26 and note27 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 119*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note28 = this
*)
(* po redu: 120*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note25 and note28 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 121*)
(*29*)  (*BRANCH NAME*)
} note note29 = this
(* po redu: 122*)
(*30*)  
(*BRANCH END*)
from note22 and note29 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
(* po redu: 123*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note30 = this
*)
(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note15 and note30 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have False
by auto
*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note31 = this
*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
*)
(* po redu: 127*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 128*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 129*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 130*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 132*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 133*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 134*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 135*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI2` and `LI1 = LI2` and `LI1 = LI2`
have "\<not>int_l_l LI1 LI1"
by auto

*)
(* po redu: 136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1` and `\<not>int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 137*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note32 = this
*)
(* po redu: 138*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 139*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 140*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 141*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note33 = this
*)
(* po redu: 142*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note32 and note33 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 143*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note34 = this
*)
(* po redu: 144*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 145*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 146*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 147*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI2` and `LI1 = LI2` and `LI1 = LI2`
have "\<not>int_l_l LI1 LI1"
by auto

*)
(* po redu: 148*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1` and `\<not>int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 149*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note35 = this
*)
(* po redu: 150*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 151*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 152*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 153*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note36 = this
*)
(* po redu: 154*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note35 and note36 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 155*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note37 = this
*)
(* po redu: 156*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note34 and note37 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 157*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note38 = this
*)
(* po redu: 158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 160*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 161*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 162*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 163*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI2` and `LI1 = LI2` and `LI1 = LI2`
have "\<not>int_l_l LI1 LI1"
by auto

*)
(* po redu: 164*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1` and `\<not>int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 165*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note39 = this
*)
(* po redu: 166*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 168*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 169*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note40 = this
*)
(* po redu: 170*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note39 and note40 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 171*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note41 = this
*)
(* po redu: 172*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 173*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 174*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 175*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI2` and `LI1 = LI2` and `LI1 = LI2`
have "\<not>int_l_l LI1 LI1"
by auto

*)
(* po redu: 176*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1` and `\<not>int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 177*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note42 = this
*)
(* po redu: 178*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 179*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 180*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 181*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note43 = this
*)
(* po redu: 182*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note42 and note43 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 183*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note44 = this
*)
(* po redu: 184*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note41 and note44 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 185*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note45 = this
*)
(* po redu: 186*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note38 and note45 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 187*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note46 = this
*)
(* po redu: 188*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 189*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 190*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 191*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 192*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 193*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 194*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 195*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI2` and `LI1 = LI2` and `LI1 = LI2`
have "\<not>int_l_l LI1 LI1"
by auto

*)
(* po redu: 196*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1` and `\<not>int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 197*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note47 = this
*)
(* po redu: 198*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 200*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 201*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note48 = this
*)
(* po redu: 202*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note47 and note48 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 203*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note49 = this
*)
(* po redu: 204*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 205*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 206*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 207*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI2` and `LI1 = LI2` and `LI1 = LI2`
have "\<not>int_l_l LI1 LI1"
by auto

*)
(* po redu: 208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1` and `\<not>int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 209*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note50 = this
*)
(* po redu: 210*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 212*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 213*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note51 = this
*)
(* po redu: 214*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note50 and note51 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 215*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note52 = this
*)
(* po redu: 216*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note49 and note52 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 217*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note53 = this
*)
(* po redu: 218*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 219*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 220*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 221*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 222*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 223*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI2` and `LI1 = LI2` and `LI1 = LI2`
have "\<not>int_l_l LI1 LI1"
by auto

*)
(* po redu: 224*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1` and `\<not>int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 225*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note54 = this
*)
(* po redu: 226*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 228*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 229*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note55 = this
*)
(* po redu: 230*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note54 and note55 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 231*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note56 = this
*)
(* po redu: 232*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 233*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 234*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 235*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI2` and `LI1 = LI2` and `LI1 = LI2`
have "\<not>int_l_l LI1 LI1"
by auto

*)
(* po redu: 236*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1` and `\<not>int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 237*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note57 = this
*)
(* po redu: 238*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 239*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 240*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 241*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note58 = this
*)
(* po redu: 242*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note57 and note58 and `LI1 = LI2 \<or> LI1 ~= LI2`
have False
by auto
*)
(* po redu: 243*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note59 = this
*)
(* po redu: 244*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note56 and note59 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 245*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note60 = this
*)
(* po redu: 246*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note53 and note60 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 247*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note61 = this
*)
(* po redu: 248*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note46 and note61 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have False
by auto
*)
(* po redu: 249*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note62 = this
*)
(* po redu: 250*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note31 and note62 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have False
by auto
*)
(* po redu: 251*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note63 = this
*)
(* po redu: 252*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI2"
*)
(* po redu: 253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END THESIS*)
moreover 
from `\<not>int_l_l LI1 LI2`
have ?thesis
by auto
*)
(* po redu: 254*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from `\<not>int_l_l LI1 LI2`
have ?thesis
by auto
*)
(* po redu: 255*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note64 = this
*)
(* po redu: 256*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note63 and note64 and `int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2`
have ?thesis
by auto
*)
(* po redu: 257*)
(*31*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note65 = this
(* po redu: 258*)
(*32*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
(* po redu: 259*)
(*33*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"
using ax_D6a [of "LI1" "LI2"]
by auto

(* po redu: 260*)
(*34*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI2"
(* po redu: 261*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

*)
(* po redu: 262*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
*)
(* po redu: 263*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 264*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 265*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 266*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 268*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 269*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 270*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 271*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 273*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note66 = this
*)
(* po redu: 274*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 275*)
(*35*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 276*)
(*36*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 277*)
(*37*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 278*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note67 = this
*)
(* po redu: 279*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note66 and note67 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 280*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note68 = this
*)
(* po redu: 281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 284*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 285*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 286*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note69 = this
*)
(* po redu: 287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 288*)
(*38*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 289*)
(*39*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 290*)
(*40*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 291*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note70 = this
*)
(* po redu: 292*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note69 and note70 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 293*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note71 = this
*)
(* po redu: 294*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note68 and note71 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 295*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note72 = this
*)
(* po redu: 296*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 297*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 298*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 300*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 301*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 302*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 303*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note73 = this
*)
(* po redu: 304*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 305*)
(*41*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 306*)
(*42*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 307*)
(*43*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note74 = this
*)
(* po redu: 309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note73 and note74 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 310*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note75 = this
*)
(* po redu: 311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 312*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 314*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 315*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 316*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note76 = this
*)
(* po redu: 317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 318*)
(*44*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 319*)
(*45*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 320*)
(*46*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 321*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note77 = this
*)
(* po redu: 322*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note76 and note77 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 323*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note78 = this
*)
(* po redu: 324*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note75 and note78 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 325*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note79 = this
*)
(* po redu: 326*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note72 and note79 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 327*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note80 = this
*)
(* po redu: 328*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 329*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 330*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 331*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 332*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 333*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 334*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 335*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 336*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 337*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note81 = this
*)
(* po redu: 338*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 339*)
(*47*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 340*)
(*48*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 341*)
(*49*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 342*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note82 = this
*)
(* po redu: 343*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note81 and note82 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note83 = this
*)
(* po redu: 345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 347*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 348*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 349*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 350*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note84 = this
*)
(* po redu: 351*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 352*)
(*50*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 353*)
(*51*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 354*)
(*52*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 355*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note85 = this
*)
(* po redu: 356*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note84 and note85 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 357*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note86 = this
*)
(* po redu: 358*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note83 and note86 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 359*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note87 = this
*)
(* po redu: 360*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 361*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 362*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 364*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 365*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 366*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 367*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note88 = this
*)
(* po redu: 368*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 369*)
(*53*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 370*)
(*54*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 371*)
(*55*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note89 = this
*)
(* po redu: 373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note88 and note89 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 374*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note90 = this
*)
(* po redu: 375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 376*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 378*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 379*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 380*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note91 = this
*)
(* po redu: 381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 382*)
(*56*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 383*)
(*57*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 384*)
(*58*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 385*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note92 = this
*)
(* po redu: 386*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note91 and note92 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 387*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note93 = this
*)
(* po redu: 388*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note90 and note93 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 389*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note94 = this
*)
(* po redu: 390*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note87 and note94 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 391*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note95 = this
*)
(* po redu: 392*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note80 and note95 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
(* po redu: 393*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note96 = this
*)
(* po redu: 394*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
*)
(* po redu: 395*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 396*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 397*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 398*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 400*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 401*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 402*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 403*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 404*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 405*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note97 = this
*)
(* po redu: 406*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 407*)
(*59*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 408*)
(*60*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 409*)
(*61*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 410*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note98 = this
*)
(* po redu: 411*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note97 and note98 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note99 = this
*)
(* po redu: 413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 414*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 415*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 416*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 417*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 418*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note100 = this
*)
(* po redu: 419*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 420*)
(*62*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 421*)
(*63*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 422*)
(*64*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 423*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note101 = this
*)
(* po redu: 424*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note100 and note101 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 425*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note102 = this
*)
(* po redu: 426*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note99 and note102 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 427*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note103 = this
*)
(* po redu: 428*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 429*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 430*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 432*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 433*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 434*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 435*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note104 = this
*)
(* po redu: 436*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 437*)
(*65*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 438*)
(*66*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 439*)
(*67*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 440*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note105 = this
*)
(* po redu: 441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note104 and note105 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 442*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note106 = this
*)
(* po redu: 443*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 444*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 446*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note107 = this
*)
(* po redu: 449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 450*)
(*68*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 451*)
(*69*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 452*)
(*70*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 453*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note108 = this
*)
(* po redu: 454*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note107 and note108 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 455*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note109 = this
*)
(* po redu: 456*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note106 and note109 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 457*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note110 = this
*)
(* po redu: 458*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note103 and note110 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 459*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note111 = this
*)
(* po redu: 460*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 461*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 462*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 464*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 465*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 466*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 467*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 468*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 469*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note112 = this
*)
(* po redu: 470*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 471*)
(*71*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 472*)
(*72*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 473*)
(*73*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 474*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note113 = this
*)
(* po redu: 475*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note112 and note113 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note114 = this
*)
(* po redu: 477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 478*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 479*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 480*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 481*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 482*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note115 = this
*)
(* po redu: 483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 484*)
(*74*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 485*)
(*75*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 486*)
(*76*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 487*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note116 = this
*)
(* po redu: 488*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note115 and note116 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 489*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note117 = this
*)
(* po redu: 490*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note114 and note117 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 491*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note118 = this
*)
(* po redu: 492*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 493*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 494*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 496*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 497*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 498*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 499*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note119 = this
*)
(* po redu: 500*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 501*)
(*77*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 502*)
(*78*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 503*)
(*79*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 504*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note120 = this
*)
(* po redu: 505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note119 and note120 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 506*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note121 = this
*)
(* po redu: 507*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 508*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

*)
(* po redu: 509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI2"
*)
(* po redu: 510*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI2` and `LI1 = LI2`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 511*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 512*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note122 = this
*)
(* po redu: 513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI2"
*)
(* po redu: 514*)
(*80*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI2`
obtain  PO1::point
where "inc_po_l PO1 LI1" and "inc_po_l PO1 LI2" and "LI1 ~= LI2"
using ax_D6 [of "LI1" "LI2"]
by auto

(* po redu: 515*)
(*81*)  
(*BRANCH END THESIS*)
moreover 
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have ?thesis
by auto
(* po redu: 516*)
(*82*)  
(*BRANCH END*)
from `(inc_po_l PO1 LI1 and inc_po_l PO1 LI2)`
have ?thesis
by auto
(* po redu: 517*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note123 = this
*)
(* po redu: 518*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note122 and note123 and `LI1 = LI2 \<or> LI1 ~= LI2`
have ?thesis
by auto
*)
(* po redu: 519*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note124 = this
*)
(* po redu: 520*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note121 and note124 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 521*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note125 = this
*)
(* po redu: 522*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note118 and note125 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 523*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note126 = this
*)
(* po redu: 524*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note111 and note126 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
(* po redu: 525*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note127 = this
*)
(* po redu: 526*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note96 and note127 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have ?thesis
by auto
*)
(* po redu: 527*)
(*83*)  (*BRANCH NAME*)
} note note128 = this
(* po redu: 528*)
(*84*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI2"
(* po redu: 529*)
(*85*)  
(*BRANCH END THESIS*)
moreover 
from `\<not>int_l_l LI1 LI2`
have ?thesis
by auto
(* po redu: 530*)
(*86*)  
(*BRANCH END*)
from `\<not>int_l_l LI1 LI2`
have ?thesis
by auto
(* po redu: 531*)
(*87*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note129 = this
(* po redu: 532*)
(*88*)  
(*BRANCH END*)
from note128 and note129 and `int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2`
have ?thesis
by auto
(* po redu: 533*)
(*89*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note130 = this
(* po redu: 534*)
(*90*)  
(*BRANCH END*)
from note65 and note130 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
