theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th18:
assumes "PL1 ~= PL2"
and "inc_l_pl LI1 PL1"
and "inc_l_pl LI1 PL2"
and "inc_po_pl PO1 PL1"
and "inc_po_pl PO1 PL2"
shows " (inc_po_l PO1 LI1)"
proof -

(* po redu: 1*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 2*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

*)
(* po redu: 4*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
*)
(* po redu: 5*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 6*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 7*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 8*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 9*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 10*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 11*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 12*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 13*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 14*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 15*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1 = this
*)
(* po redu: 16*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 17*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 18*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 19*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note2 = this
*)
(* po redu: 20*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1 and note2 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 21*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note3 = this
*)
(* po redu: 22*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 23*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 24*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 25*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note4 = this
*)
(* po redu: 26*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 27*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 28*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 29*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note5 = this
*)
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note4 and note5 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note6 = this
*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note3 and note6 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 33*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note7 = this
*)
(* po redu: 34*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 35*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 36*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 37*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 38*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 39*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note8 = this
*)
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 41*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 42*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 43*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note9 = this
*)
(* po redu: 44*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note8 and note9 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note10 = this
*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 48*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 49*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note11 = this
*)
(* po redu: 50*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 51*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 52*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 53*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note12 = this
*)
(* po redu: 54*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note11 and note12 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 55*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note13 = this
*)
(* po redu: 56*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note10 and note13 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 57*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note14 = this
*)
(* po redu: 58*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note7 and note14 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 59*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note15 = this
*)
(* po redu: 60*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 61*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 62*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 63*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 64*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 65*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 66*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 67*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note16 = this
*)
(* po redu: 68*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 69*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 70*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note17 = this
*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note17 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 73*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note18 = this
*)
(* po redu: 74*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 75*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 76*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 77*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note19 = this
*)
(* po redu: 78*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note20 = this
*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note19 and note20 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note21 = this
*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note18 and note21 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note22 = this
*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 87*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 88*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 89*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note23 = this
*)
(* po redu: 92*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 93*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 94*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 95*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note24 = this
*)
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note23 and note24 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 97*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note25 = this
*)
(* po redu: 98*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 99*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 100*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 101*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note26 = this
*)
(* po redu: 102*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 104*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 105*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note27 = this
*)
(* po redu: 106*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note26 and note27 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 107*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note28 = this
*)
(* po redu: 108*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note25 and note28 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 109*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note29 = this
*)
(* po redu: 110*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note22 and note29 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 111*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note30 = this
*)
(* po redu: 112*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note15 and note30 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 113*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note31 = this
*)
(* po redu: 114*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 115*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 116*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 117*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 118*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 119*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 120*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 121*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 122*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 123*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note32 = this
*)
(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 127*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note33 = this
*)
(* po redu: 128*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note32 and note33 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 129*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note34 = this
*)
(* po redu: 130*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 132*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 133*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note35 = this
*)
(* po redu: 134*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 135*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 137*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note36 = this
*)
(* po redu: 138*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note35 and note36 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 139*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note37 = this
*)
(* po redu: 140*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note34 and note37 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 141*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note38 = this
*)
(* po redu: 142*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 143*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 144*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 145*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 146*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 147*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note39 = this
*)
(* po redu: 148*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 149*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 151*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note40 = this
*)
(* po redu: 152*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note39 and note40 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 153*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note41 = this
*)
(* po redu: 154*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 155*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 156*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 157*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note42 = this
*)
(* po redu: 158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 161*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note43 = this
*)
(* po redu: 162*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note42 and note43 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 163*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note44 = this
*)
(* po redu: 164*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note41 and note44 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 165*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note45 = this
*)
(* po redu: 166*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note38 and note45 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 167*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note46 = this
*)
(* po redu: 168*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 169*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 170*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 171*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 172*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 173*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 174*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 175*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note47 = this
*)
(* po redu: 176*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 177*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 179*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note48 = this
*)
(* po redu: 180*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note47 and note48 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 181*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note49 = this
*)
(* po redu: 182*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 183*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 184*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 185*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note50 = this
*)
(* po redu: 186*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 187*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 188*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 189*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note51 = this
*)
(* po redu: 190*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note50 and note51 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 191*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note52 = this
*)
(* po redu: 192*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note49 and note52 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 193*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note53 = this
*)
(* po redu: 194*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 196*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 197*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 198*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 199*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note54 = this
*)
(* po redu: 200*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 201*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 202*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 203*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note55 = this
*)
(* po redu: 204*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note54 and note55 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 205*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note56 = this
*)
(* po redu: 206*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 207*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 208*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 209*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note57 = this
*)
(* po redu: 210*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 212*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 213*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note58 = this
*)
(* po redu: 214*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note57 and note58 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 215*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note59 = this
*)
(* po redu: 216*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note56 and note59 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 217*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note60 = this
*)
(* po redu: 218*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note53 and note60 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 219*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note61 = this
*)
(* po redu: 220*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note46 and note61 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 221*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note62 = this
*)
(* po redu: 222*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note31 and note62 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
(* po redu: 223*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note63 = this
*)
(* po redu: 224*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
*)
(* po redu: 225*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 226*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 228*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 229*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 230*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 231*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 232*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 233*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 234*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 235*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note64 = this
*)
(* po redu: 236*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 237*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 239*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note65 = this
*)
(* po redu: 240*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note64 and note65 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 241*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note66 = this
*)
(* po redu: 242*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 244*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 245*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note67 = this
*)
(* po redu: 246*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 247*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 248*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 249*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note68 = this
*)
(* po redu: 250*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note67 and note68 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 251*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note69 = this
*)
(* po redu: 252*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note66 and note69 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 253*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note70 = this
*)
(* po redu: 254*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 255*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 256*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 257*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 258*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 259*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note71 = this
*)
(* po redu: 260*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 261*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 262*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 263*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note72 = this
*)
(* po redu: 264*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note71 and note72 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 265*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note73 = this
*)
(* po redu: 266*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 268*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 269*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note74 = this
*)
(* po redu: 270*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 271*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 273*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note75 = this
*)
(* po redu: 274*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note74 and note75 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 275*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note76 = this
*)
(* po redu: 276*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note73 and note76 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 277*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note77 = this
*)
(* po redu: 278*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note70 and note77 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 279*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note78 = this
*)
(* po redu: 280*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 281*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 282*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 283*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 284*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 285*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 286*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 287*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note79 = this
*)
(* po redu: 288*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 289*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 290*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 291*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note80 = this
*)
(* po redu: 292*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note79 and note80 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 293*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note81 = this
*)
(* po redu: 294*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 296*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 297*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note82 = this
*)
(* po redu: 298*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 300*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 301*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note83 = this
*)
(* po redu: 302*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note82 and note83 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 303*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note84 = this
*)
(* po redu: 304*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note81 and note84 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 305*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note85 = this
*)
(* po redu: 306*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 308*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 309*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 310*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 311*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note86 = this
*)
(* po redu: 312*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 313*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 314*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 315*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note87 = this
*)
(* po redu: 316*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note86 and note87 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 317*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note88 = this
*)
(* po redu: 318*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 319*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 320*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 321*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note89 = this
*)
(* po redu: 322*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 324*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 325*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note90 = this
*)
(* po redu: 326*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note89 and note90 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 327*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note91 = this
*)
(* po redu: 328*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note88 and note91 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 329*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note92 = this
*)
(* po redu: 330*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note85 and note92 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 331*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note93 = this
*)
(* po redu: 332*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note78 and note93 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 333*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note94 = this
*)
(* po redu: 334*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 336*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 337*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 338*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 340*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 341*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 342*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 343*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note95 = this
*)
(* po redu: 344*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 345*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 347*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note96 = this
*)
(* po redu: 348*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note95 and note96 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 349*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note97 = this
*)
(* po redu: 350*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 352*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 353*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note98 = this
*)
(* po redu: 354*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 356*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 357*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note99 = this
*)
(* po redu: 358*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note98 and note99 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 359*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note100 = this
*)
(* po redu: 360*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note97 and note100 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 361*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note101 = this
*)
(* po redu: 362*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 364*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 365*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 366*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 367*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note102 = this
*)
(* po redu: 368*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 369*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 370*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 371*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note103 = this
*)
(* po redu: 372*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note102 and note103 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 373*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note104 = this
*)
(* po redu: 374*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 375*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 376*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 377*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note105 = this
*)
(* po redu: 378*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 379*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 381*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note106 = this
*)
(* po redu: 382*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note105 and note106 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 383*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note107 = this
*)
(* po redu: 384*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note104 and note107 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 385*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note108 = this
*)
(* po redu: 386*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note101 and note108 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 387*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note109 = this
*)
(* po redu: 388*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 389*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 390*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 391*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 392*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 393*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 394*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 395*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note110 = this
*)
(* po redu: 396*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 397*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 399*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note111 = this
*)
(* po redu: 400*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note110 and note111 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 401*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note112 = this
*)
(* po redu: 402*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 403*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 404*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 405*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note113 = this
*)
(* po redu: 406*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 407*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 408*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 409*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note114 = this
*)
(* po redu: 410*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note113 and note114 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 411*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note115 = this
*)
(* po redu: 412*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note112 and note115 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 413*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note116 = this
*)
(* po redu: 414*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 416*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 417*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

*)
(* po redu: 418*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
*)
(* po redu: 419*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note117 = this
*)
(* po redu: 420*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
*)
(* po redu: 421*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

*)
(* po redu: 422*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

*)
(* po redu: 423*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note118 = this
*)
(* po redu: 424*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note117 and note118 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
*)
(* po redu: 425*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note119 = this
*)
(* po redu: 426*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 427*)
(*1*)  (*REGULAR*)

have  "inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1"
using ax_g4 [of "PO1" "LI1"]
by auto

(* po redu: 428*)
(*2*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI1"
(* po redu: 429*)
(*3*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note120 = this
(* po redu: 430*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI1"
(* po redu: 431*)
(*5*)  (*REGULAR*)
moreover

obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 432*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
obtain  PO4::point
where "PO1 ~= PO4" and "inc_po_pl PO4 PL1" and "inc_po_pl PO4 PL2"
using ax_I7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 433*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 434*)
(*6*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL1"
using ax_D11 [of "LI1" "PL1" "PO2"]
by auto

(* po redu: 435*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 436*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 437*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 438*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 439*)
(*7*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL2"
using ax_D11 [of "LI1" "PL2" "PO2"]
by auto

(* po redu: 440*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

*)
(* po redu: 441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
*)
(* po redu: 442*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `PO1 = PO2`
have False
by auto

*)
(* po redu: 443*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note121 = this
*)
(* po redu: 444*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
*)
(* po redu: 445*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO2 LI2"
using ax_I1 [of "PO1" "PO2"]
by auto

*)
(* po redu: 446*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

*)
(* po redu: 447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 448*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 449*)
(*8*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO1 LI1`
have  "\<not>col PO2 PO3 PO1"
using ax_D1a [of "PO2" "PO3" "LI1" "PO1"]
by auto

(* po redu: 450*)
(*9*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 451*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 452*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 453*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 454*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 455*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 456*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 457*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 458*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 460*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 461*)
(*10*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL2"
using ax_D11 [of "LI1" "PL2" "PO3"]
by auto

(* po redu: 462*)
(*11*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO1`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_231 [of "PO2" "PO3" "PO1"]
by auto

(* po redu: 463*)
(*12*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO3 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO3" "PL1" "PL2"]
by auto

(* po redu: 464*)
(*13*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 465*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note122 = this
*)
(* po redu: 466*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note121 and note122 and `PO1 = PO2 \<or> PO1 ~= PO2`
have False
by auto
*)
(* po redu: 467*)
(*14*)  (*BRANCH NAME*)
} note note123 = this
(* po redu: 468*)
(*15*)  
(*BRANCH END*)
from note120 and note123 and `inc_po_l PO1 LI1 \<or> \<not>inc_po_l PO1 LI1`
have ?thesis
by auto
(* po redu: 469*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note124 = this
*)
(* po redu: 470*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note119 and note124 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 471*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note125 = this
*)
(* po redu: 472*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note116 and note125 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 473*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note126 = this
*)
(* po redu: 474*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note109 and note126 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 475*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note127 = this
*)
(* po redu: 476*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note94 and note127 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
(* po redu: 477*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note128 = this
*)
(* po redu: 478*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note63 and note128 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
*)
from this
show ?thesis
by auto
qed
