theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th2:
shows " (col PO1 PO2 PO3) \<or>  (\<not>col PO1 PO2 PO3)"
proof -

(* po redu: 1*)
(*1*)  (*REGULAR*)

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 2*)
(*2*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 3*)
(*3*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 4*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 5*)
(*5*)  (*REGULAR*)
moreover

obtain  PO4::point and  PO5::point
where "\<not>col PO1 PO4 PO5"
using ax_ml_I3b_1 [of "PO1"]
by auto

(* po redu: 6*)
(*6*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 7*)
(*7*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 8*)
(*8*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 9*)
(*9*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 10*)
(*10*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO4 PO5` and `PO1 = PO4` and `PO1 = PO5`
have "\<not>col PO1 PO1 PO1"
by auto

(* po redu: 11*)
(*11*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO1 PO1` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO3"
by auto

(* po redu: 12*)
(*12*)  
(*BRANCH END*)
from `\<not>col PO1 PO2 PO3`
have ?thesis
by auto
(* po redu: 13*)
(*13*)  (*BRANCH NAME*)
} note note1 = this
(* po redu: 14*)
(*14*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 15*)
(*15*)  (*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO5 LI1"
using ax_I1 [of "PO1" "PO5"]
by auto

(* po redu: 16*)
(*16*)  (*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO4 PO5` and `PO1 = PO4`
have "\<not>col PO1 PO1 PO5"
by auto

(* po redu: 17*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO5`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO5 PL1"
using ax_I4a [of "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 18*)
(*17*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 19*)
(*18*)  (*EQCONTRADICTION*)
moreover
from `col PO1 PO1 PO1` and `PO1 = PO2` and `PO1 = PO3`
have "col PO1 PO2 PO3"
by auto

(* po redu: 20*)
(*19*)  
(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
(* po redu: 21*)
(*20*)  (*BRANCH NAME*)
} note note2 = this
(* po redu: 22*)
(*21*)  
(*BRANCH END*)
from note1 and note2 and `PO1 = PO5 \<or> PO1 ~= PO5`
have ?thesis
by auto
(* po redu: 23*)
(*22*)  (*BRANCH NAME*)
} note note3 = this
(* po redu: 24*)
(*23*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 25*)
(*24*)  (*REGULAR*)
moreover
from `PO1 ~= PO4`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO4 LI1"
using ax_I1 [of "PO1" "PO4"]
by auto

(* po redu: 26*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 27*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
*)
(* po redu: 28*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO4 PO5` and `PO1 = PO5`
have "\<not>col PO1 PO4 PO1"
by auto

*)
(* po redu: 29*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO1`
have  "\<not>col PO1 PO1 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO1"]
by auto

*)
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `col PO1 PO1 PO1` and `PO1 = PO2` and `PO1 = PO3`
have "col PO1 PO2 PO3"
by auto

*)
(* po redu: 33*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
*)
(* po redu: 34*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note4 = this
*)
(* po redu: 35*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
*)
(* po redu: 36*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO4 = PO5 \<or> PO4 ~= PO5"
using ax_g1 [of "PO4" "PO5"]
by auto

*)
(* po redu: 37*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 = PO5"
*)
(* po redu: 38*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO4 PO5` and `PO4 = PO5`
have "\<not>col PO1 PO4 PO4"
by auto

*)
(* po redu: 39*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO4 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 41*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `col PO1 PO1 PO1` and `PO1 = PO2` and `PO1 = PO3`
have "col PO1 PO2 PO3"
by auto

*)
(* po redu: 42*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
*)
(* po redu: 43*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note5 = this
*)
(* po redu: 44*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO4 ~= PO5"
*)
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO5 LI2"
using ax_I1 [of "PO1" "PO5"]
by auto

*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO4 ~= PO5`
obtain  LI3::line
where "inc_po_l PO4 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO4" "PO5"]
by auto

*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO5`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO4 PL1" and "inc_po_pl PO5 PL1"
using ax_I4a [of "PO1" "PO4" "PO5"]
by auto

*)
(* po redu: 48*)
(*25*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(* po redu: 49*)
(*26*)  (*EQCONTRADICTION*)
moreover
from `col PO1 PO1 PO1` and `PO1 = PO2` and `PO1 = PO3`
have "col PO1 PO2 PO3"
by auto

(* po redu: 50*)
(*27*)  
(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
(* po redu: 51*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note6 = this
*)
(* po redu: 52*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note5 and note6 and `PO4 = PO5 \<or> PO4 ~= PO5`
have ?thesis
by auto
*)
(* po redu: 53*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note7 = this
*)
(* po redu: 54*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note4 and note7 and `PO1 = PO5 \<or> PO1 ~= PO5`
have ?thesis
by auto
*)
(* po redu: 55*)
(*28*)  (*BRANCH NAME*)
} note note8 = this
(* po redu: 56*)
(*29*)  
(*BRANCH END*)
from note3 and note8 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 57*)
(*30*)  (*BRANCH NAME*)
} note note9 = this
(* po redu: 58*)
(*31*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 59*)
(*32*)  (*REGULAR*)
moreover
from `PO1 ~= PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO3 LI1"
using ax_I1 [of "PO1" "PO3"]
by auto

(* po redu: 60*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 61*)
(*33*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(* po redu: 62*)
(*34*)  (*EQCONTRADICTION*)
moreover
from `col PO1 PO1 PO3` and `PO1 = PO2`
have "col PO1 PO2 PO3"
by auto

(* po redu: 63*)
(*35*)  
(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
(* po redu: 64*)
(*36*)  (*BRANCH NAME*)
} note note10 = this
(* po redu: 65*)
(*37*)  
(*BRANCH END*)
from note9 and note10 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 66*)
(*38*)  (*BRANCH NAME*)
} note note11 = this
(* po redu: 67*)
(*39*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 68*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 69*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
*)
(* po redu: 70*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

*)
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

*)
(* po redu: 73*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO1 PO2`
have  "col PO1 PO2 PO1"
using ax_col_132 [of "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 74*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `col PO1 PO2 PO1` and `PO1 = PO3`
have "col PO1 PO2 PO3"
by auto

*)
(* po redu: 75*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
*)
(* po redu: 76*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note12 = this
*)
(* po redu: 77*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
*)
(* po redu: 78*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

*)
(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO3"
*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `col PO1 PO2 PO2` and `PO2 = PO3`
have "col PO1 PO2 PO3"
by auto

*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note13 = this
*)
(* po redu: 87*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO3"
*)
(* po redu: 88*)
(*40*)  (*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(* po redu: 89*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 92*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

*)
(* po redu: 93*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 94*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 95*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

*)
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
*)
(* po redu: 97*)
(*41*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(* po redu: 98*)
(*42*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI1"
(* po redu: 99*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

*)
(* po redu: 100*)
(*43*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(* po redu: 101*)
(*44*)  
(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
(* po redu: 102*)
(*45*)  (*BRANCH NAME*)
} note note14 = this
(* po redu: 103*)
(*46*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(* po redu: 104*)
(*47*)  (*REGULAR*)
moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO1 PO2 PO3"
using ax_D1a [of "PO1" "PO2" "LI1" "PO3"]
by auto

(* po redu: 105*)
(*48*)  
(*BRANCH END*)
from `\<not>col PO1 PO2 PO3`
have ?thesis
by auto
(* po redu: 106*)
(*49*)  (*BRANCH NAME*)
} note note15 = this
(* po redu: 107*)
(*50*)  
(*BRANCH END*)
from note14 and note15 and `inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(* po redu: 108*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note16 = this
*)
(* po redu: 109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
*)
(* po redu: 110*)
(*51*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(* po redu: 111*)
(*52*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI1"
(* po redu: 112*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

*)
(* po redu: 113*)
(*53*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(* po redu: 114*)
(*54*)  
(*BRANCH END*)
from `col PO1 PO2 PO3`
have ?thesis
by auto
(* po redu: 115*)
(*55*)  (*BRANCH NAME*)
} note note17 = this
(* po redu: 116*)
(*56*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(* po redu: 117*)
(*57*)  (*REGULAR*)
moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO1 PO2 PO3"
using ax_D1a [of "PO1" "PO2" "LI1" "PO3"]
by auto

(* po redu: 118*)
(*58*)  
(*BRANCH END*)
from `\<not>col PO1 PO2 PO3`
have ?thesis
by auto
(* po redu: 119*)
(*59*)  (*BRANCH NAME*)
} note note18 = this
(* po redu: 120*)
(*60*)  
(*BRANCH END*)
from note17 and note18 and `inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(* po redu: 121*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note19 = this
*)
(* po redu: 122*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note19 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
*)
(* po redu: 123*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note20 = this
*)
(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note13 and note20 and `PO2 = PO3 \<or> PO2 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note21 = this
*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note12 and note21 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 127*)
(*61*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 128*)
(*62*)  
(*BRANCH END*)
from note11 and note22 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
