theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th22:
assumes "\<not>inc_po_l PO1 LI1"
and "inc_l_pl LI1 PL1"
and "inc_po_pl PO1 PL1"
and "inc_l_pl LI1 PL2"
and "inc_po_pl PO1 PL2"
shows " (PL1 = PL2)"
proof -

(* po redu: 1*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 2*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

*)
(* po redu: 3*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
*)
(* po redu: 4*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 5*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 6*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 7*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 8*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 9*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 10*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 11*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 12*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 13*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 14*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 15*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 16*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1 = this
*)
(* po redu: 17*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 18*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 19*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 20*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note2 = this
*)
(* po redu: 21*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1 and note2 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 22*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note3 = this
*)
(* po redu: 23*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 24*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 25*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 26*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 27*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note4 = this
*)
(* po redu: 28*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 29*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note5 = this
*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note4 and note5 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 33*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note6 = this
*)
(* po redu: 34*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note3 and note6 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 35*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note7 = this
*)
(* po redu: 36*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 37*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 38*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 39*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 41*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 42*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note8 = this
*)
(* po redu: 43*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 44*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note9 = this
*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note8 and note9 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 48*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note10 = this
*)
(* po redu: 49*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 50*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 51*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 52*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note11 = this
*)
(* po redu: 53*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 54*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 55*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 56*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note12 = this
*)
(* po redu: 57*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note11 and note12 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 58*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note13 = this
*)
(* po redu: 59*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note10 and note13 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 60*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note14 = this
*)
(* po redu: 61*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note7 and note14 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 62*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note15 = this
*)
(* po redu: 63*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 64*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 65*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 66*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 67*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 68*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 69*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 70*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note16 = this
*)
(* po redu: 73*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 74*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 75*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 76*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note17 = this
*)
(* po redu: 77*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note17 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 78*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note18 = this
*)
(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note19 = this
*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 87*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 88*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note20 = this
*)
(* po redu: 89*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note19 and note20 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note21 = this
*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note18 and note21 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 92*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note22 = this
*)
(* po redu: 93*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 94*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 95*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 97*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 98*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 99*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 100*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note23 = this
*)
(* po redu: 101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 102*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 104*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note24 = this
*)
(* po redu: 105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note23 and note24 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 106*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note25 = this
*)
(* po redu: 107*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 108*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 110*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 111*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 112*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note26 = this
*)
(* po redu: 113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 114*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 115*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 116*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note27 = this
*)
(* po redu: 117*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note26 and note27 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 118*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note28 = this
*)
(* po redu: 119*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note25 and note28 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 120*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note29 = this
*)
(* po redu: 121*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note22 and note29 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 122*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note30 = this
*)
(* po redu: 123*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note15 and note30 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note31 = this
*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 127*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 128*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 132*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 134*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 135*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 136*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note32 = this
*)
(* po redu: 137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 138*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 139*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 140*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note33 = this
*)
(* po redu: 141*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note32 and note33 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 142*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note34 = this
*)
(* po redu: 143*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 144*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 146*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 147*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 148*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note35 = this
*)
(* po redu: 149*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 151*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 152*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note36 = this
*)
(* po redu: 153*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note35 and note36 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 154*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note37 = this
*)
(* po redu: 155*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note34 and note37 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 156*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note38 = this
*)
(* po redu: 157*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 158*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 159*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 161*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 162*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 163*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note39 = this
*)
(* po redu: 165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note40 = this
*)
(* po redu: 169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note39 and note40 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 170*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note41 = this
*)
(* po redu: 171*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 172*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 174*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 175*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 176*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note42 = this
*)
(* po redu: 177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 179*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 180*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note43 = this
*)
(* po redu: 181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note42 and note43 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 182*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note44 = this
*)
(* po redu: 183*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note41 and note44 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 184*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note45 = this
*)
(* po redu: 185*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note38 and note45 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 186*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note46 = this
*)
(* po redu: 187*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 188*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 190*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 192*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 194*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 196*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note47 = this
*)
(* po redu: 197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 198*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note48 = this
*)
(* po redu: 201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note47 and note48 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 202*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note49 = this
*)
(* po redu: 203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 204*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 206*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 207*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 208*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note50 = this
*)
(* po redu: 209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 212*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note51 = this
*)
(* po redu: 213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note50 and note51 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 214*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note52 = this
*)
(* po redu: 215*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note49 and note52 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 216*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note53 = this
*)
(* po redu: 217*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 218*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 219*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 220*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 221*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 222*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 223*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 224*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note54 = this
*)
(* po redu: 225*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 226*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 228*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note55 = this
*)
(* po redu: 229*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note54 and note55 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 230*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note56 = this
*)
(* po redu: 231*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 232*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 234*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 235*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 236*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note57 = this
*)
(* po redu: 237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 239*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 240*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note58 = this
*)
(* po redu: 241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note57 and note58 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 242*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note59 = this
*)
(* po redu: 243*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note56 and note59 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note60 = this
*)
(* po redu: 245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note53 and note60 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 246*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note61 = this
*)
(* po redu: 247*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note46 and note61 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note62 = this
*)
(* po redu: 249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note31 and note62 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 250*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note63 = this
*)
(* po redu: 251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 252*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 254*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 255*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 256*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 258*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 260*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 262*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 263*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 264*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note64 = this
*)
(* po redu: 265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 266*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 268*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note65 = this
*)
(* po redu: 269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note64 and note65 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 270*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note66 = this
*)
(* po redu: 271*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 274*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 275*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 276*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note67 = this
*)
(* po redu: 277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 278*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 279*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 280*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note68 = this
*)
(* po redu: 281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note67 and note68 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 282*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note69 = this
*)
(* po redu: 283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note66 and note69 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 284*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note70 = this
*)
(* po redu: 285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 288*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 290*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 291*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note71 = this
*)
(* po redu: 293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 294*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 296*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note72 = this
*)
(* po redu: 297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note71 and note72 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 298*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note73 = this
*)
(* po redu: 299*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 300*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 302*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note74 = this
*)
(* po redu: 305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note75 = this
*)
(* po redu: 309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note74 and note75 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 310*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note76 = this
*)
(* po redu: 311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note73 and note76 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 312*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note77 = this
*)
(* po redu: 313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note70 and note77 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 314*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note78 = this
*)
(* po redu: 315*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 316*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 318*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 319*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 320*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 322*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note79 = this
*)
(* po redu: 325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 327*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 328*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note80 = this
*)
(* po redu: 329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note79 and note80 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 330*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note81 = this
*)
(* po redu: 331*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 332*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 334*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 336*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note82 = this
*)
(* po redu: 337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 338*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 340*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note83 = this
*)
(* po redu: 341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note82 and note83 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 342*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note84 = this
*)
(* po redu: 343*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note81 and note84 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note85 = this
*)
(* po redu: 345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 347*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 348*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 350*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 352*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note86 = this
*)
(* po redu: 353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 354*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 356*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note87 = this
*)
(* po redu: 357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note86 and note87 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 358*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note88 = this
*)
(* po redu: 359*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 360*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 362*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note89 = this
*)
(* po redu: 365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 366*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note90 = this
*)
(* po redu: 369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note89 and note90 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 370*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note91 = this
*)
(* po redu: 371*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note88 and note91 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note92 = this
*)
(* po redu: 373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note85 and note92 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 374*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note93 = this
*)
(* po redu: 375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note78 and note93 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 376*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note94 = this
*)
(* po redu: 377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 378*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 382*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 383*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 384*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 386*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 387*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 388*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note95 = this
*)
(* po redu: 389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 390*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 391*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 392*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note96 = this
*)
(* po redu: 393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note95 and note96 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 394*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note97 = this
*)
(* po redu: 395*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 396*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 398*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 400*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note98 = this
*)
(* po redu: 401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 402*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 403*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 404*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note99 = this
*)
(* po redu: 405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note98 and note99 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 406*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note100 = this
*)
(* po redu: 407*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note97 and note100 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 408*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note101 = this
*)
(* po redu: 409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 410*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 411*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 412*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 414*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note102 = this
*)
(* po redu: 417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 419*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 420*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note103 = this
*)
(* po redu: 421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note102 and note103 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 422*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note104 = this
*)
(* po redu: 423*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 424*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 426*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 427*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note105 = this
*)
(* po redu: 429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 430*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 432*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note106 = this
*)
(* po redu: 433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note105 and note106 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 434*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note107 = this
*)
(* po redu: 435*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note104 and note107 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 436*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note108 = this
*)
(* po redu: 437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note101 and note108 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 438*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note109 = this
*)
(* po redu: 439*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 440*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 442*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 443*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 444*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 446*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note110 = this
*)
(* po redu: 447*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 448*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 449*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 450*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note111 = this
*)
(* po redu: 451*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note110 and note111 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 452*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note112 = this
*)
(* po redu: 453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 454*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 455*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 456*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 457*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note113 = this
*)
(* po redu: 458*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 460*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 461*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note114 = this
*)
(* po redu: 462*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note113 and note114 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 463*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note115 = this
*)
(* po redu: 464*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note112 and note115 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 465*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note116 = this
*)
(* po redu: 466*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 467*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 468*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 469*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 470*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 471*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 472*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note117 = this
*)
(* po redu: 473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 474*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 475*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note118 = this
*)
(* po redu: 477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note117 and note118 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 478*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note119 = this
*)
(* po redu: 479*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 480*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 482*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note120 = this
*)
(* po redu: 483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 484*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 485*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 486*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note121 = this
*)
(* po redu: 487*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note120 and note121 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 488*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note122 = this
*)
(* po redu: 489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note119 and note122 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 490*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note123 = this
*)
(* po redu: 491*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note116 and note123 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 492*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note124 = this
*)
(* po redu: 493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note109 and note124 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 494*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note125 = this
*)
(* po redu: 495*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note94 and note125 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note126 = this
*)
(* po redu: 497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note63 and note126 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
(* po redu: 498*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note127 = this
*)
(* po redu: 499*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
*)
(* po redu: 500*)
(*1*)  (*REGULAR*)

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 501*)
(*2*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 502*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 503*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 504*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 506*)
(*3*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 507*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 508*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 510*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 511*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 512*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note128 = this
*)
(* po redu: 513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 514*)
(*5*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 515*)
(*6*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 516*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note129 = this
*)
(* po redu: 517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note128 and note129 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 518*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note130 = this
*)
(* po redu: 519*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 520*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 522*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 523*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note131 = this
*)
(* po redu: 524*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 525*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 526*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 527*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note132 = this
*)
(* po redu: 528*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note131 and note132 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 529*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note133 = this
*)
(* po redu: 530*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note130 and note133 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 531*)
(*7*)  (*BRANCH NAME*)
} note note134 = this
(* po redu: 532*)
(*8*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 533*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 534*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 535*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 536*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 537*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 538*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note135 = this
*)
(* po redu: 539*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 541*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 542*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note136 = this
*)
(* po redu: 543*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note135 and note136 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 544*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note137 = this
*)
(* po redu: 545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 546*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 547*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 548*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note138 = this
*)
(* po redu: 549*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 550*)
(*9*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 551*)
(*10*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 552*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note139 = this
*)
(* po redu: 553*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note138 and note139 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 554*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note140 = this
*)
(* po redu: 555*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note137 and note140 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 556*)
(*11*)  (*BRANCH NAME*)
} note note141 = this
(* po redu: 557*)
(*12*)  
(*BRANCH END*)
from note134 and note141 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 558*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note142 = this
*)
(* po redu: 559*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 560*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 563*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 564*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 566*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 567*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 568*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note143 = this
*)
(* po redu: 569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 571*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 572*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note144 = this
*)
(* po redu: 573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note143 and note144 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 574*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note145 = this
*)
(* po redu: 575*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 576*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 578*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 580*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note146 = this
*)
(* po redu: 581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 582*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 583*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 584*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note147 = this
*)
(* po redu: 585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note146 and note147 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 586*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note148 = this
*)
(* po redu: 587*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note145 and note148 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 588*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note149 = this
*)
(* po redu: 589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 591*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 592*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 594*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 595*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 596*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note150 = this
*)
(* po redu: 597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 598*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 599*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 600*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note151 = this
*)
(* po redu: 601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note150 and note151 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 602*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note152 = this
*)
(* po redu: 603*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 604*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 606*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note153 = this
*)
(* po redu: 609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 610*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note154 = this
*)
(* po redu: 613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note153 and note154 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 614*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note155 = this
*)
(* po redu: 615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note152 and note155 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 616*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note156 = this
*)
(* po redu: 617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note149 and note156 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 618*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note157 = this
*)
(* po redu: 619*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note142 and note157 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 620*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note158 = this
*)
(* po redu: 621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 622*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 623*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 624*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 625*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 626*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 627*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 628*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 630*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 631*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 632*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note159 = this
*)
(* po redu: 633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 636*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note160 = this
*)
(* po redu: 637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note159 and note160 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 638*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note161 = this
*)
(* po redu: 639*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 640*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 642*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 643*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 644*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note162 = this
*)
(* po redu: 645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 647*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 648*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note163 = this
*)
(* po redu: 649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note162 and note163 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 650*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note164 = this
*)
(* po redu: 651*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note161 and note164 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 652*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note165 = this
*)
(* po redu: 653*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 655*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 656*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 658*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 659*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 660*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note166 = this
*)
(* po redu: 661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 662*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 663*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 664*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note167 = this
*)
(* po redu: 665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note166 and note167 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 666*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note168 = this
*)
(* po redu: 667*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 668*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 670*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 671*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 672*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note169 = this
*)
(* po redu: 673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 675*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 676*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note170 = this
*)
(* po redu: 677*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note169 and note170 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 678*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note171 = this
*)
(* po redu: 679*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note168 and note171 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 680*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note172 = this
*)
(* po redu: 681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note165 and note172 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 682*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note173 = this
*)
(* po redu: 683*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 684*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 686*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 687*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 688*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 690*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 691*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 692*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note174 = this
*)
(* po redu: 693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 695*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 696*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note175 = this
*)
(* po redu: 697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note174 and note175 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 698*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note176 = this
*)
(* po redu: 699*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 700*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 702*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 704*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note177 = this
*)
(* po redu: 705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 707*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 708*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note178 = this
*)
(* po redu: 709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note177 and note178 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 710*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note179 = this
*)
(* po redu: 711*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note176 and note179 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 712*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note180 = this
*)
(* po redu: 713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 714*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 715*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 716*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 718*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 719*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 720*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note181 = this
*)
(* po redu: 721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 722*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 723*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 724*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note182 = this
*)
(* po redu: 725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note181 and note182 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 726*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note183 = this
*)
(* po redu: 727*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 728*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 730*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 731*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 732*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note184 = this
*)
(* po redu: 733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 734*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 736*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note185 = this
*)
(* po redu: 737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note184 and note185 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 738*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note186 = this
*)
(* po redu: 739*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note183 and note186 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 740*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note187 = this
*)
(* po redu: 741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note180 and note187 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 742*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note188 = this
*)
(* po redu: 743*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note173 and note188 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note189 = this
*)
(* po redu: 745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note158 and note189 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 746*)
(*13*)  (*BRANCH NAME*)
} note note190 = this
(* po redu: 747*)
(*14*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 748*)
(*15*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 749*)
(*16*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 750*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 751*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 752*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 754*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 755*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 756*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 758*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 759*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 760*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note191 = this
*)
(* po redu: 761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 762*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 763*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 764*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note192 = this
*)
(* po redu: 765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note191 and note192 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 766*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note193 = this
*)
(* po redu: 767*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 768*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 770*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 771*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 772*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note194 = this
*)
(* po redu: 773*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 774*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 775*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 776*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note195 = this
*)
(* po redu: 777*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note194 and note195 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 778*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note196 = this
*)
(* po redu: 779*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note193 and note196 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 780*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note197 = this
*)
(* po redu: 781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 782*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 783*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 784*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 786*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 787*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 788*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note198 = this
*)
(* po redu: 789*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 790*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 791*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 792*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note199 = this
*)
(* po redu: 793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note198 and note199 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 794*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note200 = this
*)
(* po redu: 795*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 796*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 798*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 800*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note201 = this
*)
(* po redu: 801*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 802*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 803*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 804*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note202 = this
*)
(* po redu: 805*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note201 and note202 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 806*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note203 = this
*)
(* po redu: 807*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note200 and note203 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 808*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note204 = this
*)
(* po redu: 809*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note197 and note204 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 810*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note205 = this
*)
(* po redu: 811*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 812*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 813*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 814*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 815*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 816*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 817*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 818*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 819*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 820*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note206 = this
*)
(* po redu: 821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 822*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 823*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 824*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note207 = this
*)
(* po redu: 825*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note206 and note207 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 826*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note208 = this
*)
(* po redu: 827*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 828*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 829*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 830*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 831*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 832*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note209 = this
*)
(* po redu: 833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 834*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 835*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 836*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note210 = this
*)
(* po redu: 837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note209 and note210 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 838*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note211 = this
*)
(* po redu: 839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note208 and note211 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 840*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note212 = this
*)
(* po redu: 841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 842*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 843*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 844*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 845*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 846*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 847*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 848*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note213 = this
*)
(* po redu: 849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 850*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

*)
(* po redu: 851*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

*)
(* po redu: 852*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note214 = this
*)
(* po redu: 853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note213 and note214 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 854*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note215 = this
*)
(* po redu: 855*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 856*)
(*17*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 857*)
(*18*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 858*)
(*19*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 859*)
(*20*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 860*)
(*21*)  (*BRANCH NAME*)
} note note216 = this
(* po redu: 861*)
(*22*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 862*)
(*23*)  (*REGULAR*)
moreover

obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 863*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
obtain  PO4::point
where "PO1 ~= PO4" and "inc_po_pl PO4 PL1" and "inc_po_pl PO4 PL2"
using ax_I7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 864*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 865*)
(*24*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL1"
using ax_D11 [of "LI1" "PL1" "PO2"]
by auto

(* po redu: 866*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 867*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 868*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 869*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 870*)
(*25*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL2"
using ax_D11 [of "LI1" "PL2" "PO2"]
by auto

(* po redu: 871*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

*)
(* po redu: 872*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
*)
(* po redu: 873*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `PO1 = PO2`
have False
by auto

*)
(* po redu: 874*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note217 = this
*)
(* po redu: 875*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
*)
(* po redu: 876*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO2`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO2 LI2"
using ax_I1 [of "PO1" "PO2"]
by auto

*)
(* po redu: 877*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

*)
(* po redu: 878*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 879*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 880*)
(*26*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO1 LI1`
have  "\<not>col PO2 PO3 PO1"
using ax_D1a [of "PO2" "PO3" "LI1" "PO1"]
by auto

(* po redu: 881*)
(*27*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 882*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 883*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 884*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 885*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 886*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 887*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 888*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 889*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 890*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 891*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 892*)
(*28*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL2"
using ax_D11 [of "LI1" "PL2" "PO3"]
by auto

(* po redu: 893*)
(*29*)  (*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO1`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_231 [of "PO2" "PO3" "PO1"]
by auto

(* po redu: 894*)
(*30*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO3 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO3" "PL1" "PL2"]
by auto

(* po redu: 895*)
(*31*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 896*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note218 = this
*)
(* po redu: 897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note217 and note218 and `PO1 = PO2 \<or> PO1 ~= PO2`
have False
by auto
*)
(* po redu: 898*)
(*32*)  (*BRANCH NAME*)
} note note219 = this
(* po redu: 899*)
(*33*)  
(*BRANCH END*)
from note216 and note219 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 900*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note220 = this
*)
(* po redu: 901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note215 and note220 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 902*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note221 = this
*)
(* po redu: 903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note212 and note221 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 904*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note222 = this
*)
(* po redu: 905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note205 and note222 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 906*)
(*34*)  (*BRANCH NAME*)
} note note223 = this
(* po redu: 907*)
(*35*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 908*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 910*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 911*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 912*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 913*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 914*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 915*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 916*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 917*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 918*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note224 = this
*)
(* po redu: 919*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 920*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 921*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 922*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note225 = this
*)
(* po redu: 923*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note224 and note225 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 924*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note226 = this
*)
(* po redu: 925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 926*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 927*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 928*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 929*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 930*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note227 = this
*)
(* po redu: 931*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 932*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 933*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 934*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note228 = this
*)
(* po redu: 935*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note227 and note228 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 936*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note229 = this
*)
(* po redu: 937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note226 and note229 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 938*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note230 = this
*)
(* po redu: 939*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 940*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 941*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 942*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 943*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 944*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 945*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 946*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note231 = this
*)
(* po redu: 947*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 948*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 949*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 950*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note232 = this
*)
(* po redu: 951*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note231 and note232 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 952*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note233 = this
*)
(* po redu: 953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 954*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 955*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 956*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 957*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 958*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note234 = this
*)
(* po redu: 959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 960*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 961*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 962*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note235 = this
*)
(* po redu: 963*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note234 and note235 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 964*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note236 = this
*)
(* po redu: 965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note233 and note236 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 966*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note237 = this
*)
(* po redu: 967*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note230 and note237 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 968*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note238 = this
*)
(* po redu: 969*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 970*)
(*36*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 971*)
(*37*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 972*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 973*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 974*)
(*38*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 975*)
(*39*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 976*)
(*40*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note239 = this
(* po redu: 977*)
(*41*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 978*)
(*42*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 979*)
(*43*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 980*)
(*44*)  (*BRANCH NAME*)
} note note240 = this
(* po redu: 981*)
(*45*)  
(*BRANCH END*)
from note239 and note240 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 982*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note241 = this
*)
(* po redu: 983*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 984*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 985*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 986*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 987*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note242 = this
*)
(* po redu: 988*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 989*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 990*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 991*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note243 = this
*)
(* po redu: 992*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note242 and note243 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 993*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note244 = this
*)
(* po redu: 994*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note241 and note244 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 995*)
(*46*)  (*BRANCH NAME*)
} note note245 = this
(* po redu: 996*)
(*47*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 997*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 998*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 999*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1000*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1001*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1002*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note246 = this
*)
(* po redu: 1003*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1004*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1005*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1006*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note247 = this
*)
(* po redu: 1007*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note246 and note247 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1008*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note248 = this
*)
(* po redu: 1009*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1010*)
(*48*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 1011*)
(*49*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 1012*)
(*50*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note249 = this
(* po redu: 1013*)
(*51*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 1014*)
(*52*)  (*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

(* po redu: 1015*)
(*53*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

(* po redu: 1016*)
(*54*)  (*BRANCH NAME*)
} note note250 = this
(* po redu: 1017*)
(*55*)  
(*BRANCH END*)
from note249 and note250 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
(* po redu: 1018*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note251 = this
*)
(* po redu: 1019*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note248 and note251 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 1020*)
(*56*)  (*BRANCH NAME*)
} note note252 = this
(* po redu: 1021*)
(*57*)  
(*BRANCH END*)
from note245 and note252 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 1022*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note253 = this
*)
(* po redu: 1023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note238 and note253 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 1024*)
(*58*)  (*BRANCH NAME*)
} note note254 = this
(* po redu: 1025*)
(*59*)  
(*BRANCH END*)
from note223 and note254 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
(* po redu: 1026*)
(*60*)  (*BRANCH NAME*)
} note note255 = this
(* po redu: 1027*)
(*61*)  
(*BRANCH END*)
from note190 and note255 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
(* po redu: 1028*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note256 = this
*)
(* po redu: 1029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note127 and note256 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
*)
from this
show ?thesis
by auto
qed
