theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th23:
assumes "LI1 ~= LI2"
and "inc_po_l PO1 LI1"
and "inc_po_l PO1 LI2"
shows " ( \<exists>  (PL1::plane). inc_l_pl LI1 PL1 & inc_l_pl LI2 PL1)"
proof -

(* po redu: 1*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 2*)
(*1*)  (*REGULAR*)
from `LI1 ~= LI2` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have  "int_l_l LI1 LI2"
using ax_D5 [of "LI1" "LI2" "PO1"]
by auto

(* po redu: 3*)
(*2*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(* po redu: 4*)
(*3*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
(* po redu: 5*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

*)
(* po redu: 6*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
*)
(* po redu: 7*)
(*4*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 8*)
(*5*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 9*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1 = this
*)
(* po redu: 10*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
*)
(* po redu: 11*)
(*6*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(* po redu: 12*)
(*7*)  (*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

(* po redu: 13*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note2 = this
*)
(* po redu: 14*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1 and note2 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have False
by auto
*)
(* po redu: 15*)
(*8*)  (*BRANCH NAME*)
} note note3 = this
(* po redu: 16*)
(*9*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
(* po redu: 17*)
(*10*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(* po redu: 18*)
(*11*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
(* po redu: 19*)
(*12*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(* po redu: 20*)
(*13*)  (*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

(* po redu: 21*)
(*14*)  (*BRANCH NAME*)
} note note4 = this
(* po redu: 22*)
(*15*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
(* po redu: 23*)
(*16*)  (*REGULAR*)
moreover

obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 24*)
(*17*)  (*REGULAR*)
moreover

obtain  PO4::point and  PO5::point
where "inc_po_l PO4 LI2" and "PO4 ~= PO5" and "inc_po_l PO5 LI2"
using ax_I3a [of "LI2"]
by auto

(* po redu: 25*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

*)
(* po redu: 26*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 27*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 28*)
(*18*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 29*)
(*19*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 33*)
(*20*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2"
using ax_g4 [of "PO3" "LI2"]
by auto

(* po redu: 34*)
(*21*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI2"
(* po redu: 35*)
(*22*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 36*)
(*23*)  (*REGULAR*)
moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2`
have  "LI1 = LI2"
using ax_I2 [of "PO1" "PO3" "LI1" "LI2"]
by auto

(* po redu: 37*)
(*24*)  (*REGULAR*)
moreover
from `LI1 = LI2` and `LI1 ~= LI2`
have False
by auto

(* po redu: 38*)
(*25*)  (*BRANCH NAME*)
} note note5 = this
(* po redu: 39*)
(*26*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI2"
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

*)
(* po redu: 41*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 42*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 43*)
(*27*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 44*)
(*28*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 48*)
(*29*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 49*)
(*30*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 50*)
(*31*)  (*REGULAR*)
moreover

have  "PO3 = PO5 \<or> PO3 ~= PO5"
using ax_g1 [of "PO3" "PO5"]
by auto

(* po redu: 51*)
(*32*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO5"
(* po redu: 52*)
(*33*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO5`
have False
by auto

(* po redu: 53*)
(*34*)  (*BRANCH NAME*)
} note note6 = this
(* po redu: 54*)
(*35*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO5"
(* po redu: 55*)
(*36*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 56*)
(*37*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 57*)
(*38*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI1" "PO3" "PO5"]
by auto

(* po redu: 58*)
(*39*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 59*)
(*40*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

(* po redu: 60*)
(*41*)  (*BRANCH NAME*)
} note note7 = this
(* po redu: 61*)
(*42*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 62*)
(*43*)  (*REGULAR*)
moreover
from `PO3 ~= PO5`
obtain  LI3::line
where "inc_po_l PO3 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO3" "PO5"]
by auto

(* po redu: 63*)
(*44*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 64*)
(*45*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO5 PL1"
using ax_I4a [of "PO1" "PO3" "PO5"]
by auto

(* po redu: 65*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI3" "PO3" "PO5"]
by auto

*)
(* po redu: 66*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO5 PO5"
using ax_D1 [of "PO3" "LI3" "PO5" "PO5"]
by auto

*)
(* po redu: 67*)
(*46*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 68*)
(*47*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 69*)
(*48*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 70*)
(*49*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 73*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 74*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 75*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 76*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 77*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note8 = this
*)
(* po redu: 78*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note9 = this
*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 87*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI3" "PO3" "PO5"]
by auto

*)
(* po redu: 88*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

*)
(* po redu: 89*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

*)
(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note10 = this
*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 92*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 93*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 94*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note11 = this
*)
(* po redu: 95*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note10 and note11 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note12 = this
*)
(* po redu: 97*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note9 and note12 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 98*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note13 = this
*)
(* po redu: 99*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note8 and note13 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 100*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note14 = this
*)
(* po redu: 101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 102*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 103*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 104*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 105*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 106*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note15 = this
*)
(* po redu: 107*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 108*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 110*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 111*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 112*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note16 = this
*)
(* po redu: 113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 114*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 115*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 116*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI3" "PO3" "PO5"]
by auto

*)
(* po redu: 117*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

*)
(* po redu: 118*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

*)
(* po redu: 119*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note17 = this
*)
(* po redu: 120*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 121*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 122*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 123*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO5"]
by auto

*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 127*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 128*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 129*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 132*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO3 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 133*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 134*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO5 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 135*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 136*)
(*50*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 137*)
(*51*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO3` and `inc_po_l PO3 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO3" "PL1"]
by auto

(* po redu: 138*)
(*52*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 139*)
(*53*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO5` and `inc_po_l PO5 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO5" "PL1"]
by auto

(* po redu: 140*)
(*54*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 141*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note18 = this
*)
(* po redu: 142*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note17 and note18 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 143*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note19 = this
*)
(* po redu: 144*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note19 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 145*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note20 = this
*)
(* po redu: 146*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note15 and note20 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 147*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note21 = this
*)
(* po redu: 148*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note14 and note21 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 149*)
(*55*)  (*BRANCH NAME*)
} note note22 = this
(* po redu: 150*)
(*56*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 151*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 152*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 153*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 154*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 155*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 156*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 157*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 158*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note23 = this
*)
(* po redu: 159*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 161*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 162*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 163*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note24 = this
*)
(* po redu: 165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

*)
(* po redu: 167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note25 = this
*)
(* po redu: 169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note24 and note25 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 170*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note26 = this
*)
(* po redu: 171*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note23 and note26 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 172*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note27 = this
*)
(* po redu: 173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 174*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 176*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 177*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 179*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note28 = this
*)
(* po redu: 180*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 181*)
(*57*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 182*)
(*58*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 183*)
(*59*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 184*)
(*60*)  (*BRANCH NAME*)
} note note29 = this
(* po redu: 185*)
(*61*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 186*)
(*62*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 187*)
(*63*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 188*)
(*64*)  (*BRANCH NAME*)
} note note30 = this
(* po redu: 189*)
(*65*)  
(*BRANCH END*)
from note29 and note30 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 190*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note31 = this
*)
(* po redu: 191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note28 and note31 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 192*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note32 = this
*)
(* po redu: 193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note27 and note32 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 194*)
(*66*)  (*BRANCH NAME*)
} note note33 = this
(* po redu: 195*)
(*67*)  
(*BRANCH END*)
from note22 and note33 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 196*)
(*68*)  (*BRANCH NAME*)
} note note34 = this
(* po redu: 197*)
(*69*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 198*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 199*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 200*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 202*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 204*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 205*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 206*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note35 = this
*)
(* po redu: 207*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 209*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 210*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note36 = this
*)
(* po redu: 211*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note35 and note36 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 212*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note37 = this
*)
(* po redu: 213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 214*)
(*70*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 215*)
(*71*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 216*)
(*72*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 217*)
(*73*)  (*BRANCH NAME*)
} note note38 = this
(* po redu: 218*)
(*74*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 219*)
(*75*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 220*)
(*76*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 221*)
(*77*)  (*BRANCH NAME*)
} note note39 = this
(* po redu: 222*)
(*78*)  
(*BRANCH END*)
from note38 and note39 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 223*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note40 = this
*)
(* po redu: 224*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note37 and note40 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 225*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note41 = this
*)
(* po redu: 226*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 228*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 229*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 230*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 231*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 232*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 233*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 234*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note42 = this
*)
(* po redu: 235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 236*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 237*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 238*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note43 = this
*)
(* po redu: 239*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note42 and note43 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 240*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note44 = this
*)
(* po redu: 241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 242*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 243*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 244*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 245*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 246*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 247*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note45 = this
*)
(* po redu: 248*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 249*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 250*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 251*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note46 = this
*)
(* po redu: 252*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note45 and note46 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 253*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note47 = this
*)
(* po redu: 254*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note44 and note47 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 255*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note48 = this
*)
(* po redu: 256*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note41 and note48 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 257*)
(*79*)  (*BRANCH NAME*)
} note note49 = this
(* po redu: 258*)
(*80*)  
(*BRANCH END*)
from note34 and note49 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 259*)
(*81*)  (*BRANCH NAME*)
} note note50 = this
(* po redu: 260*)
(*82*)  
(*BRANCH END*)
from note7 and note50 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 261*)
(*83*)  (*BRANCH NAME*)
} note note51 = this
(* po redu: 262*)
(*84*)  
(*BRANCH END*)
from note6 and note51 and `PO3 = PO5 \<or> PO3 ~= PO5`
have ?thesis
by auto
(* po redu: 263*)
(*85*)  (*BRANCH NAME*)
} note note52 = this
(* po redu: 264*)
(*86*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 265*)
(*87*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO4 PO3"
using ax_D1a [of "PO1" "PO4" "LI2" "PO3"]
by auto

(* po redu: 266*)
(*88*)  (*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(* po redu: 267*)
(*89*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
(* po redu: 268*)
(*90*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO4`
have False
by auto

(* po redu: 269*)
(*91*)  (*BRANCH NAME*)
} note note53 = this
(* po redu: 270*)
(*92*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
(* po redu: 271*)
(*93*)  (*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(* po redu: 272*)
(*94*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
(* po redu: 273*)
(*95*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI1" "PO3" "PO4"]
by auto

(* po redu: 274*)
(*96*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 275*)
(*97*)  (*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

(* po redu: 276*)
(*98*)  (*BRANCH NAME*)
} note note54 = this
(* po redu: 277*)
(*99*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(* po redu: 278*)
(*100*)  (*REGULAR*)
moreover
from `PO3 ~= PO4`
obtain  LI3::line
where "inc_po_l PO3 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO3" "PO4"]
by auto

(* po redu: 279*)
(*101*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 280*)
(*102*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO1" "PO3" "PO4"]
by auto

(* po redu: 281*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO4 PO5"
using ax_D1 [of "PO1" "LI2" "PO4" "PO5"]
by auto

*)
(* po redu: 283*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO4 PO5"
using ax_D1 [of "PO4" "LI2" "PO4" "PO5"]
by auto

*)
(* po redu: 285*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO5 PO5"
using ax_D1 [of "PO4" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 287*)
(*103*)  (*REGULAR*)
moreover
from `PO4 ~= PO5` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO4 PO5 PO3"
using ax_D1a [of "PO4" "PO5" "LI2" "PO3"]
by auto

(* po redu: 288*)
(*104*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 289*)
(*105*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 290*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO3 PO3 PO4"
using ax_D1 [of "PO3" "LI3" "PO3" "PO4"]
by auto

*)
(* po redu: 291*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO3 PO4 PO4"
using ax_D1 [of "PO3" "LI3" "PO4" "PO4"]
by auto

*)
(* po redu: 292*)
(*106*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 293*)
(*107*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 294*)
(*108*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 295*)
(*109*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 296*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 298*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 299*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 300*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 301*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 302*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note55 = this
*)
(* po redu: 303*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 304*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 306*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note56 = this
*)
(* po redu: 309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 310*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 312*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI3" "PO3" "PO4"]
by auto

*)
(* po redu: 313*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 314*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 315*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note57 = this
*)
(* po redu: 316*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 317*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 318*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 319*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note58 = this
*)
(* po redu: 320*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note57 and note58 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 321*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note59 = this
*)
(* po redu: 322*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note56 and note59 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 323*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note60 = this
*)
(* po redu: 324*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note55 and note60 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 325*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note61 = this
*)
(* po redu: 326*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 327*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 328*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 329*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 330*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 331*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note62 = this
*)
(* po redu: 332*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 333*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 334*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 335*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 336*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 337*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note63 = this
*)
(* po redu: 338*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 340*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 341*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI3" "PO3" "PO4"]
by auto

*)
(* po redu: 342*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 343*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note64 = this
*)
(* po redu: 345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 347*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 348*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 349*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 350*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

*)
(* po redu: 351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 352*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 353*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 354*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 356*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 357*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 358*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 359*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 360*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 361*)
(*110*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 362*)
(*111*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO3` and `inc_po_l PO3 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO3" "PL1"]
by auto

(* po redu: 363*)
(*112*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO5`
have "PO4 ~= PO1"
by auto

(* po redu: 364*)
(*113*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 365*)
(*114*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 366*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note65 = this
*)
(* po redu: 367*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note64 and note65 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note66 = this
*)
(* po redu: 369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note63 and note66 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 370*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note67 = this
*)
(* po redu: 371*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note62 and note67 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note68 = this
*)
(* po redu: 373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note61 and note68 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 374*)
(*115*)  (*BRANCH NAME*)
} note note69 = this
(* po redu: 375*)
(*116*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 376*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 378*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 380*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 381*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 382*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 383*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note70 = this
*)
(* po redu: 384*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 385*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 386*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 387*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 388*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 389*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note71 = this
*)
(* po redu: 390*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 391*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

*)
(* po redu: 392*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 393*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note72 = this
*)
(* po redu: 394*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note71 and note72 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 395*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note73 = this
*)
(* po redu: 396*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note70 and note73 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 397*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note74 = this
*)
(* po redu: 398*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 400*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 401*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 402*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 403*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 404*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note75 = this
*)
(* po redu: 405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 406*)
(*117*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 407*)
(*118*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 408*)
(*119*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 409*)
(*120*)  (*BRANCH NAME*)
} note note76 = this
(* po redu: 410*)
(*121*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 411*)
(*122*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 412*)
(*123*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 413*)
(*124*)  (*BRANCH NAME*)
} note note77 = this
(* po redu: 414*)
(*125*)  
(*BRANCH END*)
from note76 and note77 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 415*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note78 = this
*)
(* po redu: 416*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note75 and note78 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 417*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note79 = this
*)
(* po redu: 418*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note74 and note79 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 419*)
(*126*)  (*BRANCH NAME*)
} note note80 = this
(* po redu: 420*)
(*127*)  
(*BRANCH END*)
from note69 and note80 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 421*)
(*128*)  (*BRANCH NAME*)
} note note81 = this
(* po redu: 422*)
(*129*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 423*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 424*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 425*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 426*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 427*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 428*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 429*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 430*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 431*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note82 = this
*)
(* po redu: 432*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 433*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 434*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 435*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note83 = this
*)
(* po redu: 436*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note82 and note83 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 437*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note84 = this
*)
(* po redu: 438*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 439*)
(*130*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 440*)
(*131*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 441*)
(*132*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 442*)
(*133*)  (*BRANCH NAME*)
} note note85 = this
(* po redu: 443*)
(*134*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 444*)
(*135*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 445*)
(*136*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 446*)
(*137*)  (*BRANCH NAME*)
} note note86 = this
(* po redu: 447*)
(*138*)  
(*BRANCH END*)
from note85 and note86 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note87 = this
*)
(* po redu: 449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note84 and note87 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 450*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note88 = this
*)
(* po redu: 451*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 452*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 454*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 455*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 456*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 457*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 458*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 459*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note89 = this
*)
(* po redu: 460*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 461*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 462*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 463*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note90 = this
*)
(* po redu: 464*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note89 and note90 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 465*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note91 = this
*)
(* po redu: 466*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 467*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 468*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 469*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 470*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 471*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 472*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note92 = this
*)
(* po redu: 473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 474*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 475*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note93 = this
*)
(* po redu: 477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note92 and note93 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 478*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note94 = this
*)
(* po redu: 479*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note91 and note94 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 480*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note95 = this
*)
(* po redu: 481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note88 and note95 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 482*)
(*139*)  (*BRANCH NAME*)
} note note96 = this
(* po redu: 483*)
(*140*)  
(*BRANCH END*)
from note81 and note96 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 484*)
(*141*)  (*BRANCH NAME*)
} note note97 = this
(* po redu: 485*)
(*142*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 486*)
(*143*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 487*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO3 = PO5 \<or> PO3 ~= PO5"
using ax_g1 [of "PO3" "PO5"]
by auto

*)
(* po redu: 488*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO5"
*)
(* po redu: 489*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO5`
have False
by auto

*)
(* po redu: 490*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note98 = this
*)
(* po redu: 491*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO5"
*)
(* po redu: 492*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

*)
(* po redu: 493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
*)
(* po redu: 494*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI1" "PO3" "PO5"]
by auto

*)
(* po redu: 495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

*)
(* po redu: 496*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

*)
(* po redu: 497*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note99 = this
*)
(* po redu: 498*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
*)
(* po redu: 499*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO3 ~= PO5`
obtain  LI4::line
where "inc_po_l PO3 LI4" and "inc_po_l PO5 LI4"
using ax_I1 [of "PO3" "PO5"]
by auto

*)
(* po redu: 500*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

*)
(* po redu: 501*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5`
obtain  PL2::plane
where "inc_po_pl PO1 PL2" and "inc_po_pl PO3 PL2" and "inc_po_pl PO5 PL2"
using ax_I4a [of "PO1" "PO3" "PO5"]
by auto

*)
(* po redu: 502*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

*)
(* po redu: 503*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO3 PO4 PO5`
obtain  PL3::plane
where "inc_po_pl PO3 PL3" and "inc_po_pl PO4 PL3" and "inc_po_pl PO5 PL3"
using ax_I4a [of "PO3" "PO4" "PO5"]
by auto

*)
(* po redu: 504*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO3 PO3 PO4"
using ax_D1 [of "PO3" "LI3" "PO3" "PO4"]
by auto

*)
(* po redu: 505*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO3 PO4 PO4"
using ax_D1 [of "PO3" "LI3" "PO4" "PO4"]
by auto

*)
(* po redu: 506*)
(*144*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 507*)
(*145*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 508*)
(*146*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 509*)
(*147*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 510*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 511*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 512*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 514*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 515*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 516*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note100 = this
*)
(* po redu: 517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 518*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 519*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 520*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 521*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 522*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note101 = this
*)
(* po redu: 523*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 524*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 525*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 526*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI3" "PO3" "PO4"]
by auto

*)
(* po redu: 527*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 528*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 529*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note102 = this
*)
(* po redu: 530*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 531*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

*)
(* po redu: 532*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
*)
(* po redu: 533*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI3" "PO3" "PO5"]
by auto

*)
(* po redu: 534*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO4 PO5"
using ax_D1 [of "PO3" "LI3" "PO4" "PO5"]
by auto

*)
(* po redu: 535*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

*)
(* po redu: 536*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO3 PO4 PO5` and `\<not>col PO3 PO4 PO5`
have False
by auto

*)
(* po redu: 537*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note103 = this
*)
(* po redu: 538*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
*)
(* po redu: 539*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 541*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note104 = this
*)
(* po redu: 542*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note103 and note104 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have False
by auto
*)
(* po redu: 543*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note105 = this
*)
(* po redu: 544*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note102 and note105 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 545*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note106 = this
*)
(* po redu: 546*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note101 and note106 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 547*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note107 = this
*)
(* po redu: 548*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note100 and note107 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 549*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note108 = this
*)
(* po redu: 550*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 551*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 552*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 553*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 554*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 555*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note109 = this
*)
(* po redu: 556*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 557*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 558*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 559*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 560*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 561*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note110 = this
*)
(* po redu: 562*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 563*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 564*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 565*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI3" "PO3" "PO4"]
by auto

*)
(* po redu: 566*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 567*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 568*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note111 = this
*)
(* po redu: 569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

*)
(* po redu: 571*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
*)
(* po redu: 572*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI3" "PO3" "PO5"]
by auto

*)
(* po redu: 573*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO3 PO4 PO5"
using ax_D1 [of "PO3" "LI3" "PO4" "PO5"]
by auto

*)
(* po redu: 574*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

*)
(* po redu: 575*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO3 PO4 PO5` and `\<not>col PO3 PO4 PO5`
have False
by auto

*)
(* po redu: 576*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note112 = this
*)
(* po redu: 577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
*)
(* po redu: 578*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 580*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 581*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 582*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

*)
(* po redu: 583*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 585*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 586*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 587*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 588*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 589*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 592*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 593*)
(*148*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 594*)
(*149*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO3` and `inc_po_l PO3 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO3" "PL1"]
by auto

(* po redu: 595*)
(*150*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 596*)
(*151*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 597*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note113 = this
*)
(* po redu: 598*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note112 and note113 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have ?thesis
by auto
*)
(* po redu: 599*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note114 = this
*)
(* po redu: 600*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note111 and note114 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 601*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note115 = this
*)
(* po redu: 602*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note110 and note115 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 603*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note116 = this
*)
(* po redu: 604*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note109 and note116 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 605*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note117 = this
*)
(* po redu: 606*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note108 and note117 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 607*)
(*152*)  (*BRANCH NAME*)
} note note118 = this
(* po redu: 608*)
(*153*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 609*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 610*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 612*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 613*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 615*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 616*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note119 = this
*)
(* po redu: 617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 618*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 619*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 620*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 621*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 622*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note120 = this
*)
(* po redu: 623*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 624*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

*)
(* po redu: 625*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 626*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note121 = this
*)
(* po redu: 627*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note120 and note121 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 628*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note122 = this
*)
(* po redu: 629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note119 and note122 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 630*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note123 = this
*)
(* po redu: 631*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 632*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 634*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 636*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 637*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note124 = this
*)
(* po redu: 638*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 639*)
(*154*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 640*)
(*155*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 641*)
(*156*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 642*)
(*157*)  (*BRANCH NAME*)
} note note125 = this
(* po redu: 643*)
(*158*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 644*)
(*159*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 645*)
(*160*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 646*)
(*161*)  (*BRANCH NAME*)
} note note126 = this
(* po redu: 647*)
(*162*)  
(*BRANCH END*)
from note125 and note126 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 648*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note127 = this
*)
(* po redu: 649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note124 and note127 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 650*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note128 = this
*)
(* po redu: 651*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note123 and note128 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 652*)
(*163*)  (*BRANCH NAME*)
} note note129 = this
(* po redu: 653*)
(*164*)  
(*BRANCH END*)
from note118 and note129 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 654*)
(*165*)  (*BRANCH NAME*)
} note note130 = this
(* po redu: 655*)
(*166*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 656*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 658*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 659*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 660*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 662*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 663*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 664*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note131 = this
*)
(* po redu: 665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 666*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 667*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 668*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note132 = this
*)
(* po redu: 669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note131 and note132 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 670*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note133 = this
*)
(* po redu: 671*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 672*)
(*167*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 673*)
(*168*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 674*)
(*169*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 675*)
(*170*)  (*BRANCH NAME*)
} note note134 = this
(* po redu: 676*)
(*171*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 677*)
(*172*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

(* po redu: 678*)
(*173*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 679*)
(*174*)  (*BRANCH NAME*)
} note note135 = this
(* po redu: 680*)
(*175*)  
(*BRANCH END*)
from note134 and note135 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 681*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note136 = this
*)
(* po redu: 682*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note133 and note136 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 683*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note137 = this
*)
(* po redu: 684*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 685*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 686*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 687*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 688*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 689*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 690*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 691*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 692*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note138 = this
*)
(* po redu: 693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 695*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 696*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note139 = this
*)
(* po redu: 697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note138 and note139 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 698*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note140 = this
*)
(* po redu: 699*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 700*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 702*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 704*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 705*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note141 = this
*)
(* po redu: 706*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 707*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO3"]
by auto

*)
(* po redu: 708*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 709*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note142 = this
*)
(* po redu: 710*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note141 and note142 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 711*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note143 = this
*)
(* po redu: 712*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note140 and note143 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 713*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note144 = this
*)
(* po redu: 714*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note137 and note144 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 715*)
(*176*)  (*BRANCH NAME*)
} note note145 = this
(* po redu: 716*)
(*177*)  
(*BRANCH END*)
from note130 and note145 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 717*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note146 = this
*)
(* po redu: 718*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note99 and note146 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
*)
(* po redu: 719*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note147 = this
*)
(* po redu: 720*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note98 and note147 and `PO3 = PO5 \<or> PO3 ~= PO5`
have ?thesis
by auto
*)
(* po redu: 721*)
(*178*)  (*BRANCH NAME*)
} note note148 = this
(* po redu: 722*)
(*179*)  
(*BRANCH END*)
from note97 and note148 and `PO1 = PO5 \<or> PO1 ~= PO5`
have ?thesis
by auto
(* po redu: 723*)
(*180*)  (*BRANCH NAME*)
} note note149 = this
(* po redu: 724*)
(*181*)  
(*BRANCH END*)
from note54 and note149 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(* po redu: 725*)
(*182*)  (*BRANCH NAME*)
} note note150 = this
(* po redu: 726*)
(*183*)  
(*BRANCH END*)
from note53 and note150 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
(* po redu: 727*)
(*184*)  (*BRANCH NAME*)
} note note151 = this
(* po redu: 728*)
(*185*)  
(*BRANCH END*)
from note52 and note151 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 729*)
(*186*)  (*BRANCH NAME*)
} note note152 = this
(* po redu: 730*)
(*187*)  
(*BRANCH END*)
from note5 and note152 and `inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2`
have ?thesis
by auto
(* po redu: 731*)
(*188*)  (*BRANCH NAME*)
} note note153 = this
(* po redu: 732*)
(*189*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 733*)
(*190*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2"
using ax_g4 [of "PO2" "LI2"]
by auto

(* po redu: 734*)
(*191*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI2"
(* po redu: 735*)
(*192*)  (*REGULAR*)
moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO2 LI2`
have  "LI1 = LI2"
using ax_I2 [of "PO1" "PO2" "LI1" "LI2"]
by auto

(* po redu: 736*)
(*193*)  (*REGULAR*)
moreover
from `LI1 = LI2` and `LI1 ~= LI2`
have False
by auto

(* po redu: 737*)
(*194*)  (*BRANCH NAME*)
} note note154 = this
(* po redu: 738*)
(*195*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI2"
(* po redu: 739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

*)
(* po redu: 740*)
(*196*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(* po redu: 741*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 742*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

*)
(* po redu: 743*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 744*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 745*)
(*197*)  (*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(* po redu: 746*)
(*198*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
(* po redu: 747*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

*)
(* po redu: 748*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 749*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 750*)
(*199*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 751*)
(*200*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 752*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 753*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 754*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 755*)
(*201*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 756*)
(*202*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 757*)
(*203*)  (*REGULAR*)
moreover

have  "PO2 = PO5 \<or> PO2 ~= PO5"
using ax_g1 [of "PO2" "PO5"]
by auto

(* po redu: 758*)
(*204*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO5"
(* po redu: 759*)
(*205*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO5`
have False
by auto

(* po redu: 760*)
(*206*)  (*BRANCH NAME*)
} note note155 = this
(* po redu: 761*)
(*207*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO5"
(* po redu: 762*)
(*208*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 763*)
(*209*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 764*)
(*210*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI1" "PO2" "PO5"]
by auto

(* po redu: 765*)
(*211*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 766*)
(*212*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 767*)
(*213*)  (*BRANCH NAME*)
} note note156 = this
(* po redu: 768*)
(*214*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 769*)
(*215*)  (*REGULAR*)
moreover
from `PO2 ~= PO5`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO2" "PO5"]
by auto

(* po redu: 770*)
(*216*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 771*)
(*217*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO5 PL1"
using ax_I4a [of "PO1" "PO2" "PO5"]
by auto

(* po redu: 772*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 773*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO5 PO5"
using ax_D1 [of "PO2" "LI3" "PO5" "PO5"]
by auto

*)
(* po redu: 774*)
(*218*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 775*)
(*219*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 776*)
(*220*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 777*)
(*221*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 778*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 779*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 780*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 782*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 783*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 784*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note157 = this
*)
(* po redu: 785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 786*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 787*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 788*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 789*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 790*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note158 = this
*)
(* po redu: 791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 792*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 794*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 795*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 796*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

*)
(* po redu: 797*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note159 = this
*)
(* po redu: 798*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 800*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 801*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note160 = this
*)
(* po redu: 802*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note159 and note160 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 803*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note161 = this
*)
(* po redu: 804*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note158 and note161 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 805*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note162 = this
*)
(* po redu: 806*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note157 and note162 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 807*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note163 = this
*)
(* po redu: 808*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 809*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 810*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 811*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 812*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 813*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note164 = this
*)
(* po redu: 814*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 816*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 817*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 818*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 819*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note165 = this
*)
(* po redu: 820*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 821*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 822*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 823*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 824*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 825*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

*)
(* po redu: 826*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note166 = this
*)
(* po redu: 827*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 828*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 829*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 830*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 831*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 832*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO5"]
by auto

*)
(* po redu: 833*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 834*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 835*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO5"]
by auto

*)
(* po redu: 836*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO5" "PO5"]
by auto

*)
(* po redu: 837*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 838*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 839*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO2 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO5"]
by auto

*)
(* po redu: 840*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO5" "PO5"]
by auto

*)
(* po redu: 841*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO5 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 842*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 843*)
(*222*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO3`
have "PO2 ~= PO1"
by auto

(* po redu: 844*)
(*223*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 845*)
(*224*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 846*)
(*225*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO5` and `inc_po_l PO5 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO5" "PL1"]
by auto

(* po redu: 847*)
(*226*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 848*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note167 = this
*)
(* po redu: 849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note166 and note167 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 850*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note168 = this
*)
(* po redu: 851*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note165 and note168 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 852*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note169 = this
*)
(* po redu: 853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note164 and note169 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 854*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note170 = this
*)
(* po redu: 855*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note163 and note170 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 856*)
(*227*)  (*BRANCH NAME*)
} note note171 = this
(* po redu: 857*)
(*228*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 858*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 859*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 860*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 861*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 862*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 863*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 864*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 865*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note172 = this
*)
(* po redu: 866*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 867*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 868*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 869*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 870*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 871*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note173 = this
*)
(* po redu: 872*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 873*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

*)
(* po redu: 874*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 875*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note174 = this
*)
(* po redu: 876*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note173 and note174 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 877*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note175 = this
*)
(* po redu: 878*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note172 and note175 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 879*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note176 = this
*)
(* po redu: 880*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 881*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 882*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 883*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 884*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 885*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 886*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note177 = this
*)
(* po redu: 887*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 888*)
(*229*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 889*)
(*230*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 890*)
(*231*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 891*)
(*232*)  (*BRANCH NAME*)
} note note178 = this
(* po redu: 892*)
(*233*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 893*)
(*234*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 894*)
(*235*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 895*)
(*236*)  (*BRANCH NAME*)
} note note179 = this
(* po redu: 896*)
(*237*)  
(*BRANCH END*)
from note178 and note179 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 897*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note180 = this
*)
(* po redu: 898*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note177 and note180 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 899*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note181 = this
*)
(* po redu: 900*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note176 and note181 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 901*)
(*238*)  (*BRANCH NAME*)
} note note182 = this
(* po redu: 902*)
(*239*)  
(*BRANCH END*)
from note171 and note182 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 903*)
(*240*)  (*BRANCH NAME*)
} note note183 = this
(* po redu: 904*)
(*241*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 905*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 906*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 907*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 908*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 909*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 910*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 911*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 912*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 913*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note184 = this
*)
(* po redu: 914*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 915*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 916*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 917*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note185 = this
*)
(* po redu: 918*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note184 and note185 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 919*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note186 = this
*)
(* po redu: 920*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 921*)
(*242*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 922*)
(*243*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 923*)
(*244*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 924*)
(*245*)  (*BRANCH NAME*)
} note note187 = this
(* po redu: 925*)
(*246*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 926*)
(*247*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 927*)
(*248*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 928*)
(*249*)  (*BRANCH NAME*)
} note note188 = this
(* po redu: 929*)
(*250*)  
(*BRANCH END*)
from note187 and note188 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 930*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note189 = this
*)
(* po redu: 931*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note186 and note189 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 932*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note190 = this
*)
(* po redu: 933*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 934*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 935*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 936*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 938*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 939*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 940*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 941*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note191 = this
*)
(* po redu: 942*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 943*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 944*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 945*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note192 = this
*)
(* po redu: 946*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note191 and note192 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 947*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note193 = this
*)
(* po redu: 948*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 949*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 950*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 951*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 952*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 953*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 954*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note194 = this
*)
(* po redu: 955*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 956*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 957*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 958*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note195 = this
*)
(* po redu: 959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note194 and note195 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 960*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note196 = this
*)
(* po redu: 961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note193 and note196 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 962*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note197 = this
*)
(* po redu: 963*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note190 and note197 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 964*)
(*251*)  (*BRANCH NAME*)
} note note198 = this
(* po redu: 965*)
(*252*)  
(*BRANCH END*)
from note183 and note198 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 966*)
(*253*)  (*BRANCH NAME*)
} note note199 = this
(* po redu: 967*)
(*254*)  
(*BRANCH END*)
from note156 and note199 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 968*)
(*255*)  (*BRANCH NAME*)
} note note200 = this
(* po redu: 969*)
(*256*)  
(*BRANCH END*)
from note155 and note200 and `PO2 = PO5 \<or> PO2 ~= PO5`
have ?thesis
by auto
(* po redu: 970*)
(*257*)  (*BRANCH NAME*)
} note note201 = this
(* po redu: 971*)
(*258*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 972*)
(*259*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO4 PO2"
using ax_D1a [of "PO1" "PO4" "LI2" "PO2"]
by auto

(* po redu: 973*)
(*260*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 974*)
(*261*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 975*)
(*262*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO4`
have False
by auto

(* po redu: 976*)
(*263*)  (*BRANCH NAME*)
} note note202 = this
(* po redu: 977*)
(*264*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 978*)
(*265*)  (*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(* po redu: 979*)
(*266*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
(* po redu: 980*)
(*267*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

(* po redu: 981*)
(*268*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 982*)
(*269*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 983*)
(*270*)  (*BRANCH NAME*)
} note note203 = this
(* po redu: 984*)
(*271*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(* po redu: 985*)
(*272*)  (*REGULAR*)
moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(* po redu: 986*)
(*273*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 987*)
(*274*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO1" "PO2" "PO4"]
by auto

(* po redu: 988*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 989*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO4 PO5"
using ax_D1 [of "PO1" "LI2" "PO4" "PO5"]
by auto

*)
(* po redu: 990*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 991*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO4 PO5"
using ax_D1 [of "PO4" "LI2" "PO4" "PO5"]
by auto

*)
(* po redu: 992*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO5 PO5"
using ax_D1 [of "PO4" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 993*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 994*)
(*275*)  (*REGULAR*)
moreover
from `PO4 ~= PO5` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO4 PO5 PO2"
using ax_D1a [of "PO4" "PO5" "LI2" "PO2"]
by auto

(* po redu: 995*)
(*276*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 996*)
(*277*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 997*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 998*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO4 PO4"
using ax_D1 [of "PO2" "LI3" "PO4" "PO4"]
by auto

*)
(* po redu: 999*)
(*278*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 1000*)
(*279*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 1001*)
(*280*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 1002*)
(*281*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 1003*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1004*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1005*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1006*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1007*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1008*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1009*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note204 = this
*)
(* po redu: 1010*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1011*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1012*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1013*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1014*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1015*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note205 = this
*)
(* po redu: 1016*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 1017*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 1018*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 1019*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 1020*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 1021*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 1022*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note206 = this
*)
(* po redu: 1023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 1024*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 1025*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 1026*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note207 = this
*)
(* po redu: 1027*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note206 and note207 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 1028*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note208 = this
*)
(* po redu: 1029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note205 and note208 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 1030*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note209 = this
*)
(* po redu: 1031*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note204 and note209 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1032*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note210 = this
*)
(* po redu: 1033*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1034*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1035*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1036*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1037*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1038*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note211 = this
*)
(* po redu: 1039*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1040*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1041*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1042*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1043*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1044*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note212 = this
*)
(* po redu: 1045*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 1046*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 1047*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 1048*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 1049*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 1050*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 1051*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note213 = this
*)
(* po redu: 1052*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 1053*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 1054*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 1055*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 1056*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 1057*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

*)
(* po redu: 1058*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 1059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 1060*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 1061*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 1062*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 1063*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 1064*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 1065*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 1066*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 1067*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 1068*)
(*282*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO3`
have "PO2 ~= PO1"
by auto

(* po redu: 1069*)
(*283*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 1070*)
(*284*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO5`
have "PO4 ~= PO1"
by auto

(* po redu: 1071*)
(*285*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 1072*)
(*286*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 1073*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note214 = this
*)
(* po redu: 1074*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note213 and note214 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 1075*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note215 = this
*)
(* po redu: 1076*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note212 and note215 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 1077*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note216 = this
*)
(* po redu: 1078*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note211 and note216 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 1079*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note217 = this
*)
(* po redu: 1080*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note210 and note217 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 1081*)
(*287*)  (*BRANCH NAME*)
} note note218 = this
(* po redu: 1082*)
(*288*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 1083*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1084*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1085*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1086*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1087*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1088*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1089*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1090*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note219 = this
*)
(* po redu: 1091*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1092*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1093*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1094*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1095*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1096*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note220 = this
*)
(* po redu: 1097*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 1098*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

*)
(* po redu: 1099*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 1100*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note221 = this
*)
(* po redu: 1101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note220 and note221 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 1102*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note222 = this
*)
(* po redu: 1103*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note219 and note222 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1104*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note223 = this
*)
(* po redu: 1105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1106*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1107*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1108*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1109*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1110*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1111*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note224 = this
*)
(* po redu: 1112*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1113*)
(*289*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1114*)
(*290*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1115*)
(*291*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 1116*)
(*292*)  (*BRANCH NAME*)
} note note225 = this
(* po redu: 1117*)
(*293*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1118*)
(*294*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 1119*)
(*295*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 1120*)
(*296*)  (*BRANCH NAME*)
} note note226 = this
(* po redu: 1121*)
(*297*)  
(*BRANCH END*)
from note225 and note226 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1122*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note227 = this
*)
(* po redu: 1123*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note224 and note227 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1124*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note228 = this
*)
(* po redu: 1125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note223 and note228 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 1126*)
(*298*)  (*BRANCH NAME*)
} note note229 = this
(* po redu: 1127*)
(*299*)  
(*BRANCH END*)
from note218 and note229 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 1128*)
(*300*)  (*BRANCH NAME*)
} note note230 = this
(* po redu: 1129*)
(*301*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 1130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 1131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 1132*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1134*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1135*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1136*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1137*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1138*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note231 = this
*)
(* po redu: 1139*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1140*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 1141*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 1142*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note232 = this
*)
(* po redu: 1143*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note231 and note232 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1144*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note233 = this
*)
(* po redu: 1145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1146*)
(*302*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1147*)
(*303*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1148*)
(*304*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 1149*)
(*305*)  (*BRANCH NAME*)
} note note234 = this
(* po redu: 1150*)
(*306*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1151*)
(*307*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1152*)
(*308*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1153*)
(*309*)  (*BRANCH NAME*)
} note note235 = this
(* po redu: 1154*)
(*310*)  
(*BRANCH END*)
from note234 and note235 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1155*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note236 = this
*)
(* po redu: 1156*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note233 and note236 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 1157*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note237 = this
*)
(* po redu: 1158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 1159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1160*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1161*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1162*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1163*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1164*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1165*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1166*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note238 = this
*)
(* po redu: 1167*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1168*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 1169*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 1170*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note239 = this
*)
(* po redu: 1171*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note238 and note239 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1172*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note240 = this
*)
(* po redu: 1173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1174*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1176*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1177*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1179*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note241 = this
*)
(* po redu: 1180*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1181*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 1182*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 1183*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note242 = this
*)
(* po redu: 1184*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note241 and note242 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1185*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note243 = this
*)
(* po redu: 1186*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note240 and note243 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 1187*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note244 = this
*)
(* po redu: 1188*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note237 and note244 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 1189*)
(*311*)  (*BRANCH NAME*)
} note note245 = this
(* po redu: 1190*)
(*312*)  
(*BRANCH END*)
from note230 and note245 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 1191*)
(*313*)  (*BRANCH NAME*)
} note note246 = this
(* po redu: 1192*)
(*314*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 1193*)
(*315*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 1194*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO5 \<or> PO2 ~= PO5"
using ax_g1 [of "PO2" "PO5"]
by auto

*)
(* po redu: 1195*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO5"
*)
(* po redu: 1196*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO5`
have False
by auto

*)
(* po redu: 1197*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note247 = this
*)
(* po redu: 1198*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO5"
*)
(* po redu: 1199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

*)
(* po redu: 1200*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
*)
(* po redu: 1201*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI1" "PO2" "PO5"]
by auto

*)
(* po redu: 1202*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 1203*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

*)
(* po redu: 1204*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note248 = this
*)
(* po redu: 1205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
*)
(* po redu: 1206*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO2 ~= PO5`
obtain  LI4::line
where "inc_po_l PO2 LI4" and "inc_po_l PO5 LI4"
using ax_I1 [of "PO2" "PO5"]
by auto

*)
(* po redu: 1207*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 1208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5`
obtain  PL2::plane
where "inc_po_pl PO1 PL2" and "inc_po_pl PO2 PL2" and "inc_po_pl PO5 PL2"
using ax_I4a [of "PO1" "PO2" "PO5"]
by auto

*)
(* po redu: 1209*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

*)
(* po redu: 1210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO2 PO4 PO5`
obtain  PL3::plane
where "inc_po_pl PO2 PL3" and "inc_po_pl PO4 PL3" and "inc_po_pl PO5 PL3"
using ax_I4a [of "PO2" "PO4" "PO5"]
by auto

*)
(* po redu: 1211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 1212*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO4 PO4"
using ax_D1 [of "PO2" "LI3" "PO4" "PO4"]
by auto

*)
(* po redu: 1213*)
(*316*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 1214*)
(*317*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 1215*)
(*318*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 1216*)
(*319*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 1217*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1218*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1219*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1220*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1221*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1222*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1223*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note249 = this
*)
(* po redu: 1224*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1225*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1226*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1227*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1228*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1229*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note250 = this
*)
(* po redu: 1230*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 1231*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 1232*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 1233*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 1234*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 1235*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 1236*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note251 = this
*)
(* po redu: 1237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 1238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

*)
(* po redu: 1239*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
*)
(* po redu: 1240*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 1241*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO4 PO5"
using ax_D1 [of "PO2" "LI3" "PO4" "PO5"]
by auto

*)
(* po redu: 1242*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

*)
(* po redu: 1243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO4 PO5` and `\<not>col PO2 PO4 PO5`
have False
by auto

*)
(* po redu: 1244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note252 = this
*)
(* po redu: 1245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
*)
(* po redu: 1246*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 1247*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 1248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note253 = this
*)
(* po redu: 1249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note252 and note253 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have False
by auto
*)
(* po redu: 1250*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note254 = this
*)
(* po redu: 1251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note251 and note254 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 1252*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note255 = this
*)
(* po redu: 1253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note250 and note255 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 1254*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note256 = this
*)
(* po redu: 1255*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note249 and note256 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1256*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note257 = this
*)
(* po redu: 1257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1258*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1260*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1261*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1262*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note258 = this
*)
(* po redu: 1263*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1264*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1266*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1268*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note259 = this
*)
(* po redu: 1269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 1270*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 1271*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 1272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 1273*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 1274*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 1275*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note260 = this
*)
(* po redu: 1276*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 1277*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

*)
(* po redu: 1278*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
*)
(* po redu: 1279*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 1280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO4 PO5"
using ax_D1 [of "PO2" "LI3" "PO4" "PO5"]
by auto

*)
(* po redu: 1281*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

*)
(* po redu: 1282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO4 PO5` and `\<not>col PO2 PO4 PO5`
have False
by auto

*)
(* po redu: 1283*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note261 = this
*)
(* po redu: 1284*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
*)
(* po redu: 1285*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 1286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 1287*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 1288*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 1289*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

*)
(* po redu: 1290*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 1291*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 1292*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 1293*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 1294*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 1295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 1296*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 1297*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 1298*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 1299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 1300*)
(*320*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO3`
have "PO2 ~= PO1"
by auto

(* po redu: 1301*)
(*321*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 1302*)
(*322*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 1303*)
(*323*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 1304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note262 = this
*)
(* po redu: 1305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note261 and note262 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have ?thesis
by auto
*)
(* po redu: 1306*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note263 = this
*)
(* po redu: 1307*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note260 and note263 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 1308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note264 = this
*)
(* po redu: 1309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note259 and note264 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 1310*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note265 = this
*)
(* po redu: 1311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note258 and note265 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 1312*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note266 = this
*)
(* po redu: 1313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note257 and note266 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 1314*)
(*324*)  (*BRANCH NAME*)
} note note267 = this
(* po redu: 1315*)
(*325*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 1316*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1318*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1319*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1320*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1321*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1322*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1323*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note268 = this
*)
(* po redu: 1324*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1325*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1326*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1327*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1328*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1329*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note269 = this
*)
(* po redu: 1330*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 1331*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

*)
(* po redu: 1332*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 1333*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note270 = this
*)
(* po redu: 1334*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note269 and note270 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 1335*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note271 = this
*)
(* po redu: 1336*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note268 and note271 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1337*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note272 = this
*)
(* po redu: 1338*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1340*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1341*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1342*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1343*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note273 = this
*)
(* po redu: 1345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1346*)
(*326*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 1347*)
(*327*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 1348*)
(*328*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 1349*)
(*329*)  (*BRANCH NAME*)
} note note274 = this
(* po redu: 1350*)
(*330*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 1351*)
(*331*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 1352*)
(*332*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 1353*)
(*333*)  (*BRANCH NAME*)
} note note275 = this
(* po redu: 1354*)
(*334*)  
(*BRANCH END*)
from note274 and note275 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 1355*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note276 = this
*)
(* po redu: 1356*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note273 and note276 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1357*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note277 = this
*)
(* po redu: 1358*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note272 and note277 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 1359*)
(*335*)  (*BRANCH NAME*)
} note note278 = this
(* po redu: 1360*)
(*336*)  
(*BRANCH END*)
from note267 and note278 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 1361*)
(*337*)  (*BRANCH NAME*)
} note note279 = this
(* po redu: 1362*)
(*338*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 1363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 1364*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 1365*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1366*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1368*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1369*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1370*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1371*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note280 = this
*)
(* po redu: 1372*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1373*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 1374*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 1375*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note281 = this
*)
(* po redu: 1376*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note280 and note281 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1377*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note282 = this
*)
(* po redu: 1378*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1379*)
(*339*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 1380*)
(*340*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 1381*)
(*341*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 1382*)
(*342*)  (*BRANCH NAME*)
} note note283 = this
(* po redu: 1383*)
(*343*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 1384*)
(*344*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 1385*)
(*345*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 1386*)
(*346*)  (*BRANCH NAME*)
} note note284 = this
(* po redu: 1387*)
(*347*)  
(*BRANCH END*)
from note283 and note284 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 1388*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note285 = this
*)
(* po redu: 1389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note282 and note285 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 1390*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note286 = this
*)
(* po redu: 1391*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 1392*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1394*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1395*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1396*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1397*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1399*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note287 = this
*)
(* po redu: 1400*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1401*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 1402*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 1403*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note288 = this
*)
(* po redu: 1404*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note287 and note288 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1405*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note289 = this
*)
(* po redu: 1406*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1407*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1408*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1409*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1410*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1411*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note290 = this
*)
(* po redu: 1413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1414*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 1415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 1416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note291 = this
*)
(* po redu: 1417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note290 and note291 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1418*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note292 = this
*)
(* po redu: 1419*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note289 and note292 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 1420*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note293 = this
*)
(* po redu: 1421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note286 and note293 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 1422*)
(*348*)  (*BRANCH NAME*)
} note note294 = this
(* po redu: 1423*)
(*349*)  
(*BRANCH END*)
from note279 and note294 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 1424*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note295 = this
*)
(* po redu: 1425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note248 and note295 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
*)
(* po redu: 1426*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note296 = this
*)
(* po redu: 1427*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note247 and note296 and `PO2 = PO5 \<or> PO2 ~= PO5`
have ?thesis
by auto
*)
(* po redu: 1428*)
(*350*)  (*BRANCH NAME*)
} note note297 = this
(* po redu: 1429*)
(*351*)  
(*BRANCH END*)
from note246 and note297 and `PO1 = PO5 \<or> PO1 ~= PO5`
have ?thesis
by auto
(* po redu: 1430*)
(*352*)  (*BRANCH NAME*)
} note note298 = this
(* po redu: 1431*)
(*353*)  
(*BRANCH END*)
from note203 and note298 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(* po redu: 1432*)
(*354*)  (*BRANCH NAME*)
} note note299 = this
(* po redu: 1433*)
(*355*)  
(*BRANCH END*)
from note202 and note299 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 1434*)
(*356*)  (*BRANCH NAME*)
} note note300 = this
(* po redu: 1435*)
(*357*)  
(*BRANCH END*)
from note201 and note300 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 1436*)
(*358*)  (*BRANCH NAME*)
} note note301 = this
(* po redu: 1437*)
(*359*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
(* po redu: 1438*)
(*360*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2"
using ax_g4 [of "PO3" "LI2"]
by auto

(* po redu: 1439*)
(*361*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI2"
(* po redu: 1440*)
(*362*)  (*REGULAR*)
moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO3 PO2"
using ax_D1a [of "PO1" "PO3" "LI2" "PO2"]
by auto

(* po redu: 1441*)
(*363*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_132 [of "PO1" "PO3" "PO2"]
by auto

(* po redu: 1442*)
(*364*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3`
have  "\<not>col PO1 PO3 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO3"]
by auto

(* po redu: 1443*)
(*365*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO3`
have  "col PO1 PO3 PO2"
using ax_col_132 [of "PO1" "PO2" "PO3"]
by auto

(* po redu: 1444*)
(*366*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2` and `col PO1 PO3 PO2`
have False
by auto

(* po redu: 1445*)
(*367*)  (*BRANCH NAME*)
} note note302 = this
(* po redu: 1446*)
(*368*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI2"
(* po redu: 1447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

*)
(* po redu: 1448*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 1449*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 1450*)
(*369*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 1451*)
(*370*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 1452*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 1453*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 1454*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 1455*)
(*371*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 1456*)
(*372*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 1457*)
(*373*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 1458*)
(*374*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 1459*)
(*375*)  (*REGULAR*)
moreover

have  "PO2 = PO5 \<or> PO2 ~= PO5"
using ax_g1 [of "PO2" "PO5"]
by auto

(* po redu: 1460*)
(*376*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO5"
(* po redu: 1461*)
(*377*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO5`
have False
by auto

(* po redu: 1462*)
(*378*)  (*BRANCH NAME*)
} note note303 = this
(* po redu: 1463*)
(*379*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO5"
(* po redu: 1464*)
(*380*)  (*REGULAR*)
moreover

have  "PO3 = PO5 \<or> PO3 ~= PO5"
using ax_g1 [of "PO3" "PO5"]
by auto

(* po redu: 1465*)
(*381*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO5"
(* po redu: 1466*)
(*382*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO5`
have False
by auto

(* po redu: 1467*)
(*383*)  (*BRANCH NAME*)
} note note304 = this
(* po redu: 1468*)
(*384*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO5"
(* po redu: 1469*)
(*385*)  (*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

(* po redu: 1470*)
(*386*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
(* po redu: 1471*)
(*387*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI1" "PO2" "PO5"]
by auto

(* po redu: 1472*)
(*388*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 1473*)
(*389*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

(* po redu: 1474*)
(*390*)  (*BRANCH NAME*)
} note note305 = this
(* po redu: 1475*)
(*391*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
(* po redu: 1476*)
(*392*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO5 LI1`
have  "\<not>col PO2 PO3 PO5"
using ax_D1a [of "PO2" "PO3" "LI1" "PO5"]
by auto

(* po redu: 1477*)
(*393*)  (*REGULAR*)
moreover
from `PO2 ~= PO5`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO5 LI3"
using ax_I1 [of "PO2" "PO5"]
by auto

(* po redu: 1478*)
(*394*)  (*REGULAR*)
moreover
from `PO3 ~= PO5`
obtain  LI4::line
where "inc_po_l PO3 LI4" and "inc_po_l PO5 LI4"
using ax_I1 [of "PO3" "PO5"]
by auto

(* po redu: 1479*)
(*395*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 1480*)
(*396*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO5 PL1"
using ax_I4a [of "PO1" "PO2" "PO5"]
by auto

(* po redu: 1481*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

*)
(* po redu: 1482*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5`
obtain  PL2::plane
where "inc_po_pl PO1 PL2" and "inc_po_pl PO3 PL2" and "inc_po_pl PO5 PL2"
using ax_I4a [of "PO1" "PO3" "PO5"]
by auto

*)
(* po redu: 1483*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO5`
obtain  PL3::plane
where "inc_po_pl PO2 PL3" and "inc_po_pl PO3 PL3" and "inc_po_pl PO5 PL3"
using ax_I4a [of "PO2" "PO3" "PO5"]
by auto

*)
(* po redu: 1484*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 1485*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO5 PO5"
using ax_D1 [of "PO2" "LI3" "PO5" "PO5"]
by auto

*)
(* po redu: 1486*)
(*397*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 1487*)
(*398*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 1488*)
(*399*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 1489*)
(*400*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 1490*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1491*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1492*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1494*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note306 = this
*)
(* po redu: 1497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1498*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1499*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1500*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1501*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1502*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note307 = this
*)
(* po redu: 1503*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 1504*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 1505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 1506*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 1507*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 1508*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

*)
(* po redu: 1509*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note308 = this
*)
(* po redu: 1510*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 1511*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

*)
(* po redu: 1512*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
*)
(* po redu: 1513*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO3 PO5"
using ax_D1 [of "PO2" "LI3" "PO3" "PO5"]
by auto

*)
(* po redu: 1514*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO5` and `\<not>col PO2 PO3 PO5`
have False
by auto

*)
(* po redu: 1515*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note309 = this
*)
(* po redu: 1516*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
*)
(* po redu: 1517*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 1518*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 1519*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note310 = this
*)
(* po redu: 1520*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note309 and note310 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have False
by auto
*)
(* po redu: 1521*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note311 = this
*)
(* po redu: 1522*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note308 and note311 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 1523*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note312 = this
*)
(* po redu: 1524*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note307 and note312 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 1525*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note313 = this
*)
(* po redu: 1526*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note306 and note313 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 1527*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note314 = this
*)
(* po redu: 1528*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 1529*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1530*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1531*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1532*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1533*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note315 = this
*)
(* po redu: 1534*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1535*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1536*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1537*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1538*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1539*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note316 = this
*)
(* po redu: 1540*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 1541*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 1542*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 1543*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 1544*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 1545*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

*)
(* po redu: 1546*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note317 = this
*)
(* po redu: 1547*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 1548*)
(*401*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 1549*)
(*402*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 1550*)
(*403*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO3 PO5"
using ax_D1 [of "PO2" "LI3" "PO3" "PO5"]
by auto

(* po redu: 1551*)
(*404*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO5` and `\<not>col PO2 PO3 PO5`
have False
by auto

(* po redu: 1552*)
(*405*)  (*BRANCH NAME*)
} note note318 = this
(* po redu: 1553*)
(*406*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 1554*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI4" "PO3" "PO5"]
by auto

*)
(* po redu: 1555*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO5 PO5"
using ax_D1 [of "PO3" "LI4" "PO5" "PO5"]
by auto

*)
(* po redu: 1556*)
(*407*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4"
using ax_D6a [of "LI1" "LI4"]
by auto

(* po redu: 1557*)
(*408*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI4"
(* po redu: 1558*)
(*409*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 1559*)
(*410*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 1560*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 1561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 1562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 1563*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 1564*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1566*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1567*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1568*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note319 = this
*)
(* po redu: 1569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 1571*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 1572*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1573*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1574*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note320 = this
*)
(* po redu: 1575*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 1576*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 1577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 1578*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 1579*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note321 = this
*)
(* po redu: 1580*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 1581*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

*)
(* po redu: 1582*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
*)
(* po redu: 1583*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI4" "PO3" "PO5"]
by auto

*)
(* po redu: 1584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

*)
(* po redu: 1585*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

*)
(* po redu: 1586*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note322 = this
*)
(* po redu: 1587*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
*)
(* po redu: 1588*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

*)
(* po redu: 1589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
*)
(* po redu: 1590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO2 PO3 PO5"
using ax_D1 [of "PO2" "LI4" "PO3" "PO5"]
by auto

*)
(* po redu: 1591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO5` and `\<not>col PO2 PO3 PO5`
have False
by auto

*)
(* po redu: 1592*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note323 = this
*)
(* po redu: 1593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
*)
(* po redu: 1594*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI4 LI4`
obtain  PO6::point
where "inc_po_l PO6 LI4" and "inc_po_l PO6 LI4" and "LI4 ~= LI4"
using ax_D6 [of "LI4" "LI4"]
by auto

*)
(* po redu: 1595*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI4 ~= LI4`
have False
by auto

*)
(* po redu: 1596*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note324 = this
*)
(* po redu: 1597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note323 and note324 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have False
by auto
*)
(* po redu: 1598*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note325 = this
*)
(* po redu: 1599*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note322 and note325 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have False
by auto
*)
(* po redu: 1600*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note326 = this
*)
(* po redu: 1601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note321 and note326 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 1602*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note327 = this
*)
(* po redu: 1603*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note320 and note327 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 1604*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note328 = this
*)
(* po redu: 1605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note319 and note328 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1606*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note329 = this
*)
(* po redu: 1607*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 1608*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1610*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note330 = this
*)
(* po redu: 1613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 1615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 1616*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1617*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1618*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note331 = this
*)
(* po redu: 1619*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 1620*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 1621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 1622*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 1623*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note332 = this
*)
(* po redu: 1624*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 1625*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

*)
(* po redu: 1626*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
*)
(* po redu: 1627*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO1 PO3 PO5"
using ax_D1 [of "PO1" "LI4" "PO3" "PO5"]
by auto

*)
(* po redu: 1628*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

*)
(* po redu: 1629*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO5` and `\<not>col PO1 PO3 PO5`
have False
by auto

*)
(* po redu: 1630*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note333 = this
*)
(* po redu: 1631*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
*)
(* po redu: 1632*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

*)
(* po redu: 1633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
*)
(* po redu: 1634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO2 PO3 PO5"
using ax_D1 [of "PO2" "LI4" "PO3" "PO5"]
by auto

*)
(* po redu: 1635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO5` and `\<not>col PO2 PO3 PO5`
have False
by auto

*)
(* po redu: 1636*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note334 = this
*)
(* po redu: 1637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
*)
(* po redu: 1638*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 1639*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 1640*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 1641*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 1642*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO5"]
by auto

*)
(* po redu: 1643*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 1644*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 1645*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO5"]
by auto

*)
(* po redu: 1646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO5" "PO5"]
by auto

*)
(* po redu: 1647*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 1648*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 1649*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO2 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO5"]
by auto

*)
(* po redu: 1650*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO5" "PO5"]
by auto

*)
(* po redu: 1651*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO5 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 1652*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 1653*)
(*411*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 1654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

*)
(* po redu: 1655*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 1656*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 1657*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 1658*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO5"]
by auto

*)
(* po redu: 1659*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 1660*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 1661*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO5"]
by auto

*)
(* po redu: 1662*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 1663*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 1664*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 1665*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 1666*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 1667*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO3 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO5"]
by auto

*)
(* po redu: 1668*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 1669*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO3 PO3 PO5"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 1670*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO3 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 1671*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 1672*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO3 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 1673*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 1674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO5 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 1675*)
(*412*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 1676*)
(*413*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO5` and `inc_po_l PO5 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO5" "PL1"]
by auto

(* po redu: 1677*)
(*414*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 1678*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note335 = this
*)
(* po redu: 1679*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note334 and note335 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have ?thesis
by auto
*)
(* po redu: 1680*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note336 = this
*)
(* po redu: 1681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note333 and note336 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have ?thesis
by auto
*)
(* po redu: 1682*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note337 = this
*)
(* po redu: 1683*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note332 and note337 and `LI3 = LI4 \<or> LI3 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 1684*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note338 = this
*)
(* po redu: 1685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note331 and note338 and `LI2 = LI4 \<or> LI2 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 1686*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note339 = this
*)
(* po redu: 1687*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note330 and note339 and `LI1 = LI4 \<or> LI1 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 1688*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note340 = this
*)
(* po redu: 1689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note329 and note340 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have ?thesis
by auto
*)
(* po redu: 1690*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note341 = this
*)
(* po redu: 1691*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 1692*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 1693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 1694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1695*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1696*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1697*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1698*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note342 = this
*)
(* po redu: 1699*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1700*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 1701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 1702*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1704*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note343 = this
*)
(* po redu: 1705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 1706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 1707*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 1708*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 1709*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note344 = this
*)
(* po redu: 1710*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 1711*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO5"]
by auto

*)
(* po redu: 1712*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

*)
(* po redu: 1713*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note345 = this
*)
(* po redu: 1714*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note344 and note345 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 1715*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note346 = this
*)
(* po redu: 1716*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note343 and note346 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 1717*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note347 = this
*)
(* po redu: 1718*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note342 and note347 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1719*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note348 = this
*)
(* po redu: 1720*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 1721*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1722*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1723*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1724*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1725*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note349 = this
*)
(* po redu: 1726*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1727*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 1728*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 1729*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1730*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1731*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note350 = this
*)
(* po redu: 1732*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 1733*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 1734*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 1735*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 1736*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note351 = this
*)
(* po redu: 1737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 1738*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO5 LI3` and `inc_po_l PO5 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO5"]
by auto

*)
(* po redu: 1739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

*)
(* po redu: 1740*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note352 = this
*)
(* po redu: 1741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note351 and note352 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 1742*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note353 = this
*)
(* po redu: 1743*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note350 and note353 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 1744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note354 = this
*)
(* po redu: 1745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note349 and note354 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1746*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note355 = this
*)
(* po redu: 1747*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note348 and note355 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 1748*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note356 = this
*)
(* po redu: 1749*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note341 and note356 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have ?thesis
by auto
*)
(* po redu: 1750*)
(*415*)  (*BRANCH NAME*)
} note note357 = this
(* po redu: 1751*)
(*416*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 1752*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 1753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 1754*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 1755*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 1756*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1758*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1759*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1760*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1761*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note358 = this
*)
(* po redu: 1762*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1763*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 1764*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 1765*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1766*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1767*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note359 = this
*)
(* po redu: 1768*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 1769*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO5"]
by auto

*)
(* po redu: 1770*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

*)
(* po redu: 1771*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note360 = this
*)
(* po redu: 1772*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note359 and note360 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 1773*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note361 = this
*)
(* po redu: 1774*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note358 and note361 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1775*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note362 = this
*)
(* po redu: 1776*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 1777*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1778*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1779*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1780*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1781*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1782*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note363 = this
*)
(* po redu: 1783*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1784*)
(*417*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1785*)
(*418*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1786*)
(*419*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 1787*)
(*420*)  (*BRANCH NAME*)
} note note364 = this
(* po redu: 1788*)
(*421*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1789*)
(*422*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO5"]
by auto

(* po redu: 1790*)
(*423*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 1791*)
(*424*)  (*BRANCH NAME*)
} note note365 = this
(* po redu: 1792*)
(*425*)  
(*BRANCH END*)
from note364 and note365 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1793*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note366 = this
*)
(* po redu: 1794*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note363 and note366 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1795*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note367 = this
*)
(* po redu: 1796*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note362 and note367 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 1797*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note368 = this
*)
(* po redu: 1798*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 1799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 1800*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 1801*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1802*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1803*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1804*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1805*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1806*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note369 = this
*)
(* po redu: 1807*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1808*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 1809*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 1810*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1812*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note370 = this
*)
(* po redu: 1813*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 1814*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO5"]
by auto

*)
(* po redu: 1815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

*)
(* po redu: 1816*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note371 = this
*)
(* po redu: 1817*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note370 and note371 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 1818*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note372 = this
*)
(* po redu: 1819*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note369 and note372 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1820*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note373 = this
*)
(* po redu: 1821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 1822*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1823*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1824*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1825*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1826*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1827*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note374 = this
*)
(* po redu: 1828*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1829*)
(*426*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 1830*)
(*427*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 1831*)
(*428*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 1832*)
(*429*)  (*BRANCH NAME*)
} note note375 = this
(* po redu: 1833*)
(*430*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 1834*)
(*431*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO5"]
by auto

(* po redu: 1835*)
(*432*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 1836*)
(*433*)  (*BRANCH NAME*)
} note note376 = this
(* po redu: 1837*)
(*434*)  
(*BRANCH END*)
from note375 and note376 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 1838*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note377 = this
*)
(* po redu: 1839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note374 and note377 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1840*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note378 = this
*)
(* po redu: 1841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note373 and note378 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 1842*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note379 = this
*)
(* po redu: 1843*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note368 and note379 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 1844*)
(*435*)  (*BRANCH NAME*)
} note note380 = this
(* po redu: 1845*)
(*436*)  
(*BRANCH END*)
from note357 and note380 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have ?thesis
by auto
(* po redu: 1846*)
(*437*)  (*BRANCH NAME*)
} note note381 = this
(* po redu: 1847*)
(*438*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI4"
(* po redu: 1848*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

*)
(* po redu: 1849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
*)
(* po redu: 1850*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 1851*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 1852*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 1853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 1854*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1855*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1856*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1857*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1858*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note382 = this
*)
(* po redu: 1859*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1860*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 1861*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 1862*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note383 = this
*)
(* po redu: 1863*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note382 and note383 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1864*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note384 = this
*)
(* po redu: 1865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 1866*)
(*439*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1867*)
(*440*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1868*)
(*441*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 1869*)
(*442*)  (*BRANCH NAME*)
} note note385 = this
(* po redu: 1870*)
(*443*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1871*)
(*444*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1872*)
(*445*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1873*)
(*446*)  (*BRANCH NAME*)
} note note386 = this
(* po redu: 1874*)
(*447*)  
(*BRANCH END*)
from note385 and note386 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1875*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note387 = this
*)
(* po redu: 1876*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note384 and note387 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 1877*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note388 = this
*)
(* po redu: 1878*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 1879*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 1880*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 1881*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1882*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1883*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 1884*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 1885*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note389 = this
*)
(* po redu: 1886*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1887*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 1888*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 1889*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note390 = this
*)
(* po redu: 1890*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note389 and note390 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1891*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note391 = this
*)
(* po redu: 1892*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 1893*)
(*448*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 1894*)
(*449*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 1895*)
(*450*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 1896*)
(*451*)  (*BRANCH NAME*)
} note note392 = this
(* po redu: 1897*)
(*452*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 1898*)
(*453*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 1899*)
(*454*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 1900*)
(*455*)  (*BRANCH NAME*)
} note note393 = this
(* po redu: 1901*)
(*456*)  
(*BRANCH END*)
from note392 and note393 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 1902*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note394 = this
*)
(* po redu: 1903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note391 and note394 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 1904*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note395 = this
*)
(* po redu: 1905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note388 and note395 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 1906*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note396 = this
*)
(* po redu: 1907*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
*)
(* po redu: 1908*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 1909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 1910*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 1911*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 1912*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1913*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1914*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1915*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1916*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1917*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note397 = this
*)
(* po redu: 1918*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1919*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 1920*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 1921*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note398 = this
*)
(* po redu: 1922*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note397 and note398 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1923*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note399 = this
*)
(* po redu: 1924*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 1925*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1926*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1927*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1928*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1929*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1930*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note400 = this
*)
(* po redu: 1931*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1932*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 1933*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 1934*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note401 = this
*)
(* po redu: 1935*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note400 and note401 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1936*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note402 = this
*)
(* po redu: 1937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note399 and note402 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 1938*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note403 = this
*)
(* po redu: 1939*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 1940*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 1941*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 1942*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1943*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1944*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1945*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1946*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1947*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note404 = this
*)
(* po redu: 1948*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1949*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 1950*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 1951*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note405 = this
*)
(* po redu: 1952*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note404 and note405 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1953*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note406 = this
*)
(* po redu: 1954*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 1955*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 1956*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 1957*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1959*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1960*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note407 = this
*)
(* po redu: 1961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 1962*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 1963*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 1964*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note408 = this
*)
(* po redu: 1965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note407 and note408 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 1966*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note409 = this
*)
(* po redu: 1967*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note406 and note409 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 1968*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note410 = this
*)
(* po redu: 1969*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note403 and note410 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 1970*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note411 = this
*)
(* po redu: 1971*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note396 and note411 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have False
by auto
*)
(* po redu: 1972*)
(*457*)  (*BRANCH NAME*)
} note note412 = this
(* po redu: 1973*)
(*458*)  
(*BRANCH END*)
from note381 and note412 and `int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4`
have ?thesis
by auto
(* po redu: 1974*)
(*459*)  (*BRANCH NAME*)
} note note413 = this
(* po redu: 1975*)
(*460*)  
(*BRANCH END*)
from note318 and note413 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have ?thesis
by auto
(* po redu: 1976*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note414 = this
*)
(* po redu: 1977*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note317 and note414 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 1978*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note415 = this
*)
(* po redu: 1979*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note316 and note415 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 1980*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note416 = this
*)
(* po redu: 1981*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note315 and note416 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 1982*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note417 = this
*)
(* po redu: 1983*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note314 and note417 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 1984*)
(*461*)  (*BRANCH NAME*)
} note note418 = this
(* po redu: 1985*)
(*462*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 1986*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 1987*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 1988*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 1989*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 1990*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 1991*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 1992*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 1993*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note419 = this
*)
(* po redu: 1994*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 1995*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 1996*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 1997*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 1998*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 1999*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note420 = this
*)
(* po redu: 2000*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 2001*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

*)
(* po redu: 2002*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 2003*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note421 = this
*)
(* po redu: 2004*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note420 and note421 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 2005*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note422 = this
*)
(* po redu: 2006*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note419 and note422 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2007*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note423 = this
*)
(* po redu: 2008*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 2009*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2010*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2011*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2012*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2013*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2014*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note424 = this
*)
(* po redu: 2015*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2016*)
(*463*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2017*)
(*464*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2018*)
(*465*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 2019*)
(*466*)  (*BRANCH NAME*)
} note note425 = this
(* po redu: 2020*)
(*467*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2021*)
(*468*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO5"]
by auto

(* po redu: 2022*)
(*469*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 2023*)
(*470*)  (*BRANCH NAME*)
} note note426 = this
(* po redu: 2024*)
(*471*)  
(*BRANCH END*)
from note425 and note426 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 2025*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note427 = this
*)
(* po redu: 2026*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note424 and note427 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2027*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note428 = this
*)
(* po redu: 2028*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note423 and note428 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 2029*)
(*472*)  (*BRANCH NAME*)
} note note429 = this
(* po redu: 2030*)
(*473*)  
(*BRANCH END*)
from note418 and note429 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 2031*)
(*474*)  (*BRANCH NAME*)
} note note430 = this
(* po redu: 2032*)
(*475*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 2033*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 2034*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 2035*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 2036*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 2037*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2038*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2039*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2040*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2041*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note431 = this
*)
(* po redu: 2042*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2043*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 2044*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 2045*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note432 = this
*)
(* po redu: 2046*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note431 and note432 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2047*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note433 = this
*)
(* po redu: 2048*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 2049*)
(*476*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2050*)
(*477*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2051*)
(*478*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO5 LI1` and `inc_po_l PO5 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 2052*)
(*479*)  (*BRANCH NAME*)
} note note434 = this
(* po redu: 2053*)
(*480*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2054*)
(*481*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2055*)
(*482*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2056*)
(*483*)  (*BRANCH NAME*)
} note note435 = this
(* po redu: 2057*)
(*484*)  
(*BRANCH END*)
from note434 and note435 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2058*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note436 = this
*)
(* po redu: 2059*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note433 and note436 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 2060*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note437 = this
*)
(* po redu: 2061*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 2062*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 2063*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 2064*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2065*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2066*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2067*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2068*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2069*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note438 = this
*)
(* po redu: 2070*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2071*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 2072*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 2073*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note439 = this
*)
(* po redu: 2074*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note438 and note439 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2075*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note440 = this
*)
(* po redu: 2076*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 2077*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2078*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2079*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2080*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2081*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2082*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note441 = this
*)
(* po redu: 2083*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2084*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 2085*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 2086*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note442 = this
*)
(* po redu: 2087*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note441 and note442 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2088*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note443 = this
*)
(* po redu: 2089*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note440 and note443 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 2090*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note444 = this
*)
(* po redu: 2091*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note437 and note444 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 2092*)
(*485*)  (*BRANCH NAME*)
} note note445 = this
(* po redu: 2093*)
(*486*)  
(*BRANCH END*)
from note430 and note445 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 2094*)
(*487*)  (*BRANCH NAME*)
} note note446 = this
(* po redu: 2095*)
(*488*)  
(*BRANCH END*)
from note305 and note446 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
(* po redu: 2096*)
(*489*)  (*BRANCH NAME*)
} note note447 = this
(* po redu: 2097*)
(*490*)  
(*BRANCH END*)
from note304 and note447 and `PO3 = PO5 \<or> PO3 ~= PO5`
have ?thesis
by auto
(* po redu: 2098*)
(*491*)  (*BRANCH NAME*)
} note note448 = this
(* po redu: 2099*)
(*492*)  
(*BRANCH END*)
from note303 and note448 and `PO2 = PO5 \<or> PO2 ~= PO5`
have ?thesis
by auto
(* po redu: 2100*)
(*493*)  (*BRANCH NAME*)
} note note449 = this
(* po redu: 2101*)
(*494*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 2102*)
(*495*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO4 PO2"
using ax_D1a [of "PO1" "PO4" "LI2" "PO2"]
by auto

(* po redu: 2103*)
(*496*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO4 PO3"
using ax_D1a [of "PO1" "PO4" "LI2" "PO3"]
by auto

(* po redu: 2104*)
(*497*)  (*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(* po redu: 2105*)
(*498*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
(* po redu: 2106*)
(*499*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO4`
have False
by auto

(* po redu: 2107*)
(*500*)  (*BRANCH NAME*)
} note note450 = this
(* po redu: 2108*)
(*501*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
(* po redu: 2109*)
(*502*)  (*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(* po redu: 2110*)
(*503*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
(* po redu: 2111*)
(*504*)  (*EQCONTRADICTION*)
moreover
from `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO4`
have False
by auto

(* po redu: 2112*)
(*505*)  (*BRANCH NAME*)
} note note451 = this
(* po redu: 2113*)
(*506*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
(* po redu: 2114*)
(*507*)  (*REGULAR*)
moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(* po redu: 2115*)
(*508*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO4 LI1"
(* po redu: 2116*)
(*509*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

(* po redu: 2117*)
(*510*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 2118*)
(*511*)  (*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

(* po redu: 2119*)
(*512*)  (*BRANCH NAME*)
} note note452 = this
(* po redu: 2120*)
(*513*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(* po redu: 2121*)
(*514*)  (*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO4 LI1`
have  "\<not>col PO2 PO3 PO4"
using ax_D1a [of "PO2" "PO3" "LI1" "PO4"]
by auto

(* po redu: 2122*)
(*515*)  (*REGULAR*)
moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(* po redu: 2123*)
(*516*)  (*REGULAR*)
moreover
from `PO3 ~= PO4`
obtain  LI4::line
where "inc_po_l PO3 LI4" and "inc_po_l PO4 LI4"
using ax_I1 [of "PO3" "PO4"]
by auto

(* po redu: 2124*)
(*517*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 2125*)
(*518*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO1" "PO2" "PO4"]
by auto

(* po redu: 2126*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 2127*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO4`
obtain  PL2::plane
where "inc_po_pl PO1 PL2" and "inc_po_pl PO3 PL2" and "inc_po_pl PO4 PL2"
using ax_I4a [of "PO1" "PO3" "PO4"]
by auto

*)
(* po redu: 2128*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO4`
obtain  PL3::plane
where "inc_po_pl PO2 PL3" and "inc_po_pl PO3 PL3" and "inc_po_pl PO4 PL3"
using ax_I4a [of "PO2" "PO3" "PO4"]
by auto

*)
(* po redu: 2129*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 2130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO4 PO5"
using ax_D1 [of "PO1" "LI2" "PO4" "PO5"]
by auto

*)
(* po redu: 2131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 2132*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO4 PO5"
using ax_D1 [of "PO4" "LI2" "PO4" "PO5"]
by auto

*)
(* po redu: 2133*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO4 PO5 PO5"
using ax_D1 [of "PO4" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 2134*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 2135*)
(*519*)  (*REGULAR*)
moreover
from `PO4 ~= PO5` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO4 PO5 PO2"
using ax_D1a [of "PO4" "PO5" "LI2" "PO2"]
by auto

(* po redu: 2136*)
(*520*)  (*REGULAR*)
moreover
from `PO4 ~= PO5` and `inc_po_l PO4 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO4 PO5 PO3"
using ax_D1a [of "PO4" "PO5" "LI2" "PO3"]
by auto

(* po redu: 2137*)
(*521*)  (*REGULAR*)
moreover

have  "PO1 = PO5 \<or> PO1 ~= PO5"
using ax_g1 [of "PO1" "PO5"]
by auto

(* po redu: 2138*)
(*522*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO5"
(* po redu: 2139*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 2140*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO4 PO4"
using ax_D1 [of "PO2" "LI3" "PO4" "PO4"]
by auto

*)
(* po redu: 2141*)
(*523*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 2142*)
(*524*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 2143*)
(*525*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 2144*)
(*526*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 2145*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 2146*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 2147*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2148*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2149*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2151*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note453 = this
*)
(* po redu: 2152*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2153*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 2154*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 2155*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2156*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2157*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note454 = this
*)
(* po redu: 2158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 2159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 2160*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 2161*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 2162*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 2163*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 2164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note455 = this
*)
(* po redu: 2165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 2166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

*)
(* po redu: 2167*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
*)
(* po redu: 2168*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI3" "PO3" "PO4"]
by auto

*)
(* po redu: 2169*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

*)
(* po redu: 2170*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note456 = this
*)
(* po redu: 2171*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
*)
(* po redu: 2172*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 2173*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 2174*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note457 = this
*)
(* po redu: 2175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note456 and note457 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have False
by auto
*)
(* po redu: 2176*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note458 = this
*)
(* po redu: 2177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note455 and note458 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 2178*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note459 = this
*)
(* po redu: 2179*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note454 and note459 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 2180*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note460 = this
*)
(* po redu: 2181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note453 and note460 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2182*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note461 = this
*)
(* po redu: 2183*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 2184*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2185*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2186*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2187*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2188*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note462 = this
*)
(* po redu: 2189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2190*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 2191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 2192*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2193*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2194*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note463 = this
*)
(* po redu: 2195*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 2196*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 2197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 2198*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 2199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 2200*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 2201*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note464 = this
*)
(* po redu: 2202*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 2203*)
(*527*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 2204*)
(*528*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 2205*)
(*529*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI3" "PO3" "PO4"]
by auto

(* po redu: 2206*)
(*530*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2207*)
(*531*)  (*BRANCH NAME*)
} note note465 = this
(* po redu: 2208*)
(*532*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 2209*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO3 PO3 PO4"
using ax_D1 [of "PO3" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4` and `inc_po_l PO4 LI4`
have  "col PO3 PO4 PO4"
using ax_D1 [of "PO3" "LI4" "PO4" "PO4"]
by auto

*)
(* po redu: 2211*)
(*533*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4"
using ax_D6a [of "LI1" "LI4"]
by auto

(* po redu: 2212*)
(*534*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI4"
(* po redu: 2213*)
(*535*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 2214*)
(*536*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 2215*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 2216*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 2217*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2218*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2219*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2220*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2221*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2222*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2223*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note466 = this
*)
(* po redu: 2224*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2225*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 2226*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 2227*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2228*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2229*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note467 = this
*)
(* po redu: 2230*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 2231*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 2232*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 2233*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 2234*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note468 = this
*)
(* po redu: 2235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 2236*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

*)
(* po redu: 2237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
*)
(* po redu: 2238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2239*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 2240*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 2241*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note469 = this
*)
(* po redu: 2242*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
*)
(* po redu: 2243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

*)
(* po redu: 2244*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
*)
(* po redu: 2245*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2246*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

*)
(* po redu: 2247*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note470 = this
*)
(* po redu: 2248*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
*)
(* po redu: 2249*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI4 LI4`
obtain  PO6::point
where "inc_po_l PO6 LI4" and "inc_po_l PO6 LI4" and "LI4 ~= LI4"
using ax_D6 [of "LI4" "LI4"]
by auto

*)
(* po redu: 2250*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI4 ~= LI4`
have False
by auto

*)
(* po redu: 2251*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note471 = this
*)
(* po redu: 2252*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note470 and note471 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have False
by auto
*)
(* po redu: 2253*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note472 = this
*)
(* po redu: 2254*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note469 and note472 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have False
by auto
*)
(* po redu: 2255*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note473 = this
*)
(* po redu: 2256*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note468 and note473 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 2257*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note474 = this
*)
(* po redu: 2258*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note467 and note474 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 2259*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note475 = this
*)
(* po redu: 2260*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note466 and note475 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2261*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note476 = this
*)
(* po redu: 2262*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2263*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2264*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2265*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2266*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2267*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note477 = this
*)
(* po redu: 2268*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2269*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 2270*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 2271*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2273*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note478 = this
*)
(* po redu: 2274*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 2275*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 2276*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 2277*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 2278*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note479 = this
*)
(* po redu: 2279*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 2280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

*)
(* po redu: 2281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
*)
(* po redu: 2282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2283*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 2284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 2285*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note480 = this
*)
(* po redu: 2286*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
*)
(* po redu: 2287*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

*)
(* po redu: 2288*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
*)
(* po redu: 2289*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2290*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

*)
(* po redu: 2291*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note481 = this
*)
(* po redu: 2292*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
*)
(* po redu: 2293*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 2294*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 2295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 2296*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 2297*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

*)
(* po redu: 2298*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 2299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 2300*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 2301*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 2302*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 2303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 2304*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 2305*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 2306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 2307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 2308*)
(*537*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 2309*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

*)
(* po redu: 2310*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 2311*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 2312*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 2313*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

*)
(* po redu: 2314*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 2315*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 2316*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO4"]
by auto

*)
(* po redu: 2317*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 2318*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 2319*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 2320*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 2321*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 2322*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO4"]
by auto

*)
(* po redu: 2323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 2324*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 2325*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 2326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 2327*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 2328*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 2329*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 2330*)
(*538*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO5`
have "PO4 ~= PO1"
by auto

(* po redu: 2331*)
(*539*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 2332*)
(*540*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 2333*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note482 = this
*)
(* po redu: 2334*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note481 and note482 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have ?thesis
by auto
*)
(* po redu: 2335*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note483 = this
*)
(* po redu: 2336*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note480 and note483 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have ?thesis
by auto
*)
(* po redu: 2337*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note484 = this
*)
(* po redu: 2338*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note479 and note484 and `LI3 = LI4 \<or> LI3 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 2339*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note485 = this
*)
(* po redu: 2340*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note478 and note485 and `LI2 = LI4 \<or> LI2 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 2341*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note486 = this
*)
(* po redu: 2342*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note477 and note486 and `LI1 = LI4 \<or> LI1 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 2343*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note487 = this
*)
(* po redu: 2344*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note476 and note487 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have ?thesis
by auto
*)
(* po redu: 2345*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note488 = this
*)
(* po redu: 2346*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 2347*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2348*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2349*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2350*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2351*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2352*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2353*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note489 = this
*)
(* po redu: 2354*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 2356*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 2357*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2358*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2359*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note490 = this
*)
(* po redu: 2360*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 2361*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 2362*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 2363*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 2364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note491 = this
*)
(* po redu: 2365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 2366*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO4"]
by auto

*)
(* po redu: 2367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

*)
(* po redu: 2368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note492 = this
*)
(* po redu: 2369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note491 and note492 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 2370*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note493 = this
*)
(* po redu: 2371*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note490 and note493 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 2372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note494 = this
*)
(* po redu: 2373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note489 and note494 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2374*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note495 = this
*)
(* po redu: 2375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2376*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2378*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2379*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2380*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note496 = this
*)
(* po redu: 2381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2382*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 2383*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 2384*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2385*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2386*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note497 = this
*)
(* po redu: 2387*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 2388*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 2389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 2390*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 2391*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note498 = this
*)
(* po redu: 2392*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 2393*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO4"]
by auto

*)
(* po redu: 2394*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

*)
(* po redu: 2395*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note499 = this
*)
(* po redu: 2396*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note498 and note499 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 2397*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note500 = this
*)
(* po redu: 2398*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note497 and note500 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 2399*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note501 = this
*)
(* po redu: 2400*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note496 and note501 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2401*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note502 = this
*)
(* po redu: 2402*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note495 and note502 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 2403*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note503 = this
*)
(* po redu: 2404*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note488 and note503 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have ?thesis
by auto
*)
(* po redu: 2405*)
(*541*)  (*BRANCH NAME*)
} note note504 = this
(* po redu: 2406*)
(*542*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 2407*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 2408*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 2409*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2410*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2411*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2412*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2413*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2414*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note505 = this
*)
(* po redu: 2417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 2419*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 2420*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2421*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2422*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note506 = this
*)
(* po redu: 2423*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 2424*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

*)
(* po redu: 2425*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

*)
(* po redu: 2426*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note507 = this
*)
(* po redu: 2427*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note506 and note507 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 2428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note508 = this
*)
(* po redu: 2429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note505 and note508 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2430*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note509 = this
*)
(* po redu: 2431*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2432*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2434*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2435*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2436*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2437*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note510 = this
*)
(* po redu: 2438*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2439*)
(*543*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2440*)
(*544*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2441*)
(*545*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 2442*)
(*546*)  (*BRANCH NAME*)
} note note511 = this
(* po redu: 2443*)
(*547*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2444*)
(*548*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 2445*)
(*549*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 2446*)
(*550*)  (*BRANCH NAME*)
} note note512 = this
(* po redu: 2447*)
(*551*)  
(*BRANCH END*)
from note511 and note512 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note513 = this
*)
(* po redu: 2449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note510 and note513 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2450*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note514 = this
*)
(* po redu: 2451*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note509 and note514 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 2452*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note515 = this
*)
(* po redu: 2453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 2454*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2455*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2456*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2458*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2460*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2461*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note516 = this
*)
(* po redu: 2462*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 2464*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 2465*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2466*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2467*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note517 = this
*)
(* po redu: 2468*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 2469*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

*)
(* po redu: 2470*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

*)
(* po redu: 2471*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note518 = this
*)
(* po redu: 2472*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note517 and note518 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 2473*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note519 = this
*)
(* po redu: 2474*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note516 and note519 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2475*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note520 = this
*)
(* po redu: 2476*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2477*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2478*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2479*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2480*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2481*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2482*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note521 = this
*)
(* po redu: 2483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2484*)
(*552*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 2485*)
(*553*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 2486*)
(*554*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 2487*)
(*555*)  (*BRANCH NAME*)
} note note522 = this
(* po redu: 2488*)
(*556*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 2489*)
(*557*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 2490*)
(*558*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 2491*)
(*559*)  (*BRANCH NAME*)
} note note523 = this
(* po redu: 2492*)
(*560*)  
(*BRANCH END*)
from note522 and note523 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 2493*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note524 = this
*)
(* po redu: 2494*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note521 and note524 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2495*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note525 = this
*)
(* po redu: 2496*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note520 and note525 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 2497*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note526 = this
*)
(* po redu: 2498*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note515 and note526 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 2499*)
(*561*)  (*BRANCH NAME*)
} note note527 = this
(* po redu: 2500*)
(*562*)  
(*BRANCH END*)
from note504 and note527 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have ?thesis
by auto
(* po redu: 2501*)
(*563*)  (*BRANCH NAME*)
} note note528 = this
(* po redu: 2502*)
(*564*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI4"
(* po redu: 2503*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

*)
(* po redu: 2504*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
*)
(* po redu: 2505*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 2506*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 2507*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2508*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2509*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2510*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2511*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2512*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2513*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note529 = this
*)
(* po redu: 2514*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2515*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 2516*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 2517*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note530 = this
*)
(* po redu: 2518*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note529 and note530 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2519*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note531 = this
*)
(* po redu: 2520*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2521*)
(*565*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2522*)
(*566*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2523*)
(*567*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 2524*)
(*568*)  (*BRANCH NAME*)
} note note532 = this
(* po redu: 2525*)
(*569*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2526*)
(*570*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2527*)
(*571*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2528*)
(*572*)  (*BRANCH NAME*)
} note note533 = this
(* po redu: 2529*)
(*573*)  
(*BRANCH END*)
from note532 and note533 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2530*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note534 = this
*)
(* po redu: 2531*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note531 and note534 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 2532*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note535 = this
*)
(* po redu: 2533*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 2534*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2535*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2536*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2538*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2539*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2540*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note536 = this
*)
(* po redu: 2541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2542*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 2543*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 2544*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note537 = this
*)
(* po redu: 2545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note536 and note537 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2546*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note538 = this
*)
(* po redu: 2547*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2548*)
(*574*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 2549*)
(*575*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 2550*)
(*576*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 2551*)
(*577*)  (*BRANCH NAME*)
} note note539 = this
(* po redu: 2552*)
(*578*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 2553*)
(*579*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 2554*)
(*580*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 2555*)
(*581*)  (*BRANCH NAME*)
} note note540 = this
(* po redu: 2556*)
(*582*)  
(*BRANCH END*)
from note539 and note540 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 2557*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note541 = this
*)
(* po redu: 2558*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note538 and note541 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 2559*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note542 = this
*)
(* po redu: 2560*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note535 and note542 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 2561*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note543 = this
*)
(* po redu: 2562*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
*)
(* po redu: 2563*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 2564*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 2565*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2566*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2567*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2568*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2569*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2571*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2572*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note544 = this
*)
(* po redu: 2573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2574*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 2575*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 2576*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note545 = this
*)
(* po redu: 2577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note544 and note545 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2578*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note546 = this
*)
(* po redu: 2579*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2580*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2582*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2583*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2585*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note547 = this
*)
(* po redu: 2586*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2587*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 2588*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 2589*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note548 = this
*)
(* po redu: 2590*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note547 and note548 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2591*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note549 = this
*)
(* po redu: 2592*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note546 and note549 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 2593*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note550 = this
*)
(* po redu: 2594*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 2595*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2596*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2597*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2598*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2599*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2600*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2601*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2602*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note551 = this
*)
(* po redu: 2603*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2604*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 2605*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 2606*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note552 = this
*)
(* po redu: 2607*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note551 and note552 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note553 = this
*)
(* po redu: 2609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2610*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2611*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2612*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2613*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2615*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note554 = this
*)
(* po redu: 2616*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2617*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 2618*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 2619*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note555 = this
*)
(* po redu: 2620*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note554 and note555 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2621*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note556 = this
*)
(* po redu: 2622*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note553 and note556 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 2623*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note557 = this
*)
(* po redu: 2624*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note550 and note557 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 2625*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note558 = this
*)
(* po redu: 2626*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note543 and note558 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have False
by auto
*)
(* po redu: 2627*)
(*583*)  (*BRANCH NAME*)
} note note559 = this
(* po redu: 2628*)
(*584*)  
(*BRANCH END*)
from note528 and note559 and `int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4`
have ?thesis
by auto
(* po redu: 2629*)
(*585*)  (*BRANCH NAME*)
} note note560 = this
(* po redu: 2630*)
(*586*)  
(*BRANCH END*)
from note465 and note560 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have ?thesis
by auto
(* po redu: 2631*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note561 = this
*)
(* po redu: 2632*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note464 and note561 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 2633*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note562 = this
*)
(* po redu: 2634*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note463 and note562 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 2635*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note563 = this
*)
(* po redu: 2636*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note462 and note563 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 2637*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note564 = this
*)
(* po redu: 2638*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note461 and note564 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 2639*)
(*587*)  (*BRANCH NAME*)
} note note565 = this
(* po redu: 2640*)
(*588*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 2641*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 2642*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 2643*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2644*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2645*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2647*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2648*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note566 = this
*)
(* po redu: 2649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2650*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 2651*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 2652*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2653*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2654*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note567 = this
*)
(* po redu: 2655*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 2656*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

*)
(* po redu: 2657*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 2658*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note568 = this
*)
(* po redu: 2659*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note567 and note568 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 2660*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note569 = this
*)
(* po redu: 2661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note566 and note569 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2662*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note570 = this
*)
(* po redu: 2663*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 2664*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2666*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2667*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2668*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2669*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note571 = this
*)
(* po redu: 2670*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2671*)
(*589*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 2672*)
(*590*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 2673*)
(*591*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 2674*)
(*592*)  (*BRANCH NAME*)
} note note572 = this
(* po redu: 2675*)
(*593*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 2676*)
(*594*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 2677*)
(*595*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 2678*)
(*596*)  (*BRANCH NAME*)
} note note573 = this
(* po redu: 2679*)
(*597*)  
(*BRANCH END*)
from note572 and note573 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 2680*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note574 = this
*)
(* po redu: 2681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note571 and note574 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2682*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note575 = this
*)
(* po redu: 2683*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note570 and note575 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 2684*)
(*598*)  (*BRANCH NAME*)
} note note576 = this
(* po redu: 2685*)
(*599*)  
(*BRANCH END*)
from note565 and note576 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 2686*)
(*600*)  (*BRANCH NAME*)
} note note577 = this
(* po redu: 2687*)
(*601*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 2688*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 2689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 2690*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 2691*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 2692*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2694*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2695*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2696*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note578 = this
*)
(* po redu: 2697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2698*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 2699*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 2700*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note579 = this
*)
(* po redu: 2701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note578 and note579 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2702*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note580 = this
*)
(* po redu: 2703*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 2704*)
(*602*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 2705*)
(*603*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 2706*)
(*604*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 2707*)
(*605*)  (*BRANCH NAME*)
} note note581 = this
(* po redu: 2708*)
(*606*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 2709*)
(*607*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 2710*)
(*608*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 2711*)
(*609*)  (*BRANCH NAME*)
} note note582 = this
(* po redu: 2712*)
(*610*)  
(*BRANCH END*)
from note581 and note582 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 2713*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note583 = this
*)
(* po redu: 2714*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note580 and note583 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 2715*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note584 = this
*)
(* po redu: 2716*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 2717*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 2718*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 2719*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2720*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2721*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2722*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2723*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2724*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note585 = this
*)
(* po redu: 2725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2726*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 2727*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 2728*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note586 = this
*)
(* po redu: 2729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note585 and note586 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2730*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note587 = this
*)
(* po redu: 2731*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 2732*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2734*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 2735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 2736*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 2737*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note588 = this
*)
(* po redu: 2738*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 2740*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 2741*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note589 = this
*)
(* po redu: 2742*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note588 and note589 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2743*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note590 = this
*)
(* po redu: 2744*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note587 and note590 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 2745*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note591 = this
*)
(* po redu: 2746*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note584 and note591 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 2747*)
(*611*)  (*BRANCH NAME*)
} note note592 = this
(* po redu: 2748*)
(*612*)  
(*BRANCH END*)
from note577 and note592 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 2749*)
(*613*)  (*BRANCH NAME*)
} note note593 = this
(* po redu: 2750*)
(*614*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO5"
(* po redu: 2751*)
(*615*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 2752*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

*)
(* po redu: 2753*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO5 \<or> PO2 ~= PO5"
using ax_g1 [of "PO2" "PO5"]
by auto

*)
(* po redu: 2754*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO5"
*)
(* po redu: 2755*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2` and `PO2 = PO5`
have False
by auto

*)
(* po redu: 2756*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note594 = this
*)
(* po redu: 2757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO5"
*)
(* po redu: 2758*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO3 = PO5 \<or> PO3 ~= PO5"
using ax_g1 [of "PO3" "PO5"]
by auto

*)
(* po redu: 2759*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO5"
*)
(* po redu: 2760*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2` and `PO3 = PO5`
have False
by auto

*)
(* po redu: 2761*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note595 = this
*)
(* po redu: 2762*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO5"
*)
(* po redu: 2763*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1"
using ax_g4 [of "PO5" "LI1"]
by auto

*)
(* po redu: 2764*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI1"
*)
(* po redu: 2765*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO5 LI1`
have  "col PO1 PO2 PO5"
using ax_D1 [of "PO1" "LI1" "PO2" "PO5"]
by auto

*)
(* po redu: 2766*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 2767*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO5` and `\<not>col PO1 PO2 PO5`
have False
by auto

*)
(* po redu: 2768*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note596 = this
*)
(* po redu: 2769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI1"
*)
(* po redu: 2770*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `\<not>inc_po_l PO5 LI1`
have  "\<not>col PO2 PO3 PO5"
using ax_D1a [of "PO2" "PO3" "LI1" "PO5"]
by auto

*)
(* po redu: 2771*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO2 ~= PO5`
obtain  LI5::line
where "inc_po_l PO2 LI5" and "inc_po_l PO5 LI5"
using ax_I1 [of "PO2" "PO5"]
by auto

*)
(* po redu: 2772*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO3 ~= PO5`
obtain  LI6::line
where "inc_po_l PO3 LI6" and "inc_po_l PO5 LI6"
using ax_I1 [of "PO3" "PO5"]
by auto

*)
(* po redu: 2773*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 2774*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5`
obtain  PL4::plane
where "inc_po_pl PO1 PL4" and "inc_po_pl PO2 PL4" and "inc_po_pl PO5 PL4"
using ax_I4a [of "PO1" "PO2" "PO5"]
by auto

*)
(* po redu: 2775*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

*)
(* po redu: 2776*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5`
obtain  PL5::plane
where "inc_po_pl PO1 PL5" and "inc_po_pl PO3 PL5" and "inc_po_pl PO5 PL5"
using ax_I4a [of "PO1" "PO3" "PO5"]
by auto

*)
(* po redu: 2777*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO2 PO3 PO5`
obtain  PL6::plane
where "inc_po_pl PO2 PL6" and "inc_po_pl PO3 PL6" and "inc_po_pl PO5 PL6"
using ax_I4a [of "PO2" "PO3" "PO5"]
by auto

*)
(* po redu: 2778*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

*)
(* po redu: 2779*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO2 PO4 PO5`
obtain  PL7::plane
where "inc_po_pl PO2 PL7" and "inc_po_pl PO4 PL7" and "inc_po_pl PO5 PL7"
using ax_I4a [of "PO2" "PO4" "PO5"]
by auto

*)
(* po redu: 2780*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

*)
(* po redu: 2781*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO3 PO4 PO5`
obtain  PL8::plane
where "inc_po_pl PO3 PL8" and "inc_po_pl PO4 PL8" and "inc_po_pl PO5 PL8"
using ax_I4a [of "PO3" "PO4" "PO5"]
by auto

*)
(* po redu: 2782*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 2783*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO4 PO4"
using ax_D1 [of "PO2" "LI3" "PO4" "PO4"]
by auto

*)
(* po redu: 2784*)
(*616*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(* po redu: 2785*)
(*617*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI3"
(* po redu: 2786*)
(*618*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(* po redu: 2787*)
(*619*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
(* po redu: 2788*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 2789*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 2790*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2792*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2793*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2794*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note597 = this
*)
(* po redu: 2795*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2796*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 2797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 2798*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2800*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note598 = this
*)
(* po redu: 2801*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 2802*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 2803*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 2804*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 2805*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 2806*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 2807*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note599 = this
*)
(* po redu: 2808*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 2809*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

*)
(* po redu: 2810*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
*)
(* po redu: 2811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI3" "PO3" "PO4"]
by auto

*)
(* po redu: 2812*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

*)
(* po redu: 2813*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note600 = this
*)
(* po redu: 2814*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
*)
(* po redu: 2815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

*)
(* po redu: 2816*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
*)
(* po redu: 2817*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 2818*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO4 PO5"
using ax_D1 [of "PO2" "LI3" "PO4" "PO5"]
by auto

*)
(* po redu: 2819*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

*)
(* po redu: 2820*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO4 PO5` and `\<not>col PO2 PO4 PO5`
have False
by auto

*)
(* po redu: 2821*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note601 = this
*)
(* po redu: 2822*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
*)
(* po redu: 2823*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI3`
obtain  PO6::point
where "inc_po_l PO6 LI3" and "inc_po_l PO6 LI3" and "LI3 ~= LI3"
using ax_D6 [of "LI3" "LI3"]
by auto

*)
(* po redu: 2824*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI3`
have False
by auto

*)
(* po redu: 2825*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note602 = this
*)
(* po redu: 2826*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note601 and note602 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have False
by auto
*)
(* po redu: 2827*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note603 = this
*)
(* po redu: 2828*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note600 and note603 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have False
by auto
*)
(* po redu: 2829*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note604 = this
*)
(* po redu: 2830*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note599 and note604 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have False
by auto
*)
(* po redu: 2831*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note605 = this
*)
(* po redu: 2832*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note598 and note605 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 2833*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note606 = this
*)
(* po redu: 2834*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note597 and note606 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 2835*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note607 = this
*)
(* po redu: 2836*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 2837*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 2838*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 2839*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2840*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2841*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note608 = this
*)
(* po redu: 2842*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 2843*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 2844*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 2845*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2846*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2847*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note609 = this
*)
(* po redu: 2848*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 2849*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

*)
(* po redu: 2850*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI3"
*)
(* po redu: 2851*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI3" "PO2" "PO4"]
by auto

*)
(* po redu: 2852*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 2853*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO4` and `\<not>col PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 2854*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note610 = this
*)
(* po redu: 2855*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI3"
*)
(* po redu: 2856*)
(*620*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3"
using ax_g4 [of "PO3" "LI3"]
by auto

(* po redu: 2857*)
(*621*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI3"
(* po redu: 2858*)
(*622*)  (*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO4 LI3`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI3" "PO3" "PO4"]
by auto

(* po redu: 2859*)
(*623*)  (*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(* po redu: 2860*)
(*624*)  (*BRANCH NAME*)
} note note611 = this
(* po redu: 2861*)
(*625*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI3"
(* po redu: 2862*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3"
using ax_g4 [of "PO5" "LI3"]
by auto

*)
(* po redu: 2863*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI3"
*)
(* po redu: 2864*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO2 PO5"
using ax_D1 [of "PO2" "LI3" "PO2" "PO5"]
by auto

*)
(* po redu: 2865*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO4 LI3` and `inc_po_l PO5 LI3`
have  "col PO2 PO4 PO5"
using ax_D1 [of "PO2" "LI3" "PO4" "PO5"]
by auto

*)
(* po redu: 2866*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO2`
have  "\<not>col PO2 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO2"]
by auto

*)
(* po redu: 2867*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO4 PO5` and `\<not>col PO2 PO4 PO5`
have False
by auto

*)
(* po redu: 2868*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note612 = this
*)
(* po redu: 2869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI3"
*)
(* po redu: 2870*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO3 PO3 PO4"
using ax_D1 [of "PO3" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2871*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4` and `inc_po_l PO4 LI4`
have  "col PO3 PO4 PO4"
using ax_D1 [of "PO3" "LI4" "PO4" "PO4"]
by auto

*)
(* po redu: 2872*)
(*626*)  (*REGULAR*)
moreover

have  "int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4"
using ax_D6a [of "LI1" "LI4"]
by auto

(* po redu: 2873*)
(*627*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI4"
(* po redu: 2874*)
(*628*)  (*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

(* po redu: 2875*)
(*629*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
(* po redu: 2876*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 2877*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 2878*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 2879*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 2880*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2881*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2882*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2883*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2884*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note613 = this
*)
(* po redu: 2885*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2886*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 2887*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 2888*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2889*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2890*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note614 = this
*)
(* po redu: 2891*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 2892*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 2893*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 2894*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 2895*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note615 = this
*)
(* po redu: 2896*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 2897*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

*)
(* po redu: 2898*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
*)
(* po redu: 2899*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2900*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 2901*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 2902*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note616 = this
*)
(* po redu: 2903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
*)
(* po redu: 2904*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

*)
(* po redu: 2905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
*)
(* po redu: 2906*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2907*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

*)
(* po redu: 2908*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note617 = this
*)
(* po redu: 2909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
*)
(* po redu: 2910*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI4 \<or> \<not>inc_po_l PO5 LI4"
using ax_g4 [of "PO5" "LI4"]
by auto

*)
(* po redu: 2911*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI4"
*)
(* po redu: 2912*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI4" "PO3" "PO5"]
by auto

*)
(* po redu: 2913*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO4 PO5"
using ax_D1 [of "PO3" "LI4" "PO4" "PO5"]
by auto

*)
(* po redu: 2914*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

*)
(* po redu: 2915*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO3 PO4 PO5` and `\<not>col PO3 PO4 PO5`
have False
by auto

*)
(* po redu: 2916*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note618 = this
*)
(* po redu: 2917*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI4"
*)
(* po redu: 2918*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI4 LI4`
obtain  PO6::point
where "inc_po_l PO6 LI4" and "inc_po_l PO6 LI4" and "LI4 ~= LI4"
using ax_D6 [of "LI4" "LI4"]
by auto

*)
(* po redu: 2919*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI4 ~= LI4`
have False
by auto

*)
(* po redu: 2920*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note619 = this
*)
(* po redu: 2921*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note618 and note619 and `inc_po_l PO5 LI4 \<or> \<not>inc_po_l PO5 LI4`
have False
by auto
*)
(* po redu: 2922*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note620 = this
*)
(* po redu: 2923*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note617 and note620 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have False
by auto
*)
(* po redu: 2924*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note621 = this
*)
(* po redu: 2925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note616 and note621 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have False
by auto
*)
(* po redu: 2926*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note622 = this
*)
(* po redu: 2927*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note615 and note622 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 2928*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note623 = this
*)
(* po redu: 2929*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note614 and note623 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 2930*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note624 = this
*)
(* po redu: 2931*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note613 and note624 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 2932*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note625 = this
*)
(* po redu: 2933*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 2934*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 2935*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 2936*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 2937*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 2938*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note626 = this
*)
(* po redu: 2939*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 2940*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 2941*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 2942*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 2943*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 2944*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note627 = this
*)
(* po redu: 2945*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 2946*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 2947*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 2948*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 2949*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note628 = this
*)
(* po redu: 2950*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 2951*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4"
using ax_g4 [of "PO1" "LI4"]
by auto

*)
(* po redu: 2952*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO1 LI4"
*)
(* po redu: 2953*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2954*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

*)
(* po redu: 2955*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO3 PO4` and `\<not>col PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 2956*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note629 = this
*)
(* po redu: 2957*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO1 LI4"
*)
(* po redu: 2958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4"
using ax_g4 [of "PO2" "LI4"]
by auto

*)
(* po redu: 2959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI4"
*)
(* po redu: 2960*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI4" "PO3" "PO4"]
by auto

*)
(* po redu: 2961*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

*)
(* po redu: 2962*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note630 = this
*)
(* po redu: 2963*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI4"
*)
(* po redu: 2964*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO5 LI4 \<or> \<not>inc_po_l PO5 LI4"
using ax_g4 [of "PO5" "LI4"]
by auto

*)
(* po redu: 2965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO5 LI4"
*)
(* po redu: 2966*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO3 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO3 PO5"
using ax_D1 [of "PO3" "LI4" "PO3" "PO5"]
by auto

*)
(* po redu: 2967*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI4` and `inc_po_l PO4 LI4` and `inc_po_l PO5 LI4`
have  "col PO3 PO4 PO5"
using ax_D1 [of "PO3" "LI4" "PO4" "PO5"]
by auto

*)
(* po redu: 2968*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO4 PO5 PO3`
have  "\<not>col PO3 PO4 PO5"
using ax_ncol_231 [of "PO4" "PO5" "PO3"]
by auto

*)
(* po redu: 2969*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO3 PO4 PO5` and `\<not>col PO3 PO4 PO5`
have False
by auto

*)
(* po redu: 2970*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note631 = this
*)
(* po redu: 2971*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO5 LI4"
*)
(* po redu: 2972*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 2973*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 2974*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 2975*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 2976*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

*)
(* po redu: 2977*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 2978*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 2979*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 2980*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 2981*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 2982*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 2983*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 2984*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 2985*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 2986*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 2987*)
(*630*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `PO1 ~= PO2` and `inc_po_l PO2 LI1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "inc_l_pl LI1 PL1"
using ax_I6 [of "PO1" "LI1" "PO2" "PL1"]
by auto

(* po redu: 2988*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

*)
(* po redu: 2989*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 2990*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 2991*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 2992*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

*)
(* po redu: 2993*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 2994*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 2995*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO4"]
by auto

*)
(* po redu: 2996*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 2997*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 2998*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 2999*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 3000*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 3001*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO4"]
by auto

*)
(* po redu: 3002*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 3003*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 3004*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 3005*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 3006*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 3007*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 3008*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 3009*)
(*631*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `PO1 ~= PO4` and `inc_po_l PO4 LI2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "inc_l_pl LI2 PL1"
using ax_I6 [of "PO1" "LI2" "PO4" "PL1"]
by auto

(* po redu: 3010*)
(*632*)  
(*BRANCH END THESIS*)
moreover 
from `inc_l_pl LI1 PL1` and `inc_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 3011*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note632 = this
*)
(* po redu: 3012*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note631 and note632 and `inc_po_l PO5 LI4 \<or> \<not>inc_po_l PO5 LI4`
have ?thesis
by auto
*)
(* po redu: 3013*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note633 = this
*)
(* po redu: 3014*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note630 and note633 and `inc_po_l PO2 LI4 \<or> \<not>inc_po_l PO2 LI4`
have ?thesis
by auto
*)
(* po redu: 3015*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note634 = this
*)
(* po redu: 3016*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note629 and note634 and `inc_po_l PO1 LI4 \<or> \<not>inc_po_l PO1 LI4`
have ?thesis
by auto
*)
(* po redu: 3017*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note635 = this
*)
(* po redu: 3018*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note628 and note635 and `LI3 = LI4 \<or> LI3 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 3019*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note636 = this
*)
(* po redu: 3020*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note627 and note636 and `LI2 = LI4 \<or> LI2 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 3021*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note637 = this
*)
(* po redu: 3022*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note626 and note637 and `LI1 = LI4 \<or> LI1 ~= LI4`
have ?thesis
by auto
*)
(* po redu: 3023*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note638 = this
*)
(* po redu: 3024*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note625 and note638 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have ?thesis
by auto
*)
(* po redu: 3025*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note639 = this
*)
(* po redu: 3026*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 3027*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 3028*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 3029*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3030*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3031*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 3032*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 3033*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note640 = this
*)
(* po redu: 3034*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3035*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 3036*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 3037*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 3038*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 3039*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note641 = this
*)
(* po redu: 3040*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 3041*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 3042*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 3043*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 3044*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note642 = this
*)
(* po redu: 3045*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 3046*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO4"]
by auto

*)
(* po redu: 3047*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

*)
(* po redu: 3048*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note643 = this
*)
(* po redu: 3049*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note642 and note643 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 3050*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note644 = this
*)
(* po redu: 3051*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note641 and note644 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 3052*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note645 = this
*)
(* po redu: 3053*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note640 and note645 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3054*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note646 = this
*)
(* po redu: 3055*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 3056*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3057*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3058*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI1 LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 3059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 3060*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note647 = this
*)
(* po redu: 3061*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3062*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 3063*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 3064*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI2 LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 3065*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 3066*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note648 = this
*)
(* po redu: 3067*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 3068*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI3 = LI4 \<or> LI3 ~= LI4"
using ax_g2 [of "LI3" "LI4"]
by auto

*)
(* po redu: 3069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 = LI4"
*)
(* po redu: 3070*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_l PO3 LI4` and `\<not>inc_po_l PO3 LI3` and `LI3 = LI4`
have False
by auto

*)
(* po redu: 3071*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note649 = this
*)
(* po redu: 3072*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI3 ~= LI4"
*)
(* po redu: 3073*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI3 ~= LI4` and `inc_po_l PO4 LI3` and `inc_po_l PO4 LI4`
have  "int_l_l LI3 LI4"
using ax_D5 [of "LI3" "LI4" "PO4"]
by auto

*)
(* po redu: 3074*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI3 LI4` and `\<not>int_l_l LI3 LI4`
have False
by auto

*)
(* po redu: 3075*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note650 = this
*)
(* po redu: 3076*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note649 and note650 and `LI3 = LI4 \<or> LI3 ~= LI4`
have False
by auto
*)
(* po redu: 3077*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note651 = this
*)
(* po redu: 3078*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note648 and note651 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 3079*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note652 = this
*)
(* po redu: 3080*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note647 and note652 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3081*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note653 = this
*)
(* po redu: 3082*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note646 and note653 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 3083*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note654 = this
*)
(* po redu: 3084*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note639 and note654 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have ?thesis
by auto
*)
(* po redu: 3085*)
(*633*)  (*BRANCH NAME*)
} note note655 = this
(* po redu: 3086*)
(*634*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
(* po redu: 3087*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 3088*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 3089*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 3090*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 3091*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3092*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3093*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3094*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3095*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3096*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note656 = this
*)
(* po redu: 3097*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3098*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 3099*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 3100*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 3101*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 3102*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note657 = this
*)
(* po redu: 3103*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 3104*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

*)
(* po redu: 3105*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

*)
(* po redu: 3106*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note658 = this
*)
(* po redu: 3107*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note657 and note658 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 3108*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note659 = this
*)
(* po redu: 3109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note656 and note659 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3110*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note660 = this
*)
(* po redu: 3111*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 3112*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3114*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3115*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3116*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3117*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note661 = this
*)
(* po redu: 3118*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3119*)
(*635*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 3120*)
(*636*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 3121*)
(*637*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 3122*)
(*638*)  (*BRANCH NAME*)
} note note662 = this
(* po redu: 3123*)
(*639*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 3124*)
(*640*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 3125*)
(*641*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 3126*)
(*642*)  (*BRANCH NAME*)
} note note663 = this
(* po redu: 3127*)
(*643*)  
(*BRANCH END*)
from note662 and note663 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 3128*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note664 = this
*)
(* po redu: 3129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note661 and note664 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3130*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note665 = this
*)
(* po redu: 3131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note660 and note665 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 3132*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note666 = this
*)
(* po redu: 3133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 3134*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 3135*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 3136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3138*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3139*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3140*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3141*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note667 = this
*)
(* po redu: 3142*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3143*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

*)
(* po redu: 3144*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
*)
(* po redu: 3145*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI2 = LI4` and `LI2 = LI4`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 3146*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 3147*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note668 = this
*)
(* po redu: 3148*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
*)
(* po redu: 3149*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

*)
(* po redu: 3150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

*)
(* po redu: 3151*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note669 = this
*)
(* po redu: 3152*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note668 and note669 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
*)
(* po redu: 3153*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note670 = this
*)
(* po redu: 3154*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note667 and note670 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3155*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note671 = this
*)
(* po redu: 3156*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 3157*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3159*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3161*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3162*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note672 = this
*)
(* po redu: 3163*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3164*)
(*644*)  (*REGULAR*)
moreover

have  "LI2 = LI4 \<or> LI2 ~= LI4"
using ax_g2 [of "LI2" "LI4"]
by auto

(* po redu: 3165*)
(*645*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI4"
(* po redu: 3166*)
(*646*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO3 LI2` and `inc_po_l PO3 LI4` and `LI2 = LI4`
have False
by auto

(* po redu: 3167*)
(*647*)  (*BRANCH NAME*)
} note note673 = this
(* po redu: 3168*)
(*648*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI4"
(* po redu: 3169*)
(*649*)  (*REGULAR*)
moreover
from `LI2 ~= LI4` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI4`
have  "int_l_l LI2 LI4"
using ax_D5 [of "LI2" "LI4" "PO4"]
by auto

(* po redu: 3170*)
(*650*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI4` and `\<not>int_l_l LI2 LI4`
have False
by auto

(* po redu: 3171*)
(*651*)  (*BRANCH NAME*)
} note note674 = this
(* po redu: 3172*)
(*652*)  
(*BRANCH END*)
from note673 and note674 and `LI2 = LI4 \<or> LI2 ~= LI4`
have False
by auto
(* po redu: 3173*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note675 = this
*)
(* po redu: 3174*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note672 and note675 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3175*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note676 = this
*)
(* po redu: 3176*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note671 and note676 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 3177*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note677 = this
*)
(* po redu: 3178*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note666 and note677 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 3179*)
(*653*)  (*BRANCH NAME*)
} note note678 = this
(* po redu: 3180*)
(*654*)  
(*BRANCH END*)
from note655 and note678 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have ?thesis
by auto
(* po redu: 3181*)
(*655*)  (*BRANCH NAME*)
} note note679 = this
(* po redu: 3182*)
(*656*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI4"
(* po redu: 3183*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4"
using ax_D6a [of "LI2" "LI4"]
by auto

*)
(* po redu: 3184*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI4"
*)
(* po redu: 3185*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 3186*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 3187*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 3188*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 3189*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3190*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3191*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 3192*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 3193*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note680 = this
*)
(* po redu: 3194*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 3196*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 3197*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note681 = this
*)
(* po redu: 3198*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note680 and note681 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3199*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note682 = this
*)
(* po redu: 3200*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 3201*)
(*657*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3202*)
(*658*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3203*)
(*659*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 3204*)
(*660*)  (*BRANCH NAME*)
} note note683 = this
(* po redu: 3205*)
(*661*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3206*)
(*662*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3207*)
(*663*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3208*)
(*664*)  (*BRANCH NAME*)
} note note684 = this
(* po redu: 3209*)
(*665*)  
(*BRANCH END*)
from note683 and note684 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3210*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note685 = this
*)
(* po redu: 3211*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note682 and note685 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 3212*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note686 = this
*)
(* po redu: 3213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 3214*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 3215*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 3216*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3217*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3218*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI4 LI4` and `LI1 = LI4` and `LI1 = LI4`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 3219*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 3220*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note687 = this
*)
(* po redu: 3221*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3222*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 3223*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 3224*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note688 = this
*)
(* po redu: 3225*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note687 and note688 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3226*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note689 = this
*)
(* po redu: 3227*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 3228*)
(*666*)  (*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

(* po redu: 3229*)
(*667*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
(* po redu: 3230*)
(*668*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI4` and `LI1 = LI4`
have False
by auto

(* po redu: 3231*)
(*669*)  (*BRANCH NAME*)
} note note690 = this
(* po redu: 3232*)
(*670*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
(* po redu: 3233*)
(*671*)  (*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

(* po redu: 3234*)
(*672*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

(* po redu: 3235*)
(*673*)  (*BRANCH NAME*)
} note note691 = this
(* po redu: 3236*)
(*674*)  
(*BRANCH END*)
from note690 and note691 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
(* po redu: 3237*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note692 = this
*)
(* po redu: 3238*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note689 and note692 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 3239*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note693 = this
*)
(* po redu: 3240*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note686 and note693 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 3241*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note694 = this
*)
(* po redu: 3242*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI4"
*)
(* po redu: 3243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4"
using ax_D6a [of "LI3" "LI4"]
by auto

*)
(* po redu: 3244*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI4"
*)
(* po redu: 3245*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 3246*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 3247*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3248*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3249*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3250*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3251*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3252*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note695 = this
*)
(* po redu: 3253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3254*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 3255*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 3256*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note696 = this
*)
(* po redu: 3257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note695 and note696 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3258*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note697 = this
*)
(* po redu: 3259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 3260*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3262*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3263*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3264*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3265*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note698 = this
*)
(* po redu: 3266*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 3268*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 3269*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note699 = this
*)
(* po redu: 3270*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note698 and note699 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3271*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note700 = this
*)
(* po redu: 3272*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note697 and note700 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 3273*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note701 = this
*)
(* po redu: 3274*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI4"
*)
(* po redu: 3275*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4"
using ax_D6a [of "LI4" "LI4"]
by auto

*)
(* po redu: 3276*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI4 LI4"
*)
(* po redu: 3277*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3278*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3279*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3281*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3282*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note702 = this
*)
(* po redu: 3283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 3285*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 3286*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note703 = this
*)
(* po redu: 3287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note702 and note703 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3288*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note704 = this
*)
(* po redu: 3289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI4 LI4"
*)
(* po redu: 3290*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI4 \<or> LI1 ~= LI4"
using ax_g2 [of "LI1" "LI4"]
by auto

*)
(* po redu: 3291*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI4"
*)
(* po redu: 3292*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI4` and `LI1 = LI4`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3293*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3294*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3295*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note705 = this
*)
(* po redu: 3296*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI4"
*)
(* po redu: 3297*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI4` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI4`
have  "int_l_l LI1 LI4"
using ax_D5 [of "LI1" "LI4" "PO3"]
by auto

*)
(* po redu: 3298*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI4` and `\<not>int_l_l LI1 LI4`
have False
by auto

*)
(* po redu: 3299*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note706 = this
*)
(* po redu: 3300*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note705 and note706 and `LI1 = LI4 \<or> LI1 ~= LI4`
have False
by auto
*)
(* po redu: 3301*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note707 = this
*)
(* po redu: 3302*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note704 and note707 and `int_l_l LI4 LI4 \<or> \<not>int_l_l LI4 LI4`
have False
by auto
*)
(* po redu: 3303*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note708 = this
*)
(* po redu: 3304*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note701 and note708 and `int_l_l LI3 LI4 \<or> \<not>int_l_l LI3 LI4`
have False
by auto
*)
(* po redu: 3305*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note709 = this
*)
(* po redu: 3306*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note694 and note709 and `int_l_l LI2 LI4 \<or> \<not>int_l_l LI2 LI4`
have False
by auto
*)
(* po redu: 3307*)
(*675*)  (*BRANCH NAME*)
} note note710 = this
(* po redu: 3308*)
(*676*)  
(*BRANCH END*)
from note679 and note710 and `int_l_l LI1 LI4 \<or> \<not>int_l_l LI1 LI4`
have ?thesis
by auto
(* po redu: 3309*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note711 = this
*)
(* po redu: 3310*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note612 and note711 and `inc_po_l PO5 LI3 \<or> \<not>inc_po_l PO5 LI3`
have ?thesis
by auto
*)
(* po redu: 3311*)
(*677*)  (*BRANCH NAME*)
} note note712 = this
(* po redu: 3312*)
(*678*)  
(*BRANCH END*)
from note611 and note712 and `inc_po_l PO3 LI3 \<or> \<not>inc_po_l PO3 LI3`
have ?thesis
by auto
(* po redu: 3313*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note713 = this
*)
(* po redu: 3314*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note610 and note713 and `inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
*)
(* po redu: 3315*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note714 = this
*)
(* po redu: 3316*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note609 and note714 and `LI2 = LI3 \<or> LI2 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 3317*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note715 = this
*)
(* po redu: 3318*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note608 and note715 and `LI1 = LI3 \<or> LI1 ~= LI3`
have ?thesis
by auto
*)
(* po redu: 3319*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note716 = this
*)
(* po redu: 3320*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note607 and note716 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have ?thesis
by auto
*)
(* po redu: 3321*)
(*679*)  (*BRANCH NAME*)
} note note717 = this
(* po redu: 3322*)
(*680*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
(* po redu: 3323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 3324*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 3325*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 3326*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 3327*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3328*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3329*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3330*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note718 = this
*)
(* po redu: 3331*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 3332*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

*)
(* po redu: 3333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
*)
(* po redu: 3334*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI2 = LI3` and `LI2 = LI3`
have "int_l_l LI2 LI2"
by auto

*)
(* po redu: 3335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI2` and `int_l_l LI2 LI2`
have False
by auto

*)
(* po redu: 3336*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note719 = this
*)
(* po redu: 3337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
*)
(* po redu: 3338*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

*)
(* po redu: 3339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

*)
(* po redu: 3340*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note720 = this
*)
(* po redu: 3341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note719 and note720 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
*)
(* po redu: 3342*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note721 = this
*)
(* po redu: 3343*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note718 and note721 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 3344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note722 = this
*)
(* po redu: 3345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 3346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 3347*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 3348*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3349*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3350*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3351*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note723 = this
*)
(* po redu: 3352*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 3353*)
(*681*)  (*REGULAR*)
moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(* po redu: 3354*)
(*682*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 = LI3"
(* po redu: 3355*)
(*683*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO2 LI2` and `inc_po_l PO2 LI3` and `LI2 = LI3`
have False
by auto

(* po redu: 3356*)
(*684*)  (*BRANCH NAME*)
} note note724 = this
(* po redu: 3357*)
(*685*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI2 ~= LI3"
(* po redu: 3358*)
(*686*)  (*REGULAR*)
moreover
from `LI2 ~= LI3` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO4"]
by auto

(* po redu: 3359*)
(*687*)  (*REGULAR*)
moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(* po redu: 3360*)
(*688*)  (*BRANCH NAME*)
} note note725 = this
(* po redu: 3361*)
(*689*)  
(*BRANCH END*)
from note724 and note725 and `LI2 = LI3 \<or> LI2 ~= LI3`
have False
by auto
(* po redu: 3362*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note726 = this
*)
(* po redu: 3363*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note723 and note726 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 3364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note727 = this
*)
(* po redu: 3365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note722 and note727 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 3366*)
(*690*)  (*BRANCH NAME*)
} note note728 = this
(* po redu: 3367*)
(*691*)  
(*BRANCH END*)
from note717 and note728 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(* po redu: 3368*)
(*692*)  (*BRANCH NAME*)
} note note729 = this
(* po redu: 3369*)
(*693*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI3"
(* po redu: 3370*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

*)
(* po redu: 3371*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI3"
*)
(* po redu: 3372*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 3373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 3374*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 3375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 3376*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_l LI3 LI3` and `LI1 = LI3` and `LI1 = LI3`
have "int_l_l LI1 LI1"
by auto

*)
(* po redu: 3377*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI1 LI1` and `int_l_l LI1 LI1`
have False
by auto

*)
(* po redu: 3378*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note730 = this
*)
(* po redu: 3379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 3380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 3381*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 3382*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note731 = this
*)
(* po redu: 3383*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note730 and note731 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 3384*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note732 = this
*)
(* po redu: 3385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 3386*)
(*694*)  (*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(* po redu: 3387*)
(*695*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
(* po redu: 3388*)
(*696*)  (*EQCONTRADICTION*)
moreover
from `\<not>inc_po_l PO4 LI1` and `inc_po_l PO4 LI3` and `LI1 = LI3`
have False
by auto

(* po redu: 3389*)
(*697*)  (*BRANCH NAME*)
} note note733 = this
(* po redu: 3390*)
(*698*)  
(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
(* po redu: 3391*)
(*699*)  (*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(* po redu: 3392*)
(*700*)  (*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(* po redu: 3393*)
(*701*)  (*BRANCH NAME*)
} note note734 = this
(* po redu: 3394*)
(*702*)  
(*BRANCH END*)
from note733 and note734 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
(* po redu: 3395*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note735 = this
*)
(* po redu: 3396*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note732 and note735 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 3397*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note736 = this
*)
(* po redu: 3398*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI3"
*)
(* po redu: 3399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

*)
(* po redu: 3400*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI3 LI3"
*)
(* po redu: 3401*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 3402*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 3403*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3404*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3405*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3406*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note737 = this
*)
(* po redu: 3407*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 3408*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 3409*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 3410*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note738 = this
*)
(* po redu: 3411*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note737 and note738 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 3412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note739 = this
*)
(* po redu: 3413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI3 LI3"
*)
(* po redu: 3414*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

*)
(* po redu: 3415*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 = LI3"
*)
(* po redu: 3416*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_l LI2 LI3` and `LI1 = LI3`
have "\<not>int_l_l LI2 LI1"
by auto

*)
(* po redu: 3417*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_l_l LI2 LI1`
have  "\<not>int_l_l LI1 LI2"
using ax_nint_l_l_21 [of "LI2" "LI1"]
by auto

*)
(* po redu: 3418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

*)
(* po redu: 3419*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note740 = this
*)
(* po redu: 3420*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "LI1 ~= LI3"
*)
(* po redu: 3421*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

*)
(* po redu: 3422*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

*)
(* po redu: 3423*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note741 = this
*)
(* po redu: 3424*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note740 and note741 and `LI1 = LI3 \<or> LI1 ~= LI3`
have False
by auto
*)
(* po redu: 3425*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note742 = this
*)
(* po redu: 3426*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note739 and note742 and `int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3`
have False
by auto
*)
(* po redu: 3427*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note743 = this
*)
(* po redu: 3428*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note736 and note743 and `int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3`
have False
by auto
*)
(* po redu: 3429*)
(*703*)  (*BRANCH NAME*)
} note note744 = this
(* po redu: 3430*)
(*704*)  
(*BRANCH END*)
from note729 and note744 and `int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(* po redu: 3431*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note745 = this
*)
(* po redu: 3432*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note596 and note745 and `inc_po_l PO5 LI1 \<or> \<not>inc_po_l PO5 LI1`
have ?thesis
by auto
*)
(* po redu: 3433*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note746 = this
*)
(* po redu: 3434*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note595 and note746 and `PO3 = PO5 \<or> PO3 ~= PO5`
have ?thesis
by auto
*)
(* po redu: 3435*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note747 = this
*)
(* po redu: 3436*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note594 and note747 and `PO2 = PO5 \<or> PO2 ~= PO5`
have ?thesis
by auto
*)
(* po redu: 3437*)
(*705*)  (*BRANCH NAME*)
} note note748 = this
(* po redu: 3438*)
(*706*)  
(*BRANCH END*)
from note593 and note748 and `PO1 = PO5 \<or> PO1 ~= PO5`
have ?thesis
by auto
(* po redu: 3439*)
(*707*)  (*BRANCH NAME*)
} note note749 = this
(* po redu: 3440*)
(*708*)  
(*BRANCH END*)
from note452 and note749 and `inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(* po redu: 3441*)
(*709*)  (*BRANCH NAME*)
} note note750 = this
(* po redu: 3442*)
(*710*)  
(*BRANCH END*)
from note451 and note750 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
(* po redu: 3443*)
(*711*)  (*BRANCH NAME*)
} note note751 = this
(* po redu: 3444*)
(*712*)  
(*BRANCH END*)
from note450 and note751 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
(* po redu: 3445*)
(*713*)  (*BRANCH NAME*)
} note note752 = this
(* po redu: 3446*)
(*714*)  
(*BRANCH END*)
from note449 and note752 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
(* po redu: 3447*)
(*715*)  (*BRANCH NAME*)
} note note753 = this
(* po redu: 3448*)
(*716*)  
(*BRANCH END*)
from note302 and note753 and `inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2`
have ?thesis
by auto
(* po redu: 3449*)
(*717*)  (*BRANCH NAME*)
} note note754 = this
(* po redu: 3450*)
(*718*)  
(*BRANCH END*)
from note301 and note754 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
(* po redu: 3451*)
(*719*)  (*BRANCH NAME*)
} note note755 = this
(* po redu: 3452*)
(*720*)  
(*BRANCH END*)
from note154 and note755 and `inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2`
have ?thesis
by auto
(* po redu: 3453*)
(*721*)  (*BRANCH NAME*)
} note note756 = this
(* po redu: 3454*)
(*722*)  
(*BRANCH END*)
from note153 and note756 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
(* po redu: 3455*)
(*723*)  (*BRANCH NAME*)
} note note757 = this
(* po redu: 3456*)
(*724*)  
(*BRANCH END*)
from note4 and note757 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have ?thesis
by auto
(* po redu: 3457*)
(*725*)  (*BRANCH NAME*)
} note note758 = this
(* po redu: 3458*)
(*726*)  
(*BRANCH END*)
from note3 and note758 and `int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
