theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma th24:
assumes "LI1 ~= LI2"
and "inc_po_l PO1 LI1"
and "inc_po_l PO1 LI2"
and "inc_l_pl LI1 PL1"
and "inc_l_pl LI2 PL1"
and "inc_l_pl LI1 PL2"
and "inc_l_pl LI2 PL2"
shows " (PL1 = PL2)"
proof -

(* po redu: 1*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

*)
(* po redu: 2*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `LI1 ~= LI2` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have  "int_l_l LI1 LI2"
using ax_D5 [of "LI1" "LI2" "PO1"]
by auto

*)
(* po redu: 3*)
(*1*)  (*REGULAR*)
from `inc_l_pl LI1 PL1` and `inc_po_l PO1 LI1`
have  "inc_po_pl PO1 PL1"
using ax_D11 [of "LI1" "PL1" "PO1"]
by auto

(* po redu: 4*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 5*)
(*2*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO1 LI1`
have  "inc_po_pl PO1 PL2"
using ax_D11 [of "LI1" "PL2" "PO1"]
by auto

(* po redu: 6*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

*)
(* po redu: 7*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI1 LI1"
*)
(* po redu: 8*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

*)
(* po redu: 9*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
*)
(* po redu: 10*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 11*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 12*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 13*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 14*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 15*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 16*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 17*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 18*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 19*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 20*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 21*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 22*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 23*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 24*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 25*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 26*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1 = this
*)
(* po redu: 27*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 28*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 29*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note2 = this
*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1 and note2 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note3 = this
*)
(* po redu: 33*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 34*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 35*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 36*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 37*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note4 = this
*)
(* po redu: 38*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 39*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 41*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note5 = this
*)
(* po redu: 42*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note4 and note5 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 43*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note6 = this
*)
(* po redu: 44*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note3 and note6 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note7 = this
*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 48*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 49*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 50*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 51*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 52*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note8 = this
*)
(* po redu: 53*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 54*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 55*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 56*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note9 = this
*)
(* po redu: 57*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note8 and note9 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 58*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note10 = this
*)
(* po redu: 59*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 60*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 61*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 62*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note11 = this
*)
(* po redu: 63*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 64*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 65*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 66*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note12 = this
*)
(* po redu: 67*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note11 and note12 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 68*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note13 = this
*)
(* po redu: 69*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note10 and note13 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 70*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note14 = this
*)
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note7 and note14 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note15 = this
*)
(* po redu: 73*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 74*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 75*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 76*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 77*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 78*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note16 = this
*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note17 = this
*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note17 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 87*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note18 = this
*)
(* po redu: 88*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 89*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 92*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note19 = this
*)
(* po redu: 93*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 94*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 95*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note20 = this
*)
(* po redu: 97*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note19 and note20 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 98*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note21 = this
*)
(* po redu: 99*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note18 and note21 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 100*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note22 = this
*)
(* po redu: 101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 102*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 103*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 104*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 106*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 107*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note23 = this
*)
(* po redu: 108*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 109*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 110*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 111*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note24 = this
*)
(* po redu: 112*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note23 and note24 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 113*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note25 = this
*)
(* po redu: 114*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 115*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 116*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 117*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 118*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note26 = this
*)
(* po redu: 119*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 120*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 121*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 122*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note27 = this
*)
(* po redu: 123*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note26 and note27 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note28 = this
*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note25 and note28 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note29 = this
*)
(* po redu: 127*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note22 and note29 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 128*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note30 = this
*)
(* po redu: 129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note15 and note30 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 130*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note31 = this
*)
(* po redu: 131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 132*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 134*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 135*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 138*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 139*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 140*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 141*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note32 = this
*)
(* po redu: 142*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 143*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 144*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 145*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note33 = this
*)
(* po redu: 146*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note32 and note33 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 147*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note34 = this
*)
(* po redu: 148*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 149*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 150*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 151*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 152*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note35 = this
*)
(* po redu: 153*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 154*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 155*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 156*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note36 = this
*)
(* po redu: 157*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note35 and note36 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 158*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note37 = this
*)
(* po redu: 159*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note34 and note37 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 160*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note38 = this
*)
(* po redu: 161*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 162*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 163*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 164*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 166*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 167*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note39 = this
*)
(* po redu: 168*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 169*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 170*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 171*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note40 = this
*)
(* po redu: 172*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note39 and note40 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 173*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note41 = this
*)
(* po redu: 174*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 175*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 176*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 177*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 178*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note42 = this
*)
(* po redu: 179*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 180*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 181*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 182*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note43 = this
*)
(* po redu: 183*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note42 and note43 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 184*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note44 = this
*)
(* po redu: 185*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note41 and note44 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 186*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note45 = this
*)
(* po redu: 187*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note38 and note45 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 188*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note46 = this
*)
(* po redu: 189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 190*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 192*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 194*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 195*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 196*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note47 = this
*)
(* po redu: 197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 198*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note48 = this
*)
(* po redu: 201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note47 and note48 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 202*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note49 = this
*)
(* po redu: 203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 204*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 206*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 207*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note50 = this
*)
(* po redu: 208*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 209*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 211*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note51 = this
*)
(* po redu: 212*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note50 and note51 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 213*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note52 = this
*)
(* po redu: 214*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note49 and note52 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 215*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note53 = this
*)
(* po redu: 216*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 217*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 218*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 219*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 220*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 221*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 222*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note54 = this
*)
(* po redu: 223*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 224*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 225*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 226*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note55 = this
*)
(* po redu: 227*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note54 and note55 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 228*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note56 = this
*)
(* po redu: 229*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 230*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 231*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 232*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note57 = this
*)
(* po redu: 233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 234*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 235*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 236*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note58 = this
*)
(* po redu: 237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note57 and note58 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 238*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note59 = this
*)
(* po redu: 239*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note56 and note59 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 240*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note60 = this
*)
(* po redu: 241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note53 and note60 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 242*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note61 = this
*)
(* po redu: 243*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note46 and note61 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note62 = this
*)
(* po redu: 245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note31 and note62 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 246*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note63 = this
*)
(* po redu: 247*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 248*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 250*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 252*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 254*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 255*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 256*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 258*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 259*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 260*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note64 = this
*)
(* po redu: 261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 262*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 263*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 264*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note65 = this
*)
(* po redu: 265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note64 and note65 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 266*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note66 = this
*)
(* po redu: 267*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 268*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 270*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 271*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 272*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note67 = this
*)
(* po redu: 273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 274*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 275*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 276*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note68 = this
*)
(* po redu: 277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note67 and note68 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 278*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note69 = this
*)
(* po redu: 279*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note66 and note69 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 280*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note70 = this
*)
(* po redu: 281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 286*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 287*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 288*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note71 = this
*)
(* po redu: 289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 290*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 291*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note72 = this
*)
(* po redu: 293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note71 and note72 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 294*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note73 = this
*)
(* po redu: 295*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 296*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 298*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 300*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note74 = this
*)
(* po redu: 301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 302*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note75 = this
*)
(* po redu: 305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note74 and note75 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 306*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note76 = this
*)
(* po redu: 307*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note73 and note76 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note77 = this
*)
(* po redu: 309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note70 and note77 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 310*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note78 = this
*)
(* po redu: 311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 312*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 314*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 315*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 316*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 318*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 319*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 320*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note79 = this
*)
(* po redu: 321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 322*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note80 = this
*)
(* po redu: 325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note79 and note80 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 326*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note81 = this
*)
(* po redu: 327*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 328*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 330*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 331*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 332*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note82 = this
*)
(* po redu: 333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 334*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 336*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note83 = this
*)
(* po redu: 337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note82 and note83 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 338*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note84 = this
*)
(* po redu: 339*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note81 and note84 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 340*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note85 = this
*)
(* po redu: 341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 342*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 343*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 344*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 346*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 347*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 348*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note86 = this
*)
(* po redu: 349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 350*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 352*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note87 = this
*)
(* po redu: 353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note86 and note87 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 354*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note88 = this
*)
(* po redu: 355*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 356*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 358*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 359*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 360*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note89 = this
*)
(* po redu: 361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 362*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note90 = this
*)
(* po redu: 365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note89 and note90 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 366*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note91 = this
*)
(* po redu: 367*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note88 and note91 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note92 = this
*)
(* po redu: 369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note85 and note92 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 370*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note93 = this
*)
(* po redu: 371*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note78 and note93 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note94 = this
*)
(* po redu: 373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 374*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 376*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 378*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 382*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 383*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 384*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note95 = this
*)
(* po redu: 385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 386*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 387*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 388*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note96 = this
*)
(* po redu: 389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note95 and note96 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 390*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note97 = this
*)
(* po redu: 391*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 392*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 394*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 395*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 396*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note98 = this
*)
(* po redu: 397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 400*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note99 = this
*)
(* po redu: 401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note98 and note99 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 402*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note100 = this
*)
(* po redu: 403*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note97 and note100 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 404*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note101 = this
*)
(* po redu: 405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 406*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 407*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 408*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 410*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 411*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note102 = this
*)
(* po redu: 413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 414*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note103 = this
*)
(* po redu: 417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note102 and note103 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 418*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note104 = this
*)
(* po redu: 419*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 420*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 422*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 423*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 424*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note105 = this
*)
(* po redu: 425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 426*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 427*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note106 = this
*)
(* po redu: 429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note105 and note106 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 430*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note107 = this
*)
(* po redu: 431*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note104 and note107 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 432*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note108 = this
*)
(* po redu: 433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note101 and note108 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 434*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note109 = this
*)
(* po redu: 435*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 436*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 438*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 439*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 440*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 442*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 443*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 444*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note110 = this
*)
(* po redu: 445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 446*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note111 = this
*)
(* po redu: 449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note110 and note111 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 450*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note112 = this
*)
(* po redu: 451*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 452*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 454*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 455*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 456*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note113 = this
*)
(* po redu: 457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 458*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 460*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note114 = this
*)
(* po redu: 461*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note113 and note114 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 462*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note115 = this
*)
(* po redu: 463*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note112 and note115 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 464*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note116 = this
*)
(* po redu: 465*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 466*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 467*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 468*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 470*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 471*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 472*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note117 = this
*)
(* po redu: 473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 474*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 475*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note118 = this
*)
(* po redu: 477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note117 and note118 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 478*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note119 = this
*)
(* po redu: 479*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 480*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 482*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 483*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 484*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note120 = this
*)
(* po redu: 485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 486*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 487*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 488*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note121 = this
*)
(* po redu: 489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note120 and note121 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 490*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note122 = this
*)
(* po redu: 491*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note119 and note122 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 492*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note123 = this
*)
(* po redu: 493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note116 and note123 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 494*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note124 = this
*)
(* po redu: 495*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note109 and note124 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note125 = this
*)
(* po redu: 497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note94 and note125 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 498*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note126 = this
*)
(* po redu: 499*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note63 and note126 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 500*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note127 = this
*)
(* po redu: 501*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 502*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 503*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 504*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 506*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 507*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 508*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 510*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 511*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 512*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 514*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 515*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 516*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note128 = this
*)
(* po redu: 517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 518*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 519*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 520*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note129 = this
*)
(* po redu: 521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note128 and note129 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 522*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note130 = this
*)
(* po redu: 523*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 524*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 525*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 526*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 527*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 528*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note131 = this
*)
(* po redu: 529*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 530*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 531*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 532*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note132 = this
*)
(* po redu: 533*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note131 and note132 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 534*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note133 = this
*)
(* po redu: 535*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note130 and note133 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 536*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note134 = this
*)
(* po redu: 537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 538*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 539*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 542*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 543*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 544*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note135 = this
*)
(* po redu: 545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 546*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 547*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 548*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note136 = this
*)
(* po redu: 549*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note135 and note136 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 550*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note137 = this
*)
(* po redu: 551*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 552*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 553*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 554*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 555*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 556*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note138 = this
*)
(* po redu: 557*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 558*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 559*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 560*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note139 = this
*)
(* po redu: 561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note138 and note139 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 562*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note140 = this
*)
(* po redu: 563*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note137 and note140 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 564*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note141 = this
*)
(* po redu: 565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note134 and note141 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 566*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note142 = this
*)
(* po redu: 567*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 568*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 571*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 572*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 574*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 575*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 576*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note143 = this
*)
(* po redu: 577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 578*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 580*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note144 = this
*)
(* po redu: 581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note143 and note144 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 582*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note145 = this
*)
(* po redu: 583*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 586*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 587*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 588*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note146 = this
*)
(* po redu: 589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 592*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note147 = this
*)
(* po redu: 593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note146 and note147 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 594*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note148 = this
*)
(* po redu: 595*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note145 and note148 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 596*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note149 = this
*)
(* po redu: 597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 598*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 599*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 600*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 602*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 603*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 604*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note150 = this
*)
(* po redu: 605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 606*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note151 = this
*)
(* po redu: 609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note150 and note151 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 610*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note152 = this
*)
(* po redu: 611*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 612*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 614*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 615*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 616*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note153 = this
*)
(* po redu: 617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 618*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 619*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 620*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note154 = this
*)
(* po redu: 621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note153 and note154 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 622*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note155 = this
*)
(* po redu: 623*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note152 and note155 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 624*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note156 = this
*)
(* po redu: 625*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note149 and note156 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 626*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note157 = this
*)
(* po redu: 627*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note142 and note157 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 628*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note158 = this
*)
(* po redu: 629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 630*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 631*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 632*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 635*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 636*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 638*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 639*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 640*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note159 = this
*)
(* po redu: 641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 642*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 643*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 644*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note160 = this
*)
(* po redu: 645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note159 and note160 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 646*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note161 = this
*)
(* po redu: 647*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 648*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 650*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 651*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 652*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note162 = this
*)
(* po redu: 653*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 655*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 656*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note163 = this
*)
(* po redu: 657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note162 and note163 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 658*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note164 = this
*)
(* po redu: 659*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note161 and note164 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 660*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note165 = this
*)
(* po redu: 661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 662*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 663*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 664*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 666*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 667*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 668*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note166 = this
*)
(* po redu: 669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 670*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 671*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 672*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note167 = this
*)
(* po redu: 673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note166 and note167 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 674*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note168 = this
*)
(* po redu: 675*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 676*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 677*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 678*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 679*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 680*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note169 = this
*)
(* po redu: 681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 682*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 683*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 684*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note170 = this
*)
(* po redu: 685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note169 and note170 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 686*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note171 = this
*)
(* po redu: 687*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note168 and note171 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 688*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note172 = this
*)
(* po redu: 689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note165 and note172 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 690*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note173 = this
*)
(* po redu: 691*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 692*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 695*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 696*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 698*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 699*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 700*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note174 = this
*)
(* po redu: 701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 702*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 704*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note175 = this
*)
(* po redu: 705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note174 and note175 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 706*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note176 = this
*)
(* po redu: 707*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 708*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 710*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 711*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 712*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note177 = this
*)
(* po redu: 713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 714*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 715*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 716*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note178 = this
*)
(* po redu: 717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note177 and note178 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 718*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note179 = this
*)
(* po redu: 719*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note176 and note179 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 720*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note180 = this
*)
(* po redu: 721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 722*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 723*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 724*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 726*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 727*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 728*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note181 = this
*)
(* po redu: 729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 730*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 731*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 732*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note182 = this
*)
(* po redu: 733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note181 and note182 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 734*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note183 = this
*)
(* po redu: 735*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 736*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 738*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 740*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note184 = this
*)
(* po redu: 741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 742*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 743*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note185 = this
*)
(* po redu: 745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note184 and note185 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 746*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note186 = this
*)
(* po redu: 747*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note183 and note186 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 748*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note187 = this
*)
(* po redu: 749*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note180 and note187 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 750*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note188 = this
*)
(* po redu: 751*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note173 and note188 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 752*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note189 = this
*)
(* po redu: 753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note158 and note189 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 754*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note190 = this
*)
(* po redu: 755*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 756*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 758*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 759*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 760*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 762*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 763*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 764*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 766*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 767*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 768*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note191 = this
*)
(* po redu: 769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 770*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 771*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 772*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note192 = this
*)
(* po redu: 773*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note191 and note192 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 774*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note193 = this
*)
(* po redu: 775*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 776*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 777*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 778*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 779*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 780*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note194 = this
*)
(* po redu: 781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 782*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 783*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 784*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note195 = this
*)
(* po redu: 785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note194 and note195 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 786*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note196 = this
*)
(* po redu: 787*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note193 and note196 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 788*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note197 = this
*)
(* po redu: 789*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 790*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 792*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 794*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 795*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 796*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note198 = this
*)
(* po redu: 797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 798*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 800*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note199 = this
*)
(* po redu: 801*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note198 and note199 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 802*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note200 = this
*)
(* po redu: 803*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 804*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 805*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 806*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 807*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 808*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note201 = this
*)
(* po redu: 809*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 810*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 812*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note202 = this
*)
(* po redu: 813*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note201 and note202 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 814*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note203 = this
*)
(* po redu: 815*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note200 and note203 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 816*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note204 = this
*)
(* po redu: 817*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note197 and note204 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 818*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note205 = this
*)
(* po redu: 819*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 820*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 822*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 823*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 824*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 825*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 826*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 827*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 828*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note206 = this
*)
(* po redu: 829*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 830*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 831*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 832*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note207 = this
*)
(* po redu: 833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note206 and note207 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 834*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note208 = this
*)
(* po redu: 835*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 836*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 838*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 839*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 840*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note209 = this
*)
(* po redu: 841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 842*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 843*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 844*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note210 = this
*)
(* po redu: 845*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note209 and note210 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 846*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note211 = this
*)
(* po redu: 847*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note208 and note211 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 848*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note212 = this
*)
(* po redu: 849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 850*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 851*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 852*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 854*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 855*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 856*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note213 = this
*)
(* po redu: 857*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 858*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 859*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 860*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note214 = this
*)
(* po redu: 861*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note213 and note214 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 862*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note215 = this
*)
(* po redu: 863*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 864*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 866*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 867*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 868*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note216 = this
*)
(* po redu: 869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 870*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 871*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 872*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note217 = this
*)
(* po redu: 873*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note216 and note217 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 874*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note218 = this
*)
(* po redu: 875*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note215 and note218 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 876*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note219 = this
*)
(* po redu: 877*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note212 and note219 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 878*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note220 = this
*)
(* po redu: 879*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note205 and note220 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 880*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note221 = this
*)
(* po redu: 881*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 882*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 883*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 884*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 885*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 886*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 887*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 888*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 889*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 890*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 891*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 892*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note222 = this
*)
(* po redu: 893*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 894*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 895*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 896*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note223 = this
*)
(* po redu: 897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note222 and note223 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 898*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note224 = this
*)
(* po redu: 899*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 900*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 902*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 903*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 904*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note225 = this
*)
(* po redu: 905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 906*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 907*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 908*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note226 = this
*)
(* po redu: 909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note225 and note226 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 910*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note227 = this
*)
(* po redu: 911*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note224 and note227 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 912*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note228 = this
*)
(* po redu: 913*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 914*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 915*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 916*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 917*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 918*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 919*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 920*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note229 = this
*)
(* po redu: 921*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 922*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 923*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 924*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note230 = this
*)
(* po redu: 925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note229 and note230 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 926*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note231 = this
*)
(* po redu: 927*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 928*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 929*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 930*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 931*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 932*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note232 = this
*)
(* po redu: 933*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 934*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 935*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 936*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note233 = this
*)
(* po redu: 937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note232 and note233 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 938*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note234 = this
*)
(* po redu: 939*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note231 and note234 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 940*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note235 = this
*)
(* po redu: 941*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note228 and note235 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 942*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note236 = this
*)
(* po redu: 943*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 944*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 945*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 946*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 947*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 948*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 949*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 950*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 951*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 952*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note237 = this
*)
(* po redu: 953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 954*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 955*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 956*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note238 = this
*)
(* po redu: 957*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note237 and note238 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 958*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note239 = this
*)
(* po redu: 959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 960*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 962*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 963*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 964*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note240 = this
*)
(* po redu: 965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 966*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 967*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 968*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note241 = this
*)
(* po redu: 969*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note240 and note241 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 970*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note242 = this
*)
(* po redu: 971*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note239 and note242 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 972*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note243 = this
*)
(* po redu: 973*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 974*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 975*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 976*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 977*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 978*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 979*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 980*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note244 = this
*)
(* po redu: 981*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 982*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 983*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 984*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note245 = this
*)
(* po redu: 985*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note244 and note245 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 986*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note246 = this
*)
(* po redu: 987*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 988*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 989*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 990*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 991*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 992*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note247 = this
*)
(* po redu: 993*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 994*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 995*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 996*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note248 = this
*)
(* po redu: 997*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note247 and note248 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 998*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note249 = this
*)
(* po redu: 999*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note246 and note249 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1000*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note250 = this
*)
(* po redu: 1001*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note243 and note250 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1002*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note251 = this
*)
(* po redu: 1003*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note236 and note251 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 1004*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note252 = this
*)
(* po redu: 1005*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note221 and note252 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 1006*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note253 = this
*)
(* po redu: 1007*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note190 and note253 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 1008*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note254 = this
*)
(* po redu: 1009*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note127 and note254 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 1010*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note255 = this
*)
(* po redu: 1011*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 1012*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 1013*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 1014*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 1015*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 1016*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 1017*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 1018*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 1019*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 1020*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1021*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1022*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1024*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1025*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1026*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1027*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1028*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note256 = this
*)
(* po redu: 1029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1030*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1031*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1032*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note257 = this
*)
(* po redu: 1033*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note256 and note257 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1034*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note258 = this
*)
(* po redu: 1035*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1036*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1037*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1038*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1039*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1040*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note259 = this
*)
(* po redu: 1041*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1042*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1043*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1044*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note260 = this
*)
(* po redu: 1045*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note259 and note260 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1046*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note261 = this
*)
(* po redu: 1047*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note258 and note261 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1048*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note262 = this
*)
(* po redu: 1049*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1050*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1051*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1052*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1053*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1054*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1055*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1056*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note263 = this
*)
(* po redu: 1057*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1058*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1060*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note264 = this
*)
(* po redu: 1061*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note263 and note264 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1062*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note265 = this
*)
(* po redu: 1063*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1064*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1065*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1066*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1067*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1068*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note266 = this
*)
(* po redu: 1069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1070*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1071*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1072*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note267 = this
*)
(* po redu: 1073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note266 and note267 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1074*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note268 = this
*)
(* po redu: 1075*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note265 and note268 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1076*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note269 = this
*)
(* po redu: 1077*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note262 and note269 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1078*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note270 = this
*)
(* po redu: 1079*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1080*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1081*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1082*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1083*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1084*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1085*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1086*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1087*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1088*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note271 = this
*)
(* po redu: 1089*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1090*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1091*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1092*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note272 = this
*)
(* po redu: 1093*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note271 and note272 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1094*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note273 = this
*)
(* po redu: 1095*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1096*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1097*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1098*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1099*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1100*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note274 = this
*)
(* po redu: 1101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1102*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1104*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note275 = this
*)
(* po redu: 1105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note274 and note275 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1106*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note276 = this
*)
(* po redu: 1107*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note273 and note276 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1108*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note277 = this
*)
(* po redu: 1109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1110*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1111*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1112*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1114*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1115*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1116*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note278 = this
*)
(* po redu: 1117*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1118*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1119*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1120*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note279 = this
*)
(* po redu: 1121*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note278 and note279 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1122*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note280 = this
*)
(* po redu: 1123*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1124*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1126*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1127*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1128*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note281 = this
*)
(* po redu: 1129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1132*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note282 = this
*)
(* po redu: 1133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note281 and note282 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1134*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note283 = this
*)
(* po redu: 1135*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note280 and note283 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1136*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note284 = this
*)
(* po redu: 1137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note277 and note284 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1138*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note285 = this
*)
(* po redu: 1139*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note270 and note285 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 1140*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note286 = this
*)
(* po redu: 1141*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 1142*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 1143*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 1144*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1146*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1147*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1148*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1149*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1150*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1151*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1152*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note287 = this
*)
(* po redu: 1153*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1154*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1155*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1156*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note288 = this
*)
(* po redu: 1157*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note287 and note288 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1158*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note289 = this
*)
(* po redu: 1159*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1161*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1162*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1163*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note290 = this
*)
(* po redu: 1165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note291 = this
*)
(* po redu: 1169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note290 and note291 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1170*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note292 = this
*)
(* po redu: 1171*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note289 and note292 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1172*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note293 = this
*)
(* po redu: 1173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1174*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1176*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1178*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1179*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1180*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note294 = this
*)
(* po redu: 1181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1182*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1183*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1184*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note295 = this
*)
(* po redu: 1185*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note294 and note295 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1186*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note296 = this
*)
(* po redu: 1187*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1188*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1190*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1191*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1192*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note297 = this
*)
(* po redu: 1193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1194*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1196*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note298 = this
*)
(* po redu: 1197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note297 and note298 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1198*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note299 = this
*)
(* po redu: 1199*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note296 and note299 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note300 = this
*)
(* po redu: 1201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note293 and note300 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1202*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note301 = this
*)
(* po redu: 1203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1204*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1206*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1207*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1210*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1212*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note302 = this
*)
(* po redu: 1213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1214*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1215*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1216*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note303 = this
*)
(* po redu: 1217*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note302 and note303 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1218*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note304 = this
*)
(* po redu: 1219*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1220*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1221*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1222*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1223*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1224*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note305 = this
*)
(* po redu: 1225*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1226*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1228*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note306 = this
*)
(* po redu: 1229*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note305 and note306 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1230*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note307 = this
*)
(* po redu: 1231*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note304 and note307 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1232*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note308 = this
*)
(* po redu: 1233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1234*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1236*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1238*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1239*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1240*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note309 = this
*)
(* po redu: 1241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1242*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note310 = this
*)
(* po redu: 1245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note309 and note310 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1246*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note311 = this
*)
(* po redu: 1247*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1248*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1250*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1251*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1252*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note312 = this
*)
(* po redu: 1253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1254*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1255*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1256*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note313 = this
*)
(* po redu: 1257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note312 and note313 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1258*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note314 = this
*)
(* po redu: 1259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note311 and note314 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1260*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note315 = this
*)
(* po redu: 1261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note308 and note315 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1262*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note316 = this
*)
(* po redu: 1263*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note301 and note316 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 1264*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note317 = this
*)
(* po redu: 1265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note286 and note317 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 1266*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note318 = this
*)
(* po redu: 1267*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 1268*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 1269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 1270*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 1271*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 1272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1274*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1275*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1276*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1278*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1279*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1280*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note319 = this
*)
(* po redu: 1281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1283*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1284*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note320 = this
*)
(* po redu: 1285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note319 and note320 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1286*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note321 = this
*)
(* po redu: 1287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1288*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1290*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1291*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note322 = this
*)
(* po redu: 1293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1294*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1296*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note323 = this
*)
(* po redu: 1297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note322 and note323 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1298*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note324 = this
*)
(* po redu: 1299*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note321 and note324 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1300*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note325 = this
*)
(* po redu: 1301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1302*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1303*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1304*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1306*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note326 = this
*)
(* po redu: 1309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1310*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1311*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1312*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note327 = this
*)
(* po redu: 1313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note326 and note327 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1314*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note328 = this
*)
(* po redu: 1315*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1316*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1318*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1319*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1320*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note329 = this
*)
(* po redu: 1321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1322*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note330 = this
*)
(* po redu: 1325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note329 and note330 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1326*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note331 = this
*)
(* po redu: 1327*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note328 and note331 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1328*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note332 = this
*)
(* po redu: 1329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note325 and note332 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1330*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note333 = this
*)
(* po redu: 1331*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1332*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1334*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1335*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1336*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1338*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1340*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note334 = this
*)
(* po redu: 1341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1342*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1343*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note335 = this
*)
(* po redu: 1345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note334 and note335 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1346*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note336 = this
*)
(* po redu: 1347*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1348*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1350*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1352*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note337 = this
*)
(* po redu: 1353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1354*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1356*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note338 = this
*)
(* po redu: 1357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note337 and note338 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1358*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note339 = this
*)
(* po redu: 1359*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note336 and note339 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1360*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note340 = this
*)
(* po redu: 1361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1362*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1363*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1364*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1366*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note341 = this
*)
(* po redu: 1369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1370*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1371*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note342 = this
*)
(* po redu: 1373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note341 and note342 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1374*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note343 = this
*)
(* po redu: 1375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1376*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1378*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1379*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1380*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note344 = this
*)
(* po redu: 1381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1382*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1383*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1384*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note345 = this
*)
(* po redu: 1385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note344 and note345 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1386*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note346 = this
*)
(* po redu: 1387*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note343 and note346 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1388*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note347 = this
*)
(* po redu: 1389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note340 and note347 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1390*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note348 = this
*)
(* po redu: 1391*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note333 and note348 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 1392*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note349 = this
*)
(* po redu: 1393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 1394*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 1395*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 1396*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1399*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1400*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1402*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1403*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1404*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note350 = this
*)
(* po redu: 1405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1406*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1407*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1408*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note351 = this
*)
(* po redu: 1409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note350 and note351 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1410*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note352 = this
*)
(* po redu: 1411*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1412*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1414*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note353 = this
*)
(* po redu: 1417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1419*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1420*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note354 = this
*)
(* po redu: 1421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note353 and note354 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1422*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note355 = this
*)
(* po redu: 1423*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note352 and note355 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1424*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note356 = this
*)
(* po redu: 1425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1426*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1427*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1428*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1430*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1432*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note357 = this
*)
(* po redu: 1433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1434*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1435*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1436*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note358 = this
*)
(* po redu: 1437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note357 and note358 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1438*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note359 = this
*)
(* po redu: 1439*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1440*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1442*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1443*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1444*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note360 = this
*)
(* po redu: 1445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1446*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note361 = this
*)
(* po redu: 1449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note360 and note361 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1450*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note362 = this
*)
(* po redu: 1451*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note359 and note362 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1452*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note363 = this
*)
(* po redu: 1453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note356 and note363 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1454*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note364 = this
*)
(* po redu: 1455*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1456*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1458*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1459*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1460*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1461*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1462*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1464*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note365 = this
*)
(* po redu: 1465*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1466*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1467*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1468*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note366 = this
*)
(* po redu: 1469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note365 and note366 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1470*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note367 = this
*)
(* po redu: 1471*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1472*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1474*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1475*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note368 = this
*)
(* po redu: 1477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1478*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1479*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1480*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note369 = this
*)
(* po redu: 1481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note368 and note369 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1482*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note370 = this
*)
(* po redu: 1483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note367 and note370 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1484*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note371 = this
*)
(* po redu: 1485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1486*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1487*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1488*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1490*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1491*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1492*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note372 = this
*)
(* po redu: 1493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1494*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note373 = this
*)
(* po redu: 1497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note372 and note373 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1498*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note374 = this
*)
(* po redu: 1499*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1500*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1501*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1502*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1503*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1504*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note375 = this
*)
(* po redu: 1505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1506*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 1507*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 1508*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note376 = this
*)
(* po redu: 1509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note375 and note376 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1510*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note377 = this
*)
(* po redu: 1511*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note374 and note377 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1512*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note378 = this
*)
(* po redu: 1513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note371 and note378 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1514*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note379 = this
*)
(* po redu: 1515*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note364 and note379 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 1516*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note380 = this
*)
(* po redu: 1517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note349 and note380 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 1518*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note381 = this
*)
(* po redu: 1519*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note318 and note381 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 1520*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note382 = this
*)
(* po redu: 1521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 1522*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 1523*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 1524*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 1525*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 1526*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 1527*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 1528*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1529*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1530*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1531*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1532*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1533*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1534*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1535*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1536*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note383 = this
*)
(* po redu: 1537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1538*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1539*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1540*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note384 = this
*)
(* po redu: 1541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note383 and note384 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1542*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note385 = this
*)
(* po redu: 1543*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1544*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1546*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1547*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1548*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note386 = this
*)
(* po redu: 1549*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1550*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1551*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1552*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note387 = this
*)
(* po redu: 1553*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note386 and note387 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1554*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note388 = this
*)
(* po redu: 1555*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note385 and note388 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1556*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note389 = this
*)
(* po redu: 1557*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1558*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1559*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1560*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1562*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1563*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1564*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note390 = this
*)
(* po redu: 1565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1566*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1567*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1568*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note391 = this
*)
(* po redu: 1569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note390 and note391 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1570*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note392 = this
*)
(* po redu: 1571*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1572*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1574*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1575*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1576*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note393 = this
*)
(* po redu: 1577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1578*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1580*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note394 = this
*)
(* po redu: 1581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note393 and note394 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1582*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note395 = this
*)
(* po redu: 1583*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note392 and note395 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1584*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note396 = this
*)
(* po redu: 1585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note389 and note396 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1586*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note397 = this
*)
(* po redu: 1587*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1588*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1591*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1592*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1594*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1595*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1596*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note398 = this
*)
(* po redu: 1597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1598*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1599*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1600*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note399 = this
*)
(* po redu: 1601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note398 and note399 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1602*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note400 = this
*)
(* po redu: 1603*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1604*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1606*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note401 = this
*)
(* po redu: 1609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1610*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note402 = this
*)
(* po redu: 1613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note401 and note402 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1614*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note403 = this
*)
(* po redu: 1615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note400 and note403 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1616*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note404 = this
*)
(* po redu: 1617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1618*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1619*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1620*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1622*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1623*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1624*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note405 = this
*)
(* po redu: 1625*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1626*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1627*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1628*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note406 = this
*)
(* po redu: 1629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note405 and note406 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1630*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note407 = this
*)
(* po redu: 1631*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1632*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1634*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1636*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note408 = this
*)
(* po redu: 1637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1638*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1639*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1640*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note409 = this
*)
(* po redu: 1641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note408 and note409 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1642*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note410 = this
*)
(* po redu: 1643*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note407 and note410 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1644*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note411 = this
*)
(* po redu: 1645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note404 and note411 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1646*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note412 = this
*)
(* po redu: 1647*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note397 and note412 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 1648*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note413 = this
*)
(* po redu: 1649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 1650*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 1651*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 1652*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1653*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1655*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1656*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1658*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1659*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1660*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note414 = this
*)
(* po redu: 1661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1662*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1663*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1664*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note415 = this
*)
(* po redu: 1665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note414 and note415 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1666*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note416 = this
*)
(* po redu: 1667*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1668*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1670*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1671*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1672*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note417 = this
*)
(* po redu: 1673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1675*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1676*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note418 = this
*)
(* po redu: 1677*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note417 and note418 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1678*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note419 = this
*)
(* po redu: 1679*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note416 and note419 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1680*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note420 = this
*)
(* po redu: 1681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1682*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1683*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1684*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1686*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1687*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1688*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note421 = this
*)
(* po redu: 1689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1690*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1691*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1692*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note422 = this
*)
(* po redu: 1693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note421 and note422 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1694*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note423 = this
*)
(* po redu: 1695*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1696*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1698*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1699*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1700*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note424 = this
*)
(* po redu: 1701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1702*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1704*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note425 = this
*)
(* po redu: 1705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note424 and note425 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1706*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note426 = this
*)
(* po redu: 1707*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note423 and note426 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1708*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note427 = this
*)
(* po redu: 1709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note420 and note427 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1710*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note428 = this
*)
(* po redu: 1711*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1712*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1714*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1715*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1716*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1718*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1719*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1720*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note429 = this
*)
(* po redu: 1721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1722*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1723*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1724*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note430 = this
*)
(* po redu: 1725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note429 and note430 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1726*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note431 = this
*)
(* po redu: 1727*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1728*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1730*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1731*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1732*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note432 = this
*)
(* po redu: 1733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1734*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1736*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note433 = this
*)
(* po redu: 1737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note432 and note433 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1738*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note434 = this
*)
(* po redu: 1739*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note431 and note434 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1740*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note435 = this
*)
(* po redu: 1741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1742*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1743*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1744*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1746*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1747*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1748*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note436 = this
*)
(* po redu: 1749*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1750*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1751*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1752*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note437 = this
*)
(* po redu: 1753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note436 and note437 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1754*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note438 = this
*)
(* po redu: 1755*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1756*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1758*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 1759*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 1760*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note439 = this
*)
(* po redu: 1761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1762*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1763*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1764*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note440 = this
*)
(* po redu: 1765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note439 and note440 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1766*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note441 = this
*)
(* po redu: 1767*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note438 and note441 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1768*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note442 = this
*)
(* po redu: 1769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note435 and note442 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1770*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note443 = this
*)
(* po redu: 1771*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note428 and note443 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 1772*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note444 = this
*)
(* po redu: 1773*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note413 and note444 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 1774*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note445 = this
*)
(* po redu: 1775*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 1776*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 1777*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 1778*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 1779*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 1780*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1782*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1783*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1784*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1786*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note446 = this
*)
(* po redu: 1787*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1788*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1789*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1790*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note447 = this
*)
(* po redu: 1791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note446 and note447 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 1792*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note448 = this
*)
(* po redu: 1793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1794*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1795*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1796*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1797*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note449 = this
*)
(* po redu: 1798*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1800*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1801*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note450 = this
*)
(* po redu: 1802*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note449 and note450 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1803*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note451 = this
*)
(* po redu: 1804*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note448 and note451 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 1805*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note452 = this
*)
(* po redu: 1806*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1807*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1808*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1809*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1810*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1811*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1812*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note453 = this
*)
(* po redu: 1813*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1814*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1816*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note454 = this
*)
(* po redu: 1817*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note453 and note454 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1818*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note455 = this
*)
(* po redu: 1819*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1820*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1822*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note456 = this
*)
(* po redu: 1823*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1824*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1825*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1826*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note457 = this
*)
(* po redu: 1827*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note456 and note457 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 1828*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note458 = this
*)
(* po redu: 1829*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note455 and note458 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 1830*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note459 = this
*)
(* po redu: 1831*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note452 and note459 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 1832*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note460 = this
*)
(* po redu: 1833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1834*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1835*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1836*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1838*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1840*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1841*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note461 = this
*)
(* po redu: 1842*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1843*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1844*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1845*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note462 = this
*)
(* po redu: 1846*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note461 and note462 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1847*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note463 = this
*)
(* po redu: 1848*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1849*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1850*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1851*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1852*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note464 = this
*)
(* po redu: 1853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1854*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1855*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1856*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note465 = this
*)
(* po redu: 1857*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note464 and note465 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1858*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note466 = this
*)
(* po redu: 1859*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note463 and note466 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1860*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note467 = this
*)
(* po redu: 1861*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1862*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1863*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1864*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1866*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1867*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note468 = this
*)
(* po redu: 1868*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1869*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1870*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1871*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note469 = this
*)
(* po redu: 1872*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note468 and note469 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1873*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note470 = this
*)
(* po redu: 1874*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1875*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1876*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1877*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1878*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note471 = this
*)
(* po redu: 1879*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1880*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1881*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1882*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note472 = this
*)
(* po redu: 1883*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note471 and note472 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1884*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note473 = this
*)
(* po redu: 1885*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note470 and note473 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1886*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note474 = this
*)
(* po redu: 1887*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note467 and note474 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1888*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note475 = this
*)
(* po redu: 1889*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note460 and note475 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 1890*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note476 = this
*)
(* po redu: 1891*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 1892*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 1893*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 1894*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1895*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1896*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1898*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1899*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1900*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1901*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note477 = this
*)
(* po redu: 1902*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1903*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1904*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1905*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note478 = this
*)
(* po redu: 1906*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note477 and note478 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1907*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note479 = this
*)
(* po redu: 1908*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1909*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1910*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1911*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1912*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note480 = this
*)
(* po redu: 1913*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1914*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1915*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1916*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note481 = this
*)
(* po redu: 1917*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note480 and note481 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1918*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note482 = this
*)
(* po redu: 1919*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note479 and note482 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1920*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note483 = this
*)
(* po redu: 1921*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1922*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1923*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1924*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1926*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1927*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note484 = this
*)
(* po redu: 1928*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1929*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1930*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1931*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note485 = this
*)
(* po redu: 1932*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note484 and note485 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1933*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note486 = this
*)
(* po redu: 1934*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1935*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1936*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1937*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1938*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note487 = this
*)
(* po redu: 1939*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1940*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1941*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1942*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note488 = this
*)
(* po redu: 1943*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note487 and note488 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1944*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note489 = this
*)
(* po redu: 1945*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note486 and note489 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 1946*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note490 = this
*)
(* po redu: 1947*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note483 and note490 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 1948*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note491 = this
*)
(* po redu: 1949*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 1950*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 1951*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 1952*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1954*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1955*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1956*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note492 = this
*)
(* po redu: 1957*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1959*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1960*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note493 = this
*)
(* po redu: 1961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note492 and note493 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 1962*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note494 = this
*)
(* po redu: 1963*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1964*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1966*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1967*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note495 = this
*)
(* po redu: 1968*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1969*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1970*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1971*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note496 = this
*)
(* po redu: 1972*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note495 and note496 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1973*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note497 = this
*)
(* po redu: 1974*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note494 and note497 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 1975*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note498 = this
*)
(* po redu: 1976*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 1977*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 1978*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 1979*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1980*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1981*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 1982*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note499 = this
*)
(* po redu: 1983*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1984*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1985*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1986*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note500 = this
*)
(* po redu: 1987*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note499 and note500 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 1988*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note501 = this
*)
(* po redu: 1989*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 1990*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 1991*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 1992*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note502 = this
*)
(* po redu: 1993*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 1994*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 1995*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 1996*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note503 = this
*)
(* po redu: 1997*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note502 and note503 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 1998*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note504 = this
*)
(* po redu: 1999*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note501 and note504 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 2000*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note505 = this
*)
(* po redu: 2001*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note498 and note505 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 2002*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note506 = this
*)
(* po redu: 2003*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note491 and note506 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 2004*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note507 = this
*)
(* po redu: 2005*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note476 and note507 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 2006*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note508 = this
*)
(* po redu: 2007*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note445 and note508 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 2008*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note509 = this
*)
(* po redu: 2009*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note382 and note509 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 2010*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note510 = this
*)
(* po redu: 2011*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note255 and note510 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
(* po redu: 2012*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note511 = this
*)
(* po redu: 2013*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
*)
(* po redu: 2014*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 2015*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 2016*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 2017*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 2018*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 2019*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 2020*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 2021*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 2022*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 2023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 2024*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2025*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2026*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2027*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2028*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2030*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note512 = this
*)
(* po redu: 2031*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2032*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2033*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2034*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note513 = this
*)
(* po redu: 2035*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note512 and note513 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 2036*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note514 = this
*)
(* po redu: 2037*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2038*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2039*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2040*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2041*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note515 = this
*)
(* po redu: 2042*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2043*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2044*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2045*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note516 = this
*)
(* po redu: 2046*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note515 and note516 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2047*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note517 = this
*)
(* po redu: 2048*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note514 and note517 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 2049*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note518 = this
*)
(* po redu: 2050*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2051*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2052*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2053*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2054*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2055*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2056*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note519 = this
*)
(* po redu: 2057*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2058*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2060*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note520 = this
*)
(* po redu: 2061*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note519 and note520 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2062*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note521 = this
*)
(* po redu: 2063*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2064*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2065*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2066*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note522 = this
*)
(* po redu: 2067*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2068*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2069*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2070*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note523 = this
*)
(* po redu: 2071*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note522 and note523 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 2072*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note524 = this
*)
(* po redu: 2073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note521 and note524 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 2074*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note525 = this
*)
(* po redu: 2075*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note518 and note525 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 2076*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note526 = this
*)
(* po redu: 2077*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 2078*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2079*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2080*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2081*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2082*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2083*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2084*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2085*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note527 = this
*)
(* po redu: 2086*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2087*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2088*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2089*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note528 = this
*)
(* po redu: 2090*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note527 and note528 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2091*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note529 = this
*)
(* po redu: 2092*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2093*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2094*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2095*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2096*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note530 = this
*)
(* po redu: 2097*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2098*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2099*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2100*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note531 = this
*)
(* po redu: 2101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note530 and note531 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2102*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note532 = this
*)
(* po redu: 2103*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note529 and note532 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2104*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note533 = this
*)
(* po redu: 2105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2106*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2107*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2108*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2110*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2111*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note534 = this
*)
(* po redu: 2112*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2113*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2114*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2115*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note535 = this
*)
(* po redu: 2116*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note534 and note535 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2117*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note536 = this
*)
(* po redu: 2118*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2119*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2120*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2121*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2122*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note537 = this
*)
(* po redu: 2123*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2124*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2125*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2126*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note538 = this
*)
(* po redu: 2127*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note537 and note538 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2128*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note539 = this
*)
(* po redu: 2129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note536 and note539 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2130*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note540 = this
*)
(* po redu: 2131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note533 and note540 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2132*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note541 = this
*)
(* po redu: 2133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note526 and note541 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 2134*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note542 = this
*)
(* po redu: 2135*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 2136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 2137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 2138*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2139*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2140*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2141*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2142*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2143*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2144*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2145*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note543 = this
*)
(* po redu: 2146*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2147*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2148*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2149*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note544 = this
*)
(* po redu: 2150*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note543 and note544 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2151*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note545 = this
*)
(* po redu: 2152*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2153*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2154*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2155*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2156*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note546 = this
*)
(* po redu: 2157*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2158*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2160*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note547 = this
*)
(* po redu: 2161*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note546 and note547 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2162*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note548 = this
*)
(* po redu: 2163*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note545 and note548 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note549 = this
*)
(* po redu: 2165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2167*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2168*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2170*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2171*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note550 = this
*)
(* po redu: 2172*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2173*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2174*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2175*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note551 = this
*)
(* po redu: 2176*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note550 and note551 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2177*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note552 = this
*)
(* po redu: 2178*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2179*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2180*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2181*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2182*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note553 = this
*)
(* po redu: 2183*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2184*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2185*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2186*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note554 = this
*)
(* po redu: 2187*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note553 and note554 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2188*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note555 = this
*)
(* po redu: 2189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note552 and note555 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2190*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note556 = this
*)
(* po redu: 2191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note549 and note556 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2192*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note557 = this
*)
(* po redu: 2193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 2194*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2195*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2196*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2198*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2199*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note558 = this
*)
(* po redu: 2201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2202*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2203*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2204*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note559 = this
*)
(* po redu: 2205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note558 and note559 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 2206*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note560 = this
*)
(* po redu: 2207*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2210*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2211*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note561 = this
*)
(* po redu: 2212*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2213*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2214*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2215*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note562 = this
*)
(* po redu: 2216*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note561 and note562 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2217*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note563 = this
*)
(* po redu: 2218*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note560 and note563 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 2219*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note564 = this
*)
(* po redu: 2220*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2221*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2222*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2223*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2224*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2225*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 2226*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note565 = this
*)
(* po redu: 2227*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2228*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2229*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2230*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note566 = this
*)
(* po redu: 2231*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note565 and note566 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2232*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note567 = this
*)
(* po redu: 2233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2234*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2236*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note568 = this
*)
(* po redu: 2237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2239*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2240*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note569 = this
*)
(* po redu: 2241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note568 and note569 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 2242*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note570 = this
*)
(* po redu: 2243*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note567 and note570 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 2244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note571 = this
*)
(* po redu: 2245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note564 and note571 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 2246*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note572 = this
*)
(* po redu: 2247*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note557 and note572 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 2248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note573 = this
*)
(* po redu: 2249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note542 and note573 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 2250*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note574 = this
*)
(* po redu: 2251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 2252*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 2253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 2254*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 2255*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 2256*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2258*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2260*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2262*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2263*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2264*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note575 = this
*)
(* po redu: 2265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2266*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2268*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note576 = this
*)
(* po redu: 2269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note575 and note576 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2270*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note577 = this
*)
(* po redu: 2271*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2274*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2275*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2276*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note578 = this
*)
(* po redu: 2277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2278*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2279*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2280*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note579 = this
*)
(* po redu: 2281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note578 and note579 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2282*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note580 = this
*)
(* po redu: 2283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note577 and note580 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2284*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note581 = this
*)
(* po redu: 2285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2288*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2290*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2291*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note582 = this
*)
(* po redu: 2293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2294*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2296*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note583 = this
*)
(* po redu: 2297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note582 and note583 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2298*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note584 = this
*)
(* po redu: 2299*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2300*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2302*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note585 = this
*)
(* po redu: 2305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note586 = this
*)
(* po redu: 2309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note585 and note586 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2310*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note587 = this
*)
(* po redu: 2311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note584 and note587 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2312*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note588 = this
*)
(* po redu: 2313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note581 and note588 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2314*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note589 = this
*)
(* po redu: 2315*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 2316*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2318*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2319*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2320*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2322*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note590 = this
*)
(* po redu: 2325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2327*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2328*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note591 = this
*)
(* po redu: 2329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note590 and note591 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2330*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note592 = this
*)
(* po redu: 2331*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2332*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2334*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2336*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note593 = this
*)
(* po redu: 2337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2338*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2340*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note594 = this
*)
(* po redu: 2341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note593 and note594 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2342*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note595 = this
*)
(* po redu: 2343*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note592 and note595 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note596 = this
*)
(* po redu: 2345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2347*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2348*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2350*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2352*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note597 = this
*)
(* po redu: 2353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2354*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2356*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note598 = this
*)
(* po redu: 2357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note597 and note598 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2358*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note599 = this
*)
(* po redu: 2359*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2360*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2362*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note600 = this
*)
(* po redu: 2365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2366*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note601 = this
*)
(* po redu: 2369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note600 and note601 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2370*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note602 = this
*)
(* po redu: 2371*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note599 and note602 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note603 = this
*)
(* po redu: 2373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note596 and note603 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2374*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note604 = this
*)
(* po redu: 2375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note589 and note604 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 2376*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note605 = this
*)
(* po redu: 2377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 2378*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 2379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 2380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2382*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2383*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2384*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2386*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2387*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2388*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note606 = this
*)
(* po redu: 2389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2390*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2391*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2392*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note607 = this
*)
(* po redu: 2393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note606 and note607 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2394*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note608 = this
*)
(* po redu: 2395*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2396*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2398*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2400*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note609 = this
*)
(* po redu: 2401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2402*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2403*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2404*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note610 = this
*)
(* po redu: 2405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note609 and note610 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2406*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note611 = this
*)
(* po redu: 2407*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note608 and note611 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2408*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note612 = this
*)
(* po redu: 2409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2410*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2411*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2412*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2414*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note613 = this
*)
(* po redu: 2417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2419*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2420*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note614 = this
*)
(* po redu: 2421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note613 and note614 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2422*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note615 = this
*)
(* po redu: 2423*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2424*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2426*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2427*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note616 = this
*)
(* po redu: 2429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2430*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2432*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note617 = this
*)
(* po redu: 2433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note616 and note617 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2434*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note618 = this
*)
(* po redu: 2435*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note615 and note618 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2436*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note619 = this
*)
(* po redu: 2437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note612 and note619 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2438*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note620 = this
*)
(* po redu: 2439*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 2440*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2442*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2443*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2444*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2446*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note621 = this
*)
(* po redu: 2449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2450*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2451*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2452*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note622 = this
*)
(* po redu: 2453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note621 and note622 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2454*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note623 = this
*)
(* po redu: 2455*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2456*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2458*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2460*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note624 = this
*)
(* po redu: 2461*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2462*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2464*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note625 = this
*)
(* po redu: 2465*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note624 and note625 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2466*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note626 = this
*)
(* po redu: 2467*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note623 and note626 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2468*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note627 = this
*)
(* po redu: 2469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2470*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2471*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2472*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2474*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2475*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note628 = this
*)
(* po redu: 2477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2478*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2479*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2480*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note629 = this
*)
(* po redu: 2481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note628 and note629 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2482*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note630 = this
*)
(* po redu: 2483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2484*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2486*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2487*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2488*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note631 = this
*)
(* po redu: 2489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2490*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 2491*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 2492*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note632 = this
*)
(* po redu: 2493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note631 and note632 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2494*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note633 = this
*)
(* po redu: 2495*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note630 and note633 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note634 = this
*)
(* po redu: 2497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note627 and note634 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2498*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note635 = this
*)
(* po redu: 2499*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note620 and note635 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 2500*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note636 = this
*)
(* po redu: 2501*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note605 and note636 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 2502*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note637 = this
*)
(* po redu: 2503*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note574 and note637 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 2504*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note638 = this
*)
(* po redu: 2505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 2506*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 2507*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 2508*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 2509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 2510*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 2511*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 2512*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2514*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2515*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2516*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2518*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2519*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2520*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note639 = this
*)
(* po redu: 2521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2522*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2523*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2524*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note640 = this
*)
(* po redu: 2525*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note639 and note640 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2526*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note641 = this
*)
(* po redu: 2527*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2528*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2529*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2530*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2531*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2532*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note642 = this
*)
(* po redu: 2533*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2534*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2535*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2536*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note643 = this
*)
(* po redu: 2537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note642 and note643 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2538*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note644 = this
*)
(* po redu: 2539*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note641 and note644 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2540*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note645 = this
*)
(* po redu: 2541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2542*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2543*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2544*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2546*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2547*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2548*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note646 = this
*)
(* po redu: 2549*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2550*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2551*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2552*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note647 = this
*)
(* po redu: 2553*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note646 and note647 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2554*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note648 = this
*)
(* po redu: 2555*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2556*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2557*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2558*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2559*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2560*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note649 = this
*)
(* po redu: 2561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2563*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2564*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note650 = this
*)
(* po redu: 2565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note649 and note650 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2566*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note651 = this
*)
(* po redu: 2567*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note648 and note651 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2568*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note652 = this
*)
(* po redu: 2569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note645 and note652 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2570*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note653 = this
*)
(* po redu: 2571*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 2572*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2574*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2575*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2576*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2578*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2580*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note654 = this
*)
(* po redu: 2581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2582*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2583*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2584*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note655 = this
*)
(* po redu: 2585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note654 and note655 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2586*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note656 = this
*)
(* po redu: 2587*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2588*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2590*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2592*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note657 = this
*)
(* po redu: 2593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2594*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2595*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2596*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note658 = this
*)
(* po redu: 2597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note657 and note658 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2598*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note659 = this
*)
(* po redu: 2599*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note656 and note659 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2600*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note660 = this
*)
(* po redu: 2601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2602*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2603*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2604*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2606*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note661 = this
*)
(* po redu: 2609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2610*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note662 = this
*)
(* po redu: 2613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note661 and note662 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2614*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note663 = this
*)
(* po redu: 2615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2616*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2618*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2619*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2620*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note664 = this
*)
(* po redu: 2621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2622*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2623*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2624*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note665 = this
*)
(* po redu: 2625*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note664 and note665 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2626*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note666 = this
*)
(* po redu: 2627*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note663 and note666 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2628*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note667 = this
*)
(* po redu: 2629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note660 and note667 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2630*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note668 = this
*)
(* po redu: 2631*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note653 and note668 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 2632*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note669 = this
*)
(* po redu: 2633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 2634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 2635*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 2636*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2638*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2639*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2640*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2642*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2643*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2644*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note670 = this
*)
(* po redu: 2645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2647*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2648*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note671 = this
*)
(* po redu: 2649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note670 and note671 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2650*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note672 = this
*)
(* po redu: 2651*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2652*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2653*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2654*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2655*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2656*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note673 = this
*)
(* po redu: 2657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2658*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2659*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2660*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note674 = this
*)
(* po redu: 2661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note673 and note674 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2662*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note675 = this
*)
(* po redu: 2663*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note672 and note675 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2664*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note676 = this
*)
(* po redu: 2665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2666*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2667*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2668*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2670*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2671*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2672*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note677 = this
*)
(* po redu: 2673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2675*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2676*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note678 = this
*)
(* po redu: 2677*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note677 and note678 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2678*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note679 = this
*)
(* po redu: 2679*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2680*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2682*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2683*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2684*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note680 = this
*)
(* po redu: 2685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2686*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2687*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2688*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note681 = this
*)
(* po redu: 2689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note680 and note681 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2690*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note682 = this
*)
(* po redu: 2691*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note679 and note682 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2692*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note683 = this
*)
(* po redu: 2693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note676 and note683 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2694*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note684 = this
*)
(* po redu: 2695*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 2696*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2698*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2699*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2700*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2702*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2704*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note685 = this
*)
(* po redu: 2705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2707*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2708*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note686 = this
*)
(* po redu: 2709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note685 and note686 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2710*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note687 = this
*)
(* po redu: 2711*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2712*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2714*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2715*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2716*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note688 = this
*)
(* po redu: 2717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2718*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2719*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2720*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note689 = this
*)
(* po redu: 2721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note688 and note689 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2722*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note690 = this
*)
(* po redu: 2723*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note687 and note690 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2724*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note691 = this
*)
(* po redu: 2725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2726*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2727*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2728*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2730*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2731*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2732*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note692 = this
*)
(* po redu: 2733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2734*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2736*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note693 = this
*)
(* po redu: 2737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note692 and note693 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2738*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note694 = this
*)
(* po redu: 2739*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2740*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2742*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2743*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note695 = this
*)
(* po redu: 2745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2746*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2747*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2748*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note696 = this
*)
(* po redu: 2749*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note695 and note696 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2750*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note697 = this
*)
(* po redu: 2751*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note694 and note697 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2752*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note698 = this
*)
(* po redu: 2753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note691 and note698 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2754*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note699 = this
*)
(* po redu: 2755*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note684 and note699 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 2756*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note700 = this
*)
(* po redu: 2757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note669 and note700 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 2758*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note701 = this
*)
(* po redu: 2759*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 2760*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 2761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 2762*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 2763*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 2764*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2766*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2767*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2768*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2770*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2771*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2772*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note702 = this
*)
(* po redu: 2773*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2774*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2775*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2776*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note703 = this
*)
(* po redu: 2777*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note702 and note703 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2778*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note704 = this
*)
(* po redu: 2779*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2780*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2782*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2783*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2784*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note705 = this
*)
(* po redu: 2785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2786*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2787*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2788*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note706 = this
*)
(* po redu: 2789*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note705 and note706 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2790*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note707 = this
*)
(* po redu: 2791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note704 and note707 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2792*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note708 = this
*)
(* po redu: 2793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2794*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2795*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2796*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2798*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2800*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note709 = this
*)
(* po redu: 2801*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2802*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2803*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2804*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note710 = this
*)
(* po redu: 2805*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note709 and note710 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2806*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note711 = this
*)
(* po redu: 2807*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2808*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2809*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2810*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2812*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note712 = this
*)
(* po redu: 2813*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2814*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2816*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note713 = this
*)
(* po redu: 2817*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note712 and note713 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2818*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note714 = this
*)
(* po redu: 2819*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note711 and note714 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2820*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note715 = this
*)
(* po redu: 2821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note708 and note715 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2822*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note716 = this
*)
(* po redu: 2823*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 2824*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2825*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2826*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2827*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2828*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2829*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2830*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2831*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2832*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note717 = this
*)
(* po redu: 2833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2834*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2835*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2836*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note718 = this
*)
(* po redu: 2837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note717 and note718 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2838*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note719 = this
*)
(* po redu: 2839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2840*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2842*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2843*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2844*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note720 = this
*)
(* po redu: 2845*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2846*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2847*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2848*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note721 = this
*)
(* po redu: 2849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note720 and note721 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2850*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note722 = this
*)
(* po redu: 2851*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note719 and note722 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2852*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note723 = this
*)
(* po redu: 2853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2854*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2855*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2856*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2857*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2858*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2859*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2860*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note724 = this
*)
(* po redu: 2861*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2862*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2863*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2864*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note725 = this
*)
(* po redu: 2865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note724 and note725 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2866*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note726 = this
*)
(* po redu: 2867*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2868*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2870*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2871*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2872*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note727 = this
*)
(* po redu: 2873*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2874*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2875*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2876*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note728 = this
*)
(* po redu: 2877*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note727 and note728 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2878*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note729 = this
*)
(* po redu: 2879*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note726 and note729 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2880*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note730 = this
*)
(* po redu: 2881*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note723 and note730 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2882*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note731 = this
*)
(* po redu: 2883*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note716 and note731 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 2884*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note732 = this
*)
(* po redu: 2885*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 2886*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 2887*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 2888*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2889*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2890*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2891*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2892*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2893*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2894*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2895*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2896*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note733 = this
*)
(* po redu: 2897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2898*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2899*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2900*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note734 = this
*)
(* po redu: 2901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note733 and note734 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2902*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note735 = this
*)
(* po redu: 2903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2904*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2906*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2907*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2908*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note736 = this
*)
(* po redu: 2909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2910*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2911*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2912*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note737 = this
*)
(* po redu: 2913*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note736 and note737 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2914*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note738 = this
*)
(* po redu: 2915*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note735 and note738 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2916*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note739 = this
*)
(* po redu: 2917*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2918*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2919*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2920*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2921*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2922*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2923*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2924*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note740 = this
*)
(* po redu: 2925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2926*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2927*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2928*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note741 = this
*)
(* po redu: 2929*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note740 and note741 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2930*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note742 = this
*)
(* po redu: 2931*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2932*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2933*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2934*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2935*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2936*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note743 = this
*)
(* po redu: 2937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2938*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2939*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2940*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note744 = this
*)
(* po redu: 2941*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note743 and note744 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2942*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note745 = this
*)
(* po redu: 2943*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note742 and note745 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2944*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note746 = this
*)
(* po redu: 2945*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note739 and note746 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 2946*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note747 = this
*)
(* po redu: 2947*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 2948*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 2949*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 2950*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2951*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2952*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2954*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2955*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2956*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note748 = this
*)
(* po redu: 2957*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2959*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2960*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note749 = this
*)
(* po redu: 2961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note748 and note749 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2962*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note750 = this
*)
(* po redu: 2963*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2964*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2966*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2967*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2968*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note751 = this
*)
(* po redu: 2969*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2970*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2971*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2972*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note752 = this
*)
(* po redu: 2973*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note751 and note752 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2974*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note753 = this
*)
(* po redu: 2975*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note750 and note753 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 2976*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note754 = this
*)
(* po redu: 2977*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 2978*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 2979*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 2980*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2981*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2982*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2983*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2984*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note755 = this
*)
(* po redu: 2985*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2986*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2987*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 2988*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note756 = this
*)
(* po redu: 2989*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note755 and note756 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 2990*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note757 = this
*)
(* po redu: 2991*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 2992*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 2993*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 2994*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 2995*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 2996*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note758 = this
*)
(* po redu: 2997*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 2998*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 2999*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3000*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note759 = this
*)
(* po redu: 3001*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note758 and note759 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3002*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note760 = this
*)
(* po redu: 3003*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note757 and note760 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3004*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note761 = this
*)
(* po redu: 3005*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note754 and note761 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3006*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note762 = this
*)
(* po redu: 3007*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note747 and note762 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 3008*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note763 = this
*)
(* po redu: 3009*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note732 and note763 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 3010*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note764 = this
*)
(* po redu: 3011*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note701 and note764 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 3012*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note765 = this
*)
(* po redu: 3013*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note638 and note765 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 3014*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note766 = this
*)
(* po redu: 3015*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 3016*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 3017*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 3018*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 3019*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 3020*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 3021*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 3022*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 3023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 3024*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3025*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3026*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3027*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3028*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3030*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3031*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3032*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note767 = this
*)
(* po redu: 3033*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3034*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3035*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3036*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note768 = this
*)
(* po redu: 3037*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note767 and note768 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3038*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note769 = this
*)
(* po redu: 3039*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3040*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3041*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3042*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3043*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3044*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note770 = this
*)
(* po redu: 3045*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3046*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3047*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3048*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note771 = this
*)
(* po redu: 3049*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note770 and note771 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3050*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note772 = this
*)
(* po redu: 3051*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note769 and note772 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3052*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note773 = this
*)
(* po redu: 3053*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3054*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3055*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3056*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3057*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3058*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3060*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note774 = this
*)
(* po redu: 3061*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3062*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3063*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3064*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note775 = this
*)
(* po redu: 3065*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note774 and note775 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3066*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note776 = this
*)
(* po redu: 3067*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3068*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3070*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3071*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3072*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note777 = this
*)
(* po redu: 3073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3074*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3075*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3076*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note778 = this
*)
(* po redu: 3077*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note777 and note778 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3078*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note779 = this
*)
(* po redu: 3079*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note776 and note779 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3080*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note780 = this
*)
(* po redu: 3081*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note773 and note780 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3082*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note781 = this
*)
(* po redu: 3083*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 3084*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3085*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3086*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3087*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3088*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3089*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3090*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3091*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3092*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note782 = this
*)
(* po redu: 3093*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3094*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3095*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3096*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note783 = this
*)
(* po redu: 3097*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note782 and note783 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3098*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note784 = this
*)
(* po redu: 3099*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3100*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3102*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3104*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note785 = this
*)
(* po redu: 3105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3106*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3107*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3108*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note786 = this
*)
(* po redu: 3109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note785 and note786 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3110*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note787 = this
*)
(* po redu: 3111*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note784 and note787 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3112*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note788 = this
*)
(* po redu: 3113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3114*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3115*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3116*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3117*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3118*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3119*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3120*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note789 = this
*)
(* po redu: 3121*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3122*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3123*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3124*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note790 = this
*)
(* po redu: 3125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note789 and note790 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3126*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note791 = this
*)
(* po redu: 3127*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3128*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3130*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3132*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note792 = this
*)
(* po redu: 3133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3134*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3135*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3136*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note793 = this
*)
(* po redu: 3137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note792 and note793 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3138*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note794 = this
*)
(* po redu: 3139*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note791 and note794 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3140*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note795 = this
*)
(* po redu: 3141*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note788 and note795 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3142*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note796 = this
*)
(* po redu: 3143*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note781 and note796 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 3144*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note797 = this
*)
(* po redu: 3145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 3146*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 3147*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 3148*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3149*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3151*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3152*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3153*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3154*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3155*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3156*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note798 = this
*)
(* po redu: 3157*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3158*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3160*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note799 = this
*)
(* po redu: 3161*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note798 and note799 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3162*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note800 = this
*)
(* po redu: 3163*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3164*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3166*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note801 = this
*)
(* po redu: 3169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3170*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3171*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3172*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note802 = this
*)
(* po redu: 3173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note801 and note802 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3174*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note803 = this
*)
(* po redu: 3175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note800 and note803 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3176*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note804 = this
*)
(* po redu: 3177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3179*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3180*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3182*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3183*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3184*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note805 = this
*)
(* po redu: 3185*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3186*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3187*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3188*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note806 = this
*)
(* po redu: 3189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note805 and note806 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3190*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note807 = this
*)
(* po redu: 3191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3192*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3194*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3196*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note808 = this
*)
(* po redu: 3197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3198*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note809 = this
*)
(* po redu: 3201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note808 and note809 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3202*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note810 = this
*)
(* po redu: 3203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note807 and note810 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3204*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note811 = this
*)
(* po redu: 3205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note804 and note811 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3206*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note812 = this
*)
(* po redu: 3207*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 3208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3211*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3212*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3214*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3215*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3216*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note813 = this
*)
(* po redu: 3217*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3218*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3219*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3220*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note814 = this
*)
(* po redu: 3221*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note813 and note814 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3222*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note815 = this
*)
(* po redu: 3223*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3224*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3225*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3226*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3228*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note816 = this
*)
(* po redu: 3229*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3230*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3231*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3232*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note817 = this
*)
(* po redu: 3233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note816 and note817 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3234*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note818 = this
*)
(* po redu: 3235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note815 and note818 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3236*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note819 = this
*)
(* po redu: 3237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3239*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3240*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3242*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note820 = this
*)
(* po redu: 3245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3246*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3247*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note821 = this
*)
(* po redu: 3249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note820 and note821 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3250*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note822 = this
*)
(* po redu: 3251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3252*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3254*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3255*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3256*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note823 = this
*)
(* po redu: 3257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3258*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3259*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3260*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note824 = this
*)
(* po redu: 3261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note823 and note824 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3262*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note825 = this
*)
(* po redu: 3263*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note822 and note825 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3264*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note826 = this
*)
(* po redu: 3265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note819 and note826 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3266*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note827 = this
*)
(* po redu: 3267*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note812 and note827 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 3268*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note828 = this
*)
(* po redu: 3269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note797 and note828 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 3270*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note829 = this
*)
(* po redu: 3271*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 3272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 3273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 3274*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 3275*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 3276*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3278*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3279*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3282*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3283*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3284*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note830 = this
*)
(* po redu: 3285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3287*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3288*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note831 = this
*)
(* po redu: 3289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note830 and note831 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3290*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note832 = this
*)
(* po redu: 3291*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3292*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3294*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3296*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note833 = this
*)
(* po redu: 3297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3298*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3300*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note834 = this
*)
(* po redu: 3301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note833 and note834 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3302*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note835 = this
*)
(* po redu: 3303*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note832 and note835 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note836 = this
*)
(* po redu: 3305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3307*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3308*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3310*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3311*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3312*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note837 = this
*)
(* po redu: 3313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3314*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3315*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3316*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note838 = this
*)
(* po redu: 3317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note837 and note838 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3318*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note839 = this
*)
(* po redu: 3319*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3320*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3322*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note840 = this
*)
(* po redu: 3325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3327*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3328*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note841 = this
*)
(* po redu: 3329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note840 and note841 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3330*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note842 = this
*)
(* po redu: 3331*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note839 and note842 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3332*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note843 = this
*)
(* po redu: 3333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note836 and note843 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3334*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note844 = this
*)
(* po redu: 3335*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 3336*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3338*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3339*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3340*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3342*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3343*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note845 = this
*)
(* po redu: 3345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3347*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3348*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note846 = this
*)
(* po redu: 3349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note845 and note846 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3350*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note847 = this
*)
(* po redu: 3351*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3352*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3354*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3356*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note848 = this
*)
(* po redu: 3357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3358*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3359*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3360*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note849 = this
*)
(* po redu: 3361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note848 and note849 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3362*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note850 = this
*)
(* po redu: 3363*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note847 and note850 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note851 = this
*)
(* po redu: 3365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3366*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3367*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3368*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3370*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3371*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note852 = this
*)
(* po redu: 3373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3374*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3375*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3376*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note853 = this
*)
(* po redu: 3377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note852 and note853 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3378*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note854 = this
*)
(* po redu: 3379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3382*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3383*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3384*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note855 = this
*)
(* po redu: 3385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3386*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3387*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3388*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note856 = this
*)
(* po redu: 3389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note855 and note856 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3390*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note857 = this
*)
(* po redu: 3391*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note854 and note857 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3392*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note858 = this
*)
(* po redu: 3393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note851 and note858 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3394*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note859 = this
*)
(* po redu: 3395*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note844 and note859 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 3396*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note860 = this
*)
(* po redu: 3397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 3398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 3399*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 3400*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3402*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3403*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3404*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3406*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3407*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3408*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note861 = this
*)
(* po redu: 3409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3410*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3411*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note862 = this
*)
(* po redu: 3413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note861 and note862 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3414*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note863 = this
*)
(* po redu: 3415*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3416*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3418*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3419*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3420*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note864 = this
*)
(* po redu: 3421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3422*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3423*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3424*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note865 = this
*)
(* po redu: 3425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note864 and note865 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3426*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note866 = this
*)
(* po redu: 3427*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note863 and note866 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note867 = this
*)
(* po redu: 3429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3430*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3431*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3432*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3434*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3435*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3436*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note868 = this
*)
(* po redu: 3437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3438*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3439*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3440*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note869 = this
*)
(* po redu: 3441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note868 and note869 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3442*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note870 = this
*)
(* po redu: 3443*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3444*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3446*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note871 = this
*)
(* po redu: 3449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3450*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3451*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3452*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note872 = this
*)
(* po redu: 3453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note871 and note872 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3454*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note873 = this
*)
(* po redu: 3455*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note870 and note873 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3456*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note874 = this
*)
(* po redu: 3457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note867 and note874 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3458*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note875 = this
*)
(* po redu: 3459*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 3460*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3461*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3462*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3463*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3464*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3465*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3466*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3467*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3468*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note876 = this
*)
(* po redu: 3469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3470*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3471*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3472*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note877 = this
*)
(* po redu: 3473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note876 and note877 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3474*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note878 = this
*)
(* po redu: 3475*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3476*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3478*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3479*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3480*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note879 = this
*)
(* po redu: 3481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3482*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3483*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3484*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note880 = this
*)
(* po redu: 3485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note879 and note880 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3486*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note881 = this
*)
(* po redu: 3487*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note878 and note881 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3488*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note882 = this
*)
(* po redu: 3489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3490*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3491*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3492*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3494*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note883 = this
*)
(* po redu: 3497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3498*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3499*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3500*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note884 = this
*)
(* po redu: 3501*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note883 and note884 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3502*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note885 = this
*)
(* po redu: 3503*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3504*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3506*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3507*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3508*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note886 = this
*)
(* po redu: 3509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3510*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI1 LI1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

*)
(* po redu: 3511*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI1 ~= LI1`
have False
by auto

*)
(* po redu: 3512*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note887 = this
*)
(* po redu: 3513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note886 and note887 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3514*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note888 = this
*)
(* po redu: 3515*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note885 and note888 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3516*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note889 = this
*)
(* po redu: 3517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note882 and note889 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3518*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note890 = this
*)
(* po redu: 3519*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note875 and note890 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 3520*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note891 = this
*)
(* po redu: 3521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note860 and note891 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 3522*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note892 = this
*)
(* po redu: 3523*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note829 and note892 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 3524*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note893 = this
*)
(* po redu: 3525*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 3526*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 3527*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 3528*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 3529*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 3530*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 3531*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 3532*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3533*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3534*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3535*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3536*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3538*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3539*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3540*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note894 = this
*)
(* po redu: 3541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3542*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3543*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3544*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note895 = this
*)
(* po redu: 3545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note894 and note895 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3546*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note896 = this
*)
(* po redu: 3547*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3548*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3549*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3550*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3551*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3552*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note897 = this
*)
(* po redu: 3553*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3554*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3555*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3556*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note898 = this
*)
(* po redu: 3557*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note897 and note898 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3558*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note899 = this
*)
(* po redu: 3559*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note896 and note899 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3560*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note900 = this
*)
(* po redu: 3561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3563*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3564*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3566*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3567*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3568*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note901 = this
*)
(* po redu: 3569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3571*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3572*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note902 = this
*)
(* po redu: 3573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note901 and note902 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3574*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note903 = this
*)
(* po redu: 3575*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3576*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3578*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3580*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note904 = this
*)
(* po redu: 3581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3582*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3583*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3584*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note905 = this
*)
(* po redu: 3585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note904 and note905 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3586*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note906 = this
*)
(* po redu: 3587*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note903 and note906 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3588*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note907 = this
*)
(* po redu: 3589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note900 and note907 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3590*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note908 = this
*)
(* po redu: 3591*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 3592*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3594*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3595*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3596*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3598*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3599*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3600*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note909 = this
*)
(* po redu: 3601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3602*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3603*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3604*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note910 = this
*)
(* po redu: 3605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note909 and note910 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3606*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note911 = this
*)
(* po redu: 3607*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3608*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3610*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note912 = this
*)
(* po redu: 3613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3615*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3616*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note913 = this
*)
(* po redu: 3617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note912 and note913 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3618*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note914 = this
*)
(* po redu: 3619*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note911 and note914 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3620*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note915 = this
*)
(* po redu: 3621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3622*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3623*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3624*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3625*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3626*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3627*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3628*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note916 = this
*)
(* po redu: 3629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3630*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3631*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3632*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note917 = this
*)
(* po redu: 3633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note916 and note917 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3634*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note918 = this
*)
(* po redu: 3635*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3636*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3638*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3639*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3640*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note919 = this
*)
(* po redu: 3641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3642*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3643*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3644*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note920 = this
*)
(* po redu: 3645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note919 and note920 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3646*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note921 = this
*)
(* po redu: 3647*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note918 and note921 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3648*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note922 = this
*)
(* po redu: 3649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note915 and note922 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3650*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note923 = this
*)
(* po redu: 3651*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note908 and note923 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 3652*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note924 = this
*)
(* po redu: 3653*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 3654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 3655*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 3656*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3658*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3659*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3660*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3662*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3663*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3664*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note925 = this
*)
(* po redu: 3665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3666*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3667*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3668*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note926 = this
*)
(* po redu: 3669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note925 and note926 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3670*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note927 = this
*)
(* po redu: 3671*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3672*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3674*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3675*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3676*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note928 = this
*)
(* po redu: 3677*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3678*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3679*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3680*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note929 = this
*)
(* po redu: 3681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note928 and note929 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3682*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note930 = this
*)
(* po redu: 3683*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note927 and note930 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3684*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note931 = this
*)
(* po redu: 3685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3686*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3687*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3688*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3690*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3691*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3692*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note932 = this
*)
(* po redu: 3693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3695*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3696*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note933 = this
*)
(* po redu: 3697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note932 and note933 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3698*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note934 = this
*)
(* po redu: 3699*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3700*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3702*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3704*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note935 = this
*)
(* po redu: 3705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3707*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3708*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note936 = this
*)
(* po redu: 3709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note935 and note936 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3710*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note937 = this
*)
(* po redu: 3711*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note934 and note937 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3712*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note938 = this
*)
(* po redu: 3713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note931 and note938 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3714*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note939 = this
*)
(* po redu: 3715*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 3716*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3718*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3719*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3720*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3722*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3723*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3724*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note940 = this
*)
(* po redu: 3725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3726*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3727*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3728*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note941 = this
*)
(* po redu: 3729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note940 and note941 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3730*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note942 = this
*)
(* po redu: 3731*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3732*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3734*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3736*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note943 = this
*)
(* po redu: 3737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3738*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3740*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note944 = this
*)
(* po redu: 3741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note943 and note944 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3742*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note945 = this
*)
(* po redu: 3743*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note942 and note945 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note946 = this
*)
(* po redu: 3745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3746*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3747*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3748*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3749*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3750*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3751*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3752*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note947 = this
*)
(* po redu: 3753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3754*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3755*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3756*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note948 = this
*)
(* po redu: 3757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note947 and note948 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3758*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note949 = this
*)
(* po redu: 3759*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3760*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3762*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 3763*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 3764*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note950 = this
*)
(* po redu: 3765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3766*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3767*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3768*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note951 = this
*)
(* po redu: 3769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note950 and note951 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3770*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note952 = this
*)
(* po redu: 3771*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note949 and note952 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3772*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note953 = this
*)
(* po redu: 3773*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note946 and note953 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3774*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note954 = this
*)
(* po redu: 3775*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note939 and note954 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 3776*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note955 = this
*)
(* po redu: 3777*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note924 and note955 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 3778*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note956 = this
*)
(* po redu: 3779*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 3780*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 3781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 3782*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 3783*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 3784*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3786*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3787*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3788*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3789*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3790*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note957 = this
*)
(* po redu: 3791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3792*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3793*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3794*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note958 = this
*)
(* po redu: 3795*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note957 and note958 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 3796*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note959 = this
*)
(* po redu: 3797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3798*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3799*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3800*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3801*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note960 = this
*)
(* po redu: 3802*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3803*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3804*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3805*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note961 = this
*)
(* po redu: 3806*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note960 and note961 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3807*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note962 = this
*)
(* po redu: 3808*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note959 and note962 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 3809*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note963 = this
*)
(* po redu: 3810*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3812*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3813*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3814*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3815*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3816*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note964 = this
*)
(* po redu: 3817*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3818*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3819*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3820*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note965 = this
*)
(* po redu: 3821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note964 and note965 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3822*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note966 = this
*)
(* po redu: 3823*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3824*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3825*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3826*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note967 = this
*)
(* po redu: 3827*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3828*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3829*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3830*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note968 = this
*)
(* po redu: 3831*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note967 and note968 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 3832*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note969 = this
*)
(* po redu: 3833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note966 and note969 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 3834*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note970 = this
*)
(* po redu: 3835*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note963 and note970 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 3836*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note971 = this
*)
(* po redu: 3837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 3838*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3840*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3842*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3843*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3844*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3845*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note972 = this
*)
(* po redu: 3846*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3847*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3848*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3849*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note973 = this
*)
(* po redu: 3850*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note972 and note973 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3851*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note974 = this
*)
(* po redu: 3852*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3853*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3854*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3855*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3856*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note975 = this
*)
(* po redu: 3857*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3858*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3859*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3860*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note976 = this
*)
(* po redu: 3861*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note975 and note976 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3862*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note977 = this
*)
(* po redu: 3863*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note974 and note977 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3864*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note978 = this
*)
(* po redu: 3865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3866*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3867*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3868*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3870*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3871*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note979 = this
*)
(* po redu: 3872*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3873*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3874*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3875*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note980 = this
*)
(* po redu: 3876*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note979 and note980 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3877*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note981 = this
*)
(* po redu: 3878*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3879*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3880*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3881*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3882*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note982 = this
*)
(* po redu: 3883*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3884*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3885*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3886*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note983 = this
*)
(* po redu: 3887*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note982 and note983 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3888*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note984 = this
*)
(* po redu: 3889*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note981 and note984 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3890*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note985 = this
*)
(* po redu: 3891*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note978 and note985 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3892*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note986 = this
*)
(* po redu: 3893*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note971 and note986 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 3894*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note987 = this
*)
(* po redu: 3895*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 3896*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 3897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 3898*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3899*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3900*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3902*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3904*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3905*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note988 = this
*)
(* po redu: 3906*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3907*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3908*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3909*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note989 = this
*)
(* po redu: 3910*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note988 and note989 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3911*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note990 = this
*)
(* po redu: 3912*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3913*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3914*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3915*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3916*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note991 = this
*)
(* po redu: 3917*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3918*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3919*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3920*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note992 = this
*)
(* po redu: 3921*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note991 and note992 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3922*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note993 = this
*)
(* po redu: 3923*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note990 and note993 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3924*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note994 = this
*)
(* po redu: 3925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3926*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3927*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3928*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3929*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3930*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3931*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note995 = this
*)
(* po redu: 3932*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3933*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3934*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3935*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note996 = this
*)
(* po redu: 3936*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note995 and note996 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3937*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note997 = this
*)
(* po redu: 3938*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3939*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3940*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3941*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3942*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note998 = this
*)
(* po redu: 3943*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3944*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3945*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3946*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note999 = this
*)
(* po redu: 3947*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note998 and note999 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3948*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1000 = this
*)
(* po redu: 3949*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note997 and note1000 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 3950*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1001 = this
*)
(* po redu: 3951*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note994 and note1001 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 3952*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1002 = this
*)
(* po redu: 3953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 3954*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 3955*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 3956*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3957*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3960*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1003 = this
*)
(* po redu: 3961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3962*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3963*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3964*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1004 = this
*)
(* po redu: 3965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1003 and note1004 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 3966*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1005 = this
*)
(* po redu: 3967*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3968*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3969*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3970*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3971*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1006 = this
*)
(* po redu: 3972*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3973*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3974*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3975*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1007 = this
*)
(* po redu: 3976*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1006 and note1007 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3977*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1008 = this
*)
(* po redu: 3978*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1005 and note1008 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 3979*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1009 = this
*)
(* po redu: 3980*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 3981*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 3982*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 3983*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3984*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3985*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 3986*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1010 = this
*)
(* po redu: 3987*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3988*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3989*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 3990*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1011 = this
*)
(* po redu: 3991*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1010 and note1011 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 3992*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1012 = this
*)
(* po redu: 3993*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 3994*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 3995*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 3996*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1013 = this
*)
(* po redu: 3997*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 3998*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 3999*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4000*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1014 = this
*)
(* po redu: 4001*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1013 and note1014 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 4002*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1015 = this
*)
(* po redu: 4003*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1012 and note1015 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 4004*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1016 = this
*)
(* po redu: 4005*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1009 and note1016 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 4006*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1017 = this
*)
(* po redu: 4007*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1002 and note1017 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 4008*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1018 = this
*)
(* po redu: 4009*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note987 and note1018 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 4010*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1019 = this
*)
(* po redu: 4011*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note956 and note1019 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 4012*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1020 = this
*)
(* po redu: 4013*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note893 and note1020 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 4014*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1021 = this
*)
(* po redu: 4015*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note766 and note1021 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
(* po redu: 4016*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1022 = this
*)
(* po redu: 4017*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note511 and note1022 and `int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2`
have ?thesis
by auto
*)
(* po redu: 4018*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1023 = this
*)
(* po redu: 4019*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI1 LI1"
*)
(* po redu: 4020*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

*)
(* po redu: 4021*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_l LI2 LI2"
*)
(* po redu: 4022*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 4023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 4024*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 4025*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 4026*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 4027*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 4028*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 4029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 4030*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 4031*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 4032*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4033*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4034*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4035*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4036*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4037*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4038*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1024 = this
*)
(* po redu: 4039*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4040*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4041*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4042*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1025 = this
*)
(* po redu: 4043*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1024 and note1025 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 4044*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1026 = this
*)
(* po redu: 4045*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4046*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4047*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4048*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4049*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1027 = this
*)
(* po redu: 4050*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4051*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4052*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4053*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1028 = this
*)
(* po redu: 4054*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1027 and note1028 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4055*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1029 = this
*)
(* po redu: 4056*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1026 and note1029 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 4057*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1030 = this
*)
(* po redu: 4058*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4060*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4061*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4062*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4063*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4064*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1031 = this
*)
(* po redu: 4065*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4066*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4067*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4068*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1032 = this
*)
(* po redu: 4069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1031 and note1032 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4070*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1033 = this
*)
(* po redu: 4071*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4072*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4074*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1034 = this
*)
(* po redu: 4075*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4076*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4077*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4078*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1035 = this
*)
(* po redu: 4079*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1034 and note1035 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 4080*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1036 = this
*)
(* po redu: 4081*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1033 and note1036 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 4082*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1037 = this
*)
(* po redu: 4083*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1030 and note1037 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 4084*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1038 = this
*)
(* po redu: 4085*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 4086*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4087*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4088*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4089*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4090*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4091*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4092*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4093*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1039 = this
*)
(* po redu: 4094*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4095*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4096*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4097*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1040 = this
*)
(* po redu: 4098*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1039 and note1040 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4099*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1041 = this
*)
(* po redu: 4100*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4101*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4102*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4103*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4104*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1042 = this
*)
(* po redu: 4105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4106*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4107*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4108*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1043 = this
*)
(* po redu: 4109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1042 and note1043 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4110*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1044 = this
*)
(* po redu: 4111*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1041 and note1044 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4112*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1045 = this
*)
(* po redu: 4113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4114*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4115*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4116*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4117*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4118*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4119*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1046 = this
*)
(* po redu: 4120*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4121*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4122*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4123*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1047 = this
*)
(* po redu: 4124*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1046 and note1047 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4125*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1048 = this
*)
(* po redu: 4126*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4127*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4128*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4129*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4130*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1049 = this
*)
(* po redu: 4131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4132*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4133*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4134*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1050 = this
*)
(* po redu: 4135*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1049 and note1050 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4136*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1051 = this
*)
(* po redu: 4137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1048 and note1051 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4138*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1052 = this
*)
(* po redu: 4139*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1045 and note1052 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4140*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1053 = this
*)
(* po redu: 4141*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1038 and note1053 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 4142*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1054 = this
*)
(* po redu: 4143*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 4144*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 4145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 4146*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4147*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4148*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4149*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4151*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4152*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4153*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1055 = this
*)
(* po redu: 4154*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4155*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4156*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4157*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1056 = this
*)
(* po redu: 4158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1055 and note1056 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4159*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1057 = this
*)
(* po redu: 4160*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4161*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4162*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4163*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1058 = this
*)
(* po redu: 4165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1059 = this
*)
(* po redu: 4169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1058 and note1059 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4170*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1060 = this
*)
(* po redu: 4171*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1057 and note1060 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4172*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1061 = this
*)
(* po redu: 4173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4174*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4176*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4178*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4179*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1062 = this
*)
(* po redu: 4180*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4181*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4182*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4183*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1063 = this
*)
(* po redu: 4184*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1062 and note1063 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4185*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1064 = this
*)
(* po redu: 4186*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4187*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4188*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4189*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4190*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1065 = this
*)
(* po redu: 4191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4192*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4193*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4194*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1066 = this
*)
(* po redu: 4195*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1065 and note1066 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4196*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1067 = this
*)
(* po redu: 4197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1064 and note1067 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4198*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1068 = this
*)
(* po redu: 4199*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1061 and note1068 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1069 = this
*)
(* po redu: 4201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 4202*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4204*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4206*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4207*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4208*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1070 = this
*)
(* po redu: 4209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4212*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1071 = this
*)
(* po redu: 4213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1070 and note1071 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 4214*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1072 = this
*)
(* po redu: 4215*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4216*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4217*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4218*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4219*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1073 = this
*)
(* po redu: 4220*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4221*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4222*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4223*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1074 = this
*)
(* po redu: 4224*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1073 and note1074 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4225*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1075 = this
*)
(* po redu: 4226*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1072 and note1075 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 4227*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1076 = this
*)
(* po redu: 4228*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4229*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4230*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4231*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4232*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4233*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 4234*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1077 = this
*)
(* po redu: 4235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4236*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4237*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4238*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1078 = this
*)
(* po redu: 4239*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1077 and note1078 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4240*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1079 = this
*)
(* po redu: 4241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4242*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4243*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1080 = this
*)
(* po redu: 4245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4246*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4247*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1081 = this
*)
(* po redu: 4249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1080 and note1081 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 4250*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1082 = this
*)
(* po redu: 4251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1079 and note1082 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 4252*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1083 = this
*)
(* po redu: 4253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1076 and note1083 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 4254*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1084 = this
*)
(* po redu: 4255*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1069 and note1084 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 4256*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1085 = this
*)
(* po redu: 4257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1054 and note1085 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 4258*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1086 = this
*)
(* po redu: 4259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 4260*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 4261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 4262*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 4263*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 4264*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4266*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4267*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4268*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4270*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4271*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4272*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1087 = this
*)
(* po redu: 4273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4274*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4275*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4276*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1088 = this
*)
(* po redu: 4277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1087 and note1088 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4278*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1089 = this
*)
(* po redu: 4279*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4282*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4283*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4284*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1090 = this
*)
(* po redu: 4285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4287*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4288*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1091 = this
*)
(* po redu: 4289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1090 and note1091 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4290*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1092 = this
*)
(* po redu: 4291*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1089 and note1092 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1093 = this
*)
(* po redu: 4293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4294*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4295*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4296*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4298*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4300*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1094 = this
*)
(* po redu: 4301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4302*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1095 = this
*)
(* po redu: 4305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1094 and note1095 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4306*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1096 = this
*)
(* po redu: 4307*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4308*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4310*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4311*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4312*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1097 = this
*)
(* po redu: 4313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4314*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4315*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4316*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1098 = this
*)
(* po redu: 4317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1097 and note1098 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4318*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1099 = this
*)
(* po redu: 4319*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1096 and note1099 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4320*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1100 = this
*)
(* po redu: 4321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1093 and note1100 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4322*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1101 = this
*)
(* po redu: 4323*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 4324*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4327*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4328*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4330*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4331*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4332*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1102 = this
*)
(* po redu: 4333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4334*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4336*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1103 = this
*)
(* po redu: 4337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1102 and note1103 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4338*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1104 = this
*)
(* po redu: 4339*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4340*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4342*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4343*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1105 = this
*)
(* po redu: 4345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4347*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4348*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1106 = this
*)
(* po redu: 4349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1105 and note1106 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4350*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1107 = this
*)
(* po redu: 4351*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1104 and note1107 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4352*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1108 = this
*)
(* po redu: 4353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4354*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4355*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4356*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4358*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4359*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4360*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1109 = this
*)
(* po redu: 4361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4362*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1110 = this
*)
(* po redu: 4365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1109 and note1110 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4366*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1111 = this
*)
(* po redu: 4367*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4368*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4370*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4371*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1112 = this
*)
(* po redu: 4373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4374*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4375*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4376*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1113 = this
*)
(* po redu: 4377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1112 and note1113 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4378*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1114 = this
*)
(* po redu: 4379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1111 and note1114 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4380*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1115 = this
*)
(* po redu: 4381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1108 and note1115 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4382*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1116 = this
*)
(* po redu: 4383*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1101 and note1116 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 4384*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1117 = this
*)
(* po redu: 4385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 4386*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 4387*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 4388*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4390*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4391*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4392*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4394*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4395*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4396*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1118 = this
*)
(* po redu: 4397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4400*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1119 = this
*)
(* po redu: 4401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1118 and note1119 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4402*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1120 = this
*)
(* po redu: 4403*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4404*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4406*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4407*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4408*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1121 = this
*)
(* po redu: 4409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4410*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4411*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1122 = this
*)
(* po redu: 4413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1121 and note1122 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4414*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1123 = this
*)
(* po redu: 4415*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1120 and note1123 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1124 = this
*)
(* po redu: 4417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4419*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4420*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4422*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4423*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4424*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1125 = this
*)
(* po redu: 4425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4426*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4427*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1126 = this
*)
(* po redu: 4429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1125 and note1126 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4430*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1127 = this
*)
(* po redu: 4431*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4432*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4434*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4435*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4436*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1128 = this
*)
(* po redu: 4437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4438*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4439*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4440*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1129 = this
*)
(* po redu: 4441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1128 and note1129 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4442*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1130 = this
*)
(* po redu: 4443*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1127 and note1130 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4444*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1131 = this
*)
(* po redu: 4445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1124 and note1131 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4446*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1132 = this
*)
(* po redu: 4447*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 4448*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4450*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4451*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4452*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4454*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4455*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4456*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1133 = this
*)
(* po redu: 4457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4458*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4460*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1134 = this
*)
(* po redu: 4461*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1133 and note1134 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4462*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1135 = this
*)
(* po redu: 4463*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4464*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4465*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4466*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4467*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4468*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1136 = this
*)
(* po redu: 4469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4470*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4471*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4472*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1137 = this
*)
(* po redu: 4473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1136 and note1137 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4474*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1138 = this
*)
(* po redu: 4475*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1135 and note1138 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1139 = this
*)
(* po redu: 4477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4478*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4479*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4480*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4482*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4483*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4484*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1140 = this
*)
(* po redu: 4485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4486*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4487*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4488*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1141 = this
*)
(* po redu: 4489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1140 and note1141 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4490*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1142 = this
*)
(* po redu: 4491*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4492*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4494*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1143 = this
*)
(* po redu: 4497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4498*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 4499*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 4500*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1144 = this
*)
(* po redu: 4501*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1143 and note1144 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4502*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1145 = this
*)
(* po redu: 4503*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1142 and note1145 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4504*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1146 = this
*)
(* po redu: 4505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1139 and note1146 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4506*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1147 = this
*)
(* po redu: 4507*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1132 and note1147 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 4508*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1148 = this
*)
(* po redu: 4509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1117 and note1148 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 4510*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1149 = this
*)
(* po redu: 4511*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1086 and note1149 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 4512*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1150 = this
*)
(* po redu: 4513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 4514*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 4515*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 4516*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 4517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 4518*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 4519*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 4520*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4522*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4523*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4524*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4525*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4526*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4527*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4528*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1151 = this
*)
(* po redu: 4529*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4530*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4531*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4532*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1152 = this
*)
(* po redu: 4533*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1151 and note1152 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4534*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1153 = this
*)
(* po redu: 4535*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4536*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4538*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4539*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4540*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1154 = this
*)
(* po redu: 4541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4542*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4543*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4544*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1155 = this
*)
(* po redu: 4545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1154 and note1155 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4546*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1156 = this
*)
(* po redu: 4547*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1153 and note1156 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4548*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1157 = this
*)
(* po redu: 4549*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4550*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4551*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4552*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4553*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4554*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4555*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4556*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1158 = this
*)
(* po redu: 4557*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4558*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4559*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4560*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1159 = this
*)
(* po redu: 4561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1158 and note1159 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4562*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1160 = this
*)
(* po redu: 4563*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4564*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4566*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4567*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4568*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1161 = this
*)
(* po redu: 4569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4571*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4572*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1162 = this
*)
(* po redu: 4573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1161 and note1162 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4574*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1163 = this
*)
(* po redu: 4575*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1160 and note1163 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4576*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1164 = this
*)
(* po redu: 4577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1157 and note1164 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4578*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1165 = this
*)
(* po redu: 4579*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 4580*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4582*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4583*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4586*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4587*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4588*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1166 = this
*)
(* po redu: 4589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4592*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1167 = this
*)
(* po redu: 4593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1166 and note1167 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4594*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1168 = this
*)
(* po redu: 4595*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4596*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4598*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4599*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4600*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1169 = this
*)
(* po redu: 4601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4602*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4603*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4604*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1170 = this
*)
(* po redu: 4605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1169 and note1170 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4606*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1171 = this
*)
(* po redu: 4607*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1168 and note1171 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1172 = this
*)
(* po redu: 4609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4610*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4611*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4612*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4614*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4615*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4616*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1173 = this
*)
(* po redu: 4617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4618*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4619*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4620*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1174 = this
*)
(* po redu: 4621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1173 and note1174 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4622*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1175 = this
*)
(* po redu: 4623*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4624*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4625*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4626*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4627*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4628*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1176 = this
*)
(* po redu: 4629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4630*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4631*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4632*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1177 = this
*)
(* po redu: 4633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1176 and note1177 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4634*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1178 = this
*)
(* po redu: 4635*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1175 and note1178 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4636*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1179 = this
*)
(* po redu: 4637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1172 and note1179 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4638*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1180 = this
*)
(* po redu: 4639*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1165 and note1180 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 4640*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1181 = this
*)
(* po redu: 4641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 4642*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 4643*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 4644*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4647*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4648*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4650*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4651*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4652*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1182 = this
*)
(* po redu: 4653*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4655*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4656*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1183 = this
*)
(* po redu: 4657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1182 and note1183 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4658*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1184 = this
*)
(* po redu: 4659*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4660*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4662*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4663*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4664*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1185 = this
*)
(* po redu: 4665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4666*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4667*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4668*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1186 = this
*)
(* po redu: 4669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1185 and note1186 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4670*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1187 = this
*)
(* po redu: 4671*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1184 and note1187 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4672*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1188 = this
*)
(* po redu: 4673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4675*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4676*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4677*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4678*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4679*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4680*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1189 = this
*)
(* po redu: 4681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4682*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4683*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4684*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1190 = this
*)
(* po redu: 4685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1189 and note1190 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4686*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1191 = this
*)
(* po redu: 4687*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4688*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4690*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4691*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4692*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1192 = this
*)
(* po redu: 4693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4695*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4696*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1193 = this
*)
(* po redu: 4697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1192 and note1193 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4698*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1194 = this
*)
(* po redu: 4699*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1191 and note1194 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4700*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1195 = this
*)
(* po redu: 4701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1188 and note1195 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4702*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1196 = this
*)
(* po redu: 4703*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 4704*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4707*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4708*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4710*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4711*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4712*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1197 = this
*)
(* po redu: 4713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4714*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4715*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4716*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1198 = this
*)
(* po redu: 4717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1197 and note1198 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4718*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1199 = this
*)
(* po redu: 4719*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4720*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4722*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4723*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4724*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1200 = this
*)
(* po redu: 4725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4726*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4727*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4728*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1201 = this
*)
(* po redu: 4729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1200 and note1201 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4730*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1202 = this
*)
(* po redu: 4731*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1199 and note1202 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4732*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1203 = this
*)
(* po redu: 4733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4734*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4735*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4736*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4738*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4740*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1204 = this
*)
(* po redu: 4741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4742*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4743*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1205 = this
*)
(* po redu: 4745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1204 and note1205 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4746*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1206 = this
*)
(* po redu: 4747*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4748*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4749*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4750*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4751*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4752*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1207 = this
*)
(* po redu: 4753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4754*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4755*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4756*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1208 = this
*)
(* po redu: 4757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1207 and note1208 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4758*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1209 = this
*)
(* po redu: 4759*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1206 and note1209 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4760*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1210 = this
*)
(* po redu: 4761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1203 and note1210 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4762*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1211 = this
*)
(* po redu: 4763*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1196 and note1211 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 4764*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1212 = this
*)
(* po redu: 4765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1181 and note1212 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 4766*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1213 = this
*)
(* po redu: 4767*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 4768*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 4769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 4770*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 4771*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 4772*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4773*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4774*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4775*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4776*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4777*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4778*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4779*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4780*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1214 = this
*)
(* po redu: 4781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4782*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4783*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4784*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1215 = this
*)
(* po redu: 4785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1214 and note1215 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4786*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1216 = this
*)
(* po redu: 4787*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4788*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4789*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4790*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4791*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4792*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1217 = this
*)
(* po redu: 4793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4794*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4795*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4796*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1218 = this
*)
(* po redu: 4797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1217 and note1218 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4798*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1219 = this
*)
(* po redu: 4799*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1216 and note1219 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4800*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1220 = this
*)
(* po redu: 4801*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4802*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4803*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4804*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4805*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4806*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4807*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4808*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1221 = this
*)
(* po redu: 4809*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4810*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4812*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1222 = this
*)
(* po redu: 4813*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1221 and note1222 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4814*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1223 = this
*)
(* po redu: 4815*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4816*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4817*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4818*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4819*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4820*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1224 = this
*)
(* po redu: 4821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4822*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4823*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4824*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1225 = this
*)
(* po redu: 4825*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1224 and note1225 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4826*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1226 = this
*)
(* po redu: 4827*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1223 and note1226 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4828*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1227 = this
*)
(* po redu: 4829*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1220 and note1227 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4830*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1228 = this
*)
(* po redu: 4831*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 4832*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4834*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4835*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4836*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4838*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4839*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4840*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1229 = this
*)
(* po redu: 4841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4842*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4843*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4844*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1230 = this
*)
(* po redu: 4845*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1229 and note1230 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4846*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1231 = this
*)
(* po redu: 4847*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4848*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4850*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4851*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4852*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1232 = this
*)
(* po redu: 4853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4854*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4855*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4856*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1233 = this
*)
(* po redu: 4857*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1232 and note1233 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4858*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1234 = this
*)
(* po redu: 4859*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1231 and note1234 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4860*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1235 = this
*)
(* po redu: 4861*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4862*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4863*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4864*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4866*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4867*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4868*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1236 = this
*)
(* po redu: 4869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4870*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4871*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4872*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1237 = this
*)
(* po redu: 4873*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1236 and note1237 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4874*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1238 = this
*)
(* po redu: 4875*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4876*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4877*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4878*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4879*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4880*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1239 = this
*)
(* po redu: 4881*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4882*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4883*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4884*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1240 = this
*)
(* po redu: 4885*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1239 and note1240 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4886*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1241 = this
*)
(* po redu: 4887*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1238 and note1241 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4888*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1242 = this
*)
(* po redu: 4889*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1235 and note1242 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4890*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1243 = this
*)
(* po redu: 4891*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1228 and note1243 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 4892*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1244 = this
*)
(* po redu: 4893*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 4894*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 4895*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 4896*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4898*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4899*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4900*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4902*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4903*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4904*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1245 = this
*)
(* po redu: 4905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4906*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4907*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4908*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1246 = this
*)
(* po redu: 4909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1245 and note1246 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4910*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1247 = this
*)
(* po redu: 4911*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4912*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4913*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4914*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4915*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4916*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1248 = this
*)
(* po redu: 4917*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4918*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4919*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4920*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1249 = this
*)
(* po redu: 4921*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1248 and note1249 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4922*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1250 = this
*)
(* po redu: 4923*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1247 and note1250 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4924*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1251 = this
*)
(* po redu: 4925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4926*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4927*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4928*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4929*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4930*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4931*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4932*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1252 = this
*)
(* po redu: 4933*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4934*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4935*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4936*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1253 = this
*)
(* po redu: 4937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1252 and note1253 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4938*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1254 = this
*)
(* po redu: 4939*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4940*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4941*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4942*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4943*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4944*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1255 = this
*)
(* po redu: 4945*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4946*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4947*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4948*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1256 = this
*)
(* po redu: 4949*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1255 and note1256 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4950*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1257 = this
*)
(* po redu: 4951*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1254 and note1257 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4952*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1258 = this
*)
(* po redu: 4953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1251 and note1258 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 4954*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1259 = this
*)
(* po redu: 4955*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 4956*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 4957*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 4958*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4960*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4962*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4963*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4964*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1260 = this
*)
(* po redu: 4965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4966*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4967*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4968*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1261 = this
*)
(* po redu: 4969*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1260 and note1261 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4970*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1262 = this
*)
(* po redu: 4971*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 4972*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4973*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4974*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4975*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4976*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1263 = this
*)
(* po redu: 4977*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4978*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4979*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4980*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1264 = this
*)
(* po redu: 4981*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1263 and note1264 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4982*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1265 = this
*)
(* po redu: 4983*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1262 and note1265 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 4984*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1266 = this
*)
(* po redu: 4985*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 4986*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 4987*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 4988*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 4989*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 4990*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 4991*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 4992*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1267 = this
*)
(* po redu: 4993*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 4994*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 4995*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 4996*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1268 = this
*)
(* po redu: 4997*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1267 and note1268 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 4998*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1269 = this
*)
(* po redu: 4999*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5000*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5001*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5002*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5003*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5004*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1270 = this
*)
(* po redu: 5005*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5006*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5007*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5008*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1271 = this
*)
(* po redu: 5009*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1270 and note1271 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5010*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1272 = this
*)
(* po redu: 5011*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1269 and note1272 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5012*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1273 = this
*)
(* po redu: 5013*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1266 and note1273 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5014*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1274 = this
*)
(* po redu: 5015*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1259 and note1274 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 5016*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1275 = this
*)
(* po redu: 5017*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1244 and note1275 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 5018*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1276 = this
*)
(* po redu: 5019*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1213 and note1276 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 5020*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1277 = this
*)
(* po redu: 5021*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1150 and note1277 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 5022*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1278 = this
*)
(* po redu: 5023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 5024*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 5025*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 5026*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 5027*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 5028*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 5029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 5030*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 5031*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 5032*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5033*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5034*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5035*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5036*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5037*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5038*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5039*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5040*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1279 = this
*)
(* po redu: 5041*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5042*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5043*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5044*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1280 = this
*)
(* po redu: 5045*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1279 and note1280 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5046*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1281 = this
*)
(* po redu: 5047*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5048*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5049*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5050*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5051*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5052*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1282 = this
*)
(* po redu: 5053*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5054*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5055*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5056*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1283 = this
*)
(* po redu: 5057*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1282 and note1283 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5058*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1284 = this
*)
(* po redu: 5059*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1281 and note1284 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5060*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1285 = this
*)
(* po redu: 5061*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5062*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5063*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5064*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5065*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5066*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5067*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5068*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1286 = this
*)
(* po redu: 5069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5070*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5071*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5072*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1287 = this
*)
(* po redu: 5073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1286 and note1287 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5074*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1288 = this
*)
(* po redu: 5075*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5076*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5077*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5078*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5079*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5080*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1289 = this
*)
(* po redu: 5081*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5082*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5083*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5084*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1290 = this
*)
(* po redu: 5085*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1289 and note1290 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5086*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1291 = this
*)
(* po redu: 5087*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1288 and note1291 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5088*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1292 = this
*)
(* po redu: 5089*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1285 and note1292 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5090*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1293 = this
*)
(* po redu: 5091*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 5092*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5093*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5094*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5095*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5096*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5097*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5098*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5099*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5100*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1294 = this
*)
(* po redu: 5101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5102*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5104*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1295 = this
*)
(* po redu: 5105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1294 and note1295 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5106*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1296 = this
*)
(* po redu: 5107*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5108*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5110*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5111*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5112*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1297 = this
*)
(* po redu: 5113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5114*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5115*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5116*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1298 = this
*)
(* po redu: 5117*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1297 and note1298 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5118*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1299 = this
*)
(* po redu: 5119*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1296 and note1299 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5120*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1300 = this
*)
(* po redu: 5121*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5122*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5123*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5124*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5126*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5127*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5128*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1301 = this
*)
(* po redu: 5129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5132*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1302 = this
*)
(* po redu: 5133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1301 and note1302 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5134*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1303 = this
*)
(* po redu: 5135*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5138*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5139*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5140*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1304 = this
*)
(* po redu: 5141*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5142*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5143*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5144*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1305 = this
*)
(* po redu: 5145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1304 and note1305 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5146*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1306 = this
*)
(* po redu: 5147*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1303 and note1306 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5148*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1307 = this
*)
(* po redu: 5149*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1300 and note1307 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5150*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1308 = this
*)
(* po redu: 5151*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1293 and note1308 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 5152*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1309 = this
*)
(* po redu: 5153*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 5154*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 5155*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 5156*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5157*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5158*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5159*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5161*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5162*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5163*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1310 = this
*)
(* po redu: 5165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1311 = this
*)
(* po redu: 5169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1310 and note1311 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5170*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1312 = this
*)
(* po redu: 5171*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5172*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5174*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5175*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5176*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1313 = this
*)
(* po redu: 5177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5179*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5180*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1314 = this
*)
(* po redu: 5181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1313 and note1314 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5182*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1315 = this
*)
(* po redu: 5183*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1312 and note1315 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5184*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1316 = this
*)
(* po redu: 5185*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5186*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5187*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5188*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5190*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5191*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5192*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1317 = this
*)
(* po redu: 5193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5194*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5196*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1318 = this
*)
(* po redu: 5197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1317 and note1318 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5198*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1319 = this
*)
(* po redu: 5199*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5200*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5202*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5203*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5204*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1320 = this
*)
(* po redu: 5205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5206*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5207*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5208*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1321 = this
*)
(* po redu: 5209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1320 and note1321 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5210*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1322 = this
*)
(* po redu: 5211*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1319 and note1322 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5212*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1323 = this
*)
(* po redu: 5213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1316 and note1323 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5214*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1324 = this
*)
(* po redu: 5215*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 5216*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5217*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5218*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5219*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5220*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5221*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5222*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5223*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5224*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1325 = this
*)
(* po redu: 5225*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5226*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5228*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1326 = this
*)
(* po redu: 5229*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1325 and note1326 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5230*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1327 = this
*)
(* po redu: 5231*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5232*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5234*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5235*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5236*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1328 = this
*)
(* po redu: 5237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5239*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5240*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1329 = this
*)
(* po redu: 5241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1328 and note1329 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5242*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1330 = this
*)
(* po redu: 5243*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1327 and note1330 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1331 = this
*)
(* po redu: 5245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5246*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5247*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5248*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5250*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5251*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5252*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1332 = this
*)
(* po redu: 5253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5254*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5255*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5256*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1333 = this
*)
(* po redu: 5257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1332 and note1333 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5258*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1334 = this
*)
(* po redu: 5259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5260*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5262*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5263*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5264*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1335 = this
*)
(* po redu: 5265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5266*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5268*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1336 = this
*)
(* po redu: 5269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1335 and note1336 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5270*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1337 = this
*)
(* po redu: 5271*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1334 and note1337 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5272*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1338 = this
*)
(* po redu: 5273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1331 and note1338 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5274*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1339 = this
*)
(* po redu: 5275*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1324 and note1339 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 5276*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1340 = this
*)
(* po redu: 5277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1309 and note1340 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 5278*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1341 = this
*)
(* po redu: 5279*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 5280*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 5281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 5282*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 5283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 5284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5288*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5290*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5291*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1342 = this
*)
(* po redu: 5293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5294*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5296*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1343 = this
*)
(* po redu: 5297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1342 and note1343 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5298*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1344 = this
*)
(* po redu: 5299*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5300*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5302*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1345 = this
*)
(* po redu: 5305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1346 = this
*)
(* po redu: 5309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1345 and note1346 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5310*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1347 = this
*)
(* po redu: 5311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1344 and note1347 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5312*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1348 = this
*)
(* po redu: 5313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5314*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5315*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5316*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5318*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5319*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5320*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1349 = this
*)
(* po redu: 5321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5322*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1350 = this
*)
(* po redu: 5325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1349 and note1350 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5326*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1351 = this
*)
(* po redu: 5327*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5328*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5330*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5331*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5332*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1352 = this
*)
(* po redu: 5333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5334*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5336*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1353 = this
*)
(* po redu: 5337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1352 and note1353 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5338*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1354 = this
*)
(* po redu: 5339*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1351 and note1354 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5340*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1355 = this
*)
(* po redu: 5341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1348 and note1355 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5342*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1356 = this
*)
(* po redu: 5343*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 5344*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5346*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5347*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5348*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5350*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5352*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1357 = this
*)
(* po redu: 5353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5354*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5356*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1358 = this
*)
(* po redu: 5357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1357 and note1358 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5358*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1359 = this
*)
(* po redu: 5359*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5360*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5362*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1360 = this
*)
(* po redu: 5365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5366*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1361 = this
*)
(* po redu: 5369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1360 and note1361 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5370*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1362 = this
*)
(* po redu: 5371*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1359 and note1362 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1363 = this
*)
(* po redu: 5373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5374*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5376*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5378*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5379*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5380*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1364 = this
*)
(* po redu: 5381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5382*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5383*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5384*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1365 = this
*)
(* po redu: 5385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1364 and note1365 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5386*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1366 = this
*)
(* po redu: 5387*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5388*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5390*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5391*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5392*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1367 = this
*)
(* po redu: 5393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5394*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5395*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5396*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1368 = this
*)
(* po redu: 5397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1367 and note1368 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5398*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1369 = this
*)
(* po redu: 5399*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1366 and note1369 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5400*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1370 = this
*)
(* po redu: 5401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1363 and note1370 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5402*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1371 = this
*)
(* po redu: 5403*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1356 and note1371 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 5404*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1372 = this
*)
(* po redu: 5405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 5406*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 5407*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 5408*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5410*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5411*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5412*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5414*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1373 = this
*)
(* po redu: 5417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5418*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5419*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5420*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1374 = this
*)
(* po redu: 5421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1373 and note1374 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5422*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1375 = this
*)
(* po redu: 5423*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5424*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5426*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5427*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1376 = this
*)
(* po redu: 5429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5430*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5432*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1377 = this
*)
(* po redu: 5433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1376 and note1377 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5434*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1378 = this
*)
(* po redu: 5435*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1375 and note1378 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5436*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1379 = this
*)
(* po redu: 5437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5438*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5439*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5440*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5442*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5443*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5444*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1380 = this
*)
(* po redu: 5445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5446*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1381 = this
*)
(* po redu: 5449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1380 and note1381 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5450*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1382 = this
*)
(* po redu: 5451*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5452*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5454*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5455*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5456*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1383 = this
*)
(* po redu: 5457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5458*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5460*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1384 = this
*)
(* po redu: 5461*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1383 and note1384 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5462*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1385 = this
*)
(* po redu: 5463*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1382 and note1385 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5464*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1386 = this
*)
(* po redu: 5465*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1379 and note1386 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5466*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1387 = this
*)
(* po redu: 5467*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 5468*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5470*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5471*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5472*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5474*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5475*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1388 = this
*)
(* po redu: 5477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5478*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5479*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5480*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1389 = this
*)
(* po redu: 5481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1388 and note1389 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5482*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1390 = this
*)
(* po redu: 5483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5484*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5486*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5487*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5488*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1391 = this
*)
(* po redu: 5489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5490*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5491*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5492*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1392 = this
*)
(* po redu: 5493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1391 and note1392 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5494*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1393 = this
*)
(* po redu: 5495*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1390 and note1393 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1394 = this
*)
(* po redu: 5497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5498*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5499*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5500*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5501*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5502*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5503*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5504*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1395 = this
*)
(* po redu: 5505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5506*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5507*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5508*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1396 = this
*)
(* po redu: 5509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1395 and note1396 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5510*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1397 = this
*)
(* po redu: 5511*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5512*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5514*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5515*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5516*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1398 = this
*)
(* po redu: 5517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5518*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_l LI2 LI2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_l PO2 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

*)
(* po redu: 5519*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `LI2 ~= LI2`
have False
by auto

*)
(* po redu: 5520*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1399 = this
*)
(* po redu: 5521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1398 and note1399 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5522*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1400 = this
*)
(* po redu: 5523*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1397 and note1400 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5524*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1401 = this
*)
(* po redu: 5525*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1394 and note1401 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5526*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1402 = this
*)
(* po redu: 5527*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1387 and note1402 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 5528*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1403 = this
*)
(* po redu: 5529*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1372 and note1403 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 5530*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1404 = this
*)
(* po redu: 5531*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1341 and note1404 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 5532*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1405 = this
*)
(* po redu: 5533*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 5534*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 5535*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 5536*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 5537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 5538*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 5539*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 5540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5542*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5543*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5544*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5546*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5547*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5548*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1406 = this
*)
(* po redu: 5549*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5550*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5551*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5552*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1407 = this
*)
(* po redu: 5553*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1406 and note1407 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5554*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1408 = this
*)
(* po redu: 5555*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5556*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5557*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5558*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5559*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5560*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1409 = this
*)
(* po redu: 5561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5563*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5564*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1410 = this
*)
(* po redu: 5565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1409 and note1410 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5566*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1411 = this
*)
(* po redu: 5567*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1408 and note1411 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5568*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1412 = this
*)
(* po redu: 5569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5571*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5572*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5574*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5575*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5576*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1413 = this
*)
(* po redu: 5577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5578*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5580*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1414 = this
*)
(* po redu: 5581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1413 and note1414 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5582*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1415 = this
*)
(* po redu: 5583*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5586*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5587*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5588*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1416 = this
*)
(* po redu: 5589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5590*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5592*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1417 = this
*)
(* po redu: 5593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1416 and note1417 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5594*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1418 = this
*)
(* po redu: 5595*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1415 and note1418 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5596*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1419 = this
*)
(* po redu: 5597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1412 and note1419 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5598*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1420 = this
*)
(* po redu: 5599*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 5600*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5602*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5603*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5604*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5606*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1421 = this
*)
(* po redu: 5609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5610*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1422 = this
*)
(* po redu: 5613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1421 and note1422 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5614*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1423 = this
*)
(* po redu: 5615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5616*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5618*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5619*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5620*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1424 = this
*)
(* po redu: 5621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5622*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5623*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5624*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1425 = this
*)
(* po redu: 5625*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1424 and note1425 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5626*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1426 = this
*)
(* po redu: 5627*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1423 and note1426 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5628*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1427 = this
*)
(* po redu: 5629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5630*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5631*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5632*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5634*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5636*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1428 = this
*)
(* po redu: 5637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5638*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5639*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5640*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1429 = this
*)
(* po redu: 5641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1428 and note1429 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5642*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1430 = this
*)
(* po redu: 5643*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5644*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5646*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5647*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5648*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1431 = this
*)
(* po redu: 5649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5650*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5651*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5652*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1432 = this
*)
(* po redu: 5653*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1431 and note1432 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5654*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1433 = this
*)
(* po redu: 5655*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1430 and note1433 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5656*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1434 = this
*)
(* po redu: 5657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1427 and note1434 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5658*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1435 = this
*)
(* po redu: 5659*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1420 and note1435 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 5660*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1436 = this
*)
(* po redu: 5661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 5662*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 5663*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 5664*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5666*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5667*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5668*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5670*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5671*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5672*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1437 = this
*)
(* po redu: 5673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5675*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5676*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1438 = this
*)
(* po redu: 5677*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1437 and note1438 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5678*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1439 = this
*)
(* po redu: 5679*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5680*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5682*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5683*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5684*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1440 = this
*)
(* po redu: 5685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5686*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5687*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5688*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1441 = this
*)
(* po redu: 5689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1440 and note1441 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5690*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1442 = this
*)
(* po redu: 5691*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1439 and note1442 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5692*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1443 = this
*)
(* po redu: 5693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5695*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5696*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5698*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5699*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5700*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1444 = this
*)
(* po redu: 5701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5702*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5704*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1445 = this
*)
(* po redu: 5705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1444 and note1445 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5706*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1446 = this
*)
(* po redu: 5707*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5708*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5710*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5711*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5712*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1447 = this
*)
(* po redu: 5713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5714*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5715*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5716*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1448 = this
*)
(* po redu: 5717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1447 and note1448 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5718*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1449 = this
*)
(* po redu: 5719*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1446 and note1449 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5720*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1450 = this
*)
(* po redu: 5721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1443 and note1450 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5722*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1451 = this
*)
(* po redu: 5723*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 5724*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5726*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5727*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5728*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5730*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5731*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5732*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1452 = this
*)
(* po redu: 5733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5734*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5736*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1453 = this
*)
(* po redu: 5737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1452 and note1453 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5738*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1454 = this
*)
(* po redu: 5739*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5740*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5742*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5743*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1455 = this
*)
(* po redu: 5745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5746*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5747*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5748*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1456 = this
*)
(* po redu: 5749*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1455 and note1456 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5750*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1457 = this
*)
(* po redu: 5751*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1454 and note1457 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5752*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1458 = this
*)
(* po redu: 5753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5754*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5755*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5756*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5758*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5759*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5760*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1459 = this
*)
(* po redu: 5761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5762*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5763*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5764*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1460 = this
*)
(* po redu: 5765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1459 and note1460 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5766*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1461 = this
*)
(* po redu: 5767*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5768*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5770*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 5771*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 5772*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1462 = this
*)
(* po redu: 5773*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5774*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5775*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5776*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1463 = this
*)
(* po redu: 5777*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1462 and note1463 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5778*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1464 = this
*)
(* po redu: 5779*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1461 and note1464 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5780*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1465 = this
*)
(* po redu: 5781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1458 and note1465 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5782*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1466 = this
*)
(* po redu: 5783*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1451 and note1466 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 5784*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1467 = this
*)
(* po redu: 5785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1436 and note1467 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 5786*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1468 = this
*)
(* po redu: 5787*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 5788*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 5789*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 5790*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 5791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 5792*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5794*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5795*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5796*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5798*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1469 = this
*)
(* po redu: 5799*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5800*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5801*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5802*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1470 = this
*)
(* po redu: 5803*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1469 and note1470 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 5804*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1471 = this
*)
(* po redu: 5805*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5806*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5807*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5808*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5809*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1472 = this
*)
(* po redu: 5810*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5812*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5813*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1473 = this
*)
(* po redu: 5814*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1472 and note1473 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5815*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1474 = this
*)
(* po redu: 5816*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1471 and note1474 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 5817*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1475 = this
*)
(* po redu: 5818*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5819*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5820*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5821*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5822*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5823*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5824*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1476 = this
*)
(* po redu: 5825*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5826*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5827*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5828*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1477 = this
*)
(* po redu: 5829*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1476 and note1477 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5830*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1478 = this
*)
(* po redu: 5831*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5832*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5834*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1479 = this
*)
(* po redu: 5835*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5836*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5837*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5838*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1480 = this
*)
(* po redu: 5839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1479 and note1480 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 5840*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1481 = this
*)
(* po redu: 5841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1478 and note1481 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 5842*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1482 = this
*)
(* po redu: 5843*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1475 and note1482 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 5844*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1483 = this
*)
(* po redu: 5845*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 5846*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5847*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5848*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5850*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5851*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5852*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5853*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1484 = this
*)
(* po redu: 5854*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5855*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5856*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5857*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1485 = this
*)
(* po redu: 5858*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1484 and note1485 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5859*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1486 = this
*)
(* po redu: 5860*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5861*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5862*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5863*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5864*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1487 = this
*)
(* po redu: 5865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5866*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5867*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5868*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1488 = this
*)
(* po redu: 5869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1487 and note1488 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5870*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1489 = this
*)
(* po redu: 5871*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1486 and note1489 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5872*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1490 = this
*)
(* po redu: 5873*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5874*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5875*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5876*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5877*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5878*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5879*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1491 = this
*)
(* po redu: 5880*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5881*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5882*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5883*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1492 = this
*)
(* po redu: 5884*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1491 and note1492 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5885*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1493 = this
*)
(* po redu: 5886*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5887*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5888*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5889*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5890*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1494 = this
*)
(* po redu: 5891*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5892*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5893*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5894*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1495 = this
*)
(* po redu: 5895*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1494 and note1495 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5896*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1496 = this
*)
(* po redu: 5897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1493 and note1496 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5898*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1497 = this
*)
(* po redu: 5899*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1490 and note1497 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5900*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1498 = this
*)
(* po redu: 5901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1483 and note1498 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 5902*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1499 = this
*)
(* po redu: 5903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 5904*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 5905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 5906*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5907*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5908*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5910*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5911*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5912*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5913*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1500 = this
*)
(* po redu: 5914*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5915*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5916*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5917*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1501 = this
*)
(* po redu: 5918*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1500 and note1501 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5919*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1502 = this
*)
(* po redu: 5920*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5921*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5922*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5923*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5924*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1503 = this
*)
(* po redu: 5925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5926*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5927*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5928*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1504 = this
*)
(* po redu: 5929*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1503 and note1504 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5930*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1505 = this
*)
(* po redu: 5931*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1502 and note1505 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5932*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1506 = this
*)
(* po redu: 5933*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5934*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5935*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5936*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5938*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5939*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1507 = this
*)
(* po redu: 5940*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5941*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5942*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5943*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1508 = this
*)
(* po redu: 5944*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1507 and note1508 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5945*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1509 = this
*)
(* po redu: 5946*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5947*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5948*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5949*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5950*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1510 = this
*)
(* po redu: 5951*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5952*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5953*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5954*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1511 = this
*)
(* po redu: 5955*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1510 and note1511 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5956*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1512 = this
*)
(* po redu: 5957*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1509 and note1512 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 5958*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1513 = this
*)
(* po redu: 5959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1506 and note1513 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 5960*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1514 = this
*)
(* po redu: 5961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 5962*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 5963*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 5964*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5966*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5967*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5968*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1515 = this
*)
(* po redu: 5969*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5970*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5971*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5972*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1516 = this
*)
(* po redu: 5973*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1515 and note1516 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 5974*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1517 = this
*)
(* po redu: 5975*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 5976*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5977*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5978*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5979*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1518 = this
*)
(* po redu: 5980*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5981*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5982*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5983*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1519 = this
*)
(* po redu: 5984*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1518 and note1519 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 5985*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1520 = this
*)
(* po redu: 5986*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1517 and note1520 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 5987*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1521 = this
*)
(* po redu: 5988*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 5989*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 5990*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 5991*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 5992*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 5993*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 5994*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1522 = this
*)
(* po redu: 5995*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 5996*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 5997*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 5998*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1523 = this
*)
(* po redu: 5999*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1522 and note1523 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6000*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1524 = this
*)
(* po redu: 6001*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6002*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6003*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6004*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1525 = this
*)
(* po redu: 6005*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6006*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6007*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6008*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1526 = this
*)
(* po redu: 6009*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1525 and note1526 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 6010*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1527 = this
*)
(* po redu: 6011*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1524 and note1527 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 6012*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1528 = this
*)
(* po redu: 6013*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1521 and note1528 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
*)
(* po redu: 6014*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1529 = this
*)
(* po redu: 6015*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1514 and note1529 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 6016*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1530 = this
*)
(* po redu: 6017*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1499 and note1530 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
*)
(* po redu: 6018*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1531 = this
*)
(* po redu: 6019*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1468 and note1531 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 6020*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1532 = this
*)
(* po redu: 6021*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1405 and note1532 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 6022*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1533 = this
*)
(* po redu: 6023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1278 and note1533 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
(* po redu: 6024*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1534 = this
*)
(* po redu: 6025*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_l LI2 LI2"
*)
(* po redu: 6026*)
(*3*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

(* po redu: 6027*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
(* po redu: 6028*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

*)
(* po redu: 6029*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
*)
(* po redu: 6030*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 6031*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 6032*)
(*5*)  (*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

(* po redu: 6033*)
(*6*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
(* po redu: 6034*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 6035*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 6036*)
(*7*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6037*)
(*8*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6038*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6039*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6040*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6041*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6042*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1535 = this
*)
(* po redu: 6043*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6044*)
(*9*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6045*)
(*10*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6046*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1536 = this
*)
(* po redu: 6047*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1535 and note1536 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 6048*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1537 = this
*)
(* po redu: 6049*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6050*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6051*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6052*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6053*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1538 = this
*)
(* po redu: 6054*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6055*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6056*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6057*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1539 = this
*)
(* po redu: 6058*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1538 and note1539 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6059*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1540 = this
*)
(* po redu: 6060*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1537 and note1540 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 6061*)
(*11*)  (*BRANCH NAME*)
} note note1541 = this
(* po redu: 6062*)
(*12*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6063*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6064*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6065*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6066*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6067*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6068*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1542 = this
*)
(* po redu: 6069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6070*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6071*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6072*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1543 = this
*)
(* po redu: 6073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1542 and note1543 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6074*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1544 = this
*)
(* po redu: 6075*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6076*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6077*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6078*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1545 = this
*)
(* po redu: 6079*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6080*)
(*13*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6081*)
(*14*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6082*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1546 = this
*)
(* po redu: 6083*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1545 and note1546 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 6084*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1547 = this
*)
(* po redu: 6085*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1544 and note1547 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 6086*)
(*15*)  (*BRANCH NAME*)
} note note1548 = this
(* po redu: 6087*)
(*16*)  
(*BRANCH END*)
from note1541 and note1548 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 6088*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1549 = this
*)
(* po redu: 6089*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 6090*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6091*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6092*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6093*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6094*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6095*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6096*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6097*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1550 = this
*)
(* po redu: 6098*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6099*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6100*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6101*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1551 = this
*)
(* po redu: 6102*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1550 and note1551 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6103*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1552 = this
*)
(* po redu: 6104*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6105*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6106*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6107*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6108*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1553 = this
*)
(* po redu: 6109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6110*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6111*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6112*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1554 = this
*)
(* po redu: 6113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1553 and note1554 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6114*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1555 = this
*)
(* po redu: 6115*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1552 and note1555 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6116*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1556 = this
*)
(* po redu: 6117*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6118*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6119*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6120*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6121*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6122*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6123*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1557 = this
*)
(* po redu: 6124*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6125*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6126*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6127*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1558 = this
*)
(* po redu: 6128*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1557 and note1558 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6129*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1559 = this
*)
(* po redu: 6130*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6132*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6133*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI1 PL1` and `\<not>int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6134*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1560 = this
*)
(* po redu: 6135*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6136*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6137*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6138*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1561 = this
*)
(* po redu: 6139*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1560 and note1561 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6140*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1562 = this
*)
(* po redu: 6141*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1559 and note1562 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6142*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1563 = this
*)
(* po redu: 6143*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1556 and note1563 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6144*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1564 = this
*)
(* po redu: 6145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1549 and note1564 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 6146*)
(*17*)  (*BRANCH NAME*)
} note note1565 = this
(* po redu: 6147*)
(*18*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
(* po redu: 6148*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 6149*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 6150*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6151*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6152*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6153*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6154*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6155*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6156*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6157*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1566 = this
*)
(* po redu: 6158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6161*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1567 = this
*)
(* po redu: 6162*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1566 and note1567 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6163*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1568 = this
*)
(* po redu: 6164*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6165*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6166*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6167*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1569 = this
*)
(* po redu: 6169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6170*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6171*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6172*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1570 = this
*)
(* po redu: 6173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1569 and note1570 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6174*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1571 = this
*)
(* po redu: 6175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1568 and note1571 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6176*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1572 = this
*)
(* po redu: 6177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6178*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6179*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6180*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6182*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6183*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1573 = this
*)
(* po redu: 6184*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6185*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6186*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6187*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1574 = this
*)
(* po redu: 6188*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1573 and note1574 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6189*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1575 = this
*)
(* po redu: 6190*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6191*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6192*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6193*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI1 PL1` and `int_l_pl LI1 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6194*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1576 = this
*)
(* po redu: 6195*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6196*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6197*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6198*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1577 = this
*)
(* po redu: 6199*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1576 and note1577 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1578 = this
*)
(* po redu: 6201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1575 and note1578 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6202*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1579 = this
*)
(* po redu: 6203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1572 and note1579 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6204*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1580 = this
*)
(* po redu: 6205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 6206*)
(*19*)  (*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

(* po redu: 6207*)
(*20*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
(* po redu: 6208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6211*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6212*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1581 = this
*)
(* po redu: 6213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6214*)
(*21*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6215*)
(*22*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6216*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1582 = this
*)
(* po redu: 6217*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1581 and note1582 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 6218*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1583 = this
*)
(* po redu: 6219*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6220*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6221*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6222*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_l_pl LI2 PL1` and `\<not>int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6223*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1584 = this
*)
(* po redu: 6224*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6225*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6226*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6227*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1585 = this
*)
(* po redu: 6228*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1584 and note1585 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6229*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1586 = this
*)
(* po redu: 6230*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1583 and note1586 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 6231*)
(*23*)  (*BRANCH NAME*)
} note note1587 = this
(* po redu: 6232*)
(*24*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
(* po redu: 6233*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6234*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6235*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6236*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6237*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_l_pl LI2 PL1` and `int_l_pl LI2 PL2` and `PL1 = PL2`
have False
by auto

*)
(* po redu: 6238*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1588 = this
*)
(* po redu: 6239*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6240*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6241*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6242*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1589 = this
*)
(* po redu: 6243*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1588 and note1589 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1590 = this
*)
(* po redu: 6245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6246*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6247*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note1591 = this
*)
(* po redu: 6249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6250*)
(*25*)  (*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

(* po redu: 6251*)
(*26*)  (*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

(* po redu: 6252*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1592 = this
*)
(* po redu: 6253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1591 and note1592 and `PL1 = PL2 \<or> PL1 ~= PL2`
have ?thesis
by auto
*)
(* po redu: 6254*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1593 = this
*)
(* po redu: 6255*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1590 and note1593 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have ?thesis
by auto
*)
(* po redu: 6256*)
(*27*)  (*BRANCH NAME*)
} note note1594 = this
(* po redu: 6257*)
(*28*)  
(*BRANCH END*)
from note1587 and note1594 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have ?thesis
by auto
(* po redu: 6258*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1595 = this
*)
(* po redu: 6259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1580 and note1595 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have ?thesis
by auto
*)
(* po redu: 6260*)
(*29*)  (*BRANCH NAME*)
} note note1596 = this
(* po redu: 6261*)
(*30*)  
(*BRANCH END*)
from note1565 and note1596 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have ?thesis
by auto
(* po redu: 6262*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1597 = this
*)
(* po redu: 6263*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 6264*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 6265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 6266*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 6267*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 6268*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6270*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6271*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6272*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6274*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6275*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6276*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1598 = this
*)
(* po redu: 6277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6278*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6279*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6280*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1599 = this
*)
(* po redu: 6281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1598 and note1599 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6282*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1600 = this
*)
(* po redu: 6283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6286*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6287*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6288*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1601 = this
*)
(* po redu: 6289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6290*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6291*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1602 = this
*)
(* po redu: 6293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1601 and note1602 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6294*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1603 = this
*)
(* po redu: 6295*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1600 and note1603 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6296*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1604 = this
*)
(* po redu: 6297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6298*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6299*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6300*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6302*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6303*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6304*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1605 = this
*)
(* po redu: 6305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6306*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1606 = this
*)
(* po redu: 6309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1605 and note1606 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6310*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1607 = this
*)
(* po redu: 6311*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6312*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6314*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6315*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6316*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1608 = this
*)
(* po redu: 6317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6318*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6319*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6320*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1609 = this
*)
(* po redu: 6321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1608 and note1609 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6322*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1610 = this
*)
(* po redu: 6323*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1607 and note1610 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1611 = this
*)
(* po redu: 6325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1604 and note1611 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6326*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1612 = this
*)
(* po redu: 6327*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 6328*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6330*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6331*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6332*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6334*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6336*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1613 = this
*)
(* po redu: 6337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6338*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6340*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1614 = this
*)
(* po redu: 6341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1613 and note1614 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6342*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1615 = this
*)
(* po redu: 6343*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6344*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6346*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6347*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6348*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1616 = this
*)
(* po redu: 6349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6350*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6351*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6352*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1617 = this
*)
(* po redu: 6353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1616 and note1617 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6354*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1618 = this
*)
(* po redu: 6355*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1615 and note1618 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6356*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1619 = this
*)
(* po redu: 6357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6358*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6359*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6360*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6362*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6363*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6364*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1620 = this
*)
(* po redu: 6365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6366*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1621 = this
*)
(* po redu: 6369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1620 and note1621 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6370*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1622 = this
*)
(* po redu: 6371*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6372*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6374*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6375*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6376*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1623 = this
*)
(* po redu: 6377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6378*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6379*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6380*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1624 = this
*)
(* po redu: 6381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1623 and note1624 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6382*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1625 = this
*)
(* po redu: 6383*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1622 and note1625 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6384*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1626 = this
*)
(* po redu: 6385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1619 and note1626 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6386*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1627 = this
*)
(* po redu: 6387*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1612 and note1627 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 6388*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1628 = this
*)
(* po redu: 6389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 6390*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 6391*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 6392*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6394*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6395*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6396*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6398*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6400*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1629 = this
*)
(* po redu: 6401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6402*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6403*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6404*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1630 = this
*)
(* po redu: 6405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1629 and note1630 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6406*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1631 = this
*)
(* po redu: 6407*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6408*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6410*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6411*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6412*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1632 = this
*)
(* po redu: 6413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6414*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6415*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6416*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1633 = this
*)
(* po redu: 6417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1632 and note1633 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6418*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1634 = this
*)
(* po redu: 6419*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1631 and note1634 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6420*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1635 = this
*)
(* po redu: 6421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6422*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6423*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6424*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6426*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6427*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6428*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1636 = this
*)
(* po redu: 6429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6430*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6432*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1637 = this
*)
(* po redu: 6433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1636 and note1637 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6434*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1638 = this
*)
(* po redu: 6435*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6436*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6438*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6439*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6440*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1639 = this
*)
(* po redu: 6441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6442*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6443*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6444*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1640 = this
*)
(* po redu: 6445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1639 and note1640 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6446*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1641 = this
*)
(* po redu: 6447*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1638 and note1641 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1642 = this
*)
(* po redu: 6449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1635 and note1642 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6450*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1643 = this
*)
(* po redu: 6451*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 6452*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6454*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6455*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6456*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6458*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6460*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1644 = this
*)
(* po redu: 6461*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6462*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6464*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1645 = this
*)
(* po redu: 6465*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1644 and note1645 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6466*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1646 = this
*)
(* po redu: 6467*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6468*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6470*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6471*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6472*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1647 = this
*)
(* po redu: 6473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6474*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6475*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6476*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1648 = this
*)
(* po redu: 6477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1647 and note1648 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6478*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1649 = this
*)
(* po redu: 6479*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1646 and note1649 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6480*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1650 = this
*)
(* po redu: 6481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6482*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6483*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6484*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6486*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6487*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6488*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1651 = this
*)
(* po redu: 6489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6490*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6491*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6492*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1652 = this
*)
(* po redu: 6493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1651 and note1652 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6494*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1653 = this
*)
(* po redu: 6495*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6496*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6498*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6499*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6500*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1654 = this
*)
(* po redu: 6501*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6502*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1`
obtain  PO2::point
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "PL1 ~= PL1"
using ax_D8 [of "PL1" "PL1"]
by auto

*)
(* po redu: 6503*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL1`
have False
by auto

*)
(* po redu: 6504*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1655 = this
*)
(* po redu: 6505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1654 and note1655 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6506*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1656 = this
*)
(* po redu: 6507*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1653 and note1656 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6508*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1657 = this
*)
(* po redu: 6509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1650 and note1657 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6510*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1658 = this
*)
(* po redu: 6511*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1643 and note1658 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 6512*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1659 = this
*)
(* po redu: 6513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1628 and note1659 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 6514*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1660 = this
*)
(* po redu: 6515*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1597 and note1660 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have ?thesis
by auto
*)
(* po redu: 6516*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1661 = this
*)
(* po redu: 6517*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
*)
(* po redu: 6518*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 6519*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 6520*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 6521*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 6522*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 6523*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 6524*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6525*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6526*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6527*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6528*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6529*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6530*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6531*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6532*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1662 = this
*)
(* po redu: 6533*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6534*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6535*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6536*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1663 = this
*)
(* po redu: 6537*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1662 and note1663 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6538*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1664 = this
*)
(* po redu: 6539*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6541*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6542*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6543*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6544*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1665 = this
*)
(* po redu: 6545*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6546*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6547*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6548*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1666 = this
*)
(* po redu: 6549*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1665 and note1666 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6550*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1667 = this
*)
(* po redu: 6551*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1664 and note1667 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6552*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1668 = this
*)
(* po redu: 6553*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6554*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6555*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6556*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6557*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6558*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6559*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6560*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1669 = this
*)
(* po redu: 6561*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6563*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6564*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1670 = this
*)
(* po redu: 6565*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1669 and note1670 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6566*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1671 = this
*)
(* po redu: 6567*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6568*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6569*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6570*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6571*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6572*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1672 = this
*)
(* po redu: 6573*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6574*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6575*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6576*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1673 = this
*)
(* po redu: 6577*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1672 and note1673 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6578*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1674 = this
*)
(* po redu: 6579*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1671 and note1674 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6580*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1675 = this
*)
(* po redu: 6581*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1668 and note1675 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6582*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1676 = this
*)
(* po redu: 6583*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 6584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6585*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6586*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6587*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6588*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6589*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6590*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6591*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6592*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1677 = this
*)
(* po redu: 6593*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6594*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6595*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6596*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1678 = this
*)
(* po redu: 6597*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1677 and note1678 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6598*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1679 = this
*)
(* po redu: 6599*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6600*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6601*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6602*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6603*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6604*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1680 = this
*)
(* po redu: 6605*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6606*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6608*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1681 = this
*)
(* po redu: 6609*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1680 and note1681 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6610*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1682 = this
*)
(* po redu: 6611*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1679 and note1682 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6612*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1683 = this
*)
(* po redu: 6613*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6615*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6616*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6617*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6618*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6619*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6620*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1684 = this
*)
(* po redu: 6621*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6622*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6623*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6624*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1685 = this
*)
(* po redu: 6625*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1684 and note1685 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6626*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1686 = this
*)
(* po redu: 6627*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6628*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6629*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6630*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6631*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6632*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1687 = this
*)
(* po redu: 6633*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6636*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1688 = this
*)
(* po redu: 6637*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1687 and note1688 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6638*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1689 = this
*)
(* po redu: 6639*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1686 and note1689 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6640*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1690 = this
*)
(* po redu: 6641*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1683 and note1690 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6642*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1691 = this
*)
(* po redu: 6643*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1676 and note1691 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 6644*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1692 = this
*)
(* po redu: 6645*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 6646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 6647*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 6648*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6649*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6650*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6651*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6652*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6653*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6654*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6655*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6656*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1693 = this
*)
(* po redu: 6657*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6658*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6659*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6660*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1694 = this
*)
(* po redu: 6661*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1693 and note1694 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6662*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1695 = this
*)
(* po redu: 6663*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6664*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6665*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6666*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6667*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6668*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1696 = this
*)
(* po redu: 6669*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6670*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6671*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6672*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1697 = this
*)
(* po redu: 6673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1696 and note1697 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6674*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1698 = this
*)
(* po redu: 6675*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1695 and note1698 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6676*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1699 = this
*)
(* po redu: 6677*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6678*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6679*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6680*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6681*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6682*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6683*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6684*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1700 = this
*)
(* po redu: 6685*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6686*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6687*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6688*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1701 = this
*)
(* po redu: 6689*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1700 and note1701 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6690*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1702 = this
*)
(* po redu: 6691*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6692*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6693*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6694*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6695*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6696*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1703 = this
*)
(* po redu: 6697*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6698*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6699*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6700*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1704 = this
*)
(* po redu: 6701*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1703 and note1704 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6702*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1705 = this
*)
(* po redu: 6703*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1702 and note1705 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6704*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1706 = this
*)
(* po redu: 6705*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1699 and note1706 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6706*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1707 = this
*)
(* po redu: 6707*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 6708*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6710*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6711*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6712*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6713*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6714*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6715*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6716*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1708 = this
*)
(* po redu: 6717*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6718*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6719*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6720*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1709 = this
*)
(* po redu: 6721*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1708 and note1709 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6722*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1710 = this
*)
(* po redu: 6723*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6724*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6725*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6726*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6727*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6728*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1711 = this
*)
(* po redu: 6729*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6730*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6731*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6732*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1712 = this
*)
(* po redu: 6733*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1711 and note1712 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6734*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1713 = this
*)
(* po redu: 6735*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1710 and note1713 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6736*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1714 = this
*)
(* po redu: 6737*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6738*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6739*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6740*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6741*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6742*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6743*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6744*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1715 = this
*)
(* po redu: 6745*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6746*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6747*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6748*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1716 = this
*)
(* po redu: 6749*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1715 and note1716 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6750*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1717 = this
*)
(* po redu: 6751*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6752*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6753*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6754*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6755*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6756*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1718 = this
*)
(* po redu: 6757*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6758*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6759*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6760*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1719 = this
*)
(* po redu: 6761*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1718 and note1719 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6762*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1720 = this
*)
(* po redu: 6763*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1717 and note1720 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6764*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1721 = this
*)
(* po redu: 6765*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1714 and note1721 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6766*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1722 = this
*)
(* po redu: 6767*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1707 and note1722 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 6768*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1723 = this
*)
(* po redu: 6769*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1692 and note1723 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 6770*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1724 = this
*)
(* po redu: 6771*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 6772*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 6773*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 6774*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 6775*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 6776*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6777*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6778*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6779*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6780*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6781*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6782*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6783*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6784*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1725 = this
*)
(* po redu: 6785*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6786*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6787*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6788*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1726 = this
*)
(* po redu: 6789*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1725 and note1726 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6790*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1727 = this
*)
(* po redu: 6791*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6792*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6793*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6794*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6795*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6796*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1728 = this
*)
(* po redu: 6797*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6798*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6799*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6800*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1729 = this
*)
(* po redu: 6801*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1728 and note1729 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6802*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1730 = this
*)
(* po redu: 6803*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1727 and note1730 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6804*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1731 = this
*)
(* po redu: 6805*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6806*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6807*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6808*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6809*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6810*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6811*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6812*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1732 = this
*)
(* po redu: 6813*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6814*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6815*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6816*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1733 = this
*)
(* po redu: 6817*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1732 and note1733 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6818*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1734 = this
*)
(* po redu: 6819*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6820*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6821*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6822*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6823*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6824*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1735 = this
*)
(* po redu: 6825*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6826*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6827*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6828*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1736 = this
*)
(* po redu: 6829*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1735 and note1736 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6830*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1737 = this
*)
(* po redu: 6831*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1734 and note1737 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6832*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1738 = this
*)
(* po redu: 6833*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1731 and note1738 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6834*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1739 = this
*)
(* po redu: 6835*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 6836*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6837*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6838*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6839*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6840*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6841*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6842*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6843*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6844*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1740 = this
*)
(* po redu: 6845*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6846*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6847*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6848*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1741 = this
*)
(* po redu: 6849*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1740 and note1741 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6850*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1742 = this
*)
(* po redu: 6851*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6852*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6853*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6854*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6855*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6856*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1743 = this
*)
(* po redu: 6857*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6858*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6859*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6860*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1744 = this
*)
(* po redu: 6861*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1743 and note1744 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6862*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1745 = this
*)
(* po redu: 6863*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1742 and note1745 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6864*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1746 = this
*)
(* po redu: 6865*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6866*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6867*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6868*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6869*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6870*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6871*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6872*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1747 = this
*)
(* po redu: 6873*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6874*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6875*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6876*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1748 = this
*)
(* po redu: 6877*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1747 and note1748 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6878*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1749 = this
*)
(* po redu: 6879*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6880*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6881*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6882*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6883*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6884*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1750 = this
*)
(* po redu: 6885*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6886*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6887*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6888*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1751 = this
*)
(* po redu: 6889*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1750 and note1751 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6890*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1752 = this
*)
(* po redu: 6891*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1749 and note1752 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6892*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1753 = this
*)
(* po redu: 6893*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1746 and note1753 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6894*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1754 = this
*)
(* po redu: 6895*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1739 and note1754 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 6896*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1755 = this
*)
(* po redu: 6897*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 6898*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 6899*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 6900*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6901*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6902*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6903*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6904*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6905*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6906*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6907*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6908*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1756 = this
*)
(* po redu: 6909*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6910*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6911*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6912*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1757 = this
*)
(* po redu: 6913*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1756 and note1757 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6914*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1758 = this
*)
(* po redu: 6915*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6916*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6917*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6918*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6919*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6920*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1759 = this
*)
(* po redu: 6921*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6922*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6923*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6924*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1760 = this
*)
(* po redu: 6925*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1759 and note1760 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6926*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1761 = this
*)
(* po redu: 6927*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1758 and note1761 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6928*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1762 = this
*)
(* po redu: 6929*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6930*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6931*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6932*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6933*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6934*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6935*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6936*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1763 = this
*)
(* po redu: 6937*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6938*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6939*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6940*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1764 = this
*)
(* po redu: 6941*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1763 and note1764 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6942*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1765 = this
*)
(* po redu: 6943*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6944*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6945*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6946*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6947*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6948*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1766 = this
*)
(* po redu: 6949*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6950*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6951*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6952*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1767 = this
*)
(* po redu: 6953*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1766 and note1767 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6954*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1768 = this
*)
(* po redu: 6955*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1765 and note1768 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6956*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1769 = this
*)
(* po redu: 6957*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1762 and note1769 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 6958*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1770 = this
*)
(* po redu: 6959*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 6960*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 6961*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 6962*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6963*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6964*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6965*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6966*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6967*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6968*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1771 = this
*)
(* po redu: 6969*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6970*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6971*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6972*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1772 = this
*)
(* po redu: 6973*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1771 and note1772 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6974*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1773 = this
*)
(* po redu: 6975*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 6976*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6977*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6978*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6979*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6980*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1774 = this
*)
(* po redu: 6981*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6982*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6983*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 6984*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1775 = this
*)
(* po redu: 6985*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1774 and note1775 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 6986*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1776 = this
*)
(* po redu: 6987*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1773 and note1776 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 6988*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1777 = this
*)
(* po redu: 6989*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 6990*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 6991*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 6992*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 6993*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 6994*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 6995*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 6996*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1778 = this
*)
(* po redu: 6997*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 6998*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 6999*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 7000*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1779 = this
*)
(* po redu: 7001*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1778 and note1779 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7002*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1780 = this
*)
(* po redu: 7003*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7004*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7005*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7006*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>int_pl_pl PL1 PL2` and `PL1 = PL2`
have "\<not>int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7007*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL1` and `\<not>int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7008*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1781 = this
*)
(* po redu: 7009*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7010*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 7011*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 7012*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1782 = this
*)
(* po redu: 7013*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1781 and note1782 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7014*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1783 = this
*)
(* po redu: 7015*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1780 and note1783 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7016*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1784 = this
*)
(* po redu: 7017*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1777 and note1784 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7018*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1785 = this
*)
(* po redu: 7019*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1770 and note1785 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 7020*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1786 = this
*)
(* po redu: 7021*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1755 and note1786 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 7022*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1787 = this
*)
(* po redu: 7023*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1724 and note1787 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 7024*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1788 = this
*)
(* po redu: 7025*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1661 and note1788 and `int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2`
have ?thesis
by auto
*)
(* po redu: 7026*)
(*31*)  (*BRANCH NAME*)
} note note1789 = this
(* po redu: 7027*)
(*32*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
(* po redu: 7028*)
(*33*)  (*REGULAR*)
moreover

have  "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"
using ax_D8a [of "PL1" "PL2"]
by auto

(* po redu: 7029*)
(*34*)  
(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL2"
(* po redu: 7030*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 7031*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 7032*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 7033*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 7034*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 7035*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 7036*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7037*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7038*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7039*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7040*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7041*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7042*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7043*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7044*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1790 = this
*)
(* po redu: 7045*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7046*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7047*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7048*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1791 = this
*)
(* po redu: 7049*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1790 and note1791 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7050*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1792 = this
*)
(* po redu: 7051*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7052*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7053*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7054*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7055*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7056*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1793 = this
*)
(* po redu: 7057*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7058*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7059*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7060*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1794 = this
*)
(* po redu: 7061*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1793 and note1794 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7062*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1795 = this
*)
(* po redu: 7063*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1792 and note1795 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7064*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1796 = this
*)
(* po redu: 7065*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 7066*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7067*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7068*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7069*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7070*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7071*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7072*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1797 = this
*)
(* po redu: 7073*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7074*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7075*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7076*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1798 = this
*)
(* po redu: 7077*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1797 and note1798 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7078*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1799 = this
*)
(* po redu: 7079*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7080*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7081*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7082*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7083*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7084*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1800 = this
*)
(* po redu: 7085*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7086*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7087*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7088*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1801 = this
*)
(* po redu: 7089*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1800 and note1801 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7090*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1802 = this
*)
(* po redu: 7091*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1799 and note1802 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7092*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1803 = this
*)
(* po redu: 7093*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1796 and note1803 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7094*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1804 = this
*)
(* po redu: 7095*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 7096*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7097*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7098*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7099*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7100*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7101*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7102*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7103*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7104*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1805 = this
*)
(* po redu: 7105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7106*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7107*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7108*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1806 = this
*)
(* po redu: 7109*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1805 and note1806 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7110*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1807 = this
*)
(* po redu: 7111*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7112*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7113*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7114*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7115*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7116*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1808 = this
*)
(* po redu: 7117*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7118*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7119*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7120*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1809 = this
*)
(* po redu: 7121*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1808 and note1809 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7122*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1810 = this
*)
(* po redu: 7123*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1807 and note1810 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7124*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1811 = this
*)
(* po redu: 7125*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 7126*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7127*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7128*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7130*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7131*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7132*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1812 = this
*)
(* po redu: 7133*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7134*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7135*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7136*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1813 = this
*)
(* po redu: 7137*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1812 and note1813 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7138*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1814 = this
*)
(* po redu: 7139*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7140*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7141*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7142*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7143*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7144*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1815 = this
*)
(* po redu: 7145*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7146*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7147*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7148*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1816 = this
*)
(* po redu: 7149*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1815 and note1816 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7150*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1817 = this
*)
(* po redu: 7151*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1814 and note1817 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7152*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1818 = this
*)
(* po redu: 7153*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1811 and note1818 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7154*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1819 = this
*)
(* po redu: 7155*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1804 and note1819 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 7156*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1820 = this
*)
(* po redu: 7157*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 7158*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 7159*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 7160*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7161*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7162*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7163*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7164*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7166*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7167*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1821 = this
*)
(* po redu: 7169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7170*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7171*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7172*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1822 = this
*)
(* po redu: 7173*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1821 and note1822 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7174*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1823 = this
*)
(* po redu: 7175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7176*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7178*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7179*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7180*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1824 = this
*)
(* po redu: 7181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7182*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7183*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7184*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1825 = this
*)
(* po redu: 7185*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1824 and note1825 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7186*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1826 = this
*)
(* po redu: 7187*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1823 and note1826 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7188*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1827 = this
*)
(* po redu: 7189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 7190*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7192*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7194*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7196*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1828 = this
*)
(* po redu: 7197*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7198*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7199*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1829 = this
*)
(* po redu: 7201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1828 and note1829 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7202*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1830 = this
*)
(* po redu: 7203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7204*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7206*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7207*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7208*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1831 = this
*)
(* po redu: 7209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7211*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7212*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1832 = this
*)
(* po redu: 7213*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1831 and note1832 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7214*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1833 = this
*)
(* po redu: 7215*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1830 and note1833 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7216*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1834 = this
*)
(* po redu: 7217*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1827 and note1834 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7218*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1835 = this
*)
(* po redu: 7219*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 7220*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7221*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7222*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7223*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7224*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7225*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7226*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7227*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7228*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1836 = this
*)
(* po redu: 7229*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7230*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7231*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7232*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1837 = this
*)
(* po redu: 7233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1836 and note1837 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7234*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1838 = this
*)
(* po redu: 7235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7236*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7238*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7239*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7240*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1839 = this
*)
(* po redu: 7241*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7242*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7244*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1840 = this
*)
(* po redu: 7245*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1839 and note1840 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7246*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1841 = this
*)
(* po redu: 7247*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1838 and note1841 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1842 = this
*)
(* po redu: 7249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 7250*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7252*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7254*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7255*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7256*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1843 = this
*)
(* po redu: 7257*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7258*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7259*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7260*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1844 = this
*)
(* po redu: 7261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1843 and note1844 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7262*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1845 = this
*)
(* po redu: 7263*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7264*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7266*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7267*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7268*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1846 = this
*)
(* po redu: 7269*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7270*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL2 PL2`
obtain  PO2::point
where "inc_po_pl PO2 PL2" and "inc_po_pl PO2 PL2" and "PL2 ~= PL2"
using ax_D8 [of "PL2" "PL2"]
by auto

*)
(* po redu: 7271*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL2 ~= PL2`
have False
by auto

*)
(* po redu: 7272*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1847 = this
*)
(* po redu: 7273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1846 and note1847 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7274*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1848 = this
*)
(* po redu: 7275*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1845 and note1848 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7276*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1849 = this
*)
(* po redu: 7277*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1842 and note1849 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7278*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1850 = this
*)
(* po redu: 7279*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1835 and note1850 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 7280*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1851 = this
*)
(* po redu: 7281*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1820 and note1851 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 7282*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1852 = this
*)
(* po redu: 7283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL2 PL2"
*)
(* po redu: 7284*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 7285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 7286*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 7287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 7288*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7290*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7291*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7292*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7294*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7295*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7296*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1853 = this
*)
(* po redu: 7297*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7298*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 7299*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 7300*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1854 = this
*)
(* po redu: 7301*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1853 and note1854 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7302*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1855 = this
*)
(* po redu: 7303*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7304*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7305*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7306*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7307*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7308*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1856 = this
*)
(* po redu: 7309*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7310*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 7311*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 7312*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1857 = this
*)
(* po redu: 7313*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1856 and note1857 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7314*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1858 = this
*)
(* po redu: 7315*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1855 and note1858 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7316*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1859 = this
*)
(* po redu: 7317*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 7318*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7319*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7320*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7321*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7322*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7323*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7324*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1860 = this
*)
(* po redu: 7325*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7326*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 7327*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 7328*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1861 = this
*)
(* po redu: 7329*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1860 and note1861 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7330*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1862 = this
*)
(* po redu: 7331*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7332*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7333*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7334*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7335*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7336*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1863 = this
*)
(* po redu: 7337*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7338*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 7339*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 7340*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1864 = this
*)
(* po redu: 7341*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1863 and note1864 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7342*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1865 = this
*)
(* po redu: 7343*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1862 and note1865 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7344*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1866 = this
*)
(* po redu: 7345*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1859 and note1866 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7346*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1867 = this
*)
(* po redu: 7347*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 7348*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7349*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7350*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7351*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7352*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7353*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7354*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7355*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7356*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1868 = this
*)
(* po redu: 7357*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7358*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 7359*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 7360*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1869 = this
*)
(* po redu: 7361*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1868 and note1869 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7362*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1870 = this
*)
(* po redu: 7363*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7364*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7365*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7366*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7367*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7368*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1871 = this
*)
(* po redu: 7369*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7370*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 7371*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 7372*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1872 = this
*)
(* po redu: 7373*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1871 and note1872 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7374*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1873 = this
*)
(* po redu: 7375*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1870 and note1873 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7376*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1874 = this
*)
(* po redu: 7377*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 7378*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7379*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7380*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7381*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7382*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7383*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7384*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1875 = this
*)
(* po redu: 7385*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7386*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 7387*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 7388*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1876 = this
*)
(* po redu: 7389*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1875 and note1876 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7390*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1877 = this
*)
(* po redu: 7391*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7392*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7393*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7394*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7395*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7396*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1878 = this
*)
(* po redu: 7397*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7398*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI1 PL1"
using ax_D10 [of "LI1" "PL1"]
by auto

*)
(* po redu: 7399*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL1` and `inc_l_pl LI1 PL1`
have False
by auto

*)
(* po redu: 7400*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1879 = this
*)
(* po redu: 7401*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1878 and note1879 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7402*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1880 = this
*)
(* po redu: 7403*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1877 and note1880 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7404*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1881 = this
*)
(* po redu: 7405*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1874 and note1881 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7406*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1882 = this
*)
(* po redu: 7407*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1867 and note1882 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 7408*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1883 = this
*)
(* po redu: 7409*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL1"
*)
(* po redu: 7410*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 7411*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 7412*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7413*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7414*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7415*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7416*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7417*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7418*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7419*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7420*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1884 = this
*)
(* po redu: 7421*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7422*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

*)
(* po redu: 7423*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

*)
(* po redu: 7424*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1885 = this
*)
(* po redu: 7425*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1884 and note1885 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7426*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1886 = this
*)
(* po redu: 7427*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7428*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7429*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7430*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7431*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7432*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1887 = this
*)
(* po redu: 7433*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7434*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

*)
(* po redu: 7435*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

*)
(* po redu: 7436*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1888 = this
*)
(* po redu: 7437*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1887 and note1888 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7438*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1889 = this
*)
(* po redu: 7439*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1886 and note1889 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7440*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1890 = this
*)
(* po redu: 7441*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 7442*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7443*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7444*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7445*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7446*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7447*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7448*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1891 = this
*)
(* po redu: 7449*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7450*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

*)
(* po redu: 7451*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

*)
(* po redu: 7452*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1892 = this
*)
(* po redu: 7453*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1891 and note1892 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7454*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1893 = this
*)
(* po redu: 7455*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7456*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7457*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7458*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7459*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7460*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1894 = this
*)
(* po redu: 7461*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7462*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI1 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI1" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI1 PL2"
using ax_D10 [of "LI1" "PL2"]
by auto

*)
(* po redu: 7463*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI1 PL2` and `inc_l_pl LI1 PL2`
have False
by auto

*)
(* po redu: 7464*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1895 = this
*)
(* po redu: 7465*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1894 and note1895 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7466*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1896 = this
*)
(* po redu: 7467*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1893 and note1896 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7468*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1897 = this
*)
(* po redu: 7469*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1890 and note1897 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7470*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1898 = this
*)
(* po redu: 7471*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI1 PL2"
*)
(* po redu: 7472*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7473*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7474*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7475*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7476*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7477*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7478*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7479*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7480*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1899 = this
*)
(* po redu: 7481*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7482*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI2 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI2 PL1"
using ax_D10 [of "LI2" "PL1"]
by auto

*)
(* po redu: 7483*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI2 PL1` and `inc_l_pl LI2 PL1`
have False
by auto

*)
(* po redu: 7484*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1900 = this
*)
(* po redu: 7485*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1899 and note1900 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7486*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1901 = this
*)
(* po redu: 7487*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7488*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7489*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7490*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7491*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7492*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1902 = this
*)
(* po redu: 7493*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7494*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI2 PL1`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_pl PO2 PL1" and "\<not>inc_l_pl LI2 PL1"
using ax_D10 [of "LI2" "PL1"]
by auto

*)
(* po redu: 7495*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI2 PL1` and `inc_l_pl LI2 PL1`
have False
by auto

*)
(* po redu: 7496*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1903 = this
*)
(* po redu: 7497*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1902 and note1903 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7498*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1904 = this
*)
(* po redu: 7499*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1901 and note1904 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7500*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1905 = this
*)
(* po redu: 7501*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL1"
*)
(* po redu: 7502*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7503*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7504*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7505*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7506*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7507*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7508*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1906 = this
*)
(* po redu: 7509*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7510*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_l_pl LI2 PL2`
obtain  PO2::point
where "inc_po_l PO2 LI2" and "inc_po_pl PO2 PL2" and "\<not>inc_l_pl LI2 PL2"
using ax_D10 [of "LI2" "PL2"]
by auto

*)
(* po redu: 7511*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>inc_l_pl LI2 PL2` and `inc_l_pl LI2 PL2`
have False
by auto

*)
(* po redu: 7512*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1907 = this
*)
(* po redu: 7513*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1906 and note1907 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7514*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1908 = this
*)
(* po redu: 7515*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_l_pl LI2 PL2"
*)
(* po redu: 7516*)
(*35*)  (*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

(* po redu: 7517*)
(*36*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
(* po redu: 7518*)
(*37*)  (*EQCONTRADICTION*)
moreover
from `int_pl_pl PL1 PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

(* po redu: 7519*)
(*38*)  (*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

(* po redu: 7520*)
(*39*)  (*BRANCH NAME*)
} note note1909 = this
(* po redu: 7521*)
(*40*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
(* po redu: 7522*)
(*41*)  (*REGULAR*)
moreover

obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(* po redu: 7523*)
(*42*)  (*REGULAR*)
moreover

obtain  PO4::point and  PO5::point
where "inc_po_l PO4 LI2" and "PO4 ~= PO5" and "inc_po_l PO5 LI2"
using ax_I3a [of "LI2"]
by auto

(* po redu: 7524*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
obtain  PO6::point
where "PO1 ~= PO6" and "inc_po_pl PO6 PL1" and "inc_po_pl PO6 PL2"
using ax_I7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 7525*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

*)
(* po redu: 7526*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 7527*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

*)
(* po redu: 7528*)
(*43*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL1"
using ax_D11 [of "LI1" "PL1" "PO2"]
by auto

(* po redu: 7529*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 7530*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 7531*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 7532*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 7533*)
(*44*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO2 LI1`
have  "inc_po_pl PO2 PL2"
using ax_D11 [of "LI1" "PL2" "PO2"]
by auto

(* po redu: 7534*)
(*45*)  (*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(* po redu: 7535*)
(*46*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
(* po redu: 7536*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

*)
(* po redu: 7537*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 7538*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 7539*)
(*47*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

(* po redu: 7540*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 7541*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 7542*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 7543*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 7544*)
(*48*)  (*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL2"
using ax_D11 [of "LI1" "PL2" "PO3"]
by auto

(* po redu: 7545*)
(*49*)  (*REGULAR*)
moreover

have  "inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2"
using ax_g4 [of "PO3" "LI2"]
by auto

(* po redu: 7546*)
(*50*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI2"
(* po redu: 7547*)
(*51*)  (*EQCONTRADICTION*)
moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(* po redu: 7548*)
(*52*)  (*REGULAR*)
moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2`
have  "LI1 = LI2"
using ax_I2 [of "PO1" "PO3" "LI1" "LI2"]
by auto

(* po redu: 7549*)
(*53*)  (*REGULAR*)
moreover
from `LI1 = LI2` and `LI1 ~= LI2`
have False
by auto

(* po redu: 7550*)
(*54*)  (*BRANCH NAME*)
} note note1910 = this
(* po redu: 7551*)
(*55*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI2"
(* po redu: 7552*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

*)
(* po redu: 7553*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 7554*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 7555*)
(*56*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL1"
using ax_D11 [of "LI2" "PL1" "PO4"]
by auto

(* po redu: 7556*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 7557*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

*)
(* po redu: 7558*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 7559*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 7560*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 7561*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7562*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 7563*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 7564*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7565*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7566*)
(*57*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL2"
using ax_D11 [of "LI2" "PL2" "PO4"]
by auto

(* po redu: 7567*)
(*58*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 7568*)
(*59*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 7569*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 7570*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 7571*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 7572*)
(*60*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 7573*)
(*61*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

(* po redu: 7574*)
(*62*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL1"
using ax_D11 [of "LI2" "PL1" "PO5"]
by auto

(* po redu: 7575*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 7576*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO5"]
by auto

*)
(* po redu: 7577*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 7578*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 7579*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 7580*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7581*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO3 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 7582*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 7583*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO5 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7584*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7585*)
(*63*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL2"
using ax_D11 [of "LI2" "PL2" "PO5"]
by auto

(* po redu: 7586*)
(*64*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO3`
have  "\<not>col PO1 PO3 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO3"]
by auto

(* po redu: 7587*)
(*65*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO5` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO3 PL2` and `inc_po_pl PO5 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO3" "PO5" "PL1" "PL2"]
by auto

(* po redu: 7588*)
(*66*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7589*)
(*67*)  (*BRANCH NAME*)
} note note1911 = this
(* po redu: 7590*)
(*68*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 7591*)
(*69*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO4 PO3"
using ax_D1a [of "PO1" "PO4" "LI2" "PO3"]
by auto

(* po redu: 7592*)
(*70*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO3`
have  "\<not>col PO1 PO3 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO3"]
by auto

(* po redu: 7593*)
(*71*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO4` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO3 PL2` and `inc_po_pl PO4 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO3" "PO4" "PL1" "PL2"]
by auto

(* po redu: 7594*)
(*72*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7595*)
(*73*)  (*BRANCH NAME*)
} note note1912 = this
(* po redu: 7596*)
(*74*)  
(*BRANCH END*)
from note1911 and note1912 and `PO1 = PO4 \<or> PO1 ~= PO4`
have False
by auto
(* po redu: 7597*)
(*75*)  (*BRANCH NAME*)
} note note1913 = this
(* po redu: 7598*)
(*76*)  
(*BRANCH END*)
from note1910 and note1913 and `inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2`
have False
by auto
(* po redu: 7599*)
(*77*)  (*BRANCH NAME*)
} note note1914 = this
(* po redu: 7600*)
(*78*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
(* po redu: 7601*)
(*79*)  (*REGULAR*)
moreover

have  "inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2"
using ax_g4 [of "PO2" "LI2"]
by auto

(* po redu: 7602*)
(*80*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO2 LI2"
(* po redu: 7603*)
(*81*)  (*REGULAR*)
moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO2 LI2`
have  "LI1 = LI2"
using ax_I2 [of "PO1" "PO2" "LI1" "LI2"]
by auto

(* po redu: 7604*)
(*82*)  (*REGULAR*)
moreover
from `LI1 = LI2` and `LI1 ~= LI2`
have False
by auto

(* po redu: 7605*)
(*83*)  (*BRANCH NAME*)
} note note1915 = this
(* po redu: 7606*)
(*84*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO2 LI2"
(* po redu: 7607*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

*)
(* po redu: 7608*)
(*85*)  (*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(* po redu: 7609*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 7610*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

*)
(* po redu: 7611*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 7612*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

*)
(* po redu: 7613*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI1 PL1` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL1"
using ax_D11 [of "LI1" "PL1" "PO3"]
by auto

*)
(* po redu: 7614*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 7615*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 7616*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 7617*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 7618*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 7619*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 7620*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 7621*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 7622*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 7623*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 7624*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI1 PL2` and `inc_po_l PO3 LI1`
have  "inc_po_pl PO3 PL2"
using ax_D11 [of "LI1" "PL2" "PO3"]
by auto

*)
(* po redu: 7625*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 7626*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
*)
(* po redu: 7627*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

*)
(* po redu: 7628*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 7629*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 7630*)
(*86*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL1"
using ax_D11 [of "LI2" "PL1" "PO4"]
by auto

(* po redu: 7631*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 7632*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

*)
(* po redu: 7633*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 7634*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 7635*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 7636*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7637*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 7638*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 7639*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7640*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7641*)
(*87*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL2"
using ax_D11 [of "LI2" "PL2" "PO4"]
by auto

(* po redu: 7642*)
(*88*)  (*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(* po redu: 7643*)
(*89*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
(* po redu: 7644*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 7645*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 7646*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 7647*)
(*90*)  (*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

(* po redu: 7648*)
(*91*)  (*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

(* po redu: 7649*)
(*92*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL1"
using ax_D11 [of "LI2" "PL1" "PO5"]
by auto

(* po redu: 7650*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 7651*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO5"]
by auto

*)
(* po redu: 7652*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 7653*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO5"]
by auto

*)
(* po redu: 7654*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO5" "PO5"]
by auto

*)
(* po redu: 7655*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7656*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO2 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO5"]
by auto

*)
(* po redu: 7657*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO5" "PO5"]
by auto

*)
(* po redu: 7658*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO5 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7659*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7660*)
(*93*)  (*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL2"
using ax_D11 [of "LI2" "PL2" "PO5"]
by auto

(* po redu: 7661*)
(*94*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

(* po redu: 7662*)
(*95*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO5 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO5" "PL1" "PL2"]
by auto

(* po redu: 7663*)
(*96*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7664*)
(*97*)  (*BRANCH NAME*)
} note note1916 = this
(* po redu: 7665*)
(*98*)  
(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
(* po redu: 7666*)
(*99*)  (*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO4 PO2"
using ax_D1a [of "PO1" "PO4" "LI2" "PO2"]
by auto

(* po redu: 7667*)
(*100*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

(* po redu: 7668*)
(*101*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO4` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO4 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO4" "PL1" "PL2"]
by auto

(* po redu: 7669*)
(*102*)  (*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

(* po redu: 7670*)
(*103*)  (*BRANCH NAME*)
} note note1917 = this
(* po redu: 7671*)
(*104*)  
(*BRANCH END*)
from note1916 and note1917 and `PO1 = PO4 \<or> PO1 ~= PO4`
have False
by auto
(* po redu: 7672*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1918 = this
*)
(* po redu: 7673*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
*)
(* po redu: 7674*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2"
using ax_g4 [of "PO3" "LI2"]
by auto

*)
(* po redu: 7675*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_l PO3 LI2"
*)
(* po redu: 7676*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO3 PO2"
using ax_D1a [of "PO1" "PO3" "LI2" "PO2"]
by auto

*)
(* po redu: 7677*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2`
have  "\<not>col PO1 PO2 PO3"
using ax_ncol_132 [of "PO1" "PO3" "PO2"]
by auto

*)
(* po redu: 7678*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3`
have  "\<not>col PO1 PO3 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 7679*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `col PO1 PO2 PO3`
have  "col PO1 PO3 PO2"
using ax_col_132 [of "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 7680*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO3 PO2` and `col PO1 PO3 PO2`
have False
by auto

*)
(* po redu: 7681*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1919 = this
*)
(* po redu: 7682*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_l PO3 LI2"
*)
(* po redu: 7683*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI2" "PO1" "PO4"]
by auto

*)
(* po redu: 7684*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 7685*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2` and `inc_po_l PO4 LI2`
have  "col PO4 PO4 PO4"
using ax_D1 [of "PO4" "LI2" "PO4" "PO4"]
by auto

*)
(* po redu: 7686*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL1"
using ax_D11 [of "LI2" "PL1" "PO4"]
by auto

*)
(* po redu: 7687*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

*)
(* po redu: 7688*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

*)
(* po redu: 7689*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

*)
(* po redu: 7690*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

*)
(* po redu: 7691*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 7692*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO4"]
by auto

*)
(* po redu: 7693*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 7694*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 7695*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 7696*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7697*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

*)
(* po redu: 7698*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO4"]
by auto

*)
(* po redu: 7699*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

*)
(* po redu: 7700*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 7701*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 7702*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO4 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7703*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO3 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO4"]
by auto

*)
(* po redu: 7704*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO3 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO3" "PO4" "PO4"]
by auto

*)
(* po redu: 7705*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO3 PO4 PO4 PO4"
using ax_D3 [of "PO3" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7706*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO4 PO4 PO4 PO4"
using ax_D3 [of "PO4" "PL1" "PO4" "PO4" "PO4"]
by auto

*)
(* po redu: 7707*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO4 LI2`
have  "inc_po_pl PO4 PL2"
using ax_D11 [of "LI2" "PL2" "PO4"]
by auto

*)
(* po redu: 7708*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 7709*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 7710*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO1 PO5"
using ax_D1 [of "PO1" "LI2" "PO1" "PO5"]
by auto

*)
(* po redu: 7711*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO1 PO5 PO5"
using ax_D1 [of "PO1" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 7712*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2` and `inc_po_l PO5 LI2`
have  "col PO5 PO5 PO5"
using ax_D1 [of "PO5" "LI2" "PO5" "PO5"]
by auto

*)
(* po redu: 7713*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

*)
(* po redu: 7714*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO5 PO2"
using ax_D1a [of "PO1" "PO5" "LI2" "PO2"]
by auto

*)
(* po redu: 7715*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `PO4 ~= PO5` and `PO1 = PO4`
have "PO1 ~= PO5"
by auto

*)
(* po redu: 7716*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO5` and `inc_po_l PO1 LI2` and `inc_po_l PO5 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO5 PO3"
using ax_D1a [of "PO1" "PO5" "LI2" "PO3"]
by auto

*)
(* po redu: 7717*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI2 PL1` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL1"
using ax_D11 [of "LI2" "PL1" "PO5"]
by auto

*)
(* po redu: 7718*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO1 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO5"]
by auto

*)
(* po redu: 7719*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO5"]
by auto

*)
(* po redu: 7720*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO5"]
by auto

*)
(* po redu: 7721*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO1 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO1" "PO5" "PO5"]
by auto

*)
(* po redu: 7722*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO2 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO5"]
by auto

*)
(* po redu: 7723*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO5"]
by auto

*)
(* po redu: 7724*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO2 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO2" "PO5" "PO5"]
by auto

*)
(* po redu: 7725*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO3 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 7726*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO3 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 7727*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO1 PO5 PO5 PO5"
using ax_D3 [of "PO1" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7728*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO2 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO5"]
by auto

*)
(* po redu: 7729*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO3 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO5"]
by auto

*)
(* po redu: 7730*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO2 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO2" "PO5" "PO5"]
by auto

*)
(* po redu: 7731*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO3 PO3 PO5"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 7732*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO3 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 7733*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO2 PO5 PO5 PO5"
using ax_D3 [of "PO2" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7734*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO3 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO5"]
by auto

*)
(* po redu: 7735*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO3 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO3" "PO5" "PO5"]
by auto

*)
(* po redu: 7736*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO3 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO3 PO5 PO5 PO5"
using ax_D3 [of "PO3" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7737*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO5 PL1`
have  "comp PO5 PO5 PO5 PO5"
using ax_D3 [of "PO5" "PL1" "PO5" "PO5" "PO5"]
by auto

*)
(* po redu: 7738*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `inc_l_pl LI2 PL2` and `inc_po_l PO5 LI2`
have  "inc_po_pl PO5 PL2"
using ax_D11 [of "LI2" "PL2" "PO5"]
by auto

*)
(* po redu: 7739*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO5 PO2`
have  "\<not>col PO1 PO2 PO5"
using ax_ncol_132 [of "PO1" "PO5" "PO2"]
by auto

*)
(* po redu: 7740*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO5` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO5 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO5 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO5" "PL1" "PL2"]
by auto

*)
(* po redu: 7741*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

*)
(* po redu: 7742*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1920 = this
*)
(* po redu: 7743*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 7744*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO4 PO2"
using ax_D1a [of "PO1" "PO4" "LI2" "PO2"]
by auto

*)
(* po redu: 7745*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PO1 ~= PO4` and `inc_po_l PO1 LI2` and `inc_po_l PO4 LI2` and `\<not>inc_po_l PO3 LI2`
have  "\<not>col PO1 PO4 PO3"
using ax_D1a [of "PO1" "PO4" "LI2" "PO3"]
by auto

*)
(* po redu: 7746*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO4 PO2`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_132 [of "PO1" "PO4" "PO2"]
by auto

*)
(* po redu: 7747*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO4` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL2` and `inc_po_pl PO2 PL2` and `inc_po_pl PO4 PL2`
have  "PL1 = PL2"
using ax_I5 [of "PO1" "PO2" "PO4" "PL1" "PL2"]
by auto

*)
(* po redu: 7748*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 = PL2` and `PL1 ~= PL2`
have False
by auto

*)
(* po redu: 7749*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1921 = this
*)
(* po redu: 7750*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1920 and note1921 and `PO1 = PO4 \<or> PO1 ~= PO4`
have False
by auto
*)
(* po redu: 7751*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1922 = this
*)
(* po redu: 7752*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1919 and note1922 and `inc_po_l PO3 LI2 \<or> \<not>inc_po_l PO3 LI2`
have False
by auto
*)
(* po redu: 7753*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1923 = this
*)
(* po redu: 7754*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1918 and note1923 and `PO1 = PO3 \<or> PO1 ~= PO3`
have False
by auto
*)
(* po redu: 7755*)
(*105*)  (*BRANCH NAME*)
} note note1924 = this
(* po redu: 7756*)
(*106*)  
(*BRANCH END*)
from note1915 and note1924 and `inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2`
have False
by auto
(* po redu: 7757*)
(*107*)  (*BRANCH NAME*)
} note note1925 = this
(* po redu: 7758*)
(*108*)  
(*BRANCH END*)
from note1914 and note1925 and `PO1 = PO2 \<or> PO1 ~= PO2`
have False
by auto
(* po redu: 7759*)
(*109*)  (*BRANCH NAME*)
} note note1926 = this
(* po redu: 7760*)
(*110*)  
(*BRANCH END*)
from note1909 and note1926 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
(* po redu: 7761*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1927 = this
*)
(* po redu: 7762*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1908 and note1927 and `int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2`
have False
by auto
*)
(* po redu: 7763*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1928 = this
*)
(* po redu: 7764*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1905 and note1928 and `int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1`
have False
by auto
*)
(* po redu: 7765*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1929 = this
*)
(* po redu: 7766*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1898 and note1929 and `int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2`
have False
by auto
*)
(* po redu: 7767*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1930 = this
*)
(* po redu: 7768*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1883 and note1930 and `int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1`
have False
by auto
*)
(* po redu: 7769*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1931 = this
*)
(* po redu: 7770*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1852 and note1931 and `int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2`
have False
by auto
*)
(* po redu: 7771*)
(*111*)  (*BRANCH NAME*)
} note note1932 = this
(* po redu: 7772*)
(*112*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL2"
(* po redu: 7773*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_pl_pl PL2 PL2 \<or> \<not>int_pl_pl PL2 PL2"
using ax_D8a [of "PL2" "PL2"]
by auto

*)
(* po redu: 7774*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL2 PL2"
*)
(* po redu: 7775*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL1 \<or> \<not>int_l_pl LI1 PL1"
using ax_D10a [of "LI1" "PL1"]
by auto

*)
(* po redu: 7776*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL1"
*)
(* po redu: 7777*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"
using ax_D10a [of "LI1" "PL2"]
by auto

*)
(* po redu: 7778*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI1 PL2"
*)
(* po redu: 7779*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL1 \<or> \<not>int_l_pl LI2 PL1"
using ax_D10a [of "LI2" "PL1"]
by auto

*)
(* po redu: 7780*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL1"
*)
(* po redu: 7781*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "int_l_pl LI2 PL2 \<or> \<not>int_l_pl LI2 PL2"
using ax_D10a [of "LI2" "PL2"]
by auto

*)
(* po redu: 7782*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_l_pl LI2 PL2"
*)
(* po redu: 7783*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PL1 = PL2 \<or> PL1 ~= PL2"
using ax_g3 [of "PL1" "PL2"]
by auto

*)
(* po redu: 7784*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 = PL2"
*)
(* po redu: 7785*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `int_pl_pl PL2 PL2` and `PL1 = PL2` and `PL1 = PL2`
have "int_pl_pl PL1 PL1"
by auto

*)
(* po redu: 7786*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>int_pl_pl PL1 PL1` and `int_pl_pl PL1 PL1`
have False
by auto

*)
(* po redu: 7787*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1933 = this
*)
(* po redu: 7788*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PL1 ~= PL2"
*)
(* po redu: 7789*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `PL1 ~= PL2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL2`
have  "int_pl_pl PL1 PL2"
using ax_D7 [of "PL1" "PL2" "PO1"]
by auto

*)
(* po redu: 7790*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `int_pl_pl PL1 PL2` and `\<not>int_pl_pl PL1 PL2`
have False
by auto

*)
(* po redu: 7791*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1934 = this
*)
(* po redu: 7792*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1933 and note1934 and `PL1 = PL2 \<or> PL1 ~= PL2`
have False
by auto
*)
(* po redu: 7793*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1