theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_ml_I3a_1: "inc_po_l PO1 LI3 \<Longrightarrow> ( \<exists>  (PO2::point). PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_ml_I3b_1: "( \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"

and
 ax_col_132: "col PO1 PO3 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_213: "col PO2 PO1 PO3 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_231: "col PO2 PO3 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_312: "col PO3 PO1 PO2 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_col_321: "col PO3 PO2 PO1 \<Longrightarrow> col PO1 PO2 PO3"

and
 ax_ncol_132: "\<not>col PO1 PO3 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_213: "\<not>col PO2 PO1 PO3 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_231: "\<not>col PO2 PO3 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_312: "\<not>col PO3 PO1 PO2 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_ncol_321: "\<not>col PO3 PO2 PO1 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
 ax_int_l_l_21: "int_l_l LI2 LI1 \<Longrightarrow> int_l_l LI1 LI2"

and
 ax_nint_l_l_21: "\<not>int_l_l LI2 LI1 \<Longrightarrow> \<not>int_l_l LI1 LI2"

and
 ax_int_pl_pl_21: "int_pl_pl PL2 PL1 \<Longrightarrow> int_pl_pl PL1 PL2"

and
 ax_nint_pl_pl_21: "\<not>int_pl_pl PL2 PL1 \<Longrightarrow> \<not>int_pl_pl PL1 PL2"

and
 ax_comp_1243: "comp PO1 PO2 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1324: "comp PO1 PO3 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1342: "comp PO1 PO3 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1423: "comp PO1 PO4 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_1432: "comp PO1 PO4 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2134: "comp PO2 PO1 PO3 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2143: "comp PO2 PO1 PO4 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2314: "comp PO2 PO3 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2341: "comp PO2 PO3 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2413: "comp PO2 PO4 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_2431: "comp PO2 PO4 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3124: "comp PO3 PO1 PO2 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3142: "comp PO3 PO1 PO4 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3214: "comp PO3 PO2 PO1 PO4 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3241: "comp PO3 PO2 PO4 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3412: "comp PO3 PO4 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_3421: "comp PO3 PO4 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4123: "comp PO4 PO1 PO2 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4132: "comp PO4 PO1 PO3 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4213: "comp PO4 PO2 PO1 PO3 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4231: "comp PO4 PO2 PO3 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4312: "comp PO4 PO3 PO1 PO2 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
 ax_comp_4321: "comp PO4 PO3 PO2 PO1 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

lemma  th9:
assumes "comp PO1 PO2 PO3 PO4"
and "\<not>col PO1 PO2 PO3"
and "inc_po_pl PO1 PL1"
and "inc_po_pl PO2 PL1"
and "inc_po_pl PO3 PL1"
shows " (inc_po_pl PO4 PL1)"
proof -

(* po redu: 1*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

*)
(* po redu: 2*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

*)
(* po redu: 3*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

*)
(* po redu: 4*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

*)
(* po redu: 5*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

*)
(* po redu: 6*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

*)
(* po redu: 7*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 8*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 9*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 10*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 11*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

*)
(* po redu: 12*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

*)
(* po redu: 13*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

*)
(* po redu: 14*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 15*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO3 PO3 PO3 PO3"
using ax_D3 [of "PO3" "PL1" "PO3" "PO3" "PO3"]
by auto

*)
(* po redu: 16*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1"
using ax_D8a [of "PL1" "PL1"]
by auto

*)
(* po redu: 17*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "int_pl_pl PL1 PL1"
*)
(* po redu: 18*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

*)
(* po redu: 19*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
*)
(* po redu: 20*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 21*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
*)
(* po redu: 22*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 23*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 24*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 25*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note1 = this
*)
(* po redu: 26*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 27*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 28*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 29*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note2 = this
*)
(* po redu: 30*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 31*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 32*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO1 PO4"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO4"]
by auto

*)
(* po redu: 33*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2` and `PO1 = PO3`
have "comp PO1 PO1 PO1 PO4"
by auto

*)
(* po redu: 34*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>comp PO1 PO1 PO1 PO4` and `comp PO1 PO1 PO1 PO4`
have False
by auto

*)
(* po redu: 35*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note3 = this
*)
(* po redu: 36*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note2 and note3 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
*)
(* po redu: 37*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note4 = this
*)
(* po redu: 38*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note1 and note4 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 39*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note5 = this
*)
(* po redu: 40*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
*)
(* po redu: 41*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 42*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 43*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 44*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note6 = this
*)
(* po redu: 45*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 46*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

*)
(* po redu: 47*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
*)
(* po redu: 48*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO3 PL1` and `PO3 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 49*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note7 = this
*)
(* po redu: 50*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
*)
(* po redu: 51*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 52*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 53*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note8 = this
*)
(* po redu: 54*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 55*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

*)
(* po redu: 56*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>col PO1 PO1 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO3 PO4"
using ax_D3a [of "PO1" "PO1" "PO3" "PL1" "PO4"]
by auto

*)
(* po redu: 57*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2`
have "comp PO1 PO1 PO3 PO4"
by auto

*)
(* po redu: 58*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>comp PO1 PO1 PO3 PO4` and `comp PO1 PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 59*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note9 = this
*)
(* po redu: 60*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note8 and note9 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
*)
(* po redu: 61*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note10 = this
*)
(* po redu: 62*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note7 and note10 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 63*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note11 = this
*)
(* po redu: 64*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note6 and note11 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 65*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note12 = this
*)
(* po redu: 66*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note5 and note12 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 67*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note13 = this
*)
(* po redu: 68*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
*)
(* po redu: 69*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 70*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
*)
(* po redu: 71*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 72*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 73*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 74*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note14 = this
*)
(* po redu: 75*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 76*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 77*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 78*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 79*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note15 = this
*)
(* po redu: 80*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 81*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 82*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 83*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note16 = this
*)
(* po redu: 84*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 85*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

*)
(* po redu: 86*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>col PO1 PO2 PO1`
have  "\<not>col PO1 PO1 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO1"]
by auto

*)
(* po redu: 87*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>col PO1 PO1 PO2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO2 PO4"
using ax_D3a [of "PO1" "PO1" "PO2" "PL1" "PO4"]
by auto

*)
(* po redu: 88*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3`
have "comp PO1 PO2 PO1 PO4"
by auto

*)
(* po redu: 89*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `comp PO1 PO2 PO1 PO4`
have  "comp PO1 PO1 PO2 PO4"
using ax_comp_1324 [of "PO1" "PO2" "PO1" "PO4"]
by auto

*)
(* po redu: 90*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>comp PO1 PO1 PO2 PO4` and `comp PO1 PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 91*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note17 = this
*)
(* po redu: 92*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note16 and note17 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
*)
(* po redu: 93*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note18 = this
*)
(* po redu: 94*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note15 and note18 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 95*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note19 = this
*)
(* po redu: 96*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note14 and note19 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 97*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note20 = this
*)
(* po redu: 98*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
*)
(* po redu: 99*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 100*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 101*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 102*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note21 = this
*)
(* po redu: 103*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 104*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

*)
(* po redu: 105*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO3"
*)
(* po redu: 106*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 107*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 108*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 109*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note22 = this
*)
(* po redu: 110*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 111*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 112*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 113*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note23 = this
*)
(* po redu: 114*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 115*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

*)
(* po redu: 116*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>col PO1 PO2 PO2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO2 PO2 PO4"
using ax_D3a [of "PO1" "PO2" "PO2" "PL1" "PO4"]
by auto

*)
(* po redu: 117*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3`
have "comp PO1 PO2 PO2 PO4"
by auto

*)
(* po redu: 118*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
from `\<not>comp PO1 PO2 PO2 PO4` and `comp PO1 PO2 PO2 PO4`
have False
by auto

*)
(* po redu: 119*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note24 = this
*)
(* po redu: 120*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note23 and note24 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
*)
(* po redu: 121*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note25 = this
*)
(* po redu: 122*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note22 and note25 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 123*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note26 = this
*)
(* po redu: 124*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO3"
*)
(* po redu: 125*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 126*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 127*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 128*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note27 = this
*)
(* po redu: 129*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 130*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

*)
(* po redu: 131*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
*)
(* po redu: 132*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
from `inc_po_pl PO3 PL1` and `PO3 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 133*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note28 = this
*)
(* po redu: 134*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
*)
(* po redu: 135*)
(*1*)  (*REGULAR*)

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 136*)
(*2*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 137*)
(*3*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note29 = this
(* po redu: 138*)
(*4*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 139*)
(*5*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO2 PO3 PO4"
using ax_D3a [of "PO1" "PO2" "PO3" "PL1" "PO4"]
by auto

(* po redu: 140*)
(*6*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO2 PO3 PO4` and `comp PO1 PO2 PO3 PO4`
have False
by auto

(* po redu: 141*)
(*7*)  (*BRANCH NAME*)
} note note30 = this
(* po redu: 142*)
(*8*)  
(*BRANCH END*)
from note29 and note30 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 143*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note31 = this
*)
(* po redu: 144*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note28 and note31 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 145*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note32 = this
*)
(* po redu: 146*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note27 and note32 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 147*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note33 = this
*)
(* po redu: 148*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note26 and note33 and `PO2 = PO3 \<or> PO2 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 149*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note34 = this
*)
(* po redu: 150*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note21 and note34 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 151*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note35 = this
*)
(* po redu: 152*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note20 and note35 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 153*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note36 = this
*)
(* po redu: 154*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note13 and note36 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
*)
(* po redu: 155*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note37 = this
*)
(* po redu: 156*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>int_pl_pl PL1 PL1"
*)
(* po redu: 157*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

*)
(* po redu: 158*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO2"
*)
(* po redu: 159*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 160*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
*)
(* po redu: 161*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 162*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 163*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 164*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note38 = this
*)
(* po redu: 165*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 166*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 167*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 168*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note39 = this
*)
(* po redu: 169*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 170*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

*)
(* po redu: 171*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO1 PO4"
using ax_D3a [of "PO1" "PO1" "PO1" "PL1" "PO4"]
by auto

*)
(* po redu: 172*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2` and `PO1 = PO3`
have "comp PO1 PO1 PO1 PO4"
by auto

*)
(* po redu: 173*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO1 PO4` and `comp PO1 PO1 PO1 PO4`
have False
by auto

*)
(* po redu: 174*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note40 = this
*)
(* po redu: 175*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note39 and note40 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
*)
(* po redu: 176*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note41 = this
*)
(* po redu: 177*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note38 and note41 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 178*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note42 = this
*)
(* po redu: 179*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
*)
(* po redu: 180*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 181*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 182*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 183*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note43 = this
*)
(* po redu: 184*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 185*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

*)
(* po redu: 186*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
*)
(* po redu: 187*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO3 PL1` and `PO3 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 188*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note44 = this
*)
(* po redu: 189*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
*)
(* po redu: 190*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 191*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 192*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note45 = this
*)
(* po redu: 193*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 194*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

*)
(* po redu: 195*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO3 PO4"
using ax_D3a [of "PO1" "PO1" "PO3" "PL1" "PO4"]
by auto

*)
(* po redu: 196*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2`
have "comp PO1 PO1 PO3 PO4"
by auto

*)
(* po redu: 197*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO3 PO4` and `comp PO1 PO1 PO3 PO4`
have False
by auto

*)
(* po redu: 198*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note46 = this
*)
(* po redu: 199*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note45 and note46 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
*)
(* po redu: 200*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note47 = this
*)
(* po redu: 201*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note44 and note47 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 202*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note48 = this
*)
(* po redu: 203*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note43 and note48 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 204*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note49 = this
*)
(* po redu: 205*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note42 and note49 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 206*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note50 = this
*)
(* po redu: 207*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO2"
*)
(* po redu: 208*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

*)
(* po redu: 209*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO3"
*)
(* po redu: 210*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 211*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 212*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 213*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note51 = this
*)
(* po redu: 214*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 215*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 216*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 217*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 218*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note52 = this
*)
(* po redu: 219*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 220*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 221*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 222*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note53 = this
*)
(* po redu: 223*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 224*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

*)
(* po redu: 225*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO1`
have  "\<not>col PO1 PO1 PO2"
using ax_ncol_132 [of "PO1" "PO2" "PO1"]
by auto

*)
(* po redu: 226*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO1 PO2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO1 PO2 PO4"
using ax_D3a [of "PO1" "PO1" "PO2" "PL1" "PO4"]
by auto

*)
(* po redu: 227*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3`
have "comp PO1 PO2 PO1 PO4"
by auto

*)
(* po redu: 228*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `comp PO1 PO2 PO1 PO4`
have  "comp PO1 PO1 PO2 PO4"
using ax_comp_1324 [of "PO1" "PO2" "PO1" "PO4"]
by auto

*)
(* po redu: 229*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>comp PO1 PO1 PO2 PO4` and `comp PO1 PO1 PO2 PO4`
have False
by auto

*)
(* po redu: 230*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note54 = this
*)
(* po redu: 231*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note53 and note54 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
*)
(* po redu: 232*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note55 = this
*)
(* po redu: 233*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note52 and note55 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 234*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note56 = this
*)
(* po redu: 235*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note51 and note56 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 236*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note57 = this
*)
(* po redu: 237*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO3"
*)
(* po redu: 238*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

*)
(* po redu: 239*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 = PO4"
*)
(* po redu: 240*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO1 PL1` and `PO1 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 241*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note58 = this
*)
(* po redu: 242*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO1 ~= PO4"
*)
(* po redu: 243*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

*)
(* po redu: 244*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO3"
*)
(* po redu: 245*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 246*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 247*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 248*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note59 = this
*)
(* po redu: 249*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 250*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

*)
(* po redu: 251*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
*)
(* po redu: 252*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)

from this
have ?thesis
by auto
} note note60 = this
*)
(* po redu: 253*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
*)
(* po redu: 254*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

*)
(* po redu: 255*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO2` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO2 PO2 PO4"
using ax_D3a [of "PO1" "PO2" "PO2" "PL1" "PO4"]
by auto

*)
(* po redu: 256*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3`
have "comp PO1 PO2 PO2 PO4"
by auto

*)
(* po redu: 257*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover
from `\<not>comp PO1 PO2 PO2 PO4` and `comp PO1 PO2 PO2 PO4`
have False
by auto

*)
(* po redu: 258*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note61 = this
*)
(* po redu: 259*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note60 and note61 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
*)
(* po redu: 260*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note62 = this
*)
(* po redu: 261*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note59 and note62 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 262*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note63 = this
*)
(* po redu: 263*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO3"
*)
(* po redu: 264*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

*)
(* po redu: 265*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 = PO4"
*)
(* po redu: 266*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO2 PL1` and `PO2 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 267*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note64 = this
*)
(* po redu: 268*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO2 ~= PO4"
*)
(* po redu: 269*)
(* NIJE RELEVANTAN *)  (*
(*REGULAR*)
moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

*)
(* po redu: 270*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 = PO4"
*)
(* po redu: 271*)
(* NIJE RELEVANTAN *)  (*
(*EQCONTRADICTION*)
moreover
from `inc_po_pl PO3 PL1` and `PO3 = PO4`
have "inc_po_pl PO4 PL1"
by auto

*)
(* po redu: 272*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note65 = this
*)
(* po redu: 273*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH BEGIN*)
moreover 
{ assume "PO3 ~= PO4"
*)
(* po redu: 274*)
(*9*)  (*REGULAR*)
moreover

have  "inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1"
using ax_g5 [of "PO4" "PL1"]
by auto

(* po redu: 275*)
(*10*)  
(*BRANCH BEGIN*)
moreover 
{ assume "inc_po_pl PO4 PL1"
(* po redu: 276*)
(*11*)  (*BRANCH NAME*)

from this
have ?thesis
by auto
} note note66 = this
(* po redu: 277*)
(*12*)  
(*BRANCH BEGIN*)
moreover 
{ assume "\<not>inc_po_pl PO4 PL1"
(* po redu: 278*)
(*13*)  (*REGULAR*)
moreover
from `\<not>col PO1 PO2 PO3` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `\<not>inc_po_pl PO4 PL1`
have  "\<not>comp PO1 PO2 PO3 PO4"
using ax_D3a [of "PO1" "PO2" "PO3" "PL1" "PO4"]
by auto

(* po redu: 279*)
(*14*)  (*REGULAR*)
moreover
from `\<not>comp PO1 PO2 PO3 PO4` and `comp PO1 PO2 PO3 PO4`
have False
by auto

(* po redu: 280*)
(*15*)  (*BRANCH NAME*)
} note note67 = this
(* po redu: 281*)
(*16*)  
(*BRANCH END*)
from note66 and note67 and `inc_po_pl PO4 PL1 \<or> \<not>inc_po_pl PO4 PL1`
have ?thesis
by auto
(* po redu: 282*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note68 = this
*)
(* po redu: 283*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note65 and note68 and `PO3 = PO4 \<or> PO3 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 284*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note69 = this
*)
(* po redu: 285*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note64 and note69 and `PO2 = PO4 \<or> PO2 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 286*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note70 = this
*)
(* po redu: 287*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note63 and note70 and `PO2 = PO3 \<or> PO2 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 288*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note71 = this
*)
(* po redu: 289*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note58 and note71 and `PO1 = PO4 \<or> PO1 ~= PO4`
have ?thesis
by auto
*)
(* po redu: 290*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note72 = this
*)
(* po redu: 291*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note57 and note72 and `PO1 = PO3 \<or> PO1 ~= PO3`
have ?thesis
by auto
*)
(* po redu: 292*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note73 = this
*)
(* po redu: 293*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note50 and note73 and `PO1 = PO2 \<or> PO1 ~= PO2`
have ?thesis
by auto
*)
(* po redu: 294*)
(* NIJE RELEVANTAN *)  (*
(*BRANCH NAME*)
} note note74 = this
*)
(* po redu: 295*)
(* NIJE RELEVANTAN *)  (*

(*BRANCH END*)
from note37 and note74 and `int_pl_pl PL1 PL1 \<or> \<not>int_pl_pl PL1 PL1`
have ?thesis
by auto
*)
from this
show ?thesis
by auto
qed
