theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"


lemma ax_I3b_1:
shows " \<exists>  (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3"
proof -

(*1*)  
obtain  PO2::point and  PO3::point and  PO4::point
where "\<not>col PO2 PO3 PO4"
using ax_I3b by auto

(*2*)  moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(*3*)  moreover 
{ assume "PO1 = PO2"
(*4*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO1 = PO2`
have "\<not>col PO1 PO3 PO4"
by auto

(*5*)  
ultimately
have ?thesis
by auto
} note note1 = this
(*6*)  moreover 
{ assume "PO1 ~= PO2"
(*7*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*8*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*9*)  moreover 
{ assume "PO1 = PO3"
(*10*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO1 = PO3`
have "\<not>col PO2 PO1 PO4"
by auto

(*11*)  moreover
from `\<not>col PO2 PO1 PO4`
have  "\<not>col PO1 PO2 PO4"
using ax_ncol_213 by auto

(*12*)  
ultimately
have ?thesis
by auto
} note note2 = this
(*13*)  moreover 
{ assume "PO1 ~= PO3"
(*14*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*15*)  moreover 
{ assume "PO2 = PO3"
(*16*)  moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(*17*)  moreover 
{ assume "PO1 = PO4"
(*18*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO3` and `PO1 = PO4`
have "\<not>col PO2 PO2 PO1"
by auto

(*19*)  moreover
from `\<not>col PO2 PO2 PO1`
have  "\<not>col PO2 PO1 PO2"
using ax_ncol_231 by auto

(*20*)  
ultimately
have ?thesis
by auto
} note note3 = this
(*21*)  moreover 
{ assume "PO1 ~= PO4"
(*22*)  moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(*23*)  moreover 
{ assume "PO2 = PO4"
(*24*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO3` and `PO2 = PO4`
have "\<not>col PO2 PO2 PO2"
by auto

(*25*)  moreover
from `\<not>col PO2 PO2 PO2`
obtain  PL1::plane
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1"
using ax_I4a [of "PO2" "PO2" "PO2"]
by auto

(*26*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*27*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*28*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*29*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(*30*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO3` and `PO2 = PO4`
have "\<not>col PO2 PO2 PO2"
by auto

(*31*)  moreover
from `col PO2 PO2 PO2` and `\<not>col PO2 PO2 PO2`
have False
by auto

(*32*)  
ultimately
have False
by auto
} note note4 = this
(*33*)  moreover 
{ assume "PO2 ~= PO4"
(*34*)  moreover
from `PO1 ~= PO4`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO4 LI2"
using ax_I1 [of "PO1" "PO4"]
by auto

(*35*)  moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(*36*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO3`
have "\<not>col PO2 PO2 PO4"
by auto

(*37*)  moreover
from `\<not>col PO2 PO2 PO4`
obtain  PL1::plane
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO2" "PO2" "PO4"]
by auto

(*38*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*39*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*40*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*41*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(*42*)  moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(*43*)  moreover 
{ assume "int_l_l LI1 LI1"
(*44*)  moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(*45*)  moreover 
{ assume "inc_po_l PO4 LI1"
(*46*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI1" "PO1" "PO4"]
by auto

(*47*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

(*48*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI1" "PO4" "PO4"]
by auto

(*49*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI1" "PO2" "PO4"]
by auto

(*50*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO3`
have "\<not>col PO2 PO2 PO4"
by auto

(*51*)  moreover
from `col PO2 PO2 PO4` and `\<not>col PO2 PO2 PO4`
have False
by auto

(*52*)  
ultimately
have False
by auto
} note note5 = this
(*53*)  moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(*54*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO4 LI1`
have  "\<not>col PO1 PO2 PO4"
using ax_D1a [of "PO1" "PO2" "LI1" "PO4"]
by auto

(*55*)  
ultimately
have ?thesis
by auto
} note note6 = this
(*56*)  from note5 and note6 and `inc_po_l PO4 LI1 | \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(*57*)  
ultimately
have ?thesis
by auto
} note note7 = this
(*58*)  moreover 
{ assume "\<not>int_l_l LI1 LI1"
(*59*)  moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(*60*)  moreover 
{ assume "inc_po_l PO4 LI1"
(*61*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI1" "PO1" "PO4"]
by auto

(*62*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

(*63*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI1" "PO4" "PO4"]
by auto

(*64*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI1" "PO2" "PO4"]
by auto

(*65*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO3`
have "\<not>col PO2 PO2 PO4"
by auto

(*66*)  moreover
from `col PO2 PO2 PO4` and `\<not>col PO2 PO2 PO4`
have False
by auto

(*67*)  
ultimately
have False
by auto
} note note8 = this
(*68*)  moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(*69*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO4 LI1`
have  "\<not>col PO1 PO2 PO4"
using ax_D1a [of "PO1" "PO2" "LI1" "PO4"]
by auto

(*70*)  
ultimately
have ?thesis
by auto
} note note9 = this
(*71*)  from note8 and note9 and `inc_po_l PO4 LI1 | \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(*72*)  
ultimately
have ?thesis
by auto
} note note10 = this
(*73*)  from note7 and note10 and `int_l_l LI1 LI1 | \<not>int_l_l LI1 LI1`
have ?thesis
by auto
(*74*)  
ultimately
have ?thesis
by auto
} note note11 = this
(*75*)  from note4 and note11 and `PO2 = PO4 | PO2 ~= PO4`
have ?thesis
by auto
(*76*)  
ultimately
have ?thesis
by auto
} note note12 = this
(*77*)  from note3 and note12 and `PO1 = PO4 | PO1 ~= PO4`
have ?thesis
by auto
(*78*)  
ultimately
have ?thesis
by auto
} note note13 = this
(*79*)  moreover 
{ assume "PO2 ~= PO3"
(*80*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*81*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*82*)  moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(*83*)  moreover 
{ assume "PO1 = PO4"
(*84*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO1 = PO4`
have "\<not>col PO2 PO3 PO1"
by auto

(*85*)  moreover
from `\<not>col PO2 PO3 PO1`
have  "\<not>col PO3 PO1 PO2"
using ax_ncol_231 by auto

(*86*)  
ultimately
have ?thesis
by auto
} note note14 = this
(*87*)  moreover 
{ assume "PO1 ~= PO4"
(*88*)  moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(*89*)  moreover 
{ assume "PO2 = PO4"
(*90*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO4`
have "\<not>col PO2 PO3 PO2"
by auto

(*91*)  moreover
from `\<not>col PO2 PO3 PO2`
have  "\<not>col PO2 PO2 PO3"
using ax_ncol_132 by auto

(*92*)  moreover
from `\<not>col PO2 PO2 PO3`
obtain  PL1::plane
where "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1"
using ax_I4a [of "PO2" "PO2" "PO3"]
by auto

(*93*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*94*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*95*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*96*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(*97*)  moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(*98*)  moreover 
{ assume "int_l_l LI1 LI1"
(*99*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*100*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*101*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*102*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*103*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(*104*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(*105*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO4`
have "\<not>col PO2 PO3 PO2"
by auto

(*106*)  moreover
from `\<not>col PO2 PO3 PO2`
have  "\<not>col PO2 PO2 PO3"
using ax_ncol_132 by auto

(*107*)  moreover
from `col PO2 PO2 PO3` and `\<not>col PO2 PO2 PO3`
have False
by auto

(*108*)  
ultimately
have False
by auto
} note note15 = this
(*109*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*110*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO1 PO2 PO3"
using ax_D1a [of "PO1" "PO2" "LI1" "PO3"]
by auto

(*111*)  
ultimately
have ?thesis
by auto
} note note16 = this
(*112*)  from note15 and note16 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*113*)  
ultimately
have ?thesis
by auto
} note note17 = this
(*114*)  moreover 
{ assume "\<not>int_l_l LI1 LI1"
(*115*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*116*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*117*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*118*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*119*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(*120*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(*121*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO2 = PO4`
have "\<not>col PO2 PO3 PO2"
by auto

(*122*)  moreover
from `\<not>col PO2 PO3 PO2`
have  "\<not>col PO2 PO2 PO3"
using ax_ncol_132 by auto

(*123*)  moreover
from `col PO2 PO2 PO3` and `\<not>col PO2 PO2 PO3`
have False
by auto

(*124*)  
ultimately
have False
by auto
} note note18 = this
(*125*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*126*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO1 PO2 PO3"
using ax_D1a [of "PO1" "PO2" "LI1" "PO3"]
by auto

(*127*)  
ultimately
have ?thesis
by auto
} note note19 = this
(*128*)  from note18 and note19 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*129*)  
ultimately
have ?thesis
by auto
} note note20 = this
(*130*)  from note17 and note20 and `int_l_l LI1 LI1 | \<not>int_l_l LI1 LI1`
have ?thesis
by auto
(*131*)  
ultimately
have ?thesis
by auto
} note note21 = this
(*132*)  moreover 
{ assume "PO2 ~= PO4"
(*133*)  moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(*134*)  moreover 
{ assume "PO3 = PO4"
(*135*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO3 = PO4`
have "\<not>col PO2 PO3 PO3"
by auto

(*136*)  moreover
from `\<not>col PO2 PO3 PO3`
obtain  PL1::plane
where "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO3 PL1"
using ax_I4a [of "PO2" "PO3" "PO3"]
by auto

(*137*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*138*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*139*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*140*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(*141*)  moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(*142*)  moreover 
{ assume "int_l_l LI1 LI1"
(*143*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*144*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*145*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*146*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*147*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(*148*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(*149*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

(*150*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO3 = PO4`
have "\<not>col PO2 PO3 PO3"
by auto

(*151*)  moreover
from `col PO2 PO3 PO3` and `\<not>col PO2 PO3 PO3`
have False
by auto

(*152*)  
ultimately
have False
by auto
} note note22 = this
(*153*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*154*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO1 PO2 PO3"
using ax_D1a [of "PO1" "PO2" "LI1" "PO3"]
by auto

(*155*)  
ultimately
have ?thesis
by auto
} note note23 = this
(*156*)  from note22 and note23 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*157*)  
ultimately
have ?thesis
by auto
} note note24 = this
(*158*)  moreover 
{ assume "\<not>int_l_l LI1 LI1"
(*159*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*160*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*161*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*162*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*163*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(*164*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(*165*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

(*166*)  moreover
from `\<not>col PO2 PO3 PO4` and `PO3 = PO4`
have "\<not>col PO2 PO3 PO3"
by auto

(*167*)  moreover
from `col PO2 PO3 PO3` and `\<not>col PO2 PO3 PO3`
have False
by auto

(*168*)  
ultimately
have False
by auto
} note note25 = this
(*169*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*170*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO1 PO2 PO3"
using ax_D1a [of "PO1" "PO2" "LI1" "PO3"]
by auto

(*171*)  
ultimately
have ?thesis
by auto
} note note26 = this
(*172*)  from note25 and note26 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*173*)  
ultimately
have ?thesis
by auto
} note note27 = this
(*174*)  from note24 and note27 and `int_l_l LI1 LI1 | \<not>int_l_l LI1 LI1`
have ?thesis
by auto
(*175*)  
ultimately
have ?thesis
by auto
} note note28 = this
(*176*)  moreover 
{ assume "PO3 ~= PO4"
(*177*)  moreover
from `PO1 ~= PO4`
obtain  LI4::line
where "inc_po_l PO1 LI4" and "inc_po_l PO4 LI4"
using ax_I1 [of "PO1" "PO4"]
by auto

(*178*)  moreover
from `PO2 ~= PO4`
obtain  LI5::line
where "inc_po_l PO2 LI5" and "inc_po_l PO4 LI5"
using ax_I1 [of "PO2" "PO4"]
by auto

(*179*)  moreover
from `PO3 ~= PO4`
obtain  LI6::line
where "inc_po_l PO3 LI6" and "inc_po_l PO4 LI6"
using ax_I1 [of "PO3" "PO4"]
by auto

(*180*)  moreover
from `\<not>col PO2 PO3 PO4`
obtain  PL1::plane
where "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO4 PL1"
using ax_I4a [of "PO2" "PO3" "PO4"]
by auto

(*181*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*182*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*183*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*184*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(*185*)  moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(*186*)  moreover 
{ assume "int_l_l LI1 LI1"
(*187*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*188*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*189*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*190*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*191*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(*192*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(*193*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

(*194*)  moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

(*195*)  moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(*196*)  moreover 
{ assume "inc_po_l PO4 LI1"
(*197*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI1" "PO1" "PO4"]
by auto

(*198*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

(*199*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI1" "PO3" "PO4"]
by auto

(*200*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI1" "PO4" "PO4"]
by auto

(*201*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI1" "PO2" "PO4"]
by auto

(*202*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO4 LI1`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI1" "PO3" "PO4"]
by auto

(*203*)  moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(*204*)  
ultimately
have False
by auto
} note note29 = this
(*205*)  moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(*206*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO4 LI1`
have  "\<not>col PO1 PO2 PO4"
using ax_D1a [of "PO1" "PO2" "LI1" "PO4"]
by auto

(*207*)  
ultimately
have ?thesis
by auto
} note note30 = this
(*208*)  from note29 and note30 and `inc_po_l PO4 LI1 | \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(*209*)  
ultimately
have ?thesis
by auto
} note note31 = this
(*210*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*211*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO1 PO2 PO3"
using ax_D1a [of "PO1" "PO2" "LI1" "PO3"]
by auto

(*212*)  
ultimately
have ?thesis
by auto
} note note32 = this
(*213*)  from note31 and note32 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*214*)  
ultimately
have ?thesis
by auto
} note note33 = this
(*215*)  moreover 
{ assume "\<not>int_l_l LI1 LI1"
(*216*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*217*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*218*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*219*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*220*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(*221*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI1" "PO2" "PO3"]
by auto

(*222*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI1" "PO3" "PO3"]
by auto

(*223*)  moreover
from `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI1" "PO3" "PO3"]
by auto

(*224*)  moreover

have  "inc_po_l PO4 LI1 \<or> \<not>inc_po_l PO4 LI1"
using ax_g4 [of "PO4" "LI1"]
by auto

(*225*)  moreover 
{ assume "inc_po_l PO4 LI1"
(*226*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO1 PO4"
using ax_D1 [of "PO1" "LI1" "PO1" "PO4"]
by auto

(*227*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO2 PO4"
using ax_D1 [of "PO1" "LI1" "PO2" "PO4"]
by auto

(*228*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO3 PO4"
using ax_D1 [of "PO1" "LI1" "PO3" "PO4"]
by auto

(*229*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO4 LI1` and `inc_po_l PO4 LI1`
have  "col PO1 PO4 PO4"
using ax_D1 [of "PO1" "LI1" "PO4" "PO4"]
by auto

(*230*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO4 LI1`
have  "col PO2 PO2 PO4"
using ax_D1 [of "PO2" "LI1" "PO2" "PO4"]
by auto

(*231*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO4 LI1`
have  "col PO2 PO3 PO4"
using ax_D1 [of "PO2" "LI1" "PO3" "PO4"]
by auto

(*232*)  moreover
from `col PO2 PO3 PO4` and `\<not>col PO2 PO3 PO4`
have False
by auto

(*233*)  
ultimately
have False
by auto
} note note34 = this
(*234*)  moreover 
{ assume "\<not>inc_po_l PO4 LI1"
(*235*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO4 LI1`
have  "\<not>col PO1 PO2 PO4"
using ax_D1a [of "PO1" "PO2" "LI1" "PO4"]
by auto

(*236*)  
ultimately
have ?thesis
by auto
} note note35 = this
(*237*)  from note34 and note35 and `inc_po_l PO4 LI1 | \<not>inc_po_l PO4 LI1`
have ?thesis
by auto
(*238*)  
ultimately
have ?thesis
by auto
} note note36 = this
(*239*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*240*)  moreover
from `PO1 ~= PO2` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO1 PO2 PO3"
using ax_D1a [of "PO1" "PO2" "LI1" "PO3"]
by auto

(*241*)  
ultimately
have ?thesis
by auto
} note note37 = this
(*242*)  from note36 and note37 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*243*)  
ultimately
have ?thesis
by auto
} note note38 = this
(*244*)  from note33 and note38 and `int_l_l LI1 LI1 | \<not>int_l_l LI1 LI1`
have ?thesis
by auto
(*245*)  
ultimately
have ?thesis
by auto
} note note39 = this
(*246*)  from note28 and note39 and `PO3 = PO4 | PO3 ~= PO4`
have ?thesis
by auto
(*247*)  
ultimately
have ?thesis
by auto
} note note40 = this
(*248*)  from note21 and note40 and `PO2 = PO4 | PO2 ~= PO4`
have ?thesis
by auto
(*249*)  
ultimately
have ?thesis
by auto
} note note41 = this
(*250*)  from note14 and note41 and `PO1 = PO4 | PO1 ~= PO4`
have ?thesis
by auto
(*251*)  
ultimately
have ?thesis
by auto
} note note42 = this
(*252*)  from note13 and note42 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*253*)  
ultimately
have ?thesis
by auto
} note note43 = this
(*254*)  from note2 and note43 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*255*)  
ultimately
have ?thesis
by auto
} note note44 = this
(*256*)  from note1 and note44 and `PO1 = PO2 | PO1 ~= PO2`
have ?thesis
by auto
ultimately 
show ?thesis
by auto
qed
