theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"


lemma ax_I3a_1:
assumes "inc_po_l PO1 LI1"
shows " \<exists>  (PO2::point). PO1 ~= PO2 & inc_po_l PO2 LI1"
proof -

(*1*)  
obtain  PO2::point and  PO3::point
where "inc_po_l PO2 LI1" and "PO2 ~= PO3" and "inc_po_l PO3 LI1"
using ax_I3a [of "LI1"]
by auto

(*2*)  moreover

have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(*3*)  moreover 
{ assume "PO1 = PO2"
(*4*)  moreover
from `PO2 ~= PO3` and `PO1 = PO2`
have "PO1 ~= PO3"
by auto

(*5*)  moreover 
from `PO1 ~= PO3` and `inc_po_l PO3 LI1`
have ?thesis
by auto
(*6*)  
ultimately
have ?thesis
by auto
} note note2 = this
(*7*)  moreover 
{ assume "PO1 ~= PO2"
(*8*)  moreover 
from `PO1 ~= PO2` and `inc_po_l PO2 LI1`
have ?thesis
by auto
(*9*)  
from this
have ?thesis
by auto
} note note3 = this
(*10*)  from note2 and note3 and `PO1 = PO2 | PO1 ~= PO2`
have ?thesis
by auto
ultimately 
show ?thesis
by auto
qed
