theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"


lemma sim_lemma_comp_11:
assumes "comp PO1 PO2 PO3 PO4"
shows "comp PO2 PO1 PO3 PO4"
proof -

(*1*)  
have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(*2*)  moreover 
{ assume "PO1 = PO2"
(*3*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2`
have "comp PO1 PO1 PO3 PO4"
by auto

(*4*)  moreover
from `comp PO1 PO1 PO3 PO4` and `PO1 = PO2`
have "comp PO2 PO1 PO3 PO4"
by auto

(*5*)  
ultimately
have ?thesis
by auto
} note note1 = this
(*6*)  moreover 
{ assume "PO1 ~= PO2"
(*7*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*8*)  moreover 
{ assume "PO1 = PO3"
(*9*)  moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(*10*)  moreover 
{ assume "PO1 = PO4"
(*11*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3` and `PO1 = PO4`
have "comp PO1 PO2 PO1 PO1"
by auto

(*12*)  moreover
from `comp PO1 PO2 PO1 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1"
using ax_D4 [of "PO1" "PO2" "PO1" "PO1"]
by auto

(*13*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*14*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*15*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*16*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*17*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*18*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*19*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*20*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*21*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*22*)  moreover
from `comp PO2 PO1 PO1 PO1` and `PO1 = PO3` and `PO1 = PO4`
have "comp PO2 PO1 PO3 PO4"
by auto

(*23*)  
ultimately
have ?thesis
by auto
} note note2 = this
(*24*)  moreover 
{ assume "PO1 ~= PO4"
(*25*)  moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(*26*)  moreover 
{ assume "PO2 = PO4"
(*27*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3` and `PO2 = PO4`
have "comp PO1 PO2 PO1 PO2"
by auto

(*28*)  moreover
from `comp PO1 PO2 PO1 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1"
using ax_D4 [of "PO1" "PO2" "PO1" "PO2"]
by auto

(*29*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*30*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*31*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*32*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*33*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*34*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*35*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*36*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*37*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*38*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*39*)  moreover
from `comp PO2 PO1 PO1 PO2` and `PO1 = PO3` and `PO2 = PO4`
have "comp PO2 PO1 PO3 PO4"
by auto

(*40*)  
ultimately
have ?thesis
by auto
} note note3 = this
(*41*)  moreover 
{ assume "PO2 ~= PO4"
(*42*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3`
have "comp PO1 PO2 PO1 PO4"
by auto

(*43*)  moreover
from `comp PO1 PO2 PO1 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO4 PL1"
using ax_D4 [of "PO1" "PO2" "PO1" "PO4"]
by auto

(*44*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*45*)  moreover
from `PO1 ~= PO4`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO4 LI2"
using ax_I1 [of "PO1" "PO4"]
by auto

(*46*)  moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(*47*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*48*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*49*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(*50*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*51*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*52*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(*53*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO1"]
by auto

(*54*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO2"]
by auto

(*55*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(*56*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*57*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*58*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*59*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*60*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(*61*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO1"]
by auto

(*62*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO2"]
by auto

(*63*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(*64*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO1"]
by auto

(*65*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO2"]
by auto

(*66*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO4"]
by auto

(*67*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO1"]
by auto

(*68*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO2"]
by auto

(*69*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO4"]
by auto

(*70*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO1"]
by auto

(*71*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO2"]
by auto

(*72*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(*73*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*74*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*75*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO4"]
by auto

(*76*)  moreover
from `comp PO2 PO1 PO1 PO4` and `PO1 = PO3`
have "comp PO2 PO1 PO3 PO4"
by auto

(*77*)  
ultimately
have ?thesis
by auto
} note note4 = this
(*78*)  from note3 and note4 and `PO2 = PO4 | PO2 ~= PO4`
have ?thesis
by auto
(*79*)  
ultimately
have ?thesis
by auto
} note note5 = this
(*80*)  from note2 and note5 and `PO1 = PO4 | PO1 ~= PO4`
have ?thesis
by auto
(*81*)  
ultimately
have ?thesis
by auto
} note note6 = this
(*82*)  moreover 
{ assume "PO1 ~= PO3"
(*83*)  moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(*84*)  moreover 
{ assume "PO1 = PO4"
(*85*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*86*)  moreover 
{ assume "PO2 = PO3"
(*87*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3` and `PO1 = PO4`
have "comp PO1 PO2 PO2 PO1"
by auto

(*88*)  moreover
from `comp PO1 PO2 PO2 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1"
using ax_D4 [of "PO1" "PO2" "PO2" "PO1"]
by auto

(*89*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*90*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*91*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*92*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*93*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*94*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*95*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*96*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*97*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*98*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*99*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*100*)  moreover
from `comp PO2 PO1 PO2 PO1` and `PO2 = PO3` and `PO1 = PO4`
have "comp PO2 PO1 PO3 PO4"
by auto

(*101*)  
ultimately
have ?thesis
by auto
} note note7 = this
(*102*)  moreover 
{ assume "PO2 ~= PO3"
(*103*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO4`
have "comp PO1 PO2 PO3 PO1"
by auto

(*104*)  moreover
from `comp PO1 PO2 PO3 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO1 PL1"
using ax_D4 [of "PO1" "PO2" "PO3" "PO1"]
by auto

(*105*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*106*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*107*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*108*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*109*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*110*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*111*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*112*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*113*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(*114*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*115*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO2"]
by auto

(*116*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*117*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*118*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*119*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO3"]
by auto

(*120*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*121*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*122*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(*123*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO2"]
by auto

(*124*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(*125*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*126*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO2"]
by auto

(*127*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*128*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO1"]
by auto

(*129*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO2"]
by auto

(*130*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO3"]
by auto

(*131*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*132*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO2"]
by auto

(*133*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*134*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*135*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*136*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO3"]
by auto

(*137*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*138*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*139*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO3"]
by auto

(*140*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO1"]
by auto

(*141*)  moreover
from `comp PO2 PO1 PO3 PO1` and `PO1 = PO4`
have "comp PO2 PO1 PO3 PO4"
by auto

(*142*)  
ultimately
have ?thesis
by auto
} note note8 = this
(*143*)  from note7 and note8 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*144*)  
ultimately
have ?thesis
by auto
} note note9 = this
(*145*)  moreover 
{ assume "PO1 ~= PO4"
(*146*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*147*)  moreover 
{ assume "PO2 = PO3"
(*148*)  moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(*149*)  moreover 
{ assume "PO2 = PO4"
(*150*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3` and `PO2 = PO4`
have "comp PO1 PO2 PO2 PO2"
by auto

(*151*)  moreover
from `comp PO1 PO2 PO2 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1"
using ax_D4 [of "PO1" "PO2" "PO2" "PO2"]
by auto

(*152*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*153*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*154*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*155*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*156*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*157*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*158*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*159*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*160*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*161*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*162*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*163*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*164*)  moreover
from `comp PO2 PO1 PO2 PO2` and `PO2 = PO3` and `PO2 = PO4`
have "comp PO2 PO1 PO3 PO4"
by auto

(*165*)  
ultimately
have ?thesis
by auto
} note note10 = this
(*166*)  moreover 
{ assume "PO2 ~= PO4"
(*167*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3`
have "comp PO1 PO2 PO2 PO4"
by auto

(*168*)  moreover
from `comp PO1 PO2 PO2 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO4 PL1"
using ax_D4 [of "PO1" "PO2" "PO2" "PO4"]
by auto

(*169*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*170*)  moreover
from `PO1 ~= PO4`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO4 LI2"
using ax_I1 [of "PO1" "PO4"]
by auto

(*171*)  moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(*172*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*173*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*174*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(*175*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*176*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*177*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(*178*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO1"]
by auto

(*179*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO2"]
by auto

(*180*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(*181*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*182*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*183*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO4"]
by auto

(*184*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*185*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*186*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO1"]
by auto

(*187*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO2"]
by auto

(*188*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(*189*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO1"]
by auto

(*190*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO2"]
by auto

(*191*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO4"]
by auto

(*192*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO1"]
by auto

(*193*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO2"]
by auto

(*194*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO4"]
by auto

(*195*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO1"]
by auto

(*196*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO2"]
by auto

(*197*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(*198*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*199*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*200*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO4"]
by auto

(*201*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*202*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*203*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO4"]
by auto

(*204*)  moreover
from `comp PO2 PO1 PO2 PO4` and `PO2 = PO3`
have "comp PO2 PO1 PO3 PO4"
by auto

(*205*)  
ultimately
have ?thesis
by auto
} note note11 = this
(*206*)  from note10 and note11 and `PO2 = PO4 | PO2 ~= PO4`
have ?thesis
by auto
(*207*)  
ultimately
have ?thesis
by auto
} note note12 = this
(*208*)  moreover 
{ assume "PO2 ~= PO3"
(*209*)  moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(*210*)  moreover 
{ assume "PO2 = PO4"
(*211*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO4`
have "comp PO1 PO2 PO3 PO2"
by auto

(*212*)  moreover
from `comp PO1 PO2 PO3 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO2 PL1"
using ax_D4 [of "PO1" "PO2" "PO3" "PO2"]
by auto

(*213*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*214*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*215*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*216*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*217*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*218*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*219*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*220*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*221*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(*222*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*223*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO2"]
by auto

(*224*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*225*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*226*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*227*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO3"]
by auto

(*228*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*229*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*230*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(*231*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO1"]
by auto

(*232*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(*233*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*234*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO2"]
by auto

(*235*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*236*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO1"]
by auto

(*237*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO2"]
by auto

(*238*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO3"]
by auto

(*239*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*240*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO2"]
by auto

(*241*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*242*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*243*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*244*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO3"]
by auto

(*245*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*246*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*247*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO3"]
by auto

(*248*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO1"]
by auto

(*249*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO2"]
by auto

(*250*)  moreover
from `comp PO2 PO1 PO3 PO2` and `PO2 = PO4`
have "comp PO2 PO1 PO3 PO4"
by auto

(*251*)  
ultimately
have ?thesis
by auto
} note note13 = this
(*252*)  moreover 
{ assume "PO2 ~= PO4"
(*253*)  moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(*254*)  moreover 
{ assume "PO3 = PO4"
(*255*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO3 = PO4`
have "comp PO1 PO2 PO3 PO3"
by auto

(*256*)  moreover
from `comp PO1 PO2 PO3 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO3 PL1"
using ax_D4 [of "PO1" "PO2" "PO3" "PO3"]
by auto

(*257*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*258*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*259*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*260*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*261*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*262*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*263*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*264*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*265*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(*266*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*267*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO2"]
by auto

(*268*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*269*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*270*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*271*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO3"]
by auto

(*272*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*273*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*274*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(*275*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO1"]
by auto

(*276*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO2"]
by auto

(*277*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*278*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO2"]
by auto

(*279*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*280*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO1"]
by auto

(*281*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO2"]
by auto

(*282*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO3"]
by auto

(*283*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*284*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO2"]
by auto

(*285*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*286*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*287*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*288*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO3"]
by auto

(*289*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*290*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*291*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO3"]
by auto

(*292*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO1"]
by auto

(*293*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO2"]
by auto

(*294*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO3"]
by auto

(*295*)  moreover
from `comp PO2 PO1 PO3 PO3` and `PO3 = PO4`
have "comp PO2 PO1 PO3 PO4"
by auto

(*296*)  
ultimately
have ?thesis
by auto
} note note14 = this
(*297*)  moreover 
{ assume "PO3 ~= PO4"
(*298*)  moreover
from `comp PO1 PO2 PO3 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO4 PL1"
using ax_D4 [of "PO1" "PO2" "PO3" "PO4"]
by auto

(*299*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*300*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*301*)  moreover
from `PO1 ~= PO4`
obtain  LI3::line
where "inc_po_l PO1 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO1" "PO4"]
by auto

(*302*)  moreover
from `PO2 ~= PO3`
obtain  LI4::line
where "inc_po_l PO2 LI4" and "inc_po_l PO3 LI4"
using ax_I1 [of "PO2" "PO3"]
by auto

(*303*)  moreover
from `PO2 ~= PO4`
obtain  LI5::line
where "inc_po_l PO2 LI5" and "inc_po_l PO4 LI5"
using ax_I1 [of "PO2" "PO4"]
by auto

(*304*)  moreover
from `PO3 ~= PO4`
obtain  LI6::line
where "inc_po_l PO3 LI6" and "inc_po_l PO4 LI6"
using ax_I1 [of "PO3" "PO4"]
by auto

(*305*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*306*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*307*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*308*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(*309*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*310*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*311*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(*312*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(*313*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*314*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO2"]
by auto

(*315*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*316*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

(*317*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO1"]
by auto

(*318*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO2"]
by auto

(*319*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO3"]
by auto

(*320*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(*321*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*322*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*323*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO3"]
by auto

(*324*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO4"]
by auto

(*325*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*326*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*327*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(*328*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(*329*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO1"]
by auto

(*330*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO2"]
by auto

(*331*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(*332*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO1"]
by auto

(*333*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO2"]
by auto

(*334*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO3"]
by auto

(*335*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(*336*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*337*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO2"]
by auto

(*338*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*339*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO4"]
by auto

(*340*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO1"]
by auto

(*341*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO2"]
by auto

(*342*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO3"]
by auto

(*343*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO4"]
by auto

(*344*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*345*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO2"]
by auto

(*346*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*347*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(*348*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO1"]
by auto

(*349*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO2"]
by auto

(*350*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO3"]
by auto

(*351*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

(*352*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO1"]
by auto

(*353*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO2"]
by auto

(*354*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO4 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO3"]
by auto

(*355*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO4"]
by auto

(*356*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO1"]
by auto

(*357*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO2"]
by auto

(*358*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO4 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO3"]
by auto

(*359*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO4"]
by auto

(*360*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO3" "PO1"]
by auto

(*361*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO3" "PO2"]
by auto

(*362*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO4 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO4" "PO3" "PO3"]
by auto

(*363*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO3" "PO4"]
by auto

(*364*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO1"]
by auto

(*365*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO2"]
by auto

(*366*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO4 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO3"]
by auto

(*367*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(*368*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*369*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*370*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO3"]
by auto

(*371*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO4"]
by auto

(*372*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*373*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*374*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO3"]
by auto

(*375*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO4"]
by auto

(*376*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO1"]
by auto

(*377*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO2"]
by auto

(*378*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO3"]
by auto

(*379*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO4"]
by auto

(*380*)  
ultimately
have ?thesis
by auto
} note note15 = this
(*381*)  from note14 and note15 and `PO3 = PO4 | PO3 ~= PO4`
have ?thesis
by auto
(*382*)  
ultimately
have ?thesis
by auto
} note note16 = this
(*383*)  from note13 and note16 and `PO2 = PO4 | PO2 ~= PO4`
have ?thesis
by auto
(*384*)  
ultimately
have ?thesis
by auto
} note note17 = this
(*385*)  from note12 and note17 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*386*)  
ultimately
have ?thesis
by auto
} note note18 = this
(*387*)  from note9 and note18 and `PO1 = PO4 | PO1 ~= PO4`
have ?thesis
by auto
(*388*)  
ultimately
have ?thesis
by auto
} note note19 = this
(*389*)  from note6 and note19 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*390*)  
ultimately
have ?thesis
by auto
} note note20 = this
(*391*)  from note1 and note20 and `PO1 = PO2 | PO1 ~= PO2`
have ?thesis
by auto
ultimately 
show ?thesis
by auto
qed
