theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"


lemma sim_lemma_ncol_6:
assumes "\<not>col PO1 PO2 PO3"
shows "\<not>col PO2 PO3 PO1"
proof -

(*1*)  
have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(*2*)  moreover 
{ assume "PO1 = PO2"
(*3*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*4*)  moreover 
{ assume "PO1 = PO3"
(*5*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(*6*)  moreover
from `\<not>col PO1 PO1 PO1` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO2 PO3 PO1"
by auto

(*7*)  
ultimately
have ?thesis
by auto
} note note1 = this
(*8*)  moreover 
{ assume "PO1 ~= PO3"
(*9*)  moreover
from `PO1 ~= PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO3 LI1"
using ax_I1 [of "PO1" "PO3"]
by auto

(*10*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(*11*)  moreover
from `\<not>col PO1 PO1 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1"
using ax_I4a [of "PO1" "PO1" "PO3"]
by auto

(*12*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*13*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*14*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(*15*)  moreover
from `col PO1 PO1 PO3` and `\<not>col PO1 PO1 PO3`
have False
by auto

(*16*)  
ultimately
have False
by auto
} note note2 = this
(*17*)  from note1 and note2 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*18*)  
ultimately
have ?thesis
by auto
} note note3 = this
(*19*)  moreover 
{ assume "PO1 ~= PO2"
(*20*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*21*)  moreover 
{ assume "PO1 = PO3"
(*22*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*23*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(*24*)  moreover
from `\<not>col PO1 PO2 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1"
using ax_I4a [of "PO1" "PO2" "PO1"]
by auto

(*25*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*26*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*27*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*28*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(*29*)  moreover
from `col PO1 PO2 PO1` and `\<not>col PO1 PO2 PO1`
have False
by auto

(*30*)  
ultimately
have False
by auto
} note note4 = this
(*31*)  moreover 
{ assume "PO1 ~= PO3"
(*32*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*33*)  moreover 
{ assume "PO2 = PO3"
(*34*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*35*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(*36*)  moreover
from `\<not>col PO1 PO2 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1"
using ax_I4a [of "PO1" "PO2" "PO2"]
by auto

(*37*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*38*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*39*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*40*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*41*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(*42*)  moreover
from `col PO1 PO2 PO2` and `\<not>col PO1 PO2 PO2`
have False
by auto

(*43*)  
ultimately
have False
by auto
} note note5 = this
(*44*)  moreover 
{ assume "PO2 ~= PO3"
(*45*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*46*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*47*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*48*)  moreover
from `\<not>col PO1 PO2 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1"
using ax_I4a [of "PO1" "PO2" "PO3"]
by auto

(*49*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*50*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*51*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*52*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*53*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO2 PO1 PO1"
using ax_D1 [of "PO2" "LI1" "PO1" "PO1"]
by auto

(*54*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO1 PO2"
using ax_D1 [of "PO2" "LI1" "PO1" "PO2"]
by auto

(*55*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO2 PO2 PO1"
using ax_D1 [of "PO2" "LI1" "PO2" "PO1"]
by auto

(*56*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(*57*)  moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(*58*)  moreover 
{ assume "int_l_l LI1 LI1"
(*59*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*60*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*61*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*62*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*63*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*64*)  
ultimately
have False
by auto
} note note6 = this
(*65*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*66*)  moreover
from `PO1 ~= PO2`
have  "PO2 ~= PO1"
by auto

(*67*)  moreover
from `PO2 ~= PO1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO2 PO1 PO3"
using ax_D1a [of "PO2" "PO1" "LI1" "PO3"]
by auto

(*68*)  moreover
from `int_l_l LI1 LI1`
obtain  PO4::point
where "inc_po_l PO4 LI1" and "inc_po_l PO4 LI1" and "LI1 ~= LI1"
using ax_D6 [of "LI1" "LI1"]
by auto

(*69*)  moreover
from `LI1 ~= LI1`
have False
by auto

(*70*)  
ultimately
have False
by auto
} note note7 = this
(*71*)  from note6 and note7 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have False
by auto
(*72*)  
ultimately
have False
by auto
} note note8 = this
(*73*)  moreover 
{ assume "\<not>int_l_l LI1 LI1"
(*74*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*75*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*76*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*77*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*78*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*79*)  
ultimately
have False
by auto
} note note9 = this
(*80*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*81*)  moreover
from `PO1 ~= PO2`
have  "PO2 ~= PO1"
by auto

(*82*)  moreover
from `PO2 ~= PO1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO2 PO1 PO3"
using ax_D1a [of "PO2" "PO1" "LI1" "PO3"]
by auto

(*83*)  moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI2" "PO1" "PO3"]
by auto

(*84*)  moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2` and `inc_po_l PO1 LI2`
have  "col PO1 PO3 PO1"
using ax_D1 [of "PO1" "LI2" "PO3" "PO1"]
by auto

(*85*)  moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2` and `inc_po_l PO3 LI2`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI2" "PO3" "PO3"]
by auto

(*86*)  moreover
from `inc_po_l PO3 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO1 LI2`
have  "col PO3 PO1 PO1"
using ax_D1 [of "PO3" "LI2" "PO1" "PO1"]
by auto

(*87*)  moreover
from `inc_po_l PO3 LI2` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2`
have  "col PO3 PO1 PO3"
using ax_D1 [of "PO3" "LI2" "PO1" "PO3"]
by auto

(*88*)  moreover
from `inc_po_l PO3 LI2` and `inc_po_l PO3 LI2` and `inc_po_l PO1 LI2`
have  "col PO3 PO3 PO1"
using ax_D1 [of "PO3" "LI2" "PO3" "PO1"]
by auto

(*89*)  moreover
from `inc_po_l PO3 LI2` and `inc_po_l PO3 LI2` and `inc_po_l PO3 LI2`
have  "col PO3 PO3 PO3"
using ax_D1 [of "PO3" "LI2" "PO3" "PO3"]
by auto

(*90*)  moreover

have  "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"
using ax_D6a [of "LI1" "LI2"]
by auto

(*91*)  moreover 
{ assume "int_l_l LI1 LI2"
(*92*)  moreover

have  "int_l_l LI2 LI1 \<or> \<not>int_l_l LI2 LI1"
using ax_D6a [of "LI2" "LI1"]
by auto

(*93*)  moreover 
{ assume "int_l_l LI2 LI1"
(*94*)  moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(*95*)  moreover 
{ assume "int_l_l LI2 LI2"
(*96*)  moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

(*97*)  moreover 
{ assume "LI1 = LI2"
(*98*)  moreover
from `inc_po_l PO3 LI2` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI2`
have False
by auto

(*99*)  
ultimately
have False
by auto
} note note10 = this
(*100*)  moreover 
{ assume "LI1 ~= LI2"
(*101*)  moreover

have  "inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2"
using ax_g4 [of "PO2" "LI2"]
by auto

(*102*)  moreover 
{ assume "inc_po_l PO2 LI2"
(*103*)  moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO2 LI2` and `inc_po_l PO3 LI2`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI2" "PO2" "PO3"]
by auto

(*104*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*105*)  
ultimately
have False
by auto
} note note11 = this
(*106*)  moreover 
{ assume "\<not>inc_po_l PO2 LI2"
(*107*)  moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO3 PO2"
using ax_D1a [of "PO1" "PO3" "LI2" "PO2"]
by auto

(*108*)  moreover
from `PO1 ~= PO3`
have  "PO3 ~= PO1"
by auto

(*109*)  moreover
from `PO3 ~= PO1` and `inc_po_l PO3 LI2` and `inc_po_l PO1 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO3 PO1 PO2"
using ax_D1a [of "PO3" "PO1" "LI2" "PO2"]
by auto

(*110*)  moreover
from `int_l_l LI2 LI2`
obtain  PO4::point
where "inc_po_l PO4 LI2" and "inc_po_l PO4 LI2" and "LI2 ~= LI2"
using ax_D6 [of "LI2" "LI2"]
by auto

(*111*)  moreover
from `LI2 ~= LI2`
have False
by auto

(*112*)  
ultimately
have False
by auto
} note note12 = this
(*113*)  from note11 and note12 and `inc_po_l PO2 LI2 | \<not>inc_po_l PO2 LI2`
have False
by auto
(*114*)  
ultimately
have False
by auto
} note note13 = this
(*115*)  from note10 and note13 and `LI1 = LI2 | LI1 ~= LI2`
have False
by auto
(*116*)  
ultimately
have False
by auto
} note note14 = this
(*117*)  moreover 
{ assume "\<not>int_l_l LI2 LI2"
(*118*)  moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

(*119*)  moreover 
{ assume "LI1 = LI2"
(*120*)  moreover
from `inc_po_l PO3 LI2` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI2`
have False
by auto

(*121*)  
ultimately
have False
by auto
} note note15 = this
(*122*)  moreover 
{ assume "LI1 ~= LI2"
(*123*)  moreover

have  "inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2"
using ax_g4 [of "PO2" "LI2"]
by auto

(*124*)  moreover 
{ assume "inc_po_l PO2 LI2"
(*125*)  moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO2 LI2` and `inc_po_l PO3 LI2`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI2" "PO2" "PO3"]
by auto

(*126*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*127*)  
ultimately
have False
by auto
} note note16 = this
(*128*)  moreover 
{ assume "\<not>inc_po_l PO2 LI2"
(*129*)  moreover
from `PO1 ~= PO3` and `inc_po_l PO1 LI2` and `inc_po_l PO3 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO1 PO3 PO2"
using ax_D1a [of "PO1" "PO3" "LI2" "PO2"]
by auto

(*130*)  moreover
from `PO1 ~= PO3`
have  "PO3 ~= PO1"
by auto

(*131*)  moreover
from `PO3 ~= PO1` and `inc_po_l PO3 LI2` and `inc_po_l PO1 LI2` and `\<not>inc_po_l PO2 LI2`
have  "\<not>col PO3 PO1 PO2"
using ax_D1a [of "PO3" "PO1" "LI2" "PO2"]
by auto

(*132*)  moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3`
have  "col PO2 PO2 PO3"
using ax_D1 [of "PO2" "LI3" "PO2" "PO3"]
by auto

(*133*)  moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO2 LI3`
have  "col PO2 PO3 PO2"
using ax_D1 [of "PO2" "LI3" "PO3" "PO2"]
by auto

(*134*)  moreover
from `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3`
have  "col PO2 PO3 PO3"
using ax_D1 [of "PO2" "LI3" "PO3" "PO3"]
by auto

(*135*)  moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI3`
have  "col PO3 PO2 PO2"
using ax_D1 [of "PO3" "LI3" "PO2" "PO2"]
by auto

(*136*)  moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3`
have  "col PO3 PO2 PO3"
using ax_D1 [of "PO3" "LI3" "PO2" "PO3"]
by auto

(*137*)  moreover
from `inc_po_l PO3 LI3` and `inc_po_l PO3 LI3` and `inc_po_l PO2 LI3`
have  "col PO3 PO3 PO2"
using ax_D1 [of "PO3" "LI3" "PO3" "PO2"]
by auto

(*138*)  moreover

have  "int_l_l LI1 LI3 \<or> \<not>int_l_l LI1 LI3"
using ax_D6a [of "LI1" "LI3"]
by auto

(*139*)  moreover 
{ assume "int_l_l LI1 LI3"
(*140*)  moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(*141*)  moreover 
{ assume "int_l_l LI2 LI3"
(*142*)  moreover

have  "int_l_l LI3 LI1 \<or> \<not>int_l_l LI3 LI1"
using ax_D6a [of "LI3" "LI1"]
by auto

(*143*)  moreover 
{ assume "int_l_l LI3 LI1"
(*144*)  moreover

have  "int_l_l LI3 LI2 \<or> \<not>int_l_l LI3 LI2"
using ax_D6a [of "LI3" "LI2"]
by auto

(*145*)  moreover 
{ assume "int_l_l LI3 LI2"
(*146*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*147*)  moreover 
{ assume "int_l_l LI3 LI3"
(*148*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*149*)  moreover 
{ assume "LI1 = LI3"
(*150*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*151*)  
ultimately
have False
by auto
} note note17 = this
(*152*)  moreover 
{ assume "LI1 ~= LI3"
(*153*)  moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(*154*)  moreover 
{ assume "LI2 = LI3"
(*155*)  moreover
from `inc_po_l PO2 LI3` and `\<not>inc_po_l PO2 LI2` and `LI2 = LI3`
have False
by auto

(*156*)  
ultimately
have False
by auto
} note note18 = this
(*157*)  moreover 
{ assume "LI2 ~= LI3"
(*158*)  moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(*159*)  moreover 
{ assume "inc_po_l PO1 LI3"
(*160*)  moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI3" "PO2" "PO3"]
by auto

(*161*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*162*)  
ultimately
have False
by auto
} note note19 = this
(*163*)  moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(*164*)  moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `\<not>inc_po_l PO1 LI3`
have  "\<not>col PO2 PO3 PO1"
using ax_D1a [of "PO2" "PO3" "LI3" "PO1"]
by auto

(*165*)  
ultimately
have ?thesis
by auto
} note note20 = this
(*166*)  from note19 and note20 and `inc_po_l PO1 LI3 | \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(*167*)  
ultimately
have ?thesis
by auto
} note note21 = this
(*168*)  from note18 and note21 and `LI2 = LI3 | LI2 ~= LI3`
have ?thesis
by auto
(*169*)  
ultimately
have ?thesis
by auto
} note note22 = this
(*170*)  from note17 and note22 and `LI1 = LI3 | LI1 ~= LI3`
have ?thesis
by auto
(*171*)  
ultimately
have ?thesis
by auto
} note note23 = this
(*172*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*173*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*174*)  moreover 
{ assume "LI1 = LI3"
(*175*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*176*)  
ultimately
have False
by auto
} note note24 = this
(*177*)  moreover 
{ assume "LI1 ~= LI3"
(*178*)  moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(*179*)  moreover 
{ assume "LI2 = LI3"
(*180*)  moreover
from `inc_po_l PO2 LI3` and `\<not>inc_po_l PO2 LI2` and `LI2 = LI3`
have False
by auto

(*181*)  
ultimately
have False
by auto
} note note25 = this
(*182*)  moreover 
{ assume "LI2 ~= LI3"
(*183*)  moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(*184*)  moreover 
{ assume "inc_po_l PO1 LI3"
(*185*)  moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI3" "PO2" "PO3"]
by auto

(*186*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*187*)  
ultimately
have False
by auto
} note note26 = this
(*188*)  moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(*189*)  moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `\<not>inc_po_l PO1 LI3`
have  "\<not>col PO2 PO3 PO1"
using ax_D1a [of "PO2" "PO3" "LI3" "PO1"]
by auto

(*190*)  
ultimately
have ?thesis
by auto
} note note27 = this
(*191*)  from note26 and note27 and `inc_po_l PO1 LI3 | \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(*192*)  
ultimately
have ?thesis
by auto
} note note28 = this
(*193*)  from note25 and note28 and `LI2 = LI3 | LI2 ~= LI3`
have ?thesis
by auto
(*194*)  
ultimately
have ?thesis
by auto
} note note29 = this
(*195*)  from note24 and note29 and `LI1 = LI3 | LI1 ~= LI3`
have ?thesis
by auto
(*196*)  
ultimately
have ?thesis
by auto
} note note30 = this
(*197*)  from note23 and note30 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have ?thesis
by auto
(*198*)  
ultimately
have ?thesis
by auto
} note note31 = this
(*199*)  moreover 
{ assume "\<not>int_l_l LI3 LI2"
(*200*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*201*)  moreover 
{ assume "int_l_l LI3 LI3"
(*202*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*203*)  moreover 
{ assume "LI1 = LI3"
(*204*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*205*)  
ultimately
have False
by auto
} note note32 = this
(*206*)  moreover 
{ assume "LI1 ~= LI3"
(*207*)  moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(*208*)  moreover 
{ assume "LI2 = LI3"
(*209*)  moreover
from `inc_po_l PO2 LI3` and `\<not>inc_po_l PO2 LI2` and `LI2 = LI3`
have False
by auto

(*210*)  
ultimately
have False
by auto
} note note33 = this
(*211*)  moreover 
{ assume "LI2 ~= LI3"
(*212*)  moreover
from `LI2 ~= LI3`
have  "LI3 ~= LI2"
by auto

(*213*)  moreover
from `LI3 ~= LI2` and `inc_po_l PO3 LI3` and `inc_po_l PO3 LI2`
have  "int_l_l LI3 LI2"
using ax_D5 [of "LI3" "LI2" "PO3"]
by auto

(*214*)  moreover
from `int_l_l LI3 LI2` and `\<not>int_l_l LI3 LI2`
have False
by auto

(*215*)  
ultimately
have False
by auto
} note note34 = this
(*216*)  from note33 and note34 and `LI2 = LI3 | LI2 ~= LI3`
have False
by auto
(*217*)  
ultimately
have False
by auto
} note note35 = this
(*218*)  from note32 and note35 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*219*)  
ultimately
have False
by auto
} note note36 = this
(*220*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*221*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*222*)  moreover 
{ assume "LI1 = LI3"
(*223*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*224*)  
ultimately
have False
by auto
} note note37 = this
(*225*)  moreover 
{ assume "LI1 ~= LI3"
(*226*)  moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(*227*)  moreover 
{ assume "LI2 = LI3"
(*228*)  moreover
from `inc_po_l PO2 LI3` and `\<not>inc_po_l PO2 LI2` and `LI2 = LI3`
have False
by auto

(*229*)  
ultimately
have False
by auto
} note note38 = this
(*230*)  moreover 
{ assume "LI2 ~= LI3"
(*231*)  moreover
from `LI2 ~= LI3`
have  "LI3 ~= LI2"
by auto

(*232*)  moreover
from `LI3 ~= LI2` and `inc_po_l PO3 LI3` and `inc_po_l PO3 LI2`
have  "int_l_l LI3 LI2"
using ax_D5 [of "LI3" "LI2" "PO3"]
by auto

(*233*)  moreover
from `int_l_l LI3 LI2` and `\<not>int_l_l LI3 LI2`
have False
by auto

(*234*)  
ultimately
have False
by auto
} note note39 = this
(*235*)  from note38 and note39 and `LI2 = LI3 | LI2 ~= LI3`
have False
by auto
(*236*)  
ultimately
have False
by auto
} note note40 = this
(*237*)  from note37 and note40 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*238*)  
ultimately
have False
by auto
} note note41 = this
(*239*)  from note36 and note41 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*240*)  
ultimately
have False
by auto
} note note42 = this
(*241*)  from note31 and note42 and `int_l_l LI3 LI2 | \<not>int_l_l LI3 LI2`
have ?thesis
by auto
(*242*)  
ultimately
have ?thesis
by auto
} note note43 = this
(*243*)  moreover 
{ assume "\<not>int_l_l LI3 LI1"
(*244*)  moreover

have  "int_l_l LI3 LI2 \<or> \<not>int_l_l LI3 LI2"
using ax_D6a [of "LI3" "LI2"]
by auto

(*245*)  moreover 
{ assume "int_l_l LI3 LI2"
(*246*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*247*)  moreover 
{ assume "int_l_l LI3 LI3"
(*248*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*249*)  moreover 
{ assume "LI1 = LI3"
(*250*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*251*)  
ultimately
have False
by auto
} note note44 = this
(*252*)  moreover 
{ assume "LI1 ~= LI3"
(*253*)  moreover
from `LI1 ~= LI3`
have  "LI3 ~= LI1"
by auto

(*254*)  moreover
from `LI3 ~= LI1` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI1`
have  "int_l_l LI3 LI1"
using ax_D5 [of "LI3" "LI1" "PO2"]
by auto

(*255*)  moreover
from `int_l_l LI3 LI1` and `\<not>int_l_l LI3 LI1`
have False
by auto

(*256*)  
ultimately
have False
by auto
} note note45 = this
(*257*)  from note44 and note45 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*258*)  
ultimately
have False
by auto
} note note46 = this
(*259*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*260*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*261*)  moreover 
{ assume "LI1 = LI3"
(*262*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*263*)  
ultimately
have False
by auto
} note note47 = this
(*264*)  moreover 
{ assume "LI1 ~= LI3"
(*265*)  moreover
from `LI1 ~= LI3`
have  "LI3 ~= LI1"
by auto

(*266*)  moreover
from `LI3 ~= LI1` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI1`
have  "int_l_l LI3 LI1"
using ax_D5 [of "LI3" "LI1" "PO2"]
by auto

(*267*)  moreover
from `int_l_l LI3 LI1` and `\<not>int_l_l LI3 LI1`
have False
by auto

(*268*)  
ultimately
have False
by auto
} note note48 = this
(*269*)  from note47 and note48 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*270*)  
ultimately
have False
by auto
} note note49 = this
(*271*)  from note46 and note49 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*272*)  
ultimately
have False
by auto
} note note50 = this
(*273*)  moreover 
{ assume "\<not>int_l_l LI3 LI2"
(*274*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*275*)  moreover 
{ assume "int_l_l LI3 LI3"
(*276*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*277*)  moreover 
{ assume "LI1 = LI3"
(*278*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*279*)  
ultimately
have False
by auto
} note note51 = this
(*280*)  moreover 
{ assume "LI1 ~= LI3"
(*281*)  moreover
from `LI1 ~= LI3`
have  "LI3 ~= LI1"
by auto

(*282*)  moreover
from `LI3 ~= LI1` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI1`
have  "int_l_l LI3 LI1"
using ax_D5 [of "LI3" "LI1" "PO2"]
by auto

(*283*)  moreover
from `int_l_l LI3 LI1` and `\<not>int_l_l LI3 LI1`
have False
by auto

(*284*)  
ultimately
have False
by auto
} note note52 = this
(*285*)  from note51 and note52 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*286*)  
ultimately
have False
by auto
} note note53 = this
(*287*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*288*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*289*)  moreover 
{ assume "LI1 = LI3"
(*290*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*291*)  
ultimately
have False
by auto
} note note54 = this
(*292*)  moreover 
{ assume "LI1 ~= LI3"
(*293*)  moreover
from `LI1 ~= LI3`
have  "LI3 ~= LI1"
by auto

(*294*)  moreover
from `LI3 ~= LI1` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI1`
have  "int_l_l LI3 LI1"
using ax_D5 [of "LI3" "LI1" "PO2"]
by auto

(*295*)  moreover
from `int_l_l LI3 LI1` and `\<not>int_l_l LI3 LI1`
have False
by auto

(*296*)  
ultimately
have False
by auto
} note note55 = this
(*297*)  from note54 and note55 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*298*)  
ultimately
have False
by auto
} note note56 = this
(*299*)  from note53 and note56 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*300*)  
ultimately
have False
by auto
} note note57 = this
(*301*)  from note50 and note57 and `int_l_l LI3 LI2 | \<not>int_l_l LI3 LI2`
have False
by auto
(*302*)  
ultimately
have False
by auto
} note note58 = this
(*303*)  from note43 and note58 and `int_l_l LI3 LI1 | \<not>int_l_l LI3 LI1`
have ?thesis
by auto
(*304*)  
ultimately
have ?thesis
by auto
} note note59 = this
(*305*)  moreover 
{ assume "\<not>int_l_l LI2 LI3"
(*306*)  moreover

have  "int_l_l LI3 LI1 \<or> \<not>int_l_l LI3 LI1"
using ax_D6a [of "LI3" "LI1"]
by auto

(*307*)  moreover 
{ assume "int_l_l LI3 LI1"
(*308*)  moreover

have  "int_l_l LI3 LI2 \<or> \<not>int_l_l LI3 LI2"
using ax_D6a [of "LI3" "LI2"]
by auto

(*309*)  moreover 
{ assume "int_l_l LI3 LI2"
(*310*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*311*)  moreover 
{ assume "int_l_l LI3 LI3"
(*312*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*313*)  moreover 
{ assume "LI1 = LI3"
(*314*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*315*)  
ultimately
have False
by auto
} note note60 = this
(*316*)  moreover 
{ assume "LI1 ~= LI3"
(*317*)  moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(*318*)  moreover 
{ assume "LI2 = LI3"
(*319*)  moreover
from `inc_po_l PO2 LI3` and `\<not>inc_po_l PO2 LI2` and `LI2 = LI3`
have False
by auto

(*320*)  
ultimately
have False
by auto
} note note61 = this
(*321*)  moreover 
{ assume "LI2 ~= LI3"
(*322*)  moreover
from `LI2 ~= LI3` and `inc_po_l PO3 LI2` and `inc_po_l PO3 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO3"]
by auto

(*323*)  moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(*324*)  
ultimately
have False
by auto
} note note62 = this
(*325*)  from note61 and note62 and `LI2 = LI3 | LI2 ~= LI3`
have False
by auto
(*326*)  
ultimately
have False
by auto
} note note63 = this
(*327*)  from note60 and note63 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*328*)  
ultimately
have False
by auto
} note note64 = this
(*329*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*330*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*331*)  moreover 
{ assume "LI1 = LI3"
(*332*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*333*)  
ultimately
have False
by auto
} note note65 = this
(*334*)  moreover 
{ assume "LI1 ~= LI3"
(*335*)  moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(*336*)  moreover 
{ assume "LI2 = LI3"
(*337*)  moreover
from `inc_po_l PO2 LI3` and `\<not>inc_po_l PO2 LI2` and `LI2 = LI3`
have False
by auto

(*338*)  
ultimately
have False
by auto
} note note66 = this
(*339*)  moreover 
{ assume "LI2 ~= LI3"
(*340*)  moreover
from `LI2 ~= LI3` and `inc_po_l PO3 LI2` and `inc_po_l PO3 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO3"]
by auto

(*341*)  moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(*342*)  
ultimately
have False
by auto
} note note67 = this
(*343*)  from note66 and note67 and `LI2 = LI3 | LI2 ~= LI3`
have False
by auto
(*344*)  
ultimately
have False
by auto
} note note68 = this
(*345*)  from note65 and note68 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*346*)  
ultimately
have False
by auto
} note note69 = this
(*347*)  from note64 and note69 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*348*)  
ultimately
have False
by auto
} note note70 = this
(*349*)  moreover 
{ assume "\<not>int_l_l LI3 LI2"
(*350*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*351*)  moreover 
{ assume "int_l_l LI3 LI3"
(*352*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*353*)  moreover 
{ assume "LI1 = LI3"
(*354*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*355*)  
ultimately
have False
by auto
} note note71 = this
(*356*)  moreover 
{ assume "LI1 ~= LI3"
(*357*)  moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(*358*)  moreover 
{ assume "LI2 = LI3"
(*359*)  moreover
from `inc_po_l PO2 LI3` and `\<not>inc_po_l PO2 LI2` and `LI2 = LI3`
have False
by auto

(*360*)  
ultimately
have False
by auto
} note note72 = this
(*361*)  moreover 
{ assume "LI2 ~= LI3"
(*362*)  moreover
from `LI2 ~= LI3` and `inc_po_l PO3 LI2` and `inc_po_l PO3 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO3"]
by auto

(*363*)  moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(*364*)  
ultimately
have False
by auto
} note note73 = this
(*365*)  from note72 and note73 and `LI2 = LI3 | LI2 ~= LI3`
have False
by auto
(*366*)  
ultimately
have False
by auto
} note note74 = this
(*367*)  from note71 and note74 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*368*)  
ultimately
have False
by auto
} note note75 = this
(*369*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*370*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*371*)  moreover 
{ assume "LI1 = LI3"
(*372*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*373*)  
ultimately
have False
by auto
} note note76 = this
(*374*)  moreover 
{ assume "LI1 ~= LI3"
(*375*)  moreover

have  "LI2 = LI3 \<or> LI2 ~= LI3"
using ax_g2 [of "LI2" "LI3"]
by auto

(*376*)  moreover 
{ assume "LI2 = LI3"
(*377*)  moreover
from `inc_po_l PO2 LI3` and `\<not>inc_po_l PO2 LI2` and `LI2 = LI3`
have False
by auto

(*378*)  
ultimately
have False
by auto
} note note77 = this
(*379*)  moreover 
{ assume "LI2 ~= LI3"
(*380*)  moreover
from `LI2 ~= LI3` and `inc_po_l PO3 LI2` and `inc_po_l PO3 LI3`
have  "int_l_l LI2 LI3"
using ax_D5 [of "LI2" "LI3" "PO3"]
by auto

(*381*)  moreover
from `int_l_l LI2 LI3` and `\<not>int_l_l LI2 LI3`
have False
by auto

(*382*)  
ultimately
have False
by auto
} note note78 = this
(*383*)  from note77 and note78 and `LI2 = LI3 | LI2 ~= LI3`
have False
by auto
(*384*)  
ultimately
have False
by auto
} note note79 = this
(*385*)  from note76 and note79 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*386*)  
ultimately
have False
by auto
} note note80 = this
(*387*)  from note75 and note80 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*388*)  
ultimately
have False
by auto
} note note81 = this
(*389*)  from note70 and note81 and `int_l_l LI3 LI2 | \<not>int_l_l LI3 LI2`
have False
by auto
(*390*)  
ultimately
have False
by auto
} note note82 = this
(*391*)  moreover 
{ assume "\<not>int_l_l LI3 LI1"
(*392*)  moreover

have  "int_l_l LI3 LI2 \<or> \<not>int_l_l LI3 LI2"
using ax_D6a [of "LI3" "LI2"]
by auto

(*393*)  moreover 
{ assume "int_l_l LI3 LI2"
(*394*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*395*)  moreover 
{ assume "int_l_l LI3 LI3"
(*396*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*397*)  moreover 
{ assume "LI1 = LI3"
(*398*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*399*)  
ultimately
have False
by auto
} note note83 = this
(*400*)  moreover 
{ assume "LI1 ~= LI3"
(*401*)  moreover
from `LI1 ~= LI3`
have  "LI3 ~= LI1"
by auto

(*402*)  moreover
from `LI3 ~= LI1` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI1`
have  "int_l_l LI3 LI1"
using ax_D5 [of "LI3" "LI1" "PO2"]
by auto

(*403*)  moreover
from `int_l_l LI3 LI1` and `\<not>int_l_l LI3 LI1`
have False
by auto

(*404*)  
ultimately
have False
by auto
} note note84 = this
(*405*)  from note83 and note84 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*406*)  
ultimately
have False
by auto
} note note85 = this
(*407*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*408*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*409*)  moreover 
{ assume "LI1 = LI3"
(*410*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*411*)  
ultimately
have False
by auto
} note note86 = this
(*412*)  moreover 
{ assume "LI1 ~= LI3"
(*413*)  moreover
from `LI1 ~= LI3`
have  "LI3 ~= LI1"
by auto

(*414*)  moreover
from `LI3 ~= LI1` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI1`
have  "int_l_l LI3 LI1"
using ax_D5 [of "LI3" "LI1" "PO2"]
by auto

(*415*)  moreover
from `int_l_l LI3 LI1` and `\<not>int_l_l LI3 LI1`
have False
by auto

(*416*)  
ultimately
have False
by auto
} note note87 = this
(*417*)  from note86 and note87 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*418*)  
ultimately
have False
by auto
} note note88 = this
(*419*)  from note85 and note88 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*420*)  
ultimately
have False
by auto
} note note89 = this
(*421*)  moreover 
{ assume "\<not>int_l_l LI3 LI2"
(*422*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*423*)  moreover 
{ assume "int_l_l LI3 LI3"
(*424*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*425*)  moreover 
{ assume "LI1 = LI3"
(*426*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*427*)  
ultimately
have False
by auto
} note note90 = this
(*428*)  moreover 
{ assume "LI1 ~= LI3"
(*429*)  moreover
from `LI1 ~= LI3`
have  "LI3 ~= LI1"
by auto

(*430*)  moreover
from `LI3 ~= LI1` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI1`
have  "int_l_l LI3 LI1"
using ax_D5 [of "LI3" "LI1" "PO2"]
by auto

(*431*)  moreover
from `int_l_l LI3 LI1` and `\<not>int_l_l LI3 LI1`
have False
by auto

(*432*)  
ultimately
have False
by auto
} note note91 = this
(*433*)  from note90 and note91 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*434*)  
ultimately
have False
by auto
} note note92 = this
(*435*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*436*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*437*)  moreover 
{ assume "LI1 = LI3"
(*438*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*439*)  
ultimately
have False
by auto
} note note93 = this
(*440*)  moreover 
{ assume "LI1 ~= LI3"
(*441*)  moreover
from `LI1 ~= LI3`
have  "LI3 ~= LI1"
by auto

(*442*)  moreover
from `LI3 ~= LI1` and `inc_po_l PO2 LI3` and `inc_po_l PO2 LI1`
have  "int_l_l LI3 LI1"
using ax_D5 [of "LI3" "LI1" "PO2"]
by auto

(*443*)  moreover
from `int_l_l LI3 LI1` and `\<not>int_l_l LI3 LI1`
have False
by auto

(*444*)  
ultimately
have False
by auto
} note note94 = this
(*445*)  from note93 and note94 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*446*)  
ultimately
have False
by auto
} note note95 = this
(*447*)  from note92 and note95 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*448*)  
ultimately
have False
by auto
} note note96 = this
(*449*)  from note89 and note96 and `int_l_l LI3 LI2 | \<not>int_l_l LI3 LI2`
have False
by auto
(*450*)  
ultimately
have False
by auto
} note note97 = this
(*451*)  from note82 and note97 and `int_l_l LI3 LI1 | \<not>int_l_l LI3 LI1`
have False
by auto
(*452*)  
ultimately
have False
by auto
} note note98 = this
(*453*)  from note59 and note98 and `int_l_l LI2 LI3 | \<not>int_l_l LI2 LI3`
have ?thesis
by auto
(*454*)  
ultimately
have ?thesis
by auto
} note note99 = this
(*455*)  moreover 
{ assume "\<not>int_l_l LI1 LI3"
(*456*)  moreover

have  "int_l_l LI2 LI3 \<or> \<not>int_l_l LI2 LI3"
using ax_D6a [of "LI2" "LI3"]
by auto

(*457*)  moreover 
{ assume "int_l_l LI2 LI3"
(*458*)  moreover

have  "int_l_l LI3 LI1 \<or> \<not>int_l_l LI3 LI1"
using ax_D6a [of "LI3" "LI1"]
by auto

(*459*)  moreover 
{ assume "int_l_l LI3 LI1"
(*460*)  moreover

have  "int_l_l LI3 LI2 \<or> \<not>int_l_l LI3 LI2"
using ax_D6a [of "LI3" "LI2"]
by auto

(*461*)  moreover 
{ assume "int_l_l LI3 LI2"
(*462*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*463*)  moreover 
{ assume "int_l_l LI3 LI3"
(*464*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*465*)  moreover 
{ assume "LI1 = LI3"
(*466*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*467*)  
ultimately
have False
by auto
} note note100 = this
(*468*)  moreover 
{ assume "LI1 ~= LI3"
(*469*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*470*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*471*)  
ultimately
have False
by auto
} note note101 = this
(*472*)  from note100 and note101 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*473*)  
ultimately
have False
by auto
} note note102 = this
(*474*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*475*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*476*)  moreover 
{ assume "LI1 = LI3"
(*477*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*478*)  
ultimately
have False
by auto
} note note103 = this
(*479*)  moreover 
{ assume "LI1 ~= LI3"
(*480*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*481*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*482*)  
ultimately
have False
by auto
} note note104 = this
(*483*)  from note103 and note104 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*484*)  
ultimately
have False
by auto
} note note105 = this
(*485*)  from note102 and note105 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*486*)  
ultimately
have False
by auto
} note note106 = this
(*487*)  moreover 
{ assume "\<not>int_l_l LI3 LI2"
(*488*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*489*)  moreover 
{ assume "int_l_l LI3 LI3"
(*490*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*491*)  moreover 
{ assume "LI1 = LI3"
(*492*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*493*)  
ultimately
have False
by auto
} note note107 = this
(*494*)  moreover 
{ assume "LI1 ~= LI3"
(*495*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*496*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*497*)  
ultimately
have False
by auto
} note note108 = this
(*498*)  from note107 and note108 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*499*)  
ultimately
have False
by auto
} note note109 = this
(*500*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*501*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*502*)  moreover 
{ assume "LI1 = LI3"
(*503*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*504*)  
ultimately
have False
by auto
} note note110 = this
(*505*)  moreover 
{ assume "LI1 ~= LI3"
(*506*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*507*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*508*)  
ultimately
have False
by auto
} note note111 = this
(*509*)  from note110 and note111 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*510*)  
ultimately
have False
by auto
} note note112 = this
(*511*)  from note109 and note112 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*512*)  
ultimately
have False
by auto
} note note113 = this
(*513*)  from note106 and note113 and `int_l_l LI3 LI2 | \<not>int_l_l LI3 LI2`
have False
by auto
(*514*)  
ultimately
have False
by auto
} note note114 = this
(*515*)  moreover 
{ assume "\<not>int_l_l LI3 LI1"
(*516*)  moreover

have  "int_l_l LI3 LI2 \<or> \<not>int_l_l LI3 LI2"
using ax_D6a [of "LI3" "LI2"]
by auto

(*517*)  moreover 
{ assume "int_l_l LI3 LI2"
(*518*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*519*)  moreover 
{ assume "int_l_l LI3 LI3"
(*520*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*521*)  moreover 
{ assume "LI1 = LI3"
(*522*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*523*)  
ultimately
have False
by auto
} note note115 = this
(*524*)  moreover 
{ assume "LI1 ~= LI3"
(*525*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*526*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*527*)  
ultimately
have False
by auto
} note note116 = this
(*528*)  from note115 and note116 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*529*)  
ultimately
have False
by auto
} note note117 = this
(*530*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*531*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*532*)  moreover 
{ assume "LI1 = LI3"
(*533*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*534*)  
ultimately
have False
by auto
} note note118 = this
(*535*)  moreover 
{ assume "LI1 ~= LI3"
(*536*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*537*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*538*)  
ultimately
have False
by auto
} note note119 = this
(*539*)  from note118 and note119 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*540*)  
ultimately
have False
by auto
} note note120 = this
(*541*)  from note117 and note120 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*542*)  
ultimately
have False
by auto
} note note121 = this
(*543*)  moreover 
{ assume "\<not>int_l_l LI3 LI2"
(*544*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*545*)  moreover 
{ assume "int_l_l LI3 LI3"
(*546*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*547*)  moreover 
{ assume "LI1 = LI3"
(*548*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*549*)  
ultimately
have False
by auto
} note note122 = this
(*550*)  moreover 
{ assume "LI1 ~= LI3"
(*551*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*552*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*553*)  
ultimately
have False
by auto
} note note123 = this
(*554*)  from note122 and note123 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*555*)  
ultimately
have False
by auto
} note note124 = this
(*556*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*557*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*558*)  moreover 
{ assume "LI1 = LI3"
(*559*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*560*)  
ultimately
have False
by auto
} note note125 = this
(*561*)  moreover 
{ assume "LI1 ~= LI3"
(*562*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*563*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*564*)  
ultimately
have False
by auto
} note note126 = this
(*565*)  from note125 and note126 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*566*)  
ultimately
have False
by auto
} note note127 = this
(*567*)  from note124 and note127 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*568*)  
ultimately
have False
by auto
} note note128 = this
(*569*)  from note121 and note128 and `int_l_l LI3 LI2 | \<not>int_l_l LI3 LI2`
have False
by auto
(*570*)  
ultimately
have False
by auto
} note note129 = this
(*571*)  from note114 and note129 and `int_l_l LI3 LI1 | \<not>int_l_l LI3 LI1`
have False
by auto
(*572*)  
ultimately
have False
by auto
} note note130 = this
(*573*)  moreover 
{ assume "\<not>int_l_l LI2 LI3"
(*574*)  moreover

have  "int_l_l LI3 LI1 \<or> \<not>int_l_l LI3 LI1"
using ax_D6a [of "LI3" "LI1"]
by auto

(*575*)  moreover 
{ assume "int_l_l LI3 LI1"
(*576*)  moreover

have  "int_l_l LI3 LI2 \<or> \<not>int_l_l LI3 LI2"
using ax_D6a [of "LI3" "LI2"]
by auto

(*577*)  moreover 
{ assume "int_l_l LI3 LI2"
(*578*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*579*)  moreover 
{ assume "int_l_l LI3 LI3"
(*580*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*581*)  moreover 
{ assume "LI1 = LI3"
(*582*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*583*)  
ultimately
have False
by auto
} note note131 = this
(*584*)  moreover 
{ assume "LI1 ~= LI3"
(*585*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*586*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*587*)  
ultimately
have False
by auto
} note note132 = this
(*588*)  from note131 and note132 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*589*)  
ultimately
have False
by auto
} note note133 = this
(*590*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*591*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*592*)  moreover 
{ assume "LI1 = LI3"
(*593*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*594*)  
ultimately
have False
by auto
} note note134 = this
(*595*)  moreover 
{ assume "LI1 ~= LI3"
(*596*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*597*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*598*)  
ultimately
have False
by auto
} note note135 = this
(*599*)  from note134 and note135 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*600*)  
ultimately
have False
by auto
} note note136 = this
(*601*)  from note133 and note136 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*602*)  
ultimately
have False
by auto
} note note137 = this
(*603*)  moreover 
{ assume "\<not>int_l_l LI3 LI2"
(*604*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*605*)  moreover 
{ assume "int_l_l LI3 LI3"
(*606*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*607*)  moreover 
{ assume "LI1 = LI3"
(*608*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*609*)  
ultimately
have False
by auto
} note note138 = this
(*610*)  moreover 
{ assume "LI1 ~= LI3"
(*611*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*612*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*613*)  
ultimately
have False
by auto
} note note139 = this
(*614*)  from note138 and note139 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*615*)  
ultimately
have False
by auto
} note note140 = this
(*616*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*617*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*618*)  moreover 
{ assume "LI1 = LI3"
(*619*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*620*)  
ultimately
have False
by auto
} note note141 = this
(*621*)  moreover 
{ assume "LI1 ~= LI3"
(*622*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*623*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*624*)  
ultimately
have False
by auto
} note note142 = this
(*625*)  from note141 and note142 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*626*)  
ultimately
have False
by auto
} note note143 = this
(*627*)  from note140 and note143 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*628*)  
ultimately
have False
by auto
} note note144 = this
(*629*)  from note137 and note144 and `int_l_l LI3 LI2 | \<not>int_l_l LI3 LI2`
have False
by auto
(*630*)  
ultimately
have False
by auto
} note note145 = this
(*631*)  moreover 
{ assume "\<not>int_l_l LI3 LI1"
(*632*)  moreover

have  "int_l_l LI3 LI2 \<or> \<not>int_l_l LI3 LI2"
using ax_D6a [of "LI3" "LI2"]
by auto

(*633*)  moreover 
{ assume "int_l_l LI3 LI2"
(*634*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*635*)  moreover 
{ assume "int_l_l LI3 LI3"
(*636*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*637*)  moreover 
{ assume "LI1 = LI3"
(*638*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*639*)  
ultimately
have False
by auto
} note note146 = this
(*640*)  moreover 
{ assume "LI1 ~= LI3"
(*641*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*642*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*643*)  
ultimately
have False
by auto
} note note147 = this
(*644*)  from note146 and note147 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*645*)  
ultimately
have False
by auto
} note note148 = this
(*646*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*647*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*648*)  moreover 
{ assume "LI1 = LI3"
(*649*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*650*)  
ultimately
have False
by auto
} note note149 = this
(*651*)  moreover 
{ assume "LI1 ~= LI3"
(*652*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*653*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*654*)  
ultimately
have False
by auto
} note note150 = this
(*655*)  from note149 and note150 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*656*)  
ultimately
have False
by auto
} note note151 = this
(*657*)  from note148 and note151 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*658*)  
ultimately
have False
by auto
} note note152 = this
(*659*)  moreover 
{ assume "\<not>int_l_l LI3 LI2"
(*660*)  moreover

have  "int_l_l LI3 LI3 \<or> \<not>int_l_l LI3 LI3"
using ax_D6a [of "LI3" "LI3"]
by auto

(*661*)  moreover 
{ assume "int_l_l LI3 LI3"
(*662*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*663*)  moreover 
{ assume "LI1 = LI3"
(*664*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*665*)  
ultimately
have False
by auto
} note note153 = this
(*666*)  moreover 
{ assume "LI1 ~= LI3"
(*667*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*668*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*669*)  
ultimately
have False
by auto
} note note154 = this
(*670*)  from note153 and note154 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*671*)  
ultimately
have False
by auto
} note note155 = this
(*672*)  moreover 
{ assume "\<not>int_l_l LI3 LI3"
(*673*)  moreover

have  "LI1 = LI3 \<or> LI1 ~= LI3"
using ax_g2 [of "LI1" "LI3"]
by auto

(*674*)  moreover 
{ assume "LI1 = LI3"
(*675*)  moreover
from `inc_po_l PO3 LI3` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI3`
have False
by auto

(*676*)  
ultimately
have False
by auto
} note note156 = this
(*677*)  moreover 
{ assume "LI1 ~= LI3"
(*678*)  moreover
from `LI1 ~= LI3` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI3`
have  "int_l_l LI1 LI3"
using ax_D5 [of "LI1" "LI3" "PO2"]
by auto

(*679*)  moreover
from `int_l_l LI1 LI3` and `\<not>int_l_l LI1 LI3`
have False
by auto

(*680*)  
ultimately
have False
by auto
} note note157 = this
(*681*)  from note156 and note157 and `LI1 = LI3 | LI1 ~= LI3`
have False
by auto
(*682*)  
ultimately
have False
by auto
} note note158 = this
(*683*)  from note155 and note158 and `int_l_l LI3 LI3 | \<not>int_l_l LI3 LI3`
have False
by auto
(*684*)  
ultimately
have False
by auto
} note note159 = this
(*685*)  from note152 and note159 and `int_l_l LI3 LI2 | \<not>int_l_l LI3 LI2`
have False
by auto
(*686*)  
ultimately
have False
by auto
} note note160 = this
(*687*)  from note145 and note160 and `int_l_l LI3 LI1 | \<not>int_l_l LI3 LI1`
have False
by auto
(*688*)  
ultimately
have False
by auto
} note note161 = this
(*689*)  from note130 and note161 and `int_l_l LI2 LI3 | \<not>int_l_l LI2 LI3`
have False
by auto
(*690*)  
ultimately
have False
by auto
} note note162 = this
(*691*)  from note99 and note162 and `int_l_l LI1 LI3 | \<not>int_l_l LI1 LI3`
have ?thesis
by auto
(*692*)  
ultimately
have ?thesis
by auto
} note note163 = this
(*693*)  from note16 and note163 and `inc_po_l PO2 LI2 | \<not>inc_po_l PO2 LI2`
have ?thesis
by auto
(*694*)  
ultimately
have ?thesis
by auto
} note note164 = this
(*695*)  from note15 and note164 and `LI1 = LI2 | LI1 ~= LI2`
have ?thesis
by auto
(*696*)  
ultimately
have ?thesis
by auto
} note note165 = this
(*697*)  from note14 and note165 and `int_l_l LI2 LI2 | \<not>int_l_l LI2 LI2`
have ?thesis
by auto
(*698*)  
ultimately
have ?thesis
by auto
} note note166 = this
(*699*)  moreover 
{ assume "\<not>int_l_l LI2 LI1"
(*700*)  moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(*701*)  moreover 
{ assume "int_l_l LI2 LI2"
(*702*)  moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

(*703*)  moreover 
{ assume "LI1 = LI2"
(*704*)  moreover
from `inc_po_l PO3 LI2` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI2`
have False
by auto

(*705*)  
ultimately
have False
by auto
} note note167 = this
(*706*)  moreover 
{ assume "LI1 ~= LI2"
(*707*)  moreover
from `LI1 ~= LI2`
have  "LI2 ~= LI1"
by auto

(*708*)  moreover
from `LI2 ~= LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO1 LI1`
have  "int_l_l LI2 LI1"
using ax_D5 [of "LI2" "LI1" "PO1"]
by auto

(*709*)  moreover
from `int_l_l LI2 LI1` and `\<not>int_l_l LI2 LI1`
have False
by auto

(*710*)  
ultimately
have False
by auto
} note note168 = this
(*711*)  from note167 and note168 and `LI1 = LI2 | LI1 ~= LI2`
have False
by auto
(*712*)  
ultimately
have False
by auto
} note note169 = this
(*713*)  moreover 
{ assume "\<not>int_l_l LI2 LI2"
(*714*)  moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

(*715*)  moreover 
{ assume "LI1 = LI2"
(*716*)  moreover
from `inc_po_l PO3 LI2` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI2`
have False
by auto

(*717*)  
ultimately
have False
by auto
} note note170 = this
(*718*)  moreover 
{ assume "LI1 ~= LI2"
(*719*)  moreover
from `LI1 ~= LI2`
have  "LI2 ~= LI1"
by auto

(*720*)  moreover
from `LI2 ~= LI1` and `inc_po_l PO1 LI2` and `inc_po_l PO1 LI1`
have  "int_l_l LI2 LI1"
using ax_D5 [of "LI2" "LI1" "PO1"]
by auto

(*721*)  moreover
from `int_l_l LI2 LI1` and `\<not>int_l_l LI2 LI1`
have False
by auto

(*722*)  
ultimately
have False
by auto
} note note171 = this
(*723*)  from note170 and note171 and `LI1 = LI2 | LI1 ~= LI2`
have False
by auto
(*724*)  
ultimately
have False
by auto
} note note172 = this
(*725*)  from note169 and note172 and `int_l_l LI2 LI2 | \<not>int_l_l LI2 LI2`
have False
by auto
(*726*)  
ultimately
have False
by auto
} note note173 = this
(*727*)  from note166 and note173 and `int_l_l LI2 LI1 | \<not>int_l_l LI2 LI1`
have ?thesis
by auto
(*728*)  
ultimately
have ?thesis
by auto
} note note174 = this
(*729*)  moreover 
{ assume "\<not>int_l_l LI1 LI2"
(*730*)  moreover

have  "int_l_l LI2 LI1 \<or> \<not>int_l_l LI2 LI1"
using ax_D6a [of "LI2" "LI1"]
by auto

(*731*)  moreover 
{ assume "int_l_l LI2 LI1"
(*732*)  moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(*733*)  moreover 
{ assume "int_l_l LI2 LI2"
(*734*)  moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

(*735*)  moreover 
{ assume "LI1 = LI2"
(*736*)  moreover
from `inc_po_l PO3 LI2` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI2`
have False
by auto

(*737*)  
ultimately
have False
by auto
} note note175 = this
(*738*)  moreover 
{ assume "LI1 ~= LI2"
(*739*)  moreover
from `LI1 ~= LI2` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have  "int_l_l LI1 LI2"
using ax_D5 [of "LI1" "LI2" "PO1"]
by auto

(*740*)  moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(*741*)  
ultimately
have False
by auto
} note note176 = this
(*742*)  from note175 and note176 and `LI1 = LI2 | LI1 ~= LI2`
have False
by auto
(*743*)  
ultimately
have False
by auto
} note note177 = this
(*744*)  moreover 
{ assume "\<not>int_l_l LI2 LI2"
(*745*)  moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

(*746*)  moreover 
{ assume "LI1 = LI2"
(*747*)  moreover
from `inc_po_l PO3 LI2` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI2`
have False
by auto

(*748*)  
ultimately
have False
by auto
} note note178 = this
(*749*)  moreover 
{ assume "LI1 ~= LI2"
(*750*)  moreover
from `LI1 ~= LI2` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have  "int_l_l LI1 LI2"
using ax_D5 [of "LI1" "LI2" "PO1"]
by auto

(*751*)  moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(*752*)  
ultimately
have False
by auto
} note note179 = this
(*753*)  from note178 and note179 and `LI1 = LI2 | LI1 ~= LI2`
have False
by auto
(*754*)  
ultimately
have False
by auto
} note note180 = this
(*755*)  from note177 and note180 and `int_l_l LI2 LI2 | \<not>int_l_l LI2 LI2`
have False
by auto
(*756*)  
ultimately
have False
by auto
} note note181 = this
(*757*)  moreover 
{ assume "\<not>int_l_l LI2 LI1"
(*758*)  moreover

have  "int_l_l LI2 LI2 \<or> \<not>int_l_l LI2 LI2"
using ax_D6a [of "LI2" "LI2"]
by auto

(*759*)  moreover 
{ assume "int_l_l LI2 LI2"
(*760*)  moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

(*761*)  moreover 
{ assume "LI1 = LI2"
(*762*)  moreover
from `inc_po_l PO3 LI2` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI2`
have False
by auto

(*763*)  
ultimately
have False
by auto
} note note182 = this
(*764*)  moreover 
{ assume "LI1 ~= LI2"
(*765*)  moreover
from `LI1 ~= LI2` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have  "int_l_l LI1 LI2"
using ax_D5 [of "LI1" "LI2" "PO1"]
by auto

(*766*)  moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(*767*)  
ultimately
have False
by auto
} note note183 = this
(*768*)  from note182 and note183 and `LI1 = LI2 | LI1 ~= LI2`
have False
by auto
(*769*)  
ultimately
have False
by auto
} note note184 = this
(*770*)  moreover 
{ assume "\<not>int_l_l LI2 LI2"
(*771*)  moreover

have  "LI1 = LI2 \<or> LI1 ~= LI2"
using ax_g2 [of "LI1" "LI2"]
by auto

(*772*)  moreover 
{ assume "LI1 = LI2"
(*773*)  moreover
from `inc_po_l PO3 LI2` and `\<not>inc_po_l PO3 LI1` and `LI1 = LI2`
have False
by auto

(*774*)  
ultimately
have False
by auto
} note note185 = this
(*775*)  moreover 
{ assume "LI1 ~= LI2"
(*776*)  moreover
from `LI1 ~= LI2` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI2`
have  "int_l_l LI1 LI2"
using ax_D5 [of "LI1" "LI2" "PO1"]
by auto

(*777*)  moreover
from `int_l_l LI1 LI2` and `\<not>int_l_l LI1 LI2`
have False
by auto

(*778*)  
ultimately
have False
by auto
} note note186 = this
(*779*)  from note185 and note186 and `LI1 = LI2 | LI1 ~= LI2`
have False
by auto
(*780*)  
ultimately
have False
by auto
} note note187 = this
(*781*)  from note184 and note187 and `int_l_l LI2 LI2 | \<not>int_l_l LI2 LI2`
have False
by auto
(*782*)  
ultimately
have False
by auto
} note note188 = this
(*783*)  from note181 and note188 and `int_l_l LI2 LI1 | \<not>int_l_l LI2 LI1`
have False
by auto
(*784*)  
ultimately
have False
by auto
} note note189 = this
(*785*)  from note174 and note189 and `int_l_l LI1 LI2 | \<not>int_l_l LI1 LI2`
have ?thesis
by auto
(*786*)  
ultimately
have ?thesis
by auto
} note note190 = this
(*787*)  from note9 and note190 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*788*)  
ultimately
have ?thesis
by auto
} note note191 = this
(*789*)  from note8 and note191 and `int_l_l LI1 LI1 | \<not>int_l_l LI1 LI1`
have ?thesis
by auto
(*790*)  
ultimately
have ?thesis
by auto
} note note192 = this
(*791*)  from note5 and note192 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*792*)  
ultimately
have ?thesis
by auto
} note note193 = this
(*793*)  from note4 and note193 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*794*)  
ultimately
have ?thesis
by auto
} note note194 = this
(*795*)  from note3 and note194 and `PO1 = PO2 | PO1 ~= PO2`
have ?thesis
by auto
ultimately 
show ?thesis
by auto
qed
