theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"


lemma sim_lemma_col_7:
assumes "col PO1 PO2 PO3"
shows "col PO2 PO1 PO3"
proof -

(*1*)  
have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(*2*)  moreover 
{ assume "PO1 = PO2"
(*3*)  moreover
from `col PO1 PO2 PO3` and `PO1 = PO2`
have "col PO1 PO1 PO3"
by auto

(*4*)  moreover
from `col PO1 PO1 PO3` and `PO1 = PO2`
have "col PO2 PO1 PO3"
by auto

(*5*)  
ultimately
have ?thesis
by auto
} note note1 = this
(*6*)  moreover 
{ assume "PO1 ~= PO2"
(*7*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*8*)  moreover 
{ assume "PO1 = PO3"
(*9*)  moreover
from `col PO1 PO2 PO3` and `PO1 = PO3`
have "col PO1 PO2 PO1"
by auto

(*10*)  moreover
from `col PO1 PO2 PO1`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1" and "inc_po_l PO1 LI1"
using ax_D2 [of "PO1" "PO2" "PO1"]
by auto

(*11*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*12*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*13*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*14*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO2 PO1 PO1"
using ax_D1 [of "PO2" "LI1" "PO1" "PO1"]
by auto

(*15*)  moreover
from `col PO2 PO1 PO1` and `PO1 = PO3`
have "col PO2 PO1 PO3"
by auto

(*16*)  
ultimately
have ?thesis
by auto
} note note2 = this
(*17*)  moreover 
{ assume "PO1 ~= PO3"
(*18*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*19*)  moreover 
{ assume "PO2 = PO3"
(*20*)  moreover
from `col PO1 PO2 PO3` and `PO2 = PO3`
have "col PO1 PO2 PO2"
by auto

(*21*)  moreover
from `col PO1 PO2 PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1" and "inc_po_l PO2 LI1"
using ax_D2 [of "PO1" "PO2" "PO2"]
by auto

(*22*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*23*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*24*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*25*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO2 PO1 PO1"
using ax_D1 [of "PO2" "LI1" "PO1" "PO1"]
by auto

(*26*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO1 PO2"
using ax_D1 [of "PO2" "LI1" "PO1" "PO2"]
by auto

(*27*)  moreover
from `col PO2 PO1 PO2` and `PO2 = PO3`
have "col PO2 PO1 PO3"
by auto

(*28*)  
ultimately
have ?thesis
by auto
} note note3 = this
(*29*)  moreover 
{ assume "PO2 ~= PO3"
(*30*)  moreover
from `col PO1 PO2 PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1" and "inc_po_l PO3 LI1"
using ax_D2 [of "PO1" "PO2" "PO3"]
by auto

(*31*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*32*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*33*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*34*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*35*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*36*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO3 PO1"
using ax_D1 [of "PO1" "LI1" "PO3" "PO1"]
by auto

(*37*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO3 PO2"
using ax_D1 [of "PO1" "LI1" "PO3" "PO2"]
by auto

(*38*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO3 PO3"
using ax_D1 [of "PO1" "LI1" "PO3" "PO3"]
by auto

(*39*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO2 PO1 PO1"
using ax_D1 [of "PO2" "LI1" "PO1" "PO1"]
by auto

(*40*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO1 PO2"
using ax_D1 [of "PO2" "LI1" "PO1" "PO2"]
by auto

(*41*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO2 PO1 PO3"
using ax_D1 [of "PO2" "LI1" "PO1" "PO3"]
by auto

(*42*)  
ultimately
have ?thesis
by auto
} note note4 = this
(*43*)  from note3 and note4 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*44*)  
ultimately
have ?thesis
by auto
} note note5 = this
(*45*)  from note2 and note5 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*46*)  
ultimately
have ?thesis
by auto
} note note6 = this
(*47*)  from note1 and note6 and `PO1 = PO2 | PO1 ~= PO2`
have ?thesis
by auto
ultimately 
show ?thesis
by auto
qed
