theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"


lemma sim_lemma_ncol_8:
assumes "\<not>col PO1 PO2 PO3"
shows "\<not>col PO2 PO1 PO3"
proof -

(*1*)  
have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(*2*)  moreover 
{ assume "PO1 = PO2"
(*3*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(*4*)  moreover
from `\<not>col PO1 PO1 PO3` and `PO1 = PO2`
have "\<not>col PO2 PO1 PO3"
by auto

(*5*)  
ultimately
have ?thesis
by auto
} note note1 = this
(*6*)  moreover 
{ assume "PO1 ~= PO2"
(*7*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*8*)  moreover 
{ assume "PO1 = PO3"
(*9*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*10*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(*11*)  moreover
from `\<not>col PO1 PO2 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1"
using ax_I4a [of "PO1" "PO2" "PO1"]
by auto

(*12*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*13*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*14*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*15*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(*16*)  moreover
from `col PO1 PO2 PO1` and `\<not>col PO1 PO2 PO1`
have False
by auto

(*17*)  
ultimately
have False
by auto
} note note2 = this
(*18*)  moreover 
{ assume "PO1 ~= PO3"
(*19*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*20*)  moreover 
{ assume "PO2 = PO3"
(*21*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*22*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(*23*)  moreover
from `\<not>col PO1 PO2 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1"
using ax_I4a [of "PO1" "PO2" "PO2"]
by auto

(*24*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*25*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*26*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*27*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*28*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(*29*)  moreover
from `col PO1 PO2 PO2` and `\<not>col PO1 PO2 PO2`
have False
by auto

(*30*)  
ultimately
have False
by auto
} note note3 = this
(*31*)  moreover 
{ assume "PO2 ~= PO3"
(*32*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*33*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*34*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*35*)  moreover
from `\<not>col PO1 PO2 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1"
using ax_I4a [of "PO1" "PO2" "PO3"]
by auto

(*36*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO1 PO1"
using ax_D1 [of "PO1" "LI1" "PO1" "PO1"]
by auto

(*37*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO1 PO2"
using ax_D1 [of "PO1" "LI1" "PO1" "PO2"]
by auto

(*38*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*39*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*40*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1`
have  "col PO2 PO1 PO1"
using ax_D1 [of "PO2" "LI1" "PO1" "PO1"]
by auto

(*41*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO1 PO2"
using ax_D1 [of "PO2" "LI1" "PO1" "PO2"]
by auto

(*42*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO2 PO2 PO1"
using ax_D1 [of "PO2" "LI1" "PO2" "PO1"]
by auto

(*43*)  moreover
from `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO2 PO2 PO2"
using ax_D1 [of "PO2" "LI1" "PO2" "PO2"]
by auto

(*44*)  moreover

have  "int_l_l LI1 LI1 \<or> \<not>int_l_l LI1 LI1"
using ax_D6a [of "LI1" "LI1"]
by auto

(*45*)  moreover 
{ assume "int_l_l LI1 LI1"
(*46*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*47*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*48*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*49*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*50*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*51*)  
ultimately
have False
by auto
} note note4 = this
(*52*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*53*)  moreover
from `PO1 ~= PO2`
have  "PO2 ~= PO1"
by auto

(*54*)  moreover
from `PO2 ~= PO1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO2 PO1 PO3"
using ax_D1a [of "PO2" "PO1" "LI1" "PO3"]
by auto

(*55*)  
ultimately
have ?thesis
by auto
} note note5 = this
(*56*)  from note4 and note5 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*57*)  
ultimately
have ?thesis
by auto
} note note6 = this
(*58*)  moreover 
{ assume "\<not>int_l_l LI1 LI1"
(*59*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*60*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*61*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*62*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*63*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*64*)  
ultimately
have False
by auto
} note note7 = this
(*65*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*66*)  moreover
from `PO1 ~= PO2`
have  "PO2 ~= PO1"
by auto

(*67*)  moreover
from `PO2 ~= PO1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1` and `\<not>inc_po_l PO3 LI1`
have  "\<not>col PO2 PO1 PO3"
using ax_D1a [of "PO2" "PO1" "LI1" "PO3"]
by auto

(*68*)  
ultimately
have ?thesis
by auto
} note note8 = this
(*69*)  from note7 and note8 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*70*)  
ultimately
have ?thesis
by auto
} note note9 = this
(*71*)  from note6 and note9 and `int_l_l LI1 LI1 | \<not>int_l_l LI1 LI1`
have ?thesis
by auto
(*72*)  
ultimately
have ?thesis
by auto
} note note10 = this
(*73*)  from note3 and note10 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*74*)  
ultimately
have ?thesis
by auto
} note note11 = this
(*75*)  from note2 and note11 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*76*)  
ultimately
have ?thesis
by auto
} note note12 = this
(*77*)  from note1 and note12 and `PO1 = PO2 | PO1 ~= PO2`
have ?thesis
by auto
ultimately 
show ?thesis
by auto
qed
