theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"


lemma sim_lemma_comp_9:
assumes "comp PO1 PO2 PO3 PO4"
shows "comp PO2 PO3 PO4 PO1"
proof -

(*1*)  
have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(*2*)  moreover 
{ assume "PO1 = PO2"
(*3*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*4*)  moreover 
{ assume "PO1 = PO3"
(*5*)  moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(*6*)  moreover 
{ assume "PO1 = PO4"
(*7*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2` and `PO1 = PO3` and `PO1 = PO4`
have "comp PO1 PO1 PO1 PO1"
by auto

(*8*)  moreover
from `comp PO1 PO1 PO1 PO1` and `PO1 = PO2` and `PO1 = PO3` and `PO1 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*9*)  
ultimately
have ?thesis
by auto
} note note1 = this
(*10*)  moreover 
{ assume "PO1 ~= PO4"
(*11*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2` and `PO1 = PO3`
have "comp PO1 PO1 PO1 PO4"
by auto

(*12*)  moreover
from `comp PO1 PO1 PO1 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO4 PL1"
using ax_D4 [of "PO1" "PO1" "PO1" "PO4"]
by auto

(*13*)  moreover
from `PO1 ~= PO4`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO4 LI1"
using ax_I1 [of "PO1" "PO4"]
by auto

(*14*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*15*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO1"]
by auto

(*16*)  moreover
from `comp PO1 PO1 PO4 PO1` and `PO1 = PO2` and `PO1 = PO3`
have "comp PO2 PO3 PO4 PO1"
by auto

(*17*)  
ultimately
have ?thesis
by auto
} note note2 = this
(*18*)  from note1 and note2 and `PO1 = PO4 | PO1 ~= PO4`
have ?thesis
by auto
(*19*)  
ultimately
have ?thesis
by auto
} note note3 = this
(*20*)  moreover 
{ assume "PO1 ~= PO3"
(*21*)  moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(*22*)  moreover 
{ assume "PO1 = PO4"
(*23*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2` and `PO1 = PO4`
have "comp PO1 PO1 PO3 PO1"
by auto

(*24*)  moreover
from `comp PO1 PO1 PO3 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO1 PL1"
using ax_D4 [of "PO1" "PO1" "PO3" "PO1"]
by auto

(*25*)  moreover
from `PO1 ~= PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO3 LI1"
using ax_I1 [of "PO1" "PO3"]
by auto

(*26*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*27*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*28*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*29*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*30*)  moreover
from `comp PO1 PO3 PO1 PO1` and `PO1 = PO2` and `PO1 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*31*)  
ultimately
have ?thesis
by auto
} note note4 = this
(*32*)  moreover 
{ assume "PO1 ~= PO4"
(*33*)  moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(*34*)  moreover 
{ assume "PO3 = PO4"
(*35*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2` and `PO3 = PO4`
have "comp PO1 PO1 PO3 PO3"
by auto

(*36*)  moreover
from `comp PO1 PO1 PO3 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO3 PL1"
using ax_D4 [of "PO1" "PO1" "PO3" "PO3"]
by auto

(*37*)  moreover
from `PO1 ~= PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO3 LI1"
using ax_I1 [of "PO1" "PO3"]
by auto

(*38*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*39*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*40*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*41*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*42*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*43*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*44*)  moreover
from `comp PO1 PO3 PO3 PO1` and `PO1 = PO2` and `PO3 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*45*)  
ultimately
have ?thesis
by auto
} note note5 = this
(*46*)  moreover 
{ assume "PO3 ~= PO4"
(*47*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO2`
have "comp PO1 PO1 PO3 PO4"
by auto

(*48*)  moreover
from `comp PO1 PO1 PO3 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO4 PL1"
using ax_D4 [of "PO1" "PO1" "PO3" "PO4"]
by auto

(*49*)  moreover
from `PO1 ~= PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO3 LI1"
using ax_I1 [of "PO1" "PO3"]
by auto

(*50*)  moreover
from `PO1 ~= PO4`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO4 LI2"
using ax_I1 [of "PO1" "PO4"]
by auto

(*51*)  moreover
from `PO3 ~= PO4`
obtain  LI3::line
where "inc_po_l PO3 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO3" "PO4"]
by auto

(*52*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*53*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*54*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(*55*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*56*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*57*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO1"]
by auto

(*58*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO3"]
by auto

(*59*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(*60*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*61*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*62*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO4"]
by auto

(*63*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*64*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*65*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(*66*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO1"]
by auto

(*67*)  moreover
from `comp PO1 PO3 PO4 PO1` and `PO1 = PO2`
have "comp PO2 PO3 PO4 PO1"
by auto

(*68*)  
ultimately
have ?thesis
by auto
} note note6 = this
(*69*)  from note5 and note6 and `PO3 = PO4 | PO3 ~= PO4`
have ?thesis
by auto
(*70*)  
ultimately
have ?thesis
by auto
} note note7 = this
(*71*)  from note4 and note7 and `PO1 = PO4 | PO1 ~= PO4`
have ?thesis
by auto
(*72*)  
ultimately
have ?thesis
by auto
} note note8 = this
(*73*)  from note3 and note8 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*74*)  
ultimately
have ?thesis
by auto
} note note9 = this
(*75*)  moreover 
{ assume "PO1 ~= PO2"
(*76*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*77*)  moreover 
{ assume "PO1 = PO3"
(*78*)  moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(*79*)  moreover 
{ assume "PO1 = PO4"
(*80*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3` and `PO1 = PO4`
have "comp PO1 PO2 PO1 PO1"
by auto

(*81*)  moreover
from `comp PO1 PO2 PO1 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO1 PL1"
using ax_D4 [of "PO1" "PO2" "PO1" "PO1"]
by auto

(*82*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*83*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*84*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*85*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*86*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*87*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*88*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*89*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*90*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*91*)  moreover
from `comp PO2 PO1 PO1 PO1` and `PO1 = PO3` and `PO1 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*92*)  
ultimately
have ?thesis
by auto
} note note10 = this
(*93*)  moreover 
{ assume "PO1 ~= PO4"
(*94*)  moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(*95*)  moreover 
{ assume "PO2 = PO4"
(*96*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3` and `PO2 = PO4`
have "comp PO1 PO2 PO1 PO2"
by auto

(*97*)  moreover
from `comp PO1 PO2 PO1 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1"
using ax_D4 [of "PO1" "PO2" "PO1" "PO2"]
by auto

(*98*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*99*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*100*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*101*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*102*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*103*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*104*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*105*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*106*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*107*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*108*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*109*)  moreover
from `comp PO2 PO1 PO2 PO1` and `PO1 = PO3` and `PO2 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*110*)  
ultimately
have ?thesis
by auto
} note note11 = this
(*111*)  moreover 
{ assume "PO2 ~= PO4"
(*112*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO3`
have "comp PO1 PO2 PO1 PO4"
by auto

(*113*)  moreover
from `comp PO1 PO2 PO1 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1" and "inc_po_pl PO4 PL1"
using ax_D4 [of "PO1" "PO2" "PO1" "PO4"]
by auto

(*114*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*115*)  moreover
from `PO1 ~= PO4`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO4 LI2"
using ax_I1 [of "PO1" "PO4"]
by auto

(*116*)  moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(*117*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*118*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*119*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(*120*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*121*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*122*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(*123*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO1"]
by auto

(*124*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO2"]
by auto

(*125*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(*126*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*127*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*128*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*129*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*130*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(*131*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO1"]
by auto

(*132*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO2"]
by auto

(*133*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(*134*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO1"]
by auto

(*135*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO2"]
by auto

(*136*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO4"]
by auto

(*137*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO1"]
by auto

(*138*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO2"]
by auto

(*139*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO4"]
by auto

(*140*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO1"]
by auto

(*141*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO2"]
by auto

(*142*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(*143*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*144*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*145*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO4"]
by auto

(*146*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*147*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*148*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO4"]
by auto

(*149*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO4 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO4" "PO1"]
by auto

(*150*)  moreover
from `comp PO2 PO1 PO4 PO1` and `PO1 = PO3`
have "comp PO2 PO3 PO4 PO1"
by auto

(*151*)  
ultimately
have ?thesis
by auto
} note note12 = this
(*152*)  from note11 and note12 and `PO2 = PO4 | PO2 ~= PO4`
have ?thesis
by auto
(*153*)  
ultimately
have ?thesis
by auto
} note note13 = this
(*154*)  from note10 and note13 and `PO1 = PO4 | PO1 ~= PO4`
have ?thesis
by auto
(*155*)  
ultimately
have ?thesis
by auto
} note note14 = this
(*156*)  moreover 
{ assume "PO1 ~= PO3"
(*157*)  moreover

have  "PO1 = PO4 \<or> PO1 ~= PO4"
using ax_g1 [of "PO1" "PO4"]
by auto

(*158*)  moreover 
{ assume "PO1 = PO4"
(*159*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*160*)  moreover 
{ assume "PO2 = PO3"
(*161*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3` and `PO1 = PO4`
have "comp PO1 PO2 PO2 PO1"
by auto

(*162*)  moreover
from `comp PO1 PO2 PO2 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO1 PL1"
using ax_D4 [of "PO1" "PO2" "PO2" "PO1"]
by auto

(*163*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*164*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*165*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*166*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*167*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*168*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*169*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*170*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*171*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*172*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*173*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*174*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*175*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO1"]
by auto

(*176*)  moreover
from `comp PO2 PO2 PO1 PO1` and `PO2 = PO3` and `PO1 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*177*)  
ultimately
have ?thesis
by auto
} note note15 = this
(*178*)  moreover 
{ assume "PO2 ~= PO3"
(*179*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO1 = PO4`
have "comp PO1 PO2 PO3 PO1"
by auto

(*180*)  moreover
from `comp PO1 PO2 PO3 PO1`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO1 PL1"
using ax_D4 [of "PO1" "PO2" "PO3" "PO1"]
by auto

(*181*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*182*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*183*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*184*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*185*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*186*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*187*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*188*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*189*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(*190*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*191*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO2"]
by auto

(*192*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*193*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*194*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*195*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO3"]
by auto

(*196*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*197*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*198*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(*199*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO2"]
by auto

(*200*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(*201*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*202*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO2"]
by auto

(*203*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*204*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO1"]
by auto

(*205*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO2"]
by auto

(*206*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO3"]
by auto

(*207*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*208*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO2"]
by auto

(*209*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*210*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*211*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*212*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO3"]
by auto

(*213*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*214*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*215*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO3"]
by auto

(*216*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO1"]
by auto

(*217*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO2"]
by auto

(*218*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO3"]
by auto

(*219*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO1"]
by auto

(*220*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO2"]
by auto

(*221*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO3"]
by auto

(*222*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO1"]
by auto

(*223*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(*224*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(*225*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO1"]
by auto

(*226*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO2"]
by auto

(*227*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(*228*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO1"]
by auto

(*229*)  moreover
from `comp PO2 PO3 PO1 PO1` and `PO1 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*230*)  
ultimately
have ?thesis
by auto
} note note16 = this
(*231*)  from note15 and note16 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*232*)  
ultimately
have ?thesis
by auto
} note note17 = this
(*233*)  moreover 
{ assume "PO1 ~= PO4"
(*234*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*235*)  moreover 
{ assume "PO2 = PO3"
(*236*)  moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(*237*)  moreover 
{ assume "PO2 = PO4"
(*238*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3` and `PO2 = PO4`
have "comp PO1 PO2 PO2 PO2"
by auto

(*239*)  moreover
from `comp PO1 PO2 PO2 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1"
using ax_D4 [of "PO1" "PO2" "PO2" "PO2"]
by auto

(*240*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*241*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*242*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*243*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*244*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*245*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*246*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*247*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*248*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*249*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*250*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*251*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*252*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO1"]
by auto

(*253*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO2"]
by auto

(*254*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO1"]
by auto

(*255*)  moreover
from `comp PO2 PO2 PO2 PO1` and `PO2 = PO3` and `PO2 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*256*)  
ultimately
have ?thesis
by auto
} note note18 = this
(*257*)  moreover 
{ assume "PO2 ~= PO4"
(*258*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO3`
have "comp PO1 PO2 PO2 PO4"
by auto

(*259*)  moreover
from `comp PO1 PO2 PO2 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO4 PL1"
using ax_D4 [of "PO1" "PO2" "PO2" "PO4"]
by auto

(*260*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*261*)  moreover
from `PO1 ~= PO4`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO4 LI2"
using ax_I1 [of "PO1" "PO4"]
by auto

(*262*)  moreover
from `PO2 ~= PO4`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO2" "PO4"]
by auto

(*263*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*264*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*265*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(*266*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*267*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*268*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(*269*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO1"]
by auto

(*270*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO2"]
by auto

(*271*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(*272*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*273*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*274*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO4"]
by auto

(*275*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*276*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*277*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO1"]
by auto

(*278*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO2"]
by auto

(*279*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(*280*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO1"]
by auto

(*281*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO2"]
by auto

(*282*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO4"]
by auto

(*283*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO1"]
by auto

(*284*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO2"]
by auto

(*285*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO4"]
by auto

(*286*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO1"]
by auto

(*287*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO2"]
by auto

(*288*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(*289*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*290*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*291*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO4"]
by auto

(*292*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*293*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*294*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO4"]
by auto

(*295*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO4 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO4" "PO1"]
by auto

(*296*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO4 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO4" "PO2"]
by auto

(*297*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO4" "PO4"]
by auto

(*298*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO1"]
by auto

(*299*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO2"]
by auto

(*300*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO4"]
by auto

(*301*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO1"]
by auto

(*302*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(*303*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

(*304*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO4 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO1"]
by auto

(*305*)  moreover
from `comp PO2 PO2 PO4 PO1` and `PO2 = PO3`
have "comp PO2 PO3 PO4 PO1"
by auto

(*306*)  
ultimately
have ?thesis
by auto
} note note19 = this
(*307*)  from note18 and note19 and `PO2 = PO4 | PO2 ~= PO4`
have ?thesis
by auto
(*308*)  
ultimately
have ?thesis
by auto
} note note20 = this
(*309*)  moreover 
{ assume "PO2 ~= PO3"
(*310*)  moreover

have  "PO2 = PO4 \<or> PO2 ~= PO4"
using ax_g1 [of "PO2" "PO4"]
by auto

(*311*)  moreover 
{ assume "PO2 = PO4"
(*312*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO2 = PO4`
have "comp PO1 PO2 PO3 PO2"
by auto

(*313*)  moreover
from `comp PO1 PO2 PO3 PO2`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO2 PL1"
using ax_D4 [of "PO1" "PO2" "PO3" "PO2"]
by auto

(*314*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*315*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*316*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*317*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*318*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*319*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*320*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*321*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*322*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(*323*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*324*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO2"]
by auto

(*325*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*326*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*327*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*328*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO3"]
by auto

(*329*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*330*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*331*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(*332*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO1"]
by auto

(*333*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(*334*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*335*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO2"]
by auto

(*336*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*337*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO1"]
by auto

(*338*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO2"]
by auto

(*339*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO3"]
by auto

(*340*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*341*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO2"]
by auto

(*342*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*343*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*344*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*345*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO3"]
by auto

(*346*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*347*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*348*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO3"]
by auto

(*349*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO1"]
by auto

(*350*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO2"]
by auto

(*351*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO3"]
by auto

(*352*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO1"]
by auto

(*353*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO2"]
by auto

(*354*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO3"]
by auto

(*355*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO1"]
by auto

(*356*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(*357*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(*358*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO1"]
by auto

(*359*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO2"]
by auto

(*360*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(*361*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO1"]
by auto

(*362*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO3 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO2"]
by auto

(*363*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO3"]
by auto

(*364*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO2" "PO1"]
by auto

(*365*)  moreover
from `comp PO2 PO3 PO2 PO1` and `PO2 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*366*)  
ultimately
have ?thesis
by auto
} note note21 = this
(*367*)  moreover 
{ assume "PO2 ~= PO4"
(*368*)  moreover

have  "PO3 = PO4 \<or> PO3 ~= PO4"
using ax_g1 [of "PO3" "PO4"]
by auto

(*369*)  moreover 
{ assume "PO3 = PO4"
(*370*)  moreover
from `comp PO1 PO2 PO3 PO4` and `PO3 = PO4`
have "comp PO1 PO2 PO3 PO3"
by auto

(*371*)  moreover
from `comp PO1 PO2 PO3 PO3`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO3 PL1"
using ax_D4 [of "PO1" "PO2" "PO3" "PO3"]
by auto

(*372*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*373*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*374*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*375*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*376*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*377*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*378*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*379*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*380*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(*381*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*382*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO2"]
by auto

(*383*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*384*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*385*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*386*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO3"]
by auto

(*387*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*388*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*389*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(*390*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO1"]
by auto

(*391*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO2"]
by auto

(*392*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*393*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO2"]
by auto

(*394*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*395*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO1"]
by auto

(*396*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO2"]
by auto

(*397*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO3"]
by auto

(*398*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*399*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO2"]
by auto

(*400*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*401*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*402*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*403*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO3"]
by auto

(*404*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*405*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*406*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO3"]
by auto

(*407*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO1"]
by auto

(*408*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO2"]
by auto

(*409*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO3"]
by auto

(*410*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO1"]
by auto

(*411*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO2"]
by auto

(*412*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO3"]
by auto

(*413*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO1"]
by auto

(*414*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(*415*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(*416*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO1"]
by auto

(*417*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO2"]
by auto

(*418*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(*419*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO1"]
by auto

(*420*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO3 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO2"]
by auto

(*421*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO3"]
by auto

(*422*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO2" "PO1"]
by auto

(*423*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO3 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO3" "PO2" "PO2"]
by auto

(*424*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO2" "PO3"]
by auto

(*425*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO1"]
by auto

(*426*)  moreover
from `comp PO2 PO3 PO3 PO1` and `PO3 = PO4`
have "comp PO2 PO3 PO4 PO1"
by auto

(*427*)  
ultimately
have ?thesis
by auto
} note note22 = this
(*428*)  moreover 
{ assume "PO3 ~= PO4"
(*429*)  moreover
from `comp PO1 PO2 PO3 PO4`
obtain  PL1::plane
where "inc_po_pl PO1 PL1" and "inc_po_pl PO2 PL1" and "inc_po_pl PO3 PL1" and "inc_po_pl PO4 PL1"
using ax_D4 [of "PO1" "PO2" "PO3" "PO4"]
by auto

(*430*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*431*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*432*)  moreover
from `PO1 ~= PO4`
obtain  LI3::line
where "inc_po_l PO1 LI3" and "inc_po_l PO4 LI3"
using ax_I1 [of "PO1" "PO4"]
by auto

(*433*)  moreover
from `PO2 ~= PO3`
obtain  LI4::line
where "inc_po_l PO2 LI4" and "inc_po_l PO3 LI4"
using ax_I1 [of "PO2" "PO3"]
by auto

(*434*)  moreover
from `PO2 ~= PO4`
obtain  LI5::line
where "inc_po_l PO2 LI5" and "inc_po_l PO4 LI5"
using ax_I1 [of "PO2" "PO4"]
by auto

(*435*)  moreover
from `PO3 ~= PO4`
obtain  LI6::line
where "inc_po_l PO3 LI6" and "inc_po_l PO4 LI6"
using ax_I1 [of "PO3" "PO4"]
by auto

(*436*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO1"]
by auto

(*437*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO2"]
by auto

(*438*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO3"]
by auto

(*439*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO1" "PO4"]
by auto

(*440*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO1"]
by auto

(*441*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO2"]
by auto

(*442*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO3"]
by auto

(*443*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO2" "PO4"]
by auto

(*444*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO1"]
by auto

(*445*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO2"]
by auto

(*446*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO3"]
by auto

(*447*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO3" "PO4"]
by auto

(*448*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO1 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO1"]
by auto

(*449*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO1 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO2"]
by auto

(*450*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO1 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO3"]
by auto

(*451*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO1 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO1" "PO4" "PO4"]
by auto

(*452*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO1"]
by auto

(*453*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO2"]
by auto

(*454*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO3"]
by auto

(*455*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO1" "PO4"]
by auto

(*456*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO1"]
by auto

(*457*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO2"]
by auto

(*458*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO3"]
by auto

(*459*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO2" "PO4"]
by auto

(*460*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO1"]
by auto

(*461*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO2"]
by auto

(*462*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO3" "PO3"]
by auto

(*463*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO2 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO1"]
by auto

(*464*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO2 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO2"]
by auto

(*465*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO2 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO3"]
by auto

(*466*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO2 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO2" "PO4" "PO4"]
by auto

(*467*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO1"]
by auto

(*468*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO2"]
by auto

(*469*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO3"]
by auto

(*470*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO1" "PO4"]
by auto

(*471*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO1"]
by auto

(*472*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO2"]
by auto

(*473*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO3"]
by auto

(*474*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO2" "PO4"]
by auto

(*475*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO1"]
by auto

(*476*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO2"]
by auto

(*477*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO3"]
by auto

(*478*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO3" "PO4"]
by auto

(*479*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO3 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO1"]
by auto

(*480*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO3 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO2"]
by auto

(*481*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO3 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO3"]
by auto

(*482*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO3 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO3" "PO4" "PO4"]
by auto

(*483*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO1 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO1"]
by auto

(*484*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO1 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO2"]
by auto

(*485*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO4 PO1 PO3"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO3"]
by auto

(*486*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO1 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO1" "PO4"]
by auto

(*487*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO2 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO1"]
by auto

(*488*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO2 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO2"]
by auto

(*489*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO4 PO2 PO3"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO3"]
by auto

(*490*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO2 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO2" "PO4"]
by auto

(*491*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO3 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO3" "PO1"]
by auto

(*492*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO3 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO3" "PO2"]
by auto

(*493*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO4 PO3 PO3"
using ax_D3 [of "PO1" "PL1" "PO4" "PO3" "PO3"]
by auto

(*494*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO3 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO3" "PO4"]
by auto

(*495*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO1 PO4 PO4 PO1"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO1"]
by auto

(*496*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO1 PO4 PO4 PO2"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO2"]
by auto

(*497*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO1 PO4 PO4 PO3"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO3"]
by auto

(*498*)  moreover
from `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO1 PO4 PO4 PO4"
using ax_D3 [of "PO1" "PL1" "PO4" "PO4" "PO4"]
by auto

(*499*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO1"]
by auto

(*500*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO2"]
by auto

(*501*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO3"]
by auto

(*502*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO1" "PO4"]
by auto

(*503*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO1"]
by auto

(*504*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO2"]
by auto

(*505*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO3"]
by auto

(*506*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO2" "PO4"]
by auto

(*507*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO1"]
by auto

(*508*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO2"]
by auto

(*509*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO3"]
by auto

(*510*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO3" "PO4"]
by auto

(*511*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO1 PO4 PO1"
using ax_D3 [of "PO2" "PL1" "PO1" "PO4" "PO1"]
by auto

(*512*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO1 PO4 PO2"
using ax_D3 [of "PO2" "PL1" "PO1" "PO4" "PO2"]
by auto

(*513*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO1 PO4 PO3"
using ax_D3 [of "PO2" "PL1" "PO1" "PO4" "PO3"]
by auto

(*514*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO1 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO1" "PO4" "PO4"]
by auto

(*515*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO1"]
by auto

(*516*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO2"]
by auto

(*517*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO3"]
by auto

(*518*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO1" "PO4"]
by auto

(*519*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO1"]
by auto

(*520*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO2"]
by auto

(*521*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO3"]
by auto

(*522*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO2" "PO4"]
by auto

(*523*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO1"]
by auto

(*524*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO2"]
by auto

(*525*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO3"]
by auto

(*526*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO3" "PO4"]
by auto

(*527*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO2 PO4 PO1"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO1"]
by auto

(*528*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO2 PO4 PO2"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO2"]
by auto

(*529*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO2 PO4 PO3"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO3"]
by auto

(*530*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO2 PO4 PO4"
using ax_D3 [of "PO2" "PL1" "PO2" "PO4" "PO4"]
by auto

(*531*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO1 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO1"]
by auto

(*532*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO3 PO1 PO2"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO2"]
by auto

(*533*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO1 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO3"]
by auto

(*534*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO1 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO1" "PO4"]
by auto

(*535*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO2 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO2" "PO1"]
by auto

(*536*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO3 PO2 PO2"
using ax_D3 [of "PO2" "PL1" "PO3" "PO2" "PO2"]
by auto

(*537*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO2 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO2" "PO3"]
by auto

(*538*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO2 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO2" "PO4"]
by auto

(*539*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO3 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO1"]
by auto

(*540*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO2 PL1`
have  "comp PO2 PO3 PO3 PO2"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO2"]
by auto

(*541*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1`
have  "comp PO2 PO3 PO3 PO3"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO3"]
by auto

(*542*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1`
have  "comp PO2 PO3 PO3 PO4"
using ax_D3 [of "PO2" "PL1" "PO3" "PO3" "PO4"]
by auto

(*543*)  moreover
from `inc_po_pl PO2 PL1` and `inc_po_pl PO3 PL1` and `inc_po_pl PO4 PL1` and `inc_po_pl PO1 PL1`
have  "comp PO2 PO3 PO4 PO1"
using ax_D3 [of "PO2" "PL1" "PO3" "PO4" "PO1"]
by auto

(*544*)  
ultimately
have ?thesis
by auto
} note note23 = this
(*545*)  from note22 and note23 and `PO3 = PO4 | PO3 ~= PO4`
have ?thesis
by auto
(*546*)  
ultimately
have ?thesis
by auto
} note note24 = this
(*547*)  from note21 and note24 and `PO2 = PO4 | PO2 ~= PO4`
have ?thesis
by auto
(*548*)  
ultimately
have ?thesis
by auto
} note note25 = this
(*549*)  from note20 and note25 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*550*)  
ultimately
have ?thesis
by auto
} note note26 = this
(*551*)  from note17 and note26 and `PO1 = PO4 | PO1 ~= PO4`
have ?thesis
by auto
(*552*)  
ultimately
have ?thesis
by auto
} note note27 = this
(*553*)  from note14 and note27 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*554*)  
ultimately
have ?thesis
by auto
} note note28 = this
(*555*)  from note9 and note28 and `PO1 = PO2 | PO1 ~= PO2`
have ?thesis
by auto
ultimately 
show ?thesis
by auto
qed
