theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> \<not>inc_po_l PO3 LI4 \<Longrightarrow> \<not>col PO1 PO2 PO3"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> comp PO1 PO2 PO3 PO4"

and
ax_D3a: "\<not>col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> \<not>inc_po_pl PO4 PL5 \<Longrightarrow> \<not>comp PO1 PO2 PO3 PO4"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9: "\<not>inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D11b: "inc_po_l PO1 LI2 \<and> \<not>inc_po_pl PO1 PL3 \<Longrightarrow> \<not>inc_l_pl LI2 PL3"

and
ax_I2: "PO3 ~= PO4 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO4 LI1 \<and> inc_po_l PO3 LI2 \<and> inc_po_l PO4 LI2 \<Longrightarrow> LI1 = LI2"

and
ax_I5: "\<not>col PO3 PO4 PO5 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO5 PL1 \<and> inc_po_pl PO3 PL2 \<and> inc_po_pl PO4 PL2 \<and> inc_po_pl PO5 PL2 \<Longrightarrow> PL1 = PL2"

and
ax_I6: "inc_po_l PO3 LI2 \<and> PO3 ~= PO4 \<and> inc_po_l PO4 LI2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO4 PL1 \<Longrightarrow> inc_l_pl LI2 PL1"

and
ax_D6a: "int_l_l LI1 LI2 \<or> \<not>int_l_l LI1 LI2"

and
ax_D8a: "int_pl_pl PL1 PL2 \<or> \<not>int_pl_pl PL1 PL2"

and
ax_D10a: "int_l_pl LI1 PL2 \<or> \<not>int_l_pl LI1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<and> LI1 ~= LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<and> PL1 ~= PL2)"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> \<not>inc_l_pl LI1 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO1::point) (PO2::point). inc_po_l PO1 LI3 \<and> PO1 ~= PO2 \<and> inc_po_l PO2 LI3)"

and
ax_I4a: "\<not>col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). \<not>col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). \<not>comp PO1 PO2 PO3 PO4)"


lemma sim_lemma_ncol_6:
assumes "\<not>col PO1 PO2 PO3"
shows "\<not>col PO2 PO3 PO1"
proof -

(*1*)  
have  "PO1 = PO2 \<or> PO1 ~= PO2"
using ax_g1 [of "PO1" "PO2"]
by auto

(*2*)  moreover 
{ assume "PO1 = PO2"
(*3*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*4*)  moreover 
{ assume "PO1 = PO3"
(*5*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO1 PO1 PO1"
by auto

(*6*)  moreover
from `\<not>col PO1 PO1 PO1` and `PO1 = PO2` and `PO1 = PO3`
have "\<not>col PO2 PO3 PO1"
by auto

(*7*)  
ultimately
have ?thesis
by auto
} note note1 = this
(*8*)  moreover 
{ assume "PO1 ~= PO3"
(*9*)  moreover
from `PO1 ~= PO3`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO3 LI1"
using ax_I1 [of "PO1" "PO3"]
by auto

(*10*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(*11*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO1 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO1 PO3"
using ax_D1 [of "PO1" "LI1" "PO1" "PO3"]
by auto

(*12*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO2`
have "\<not>col PO1 PO1 PO3"
by auto

(*13*)  moreover
from `col PO1 PO1 PO3` and `\<not>col PO1 PO1 PO3`
have False
by auto

(*14*)  
ultimately
have False
by auto
} note note2 = this
(*15*)  from note1 and note2 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*16*)  
ultimately
have ?thesis
by auto
} note note3 = this
(*17*)  moreover 
{ assume "PO1 ~= PO2"
(*18*)  moreover

have  "PO1 = PO3 \<or> PO1 ~= PO3"
using ax_g1 [of "PO1" "PO3"]
by auto

(*19*)  moreover 
{ assume "PO1 = PO3"
(*20*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*21*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(*22*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO1 LI1`
have  "col PO1 PO2 PO1"
using ax_D1 [of "PO1" "LI1" "PO2" "PO1"]
by auto

(*23*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO1 = PO3`
have "\<not>col PO1 PO2 PO1"
by auto

(*24*)  moreover
from `col PO1 PO2 PO1` and `\<not>col PO1 PO2 PO1`
have False
by auto

(*25*)  
ultimately
have False
by auto
} note note4 = this
(*26*)  moreover 
{ assume "PO1 ~= PO3"
(*27*)  moreover

have  "PO2 = PO3 \<or> PO2 ~= PO3"
using ax_g1 [of "PO2" "PO3"]
by auto

(*28*)  moreover 
{ assume "PO2 = PO3"
(*29*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*30*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(*31*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO2 LI1`
have  "col PO1 PO2 PO2"
using ax_D1 [of "PO1" "LI1" "PO2" "PO2"]
by auto

(*32*)  moreover
from `\<not>col PO1 PO2 PO3` and `PO2 = PO3`
have "\<not>col PO1 PO2 PO2"
by auto

(*33*)  moreover
from `col PO1 PO2 PO2` and `\<not>col PO1 PO2 PO2`
have False
by auto

(*34*)  
ultimately
have False
by auto
} note note5 = this
(*35*)  moreover 
{ assume "PO2 ~= PO3"
(*36*)  moreover
from `PO1 ~= PO2`
obtain  LI1::line
where "inc_po_l PO1 LI1" and "inc_po_l PO2 LI1"
using ax_I1 [of "PO1" "PO2"]
by auto

(*37*)  moreover
from `PO1 ~= PO3`
obtain  LI2::line
where "inc_po_l PO1 LI2" and "inc_po_l PO3 LI2"
using ax_I1 [of "PO1" "PO3"]
by auto

(*38*)  moreover
from `PO2 ~= PO3`
obtain  LI3::line
where "inc_po_l PO2 LI3" and "inc_po_l PO3 LI3"
using ax_I1 [of "PO2" "PO3"]
by auto

(*39*)  moreover

have  "inc_po_l PO3 LI1 \<or> \<not>inc_po_l PO3 LI1"
using ax_g4 [of "PO3" "LI1"]
by auto

(*40*)  moreover 
{ assume "inc_po_l PO3 LI1"
(*41*)  moreover
from `inc_po_l PO1 LI1` and `inc_po_l PO2 LI1` and `inc_po_l PO3 LI1`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI1" "PO2" "PO3"]
by auto

(*42*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*43*)  
ultimately
have False
by auto
} note note9 = this
(*44*)  moreover 
{ assume "\<not>inc_po_l PO3 LI1"
(*45*)  moreover

have  "inc_po_l PO2 LI2 \<or> \<not>inc_po_l PO2 LI2"
using ax_g4 [of "PO2" "LI2"]
by auto

(*46*)  moreover 
{ assume "inc_po_l PO2 LI2"
(*47*)  moreover
from `inc_po_l PO1 LI2` and `inc_po_l PO2 LI2` and `inc_po_l PO3 LI2`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI2" "PO2" "PO3"]
by auto

(*48*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*49*)  
ultimately
have False
by auto
} note note16 = this
(*50*)  moreover 
{ assume "\<not>inc_po_l PO2 LI2"
(*51*)  moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(*52*)  moreover 
{ assume "inc_po_l PO1 LI3"
(*53*)  moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI3" "PO2" "PO3"]
by auto

(*54*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*55*)  
ultimately
have False
by auto
} note note19 = this
(*56*)  moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(*57*)  moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `\<not>inc_po_l PO1 LI3`
have  "\<not>col PO2 PO3 PO1"
using ax_D1a [of "PO2" "PO3" "LI3" "PO1"]
by auto

(*58*)  
ultimately
have ?thesis
by auto
} note note20 = this
(*59*)  from note19 and note20 and `inc_po_l PO1 LI3 | \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(*60*)  moreover

have  "inc_po_l PO1 LI3 \<or> \<not>inc_po_l PO1 LI3"
using ax_g4 [of "PO1" "LI3"]
by auto

(*61*)  moreover 
{ assume "inc_po_l PO1 LI3"
(*62*)  moreover
from `inc_po_l PO1 LI3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3`
have  "col PO1 PO2 PO3"
using ax_D1 [of "PO1" "LI3" "PO2" "PO3"]
by auto

(*63*)  moreover
from `col PO1 PO2 PO3` and `\<not>col PO1 PO2 PO3`
have False
by auto

(*64*)  
ultimately
have False
by auto
} note note26 = this
(*65*)  moreover 
{ assume "\<not>inc_po_l PO1 LI3"
(*66*)  moreover
from `PO2 ~= PO3` and `inc_po_l PO2 LI3` and `inc_po_l PO3 LI3` and `\<not>inc_po_l PO1 LI3`
have  "\<not>col PO2 PO3 PO1"
using ax_D1a [of "PO2" "PO3" "LI3" "PO1"]
by auto

(*67*)  
ultimately
have ?thesis
by auto
} note note27 = this
(*68*)  from note26 and note27 and `inc_po_l PO1 LI3 | \<not>inc_po_l PO1 LI3`
have ?thesis
by auto
(*69*)  
ultimately
have ?thesis
by auto
} note note163 = this
(*70*)  from note16 and note163 and `inc_po_l PO2 LI2 | \<not>inc_po_l PO2 LI2`
have ?thesis
by auto
(*71*)  
ultimately
have ?thesis
by auto
} note note190 = this
(*72*)  from note9 and note190 and `inc_po_l PO3 LI1 | \<not>inc_po_l PO3 LI1`
have ?thesis
by auto
(*73*)  
ultimately
have ?thesis
by auto
} note note192 = this
(*74*)  from note5 and note192 and `PO2 = PO3 | PO2 ~= PO3`
have ?thesis
by auto
(*75*)  
ultimately
have ?thesis
by auto
} note note193 = this
(*76*)  from note4 and note193 and `PO1 = PO3 | PO1 ~= PO3`
have ?thesis
by auto
(*77*)  
ultimately
have ?thesis
by auto
} note note194 = this
(*78*)  from note3 and note194 and `PO1 = PO2 | PO1 ~= PO2`
have ?thesis
by auto
ultimately 
show ?thesis
by auto
qed
