theory Geometry
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts comp :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"

axiomatization where
ax_int_l_l_21: "int_l_l LI1 LI2 \<Longrightarrow> int_l_l LI2 LI1"

and
ax_nint_l_l_21: "\<not>int_l_l LI1 LI2 \<Longrightarrow> \<not>int_l_l LI2 LI1"

and
ax_int_pl_pl_21: "int_pl_pl PL1 PL2 \<Longrightarrow> int_pl_pl PL2 PL1"

and
ax_nint_pl_pl_21: "\<not>int_pl_pl PL1 PL2 \<Longrightarrow> \<not>int_pl_pl PL2 PL1"

and
ax_col_312: "col PO1 PO2 PO3 \<Longrightarrow> col PO2 PO3 PO1"

and
ax_ncol_312: "\<not>col PO1 PO2 PO3 \<Longrightarrow> \<not>col PO2 PO3 PO1"

and
ax_col_213: "col PO1 PO2 PO3 \<Longrightarrow> col PO2 PO1 PO3"

and
ax_ncol_213: "\<not>col PO1 PO2 PO3 \<Longrightarrow> \<not>col PO2 PO1 PO3"

and
ax_comp_4123: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> comp PO2 PO3 PO4 PO1"

and
ax_comp_2134: "comp PO1 PO2 PO3 PO4 \<Longrightarrow> comp PO2 PO1 PO3 PO4"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> \<not>inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> \<not>inc_po_pl PO1 PL2"


lemma ax_col_213:
assumes "col PO2 PO1 PO3"
shows "col PO1 PO2 PO3"
proof -

(*1*)  from `col PO2 PO1 PO3`
have  "col PO1 PO3 PO2"
using ax_col_312 [of "PO2" "PO1" "PO3"]
by auto

(*2*)  moreover
from `col PO1 PO3 PO2`
have  "col PO3 PO1 PO2"
using ax_col_213 [of "PO1" "PO3" "PO2"]
by auto

(*3*)  moreover
from `col PO3 PO1 PO2`
have  "col PO1 PO2 PO3"
using ax_col_312 [of "PO3" "PO1" "PO2"]
by auto

ultimately 
show ?thesis
by auto
qed
