(*
Title: Foundations of Geometry
Authors: Alfred Tarski
Formalized by: Sana Stojanovic and Julien Narboux and Predrag Janicic
Proved by: ArgoCLP
Date: 01.03.2014.
 *)

Ltac hyp_of_type t :=
 match goal with
| H1:t |- _ => H1
  end.

Tactic Notation "by" "cases" "on" constr(t) :=
  let H := hyp_of_type t in decompose [or] H; clear H.

Ltac applying l := apply l;repeat split;repeat subst;intuition.
Ltac contradict := solve [intuition].
Ltac decompAnd H :=try (progress (decompose [and] H);clear H).

Parameter point : Type.

Parameter eq_point : point -> point -> Prop.
Parameter not_eq_point : point -> point -> Prop.
Parameter col : point -> point -> point -> Prop.
Parameter not_col : point -> point -> point -> Prop.
Parameter cop : point -> point -> point -> point -> Prop.
Parameter not_cop : point -> point -> point -> point -> Prop.
Parameter bet : point -> point -> point -> Prop.
Parameter not_bet : point -> point -> point -> Prop.
Parameter cong : point -> point -> point -> point -> Prop.
Parameter not_cong : point -> point -> point -> point -> Prop.
Parameter cong3 : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong3 : point -> point -> point -> point -> point -> point -> Prop.
Parameter afs : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_afs : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter bet4 : point -> point -> point -> point -> Prop.
Parameter not_bet4 : point -> point -> point -> point -> Prop.
Parameter ifs : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_ifs : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter fs : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_fs : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter le : point -> point -> point -> point -> Prop.
Parameter not_le : point -> point -> point -> point -> Prop.
Parameter lt : point -> point -> point -> point -> Prop.
Parameter not_lt : point -> point -> point -> point -> Prop.
Parameter gt : point -> point -> point -> point -> Prop.
Parameter not_gt : point -> point -> point -> point -> Prop.
Parameter ge : point -> point -> point -> point -> Prop.
Parameter not_ge : point -> point -> point -> point -> Prop.
Parameter out : point -> point -> point -> Prop.
Parameter not_out : point -> point -> point -> Prop.
Parameter is_midpoint : point -> point -> point -> Prop.
Parameter not_is_midpoint : point -> point -> point -> Prop.
Parameter is_symmetric : point -> point -> point -> Prop.
Parameter not_is_symmetric : point -> point -> point -> Prop.
Parameter is_image : point -> point -> point -> point -> Prop.
Parameter not_is_image : point -> point -> point -> point -> Prop.
Parameter is_image_spec : point -> point -> point -> point -> Prop.
Parameter not_is_image_spec : point -> point -> point -> point -> Prop.
Parameter is_image_spec_in : point -> point -> point -> point -> point -> Prop.
Parameter not_is_image_spec_in : point -> point -> point -> point -> point -> Prop.
Parameter is_image_spec_in_gen : point -> point -> point -> point -> point -> Prop.
Parameter not_is_image_spec_in_gen : point -> point -> point -> point -> point -> Prop.
Parameter per : point -> point -> point -> Prop.
Parameter not_per : point -> point -> point -> Prop.
Parameter perp_in : point -> point -> point -> point -> point -> Prop.
Parameter not_perp_in : point -> point -> point -> point -> point -> Prop.
Parameter perp : point -> point -> point -> point -> Prop.
Parameter not_perp : point -> point -> point -> point -> Prop.
Parameter two_sides : point -> point -> point -> point -> Prop.
Parameter not_two_sides : point -> point -> point -> point -> Prop.
Parameter one_side : point -> point -> point -> point -> Prop.
Parameter not_one_side : point -> point -> point -> point -> Prop.
Parameter point_on_line : point -> point -> point -> Prop.
Parameter not_point_on_line : point -> point -> point -> Prop.
Parameter point_on_halfline : point -> point -> point -> Prop.
Parameter not_point_on_halfline : point -> point -> point -> Prop.
Parameter point_on_plane3p : point -> point -> point -> point -> Prop.
Parameter not_point_on_plane3p : point -> point -> point -> point -> Prop.
Parameter point_on_plane2l : point -> point -> point -> point -> point -> Prop.
Parameter not_point_on_plane2l : point -> point -> point -> point -> point -> Prop.
Parameter same_lines : point -> point -> point -> point -> Prop.
Parameter not_same_lines : point -> point -> point -> point -> Prop.
Parameter same_planes3p : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_same_planes3p : point -> point -> point -> point -> point -> point -> Prop.
Parameter line_on_plane3p : point -> point -> point -> point -> point -> Prop.
Parameter not_line_on_plane3p : point -> point -> point -> point -> point -> Prop.
Parameter same_planes2l : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_same_planes2l : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter line_on_plane2l : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_line_on_plane2l : point -> point -> point -> point -> point -> point -> Prop.
Parameter same_planes2l3p : point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_same_planes2l3p : point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter distinct : point -> point -> point -> Prop.
Parameter not_distinct : point -> point -> point -> Prop.
Parameter cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter point_in_angle : point -> point -> point -> point -> Prop.
Parameter not_point_in_angle : point -> point -> point -> point -> Prop.
Parameter le_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_le_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter ge_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_ge_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter lt_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_lt_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter gt_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_gt_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter cong4 : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong4 : point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter acute : point -> point -> point -> Prop.
Parameter not_acute : point -> point -> point -> Prop.
Parameter obtuse : point -> point -> point -> Prop.
Parameter not_obtuse : point -> point -> point -> Prop.
Parameter inter : point -> point -> point -> point -> point -> Prop.
Parameter not_inter : point -> point -> point -> point -> point -> Prop.
Parameter intersect : point -> point -> point -> point -> Prop.
Parameter not_intersect : point -> point -> point -> point -> Prop.
Parameter two_sides3p : point -> point -> point -> point -> point -> Prop.
Parameter not_two_sides3p : point -> point -> point -> point -> point -> Prop.
Parameter one_side3p : point -> point -> point -> point -> point -> Prop.
Parameter not_one_side3p : point -> point -> point -> point -> point -> Prop.
Parameter right_angle3p3p : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_right_angle3p3p : point -> point -> point -> point -> point -> point -> Prop.
Parameter right_angle2p3p_in : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_right_angle2p3p_in : point -> point -> point -> point -> point -> point -> Prop.
Parameter right_angle2p3p : point -> point -> point -> point -> point -> Prop.
Parameter not_right_angle2p3p : point -> point -> point -> point -> point -> Prop.
Parameter cop_lines : point -> point -> point -> point -> Prop.
Parameter not_cop_lines : point -> point -> point -> point -> Prop.
Parameter cop_lines3l : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cop_lines3l : point -> point -> point -> point -> point -> point -> Prop.
Parameter int : point -> point -> point -> point -> Prop.
Parameter not_int : point -> point -> point -> point -> Prop.
Parameter parallel : point -> point -> point -> point -> Prop.
Parameter not_parallel : point -> point -> point -> point -> Prop.
Parameter parallel_broad : point -> point -> point -> point -> Prop.
Parameter not_parallel_broad : point -> point -> point -> point -> Prop.
Parameter parallel_planes : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_parallel_planes : point -> point -> point -> point -> point -> point -> Prop.
Parameter point_on_ray : point -> point -> point -> Prop.
Parameter not_point_on_ray : point -> point -> point -> Prop.
Parameter parallel_normal : point -> point -> point -> point -> point -> Prop.
Parameter not_parallel_normal : point -> point -> point -> point -> point -> Prop.

Axiom ax_1 : forall (A:point) (B:point), cong A B B A.
Axiom ax_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong A B C D /\ cong A B E F) -> cong C D E F.
Axiom ax_3 : forall (A:point) (B:point) (C:point), cong A B C C -> A = B.
Axiom ax_4 : forall (D:point) (A:point) (B:point) (C:point), exists E:point, (bet D A E /\ cong A E B C).
Axiom ax_5 : forall (A:point) (B:point) (C:point) (E:point) (F:point) (G:point) (D:point) (I:point), (A <> B /\ bet A B C /\ bet E F G /\ cong A B E F /\ cong B C F G /\ cong A D E I /\ cong B D F I) -> cong C D G I.
Axiom ax_6 : forall (A:point) (B:point), bet A B A -> A = B.
Axiom ax_7 : forall (A:point) (D:point) (C:point) (B:point) (E:point), (bet A D C /\ bet B E C) -> exists F:point, (bet D F B /\ bet E F A).
Axiom ax_branch_bet : forall (A:point) (B:point) (C:point), bet A B C \/ not_bet A B C.
Axiom ax_false_bet : forall (A:point) (B:point) (C:point), (bet A B C /\ not_bet A B C) -> (False).
Axiom ax_8 : exists A:point, exists B:point, exists C:point, (not_bet A B C /\ not_bet B C A /\ not_bet C A B).
Axiom ax_9 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ cong C A C B /\ cong D A D B /\ cong E A E B) -> bet C D E \/ bet D E C \/ bet E C D.
Axiom ax_10 : forall (A:point) (D:point) (E:point) (B:point) (C:point), (bet A D E /\ bet B D C /\ A <> D) -> exists F:point, exists G:point, (bet A B F /\ bet A C G /\ bet F E G).
Axiom ax_g1 : forall (A:point) (B:point), A = B \/ A <> B.
Axiom ax_2_10_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), afs A B C D E F G I -> (bet A B C /\ bet E F G /\ cong A B E F /\ cong B C F G /\ cong A D E I /\ cong B D F I).
Axiom ax_2_10_2 : forall (A:point) (B:point) (C:point) (E:point) (F:point) (G:point) (D:point) (I:point), (bet A B C /\ bet E F G /\ cong A B E F /\ cong B C F G /\ cong A D E I /\ cong B D F I) -> afs A B C D E F G I.
Axiom ax_branch_afs : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), afs A B C D E F G I \/ not_afs A B C D E F G I.
Axiom ax_false_afs : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (afs A B C D E F G I /\ not_afs A B C D E F G I) -> (False).
Axiom ax_3_8_1 : forall (A:point) (B:point) (C:point) (D:point), bet4 A B C D -> (bet A B C /\ bet A B D /\ bet A C D /\ bet B C D).
Axiom ax_3_8_2 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet A B D /\ bet A C D /\ bet B C D) -> bet4 A B C D.
Axiom ax_branch_bet4 : forall (A:point) (B:point) (C:point) (D:point), bet4 A B C D \/ not_bet4 A B C D.
Axiom ax_false_bet4 : forall (A:point) (B:point) (C:point) (D:point), (bet4 A B C D /\ not_bet4 A B C D) -> (False).
Axiom ax_4_1_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), ifs A B C D E F G I -> (bet A B C /\ bet E F G /\ cong A C E G /\ cong B C F G /\ cong A D E I /\ cong C D G I).
Axiom ax_4_1_2 : forall (A:point) (B:point) (C:point) (E:point) (F:point) (G:point) (D:point) (I:point), (bet A B C /\ bet E F G /\ cong A C E G /\ cong B C F G /\ cong A D E I /\ cong C D G I) -> ifs A B C D E F G I.
Axiom ax_branch_ifs : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), ifs A B C D E F G I \/ not_ifs A B C D E F G I.
Axiom ax_false_ifs : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (ifs A B C D E F G I /\ not_ifs A B C D E F G I) -> (False).
Axiom ax_4_4_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong3 A B C D E F -> (cong A B D E /\ cong A C D F /\ cong B C E F).
Axiom ax_4_4_2 : forall (A:point) (B:point) (D:point) (E:point) (C:point) (F:point), (cong A B D E /\ cong A C D F /\ cong B C E F) -> cong3 A B C D E F.
Axiom ax_4_4_3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), cong4 A B C D E F G I -> (cong A B E F /\ cong A C E G /\ cong A D E I /\ cong B C F G /\ cong B D F I /\ cong C D G I).
Axiom ax_4_4_4 : forall (A:point) (B:point) (E:point) (F:point) (C:point) (G:point) (D:point) (I:point), (cong A B E F /\ cong A C E G /\ cong A D E I /\ cong B C F G /\ cong B D F I /\ cong C D G I) -> cong4 A B C D E F G I.
Axiom ax_branch_cong3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong3 A B C D E F \/ not_cong3 A B C D E F.
Axiom ax_false_cong3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong3 A B C D E F /\ not_cong3 A B C D E F) -> (False).
Axiom ax_branch_cong4 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), cong4 A B C D E F G I \/ not_cong4 A B C D E F G I.
Axiom ax_false_cong4 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (cong4 A B C D E F G I /\ not_cong4 A B C D E F G I) -> (False).
Axiom ax_4_10_1 : forall (A:point) (B:point) (C:point), col A B C -> bet A B C \/ bet B C A \/ bet C A B.
Axiom ax_4_10_2 : forall (A:point) (B:point) (C:point), bet A B C -> col A B C.
Axiom ax_4_10_3 : forall (B:point) (C:point) (A:point), bet B C A -> col A B C.
Axiom ax_4_10_4 : forall (C:point) (A:point) (B:point), bet C A B -> col A B C.
Axiom ax_4_15_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), fs A B C D E F G I -> (col A B C /\ cong3 A B C E F G /\ cong A D E I /\ cong B D F I).
Axiom ax_4_15_2 : forall (A:point) (B:point) (C:point) (E:point) (F:point) (G:point) (D:point) (I:point), (col A B C /\ cong3 A B C E F G /\ cong A D E I /\ cong B D F I) -> fs A B C D E F G I.
Axiom ax_branch_fs : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), fs A B C D E F G I \/ not_fs A B C D E F G I.
Axiom ax_false_fs : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (fs A B C D E F G I /\ not_fs A B C D E F G I) -> (False).
Axiom ax_5_4_1 : forall (A:point) (B:point) (C:point) (D:point), le A B C D -> exists E:point, (bet C E D /\ cong A B C E).
Axiom ax_5_4_2 : forall (C:point) (E:point) (D:point) (A:point) (B:point), (bet C E D /\ cong A B C E) -> le A B C D.
Axiom ax_5_4_3 : forall (C:point) (D:point) (A:point) (B:point), ge C D A B -> le A B C D.
Axiom ax_5_4_4 : forall (A:point) (B:point) (C:point) (D:point), le A B C D -> ge C D A B.
Axiom ax_branch_le : forall (A:point) (B:point) (C:point) (D:point), le A B C D \/ not_le A B C D.
Axiom ax_false_le : forall (A:point) (B:point) (C:point) (D:point), (le A B C D /\ not_le A B C D) -> (False).
Axiom ax_branch_ge : forall (A:point) (B:point) (C:point) (D:point), ge A B C D \/ not_ge A B C D.
Axiom ax_false_ge : forall (A:point) (B:point) (C:point) (D:point), (ge A B C D /\ not_ge A B C D) -> (False).
Axiom ax_branch_cong : forall (A:point) (B:point) (C:point) (D:point), cong A B C D \/ not_cong A B C D.
Axiom ax_false_cong : forall (A:point) (B:point) (C:point) (D:point), (cong A B C D /\ not_cong A B C D) -> (False).
Axiom ax_5_14_1 : forall (A:point) (B:point) (C:point) (D:point), lt A B C D -> (le A B C D /\ not_cong A B C D).
Axiom ax_5_14_2 : forall (A:point) (B:point) (C:point) (D:point), (le A B C D /\ not_cong A B C D) -> lt A B C D.
Axiom ax_5_14_3 : forall (C:point) (D:point) (A:point) (B:point), gt C D A B -> lt A B C D.
Axiom ax_5_14_4 : forall (A:point) (B:point) (C:point) (D:point), lt A B C D -> gt C D A B.
Axiom ax_branch_lt : forall (A:point) (B:point) (C:point) (D:point), lt A B C D \/ not_lt A B C D.
Axiom ax_false_lt : forall (A:point) (B:point) (C:point) (D:point), (lt A B C D /\ not_lt A B C D) -> (False).
Axiom ax_branch_gt : forall (A:point) (B:point) (C:point) (D:point), gt A B C D \/ not_gt A B C D.
Axiom ax_false_gt : forall (A:point) (B:point) (C:point) (D:point), (gt A B C D /\ not_gt A B C D) -> (False).
Axiom ax_6_1_1 : forall (C:point) (A:point) (B:point), out C A B -> (A <> C /\ B <> C /\ bet C A B) \/ (A <> C /\ B <> C /\ bet C B A).
Axiom ax_6_1_2 : forall (A:point) (C:point) (B:point), (A <> C /\ B <> C /\ bet C A B) -> out C A B.
Axiom ax_6_1_3 : forall (A:point) (C:point) (B:point), (A <> C /\ B <> C /\ bet C B A) -> out C A B.
Axiom ax_branch_out : forall (C:point) (A:point) (B:point), out C A B \/ not_out C A B.
Axiom ax_false_out : forall (C:point) (A:point) (B:point), (out C A B /\ not_out C A B) -> (False).
Axiom ax_6_8_1 : forall (B:point) (A:point) (C:point), (B <> A /\ point_on_ray C A B) -> out A C B.
Axiom ax_6_8_2 : forall (B:point) (A:point) (C:point), (B <> A /\ out A C B) -> point_on_ray C A B.
Axiom ax_branch_point_on_ray : forall (C:point) (A:point) (B:point), point_on_ray C A B \/ not_point_on_ray C A B.
Axiom ax_false_point_on_ray : forall (C:point) (A:point) (B:point), (point_on_ray C A B /\ not_point_on_ray C A B) -> (False).
Axiom ax_6_14_1 : forall (C:point) (A:point) (B:point), point_on_line C A B -> (A <> B /\ col A B C).
Axiom ax_6_14_2 : forall (A:point) (B:point) (C:point), (A <> B /\ col A B C) -> point_on_line C A B.
Axiom ax_same_lines_1 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> D /\ point_on_line C A B /\ point_on_line D A B) -> same_lines A B C D.
Axiom ax_same_lines_2 : forall (A:point) (B:point) (C:point) (D:point), same_lines A B C D -> (A <> B /\ C <> D /\ point_on_line C A B /\ point_on_line D A B).
Axiom ax_false_same_lines : forall (A:point) (B:point) (C:point) (D:point), (same_lines A B C D /\ not_same_lines A B C D) -> (False).
Axiom ax_branch_same_lines : forall (A:point) (B:point) (C:point) (D:point), same_lines A B C D \/ not_same_lines A B C D.
Axiom ax_branch_col : forall (A:point) (B:point) (C:point), col A B C \/ not_col A B C.
Axiom ax_false_col : forall (A:point) (B:point) (C:point), (col A B C /\ not_col A B C) -> (False).
Axiom ax_branch_point_on_line : forall (A:point) (B:point) (C:point), A <> B -> point_on_line C A B \/ not_point_on_line C A B.
Axiom ax_false_point_on_line : forall (C:point) (A:point) (B:point), (point_on_line C A B /\ not_point_on_line C A B) -> (False).
Axiom ax_6_22_1 : forall (E:point) (A:point) (B:point) (C:point) (D:point), inter E A B C D -> (A <> B /\ C <> D /\ point_on_line E A B /\ point_on_line E C D /\ not_same_lines A B C D).
Axiom ax_6_22_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ C <> D /\ point_on_line E A B /\ point_on_line E C D /\ not_same_lines A B C D) -> inter E A B C D.
Axiom ax_branch_inter : forall (A:point) (B:point) (C:point) (D:point) (E:point), inter A B C D E \/ not_inter A B C D E.
Axiom ax_false_inter : forall (A:point) (B:point) (C:point) (D:point) (E:point), (inter A B C D E /\ not_inter A B C D E) -> (False).
Axiom ax_7_1 : forall (B:point) (A:point) (C:point), is_midpoint B A C -> (bet A B C /\ cong B A B C).
Axiom ax_7_2 : forall (A:point) (B:point) (C:point), (bet A B C /\ cong B A B C) -> is_midpoint B A C.
Axiom ax_branch_is_midpoint : forall (A:point) (B:point) (C:point), is_midpoint A B C \/ not_is_midpoint A B C.
Axiom ax_false_is_midpoint : forall (A:point) (B:point) (C:point), (is_midpoint A B C /\ not_is_midpoint A B C) -> (False).
Axiom ax_7_5_1 : forall (A:point) (B:point) (C:point), is_symmetric A B C -> is_midpoint C A B.
Axiom ax_7_5_2 : forall (C:point) (A:point) (B:point), is_midpoint C A B -> is_symmetric A B C.
Axiom ax_branch_is_symmetric : forall (A:point) (B:point) (C:point), is_symmetric A B C \/ not_is_symmetric A B C.
Axiom ax_false_is_symmetric : forall (A:point) (B:point) (C:point), (is_symmetric A B C /\ not_is_symmetric A B C) -> (False).
Axiom ax_8_1_1 : forall (A:point) (B:point) (C:point), per A B C -> exists D:point, (cong A C A D /\ is_midpoint B C D).
Axiom ax_8_1_2 : forall (A:point) (C:point) (D:point) (B:point), (cong A C A D /\ is_midpoint B C D) -> per A B C.
Axiom ax_branch_per : forall (A:point) (B:point) (C:point), per A B C \/ not_per A B C.
Axiom ax_false_per : forall (A:point) (B:point) (C:point), (per A B C /\ not_per A B C) -> (False).
Axiom ax_8_11_1_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (perp_in A B C D E /\ B <> A /\ D <> A) -> (B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ per B A D).
Axiom ax_8_11_1_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (perp_in A B C D E /\ B <> A /\ E <> A) -> (B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ per B A E).
Axiom ax_8_11_1_3 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (perp_in A B C D E /\ C <> A /\ D <> A) -> (B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ per C A D).
Axiom ax_8_11_1_4 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (perp_in A B C D E /\ C <> A /\ E <> A) -> (B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ per C A E).
Axiom ax_8_11_1_5 : forall (B:point) (A:point) (D:point) (C:point) (E:point), (B <> A /\ D <> A /\ B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ per B A D) -> perp_in A B C D E.
Axiom ax_8_11_1_6 : forall (B:point) (A:point) (E:point) (C:point) (D:point), (B <> A /\ E <> A /\ B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ per B A E) -> perp_in A B C D E.
Axiom ax_8_11_1_7 : forall (C:point) (A:point) (D:point) (B:point) (E:point), (C <> A /\ D <> A /\ B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ per C A D) -> perp_in A B C D E.
Axiom ax_8_11_1_8 : forall (C:point) (A:point) (E:point) (B:point) (D:point), (C <> A /\ E <> A /\ B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ per C A E) -> perp_in A B C D E.
Axiom ax_8_11_2_1 : forall (A:point) (B:point) (C:point) (D:point), perp A B C D -> exists E:point, perp_in E A B C D.
Axiom ax_8_11_2_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), perp_in A B C D E -> perp B C D E.
Axiom ax_branch_perp_in : forall (A:point) (B:point) (C:point) (D:point) (E:point), perp_in A B C D E \/ not_perp_in A B C D E.
Axiom ax_false_perp_in : forall (A:point) (B:point) (C:point) (D:point) (E:point), (perp_in A B C D E /\ not_perp_in A B C D E) -> (False).
Axiom ax_branch_perp : forall (A:point) (B:point) (C:point) (D:point), perp A B C D \/ not_perp A B C D.
Axiom ax_false_perp : forall (A:point) (B:point) (C:point) (D:point), (perp A B C D /\ not_perp A B C D) -> (False).
Axiom ax_9_1_1 : forall (C:point) (D:point) (A:point) (B:point), two_sides C D A B -> exists E:point, (A <> B /\ not_point_on_line C A B /\ not_point_on_line D A B /\ point_on_line E A B /\ bet C E D).
Axiom ax_9_1_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ not_point_on_line C A B /\ not_point_on_line D A B /\ point_on_line E A B /\ bet C E D) -> two_sides C D A B.
Axiom ax_9_7_1 : forall (C:point) (D:point) (A:point) (B:point), one_side C D A B -> exists E:point, (A <> B /\ two_sides C E A B /\ two_sides D E A B).
Axiom ax_9_7_2 : forall (A:point) (B:point) (C:point) (E:point) (D:point), (A <> B /\ two_sides C E A B /\ two_sides D E A B) -> one_side C D A B.
Axiom ax_branch_two_sides : forall (A:point) (B:point) (C:point) (D:point), A <> B -> two_sides C D A B \/ not_two_sides C D A B.
Axiom ax_false_two_sides : forall (C:point) (D:point) (A:point) (B:point), (two_sides C D A B /\ not_two_sides C D A B) -> (False).
Axiom ax_branch_one_side : forall (A:point) (B:point) (C:point) (D:point), A <> B -> one_side C D A B \/ not_one_side C D A B.
Axiom ax_false_one_side : forall (C:point) (D:point) (A:point) (B:point), (one_side C D A B /\ not_one_side C D A B) -> (False).
Axiom ax_10_3_1 : forall (C:point) (D:point) (B:point) (A:point), (C <> D /\ is_image_spec B A C D) -> exists E:point, (is_midpoint E A B /\ point_on_line E C D /\ perp C D A B) \/ (is_midpoint E A B /\ point_on_line E C D /\ A = B).
Axiom ax_10_3_2_1 : forall (C:point) (D:point) (E:point) (A:point) (B:point), (C <> D /\ is_midpoint E A B /\ point_on_line E C D /\ perp C D A B) -> is_image_spec B A C D.
Axiom ax_10_3_2_2 : forall (B:point) (C:point) (D:point) (A:point), (B <> C /\ is_midpoint D A A /\ point_on_line D B C) -> is_image_spec A A B C.
Axiom ax_branch_is_image_spec : forall (C:point) (D:point) (A:point) (B:point), C <> D -> is_image_spec A B C D \/ not_is_image_spec A B C D.
Axiom ax_false_is_image_spec : forall (A:point) (B:point) (C:point) (D:point), (is_image_spec A B C D /\ not_is_image_spec A B C D) -> (False).
Axiom ax_10_3_3 : forall (B:point) (A:point) (C:point) (D:point), is_image B A C D -> (C <> D /\ is_image_spec B A C D) \/ (C = D /\ is_midpoint C A B).
Axiom ax_10_3_4_1 : forall (C:point) (D:point) (B:point) (A:point), (C <> D /\ is_image_spec B A C D) -> is_image B A C D.
Axiom ax_10_3_4_2 : forall (C:point) (A:point) (B:point), is_midpoint C A B -> is_image B A C C.
Axiom ax_branch_is_image : forall (B:point) (A:point) (C:point) (D:point), is_image B A C D \/ not_is_image B A C D.
Axiom ax_false_is_image : forall (B:point) (A:point) (C:point) (D:point), (is_image B A C D /\ not_is_image B A C D) -> (False).
Axiom ax_is_image_spec_in_1 : forall (D:point) (E:point) (A:point) (B:point) (C:point), (D <> E /\ is_image_spec_in A B C D E) -> (is_midpoint A C B /\ col D E A /\ perp D E C B) \/ (is_midpoint A C B /\ col D E A /\ C = B).
Axiom ax_is_image_spec_in_2 : forall (D:point) (E:point) (A:point) (C:point) (B:point), (D <> E /\ is_midpoint A C B /\ col D E A /\ perp D E C B) -> is_image_spec_in A B C D E.
Axiom ax_is_image_spec_in_3 : forall (C:point) (D:point) (A:point) (B:point), (C <> D /\ is_midpoint A B B /\ col C D A) -> is_image_spec_in A B B C D.
Axiom ax_is_image_spec_in_gen_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point), is_image_spec_in_gen A B C D E -> (D <> E /\ is_image_spec_in A B C D E) \/ (D = E /\ D = A /\ is_midpoint A C B).
Axiom ax_is_image_spec_in_gen_2 : forall (D:point) (E:point) (A:point) (B:point) (C:point), (D <> E /\ is_image_spec_in A B C D E) -> is_image_spec_in_gen A B C D E.
Axiom ax_is_image_spec_in_gen_3 : forall (A:point) (C:point) (B:point), is_midpoint A C B -> is_image_spec_in_gen A B C A A.
Axiom ax_false_is_image_spec_in : forall (A:point) (B:point) (C:point) (D:point) (E:point), (is_image_spec_in A B C D E /\ not_is_image_spec_in A B C D E) -> (False).
Axiom ax_branch_is_image_spec_in : forall (D:point) (E:point) (A:point) (B:point) (C:point), D <> E -> is_image_spec_in A B C D E \/ not_is_image_spec_in A B C D E.
Axiom ax_branch_is_image_spec_in_gen : forall (A:point) (B:point) (C:point) (D:point) (E:point), is_image_spec_in_gen A B C D E \/ not_is_image_spec_in_gen A B C D E.
Axiom ax_false_is_image_spec_in_gen : forall (A:point) (B:point) (C:point) (D:point) (E:point), (is_image_spec_in_gen A B C D E /\ not_is_image_spec_in_gen A B C D E) -> (False).
Axiom ax_11_2_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong_angle A B C D E F -> exists G:point, exists I:point, exists J:point, exists K:point, (A <> B /\ C <> B /\ D <> E /\ F <> E /\ bet B A G /\ cong A G E D /\ bet B C I /\ cong C I E F /\ bet E D J /\ cong D J B A /\ bet E F K /\ cong F K B C /\ cong G I J K).
Axiom ax_11_2_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point), (A <> B /\ C <> B /\ D <> E /\ F <> E /\ bet B A G /\ cong A G E D /\ bet B C I /\ cong C I E F /\ bet E D J /\ cong D J B A /\ bet E F K /\ cong F K B C /\ cong G I J K) -> cong_angle A B C D E F.
Axiom ax_distinct_1 : forall (A:point) (B:point) (C:point), distinct A B C -> (A <> B /\ A <> C /\ B <> C).
Axiom ax_distinct_2 : forall (A:point) (B:point) (C:point), (A <> B /\ A <> C /\ B <> C) -> distinct A B C.
Axiom ax_branch_distinct : forall (A:point) (B:point) (C:point), distinct A B C \/ not_distinct A B C.
Axiom ax_false_distinct : forall (A:point) (B:point) (C:point), (distinct A B C /\ not_distinct A B C) -> (False).
Axiom ax_11_23_1_1 : forall (D:point) (A:point) (B:point) (C:point), point_in_angle D A B C -> exists E:point, (A <> B /\ C <> B /\ D <> B /\ bet A E C /\ E = B) \/ (A <> B /\ C <> B /\ D <> B /\ bet A E C /\ out B E D).
Axiom ax_11_23_1_2 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> B /\ D <> B /\ bet A B C) -> point_in_angle D A B C.
Axiom ax_11_23_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ C <> B /\ D <> B /\ bet A E C /\ out B E D) -> point_in_angle D A B C.
Axiom ax_branch_point_in_angle : forall (A:point) (B:point) (C:point) (D:point), point_in_angle A B C D \/ not_point_in_angle A B C D.
Axiom ax_false_point_in_angle : forall (A:point) (B:point) (C:point) (D:point), (point_in_angle A B C D /\ not_point_in_angle A B C D) -> (False).
Axiom ax_11_27_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), le_angle A B C D E F -> exists G:point, (point_in_angle G D E F /\ cong_angle A B C D E G).
Axiom ax_11_27_2 : forall (G:point) (D:point) (E:point) (F:point) (A:point) (B:point) (C:point), (point_in_angle G D E F /\ cong_angle A B C D E G) -> le_angle A B C D E F.
Axiom ax_branch_le_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), le_angle A B C D E F \/ not_le_angle A B C D E F.
Axiom ax_false_le_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (le_angle A B C D E F /\ not_le_angle A B C D E F) -> (False).
Axiom ax_11_27_3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), ge_angle A B C D E F -> le_angle D E F A B C.
Axiom ax_11_27_4 : forall (D:point) (E:point) (F:point) (A:point) (B:point) (C:point), le_angle D E F A B C -> ge_angle A B C D E F.
Axiom ax_branch_ge_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), ge_angle A B C D E F \/ not_le_angle A B C D E F.
Axiom ax_false_ge_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (ge_angle A B C D E F /\ not_ge_angle A B C D E F) -> (False).
Axiom ax_branch_cong_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong_angle A B C D E F \/ not_cong_angle A B C D E F.
Axiom ax_cong_angle_false : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong_angle A B C D E F /\ not_cong_angle A B C D E F) -> (False).
Axiom ax_11_38_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), lt_angle A B C D E F -> (le_angle A B C D E F /\ not_cong_angle A B C D E F).
Axiom ax_11_38_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (le_angle A B C D E F /\ not_cong_angle A B C D E F) -> lt_angle A B C D E F.
Axiom ax_11_38_3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), gt_angle A B C D E F -> lt_angle D E F A B C.
Axiom ax_11_38_4 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), lt_angle A B C D E F -> gt_angle D E F A B C.
Axiom ax_branch_gt_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), gt_angle A B C D E F \/ not_gt_angle A B C D E F.
Axiom ax_false_gt_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (gt_angle A B C D E F /\ not_gt_angle A B C D E F) -> (False).
Axiom ax_branch_lt_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), lt_angle A B C D E F \/ not_lt_angle A B C D E F.
Axiom ax_false_lt_angle : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (lt_angle A B C D E F /\ not_lt_angle A B C D E F) -> (False).
Axiom ax_11_39_1 : forall (A:point) (B:point) (C:point), acute A B C -> exists D:point, exists E:point, exists F:point, (per D E F /\ lt_angle A B C D E F).
Axiom ax_11_39_2 : forall (D:point) (E:point) (F:point) (A:point) (B:point) (C:point), (per D E F /\ lt_angle A B C D E F) -> acute A B C.
Axiom ax_11_39_3 : forall (A:point) (B:point) (C:point), obtuse A B C -> exists D:point, exists E:point, exists F:point, (per D E F /\ gt_angle A B C D E F).
Axiom ax_11_39_4 : forall (D:point) (E:point) (F:point) (A:point) (B:point) (C:point), (per D E F /\ gt_angle A B C D E F) -> obtuse A B C.
Axiom ax_branch_acute : forall (A:point) (B:point) (C:point), acute A B C \/ not_acute A B C.
Axiom ax_false_acute : forall (A:point) (B:point) (C:point), (acute A B C /\ not_acute A B C) -> (False).
Axiom ax_branch_obtuse : forall (A:point) (B:point) (C:point), obtuse A B C \/ not_obtuse A B C.
Axiom ax_false_obtuse : forall (A:point) (B:point) (C:point), (obtuse A B C /\ not_obtuse A B C) -> (False).
Axiom ax_int1 : forall (A:point) (B:point) (C:point) (D:point), int A B C D -> exists E:point, inter E A B C D.
Axiom ax_int2 : forall (E:point) (A:point) (B:point) (C:point) (D:point), inter E A B C D -> int A B C D.
Axiom ax_branch_int : forall (A:point) (B:point) (C:point) (D:point), int A B C D \/ not_int A B C D.
Axiom ax_false_int : forall (A:point) (B:point) (C:point) (D:point), (int A B C D /\ not_int A B C D) -> (False).
Axiom ax_12_2_1 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> D /\ not_int A B C D) -> parallel A B C D.
Axiom ax_12_2_2 : forall (A:point) (B:point) (C:point) (D:point), parallel A B C D -> (A <> B /\ C <> D /\ not_int A B C D).
Axiom ax_12_3_1 : forall (A:point) (B:point) (C:point) (D:point), parallel_broad A B C D -> (A <> B /\ C <> D /\ parallel A B C D) \/ (A <> B /\ C <> D /\ same_lines A B C D).
Axiom ax_12_3_2 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> D /\ parallel A B C D) -> parallel_broad A B C D.
Axiom ax_12_3_3 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> D /\ same_lines A B C D) -> parallel_broad A B C D.
Axiom ax_branch_parallel : forall (A:point) (B:point) (C:point) (D:point), parallel A B C D \/ not_parallel A B C D.
Axiom ax_false_parallel : forall (A:point) (B:point) (C:point) (D:point), (parallel A B C D /\ not_parallel A B C D) -> (False).
Axiom ax_branch_parallel_broad : forall (A:point) (B:point) (C:point) (D:point), parallel_broad A B C D \/ not_parallel_broad A B C D.
Axiom ax_false_parallel_broad : forall (A:point) (B:point) (C:point) (D:point), (parallel_broad A B C D /\ not_parallel_broad A B C D) -> (False).

(* Chapter : Consequences of the Axioms A1-A5 *)

Theorem th_2_11 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (bet A B C /\ bet D E F /\ cong A B D E /\ cong B C E F) -> cong A C D F.
Proof.
Admitted.

Theorem th_2_12 : forall (D:point) (A:point) (E:point) (B:point) (C:point) (F:point), (D <> A /\ bet D A E /\ cong A E B C /\ bet D A F /\ cong A F B C) -> E = F.
Proof.
Admitted.

Theorem th_2_1 : forall (A:point) (B:point), cong A B A B.
Proof.
 intros.
 assert (cong B A A B) by applying (ax_1 B A ) .
 (* We are using: (cong B A A B) and (cong B A A B) *)
 assert (cong A B A B) by applying (ax_2 B A A B A B ) .
 solve [firstorder].
Qed.

Theorem th_2_2 : forall (A:point) (B:point) (C:point) (D:point), cong A B C D -> cong C D A B.
Proof.
 intros.
 assert (cong B A A B) by applying (ax_1 B A ) .
 (* We are using: (cong B A A B) and (cong B A A B) *)
 assert (cong A B A B) by applying (ax_2 B A A B A B ) .
 (* We are using: (cong A B C D) and (cong A B A B) *)
 assert (cong C D A B) by applying (ax_2 A B C D A B ) .
 solve [firstorder].
Qed.

Theorem th_2_3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong A B C D /\ cong C D E F) -> cong A B E F.
Proof.
 intros.
 (* We are using: (cong A B C D) *)
 assert (cong C D A B) by applying (th_2_2 A B C D ) .
 (* We are using: (cong C D A B) and (cong C D E F) *)
 assert (cong A B E F) by applying (ax_2 C D A B E F ) .
 solve [firstorder].
Qed.

Theorem th_2_4 : forall (A:point) (B:point) (C:point) (D:point), cong A B C D -> cong B A C D.
Proof.
 intros.
 assert (cong A B B A) by applying (ax_1 A B ) .
 (* We are using: (cong A B B A) and (cong A B C D) *)
 assert (cong B A C D) by applying (ax_2 A B B A C D ) .
 solve [firstorder].
Qed.

Theorem th_2_5 : forall (A:point) (B:point) (C:point) (D:point), cong A B C D -> cong A B D C.
Proof.
 intros.
 (* We are using: (cong A B C D) *)
 assert (cong C D A B) by applying (th_2_2 A B C D ) .
 (* We are using: (cong C D A B) *)
 assert (cong D C A B) by applying (th_2_4 C D A B ) .
 (* We are using: (cong D C A B) *)
 assert (cong A B D C) by applying (th_2_2 D C A B ) .
 solve [firstorder].
Qed.

Theorem th_2_8 : forall (A:point) (B:point), cong A A B B.
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists C, (bet A A C /\ cong A C A A)) by applying (ax_4 A A A A ) ;destruct Hnew as [C Hnew];decompAnd Hnew.
 (* We are using: (cong A C A A) *)
 assert (A = C) by applying (ax_3 A C A ) .
 let Hnew := fresh in  assert ( Hnew : exists F, (bet A A F /\ cong A F B B)) by applying (ax_4 A A B B ) ;destruct Hnew as [F Hnew];decompAnd Hnew.
 (* We are using: (cong A F B B) *)
 assert (A = F) by applying (ax_3 A F B ) .
 (* We are using: (cong A F B B) and (A = C) and (A = F) *)
 assert (cong A A B B)  by (intuition;repeat subst; intuition).
 solve [firstorder].
Qed.

(* Chapter : Simple Properties of Betweenness *)

Theorem th_3_5 : forall (A:point) (B:point) (D:point) (C:point), (bet A B D /\ bet B C D) -> (bet A B C /\ bet A C D).
Proof.
Admitted.

Theorem th_3_7 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet B C D /\ B <> C) -> (bet A C D /\ bet A B D).
Proof.
Admitted.

Theorem th_3_14 : forall (A:point) (B:point), exists C:point, (bet A B C /\ B <> C).
Proof.
Admitted.

Theorem th_3_15_2 : forall (A:point) (B:point), A <> B -> exists C:point, exists D:point, (bet4 A B C D /\ A <> C /\ A <> D /\ B <> C /\ B <> D /\ C <> D).
Proof.
Admitted.

Theorem th_3_17 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (bet A B C /\ bet D E C /\ bet A F D) -> exists G:point, (bet F G C /\ bet B G E).
Proof.
Admitted.

Theorem th_3_1 : forall (A:point) (B:point), bet A B B.
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists G, (bet A B G /\ cong B G A A)) by applying (ax_4 A B A A ) ;destruct Hnew as [G Hnew];decompAnd Hnew.
 (* We are using: (cong B G A A) *)
 assert (B = G) by applying (ax_3 B G A ) .
 (* We are using: (bet A B G) and (B = G) *)
 assert (bet A B B)  by (intuition;repeat subst; intuition).
 solve [firstorder].
Qed.

Theorem th_3_2 : forall (A:point) (B:point) (C:point), bet A B C -> bet C B A.
Proof.
 intros.
 assert (bet A B B) by applying (th_3_1 A B ) .
 assert (bet B B B) by applying (th_3_1 B B ) .
 assert (bet B C C) by applying (th_3_1 B C ) .
 (* We are using: (bet A B B) and (bet B B B) *)
 let Hnew := fresh in  assert ( Hnew : exists F, (bet B F B /\ bet B F A)) by applying (ax_7 A B B B B ) ;destruct Hnew as [F Hnew];decompAnd Hnew.
 (* We are using: (bet B F B) *)
 assert (B = F) by applying (ax_6 B F ) .
 (* We are using: (bet A B C) and (bet B C C) *)
 let Hnew := fresh in  assert ( Hnew : exists I, (bet B I B /\ bet C I A)) by applying (ax_7 A B C B C ) ;destruct Hnew as [I Hnew];decompAnd Hnew.
 (* We are using: (bet B I B) *)
 assert (B = I) by applying (ax_6 B I ) .
 (* We are using: (bet C I A) and (B = F) and (B = I) *)
 assert (bet C B A)  by (intuition;repeat subst; intuition).
 solve [firstorder].
Qed.

Theorem th_3_3 : forall (A:point) (B:point), bet A A B.
Proof.
 intros.
 assert (bet B A A) by applying (th_3_1 B A ) .
 (* We are using: (bet B A A) *)
 assert (bet A A B) by applying (th_3_2 B A A ) .
 solve [firstorder].
Qed.

Theorem th_3_4 : forall (A:point) (B:point) (C:point), (bet A B C /\ bet B A C) -> A = B.
Proof.
 intros.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> B *)
 (* We are using: (bet A B C) and (bet B A C) *)
 let Hnew := fresh in  assert ( Hnew : exists E, (bet B E B /\ bet A E A)) by applying (ax_7 A B C B A ) ;destruct Hnew as [E Hnew];decompAnd Hnew.
 (* We are using: (bet A E A) *)
 assert (A = E) by applying (ax_6 A E ) .
 (* We are using: (bet B E B) and (A = E) *)
 assert (bet B A B)  by (intuition;repeat subst; intuition).
 (* We are using: (bet B A B) *)
 assert (B = A) by applying (ax_6 B A ) .
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (B = A) and (B <> A) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
Qed.

Theorem th_3_6 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet A C D) -> (bet B C D /\ bet A B D).
Proof.
 intros.
 (* We are using: (bet A B C) *)
 assert (bet C B A) by applying (th_3_2 A B C ) .
 (* We are using: (bet A C D) *)
 assert (bet D C A) by applying (th_3_2 A C D ) .
 (* We are using: (bet D C A) and (bet C B A) *)
 assert (bet D C B /\ bet D B A) by applying (th_3_5 D C A B ) .
 (* We are using: (bet D B A) *)
 assert (bet A B D) by applying (th_3_2 D B A ) .
 (* We are using: (bet D C B) *)
 assert (bet B C D) by applying (th_3_2 D C B ) .
 solve [firstorder].
Qed.

Theorem th_3_9 : forall (A:point) (B:point) (C:point) (D:point), bet4 A B C D -> bet4 D C B A.
Proof.
 intros.
 (* We are using: (bet4 A B C D) *)
 assert (bet A B C /\ bet A B D /\ bet A C D /\ bet B C D) by applying (ax_3_8_1 A B C D ) .
 (* We are using: (bet A B C) *)
 assert (bet C B A) by applying (th_3_2 A B C ) .
 (* We are using: (bet A B D) *)
 assert (bet D B A) by applying (th_3_2 A B D ) .
 (* We are using: (bet A C D) *)
 assert (bet D C A) by applying (th_3_2 A C D ) .
 (* We are using: (bet B C D) *)
 assert (bet D C B) by applying (th_3_2 B C D ) .
 (* We are using: (bet D C B) and (bet D C A) and (bet D B A) and (bet C B A) *)
 assert (bet4 D C B A) by applying (ax_3_8_2 D C B A ) .
 solve [firstorder].
Qed.

Theorem th_3_10_1 : forall (A:point) (B:point) (C:point) (D:point), bet4 A B C D -> bet A B C.
Proof.
 intros.
 (* We are using: (bet4 A B C D) *)
 assert (bet A B C /\ bet A B D /\ bet A C D /\ bet B C D) by applying (ax_3_8_1 A B C D ) .
 solve [firstorder].
Qed.

Theorem th_3_10_2 : forall (A:point) (B:point) (C:point) (D:point), bet4 A B C D -> bet B C D.
Proof.
 intros.
 (* We are using: (bet4 A B C D) *)
 assert (bet A B C /\ bet A B D /\ bet A C D /\ bet B C D) by applying (ax_3_8_1 A B C D ) .
 solve [firstorder].
Qed.

Theorem th_3_11_1 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet A D B) -> bet4 A D B C.
Proof.
 intros.
 (* We are using: (bet A D B) and (bet A B C) *)
 assert (bet D B C /\ bet A D C) by applying (th_3_6 A D B C ) .
 (* We are using: (bet A D B) and (bet A D C) and (bet A B C) and (bet D B C) *)
 assert (bet4 A D B C) by applying (ax_3_8_2 A D B C ) .
 solve [firstorder].
Qed.

Theorem th_3_11_2 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet B D C) -> bet4 A B D C.
Proof.
 intros.
 (* We are using: (bet A B C) and (bet B D C) *)
 assert (bet A B D /\ bet A D C) by applying (th_3_5 A B C D ) .
 (* We are using: (bet A B D) and (bet A B C) and (bet A D C) and (bet B D C) *)
 assert (bet4 A B D C) by applying (ax_3_8_2 A B D C ) .
 solve [firstorder].
Qed.

Theorem th_3_12_1 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet B C D /\ B <> C) -> bet4 A B C D.
Proof.
 intros.
 (* We are using: (bet A B C) and (bet B C D) and (B <> C) *)
 assert (bet A C D /\ bet A B D) by applying (th_3_7 A B C D ) .
 (* We are using: (bet A C D) and (bet A B C) *)
 assert (bet4 A B C D) by applying (th_3_11_1 A C D B ) .
 solve [firstorder].
Qed.

Theorem th_3_12_2 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet A C D) -> bet4 A B C D.
Proof.
 intros.
 (* We are using: (bet A C D) and (bet A B C) *)
 assert (bet4 A B C D) by applying (th_3_11_1 A C D B ) .
 solve [firstorder].
Qed.

Theorem th_3_13 : exists A:point, exists B:point, A <> B.
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists A,  exists B,  exists C, (not_bet A B C /\ not_bet B C A /\ not_bet C A B)) by applying (ax_8 ) ;destruct Hnew as [A[B[C]] Hnew];decompAnd Hnew.
 let Hnew := fresh in  assert ( Hnew : exists D, (bet A A D /\ cong A D A A)) by applying (ax_4 A A A A ) ;destruct Hnew as [D Hnew];decompAnd Hnew.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
 by cases on (A = C \/ A <> C).
 (* Case : A = C *)
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
 by cases on (A = D \/ A <> D).
 (* Case : A = D *)
 (* We are using: (bet A A D) and (A = B) and (A = C) and (A = D) *)
 assert (bet A A A)  by (intuition;repeat subst; intuition).
 (* We are using: (bet A A A) and (A = B) and (A = C) *)
 assert (bet A B C)  by (intuition;repeat subst; intuition).
 (* We are using: (not_bet A B C) and (bet A B C) *)
 assert (False) by applying (ax_false_bet A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : A <> D *)
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : A <> C *)
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : A <> B *)
 solve [firstorder].
 (* end of the case. *)
Qed.

Theorem th_3_15_1 : forall (A:point) (B:point), A <> B -> exists C:point, (bet A B C /\ A <> C /\ B <> C).
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists D, (bet A B D /\ B <> D)) by applying (th_3_14 A B ) ;destruct Hnew as [D Hnew];decompAnd Hnew.
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
 by cases on (A = D \/ A <> D).
 (* Case : A = D *)
 (* We are using: (bet A B D) and (A = D) *)
 assert (bet A B A)  by (intuition;repeat subst; intuition).
 (* We are using: (bet A B A) *)
 assert (A = B) by applying (ax_6 A B ) .
 (* We are using: (A = B) and (A <> B) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> D *)
 solve [firstorder].
 (* end of the case. *)
Qed.

(* Chapter : Simple Properties of Congruence and Betweenness *)

Theorem th_4_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), ifs A B C D E F G I -> cong B D F I.
Proof.
Admitted.

Theorem th_4_3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (bet A B C /\ bet D E F /\ cong A C D F /\ cong B C E F) -> cong A B D E.
Proof.
Admitted.

Theorem th_4_5 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (bet A B C /\ cong A C D E) -> exists F:point, (bet D F E /\ cong3 A B C D F E).
Proof.
Admitted.

Theorem th_4_6 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (bet A B C /\ cong3 A B C D E F) -> bet D E F.
Proof.
Admitted.

Theorem th_4_14 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (col A B C /\ cong A B D E) -> exists F:point, cong3 A B C D E F.
Proof.
Admitted.

Theorem th_4_16 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (fs A B C D E F G I /\ A <> B) -> cong C D G I.
Proof.
Admitted.

Theorem th_4_17 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ col A B C /\ cong A D A E /\ cong B D B E) -> cong C D C E.
Proof.
Admitted.

Theorem th_4_11 : forall (A:point) (B:point) (C:point), col A B C -> (col B C A /\ col C A B /\ col C B A /\ col B A C /\ col A C B).
Proof.
 intros.
 (* We are using: (col A B C) *)
 assert (bet A B C \/ bet B C A \/ bet C A B) by applying (ax_4_10_1 A B C ) .
 by cases on (bet A B C \/ bet B C A \/ bet C A B).
 (* Case : bet A B C *)
 (* We are using: (bet A B C) *)
 assert (col C A B) by applying (ax_4_10_3 A B C ) .
 (* We are using: (bet A B C) *)
 assert (bet C B A) by applying (th_3_2 A B C ) .
 (* We are using: (bet C B A) *)
 assert (col A C B) by applying (ax_4_10_3 C B A ) .
 (* We are using: (bet C B A) *)
 assert (col C B A) by applying (ax_4_10_2 C B A ) .
 (* We are using: (bet A B C) *)
 assert (col B C A) by applying (ax_4_10_4 A B C ) .
 (* We are using: (bet C B A) *)
 assert (col B A C) by applying (ax_4_10_4 C B A ) .
 solve [firstorder].
 (* end of the case. *)
 (* Case : bet B C A *)
 (* We are using: (bet B C A) *)
 assert (bet A C B) by applying (th_3_2 B C A ) .
 (* We are using: (bet A C B) *)
 assert (col B A C) by applying (ax_4_10_3 A C B ) .
 (* We are using: (bet A C B) *)
 assert (col A C B) by applying (ax_4_10_2 A C B ) .
 (* We are using: (bet B C A) *)
 assert (col B C A) by applying (ax_4_10_2 B C A ) .
 (* We are using: (bet A C B) *)
 assert (col C B A) by applying (ax_4_10_4 A C B ) .
 (* We are using: (bet B C A) *)
 assert (col C A B) by applying (ax_4_10_4 B C A ) .
 solve [firstorder].
 (* end of the case. *)
 (* Case : bet C A B *)
 (* We are using: (bet C A B) *)
 assert (col B C A) by applying (ax_4_10_3 C A B ) .
 (* We are using: (bet C A B) *)
 assert (bet B A C) by applying (th_3_2 C A B ) .
 (* We are using: (bet B A C) *)
 assert (col C B A) by applying (ax_4_10_3 B A C ) .
 (* We are using: (bet B A C) *)
 assert (col B A C) by applying (ax_4_10_2 B A C ) .
 (* We are using: (bet C A B) *)
 assert (col C A B) by applying (ax_4_10_2 C A B ) .
 (* We are using: (bet B A C) *)
 assert (col A C B) by applying (ax_4_10_4 B A C ) .
 solve [firstorder].
 (* end of the case. *)
Qed.

Theorem th_4_12 : forall (A:point) (B:point), col A A B.
Proof.
 intros.
 assert (bet A A B) by applying (th_3_3 A B ) .
 (* We are using: (bet A A B) *)
 assert (col A A B) by applying (ax_4_10_2 A A B ) .
 solve [firstorder].
Qed.

Theorem th_4_13 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (col A B C /\ cong3 A B C D E F) -> col D E F.
Proof.
 intros.
 (* We are using: (cong3 A B C D E F) *)
 assert (cong A B D E /\ cong A C D F /\ cong B C E F) by applying (ax_4_4_1 A B C D E F ) .
 (* We are using: (cong A B D E) *)
 assert (cong A B E D) by applying (th_2_5 A B D E ) .
 (* We are using: (cong A B E D) *)
 assert (cong B A E D) by applying (th_2_4 A B E D ) .
 (* We are using: (cong B C E F) *)
 assert (cong B C F E) by applying (th_2_5 B C E F ) .
 (* We are using: (cong B C F E) *)
 assert (cong C B F E) by applying (th_2_4 B C F E ) .
 (* We are using: (cong A C D F) and (cong A B D E) and (cong C B F E) *)
 assert (cong3 A C B D F E) by applying (ax_4_4_2 A C D F B E ) .
 (* We are using: (cong B A E D) and (cong B C E F) and (cong A C D F) *)
 assert (cong3 B A C E D F) by applying (ax_4_4_2 B A E D C F ) .
 (* We are using: (col A B C) *)
 assert (bet A B C \/ bet B C A \/ bet C A B) by applying (ax_4_10_1 A B C ) .
 by cases on (bet A B C \/ bet B C A \/ bet C A B).
 (* Case : bet A B C *)
 (* We are using: (bet A B C) and (cong3 A B C D E F) *)
 assert (bet D E F) by applying (th_4_6 A B C D E F ) .
 (* We are using: (bet D E F) *)
 assert (col D E F) by applying (ax_4_10_2 D E F ) .
 solve [firstorder].
 (* end of the case. *)
 (* Case : bet B C A *)
 (* We are using: (bet B C A) *)
 assert (bet A C B) by applying (th_3_2 B C A ) .
 (* We are using: (bet A C B) and (cong3 A C B D F E) *)
 assert (bet D F E) by applying (th_4_6 A C B D F E ) .
 (* We are using: (bet D F E) *)
 assert (col D F E) by applying (ax_4_10_2 D F E ) .
 (* We are using: (col D F E) *)
 assert (col F E D /\ col E D F /\ col E F D /\ col F D E /\ col D E F) by applying (th_4_11 D F E ) .
 solve [firstorder].
 (* end of the case. *)
 (* Case : bet C A B *)
 (* We are using: (bet C A B) *)
 assert (bet B A C) by applying (th_3_2 C A B ) .
 (* We are using: (bet B A C) and (cong3 B A C E D F) *)
 assert (bet E D F) by applying (th_4_6 B A C E D F ) .
 (* We are using: (bet E D F) *)
 assert (col E D F) by applying (ax_4_10_2 E D F ) .
 (* We are using: (col E D F) *)
 assert (col D F E /\ col F E D /\ col F D E /\ col D E F /\ col E F D) by applying (th_4_11 E D F ) .
 solve [firstorder].
 (* end of the case. *)
Qed.

Theorem th_4_18 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ col A B C /\ cong A C A D /\ cong B C B D) -> C = D.
Proof.
 intros.
 (* We are using: (A <> B) and (col A B C) and (cong A C A D) and (cong B C B D) *)
 assert (cong C C C D) by applying (th_4_17 A B C C D ) .
 (* We are using: (cong C C C D) *)
 assert (cong C D C C) by applying (th_2_2 C C C D ) .
 (* We are using: (cong C D C C) *)
 assert (C = D) by applying (ax_3 C D C ) .
 solve [firstorder].
Qed.

Theorem th_4_19 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ cong A B A D /\ cong C B C D) -> B = D.
Proof.
 intros.
 assert (bet B A A) by applying (th_3_1 B A ) .
 (* We are using: (bet A B C) *)
 assert (col C A B) by applying (ax_4_10_3 A B C ) .
 (* We are using: (cong A B A D) *)
 assert (cong A D A B) by applying (th_2_2 A B A D ) .
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (cong A D A B) and (A = B) *)
 assert (cong A D A A)  by (intuition;repeat subst; intuition).
 (* We are using: (cong A D A A) *)
 assert (A = D) by applying (ax_3 A D A ) .
 (* We are using: (A = B) and (A = D) *)
 assert (B = D)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> B *)
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
 by cases on (A = C \/ A <> C).
 (* Case : A = C *)
 (* We are using: (bet A B C) and (A = C) *)
 assert (bet A B A)  by (intuition;repeat subst; intuition).
 (* We are using: (bet A B A) and (bet B A A) *)
 assert (A = B) by applying (th_3_4 A B A ) .
 (* We are using: (A = B) and (A <> B) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> C *)
 (* We are using: (A <> C) *)
 assert (C <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (C <> A) and (col C A B) and (cong C B C D) and (cong A B A D) *)
 assert (B = D) by applying (th_4_18 C A B D ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
Qed.

(* Chapter : Relationship between Congruence and Comparison of Distances *)

Theorem th_5_1 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ bet A B C /\ bet A B D) -> bet A C D \/ bet A D C.
Proof.
Admitted.

Theorem th_5_3 : forall (A:point) (B:point) (D:point) (C:point), (bet A B D /\ bet A C D) -> bet A B C \/ bet A C B.
Proof.
Admitted.

Theorem th_5_5_1 : forall (A:point) (B:point) (C:point) (D:point), le A B C D -> exists E:point, (bet A B E /\ cong A E C D).
Proof.
Admitted.

Theorem th_5_5_2 : forall (A:point) (B:point) (E:point) (C:point) (D:point), (bet A B E /\ cong A E C D) -> le A B C D.
Proof.
Admitted.

Theorem th_5_6 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (le A B C D /\ cong A B E F /\ cong C D G I) -> le E F G I.
Proof.
Admitted.

Theorem th_5_8 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (le A B C D /\ le C D E F) -> le A B E F.
Proof.
Admitted.

Theorem th_5_9 : forall (A:point) (B:point) (C:point) (D:point), (le A B C D /\ le C D A B) -> cong A B C D.
Proof.
Admitted.

Theorem th_5_10 : forall (A:point) (B:point) (C:point) (D:point), le A B C D \/ le C D A B.
Proof.
Admitted.

Theorem th_5_2 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ bet A B C /\ bet A B D) -> bet B C D \/ bet B D C.
Proof.
 intros.
 (* We are using: (A <> B) and (bet A B C) and (bet A B C) *)
 assert (bet A C C \/ bet A C C) by applying (th_5_1 A B C C ) .
 by cases on (bet A C C \/ bet A C C).
 (* Case : bet A C C *)
 (* We are using: (bet A B C) and (bet A C C) *)
 assert (bet B C C /\ bet A B C) by applying (th_3_6 A B C C ) .
 (* We are using: (bet A C C) and (bet A C C) *)
 assert (bet C C C /\ bet A C C) by applying (th_3_6 A C C C ) .
 (* We are using: (A <> B) and (bet A B C) and (bet A B D) *)
 assert (bet A C D \/ bet A D C) by applying (th_5_1 A B C D ) .
 by cases on (bet A C D \/ bet A D C).
 (* Case : bet A C D *)
 (* We are using: (bet A B C) and (bet A C D) *)
 assert (bet B C D /\ bet A B D) by applying (th_3_6 A B C D ) .
 solve [firstorder].
 (* end of the case. *)
 (* Case : bet A D C *)
 (* We are using: (bet A B D) and (bet A D C) *)
 assert (bet B D C /\ bet A B C) by applying (th_3_6 A B D C ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : bet A C C *)
 (* We are using: (bet A B C) and (bet A C C) *)
 assert (bet B C C /\ bet A B C) by applying (th_3_6 A B C C ) .
 (* We are using: (A <> B) and (bet A B C) and (bet A B D) *)
 assert (bet A C D \/ bet A D C) by applying (th_5_1 A B C D ) .
 by cases on (bet A C D \/ bet A D C).
 (* Case : bet A C D *)
 (* We are using: (bet A B C) and (bet A C D) *)
 assert (bet B C D /\ bet A B D) by applying (th_3_6 A B C D ) .
 solve [firstorder].
 (* end of the case. *)
 (* Case : bet A D C *)
 (* We are using: (bet A B D) and (bet A D C) *)
 assert (bet B D C /\ bet A B C) by applying (th_3_6 A B D C ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
Qed.

Theorem th_5_7 : forall (A:point) (B:point), le A B A B.
Proof.
 intros.
 assert (bet A B B) by applying (th_3_1 A B ) .
 assert (cong A B A B) by applying (th_2_1 A B ) .
 (* We are using: (bet A B B) and (cong A B A B) *)
 assert (le A B A B) by applying (ax_5_4_2 A B B A B ) .
 solve [firstorder].
Qed.

Theorem th_5_11 : forall (A:point) (B:point) (C:point), le A A B C.
Proof.
 intros.
 assert (bet B B C) by applying (th_3_3 B C ) .
 assert (cong A A B B) by applying (th_2_8 A B ) .
 (* We are using: (bet B B C) and (cong A A B B) *)
 assert (le A A B C) by applying (ax_5_4_2 B B C A A ) .
 solve [firstorder].
Qed.

Theorem th_5_12_1 : forall (A:point) (B:point) (C:point), (col A B C /\ bet A B C) -> (le A B A C /\ le B C A C).
Proof.
 intros.
 (* We are using: (bet A B C) *)
 assert (bet C B A) by applying (th_3_2 A B C ) .
 assert (bet A C C) by applying (th_3_1 A C ) .
 assert (bet B A A) by applying (th_3_1 B A ) .
 assert (cong A B B A) by applying (ax_1 A B ) .
 assert (cong B A A B) by applying (ax_1 B A ) .
 assert (cong B C C B) by applying (ax_1 B C ) .
 assert (cong C A A C) by applying (ax_1 C A ) .
 (* We are using: (bet A B C) and (cong B A A B) *)
 assert (le B A A C) by applying (ax_5_4_2 A B C B A ) .
 (* We are using: (bet A C C) and (cong C A A C) *)
 assert (le C A A C) by applying (ax_5_4_2 A C C C A ) .
 (* We are using: (bet B A A) and (cong A B B A) *)
 assert (le A B B A) by applying (ax_5_4_2 B A A A B ) .
 (* We are using: (bet C B A) and (cong B C C B) *)
 assert (le B C C A) by applying (ax_5_4_2 C B A B C ) .
 (* We are using: (le A B B A) and (le B A A C) *)
 assert (le A B A C) by applying (th_5_8 A B B A A C ) .
 (* We are using: (le B C C A) and (le C A A C) *)
 assert (le B C A C) by applying (th_5_8 B C C A A C ) .
 solve [firstorder].
Qed.

Theorem th_5_12_2 : forall (A:point) (B:point) (C:point), (col A B C /\ le A B A C /\ le B C A C) -> bet A B C.
Proof.
 intros.
 assert (bet A A B) by applying (th_3_3 A B ) .
 assert (bet A A C) by applying (th_3_3 A C ) .
 assert (bet B B A) by applying (th_3_3 B A ) .
 assert (bet A B B) by applying (th_3_1 A B ) .
 assert (bet A C C) by applying (th_3_1 A C ) .
 assert (bet B A A) by applying (th_3_1 B A ) .
 (* We are using: (bet A A C) *)
 assert (col A A C) by applying (ax_4_10_2 A A C ) .
 (* We are using: (bet A C C) *)
 assert (col A C C) by applying (ax_4_10_2 A C C ) .
 (* We are using: (bet B A A) *)
 assert (col B A A) by applying (ax_4_10_2 B A A ) .
 (* We are using: (bet B B A) *)
 assert (col B B A) by applying (ax_4_10_2 B B A ) .
 (* We are using: (col A A C) and (bet A A C) *)
 assert (le A A A C /\ le A C A C) by applying (th_5_12_1 A A C ) .
 (* We are using: (col A C C) and (bet A C C) *)
 assert (le A C A C /\ le C C A C) by applying (th_5_12_1 A C C ) .
 (* We are using: (col B A A) and (bet B A A) *)
 assert (le B A B A /\ le A A B A) by applying (th_5_12_1 B A A ) .
 (* We are using: (col B B A) and (bet B B A) *)
 assert (le B B B A /\ le B A B A) by applying (th_5_12_1 B B A ) .
 (* We are using: (le A C A C) and (le A C A C) *)
 assert (cong A C A C) by applying (th_5_9 A C A C ) .
 (* We are using: (le B A B A) and (le B A B A) *)
 assert (cong B A B A) by applying (th_5_9 B A B A ) .
 assert (cong B A A B) by applying (ax_1 B A ) .
 (* We are using: (col A B C) *)
 assert (bet A B C \/ bet B C A \/ bet C A B) by applying (ax_4_10_1 A B C ) .
 by cases on (bet A B C \/ bet B C A \/ bet C A B).
 (* Case : bet A B C *)
 solve [firstorder].
 (* end of the case. *)
 (* Case : bet B C A *)
 (* We are using: (bet B C A) *)
 assert (bet A C B) by applying (th_3_2 B C A ) .
 (* We are using: (bet A C B) *)
 assert (col A C B) by applying (ax_4_10_2 A C B ) .
 (* We are using: (col A C B) and (bet A C B) *)
 assert (le A C A B /\ le C B A B) by applying (th_5_12_1 A C B ) .
 (* We are using: (le A C A B) and (le A B A C) *)
 assert (cong A C A B) by applying (th_5_9 A C A B ) .
 (* We are using: (cong A C A B) *)
 assert (cong C A A B) by applying (th_2_4 A C A B ) .
 (* We are using: (bet B C A) and (bet A A B) and (cong B A A B) and (cong C A A B) *)
 assert (cong B C A A) by applying (th_4_3 B C A A A B ) .
 (* We are using: (cong B C A A) *)
 assert (B = C) by applying (ax_3 B C A ) .
 (* We are using: (bet A B B) and (B = C) *)
 assert (bet A B C)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : bet C A B *)
 (* We are using: (bet C A B) *)
 assert (bet B A C) by applying (th_3_2 C A B ) .
 (* We are using: (bet B A C) *)
 assert (col B A C) by applying (ax_4_10_2 B A C ) .
 (* We are using: (col B A C) and (bet B A C) *)
 assert (le B A B C /\ le A C B C) by applying (th_5_12_1 B A C ) .
 (* We are using: (le A C B C) and (le B C A C) *)
 assert (cong A C B C) by applying (th_5_9 A C B C ) .
 (* We are using: (bet A A C) and (bet B A C) and (cong A C B C) and (cong A C A C) *)
 assert (cong A A B A) by applying (th_4_3 A A C B A C ) .
 (* We are using: (bet B A A) and (bet B B A) and (cong B A B A) and (cong A A B A) *)
 assert (cong B A B B) by applying (th_4_3 B A A B B A ) .
 (* We are using: (cong B A B B) *)
 assert (B = A) by applying (ax_3 B A B ) .
 (* We are using: (bet A A C) and (B = A) *)
 assert (bet B B C)  by (intuition;repeat subst; intuition).
 (* We are using: (bet B B C) and (B = A) *)
 assert (bet A B C)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
Qed.

(* Chapter : Half-lines and Lines *)

Theorem th_6_2_1 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> B /\ D <> B /\ bet A B D /\ bet C B D) -> out B A C.
Proof.
Admitted.

Theorem th_6_2_2 : forall (A:point) (D:point) (B:point) (C:point), (A <> D /\ B <> D /\ C <> D /\ bet A D C /\ out D A B) -> bet B D C.
Proof.
Admitted.

Theorem th_6_3_1 : forall (C:point) (A:point) (B:point), out C A B -> exists D:point, (A <> C /\ B <> C /\ D <> C /\ bet A C D /\ bet B C D).
Proof.
Admitted.

Theorem th_6_4_1 : forall (D:point) (A:point) (B:point) (C:point), out D A B -> (col A D B /\ not_bet A D B).
Proof.
Admitted.

Theorem th_6_11_1 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> D) -> exists E:point, (out B E A /\ cong B E C D).
Proof.
Admitted.

Theorem th_6_11_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (A <> B /\ C <> D /\ out B E A /\ cong B E C D /\ out B F A /\ cong B F C D) -> E = F.
Proof.
Admitted.

Theorem th_6_13_1 : forall (C:point) (A:point) (B:point), (out C A B /\ le C A C B) -> bet C A B.
Proof.
Admitted.

Theorem th_6_15_1 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ A <> C /\ bet B A C /\ point_on_line D A B) -> point_on_ray D A B \/ point_on_ray D A C \/ D = A.
Proof.
Admitted.

Theorem th_6_15_3 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ A <> C /\ bet B A C /\ point_on_ray D A C) -> point_on_line D A B.
Proof.
Admitted.

Theorem th_6_19_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (A <> B /\ C <> D /\ point_on_line A C D /\ point_on_line B C D /\ E <> F /\ point_on_line A E F /\ point_on_line B E F) -> same_lines C D E F.
Proof.
Admitted.

Theorem th_6_21 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (A <> B /\ C <> D /\ not_same_lines A B C D /\ point_on_line E A B /\ point_on_line E C D /\ point_on_line F A B /\ point_on_line F C D) -> E = F.
Proof.
Admitted.

Theorem th_6_23_2 : forall (D:point) (E:point) (A:point) (B:point) (C:point), (D <> E /\ point_on_line A D E /\ point_on_line B D E /\ point_on_line C D E) -> col A B C.
Proof.
Admitted.

Theorem th_6_24 : exists A:point, exists B:point, exists C:point, not_col A B C.
Proof.
Admitted.

Theorem th_6_3_2 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> B /\ D <> B /\ bet A B D /\ bet C B D) -> out B A C.
Proof.
 intros.
 (* We are using: (A <> B) and (C <> B) and (D <> B) and (bet A B D) and (bet C B D) *)
 assert (out B A C) by applying (th_6_2_1 A B C D ) .
 solve [firstorder].
Qed.

Theorem th_6_4_2 : forall (A:point) (B:point) (C:point) (D:point), (col A B C /\ not_bet A B C) -> out B A C.
Proof.
 intros.
 assert (bet A B B) by applying (th_3_1 A B ) .
 assert (bet A A C) by applying (th_3_3 A C ) .
 (* We are using: (col A B C) *)
 assert (bet A B C \/ bet B C A \/ bet C A B) by applying (ax_4_10_1 A B C ) .
 by cases on (bet A B C \/ bet B C A \/ bet C A B).
 (* Case : bet A B C *)
 (* We are using: (bet A B C) and (not_bet A B C) *)
 assert (False) by applying (ax_false_bet A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : bet B C A *)
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (bet A A C) and (A = B) *)
 assert (bet A B C)  by (intuition;repeat subst; intuition).
 (* We are using: (not_bet A B C) and (bet A B C) *)
 assert (False) by applying (ax_false_bet A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : A <> B *)
 assert (B = C \/ B <> C) by applying (ax_g1 B C ) .
 by cases on (B = C \/ B <> C).
 (* Case : B = C *)
 (* We are using: (bet A B B) and (B = C) *)
 assert (bet A B C)  by (intuition;repeat subst; intuition).
 (* We are using: (not_bet A B C) and (bet A B C) *)
 assert (False) by applying (ax_false_bet A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : B <> C *)
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (C <> B) and (bet B C A) *)
 assert (out B A C) by applying (ax_6_1_3 A B C ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* end of the case. *)
 (* Case : bet C A B *)
 (* We are using: (bet C A B) *)
 assert (bet B A C) by applying (th_3_2 C A B ) .
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (bet A A C) and (A = B) *)
 assert (bet A B C)  by (intuition;repeat subst; intuition).
 (* We are using: (not_bet A B C) and (bet A B C) *)
 assert (False) by applying (ax_false_bet A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : A <> B *)
 assert (B = C \/ B <> C) by applying (ax_g1 B C ) .
 by cases on (B = C \/ B <> C).
 (* Case : B = C *)
 (* We are using: (bet A B B) and (B = C) *)
 assert (bet A B C)  by (intuition;repeat subst; intuition).
 (* We are using: (not_bet A B C) and (bet A B C) *)
 assert (False) by applying (ax_false_bet A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : B <> C *)
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (C <> B) and (bet B A C) *)
 assert (out B A C) by applying (ax_6_1_2 A B C ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* end of the case. *)
Qed.

Theorem th_6_5 : forall (A:point) (B:point), A <> B -> out B A A.
Proof.
 intros.
 assert (bet B A A) by applying (th_3_1 B A ) .
 (* We are using: (A <> B) and (A <> B) and (bet B A A) *)
 assert (out B A A) by applying (ax_6_1_3 A B A ) .
 solve [firstorder].
Qed.

Theorem th_6_6 : forall (A:point) (B:point) (C:point), out A B C -> out A C B.
Proof.
 intros.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (out A B C) and (A = B) *)
 assert (out A A C)  by (intuition;repeat subst; intuition).
 (* We are using: (out A A C) *)
 let Hnew := fresh in  assert ( Hnew : exists I, (A <> A /\ C <> A /\ I <> A /\ bet A A I /\ bet C A I)) by applying (th_6_3_1 A A C ) ;destruct Hnew as [I Hnew];decompAnd Hnew.
 (* We are using: (A <> A) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> B *)
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
 by cases on (A = C \/ A <> C).
 (* Case : A = C *)
 (* We are using: (out A B C) and (A = C) *)
 assert (out A B A)  by (intuition;repeat subst; intuition).
 (* We are using: (out A B A) *)
 let Hnew := fresh in  assert ( Hnew : exists I, (B <> A /\ A <> A /\ I <> A /\ bet B A I /\ bet A A I)) by applying (th_6_3_1 A B A ) ;destruct Hnew as [I Hnew];decompAnd Hnew.
 (* We are using: (A <> A) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> C *)
 let Hnew := fresh in  assert ( Hnew : exists G, (bet B A G /\ A <> G)) by applying (th_3_14 B A ) ;destruct Hnew as [G Hnew];decompAnd Hnew.
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> C) *)
 assert (C <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> G) *)
 assert (G <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (B <> A) and (C <> A) and (G <> A) and (bet B A G) and (out A B C) *)
 assert (bet C A G) by applying (th_6_2_2 B A C G ) .
 (* We are using: (A <> C) *)
 assert (C <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> G) *)
 assert (G <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (C <> A) and (B <> A) and (G <> A) and (bet C A G) and (bet B A G) *)
 assert (out A C B) by applying (th_6_3_2 C A B G ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
Qed.

Theorem th_6_7 : forall (A:point) (B:point) (C:point) (D:point), (out A B C /\ out A C D) -> out A B D.
Proof.
 intros.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (out A B C) and (A = B) *)
 assert (out A A C)  by (intuition;repeat subst; intuition).
 (* We are using: (out A A C) *)
 let Hnew := fresh in  assert ( Hnew : exists N, (A <> A /\ C <> A /\ N <> A /\ bet A A N /\ bet C A N)) by applying (th_6_3_1 A A C ) ;destruct Hnew as [N Hnew];decompAnd Hnew.
 (* We are using: (A <> A) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> B *)
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
 by cases on (A = C \/ A <> C).
 (* Case : A = C *)
 (* We are using: (out A C D) and (A = C) *)
 assert (out A A D)  by (intuition;repeat subst; intuition).
 (* We are using: (out A A D) *)
 let Hnew := fresh in  assert ( Hnew : exists P, (A <> A /\ D <> A /\ P <> A /\ bet A A P /\ bet D A P)) by applying (th_6_3_1 A A D ) ;destruct Hnew as [P Hnew];decompAnd Hnew.
 (* We are using: (A <> A) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> C *)
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
 by cases on (A = D \/ A <> D).
 (* Case : A = D *)
 let Hnew := fresh in  assert ( Hnew : exists I, (bet B A I /\ A <> I)) by applying (th_3_14 B A ) ;destruct Hnew as [I Hnew];decompAnd Hnew.
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (out A C D) and (A = D) *)
 assert (out A C A)  by (intuition;repeat subst; intuition).
 (* We are using: (out A C A) *)
 let Hnew := fresh in  assert ( Hnew : exists N, (C <> A /\ A <> A /\ N <> A /\ bet C A N /\ bet A A N)) by applying (th_6_3_1 A C A ) ;destruct Hnew as [N Hnew];decompAnd Hnew.
 (* We are using: (A <> A) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> D *)
 let Hnew := fresh in  assert ( Hnew : exists J, (bet B A J /\ A <> J)) by applying (th_3_14 B A ) ;destruct Hnew as [J Hnew];decompAnd Hnew.
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> C) *)
 assert (C <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> J) *)
 assert (J <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (B <> A) and (C <> A) and (J <> A) and (bet B A J) and (out A B C) *)
 assert (bet C A J) by applying (th_6_2_2 B A C J ) .
 (* We are using: (A <> C) *)
 assert (C <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> D) *)
 assert (D <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> J) *)
 assert (J <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (C <> A) and (D <> A) and (J <> A) and (bet C A J) and (out A C D) *)
 assert (bet D A J) by applying (th_6_2_2 C A D J ) .
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> D) *)
 assert (D <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> J) *)
 assert (J <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (B <> A) and (D <> A) and (J <> A) and (bet B A J) and (bet D A J) *)
 assert (out A B D) by applying (th_6_3_2 B A D J ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* end of the case. *)
Qed.

Theorem th_6_13_2 : forall (A:point) (B:point) (C:point), (out A B C /\ bet A B C) -> le A B A C.
Proof.
 intros.
 (* We are using: (bet A B C) *)
 assert (col A B C) by applying (ax_4_10_2 A B C ) .
 (* We are using: (col A B C) and (bet A B C) *)
 assert (le A B A C /\ le B C A C) by applying (th_5_12_1 A B C ) .
 solve [firstorder].
Qed.

Theorem th_6_15_2 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ A <> C /\ bet B A C /\ point_on_ray D A B) -> point_on_line D A B.
Proof.
 intros.
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (B <> A) and (point_on_ray D A B) *)
 assert (out A D B) by applying (ax_6_8_1 B A D ) .
 (* We are using: (out A D B) *)
 assert (col D A B /\ not_bet D A B) by applying (th_6_4_1 A D B ) .
 (* We are using: (col D A B) *)
 assert (col A B D /\ col B D A /\ col B A D /\ col A D B /\ col D B A) by applying (th_4_11 D A B ) .
 (* We are using: (A <> B) and (col A B D) *)
 assert (point_on_line D A B) by applying (ax_6_14_2 A B D ) .
 solve [firstorder].
Qed.

Theorem th_6_15_4 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ A <> C /\ bet B A C /\ D = A) -> point_on_line D A B.
Proof.
 intros.
 assert (bet B A A) by applying (th_3_1 B A ) .
 (* We are using: (bet B A A) *)
 assert (col A B A) by applying (ax_4_10_3 B A A ) .
 (* We are using: (A <> B) and (col A B A) *)
 assert (point_on_line A A B) by applying (ax_6_14_2 A B A ) .
 (* We are using: (point_on_line A A B) and (D = A) *)
 assert (point_on_line D D B)  by (intuition;repeat subst; intuition).
 (* We are using: (point_on_line D D B) and (D = A) *)
 assert (point_on_line D A B)  by (intuition;repeat subst; intuition).
 solve [firstorder].
Qed.

Theorem th_6_16 : forall (A:point) (B:point) (C:point), (A <> B /\ C <> A /\ point_on_line C A B) -> same_lines A B A C.
Proof.
 intros.
 assert (bet B A A) by applying (th_3_1 B A ) .
 (* We are using: (bet B A A) *)
 assert (col A B A) by applying (ax_4_10_3 B A A ) .
 (* We are using: (A <> B) and (col A B A) *)
 assert (point_on_line A A B) by applying (ax_6_14_2 A B A ) .
 (* We are using: (C <> A) *)
 assert (A <> C)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (A <> C) and (point_on_line A A B) and (point_on_line C A B) *)
 assert (same_lines A B A C) by applying (ax_same_lines_1 A B A C ) .
 solve [firstorder].
Qed.

Theorem th_6_17 : forall (A:point) (B:point), A <> B -> (point_on_line A A B /\ point_on_line B A B /\ same_lines A B B A).
Proof.
 intros.
 assert (col A A B) by applying (th_4_12 A B ) .
 assert (col B B A) by applying (th_4_12 B A ) .
 (* We are using: (col A A B) *)
 assert (col A B A /\ col B A A /\ col B A A /\ col A A B /\ col A B A) by applying (th_4_11 A A B ) .
 (* We are using: (col B B A) *)
 assert (col B A B /\ col A B B /\ col A B B /\ col B B A /\ col B A B) by applying (th_4_11 B B A ) .
 (* We are using: (A <> B) and (col A B A) *)
 assert (point_on_line A A B) by applying (ax_6_14_2 A B A ) .
 (* We are using: (A <> B) and (col A B B) *)
 assert (point_on_line B A B) by applying (ax_6_14_2 A B B ) .
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (B <> A) and (point_on_line B A B) and (point_on_line A A B) *)
 assert (same_lines A B B A) by applying (ax_same_lines_1 A B B A ) .
 solve [firstorder].
Qed.

Theorem th_6_18 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> D /\ point_on_line C A B /\ point_on_line D A B) -> same_lines A B C D.
Proof.
 intros.
 (* We are using: (A <> B) and (C <> D) and (point_on_line C A B) and (point_on_line D A B) *)
 assert (same_lines A B C D) by applying (ax_same_lines_1 A B C D ) .
 solve [firstorder].
Qed.

Theorem th_6_19_1 : forall (A:point) (B:point), A <> B -> exists C:point, exists D:point, (C <> D /\ point_on_line A C D /\ point_on_line B C D).
Proof.
 intros.
 (* We are using: (A <> B) *)
 assert (point_on_line A A B /\ point_on_line B A B /\ same_lines A B B A) by applying (th_6_17 A B ) .
 solve [firstorder].
Qed.

Theorem th_6_23_1 : forall (A:point) (B:point) (C:point), col A B C -> exists D:point, exists E:point, (D <> E /\ point_on_line A D E /\ point_on_line B D E /\ point_on_line C D E).
Proof.
 intros.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
 by cases on (A = C \/ A <> C).
 (* Case : A = C *)
 let Hnew := fresh in  assert ( Hnew : exists D, (bet A A D /\ A <> D)) by applying (th_3_14 A A ) ;destruct Hnew as [D Hnew];decompAnd Hnew.
 (* We are using: (A <> D) *)
 assert (point_on_line A A D /\ point_on_line D A D /\ same_lines A D D A) by applying (th_6_17 A D ) .
 (* We are using: (point_on_line A A D) and (A = B) *)
 assert (point_on_line B A D)  by (intuition;repeat subst; intuition).
 (* We are using: (point_on_line A A D) and (A = C) *)
 assert (point_on_line C A D)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> C *)
 (* We are using: (A <> C) *)
 assert (point_on_line A A C /\ point_on_line C A C /\ same_lines A C C A) by applying (th_6_17 A C ) .
 (* We are using: (point_on_line A A C) and (A = B) *)
 assert (point_on_line B A C)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : A <> B *)
 (* We are using: (A <> B) *)
 assert (point_on_line A A B /\ point_on_line B A B /\ same_lines A B B A) by applying (th_6_17 A B ) .
 (* We are using: (A <> B) and (col A B C) *)
 assert (point_on_line C A B) by applying (ax_6_14_2 A B C ) .
 solve [firstorder].
 (* end of the case. *)
Qed.

Theorem th_6_25 : forall (A:point) (B:point), A <> B -> exists C:point, not_col A B C.
Proof.
 intros.
 assert (col A B A \/ not_col A B A) by applying (ax_branch_col A B A ) .
 by cases on (col A B A \/ not_col A B A).
 (* Case : col A B A *)
 (* We are using: (A <> B) and (col A B A) *)
 assert (point_on_line A A B) by applying (ax_6_14_2 A B A ) .
 assert (col A B B \/ not_col A B B) by applying (ax_branch_col A B B ) .
 by cases on (col A B B \/ not_col A B B).
 (* Case : col A B B *)
 (* We are using: (A <> B) and (col A B B) *)
 assert (point_on_line B A B) by applying (ax_6_14_2 A B B ) .
 let Hnew := fresh in  assert ( Hnew : exists C,  exists D,  exists E, (not_col C D E)) by applying (th_6_24 ) ;destruct Hnew as [C[D[E]] Hnew];decompAnd Hnew.
 assert (col A B C \/ not_col A B C) by applying (ax_branch_col A B C ) .
 by cases on (col A B C \/ not_col A B C).
 (* Case : col A B C *)
 (* We are using: (A <> B) and (col A B C) *)
 assert (point_on_line C A B) by applying (ax_6_14_2 A B C ) .
 assert (col A B D \/ not_col A B D) by applying (ax_branch_col A B D ) .
 by cases on (col A B D \/ not_col A B D).
 (* Case : col A B D *)
 (* We are using: (A <> B) and (col A B D) *)
 assert (point_on_line D A B) by applying (ax_6_14_2 A B D ) .
 assert (col A B E \/ not_col A B E) by applying (ax_branch_col A B E ) .
 by cases on (col A B E \/ not_col A B E).
 (* Case : col A B E *)
 (* We are using: (A <> B) and (col A B E) *)
 assert (point_on_line E A B) by applying (ax_6_14_2 A B E ) .
 (* We are using: (A <> B) and (point_on_line C A B) and (point_on_line D A B) and (point_on_line E A B) *)
 assert (col C D E) by applying (th_6_23_2 A B C D E ) .
 (* We are using: (col C D E) and (not_col C D E) *)
 assert (False) by applying (ax_false_col C D E ) .
 contradict.
 (* end of the case. *)
 (* Case : not_col A B E *)
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : not_col A B D *)
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : not_col A B C *)
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : not_col A B B *)
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : not_col A B A *)
 solve [firstorder].
 (* end of the case. *)
Qed.

(* Chapter : Point reflexivity *)

Theorem th_7_13 : forall (A:point) (D:point) (C:point) (B:point) (E:point), (is_symmetric A D C /\ is_symmetric B E C) -> cong A B D E.
Proof.
Admitted.

Theorem th_7_19_1 : forall (C:point) (D:point) (B:point) (F:point) (A:point) (E:point), (is_symmetric C D B /\ is_symmetric D F A /\ is_symmetric C E A /\ is_symmetric E F B) -> A = B.
Proof.
Admitted.

Theorem th_7_20 : forall (A:point) (B:point) (C:point), (col A B C /\ cong B A B C) -> A = C \/ is_midpoint B A C.
Proof.
Admitted.

Theorem th_7_21 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (not_col A B C /\ B <> D /\ cong A B C D /\ cong B C D A /\ col A E C /\ col B E D) -> (is_midpoint E A C /\ is_midpoint E B D).
Proof.
Admitted.

Theorem th_7_22 : forall (A:point) (E:point) (B:point) (C:point) (D:point) (F:point) (G:point), (bet A E B /\ bet C E D /\ cong E A E C /\ cong E B E D /\ is_midpoint F A C /\ is_midpoint G B D) -> bet F E G.
Proof.
Admitted.

Theorem th_7_25 : forall (C:point) (A:point) (B:point), cong C A C B -> exists D:point, is_midpoint D A B.
Proof.
Admitted.

Theorem th_7_2 : forall (A:point) (B:point) (C:point), is_midpoint A B C -> is_midpoint A C B.
Proof.
 intros.
 (* We are using: (is_midpoint A B C) *)
 assert (bet B A C /\ cong A B A C) by applying (ax_7_1 A B C ) .
 (* We are using: (bet B A C) *)
 assert (bet C A B) by applying (th_3_2 B A C ) .
 (* We are using: (cong A B A C) *)
 assert (cong A C A B) by applying (th_2_2 A B A C ) .
 (* We are using: (bet C A B) and (cong A C A B) *)
 assert (is_midpoint A C B) by applying (ax_7_2 C A B ) .
 solve [firstorder].
Qed.

Theorem th_7_3_1 : forall (A:point) (B:point), is_midpoint A B B -> A = B.
Proof.
 intros.
 (* We are using: (is_midpoint A B B) *)
 assert (bet B A B /\ cong A B A B) by applying (ax_7_1 A B B ) .
 (* We are using: (bet B A B) *)
 assert (B = A) by applying (ax_6 B A ) .
 (* We are using: (B = A) *)
 assert (A = B)  by (intuition;repeat subst; intuition).
 solve [firstorder].
Qed.

Theorem th_7_3_2 : forall (A:point), is_midpoint A A A.
Proof.
 intros.
 assert (bet A A A) by applying (th_3_1 A A ) .
 assert (cong A A A A) by applying (th_2_1 A A ) .
 (* We are using: (bet A A A) and (cong A A A A) *)
 assert (is_midpoint A A A) by applying (ax_7_2 A A A ) .
 solve [firstorder].
Qed.

Theorem th_7_4_1 : forall (A:point) (B:point), exists C:point, is_midpoint A B C.
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists M, (bet B A M /\ cong A M A B)) by applying (ax_4 B A A B ) ;destruct Hnew as [M Hnew];decompAnd Hnew.
 (* We are using: (cong A M A B) *)
 assert (cong A B A M) by applying (th_2_2 A M A B ) .
 (* We are using: (bet B A M) and (cong A B A M) *)
 assert (is_midpoint A B M) by applying (ax_7_2 B A M ) .
 solve [firstorder].
Qed.

Theorem th_7_4_2 : forall (A:point) (B:point) (C:point) (D:point), (is_midpoint A B C /\ is_midpoint A B D) -> C = D.
Proof.
 intros.
 (* We are using: (is_midpoint A B C) *)
 assert (is_midpoint A C B) by applying (th_7_2 A B C ) .
 (* We are using: (is_midpoint A B D) *)
 assert (is_midpoint A D B) by applying (th_7_2 A B D ) .
 (* We are using: (is_midpoint A B C) *)
 assert (bet B A C /\ cong A B A C) by applying (ax_7_1 A B C ) .
 (* We are using: (is_midpoint A B D) *)
 assert (bet B A D /\ cong A B A D) by applying (ax_7_1 A B D ) .
 (* We are using: (is_midpoint A C B) *)
 assert (bet C A B /\ cong A C A B) by applying (ax_7_1 A C B ) .
 (* We are using: (is_midpoint A D B) *)
 assert (bet D A B /\ cong A D A B) by applying (ax_7_1 A D B ) .
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (cong A C A B) and (A = B) *)
 assert (cong A C A A)  by (intuition;repeat subst; intuition).
 (* We are using: (cong A C A A) *)
 assert (A = C) by applying (ax_3 A C A ) .
 (* We are using: (cong A D A B) and (A = B) and (A = C) *)
 assert (cong A D A A)  by (intuition;repeat subst; intuition).
 (* We are using: (cong A D A A) *)
 assert (A = D) by applying (ax_3 A D A ) .
 (* We are using: (A = C) and (A = D) *)
 assert (C = D)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> B *)
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (B <> A) and (bet B A C) and (cong A C A B) and (bet B A D) and (cong A D A B) *)
 assert (C = D) by applying (th_2_12 B A C A B D ) .
 solve [firstorder].
 (* end of the case. *)
Qed.

Theorem th_7_7 : forall (A:point) (B:point) (C:point), is_symmetric A B C -> is_symmetric B A C.
Proof.
 intros.
 (* We are using: (is_symmetric A B C) *)
 assert (is_midpoint C A B) by applying (ax_7_5_1 A B C ) .
 (* We are using: (is_midpoint C A B) *)
 assert (is_midpoint C B A) by applying (th_7_2 C A B ) .
 (* We are using: (is_midpoint C B A) *)
 assert (is_symmetric B A C) by applying (ax_7_5_2 C B A ) .
 solve [firstorder].
Qed.

Theorem th_7_8_1 : forall (A:point) (B:point), exists C:point, is_symmetric C A B.
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists E, (is_midpoint B A E)) by applying (th_7_4_1 B A ) ;destruct Hnew as [E Hnew];decompAnd Hnew.
 (* We are using: (is_midpoint B A E) *)
 assert (is_midpoint B E A) by applying (th_7_2 B A E ) .
 (* We are using: (is_midpoint B E A) *)
 assert (is_symmetric E A B) by applying (ax_7_5_2 B E A ) .
 solve [firstorder].
Qed.

Theorem th_7_8_2 : forall (A:point) (B:point) (C:point) (D:point), (is_symmetric A B C /\ is_symmetric D B C) -> A = D.
Proof.
 intros.
 (* We are using: (is_symmetric A B C) *)
 assert (is_midpoint C A B) by applying (ax_7_5_1 A B C ) .
 (* We are using: (is_midpoint C A B) *)
 assert (is_midpoint C B A) by applying (th_7_2 C A B ) .
 (* We are using: (is_symmetric D B C) *)
 assert (is_midpoint C D B) by applying (ax_7_5_1 D B C ) .
 (* We are using: (is_midpoint C D B) *)
 assert (is_midpoint C B D) by applying (th_7_2 C D B ) .
 (* We are using: (is_midpoint C B A) and (is_midpoint C B D) *)
 assert (A = D) by applying (th_7_4_2 C B A D ) .
 solve [firstorder].
Qed.

Theorem th_7_10_1 : forall (A:point) (B:point), is_symmetric A A B -> A = B.
Proof.
 intros.
 (* We are using: (is_symmetric A A B) *)
 assert (is_midpoint B A A) by applying (ax_7_5_1 A A B ) .
 (* We are using: (is_midpoint B A A) *)
 assert (B = A) by applying (th_7_3_1 B A ) .
 (* We are using: (B = A) *)
 assert (A = B)  by (intuition;repeat subst; intuition).
 solve [firstorder].
Qed.

Theorem th_7_10_2 : forall (A:point), is_symmetric A A A.
Proof.
 intros.
 assert (is_midpoint A A A) by applying (th_7_3_2 A ) .
 (* We are using: (is_midpoint A A A) *)
 assert (is_symmetric A A A) by applying (ax_7_5_2 A A A ) .
 solve [firstorder].
Qed.

Theorem th_7_15_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point), (bet A B C /\ is_symmetric A D E /\ is_symmetric B F E /\ is_symmetric C G E) -> bet D F G.
Proof.
 intros.
 (* We are using: (is_symmetric A D E) and (is_symmetric B F E) *)
 assert (cong A B D F) by applying (th_7_13 A D E B F ) .
 (* We are using: (is_symmetric A D E) and (is_symmetric C G E) *)
 assert (cong A C D G) by applying (th_7_13 A D E C G ) .
 (* We are using: (is_symmetric B F E) and (is_symmetric C G E) *)
 assert (cong B C F G) by applying (th_7_13 B F E C G ) .
 (* We are using: (cong A B D F) and (cong A C D G) and (cong B C F G) *)
 assert (cong3 A B C D F G) by applying (ax_4_4_2 A B D F C G ) .
 (* We are using: (bet A B C) and (cong3 A B C D F G) *)
 assert (bet D F G) by applying (th_4_6 A B C D F G ) .
 solve [firstorder].
Qed.

Theorem th_7_15_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point), (bet A B C /\ is_symmetric D A E /\ is_symmetric F B E /\ is_symmetric G C E) -> bet D F G.
Proof.
 intros.
 (* We are using: (is_symmetric D A E) and (is_symmetric F B E) *)
 assert (cong D F A B) by applying (th_7_13 D A E F B ) .
 (* We are using: (cong D F A B) *)
 assert (cong A B D F) by applying (th_2_2 D F A B ) .
 (* We are using: (is_symmetric D A E) and (is_symmetric G C E) *)
 assert (cong D G A C) by applying (th_7_13 D A E G C ) .
 (* We are using: (cong D G A C) *)
 assert (cong A C D G) by applying (th_2_2 D G A C ) .
 (* We are using: (is_symmetric F B E) and (is_symmetric G C E) *)
 assert (cong F G B C) by applying (th_7_13 F B E G C ) .
 (* We are using: (cong F G B C) *)
 assert (cong B C F G) by applying (th_2_2 F G B C ) .
 (* We are using: (cong A B D F) and (cong A C D G) and (cong B C F G) *)
 assert (cong3 A B C D F G) by applying (ax_4_4_2 A B D F C G ) .
 (* We are using: (bet A B C) and (cong3 A B C D F G) *)
 assert (bet D F G) by applying (th_4_6 A B C D F G ) .
 solve [firstorder].
Qed.

Theorem th_7_16_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point), (cong A B C D /\ is_symmetric A E F /\ is_symmetric B G F /\ is_symmetric C I F /\ is_symmetric D J F) -> cong E G I J.
Proof.
 intros.
 (* We are using: (is_symmetric A E F) and (is_symmetric B G F) *)
 assert (cong A B E G) by applying (th_7_13 A E F B G ) .
 (* We are using: (is_symmetric C I F) and (is_symmetric D J F) *)
 assert (cong C D I J) by applying (th_7_13 C I F D J ) .
 (* We are using: (cong A B C D) and (cong A B E G) *)
 assert (cong C D E G) by applying (ax_2 A B C D E G ) .
 (* We are using: (cong C D E G) and (cong C D I J) *)
 assert (cong E G I J) by applying (ax_2 C D E G I J ) .
 solve [firstorder].
Qed.

Theorem th_7_16_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point), (cong A B C D /\ is_symmetric E A F /\ is_symmetric G B F /\ is_symmetric I C F /\ is_symmetric J D F) -> cong E G I J.
Proof.
 intros.
 (* We are using: (is_symmetric E A F) *)
 assert (is_symmetric A E F) by applying (th_7_7 E A F ) .
 (* We are using: (is_symmetric G B F) *)
 assert (is_symmetric B G F) by applying (th_7_7 G B F ) .
 (* We are using: (is_symmetric I C F) *)
 assert (is_symmetric C I F) by applying (th_7_7 I C F ) .
 (* We are using: (is_symmetric J D F) *)
 assert (is_symmetric D J F) by applying (th_7_7 J D F ) .
 (* We are using: (cong A B C D) and (is_symmetric A E F) and (is_symmetric B G F) and (is_symmetric C I F) and (is_symmetric D J F) *)
 assert (cong E G I J) by applying (th_7_16_1 A B C D E F G I J ) .
 solve [firstorder].
Qed.

Theorem th_7_17 : forall (A:point) (B:point) (C:point) (D:point), (is_midpoint A B C /\ is_midpoint D B C) -> A = D.
Proof.
 intros.
 assert (bet A B B) by applying (th_3_1 A B ) .
 assert (bet D A A) by applying (th_3_1 D A ) .
 (* We are using: (is_midpoint A B C) *)
 assert (bet B A C /\ cong A B A C) by applying (ax_7_1 A B C ) .
 (* We are using: (is_midpoint D B C) *)
 assert (bet B D C /\ cong D B D C) by applying (ax_7_1 D B C ) .
 (* We are using: (bet B A C) *)
 assert (col C B A) by applying (ax_4_10_3 B A C ) .
 (* We are using: (bet B D C) *)
 assert (col C B D) by applying (ax_4_10_3 B D C ) .
 (* We are using: (bet D A A) *)
 assert (col A D A) by applying (ax_4_10_3 D A A ) .
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
 by cases on (A = C \/ A <> C).
 (* Case : A = C *)
 (* We are using: (bet B D C) and (A = B) and (A = C) *)
 assert (bet A D A)  by (intuition;repeat subst; intuition).
 (* We are using: (bet A D A) and (bet D A A) *)
 assert (A = D) by applying (th_3_4 A D A ) .
 (* We are using: (A = D) *)
 assert (A = D)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> C *)
 (* We are using: (col C B A) and (A = B) *)
 assert (col C A A)  by (intuition;repeat subst; intuition).
 (* We are using: (col C B D) and (A = B) *)
 assert (col C A D)  by (intuition;repeat subst; intuition).
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
 by cases on (A = D \/ A <> D).
 (* Case : A = D *)
 (* We are using: (A = D) *)
 assert (A = D)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> D *)
 (* We are using: (cong A B A C) and (A = B) *)
 assert (cong A A A C)  by (intuition;repeat subst; intuition).
 (* We are using: (cong D B D C) and (A = B) *)
 assert (cong D A D C)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> D) and (col A D A) and (cong A A A C) and (cong D A D C) *)
 assert (A = C) by applying (th_4_18 A D A C ) .
 (* We are using: (A = C) and (A <> C) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* end of the case. *)
 (* end of the case. *)
 (* Case : A <> B *)
 (* We are using: (A <> B) *)
 assert (point_on_line A A B /\ point_on_line B A B /\ same_lines A B B A) by applying (th_6_17 A B ) .
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
 by cases on (A = D \/ A <> D).
 (* Case : A = D *)
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> D *)
 assert (B = C \/ B <> C) by applying (ax_g1 B C ) .
 by cases on (B = C \/ B <> C).
 (* Case : B = C *)
 (* We are using: (bet B A C) and (B = C) *)
 assert (bet B A B)  by (intuition;repeat subst; intuition).
 (* We are using: (bet A B B) and (bet B A B) *)
 assert (A = B) by applying (th_3_4 A B B ) .
 (* We are using: (A = B) and (A <> B) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : B <> C *)
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (C <> B) and (col C B A) *)
 assert (point_on_line A C B) by applying (ax_6_14_2 C B A ) .
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (C <> B) and (col C B D) *)
 assert (point_on_line D C B) by applying (ax_6_14_2 C B D ) .
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (C <> B) *)
 assert (point_on_line C C B /\ point_on_line B C B /\ same_lines C B B C) by applying (th_6_17 C B ) .
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (C <> B) and (point_on_line A C B) and (point_on_line B C B) and (point_on_line D C B) *)
 assert (col A B D) by applying (th_6_23_2 C B A B D ) .
 (* We are using: (A <> B) and (col A B D) *)
 assert (point_on_line D A B) by applying (ax_6_14_2 A B D ) .
 (* We are using: (A <> B) and (point_on_line A A B) and (point_on_line D A B) and (point_on_line B A B) *)
 assert (col A D B) by applying (th_6_23_2 A B A D B ) .
 (* We are using: (A <> D) and (col A D B) and (cong A B A C) and (cong D B D C) *)
 assert (B = C) by applying (th_4_18 A D B C ) .
 (* We are using: (B = C) and (B <> C) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* end of the case. *)
 (* end of the case. *)
Qed.

Theorem th_7_18 : forall (A:point) (B:point) (C:point) (D:point), (is_symmetric A B C /\ is_symmetric A B D) -> C = D.
Proof.
 intros.
 (* We are using: (is_symmetric A B C) *)
 assert (is_midpoint C A B) by applying (ax_7_5_1 A B C ) .
 (* We are using: (is_symmetric A B D) *)
 assert (is_midpoint D A B) by applying (ax_7_5_1 A B D ) .
 (* We are using: (is_midpoint C A B) and (is_midpoint D A B) *)
 assert (C = D) by applying (th_7_17 C A B D ) .
 solve [firstorder].
Qed.

Theorem th_7_19_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point), (is_symmetric A B C /\ is_symmetric B D E /\ is_symmetric A F E /\ is_symmetric F G C /\ E = C) -> D = G.
Proof.
 intros.
 (* We are using: (is_symmetric A F E) and (E = C) *)
 assert (is_symmetric A F C)  by (intuition;repeat subst; intuition).
 (* We are using: (is_symmetric B D E) and (E = C) *)
 assert (is_symmetric B D C)  by (intuition;repeat subst; intuition).
 (* We are using: (is_symmetric B D C) *)
 assert (is_symmetric D B C) by applying (th_7_7 B D C ) .
 (* We are using: (is_symmetric F G C) *)
 assert (is_symmetric G F C) by applying (th_7_7 F G C ) .
 (* We are using: (is_symmetric A B C) and (is_symmetric D B C) *)
 assert (A = D) by applying (th_7_8_2 A B C D ) .
 (* We are using: (is_symmetric A F E) and (E = C) *)
 assert (is_symmetric A F C)  by (intuition;repeat subst; intuition).
 (* We are using: (is_symmetric A F C) and (is_symmetric G F C) *)
 assert (A = G) by applying (th_7_8_2 A F C G ) .
 (* We are using: (A = D) and (A = G) *)
 assert (D = G)  by (intuition;repeat subst; intuition).
 solve [firstorder].
Qed.

(* Chapter : Right Angles *)

Theorem th_8_2 : forall (A:point) (B:point) (C:point), per A B C -> per C B A.
Proof.
Admitted.

Theorem th_8_3 : forall (A:point) (B:point) (C:point) (D:point), (per A B C /\ A <> B /\ col B A D) -> per D B C.
Proof.
Admitted.

Theorem th_8_6 : forall (A:point) (B:point) (C:point) (D:point), (per A B C /\ per D B C /\ bet A C D) -> B = C.
Proof.
Admitted.

Theorem th_8_7 : forall (A:point) (B:point) (C:point), (per A B C /\ per A C B) -> B = C.
Proof.
Admitted.

Theorem th_8_10 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (per A B C /\ cong3 A B C D E F) -> per D E F.
Proof.
Admitted.

Theorem th_8_12 : forall (A:point) (B:point) (C:point) (D:point) (E:point), perp_in A B C D E -> perp_in A D E B C.
Proof.
Admitted.

Theorem th_8_13_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point), perp_in A B C D E -> exists F:point, exists G:point, (B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ point_on_line F B C /\ point_on_line G D E /\ F <> A /\ G <> A /\ per F A G).
Proof.
Admitted.

Theorem th_8_13_2 : forall (B:point) (C:point) (D:point) (E:point) (A:point) (F:point) (G:point), (B <> C /\ D <> E /\ point_on_line A B C /\ point_on_line A D E /\ point_on_line F B C /\ point_on_line G D E /\ F <> A /\ G <> A /\ per F A G) -> perp_in A B C D E.
Proof.
Admitted.

Theorem th_8_14_1 : forall (A:point) (B:point) (C:point) (D:point), perp A B C D -> (A <> B /\ C <> D /\ not_same_lines A B C D).
Proof.
Admitted.

Theorem th_8_14_2_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point), perp_in A B C D E -> (perp B C D E /\ inter A B C D E).
Proof.
Admitted.

Theorem th_8_14_2_2 : forall (B:point) (C:point) (D:point) (E:point) (A:point), (perp B C D E /\ inter A B C D E) -> perp_in A B C D E.
Proof.
Admitted.

Theorem th_8_14_3 : forall (E:point) (A:point) (B:point) (C:point) (D:point) (F:point), (perp_in E A B C D /\ perp_in F A B C D) -> E = F.
Proof.
Admitted.

Theorem th_8_16_1 : forall (A:point) (B:point) (D:point) (E:point) (C:point), (A <> B /\ col A B D /\ col A B E /\ E <> D /\ perp A B C D) -> (not_col A B C /\ per C D E).
Proof.
Admitted.

Theorem th_8_16_2 : forall (A:point) (B:point) (D:point) (E:point) (C:point), (A <> B /\ col A B D /\ col A B E /\ E <> D /\ not_col A B C /\ per C D E) -> perp A B C D.
Proof.
Admitted.

Theorem th_8_18_1 : forall (A:point) (B:point) (C:point), not_col A B C -> exists D:point, (col A B D /\ perp A B C D).
Proof.
Admitted.

Theorem th_8_20_1 : forall (A:point) (B:point) (C:point) (E:point) (F:point) (D:point), (per A B C /\ is_symmetric C E A /\ is_symmetric C F B /\ is_midpoint D E F) -> per B A D.
Proof.
Admitted.

Theorem th_8_21 : forall (A:point) (B:point) (C:point), A <> B -> exists D:point, exists E:point, (perp A B D A /\ col A B E /\ bet C E D).
Proof.
Admitted.

Theorem th_8_22_1 : forall (A:point) (B:point), exists C:point, is_midpoint C A B.
Proof.
Admitted.

Theorem th_8_24 : forall (C:point) (A:point) (B:point) (D:point) (E:point) (F:point), (perp C A A B /\ perp D B A B /\ col A B E /\ bet C E D /\ bet B F D /\ cong A C B F) -> exists G:point, (is_midpoint G A B /\ is_midpoint G C F).
Proof.
Admitted.

Theorem th_8_4 : forall (A:point) (B:point) (C:point) (D:point), (per A B C /\ is_midpoint B C D) -> per A B D.
Proof.
 intros.
 (* We are using: (is_midpoint B C D) *)
 assert (is_midpoint B D C) by applying (th_7_2 B C D ) .
 (* We are using: (per A B C) *)
 let Hnew := fresh in  assert ( Hnew : exists E, (cong A C A E /\ is_midpoint B C E)) by applying (ax_8_1_1 A B C ) ;destruct Hnew as [E Hnew];decompAnd Hnew.
 (* We are using: (is_midpoint B C D) and (is_midpoint B C E) *)
 assert (D = E) by applying (th_7_4_2 B C D E ) .
 (* We are using: (cong A C A E) and (D = E) *)
 assert (cong A C A D)  by (intuition;repeat subst; intuition).
 (* We are using: (cong A C A D) *)
 assert (cong A D A C) by applying (th_2_2 A C A D ) .
 (* We are using: (cong A D A C) and (is_midpoint B D C) *)
 assert (per A B D) by applying (ax_8_1_2 A D C B ) .
 solve [firstorder].
Qed.

Theorem th_8_5 : forall (A:point) (B:point), per A B B.
Proof.
 intros.
 assert (is_midpoint B B B) by applying (th_7_3_2 B ) .
 assert (cong A B A B) by applying (th_2_1 A B ) .
 (* We are using: (cong A B A B) and (is_midpoint B B B) *)
 assert (per A B B) by applying (ax_8_1_2 A B B B ) .
 solve [firstorder].
Qed.

Theorem th_8_8 : forall (A:point) (B:point), per A B A -> A = B.
Proof.
 intros.
 assert (bet A A A) by applying (th_3_1 A A ) .
 (* We are using: (per A B A) and (per A B A) and (bet A A A) *)
 assert (B = A) by applying (th_8_6 A B A A ) .
 (* We are using: (B = A) *)
 assert (A = B)  by (intuition;repeat subst; intuition).
 solve [firstorder].
Qed.

Theorem th_8_9 : forall (A:point) (B:point) (C:point), (per A B C /\ col A B C) -> A = B \/ C = B.
Proof.
 intros.
 (* We are using: (col A B C) *)
 assert (col B C A /\ col C A B /\ col C B A /\ col B A C /\ col A C B) by applying (th_4_11 A B C ) .
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> B *)
 (* We are using: (per A B C) and (A <> B) and (col B A C) *)
 assert (per C B C) by applying (th_8_3 A B C C ) .
 (* We are using: (per C B C) *)
 assert (C = B) by applying (th_8_8 C B ) .
 solve [firstorder].
 (* end of the case. *)
Qed.

Theorem th_8_15_1 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ col A B C /\ perp A B D C) -> perp_in C A B D C.
Proof.
 intros.
 (* We are using: (perp A B D C) *)
 assert (A <> B /\ D <> C /\ not_same_lines A B D C) by applying (th_8_14_1 A B D C ) .
 (* We are using: (D <> C) *)
 assert (point_on_line D D C /\ point_on_line C D C /\ same_lines D C C D) by applying (th_6_17 D C ) .
 (* We are using: (A <> B) and (col A B C) *)
 assert (point_on_line C A B) by applying (ax_6_14_2 A B C ) .
 (* We are using: (A <> B) and (D <> C) and (point_on_line C A B) and (point_on_line C D C) and (not_same_lines A B D C) *)
 assert (inter C A B D C) by applying (ax_6_22_2 A B D C C ) .
 (* We are using: (perp A B D C) and (inter C A B D C) *)
 assert (perp_in C A B D C) by applying (th_8_14_2_2 A B D C C ) .
 solve [firstorder].
Qed.

Theorem th_8_15_2 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ col A B C /\ perp_in C A B D C) -> perp A B D C.
Proof.
 intros.
 (* We are using: (perp_in C A B D C) *)
 assert (perp A B D C) by applying (ax_8_11_2_2 C A B D C ) .
 solve [firstorder].
Qed.

Theorem th_8_18_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (not_col A B C /\ col A B D /\ perp A B C D /\ col A B E /\ perp A B C E) -> D = E.
Proof.
 intros.
 (* We are using: (perp A B C D) *)
 assert (A <> B /\ C <> D /\ not_same_lines A B C D) by applying (th_8_14_1 A B C D ) .
 (* We are using: (perp A B C E) *)
 assert (A <> B /\ C <> E /\ not_same_lines A B C E) by applying (th_8_14_1 A B C E ) .
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
 by cases on (A = D \/ A <> D).
 (* Case : A = D *)
 assert (A = E \/ A <> E) by applying (ax_g1 A E ) .
 by cases on (A = E \/ A <> E).
 (* Case : A = E *)
 (* We are using: (A = D) and (A = E) *)
 assert (D = E)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> E *)
 (* We are using: (col A B D) and (A = D) *)
 assert (col A B A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> E) *)
 assert (E <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (perp A B C D) and (A = D) *)
 assert (perp A B C A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (col A B A) and (col A B E) and (E <> A) and (perp A B C A) *)
 assert (not_col A B C /\ per C A E) by applying (th_8_16_1 A B A E C ) .
 (* We are using: (col A B D) and (A = D) *)
 assert (col A B A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (col A B E) and (col A B A) and (A <> E) and (perp A B C E) *)
 assert (not_col A B C /\ per C E A) by applying (th_8_16_1 A B E A C ) .
 (* We are using: (per C A E) and (per C E A) *)
 assert (A = E) by applying (th_8_7 C A E ) .
 (* We are using: (A = E) and (A <> E) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* end of the case. *)
 (* Case : A <> D *)
 assert (B = D \/ B <> D) by applying (ax_g1 B D ) .
 by cases on (B = D \/ B <> D).
 (* Case : B = D *)
 assert (B = E \/ B <> E) by applying (ax_g1 B E ) .
 by cases on (B = E \/ B <> E).
 (* Case : B = E *)
 (* We are using: (B = D) and (B = E) *)
 assert (D = E)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : B <> E *)
 (* We are using: (col A B D) and (B = D) *)
 assert (col A B B)  by (intuition;repeat subst; intuition).
 (* We are using: (B <> E) *)
 assert (E <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (perp A B C D) and (B = D) *)
 assert (perp A B C B)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (col A B B) and (col A B E) and (E <> B) and (perp A B C B) *)
 assert (not_col A B C /\ per C B E) by applying (th_8_16_1 A B B E C ) .
 (* We are using: (col A B D) and (B = D) *)
 assert (col A B B)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (col A B E) and (col A B B) and (B <> E) and (perp A B C E) *)
 assert (not_col A B C /\ per C E B) by applying (th_8_16_1 A B E B C ) .
 (* We are using: (per C B E) and (per C E B) *)
 assert (B = E) by applying (th_8_7 C B E ) .
 (* We are using: (B = E) and (B <> E) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* end of the case. *)
 (* Case : B <> D *)
 assert (D = E \/ D <> E) by applying (ax_g1 D E ) .
 by cases on (D = E \/ D <> E).
 (* Case : D = E *)
 solve [firstorder].
 (* end of the case. *)
 (* Case : D <> E *)
 (* We are using: (D <> E) *)
 assert (E <> D)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (col A B D) and (col A B E) and (E <> D) and (perp A B C D) *)
 assert (not_col A B C /\ per C D E) by applying (th_8_16_1 A B D E C ) .
 (* We are using: (A <> B) and (col A B E) and (col A B D) and (D <> E) and (perp A B C E) *)
 assert (not_col A B C /\ per C E D) by applying (th_8_16_1 A B E D C ) .
 (* We are using: (per C D E) and (per C E D) *)
 assert (D = E) by applying (th_8_7 C D E ) .
 (* We are using: (D = E) and (D <> E) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* end of the case. *)
 (* end of the case. *)
Qed.

Theorem th_8_20_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (per A B C /\ is_symmetric C D A /\ is_symmetric C E B /\ is_midpoint F D E /\ B <> C) -> A <> F.
Proof.
 intros.
 (* We are using: (is_symmetric C D A) *)
 assert (is_midpoint A C D) by applying (ax_7_5_1 C D A ) .
 (* We are using: (is_midpoint A C D) *)
 assert (is_midpoint A D C) by applying (th_7_2 A C D ) .
 (* We are using: (is_symmetric C E B) *)
 assert (is_midpoint B C E) by applying (ax_7_5_1 C E B ) .
 assert (bet B C C) by applying (th_3_1 B C ) .
 assert (bet F D D) by applying (th_3_1 F D ) .
 (* We are using: (is_midpoint B C E) *)
 assert (bet C B E /\ cong B C B E) by applying (ax_7_1 B C E ) .
 (* We are using: (is_midpoint F D E) *)
 assert (bet D F E /\ cong F D F E) by applying (ax_7_1 F D E ) .
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (is_midpoint B C E) and (A = B) *)
 assert (is_midpoint A C E)  by (intuition;repeat subst; intuition).
 (* We are using: (is_midpoint A C D) and (is_midpoint A C E) *)
 assert (D = E) by applying (th_7_4_2 A C D E ) .
 (* We are using: (bet D F E) and (D = E) *)
 assert (bet D F D)  by (intuition;repeat subst; intuition).
 (* We are using: (bet D F D) and (bet F D D) *)
 assert (D = F) by applying (th_3_4 D F D ) .
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
 by cases on (A = D \/ A <> D).
 (* Case : A = D *)
 (* We are using: (is_midpoint F D E) and (A = B) and (D = E) and (D = F) and (A = D) *)
 assert (is_midpoint A A A)  by (intuition;repeat subst; intuition).
 (* We are using: (is_midpoint A D C) and (A = B) and (D = E) and (D = F) and (A = D) *)
 assert (is_midpoint A A C)  by (intuition;repeat subst; intuition).
 (* We are using: (is_midpoint A A A) and (is_midpoint A A C) *)
 assert (A = C) by applying (th_7_4_2 A A A C ) .
 (* We are using: (B <> C) and (A = B) and (D = E) and (D = F) and (A = D) *)
 assert (A <> C)  by (intuition;repeat subst; intuition).
 (* We are using: (B <> C) and (A = B) *)
 assert (A <> C)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> C) *)
 assert (A <> C)  by (intuition;repeat subst; intuition).
 (* We are using: (A = C) and (A <> C) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> D *)
 (* We are using: (A <> D) *)
 assert (A <> D)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> D) and (D = F) *)
 assert (A <> F)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> D) and (D = F) *)
 assert (A <> F)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* Case : A <> B *)
 assert (A = F \/ A <> F) by applying (ax_g1 A F ) .
 by cases on (A = F \/ A <> F).
 (* Case : A = F *)
 (* We are using: (is_midpoint F D E) and (A = F) *)
 assert (is_midpoint A D E)  by (intuition;repeat subst; intuition).
 (* We are using: (is_midpoint A D C) and (is_midpoint A D E) *)
 assert (C = E) by applying (th_7_4_2 A D C E ) .
 (* We are using: (bet C B E) and (C = E) *)
 assert (bet C B C)  by (intuition;repeat subst; intuition).
 (* We are using: (bet B C C) and (bet C B C) *)
 assert (B = C) by applying (th_3_4 B C C ) .
 (* We are using: (B = C) and (B <> C) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : A <> F *)
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
Qed.

Theorem th_8_22_2 : forall (A:point) (B:point) (C:point) (D:point), (is_midpoint A B C /\ is_midpoint D B C) -> A = D.
Proof.
 intros.
 (* We are using: (is_midpoint A B C) and (is_midpoint D B C) *)
 assert (A = D) by applying (th_7_17 A B C D ) .
 solve [firstorder].
Qed.

(* Chapter : Half-planes and Planes, Subspaces *)

Theorem th_9_3 : forall (C:point) (E:point) (A:point) (B:point) (F:point) (G:point) (D:point), (two_sides C E A B /\ A <> B /\ point_on_line F A B /\ is_midpoint F C E /\ point_on_line G A B /\ out G C D) -> two_sides D E A B.
Proof.
Admitted.

Theorem th_9_4_1 : forall (C:point) (D:point) (A:point) (B:point) (E:point) (F:point) (G:point) (I:point) (J:point), (two_sides C D A B /\ A <> B /\ point_on_line E A B /\ perp A B C E /\ point_on_line F A B /\ perp A B D F /\ is_midpoint G E F /\ out E I C /\ is_symmetric I J G) -> out F J D.
Proof.
Admitted.

Theorem th_9_4_2 : forall (C:point) (D:point) (A:point) (B:point) (E:point) (F:point) (G:point) (J:point) (I:point), (two_sides C D A B /\ A <> B /\ point_on_line E A B /\ perp A B C E /\ point_on_line F A B /\ perp A B D F /\ is_midpoint G E F /\ out F J D /\ is_symmetric I J G) -> out E I C.
Proof.
Admitted.

Theorem th_9_4_3 : forall (C:point) (D:point) (A:point) (B:point) (E:point) (F:point) (G:point) (I:point), (two_sides C D A B /\ A <> B /\ point_on_line E A B /\ perp A B C E /\ point_on_line F A B /\ perp A B D F /\ out E G C /\ out F I D) -> two_sides G I A B.
Proof.
Admitted.

Theorem th_9_5 : forall (A:point) (B:point) (C:point) (E:point) (F:point) (D:point), (A <> B /\ two_sides C E A B /\ point_on_line F A B /\ out F C D) -> two_sides D E A B.
Proof.
Admitted.

Theorem th_9_6 : forall (A:point) (C:point) (D:point) (B:point) (E:point), (bet A C D /\ bet B E C) -> exists F:point, (bet A F B /\ bet D E F).
Proof.
Admitted.

Theorem th_9_8_2 : forall (C:point) (E:point) (A:point) (B:point) (D:point), (two_sides C E A B /\ one_side C D A B) -> two_sides D E A B.
Proof.
Admitted.

Theorem th_9_9 : forall (C:point) (D:point) (A:point) (B:point), two_sides C D A B -> not_one_side C D A B.
Proof.
Admitted.

Theorem th_9_10 : forall (A:point) (B:point) (C:point), (A <> B /\ not_point_on_line C A B) -> exists D:point, two_sides C D A B.
Proof.
Admitted.

Theorem th_9_17 : forall (C:point) (D:point) (A:point) (B:point) (E:point), (one_side C D A B /\ bet C E D) -> one_side E C A B.
Proof.
Admitted.

Theorem th_9_18_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ point_on_line C A B /\ col D E C /\ two_sides D E A B) -> (bet D C E /\ not_point_on_line D A B /\ not_point_on_line E A B).
Proof.
Admitted.

Theorem th_9_19_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ point_on_line C A B /\ col D E C /\ one_side D E A B) -> (out C D E /\ not_point_on_line D A B).
Proof.
Admitted.

Theorem th_9_31 : forall (A:point) (B:point) (C:point) (D:point), (one_side A B C D /\ one_side A D C B) -> two_sides D B C A.
Proof.
Admitted.

Theorem th_9_2 : forall (A:point) (B:point) (C:point) (D:point), two_sides A B C D -> two_sides B A C D.
Proof.
 intros.
 (* We are using: (two_sides A B C D) *)
 let Hnew := fresh in  assert ( Hnew : exists E, (C <> D /\ not_point_on_line A C D /\ not_point_on_line B C D /\ point_on_line E C D /\ bet A E B)) by applying (ax_9_1_1 A B C D ) ;destruct Hnew as [E Hnew];decompAnd Hnew.
 (* We are using: (bet A E B) *)
 assert (bet B E A) by applying (th_3_2 A E B ) .
 (* We are using: (C <> D) and (not_point_on_line B C D) and (not_point_on_line A C D) and (point_on_line E C D) and (bet B E A) *)
 assert (two_sides B A C D) by applying (ax_9_1_2 C D B A E ) .
 solve [firstorder].
Qed.

Theorem th_9_8_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (two_sides A B C D /\ two_sides E B C D) -> one_side A E C D.
Proof.
 intros.
 assert (C = D \/ C <> D) by applying (ax_g1 C D ) .
 by cases on (C = D \/ C <> D).
 (* Case : C = D *)
 (* We are using: (two_sides A B C D) and (C = D) *)
 assert (two_sides A B C C)  by (intuition;repeat subst; intuition).
 (* We are using: (two_sides A B C C) *)
 let Hnew := fresh in  assert ( Hnew : exists F, (C <> C /\ not_point_on_line A C C /\ not_point_on_line B C C /\ point_on_line F C C /\ bet A F B)) by applying (ax_9_1_1 A B C C ) ;destruct Hnew as [F Hnew];decompAnd Hnew.
 (* We are using: (C <> C) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : C <> D *)
 (* We are using: (C <> D) and (two_sides A B C D) and (two_sides E B C D) *)
 assert (one_side A E C D) by applying (ax_9_7_2 C D A B E ) .
 solve [firstorder].
 (* end of the case. *)
Qed.

Theorem th_9_11 : forall (A:point) (B:point) (C:point), (A <> B /\ not_point_on_line C A B) -> one_side C C A B.
Proof.
 intros.
 (* We are using: (A <> B) and (not_point_on_line C A B) *)
 let Hnew := fresh in  assert ( Hnew : exists D, (two_sides C D A B)) by applying (th_9_10 A B C ) ;destruct Hnew as [D Hnew];decompAnd Hnew.
 (* We are using: (two_sides C D A B) and (two_sides C D A B) *)
 assert (one_side C C A B) by applying (th_9_8_1 C D A B C ) .
 solve [firstorder].
Qed.

Theorem th_9_12 : forall (A:point) (B:point) (C:point) (D:point), one_side A B C D -> one_side B A C D.
Proof.
 intros.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (one_side A B C D) and (A = B) *)
 assert (one_side A A C D)  by (intuition;repeat subst; intuition).
 (* We are using: (one_side A A C D) and (A = B) *)
 assert (one_side B A C D)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> B *)
 (* We are using: (one_side A B C D) *)
 let Hnew := fresh in  assert ( Hnew : exists E, (C <> D /\ two_sides A E C D /\ two_sides B E C D)) by applying (ax_9_7_1 A B C D ) ;destruct Hnew as [E Hnew];decompAnd Hnew.
 (* We are using: (two_sides B E C D) and (two_sides A E C D) *)
 assert (one_side B A C D) by applying (th_9_8_1 B E C D A ) .
 solve [firstorder].
 (* end of the case. *)
Qed.

Theorem th_9_13 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (one_side A B C D /\ one_side B E C D) -> one_side A E C D.
Proof.
 intros.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (one_side B E C D) and (A = B) *)
 assert (one_side A E C D)  by (intuition;repeat subst; intuition).
 solve [firstorder].
 (* end of the case. *)
 (* Case : A <> B *)
 assert (C = D \/ C <> D) by applying (ax_g1 C D ) .
 by cases on (C = D \/ C <> D).
 (* Case : C = D *)
 (* We are using: (one_side A B C D) and (C = D) *)
 assert (one_side A B C C)  by (intuition;repeat subst; intuition).
 (* We are using: (one_side A B C C) *)
 let Hnew := fresh in  assert ( Hnew : exists F, (C <> C /\ two_sides A F C C /\ two_sides B F C C)) by applying (ax_9_7_1 A B C C ) ;destruct Hnew as [F Hnew];decompAnd Hnew.
 (* We are using: (C <> C) *)
 assert (False)  by (intuition;repeat subst; intuition).
 contradict.
 (* end of the case. *)
 (* Case : C <> D *)
 (* We are using: (one_side A B C D) *)
 let Hnew := fresh in  assert ( Hnew : exists F, (C <> D /\ two_sides A F C D /\ two_sides B F C D)) by applying (ax_9_7_1 A B C D ) ;destruct Hnew as [F Hnew];decompAnd Hnew.
 (* We are using: (two_sides B F C D) and (one_side B E C D) *)
 assert (two_sides E F C D) by applying (th_9_8_2 B F C D E ) .
 (* We are using: (two_sides A F C D) and (two_sides E F C D) *)
 assert (one_side A E C D) by applying (th_9_8_1 A F C D E ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
Qed.

Theorem th_9_18_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ point_on_line C A B /\ col D E C /\ bet D C E /\ not_point_on_line D A B /\ not_point_on_line E A B) -> two_sides D E A B.
Proof.
 intros.
 (* We are using: (A <> B) and (not_point_on_line D A B) and (not_point_on_line E A B) and (point_on_line C A B) and (bet D C E) *)
 assert (two_sides D E A B) by applying (ax_9_1_2 A B D E C ) .
 solve [firstorder].
Qed.

Theorem th_9_19_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ point_on_line C A B /\ col D E C /\ out C D E /\ not_point_on_line D A B) -> one_side D E A B.
Proof.
 intros.
 (* We are using: (A <> B) and (not_point_on_line D A B) *)
 let Hnew := fresh in  assert ( Hnew : exists F, (two_sides D F A B)) by applying (th_9_10 A B D ) ;destruct Hnew as [F Hnew];decompAnd Hnew.
 (* We are using: (A <> B) and (two_sides D F A B) and (point_on_line C A B) and (out C D E) *)
 assert (two_sides E F A B) by applying (th_9_5 A B D F C E ) .
 (* We are using: (two_sides D F A B) and (two_sides E F A B) *)
 assert (one_side D E A B) by applying (th_9_8_1 D F A B E ) .
 solve [firstorder].
Qed.

(* Chapter : Line reflexivity *)

Theorem th_10_2 : forall (A:point) (B:point) (C:point), A <> B -> exists D:point, is_image D C A B.
Proof.
Admitted.

Theorem th_10_4 : forall (B:point) (A:point) (C:point) (D:point), is_image B A C D -> is_image A B C D.
Proof.
Admitted.

Theorem th_10_5 : forall (A:point) (B:point) (D:point) (C:point) (E:point), (A <> B /\ is_image D C A B /\ is_image E D A B) -> C = E.
Proof.
Admitted.

Theorem th_10_8_1 : forall (A:point) (B:point) (C:point), (A <> B /\ is_image C C A B) -> point_on_line C A B.
Proof.
Admitted.

Theorem th_10_10 : forall (A:point) (B:point) (E:point) (C:point) (F:point) (D:point), (A <> B /\ is_image E C A B /\ is_image F D A B) -> cong C D E F.
Proof.
Admitted.

Theorem th_10_12 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (per A B C /\ per D E F /\ cong A B D E /\ cong B C E F) -> cong A C D F.
Proof.
Admitted.

Theorem th_10_14 : forall (A:point) (B:point) (D:point) (C:point), (A <> B /\ is_image D C A B /\ not_point_on_line C A B) -> two_sides C D A B.
Proof.
Admitted.

Theorem th_10_15 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ point_on_line C A B /\ not_point_on_line D A B) -> exists E:point, (perp A B E C /\ one_side E D A B).
Proof.
Admitted.

Theorem th_10_16_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (not_col A B C /\ not_col D E F /\ cong A B D E) -> exists G:point, (cong3 A B C D E G /\ one_side G F D E).
Proof.
Admitted.

Theorem th_10_16_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (not_col A B C /\ not_col D E F /\ cong A B D E /\ cong3 A B C D E G /\ one_side G F D E /\ cong3 A B C D E I /\ one_side I F D E) -> G = I.
Proof.
Admitted.

Theorem th_10_6_1 : forall (A:point) (B:point) (C:point), A <> B -> exists D:point, is_image C D A B.
Proof.
 intros.
 (* We are using: (A <> B) *)
 let Hnew := fresh in  assert ( Hnew : exists F, (is_image F C A B)) by applying (th_10_2 A B ) ;destruct Hnew as [F Hnew];decompAnd Hnew.
 (* We are using: (is_image F C A B) *)
 assert (is_image C F A B) by applying (th_10_4 F C A B ) .
 solve [firstorder].
Qed.

Theorem th_10_6_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ is_image C D A B /\ is_image C E A B) -> D = E.
Proof.
 intros.
 (* We are using: (is_image C E A B) *)
 assert (is_image E C A B) by applying (th_10_4 C E A B ) .
 (* We are using: (A <> B) and (is_image C D A B) and (is_image E C A B) *)
 assert (D = E) by applying (th_10_5 A B C D E ) .
 solve [firstorder].
Qed.

Theorem th_10_7 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (A <> B /\ is_image C D A B /\ is_image C E A B) -> D = E.
Proof.
 intros.
 (* We are using: (A <> B) and (is_image C D A B) and (is_image C E A B) *)
 assert (D = E) by applying (th_10_6_2 A B C D E ) .
 solve [firstorder].
Qed.

Theorem th_10_8_2 : forall (A:point) (B:point) (C:point), (A <> B /\ point_on_line C A B) -> is_image C C A B.
Proof.
 intros.
 assert (is_midpoint C C C) by applying (th_7_3_2 C ) .
 (* We are using: (A <> B) and (is_midpoint C C C) and (point_on_line C A B) *)
 assert (is_image_spec C C A B) by applying (ax_10_3_2_2 A B C C ) .
 (* We are using: (A <> B) and (is_image_spec C C A B) *)
 assert (is_image C C A B) by applying (ax_10_3_4_1 A B C C ) .
 solve [firstorder].
Qed.

(* Chapter : Congruence and Comparison of Angles, Congruence theorem, Orthogonality for Subspaces *)

Theorem th_11_3_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong_angle A B C D E F -> exists G:point, exists I:point, exists J:point, exists K:point, (out B G A /\ out B I C /\ out E J D /\ out E K F /\ cong3 G B I J E K).
Proof.
Admitted.

Theorem th_11_3_2 : forall (B:point) (G:point) (A:point) (I:point) (C:point) (E:point) (J:point) (D:point) (K:point) (F:point), (out B G A /\ out B I C /\ out E J D /\ out E K F /\ cong3 G B I J E K) -> cong_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_4_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point), (cong_angle A B C D E F /\ A <> B /\ C <> B /\ D <> E /\ F <> E /\ out B G A /\ out B I C /\ out E J D /\ out E K F /\ cong B G E J /\ cong B I E K) -> cong G I J K.
Proof.
Admitted.

Theorem th_11_4_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point), (A <> B /\ C <> B /\ D <> E /\ F <> E /\ out B G A /\ out B I C /\ out E J D /\ out E K F /\ cong B G E J /\ cong B I E K /\ cong G I J K) -> cong_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_6 : forall (A:point) (B:point) (C:point), (A <> B /\ C <> B) -> cong_angle A B C A B C.
Proof.
Admitted.

Theorem th_11_7 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong_angle A B C D E F -> cong_angle D E F A B C.
Proof.
Admitted.

Theorem th_11_8 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point), (cong_angle A B C D E F /\ cong_angle D E F G I J) -> cong_angle A B C G I J.
Proof.
Admitted.

Theorem th_11_9 : forall (A:point) (B:point) (C:point), (A <> B /\ C <> B) -> cong_angle A B C C B A.
Proof.
Admitted.

Theorem th_11_10 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point), (cong_angle A B C D E F /\ out B G A /\ out B I C /\ out E J D /\ out E K F) -> cong_angle G B I J E K.
Proof.
Admitted.

Theorem th_11_13 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (cong_angle A B C D E F /\ bet A B G /\ G <> B /\ bet D E I /\ I <> E) -> cong_angle G B C I E F.
Proof.
Admitted.

Theorem th_11_14 : forall (A:point) (B:point) (D:point) (C:point) (E:point), (bet A B D /\ distinct A B D /\ bet C B E /\ distinct C B E) -> cong_angle A B C D B E.
Proof.
Admitted.

Theorem th_11_15_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (not_col A B C /\ not_col D E F) -> exists G:point, (cong_angle A B C D E G /\ one_side G F E D).
Proof.
Admitted.

Theorem th_11_15_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (not_col A B C /\ not_col D E F /\ cong_angle A B C D E G /\ one_side G F E D /\ cong_angle A B C D E I /\ one_side I F E D) -> G = I.
Proof.
Admitted.

Theorem th_11_16 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (per A B C /\ A <> B /\ C <> B /\ per D E F /\ D <> E /\ F <> E) -> cong_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_17 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (per A B C /\ cong_angle A B C D E F) -> per D E F.
Proof.
Admitted.

Theorem th_11_18_2 : forall (C:point) (B:point) (D:point) (A:point), (bet C B D /\ distinct B C D /\ A <> B /\ cong_angle A B C A B D) -> per A B C.
Proof.
Admitted.

Theorem th_11_19 : forall (B:point) (A:point) (C:point) (D:point), (per B A C /\ per B A D /\ one_side C D A B) -> out A C D.
Proof.
Admitted.

Theorem th_11_21_1_1 : forall (B:point) (A:point) (C:point) (D:point) (E:point) (F:point), (out B A C /\ cong_angle A B C D E F) -> out E D F.
Proof.
Admitted.

Theorem th_11_21_1_2 : forall (B:point) (A:point) (C:point) (E:point) (D:point) (F:point), (out B A C /\ out E D F) -> cong_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_21_2_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (bet A B C /\ distinct A B C /\ cong_angle A B C D E F) -> (bet D E F /\ distinct D E F).
Proof.
Admitted.

Theorem th_11_21_2_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (bet A B C /\ distinct A B C /\ bet D E F /\ distinct D E F) -> cong_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_22_1 : forall (A:point) (C:point) (B:point) (D:point) (E:point) (G:point) (F:point) (I:point), (two_sides A C B D /\ two_sides E G F I /\ cong_angle A B D E F I /\ cong_angle D B C I F G) -> cong_angle A B C E F G.
Proof.
Admitted.

Theorem th_11_22_2 : forall (A:point) (C:point) (B:point) (D:point) (E:point) (G:point) (F:point) (I:point), (one_side A C B D /\ one_side E G F I /\ cong_angle A B D E F I /\ cong_angle D B C I F G) -> cong_angle A B C E F G.
Proof.
Admitted.

Theorem th_11_24 : forall (A:point) (B:point) (C:point) (D:point), point_in_angle A B C D -> point_in_angle A D C B.
Proof.
Admitted.

Theorem th_11_25 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point), (point_in_angle A B C D /\ out C E B /\ out C F D /\ out C G A) -> point_in_angle G E C F.
Proof.
Admitted.

Theorem th_11_28 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point), (cong3 A B C D E F /\ col A C G) -> exists I:point, cong4 A B C G D E F I.
Proof.
Admitted.

Theorem th_11_29_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), le_angle A B C D E F -> exists G:point, (point_in_angle C A B G /\ cong_angle A B G D E F).
Proof.
Admitted.

Theorem th_11_29_2 : forall (C:point) (A:point) (B:point) (G:point) (D:point) (E:point) (F:point), (point_in_angle C A B G /\ cong_angle A B G D E F) -> le_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_30 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point) (L:point) (M:point), (le_angle A B C D E F /\ cong_angle A B C G I J /\ cong_angle D E F K L M) -> le_angle G I J K L M.
Proof.
Admitted.

Theorem th_11_31_1 : forall (B:point) (A:point) (C:point) (D:point) (E:point) (F:point), (out B A C /\ D <> E /\ F <> E) -> le_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_31_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (A <> B /\ C <> B /\ bet D E F /\ distinct D E F) -> le_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_33 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point), (le_angle A B C D E F /\ le_angle D E F G I J) -> le_angle A B C G I J.
Proof.
Admitted.

Theorem th_11_34 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (le_angle A B C D E F /\ le_angle D E F A B C) -> cong_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_35 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (A <> B /\ C <> B /\ D <> E /\ F <> E) -> le_angle A B C D E F \/ le_angle D E F A B C.
Proof.
Admitted.

Theorem th_11_36_1 : forall (A:point) (B:point) (G:point) (D:point) (E:point) (I:point) (C:point) (F:point), (bet A B G /\ distinct A B G /\ bet D E I /\ distinct D E I /\ le_angle A B C D E F) -> le_angle I E F G B C.
Proof.
Admitted.

Theorem th_11_36_2 : forall (A:point) (B:point) (G:point) (D:point) (E:point) (I:point) (F:point) (C:point), (bet A B G /\ distinct A B G /\ bet D E I /\ distinct D E I /\ le_angle I E F G B C) -> le_angle A B C D E F.
Proof.
Admitted.

Theorem th_11_41 : forall (A:point) (B:point) (C:point) (D:point), (not_col A B C /\ bet B A D /\ D <> A) -> (lt_angle A C B C A D /\ lt_angle A B C C A D).
Proof.
Admitted.

Theorem th_11_43_1 : forall (A:point) (B:point) (C:point), (not_col A B C /\ per B A C) -> (acute A B C /\ acute A C B).
Proof.
Admitted.

Theorem th_11_43_2 : forall (A:point) (B:point) (C:point), (not_col A B C /\ obtuse B A C) -> (acute A B C /\ acute A C B).
Proof.
Admitted.

Theorem th_11_44_2 : forall (A:point) (B:point) (C:point), (not_col A B C /\ cong_angle A C B A B C) -> cong A B A C.
Proof.
Admitted.

Theorem th_11_44_3 : forall (A:point) (B:point) (C:point), (not_col A B C /\ lt A B A C) -> lt_angle A C B A B C.
Proof.
Admitted.

Theorem th_11_44_4 : forall (A:point) (B:point) (C:point), (not_col A B C /\ lt_angle A C B A B C) -> lt A B A C.
Proof.
Admitted.

Theorem th_11_46_1 : forall (A:point) (B:point) (C:point), (not_col A B C /\ per B A C) -> (lt A B B C /\ lt A C B C).
Proof.
Admitted.

Theorem th_11_46_2 : forall (A:point) (B:point) (C:point), (not_col A B C /\ obtuse B A C) -> (lt A B B C /\ lt A C B C).
Proof.
Admitted.

Theorem th_11_47 : forall (A:point) (C:point) (B:point) (D:point), (per A C B /\ perp_in D C D A B) -> (bet A D B /\ distinct A D B).
Proof.
Admitted.

Theorem th_11_49_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong_angle A B C D E F /\ cong B A E D /\ cong B C E F) -> cong A C D F.
Proof.
Admitted.

Theorem th_11_49_2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong_angle A B C D E F /\ cong B A E D /\ cong B C E F /\ cong A C D F /\ A <> C) -> (cong_angle B A C E D F /\ cong_angle B C A E F D).
Proof.
Admitted.

Theorem th_11_50_1 : forall (A:point) (B:point) (C:point) (E:point) (D:point) (F:point), (not_col A B C /\ cong_angle B A C E D F /\ cong_angle A B C D E F /\ cong A B D E) -> (cong A C D F /\ cong B C E F /\ cong_angle A C B D F E).
Proof.
Admitted.

Theorem th_11_50_2 : forall (A:point) (B:point) (C:point) (E:point) (F:point) (D:point), (not_col A B C /\ cong_angle B C A E F D /\ cong_angle A B C D E F /\ cong A B D E) -> (cong A C D F /\ cong B C E F /\ cong_angle B A C E D F).
Proof.
Admitted.

Theorem th_11_51 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (distinct A B C /\ cong A B D E /\ cong A C D F /\ cong B C E F) -> (cong_angle B A C E D F /\ cong_angle A B C D E F /\ cong_angle B C A E F D).
Proof.
Admitted.

Theorem th_11_52 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong_angle A B C D E F /\ cong A C D F /\ cong B C E F /\ le B C A C) -> (cong B A E D /\ cong_angle B A C E D F /\ cong_angle B C A E F D).
Proof.
Admitted.

Theorem th_11_53 : forall (A:point) (D:point) (C:point) (B:point), (per A D C /\ C <> D /\ distinct A B D /\ bet D A B) -> (lt_angle D B C D A C /\ lt A C B C).
Proof.
Admitted.

Theorem th_11_57 : forall (B:point) (E:point) (A:point) (D:point) (C:point) (F:point), (one_side B E A D /\ one_side C F A D /\ per B A D /\ per C A D /\ per E D A /\ per F D A) -> cong_angle B A C E D F.
Proof.
Admitted.

Theorem th_11_18_1 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ distinct B A C /\ D <> B /\ per D B A) -> cong_angle D B A D B C.
Proof.
 intros.
 (* We are using: (distinct B A C) *)
 assert (B <> A /\ B <> C /\ A <> C) by applying (ax_distinct_1 B A C ) .
 (* We are using: (per D B A) *)
 assert (per A B D) by applying (th_8_2 D B A ) .
 (* We are using: (bet A B C) *)
 assert (bet C B A) by applying (th_3_2 A B C ) .
 (* We are using: (bet C B A) *)
 assert (col B A C) by applying (ax_4_10_4 C B A ) .
 (* We are using: (B <> A) *)
 assert (A <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (per A B D) and (A <> B) and (col B A C) *)
 assert (per C B D) by applying (th_8_3 A B D C ) .
 (* We are using: (per C B D) *)
 assert (per D B C) by applying (th_8_2 C B D ) .
 (* We are using: (B <> A) *)
 assert (A <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (per D B A) and (D <> B) and (A <> B) and (per D B C) and (D <> B) and (C <> B) *)
 assert (cong_angle D B A D B C) by applying (th_11_16 D B A D B C ) .
 solve [firstorder].
Qed.

Theorem th_11_32 : forall (A:point) (B:point) (C:point), (A <> B /\ C <> B) -> le_angle A B C A B C.
Proof.
 intros.
 assert (bet A C C) by applying (th_3_1 A C ) .
 (* We are using: (C <> B) *)
 assert (out B C C) by applying (th_6_5 C B ) .
 (* We are using: (A <> B) and (C <> B) *)
 assert (cong_angle A B C A B C) by applying (th_11_6 A B C ) .
 (* We are using: (A <> B) and (C <> B) and (C <> B) and (bet A C C) and (out B C C) *)
 assert (point_in_angle C A B C) by applying (ax_11_23_2 A B C C C ) .
 (* We are using: (point_in_angle C A B C) and (cong_angle A B C A B C) *)
 assert (le_angle A B C A B C) by applying (ax_11_27_2 C A B C A B C ) .
 solve [firstorder].
Qed.

Theorem th_11_44_1 : forall (A:point) (B:point) (C:point), (not_col A B C /\ cong A B A C) -> cong_angle A C B A B C.
Proof.
 intros.
 assert (col A A B) by applying (th_4_12 A B ) .
 assert (col A A C) by applying (th_4_12 A C ) .
 assert (col B B A) by applying (th_4_12 B A ) .
 (* We are using: (col A A B) *)
 assert (col A B A /\ col B A A /\ col B A A /\ col A A B /\ col A B A) by applying (th_4_11 A A B ) .
 (* We are using: (col A A C) *)
 assert (col A C A /\ col C A A /\ col C A A /\ col A A C /\ col A C A) by applying (th_4_11 A A C ) .
 (* We are using: (col B B A) *)
 assert (col B A B /\ col A B B /\ col A B B /\ col B B A /\ col B A B) by applying (th_4_11 B B A ) .
 (* We are using: (cong A B A C) *)
 assert (cong A B C A) by applying (th_2_5 A B A C ) .
 (* We are using: (cong A B C A) *)
 assert (cong C A A B) by applying (th_2_2 A B C A ) .
 (* We are using: (cong C A A B) *)
 assert (cong C A B A) by applying (th_2_5 C A A B ) .
 assert (cong B C C B) by applying (ax_1 B C ) .
 (* We are using: (cong B C C B) *)
 assert (cong C B B C) by applying (th_2_2 B C C B ) .
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
 by cases on (A = B \/ A <> B).
 (* Case : A = B *)
 (* We are using: (col A A C) and (A = B) *)
 assert (col A B C)  by (intuition;repeat subst; intuition).
 (* We are using: (not_col A B C) and (col A B C) *)
 assert (False) by applying (ax_false_col A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : A <> B *)
 (* We are using: (A <> B) *)
 assert (out B A A) by applying (th_6_5 A B ) .
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
 by cases on (A = C \/ A <> C).
 (* Case : A = C *)
 (* We are using: (col A B A) and (A = C) *)
 assert (col A B C)  by (intuition;repeat subst; intuition).
 (* We are using: (not_col A B C) and (col A B C) *)
 assert (False) by applying (ax_false_col A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : A <> C *)
 (* We are using: (A <> C) *)
 assert (out C A A) by applying (th_6_5 A C ) .
 assert (B = C \/ B <> C) by applying (ax_g1 B C ) .
 by cases on (B = C \/ B <> C).
 (* Case : B = C *)
 (* We are using: (col A B B) and (B = C) *)
 assert (col A B C)  by (intuition;repeat subst; intuition).
 (* We are using: (not_col A B C) and (col A B C) *)
 assert (False) by applying (ax_false_col A B C ) .
 contradict.
 (* end of the case. *)
 (* Case : B <> C *)
 (* We are using: (B <> C) *)
 assert (out C B B) by applying (th_6_5 B C ) .
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (C <> B) *)
 assert (out B C C) by applying (th_6_5 C B ) .
 (* We are using: (B <> C) *)
 assert (C <> B)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> C) and (B <> C) and (A <> B) and (C <> B) and (out C A A) and (out C B B) and (out B A A) and (out B C C) and (cong C A B A) and (cong C B B C) and (cong A B A C) *)
 assert (cong_angle A C B A B C) by applying (th_11_4_2 A C B A B C A B A C ) .
 solve [firstorder].
 (* end of the case. *)
 (* end of the case. *)
 (* end of the case. *)
Qed.

(* Chapter : Parallelism (Euclidean Sense) *)

Theorem th_12_5_1 : forall (A:point) (B:point) (C:point) (D:point), parallel A B C D -> parallel C D A B.
Proof.
Admitted.

Theorem th_12_5_2 : forall (A:point) (B:point) (C:point) (D:point), parallel_broad A B C D -> parallel_broad C D A B.
Proof.
Admitted.

Theorem th_12_6 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (parallel A B C D /\ point_on_line E C D /\ point_on_line F C D) -> one_side E F A B.
Proof.
Admitted.

Theorem th_12_9 : forall (A:point) (B:point) (E:point) (F:point) (C:point) (D:point), (perp A B E F /\ perp C D E F) -> parallel_broad A B C D.
Proof.
Admitted.

Theorem th_12_10 : forall (A:point) (B:point) (C:point), A <> B -> exists D:point, exists E:point, (D <> E /\ parallel_broad A B D E /\ point_on_line C D E).
Proof.
Admitted.

Theorem th_12_11 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point), (A <> B /\ not_point_on_line C A B /\ parallel_broad A B D E /\ parallel_broad A B F G /\ point_on_line C D E /\ point_on_line C F G) -> same_lines D E F G.
Proof.
Admitted.

Theorem th_12_15 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (parallel_broad A B C D /\ parallel_broad C D E F) -> parallel_broad A B E F.
Proof.
Admitted.

Theorem th_12_16 : forall (A:point) (B:point) (C:point) (D:point) (G:point) (E:point) (F:point), (parallel_broad A B C D /\ inter G E F A B) -> exists I:point, inter I E F C D.
Proof.
Admitted.

Theorem th_12_17 : forall (E:point) (A:point) (C:point) (B:point) (D:point), (is_midpoint E A C /\ is_midpoint E B D /\ A <> B) -> parallel_broad A B C D.
Proof.
Admitted.

Theorem th_12_18 : forall (A:point) (B:point) (C:point) (D:point) (E:point), (cong A B C D /\ cong B C D A /\ not_col A B C /\ B <> D /\ col A E C /\ col B E D) -> (parallel_broad A B C D /\ parallel_broad B C D A /\ two_sides B D A C /\ two_sides A C B D).
Proof.
Admitted.

Theorem th_12_19 : forall (A:point) (B:point) (C:point) (D:point), (not_col A B C /\ parallel_broad A B C D /\ parallel_broad B C D A) -> (cong A B C D /\ cong B C D A /\ two_sides B D A C /\ two_sides A C B D).
Proof.
Admitted.

Theorem th_12_20 : forall (A:point) (B:point) (C:point) (D:point), (parallel_broad A B C D /\ cong A B C D /\ two_sides B D A C) -> (parallel_broad B C D A /\ cong B C D A /\ two_sides A C B D).
Proof.
Admitted.

Theorem th_12_21_1 : forall (B:point) (D:point) (A:point) (C:point), (two_sides B D A C /\ parallel_broad A B C D) -> cong_angle B A C D C A.
Proof.
Admitted.

Theorem th_12_21_2 : forall (B:point) (D:point) (A:point) (C:point), (two_sides B D A C /\ cong_angle B A C D C A) -> parallel_broad A B C D.
Proof.
Admitted.

Theorem th_12_22_1 : forall (E:point) (A:point) (C:point) (B:point) (D:point), (out E A C /\ one_side B D E A /\ parallel_broad A B C D) -> cong_angle B A E D C E.
Proof.
Admitted.

Theorem th_12_22_2 : forall (E:point) (A:point) (C:point) (B:point) (D:point), (out E A C /\ one_side B D E A /\ cong_angle B A E D C E) -> parallel_broad A B C D.
Proof.
Admitted.

Theorem th_12_23 : forall (A:point) (B:point) (C:point), not_col A B C -> exists D:point, exists E:point, (two_sides B D A C /\ two_sides C E A B /\ bet D A E /\ cong_angle A B C B A E /\ cong_angle A C B C A D).
Proof.
Admitted.

Theorem th_12_4 : forall (A:point) (B:point), A <> B -> parallel_broad A B A B.
Proof.
 intros.
 (* We are using: (A <> B) *)
 assert (point_on_line A A B /\ point_on_line B A B /\ same_lines A B B A) by applying (th_6_17 A B ) .
 (* We are using: (A <> B) *)
 assert (B <> A)  by (intuition;repeat subst; intuition).
 (* We are using: (A <> B) and (B <> A) and (point_on_line B A B) *)
 assert (same_lines A B A B) by applying (th_6_16 A B B ) .
 (* We are using: (A <> B) and (A <> B) and (same_lines A B A B) *)
 assert (parallel_broad A B A B) by applying (ax_12_3_3 A B A B ) .
 solve [firstorder].
Qed.

