<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:saxon="http://icl.com/saxon"
xsl:extension-element-prefixes="saxon">

<xsl:strip-space elements="*" />

<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>

<xsl:template match="/">
  <xsl:for-each select="main">
    <xsl:apply-templates select="frontpage"/>
    <xsl:text>
Ltac hyp_of_type t :=
 match goal with
| H1:t |- _ => H1
  end.

Tactic Notation "by" "cases" "on" constr(t) :=
  let H := hyp_of_type t in decompose [or] H; clear H.

Ltac applying l := apply l;repeat split;repeat subst;intuition.
Ltac contradict := solve [intuition].
Ltac decompAnd H :=try (progress (decompose [and] H);clear H).&#xA;
</xsl:text>
        <xsl:apply-templates select="theory"/>
	<xsl:apply-templates select="chapter"/>
    </xsl:for-each>
</xsl:template>

<xsl:template match="chapter">
  <xsl:text>(* Chapter : </xsl:text>
  <xsl:value-of select="@name"/>
  <xsl:text> *)&#xa;&#xa;</xsl:text>
  <xsl:apply-templates select="conjecture"/>
  <xsl:apply-templates select="theorem"/>
</xsl:template>

<xsl:template match="frontpage">
  <xsl:text>(*&#xa;</xsl:text>
  <xsl:apply-templates />   
  <xsl:text> *)&#xa;</xsl:text>
</xsl:template>

<xsl:template match="title">    
     <xsl:text>Title: </xsl:text>
     <xsl:apply-templates />   
     <xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="authors">    
     <xsl:text>Authors: </xsl:text>
     <xsl:for-each select ="name">
       <xsl:apply-templates select = "."/>
       <xsl:if test = "position()!=last()">
	 <xsl:text> and </xsl:text>
       </xsl:if>
     </xsl:for-each>
     <xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="formalizedby">    
     <xsl:text>Formalized by: </xsl:text>
     <xsl:for-each select ="name">
       <xsl:apply-templates select = "."/>
       <xsl:if test = "position()!=last()">
	 <xsl:text> and </xsl:text>
       </xsl:if>
     </xsl:for-each>
     <xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="provedby">    
     <xsl:text>Proved by: </xsl:text>
     <xsl:for-each select ="name">
       <xsl:apply-templates select = "."/>
       <xsl:if test = "position()!=last()">
	 <xsl:text> and </xsl:text>
       </xsl:if>
     </xsl:for-each>
     <xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="date">    
     <xsl:text>Date: </xsl:text>
     <xsl:apply-templates />   
     <xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="theory">
  <xsl:apply-templates select="signature" />
  <xsl:apply-templates select="axiom" />
  <xsl:text>&#xa;</xsl:text>
</xsl:template>

<xsl:template match="signature">
  <xsl:for-each select="type">
    <xsl:text>Parameter </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text> : Type.&#xA;</xsl:text>
  </xsl:for-each>
  <xsl:text>&#xA;</xsl:text>
  <xsl:apply-templates select="relation_symbol" />
  <xsl:text>&#xA;</xsl:text>
</xsl:template>

<xsl:template match="relation_symbol">
  <xsl:text>Parameter </xsl:text>
  <xsl:value-of select="@name"/>
  <xsl:text> : </xsl:text>
  <xsl:for-each select="type">
    <xsl:value-of select="."/>
    <xsl:text> -> </xsl:text>
  </xsl:for-each>
  <xsl:text>Prop.&#xA;</xsl:text>
</xsl:template>

<xsl:template match="function_symbol">
  <xsl:text>Parameter </xsl:text>
  <xsl:value-of select="name"/>
  <xsl:text> :</xsl:text>
  <xsl:for-each select="type">
    <xsl:value-of select="."/>
    <xsl:if test = "position()!=last()">
      <xsl:text> -> </xsl:text>
    </xsl:if>
  </xsl:for-each>
  <xsl:text>.&#xA;</xsl:text>
</xsl:template>

<xsl:template match="axiom">
  <xsl:text>Axiom </xsl:text>
  <xsl:value-of select="@name"/>
  <xsl:text> : </xsl:text>
  <xsl:apply-templates select="cl_formula" />
  <xsl:text>.&#xA;</xsl:text>
</xsl:template>

<xsl:template match="conjecture">
  <xsl:text>Theorem </xsl:text>
  <xsl:apply-templates select="name" />
  <xsl:text> : </xsl:text>
  <xsl:apply-templates select="cl_formula" />
  <xsl:text>.&#xA;Proof.&#xA;</xsl:text>
  <xsl:text>Admitted.&#xA;&#xA;</xsl:text>
</xsl:template>

<xsl:template match="theorem">
  <xsl:for-each select = "proof">
    <xsl:text>Theorem </xsl:text>
    <xsl:value-of select="../theorem_name" />
    <xsl:if test="position()>1">
      <xsl:text>_proof_</xsl:text>
      <xsl:value-of select="position()"/> 
    </xsl:if> 
    <xsl:text> : </xsl:text>
    <xsl:apply-templates select="../cl_formula" />
    <xsl:text>.&#xA;</xsl:text>
    <xsl:text>Proof.&#xA;</xsl:text>
    <xsl:text> intros.&#xA;</xsl:text>
    <xsl:apply-templates select="."/>
    <xsl:text>Qed.&#xA;&#xA;</xsl:text>
  </xsl:for-each>
</xsl:template>

<xsl:template match="atom">
  <xsl:if test="@type = 'general'">
    <xsl:value-of select="relation_symbol/@name"/>
    <xsl:for-each select="parameter">
      <xsl:text> </xsl:text>
      	<xsl:value-of select="."/>
    </xsl:for-each>
  </xsl:if>
 
  <xsl:if test="@type = 'equal'">
    <xsl:value-of select="parameter[1]"/>
    <xsl:text> = </xsl:text> 
    <xsl:value-of select="parameter[2]"/>
  </xsl:if>

  <xsl:if test="@type = 'not_equal'">
    <xsl:value-of select="parameter[1]"/>
    <xsl:text> &lt;> </xsl:text>
    <xsl:value-of select="parameter[2]"/>
  </xsl:if>
</xsl:template>

<xsl:template match="cl_formula">
  <xsl:if test="variables">  
  <xsl:text>forall </xsl:text>
  <xsl:for-each  select="variables/variable">
    <xsl:text>(</xsl:text>
    <xsl:if test= "@name = 'H'">
      <xsl:text>HH</xsl:text>
    </xsl:if>
    <xsl:if test= "@name != 'H'">
      <xsl:value-of select="@name"/>
    </xsl:if>
    <xsl:text>:</xsl:text>
    <xsl:value-of select="@type"/>
    <xsl:text>)</xsl:text>
    <xsl:if test="position()!=last()">
      <xsl:text> </xsl:text>
    </xsl:if>
  </xsl:for-each>
  <xsl:text>, </xsl:text>
  </xsl:if>

  <xsl:apply-templates  select="from"/>    
  <xsl:if test="from">  
    <xsl:text> -> </xsl:text> 
  </xsl:if>
  <xsl:apply-templates  select="have"/> 
</xsl:template>

<xsl:template match="ex_variables">
     <xsl:apply-templates />         
</xsl:template>

<xsl:template match="ex_variable">
     <xsl:text>exists </xsl:text>
     <xsl:if test="@name = 'H'">
       <xsl:text>HH</xsl:text>
     </xsl:if>
     <xsl:if test="@name != 'H'">
       <xsl:value-of select="@name"/>
     </xsl:if>
     <xsl:text>:</xsl:text>
     <xsl:value-of select="@type"/>
     <xsl:text>, </xsl:text>
</xsl:template>

<xsl:template match="obtain_witness">
  <xsl:text> let Hnew := fresh in </xsl:text>
  <xsl:text> assert ( Hnew :</xsl:text>
  <xsl:for-each select="constant">
    <xsl:text> exists </xsl:text>
    <xsl:value-of select="@name"/> 
    <xsl:if test="position()!=last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="from">
    <xsl:apply-templates />         
</xsl:template>


<xsl:template match="dnf">
    <xsl:for-each select="conj">
      <xsl:apply-templates select="."/>
      <xsl:if test="position()!=last()">
	<xsl:text> \/ </xsl:text>
      </xsl:if>
      </xsl:for-each>
</xsl:template>

<xsl:template match="conj">
  <xsl:apply-templates select = "ex_variables"/> 
  <xsl:if test="count(atom)!=1"> 
    <xsl:text>(</xsl:text>
  </xsl:if> 
  <xsl:if test="count(atom)=0">
     <xsl:text>False</xsl:text>
  </xsl:if>
  <xsl:for-each select="atom">
    <xsl:apply-templates select="."/>
    <xsl:if test="position()!=last()">
      <xsl:text> /\ </xsl:text>
    </xsl:if>
  </xsl:for-each>
  <xsl:if test="count(atom)!=1"> 
    <xsl:text>)</xsl:text>
  </xsl:if> 
</xsl:template>

<xsl:template match="proof_closing">
   <xsl:if test="goal_reached_thesis">
     <xsl:if test="not(case_split)">
       <xsl:text> solve [firstorder].&#xA;</xsl:text> 
     </xsl:if>
   </xsl:if> 
   <xsl:if test="goal_reached_contradiction">
     <xsl:if test="not(modus_ponens/@axiom_name) and not(have) and not(case_split)">
       <xsl:text> contradict.&#xA;</xsl:text>
     </xsl:if>
   </xsl:if>
   <xsl:if test="case_split">
     <xsl:apply-templates />   
   </xsl:if>
</xsl:template>


<xsl:template match="proof_step">
      <xsl:apply-templates select="modus_ponens"/>  
      <xsl:apply-templates select="case_split"/>

  <xsl:if test="goal/@reached = 'thesis'">
    <xsl:if test="not(case_split) and not(modus_ponens/from)">
       <xsl:text> assumption.&#xA;</xsl:text> 
     </xsl:if>
     <xsl:if test="not(case_split) and modus_ponens/from">
       <xsl:text> solve [firstorder].&#xA;</xsl:text> 
     </xsl:if>
  </xsl:if>
  
  <!-- if "have" does not exists and there is not an "axiom_name"
       then we have a contradiction, for example A=B & A!=B -->

    <xsl:if test="goal/@reached = 'false'">
	 <xsl:text> (*  goal/@reached = 'false' *)</xsl:text> 
	 <xsl:if test="not(modus_ponens/@axiom_name) and not(have) and not(case_split)">
	   <xsl:text> contradict.&#xA;</xsl:text>
	 </xsl:if>
	 <xsl:if test="not(have)">
	   <xsl:text> (* not have *)&#xA;</xsl:text>
	 </xsl:if>
	 <xsl:if test="modus_ponens/@axiom_name">
	   <xsl:text> (* axiom name *)&#xA;</xsl:text>
	 </xsl:if>
    </xsl:if>
</xsl:template>


<xsl:template match="modus_ponens">
  
  <xsl:if test="from">
    <xsl:text> (* We are using: </xsl:text>
    <xsl:for-each select="from/conj/atom">
      <xsl:text>(</xsl:text>
      <xsl:apply-templates select="."/>
      <xsl:text>)</xsl:text>
      <xsl:if test="position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:text> *)&#xA;</xsl:text>
  </xsl:if>


  <xsl:apply-templates select="have/obtain_witness"/>

  <xsl:if test = "have/obtain_witness">
    <xsl:text>, </xsl:text>
  </xsl:if>
  
  <xsl:if test = "not(have/obtain_witness) and have">
    <xsl:text> assert </xsl:text>
  </xsl:if>

  
<!-- between different conjunctions brackets are needed if there is more 
     than one conjunctions-->
  <xsl:if test = "have"> 
    <xsl:text>(</xsl:text>
    <xsl:if test = "count(have/dnf/conj/atom)=0">
      <xsl:text>False</xsl:text>
    </xsl:if>
    <xsl:for-each select="have/dnf/conj">
      <xsl:for-each select="atom">
	<xsl:apply-templates select="."/>
	<xsl:if test="position()!=last()">
	  <xsl:text> /\ </xsl:text>
	</xsl:if>
      </xsl:for-each>     
      <xsl:if test= "position()!= last()">
	<xsl:text> \/ </xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:text>)</xsl:text>
    <xsl:if test = "have/obtain_witness"> 
      <xsl:text>)</xsl:text>
    </xsl:if>
  </xsl:if>
  
  <!-- if there is a conclusion ("have") and "axiom_name"
       we are instantiating the axiom -->
  <xsl:if test = "have">
    <xsl:if test = "have and @axiom_name">
      <xsl:text> by applying (</xsl:text>
      <xsl:value-of select="@axiom_name"/>
      <xsl:text> </xsl:text>
      <xsl:for-each select="constants/constant">
	<xsl:value-of select="@name"/>
	<xsl:text> </xsl:text>
      </xsl:for-each>
      <xsl:text>) </xsl:text> 
    </xsl:if>
    
    <xsl:choose>
      <xsl:when test="have/obtain_witness">
	<xsl:text>;</xsl:text>
      </xsl:when>
      <xsl:when test="not(@axiom_name)">
	<xsl:text> </xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>.&#xA;</xsl:text>
      </xsl:otherwise> 
    </xsl:choose>

    <xsl:if test = "have/obtain_witness">  
      <xsl:text>destruct Hnew as </xsl:text>
      <xsl:for-each select="have/obtain_witness/constant">
	<xsl:text>[</xsl:text>
	<xsl:value-of select="@name"/>
      </xsl:for-each>
      <xsl:for-each select="have/obtain_witness/constant">
	<xsl:if test= "position()= last()">
	  <xsl:text> Hnew</xsl:text>
	</xsl:if>
	<xsl:text>]</xsl:text>
      </xsl:for-each>
      <xsl:text>;decompAnd Hnew.&#xA;</xsl:text>
    </xsl:if>

    <!-- if there is a conclusion ("have"), but there is not an 
         "axiom_name" -->
    <!-- (ArgoCLP step - eqcontradiction) -->
    <xsl:if test = "not(@axiom_name)">
      <xsl:text> by (intuition;repeat subst; intuition).&#xA;</xsl:text> 
    </xsl:if>
  </xsl:if>

  <!-- if there is not a conclusion "have", but has "axiom_name"
       than there is a contradiction from application of that axiom -->
  <xsl:if test = "not(have) and @axiom_name">
    <xsl:text> repeat subst;intuition;exfalso;eapply </xsl:text>
    <xsl:value-of select="@axiom_name"/>
    <xsl:text>; eauto.&#xA; </xsl:text> 
  </xsl:if>
</xsl:template>

<xsl:template match="have">
  <xsl:for-each select="variables/variable">
    <xsl:text>exists </xsl:text>
    <xsl:value-of select="@name"/> 
    <xsl:text>:</xsl:text>
    <xsl:value-of select="@type"/>
    <xsl:text>, </xsl:text>
  </xsl:for-each>
  <xsl:apply-templates select="dnf"/>
</xsl:template>

<xsl:template match="case_split">
    <xsl:text> by cases on (</xsl:text>
    <xsl:apply-templates  select="disjunction_elimination/dnf"/>
    <xsl:text>).&#xA;</xsl:text>
    <xsl:apply-templates />         
</xsl:template>

<xsl:template match="of_variables">
  <xsl:for-each select="variable">
    <xsl:if test="@name != 'H'">
      <xsl:value-of select="@name"/>
    </xsl:if>
    <xsl:if test="@name = 'H'">
      <xsl:text>HH</xsl:text>
    </xsl:if>
    <xsl:if test="position()!=last()">
      <xsl:text> </xsl:text>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="assumption">
    <xsl:text> (* Case : </xsl:text>
    <xsl:apply-templates  select="conj"/>
    <xsl:text> *)&#xA;</xsl:text>
    <xsl:apply-templates select="proof"/> 
    <xsl:text> (* end of the case. *)&#xA;</xsl:text>
   
</xsl:template>

<xsl:template match="disjunction_elimination">
</xsl:template>
</xsl:stylesheet>
